/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.core.net.socket;

import de.kaleidox.crystalshard.core.net.socket.DiscordEventDispatch;
import de.kaleidox.crystalshard.core.net.socket.WebSocketException;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.util.helpers.JsonHelper;
import java.nio.charset.Charset;
import java.util.concurrent.CompletableFuture;
import okhttp3.Response;
import okhttp3.WebSocket;
import okio.ByteString;

public class WebSocketListener
extends okhttp3.WebSocketListener {
    private static final Logger logger = new Logger(WebSocketListener.class);
    private final Discord discord;
    private StringBuilder onTextBuilder = new StringBuilder();
    private CompletableFuture<String> onTextFuture = new CompletableFuture();

    public WebSocketListener(Discord discordObject) {
        this.discord = discordObject;
    }

    public void onOpen(WebSocket webSocket, Response response) {
        super.onOpen(webSocket, response);
        logger.trace((Object)("WebSocket opened: " + webSocket));
    }

    public void onMessage(WebSocket webSocket, String text) {
        super.onMessage(webSocket, text);
        logger.exception((Throwable)new WebSocketException(), "WebSocket error");
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        super.onMessage(webSocket, bytes);
        DiscordEventDispatch.handle(this.discord, JsonHelper.parse((String)bytes.string(Charset.forName("UTF-8"))));
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        super.onClosing(webSocket, code, reason);
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        super.onClosed(webSocket, code, reason);
        logger.trace((Object)("WebSocket closed with code '" + code + "' and reason: " + reason));
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        super.onFailure(webSocket, t, response);
    }
}

