/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.core.net.socket;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.kaleidox.crystalshard.core.concurrent.ThreadPoolImpl;
import de.kaleidox.crystalshard.core.net.request.DiscordRequestImpl;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.endpoint.DiscordEndpoint;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.core.net.socket.OpCode;
import de.kaleidox.crystalshard.core.net.socket.Payload;
import de.kaleidox.crystalshard.core.net.socket.WebSocketClient;
import de.kaleidox.crystalshard.core.net.socket.WebSocketListener;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.util.helpers.JsonHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;

public class WebSocketClientImpl
implements WebSocketClient {
    private static final Logger logger = new Logger(WebSocketClient.class);
    private static final OkHttpClient CLIENT = new OkHttpClient();
    private final Discord discord;
    private final WebSocket webSocket;
    private final AtomicLong lastPacket = new AtomicLong(0L);
    private final AtomicLong lastHeartbeat = new AtomicLong(0L);
    private final ThreadPoolImpl threadPool;

    public WebSocketClientImpl(Discord discordObject) {
        logger.warn((Object)"The Java 8 WebSocket implementation has not been tested yet.");
        URL gatewayUrl = (URL)((CompletableFuture)((CompletableFuture)new DiscordRequestImpl(discordObject).setMethod(HttpMethod.GET).setUri((RequestURI)DiscordEndpoint.GATEWAY.createUri(new Object[0])).executeAs(node -> node.get("url").asText()).exceptionally(throwable -> {
            logger.exception(throwable);
            return "wss://gateway.discord.gg";
        })).thenApply(spec -> {
            try {
                return new URL((String)spec);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        })).join();
        Request request = new Request.Builder().url(gatewayUrl).header("User-Agent", "DiscordBot (http://crystalshard.kaleidox.de, 0.1)").header("Content-Type", "application/json").header("Authorization", discordObject.getPrefixedToken()).build();
        this.threadPool = new ThreadPoolImpl(discordObject, 1, "WebSocketClient");
        this.discord = discordObject;
        this.webSocket = CLIENT.newWebSocket(request, (okhttp3.WebSocketListener)new WebSocketListener(discordObject));
        this.identification();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.webSocket.close(1000, "Shutting down!")));
    }

    private void identification() {
        ObjectNode data = JsonHelper.objectNode((Object[])new Object[]{"properties", JsonHelper.objectNode((Object[])new Object[]{"$os", JsonHelper.nodeOf((Object)System.getProperty("os.name")), "$browser", JsonHelper.nodeOf((Object)"CrystalShard v0.9"), "$device", JsonHelper.nodeOf((Object)"CrystalShard v0.9")})});
        this.sendPayload(Payload.create((OpCode)OpCode.IDENTIFY, (JsonNode)data)).exceptionally(arg_0 -> ((Logger)logger).exception(arg_0));
    }

    public CompletableFuture<Void> sendPayload(Payload payload) {
        assert (payload != null) : "Payload must not be null!";
        this.threadPool.execute(() -> {
            while (this.lastPacket.get() > System.currentTimeMillis() - 600L) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    logger.exception((Throwable)e);
                }
            }
            if (this.lastPacket.get() <= System.currentTimeMillis() - 500L) {
                logger.trace((Object)("Sending Packet with OpCode " + payload.getCode() + " and body: " + payload.getBody()));
                boolean attachedFuture = false;
                for (Payload that : payload.split()) {
                    boolean last = that.isLast();
                    that.addNode("token", JsonHelper.nodeOf((Object)this.discord.getPrefixedToken()));
                    that.addNode("large_threshold", JsonHelper.nodeOf((Object)250));
                    that.addNode("shard", (JsonNode)JsonHelper.arrayNode((Object[])new Object[]{this.discord.getShardId(), this.discord.getShards()}));
                    String nodeAsText = that.getSendableNode().toString();
                    this.webSocket.send(nodeAsText);
                    if (last) {
                        this.lastPacket.set(System.currentTimeMillis());
                    }
                    if (attachedFuture) continue;
                    attachedFuture = true;
                }
            }
        }, new String[0]);
        return new CompletableFuture<Void>();
    }

    public void heartbeat() {
        Payload payload = Payload.create((OpCode)OpCode.HEARTBEAT, (JsonNode)JsonHelper.nodeOf(null));
        this.sendPayload(payload);
        this.lastHeartbeat.set(System.currentTimeMillis());
    }

    public boolean respondToHeartbeat() {
        return this.lastHeartbeat.get() < System.currentTimeMillis() - 4000L;
    }
}

