/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.core.net.request.ratelimit;

import de.kaleidox.crystalshard.core.concurrent.ThreadPoolImpl;
import de.kaleidox.crystalshard.core.net.request.WebRequest;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.core.net.request.ratelimit.BucketManager;
import de.kaleidox.crystalshard.core.net.request.ratelimiting.Ratelimiter;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Headers;

public class RatelimiterImpl
implements Ratelimiter {
    private static final Logger logger = new Logger(RatelimiterImpl.class);
    private final Discord discord;
    private final BucketManager bucketManager;
    private final ConcurrentHashMap<RequestURI, AtomicInteger> remainingMap;
    private final ConcurrentHashMap<RequestURI, AtomicInteger> limitMap;
    private final ConcurrentHashMap<RequestURI, AtomicReference<Instant>> resetMap;
    final ThreadPoolImpl executePool;

    public RatelimiterImpl(Discord discord) {
        this.discord = discord;
        this.executePool = new ThreadPoolImpl(discord, -1, "Ratelimit Execution");
        this.bucketManager = new BucketManager(discord, this);
        this.remainingMap = new ConcurrentHashMap();
        this.limitMap = new ConcurrentHashMap();
        this.resetMap = new ConcurrentHashMap();
    }

    public AtomicInteger getRemaining(RequestURI discordRequestURI) {
        this.assureAtomicValues(discordRequestURI);
        AtomicInteger remaining = this.remainingMap.get(discordRequestURI);
        AtomicReference<Instant> reset = this.resetMap.get(discordRequestURI);
        if (remaining.get() == 0 && reset.get().isAfter(Instant.now())) {
            remaining.incrementAndGet();
        }
        return remaining;
    }

    private void assureAtomicValues(RequestURI discordRequestURI) {
        this.remainingMap.putIfAbsent(discordRequestURI, new AtomicInteger(1));
        this.limitMap.putIfAbsent(discordRequestURI, new AtomicInteger(1));
        this.resetMap.putIfAbsent(discordRequestURI, new AtomicReference<Instant>(Instant.now().minusSeconds(1L)));
    }

    public AtomicInteger getLimit(RequestURI discordRequestURI) {
        this.assureAtomicValues(discordRequestURI);
        return this.limitMap.get(discordRequestURI);
    }

    public AtomicReference<Instant> getReset(RequestURI discordRequestURI) {
        this.assureAtomicValues(discordRequestURI);
        return this.resetMap.get(discordRequestURI);
    }

    public <T> void schedule(WebRequest<T> request, CompletableFuture<Headers> headersFuture, Runnable requestTask) {
        RequestURI requestUri = request.getUri();
        headersFuture.thenAcceptAsync(headers -> {
            try {
                Optional.ofNullable(headers.get("X-RateLimit-Remaining")).map(Integer::parseInt).ifPresent(readyAt -> this.remainingMap.get(requestUri).set((int)readyAt));
                Optional.ofNullable(headers.get("X-RateLimit-Limit")).map(Integer::parseInt).ifPresent(limit -> this.limitMap.get(requestUri).set((int)limit));
                Optional.ofNullable(headers.get("X-RateLimit-Reset")).map(Long::parseLong).map(Instant::ofEpochMilli).ifPresent(retryAt -> this.resetMap.get(requestUri).set((Instant)retryAt));
            }
            catch (NullPointerException e) {
                logger.exception((Throwable)e, "NPE on Ratelimit header evaluation.");
            }
        });
        this.bucketManager.schedule(requestUri, requestTask);
    }
}

