/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.core.net.request;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.WebRequest;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.util.helpers.JsonHelper;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class WebRequestImpl<T>
implements WebRequest<T> {
    protected static final Logger logger = new Logger(WebRequest.class);
    protected static final OkHttpClient CLIENT = new OkHttpClient();
    protected final Request.Builder requestBuilder;
    protected final CompletableFuture<String> future;
    protected RequestURI uri;
    protected HttpMethod method;
    protected JsonNode node;

    public WebRequestImpl() {
        logger.warn((Object)"The Java 8 WebRequest implementation has not been tested yet.");
        this.requestBuilder = new Request.Builder();
        this.future = new CompletableFuture();
    }

    public WebRequest<T> addHeader(String name, String value) {
        this.requestBuilder.addHeader(name, value);
        return this;
    }

    public RequestURI getUri() {
        return this.uri;
    }

    public WebRequest<T> setUri(RequestURI uri) {
        this.uri = uri;
        return this;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public WebRequest<T> setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public JsonNode getNode() {
        return this.node;
    }

    public WebRequest<T> setNode(JsonNode node) {
        this.node = node;
        return this;
    }

    public WebRequest<T> setNode(Object ... data) {
        this.node = JsonHelper.objectNode((Object[])data);
        return this;
    }

    public CompletableFuture<String> execute() throws RuntimeException {
        Objects.requireNonNull(this.uri, "URI is not set!");
        Objects.requireNonNull(this.method, "Method is not set!");
        Objects.requireNonNull(this.node, "Node is not set!");
        try {
            Request request = this.requestBuilder.url(this.uri.getURI().toString()).method(this.method.getDescriptor(), RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)this.node.toString())).build();
            Response response = CLIENT.newCall(request).execute();
            assert (response.body() != null) : "Unexcpected NullPointer in WebRequestImpl";
            this.future.complete(response.body().string());
            return this.future;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

