/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.core.concurrent;

import de.kaleidox.crystalshard.core.concurrent.ThreadPool;
import de.kaleidox.crystalshard.core.concurrent.Worker;
import de.kaleidox.crystalshard.core.net.socket.WebSocketClientImpl;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicMarkableReference;

public class ThreadPoolImpl
implements ThreadPool {
    private static final Logger logger = new Logger(ThreadPoolImpl.class);
    private final ConcurrentHashMap<Worker, AtomicBoolean> threads;
    private final Discord discord;
    private final int maxSize;
    private final LinkedBlockingQueue<Task> queue;
    private final AtomicInteger busyThreads = new AtomicInteger(0);
    private final Factory factory;
    private Executor executor;
    private ScheduledExecutorService scheduler;
    private String name;
    private List<Worker> factoriedThreads = new ArrayList<Worker>();

    public ThreadPoolImpl(Discord discord) {
        this(discord, -1, "CrystalShard Main Worker");
        this.executor = new BotOwn(this);
        this.scheduler = Executors.newSingleThreadScheduledExecutor(this.factory);
        this.scheduler.scheduleAtFixedRate(this::cleanupThreads, 30L, 30L, TimeUnit.SECONDS);
    }

    public ThreadPoolImpl(Discord discordObject, int maxSize, String name) {
        this.discord = discordObject;
        this.maxSize = maxSize;
        this.threads = new ConcurrentHashMap();
        this.queue = new LinkedBlockingQueue();
        this.name = name;
        this.factory = new Factory();
        this.execute(() -> logger.deeptrace((Object)("New ThreadPool created: " + name)), new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Runnable task, String ... description) {
        LinkedBlockingQueue<Task> linkedBlockingQueue = this.queue;
        synchronized (linkedBlockingQueue) {
            if ((this.threads.size() < this.maxSize || this.maxSize == -1) && this.busyThreads.get() <= this.queue.size()) {
                this.factory.getOrCreateWorker();
            }
            this.queue.add(new Task(task, description));
            this.queue.notify();
        }
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    public Discord getDiscord() {
        return this.discord;
    }

    public void startHeartbeat(long heartbeat) {
        this.scheduler.scheduleAtFixedRate(() -> ((WebSocketClientImpl)this.discord.getWebSocket()).heartbeat(), heartbeat, heartbeat, TimeUnit.MILLISECONDS);
    }

    void cleanupThreads() {
        this.factoriedThreads.stream().filter(worker -> worker.getState() == Thread.State.TERMINATED).peek(Thread::interrupt).peek(worker -> this.factory.nameCounter.decrementAndGet()).forEach(this.factoriedThreads::remove);
    }

    private static boolean nonFutureTask(Runnable task) {
        return !task.toString().toLowerCase().contains("future");
    }

    private class Task
    implements Runnable {
        private final Runnable runnable;
        private final String[] description;

        Task(Runnable runnable, String ... description) {
            this.runnable = runnable;
            this.description = description;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            catch (Exception e) {
                logger.exception((Throwable)e);
            }
        }

        public boolean hasDescription() {
            return this.description.length != 0;
        }

        public String getDescription() {
            return this.description.length == 0 ? "No task description." : String.join((CharSequence)" ", this.description);
        }
    }

    public class WorkerImpl
    extends Worker {
        private final Discord discord;
        private final AtomicMarkableReference<Task> nextTask;
        private final AtomicBoolean isBusy;
        private final boolean runnableAttachedThread;

        WorkerImpl(Discord discord, int id) {
            super(ThreadPoolImpl.this.name == null ? "Worker Thread #" + id : ThreadPoolImpl.this.name + " Thread" + (ThreadPoolImpl.this.maxSize == 1 ? "" : " #" + id));
            this.nextTask = new AtomicMarkableReference<Object>(null, false);
            this.discord = discord;
            this.isBusy = new AtomicBoolean(false);
            this.runnableAttachedThread = false;
        }

        WorkerImpl(Runnable initTask, Discord discord, int id) {
            super(initTask, ThreadPoolImpl.this.name == null ? "Worker Thread #" + id : ThreadPoolImpl.this.name + " Thread" + (ThreadPoolImpl.this.maxSize == 1 ? "" : " #" + id));
            this.nextTask = new AtomicMarkableReference<Object>(null, false);
            this.discord = discord;
            this.isBusy = new AtomicBoolean(true);
            this.runnableAttachedThread = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (!this.runnableAttachedThread) {
                Task task = null;
                while (true) {
                    LinkedBlockingQueue linkedBlockingQueue = ThreadPoolImpl.this.queue;
                    synchronized (linkedBlockingQueue) {
                        block12: {
                            try {
                                while (ThreadPoolImpl.this.queue.isEmpty() && !this.nextTask.isMarked()) {
                                    try {
                                        ThreadPoolImpl.this.queue.wait();
                                    }
                                    catch (InterruptedException e) {
                                        logger.exception((Throwable)e);
                                    }
                                }
                                Task task2 = task = this.nextTask.isMarked() ? this.nextTask.getReference() : (Task)ThreadPoolImpl.this.queue.poll();
                                assert (task != null);
                                this.busy();
                                task.run();
                                this.unbusy();
                                if (this.nextTask.isMarked()) {
                                    this.nextTask.set(null, false);
                                }
                            }
                            catch (Throwable e) {
                                if ($assertionsDisabled || task != null) break block12;
                                throw new AssertionError();
                            }
                        }
                    }
                }
            }
            super.run();
        }

        private void busy() {
            this.isBusy.set(true);
            ThreadPoolImpl.this.busyThreads.incrementAndGet();
        }

        private void unbusy() {
            this.isBusy.set(false);
            ThreadPoolImpl.this.busyThreads.decrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void attachTask(Task task) {
            LinkedBlockingQueue linkedBlockingQueue = ThreadPoolImpl.this.queue;
            synchronized (linkedBlockingQueue) {
                if (this.isBusy.get()) {
                    ThreadPoolImpl.this.execute(task, new String[0]);
                } else {
                    this.nextTask.set(task, true);
                    ThreadPoolImpl.this.queue.notify();
                }
            }
        }

        public Discord getDiscord() {
            return this.discord;
        }
    }

    public class BotOwn
    implements Executor {
        private final ThreadPoolImpl pool;

        BotOwn(ThreadPoolImpl pool) {
            this.pool = pool;
        }

        @Override
        public void execute(Runnable command) {
            this.pool.execute(command, new String[0]);
        }
    }

    public class Factory
    implements ThreadFactory {
        private final AtomicInteger nameCounter = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            WorkerImpl worker = new WorkerImpl(r, ThreadPoolImpl.this.discord, this.nameCounter.getAndIncrement());
            ThreadPoolImpl.this.factoriedThreads.add(worker);
            return worker;
        }

        public Worker getOrCreateWorker() {
            return ThreadPoolImpl.this.threads.entrySet().stream().filter(entry -> !((AtomicBoolean)entry.getValue()).get()).findFirst().map(Map.Entry::getKey).orElseGet(() -> {
                WorkerImpl worker = new WorkerImpl(ThreadPoolImpl.this.discord, this.nameCounter.getAndIncrement());
                ThreadPoolImpl.this.threads.put(worker, worker.isBusy);
                if (!worker.isAlive()) {
                    worker.start();
                }
                return worker;
            });
        }
    }
}

