/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.core.cache.sub;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.core.CoreInjector;
import de.kaleidox.crystalshard.core.cache.CacheImpl;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.WebRequest;
import de.kaleidox.crystalshard.core.net.request.endpoint.DiscordEndpoint;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.internal.InternalInjector;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.items.channel.Channel;
import de.kaleidox.crystalshard.main.items.channel.ChannelCategory;
import de.kaleidox.crystalshard.main.items.channel.ChannelType;
import de.kaleidox.crystalshard.main.items.channel.GroupChannel;
import de.kaleidox.crystalshard.main.items.channel.PrivateTextChannel;
import de.kaleidox.crystalshard.main.items.channel.ServerTextChannel;
import de.kaleidox.crystalshard.main.items.channel.ServerVoiceChannel;
import de.kaleidox.crystalshard.main.items.server.Server;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ChannelCacheImpl
extends CacheImpl<Channel, Long, Long> {
    private final Discord discordInternal;

    public ChannelCacheImpl(Discord discordInternal) {
        super(Channel.class, param -> ((JsonNode)param[2]).get("id").asLong(), TimeUnit.HOURS.toMillis(12L), Discord.class, Server.class, JsonNode.class);
        this.discordInternal = discordInternal;
    }

    @Override
    @NotNull
    public CompletableFuture<Object[]> requestConstructorParameters(Long requestIdent) {
        WebRequest request = CoreInjector.webRequest((Discord)this.discordInternal);
        return request.setMethod(HttpMethod.GET).setUri((RequestURI)DiscordEndpoint.CHANNEL.createUri(new Object[]{requestIdent})).executeAs(data -> {
            long guildId = data.path("guild_id").asLong(-1L);
            Server server = guildId == -1L ? null : (Server)this.discordInternal.getServerCache().getOrRequest((Object)guildId, (Object)guildId);
            return new Object[]{this.discordInternal, server, data};
        });
    }

    @Override
    @NotNull
    public Channel construct(Object ... param) {
        Discord discord = (Discord)param[0];
        Server server = param[1] == null ? null : (Server)param[1];
        JsonNode data = (JsonNode)param[2];
        switch (ChannelType.getFromId((int)data.get("type").asInt())) {
            case GUILD_TEXT: {
                return (Channel)InternalInjector.newInstance(ServerTextChannel.class, (Object[])new Object[]{discord, server, data});
            }
            case DM: {
                return (Channel)InternalInjector.newInstance(PrivateTextChannel.class, (Object[])new Object[]{discord, data});
            }
            case GUILD_VOICE: {
                return (Channel)InternalInjector.newInstance(ServerVoiceChannel.class, (Object[])new Object[]{discord, server, data});
            }
            case GROUP_DM: {
                return (Channel)InternalInjector.newInstance(GroupChannel.class, (Object[])new Object[]{discord, data});
            }
            case GUILD_CATEGORY: {
                return (Channel)InternalInjector.newInstance(ChannelCategory.class, (Object[])new Object[]{discord, server, data});
            }
        }
        throw new NoSuchElementException("Unknown or no channel Type.");
    }
}

