/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.core.cache;

import de.kaleidox.crystalshard.core.cache.Cache;
import de.kaleidox.crystalshard.core.cache.CacheReference;
import de.kaleidox.crystalshard.core.cache.Cacheable;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.util.helpers.MapHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CacheImpl<T extends Cacheable, I, R>
implements Cache<T, I, R> {
    public static final ConcurrentHashMap<Class<?>, CacheImpl<? extends Cacheable, Object, Object>> cacheInstances;
    private static final Logger logger;
    private static final ScheduledExecutorService scheduledExecutorService;
    private final ConcurrentHashMap<I, CacheReference<T, R>> instances;
    private final Class<? extends T> typeClass;
    private final Function<Object[], I> mapperToIdentifier;
    private final long keepaliveMilis;
    private final Class<?>[] constructorParameter;

    public <Con extends T> CacheImpl(Class<Con> typeClass, Function<Object[], I> mapperToIdentifier, long keepaliveMillis, Class<?> ... defaultConstructorParameter) {
        this.typeClass = typeClass;
        this.mapperToIdentifier = mapperToIdentifier;
        this.keepaliveMilis = keepaliveMillis;
        this.constructorParameter = defaultConstructorParameter;
        this.instances = new ConcurrentHashMap();
        cacheInstances.put(typeClass, this);
    }

    @NotNull
    public abstract CompletableFuture<Object[]> requestConstructorParameters(R var1);

    @NotNull
    public abstract T construct(Object ... var1);

    @Nullable
    public T getOrNull(I identifier) {
        try {
            return this.get(identifier);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public CompletableFuture<T> request(I ident, R requestIdent) throws NoSuchElementException {
        if (!MapHelper.containsKey(this.instances, ident)) {
            throw new NoSuchElementException("Element with identifyer " + ident + " has never been isCached before! Try using method #getOrRequest instead.");
        }
        CacheReference ref = (CacheReference)MapHelper.getEquals(this.instances, ident, null);
        if (ref.isCached()) {
            return CompletableFuture.completedFuture(ref.getReference());
        }
        return CompletableFuture.supplyAsync(() -> this.getOrRequest(ident, (R)(requestIdent == null ? ref.getRecentRequestor() : requestIdent)));
    }

    public T getOrCreate(Object ... params) throws IllegalArgumentException {
        if (!this.matchingParams(params)) {
            throw new IllegalArgumentException("Cannot use parameters " + Arrays.toString(params) + " for creating new instance of " + this.typeClass.toGenericString());
        }
        I ident = this.mapperToIdentifier.apply(params);
        if (MapHelper.containsKey(this.instances, ident)) {
            CacheReference ref = (CacheReference)MapHelper.getEquals(this.instances, ident, null);
            if (ref.isCached()) {
                return ref.getReference();
            }
            Cacheable val = (Cacheable)Objects.requireNonNull(this.construct(params), "Method \"construct\" must not return null!");
            logger.deeptrace((Object)("Constructed new instance with passed parameters " + Arrays.toString(params) + " of type " + this.typeClass.toGenericString()));
            ref.setReference(val);
            return (T)val;
        }
        Cacheable val = (Cacheable)Objects.requireNonNull(this.construct(params), "Method \"construct\" must not return null!");
        logger.deeptrace((Object)("Constructed new instance with passed parameters " + Arrays.toString(params) + " of type " + this.typeClass.toGenericString()));
        CacheReference<Cacheable, Object> ref = new CacheReference<Cacheable, Object>(val, this.keepaliveMilis, null, params);
        this.instances.put(ident, ref);
        return (T)val;
    }

    public T getOrCreate(I ident, Object ... parameters) throws IllegalArgumentException {
        if (MapHelper.containsKey(this.instances, ident)) {
            CacheReference ref = (CacheReference)MapHelper.getEquals(this.instances, ident, null);
            if (ref.isCached()) {
                return ref.getReference();
            }
            if (!this.matchingParams(parameters)) {
                throw new IllegalArgumentException("Cannot use parameters " + Arrays.toString(parameters) + " for creating new instance of " + this.typeClass.toGenericString());
            }
            ref.setReference((Cacheable)Objects.requireNonNull(this.construct(parameters), "Method \"construct\" must not return null!"));
            ref.setRecentParameters(parameters);
            ref.accessed();
            logger.deeptrace((Object)("Constructed new instance with recent parameters " + Arrays.toString(parameters) + " of type " + this.typeClass.toGenericString()));
            return ref.getReference();
        }
        if (!this.matchingParams(parameters)) {
            throw new IllegalArgumentException("Cannot use parameters " + Arrays.toString(parameters) + " for creating new instance of " + this.typeClass.toGenericString());
        }
        Cacheable val = (Cacheable)Objects.requireNonNull(this.construct(parameters), "Method \"construct\" must not return null!");
        logger.deeptrace((Object)("Constructed new instance with recent parameters " + Arrays.toString(parameters) + " of type " + this.typeClass.toGenericString()));
        CacheReference<Cacheable, Object> ref = new CacheReference<Cacheable, Object>(val, this.keepaliveMilis, null, parameters);
        this.instances.put(ident, ref);
        return (T)val;
    }

    public T getOrRequest(I ident, R requestIdent) throws NoSuchElementException, IllegalArgumentException {
        Cacheable val;
        if (MapHelper.containsKey(this.instances, ident)) {
            CacheReference ref = (CacheReference)MapHelper.getEquals(this.instances, ident, null);
            if (ref.isCached()) {
                return ref.getReference();
            }
            Object[] recentParameters = ref.getRecentParameters();
            if (recentParameters == null) {
                throw new NoSuchElementException("Reference is not cached and cant be created; no recent parameters set.");
            }
            if (!this.matchingParams(recentParameters)) {
                throw new IllegalArgumentException("Cannot use parameters " + Arrays.toString(recentParameters) + " for creating new instance of " + this.typeClass.toGenericString());
            }
            val = (Cacheable)Objects.requireNonNull(this.construct(recentParameters), "Method \"construct\" must not return null!");
            logger.deeptrace((Object)("Constructed new instance with recent parameters " + Arrays.toString(recentParameters) + " of type " + this.typeClass.toGenericString()));
            ref.setReference(val);
        } else {
            Object[] params = Objects.requireNonNull(this.requestConstructorParameters(requestIdent)).join();
            if (!this.matchingParams(params)) {
                throw new IllegalArgumentException("Cannot use parameters " + Arrays.toString(params) + " for creating new instance of " + this.typeClass.toGenericString());
            }
            val = (Cacheable)Objects.requireNonNull(this.construct(params), "Method \"construct\" must not return null!");
            logger.deeptrace((Object)("Constructed new instance with recent parameters " + Arrays.toString(params) + " of type " + this.typeClass.toGenericString()));
            CacheReference<Cacheable, R> ref = new CacheReference<Cacheable, R>(val, this.keepaliveMilis, requestIdent, params);
            this.instances.put(ident, ref);
        }
        return (T)val;
    }

    public T get(I ident) throws NoSuchElementException, IllegalArgumentException {
        Object val;
        if (!MapHelper.containsKey(this.instances, ident)) {
            throw new NoSuchElementException("Instance with ident " + ident + " not found.");
        }
        CacheReference ref = (CacheReference)MapHelper.getEquals(this.instances, ident, null);
        if (ref.isCached()) {
            val = ref.getReference();
        } else {
            Object[] recentParameters = ref.getRecentParameters();
            if (recentParameters == null) {
                throw new NoSuchElementException("Reference is not isCached and cant be created; no recent parameters set.");
            }
            if (!this.matchingParams(recentParameters)) {
                throw new IllegalArgumentException("Cannot use parameters " + Arrays.toString(recentParameters) + " for creating new instance of " + this.typeClass.toGenericString());
            }
            val = (Cacheable)Objects.requireNonNull(this.construct(recentParameters), "Method \"construct\" must not return null!");
            logger.deeptrace((Object)("Constructed new instance with recent parameters " + Arrays.toString(recentParameters) + " of type " + this.typeClass.toGenericString()));
            ref.setReference(val);
        }
        return val;
    }

    @SafeVarargs
    public final List<I> requestToCache(I ... idents) {
        ArrayList list = new ArrayList();
        for (Object ident : idents) {
            Objects.requireNonNull(ident);
            this.instances.entrySet().stream().filter(entry -> entry.getKey().equals(ident)).forEachOrdered(entry -> {
                try {
                    CacheReference ref = (CacheReference)entry.getValue();
                    Object[] recentParameters = ref.getRecentParameters();
                    if (recentParameters == null) {
                        throw new NoSuchElementException("Reference is not isCached and cant be created; no recent parameters set.");
                    }
                    if (!this.matchingParams(recentParameters)) {
                        throw new IllegalArgumentException("Cannot use parameters " + Arrays.toString(recentParameters) + " for creating new instance of " + this.typeClass.toGenericString());
                    }
                    ref.setReference((Cacheable)Objects.requireNonNull(this.construct(recentParameters), "Method \"construct\" must not return null!"));
                    logger.deeptrace((Object)("Constructed new instance with recent parameters " + Arrays.toString(recentParameters) + " of type " + this.typeClass.toGenericString()));
                }
                finally {
                    list.add(ident);
                }
            });
        }
        return list;
    }

    @SafeVarargs
    public final List<I> destroyFromCache(I ... idents) {
        ArrayList list = new ArrayList();
        for (Object ident : idents) {
            Objects.requireNonNull(ident);
            this.instances.entrySet().stream().filter(entry -> entry.getKey().equals(ident)).forEachOrdered(entry -> {
                try {
                    CacheReference ref = (CacheReference)entry.getValue();
                    this.instances.remove(entry.getKey(), ref);
                    ref.uncache();
                    ref.close();
                }
                finally {
                    list.add(ident);
                }
            });
        }
        return list;
    }

    private boolean matchingParams(Object ... parameter) {
        boolean match = true;
        for (int i = 0; i < parameter.length; ++i) {
            if (this.constructorParameter[i].isAssignableFrom(parameter[i].getClass())) continue;
            match = false;
        }
        return match;
    }

    static {
        logger = new Logger(CacheImpl.class);
        cacheInstances = new ConcurrentHashMap();
        scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        scheduledExecutorService.scheduleAtFixedRate(() -> cacheInstances.entrySet().stream().flatMap(entry -> ((CacheImpl)entry.getValue()).instances.entrySet().stream()).map(Map.Entry::getValue).filter(CacheReference::canBeUncached).forEachOrdered(CacheReference::uncache), 30L, 30L, TimeUnit.SECONDS);
    }
}

