/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.core.net.socket;

import de.kaleidox.crystalshard.core.net.socket.DiscordEventDispatch;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.util.helpers.JsonHelper;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public class WebSocketListener
implements WebSocket.Listener {
    private static final Logger logger = new Logger(WebSocketListener.class);
    private final Discord discord;
    private StringBuilder onTextBuilder = new StringBuilder();
    private CompletableFuture<String> onTextFuture = new CompletableFuture();

    public WebSocketListener(Discord discordObject) {
        this.discord = discordObject;
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        webSocket.request(1L);
        logger.trace((Object)("WebSocket opened: " + webSocket));
    }

    public CompletionStage<String> onText(WebSocket webSocket, CharSequence data, boolean last) {
        webSocket.request(1L);
        this.onTextBuilder.append(data);
        if (last) {
            this.onTextFuture.complete(this.onTextBuilder.toString());
            this.onTextBuilder = new StringBuilder();
            CompletableFuture<String> returning = this.onTextFuture;
            returning.thenAcceptAsync(arg_0 -> ((Logger)logger).deeptrace(arg_0));
            ((CompletableFuture)((CompletableFuture)returning.exceptionally(arg_0 -> ((Logger)logger).exception(arg_0))).thenApplyAsync(JsonHelper::parse)).thenAcceptAsync(node -> DiscordEventDispatch.handle(this.discord, node));
            this.onTextFuture = new CompletableFuture();
            return returning;
        }
        return this.onTextFuture;
    }

    @Override
    public CompletionStage<?> onBinary(WebSocket webSocket, ByteBuffer data, boolean last) {
        webSocket.request(1L);
        logger.error((Object)"WebSocket#onBinary is not implemented! Please contact the developer.");
        return null;
    }

    @Override
    public CompletionStage<?> onPing(WebSocket webSocket, ByteBuffer message) {
        webSocket.request(1L);
        logger.error((Object)"WebSocket#onPing is not implemented! Please contact the developer.");
        return null;
    }

    @Override
    public CompletionStage<?> onPong(WebSocket webSocket, ByteBuffer message) {
        webSocket.request(1L);
        logger.error((Object)"WebSocket#onPong is not implemented! Please contact the developer.");
        return null;
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        webSocket.request(1L);
        logger.trace((Object)("WebSocket closed with code '" + statusCode + "' and reason: " + reason));
        return null;
    }

    @Override
    public void onError(WebSocket webSocket, Throwable error) {
        webSocket.request(1L);
        logger.exception(error, "WebSocket error");
    }
}

