/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.core.net.socket;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.kaleidox.crystalshard.core.concurrent.ThreadPoolImpl;
import de.kaleidox.crystalshard.core.net.request.DiscordRequestImpl;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.endpoint.DiscordEndpoint;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.core.net.socket.OpCode;
import de.kaleidox.crystalshard.core.net.socket.Payload;
import de.kaleidox.crystalshard.core.net.socket.WebSocketClient;
import de.kaleidox.crystalshard.core.net.socket.WebSocketListener;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.util.helpers.FutureHelper;
import de.kaleidox.util.helpers.JsonHelper;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;

public class WebSocketClientImpl
implements WebSocketClient {
    private static final Logger logger = new Logger(WebSocketClient.class);
    private static final HttpClient CLIENT = HttpClient.newHttpClient();
    private final Discord discord;
    private final WebSocket webSocket;
    private final AtomicLong lastPacket = new AtomicLong(0L);
    private final AtomicLong lastHeartbeat = new AtomicLong(0L);
    private final ThreadPoolImpl threadPool;

    public WebSocketClientImpl(Discord discordObject) {
        URI gatewayUrl = (URI)((CompletableFuture)((CompletableFuture)new DiscordRequestImpl(discordObject).setMethod(HttpMethod.GET).setUri((RequestURI)DiscordEndpoint.GATEWAY.createUri(new Object[0])).executeAs(node -> node.get("url").asText()).exceptionally(throwable -> {
            logger.exception(throwable);
            return "wss://gateway.discord.gg";
        })).thenApply(URI::create)).join();
        this.threadPool = new ThreadPoolImpl(discordObject, 1, "WebSocketClient");
        this.discord = discordObject;
        this.webSocket = CLIENT.newWebSocketBuilder().header("Authorization", discordObject.getPrefixedToken()).buildAsync(gatewayUrl, new WebSocketListener(discordObject)).join();
        this.identification();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.webSocket.sendClose(1000, "Shutting down!")));
    }

    private void identification() {
        ObjectNode data = JsonHelper.objectNode((Object[])new Object[]{"properties", JsonHelper.objectNode((Object[])new Object[]{"$os", JsonHelper.nodeOf((Object)System.getProperty("os.name")), "$browser", JsonHelper.nodeOf((Object)"CrystalShard v0.9"), "$device", JsonHelper.nodeOf((Object)"CrystalShard v0.9")})});
        this.sendPayload(Payload.create((OpCode)OpCode.IDENTIFY, (JsonNode)data)).exceptionally(arg_0 -> ((Logger)logger).exception(arg_0));
    }

    public CompletableFuture<Void> sendPayload(Payload payload) {
        assert (payload != null) : "Payload must not be null!";
        CompletableFuture future = new CompletableFuture();
        this.threadPool.execute(() -> {
            while (this.lastPacket.get() > System.currentTimeMillis() - 600L) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    logger.exception((Throwable)e);
                }
            }
            if (this.lastPacket.get() <= System.currentTimeMillis() - 500L) {
                logger.trace((Object)("Sending Packet with OpCode " + payload.getCode() + " and body: " + payload.getBody()));
                boolean attachedFuture = false;
                for (Payload that : payload.split()) {
                    boolean last = that.isLast();
                    that.addNode("token", JsonHelper.nodeOf((Object)this.discord.getPrefixedToken()));
                    that.addNode("large_threshold", JsonHelper.nodeOf((Object)250));
                    that.addNode("shard", (JsonNode)JsonHelper.arrayNode((Object[])new Object[]{this.discord.getShardId(), this.discord.getShards()}));
                    CharSequence nodeAsText = that.getSendableNode();
                    CompletableFuture<WebSocket> subFut = this.webSocket.sendText(nodeAsText, last);
                    if (last) {
                        this.lastPacket.set(System.currentTimeMillis());
                    }
                    if (attachedFuture) continue;
                    FutureHelper.linkFutures(subFut, (CompletableFuture[])new CompletableFuture[]{future});
                    attachedFuture = true;
                }
            }
        }, new String[0]);
        return future.thenApply(n -> null);
    }

    public void heartbeat() {
        Payload payload = Payload.create((OpCode)OpCode.HEARTBEAT, (JsonNode)JsonHelper.nodeOf(null));
        this.sendPayload(payload);
        this.lastHeartbeat.set(System.currentTimeMillis());
    }

    public boolean respondToHeartbeat() {
        return this.lastHeartbeat.get() < System.currentTimeMillis() - 4000L;
    }
}

