/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.core.net.request.ratelimit;

import de.kaleidox.crystalshard.core.concurrent.ThreadPoolImpl;
import de.kaleidox.crystalshard.core.net.request.endpoint.DiscordRequestURI;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.core.net.request.ratelimit.RatelimiterImpl;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.util.functional.LivingInt;
import de.kaleidox.util.helpers.MapHelper;
import de.kaleidox.util.helpers.QueueHelper;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.naming.LimitExceededException;

class BucketManager {
    private static final Logger logger = new Logger(BucketManager.class);
    private final Discord discord;
    private final RatelimiterImpl ratelimiterImpl;
    private final ConcurrentLinkedQueue<Bucket> bucketQueue;
    private final ThreadPoolImpl atomicPool;
    private final LivingInt globalRatelimit;

    BucketManager(Discord discord, RatelimiterImpl ratelimiterImpl) {
        this.discord = discord;
        this.ratelimiterImpl = ratelimiterImpl;
        this.bucketQueue = new ConcurrentLinkedQueue();
        this.atomicPool = new ThreadPoolImpl(discord, 1, "BucketManager");
        this.globalRatelimit = new LivingInt(0, 0, -1, 20L, TimeUnit.MILLISECONDS);
        this.cycle();
    }

    private void cycle() {
        this.atomicPool.execute(() -> {
            ConcurrentLinkedQueue<Bucket> concurrentLinkedQueue = this.bucketQueue;
            synchronized (concurrentLinkedQueue) {
                while (true) {
                    try {
                        while (true) {
                            if (this.bucketQueue.isEmpty()) {
                                this.bucketQueue.wait();
                                continue;
                            }
                            Bucket poll = this.bucketQueue.poll();
                            while (!poll.canRun()) {
                                logger.deeptrace((Object)("Ratelimited bucket " + poll + " for " + poll.waitDuration() + " MS"));
                                Thread.sleep(poll.waitDuration());
                            }
                            poll.runAll();
                        }
                    }
                    catch (InterruptedException e) {
                        logger.exception((Throwable)e, "BucketQueue wait or sleep interrupted.");
                        continue;
                    }
                    break;
                }
            }
        }, new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void schedule(RequestURI discordRequestURI, Runnable requestExecution) {
        ConcurrentLinkedQueue<Bucket> concurrentLinkedQueue = this.bucketQueue;
        synchronized (concurrentLinkedQueue) {
            try {
                if (this.bucketQueue.isEmpty()) {
                    this.bucketQueue.add(new Bucket());
                }
                boolean success = false;
                while (!success) {
                    Bucket poll = (Bucket)QueueHelper.getTail(this.bucketQueue);
                    assert (poll != null);
                    if (poll.canAccept(discordRequestURI)) {
                        poll.addRequest(discordRequestURI, requestExecution);
                        success = true;
                        continue;
                    }
                    this.bucketQueue.add(new Bucket());
                }
                this.bucketQueue.notify();
            }
            catch (LimitExceededException e) {
                logger.exception((Throwable)e);
            }
        }
    }

    private class Bucket {
        private ConcurrentHashMap<RequestURI, Runnable[]> requests = new ConcurrentHashMap();

        Bucket() {
        }

        public String toString() {
            int numEndpoints = this.requests.size();
            int numRequests = this.requests.entrySet().stream().map(Map.Entry::getValue).mapToInt(arr -> ((Runnable[])arr).length).sum();
            return "Bucket [" + numEndpoints + " Endpoint" + (numEndpoints == 1 ? "" : "s") + ", " + numRequests + " Requests]";
        }

        boolean canAccept(RequestURI discordRequestURI) {
            return MapHelper.countKeyOccurrences(this.requests, (Object)discordRequestURI) < BucketManager.this.ratelimiterImpl.getLimit(discordRequestURI).get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addRequest(RequestURI discordRequestURI, Runnable requestExecution) throws LimitExceededException {
            ConcurrentLinkedQueue<Bucket> concurrentLinkedQueue = BucketManager.this.bucketQueue;
            synchronized (concurrentLinkedQueue) {
                if (!MapHelper.containsKey(this.requests, (Object)discordRequestURI)) {
                    this.requests.put(discordRequestURI, new Runnable[0]);
                }
                Runnable[] getOrDefault = (Runnable[])MapHelper.getEquals(this.requests, (Object)discordRequestURI, null);
                AtomicInteger limit = BucketManager.this.ratelimiterImpl.getLimit(discordRequestURI);
                AtomicInteger remaining = BucketManager.this.ratelimiterImpl.getRemaining(discordRequestURI);
                if (limit.get() < getOrDefault.length) {
                    throw new LimitExceededException("Bucket Limit exceeded!");
                }
                Runnable[] arr = this.addToArray(getOrDefault, requestExecution);
                this.requests.replace(discordRequestURI, arr);
                remaining.decrementAndGet();
            }
        }

        private Runnable[] addToArray(Runnable[] arr, Runnable add) {
            Runnable[] putArr = new Runnable[arr.length + 1];
            System.arraycopy(arr, 0, putArr, 0, arr.length);
            putArr[putArr.length - 1] = add;
            return putArr;
        }

        void runAll() {
            BucketManager.this.globalRatelimit.change(this.requests.size());
            this.requests.forEach((endpoint, runnables) -> {
                for (Runnable task : runnables) {
                    try {
                        BucketManager.this.ratelimiterImpl.executePool.execute(task, "Request to " + endpoint);
                    }
                    catch (Exception e) {
                        logger.exception((Throwable)e, "Exception in Request " + endpoint);
                    }
                }
                this.requests.remove(endpoint, runnables);
            });
            if (this.requests.size() > 0) {
                logger.error((Object)("Request List of Bucket " + this + " is not empty after execution loop."));
                this.requests.clear();
            }
        }

        boolean canRun() {
            if (BucketManager.this.globalRatelimit.get() + this.requests.size() >= 50) {
                return false;
            }
            int trueC = 0;
            for (RequestURI end : this.requests.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toList())) {
                int remaining = BucketManager.this.ratelimiterImpl.getRemaining(end).get();
                int limit = BucketManager.this.ratelimiterImpl.getLimit(end).get();
                Instant reset = BucketManager.this.ratelimiterImpl.getReset(end).get();
                if (remaining == 0) {
                    if (!reset.isBefore(Instant.now())) continue;
                    ++trueC;
                    continue;
                }
                if (remaining + this.requests.entrySet().stream().map(Map.Entry::getKey).map(RequestURI::getAppendix).mapToInt(a -> 1).sum() >= limit) continue;
                ++trueC;
            }
            return trueC == this.requests.size();
        }

        long waitDuration() {
            long val = 0L;
            for (Map.Entry<RequestURI, Runnable[]> endpointEntry : this.requests.entrySet()) {
                Instant reset = BucketManager.this.ratelimiterImpl.getReset(endpointEntry.getKey()).get();
                long calc = TimeUnit.SECONDS.toMillis(reset.getEpochSecond()) + TimeUnit.NANOSECONDS.toMillis(reset.getNano());
                if (calc <= val) continue;
                val = calc;
            }
            return val;
        }

        private int numberRequests(DiscordRequestURI discordRequestURI) {
            return this.requests.entrySet().stream().filter(entry -> ((DiscordRequestURI)entry.getKey()).sameRatelimit((Object)discordRequestURI)).mapToInt(entry -> ((Runnable[])entry.getValue()).length).sum();
        }
    }
}

