/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.core.net.request;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.WebRequest;
import de.kaleidox.crystalshard.core.net.request.endpoint.RequestURI;
import de.kaleidox.crystalshard.logging.Logger;
import de.kaleidox.util.helpers.JsonHelper;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class WebRequestImpl<T>
implements WebRequest<T> {
    protected static final Logger logger = new Logger(WebRequest.class);
    protected static final HttpClient CLIENT = HttpClient.newHttpClient();
    protected final HttpRequest.Builder requestBuilder = HttpRequest.newBuilder();
    protected final CompletableFuture<String> future = new CompletableFuture();
    protected RequestURI uri;
    protected HttpMethod method;
    protected JsonNode node;

    public WebRequest<T> addHeader(String name, String value) {
        this.requestBuilder.header(name, value);
        return this;
    }

    public RequestURI getUri() {
        return this.uri;
    }

    public WebRequest<T> setUri(RequestURI uri) {
        this.uri = uri;
        return this;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public WebRequest<T> setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    public JsonNode getNode() {
        return this.node;
    }

    public WebRequest<T> setNode(JsonNode node) {
        this.node = node;
        return this;
    }

    public WebRequest<T> setNode(Object ... data) {
        this.node = JsonHelper.objectNode((Object[])data);
        return this;
    }

    public CompletableFuture<String> execute() throws RuntimeException {
        Objects.requireNonNull(this.uri, "URI is not set!");
        Objects.requireNonNull(this.method, "Method is not set!");
        Objects.requireNonNull(this.node, "Node is not set!");
        try {
            HttpResponse<String> response = CLIENT.send(this.requestBuilder.uri(this.uri.getURI()).method(this.method.getDescriptor(), HttpRequest.BodyPublishers.ofString(this.method == HttpMethod.GET ? "" : this.node.toString())).build(), HttpResponse.BodyHandlers.ofString());
            this.future.complete(response.body());
            return this.future;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

