/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.core.net.request;

import com.fasterxml.jackson.databind.JsonNode;
import de.kaleidox.crystalshard.core.net.request.HttpMethod;
import de.kaleidox.crystalshard.core.net.request.WebRequestImpl;
import de.kaleidox.crystalshard.core.net.request.ratelimit.RatelimiterImpl;
import de.kaleidox.crystalshard.main.Discord;
import de.kaleidox.crystalshard.main.exception.DiscordResponseException;
import de.kaleidox.util.CompletableFutureExtended;
import de.kaleidox.util.helpers.JsonHelper;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class DiscordRequestImpl<T>
extends WebRequestImpl<T> {
    private final Discord discord;

    public DiscordRequestImpl(Discord discord) {
        this.discord = discord;
    }

    @Override
    public CompletableFuture<String> execute() throws RuntimeException {
        Objects.requireNonNull(this.uri, "URI is not set!");
        Objects.requireNonNull(this.method, "Method is not set!");
        CompletableFutureExtended future = new CompletableFutureExtended(this.discord.getExecutor());
        CompletableFutureExtended headersFuture = new CompletableFutureExtended(this.discord.getExecutor());
        RatelimiterImpl ratelimiter = (RatelimiterImpl)this.discord.getRatelimiter();
        ratelimiter.schedule(this, (CompletableFuture<HttpHeaders>)headersFuture, () -> this.lambda$execute$0((CompletableFuture)headersFuture, (CompletableFuture)future));
        return future;
    }

    public String toString() {
        return "DiscordRequest -> " + this.uri.toString();
    }

    private /* synthetic */ void lambda$execute$0(CompletableFuture headersFuture, CompletableFuture future) {
        try {
            String body = this.method == HttpMethod.GET ? "" : (this.node == null ? "" : this.node.toString());
            logger.trace((Object)("Creating request: " + this.toString() + " with request body: " + body));
            HttpRequest request = this.requestBuilder.uri(this.uri.getURI()).header("User-Agent", "DiscordBot (http://kaleidox.de, 0.1)").header("Content-Type", "application/json").header("Authorization", this.discord.getPrefixedToken()).method(this.method.getDescriptor(), HttpRequest.BodyPublishers.ofString(body)).build();
            HttpResponse<String> response = CLIENT.send(request, HttpResponse.BodyHandlers.ofString());
            String responseBody = response.body();
            int statusCode = response.statusCode();
            headersFuture.complete(response.headers());
            boolean unknown = true;
            switch (statusCode) {
                case 200: 
                case 204: {
                    future.complete(responseBody);
                    break;
                }
                case 400: {
                    logger.error((Object)("{400} Bad Request issued: " + this.method.getDescriptor() + " " + this.uri.getURI() + " with response responseBody: " + responseBody + " and request responseBody: " + body));
                    break;
                }
                case 429: {
                    logger.warn((Object)("{429} Warning: Ratelimit was hit with request: " + this.toString() + ". Response was:" + responseBody + "\n\t\tPlease contact the developer!"));
                    return;
                }
                case 403: 
                case 404: {
                    unknown = false;
                }
                default: {
                    JsonNode responseNode = JsonHelper.parse((String)responseBody);
                    logger.traceElseInfo((Object)("{" + statusCode + ":" + responseNode.get("code").asText() + ":\"" + responseNode.get("message").asText() + "\"} " + (unknown ? "Recieved unknown status code from Discord with responseBody: " + responseBody : "Untreated code recieved with body: " + responseBody)), (Object)("Recieved unknown status code: " + statusCode));
                    future.completeExceptionally((Throwable)new DiscordResponseException("Discord Responded with unknown status code " + statusCode + " and message: " + responseBody));
                    break;
                }
            }
        }
        catch (Throwable e) {
            logger.exception(e, "Error in WebRequest " + this.toString());
        }
    }
}

