/*
 * Decompiled with CFR 0.152.
 */
package de.kaleidox.crystalshard.core.cache;

import de.kaleidox.crystalshard.core.cache.Cacheable;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

class CacheReference<T extends Cacheable, R> {
    private final long keepAlive;
    private String refString;
    private R recentRequestor;
    private Object[] recentParameters;
    private T reference;
    private AtomicLong lastAccess;
    private AtomicBoolean cached;

    CacheReference(T reference, long keepAlive, R recentRequestor, Object ... recentParameters) {
        this.reference = reference;
        this.keepAlive = keepAlive;
        this.recentRequestor = recentRequestor;
        this.recentParameters = recentParameters;
        this.lastAccess = new AtomicLong(System.currentTimeMillis());
        if (Objects.nonNull(reference)) {
            this.refString = reference.toString();
        }
        this.cached = new AtomicBoolean(reference != null);
    }

    public int hashCode() {
        return this.reference == null ? super.hashCode() : this.reference.hashCode();
    }

    public boolean equals(Object obj) {
        return this.reference == null ? super.equals(obj) : this.reference.equals(obj);
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException("Cannot clone CacheReferences!");
    }

    public String toString() {
        return "CacheReference{" + (this.refString == null ? "undefined reference" : this.refString) + "}";
    }

    public void close() {
        this.reference = null;
        this.recentRequestor = null;
        this.recentParameters = null;
        this.lastAccess = null;
        this.cached = null;
    }

    public synchronized Object[] getRecentParameters() {
        return this.recentParameters;
    }

    public synchronized void setRecentParameters(Object[] recentParameters) {
        this.recentParameters = recentParameters;
    }

    public R getRecentRequestor() {
        return this.recentRequestor;
    }

    public void setRecentRequestor(R recentRequestor) {
        this.recentRequestor = recentRequestor;
    }

    public synchronized boolean isCached() {
        return this.cached.get();
    }

    public synchronized T getReference() {
        this.accessed();
        return this.reference;
    }

    public synchronized void setReference(T reference) {
        this.reference = reference;
        this.cached.set(true);
        if (Objects.nonNull(reference)) {
            this.refString = reference.toString();
        }
    }

    public synchronized void accessed() {
        this.lastAccess.set(System.currentTimeMillis());
    }

    public synchronized void uncache() {
        this.reference = null;
        this.cached.set(false);
    }

    public boolean canBeUncached() {
        return this.lastAccess.get() + this.keepAlive < System.currentTimeMillis();
    }
}

