/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt.util;

import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class DataReader {
    public static final NumberFormat format = NumberFormat.getInstance(Locale.US);

    public static double[] readDoubleArray(String string, ParsePosition pos, int size) {
        DataReader.skipOverChar(string, pos, '{');
        double[] result = new double[size];
        int index = 0;
        while (index < size - 1) {
            DataReader.skipBlanks(string, pos);
            result[index++] = format.parse(string, pos).doubleValue();
            DataReader.skipOverChar(string, pos, ',');
        }
        DataReader.skipBlanks(string, pos);
        result[index++] = format.parse(string, pos).doubleValue();
        DataReader.skipOverChar(string, pos, '}');
        return result;
    }

    public static void skipBlanks(String string, ParsePosition pos) {
        while (Character.isWhitespace(string.charAt(pos.getIndex()))) {
            pos.setIndex(pos.getIndex() + 1);
        }
    }

    public static int[] readIntArray(String string, ParsePosition pos, int size) {
        DataReader.skipOverChar(string, pos, '{');
        int[] result = new int[size];
        int index = 0;
        while (index < size - 1) {
            DataReader.skipBlanks(string, pos);
            result[index++] = format.parse(string, pos).intValue();
            DataReader.skipOverChar(string, pos, ',');
        }
        DataReader.skipBlanks(string, pos);
        result[index++] = format.parse(string, pos).intValue();
        DataReader.skipOverChar(string, pos, '}');
        return result;
    }

    public static void skipOverChar(String string, ParsePosition pos, char bracket) {
        DataReader.skipBlanks(string, pos);
        if (string.charAt(pos.getIndex()) != bracket) {
            throw new IllegalArgumentException("no array here");
        }
        pos.setIndex(pos.getIndex() + 1);
    }
}

