/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt.solarsystem;

import de.kah2.zodiac.nova4jmt.RiseSet;
import de.kah2.zodiac.nova4jmt.Transform;
import de.kah2.zodiac.nova4jmt.Utility;
import de.kah2.zodiac.nova4jmt.Vsop87;
import de.kah2.zodiac.nova4jmt.api.LnEquPosn;
import de.kah2.zodiac.nova4jmt.api.LnHelioPosn;
import de.kah2.zodiac.nova4jmt.api.LnLnlatPosn;
import de.kah2.zodiac.nova4jmt.api.LnRectPosn;
import de.kah2.zodiac.nova4jmt.api.LnRstTime;
import de.kah2.zodiac.nova4jmt.solarsystem.Earth;
import de.kah2.zodiac.nova4jmt.solarsystem.Solar;
import de.kah2.zodiac.nova4jmt.util.IGetEquBodyCoords;

public class Uranus {
    static double cJD = 0.0;
    static double cL = 0.0;
    static double cB = 0.0;
    static double cR = 0.0;

    public static void ln_get_uranus_equ_coords(double JD, LnEquPosn position) {
        double c;
        double b;
        double a;
        double last;
        double delta;
        double diff;
        LnHelioPosn h_sol = new LnHelioPosn();
        LnHelioPosn h_uranus = new LnHelioPosn();
        LnRectPosn g_sol = new LnRectPosn();
        LnRectPosn g_uranus = new LnRectPosn();
        double t = 0.0;
        Solar.ln_get_solar_geom_coords(JD, h_sol);
        Transform.ln_get_rect_from_helio(h_sol, g_sol);
        do {
            last = t;
            Uranus.ln_get_uranus_helio_coords(JD - t, h_uranus);
            Transform.ln_get_rect_from_helio(h_uranus, g_uranus);
            a = g_sol.X + g_uranus.X;
            b = g_sol.Y + g_uranus.Y;
            c = g_sol.Z + g_uranus.Z;
            delta = a * a + b * b + c * c;
        } while ((diff = (t = (delta = Math.sqrt(delta)) * 0.0057755183) - last) > 1.0E-4 || diff < -1.0E-4);
        double ra = Math.atan2(b, a);
        double dec = c / delta;
        dec = Math.asin(dec);
        position.ra = Utility.ln_range_degrees(Utility.ln_rad_to_deg(ra));
        position.dec = Utility.ln_rad_to_deg(dec);
    }

    public static void ln_get_uranus_helio_coords(double JD, LnHelioPosn position) {
        if (JD == cJD) {
            position.L = cL;
            position.B = cB;
            position.R = cR;
            return;
        }
        double t = (JD - 2451545.0) / 365250.0;
        double t2 = t * t;
        double t3 = t2 * t;
        double t4 = t3 * t;
        double L0 = Vsop87.ln_calc_series(Longitude.uranus_longitude_l0, t);
        double L1 = Vsop87.ln_calc_series(Longitude.uranus_longitude_l1, t);
        double L2 = Vsop87.ln_calc_series(Longitude.uranus_longitude_l2, t);
        double L3 = Vsop87.ln_calc_series(Longitude.uranus_longitude_l3, t);
        double L4 = Vsop87.ln_calc_series(Longitude.uranus_longitude_l4, t);
        position.L = L0 + L1 * t + L2 * t2 + L3 * t3 + L4 * t4;
        double B0 = Vsop87.ln_calc_series(Latitude.uranus_latitude_b0, t);
        double B1 = Vsop87.ln_calc_series(Latitude.uranus_latitude_b1, t);
        double B2 = Vsop87.ln_calc_series(Latitude.uranus_latitude_b2, t);
        double B3 = Vsop87.ln_calc_series(Latitude.uranus_latitude_b3, t);
        position.B = B0 + B1 * t + B2 * t2 + B3 * t3;
        double R0 = Vsop87.ln_calc_series(Radius.uranus_radius_r0, t);
        double R1 = Vsop87.ln_calc_series(Radius.uranus_radius_r1, t);
        double R2 = Vsop87.ln_calc_series(Radius.uranus_radius_r2, t);
        double R3 = Vsop87.ln_calc_series(Radius.uranus_radius_r3, t);
        double R4 = Vsop87.ln_calc_series(Radius.uranus_radius_r4, t);
        position.R = R0 + R1 * t + R2 * t2 + R3 * t3 + R4 * t4;
        position.L = Utility.ln_rad_to_deg(position.L);
        position.B = Utility.ln_rad_to_deg(position.B);
        position.L = Utility.ln_range_degrees(position.L);
        Vsop87.ln_vsop87_to_fk5(position, JD);
        cJD = JD;
        cL = position.L;
        cB = position.B;
        cR = position.R;
    }

    public static double ln_get_uranus_earth_dist(double JD) {
        LnHelioPosn h_uranus = new LnHelioPosn();
        LnHelioPosn h_earth = new LnHelioPosn();
        LnRectPosn g_uranus = new LnRectPosn();
        LnRectPosn g_earth = new LnRectPosn();
        Uranus.ln_get_uranus_helio_coords(JD, h_uranus);
        Earth.ln_get_earth_helio_coords(JD, h_earth);
        Transform.ln_get_rect_from_helio(h_uranus, g_uranus);
        Transform.ln_get_rect_from_helio(h_earth, g_earth);
        double x = g_uranus.X - g_earth.X;
        double y = g_uranus.Y - g_earth.Y;
        double z = g_uranus.Z - g_earth.Z;
        x *= x;
        y *= y;
        z *= z;
        return Math.sqrt(x + y + z);
    }

    public static double ln_get_uranus_solar_dist(double JD) {
        LnHelioPosn h_uranus = new LnHelioPosn();
        Uranus.ln_get_uranus_helio_coords(JD, h_uranus);
        return h_uranus.R;
    }

    public static double ln_get_uranus_magnitude(double JD) {
        double r = Uranus.ln_get_uranus_solar_dist(JD);
        double delta = Uranus.ln_get_uranus_earth_dist(JD);
        return -7.19 + 5.0 * Math.log10(r * delta);
    }

    public static double ln_get_uranus_disk(double JD) {
        double R = Earth.ln_get_earth_solar_dist(JD);
        double r = Uranus.ln_get_uranus_solar_dist(JD);
        double delta = Uranus.ln_get_uranus_earth_dist(JD);
        return ((r + delta) * (r + delta) - R * R) / (4.0 * r * delta);
    }

    public static double ln_get_uranus_phase(double JD) {
        double R = Earth.ln_get_earth_solar_dist(JD);
        double r = Uranus.ln_get_uranus_solar_dist(JD);
        double delta = Uranus.ln_get_uranus_earth_dist(JD);
        double i = (r * r + delta * delta - R * R) / (2.0 * r * delta);
        i = Math.acos(i);
        return Utility.ln_rad_to_deg(i);
    }

    public static int ln_get_uranus_rst(double JD, LnLnlatPosn observer, LnRstTime rst) {
        return RiseSet.ln_get_body_rst_horizon(JD, observer, new IGetEquBodyCoords(){

            @Override
            public void get_equ_body_coords(double JD, LnEquPosn position) {
                Uranus.ln_get_uranus_equ_coords(JD, position);
            }
        }, RiseSet.LN_STAR_STANDART_HORIZON.doubleValue(), rst);
    }

    public static double ln_get_uranus_sdiam(double JD) {
        double So = 35.02;
        double dist = Uranus.ln_get_uranus_earth_dist(JD);
        return So / dist;
    }

    public static void ln_get_uranus_rect_helio(double JD, LnRectPosn position) {
        LnHelioPosn uranus = new LnHelioPosn();
        Uranus.ln_get_uranus_helio_coords(JD, uranus);
        Transform.ln_get_rect_from_helio(uranus, position);
    }

    static class Radius {
        private static final Vsop87.LnVsop[] uranus_radius_r0 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(19.21264847206, 0.0, 0.0), new Vsop87.LnVsop(0.88784984413, 5.60377527014, 74.7815985673), new Vsop87.LnVsop(0.03440836062, 0.32836099706, 73.297125859), new Vsop87.LnVsop(0.0205565386, 1.7829515933, 149.5631971346), new Vsop87.LnVsop(0.0064932241, 4.52247285911, 76.2660712756), new Vsop87.LnVsop(0.00602247865, 3.86003823674, 63.7358983034), new Vsop87.LnVsop(0.00496404167, 1.40139935333, 454.9093665273), new Vsop87.LnVsop(0.00338525369, 1.58002770318, 138.5174968707), new Vsop87.LnVsop(0.00243509114, 1.57086606044, 71.8126531507), new Vsop87.LnVsop(0.00190522303, 1.99809394714, 1.4844727083), new Vsop87.LnVsop(0.00161858838, 2.79137786799, 148.0787244263), new Vsop87.LnVsop(0.00143706183, 1.38368544947, 11.0457002639), new Vsop87.LnVsop(9.3192405E-4, 0.17437220467, 36.6485629295), new Vsop87.LnVsop(7.1424548E-4, 4.24509236074, 224.3447957019), new Vsop87.LnVsop(8.9806014E-4, 3.66105364565, 109.9456887885), new Vsop87.LnVsop(3.9009723E-4, 1.66971401684, 70.8494453042), new Vsop87.LnVsop(4.6677296E-4, 1.39976401694, 35.1640902212), new Vsop87.LnVsop(3.9025624E-4, 3.36234773834, 277.0349937414), new Vsop87.LnVsop(3.6755274E-4, 3.88649278513, 146.594251718), new Vsop87.LnVsop(3.0348723E-4, 0.70100838798, 151.0476698429), new Vsop87.LnVsop(2.9156413E-4, 3.180563367, 77.7505439839), new Vsop87.LnVsop(2.0471591E-4, 1.55587964879, 202.2533951741), new Vsop87.LnVsop(2.5620756E-4, 5.25656086672, 380.12776796), new Vsop87.LnVsop(2.578588E-4, 3.7853770987, 85.8272988312), new Vsop87.LnVsop(2.2637073E-4, 0.72518687029, 529.6909650946), new Vsop87.LnVsop(2.0473534E-4, 2.79640244248, 70.3281804424), new Vsop87.LnVsop(1.79013E-4, 0.55455066863, 2.9689454166), new Vsop87.LnVsop(1.2328114E-4, 5.96037276805, 127.4717966068), new Vsop87.LnVsop(1.4701666E-4, 4.90434516516, 108.4612160802), new Vsop87.LnVsop(1.149468E-4, 0.43772043395, 65.2203710117), new Vsop87.LnVsop(1.5502375E-4, 5.35405396163, 38.1330356378), new Vsop87.LnVsop(1.0792498E-4, 1.42106296264, 213.299095438), new Vsop87.LnVsop(1.1695693E-4, 3.29824190199, 3.9321532631), new Vsop87.LnVsop(1.1959076E-4, 1.7504339214, 984.6003316219), new Vsop87.LnVsop(1.2896452E-4, 2.62154084288, 111.4301614968), new Vsop87.LnVsop(1.1852959E-4, 0.99344161196, 52.6901980395), new Vsop87.LnVsop(9.111621E-5, 4.99633582839, 62.2514255951), new Vsop87.LnVsop(8.420792E-5, 5.25351368389, 222.8603229936), new Vsop87.LnVsop(7.448995E-5, 0.79495503123, 351.8165923087), new Vsop87.LnVsop(8.402384E-5, 5.03876467031, 415.5524906121), new Vsop87.LnVsop(6.046221E-5, 5.67958564987, 78.7137518304), new Vsop87.LnVsop(5.524411E-5, 3.11493320824, 9.5612275556), new Vsop87.LnVsop(7.329301E-5, 3.97276588872, 183.2428146475), new Vsop87.LnVsop(5.44457E-5, 5.10574758517, 145.1097790097), new Vsop87.LnVsop(5.238203E-5, 2.62960535651, 33.6796175129), new Vsop87.LnVsop(4.079523E-5, 3.22064116734, 340.7708920448), new Vsop87.LnVsop(3.801645E-5, 6.10982670905, 184.7272873558), new Vsop87.LnVsop(3.918728E-5, 4.25017709085, 39.6175083461), new Vsop87.LnVsop(2.940764E-5, 2.14649735789, 137.0330241624), new Vsop87.LnVsop(3.781197E-5, 3.45840366912, 456.3938392356), new Vsop87.LnVsop(2.942224E-5, 0.42392830457, 299.1263942692), new Vsop87.LnVsop(3.686324E-5, 2.48725993956, 453.424893819), new Vsop87.LnVsop(3.101496E-5, 4.14028619712, 219.891377577), new Vsop87.LnVsop(2.962643E-5, 0.82981906774, 56.6223513026), new Vsop87.LnVsop(2.937579E-5, 3.67652211319, 140.001969579), new Vsop87.LnVsop(2.864793E-5, 0.30998964462, 12.5301729722), new Vsop87.LnVsop(2.53811E-5, 4.85443168231, 131.4039498699), new Vsop87.LnVsop(1.962787E-5, 5.24326793681, 84.3428261229), new Vsop87.LnVsop(2.363719E-5, 0.44244699485, 554.0699874828), new Vsop87.LnVsop(1.978408E-5, 6.12838999163, 106.9767433719), new Vsop87.LnVsop(2.182603E-5, 2.94042519396, 305.3461693927), new Vsop87.LnVsop(1.963255E-5, 0.04114614586, 221.3758502853), new Vsop87.LnVsop(1.829781E-5, 4.01105197128, 68.8437077341), new Vsop87.LnVsop(1.64292E-5, 0.35558129224, 67.6680515665), new Vsop87.LnVsop(1.584876E-5, 3.16265838848, 225.8292684102), new Vsop87.LnVsop(1.848022E-5, 2.91116293131, 909.8187330546), new Vsop87.LnVsop(1.632263E-5, 4.23038575372, 22.0914005278), new Vsop87.LnVsop(1.402196E-5, 1.3910671015, 265.9892934775), new Vsop87.LnVsop(1.404021E-5, 5.63567908789, 4.4534181249), new Vsop87.LnVsop(1.656488E-5, 1.96436491067, 79.2350166922), new Vsop87.LnVsop(1.248478E-5, 5.44008558936, 54.1746707478), new Vsop87.LnVsop(1.563396E-5, 1.47919498164, 112.9146342051), new Vsop87.LnVsop(1.248513E-5, 4.88964506527, 479.2883889155), new Vsop87.LnVsop(1.197649E-5, 2.52152454056, 145.6310438715), new Vsop87.LnVsop(1.506943E-5, 5.2418542036, 181.7583419392), new Vsop87.LnVsop(1.481952E-5, 5.66201356223, 152.5321425512), new Vsop87.LnVsop(1.439115E-5, 1.53047702403, 447.7958195265), new Vsop87.LnVsop(1.408871E-5, 4.41921152932, 462.0229135281), new Vsop87.LnVsop(1.477003E-5, 4.32173218344, 256.5399405065), new Vsop87.LnVsop(1.228234E-5, 5.97697848866, 59.8037450403), new Vsop87.LnVsop(1.249895E-5, 6.24480493841, 160.6088973985), new Vsop87.LnVsop(9.06516E-6, 5.62013120164, 74.6697239827), new Vsop87.LnVsop(1.090686E-5, 4.15394319904, 77.962992305), new Vsop87.LnVsop(8.44827E-6, 0.1296605606, 82.8583534146), new Vsop87.LnVsop(9.00579E-6, 2.37303064621, 74.8934731519), new Vsop87.LnVsop(1.071649E-5, 1.74298201693, 528.2064923863), new Vsop87.LnVsop(6.89518E-6, 3.08087933344, 69.3649725959), new Vsop87.LnVsop(5.9401E-6, 4.50031730404, 8.0767548473), new Vsop87.LnVsop(7.18644E-6, 4.00028668863, 128.9562693151), new Vsop87.LnVsop(6.99874E-6, 0.03990034416, 143.6253063014), new Vsop87.LnVsop(5.75672E-6, 5.89553952415, 66.70484372), new Vsop87.LnVsop(7.58678E-6, 2.1369380317, 692.5874843535), new Vsop87.LnVsop(7.10274E-6, 5.41605211553, 218.4069048687), new Vsop87.LnVsop(5.48663E-6, 5.62811775865, 3.1813937377), new Vsop87.LnVsop(6.51756E-6, 4.42317051993, 18.1592472647), new Vsop87.LnVsop(5.3973E-6, 6.20779847549, 71.6002048296), new Vsop87.LnVsop(5.44899E-6, 5.69409543986, 203.7378678824), new Vsop87.LnVsop(7.10254E-6, 4.21967520209, 381.6122406683), new Vsop87.LnVsop(5.94034E-6, 3.83794153459, 32.1951448046), new Vsop87.LnVsop(7.09902E-6, 4.48962691884, 293.188503436), new Vsop87.LnVsop(7.05697E-6, 0.4551853916, 835.0371344873), new Vsop87.LnVsop(5.87851E-6, 5.08268227675, 186.2117600641), new Vsop87.LnVsop(5.98191E-6, 0.35792534475, 269.9214467406), new Vsop87.LnVsop(6.42152E-6, 2.71090806243, 87.3117715395), new Vsop87.LnVsop(4.9564E-6, 2.6511174264, 200.7689224658), new Vsop87.LnVsop(6.30166E-6, 4.46153551027, 275.5505210331), new Vsop87.LnVsop(5.7495E-6, 5.57877269214, 2.4476805548), new Vsop87.LnVsop(5.69622E-6, 1.63924602135, 77.2292791221), new Vsop87.LnVsop(5.56672E-6, 1.07231890667, 1059.3819301892), new Vsop87.LnVsop(4.49362E-6, 0.27988155703, 617.8058857862), new Vsop87.LnVsop(4.63703E-6, 1.43450762802, 297.6419215609), new Vsop87.LnVsop(4.36536E-6, 0.52783902054, 209.3669421749), new Vsop87.LnVsop(4.6392E-6, 2.35519668239, 211.8146227297), new Vsop87.LnVsop(4.35944E-6, 2.10077178384, 1514.2912967165), new Vsop87.LnVsop(5.15533E-6, 3.23274245907, 284.1485407422), new Vsop87.LnVsop(4.55004E-6, 4.08342038147, 99.1606209555), new Vsop87.LnVsop(4.77251E-6, 2.8938165321, 39.3568759152), new Vsop87.LnVsop(5.42691E-6, 5.39457310701, 278.5194664497), new Vsop87.LnVsop(4.09903E-6, 3.04961893378, 404.5067903482), new Vsop87.LnVsop(3.68389E-6, 0.71079545635, 125.9873238985), new Vsop87.LnVsop(5.03183E-6, 5.8391548775, 191.2076949102), new Vsop87.LnVsop(4.874E-6, 0.06424307109, 60.7669528868), new Vsop87.LnVsop(4.5503E-6, 2.59321031027, 490.3340891794), new Vsop87.LnVsop(4.36349E-6, 2.08129398068, 51.2057253312), new Vsop87.LnVsop(4.35759E-6, 2.79444435294, 75.7448064138), new Vsop87.LnVsop(3.2348E-6, 4.82939220481, 195.1398481733), new Vsop87.LnVsop(3.59344E-6, 0.00870449102, 35.4247226521), new Vsop87.LnVsop(4.29078E-6, 3.08057776747, 41.1019810544), new Vsop87.LnVsop(3.19986E-6, 5.48621997496, 14.977853527), new Vsop87.LnVsop(4.13961E-6, 0.08822621279, 258.0244132148), new Vsop87.LnVsop(3.79728E-6, 0.05834508997, 378.6432952517), new Vsop87.LnVsop(4.20206E-6, 2.25392348451, 81.0013736908), new Vsop87.LnVsop(3.57527E-6, 4.71408309367, 173.9422195228), new Vsop87.LnVsop(3.58938E-6, 0.35269536425, 426.598190876), new Vsop87.LnVsop(4.05369E-6, 6.12344979469, 24.3790223882), new Vsop87.LnVsop(3.65088E-6, 5.59471873032, 255.0554677982), new Vsop87.LnVsop(3.08155E-6, 3.92316644086, 116.4260963429), new Vsop87.LnVsop(3.25546E-6, 4.71973290837, 134.5853436076), new Vsop87.LnVsop(2.92775E-6, 3.99521624654, 72.3339180125), new Vsop87.LnVsop(3.86408E-6, 0.68629232964, 230.5645708254), new Vsop87.LnVsop(3.0558E-6, 3.76131538046, 344.7030453079), new Vsop87.LnVsop(2.86849E-6, 1.8498761975, 153.4953503977), new Vsop87.LnVsop(3.53346E-6, 4.65720677156, 329.8370663655), new Vsop87.LnVsop(3.01835E-6, 0.13173596285, 565.1156877467), new Vsop87.LnVsop(2.41282E-6, 1.6040006132, 81.3738807063), new Vsop87.LnVsop(2.49797E-6, 4.24206827815, 75.3028634291), new Vsop87.LnVsop(2.45219E-6, 5.94902281852, 20.6069278195), new Vsop87.LnVsop(2.48331E-6, 1.06282358803, 105.4922706636), new Vsop87.LnVsop(3.05353E-6, 2.55534744586, 6208.2942514241), new Vsop87.LnVsop(2.9637E-6, 4.21095612809, 1364.7280995819), new Vsop87.LnVsop(2.19939E-6, 2.96120542961, 120.358249606), new Vsop87.LnVsop(2.33643E-6, 2.97217201792, 46.2097904851), new Vsop87.LnVsop(2.62427E-6, 3.83657820849, 831.1049812242), new Vsop87.LnVsop(2.33512E-6, 4.47917715806, 628.8515860501), new Vsop87.LnVsop(1.87419E-6, 3.03519991355, 135.5485514541), new Vsop87.LnVsop(2.168E-6, 3.42879551504, 241.6102710893), new Vsop87.LnVsop(2.5579E-6, 1.16711533037, 177.8743727859), new Vsop87.LnVsop(2.20463E-6, 0.19626840245, 180.2738692309), new Vsop87.LnVsop(2.24582E-6, 0.4067414402, 114.3991069134), new Vsop87.LnVsop(2.05687E-6, 2.30385491694, 259.5088859231), new Vsop87.LnVsop(2.11135E-6, 4.93079268569, 103.0927742186), new Vsop87.LnVsop(1.75625E-6, 5.51167774427, 7.1135470008), new Vsop87.LnVsop(1.88093E-6, 2.23534719993, 5.4166259714), new Vsop87.LnVsop(1.71643E-6, 5.21732384809, 41.6444977756), new Vsop87.LnVsop(1.76103E-6, 1.95966779423, 756.3233826569), new Vsop87.LnVsop(1.70321E-6, 4.95071878484, 206.1855484372), new Vsop87.LnVsop(1.69478E-6, 4.04293214414, 55.6591434561), new Vsop87.LnVsop(2.19016E-6, 0.24791955037, 294.6729761443), new Vsop87.LnVsop(1.8779E-6, 2.04529505651, 408.4389436113), new Vsop87.LnVsop(1.82258E-6, 0.70728907628, 391.1734682239), new Vsop87.LnVsop(1.91808E-6, 5.76676964168, 291.7040307277), new Vsop87.LnVsop(1.53646E-6, 4.7065704527, 543.0242872189), new Vsop87.LnVsop(1.69989E-6, 4.50972133596, 288.0806940053), new Vsop87.LnVsop(1.63761E-6, 5.22511628213, 67.3592350258), new Vsop87.LnVsop(1.94295E-6, 6.11711108749, 414.0680179038), new Vsop87.LnVsop(1.68295E-6, 5.25802294337, 518.6452648307), new Vsop87.LnVsop(1.56891E-6, 0.66346387654, 220.4126424388), new Vsop87.LnVsop(1.82269E-6, 0.78381581992, 417.0369633204), new Vsop87.LnVsop(1.675E-6, 4.92284198283, 422.6660376129), new Vsop87.LnVsop(1.70706E-6, 2.30954371717, 98.8999885246), new Vsop87.LnVsop(1.61764E-6, 3.27144223053, 443.8636662634), new Vsop87.LnVsop(1.33098E-6, 2.88847467964, 373.9079928365), new Vsop87.LnVsop(1.61139E-6, 3.82341819072, 451.9404211107), new Vsop87.LnVsop(1.79288E-6, 4.82418428313, 366.485629295), new Vsop87.LnVsop(1.78253E-6, 3.98045379191, 10138.5039476437), new Vsop87.LnVsop(1.42045E-6, 1.2689265649, 159.1244246902), new Vsop87.LnVsop(1.53749E-6, 4.27847447687, 45.5766510387), new Vsop87.LnVsop(1.61285E-6, 4.99511779244, 73.8183907208), new Vsop87.LnVsop(1.46245E-6, 2.65555668221, 465.9550667912), new Vsop87.LnVsop(1.24849E-6, 4.30472570922, 339.2864193365), new Vsop87.LnVsop(1.54661E-6, 4.32026115082, 760.25553592), new Vsop87.LnVsop(1.42885E-6, 2.07772801387, 457.8783119439), new Vsop87.LnVsop(1.52257E-6, 4.64725594465, 155.7829722581), new Vsop87.LnVsop(1.16813E-6, 4.43623541426, 5.9378908332), new Vsop87.LnVsop(1.1336E-6, 4.65468501147, 80.1982245387), new Vsop87.LnVsop(1.08272E-6, 3.76939374352, 142.4496501338), new Vsop87.LnVsop(1.3356E-6, 5.30624966763, 14.0146456805), new Vsop87.LnVsop(1.1629E-6, 2.51243579606, 296.1574488526), new Vsop87.LnVsop(1.29281E-6, 0.36073764928, 96.8729990951), new Vsop87.LnVsop(1.22859E-6, 2.38440865925, 141.4864422873), new Vsop87.LnVsop(1.01683E-6, 1.05650638045, 92.3077063856), new Vsop87.LnVsop(1.14628E-6, 6.24869783552, 767.3690829208), new Vsop87.LnVsop(1.13301E-6, 0.83046410321, 100.3844612329), new Vsop87.LnVsop(1.07414E-6, 2.39445059446, 347.8844390456), new Vsop87.LnVsop(9.5213E-7, 0.79902536632, 342.2553647531), new Vsop87.LnVsop(1.1111E-6, 0.38500786215, 216.9224321604), new Vsop87.LnVsop(1.27294E-6, 0.4239525152, 331.3215390738), new Vsop87.LnVsop(1.12636E-6, 0.08107841996, 558.0021407459), new Vsop87.LnVsop(1.03166E-6, 0.69792291595, 358.9301393095), new Vsop87.LnVsop(1.11707E-6, 0.75072196369, 80.7194894005), new Vsop87.LnVsop(9.0912E-7, 5.16491055574, 144.1465711632), new Vsop87.LnVsop(9.0696E-7, 0.2213237742, 333.657345044), new Vsop87.LnVsop(9.8568E-7, 4.33164222339, 74.5209661364), new Vsop87.LnVsop(8.9282E-7, 2.18851161054, 74.8297826771), new Vsop87.LnVsop(1.17046E-6, 3.94988763259, 74.2603337055), new Vsop87.LnVsop(8.9282E-7, 5.87783530506, 74.7334144575), new Vsop87.LnVsop(9.7479E-7, 0.69714600982, 977.4867846211), new Vsop87.LnVsop(1.16587E-6, 1.83677031992, 1289.9465010146), new Vsop87.LnVsop(8.5652E-7, 5.79984896939, 6.592282139), new Vsop87.LnVsop(8.6998E-7, 5.61960123914, 300.6108669775), new Vsop87.LnVsop(1.05424E-6, 5.94521818668, 328.3525936572), new Vsop87.LnVsop(1.12185E-6, 1.21210217535, 329.7251917809), new Vsop87.LnVsop(8.2982E-7, 2.20797412496, 74.9416572617), new Vsop87.LnVsop(9.4527E-7, 4.54115315196, 28.5718080822), new Vsop87.LnVsop(1.06878E-6, 1.82068770403, 306.830642101), new Vsop87.LnVsop(1.03534E-6, 2.9937266237, 6.2197751235), new Vsop87.LnVsop(1.06186E-6, 0.81603278109, 1087.6931058405), new Vsop87.LnVsop(7.7777E-7, 2.73309413665, 110.2063212194), new Vsop87.LnVsop(9.8378E-7, 3.73478755861, 75.0422309982), new Vsop87.LnVsop(8.5982E-7, 2.83236465462, 983.1158589136), new Vsop87.LnVsop(8.9038E-7, 4.73790965769, 604.4725636619), new Vsop87.LnVsop(8.3329E-7, 1.88332319315, 387.2413149608), new Vsop87.LnVsop(8.516E-7, 1.25690280514, 142.1408335931), new Vsop87.LnVsop(9.0074E-7, 3.8029787264, 986.0848043302), new Vsop87.LnVsop(7.4695E-7, 1.35103014238, 350.3321196004), new Vsop87.LnVsop(9.0483E-7, 0.36671354002, 0.9632078465), new Vsop87.LnVsop(9.5775E-7, 5.54841186043, 969.6224780949), new Vsop87.LnVsop(8.2748E-7, 5.85591719177, 74.6215398729), new Vsop87.LnVsop(7.5723E-7, 2.78001204936, 88.1149206916), new Vsop87.LnVsop(8.4009E-7, 1.84380973979, 227.3137411185), new Vsop87.LnVsop(7.0483E-7, 4.65532969655, 44.7253177768), new Vsop87.LnVsop(7.1348E-7, 3.65007988636, 894.8408795276), new Vsop87.LnVsop(9.4503E-7, 4.98848650229, 403.1341922245), new Vsop87.LnVsop(8.9085E-7, 4.43916822737, 154.0166152595), new Vsop87.LnVsop(7.939E-7, 5.66990936464, 267.4737661858), new Vsop87.LnVsop(7.5695E-7, 5.40808174797, 50.4025761791), new Vsop87.LnVsop(6.8583E-7, 4.76679841387, 991.7138786227), new Vsop87.LnVsop(6.5256E-7, 0.69286492023, 152.7445908723), new Vsop87.LnVsop(6.2931E-7, 2.90223286898, 79.889407998), new Vsop87.LnVsop(6.4054E-7, 0.09529052033, 681.5417840896), new Vsop87.LnVsop(8.0142E-7, 2.97521726739, 526.722019678), new Vsop87.LnVsop(6.9651E-7, 3.95227500507, 187.6962327724), new Vsop87.LnVsop(5.9427E-7, 3.59867941503, 58.1068240109), new Vsop87.LnVsop(5.924E-7, 0.51080685499, 28.3111756513), new Vsop87.LnVsop(6.8652E-7, 2.41879555463, 235.3904959658), new Vsop87.LnVsop(6.6216E-7, 5.04460437297, 30.7106720963), new Vsop87.LnVsop(7.0223E-7, 3.73647394236, 546.956440482), new Vsop87.LnVsop(6.6829E-7, 0.85504819327, 522.5774180938), new Vsop87.LnVsop(6.2028E-7, 2.3155351706, 74.0308390419), new Vsop87.LnVsop(6.2958E-7, 0.29182779746, 119.5069163441), new Vsop87.LnVsop(7.1477E-7, 3.16924790922, 23.5758732361), new Vsop87.LnVsop(7.4807E-7, 5.36814054526, 373.0142209592), new Vsop87.LnVsop(6.3852E-7, 2.36782311698, 157.6399519819), new Vsop87.LnVsop(7.0614E-7, 0.5585579503, 92.940845832), new Vsop87.LnVsop(5.5762E-7, 5.27011035858, 874.3940104025), new Vsop87.LnVsop(7.5741E-7, 4.66371340256, 101.8689339412), new Vsop87.LnVsop(7.3741E-7, 6.20569442158, 312.4597163935), new Vsop87.LnVsop(7.2959E-7, 0.58417048033, 367.9701020033), new Vsop87.LnVsop(5.3182E-7, 2.24688972584, 17.5261078183), new Vsop87.LnVsop(6.3238E-7, 4.59765034931, 67.8804998876), new Vsop87.LnVsop(6.0717E-7, 0.57546407104, 253.5709950899), new Vsop87.LnVsop(5.284E-7, 2.45780676537, 264.5048207692), new Vsop87.LnVsop(7.0508E-7, 1.51929972323, 552.5855147745), new Vsop87.LnVsop(6.8624E-7, 2.4450775445, 555.5544601911), new Vsop87.LnVsop(6.2796E-7, 0.33786296182, 561.1835344836), new Vsop87.LnVsop(4.9353E-7, 1.09630903572, 19.1224551112), new Vsop87.LnVsop(6.4619E-7, 5.27406291626, 68.1893164283), new Vsop87.LnVsop(6.2909E-7, 5.35706460122, 92.0470739547), new Vsop87.LnVsop(4.764E-7, 3.90841810802, 192.6921676185), new Vsop87.LnVsop(6.5137E-7, 3.73959418275, 536.8045120954), new Vsop87.LnVsop(6.5253E-7, 4.24102184816, 771.3012361839), new Vsop87.LnVsop(5.9404E-7, 6.10556142565, 365.0011565867), new Vsop87.LnVsop(5.2269E-7, 1.71514378709, 905.8865797915), new Vsop87.LnVsop(4.5962E-7, 3.874335532, 210.3301500214), new Vsop87.LnVsop(6.216E-7, 2.68143699514, 130.4407420234), new Vsop87.LnVsop(4.6457E-7, 5.97440565334, 477.8039162072), new Vsop87.LnVsop(4.6176E-7, 3.89655419144, 48.7580447764), new Vsop87.LnVsop(4.2915E-7, 3.81993104061, 61.2882177486), new Vsop87.LnVsop(4.7152E-7, 0.99574606527, 166.828672522), new Vsop87.LnVsop(5.3843E-7, 2.867487359, 353.301065017), new Vsop87.LnVsop(4.2114E-7, 2.61910843789, 90.8232336773), new Vsop87.LnVsop(5.261E-7, 2.97705829152, 383.0967133766), new Vsop87.LnVsop(4.318E-7, 4.15850225489, 173.6815870919), new Vsop87.LnVsop(4.1297E-7, 1.7992397018, 149.45132255), new Vsop87.LnVsop(4.4964E-7, 1.76623473669, 0.5212648618), new Vsop87.LnVsop(4.2836E-7, 1.56965438447, 120.9913890524), new Vsop87.LnVsop(4.9794E-7, 4.03361534543, 303.8616966844), new Vsop87.LnVsop(4.5233E-7, 3.5777862545, 97.4155158163), new Vsop87.LnVsop(3.8695E-7, 2.3940421117, 31.492569389), new Vsop87.LnVsop(3.8067E-7, 5.79467736188, 75.5323580927), new Vsop87.LnVsop(5.0252E-7, 4.7645830025, 911.3032057629), new Vsop87.LnVsop(5.0884E-7, 5.15513957128, 439.782755154), new Vsop87.LnVsop(4.282E-7, 5.17313041477, 162.0933701068), new Vsop87.LnVsop(4.2805E-7, 0.84360648676, 58.319272332), new Vsop87.LnVsop(5.0343E-7, 5.81599953406, 66.9172920411), new Vsop87.LnVsop(3.5657E-7, 1.87511529678, 472.1748419147), new Vsop87.LnVsop(4.5667E-7, 1.9211081498, 55.1378785943), new Vsop87.LnVsop(3.9992E-7, 1.74263755793, 89.7594520943), new Vsop87.LnVsop(4.9427E-7, 1.89225881347, 42.5864537627), new Vsop87.LnVsop(4.4919E-7, 1.48348147872, 450.9772132642), new Vsop87.LnVsop(3.4282E-7, 5.20397534102, 316.3918696566), new Vsop87.LnVsop(4.6407E-7, 0.33922791761, 273.1028404783), new Vsop87.LnVsop(3.7265E-7, 2.03623179153, 117.9105690512), new Vsop87.LnVsop(4.6107E-7, 5.62298858989, 1819.6374661092), new Vsop87.LnVsop(3.9368E-7, 4.19402801195, 486.4019359163), new Vsop87.LnVsop(4.1044E-7, 4.82988044777, 149.6750717192), new Vsop87.LnVsop(4.4959E-7, 0.72694662195, 3265.8308281325), new Vsop87.LnVsop(4.3756E-7, 0.75422118122, 404.6186649328), new Vsop87.LnVsop(3.1823E-7, 3.84768075664, 20.4468691251), new Vsop87.LnVsop(4.4288E-7, 4.36757729571, 418.2608035978), new Vsop87.LnVsop(3.8E-7, 3.03175184245, 167.0893049529), new Vsop87.LnVsop(4.3649E-7, 1.57339867295, 491.5579294568), new Vsop87.LnVsop(3.3721E-7, 1.26383804364, 260.9933586314), new Vsop87.LnVsop(3.1278E-7, 4.16119477825, 13.3333221243), new Vsop87.LnVsop(3.651E-7, 2.58786153975, 68.5618234438), new Vsop87.LnVsop(3.9768E-7, 2.8636569438, 468.2426886516), new Vsop87.LnVsop(3.629E-7, 1.35814658055, 59.2824801785), new Vsop87.LnVsop(3.2168E-7, 3.12118521629, 103.3534066495), new Vsop87.LnVsop(3.3633E-7, 0.15841728793, 24.1183899573), new Vsop87.LnVsop(3.3723E-7, 0.75503571162, 290.2195580194), new Vsop87.LnVsop(2.975E-7, 5.33159349844, 1033.3583763983), new Vsop87.LnVsop(3.1989E-7, 4.67688193416, 205.2223405907), new Vsop87.LnVsop(3.5268E-7, 1.00718464333, 1108.1399749656), new Vsop87.LnVsop(3.0858E-7, 4.62657701145, 258.8757464767), new Vsop87.LnVsop(3.285E-7, 5.25352681937, 114.1384744825), new Vsop87.LnVsop(3.3452E-7, 3.40494756837, 43.1289704839), new Vsop87.LnVsop(3.1092E-7, 2.26716508311, 104.0077979553), new Vsop87.LnVsop(2.9723E-7, 5.64053362927, 254.9435932136), new Vsop87.LnVsop(3.1576E-7, 3.7823710623, 152.0108776894), new Vsop87.LnVsop(3.4573E-7, 5.17385991822, 25.6028626656), new Vsop87.LnVsop(2.8153E-7, 3.9268752386, 199.2844497575), new Vsop87.LnVsop(2.8415E-7, 1.76927009458, 820.0592809603), new Vsop87.LnVsop(2.8971E-7, 2.58260543469, 76.4785195967), new Vsop87.LnVsop(3.3643E-7, 5.79472403547, 274.0660483248), new Vsop87.LnVsop(3.1355E-7, 1.39422550951, 178.7893965226), new Vsop87.LnVsop(2.9433E-7, 5.93671324356, 280.9671470045), new Vsop87.LnVsop(3.0136E-7, 0.443733256, 27.0873353739), new Vsop87.LnVsop(3.3815E-7, 6.26141095251, 401.6497195162), new Vsop87.LnVsop(2.7513E-7, 2.15290154943, 480.7728616238), new Vsop87.LnVsop(2.6821E-7, 2.51632690244, 123.5396433437), new Vsop87.LnVsop(2.6229E-7, 0.22582956326, 286.596221297), new Vsop87.LnVsop(2.6562E-7, 3.88341102553, 372.4235201282), new Vsop87.LnVsop(3.4017E-7, 1.44565808735, 88.7962442478), new Vsop87.LnVsop(2.774E-7, 4.64687309709, 198.321241911), new Vsop87.LnVsop(2.9859E-7, 0.82891399431, 100.6450936638), new Vsop87.LnVsop(3.3948E-7, 1.14432761269, 82.4858463991), new Vsop87.LnVsop(2.6493E-7, 1.98025893553, 95.3885263868), new Vsop87.LnVsop(2.4352E-7, 2.37812752505, 146.3818033969), new Vsop87.LnVsop(2.7244E-7, 2.10487988447, 1057.8974574809), new Vsop87.LnVsop(2.6337E-7, 0.39684584427, 106.0135355254), new Vsop87.LnVsop(2.4101E-7, 6.21637542402, 16.6747745564), new Vsop87.LnVsop(3.1013E-7, 5.3398578805, 476.4313180835), new Vsop87.LnVsop(2.7036E-7, 0.71198582048, 248.7238180901), new Vsop87.LnVsop(2.3868E-7, 3.42162769068, 1044.4040766622), new Vsop87.LnVsop(2.9026E-7, 3.98796449555, 908.3342603463), new Vsop87.LnVsop(2.4251E-7, 0.36629105441, 73.1852512744), new Vsop87.LnVsop(2.2897E-7, 2.26875155959, 175.1660598002), new Vsop87.LnVsop(2.8024E-7, 3.46485782344, 1439.5096981492), new Vsop87.LnVsop(2.2051E-7, 0.05165872393, 33.1371007917), new Vsop87.LnVsop(2.2208E-7, 5.32236354206, 483.2205421786), new Vsop87.LnVsop(2.1075E-7, 0.37096066639, 214.7835681463), new Vsop87.LnVsop(2.0699E-7, 1.79611118091, 118.0224436358), new Vsop87.LnVsop(2.7443E-7, 5.75986647976, 1215.1649024473), new Vsop87.LnVsop(2.5481E-7, 5.4969198547, 115.8835796217), new Vsop87.LnVsop(2.7703E-7, 4.1192830645, 694.0719570618), new Vsop87.LnVsop(2.4828E-7, 0.6523800562, 132.8884225782), new Vsop87.LnVsop(2.1295E-7, 3.86501877873, 66.1835788582), new Vsop87.LnVsop(2.1146E-7, 1.13726745832, 60.5545045657), new Vsop87.LnVsop(2.3959E-7, 4.56157429146, 458.8415197904), new Vsop87.LnVsop(2.6221E-7, 2.77532838847, 490.0734567485), new Vsop87.LnVsop(2.2973E-7, 4.52937663566, 78.4049352897), new Vsop87.LnVsop(2.5273E-7, 3.64987288394, 73.4090004436), new Vsop87.LnVsop(2.6408E-7, 3.3724051836, 49.7212526229), new Vsop87.LnVsop(2.687E-7, 3.26028443561, 691.1030116452), new Vsop87.LnVsop(2.1053E-7, 5.54284102969, 129.9194771616), new Vsop87.LnVsop(2.0861E-7, 3.92598175503, 134.0640787458), new Vsop87.LnVsop(2.2933E-7, 5.02405062369, 150.5264049811), new Vsop87.LnVsop(2.298E-7, 2.5672758855, 332.8060117821), new Vsop87.LnVsop(2.0836E-7, 0.98988990409, 29.2049475286), new Vsop87.LnVsop(1.8891E-7, 1.91272305963, 124.5028511902), new Vsop87.LnVsop(1.8755E-7, 1.07911898423, 70.1157321213), new Vsop87.LnVsop(2.3454E-7, 0.60524375676, 189.7232222019), new Vsop87.LnVsop(2.3104E-7, 3.93171225238, 43.2890291783), new Vsop87.LnVsop(1.9351E-7, 1.33568544736, 616.3214130779), new Vsop87.LnVsop(2.3769E-7, 0.02170705684, 593.426863398), new Vsop87.LnVsop(2.1258E-7, 0.90140026224, 326.8681209489), new Vsop87.LnVsop(1.9626E-7, 1.40914183189, 1589.0728952838), new Vsop87.LnVsop(1.8282E-7, 4.55112709109, 165.6048322446), new Vsop87.LnVsop(2.4502E-7, 0.91753157942, 441.2672278623), new Vsop87.LnVsop(2.4938E-7, 4.63474678982, 162.8965192589), new Vsop87.LnVsop(1.8904E-7, 1.23360547168, 13.4933808187), new Vsop87.LnVsop(1.7364E-7, 5.28602832892, 7.8643065262), new Vsop87.LnVsop(1.8603E-7, 5.11206439748, 81.8951455681), new Vsop87.LnVsop(1.7341E-7, 4.0647673679, 403.0223176399), new Vsop87.LnVsop(2.2513E-7, 3.15059944802, 419.7452763061), new Vsop87.LnVsop(1.7912E-7, 2.53786076055, 47.061123747), new Vsop87.LnVsop(2.1237E-7, 2.14856256664, 75.5847477194), new Vsop87.LnVsop(1.6995E-7, 2.48647736969, 2043.9822618111), new Vsop87.LnVsop(2.2639E-7, 2.07623129511, 699.7010313543), new Vsop87.LnVsop(2.3531E-7, 5.80237015057, 232.0490435337), new Vsop87.LnVsop(1.9255E-7, 1.5662120398, 425.1137181677), new Vsop87.LnVsop(2.2735E-7, 0.2827454276, 0.1118745846), new Vsop87.LnVsop(2.091E-7, 5.30767454224, 237.6781178262), new Vsop87.LnVsop(1.6146E-7, 3.45551692754, 0.7507595254), new Vsop87.LnVsop(2.1076E-7, 0.96002144676, 405.9912630565), new Vsop87.LnVsop(1.7963E-7, 1.60799681102, 215.4379594521), new Vsop87.LnVsop(1.6289E-7, 4.88888227946, 69.1525242748), new Vsop87.LnVsop(2.1756E-7, 3.23184546146, 1744.8558675419), new Vsop87.LnVsop(2.1708E-7, 0.88801367868, 344.9636777388), new Vsop87.LnVsop(1.5964E-7, 0.34537232571, 77.0692204277), new Vsop87.LnVsop(1.7286E-7, 6.02968524571, 32.2433289144), new Vsop87.LnVsop(1.5915E-7, 2.96605572794, 25.8634950965), new Vsop87.LnVsop(1.783E-7, 4.01479681257, 280.003939158), new Vsop87.LnVsop(1.4755E-7, 3.74119528291, 610.6923387854), new Vsop87.LnVsop(1.5023E-7, 4.24763459617, 228.276948965), new Vsop87.LnVsop(1.5326E-7, 0.22145354256, 17.2654753874), new Vsop87.LnVsop(1.5354E-7, 0.25482391126, 661.0949149645), new Vsop87.LnVsop(1.6424E-7, 3.43626239649, 147.1155165798), new Vsop87.LnVsop(1.4654E-7, 1.14175759154, 823.9914342234), new Vsop87.LnVsop(1.5172E-7, 5.07753627325, 114.9416236346), new Vsop87.LnVsop(1.4674E-7, 1.6817792116, 207.8824694666), new Vsop87.LnVsop(1.7682E-7, 5.94376629143, 624.919432787), new Vsop87.LnVsop(1.8848E-7, 1.3845654645, 377.1588225434), new Vsop87.LnVsop(1.5425E-7, 1.66489033237, 440.6822725257), new Vsop87.LnVsop(1.4513E-7, 0.39264401278, 142.6620984549), new Vsop87.LnVsop(1.4672E-7, 4.41834132435, 16.4623262353), new Vsop87.LnVsop(1.6992E-7, 0.16042368544, 438.2982824457), new Vsop87.LnVsop(1.6587E-7, 0.92058534977, 369.0820676961), new Vsop87.LnVsop(1.7239E-7, 4.51659362028, 606.7601855223), new Vsop87.LnVsop(1.3222E-7, 3.0434010617, 668.2084619653), new Vsop87.LnVsop(1.4458E-7, 2.93327046597, 419.4846438752), new Vsop87.LnVsop(1.3238E-7, 0.13650358961, 216.4804891757), new Vsop87.LnVsop(1.5722E-7, 4.93688742368, 124.2904028691), new Vsop87.LnVsop(1.2927E-7, 1.65950183059, 54.3347294422), new Vsop87.LnVsop(1.4216E-7, 4.41971117975, 47.6942631934), new Vsop87.LnVsop(1.2751E-7, 0.03041331624, 217.2312487011), new Vsop87.LnVsop(1.4006E-7, 3.6887047076, 16.04163511), new Vsop87.LnVsop(1.4718E-7, 1.08540409163, 49.5088043018), new Vsop87.LnVsop(1.7579E-7, 5.05617037261, 564.8550553158), new Vsop87.LnVsop(1.2945E-7, 1.53551413817, 218.9281697305), new Vsop87.LnVsop(1.3528E-7, 4.80158552555, 72.7758609972), new Vsop87.LnVsop(1.2546E-7, 3.43007050169, 958.576777831), new Vsop87.LnVsop(1.3034E-7, 0.56491831473, 1171.875873269), new Vsop87.LnVsop(1.2452E-7, 3.29205788475, 902.7051860538), new Vsop87.LnVsop(1.1963E-7, 1.41057536904, 55.7710180407), new Vsop87.LnVsop(1.647E-7, 2.04067746898, 411.620337349), new Vsop87.LnVsop(1.5604E-7, 1.53457514224, 833.552661779), new Vsop87.LnVsop(1.4914E-7, 3.42772092084, 19.0105805266), new Vsop87.LnVsop(1.204E-7, 5.17744918756, 135.336103133), new Vsop87.LnVsop(1.4349E-7, 4.18933467558, 89.338760969), new Vsop87.LnVsop(1.5553E-7, 3.54672509714, 113.8778420516), new Vsop87.LnVsop(1.5574E-7, 5.92871386562, 778.4147831847), new Vsop87.LnVsop(1.5424E-7, 2.12697366276, 106.2741679563), new Vsop87.LnVsop(1.1957E-7, 1.43314130608, 455.8725743738), new Vsop87.LnVsop(1.5933E-7, 5.49557852242, 513.079881013), new Vsop87.LnVsop(1.3562E-7, 4.11426797137, 95.2284676924), new Vsop87.LnVsop(1.2063E-7, 0.20881650176, 65.8747623175), new Vsop87.LnVsop(1.5093E-7, 1.86345091876, 7.7042478318), new Vsop87.LnVsop(1.5832E-7, 3.42498484109, 79.5169009825), new Vsop87.LnVsop(1.1492E-7, 4.6518745562, 149.6113812444), new Vsop87.LnVsop(1.4516E-7, 3.35209961643, 19.643719973), new Vsop87.LnVsop(1.1406E-7, 1.31085455047, 63.6240237188), new Vsop87.LnVsop(1.2043E-7, 0.01569453703, 397.3932433474), new Vsop87.LnVsop(1.4157E-7, 1.87440535402, 6283.0758499914), new Vsop87.LnVsop(1.1355E-7, 0.19026820825, 5.6290742925), new Vsop87.LnVsop(1.4109E-7, 0.09348109699, 6133.5126528568), new Vsop87.LnVsop(1.1659E-7, 0.84853578994, 5.1078094307), new Vsop87.LnVsop(1.1052E-7, 0.47607339293, 150.0844619964), new Vsop87.LnVsop(1.3908E-7, 5.6551430952, 639.897286314), new Vsop87.LnVsop(1.1505E-7, 5.1947564228, 1182.9215735329), new Vsop87.LnVsop(1.1492E-7, 2.05801478182, 149.5150130248), new Vsop87.LnVsop(1.4974E-7, 3.54838066958, 252.6559713532), new Vsop87.LnVsop(1.155E-7, 4.78304722906, 334.2904844904), new Vsop87.LnVsop(1.0671E-7, 4.67373109923, 149.723255829), new Vsop87.LnVsop(1.0855E-7, 4.52379396618, 453.9461586808), new Vsop87.LnVsop(1.4218E-7, 0.08018756427, 240.3864308119), new Vsop87.LnVsop(1.1896E-7, 1.4080319722, 26.0235537909), new Vsop87.LnVsop(1.3388E-7, 0.76174926716, 37.8724032069), new Vsop87.LnVsop(1.086E-7, 4.40226202285, 57.1436161644), new Vsop87.LnVsop(1.0722E-7, 5.34547451937, 331.2096644892), new Vsop87.LnVsop(1.2796E-7, 3.70341837855, 67.0773507355), new Vsop87.LnVsop(1.3353E-7, 0.86919663716, 22.8945496799), new Vsop87.LnVsop(1.0568E-7, 5.80969806479, 193.655375465), new Vsop87.LnVsop(1.0324E-7, 2.99970080363, 525.7588118315), new Vsop87.LnVsop(1.1331E-7, 3.11771273798, 93.9040536785), new Vsop87.LnVsop(1.431E-7, 1.06766336398, 477.9157907918), new Vsop87.LnVsop(1.0296E-7, 3.8144746384, 180.1619946463), new Vsop87.LnVsop(1.2341E-7, 4.62813430525, 1894.4190646765), new Vsop87.LnVsop(1.1464E-7, 0.93530139587, 121.8427223143), new Vsop87.LnVsop(1.2833E-7, 0.31985851817, 474.9468453752), new Vsop87.LnVsop(1.2455E-7, 2.84950981207, 184.0941479094), new Vsop87.LnVsop(1.173E-7, 1.07977388266, 363.5166838784), new Vsop87.LnVsop(1.0287E-7, 6.03277961834, 43.2408450685), new Vsop87.LnVsop(1.1395E-7, 4.25533440684, 181.0557665236), new Vsop87.LnVsop(1.0426E-7, 1.46990536801, 80.4106728598), new Vsop87.LnVsop(1.002E-7, 6.22580063292, 84.1827674285), new Vsop87.LnVsop(1.3895E-7, 3.4634353626, 157.2674449664), new Vsop87.LnVsop(9.893E-8, 2.72218970897, 384.0599212231), new Vsop87.LnVsop(1.0719E-7, 2.47554935503, 140.6563608848), new Vsop87.LnVsop(1.0964E-7, 3.74557708007, 494.2662424425), new Vsop87.LnVsop(1.2104E-7, 2.69878200554, 369.4545747116), new Vsop87.LnVsop(9.686E-8, 0.0069758008, 40.1600250673), new Vsop87.LnVsop(1.2385E-7, 1.71007866936, 229.0800981171), new Vsop87.LnVsop(1.2577E-7, 4.66630955474, 64.6991061499), new Vsop87.LnVsop(1.065E-7, 1.78642598254, 252.0865223816), new Vsop87.LnVsop(1.1653E-7, 5.70662425749, 39.0962434843), new Vsop87.LnVsop(1.1004E-7, 3.58723041577, 449.2802922348), new Vsop87.LnVsop(1.0454E-7, 2.81847601796, 1246.6574718363), new Vsop87.LnVsop(9.326E-8, 0.97605558757, 109.3125493421), new Vsop87.LnVsop(9.261E-8, 5.19861935669, 749.2098356561), new Vsop87.LnVsop(9.811E-8, 3.72249796639, 233.9060232575), new Vsop87.LnVsop(1.0264E-7, 6.08657486312, 156.1554792736), new Vsop87.LnVsop(1.2406E-7, 0.7620799857, 122.4758617607), new Vsop87.LnVsop(1.0249E-7, 2.86919673355, 189.1807054807), new Vsop87.LnVsop(1.2671E-7, 6.19797274264, 149.8238295655), new Vsop87.LnVsop(9.589E-8, 1.00839074495, 393.4610900843), new Vsop87.LnVsop(9.106E-8, 5.53296926826, 133.1008708993), new Vsop87.LnVsop(1.0449E-7, 1.23520879648, 148.5999892881), new Vsop87.LnVsop(9.923E-8, 5.65994205559, 42.5382696529), new Vsop87.LnVsop(1.237E-7, 5.2960237032, 20.4950532349), new Vsop87.LnVsop(1.0304E-7, 3.56303132976, 619.2903584945), new Vsop87.LnVsop(1.1103E-7, 5.89715087659, 832.5894539325), new Vsop87.LnVsop(9.313E-8, 3.00333916453, 754.8389099486), new Vsop87.LnVsop(1.0342E-7, 5.50503668014, 460.5384408198), new Vsop87.LnVsop(1.2219E-7, 3.17057317997, 30.0562807905), new Vsop87.LnVsop(8.998E-8, 5.82877688374, 248.4631856592), new Vsop87.LnVsop(1.0082E-7, 1.9111904865, 25.0603459444), new Vsop87.LnVsop(1.0991E-7, 0.05720554764, 54.2865453324), new Vsop87.LnVsop(8.638E-8, 5.49106676064, 448.6895914038), new Vsop87.LnVsop(9.39E-8, 1.32674472289, 9.4011688612), new Vsop87.LnVsop(9.621E-8, 5.6909029939, 73.88782669), new Vsop87.LnVsop(1.0975E-7, 4.40051429814, 63.847772888), new Vsop87.LnVsop(8.365E-8, 3.2694361084, 172.1971143836), new Vsop87.LnVsop(9.674E-8, 4.27052644727, 282.6640680339), new Vsop87.LnVsop(1.077E-7, 0.19304986906, 463.5073862364), new Vsop87.LnVsop(1.0666E-7, 1.42510087091, 268.4369740323), new Vsop87.LnVsop(1.0567E-7, 2.61602525339, 446.3113468182), new Vsop87.LnVsop(8.495E-8, 5.03708799595, 370.9390474199), new Vsop87.LnVsop(9.888E-8, 4.25430313596, 602.9880909536), new Vsop87.LnVsop(1.0101E-7, 5.04200998723, 241.8709035202), new Vsop87.LnVsop(8.89E-8, 2.5332074673, 271.4059194489), new Vsop87.LnVsop(9.08E-8, 0.99121734894, 6.9010986797), new Vsop87.LnVsop(1.0416E-7, 4.96315418372, 97.6761482472), new Vsop87.LnVsop(8.79E-8, 3.05434837439, 291.262087743), new Vsop87.LnVsop(7.936E-8, 5.71233384542, 541.5398145106), new Vsop87.LnVsop(1.0152E-7, 1.90464684114, 91.4563731237), new Vsop87.LnVsop(7.939E-8, 0.88279344814, 154.979823106), new Vsop87.LnVsop(8.212E-8, 0.00845991197, 76.42612997), new Vsop87.LnVsop(7.965E-8, 2.36308659035, 196.6243208816), new Vsop87.LnVsop(8.948E-8, 4.31891786278, 469.1364605289), new Vsop87.LnVsop(8.46E-8, 0.14600703561, 262.4778313397), new Vsop87.LnVsop(9.878E-8, 0.61245182735, 308.3151148093), new Vsop87.LnVsop(9.12E-8, 5.03217831219, 450.4559484024), new Vsop87.LnVsop(1.0276E-7, 3.58321573131, 842.1506814881), new Vsop87.LnVsop(8.153E-8, 4.60445400464, 69.6737891366), new Vsop87.LnVsop(1.0625E-7, 2.28659627239, 194.2885149114), new Vsop87.LnVsop(7.552E-8, 4.86800510971, 1097.0942747017), new Vsop87.LnVsop(9.019E-8, 0.69841869766, 685.4739373527), new Vsop87.LnVsop(7.451E-8, 5.67442696266, 337.8019466282), new Vsop87.LnVsop(8.011E-8, 4.33417263028, 302.0953396858), new Vsop87.LnVsop(9.132E-8, 1.09206046595, 93.7921790939), new Vsop87.LnVsop(9.342E-8, 4.16662386065, 15.4991183888), new Vsop87.LnVsop(7.411E-8, 3.04632695464, 7.4223635415), new Vsop87.LnVsop(1.0072E-7, 1.18952866918, 621.7380390493), new Vsop87.LnVsop(8.913E-8, 1.33679256423, 0.2606324309), new Vsop87.LnVsop(8.189E-8, 3.16576794671, 32.7164096664), new Vsop87.LnVsop(7.85E-8, 4.37236255826, 464.4705940829), new Vsop87.LnVsop(8.734E-8, 2.03651704284, 149.4031384402), new Vsop87.LnVsop(7.745E-8, 0.14834225031, 1404.0849754971), new Vsop87.LnVsop(9.037E-8, 3.53203542312, 636.6677084665), new Vsop87.LnVsop(1.0212E-7, 2.58904966897, 711.4493070338), new Vsop87.LnVsop(8.569E-8, 2.47926109895, 497.4476361802), new Vsop87.LnVsop(9.591E-8, 1.33938357595, 142.9709149956), new Vsop87.LnVsop(7.613E-8, 1.86876737547, 31.6526280834), new Vsop87.LnVsop(8.723E-8, 5.88916926012, 82.2039621088), new Vsop87.LnVsop(8.997E-8, 2.37079010824, 76.154196691), new Vsop87.LnVsop(7.128E-8, 6.2445038363, 376.1956146969), new Vsop87.LnVsop(9.686E-8, 5.67475763163, 98.3574718034), new Vsop87.LnVsop(9.993E-8, 4.91667894523, 829.6205085159), new Vsop87.LnVsop(7.745E-8, 4.87945477576, 310.1720945331), new Vsop87.LnVsop(9.812E-8, 3.78656280821, 838.218528225), new Vsop87.LnVsop(8.785E-8, 6.14514661123, 17.6379824029), new Vsop87.LnVsop(9.5E-8, 6.02030079251, 916.9322800554), new Vsop87.LnVsop(8.44E-8, 5.06400284478, 1.3725981237), new Vsop87.LnVsop(9.802E-8, 1.92874890805, 62.7726904569), new Vsop87.LnVsop(7.059E-8, 5.91499106809, 74.1484591209), new Vsop87.LnVsop(7.016E-8, 1.52544072246, 679.2541622292), new Vsop87.LnVsop(9.577E-8, 1.44268080407, 763.4369296577), new Vsop87.LnVsop(9.562E-8, 1.97733085047, 703.6331846174), new Vsop87.LnVsop(7.059E-8, 1.94098053303, 75.4147380137), new Vsop87.LnVsop(9.214E-8, 0.88741799785, 362.8622925726), new Vsop87.LnVsop(6.823E-8, 5.11460794174, 107.4980082337), new Vsop87.LnVsop(7.148E-8, 1.73466140387, 1190.7858800591), new Vsop87.LnVsop(9.073E-8, 4.31998777457, 16.1535096946), new Vsop87.LnVsop(9.126E-8, 3.74417362577, 4.665866446), new Vsop87.LnVsop(7.923E-8, 4.6451154044, 232.4215505492), new Vsop87.LnVsop(8.828E-8, 1.08177391234, 412.5835451955), new Vsop87.LnVsop(9.169E-8, 3.25102587429, 155.5010879678), new Vsop87.LnVsop(7.624E-8, 0.88232424215, 459.3627846522), new Vsop87.LnVsop(8.2E-8, 1.51866334745, 10063.7223490764), new Vsop87.LnVsop(8.005E-8, 6.13208431788, 745.277682393), new Vsop87.LnVsop(8.579E-8, 2.377262345, 75.6753704446), new Vsop87.LnVsop(7.597E-8, 2.63491731877, 657.1627617014), new Vsop87.LnVsop(6.398E-8, 0.61376490225, 73.2489417492), new Vsop87.LnVsop(7.149E-8, 1.33917289544, 236.8749686741), new Vsop87.LnVsop(6.577E-8, 4.82504547981, 1072.7152523135), new Vsop87.LnVsop(6.38E-8, 3.20688120531, 73.3453099688), new Vsop87.LnVsop(7.506E-8, 0.67400214407, 228.7982138268), new Vsop87.LnVsop(7.451E-8, 3.06064473161, 171.6545976624), new Vsop87.LnVsop(6.361E-8, 6.05108999867, 95.9792272178), new Vsop87.LnVsop(7.086E-8, 4.88497877319, 6531.661656265), new Vsop87.LnVsop(6.522E-8, 4.0143169552, 118.8737768977), new Vsop87.LnVsop(6.236E-8, 1.08169162104, 143.9341228421), new Vsop87.LnVsop(7.2E-8, 1.19830150903, 1617.3840709351), new Vsop87.LnVsop(6.373E-8, 3.2741194528, 116.5379709275), new Vsop87.LnVsop(6.15E-8, 0.03921300469, 627.3671133418), new Vsop87.LnVsop(8.664E-8, 5.60425824325, 2810.9214616052), new Vsop87.LnVsop(7.635E-8, 4.06598468585, 4.7353024152), new Vsop87.LnVsop(6.147E-8, 4.16482048084, 1300.9922012785), new Vsop87.LnVsop(7.471E-8, 0.45174255163, 192.8040422031), new Vsop87.LnVsop(8.148E-8, 3.11700641874, 10213.285546211), new Vsop87.LnVsop(8.603E-8, 3.80404544682, 25558.2121764796), new Vsop87.LnVsop(7.593E-8, 2.86863623528, 406.1031376411), new Vsop87.LnVsop(7.725E-8, 3.05989382335, 341.9947323222), new Vsop87.LnVsop(7.063E-8, 5.35078594952, 73.0364934281), new Vsop87.LnVsop(6.762E-8, 1.94867196735, 288.7350853111), new Vsop87.LnVsop(6.102E-8, 2.06174377751, 73.9784494152), new Vsop87.LnVsop(6.993E-8, 1.24520005325, 400.1652468079), new Vsop87.LnVsop(7.856E-8, 3.11320541136, 81.682697247), new Vsop87.LnVsop(6.731E-8, 0.00424999029, 572.2292347475), new Vsop87.LnVsop(6.688E-8, 0.03046234361, 90.2807169561), new Vsop87.LnVsop(7.766E-8, 2.87448427459, 79.4474650133), new Vsop87.LnVsop(7.668E-8, 1.71124875127, 104.5290628171), new Vsop87.LnVsop(8.317E-8, 2.40731767085, 674.8007441043), new Vsop87.LnVsop(6.793E-8, 1.29774355388, 22.633917249), new Vsop87.LnVsop(7.732E-8, 1.44266849755, 131.9252147317), new Vsop87.LnVsop(6.034E-8, 0.96635268225, 476.3194434989), new Vsop87.LnVsop(6.0E-8, 3.24980736635, 76.7873361374), new Vsop87.LnVsop(6.375E-8, 1.37050567525, 75.1541055828), new Vsop87.LnVsop(5.861E-8, 4.31971360878, 86.6304479833), new Vsop87.LnVsop(7.19E-8, 3.21396773403, 71.1582618449), new Vsop87.LnVsop(6.303E-8, 2.24129466051, 1310.3933701397), new Vsop87.LnVsop(6.628E-8, 1.990437442, 1.5963472929), new Vsop87.LnVsop(6.263E-8, 3.47620738623, 346.3999663373), new Vsop87.LnVsop(6.081E-8, 1.2659989052, 61.448276443), new Vsop87.LnVsop(7.312E-8, 5.48372849636, 50.66320861), new Vsop87.LnVsop(7.3E-8, 5.26774051203, 285.6330134505), new Vsop87.LnVsop(5.727E-8, 2.39389303582, 20277.0078952874), new Vsop87.LnVsop(7.776E-8, 5.47416512352, 416.7763308895), new Vsop87.LnVsop(5.693E-8, 1.13593628568, 445.3481389717), new Vsop87.LnVsop(5.794E-8, 2.43359359889, 180.7951340927), new Vsop87.LnVsop(6.927E-8, 4.19296597477, 525.2375469697), new Vsop87.LnVsop(7.681E-8, 5.64147063245, 549.7284439425), new Vsop87.LnVsop(6.68E-8, 5.36285833774, 452.4616859725), new Vsop87.LnVsop(7.677E-8, 0.71278975356, 44.070926471), new Vsop87.LnVsop(7.734E-8, 5.72717526802, 154.2984995498), new Vsop87.LnVsop(5.932E-8, 3.22993254909, 73.4571845534), new Vsop87.LnVsop(5.683E-8, 3.65029666464, 442.3791935551), new Vsop87.LnVsop(5.788E-8, 2.17544248991, 2.2876218604), new Vsop87.LnVsop(6.685E-8, 4.8497109273, 148.8124376092), new Vsop87.LnVsop(5.797E-8, 0.51568102763, 149.3025647037), new Vsop87.LnVsop(7.739E-8, 3.23104533276, 589.4947101349), new Vsop87.LnVsop(7.474E-8, 2.47202834062, 321.7603115182), new Vsop87.LnVsop(6.106E-8, 0.81922621826, 89.5993933999), new Vsop87.LnVsop(5.522E-8, 1.83812319711, 375.3924655448), new Vsop87.LnVsop(6.706E-8, 5.23367324742, 769.8167634756), new Vsop87.LnVsop(6.168E-8, 4.58379993316, 137.5542890242), new Vsop87.LnVsop(7.21E-8, 2.56243122515, 375.6743498351), new Vsop87.LnVsop(6.777E-8, 0.50997508166, 1147.4968508808), new Vsop87.LnVsop(6.59E-8, 3.39794943072, 389.6889955156), new Vsop87.LnVsop(6.376E-8, 0.24081237769, 881.5075574033), new Vsop87.LnVsop(5.829E-8, 6.04973118199, 172.4577468145), new Vsop87.LnVsop(5.827E-8, 2.19507738696, 8.9068362498), new Vsop87.LnVsop(5.305E-8, 1.977856112, 150.31395666), new Vsop87.LnVsop(5.706E-8, 1.66973662153, 70.0462961521), new Vsop87.LnVsop(5.422E-8, 1.21990761182, 332.1728723357), new Vsop87.LnVsop(6.818E-8, 1.98954025696, 105.380396079), new Vsop87.LnVsop(7.235E-8, 2.78896876234, 748.0978699633), new Vsop87.LnVsop(6.36E-8, 0.36304095923, 74.4090915518), new Vsop87.LnVsop(5.612E-8, 3.4988632804, 102.523325247), new Vsop87.LnVsop(6.581E-8, 4.48256802747, 31.2319369581), new Vsop87.LnVsop(6.268E-8, 3.59621382047, 488.8496164711), new Vsop87.LnVsop(6.36E-8, 0.66780746624, 272.5815756165), new Vsop87.LnVsop(6.673E-8, 0.77536194908, 6069.7767545534), new Vsop87.LnVsop(5.279E-8, 4.27436629709, 11.1575748485), new Vsop87.LnVsop(5.611E-8, 2.40776057824, 1286.0143477515), new Vsop87.LnVsop(5.9E-8, 0.51262679903, 285.1117485887), new Vsop87.LnVsop(5.898E-8, 5.26174074234, 757.8078553652), new Vsop87.LnVsop(5.385E-8, 1.77116775784, 139.4807047172), new Vsop87.LnVsop(6.198E-8, 0.83056505252, 1507.1777497157), new Vsop87.LnVsop(5.425E-8, 1.93107713343, 40.8413486235), new Vsop87.LnVsop(6.091E-8, 5.18564204379, 487.1045113319), new Vsop87.LnVsop(5.134E-8, 2.61122038772, 194.1766403268), new Vsop87.LnVsop(5.505E-8, 1.31212823209, 883.7951792637), new Vsop87.LnVsop(5.687E-8, 1.96943472998, 394.3548619616), new Vsop87.LnVsop(6.304E-8, 3.02157380188, 442.7517005706), new Vsop87.LnVsop(5.027E-8, 4.45266598835, 12.0089081104), new Vsop87.LnVsop(5.204E-8, 3.39869589191, 1400.152822234), new Vsop87.LnVsop(6.542E-8, 2.31977509408, 328.2407190726), new Vsop87.LnVsop(4.969E-8, 6.27367198215, 0.1600586944), new Vsop87.LnVsop(5.019E-8, 2.43585264336, 742.9900605326), new Vsop87.LnVsop(5.505E-8, 0.3230734679, 40.5807161926), new Vsop87.LnVsop(6.432E-8, 2.21948959433, 9999.986450773), new Vsop87.LnVsop(6.932E-8, 1.71722830737, 378.9039276826), new Vsop87.LnVsop(5.187E-8, 3.04429850681, 1083.7609525774), new Vsop87.LnVsop(4.893E-8, 6.06127550285, 980.6681783588), new Vsop87.LnVsop(5.791E-8, 3.94061476239, 550.1378342197), new Vsop87.LnVsop(5.054E-8, 5.63164324182, 164.1203595363), new Vsop87.LnVsop(5.481E-8, 4.36493293939, 233.533516242), new Vsop87.LnVsop(5.326E-8, 0.06980162504, 336.8387387817), new Vsop87.LnVsop(6.675E-8, 4.68809907572, 312.1990839626), new Vsop87.LnVsop(5.777E-8, 2.24316510899, 230.9370778409), new Vsop87.LnVsop(4.907E-8, 2.9603946351, 361.3778198643), new Vsop87.LnVsop(6.636E-8, 0.3441507572, 511.5954083047), new Vsop87.LnVsop(6.333E-8, 0.96579519801, 249.9476583675), new Vsop87.LnVsop(6.468E-8, 3.02580538093, 298.2326223919), new Vsop87.LnVsop(5.096E-8, 4.22435065058, 65.3804297061), new Vsop87.LnVsop(5.159E-8, 3.77051984159, 57.255490749), new Vsop87.LnVsop(4.974E-8, 1.21594265105, 455.0694252217), new Vsop87.LnVsop(5.785E-8, 5.06114337982, 216.2680408546), new Vsop87.LnVsop(4.96E-8, 4.7280621023, 454.7493078329), new Vsop87.LnVsop(5.619E-8, 2.27500441196, 227.5261894396), new Vsop87.LnVsop(5.161E-8, 2.79823920744, 217.4436970222), new Vsop87.LnVsop(4.791E-8, 4.40314095945, 853.196381752), new Vsop87.LnVsop(5.45E-8, 6.00971547441, 25.1297819136), new Vsop87.LnVsop(5.094E-8, 3.96693309174, 1066.49547719), new Vsop87.LnVsop(6.485E-8, 3.02825531498, 167.7224443993), new Vsop87.LnVsop(5.396E-8, 5.62885554221, 418.5214360287), new Vsop87.LnVsop(5.048E-8, 2.46802064424, 987.5692770385), new Vsop87.LnVsop(6.152E-8, 0.79853332272, 2274.5468326365), new Vsop87.LnVsop(6.507E-8, 1.72872754258, 125.1841747464), new Vsop87.LnVsop(4.734E-8, 0.64940724791, 119.3950417595), new Vsop87.LnVsop(5.785E-8, 4.31238502962, 374.4986936675), new Vsop87.LnVsop(6.209E-8, 4.78522319194, 270.1820791715), new Vsop87.LnVsop(5.381E-8, 5.50204905208, 632.7837393132), new Vsop87.LnVsop(4.921E-8, 1.43037646364, 73.1370671646), new Vsop87.LnVsop(4.596E-8, 0.55370404346, 35.685355083), new Vsop87.LnVsop(5.076E-8, 1.34845106372, 455.0212411119), new Vsop87.LnVsop(5.73E-8, 3.30386575677, 88.274979386), new Vsop87.LnVsop(5.07E-8, 4.59616483078, 454.7974919427), new Vsop87.LnVsop(4.547E-8, 3.81754661073, 1329.3033769298), new Vsop87.LnVsop(6.213E-8, 2.58827935033, 544.5087599272), new Vsop87.LnVsop(4.825E-8, 6.08615762909, 304.1223291153), new Vsop87.LnVsop(4.824E-8, 6.00481294702, 226.7924762567), new Vsop87.LnVsop(5.528E-8, 5.69752791882, 548.4409131903), new Vsop87.LnVsop(6.054E-8, 0.84188900289, 10.0824924174), new Vsop87.LnVsop(5.426E-8, 2.44848284229, 531.978586955), new Vsop87.LnVsop(5.047E-8, 2.74537299312, 423.6292454594), new Vsop87.LnVsop(6.017E-8, 0.11706831045, 149.0419322728), new Vsop87.LnVsop(5.671E-8, 4.76092767065, 491.8185618877), new Vsop87.LnVsop(5.866E-8, 6.20513223441, 772.7857088922), new Vsop87.LnVsop(5.334E-8, 2.49860553733, 1131.1945833399), new Vsop87.LnVsop(4.766E-8, 0.19527580548, 380.3884003909), new Vsop87.LnVsop(4.562E-8, 0.55717668871, 253.4591205053), new Vsop87.LnVsop(5.777E-8, 4.22586873011, 208.8456773131), new Vsop87.LnVsop(5.257E-8, 4.72122908918, 535.3200393871), new Vsop87.LnVsop(4.406E-8, 3.42864201394, 144.8973306886), new Vsop87.LnVsop(5.174E-8, 1.37808288211, 520.129737539), new Vsop87.LnVsop(4.469E-8, 1.67012643165, 1261.6353253633), new Vsop87.LnVsop(4.331E-8, 2.64717426456, 1517.2602421331), new Vsop87.LnVsop(4.802E-8, 2.6056946352, 177.3049238143), new Vsop87.LnVsop(5.206E-8, 0.97973969441, 128.4350044533), new Vsop87.LnVsop(4.368E-8, 3.36272561974, 1503.2455964526), new Vsop87.LnVsop(4.329E-8, 2.73534631925, 289.5651667136), new Vsop87.LnVsop(4.48E-8, 1.66847193407, 357.4456666012), new Vsop87.LnVsop(5.386E-8, 5.84886051674, 268.6976064632), new Vsop87.LnVsop(5.293E-8, 1.36761627543, 271.61836777), new Vsop87.LnVsop(5.277E-8, 0.77780731413, 1670.0742689746), new Vsop87.LnVsop(4.812E-8, 4.95769337401, 545.4719677737), new Vsop87.LnVsop(5.895E-8, 2.03979596386, 8.5980197091), new Vsop87.LnVsop(4.41E-8, 3.23960763864, 973.554631358), new Vsop87.LnVsop(4.201E-8, 6.02802824632, 204.7010757289), new Vsop87.LnVsop(4.947E-8, 5.50324549674, 365.9006739584), new Vsop87.LnVsop(4.553E-8, 2.77414446606, 147.9668498417), new Vsop87.LnVsop(5.351E-8, 1.81217833246, 521.0929453855), new Vsop87.LnVsop(4.218E-8, 0.73689779266, 1321.4390704036), new Vsop87.LnVsop(5.016E-8, 1.91636964972, 535.9107402181), new Vsop87.LnVsop(5.188E-8, 1.30753762651, 436.8138097374), new Vsop87.LnVsop(5.686E-8, 2.54348150001, 501.3797894433), new Vsop87.LnVsop(4.126E-8, 3.00605697657, 136.0698163159), new Vsop87.LnVsop(4.341E-8, 3.74899549978, 263.0203480609), new Vsop87.LnVsop(4.976E-8, 2.82755706922, 360.4146120178), new Vsop87.LnVsop(5.36E-8, 3.99155865541, 92.4195809702), new Vsop87.LnVsop(4.935E-8, 5.04375067678, 697.8071683688), new Vsop87.LnVsop(4.129E-8, 1.50064332826, 71.8608372605), new Vsop87.LnVsop(4.825E-8, 2.90964137048, 551.1010420662), new Vsop87.LnVsop(5.036E-8, 4.66411186577, 305.6068018236), new Vsop87.LnVsop(4.587E-8, 4.78553156868, 95.931043108), new Vsop87.LnVsop(5.054E-8, 5.41201072891, 758.7710632117), new Vsop87.LnVsop(5.012E-8, 4.50266403787, 635.9651330509), new Vsop87.LnVsop(5.151E-8, 0.41217186078, 968.1380053866), new Vsop87.LnVsop(4.247E-8, 0.65406696565, 920.8644333185), new Vsop87.LnVsop(5.15E-8, 1.13490701556, 310.9752436852), new Vsop87.LnVsop(4.941E-8, 2.84565061722, 406.954470903), new Vsop87.LnVsop(4.569E-8, 5.19758291396, 10.2949407385), new Vsop87.LnVsop(4.259E-8, 5.53167973839, 184.9879197867), new Vsop87.LnVsop(4.604E-8, 2.51643176466, 962.5089310941), new Vsop87.LnVsop(4.409E-8, 1.59455204572, 367.5975949878), new Vsop87.LnVsop(5.105E-8, 1.26007002216, 971.1069508032), new Vsop87.LnVsop(4.5E-8, 6.15657007891, 1052.2683831884), new Vsop87.LnVsop(3.968E-8, 0.07377679014, 77.7023598741), new Vsop87.LnVsop(3.9E-8, 1.66467970991, 945.2434557067), new Vsop87.LnVsop(4.137E-8, 4.19706074841, 25.2727942655), new Vsop87.LnVsop(4.237E-8, 2.80797873442, 213.9534867438), new Vsop87.LnVsop(3.899E-8, 4.28674267073, 224.2329211173), new Vsop87.LnVsop(5.03E-8, 6.24112139947, 1162.4747044078), new Vsop87.LnVsop(4.967E-8, 2.58649417006, 358.4088744477), new Vsop87.LnVsop(3.859E-8, 2.72333630141, 818.574808252), new Vsop87.LnVsop(4.889E-8, 2.50485923786, 355.7487455718), new Vsop87.LnVsop(4.626E-8, 6.00420830249, 421.1815649046), new Vsop87.LnVsop(4.765E-8, 4.37822799323, 117.36805233), new Vsop87.LnVsop(3.919E-8, 4.81677862044, 893.3564068193), new Vsop87.LnVsop(4.287E-8, 3.15207047069, 846.0828347512), new Vsop87.LnVsop(3.941E-8, 0.04342429962, 1235.6117715724), new Vsop87.LnVsop(3.816E-8, 2.42145744929, 348.8476468921), new Vsop87.LnVsop(4.756E-8, 1.32234737789, 238.9019581036), new Vsop87.LnVsop(4.077E-8, 5.6885446997, 695.5564297701), new Vsop87.LnVsop(3.842E-8, 0.3742937338, 774.4826299216), new Vsop87.LnVsop(4.674E-8, 0.08112657673, 1366.2125722902), new Vsop87.LnVsop(5.313E-8, 4.38472090135, 689.6185389369), new Vsop87.LnVsop(4.578E-8, 0.36908312831, 168.3131452303), new Vsop87.LnVsop(4.827E-8, 1.26561568753, 170.7608257851), new Vsop87.LnVsop(4.636E-8, 5.93439675803, 148.1905990109), new Vsop87.LnVsop(5.128E-8, 0.17600223269, 433.7117378768), new Vsop87.LnVsop(4.291E-8, 3.12693688865, 377.4194549743), new Vsop87.LnVsop(3.927E-8, 5.59942396205, 1048.3362299253), new Vsop87.LnVsop(4.226E-8, 6.24596640453, 448.9714756941), new Vsop87.LnVsop(3.776E-8, 1.78756451192, 71.7007785661), new Vsop87.LnVsop(3.85E-8, 2.72007090628, 151.850818995), new Vsop87.LnVsop(4.561E-8, 0.07201979569, 2349.3284312038), new Vsop87.LnVsop(4.291E-8, 5.39929372298, 523.7530742614), new Vsop87.LnVsop(4.143E-8, 0.17158866287, 735.8765135318), new Vsop87.LnVsop(3.694E-8, 1.44652002583, 48.9181034708), new Vsop87.LnVsop(3.728E-8, 1.69745141654, 984.7122062065), new Vsop87.LnVsop(4.173E-8, 4.01017634093, 195.7729876197), new Vsop87.LnVsop(4.986E-8, 1.03560339271, 224.4566702865), new Vsop87.LnVsop(4.031E-8, 0.92145122185, 76.0054388447), new Vsop87.LnVsop(4.097E-8, 3.51219407937, 72.4939767069), new Vsop87.LnVsop(3.812E-8, 4.41246815759, 1511.3223512999), new Vsop87.LnVsop(4.098E-8, 2.39702785276, 239.1625905345), new Vsop87.LnVsop(3.751E-8, 5.81981147475, 450.7165808333), new Vsop87.LnVsop(3.657E-8, 1.4138849444, 117.3198682202), new Vsop87.LnVsop(4.373E-8, 4.08948598951, 75.4359898731), new Vsop87.LnVsop(4.765E-8, 4.44775874782, 51.8870488874), new Vsop87.LnVsop(3.7E-8, 2.04103813925, 63.2146334416), new Vsop87.LnVsop(4.436E-8, 5.7658054565, 836.5216071956), new Vsop87.LnVsop(4.648E-8, 2.07482117651, 1106.6555022573), new Vsop87.LnVsop(4.854E-8, 5.26337784504, 601.5036182453), new Vsop87.LnVsop(3.736E-8, 1.46595907948, 138.6293714553), new Vsop87.LnVsop(4.304E-8, 3.03122452327, 1109.6244476739), new Vsop87.LnVsop(4.02E-8, 0.59697361731, 91.2439248026), new Vsop87.LnVsop(4.937E-8, 5.49417275871, 976.7360250957), new Vsop87.LnVsop(3.719E-8, 0.11762341199, 1031.87390369), new Vsop87.LnVsop(4.036E-8, 2.09041185441, 325.3836482406), new Vsop87.LnVsop(4.373E-8, 3.76648561161, 74.1272072615), new Vsop87.LnVsop(4.545E-8, 1.35255134812, 41.7563723602), new Vsop87.LnVsop(4.172E-8, 0.75349427039, 1500.0642027149), new Vsop87.LnVsop(4.19E-8, 5.82534911413, 346.4481504471), new Vsop87.LnVsop(3.784E-8, 0.83700163181, 827.9235874865), new Vsop87.LnVsop(4.454E-8, 1.87402712883, 141.1776257466), new Vsop87.LnVsop(4.853E-8, 0.95917381603, 58.1705144857), new Vsop87.LnVsop(4.409E-8, 0.16608106044, 630.3360587584), new Vsop87.LnVsop(3.597E-8, 1.02560564655, 515.463871093), new Vsop87.LnVsop(4.822E-8, 3.83570312464, 163.5778428151), new Vsop87.LnVsop(4.021E-8, 5.68447974866, 3.4902102784), new Vsop87.LnVsop(4.244E-8, 3.75845344717, 733.428832977), new Vsop87.LnVsop(3.933E-8, 4.55157642432, 240.125798381), new Vsop87.LnVsop(4.421E-8, 1.51263319894, 1610.2705239343), new Vsop87.LnVsop(3.39E-8, 4.00215380112, 74.9940468884), new Vsop87.LnVsop(4.556E-8, 3.41531360523, 1140.38330388), new Vsop87.LnVsop(4.171E-8, 0.76417016678, 623.4349600787), new Vsop87.LnVsop(3.997E-8, 5.74857613262, 6212.2264046872), new Vsop87.LnVsop(4.54E-8, 3.21454634514, 761.7400086283), new Vsop87.LnVsop(4.232E-8, 0.8388726758, 176.6505325085), new Vsop87.LnVsop(4.098E-8, 1.41920746453, 559.6990617753), new Vsop87.LnVsop(4.553E-8, 1.09016692751, 561.8861098992), new Vsop87.LnVsop(3.828E-8, 4.08837921098, 268.9582388941), new Vsop87.LnVsop(3.598E-8, 5.35099971703, 394.9455627926), new Vsop87.LnVsop(3.484E-8, 5.54596330164, 594.9113361063), new Vsop87.LnVsop(3.564E-8, 1.57868308864, 354.9979860464), new Vsop87.LnVsop(4.279E-8, 2.35436288262, 562.6680071919), new Vsop87.LnVsop(3.896E-8, 4.66682485035, 71.9245277353), new Vsop87.LnVsop(4.485E-8, 4.71272827101, 731.9443602687), new Vsop87.LnVsop(3.398E-8, 1.6208634854, 941.3113024436), new Vsop87.LnVsop(3.299E-8, 5.13632919725, 477.0007670551), new Vsop87.LnVsop(4.623E-8, 2.72836206211, 6244.9428143536), new Vsop87.LnVsop(3.308E-8, 2.60386718967, 14.8177948326), new Vsop87.LnVsop(3.435E-8, 2.96178781224, 995.6460318858), new Vsop87.LnVsop(3.98E-8, 3.73613153043, 673.316271396), new Vsop87.LnVsop(3.623E-8, 0.12701520068, 49.1787359017), new Vsop87.LnVsop(4.377E-8, 0.27353840833, 469.7271613599), new Vsop87.LnVsop(3.255E-8, 1.24513640154, 82.6459050935), new Vsop87.LnVsop(3.323E-8, 4.51516827363, 454.8611824175), new Vsop87.LnVsop(3.32E-8, 1.42938752044, 454.9575506371), new Vsop87.LnVsop(3.495E-8, 5.61859895107, 1116.0042814918), new Vsop87.LnVsop(3.593E-8, 5.35238853915, 57.5161231799), new Vsop87.LnVsop(4.196E-8, 1.04465999471, 743.7932096847), new Vsop87.LnVsop(3.512E-8, 6.09122971288, 70.5888128733), new Vsop87.LnVsop(3.814E-8, 2.49565462974, 6204.362098161), new Vsop87.LnVsop(3.828E-8, 4.39752166068, 586.3133163972), new Vsop87.LnVsop(3.924E-8, 1.1070704438, 686.958410061), new Vsop87.LnVsop(3.356E-8, 6.26211053275, 447.2051186955), new Vsop87.LnVsop(3.639E-8, 4.85097208169, 138.4056222861), new Vsop87.LnVsop(3.518E-8, 0.52105043625, 262.8078997398), new Vsop87.LnVsop(3.671E-8, 1.99667387765, 511.5317178299), new Vsop87.LnVsop(4.167E-8, 1.61938375536, 576.1613880106), new Vsop87.LnVsop(3.263E-8, 2.27802067614, 295.1942410061), new Vsop87.LnVsop(3.215E-8, 0.64628330219, 887.7273325268), new Vsop87.LnVsop(3.232E-8, 2.20615118349, 68.631259413), new Vsop87.LnVsop(3.279E-8, 3.50509705814, 256.4280659219), new Vsop87.LnVsop(3.718E-8, 3.27473813045, 454.6487340964), new Vsop87.LnVsop(3.638E-8, 2.63250736806, 455.1699989582), new Vsop87.LnVsop(3.459E-8, 3.18851975154, 377.6800874052), new Vsop87.LnVsop(3.772E-8, 0.88810300052, 10142.4361009068), new Vsop87.LnVsop(3.669E-8, 4.11456655271, 409.9234163196), new Vsop87.LnVsop(3.53E-8, 4.02075420346, 388.2045228073), new Vsop87.LnVsop(3.163E-8, 1.65300792599, 765.8846102125), new Vsop87.LnVsop(3.568E-8, 5.95965909592, 460.8472573605), new Vsop87.LnVsop(3.188E-8, 1.74587038709, 18.9100067901), new Vsop87.LnVsop(3.305E-8, 5.77382040863, 10.5244354021), new Vsop87.LnVsop(4.026E-8, 2.48487699537, 531.1754378029), new Vsop87.LnVsop(3.345E-8, 4.15802505352, 1515.7757694248), new Vsop87.LnVsop(3.644E-8, 1.78909340323, 251.1714986449), new Vsop87.LnVsop(3.525E-8, 2.56091667232, 78114.14622758799), new Vsop87.LnVsop(3.147E-8, 5.05814757549, 1521.4048437173), new Vsop87.LnVsop(3.155E-8, 0.65831540442, 74.0478853844), new Vsop87.LnVsop(4.18E-8, 1.168336748, 514.5643537213), new Vsop87.LnVsop(3.255E-8, 1.96741940264, 58.7399634573), new Vsop87.LnVsop(3.212E-8, 3.18682610058, 1512.8068240082), new Vsop87.LnVsop(3.486E-8, 0.22630227172, 36.5366883449), new Vsop87.LnVsop(3.997E-8, 5.58144993177, 57.7980074702), new Vsop87.LnVsop(3.628E-8, 2.42977552434, 230.8252032563), new Vsop87.LnVsop(3.884E-8, 5.6577084846, 94.4253185403), new Vsop87.LnVsop(3.485E-8, 3.26177495276, 36.7604375141), new Vsop87.LnVsop(3.506E-8, 6.26633354904, 545.2750258176), new Vsop87.LnVsop(3.187E-8, 1.62296832026, 138.4693127609), new Vsop87.LnVsop(3.934E-8, 2.86731965547, 832.0681890707), new Vsop87.LnVsop(3.115E-8, 5.67364420834, 73.5577582899), new Vsop87.LnVsop(3.721E-8, 2.55626754637, 279.4826742962), new Vsop87.LnVsop(3.171E-8, 4.85529878165, 138.5656809805), new Vsop87.LnVsop(3.108E-8, 3.14860474691, 72.5463663336), new Vsop87.LnVsop(3.777E-8, 5.94890597104, 873.1701701251), new Vsop87.LnVsop(4.357E-8, 4.15105623366, 10175.1525105732), new Vsop87.LnVsop(3.525E-8, 4.8031643597, 429.7795846137), new Vsop87.LnVsop(3.382E-8, 1.45717307307, 5983.9494557222), new Vsop87.LnVsop(4.161E-8, 5.39091883238, 1363.2436268736), new Vsop87.LnVsop(3.537E-8, 4.29176088936, 36.1754821775), new Vsop87.LnVsop(3.115E-8, 0.59873966282, 273.8536000037), new Vsop87.LnVsop(3.457E-8, 3.94796907904, 444.8268741099), new Vsop87.LnVsop(3.593E-8, 3.91831549069, 10134.5717943806), new Vsop87.LnVsop(3.7E-8, 0.67445695843, 73.9302653054), new Vsop87.LnVsop(3.547E-8, 5.63096398237, 440.8947208468), new Vsop87.LnVsop(3.622E-8, 1.10742531477, 2250.1678102483), new Vsop87.LnVsop(3.562E-8, 3.80604468765, 1525.3369969804), new Vsop87.LnVsop(3.33E-8, 1.76480149289, 78.9743842613), new Vsop87.LnVsop(3.013E-8, 0.69171521367, 210.8514148832), new Vsop87.LnVsop(3.241E-8, 3.65013641564, 335.7749571987), new Vsop87.LnVsop(3.032E-8, 5.77852412826, 612.1768114937), new Vsop87.LnVsop(3.978E-8, 4.58297442673, 898.7730327907), new Vsop87.LnVsop(3.337E-8, 4.81258545559, 597.3590166611), new Vsop87.LnVsop(3.141E-8, 3.11768616608, 6607.9277275406), new Vsop87.LnVsop(3.696E-8, 1.76581280127, 384.5811860849), new Vsop87.LnVsop(3.577E-8, 3.95434949639, 179.3106613844), new Vsop87.LnVsop(3.02E-8, 5.0419340802, 197.7999770492), new Vsop87.LnVsop(4.082E-8, 3.52781255989, 402.2191684878), new Vsop87.LnVsop(3.454E-8, 3.41560919175, 912.7876784712), new Vsop87.LnVsop(3.697E-8, 0.89932694516, 75.6329318292), new Vsop87.LnVsop(3.238E-8, 1.15084522701, 104.8378793578), new Vsop87.LnVsop(3.374E-8, 0.40981508151, 677.7696895209), new Vsop87.LnVsop(3.5E-8, 4.46985063604, 46.470422916), new Vsop87.LnVsop(3.111E-8, 1.88860295507, 34.2008823747), new Vsop87.LnVsop(3.953E-8, 0.25645102865, 517.1607921224), new Vsop87.LnVsop(3.194E-8, 4.56998602897, 1385.174968707), new Vsop87.LnVsop(3.931E-8, 1.09338513303, 388.4651552382), new Vsop87.LnVsop(2.93E-8, 4.8814435312, 455.6601260527), new Vsop87.LnVsop(3.18E-8, 1.03370427552, 885.4397106664), new Vsop87.LnVsop(3.235E-8, 5.09681747179, 464.9918589447), new Vsop87.LnVsop(3.173E-8, 5.68964342749, 4.192785694), new Vsop87.LnVsop(3.181E-8, 2.87968862974, 9914.1591519418), new Vsop87.LnVsop(3.355E-8, 5.45857968674, 73.0846775379), new Vsop87.LnVsop(3.951E-8, 5.81493541571, 586.377006872), new Vsop87.LnVsop(2.899E-8, 5.12928266291, 448.3170843883), new Vsop87.LnVsop(2.903E-8, 1.06370870134, 454.1586070019), new Vsop87.LnVsop(3.706E-8, 2.47342147635, 64.2571631652), new Vsop87.LnVsop(3.649E-8, 1.90256590579, 31.5407534988), new Vsop87.LnVsop(3.36E-8, 4.99299052479, 143.3434220111), new Vsop87.LnVsop(3.657E-8, 4.53797912903, 676.2852168126), new Vsop87.LnVsop(3.488E-8, 5.62713714766, 3189.5647568569), new Vsop87.LnVsop(2.94E-8, 4.33606107945, 78263.70942472259), new Vsop87.LnVsop(3.309E-8, 3.10770680369, 519.6084726772), new Vsop87.LnVsop(3.781E-8, 4.30315299354, 164.5410506616), new Vsop87.LnVsop(4.03E-8, 4.41794838679, 772.5887669361), new Vsop87.LnVsop(3.058E-8, 4.84465787968, 221.1634019642), new Vsop87.LnVsop(2.867E-8, 5.17129632099, 346.1875180162), new Vsop87.LnVsop(3.842E-8, 1.87994191354, 299.7170951002), new Vsop87.LnVsop(2.844E-8, 4.34268503622, 262.0571402144), new Vsop87.LnVsop(3.724E-8, 4.94511644698, 984.4884570373), new Vsop87.LnVsop(3.216E-8, 5.70775867303, 14.6690369863), new Vsop87.LnVsop(2.923E-8, 0.37358823115, 6.4804075544), new Vsop87.LnVsop(2.931E-8, 0.78809830626, 540.0553418023), new Vsop87.LnVsop(3.707E-8, 4.14868763219, 6136.4815982734), new Vsop87.LnVsop(3.931E-8, 5.52289695589, 6171.6456884946), new Vsop87.LnVsop(2.83E-8, 2.11705330414, 34.5309507748), new Vsop87.LnVsop(3.348E-8, 3.08775772849, 245.4942402426), new Vsop87.LnVsop(3.394E-8, 2.49196845335, 260.360219185), new Vsop87.LnVsop(3.378E-8, 3.82658652472, 25936.85547173129), new Vsop87.LnVsop(3.041E-8, 2.14503983522, 6604.958782124), new Vsop87.LnVsop(3.657E-8, 6.02755271763, 340.8827666294), new Vsop87.LnVsop(2.818E-8, 4.44508352472, 369.342700127), new Vsop87.LnVsop(2.865E-8, 3.21935127992, 3.8202786785), new Vsop87.LnVsop(3.738E-8, 5.38309514127, 980.146913497), new Vsop87.LnVsop(2.797E-8, 5.97725967979, 2014.0265547571), new Vsop87.LnVsop(3.28E-8, 0.74832416123, 422.7142217227), new Vsop87.LnVsop(3.511E-8, 1.92497000013, 343.4792050305), new Vsop87.LnVsop(2.962E-8, 2.29867992492, 661.1586054393), new Vsop87.LnVsop(3.603E-8, 2.72183511139, 508.6264628881), new Vsop87.LnVsop(3.62E-8, 5.57691156197, 10066.691294493), new Vsop87.LnVsop(3.306E-8, 6.20620840278, 11.5669651257), new Vsop87.LnVsop(3.279E-8, 6.13563821647, 276.0717858949), new Vsop87.LnVsop(2.823E-8, 1.19859134883, 1119.1856752295), new Vsop87.LnVsop(3.302E-8, 5.46042536571, 302.3772239761), new Vsop87.LnVsop(2.747E-8, 4.5747626302, 226.6324175623), new Vsop87.LnVsop(3.814E-8, 3.13695930196, 901.9544265284), new Vsop87.LnVsop(2.707E-8, 0.46257342768, 1458.472094566), new Vsop87.LnVsop(3.402E-8, 4.84131712548, 714.6788848813), new Vsop87.LnVsop(3.346E-8, 1.9097173874, 44.6134431922), new Vsop87.LnVsop(2.96E-8, 5.31788128818, 1467.0701142751), new Vsop87.LnVsop(3.062E-8, 1.93542241882, 987.7817253596), new Vsop87.LnVsop(3.045E-8, 4.24065596268, 170.1701249541), new Vsop87.LnVsop(3.504E-8, 4.10521239427, 6280.1069045748), new Vsop87.LnVsop(2.674E-8, 1.01129308948, 582.3811631341), new Vsop87.LnVsop(3.584E-8, 3.12196206765, 108.7218485111), new Vsop87.LnVsop(2.975E-8, 0.13746189123, 9987.4562778008), new Vsop87.LnVsop(2.634E-8, 5.61201014857, 412.3710968744), new Vsop87.LnVsop(3.702E-8, 0.66231252049, 10101.8553847142), new Vsop87.LnVsop(3.526E-8, 4.42297802934, 322.6116447801), new Vsop87.LnVsop(3.261E-8, 4.39228048501, 75.3722993983), new Vsop87.LnVsop(2.939E-8, 3.26319979871, 130.552616608), new Vsop87.LnVsop(3.295E-8, 3.98758407636, 488.5889840402), new Vsop87.LnVsop(2.737E-8, 3.15826692829, 683.0262567979), new Vsop87.LnVsop(2.915E-8, 1.47424610987, 680.0573113813), new Vsop87.LnVsop(2.624E-8, 0.47879556723, 29.226199388), new Vsop87.LnVsop(2.678E-8, 1.28275200438, 236.1936451179), new Vsop87.LnVsop(3.678E-8, 3.46436124301, 26468.0309095342), new Vsop87.LnVsop(2.598E-8, 2.16996571956, 191.3195694948), new Vsop87.LnVsop(2.943E-8, 3.58544468129, 12489.8856287072), new Vsop87.LnVsop(2.72E-8, 1.24094972893, 989.0537497468), new Vsop87.LnVsop(2.894E-8, 2.2699912084, 1615.8995982268), new Vsop87.LnVsop(2.985E-8, 4.93091159917, 132.5796060375), new Vsop87.LnVsop(2.579E-8, 1.27635624544, 1034.8428491066), new Vsop87.LnVsop(2.711E-8, 1.25250599577, 52250.5878817157), new Vsop87.LnVsop(2.917E-8, 5.69857391789, 688.6553310904), new Vsop87.LnVsop(3.483E-8, 1.97113718781, 655.938921424), new Vsop87.LnVsop(3.28E-8, 1.75059058234, 683.9894646444), new Vsop87.LnVsop(3.26E-8, 3.46047977615, 74.1908977363), new Vsop87.LnVsop(2.936E-8, 2.61715717878, 115.3623147599), new Vsop87.LnVsop(3.2E-8, 0.66316490563, 457.3570470821), new Vsop87.LnVsop(2.565E-8, 3.47443238116, 2042.4977891028), new Vsop87.LnVsop(3.158E-8, 4.58160924364, 12492.8545741238), new Vsop87.LnVsop(2.719E-8, 2.8954618437, 27.7204748203), new Vsop87.LnVsop(3.373E-8, 5.52806001629, 10210.3166007944), new Vsop87.LnVsop(2.6E-8, 0.31946397676, 85.9391734158), new Vsop87.LnVsop(2.619E-8, 4.43681016724, 949.1756089698), new Vsop87.LnVsop(3.29E-8, 1.35055242247, 515.6763194141), new Vsop87.LnVsop(3.18E-8, 4.49938964982, 694.8382229522), new Vsop87.LnVsop(2.586E-8, 4.09771865336, 1448.9108670104), new Vsop87.LnVsop(2.574E-8, 5.47692668053, 246.9787129509), new Vsop87.LnVsop(3.001E-8, 3.24181300229, 1618.8685436434), new Vsop87.LnVsop(3.009E-8, 3.16728117117, 385.7568422525), new Vsop87.LnVsop(2.675E-8, 4.91608217296, 754.0357607965), new Vsop87.LnVsop(2.535E-8, 0.13831089527, 591.9423906897), new Vsop87.LnVsop(3.319E-8, 5.98200177347, 533.8355666788), new Vsop87.LnVsop(3.307E-8, 3.31452419197, 732.97125859), new Vsop87.LnVsop(2.975E-8, 5.72770980032, 1011.4270345649), new Vsop87.LnVsop(3.46E-8, 2.59999470578, 267.5856407704), new Vsop87.LnVsop(2.857E-8, 4.11031053901, 2267.4332856357), new Vsop87.LnVsop(2.754E-8, 0.78792218586, 229.4526051326), new Vsop87.LnVsop(3.422E-8, 6.18592254593, 281.4884118663), new Vsop87.LnVsop(3.495E-8, 0.1722463496, 371.5297482509), new Vsop87.LnVsop(2.547E-8, 4.45612695304, 901.2207133455), new Vsop87.LnVsop(2.476E-8, 1.55163657371, 1234.1272988641), new Vsop87.LnVsop(3.38E-8, 3.46612468213, 283.6272758804), new Vsop87.LnVsop(2.593E-8, 1.42286075943, 141.6988906084), new Vsop87.LnVsop(2.665E-8, 2.98397830634, 250.6020496733), new Vsop87.LnVsop(2.424E-8, 3.87508350406, 70.6369969831), new Vsop87.LnVsop(2.458E-8, 4.65895339908, 392.6579409322), new Vsop87.LnVsop(2.877E-8, 5.47506403197, 1436.5407527326), new Vsop87.LnVsop(2.948E-8, 3.49876539234, 123.0183784819), new Vsop87.LnVsop(2.739E-8, 6.05181954433, 161.4120465506), new Vsop87.LnVsop(2.361E-8, 5.34825180906, 318.679491517), new Vsop87.LnVsop(3.221E-8, 1.06289254235, 388.7257876691), new Vsop87.LnVsop(2.715E-8, 1.28980431988, 108.982480942), new Vsop87.LnVsop(2.392E-8, 2.58938442749, 156.6767441354), new Vsop87.LnVsop(2.313E-8, 5.57068624384, 29.7956483596), new Vsop87.LnVsop(2.351E-8, 3.65378596351, 112.3933693433), new Vsop87.LnVsop(2.768E-8, 5.4225616879, 482.2573343321), new Vsop87.LnVsop(2.731E-8, 2.33677247572, 273.1510245881), new Vsop87.LnVsop(3.23E-8, 5.65661970187, 134.3728952865), new Vsop87.LnVsop(2.685E-8, 5.03687735302, 763.2244813366), new Vsop87.LnVsop(2.816E-8, 5.71804752798, 327.4375699205), new Vsop87.LnVsop(2.608E-8, 3.11386505876, 578.449009871), new Vsop87.LnVsop(2.371E-8, 3.52034351878, 3.6233367224), new Vsop87.LnVsop(2.26E-8, 6.23958645351, 400.5746370851), new Vsop87.LnVsop(3.089E-8, 5.69639540598, 537.3952129264), new Vsop87.LnVsop(2.84E-8, 0.03011890351, 563.3705826075), new Vsop87.LnVsop(2.43E-8, 4.24536997427, 27.7417266797), new Vsop87.LnVsop(2.3E-8, 2.44747995452, 107.918699359), new Vsop87.LnVsop(2.756E-8, 0.44285569281, 255.8373650909), new Vsop87.LnVsop(2.255E-8, 3.38467700412, 1257.7031721002), new Vsop87.LnVsop(2.26E-8, 3.85026258012, 753.1419889192), new Vsop87.LnVsop(2.598E-8, 0.43155550046, 175.4266922311), new Vsop87.LnVsop(2.319E-8, 6.27990804405, 493.0424021651), new Vsop87.LnVsop(2.579E-8, 1.76841912074, 710.7467316182), new Vsop87.LnVsop(2.323E-8, 5.19875505188, 380.2396425446), new Vsop87.LnVsop(2.426E-8, 0.96570848986, 225.3080035484), new Vsop87.LnVsop(2.182E-8, 3.63636403703, 178.1350052168), new Vsop87.LnVsop(2.713E-8, 0.64055715691, 424.1505103212), new Vsop87.LnVsop(2.85E-8, 5.36388642993, 44.0921783304), new Vsop87.LnVsop(2.174E-8, 1.36737239358, 526.5095713569), new Vsop87.LnVsop(2.23E-8, 0.18624095003, 309.2783226558), new Vsop87.LnVsop(2.691E-8, 3.12857199475, 36.9091953604), new Vsop87.LnVsop(2.356E-8, 4.70736394167, 1297.0600480154), new Vsop87.LnVsop(2.705E-8, 3.96315420875, 466.7582159433), new Vsop87.LnVsop(2.12E-8, 4.00527978646, 78.9262001515), new Vsop87.LnVsop(2.79E-8, 4.69333575335, 845.8858927951), new Vsop87.LnVsop(2.79E-8, 3.15560752049, 696.3226956605), new Vsop87.LnVsop(2.082E-8, 4.28436571612, 1134.1635287565), new Vsop87.LnVsop(2.65E-8, 1.97955054585, 421.2297490144), new Vsop87.LnVsop(2.35E-8, 2.27006566559, 280.2163874791), new Vsop87.LnVsop(2.757E-8, 3.97088429501, 566.3395280241), new Vsop87.LnVsop(2.4E-8, 2.08287192901, 3116.2676309979), new Vsop87.LnVsop(2.091E-8, 4.86268336295, 1222.2784494481), new Vsop87.LnVsop(2.402E-8, 4.59336971395, 569.0478410098), new Vsop87.LnVsop(2.053E-8, 4.50782983699, 2045.4667345194), new Vsop87.LnVsop(2.585E-8, 3.01434261062, 30.5987975117), new Vsop87.LnVsop(2.362E-8, 0.28351250494, 25863.55834587229), new Vsop87.LnVsop(2.296E-8, 2.43545418785, 52252.07235442399), new Vsop87.LnVsop(2.296E-8, 4.03915647243, 52102.50915728939), new Vsop87.LnVsop(2.48E-8, 4.82872104445, 702.1487119091), new Vsop87.LnVsop(2.394E-8, 2.7184228788, 688.4428827693), new Vsop87.LnVsop(2.598E-8, 5.52873150583, 207.3612046048), new Vsop87.LnVsop(2.726E-8, 2.73636031357, 320.3240229197), new Vsop87.LnVsop(2.686E-8, 3.13615031711, 161.7208630913), new Vsop87.LnVsop(2.651E-8, 4.31467866101, 639.6366538831), new Vsop87.LnVsop(1.999E-8, 3.81218083941, 122.0551706354), new Vsop87.LnVsop(2.454E-8, 4.63684196748, 1012.9115072732), new Vsop87.LnVsop(1.998E-8, 4.34234332604, 343.2185725996), new Vsop87.LnVsop(1.982E-8, 1.04358448861, 76.3142553854), new Vsop87.LnVsop(2.651E-8, 4.50494915824, 6209.7787241324), new Vsop87.LnVsop(2.315E-8, 2.16329763901, 380.0158933754), new Vsop87.LnVsop(2.012E-8, 0.58027132344, 530.6541729411), new Vsop87.LnVsop(1.987E-8, 2.34515279356, 768.8535556291), new Vsop87.LnVsop(2.062E-8, 5.14612272595, 68.3011910129), new Vsop87.LnVsop(1.998E-8, 4.72846905297, 76.2178871658), new Vsop87.LnVsop(2.501E-8, 1.46803291637, 95.2766518022), new Vsop87.LnVsop(2.564E-8, 2.20950808655, 566.600160455), new Vsop87.LnVsop(2.569E-8, 1.6864211704, 749.5823426716), new Vsop87.LnVsop(2.047E-8, 4.43426104911, 229.340730548), new Vsop87.LnVsop(2.226E-8, 1.08954827693, 383.3091616977), new Vsop87.LnVsop(2.046E-8, 3.37543676127, 1055.4497769261), new Vsop87.LnVsop(1.954E-8, 2.49907098662, 313.9441891018), new Vsop87.LnVsop(2.177E-8, 3.00048235729, 317.8763423649), new Vsop87.LnVsop(2.238E-8, 0.97968512796, 147.5574595645), new Vsop87.LnVsop(2.148E-8, 0.16770637484, 112.6540017742), new Vsop87.LnVsop(2.35E-8, 5.77036099171, 304.2342036999), new Vsop87.LnVsop(2.183E-8, 5.58654428071, 428.0826635843), new Vsop87.LnVsop(2.063E-8, 5.64116701319, 73.6696328745), new Vsop87.LnVsop(2.535E-8, 1.1355489711, 140.9651774255), new Vsop87.LnVsop(2.445E-8, 0.65211381551, 271.6665518798), new Vsop87.LnVsop(2.072E-8, 2.29027742046, 696.5196376166), new Vsop87.LnVsop(2.08E-8, 1.24910729957, 311.2840602259), new Vsop87.LnVsop(1.912E-8, 3.75992027324, 528.7277572481), new Vsop87.LnVsop(2.063E-8, 2.21480458793, 75.8935642601), new Vsop87.LnVsop(2.107E-8, 4.64640498877, 150.3663462867), new Vsop87.LnVsop(1.883E-8, 5.29259430554, 381.0909758065), new Vsop87.LnVsop(2.562E-8, 1.42062915032, 551.2129166508), new Vsop87.LnVsop(2.062E-8, 0.46104612533, 386.0656587932), new Vsop87.LnVsop(1.916E-8, 5.84122649523, 481.7360694703), new Vsop87.LnVsop(2.333E-8, 4.77162438255, 347.9326231554), new Vsop87.LnVsop(2.156E-8, 2.11521771652, 1250.5896250994), new Vsop87.LnVsop(2.347E-8, 1.97105922216, 188.2387494936), new Vsop87.LnVsop(2.034E-8, 5.51423990497, 678.3603903519), new Vsop87.LnVsop(2.321E-8, 3.54031153946, 103.9865460959), new Vsop87.LnVsop(1.833E-8, 5.62091026321, 840.6662087798), new Vsop87.LnVsop(2.378E-8, 6.0007378545, 664.1275508559), new Vsop87.LnVsop(1.896E-8, 2.15809918048, 379.1645601135), new Vsop87.LnVsop(1.809E-8, 5.61397062326, 14.2270940016), new Vsop87.LnVsop(2.262E-8, 4.5851769094, 430.5303441391), new Vsop87.LnVsop(1.933E-8, 0.42376762202, 915.4478073471), new Vsop87.LnVsop(1.933E-8, 5.10325064461, 1065.0110044817), new Vsop87.LnVsop(2.083E-8, 4.96820157485, 294.3004691288), new Vsop87.LnVsop(1.797E-8, 2.39655065767, 311.9384515317), new Vsop87.LnVsop(1.797E-8, 0.79284837309, 461.5016486663), new Vsop87.LnVsop(1.865E-8, 1.13583348993, 739.0579072695), new Vsop87.LnVsop(1.865E-8, 5.81531651252, 888.6211044041), new Vsop87.LnVsop(1.793E-8, 5.7880461393, 625.8826406335), new Vsop87.LnVsop(1.947E-8, 5.79903258109, 257.3912737684), new Vsop87.LnVsop(2.462E-8, 3.9591678311, 26.826702943), new Vsop87.LnVsop(2.317E-8, 0.68746265782, 625.9945152181), new Vsop87.LnVsop(2.107E-8, 0.10366607161, 1002.7595788866), new Vsop87.LnVsop(2.174E-8, 4.30981640926, 221.8971151471), new Vsop87.LnVsop(1.883E-8, 4.16371906934, 213.1872208534), new Vsop87.LnVsop(1.991E-8, 2.15389092541, 507.5995645668), new Vsop87.LnVsop(1.81E-8, 3.70831888738, 539.2521926502), new Vsop87.LnVsop(1.991E-8, 5.06761957393, 255.57673266), new Vsop87.LnVsop(1.812E-8, 0.78741962695, 151.260118164), new Vsop87.LnVsop(1.964E-8, 2.71891117329, 1024.217839968), new Vsop87.LnVsop(2.252E-8, 4.45925757192, 598.5346728287), new Vsop87.LnVsop(1.804E-8, 2.34130589983, 80.9319377216), new Vsop87.LnVsop(1.854E-8, 0.13193495049, 1396.9714284963), new Vsop87.LnVsop(1.854E-8, 4.81141797308, 1546.5346256309), new Vsop87.LnVsop(2.186E-8, 2.58979636823, 76.5267037065), new Vsop87.LnVsop(1.763E-8, 5.59121902178, 947.6911362615), new Vsop87.LnVsop(1.763E-8, 0.91173599918, 798.1279391269), new Vsop87.LnVsop(1.816E-8, 0.95956155095, 156.043604689), new Vsop87.LnVsop(2.202E-8, 2.18092416439, 583.8656358424), new Vsop87.LnVsop(1.91E-8, 2.64138421542, 498.1983957056), new Vsop87.LnVsop(1.91E-8, 4.24508650001, 348.635198571), new Vsop87.LnVsop(2.215E-8, 2.45791819477, 154.5591319807), new Vsop87.LnVsop(2.322E-8, 6.16493439544, 3340.6124266998), new Vsop87.LnVsop(1.895E-8, 2.0239663472, 467.4395394995), new Vsop87.LnVsop(1.943E-8, 4.41537853646, 185.5786206177), new Vsop87.LnVsop(1.738E-8, 2.44168217704, 913.0001267923), new Vsop87.LnVsop(2.046E-8, 2.19760587122, 882.9920301116), new Vsop87.LnVsop(1.83E-8, 1.16794111151, 47.2735720681), new Vsop87.LnVsop(2.143E-8, 5.26070898677, 42.0651889009), new Vsop87.LnVsop(2.2E-8, 5.8975093892, 10139.988420352), new Vsop87.LnVsop(1.677E-8, 1.72367555591, 975.0391040663), new Vsop87.LnVsop(1.677E-8, 3.26140378877, 1124.6023012009), new Vsop87.LnVsop(1.776E-8, 5.05356646709, 956.2891559706), new Vsop87.LnVsop(2.115E-8, 3.10908283877, 84.8640909847), new Vsop87.LnVsop(2.116E-8, 4.50159315432, 269.0701134787), new Vsop87.LnVsop(1.77E-8, 2.96002469436, 1459.9565672743), new Vsop87.LnVsop(1.807E-8, 3.84800342064, 529.57909051), new Vsop87.LnVsop(1.87E-8, 2.9336511131, 1208.0513554465), new Vsop87.LnVsop(1.87E-8, 4.47137934596, 1357.6145525811), new Vsop87.LnVsop(1.891E-8, 1.70111414825, 190.665178189), new Vsop87.LnVsop(2.06E-8, 5.06581864584, 26013.1215430069), new Vsop87.LnVsop(1.835E-8, 4.7112058249, 76.1060125812), new Vsop87.LnVsop(2.02E-8, 1.67687010626, 354.7855377253), new Vsop87.LnVsop(1.733E-8, 2.43404581799, 187.2755416471), new Vsop87.LnVsop(1.641E-8, 0.46152323273, 303.0585475323), new Vsop87.LnVsop(1.671E-8, 0.67572104809, 154.6710065653), new Vsop87.LnVsop(1.696E-8, 3.15463633411, 398.2870152247), new Vsop87.LnVsop(1.968E-8, 5.83082526219, 195.4004806042), new Vsop87.LnVsop(2.23E-8, 1.7680194688, 624.5100425098), new Vsop87.LnVsop(2.151E-8, 3.33296618401, 552.6973893591), new Vsop87.LnVsop(1.674E-8, 3.34095983797, 316.6525020875), new Vsop87.LnVsop(2.029E-8, 2.07844879451, 199.8538987291), new Vsop87.LnVsop(2.029E-8, 0.47474650993, 349.4170958637), new Vsop87.LnVsop(2.114E-8, 3.86984575671, 81.2620061217), new Vsop87.LnVsop(2.147E-8, 5.6393177255, 590.8304249969), new Vsop87.LnVsop(1.706E-8, 0.73548513365, 961.0244583858), new Vsop87.LnVsop(1.706E-8, 2.33918741824, 811.4612612512), new Vsop87.LnVsop(1.822E-8, 1.64784768077, 473.4623726669), new Vsop87.LnVsop(1.822E-8, 3.25154996536, 323.8991755323), new Vsop87.LnVsop(1.909E-8, 5.58002039864, 6134.9971255651), new Vsop87.LnVsop(2.061E-8, 3.34168764903, 6.8529145699), new Vsop87.LnVsop(1.846E-8, 4.3315401475, 1396.2206689709), new Vsop87.LnVsop(1.879E-8, 4.21685982495, 52.1476813183), new Vsop87.LnVsop(1.937E-8, 2.04746615092, 367.8582274187), new Vsop87.LnVsop(1.937E-8, 3.58519438379, 517.4214245533), new Vsop87.LnVsop(1.884E-8, 1.88048876898, 12.1576659567), new Vsop87.LnVsop(1.602E-8, 1.46373302224, 325.9530972122), new Vsop87.LnVsop(1.754E-8, 4.23029342972, 539.0921339558), new Vsop87.LnVsop(1.645E-8, 6.23273743453, 782.3469364478), new Vsop87.LnVsop(2.153E-8, 1.61615068478, 587.8614795803), new Vsop87.LnVsop(1.702E-8, 2.46774061252, 407.4757357648), new Vsop87.LnVsop(1.602E-8, 4.95996654045, 487.1526954417), new Vsop87.LnVsop(1.576E-8, 3.95360340011, 2077.7624530605), new Vsop87.LnVsop(1.576E-8, 2.41587516724, 1928.1992559259), new Vsop87.LnVsop(1.576E-8, 5.4438886119, 532.1386456494), new Vsop87.LnVsop(1.88E-8, 1.41060159, 575.2676161333), new Vsop87.LnVsop(1.88E-8, 6.0900846126, 724.8308132679), new Vsop87.LnVsop(1.596E-8, 5.33991691502, 34.6215735), new Vsop87.LnVsop(1.624E-8, 1.21716384102, 475.5162943468), new Vsop87.LnVsop(1.803E-8, 0.60015233109, 529.8028396792), new Vsop87.LnVsop(1.662E-8, 3.50151803039, 484.7050148869), new Vsop87.LnVsop(1.735E-8, 1.01657070139, 196.8849533125), new Vsop87.LnVsop(1.584E-8, 0.28218018153, 1811.773159583), new Vsop87.LnVsop(1.804E-8, 6.08380488717, 188.6594406189), new Vsop87.LnVsop(1.758E-8, 0.5321154964, 550.8885937451), new Vsop87.LnVsop(1.758E-8, 2.06984372926, 700.4517908797), new Vsop87.LnVsop(1.573E-8, 5.3835015322, 461.1291416508), new Vsop87.LnVsop(1.667E-8, 0.24230138722, 556.5176680376), new Vsop87.LnVsop(1.559E-8, 6.02213221899, 343.7398374614), new Vsop87.LnVsop(1.796E-8, 5.78444078662, 525.4981794006), new Vsop87.LnVsop(1.563E-8, 0.8061744441, 563.6312150384), new Vsop87.LnVsop(1.603E-8, 4.38109882376, 59.5912967192), new Vsop87.LnVsop(1.606E-8, 1.83958629336, 1349.7502460549), new Vsop87.LnVsop(1.606E-8, 3.44328857794, 1200.1870489203), new Vsop87.LnVsop(1.665E-8, 3.75333799201, 764.7089540449), new Vsop87.LnVsop(1.665E-8, 2.14963570742, 914.2721511795), new Vsop87.LnVsop(1.741E-8, 0.81651703967, 548.2439712342), new Vsop87.LnVsop(1.766E-8, 2.00418474011, 495.9631634719), new Vsop87.LnVsop(1.98E-8, 4.53192980595, 1054.9285120643), new Vsop87.LnVsop(1.98E-8, 2.99420157308, 905.3653149297), new Vsop87.LnVsop(2.146E-8, 2.25428923199, 67.9286839974), new Vsop87.LnVsop(1.56E-8, 3.27821444787, 1208.9451273238), new Vsop87.LnVsop(1.695E-8, 2.26284891229, 493.303034596), new Vsop87.LnVsop(1.94E-8, 4.17311496384, 981.6313862053), new Vsop87.LnVsop(2.135E-8, 5.07005192745, 245.5424243524), new Vsop87.LnVsop(1.604E-8, 4.06884840529, 1136.4511506169), new Vsop87.LnVsop(1.703E-8, 2.08965979965, 274.5873131866), new Vsop87.LnVsop(1.678E-8, 0.30302488401, 1297.8631971675), new Vsop87.LnVsop(2.086E-8, 3.24437004031, 516.0488264296), new Vsop87.LnVsop(1.505E-8, 0.3862283384, 509.0840372751), new Vsop87.LnVsop(1.631E-8, 0.44359079978, 806.725958836), new Vsop87.LnVsop(1.544E-8, 4.38766645261, 206.706813299), new Vsop87.LnVsop(1.495E-8, 4.52648520007, 234.4967240885), new Vsop87.LnVsop(1.549E-8, 0.99024664404, 834.0739266408), new Vsop87.LnVsop(1.549E-8, 5.73570371835, 684.5107295062), new Vsop87.LnVsop(2.013E-8, 5.61129200002, 81.6345131372), new Vsop87.LnVsop(1.95E-8, 0.19680015179, 118.0706277456), new Vsop87.LnVsop(1.943E-8, 5.23985037412, 14.5571624017), new Vsop87.LnVsop(1.483E-8, 0.49824817575, 1020.8282034261), new Vsop87.LnVsop(1.483E-8, 2.03597640861, 1170.3914005607), new Vsop87.LnVsop(1.482E-8, 4.41190841719, 170.7126416753), new Vsop87.LnVsop(1.902E-8, 2.0710383254, 15.1903018481), new Vsop87.LnVsop(1.493E-8, 2.1365672033, 10.9338256793), new Vsop87.LnVsop(1.702E-8, 2.7847833526, 844.5983620429), new Vsop87.LnVsop(1.914E-8, 6.05987746357, 1211.2327491842), new Vsop87.LnVsop(2.038E-8, 1.60297482666, 6588.4220193841), new Vsop87.LnVsop(1.689E-8, 3.06284907974, 0.8031491521), new Vsop87.LnVsop(1.685E-8, 0.28381539862, 521.6142102473), new Vsop87.LnVsop(1.734E-8, 3.45650791724, 1895.9035373848), new Vsop87.LnVsop(1.636E-8, 1.62858153403, 164.3809919672), new Vsop87.LnVsop(1.602E-8, 0.20642761616, 64.4866578288), new Vsop87.LnVsop(1.8E-8, 2.99044739237, 101.6083015103), new Vsop87.LnVsop(1.867E-8, 2.92532022361, 6060.2155269978), new Vsop87.LnVsop(1.822E-8, 4.31796502202, 934.1977554428), new Vsop87.LnVsop(1.66E-8, 5.69708947634, 1291.4309737229), new Vsop87.LnVsop(2.0E-8, 5.18442514436, 452.2010535416), new Vsop87.LnVsop(1.573E-8, 2.39570178134, 614.8369403696), new Vsop87.LnVsop(1.446E-8, 6.12512087543, 568.2970814844), new Vsop87.LnVsop(1.446E-8, 4.58739264257, 418.7338843498), new Vsop87.LnVsop(1.432E-8, 1.97954511274, 504.561183181), new Vsop87.LnVsop(1.578E-8, 4.62126447177, 669.6929346736), new Vsop87.LnVsop(1.773E-8, 3.00675487512, 16.9835910971), new Vsop87.LnVsop(1.514E-8, 0.35161589106, 403.7036411961), new Vsop87.LnVsop(1.888E-8, 3.89724586598, 1440.9941708575), new Vsop87.LnVsop(1.9E-8, 3.58215504368, 3192.5337022735), new Vsop87.LnVsop(1.747E-8, 4.07850521042, 6346.8117482948), new Vsop87.LnVsop(1.747E-8, 2.54077697756, 6197.2485511602), new Vsop87.LnVsop(1.683E-8, 1.9223528062, 181.6464673546), new Vsop87.LnVsop(1.587E-8, 4.9976178222, 6057.2465815812), new Vsop87.LnVsop(1.889E-8, 0.62618826487, 1129.7101106316), new Vsop87.LnVsop(1.753E-8, 1.82324191014, 1020.025054274), new Vsop87.LnVsop(1.753E-8, 3.360970143, 1169.5882514086), new Vsop87.LnVsop(1.407E-8, 3.8766789322, 904.1896587621), new Vsop87.LnVsop(1.658E-8, 0.17315209135, 170.0100662597), new Vsop87.LnVsop(1.612E-8, 4.71519560888, 370.0452755426), new Vsop87.LnVsop(1.456E-8, 5.78909667336, 415.6643651967), new Vsop87.LnVsop(1.472E-8, 3.92804806651, 212.3358875915), new Vsop87.LnVsop(1.776E-8, 5.89527317383, 1593.808197699), new Vsop87.LnVsop(1.776E-8, 4.29157088924, 1743.3713948336), new Vsop87.LnVsop(1.398E-8, 2.89266999881, 376.9463742223), new Vsop87.LnVsop(1.936E-8, 3.02716801943, 10518.6317156037), new Vsop87.LnVsop(1.423E-8, 1.34276219051, 302.7497309916), new Vsop87.LnVsop(1.929E-8, 4.65175583668, 2199.7652340692), new Vsop87.LnVsop(1.93E-8, 3.81505372582, 543.9180590962), new Vsop87.LnVsop(1.581E-8, 4.28040315071, 375.934982266), new Vsop87.LnVsop(1.621E-8, 2.21372960034, 362.0322111701), new Vsop87.LnVsop(1.629E-8, 4.08549980424, 340.5102596139), new Vsop87.LnVsop(1.756E-8, 1.24206336045, 555.6663347757), new Vsop87.LnVsop(1.391E-8, 4.05514082167, 623.2225117576), new Vsop87.LnVsop(1.48E-8, 0.85968170103, 557.0389328994), new Vsop87.LnVsop(1.421E-8, 0.13443282384, 1523.6924655777), new Vsop87.LnVsop(1.421E-8, 1.73813510842, 1374.1292684431), new Vsop87.LnVsop(1.399E-8, 1.64961108641, 356.2700104336), new Vsop87.LnVsop(1.847E-8, 1.78123333872, 25939.82441714789), new Vsop87.LnVsop(1.466E-8, 0.75306338987, 2.0057375701), new Vsop87.LnVsop(1.461E-8, 3.67524662572, 139.1718881765), new Vsop87.LnVsop(1.453E-8, 4.69267570928, 746.7621551013), new Vsop87.LnVsop(1.45E-8, 3.85293024011, 907.3710524998), new Vsop87.LnVsop(1.369E-8, 1.34933149459, 1130.2313754934), new Vsop87.LnVsop(1.42E-8, 2.79221953555, 396.5419100855)};
        private static final Vsop87.LnVsop[] uranus_radius_r1 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.01479896629, 3.67205697578, 74.7815985673), new Vsop87.LnVsop(7.1212143E-4, 6.22600975161, 63.7358983034), new Vsop87.LnVsop(6.862716E-4, 6.13411179902, 149.5631971346), new Vsop87.LnVsop(2.0857554E-4, 5.2462584896, 11.0457002639), new Vsop87.LnVsop(2.1468362E-4, 2.60175716374, 76.2660712756), new Vsop87.LnVsop(2.4059369E-4, 3.14159265359, 0.0), new Vsop87.LnVsop(1.1405056E-4, 0.01849738017, 70.8494453042), new Vsop87.LnVsop(7.496797E-5, 0.42361355955, 73.297125859), new Vsop87.LnVsop(4.243606E-5, 1.41691058162, 85.8272988312), new Vsop87.LnVsop(3.505951E-5, 2.58348117401, 138.5174968707), new Vsop87.LnVsop(3.2288E-5, 5.25495561645, 3.9321532631), new Vsop87.LnVsop(3.926833E-5, 3.15526349399, 71.8126531507), new Vsop87.LnVsop(3.059899E-5, 0.15323842112, 1.4844727083), new Vsop87.LnVsop(3.578254E-5, 2.31157935775, 224.3447957019), new Vsop87.LnVsop(2.564235E-5, 0.98078549108, 148.0787244263), new Vsop87.LnVsop(2.429191E-5, 3.99450740432, 52.6901980395), new Vsop87.LnVsop(1.64483E-5, 2.65310351864, 127.4717966068), new Vsop87.LnVsop(1.583569E-5, 1.4304953436, 78.7137518304), new Vsop87.LnVsop(1.41338E-5, 4.57461623347, 202.2533951741), new Vsop87.LnVsop(1.489724E-5, 2.67568435302, 56.6223513026), new Vsop87.LnVsop(1.40328E-5, 1.36986207457, 77.7505439839), new Vsop87.LnVsop(1.227894E-5, 1.04699377171, 62.2514255951), new Vsop87.LnVsop(1.507836E-5, 5.06019185241, 151.0476698429), new Vsop87.LnVsop(9.91944E-6, 2.1718165585, 65.2203710117), new Vsop87.LnVsop(1.032728E-5, 0.26473484111, 131.4039498699), new Vsop87.LnVsop(8.61752E-6, 5.05508815872, 351.8165923087), new Vsop87.LnVsop(7.44512E-6, 3.07725212553, 35.1640902212), new Vsop87.LnVsop(6.03966E-6, 0.90716451094, 984.6003316219), new Vsop87.LnVsop(6.47014E-6, 4.47286717163, 70.3281804424), new Vsop87.LnVsop(5.74672E-6, 3.2306914554, 447.7958195265), new Vsop87.LnVsop(6.87477E-6, 2.49910872963, 77.962992305), new Vsop87.LnVsop(6.23247E-6, 0.86227007749, 9.5612275556), new Vsop87.LnVsop(5.27867E-6, 5.15141241909, 2.9689454166), new Vsop87.LnVsop(5.61872E-6, 2.71781314149, 462.0229135281), new Vsop87.LnVsop(5.3053E-6, 5.91685160971, 213.299095438), new Vsop87.LnVsop(4.59886E-6, 4.22296426568, 12.5301729722), new Vsop87.LnVsop(4.94251E-6, 0.4632180053, 145.6310438715), new Vsop87.LnVsop(4.87371E-6, 0.70688896635, 380.12776796), new Vsop87.LnVsop(3.80709E-6, 3.85094436388, 3.1813937377), new Vsop87.LnVsop(4.44185E-6, 2.15555848995, 67.6680515665), new Vsop87.LnVsop(3.38646E-6, 2.53719277381, 18.1592472647), new Vsop87.LnVsop(3.72951E-6, 5.05141758574, 529.6909650946), new Vsop87.LnVsop(3.48335E-6, 1.74875375735, 71.6002048296), new Vsop87.LnVsop(4.05615E-6, 1.22950417858, 22.0914005278), new Vsop87.LnVsop(2.68994E-6, 6.2420480531, 340.7708920448), new Vsop87.LnVsop(2.5586E-6, 2.95699944505, 84.3428261229), new Vsop87.LnVsop(2.59244E-6, 3.92085033287, 59.8037450403), new Vsop87.LnVsop(2.24702E-6, 3.90949421678, 160.6088973985), new Vsop87.LnVsop(2.21874E-6, 3.64708443278, 137.0330241624), new Vsop87.LnVsop(2.54339E-6, 3.50524488134, 38.1330356378), new Vsop87.LnVsop(2.382E-6, 2.04842095939, 269.9214467406), new Vsop87.LnVsop(2.72459E-6, 3.38353829996, 222.8603229936), new Vsop87.LnVsop(2.006E-6, 1.24854381161, 69.3649725959), new Vsop87.LnVsop(2.34216E-6, 0.27861629739, 108.4612160802), new Vsop87.LnVsop(1.88802E-6, 4.41158620525, 265.9892934775), new Vsop87.LnVsop(2.12138E-6, 0.68012161063, 111.4301614968), new Vsop87.LnVsop(2.05992E-6, 1.53361539719, 284.1485407422), new Vsop87.LnVsop(1.96457E-6, 4.77133840382, 299.1263942692), new Vsop87.LnVsop(1.53201E-6, 5.21574674133, 209.3669421749), new Vsop87.LnVsop(1.63544E-6, 4.34120077587, 33.6796175129), new Vsop87.LnVsop(1.50382E-6, 1.98905719076, 54.1746707478), new Vsop87.LnVsop(1.36927E-6, 0.40354426815, 195.1398481733), new Vsop87.LnVsop(1.17521E-6, 0.39618046394, 87.3117715395), new Vsop87.LnVsop(1.28577E-6, 2.40591376513, 39.6175083461), new Vsop87.LnVsop(1.04684E-6, 2.91746030897, 134.5853436076), new Vsop87.LnVsop(1.0387E-6, 1.81603765254, 72.3339180125), new Vsop87.LnVsop(1.06087E-6, 0.17146170085, 79.2350166922), new Vsop87.LnVsop(1.06822E-6, 0.69945014388, 2.4476805548), new Vsop87.LnVsop(9.4904E-7, 4.02460487466, 82.8583534146), new Vsop87.LnVsop(1.04645E-6, 4.43615418997, 305.3461693927), new Vsop87.LnVsop(9.3832E-7, 5.01799603662, 51.2057253312), new Vsop87.LnVsop(1.03733E-6, 2.57520994669, 191.2076949102), new Vsop87.LnVsop(1.0682E-6, 1.22984965801, 225.8292684102), new Vsop87.LnVsop(9.358E-7, 3.09257295667, 77.2292791221), new Vsop87.LnVsop(9.7607E-7, 3.8140415956, 152.5321425512), new Vsop87.LnVsop(8.4782E-7, 5.72500693196, 68.8437077341), new Vsop87.LnVsop(7.7488E-7, 0.08155105577, 45.5766510387), new Vsop87.LnVsop(7.6047E-7, 4.2042219855, 73.8183907208), new Vsop87.LnVsop(8.6387E-7, 0.53091293351, 145.1097790097), new Vsop87.LnVsop(7.5755E-7, 3.78546185557, 75.7448064138), new Vsop87.LnVsop(7.7592E-7, 1.63627982289, 479.2883889155), new Vsop87.LnVsop(8.478E-7, 0.61510586137, 116.4260963429), new Vsop87.LnVsop(1.00494E-6, 4.93994320097, 120.358249606), new Vsop87.LnVsop(7.1979E-7, 4.30613043603, 565.1156877467), new Vsop87.LnVsop(7.1236E-7, 2.38119498898, 60.7669528868), new Vsop87.LnVsop(7.1539E-7, 3.93757368948, 153.4953503977), new Vsop87.LnVsop(8.4837E-7, 5.55880391517, 344.7030453079), new Vsop87.LnVsop(6.3516E-7, 1.93751130249, 41.6444977756), new Vsop87.LnVsop(7.1587E-7, 3.7120401109, 408.4389436113), new Vsop87.LnVsop(6.1914E-7, 3.90141588459, 4.4534181249), new Vsop87.LnVsop(6.5088E-7, 1.55911828467, 106.9767433719), new Vsop87.LnVsop(6.0091E-7, 0.60112111486, 74.8934731519), new Vsop87.LnVsop(6.1828E-7, 4.39028435621, 453.424893819), new Vsop87.LnVsop(6.3246E-7, 4.18799696764, 184.7272873558), new Vsop87.LnVsop(6.2339E-7, 3.23753339104, 422.6660376129), new Vsop87.LnVsop(5.4893E-7, 3.72792577723, 7.1135470008), new Vsop87.LnVsop(5.2457E-7, 6.08632045364, 404.5067903482), new Vsop87.LnVsop(5.3071E-7, 3.51022280941, 125.9873238985), new Vsop87.LnVsop(5.9034E-7, 1.55684840494, 456.3938392356), new Vsop87.LnVsop(5.8831E-7, 5.33573241567, 220.4126424388), new Vsop87.LnVsop(5.2838E-7, 5.20104115605, 358.9301393095), new Vsop87.LnVsop(5.2878E-7, 4.44628349017, 426.598190876), new Vsop87.LnVsop(5.5201E-7, 1.60181891958, 14.977853527), new Vsop87.LnVsop(5.0997E-7, 0.52968367981, 490.3340891794), new Vsop87.LnVsop(4.9541E-7, 4.25523625544, 5.4166259714), new Vsop87.LnVsop(5.1389E-7, 0.37029408817, 206.1855484372), new Vsop87.LnVsop(5.1834E-7, 1.7547806765, 8.0767548473), new Vsop87.LnVsop(5.6742E-7, 0.8389113562, 146.594251718), new Vsop87.LnVsop(4.9107E-7, 0.94051631401, 99.1606209555), new Vsop87.LnVsop(4.5714E-7, 5.34241750716, 152.7445908723), new Vsop87.LnVsop(4.8197E-7, 1.97584360072, 288.0806940053), new Vsop87.LnVsop(4.4024E-7, 3.03717070644, 20.6069278195), new Vsop87.LnVsop(4.9092E-7, 5.84636334727, 112.9146342051), new Vsop87.LnVsop(4.1989E-7, 0.0489566624, 128.9562693151), new Vsop87.LnVsop(4.8335E-7, 3.62867663323, 81.0013736908), new Vsop87.LnVsop(4.1451E-7, 2.33805925587, 277.0349937414), new Vsop87.LnVsop(4.0161E-7, 5.0967211278, 35.4247226521), new Vsop87.LnVsop(4.1968E-7, 2.50991447143, 24.3790223882), new Vsop87.LnVsop(3.8204E-7, 3.61405134343, 173.9422195228), new Vsop87.LnVsop(3.8414E-7, 2.06063652881, 333.657345044), new Vsop87.LnVsop(4.2597E-7, 1.260887373, 1514.2912967165), new Vsop87.LnVsop(3.8855E-7, 0.74315611802, 347.8844390456), new Vsop87.LnVsop(3.8552E-7, 4.95041145803, 92.940845832), new Vsop87.LnVsop(3.3234E-7, 1.38358507432, 74.6697239827), new Vsop87.LnVsop(3.3788E-7, 3.68407945156, 66.9172920411), new Vsop87.LnVsop(3.9054E-7, 5.4970292656, 200.7689224658), new Vsop87.LnVsop(3.1786E-7, 0.54344835858, 203.7378678824), new Vsop87.LnVsop(3.3322E-7, 6.26106483857, 1059.3819301892), new Vsop87.LnVsop(3.0806E-7, 2.53797566903, 977.4867846211), new Vsop87.LnVsop(3.0059E-7, 0.19481253674, 387.2413149608), new Vsop87.LnVsop(2.912E-7, 5.44130853027, 58.1068240109), new Vsop87.LnVsop(2.8997E-7, 3.10546504714, 991.7138786227), new Vsop87.LnVsop(2.7827E-7, 0.36512476794, 80.1982245387), new Vsop87.LnVsop(3.5694E-7, 3.72852678524, 96.8729990951), new Vsop87.LnVsop(3.2516E-7, 4.3844786763, 221.3758502853), new Vsop87.LnVsop(2.684E-7, 1.35294770385, 0.9632078465), new Vsop87.LnVsop(3.1276E-7, 0.79566551587, 373.0142209592), new Vsop87.LnVsop(2.5922E-7, 3.45840169631, 144.1465711632), new Vsop87.LnVsop(3.1032E-7, 2.06301188151, 230.5645708254), new Vsop87.LnVsop(3.0278E-7, 0.71358545978, 109.9456887885), new Vsop87.LnVsop(2.4834E-7, 3.04814439142, 14.0146456805), new Vsop87.LnVsop(2.5206E-7, 5.12301274564, 81.3738807063), new Vsop87.LnVsop(2.7765E-7, 4.75859307922, 415.5524906121), new Vsop87.LnVsop(2.5582E-7, 2.56904012503, 522.5774180938), new Vsop87.LnVsop(2.4351E-7, 2.20288762433, 628.8515860501), new Vsop87.LnVsop(2.4132E-7, 5.67351884701, 443.8636662634), new Vsop87.LnVsop(2.5491E-7, 1.78473889586, 143.6253063014), new Vsop87.LnVsop(2.4065E-7, 0.6701080534, 46.2097904851), new Vsop87.LnVsop(2.5679E-7, 5.43185950755, 546.956440482), new Vsop87.LnVsop(2.4624E-7, 3.30585050808, 617.8058857862), new Vsop87.LnVsop(2.4242E-7, 5.59897471399, 32.1951448046), new Vsop87.LnVsop(2.239E-7, 4.82189515313, 135.5485514541), new Vsop87.LnVsop(2.7179E-7, 2.02720095476, 536.8045120954), new Vsop87.LnVsop(2.1973E-7, 4.59216176679, 241.6102710893), new Vsop87.LnVsop(2.2055E-7, 4.61793641919, 391.1734682239), new Vsop87.LnVsop(2.0834E-7, 0.24550904041, 465.9550667912), new Vsop87.LnVsop(2.7275E-7, 2.15420645259, 140.001969579), new Vsop87.LnVsop(2.3632E-7, 4.94972840898, 561.1835344836), new Vsop87.LnVsop(2.1149E-7, 5.27166890173, 159.1244246902), new Vsop87.LnVsop(2.3328E-7, 3.80624099549, 55.1378785943), new Vsop87.LnVsop(2.0015E-7, 1.30330553666, 518.6452648307), new Vsop87.LnVsop(2.4853E-7, 0.5339855631, 181.7583419392), new Vsop87.LnVsop(2.0058E-7, 4.88841177982, 909.8187330546), new Vsop87.LnVsop(1.9193E-7, 1.31168318333, 543.0242872189), new Vsop87.LnVsop(2.0801E-7, 0.91178178054, 76.4785195967), new Vsop87.LnVsop(1.899E-7, 4.67975156701, 98.8999885246), new Vsop87.LnVsop(1.9667E-7, 0.66620464883, 66.70484372), new Vsop87.LnVsop(2.5922E-7, 4.52830002662, 454.9093665273), new Vsop87.LnVsop(1.8833E-7, 6.0804245163, 103.0927742186), new Vsop87.LnVsop(2.1624E-7, 1.23560892029, 41.1019810544), new Vsop87.LnVsop(1.8091E-7, 0.96586313214, 55.6591434561), new Vsop87.LnVsop(2.1264E-7, 4.1951431552, 329.7251917809), new Vsop87.LnVsop(1.8717E-7, 5.77529020491, 142.4496501338), new Vsop87.LnVsop(1.9415E-7, 4.31464975363, 6.2197751235), new Vsop87.LnVsop(2.3318E-7, 5.83851945854, 297.6419215609), new Vsop87.LnVsop(1.6657E-7, 6.09418922673, 211.8146227297), new Vsop87.LnVsop(1.6201E-7, 2.49044081792, 61.2882177486), new Vsop87.LnVsop(2.0158E-7, 3.16239645425, 186.2117600641), new Vsop87.LnVsop(1.6004E-7, 2.97277766861, 81.8951455681), new Vsop87.LnVsop(1.9202E-7, 6.01151966247, 155.7829722581), new Vsop87.LnVsop(1.7468E-7, 4.82367359029, 273.1028404783), new Vsop87.LnVsop(1.5141E-7, 3.65588411554, 472.1748419147), new Vsop87.LnVsop(1.8451E-7, 3.47623430315, 36.6485629295), new Vsop87.LnVsop(1.6303E-7, 0.13085990583, 554.0699874828), new Vsop87.LnVsop(1.8634E-7, 0.23919770714, 23.5758732361), new Vsop87.LnVsop(1.4358E-7, 2.69393539884, 70.1157321213), new Vsop87.LnVsop(1.519E-7, 2.43789398876, 486.4019359163), new Vsop87.LnVsop(1.4488E-7, 0.14254642208, 235.3904959658), new Vsop87.LnVsop(1.3868E-7, 5.09135892763, 29.2049475286), new Vsop87.LnVsop(1.4406E-7, 1.56741430063, 110.2063212194), new Vsop87.LnVsop(1.5722E-7, 4.25156109914, 146.3818033969), new Vsop87.LnVsop(1.7435E-7, 1.95393343617, 835.0371344873), new Vsop87.LnVsop(1.3691E-7, 1.63831110433, 92.0470739547), new Vsop87.LnVsop(1.3239E-7, 2.85690648081, 49.5088043018), new Vsop87.LnVsop(1.2541E-7, 2.92111856784, 60.5545045657), new Vsop87.LnVsop(1.2594E-7, 3.20935822266, 100.3844612329), new Vsop87.LnVsop(1.4937E-7, 0.32571457437, 259.5088859231), new Vsop87.LnVsop(1.2827E-7, 2.77958172785, 105.4922706636), new Vsop87.LnVsop(1.2323E-7, 3.36427641421, 440.6822725257), new Vsop87.LnVsop(1.5261E-7, 0.25477631378, 258.8757464767), new Vsop87.LnVsop(1.2061E-7, 0.08834689678, 157.6399519819), new Vsop87.LnVsop(1.2881E-7, 0.30715003179, 124.2904028691), new Vsop87.LnVsop(1.093E-7, 3.41396817201, 33.1371007917), new Vsop87.LnVsop(1.1062E-7, 4.99201784219, 604.4725636619), new Vsop87.LnVsop(1.0713E-7, 3.88653353837, 767.3690829208), new Vsop87.LnVsop(1.0435E-7, 5.25417558285, 264.5048207692), new Vsop87.LnVsop(1.286E-7, 4.80794300903, 114.3991069134), new Vsop87.LnVsop(1.1561E-7, 2.6045014019, 166.828672522), new Vsop87.LnVsop(1.0926E-7, 0.64149188846, 558.0021407459), new Vsop87.LnVsop(1.232E-7, 4.33795118362, 16.6747745564), new Vsop87.LnVsop(9.947E-8, 0.67247104431, 31.492569389), new Vsop87.LnVsop(1.1298E-7, 0.96114335836, 373.9079928365), new Vsop87.LnVsop(1.215E-7, 1.91679035087, 378.6432952517), new Vsop87.LnVsop(1.2229E-7, 0.70508380884, 218.4069048687), new Vsop87.LnVsop(1.0319E-7, 0.18138367123, 275.5505210331), new Vsop87.LnVsop(1.0753E-7, 5.74480767273, 88.1149206916), new Vsop87.LnVsop(9.402E-8, 0.67913169059, 353.301065017), new Vsop87.LnVsop(1.0651E-7, 2.32656568944, 132.8884225782), new Vsop87.LnVsop(9.113E-8, 2.99457723392, 681.5417840896), new Vsop87.LnVsop(1.0788E-7, 2.62866889129, 154.0166152595), new Vsop87.LnVsop(9.169E-8, 4.79284571455, 216.4804891757), new Vsop87.LnVsop(9.121E-8, 0.77801335714, 67.3592350258), new Vsop87.LnVsop(9.222E-8, 0.73831686735, 129.9194771616), new Vsop87.LnVsop(1.0633E-7, 0.37523847853, 699.7010313543), new Vsop87.LnVsop(9.637E-8, 2.88664912193, 67.8804998876), new Vsop87.LnVsop(8.646E-8, 6.1226167326, 150.5264049811), new Vsop87.LnVsop(8.601E-8, 2.2012646488, 342.2553647531), new Vsop87.LnVsop(9.283E-8, 3.02854870998, 162.0933701068), new Vsop87.LnVsop(9.178E-8, 1.49445512725, 19.643719973), new Vsop87.LnVsop(1.0072E-7, 3.56581375513, 278.5194664497), new Vsop87.LnVsop(9.455E-8, 3.06088366945, 149.6750717192), new Vsop87.LnVsop(9.786E-8, 2.43713607191, 75.3028634291), new Vsop87.LnVsop(9.167E-8, 5.33037538537, 152.0108776894), new Vsop87.LnVsop(8.844E-8, 5.263892204, 80.7194894005), new Vsop87.LnVsop(8.017E-8, 4.7182259586, 106.0135355254), new Vsop87.LnVsop(1.0094E-7, 0.7860106238, 339.2864193365), new Vsop87.LnVsop(8.813E-8, 0.01616162779, 42.5864537627), new Vsop87.LnVsop(7.821E-8, 0.61192552414, 135.336103133), new Vsop87.LnVsop(8.193E-8, 2.59644466423, 469.1364605289), new Vsop87.LnVsop(8.571E-8, 5.69112316506, 760.25553592), new Vsop87.LnVsop(9.277E-8, 1.97750611607, 147.1155165798), new Vsop87.LnVsop(7.482E-8, 2.64377659424, 5.9378908332), new Vsop87.LnVsop(8.699E-8, 0.54050826161, 66.1835788582), new Vsop87.LnVsop(9.761E-8, 2.59090843673, 50.4025761791), new Vsop87.LnVsop(7.547E-8, 5.94593031762, 97.4155158163), new Vsop87.LnVsop(7.597E-8, 5.80197876381, 450.9772132642), new Vsop87.LnVsop(8.669E-8, 3.69932904987, 300.6108669775), new Vsop87.LnVsop(7.728E-8, 1.95146228634, 180.2738692309), new Vsop87.LnVsop(7.309E-8, 4.98689362574, 117.9105690512), new Vsop87.LnVsop(8.195E-8, 2.30281777892, 254.9435932136), new Vsop87.LnVsop(7.536E-8, 1.47100575256, 32.2433289144), new Vsop87.LnVsop(8.473E-8, 1.27680705707, 39.3568759152), new Vsop87.LnVsop(7.026E-8, 0.68091865104, 874.3940104025), new Vsop87.LnVsop(7.389E-8, 4.09295183164, 92.3077063856), new Vsop87.LnVsop(7.314E-8, 5.04313738379, 756.3233826569), new Vsop87.LnVsop(8.454E-8, 1.22026161161, 79.4474650133), new Vsop87.LnVsop(8.732E-8, 1.34335847863, 48.7580447764), new Vsop87.LnVsop(8.7E-8, 0.17463519061, 43.1289704839), new Vsop87.LnVsop(8.187E-8, 4.29619724129, 624.919432787), new Vsop87.LnVsop(6.941E-8, 5.420540286, 610.6923387854), new Vsop87.LnVsop(6.816E-8, 3.90452052962, 480.7728616238), new Vsop87.LnVsop(6.753E-8, 6.03251850119, 350.3321196004), new Vsop87.LnVsop(6.692E-8, 4.78230287697, 142.6620984549), new Vsop87.LnVsop(7.025E-8, 1.27885740826, 68.5618234438), new Vsop87.LnVsop(6.824E-8, 1.36436524169, 291.262087743), new Vsop87.LnVsop(6.9E-8, 3.33848530676, 68.1893164283), new Vsop87.LnVsop(7.254E-8, 3.18927739209, 268.4369740323), new Vsop87.LnVsop(7.635E-8, 4.81180010568, 312.4597163935), new Vsop87.LnVsop(8.135E-8, 1.99010407624, 692.5874843535), new Vsop87.LnVsop(6.31E-8, 5.42075206842, 88.7962442478), new Vsop87.LnVsop(6.477E-8, 1.05239284135, 685.4739373527), new Vsop87.LnVsop(7.121E-8, 5.79764411155, 468.2426886516), new Vsop87.LnVsop(6.32E-8, 2.58497126634, 458.090760265), new Vsop87.LnVsop(6.775E-8, 2.59596588927, 282.6640680339), new Vsop87.LnVsop(6.222E-8, 5.68982546821, 113.8778420516), new Vsop87.LnVsop(8.525E-8, 0.00581798397, 227.3137411185), new Vsop87.LnVsop(6.52E-8, 3.99093726386, 42.5382696529), new Vsop87.LnVsop(6.435E-8, 1.03721543099, 365.9006739584), new Vsop87.LnVsop(8.153E-8, 4.04274797388, 183.2428146475), new Vsop87.LnVsop(6.039E-8, 4.35471040863, 19.1224551112), new Vsop87.LnVsop(8.149E-8, 1.12461637867, 69.1525242748), new Vsop87.LnVsop(6.151E-8, 2.783037838, 121.8427223143), new Vsop87.LnVsop(7.815E-8, 0.55588235015, 296.1574488526), new Vsop87.LnVsop(5.989E-8, 4.98445156091, 184.0941479094), new Vsop87.LnVsop(6.379E-8, 0.16323583721, 228.276948965), new Vsop87.LnVsop(6.269E-8, 4.22014121556, 119.5069163441), new Vsop87.LnVsop(5.982E-8, 5.44774666431, 17.5261078183), new Vsop87.LnVsop(5.87E-8, 0.36534808613, 148.5999892881), new Vsop87.LnVsop(5.868E-8, 5.39245291119, 95.3885263868), new Vsop87.LnVsop(5.906E-8, 0.97697194245, 13.3333221243), new Vsop87.LnVsop(5.78E-8, 0.17831781847, 458.8415197904), new Vsop87.LnVsop(5.719E-8, 4.74598221436, 248.7238180901), new Vsop87.LnVsop(5.534E-8, 4.24741728108, 75.5323580927), new Vsop87.LnVsop(5.63E-8, 2.81567861587, 154.979823106), new Vsop87.LnVsop(6.26E-8, 3.52991762509, 285.6330134505), new Vsop87.LnVsop(6.919E-8, 3.31432622158, 306.830642101), new Vsop87.LnVsop(6.087E-8, 4.04640130992, 271.4059194489), new Vsop87.LnVsop(6.866E-8, 1.3429923722, 7.8643065262), new Vsop87.LnVsop(5.586E-8, 5.33279407873, 920.8644333185), new Vsop87.LnVsop(6.528E-8, 0.45565192064, 106.2741679563), new Vsop87.LnVsop(5.586E-8, 0.29304653043, 173.6815870919), new Vsop87.LnVsop(5.353E-8, 2.49825965802, 24.1183899573), new Vsop87.LnVsop(6.205E-8, 5.27879491339, 120.9913890524), new Vsop87.LnVsop(5.974E-8, 3.62786821437, 189.7232222019), new Vsop87.LnVsop(5.176E-8, 3.69984512887, 778.4147831847), new Vsop87.LnVsop(5.24E-8, 4.14231460056, 89.7594520943), new Vsop87.LnVsop(5.172E-8, 1.54846732288, 193.655375465), new Vsop87.LnVsop(6.36E-8, 0.35370738254, 411.620337349), new Vsop87.LnVsop(5.26E-8, 1.26005665335, 267.4737661858), new Vsop87.LnVsop(6.906E-8, 4.88299482194, 419.4846438752), new Vsop87.LnVsop(6.332E-8, 5.25617761055, 58.319272332), new Vsop87.LnVsop(5.993E-8, 4.70505278581, 298.2326223919), new Vsop87.LnVsop(5.507E-8, 2.72405080404, 986.0848043302), new Vsop87.LnVsop(4.936E-8, 6.07953205967, 134.0640787458), new Vsop87.LnVsop(5.469E-8, 6.2163560823, 91.4563731237), new Vsop87.LnVsop(4.846E-8, 5.6671411571, 90.8232336773), new Vsop87.LnVsop(4.87E-8, 1.24431497533, 25.6028626656), new Vsop87.LnVsop(6.149E-8, 1.88362168986, 397.3932433474), new Vsop87.LnVsop(5.154E-8, 3.37555501409, 831.1049812242), new Vsop87.LnVsop(5.253E-8, 1.85387498292, 114.9416236346), new Vsop87.LnVsop(5.163E-8, 0.49175608455, 16.4623262353), new Vsop87.LnVsop(4.67E-8, 0.85077620511, 403.0223176399), new Vsop87.LnVsop(4.688E-8, 4.94827397388, 902.7051860538), new Vsop87.LnVsop(5.005E-8, 1.40309022449, 6.1503391543), new Vsop87.LnVsop(5.217E-8, 0.27521357608, 192.6921676185), new Vsop87.LnVsop(6.177E-8, 2.78454594522, 198.321241911), new Vsop87.LnVsop(5.014E-8, 5.57665259095, 451.9404211107), new Vsop87.LnVsop(4.58E-8, 2.47734499363, 31.2319369581), new Vsop87.LnVsop(5.129E-8, 3.2352870415, 109.3125493421), new Vsop87.LnVsop(5.74E-8, 0.95870813397, 483.2205421786), new Vsop87.LnVsop(4.369E-8, 6.21847573079, 207.8824694666), new Vsop87.LnVsop(4.425E-8, 2.74721673213, 823.9914342234), new Vsop87.LnVsop(4.299E-8, 0.66587852826, 210.3301500214), new Vsop87.LnVsop(4.527E-8, 1.8736581989, 44.7253177768), new Vsop87.LnVsop(4.484E-8, 1.03729827686, 606.7601855223), new Vsop87.LnVsop(4.135E-8, 0.41031273891, 180.1619946463), new Vsop87.LnVsop(4.646E-8, 5.82325024322, 905.8865797915), new Vsop87.LnVsop(4.086E-8, 4.84914558939, 124.5028511902), new Vsop87.LnVsop(4.486E-8, 0.35223479841, 457.8783119439), new Vsop87.LnVsop(4.318E-8, 1.68857333749, 309.2783226558), new Vsop87.LnVsop(5.151E-8, 2.90867214997, 28.3111756513), new Vsop87.LnVsop(4.061E-8, 3.32301396744, 107.4980082337), new Vsop87.LnVsop(4.332E-8, 1.41872733238, 25.1297819136), new Vsop87.LnVsop(4.944E-8, 5.87125173636, 303.8616966844), new Vsop87.LnVsop(4.407E-8, 5.2874885047, 449.2802922348), new Vsop87.LnVsop(4.18E-8, 1.67985859496, 7.4223635415), new Vsop87.LnVsop(3.977E-8, 3.22662754639, 639.897286314), new Vsop87.LnVsop(5.415E-8, 2.15030495019, 187.6962327724), new Vsop87.LnVsop(4.217E-8, 0.73382717079, 497.4476361802), new Vsop87.LnVsop(4.875E-8, 0.88184557385, 255.0554677982), new Vsop87.LnVsop(4.758E-8, 4.60909386948, 258.0244132148), new Vsop87.LnVsop(5.337E-8, 2.36556705745, 477.8039162072), new Vsop87.LnVsop(4.456E-8, 1.74674336635, 95.9792272178), new Vsop87.LnVsop(4.138E-8, 3.80344455465, 460.5384408198), new Vsop87.LnVsop(3.843E-8, 4.02615028031, 104.0077979553), new Vsop87.LnVsop(5.032E-8, 0.36645338967, 123.5396433437), new Vsop87.LnVsop(3.78E-8, 2.89085160996, 27.0873353739), new Vsop87.LnVsop(4.309E-8, 4.77464606019, 463.5073862364), new Vsop87.LnVsop(3.779E-8, 3.05636034284, 142.1408335931), new Vsop87.LnVsop(4.357E-8, 3.73616179561, 376.1956146969), new Vsop87.LnVsop(3.705E-8, 2.47343159576, 25.2727942655), new Vsop87.LnVsop(4.232E-8, 4.31629167726, 446.3113468182), new Vsop87.LnVsop(3.576E-8, 2.55404008547, 6.592282139), new Vsop87.LnVsop(3.685E-8, 3.26448469664, 170.7608257851), new Vsop87.LnVsop(3.575E-8, 4.31199276037, 572.2292347475), new Vsop87.LnVsop(4.496E-8, 2.10358455875, 838.218528225), new Vsop87.LnVsop(3.716E-8, 0.20018583737, 394.3548619616), new Vsop87.LnVsop(3.846E-8, 5.8108074508, 586.3133163972), new Vsop87.LnVsop(3.527E-8, 4.05179036599, 433.7117378768), new Vsop87.LnVsop(3.524E-8, 3.75716903766, 473.068613792), new Vsop87.LnVsop(3.501E-8, 4.445648846, 384.0599212231), new Vsop87.LnVsop(3.636E-8, 2.12955997197, 73.1852512744), new Vsop87.LnVsop(3.841E-8, 5.28811045359, 43.2890291783), new Vsop87.LnVsop(3.928E-8, 4.26291422687, 196.6243208816), new Vsop87.LnVsop(3.702E-8, 3.86923731076, 981.6313862053), new Vsop87.LnVsop(3.445E-8, 2.10100539423, 316.3918696566), new Vsop87.LnVsop(3.432E-8, 2.97356096189, 535.9107402181), new Vsop87.LnVsop(4.312E-8, 0.38740046308, 988.532484885), new Vsop87.LnVsop(3.867E-8, 2.08559458308, 457.3570470821), new Vsop87.LnVsop(3.353E-8, 4.19681836937, 114.1384744825), new Vsop87.LnVsop(4.128E-8, 3.06165703137, 377.1588225434), new Vsop87.LnVsop(3.545E-8, 4.41886084391, 1293.8786542777), new Vsop87.LnVsop(3.309E-8, 3.54050386234, 520.129737539), new Vsop87.LnVsop(3.337E-8, 6.23473900765, 9947.0556815321), new Vsop87.LnVsop(4.527E-8, 4.61192905449, 47.061123747), new Vsop87.LnVsop(3.523E-8, 2.00908999163, 47.6942631934), new Vsop87.LnVsop(3.37E-8, 3.65249455401, 976.0023119128), new Vsop87.LnVsop(3.29E-8, 6.135297351, 34.2008823747), new Vsop87.LnVsop(3.253E-8, 5.22413528932, 425.1137181677), new Vsop87.LnVsop(3.461E-8, 5.18605119393, 993.198351331), new Vsop87.LnVsop(3.712E-8, 2.53410725291, 237.6781178262), new Vsop87.LnVsop(3.24E-8, 3.56995183051, 17.2654753874), new Vsop87.LnVsop(3.362E-8, 1.26285882591, 233.9060232575), new Vsop87.LnVsop(3.606E-8, 1.94705146379, 661.0949149645), new Vsop87.LnVsop(3.182E-8, 0.3660331511, 449.4927405559), new Vsop87.LnVsop(3.427E-8, 6.03153107557, 199.2844497575), new Vsop87.LnVsop(3.169E-8, 2.55715329118, 6133.5126528568), new Vsop87.LnVsop(3.994E-8, 4.53148620187, 916.9322800554), new Vsop87.LnVsop(4.413E-8, 4.14550138614, 219.891377577), new Vsop87.LnVsop(3.6E-8, 4.16003477661, 214.7835681463), new Vsop87.LnVsop(4.193E-8, 4.26425258521, 381.6122406683), new Vsop87.LnVsop(3.846E-8, 3.76849990033, 8.5980197091), new Vsop87.LnVsop(3.183E-8, 3.15317674552, 15.1903018481), new Vsop87.LnVsop(3.35E-8, 5.63661413371, 444.8268741099), new Vsop87.LnVsop(3.78E-8, 5.35722293289, 328.2407190726), new Vsop87.LnVsop(3.166E-8, 2.16351748263, 983.1158589136), new Vsop87.LnVsop(3.93E-8, 2.09444900058, 653.9813679637), new Vsop87.LnVsop(3.585E-8, 1.24517449239, 162.8965192589), new Vsop87.LnVsop(3.527E-8, 1.89208045227, 280.9671470045), new Vsop87.LnVsop(3.282E-8, 1.91872815218, 2349.3284312038), new Vsop87.LnVsop(3.076E-8, 4.77282170585, 820.0592809603), new Vsop87.LnVsop(3.399E-8, 5.35259772941, 141.6988906084), new Vsop87.LnVsop(3.269E-8, 0.52855777633, 450.4559484024), new Vsop87.LnVsop(3.582E-8, 1.60170266832, 1587.5884225755), new Vsop87.LnVsop(3.044E-8, 0.84602343274, 30.7106720963), new Vsop87.LnVsop(3.616E-8, 6.16820602029, 171.6545976624), new Vsop87.LnVsop(3.007E-8, 4.69605806277, 978.9712573294), new Vsop87.LnVsop(3.528E-8, 4.79818282081, 406.954470903), new Vsop87.LnVsop(2.98E-8, 2.17792323043, 597.3590166611), new Vsop87.LnVsop(2.977E-8, 0.6947862817, 294.3004691288), new Vsop87.LnVsop(3.411E-8, 1.18022650672, 167.7224443993), new Vsop87.LnVsop(4.049E-8, 3.15153850922, 833.552661779), new Vsop87.LnVsop(3.725E-8, 5.84743216544, 6058.7310542895), new Vsop87.LnVsop(3.242E-8, 0.63525153286, 141.4864422873), new Vsop87.LnVsop(3.683E-8, 1.86888555615, 371.5297482509), new Vsop87.LnVsop(3.877E-8, 1.44138798341, 346.1875180162), new Vsop87.LnVsop(3.142E-8, 2.26934250738, 517.1607921224), new Vsop87.LnVsop(4.077E-8, 0.07273073033, 1190.0351205337), new Vsop87.LnVsop(2.893E-8, 3.53141229605, 94.4253185403), new Vsop87.LnVsop(3.02E-8, 2.64998251178, 20.4468691251), new Vsop87.LnVsop(3.11E-8, 1.11431255827, 1044.4040766622), new Vsop87.LnVsop(2.836E-8, 0.62522723719, 749.2098356561), new Vsop87.LnVsop(2.898E-8, 4.11830043593, 600.5404103988), new Vsop87.LnVsop(2.819E-8, 4.72400465237, 122.4758617607), new Vsop87.LnVsop(3.572E-8, 1.96375884146, 372.4235201282), new Vsop87.LnVsop(2.801E-8, 3.99301180541, 10063.7223490764), new Vsop87.LnVsop(2.806E-8, 3.85026986935, 133.1008708993), new Vsop87.LnVsop(2.791E-8, 6.24681129336, 908.3342603463), new Vsop87.LnVsop(3.466E-8, 3.43275071793, 82.6459050935), new Vsop87.LnVsop(3.725E-8, 1.68366366742, 683.9894646444), new Vsop87.LnVsop(3.763E-8, 3.28247771799, 432.8179659995), new Vsop87.LnVsop(3.493E-8, 0.98765698465, 9988.9407505091), new Vsop87.LnVsop(3.523E-8, 5.12512607932, 105.380396079), new Vsop87.LnVsop(3.432E-8, 2.8048316223, 764.1876891831), new Vsop87.LnVsop(2.733E-8, 0.42373696972, 354.9979860464), new Vsop87.LnVsop(3.041E-8, 5.75641149588, 409.9234163196), new Vsop87.LnVsop(3.379E-8, 5.47448876584, 1396.2206689709), new Vsop87.LnVsop(3.102E-8, 0.41684444831, 521.0929453855), new Vsop87.LnVsop(2.863E-8, 0.41519700992, 894.8408795276), new Vsop87.LnVsop(3.128E-8, 5.23384180625, 424.1505103212), new Vsop87.LnVsop(2.688E-8, 3.59170326422, 621.7380390493), new Vsop87.LnVsop(2.848E-8, 2.16605887838, 216.9224321604), new Vsop87.LnVsop(2.673E-8, 1.60411606116, 136.0698163159), new Vsop87.LnVsop(3.414E-8, 4.93712749827, 1140.38330388), new Vsop87.LnVsop(2.653E-8, 5.10283251074, 118.0224436358), new Vsop87.LnVsop(2.73E-8, 4.22647867347, 990.2294059144), new Vsop87.LnVsop(3.113E-8, 5.23808775951, 417.0369633204), new Vsop87.LnVsop(3.289E-8, 4.26401031509, 544.5087599272), new Vsop87.LnVsop(3.1E-8, 5.4792852793, 701.1855040626), new Vsop87.LnVsop(2.785E-8, 5.19343849093, 144.8973306886), new Vsop87.LnVsop(2.605E-8, 4.82136791856, 362.8622925726), new Vsop87.LnVsop(3.183E-8, 4.76078229245, 294.6729761443), new Vsop87.LnVsop(3.55E-8, 3.82073713802, 511.5317178299), new Vsop87.LnVsop(2.641E-8, 3.49997209213, 293.188503436), new Vsop87.LnVsop(2.788E-8, 1.54956737675, 28.5718080822), new Vsop87.LnVsop(2.897E-8, 0.37376102831, 582.3811631341), new Vsop87.LnVsop(2.615E-8, 2.25516923974, 74.9940468884), new Vsop87.LnVsop(3.582E-8, 1.27992264402, 987.5692770385), new Vsop87.LnVsop(3.115E-8, 5.10929689813, 459.0539681115), new Vsop87.LnVsop(2.589E-8, 1.83177157042, 657.1627617014), new Vsop87.LnVsop(2.539E-8, 4.14968938109, 74.7334144575), new Vsop87.LnVsop(2.797E-8, 2.82242772664, 2036.8687148103), new Vsop87.LnVsop(2.688E-8, 2.16500211397, 262.8078997398), new Vsop87.LnVsop(2.817E-8, 6.06679932038, 374.4986936675), new Vsop87.LnVsop(2.539E-8, 0.46036497385, 74.8297826771), new Vsop87.LnVsop(2.504E-8, 3.523948017, 1183.6723330583), new Vsop87.LnVsop(2.565E-8, 1.64023845161, 73.4090004436), new Vsop87.LnVsop(2.663E-8, 4.23321349902, 421.1815649046), new Vsop87.LnVsop(3.019E-8, 1.62290757266, 414.0680179038), new Vsop87.LnVsop(2.793E-8, 2.00644423849, 75.0422309982), new Vsop87.LnVsop(3.253E-8, 2.43153394317, 98.3574718034), new Vsop87.LnVsop(2.883E-8, 2.41875736533, 4.665866446), new Vsop87.LnVsop(2.553E-8, 1.25909246207, 670.4960838257), new Vsop87.LnVsop(3.135E-8, 1.96936617667, 842.1506814881), new Vsop87.LnVsop(2.604E-8, 3.87350462519, 74.0308390419), new Vsop87.LnVsop(2.51E-8, 3.35948960782, 464.9918589447), new Vsop87.LnVsop(3.05E-8, 1.8107797128, 331.2096644892), new Vsop87.LnVsop(3.005E-8, 0.81031349171, 73.88782669), new Vsop87.LnVsop(2.701E-8, 5.89709637826, 525.2375469697), new Vsop87.LnVsop(3.11E-8, 6.14956891318, 118.8737768977), new Vsop87.LnVsop(2.774E-8, 6.26134027482, 1022.3126761344), new Vsop87.LnVsop(2.402E-8, 4.38353347008, 1303.2798231389), new Vsop87.LnVsop(2.8E-8, 2.60339313269, 74.5209661364), new Vsop87.LnVsop(3.005E-8, 0.76247280223, 75.6753704446), new Vsop87.LnVsop(2.434E-8, 4.9478467943, 969.6224780949), new Vsop87.LnVsop(2.63E-8, 0.62894209942, 227.5261894396), new Vsop87.LnVsop(2.669E-8, 0.7334022821, 73.0846775379), new Vsop87.LnVsop(2.465E-8, 1.3064877338, 77.0692204277), new Vsop87.LnVsop(2.395E-8, 2.76580569447, 768.8535556291), new Vsop87.LnVsop(2.753E-8, 5.59058621175, 388.7257876691), new Vsop87.LnVsop(3.23E-8, 0.01981320255, 881.5075574033), new Vsop87.LnVsop(3.008E-8, 5.6595546366, 1969.2006632438), new Vsop87.LnVsop(3.008E-8, 0.91409756228, 2118.7638603784), new Vsop87.LnVsop(2.465E-8, 0.26629856014, 72.4939767069), new Vsop87.LnVsop(2.313E-8, 3.37979302623, 286.596221297), new Vsop87.LnVsop(2.272E-8, 2.77069357318, 515.463871093), new Vsop87.LnVsop(2.579E-8, 4.80372721669, 103.3534066495), new Vsop87.LnVsop(2.36E-8, 4.12736987374, 74.6215398729), new Vsop87.LnVsop(2.22E-8, 2.17920233841, 491.8185618877), new Vsop87.LnVsop(2.498E-8, 1.19812774743, 383.0967133766), new Vsop87.LnVsop(2.981E-8, 3.15769661969, 1887.3055176757), new Vsop87.LnVsop(2.57E-8, 3.1385967429, 229.0800981171), new Vsop87.LnVsop(2.355E-8, 0.48259604722, 74.9416572617), new Vsop87.LnVsop(2.228E-8, 1.4245214891, 6219.339951688), new Vsop87.LnVsop(2.184E-8, 5.18000549953, 59.2824801785), new Vsop87.LnVsop(2.319E-8, 2.10326941903, 11.1575748485), new Vsop87.LnVsop(2.724E-8, 3.48225905765, 10.2949407385), new Vsop87.LnVsop(2.162E-8, 3.61282527361, 22.633917249), new Vsop87.LnVsop(2.232E-8, 3.98572942665, 68.631259413), new Vsop87.LnVsop(2.39E-8, 2.47806087593, 177.8743727859), new Vsop87.LnVsop(2.199E-8, 0.22998162264, 217.2312487011), new Vsop87.LnVsop(2.915E-8, 5.18526716284, 218.9281697305), new Vsop87.LnVsop(2.875E-8, 2.77889026188, 184.9879197867), new Vsop87.LnVsop(2.865E-8, 0.62015957113, 1411.1985224979), new Vsop87.LnVsop(2.298E-8, 3.95654643159, 26.0235537909), new Vsop87.LnVsop(2.318E-8, 1.21463632824, 291.7040307277), new Vsop87.LnVsop(2.56E-8, 1.48802298081, 1055.4497769261), new Vsop87.LnVsop(2.796E-8, 5.59819583385, 260.9933586314), new Vsop87.LnVsop(2.492E-8, 4.25519394022, 149.45132255), new Vsop87.LnVsop(2.007E-8, 6.11892578566, 63.6240237188), new Vsop87.LnVsop(2.11E-8, 3.59139003023, 256.4280659219), new Vsop87.LnVsop(2.198E-8, 4.46404375855, 524.0618908021), new Vsop87.LnVsop(2.706E-8, 0.80150714262, 89.0086925689), new Vsop87.LnVsop(2.41E-8, 2.28619111368, 74.2603337055), new Vsop87.LnVsop(2.102E-8, 3.18561308775, 635.9651330509), new Vsop87.LnVsop(2.006E-8, 1.30247563131, 385.7568422525), new Vsop87.LnVsop(2.304E-8, 3.60550712225, 115.8835796217), new Vsop87.LnVsop(1.899E-8, 2.42426868365, 273.8536000037), new Vsop87.LnVsop(2.119E-8, 5.98199852906, 559.6990617753), new Vsop87.LnVsop(2.152E-8, 5.30772822745, 2.0057375701), new Vsop87.LnVsop(2.447E-8, 5.10278930542, 205.2223405907), new Vsop87.LnVsop(1.962E-8, 1.45399000044, 80.4106728598), new Vsop87.LnVsop(1.895E-8, 3.30475087405, 46.470422916), new Vsop87.LnVsop(1.942E-8, 1.79179369066, 346.3999663373), new Vsop87.LnVsop(1.85E-8, 5.74338030118, 175.1660598002), new Vsop87.LnVsop(1.848E-8, 2.74750349182, 429.7795846137), new Vsop87.LnVsop(1.848E-8, 1.20977525896, 280.2163874791), new Vsop87.LnVsop(2.22E-8, 1.12912931401, 323.5054166574), new Vsop87.LnVsop(1.839E-8, 3.5808636747, 327.4375699205), new Vsop87.LnVsop(1.839E-8, 4.86693953738, 507.5995645668), new Vsop87.LnVsop(1.848E-8, 5.26302620499, 81.682697247), new Vsop87.LnVsop(1.996E-8, 4.36291795113, 1812.5239191084), new Vsop87.LnVsop(1.893E-8, 0.10622820999, 93.9040536785), new Vsop87.LnVsop(2.368E-8, 2.77235858734, 477.0007670551), new Vsop87.LnVsop(1.891E-8, 2.25571301508, 4.7353024152), new Vsop87.LnVsop(1.792E-8, 1.5975940843, 832.5894539325), new Vsop87.LnVsop(1.792E-8, 3.20129636889, 683.0262567979), new Vsop87.LnVsop(2.092E-8, 0.32766195745, 343.2185725996), new Vsop87.LnVsop(1.792E-8, 5.80267442975, 779.899255893), new Vsop87.LnVsop(1.726E-8, 3.18023607065, 332.1728723357), new Vsop87.LnVsop(1.831E-8, 3.75183606052, 469.7271613599), new Vsop87.LnVsop(1.831E-8, 5.28956429339, 619.2903584945), new Vsop87.LnVsop(1.721E-8, 0.80119805379, 1432.3961511484), new Vsop87.LnVsop(1.721E-8, 2.33892628665, 1581.959348283), new Vsop87.LnVsop(1.978E-8, 1.7419645108, 331.3215390738), new Vsop87.LnVsop(1.895E-8, 5.31311179301, 253.5709950899), new Vsop87.LnVsop(1.758E-8, 2.96038070029, 1596.1864422846), new Vsop87.LnVsop(1.758E-8, 1.42265246742, 1446.62324515), new Vsop87.LnVsop(2.109E-8, 0.73357181364, 758.7710632117), new Vsop87.LnVsop(1.911E-8, 0.46392477628, 1589.0728952838), new Vsop87.LnVsop(1.96E-8, 5.98949067581, 1392.2885157078), new Vsop87.LnVsop(1.96E-8, 1.31000765322, 1242.7253185732), new Vsop87.LnVsop(1.833E-8, 6.18306213718, 535.3200393871), new Vsop87.LnVsop(2.195E-8, 0.42296220916, 703.6331846174), new Vsop87.LnVsop(1.815E-8, 5.00776376696, 255.8373650909), new Vsop87.LnVsop(1.89E-8, 0.32598438166, 221.1634019642), new Vsop87.LnVsop(1.864E-8, 2.6802330408, 405.9912630565), new Vsop87.LnVsop(2.065E-8, 6.09002439734, 763.4369296577), new Vsop87.LnVsop(2.065E-8, 4.55229616447, 613.8737325231), new Vsop87.LnVsop(1.61E-8, 4.9140818566, 115.3623147599), new Vsop87.LnVsop(1.823E-8, 5.54014516908, 357.4456666012), new Vsop87.LnVsop(1.62E-8, 2.90668209411, 609.2078660771), new Vsop87.LnVsop(1.604E-8, 3.64436334999, 30.0562807905), new Vsop87.LnVsop(1.578E-8, 6.12288879129, 423.6292454594), new Vsop87.LnVsop(1.754E-8, 3.29214293116, 1515.7757694248), new Vsop87.LnVsop(1.819E-8, 6.21015313585, 215.4379594521), new Vsop87.LnVsop(1.679E-8, 2.61674435978, 181.0557665236), new Vsop87.LnVsop(1.907E-8, 5.520303318, 602.9880909536), new Vsop87.LnVsop(1.52E-8, 1.94954212244, 1228.4982245716), new Vsop87.LnVsop(1.52E-8, 0.34583983785, 1378.0614217062), new Vsop87.LnVsop(1.538E-8, 4.79041960434, 543.9180590962), new Vsop87.LnVsop(1.518E-8, 3.84678636307, 14.2270940016), new Vsop87.LnVsop(1.851E-8, 4.61165114292, 774.4826299216), new Vsop87.LnVsop(1.52E-8, 3.24071154201, 39.0962434843), new Vsop87.LnVsop(1.647E-8, 5.88231739154, 398.8777160557), new Vsop87.LnVsop(1.471E-8, 1.35595542925, 481.7360694703), new Vsop87.LnVsop(1.469E-8, 5.56206799884, 301.4140161296), new Vsop87.LnVsop(1.474E-8, 1.58634608266, 274.0660483248), new Vsop87.LnVsop(1.48E-8, 6.05250894033, 194.2885149114), new Vsop87.LnVsop(1.473E-8, 0.67726919761, 539.2521926502), new Vsop87.LnVsop(1.472E-8, 3.07440978254, 50.66320861), new Vsop87.LnVsop(1.564E-8, 5.43230552977, 459.3627846522), new Vsop87.LnVsop(1.468E-8, 5.20182042843, 130.4407420234), new Vsop87.LnVsop(1.802E-8, 2.75155368399, 30.5987975117), new Vsop87.LnVsop(1.483E-8, 2.08618845205, 69.6737891366), new Vsop87.LnVsop(1.433E-8, 3.35897454068, 267.5856407704), new Vsop87.LnVsop(1.801E-8, 6.06701083819, 210.8514148832), new Vsop87.LnVsop(1.473E-8, 1.65632386952, 1052.2683831884), new Vsop87.LnVsop(1.392E-8, 3.13732434239, 369.0820676961), new Vsop87.LnVsop(1.502E-8, 0.28443439725, 495.9631634719), new Vsop87.LnVsop(1.403E-8, 4.98324477005, 35.685355083), new Vsop87.LnVsop(1.404E-8, 3.16559098208, 255.57673266), new Vsop87.LnVsop(1.456E-8, 5.36560710378, 6283.0758499914), new Vsop87.LnVsop(1.412E-8, 0.68968780108, 348.8476468921), new Vsop87.LnVsop(1.589E-8, 4.89344411716, 1366.2125722902), new Vsop87.LnVsop(1.426E-8, 5.72934799733, 335.1418177523), new Vsop87.LnVsop(1.469E-8, 4.66006940636, 893.3564068193), new Vsop87.LnVsop(1.469E-8, 6.26377169094, 743.7932096847), new Vsop87.LnVsop(1.668E-8, 1.29876086261, 1673.2556627123), new Vsop87.LnVsop(1.668E-8, 2.90246314719, 1523.6924655777), new Vsop87.LnVsop(1.526E-8, 5.93140614398, 1662.9607219738), new Vsop87.LnVsop(1.373E-8, 4.85710108204, 61.448276443), new Vsop87.LnVsop(1.366E-8, 4.78315200862, 470.6903692064), new Vsop87.LnVsop(1.39E-8, 5.7698716402, 79.889407998), new Vsop87.LnVsop(1.461E-8, 3.00376275716, 632.7837393132)};
        private static final Vsop87.LnVsop[] uranus_radius_r2 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(2.2439899E-4, 0.69953310903, 74.7815985673), new Vsop87.LnVsop(4.726838E-5, 1.69896897296, 63.7358983034), new Vsop87.LnVsop(1.681383E-5, 4.64842242588, 70.8494453042), new Vsop87.LnVsop(1.433633E-5, 3.52135281258, 149.5631971346), new Vsop87.LnVsop(1.649477E-5, 3.09669484042, 11.0457002639), new Vsop87.LnVsop(7.69974E-6, 0.0, 0.0), new Vsop87.LnVsop(4.61159E-6, 0.76667185672, 3.9321532631), new Vsop87.LnVsop(5.00193E-6, 6.17218448634, 76.2660712756), new Vsop87.LnVsop(3.90377E-6, 4.49603136758, 56.6223513026), new Vsop87.LnVsop(3.89972E-6, 5.52663268311, 85.8272988312), new Vsop87.LnVsop(2.92283E-6, 0.20370820668, 52.6901980395), new Vsop87.LnVsop(2.72269E-6, 3.8473537521, 138.5174968707), new Vsop87.LnVsop(2.86451E-6, 3.53449822561, 73.297125859), new Vsop87.LnVsop(2.05341E-6, 3.24759155116, 78.7137518304), new Vsop87.LnVsop(2.19349E-6, 1.96433948894, 131.4039498699), new Vsop87.LnVsop(2.15812E-6, 0.84820922453, 77.962992305), new Vsop87.LnVsop(1.2904E-6, 2.08142441038, 3.1813937377), new Vsop87.LnVsop(1.48716E-6, 4.89757177249, 127.4717966068), new Vsop87.LnVsop(1.17642E-6, 4.93417950365, 447.7958195265), new Vsop87.LnVsop(1.12873E-6, 1.01358614296, 462.0229135281), new Vsop87.LnVsop(9.9082E-7, 6.15736951949, 224.3447957019), new Vsop87.LnVsop(9.1634E-7, 0.68110922044, 18.1592472647), new Vsop87.LnVsop(8.9537E-7, 0.23396296581, 202.2533951741), new Vsop87.LnVsop(8.8475E-7, 2.93078580361, 62.2514255951), new Vsop87.LnVsop(1.13471E-6, 4.78996247308, 145.6310438715), new Vsop87.LnVsop(1.03857E-6, 3.58561861261, 71.6002048296), new Vsop87.LnVsop(6.1854E-7, 3.29891157272, 351.8165923087), new Vsop87.LnVsop(5.7828E-7, 4.90530751807, 22.0914005278), new Vsop87.LnVsop(6.4448E-7, 3.38789169908, 1.4844727083), new Vsop87.LnVsop(7.111E-7, 6.10490045777, 454.9093665273), new Vsop87.LnVsop(5.092E-7, 3.86475363643, 65.2203710117), new Vsop87.LnVsop(6.3666E-7, 3.96437325595, 67.6680515665), new Vsop87.LnVsop(5.9151E-7, 5.54929939724, 9.5612275556), new Vsop87.LnVsop(4.8713E-7, 3.74773116593, 269.9214467406), new Vsop87.LnVsop(4.401E-7, 1.92372120641, 59.8037450403), new Vsop87.LnVsop(4.2677E-7, 2.61696151844, 151.0476698429), new Vsop87.LnVsop(4.4556E-7, 5.90316779799, 71.8126531507), new Vsop87.LnVsop(4.2421E-7, 6.1363853032, 284.1485407422), new Vsop87.LnVsop(3.7328E-7, 5.91300114911, 984.6003316219), new Vsop87.LnVsop(4.2329E-7, 2.08837866544, 12.5301729722), new Vsop87.LnVsop(3.6234E-7, 5.4033118009, 77.7505439839), new Vsop87.LnVsop(3.1472E-7, 4.58140053324, 148.0787244263), new Vsop87.LnVsop(3.1469E-7, 2.26119541579, 195.1398481733), new Vsop87.LnVsop(2.7151E-7, 3.53245541147, 209.3669421749), new Vsop87.LnVsop(2.8313E-7, 4.57742211849, 77.2292791221), new Vsop87.LnVsop(2.6135E-7, 0.65832277309, 120.358249606), new Vsop87.LnVsop(2.4371E-7, 5.86680470366, 69.3649725959), new Vsop87.LnVsop(2.3072E-7, 1.04150250909, 84.3428261229), new Vsop87.LnVsop(2.2686E-7, 1.71276605718, 160.6088973985), new Vsop87.LnVsop(2.7909E-7, 4.91450005237, 277.0349937414), new Vsop87.LnVsop(2.0958E-7, 2.202477842, 45.5766510387), new Vsop87.LnVsop(2.0277E-7, 2.30684759993, 2.4476805548), new Vsop87.LnVsop(1.6889E-7, 4.75579457418, 213.299095438), new Vsop87.LnVsop(1.6616E-7, 1.85435119988, 340.7708920448), new Vsop87.LnVsop(1.7053E-7, 4.3720784206, 54.1746707478), new Vsop87.LnVsop(1.6086E-7, 3.65914337666, 152.7445908723), new Vsop87.LnVsop(1.4838E-7, 5.44395102901, 408.4389436113), new Vsop87.LnVsop(1.3872E-7, 3.3853110087, 358.9301393095), new Vsop87.LnVsop(1.3344E-7, 5.24928235077, 137.0330241624), new Vsop87.LnVsop(1.3276E-7, 1.26302583053, 134.5853436076), new Vsop87.LnVsop(1.27E-7, 3.02323882509, 92.940845832), new Vsop87.LnVsop(1.3615E-7, 1.5319229404, 422.6660376129), new Vsop87.LnVsop(1.2387E-7, 1.33244915199, 51.2057253312), new Vsop87.LnVsop(1.645E-7, 0.40355823582, 265.9892934775), new Vsop87.LnVsop(1.2052E-7, 5.08792165794, 191.2076949102), new Vsop87.LnVsop(1.1443E-7, 2.05677650023, 7.1135470008), new Vsop87.LnVsop(1.2762E-7, 4.42146478775, 87.3117715395), new Vsop87.LnVsop(1.2158E-7, 3.23645294871, 116.4260963429), new Vsop87.LnVsop(1.1636E-7, 4.65085291428, 41.6444977756), new Vsop87.LnVsop(1.1612E-7, 4.17982719132, 60.5545045657), new Vsop87.LnVsop(1.1692E-7, 3.73284551397, 220.4126424388), new Vsop87.LnVsop(1.0313E-7, 0.35141402139, 70.3281804424), new Vsop87.LnVsop(1.1316E-7, 1.07773417628, 72.3339180125), new Vsop87.LnVsop(9.522E-8, 3.05257396853, 2.9689454166), new Vsop87.LnVsop(9.279E-8, 2.43997351068, 565.1156877467), new Vsop87.LnVsop(8.993E-8, 5.1884103266, 225.8292684102), new Vsop87.LnVsop(1.0284E-7, 1.18602188589, 344.7030453079), new Vsop87.LnVsop(8.847E-8, 6.00863947318, 5.4166259714), new Vsop87.LnVsop(8.508E-8, 5.24741470219, 347.8844390456), new Vsop87.LnVsop(8.322E-8, 3.71500823381, 14.977853527), new Vsop87.LnVsop(8.276E-8, 2.27407098373, 299.1263942692), new Vsop87.LnVsop(8.064E-8, 5.71681525179, 55.1378785943), new Vsop87.LnVsop(7.829E-8, 0.90269701074, 222.8603229936), new Vsop87.LnVsop(8.335E-8, 4.48600419464, 70.1157321213), new Vsop87.LnVsop(8.489E-8, 3.911747962, 333.657345044), new Vsop87.LnVsop(8.708E-8, 5.81537952972, 153.4953503977), new Vsop87.LnVsop(1.0194E-7, 5.97791997034, 35.1640902212), new Vsop87.LnVsop(9.652E-8, 0.38887666466, 415.5524906121), new Vsop87.LnVsop(7.106E-8, 1.5059848847, 991.7138786227), new Vsop87.LnVsop(8.055E-8, 2.25812279923, 206.1855484372), new Vsop87.LnVsop(6.468E-8, 2.99863142327, 380.12776796), new Vsop87.LnVsop(6.393E-8, 1.1686180992, 96.8729990951), new Vsop87.LnVsop(8.976E-8, 6.05363032396, 146.3818033969), new Vsop87.LnVsop(6.131E-8, 0.05596259493, 99.1606209555), new Vsop87.LnVsop(5.803E-8, 0.79879069877, 142.4496501338), new Vsop87.LnVsop(5.816E-8, 4.63029217647, 49.5088043018), new Vsop87.LnVsop(5.557E-8, 0.63854330387, 58.1068240109), new Vsop87.LnVsop(5.869E-8, 2.21418083323, 80.1982245387), new Vsop87.LnVsop(5.162E-8, 4.36457872885, 977.4867846211), new Vsop87.LnVsop(5.428E-8, 0.85181859845, 546.956440482), new Vsop87.LnVsop(5.75E-8, 2.48104577171, 373.0142209592), new Vsop87.LnVsop(5.766E-8, 0.34229026122, 536.8045120954), new Vsop87.LnVsop(5.924E-8, 5.48443563529, 76.4785195967), new Vsop87.LnVsop(5.154E-8, 4.81339702575, 387.2413149608), new Vsop87.LnVsop(5.325E-8, 3.72411790512, 23.5758732361), new Vsop87.LnVsop(5.037E-8, 5.06388596602, 440.6822725257), new Vsop87.LnVsop(5.209E-8, 4.09574144962, 132.8884225782), new Vsop87.LnVsop(5.79E-8, 3.39593613152, 458.090760265), new Vsop87.LnVsop(5.007E-8, 4.25821411688, 522.5774180938), new Vsop87.LnVsop(5.114E-8, 0.4964558173, 60.7669528868), new Vsop87.LnVsop(5.027E-8, 6.1524848967, 39.6175083461), new Vsop87.LnVsop(5.183E-8, 3.25775152471, 561.1835344836), new Vsop87.LnVsop(4.603E-8, 1.69268338637, 152.5321425512), new Vsop87.LnVsop(4.566E-8, 0.46068888813, 33.1371007917), new Vsop87.LnVsop(5.302E-8, 1.83522660093, 124.2904028691), new Vsop87.LnVsop(4.454E-8, 2.30288945184, 312.4597163935), new Vsop87.LnVsop(5.766E-8, 0.6606915576, 38.1330356378), new Vsop87.LnVsop(4.255E-8, 3.58596694157, 479.2883889155), new Vsop87.LnVsop(4.315E-8, 1.64104755836, 128.9562693151), new Vsop87.LnVsop(4.19E-8, 4.37674804409, 79.2350166922), new Vsop87.LnVsop(5.756E-8, 0.87494010124, 20.6069278195), new Vsop87.LnVsop(5.409E-8, 0.87333646247, 81.8951455681), new Vsop87.LnVsop(5.124E-8, 1.40551554367, 144.1465711632), new Vsop87.LnVsop(4.045E-8, 6.07362424621, 19.643719973), new Vsop87.LnVsop(3.994E-8, 5.77048046468, 288.0806940053), new Vsop87.LnVsop(4.987E-8, 2.99179430284, 29.2049475286), new Vsop87.LnVsop(3.87E-8, 4.43713601497, 141.6988906084), new Vsop87.LnVsop(3.811E-8, 3.15820960943, 159.1244246902), new Vsop87.LnVsop(4.553E-8, 0.01384318412, 298.2326223919), new Vsop87.LnVsop(3.737E-8, 5.28319518103, 353.301065017), new Vsop87.LnVsop(3.742E-8, 2.67921642406, 426.598190876), new Vsop87.LnVsop(3.939E-8, 5.27301148162, 521.0929453855), new Vsop87.LnVsop(5.065E-8, 4.09433474334, 111.4301614968), new Vsop87.LnVsop(3.861E-8, 1.343943837, 535.3200393871), new Vsop87.LnVsop(3.619E-8, 5.10070043677, 490.3340891794), new Vsop87.LnVsop(4.385E-8, 0.620576801, 827.1728279611), new Vsop87.LnVsop(3.645E-8, 0.34509016266, 33.6796175129), new Vsop87.LnVsop(3.558E-8, 2.51710360898, 258.8757464767), new Vsop87.LnVsop(3.919E-8, 0.62079541541, 152.0108776894), new Vsop87.LnVsop(3.576E-8, 3.24526237368, 230.5645708254), new Vsop87.LnVsop(3.469E-8, 0.79054323335, 983.1158589136), new Vsop87.LnVsop(4.53E-8, 2.86839686392, 129.9194771616), new Vsop87.LnVsop(3.648E-8, 5.59395544992, 774.4826299216), new Vsop87.LnVsop(3.44E-8, 4.71254994607, 6.9010986797), new Vsop87.LnVsop(3.513E-8, 4.49630054276, 376.1956146969), new Vsop87.LnVsop(4.521E-8, 2.05472247761, 404.5067903482), new Vsop87.LnVsop(3.336E-8, 0.89628904042, 469.1364605289), new Vsop87.LnVsop(3.274E-8, 3.86236880159, 42.5382696529), new Vsop87.LnVsop(3.201E-8, 2.76459652868, 248.7238180901), new Vsop87.LnVsop(3.184E-8, 0.07709843451, 1514.2912967165), new Vsop87.LnVsop(3.783E-8, 5.29835962126, 369.0820676961), new Vsop87.LnVsop(3.119E-8, 1.27526406087, 200.7689224658), new Vsop87.LnVsop(3.266E-8, 2.24754480216, 73.8183907208), new Vsop87.LnVsop(3.055E-8, 2.60120354408, 433.7117378768), new Vsop87.LnVsop(3.051E-8, 4.54953369151, 980.6681783588), new Vsop87.LnVsop(3.472E-8, 4.93521260607, 411.620337349), new Vsop87.LnVsop(3.531E-8, 4.49372794858, 881.5075574033), new Vsop87.LnVsop(3.284E-8, 5.59170577331, 472.1748419147), new Vsop87.LnVsop(3.049E-8, 3.68906777491, 16.6747745564), new Vsop87.LnVsop(3.015E-8, 6.02967446446, 291.262087743), new Vsop87.LnVsop(3.755E-8, 3.1258774756, 108.4612160802), new Vsop87.LnVsop(3.467E-8, 2.17484439267, 554.0699874828), new Vsop87.LnVsop(3.138E-8, 0.52367930477, 1094.8066528413), new Vsop87.LnVsop(3.257E-8, 2.49339546514, 451.7279727896), new Vsop87.LnVsop(2.886E-8, 2.44887846041, 135.336103133), new Vsop87.LnVsop(2.965E-8, 0.3929499553, 25.2727942655), new Vsop87.LnVsop(2.794E-8, 5.32964924523, 125.9873238985), new Vsop87.LnVsop(2.814E-8, 1.70481689541, 639.897286314), new Vsop87.LnVsop(2.777E-8, 5.94801147914, 89.7594520943), new Vsop87.LnVsop(2.831E-8, 2.52728803131, 867.2804634017), new Vsop87.LnVsop(2.779E-8, 0.48501334493, 305.3461693927), new Vsop87.LnVsop(2.872E-8, 0.77434367967, 486.4019359163), new Vsop87.LnVsop(2.857E-8, 4.71106805785, 218.9281697305), new Vsop87.LnVsop(3.081E-8, 4.10993868704, 146.594251718), new Vsop87.LnVsop(2.763E-8, 4.27510031656, 350.3321196004), new Vsop87.LnVsop(3.365E-8, 3.67691210011, 661.0949149645), new Vsop87.LnVsop(2.925E-8, 1.43646759644, 381.6122406683), new Vsop87.LnVsop(2.802E-8, 3.11122994722, 216.4804891757), new Vsop87.LnVsop(2.756E-8, 4.6267249884, 1357.6145525811), new Vsop87.LnVsop(3.45E-8, 2.12911756067, 685.4739373527), new Vsop87.LnVsop(2.646E-8, 3.81808560938, 550.8885937451), new Vsop87.LnVsop(2.584E-8, 5.63009428967, 24.3790223882), new Vsop87.LnVsop(2.74E-8, 1.85885336732, 529.6909650946), new Vsop87.LnVsop(2.606E-8, 4.36605237304, 1080.5795588397), new Vsop87.LnVsop(2.438E-8, 3.04265976382, 391.1734682239), new Vsop87.LnVsop(2.446E-8, 5.7384638154, 535.9107402181), new Vsop87.LnVsop(2.471E-8, 4.1814010428, 235.3904959658), new Vsop87.LnVsop(2.568E-8, 1.09886876369, 913.0001267923), new Vsop87.LnVsop(2.346E-8, 1.88690998393, 82.8583534146), new Vsop87.LnVsop(2.301E-8, 0.2711625493, 7.8643065262), new Vsop87.LnVsop(3.053E-8, 5.35047433775, 681.5417840896), new Vsop87.LnVsop(2.29E-8, 2.49218620138, 203.7378678824), new Vsop87.LnVsop(2.325E-8, 0.52844013308, 14.2270940016), new Vsop87.LnVsop(2.258E-8, 0.0315661773, 398.2870152247), new Vsop87.LnVsop(2.16E-8, 6.01811980506, 140.001969579), new Vsop87.LnVsop(2.328E-8, 3.12607654898, 273.1028404783), new Vsop87.LnVsop(2.139E-8, 4.33383273131, 91.4563731237), new Vsop87.LnVsop(2.723E-8, 1.24464892033, 166.828672522), new Vsop87.LnVsop(2.053E-8, 4.3243438112, 515.463871093), new Vsop87.LnVsop(2.398E-8, 5.9014427096, 79.4474650133), new Vsop87.LnVsop(2.222E-8, 4.80208391464, 268.4369740323), new Vsop87.LnVsop(2.31E-8, 0.48180017719, 14.0146456805), new Vsop87.LnVsop(2.022E-8, 5.85402756377, 271.4059194489), new Vsop87.LnVsop(2.521E-8, 3.23111737258, 901.9544265284), new Vsop87.LnVsop(2.369E-8, 2.40985582671, 73.0846775379), new Vsop87.LnVsop(2.034E-8, 0.47496124187, 2043.9822618111), new Vsop87.LnVsop(1.955E-8, 6.21237525891, 384.0599212231), new Vsop87.LnVsop(1.954E-8, 3.38054663002, 820.0592809603), new Vsop87.LnVsop(1.867E-8, 5.32253331194, 31.492569389), new Vsop87.LnVsop(2.416E-8, 0.0642020989, 419.4846438752), new Vsop87.LnVsop(1.762E-8, 5.772005785, 1589.0728952838), new Vsop87.LnVsop(1.762E-8, 4.23427755214, 1439.5096981492), new Vsop87.LnVsop(1.925E-8, 0.79521713622, 184.0941479094), new Vsop87.LnVsop(2.204E-8, 0.52846501316, 278.5194664497), new Vsop87.LnVsop(2.228E-8, 4.32684227036, 66.9172920411), new Vsop87.LnVsop(1.679E-8, 5.14179135334, 1059.3819301892), new Vsop87.LnVsop(1.706E-8, 1.54289098759, 234.4967240885), new Vsop87.LnVsop(1.625E-8, 5.07314285147, 100.3844612329), new Vsop87.LnVsop(1.609E-8, 6.16926697458, 1119.1856752295), new Vsop87.LnVsop(2.033E-8, 3.53119363701, 109.9456887885), new Vsop87.LnVsop(2.129E-8, 1.22429037482, 184.7272873558), new Vsop87.LnVsop(1.717E-8, 2.42144217711, 678.3603903519), new Vsop87.LnVsop(1.717E-8, 3.95917040998, 827.9235874865), new Vsop87.LnVsop(1.81E-8, 0.05278694247, 17.2654753874), new Vsop87.LnVsop(1.585E-8, 1.88716701489, 4.4534181249), new Vsop87.LnVsop(1.577E-8, 5.35894329524, 1894.4190646765), new Vsop87.LnVsop(1.523E-8, 3.77627435709, 181.0557665236), new Vsop87.LnVsop(1.534E-8, 0.19778048653, 135.5485514541), new Vsop87.LnVsop(1.506E-8, 2.95864025543, 849.2642284889), new Vsop87.LnVsop(1.506E-8, 1.35493797085, 998.8274256235), new Vsop87.LnVsop(1.722E-8, 5.00518792666, 699.7010313543), new Vsop87.LnVsop(1.722E-8, 3.46745969379, 550.1378342197), new Vsop87.LnVsop(1.643E-8, 5.86122302822, 89.0086925689), new Vsop87.LnVsop(1.52E-8, 1.42254433373, 0.2124483211), new Vsop87.LnVsop(1.529E-8, 0.77073213979, 329.7251917809), new Vsop87.LnVsop(1.458E-8, 5.90775641818, 147.1155165798), new Vsop87.LnVsop(1.792E-8, 1.11686829848, 453.424893819), new Vsop87.LnVsop(1.498E-8, 2.6114567579, 365.9006739584), new Vsop87.LnVsop(1.793E-8, 2.14241351007, 211.8146227297), new Vsop87.LnVsop(1.58E-8, 5.57997675255, 785.5283301855), new Vsop87.LnVsop(1.58E-8, 4.04224851969, 635.9651330509), new Vsop87.LnVsop(1.835E-8, 4.31480288855, 465.9550667912), new Vsop87.LnVsop(1.407E-8, 4.94842057032, 74.8934731519), new Vsop87.LnVsop(1.403E-8, 5.15016124506, 180.1619946463), new Vsop87.LnVsop(1.42E-8, 2.60452620081, 95.3885263868), new Vsop87.LnVsop(1.383E-8, 5.95287019467, 74.6697239827), new Vsop87.LnVsop(1.382E-8, 2.10457236484, 458.8415197904), new Vsop87.LnVsop(1.513E-8, 1.88475439191, 1051.517623663), new Vsop87.LnVsop(1.368E-8, 5.67966974902, 66.70484372)};
        private static final Vsop87.LnVsop[] uranus_radius_r3 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.164663E-5, 4.73440180792, 74.7815985673), new Vsop87.LnVsop(2.12363E-6, 3.34268349684, 63.7358983034), new Vsop87.LnVsop(1.96315E-6, 2.981012371, 70.8494453042), new Vsop87.LnVsop(1.04707E-6, 0.95789279555, 11.0457002639), new Vsop87.LnVsop(7.1681E-7, 0.02528295071, 56.6223513026), new Vsop87.LnVsop(7.2719E-7, 0.99479831041, 149.5631971346), new Vsop87.LnVsop(5.4933E-7, 2.59936585639, 3.9321532631), new Vsop87.LnVsop(3.4026E-7, 3.82319495878, 76.2660712756), new Vsop87.LnVsop(3.2081E-7, 3.59825177872, 131.4039498699), new Vsop87.LnVsop(2.9569E-7, 3.44303690664, 85.8272988312), new Vsop87.LnVsop(3.6377E-7, 5.65035573026, 77.962992305), new Vsop87.LnVsop(2.7625E-7, 0.42885477377, 3.1813937377), new Vsop87.LnVsop(2.7552E-7, 2.55709855563, 52.6901980395), new Vsop87.LnVsop(2.474E-7, 5.14634979896, 78.7137518304), new Vsop87.LnVsop(1.9382E-7, 5.13444064222, 18.1592472647), new Vsop87.LnVsop(1.5767E-7, 0.37116951743, 447.7958195265), new Vsop87.LnVsop(1.5441E-7, 5.57271837433, 462.0229135281), new Vsop87.LnVsop(1.5035E-7, 3.84415419523, 73.297125859), new Vsop87.LnVsop(1.545E-7, 2.9757251436, 145.6310438715), new Vsop87.LnVsop(1.7788E-7, 0.0, 0.0), new Vsop87.LnVsop(1.5958E-7, 5.19915553861, 71.6002048296), new Vsop87.LnVsop(1.078E-7, 6.02554585112, 138.5174968707), new Vsop87.LnVsop(1.0347E-7, 3.60350847669, 224.3447957019), new Vsop87.LnVsop(7.612E-8, 1.47668980969, 1.4844727083), new Vsop87.LnVsop(8.14E-8, 2.61444086595, 22.0914005278), new Vsop87.LnVsop(7.107E-8, 5.43946774526, 269.9214467406), new Vsop87.LnVsop(6.459E-8, 4.37142319461, 284.1485407422), new Vsop87.LnVsop(6.817E-8, 0.0148593733, 151.0476698429), new Vsop87.LnVsop(7.811E-8, 0.29898229022, 127.4717966068), new Vsop87.LnVsop(5.768E-8, 4.22672716677, 373.0142209592), new Vsop87.LnVsop(5.105E-8, 1.81797461354, 202.2533951741), new Vsop87.LnVsop(4.692E-8, 2.7840457544, 120.358249606), new Vsop87.LnVsop(5.071E-8, 0.7664167964, 62.2514255951), new Vsop87.LnVsop(4.133E-8, 1.8887930071, 209.3669421749), new Vsop87.LnVsop(5.201E-8, 4.15791319343, 195.1398481733), new Vsop87.LnVsop(3.946E-8, 1.83105030444, 72.3339180125), new Vsop87.LnVsop(3.582E-8, 3.92592140377, 124.2904028691), new Vsop87.LnVsop(4.34E-8, 3.99626115302, 9.5612275556), new Vsop87.LnVsop(3.739E-8, 1.50894993813, 148.0787244263), new Vsop87.LnVsop(3.436E-8, 1.99291271003, 65.2203710117), new Vsop87.LnVsop(3.835E-8, 1.15614639932, 153.4953503977), new Vsop87.LnVsop(3.593E-8, 0.94897593272, 92.940845832), new Vsop87.LnVsop(3.95E-8, 1.85721204646, 152.7445908723), new Vsop87.LnVsop(3.277E-8, 1.40881404192, 351.8165923087), new Vsop87.LnVsop(3.058E-8, 5.76662885271, 160.6088973985), new Vsop87.LnVsop(2.719E-8, 5.64780369357, 134.5853436076), new Vsop87.LnVsop(2.8E-8, 0.79480255927, 572.2292347475), new Vsop87.LnVsop(2.727E-8, 6.00569967758, 12.5301729722), new Vsop87.LnVsop(2.524E-8, 3.05071097098, 387.2413149608), new Vsop87.LnVsop(2.662E-8, 1.98593312104, 450.9772132642), new Vsop87.LnVsop(2.391E-8, 1.62282528307, 358.9301393095), new Vsop87.LnVsop(2.57E-8, 2.81202618885, 213.299095438), new Vsop87.LnVsop(2.291E-8, 4.81424601791, 536.8045120954), new Vsop87.LnVsop(2.213E-8, 2.20360299816, 465.9550667912), new Vsop87.LnVsop(2.345E-8, 3.89530188536, 76.4785195967), new Vsop87.LnVsop(1.99E-8, 6.00348345539, 77.2292791221), new Vsop87.LnVsop(1.836E-8, 0.86993337572, 288.0806940053), new Vsop87.LnVsop(2.233E-8, 4.20038854663, 45.5766510387), new Vsop87.LnVsop(1.745E-8, 4.28595550732, 67.6680515665), new Vsop87.LnVsop(1.715E-8, 5.36211200127, 84.3428261229), new Vsop87.LnVsop(1.64E-8, 5.46719808619, 309.2783226558), new Vsop87.LnVsop(1.64E-8, 3.86349580161, 458.8415197904), new Vsop87.LnVsop(1.728E-8, 3.60055588821, 81.8951455681), new Vsop87.LnVsop(1.483E-8, 3.46836166107, 59.8037450403), new Vsop87.LnVsop(1.463E-8, 3.58895839694, 347.8844390456), new Vsop87.LnVsop(1.415E-8, 1.8281699263, 497.4476361802), new Vsop87.LnVsop(1.399E-8, 5.26616832831, 909.8187330546), new Vsop87.LnVsop(1.399E-8, 3.66246604373, 1059.3819301892), new Vsop87.LnVsop(1.401E-8, 4.64442933182, 96.8729990951)};
        private static final Vsop87.LnVsop[] uranus_radius_r4 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(5.3224E-7, 3.00468894529, 74.7815985673), new Vsop87.LnVsop(9.887E-8, 1.91399083603, 56.6223513026), new Vsop87.LnVsop(7.008E-8, 5.08677527404, 11.0457002639), new Vsop87.LnVsop(6.718E-8, 5.39509675772, 149.5631971346), new Vsop87.LnVsop(3.855E-8, 5.18994119112, 131.4039498699), new Vsop87.LnVsop(3.316E-8, 1.22839100759, 85.8272988312), new Vsop87.LnVsop(2.664E-8, 0.44064577837, 63.7358983034), new Vsop87.LnVsop(2.309E-8, 0.92380720934, 145.6310438715), new Vsop87.LnVsop(2.383E-8, 6.21390585593, 358.9301393095), new Vsop87.LnVsop(2.288E-8, 2.23425399117, 440.6822725257), new Vsop87.LnVsop(2.472E-8, 3.28269448244, 18.1592472647), new Vsop87.LnVsop(2.837E-8, 3.14159265359, 0.0)};

        Radius() {
        }
    }

    static class Latitude {
        private static final Vsop87.LnVsop[] uranus_latitude_b0 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.01346277648, 2.61877810547, 74.7815985673), new Vsop87.LnVsop(6.23414E-4, 5.08111189648, 149.5631971346), new Vsop87.LnVsop(6.1601196E-4, 3.14159265359, 0.0), new Vsop87.LnVsop(9.963722E-5, 1.61603805646, 76.2660712756), new Vsop87.LnVsop(9.92616E-5, 0.57630380333, 73.297125859), new Vsop87.LnVsop(3.259466E-5, 1.26119342526, 224.3447957019), new Vsop87.LnVsop(2.972303E-5, 2.24367206357, 1.4844727083), new Vsop87.LnVsop(2.010275E-5, 6.05550884547, 148.0787244263), new Vsop87.LnVsop(1.522163E-5, 0.27959645002, 63.7358983034), new Vsop87.LnVsop(9.24064E-6, 4.03822512696, 151.0476698429), new Vsop87.LnVsop(7.6064E-6, 6.13999362624, 71.8126531507), new Vsop87.LnVsop(4.20265E-6, 5.21280055515, 11.0457002639), new Vsop87.LnVsop(4.30661E-6, 3.55443947716, 213.299095438), new Vsop87.LnVsop(4.36847E-6, 3.38081057022, 529.6909650946), new Vsop87.LnVsop(5.22314E-6, 3.32086440954, 138.5174968707), new Vsop87.LnVsop(4.34627E-6, 0.34063199763, 77.7505439839), new Vsop87.LnVsop(4.6263E-6, 0.74256687606, 85.8272988312), new Vsop87.LnVsop(2.32667E-6, 2.25715668168, 222.8603229936), new Vsop87.LnVsop(2.15848E-6, 1.59122810633, 38.1330356378), new Vsop87.LnVsop(2.44698E-6, 0.787951741, 2.9689454166), new Vsop87.LnVsop(1.79936E-6, 3.72487768728, 299.1263942692), new Vsop87.LnVsop(1.74896E-6, 1.23550822483, 146.594251718), new Vsop87.LnVsop(1.73648E-6, 1.93654971482, 380.12776796), new Vsop87.LnVsop(1.60368E-6, 5.33635511113, 111.4301614968), new Vsop87.LnVsop(1.44064E-6, 5.96238846558, 35.1640902212), new Vsop87.LnVsop(1.02049E-6, 2.61876132065, 78.7137518304), new Vsop87.LnVsop(1.16363E-6, 5.73877137488, 70.8494453042), new Vsop87.LnVsop(1.06444E-6, 0.94095705978, 70.3281804424), new Vsop87.LnVsop(8.616E-7, 0.70251751041, 39.6175083461), new Vsop87.LnVsop(7.2611E-7, 0.205721589, 225.8292684102), new Vsop87.LnVsop(7.1172E-7, 0.83343109173, 109.9456887885), new Vsop87.LnVsop(5.7495E-7, 2.67048156941, 108.4612160802), new Vsop87.LnVsop(5.4263E-7, 3.35177461012, 184.7272873558), new Vsop87.LnVsop(4.4471E-7, 2.74407889623, 152.5321425512), new Vsop87.LnVsop(3.8592E-7, 5.1739053114, 202.2533951741), new Vsop87.LnVsop(3.9159E-7, 2.17111197275, 351.8165923087), new Vsop87.LnVsop(4.1362E-7, 3.22138743484, 160.6088973985), new Vsop87.LnVsop(3.5132E-7, 4.00123533788, 112.9146342051), new Vsop87.LnVsop(3.3091E-7, 3.6137250502, 221.3758502853), new Vsop87.LnVsop(3.1332E-7, 2.71938965609, 145.1097790097), new Vsop87.LnVsop(3.734E-7, 4.0208394424, 52.6901980395), new Vsop87.LnVsop(3.2034E-7, 1.29143160665, 145.6310438715), new Vsop87.LnVsop(2.7569E-7, 3.70085992486, 36.6485629295), new Vsop87.LnVsop(2.4272E-7, 2.85050776068, 127.4717966068), new Vsop87.LnVsop(2.4635E-7, 1.11646359832, 3.9321532631), new Vsop87.LnVsop(2.4309E-7, 5.48949970007, 79.2350166922), new Vsop87.LnVsop(2.1418E-7, 0.63723215666, 277.0349937414), new Vsop87.LnVsop(1.9832E-7, 2.59336449599, 84.3428261229), new Vsop87.LnVsop(2.2368E-7, 5.73729035268, 4.4534181249), new Vsop87.LnVsop(1.9125E-7, 1.30093692086, 62.2514255951), new Vsop87.LnVsop(1.9796E-7, 4.72268731719, 297.6419215609), new Vsop87.LnVsop(2.0298E-7, 1.06069563441, 454.9093665273), new Vsop87.LnVsop(1.9769E-7, 5.77906677614, 305.3461693927), new Vsop87.LnVsop(2.1357E-7, 1.01279253027, 33.6796175129), new Vsop87.LnVsop(1.5136E-7, 2.91791848257, 426.598190876), new Vsop87.LnVsop(1.601E-7, 1.95529008632, 186.2117600641), new Vsop87.LnVsop(1.3804E-7, 2.67173362271, 74.6697239827), new Vsop87.LnVsop(1.1468E-7, 5.7330316553, 41.1019810544), new Vsop87.LnVsop(1.0741E-7, 3.73406242289, 1059.3819301892), new Vsop87.LnVsop(1.1468E-7, 3.98150176278, 106.9767433719), new Vsop87.LnVsop(1.0365E-7, 4.75684964951, 183.2428146475), new Vsop87.LnVsop(1.0232E-7, 6.18772944512, 373.9079928365), new Vsop87.LnVsop(1.3803E-7, 5.70721417446, 74.8934731519), new Vsop87.LnVsop(1.0563E-7, 3.78630189172, 490.3340891794), new Vsop87.LnVsop(1.1838E-7, 5.96756141943, 87.3117715395), new Vsop87.LnVsop(1.0033E-7, 1.74884568436, 22.0914005278), new Vsop87.LnVsop(1.0107E-7, 0.92920871591, 65.2203710117), new Vsop87.LnVsop(9.126E-8, 5.11087748378, 153.4953503977), new Vsop87.LnVsop(1.2093E-7, 2.53736478942, 9.5612275556), new Vsop87.LnVsop(8.645E-8, 4.18353789478, 12.5301729722), new Vsop87.LnVsop(9.969E-8, 5.83607933801, 604.4725636619), new Vsop87.LnVsop(1.1363E-7, 2.12628390559, 68.8437077341), new Vsop87.LnVsop(8.481E-8, 3.37168822431, 72.3339180125), new Vsop87.LnVsop(7.79E-8, 5.1180289667, 77.962992305), new Vsop87.LnVsop(8.306E-8, 5.19333619113, 77.2292791221), new Vsop87.LnVsop(7.701E-8, 3.25277033035, 71.6002048296), new Vsop87.LnVsop(7.521E-8, 2.98280931167, 114.3991069134), new Vsop87.LnVsop(6.948E-8, 3.31879527596, 56.6223513026), new Vsop87.LnVsop(6.5E-8, 0.88498775188, 288.0806940053), new Vsop87.LnVsop(6.393E-8, 3.51141825287, 220.4126424388), new Vsop87.LnVsop(6.208E-8, 0.58088443555, 340.7708920448), new Vsop87.LnVsop(6.772E-8, 4.09371704059, 137.0330241624), new Vsop87.LnVsop(5.595E-8, 5.68796827406, 259.5088859231), new Vsop87.LnVsop(5.301E-8, 2.65424478534, 300.6108669775), new Vsop87.LnVsop(4.95E-8, 4.99680523609, 219.891377577), new Vsop87.LnVsop(6.424E-8, 0.44994761517, 140.001969579), new Vsop87.LnVsop(4.972E-8, 4.06861003746, 143.6253063014), new Vsop87.LnVsop(5.694E-8, 3.76750788366, 67.6680515665), new Vsop87.LnVsop(4.853E-8, 2.03388920337, 415.5524906121), new Vsop87.LnVsop(3.803E-8, 1.26170663854, 75.3028634291), new Vsop87.LnVsop(3.807E-8, 2.2478190396, 909.8187330546), new Vsop87.LnVsop(3.813E-8, 3.1046677749, 181.7583419392), new Vsop87.LnVsop(3.78E-8, 5.19959127344, 227.3137411185), new Vsop87.LnVsop(3.426E-8, 5.91911283488, 296.1574488526), new Vsop87.LnVsop(3.517E-8, 5.44401451357, 628.8515860501), new Vsop87.LnVsop(3.943E-8, 4.9510920534, 265.9892934775), new Vsop87.LnVsop(3.472E-8, 0.34748263417, 131.4039498699), new Vsop87.LnVsop(3.4E-8, 0.5368588001, 206.1855484372), new Vsop87.LnVsop(3.039E-8, 4.68312649973, 159.1244246902), new Vsop87.LnVsop(3.189E-8, 5.68771037501, 235.3904959658), new Vsop87.LnVsop(3.303E-8, 2.09359478408, 73.8183907208), new Vsop87.LnVsop(3.062E-8, 4.48989306244, 66.70484372), new Vsop87.LnVsop(3.265E-8, 0.01005829991, 75.7448064138), new Vsop87.LnVsop(2.917E-8, 4.21626758697, 258.0244132148), new Vsop87.LnVsop(3.747E-8, 0.82998936434, 74.2603337055), new Vsop87.LnVsop(2.818E-8, 3.96515762579, 82.8583534146), new Vsop87.LnVsop(2.474E-8, 3.81322641071, 7.1135470008), new Vsop87.LnVsop(2.394E-8, 2.21473666039, 54.1746707478), new Vsop87.LnVsop(2.546E-8, 2.97069404242, 378.6432952517), new Vsop87.LnVsop(2.632E-8, 1.55152764206, 154.0166152595), new Vsop87.LnVsop(2.639E-8, 2.28085213767, 32.1951448046), new Vsop87.LnVsop(2.642E-8, 3.96819246977, 381.6122406683), new Vsop87.LnVsop(2.203E-8, 3.06747152218, 59.8037450403), new Vsop87.LnVsop(2.635E-8, 0.54046453944, 211.8146227297), new Vsop87.LnVsop(2.053E-8, 1.98285180962, 18.1592472647), new Vsop87.LnVsop(2.516E-8, 0.63537765744, 187.6962327724), new Vsop87.LnVsop(2.485E-8, 3.55942732547, 96.8729990951), new Vsop87.LnVsop(1.918E-8, 1.6047957873, 80.1982245387), new Vsop87.LnVsop(2.055E-8, 4.49938733826, 5.9378908332), new Vsop87.LnVsop(2.018E-8, 2.97794616041, 191.2076949102), new Vsop87.LnVsop(1.832E-8, 1.96177252651, 81.8951455681), new Vsop87.LnVsop(1.719E-8, 2.22518862087, 479.2883889155), new Vsop87.LnVsop(1.857E-8, 1.66299721979, 984.6003316219), new Vsop87.LnVsop(1.726E-8, 3.22144940779, 218.4069048687), new Vsop87.LnVsop(1.77E-8, 5.24609773415, 105.4922706636), new Vsop87.LnVsop(1.52E-8, 0.94716593371, 372.4235201282), new Vsop87.LnVsop(1.512E-8, 6.03457842275, 99.1606209555), new Vsop87.LnVsop(1.614E-8, 3.39986737271, 230.5645708254), new Vsop87.LnVsop(1.711E-8, 3.4423248368, 522.5774180938), new Vsop87.LnVsop(1.504E-8, 1.34653259405, 74.5209661364), new Vsop87.LnVsop(1.584E-8, 4.37196518404, 80.7194894005), new Vsop87.LnVsop(1.36E-8, 5.4869124027, 74.8297826771), new Vsop87.LnVsop(1.405E-8, 0.33792710499, 142.4496501338), new Vsop87.LnVsop(1.363E-8, 4.56068902351, 42.5864537627), new Vsop87.LnVsop(1.709E-8, 3.63180456542, 554.0699874828), new Vsop87.LnVsop(1.36E-8, 2.89305157919, 74.7334144575), new Vsop87.LnVsop(1.26E-8, 5.50922979275, 74.9416572617), new Vsop87.LnVsop(1.384E-8, 4.40028240227, 260.9933586314), new Vsop87.LnVsop(1.365E-8, 2.15266243195, 162.0933701068), new Vsop87.LnVsop(1.244E-8, 4.97782030325, 149.45132255), new Vsop87.LnVsop(1.278E-8, 0.84565446273, 767.3690829208), new Vsop87.LnVsop(1.263E-8, 4.53422211084, 294.6729761443), new Vsop87.LnVsop(1.322E-8, 5.10927435201, 51.2057253312), new Vsop87.LnVsop(1.18E-8, 0.79757360842, 116.4260963429), new Vsop87.LnVsop(1.495E-8, 0.74986873597, 75.0422309982), new Vsop87.LnVsop(1.213E-8, 3.66821217363, 20.6069278195), new Vsop87.LnVsop(1.248E-8, 3.13317666641, 67.3592350258), new Vsop87.LnVsop(1.171E-8, 4.39747177706, 180.2738692309), new Vsop87.LnVsop(1.125E-8, 3.86202201629, 39.3568759152), new Vsop87.LnVsop(1.263E-8, 2.87116663203, 74.6215398729), new Vsop87.LnVsop(1.376E-8, 3.75596842702, 92.940845832), new Vsop87.LnVsop(1.018E-8, 6.20402800983, 835.0371344873), new Vsop87.LnVsop(9.62E-9, 3.30346641752, 255.0554677982), new Vsop87.LnVsop(1.239E-8, 1.73040337356, 149.6750717192), new Vsop87.LnVsop(9.7E-9, 1.71235586924, 115.8835796217), new Vsop87.LnVsop(9.43E-9, 3.07319537857, 8.0767548473), new Vsop87.LnVsop(1.0E-8, 5.49989514567, 256.5399405065), new Vsop87.LnVsop(9.11E-9, 6.23756163651, 200.7689224658), new Vsop87.LnVsop(9.08E-9, 0.00832674265, 536.8045120954), new Vsop87.LnVsop(9.69E-9, 5.7757567523, 128.9562693151), new Vsop87.LnVsop(9.52E-9, 3.00463012001, 14.977853527), new Vsop87.LnVsop(9.83E-9, 0.35101173825, 404.5067903482), new Vsop87.LnVsop(8.08E-9, 3.21398175104, 28.3111756513), new Vsop87.LnVsop(7.64E-9, 3.45466431894, 214.7835681463), new Vsop87.LnVsop(1.021E-8, 1.79907610488, 3.1813937377), new Vsop87.LnVsop(7.83E-9, 4.1216774988, 125.9873238985), new Vsop87.LnVsop(7.15E-9, 5.80380056776, 157.6399519819), new Vsop87.LnVsop(6.89E-9, 1.84739011152, 41.6444977756), new Vsop87.LnVsop(7.15E-9, 5.56310287629, 146.3818033969), new Vsop87.LnVsop(6.82E-9, 5.16479782395, 74.0308390419), new Vsop87.LnVsop(6.73E-9, 2.65544175682, 75.5323580927), new Vsop87.LnVsop(6.96E-9, 3.59376281929, 362.8622925726), new Vsop87.LnVsop(7.15E-9, 4.76877987059, 331.3215390738), new Vsop87.LnVsop(7.29E-9, 2.25493921872, 453.424893819), new Vsop87.LnVsop(6.48E-9, 1.99137116455, 639.897286314), new Vsop87.LnVsop(6.41E-9, 5.77409064831, 110.2063212194), new Vsop87.LnVsop(6.66E-9, 5.97888465085, 135.5485514541), new Vsop87.LnVsop(7.74E-9, 0.42035537394, 565.1156877467), new Vsop87.LnVsop(6.74E-9, 5.3291350143, 142.1408335931), new Vsop87.LnVsop(7.76E-9, 5.57009796152, 2.4476805548), new Vsop87.LnVsop(7.98E-9, 0.90966507165, 152.0108776894), new Vsop87.LnVsop(6.8E-9, 2.94896042701, 60.7669528868), new Vsop87.LnVsop(6.03E-9, 2.0420815188, 195.1398481733), new Vsop87.LnVsop(6.5E-9, 4.5628702594, 216.9224321604), new Vsop87.LnVsop(7.38E-9, 5.07239490532, 89.7594520943), new Vsop87.LnVsop(5.97E-9, 1.91415368214, 203.7378678824), new Vsop87.LnVsop(6.46E-9, 2.79255070924, 50.4025761791), new Vsop87.LnVsop(5.57E-9, 2.9179539235, 68.1893164283), new Vsop87.LnVsop(5.65E-9, 2.77660876182, 14.0146456805), new Vsop87.LnVsop(5.31E-9, 3.75443696232, 617.8058857862), new Vsop87.LnVsop(5.3E-9, 3.51481429918, 291.7040307277), new Vsop87.LnVsop(5.06E-9, 4.94596553031, 81.3738807063), new Vsop87.LnVsop(6.02E-9, 2.45288547587, 81.0013736908), new Vsop87.LnVsop(5.96E-9, 5.42429198496, 692.5874843535), new Vsop87.LnVsop(6.48E-9, 5.7487776582, 141.4864422873), new Vsop87.LnVsop(5.23E-9, 4.97086637939, 387.2413149608), new Vsop87.LnVsop(5.44E-9, 2.99910796114, 152.7445908723), new Vsop87.LnVsop(4.85E-9, 2.36315064516, 448.6895914038), new Vsop87.LnVsop(4.81E-9, 5.8166549566, 134.5853436076), new Vsop87.LnVsop(4.7E-9, 1.3017484602, 228.276948965), new Vsop87.LnVsop(4.75E-9, 0.53495528828, 303.8616966844), new Vsop87.LnVsop(5.84E-9, 4.6786656527, 88.7962442478), new Vsop87.LnVsop(4.61E-9, 0.55903469027, 23.5758732361), new Vsop87.LnVsop(4.78E-9, 6.22340588748, 5.4166259714), new Vsop87.LnVsop(4.26E-9, 5.25039648756, 35.4247226521), new Vsop87.LnVsop(4.46E-9, 2.50203892379, 905.8865797915), new Vsop87.LnVsop(4.41E-9, 4.26182840333, 278.5194664497), new Vsop87.LnVsop(5.01E-9, 4.79995214429, 306.830642101), new Vsop87.LnVsop(4.99E-9, 5.86243513978, 293.188503436), new Vsop87.LnVsop(4.74E-9, 3.031176471, 286.596221297), new Vsop87.LnVsop(5.06E-9, 2.05350887377, 373.0142209592), new Vsop87.LnVsop(4.1E-9, 5.30618889138, 95.3885263868), new Vsop87.LnVsop(3.95E-9, 5.65591153137, 284.1485407422), new Vsop87.LnVsop(4.78E-9, 2.41099809344, 358.9301393095), new Vsop87.LnVsop(5.36E-9, 1.82605088834, 114.1384744825), new Vsop87.LnVsop(3.83E-9, 5.54529609922, 419.4846438752), new Vsop87.LnVsop(4.13E-9, 0.03790517946, 103.0927742186), new Vsop87.LnVsop(3.68E-9, 4.08523828488, 1589.0728952838), new Vsop87.LnVsop(3.7E-9, 1.82531607739, 334.2904844904), new Vsop87.LnVsop(3.87E-9, 0.56619512225, 602.9880909536), new Vsop87.LnVsop(4.82E-9, 5.58482619841, 68.5618234438), new Vsop87.LnVsop(4.78E-9, 0.17223161797, 120.358249606), new Vsop87.LnVsop(4.19E-9, 5.07107020071, 367.9701020033), new Vsop87.LnVsop(3.42E-9, 5.27207825111, 28.5718080822), new Vsop87.LnVsop(4.06E-9, 2.00845231847, 679.2541622292), new Vsop87.LnVsop(3.81E-9, 4.61323929793, 329.7251917809), new Vsop87.LnVsop(3.88E-9, 0.89083225227, 483.2205421786), new Vsop87.LnVsop(3.76E-9, 1.28833260468, 155.7829722581), new Vsop87.LnVsop(3.26E-9, 6.09139244001, 456.3938392356), new Vsop87.LnVsop(3.0E-9, 5.11528183598, 375.3924655448), new Vsop87.LnVsop(3.21E-9, 0.11320249807, 69.3649725959), new Vsop87.LnVsop(2.99E-9, 6.0391232334, 332.8060117821), new Vsop87.LnVsop(3.28E-9, 3.47252263966, 73.4090004436), new Vsop87.LnVsop(2.83E-9, 1.81773059325, 647.0108333148), new Vsop87.LnVsop(3.08E-9, 3.50107540223, 30.7106720963), new Vsop87.LnVsop(2.78E-9, 3.85509473152, 760.25553592), new Vsop87.LnVsop(2.93E-9, 5.44449244354, 477.9157907918), new Vsop87.LnVsop(3.19E-9, 1.96492310465, 543.0242872189), new Vsop87.LnVsop(2.75E-9, 1.82480767582, 24.3790223882), new Vsop87.LnVsop(2.54E-9, 4.23529202563, 391.1734682239), new Vsop87.LnVsop(2.48E-9, 2.17740648239, 611.5861106627), new Vsop87.LnVsop(2.71E-9, 3.85067228463, 209.3669421749), new Vsop87.LnVsop(2.45E-9, 1.04008534095, 1332.4847706675), new Vsop87.LnVsop(2.48E-9, 6.19520746836, 1134.1635287565), new Vsop87.LnVsop(3.17E-9, 5.60194689908, 501.3797894433), new Vsop87.LnVsop(2.42E-9, 1.37720813333, 121.2520214833), new Vsop87.LnVsop(2.34E-9, 0.50970508504, 462.0229135281), new Vsop87.LnVsop(2.36E-9, 0.71434091094, 233.9060232575), new Vsop87.LnVsop(3.19E-9, 4.24234798459, 328.3525936572), new Vsop87.LnVsop(2.45E-9, 6.00685270776, 295.1942410061), new Vsop87.LnVsop(2.24E-9, 2.04173820334, 370.9390474199), new Vsop87.LnVsop(2.26E-9, 4.36158718577, 269.9214467406), new Vsop87.LnVsop(2.22E-9, 5.32240209336, 983.1158589136), new Vsop87.LnVsop(2.19E-9, 1.37802257893, 302.0953396858), new Vsop87.LnVsop(3.01E-9, 5.70756404145, 189.1807054807), new Vsop87.LnVsop(2.44E-9, 4.69736688026, 316.3918696566), new Vsop87.LnVsop(2.67E-9, 0.15744446717, 10213.285546211), new Vsop87.LnVsop(2.1E-9, 5.84976141374, 147.1155165798), new Vsop87.LnVsop(2.24E-9, 3.04838385551, 1439.5096981492), new Vsop87.LnVsop(2.67E-9, 2.78030672201, 144.1465711632), new Vsop87.LnVsop(2.04E-9, 2.37388505075, 275.5505210331), new Vsop87.LnVsop(2.29E-9, 2.33600590519, 150.5264049811), new Vsop87.LnVsop(1.94E-9, 5.11344829807, 1215.1649024473), new Vsop87.LnVsop(2.15E-9, 0.7013069954, 45.5766510387), new Vsop87.LnVsop(1.98E-9, 3.20849122961, 7.4223635415), new Vsop87.LnVsop(1.96E-9, 3.83527631644, 46.2097904851), new Vsop87.LnVsop(1.95E-9, 6.08813214815, 344.7030453079), new Vsop87.LnVsop(1.79E-9, 4.70649738298, 518.6452648307), new Vsop87.LnVsop(1.76E-9, 3.72183112618, 150.0844619964), new Vsop87.LnVsop(2.22E-9, 6.13768802796, 6.2197751235), new Vsop87.LnVsop(1.74E-9, 1.87343899875, 310.1720945331), new Vsop87.LnVsop(1.68E-9, 3.3420961142, 173.9422195228), new Vsop87.LnVsop(1.92E-9, 0.4164424183, 0.9632078465), new Vsop87.LnVsop(1.41E-9, 1.70340116374, 531.1754378029), new Vsop87.LnVsop(1.49E-9, 3.99276635695, 228.7982138268), new Vsop87.LnVsop(1.37E-9, 6.20556096334, 369.4545747116), new Vsop87.LnVsop(1.45E-9, 3.96204016046, 350.3321196004), new Vsop87.LnVsop(1.26E-9, 5.28560984253, 329.8370663655), new Vsop87.LnVsop(1.32E-9, 4.51993002555, 148.5999892881), new Vsop87.LnVsop(1.25E-9, 4.24716365077, 248.7238180901), new Vsop87.LnVsop(1.31E-9, 4.06190440824, 526.722019678), new Vsop87.LnVsop(1.2E-9, 4.08620475792, 154.979823106), new Vsop87.LnVsop(1.34E-9, 3.16619358295, 262.4778313397), new Vsop87.LnVsop(1.21E-9, 2.31292076167, 232.0490435337), new Vsop87.LnVsop(1.25E-9, 4.25542060721, 377.1588225434), new Vsop87.LnVsop(1.19E-9, 4.1219384181, 404.6186649328), new Vsop87.LnVsop(1.3E-9, 6.09762672394, 171.6545976624), new Vsop87.LnVsop(1.27E-9, 3.76800714166, 369.0820676961), new Vsop87.LnVsop(1.0E-9, 2.65367785044, 703.6331846174), new Vsop87.LnVsop(1.27E-9, 3.335368644, 149.0419322728), new Vsop87.LnVsop(1.16E-9, 4.77834673196, 1289.9465010146), new Vsop87.LnVsop(9.6E-10, 2.4715516937, 210.3301500214), new Vsop87.LnVsop(9.7E-10, 1.08835035283, 156.1554792736), new Vsop87.LnVsop(1.08E-9, 3.07832539912, 6133.5126528568), new Vsop87.LnVsop(1.08E-9, 2.03236554349, 6283.0758499914), new Vsop87.LnVsop(1.0E-9, 4.75380350867, 218.9281697305), new Vsop87.LnVsop(9.3E-10, 1.66567734962, 668.2084619653), new Vsop87.LnVsop(9.7E-10, 0.64083375068, 252.6559713532), new Vsop87.LnVsop(9.1E-10, 4.11478686503, 166.828672522), new Vsop87.LnVsop(8.9E-10, 4.92738306385, 353.301065017), new Vsop87.LnVsop(8.1E-10, 1.42684401779, 831.1049812242), new Vsop87.LnVsop(8.4E-10, 2.75226196759, 217.2312487011), new Vsop87.LnVsop(8.3E-10, 4.26421510316, 383.0967133766), new Vsop87.LnVsop(9.8E-10, 0.58553892847, 339.2864193365), new Vsop87.LnVsop(1.01E-9, 4.62998086587, 756.3233826569), new Vsop87.LnVsop(7.9E-10, 5.7969252212, 443.8636662634), new Vsop87.LnVsop(7.5E-10, 3.3904628513, 447.2051186955), new Vsop87.LnVsop(7.6E-10, 0.11314255037, 406.1031376411), new Vsop87.LnVsop(7.4E-10, 0.54434880673, 33.1371007917), new Vsop87.LnVsop(7.5E-10, 2.44458975326, 120.9913890524), new Vsop87.LnVsop(7.4E-10, 0.63126666381, 335.7749571987)};
        private static final Vsop87.LnVsop[] uranus_latitude_b1 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(3.4101978E-4, 0.01321929936, 74.7815985673), new Vsop87.LnVsop(2.480115E-5, 2.73961370453, 149.5631971346), new Vsop87.LnVsop(1.719377E-5, 0.0, 0.0), new Vsop87.LnVsop(3.95276E-6, 5.49322816551, 76.2660712756), new Vsop87.LnVsop(3.08903E-6, 3.61139770633, 73.297125859), new Vsop87.LnVsop(1.81125E-6, 5.32079457105, 224.3447957019), new Vsop87.LnVsop(1.4452E-6, 4.22110521671, 63.7358983034), new Vsop87.LnVsop(7.6343E-7, 4.54620999213, 85.8272988312), new Vsop87.LnVsop(7.2633E-7, 5.97811706013, 1.4844727083), new Vsop87.LnVsop(6.5492E-7, 2.77607065171, 11.0457002639), new Vsop87.LnVsop(6.3931E-7, 6.15917217447, 138.5174968707), new Vsop87.LnVsop(5.0972E-7, 1.79457572126, 151.0476698429), new Vsop87.LnVsop(3.993E-7, 3.59559614775, 148.0787244263), new Vsop87.LnVsop(3.6667E-7, 3.82753352893, 70.8494453042), new Vsop87.LnVsop(2.6969E-7, 4.71074996908, 78.7137518304), new Vsop87.LnVsop(2.7205E-7, 4.22769491494, 71.8126531507), new Vsop87.LnVsop(2.2074E-7, 4.76357435668, 213.299095438), new Vsop87.LnVsop(2.2655E-7, 4.40615405121, 77.7505439839), new Vsop87.LnVsop(1.572E-7, 1.55930265947, 529.6909650946), new Vsop87.LnVsop(1.009E-7, 5.83224201984, 145.6310438715), new Vsop87.LnVsop(1.2912E-7, 1.56375170441, 299.1263942692), new Vsop87.LnVsop(7.956E-8, 5.0228752619, 2.9689454166), new Vsop87.LnVsop(8.579E-8, 6.26698868752, 222.8603229936), new Vsop87.LnVsop(7.534E-8, 0.80106371071, 160.6088973985), new Vsop87.LnVsop(6.679E-8, 2.7852838806, 3.9321532631), new Vsop87.LnVsop(5.496E-8, 3.31254191722, 77.962992305), new Vsop87.LnVsop(5.232E-8, 5.06918050814, 71.6002048296), new Vsop87.LnVsop(4.398E-8, 4.52763457543, 380.12776796), new Vsop87.LnVsop(5.025E-8, 1.23324638522, 52.6901980395), new Vsop87.LnVsop(5.16E-8, 4.31709832477, 225.8292684102), new Vsop87.LnVsop(3.31E-8, 3.75868972095, 35.1640902212), new Vsop87.LnVsop(3.866E-8, 1.2637098235, 65.2203710117), new Vsop87.LnVsop(3.055E-8, 0.62704236969, 152.5321425512), new Vsop87.LnVsop(2.433E-8, 5.16881959896, 39.6175083461), new Vsop87.LnVsop(3.04E-8, 2.69522691477, 202.2533951741), new Vsop87.LnVsop(2.312E-8, 5.05125177167, 22.0914005278), new Vsop87.LnVsop(2.685E-8, 0.3934829935, 84.3428261229), new Vsop87.LnVsop(2.372E-8, 5.24162482086, 56.6223513026), new Vsop87.LnVsop(2.088E-8, 1.79153906168, 220.4126424388), new Vsop87.LnVsop(2.085E-8, 3.50728589034, 87.3117715395), new Vsop87.LnVsop(2.17E-8, 0.92046078692, 153.4953503977), new Vsop87.LnVsop(1.813E-8, 4.5820540042, 146.594251718), new Vsop87.LnVsop(1.712E-8, 3.46795755957, 111.4301614968), new Vsop87.LnVsop(1.669E-8, 0.52544187039, 184.7272873558), new Vsop87.LnVsop(1.69E-8, 3.51435037186, 351.8165923087), new Vsop87.LnVsop(1.623E-8, 1.83332553557, 72.3339180125), new Vsop87.LnVsop(1.615E-8, 3.22111940844, 79.2350166922), new Vsop87.LnVsop(1.443E-8, 0.38490278682, 9.5612275556), new Vsop87.LnVsop(1.379E-8, 2.25314683721, 131.4039498699), new Vsop87.LnVsop(1.471E-8, 5.65482351957, 67.6680515665), new Vsop87.LnVsop(1.513E-8, 1.70291762548, 12.5301729722), new Vsop87.LnVsop(1.219E-8, 1.01279910067, 127.4717966068), new Vsop87.LnVsop(1.595E-8, 5.26092020655, 62.2514255951), new Vsop87.LnVsop(1.392E-8, 2.1904421873, 206.1855484372), new Vsop87.LnVsop(1.569E-8, 3.39043730503, 277.0349937414), new Vsop87.LnVsop(1.56E-8, 3.27054489518, 36.6485629295), new Vsop87.LnVsop(1.162E-8, 0.53527505489, 77.2292791221), new Vsop87.LnVsop(1.085E-8, 1.27498553595, 73.8183907208), new Vsop87.LnVsop(1.257E-8, 0.04368108516, 18.1592472647), new Vsop87.LnVsop(1.047E-8, 0.81042117668, 75.7448064138), new Vsop87.LnVsop(1.038E-8, 3.90628138392, 4.4534181249), new Vsop87.LnVsop(9.56E-9, 3.66430920732, 74.8934731519), new Vsop87.LnVsop(1.052E-8, 2.41090141006, 297.6419215609), new Vsop87.LnVsop(9.76E-9, 5.46581402543, 70.3281804424), new Vsop87.LnVsop(1.177E-8, 0.17623728581, 426.598190876), new Vsop87.LnVsop(8.53E-9, 0.81527596999, 137.0330241624), new Vsop87.LnVsop(8.62E-9, 1.76954399486, 305.3461693927), new Vsop87.LnVsop(7.26E-9, 2.1975807679, 112.9146342051), new Vsop87.LnVsop(7.91E-9, 2.49340799866, 1059.3819301892), new Vsop87.LnVsop(6.96E-9, 4.12237397933, 109.9456887885), new Vsop87.LnVsop(6.94E-9, 1.89100616611, 92.940845832), new Vsop87.LnVsop(7.11E-9, 4.06903566155, 373.9079928365), new Vsop87.LnVsop(5.84E-9, 6.17026395543, 81.8951455681), new Vsop87.LnVsop(6.6E-9, 4.96483571441, 74.6697239827), new Vsop87.LnVsop(5.66E-9, 5.130465689, 490.3340891794), new Vsop87.LnVsop(5.59E-9, 0.90292303032, 221.3758502853), new Vsop87.LnVsop(6.92E-9, 0.12427497048, 3.1813937377), new Vsop87.LnVsop(7.34E-9, 0.6053195787, 38.1330356378), new Vsop87.LnVsop(5.32E-9, 3.98648434092, 604.4725636619), new Vsop87.LnVsop(5.84E-9, 5.0668954748, 288.0806940053), new Vsop87.LnVsop(6.29E-9, 0.54026926209, 96.8729990951), new Vsop87.LnVsop(5.61E-9, 4.73267608947, 454.9093665273), new Vsop87.LnVsop(4.7E-9, 3.9928038929, 41.1019810544), new Vsop87.LnVsop(5.66E-9, 6.02809954245, 191.2076949102), new Vsop87.LnVsop(5.07E-9, 2.22687412142, 265.9892934775), new Vsop87.LnVsop(5.06E-9, 1.87736218659, 7.1135470008), new Vsop87.LnVsop(4.39E-9, 3.41337176747, 80.1982245387), new Vsop87.LnVsop(4.1E-9, 2.50600627363, 142.4496501338), new Vsop87.LnVsop(4.22E-9, 3.31613690285, 235.3904959658), new Vsop87.LnVsop(3.72E-9, 4.59862949974, 536.8045120954), new Vsop87.LnVsop(3.71E-9, 0.79783261377, 108.4612160802), new Vsop87.LnVsop(3.73E-9, 4.5699608902, 415.5524906121), new Vsop87.LnVsop(3.51E-9, 5.99218780431, 186.2117600641), new Vsop87.LnVsop(4.07E-9, 4.34825659263, 340.7708920448), new Vsop87.LnVsop(3.28E-9, 0.6573822775, 66.70484372), new Vsop87.LnVsop(3.72E-9, 5.10831450067, 522.5774180938), new Vsop87.LnVsop(3.43E-9, 0.53613562161, 300.6108669775), new Vsop87.LnVsop(2.7E-9, 1.27650196236, 703.6331846174), new Vsop87.LnVsop(2.78E-9, 4.58530381992, 195.1398481733), new Vsop87.LnVsop(2.39E-9, 0.43515793516, 33.1371007917), new Vsop87.LnVsop(2.37E-9, 3.8204136745, 617.8058857862), new Vsop87.LnVsop(2.35E-9, 4.20082783313, 116.4260963429), new Vsop87.LnVsop(2.35E-9, 1.41272118988, 835.0371344873), new Vsop87.LnVsop(2.45E-9, 4.77313758758, 41.6444977756), new Vsop87.LnVsop(1.98E-9, 0.36712400018, 2.4476805548), new Vsop87.LnVsop(1.93E-9, 3.18074408969, 387.2413149608), new Vsop87.LnVsop(2.04E-9, 3.17054171814, 211.8146227297), new Vsop87.LnVsop(2.42E-9, 1.2387165217, 146.3818033969), new Vsop87.LnVsop(2.27E-9, 2.35811929824, 159.1244246902), new Vsop87.LnVsop(1.86E-9, 5.03606957476, 14.977853527), new Vsop87.LnVsop(2.11E-9, 3.80164653477, 373.0142209592), new Vsop87.LnVsop(2.09E-9, 3.12060090889, 227.3137411185), new Vsop87.LnVsop(1.66E-9, 3.2646448643, 259.5088859231), new Vsop87.LnVsop(1.69E-9, 1.43527176999, 152.7445908723), new Vsop87.LnVsop(1.27E-9, 2.56383866135, 140.001969579), new Vsop87.LnVsop(1.24E-9, 6.0393700405, 162.0933701068), new Vsop87.LnVsop(1.18E-9, 1.35527417493, 114.3991069134), new Vsop87.LnVsop(1.1E-9, 1.36513996746, 183.2428146475), new Vsop87.LnVsop(1.09E-9, 2.14362406822, 209.3669421749), new Vsop87.LnVsop(1.16E-9, 3.42267498449, 228.276948965), new Vsop87.LnVsop(1.04E-9, 5.33634525923, 378.6432952517), new Vsop87.LnVsop(1.28E-9, 5.42597035936, 230.5645708254), new Vsop87.LnVsop(1.15E-9, 1.15568409498, 909.8187330546), new Vsop87.LnVsop(8.6E-10, 1.55888062727, 344.7030453079), new Vsop87.LnVsop(9.8E-10, 5.72850189948, 154.0166152595), new Vsop87.LnVsop(1.04E-9, 5.06629922886, 145.1097790097), new Vsop87.LnVsop(9.9E-10, 3.88447445684, 33.6796175129), new Vsop87.LnVsop(8.5E-10, 6.1502517387, 269.9214467406), new Vsop87.LnVsop(8.5E-10, 3.47642579503, 296.1574488526), new Vsop87.LnVsop(7.8E-10, 0.83351167637, 144.1465711632)};
        private static final Vsop87.LnVsop[] uranus_latitude_b2 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(7.64663E-6, 1.74870957857, 74.7815985673), new Vsop87.LnVsop(5.5734E-7, 3.14159265359, 0.0), new Vsop87.LnVsop(2.5641E-7, 5.67301557131, 149.5631971346), new Vsop87.LnVsop(1.3335E-7, 5.92348443969, 73.297125859), new Vsop87.LnVsop(6.636E-8, 2.30241577514, 85.8272988312), new Vsop87.LnVsop(4.926E-8, 2.21241492976, 76.2660712756), new Vsop87.LnVsop(4.368E-8, 0.76649493506, 11.0457002639), new Vsop87.LnVsop(4.095E-8, 1.81604424547, 70.8494453042), new Vsop87.LnVsop(3.55E-8, 2.72620892642, 224.3447957019), new Vsop87.LnVsop(3.556E-8, 0.36898980602, 78.7137518304), new Vsop87.LnVsop(3.799E-8, 1.75732801545, 138.5174968707), new Vsop87.LnVsop(1.82E-8, 1.54477121376, 77.962992305), new Vsop87.LnVsop(1.651E-8, 1.41591379356, 1.4844727083), new Vsop87.LnVsop(1.608E-8, 6.22512841748, 213.299095438), new Vsop87.LnVsop(1.452E-8, 3.90164387464, 145.6310438715), new Vsop87.LnVsop(1.245E-8, 3.04960471697, 529.6909650946), new Vsop87.LnVsop(1.689E-8, 0.57422602041, 71.6002048296), new Vsop87.LnVsop(1.082E-8, 5.44260490226, 151.0476698429), new Vsop87.LnVsop(1.033E-8, 5.50906270157, 63.7358983034), new Vsop87.LnVsop(9.79E-9, 4.45089803473, 3.9321532631), new Vsop87.LnVsop(8.95E-9, 4.45228515086, 148.0787244263), new Vsop87.LnVsop(6.1E-9, 0.69755363233, 71.8126531507), new Vsop87.LnVsop(7.24E-9, 4.66998863825, 160.6088973985), new Vsop87.LnVsop(3.77E-9, 5.83975114717, 127.4717966068), new Vsop87.LnVsop(3.95E-9, 2.05229057211, 77.7505439839), new Vsop87.LnVsop(3.33E-9, 3.7658083465, 454.9093665273), new Vsop87.LnVsop(3.09E-9, 4.06945653305, 18.1592472647), new Vsop87.LnVsop(2.86E-9, 0.1071498385, 220.4126424388), new Vsop87.LnVsop(2.81E-9, 5.45374336062, 299.1263942692), new Vsop87.LnVsop(3.23E-9, 0.0494867586, 72.3339180125), new Vsop87.LnVsop(3.65E-9, 2.39747909046, 56.6223513026), new Vsop87.LnVsop(2.58E-9, 3.54572684987, 52.6901980395), new Vsop87.LnVsop(2.14E-9, 1.99573431344, 22.0914005278), new Vsop87.LnVsop(2.2E-9, 5.12637793339, 3.1813937377), new Vsop87.LnVsop(1.34E-9, 4.08992196303, 131.4039498699), new Vsop87.LnVsop(1.47E-9, 2.9213955648, 153.4953503977), new Vsop87.LnVsop(9.6E-10, 1.97465913947, 225.8292684102), new Vsop87.LnVsop(7.6E-10, 1.48178075191, 206.1855484372), new Vsop87.LnVsop(8.5E-10, 2.49786959141, 380.12776796)};
        private static final Vsop87.LnVsop[] uranus_latitude_b3 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(2.1201E-7, 3.16540759295, 74.7815985673), new Vsop87.LnVsop(1.182E-8, 4.44441014271, 149.5631971346), new Vsop87.LnVsop(1.184E-8, 3.14159265359, 0.0), new Vsop87.LnVsop(4.33E-9, 1.1037178034, 73.297125859), new Vsop87.LnVsop(4.12E-9, 0.43984657946, 76.2660712756), new Vsop87.LnVsop(4.66E-9, 5.92951996029, 70.8494453042), new Vsop87.LnVsop(4.64E-9, 1.88752032733, 78.7137518304), new Vsop87.LnVsop(4.04E-9, 6.16046303283, 85.8272988312), new Vsop87.LnVsop(4.01E-9, 1.6892195671, 63.7358983034), new Vsop87.LnVsop(2.95E-9, 5.96253146711, 77.962992305), new Vsop87.LnVsop(2.94E-9, 1.85767623542, 71.6002048296), new Vsop87.LnVsop(1.74E-9, 4.79023778832, 11.0457002639), new Vsop87.LnVsop(9.9E-10, 0.42283006135, 224.3447957019), new Vsop87.LnVsop(8.8E-10, 2.27837607751, 145.6310438715), new Vsop87.LnVsop(7.9E-10, 3.66485269931, 138.5174968707)};

        Latitude() {
        }
    }

    static class Longitude {
        private static final Vsop87.LnVsop[] uranus_longitude_l0 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(5.48129294297, 0.0, 0.0), new Vsop87.LnVsop(0.09260408234, 0.89106421507, 74.7815985673), new Vsop87.LnVsop(0.01504247898, 3.6271926092, 1.4844727083), new Vsop87.LnVsop(0.00365981674, 1.89962179044, 73.297125859), new Vsop87.LnVsop(0.00272328168, 3.35823706307, 149.5631971346), new Vsop87.LnVsop(7.0328461E-4, 5.39254450063, 63.7358983034), new Vsop87.LnVsop(6.8892678E-4, 6.09292483287, 76.2660712756), new Vsop87.LnVsop(6.1998615E-4, 2.26952066061, 2.9689454166), new Vsop87.LnVsop(6.1950719E-4, 2.85098872691, 11.0457002639), new Vsop87.LnVsop(2.646877E-4, 3.14152083966, 71.8126531507), new Vsop87.LnVsop(2.5710476E-4, 6.11379840493, 454.9093665273), new Vsop87.LnVsop(2.107885E-4, 4.36059339067, 148.0787244263), new Vsop87.LnVsop(1.7818647E-4, 1.74436930289, 36.6485629295), new Vsop87.LnVsop(1.4613507E-4, 4.73732166022, 3.9321532631), new Vsop87.LnVsop(1.1162509E-4, 5.8268179635, 224.3447957019), new Vsop87.LnVsop(1.099791E-4, 0.48865004018, 138.5174968707), new Vsop87.LnVsop(9.527478E-5, 2.95516862826, 35.1640902212), new Vsop87.LnVsop(7.545601E-5, 5.236265824, 109.9456887885), new Vsop87.LnVsop(4.220241E-5, 3.23328220918, 70.8494453042), new Vsop87.LnVsop(4.0519E-5, 2.277550173, 151.0476698429), new Vsop87.LnVsop(3.354596E-5, 1.0654900738, 4.4534181249), new Vsop87.LnVsop(2.926718E-5, 4.62903718891, 9.5612275556), new Vsop87.LnVsop(3.49034E-5, 5.48306144511, 146.594251718), new Vsop87.LnVsop(3.144069E-5, 4.75199570434, 77.7505439839), new Vsop87.LnVsop(2.922333E-5, 5.35235361027, 85.8272988312), new Vsop87.LnVsop(2.272788E-5, 4.36600400036, 70.3281804424), new Vsop87.LnVsop(2.051219E-5, 1.51773566586, 0.1118745846), new Vsop87.LnVsop(2.148602E-5, 0.60745949945, 38.1330356378), new Vsop87.LnVsop(1.991643E-5, 4.92437588682, 277.0349937414), new Vsop87.LnVsop(1.376226E-5, 2.04283539351, 65.2203710117), new Vsop87.LnVsop(1.666902E-5, 3.62744066769, 380.12776796), new Vsop87.LnVsop(1.284107E-5, 3.11347961505, 202.2533951741), new Vsop87.LnVsop(1.150429E-5, 0.93343589092, 3.1813937377), new Vsop87.LnVsop(1.533221E-5, 2.58594681212, 52.6901980395), new Vsop87.LnVsop(1.281604E-5, 0.54271272721, 222.8603229936), new Vsop87.LnVsop(1.372139E-5, 4.19641530878, 111.4301614968), new Vsop87.LnVsop(1.221029E-5, 0.1990065003, 108.4612160802), new Vsop87.LnVsop(9.46181E-6, 1.19253165736, 127.4717966068), new Vsop87.LnVsop(1.150989E-5, 4.17898916639, 33.6796175129), new Vsop87.LnVsop(1.244347E-5, 0.91614441731, 2.4476805548), new Vsop87.LnVsop(1.072013E-5, 0.23566016888, 62.2514255951), new Vsop87.LnVsop(1.090463E-5, 1.77501500531, 12.5301729722), new Vsop87.LnVsop(7.07935E-6, 5.18291670033, 213.299095438), new Vsop87.LnVsop(6.53376E-6, 0.96587864431, 78.7137518304), new Vsop87.LnVsop(6.2757E-6, 0.18209040157, 984.6003316219), new Vsop87.LnVsop(5.24485E-6, 2.01275350435, 299.1263942692), new Vsop87.LnVsop(5.59396E-6, 3.35768635981, 0.5212648618), new Vsop87.LnVsop(6.06847E-6, 5.4320988925, 529.6909650946), new Vsop87.LnVsop(4.04897E-6, 5.98690517582, 8.0767548473), new Vsop87.LnVsop(4.67183E-6, 0.41482520325, 145.1097790097), new Vsop87.LnVsop(4.71311E-6, 1.40661608158, 184.7272873558), new Vsop87.LnVsop(4.83226E-6, 2.10553218341, 0.9632078465), new Vsop87.LnVsop(3.95569E-6, 5.87037914022, 351.8165923087), new Vsop87.LnVsop(4.33527E-6, 5.52141037763, 183.2428146475), new Vsop87.LnVsop(3.09843E-6, 5.83301863492, 145.6310438715), new Vsop87.LnVsop(3.78642E-6, 2.34989391811, 56.6223513026), new Vsop87.LnVsop(3.99033E-6, 0.33796522578, 415.5524906121), new Vsop87.LnVsop(3.00392E-6, 5.64355207373, 22.0914005278), new Vsop87.LnVsop(2.4923E-6, 4.74621772167, 225.8292684102), new Vsop87.LnVsop(2.39311E-6, 2.35072447972, 137.0330241624), new Vsop87.LnVsop(2.94103E-6, 5.83919833199, 39.6175083461), new Vsop87.LnVsop(2.1645E-6, 4.77807782477, 340.7708920448), new Vsop87.LnVsop(2.51784E-6, 1.63692846797, 221.3758502853), new Vsop87.LnVsop(2.19624E-6, 1.92233630317, 67.6680515665), new Vsop87.LnVsop(2.02019E-6, 1.29693040688, 0.0481841098), new Vsop87.LnVsop(2.24105E-6, 0.51589500446, 84.3428261229), new Vsop87.LnVsop(2.16563E-6, 6.14217553245, 5.9378908332), new Vsop87.LnVsop(2.22605E-6, 2.84314245655, 0.2606324309), new Vsop87.LnVsop(2.07907E-6, 5.5801263788, 68.8437077341), new Vsop87.LnVsop(1.8752E-6, 1.3192760652, 0.1600586944), new Vsop87.LnVsop(1.99306E-6, 0.95648612651, 152.5321425512), new Vsop87.LnVsop(1.58075E-6, 0.73795262538, 54.1746707478), new Vsop87.LnVsop(1.68606E-6, 5.87865394974, 18.1592472647), new Vsop87.LnVsop(1.70326E-6, 3.67712574811, 5.4166259714), new Vsop87.LnVsop(1.93647E-6, 1.88800957346, 456.3938392356), new Vsop87.LnVsop(1.93051E-6, 0.91616617785, 453.424893819), new Vsop87.LnVsop(1.81991E-6, 3.53625031273, 79.2350166922), new Vsop87.LnVsop(1.73102E-6, 1.53869634445, 160.6088973985), new Vsop87.LnVsop(1.64483E-6, 1.42390725018, 106.9767433719), new Vsop87.LnVsop(1.7194E-6, 5.67948631369, 219.891377577), new Vsop87.LnVsop(1.62805E-6, 3.05027759814, 112.9146342051), new Vsop87.LnVsop(1.46659E-6, 1.26296726443, 59.8037450403), new Vsop87.LnVsop(1.39276E-6, 5.38697273752, 32.1951448046), new Vsop87.LnVsop(1.38636E-6, 4.25998533357, 909.8187330546), new Vsop87.LnVsop(1.43058E-6, 1.2998045387, 35.4247226521), new Vsop87.LnVsop(1.23986E-6, 1.37489956563, 7.1135470008), new Vsop87.LnVsop(1.04582E-6, 5.02793726187, 0.7507595254), new Vsop87.LnVsop(1.03295E-6, 0.68145096277, 14.977853527), new Vsop87.LnVsop(9.4957E-7, 0.90678215577, 74.6697239827), new Vsop87.LnVsop(8.2948E-7, 2.92800368384, 265.9892934775), new Vsop87.LnVsop(1.10403E-6, 2.02666475709, 554.0699874828), new Vsop87.LnVsop(9.4433E-7, 3.94271122207, 74.8934731519), new Vsop87.LnVsop(8.0072E-7, 1.01583506701, 6.592282139), new Vsop87.LnVsop(1.09576E-6, 5.70572405893, 77.962992305), new Vsop87.LnVsop(8.5946E-7, 1.70581556772, 82.8583534146), new Vsop87.LnVsop(1.03799E-6, 1.45794315266, 24.3790223882), new Vsop87.LnVsop(7.4661E-7, 4.63178804642, 69.3649725959), new Vsop87.LnVsop(7.9813E-7, 3.00965058125, 297.6419215609), new Vsop87.LnVsop(8.449E-7, 0.36886722094, 186.2117600641), new Vsop87.LnVsop(8.8657E-7, 0.52498114072, 181.7583419392), new Vsop87.LnVsop(7.0368E-7, 1.18984702891, 66.70484372), new Vsop87.LnVsop(6.9971E-7, 0.87463619381, 305.3461693927), new Vsop87.LnVsop(7.0082E-7, 3.75845990682, 131.4039498699), new Vsop87.LnVsop(8.435E-7, 5.88592009032, 256.5399405065), new Vsop87.LnVsop(7.4493E-7, 6.2423868428, 447.7958195265), new Vsop87.LnVsop(6.2454E-7, 0.16868402018, 479.2883889155), new Vsop87.LnVsop(7.2904E-7, 2.84891153624, 462.0229135281), new Vsop87.LnVsop(6.9205E-7, 4.43939850837, 39.3568759152), new Vsop87.LnVsop(7.6729E-7, 4.58716659215, 6.2197751235), new Vsop87.LnVsop(7.3423E-7, 4.27591432865, 87.3117715395), new Vsop87.LnVsop(5.5577E-7, 1.49804110443, 71.6002048296), new Vsop87.LnVsop(5.7315E-7, 1.63007488533, 143.6253063014), new Vsop87.LnVsop(6.1674E-7, 3.18616775231, 77.2292791221), new Vsop87.LnVsop(5.7668E-7, 3.67128264895, 51.2057253312), new Vsop87.LnVsop(5.0352E-7, 1.12355398826, 20.6069278195), new Vsop87.LnVsop(5.372E-7, 5.51853172042, 128.9562693151), new Vsop87.LnVsop(5.7895E-7, 2.6686921691, 381.6122406683), new Vsop87.LnVsop(5.8089E-7, 1.5863521331, 60.7669528868), new Vsop87.LnVsop(4.539E-7, 0.48027056949, 14.0146456805), new Vsop87.LnVsop(3.7513E-7, 6.06768205316, 211.8146227297), new Vsop87.LnVsop(3.8565E-7, 3.43547372715, 153.4953503977), new Vsop87.LnVsop(4.6085E-7, 4.36220351003, 75.7448064138), new Vsop87.LnVsop(4.022E-7, 4.57551863155, 46.2097904851), new Vsop87.LnVsop(3.4314E-7, 2.9385893887, 140.001969579), new Vsop87.LnVsop(3.8754E-7, 5.59046474201, 99.1606209555), new Vsop87.LnVsop(3.4864E-7, 1.0287768134, 203.7378678824), new Vsop87.LnVsop(4.0016E-7, 0.69893479575, 218.4069048687), new Vsop87.LnVsop(3.2562E-7, 4.21895389367, 200.7689224658), new Vsop87.LnVsop(3.1889E-7, 5.50965372046, 72.3339180125), new Vsop87.LnVsop(4.1668E-7, 3.82449219367, 81.0013736908), new Vsop87.LnVsop(3.4668E-7, 0.39221757952, 1.3725981237), new Vsop87.LnVsop(3.9741E-7, 6.05490168728, 293.188503436), new Vsop87.LnVsop(2.7545E-7, 2.18754130148, 125.9873238985), new Vsop87.LnVsop(3.6328E-7, 1.66621808766, 258.0244132148), new Vsop87.LnVsop(3.5508E-7, 1.96672429313, 835.0371344873), new Vsop87.LnVsop(3.5373E-7, 3.72274050162, 692.5874843535), new Vsop87.LnVsop(2.7364E-7, 2.10315692995, 209.3669421749), new Vsop87.LnVsop(2.6442E-7, 4.48298644364, 373.9079928365), new Vsop87.LnVsop(3.4517E-7, 1.08687838842, 191.2076949102), new Vsop87.LnVsop(2.6317E-7, 3.6335778804, 490.3340891794), new Vsop87.LnVsop(2.9888E-7, 3.87365011384, 259.5088859231), new Vsop87.LnVsop(2.5926E-7, 0.54378574725, 41.6444977756), new Vsop87.LnVsop(2.711E-7, 0.00478270361, 28.5718080822), new Vsop87.LnVsop(2.6313E-7, 5.81236674192, 75.3028634291), new Vsop87.LnVsop(3.4277E-7, 6.05545630018, 275.5505210331), new Vsop87.LnVsop(2.4315E-7, 3.18651202042, 81.3738807063), new Vsop87.LnVsop(2.9936E-7, 1.8878903041, 269.9214467406), new Vsop87.LnVsop(2.6242E-7, 6.20368166778, 134.5853436076), new Vsop87.LnVsop(2.2842E-7, 0.92857008471, 288.0806940053), new Vsop87.LnVsop(2.5216E-7, 5.43032747843, 116.4260963429), new Vsop87.LnVsop(2.7063E-7, 4.75299776159, 41.1019810544), new Vsop87.LnVsop(2.2706E-7, 0.5305745312, 1514.2912967165), new Vsop87.LnVsop(2.648E-7, 4.77161377188, 284.1485407422), new Vsop87.LnVsop(2.195E-7, 4.59091247537, 404.5067903482), new Vsop87.LnVsop(2.2022E-7, 1.84418065243, 617.8058857862), new Vsop87.LnVsop(2.4811E-7, 4.70901440561, 378.6432952517), new Vsop87.LnVsop(2.904E-7, 0.17160028536, 528.2064923863), new Vsop87.LnVsop(2.0487E-7, 0.10247779138, 195.1398481733), new Vsop87.LnVsop(2.0726E-7, 5.62240737217, 55.6591434561), new Vsop87.LnVsop(2.5919E-7, 0.74700144605, 278.5194664497), new Vsop87.LnVsop(2.2824E-7, 3.58334799786, 1.5963472929), new Vsop87.LnVsop(2.1855E-7, 0.05691568897, 173.9422195228), new Vsop87.LnVsop(1.9045E-7, 2.30354999303, 5.1078094307), new Vsop87.LnVsop(2.0831E-7, 2.64115582292, 105.4922706636), new Vsop87.LnVsop(2.1849E-7, 5.87274563981, 45.5766510387), new Vsop87.LnVsop(2.1075E-7, 1.98176191313, 114.3991069134), new Vsop87.LnVsop(1.9306E-7, 2.84240229356, 159.1244246902), new Vsop87.LnVsop(1.9062E-7, 0.50604571692, 67.3592350258), new Vsop87.LnVsop(2.0431E-7, 3.77538635518, 135.5485514541), new Vsop87.LnVsop(1.7322E-7, 4.47827838578, 120.358249606), new Vsop87.LnVsop(2.0581E-7, 0.88703968592, 255.0554677982), new Vsop87.LnVsop(1.9339E-7, 1.4856940316, 0.8937718773), new Vsop87.LnVsop(2.1333E-7, 2.7445877721, 28.3111756513), new Vsop87.LnVsop(1.7629E-7, 4.09292272552, 296.1574488526), new Vsop87.LnVsop(1.5918E-7, 3.94524461273, 17.5261078183), new Vsop87.LnVsop(1.5556E-7, 0.92841352827, 300.6108669775), new Vsop87.LnVsop(1.6443E-7, 0.30879187235, 30.7106720963), new Vsop87.LnVsop(1.5248E-7, 4.93045860155, 7.4223635415), new Vsop87.LnVsop(1.93E-7, 6.21959323869, 329.8370663655), new Vsop87.LnVsop(1.3876E-7, 0.56084534056, 144.1465711632), new Vsop87.LnVsop(1.6198E-7, 2.30318612128, 344.7030453079), new Vsop87.LnVsop(1.6033E-7, 0.19604773155, 103.0927742186), new Vsop87.LnVsop(1.4368E-7, 2.57751058848, 230.5645708254), new Vsop87.LnVsop(1.6807E-7, 4.9362064894, 565.1156877467), new Vsop87.LnVsop(1.7121E-7, 1.82016259921, 294.6729761443), new Vsop87.LnVsop(1.6827E-7, 0.27566510604, 73.8183907208), new Vsop87.LnVsop(1.5455E-7, 1.91556741732, 96.8729990951), new Vsop87.LnVsop(1.5814E-7, 3.86318315976, 98.8999885246), new Vsop87.LnVsop(1.1923E-7, 6.17587234615, 44.7253177768), new Vsop87.LnVsop(1.2446E-7, 6.2246634541, 80.1982245387), new Vsop87.LnVsop(1.3001E-7, 1.9948387226, 27.0873353739), new Vsop87.LnVsop(1.318E-7, 3.43753711704, 227.3137411185), new Vsop87.LnVsop(1.1678E-7, 4.31505860166, 426.598190876), new Vsop87.LnVsop(1.4374E-7, 5.78359439943, 1059.3819301892), new Vsop87.LnVsop(1.5879E-7, 0.98454960135, 6208.2942514241), new Vsop87.LnVsop(1.1511E-7, 2.55846980442, 19.1224551112), new Vsop87.LnVsop(1.1193E-7, 1.74548073119, 220.4126424388), new Vsop87.LnVsop(1.1981E-7, 5.8435546521, 13.3333221243), new Vsop87.LnVsop(1.3333E-7, 5.39450805857, 391.1734682239), new Vsop87.LnVsop(1.2322E-7, 4.57477369077, 23.5758732361), new Vsop87.LnVsop(1.2847E-7, 1.77354298387, 180.2738692309), new Vsop87.LnVsop(1.1629E-7, 4.29071404978, 142.4496501338), new Vsop87.LnVsop(1.2214E-7, 2.44698830848, 100.3844612329), new Vsop87.LnVsop(1.2439E-7, 2.3266100767, 80.7194894005), new Vsop87.LnVsop(9.77E-8, 0.39792836846, 7.8643065262), new Vsop87.LnVsop(1.3165E-7, 2.74113201454, 177.8743727859), new Vsop87.LnVsop(1.2265E-7, 5.428160452, 831.1049812242), new Vsop87.LnVsop(1.0264E-7, 5.90199222998, 74.5209661364), new Vsop87.LnVsop(9.317E-8, 3.75869700707, 74.8297826771), new Vsop87.LnVsop(1.2284E-7, 5.52145313445, 74.2603337055), new Vsop87.LnVsop(1.0682E-7, 4.00694729802, 235.3904959658), new Vsop87.LnVsop(9.243E-8, 5.38488037675, 20.4468691251), new Vsop87.LnVsop(9.458E-8, 2.60118467048, 92.3077063856), new Vsop87.LnVsop(9.317E-8, 1.16483658243, 74.7334144575), new Vsop87.LnVsop(1.0786E-7, 1.88993609169, 241.6102710893), new Vsop87.LnVsop(1.0597E-7, 5.50467173303, 187.6962327724), new Vsop87.LnVsop(1.2035E-7, 6.02036249862, 154.0166152595), new Vsop87.LnVsop(9.129E-8, 1.15458738606, 0.6331394464), new Vsop87.LnVsop(1.1708E-7, 6.25765865911, 155.7829722581), new Vsop87.LnVsop(1.2186E-7, 5.79479693025, 1364.7280995819), new Vsop87.LnVsop(1.0992E-7, 5.7667459645, 628.8515860501), new Vsop87.LnVsop(8.531E-8, 5.1791803753, 1.6445314027), new Vsop87.LnVsop(8.662E-8, 3.78046237096, 74.9416572617), new Vsop87.LnVsop(1.1225E-7, 1.30868548209, 604.4725636619), new Vsop87.LnVsop(1.054E-7, 1.05897224519, 291.7040307277), new Vsop87.LnVsop(8.443E-8, 3.52060391248, 756.3233826569), new Vsop87.LnVsop(1.029E-7, 5.3049938479, 75.0422309982), new Vsop87.LnVsop(9.591E-8, 1.64200163871, 24.1183899573), new Vsop87.LnVsop(8.02E-8, 6.24545313293, 543.0242872189), new Vsop87.LnVsop(7.796E-8, 5.23505740309, 58.1068240109), new Vsop87.LnVsop(8.649E-8, 1.14271989382, 74.6215398729), new Vsop87.LnVsop(7.793E-8, 4.00212500951, 31.492569389), new Vsop87.LnVsop(8.915E-8, 3.63129999542, 408.4389436113), new Vsop87.LnVsop(7.195E-8, 4.24369275612, 110.2063212194), new Vsop87.LnVsop(9.545E-8, 2.00926809412, 331.3215390738), new Vsop87.LnVsop(8.786E-8, 2.25836637388, 451.9404211107), new Vsop87.LnVsop(9.768E-8, 0.10232823685, 366.485629295), new Vsop87.LnVsop(9.075E-8, 1.63090160034, 443.8636662634), new Vsop87.LnVsop(7.255E-8, 4.35305855248, 88.1149206916), new Vsop87.LnVsop(9.482E-8, 1.43114303369, 414.0680179038), new Vsop87.LnVsop(7.645E-8, 0.62076955028, 50.4025761791), new Vsop87.LnVsop(6.836E-8, 5.12192858785, 0.8031491521), new Vsop87.LnVsop(6.899E-8, 5.86240754958, 339.2864193365), new Vsop87.LnVsop(8.125E-8, 0.45159535895, 25.6028626656), new Vsop87.LnVsop(6.488E-8, 6.03171366016, 1.2238402774), new Vsop87.LnVsop(9.108E-8, 2.41055572869, 10138.5039476437), new Vsop87.LnVsop(8.139E-8, 0.21930359866, 422.6660376129), new Vsop87.LnVsop(7.164E-8, 4.00283046264, 157.6399519819), new Vsop87.LnVsop(6.393E-8, 4.47880072523, 79.889407998), new Vsop87.LnVsop(8.039E-8, 2.1016108553, 92.940845832), new Vsop87.LnVsop(6.773E-8, 1.38798529262, 16.6747745564), new Vsop87.LnVsop(6.816E-8, 2.84724339946, 142.1408335931), new Vsop87.LnVsop(7.788E-8, 5.86998158412, 760.25553592), new Vsop87.LnVsop(8.38E-8, 2.33770107198, 417.0369633204), new Vsop87.LnVsop(7.928E-8, 3.41948324447, 7.7042478318), new Vsop87.LnVsop(7.235E-8, 0.50521045386, 457.8783119439), new Vsop87.LnVsop(7.143E-8, 5.57879993926, 4.7353024152), new Vsop87.LnVsop(7.379E-8, 0.47767694338, 68.1893164283), new Vsop87.LnVsop(6.403E-8, 3.88657131997, 74.0308390419), new Vsop87.LnVsop(6.101E-8, 1.65240727244, 350.3321196004), new Vsop87.LnVsop(6.82E-8, 6.15375544111, 67.8804998876), new Vsop87.LnVsop(5.994E-8, 2.3608765312, 2.0057375701), new Vsop87.LnVsop(6.008E-8, 5.46469064027, 48.7580447764), new Vsop87.LnVsop(7.02E-8, 0.13804863634, 306.830642101), new Vsop87.LnVsop(5.72E-8, 1.49555002206, 206.1855484372), new Vsop87.LnVsop(6.862E-8, 1.08055101709, 465.9550667912), new Vsop87.LnVsop(6.413E-8, 5.07420793721, 4.665866446), new Vsop87.LnVsop(7.804E-8, 3.98873608283, 3.6233367224), new Vsop87.LnVsop(5.53E-8, 5.57878118094, 2.9207613068), new Vsop87.LnVsop(5.519E-8, 3.38213279322, 149.45132255), new Vsop87.LnVsop(6.111E-8, 1.95407755561, 216.9224321604), new Vsop87.LnVsop(6.58E-8, 2.7099382691, 329.7251917809), new Vsop87.LnVsop(5.835E-8, 3.99897551776, 347.8844390456), new Vsop87.LnVsop(5.112E-8, 2.42454049536, 342.2553647531), new Vsop87.LnVsop(5.533E-8, 2.83342316665, 260.9933586314), new Vsop87.LnVsop(5.727E-8, 0.49154098031, 0.3725070155), new Vsop87.LnVsop(5.395E-8, 2.78483514026, 13.4933808187), new Vsop87.LnVsop(6.024E-8, 4.78785737004, 558.0021407459), new Vsop87.LnVsop(4.903E-8, 1.76924594442, 333.657345044), new Vsop87.LnVsop(5.381E-8, 5.71120333625, 1.6969210294), new Vsop87.LnVsop(5.389E-8, 2.940752762, 9.4011688612), new Vsop87.LnVsop(5.042E-8, 5.47678294897, 372.4235201282), new Vsop87.LnVsop(5.093E-8, 3.43101132912, 518.6452648307), new Vsop87.LnVsop(4.766E-8, 5.34829276989, 61.2882177486), new Vsop87.LnVsop(5.655E-8, 3.30309284254, 0.6543913058), new Vsop87.LnVsop(5.566E-8, 0.44947190504, 162.0933701068), new Vsop87.LnVsop(5.834E-8, 3.46697149482, 55.1378785943), new Vsop87.LnVsop(5.656E-8, 1.23594821626, 328.3525936572), new Vsop87.LnVsop(5.071E-8, 5.42033083225, 977.4867846211), new Vsop87.LnVsop(5.719E-8, 0.66730329426, 92.0470739547), new Vsop87.LnVsop(5.283E-8, 2.4227215143, 58.319272332), new Vsop87.LnVsop(5.613E-8, 2.36101054919, 6.9010986797), new Vsop87.LnVsop(4.853E-8, 1.2709395912, 983.1158589136), new Vsop87.LnVsop(5.512E-8, 0.13294006611, 149.6750717192), new Vsop87.LnVsop(4.693E-8, 1.85511154338, 119.5069163441), new Vsop87.LnVsop(4.307E-8, 4.18173079985, 90.8232336773), new Vsop87.LnVsop(5.957E-8, 1.73124132593, 152.7445908723), new Vsop87.LnVsop(5.675E-8, 5.53546214308, 1087.6931058405), new Vsop87.LnVsop(4.562E-8, 3.26460078185, 89.7594520943), new Vsop87.LnVsop(5.594E-8, 5.75194360195, 358.9301393095), new Vsop87.LnVsop(4.689E-8, 5.01733767973, 43.1289704839), new Vsop87.LnVsop(4.424E-8, 0.97724627015, 4.192785694), new Vsop87.LnVsop(4.012E-8, 1.08246444514, 75.5323580927), new Vsop87.LnVsop(5.623E-8, 1.1038737829, 66.9172920411), new Vsop87.LnVsop(4.048E-8, 1.94074496693, 17.2654753874), new Vsop87.LnVsop(4.768E-8, 2.24189462905, 986.0848043302), new Vsop87.LnVsop(5.213E-8, 1.36495122038, 767.3690829208), new Vsop87.LnVsop(4.922E-8, 0.1374247914, 0.8513332619), new Vsop87.LnVsop(4.342E-8, 5.33545538316, 152.0108776894), new Vsop87.LnVsop(3.918E-8, 3.85162186106, 2.2876218604), new Vsop87.LnVsop(3.931E-8, 1.7019168766, 5.6290742925), new Vsop87.LnVsop(4.658E-8, 0.93863607366, 267.4737661858), new Vsop87.LnVsop(3.895E-8, 5.87672991487, 16.4623262353), new Vsop87.LnVsop(5.176E-8, 3.40869435646, 1289.9465010146), new Vsop87.LnVsop(4.628E-8, 5.42648205428, 16.04163511), new Vsop87.LnVsop(5.039E-8, 2.16699952281, 367.9701020033), new Vsop87.LnVsop(3.775E-8, 0.59927848906, 210.3301500214), new Vsop87.LnVsop(5.015E-8, 0.26807931893, 403.1341922245), new Vsop87.LnVsop(4.535E-8, 2.90035619661, 59.2824801785), new Vsop87.LnVsop(4.571E-8, 0.85791209853, 969.6224780949), new Vsop87.LnVsop(4.201E-8, 5.12033927784, 19.0105805266), new Vsop87.LnVsop(4.7E-8, 4.17550908523, 130.4407420234), new Vsop87.LnVsop(3.694E-8, 0.75965712567, 114.1384744825), new Vsop87.LnVsop(3.794E-8, 4.59731406975, 25.8634950965), new Vsop87.LnVsop(4.019E-8, 4.98465691172, 30.0562807905), new Vsop87.LnVsop(4.735E-8, 3.76713441227, 373.0142209592), new Vsop87.LnVsop(3.635E-8, 3.20392753847, 991.7138786227), new Vsop87.LnVsop(4.021E-8, 0.47038124299, 387.2413149608), new Vsop87.LnVsop(3.443E-8, 5.20975249527, 894.8408795276), new Vsop87.LnVsop(3.304E-8, 2.01134489744, 286.596221297), new Vsop87.LnVsop(3.315E-8, 3.98568908785, 264.5048207692), new Vsop87.LnVsop(3.28E-8, 5.46909245799, 192.6921676185), new Vsop87.LnVsop(4.481E-8, 6.1551081404, 173.6815870919), new Vsop87.LnVsop(3.302E-8, 1.63115447974, 681.5417840896), new Vsop87.LnVsop(3.193E-8, 3.9651467602, 146.3818033969), new Vsop87.LnVsop(4.0E-8, 1.40741532794, 383.0967133766), new Vsop87.LnVsop(3.523E-8, 5.19259518595, 97.4155158163), new Vsop87.LnVsop(3.844E-8, 3.60271287642, 0.590700831), new Vsop87.LnVsop(3.183E-8, 4.15987875012, 76.4785195967), new Vsop87.LnVsop(3.122E-8, 4.5019516359, 1439.5096981492), new Vsop87.LnVsop(3.238E-8, 1.64548946107, 214.7835681463), new Vsop87.LnVsop(3.543E-8, 4.15778489389, 68.5618234438), new Vsop87.LnVsop(2.95E-8, 2.95792688293, 120.9913890524), new Vsop87.LnVsop(2.904E-8, 3.69931078718, 874.3940104025), new Vsop87.LnVsop(3.292E-8, 2.14601654518, 253.5709950899), new Vsop87.LnVsop(3.225E-8, 2.56298661136, 60.5545045657), new Vsop87.LnVsop(3.071E-8, 3.57595003388, 117.9105690512), new Vsop87.LnVsop(3.237E-8, 4.80214981899, 19.643719973), new Vsop87.LnVsop(2.78E-8, 0.65215559196, 42.5382696529), new Vsop87.LnVsop(3.24E-8, 5.31726675118, 546.956440482), new Vsop87.LnVsop(3.657E-8, 5.89905956226, 16.1535096946), new Vsop87.LnVsop(3.547E-8, 2.76324444984, 82.4858463991), new Vsop87.LnVsop(3.556E-8, 4.68368769233, 593.426863398), new Vsop87.LnVsop(3.342E-8, 1.56467995408, 312.4597163935), new Vsop87.LnVsop(3.437E-8, 4.95814102027, 49.7212526229), new Vsop87.LnVsop(3.593E-8, 2.52079368833, 22.8945496799), new Vsop87.LnVsop(2.672E-8, 2.41694469728, 29.2049475286), new Vsop87.LnVsop(2.899E-8, 3.48228574147, 95.3885263868), new Vsop87.LnVsop(3.102E-8, 1.42591645035, 17.6379824029), new Vsop87.LnVsop(3.341E-8, 2.64162643824, 771.3012361839), new Vsop87.LnVsop(2.547E-8, 6.10642153796, 455.8725743738), new Vsop87.LnVsop(2.68E-8, 1.16873928613, 477.8039162072), new Vsop87.LnVsop(3.335E-8, 3.01819753318, 88.7962442478), new Vsop87.LnVsop(3.356E-8, 3.09879595032, 552.5855147745), new Vsop87.LnVsop(2.947E-8, 0.32015414114, 150.5264049811), new Vsop87.LnVsop(2.678E-8, 1.42841144096, 1.1119656928), new Vsop87.LnVsop(2.54E-8, 1.94053883528, 6.4804075544), new Vsop87.LnVsop(2.953E-8, 4.59498573141, 167.0893049529), new Vsop87.LnVsop(2.746E-8, 1.93558791594, 73.1852512744), new Vsop87.LnVsop(2.491E-8, 2.97226347553, 453.9461586808), new Vsop87.LnVsop(3.051E-8, 1.91972740209, 561.1835344836), new Vsop87.LnVsop(2.999E-8, 1.37948475539, 365.0011565867), new Vsop87.LnVsop(2.491E-8, 5.45961727666, 66.1835788582), new Vsop87.LnVsop(2.845E-8, 1.23683883276, 32.2433289144), new Vsop87.LnVsop(2.318E-8, 1.14709996164, 43.2408450685), new Vsop87.LnVsop(2.591E-8, 1.46851525197, 33.1371007917), new Vsop87.LnVsop(3.188E-8, 4.01290993082, 555.5544601911), new Vsop87.LnVsop(2.341E-8, 5.87022529526, 228.276948965), new Vsop87.LnVsop(2.507E-8, 3.85921708605, 104.0077979553), new Vsop87.LnVsop(2.825E-8, 1.55599717119, 353.301065017), new Vsop87.LnVsop(2.823E-8, 3.60128149001, 42.5864537627), new Vsop87.LnVsop(2.911E-8, 5.22123493517, 73.4090004436), new Vsop87.LnVsop(2.269E-8, 3.31411348054, 4.1446015842), new Vsop87.LnVsop(2.243E-8, 2.66541975581, 70.1157321213), new Vsop87.LnVsop(2.253E-8, 4.08061547423, 123.5396433437), new Vsop87.LnVsop(2.576E-8, 2.38332773848, 100.6450936638), new Vsop87.LnVsop(2.868E-8, 6.16611201949, 101.8689339412), new Vsop87.LnVsop(2.76E-8, 5.71757499554, 43.2890291783), new Vsop87.LnVsop(2.847E-8, 0.54976679257, 20.4950532349), new Vsop87.LnVsop(2.944E-8, 2.79704642392, 418.2608035978), new Vsop87.LnVsop(2.155E-8, 4.04509548705, 47.061123747), new Vsop87.LnVsop(2.825E-8, 1.90768435934, 273.1028404783), new Vsop87.LnVsop(2.529E-8, 4.12564642359, 332.8060117821), new Vsop87.LnVsop(2.797E-8, 2.32758928903, 404.6186649328), new Vsop87.LnVsop(2.04E-8, 2.01870191041, 316.3918696566), new Vsop87.LnVsop(2.525E-8, 3.11718333411, 905.8865797915), new Vsop87.LnVsop(2.021E-8, 5.48821446741, 47.6942631934), new Vsop87.LnVsop(2.17E-8, 4.4619656005, 2.7083129857), new Vsop87.LnVsop(2.399E-8, 3.7884951828, 75.5847477194), new Vsop87.LnVsop(2.746E-8, 4.82558024832, 6.8529145699), new Vsop87.LnVsop(2.471E-8, 3.46241291144, 8.5980197091), new Vsop87.LnVsop(1.98E-8, 3.45572736554, 472.1748419147), new Vsop87.LnVsop(1.968E-8, 5.79683846128, 11.1575748485), new Vsop87.LnVsop(1.976E-8, 5.43505814122, 199.2844497575), new Vsop87.LnVsop(2.285E-8, 2.79572464474, 22.633917249), new Vsop87.LnVsop(1.913E-8, 0.27742491783, 69.1525242748), new Vsop87.LnVsop(2.663E-8, 5.43112910549, 3265.8308281325), new Vsop87.LnVsop(2.604E-8, 0.4366204973, 439.782755154), new Vsop87.LnVsop(2.058E-8, 1.69376068077, 65.8747623175), new Vsop87.LnVsop(2.121E-8, 2.00288263601, 106.0135355254), new Vsop87.LnVsop(2.217E-8, 0.97212356159, 39.0962434843), new Vsop87.LnVsop(2.003E-8, 1.49825259375, 29.226199388), new Vsop87.LnVsop(2.225E-8, 4.36334040085, 468.2426886516), new Vsop87.LnVsop(2.057E-8, 0.06201487399, 205.2223405907), new Vsop87.LnVsop(2.086E-8, 0.44287700052, 10.2949407385), new Vsop87.LnVsop(1.924E-8, 0.83899941456, 254.9435932136), new Vsop87.LnVsop(1.77E-8, 4.3204880583, 0.457574387), new Vsop87.LnVsop(1.973E-8, 6.05836685033, 78.4049352897), new Vsop87.LnVsop(1.852E-8, 6.19975101768, 258.8757464767), new Vsop87.LnVsop(2.095E-8, 5.80179588658, 486.4019359163), new Vsop87.LnVsop(2.207E-8, 5.18886333203, 134.0640787458), new Vsop87.LnVsop(2.085E-8, 5.35829244404, 908.3342603463), new Vsop87.LnVsop(1.887E-8, 6.20764466965, 198.321241911), new Vsop87.LnVsop(2.147E-8, 1.40526642648, 526.722019678), new Vsop87.LnVsop(2.085E-8, 2.55047290838, 49.5088043018), new Vsop87.LnVsop(1.634E-8, 3.36868035546, 118.0224436358), new Vsop87.LnVsop(1.729E-8, 1.99202140996, 77.0692204277), new Vsop87.LnVsop(1.772E-8, 0.04590477856, 334.2904844904), new Vsop87.LnVsop(1.844E-8, 2.97451465787, 178.7893965226), new Vsop87.LnVsop(1.73E-8, 2.01735784062, 142.6620984549), new Vsop87.LnVsop(1.597E-8, 1.60733571281, 40.1600250673), new Vsop87.LnVsop(1.602E-8, 5.65898626013, 175.1660598002), new Vsop87.LnVsop(1.668E-8, 1.53361997245, 0.8300814025), new Vsop87.LnVsop(1.768E-8, 4.72713891115, 32.7164096664), new Vsop87.LnVsop(1.731E-8, 5.53331362694, 15.4991183888), new Vsop87.LnVsop(1.756E-8, 5.57550298818, 522.5774180938), new Vsop87.LnVsop(1.762E-8, 2.61456701609, 166.828672522), new Vsop87.LnVsop(1.558E-8, 3.43776574559, 124.5028511902), new Vsop87.LnVsop(1.785E-8, 2.31713014156, 290.2195580194), new Vsop87.LnVsop(1.878E-8, 1.08799780926, 274.0660483248), new Vsop87.LnVsop(1.53E-8, 3.28602877385, 820.0592809603), new Vsop87.LnVsop(1.54E-8, 6.11183693327, 165.6048322446), new Vsop87.LnVsop(1.503E-8, 1.88793984015, 303.8616966844), new Vsop87.LnVsop(1.637E-8, 0.10818716175, 72.7758609972), new Vsop87.LnVsop(1.497E-8, 2.01776960009, 150.0844619964), new Vsop87.LnVsop(1.575E-8, 5.25534001318, 233.9060232575), new Vsop87.LnVsop(1.469E-8, 0.61918308468, 1033.3583763983), new Vsop87.LnVsop(1.904E-8, 6.25182084377, 162.8965192589), new Vsop87.LnVsop(1.398E-8, 3.41567259878, 4.9959348461), new Vsop87.LnVsop(1.696E-8, 2.11496406243, 189.7232222019), new Vsop87.LnVsop(1.641E-8, 0.88245154254, 115.8835796217), new Vsop87.LnVsop(1.924E-8, 0.91450801831, 1819.6374661092), new Vsop87.LnVsop(1.707E-8, 2.55772668001, 1108.1399749656), new Vsop87.LnVsop(1.338E-8, 3.17269412566, 362.8622925726), new Vsop87.LnVsop(1.43E-8, 3.7335297053, 8.9068362498), new Vsop87.LnVsop(1.342E-8, 2.84242222704, 55.7710180407), new Vsop87.LnVsop(1.366E-8, 4.0010335875, 103.3534066495), new Vsop87.LnVsop(1.606E-8, 6.02754119794, 31.2319369581), new Vsop87.LnVsop(1.693E-8, 1.52609075769, 401.6497195162), new Vsop87.LnVsop(1.451E-8, 5.63277890051, 129.9194771616), new Vsop87.LnVsop(1.39E-8, 0.22627586528, 370.9390474199), new Vsop87.LnVsop(1.3E-8, 0.19222551672, 81.8951455681), new Vsop87.LnVsop(1.28E-8, 0.62174224381, 448.6895914038), new Vsop87.LnVsop(1.29E-8, 2.77107833656, 63.6240237188), new Vsop87.LnVsop(1.712E-8, 2.16788442139, 536.8045120954), new Vsop87.LnVsop(1.694E-8, 2.49962791661, 441.2672278623), new Vsop87.LnVsop(1.644E-8, 2.41311982961, 10.0824924174), new Vsop87.LnVsop(1.668E-8, 5.00711095329, 79.5169009825), new Vsop87.LnVsop(1.629E-8, 5.55917656506, 344.9636777388), new Vsop87.LnVsop(1.345E-8, 4.42619970902, 189.1807054807), new Vsop87.LnVsop(1.252E-8, 5.9230078039, 57.1436161644), new Vsop87.LnVsop(1.176E-8, 1.63172838154, 84.1827674285), new Vsop87.LnVsop(1.322E-8, 0.24854997323, 114.9416236346), new Vsop87.LnVsop(1.647E-8, 0.00195946885, 491.5579294568), new Vsop87.LnVsop(1.383E-8, 5.72955320309, 89.338760969), new Vsop87.LnVsop(1.421E-8, 4.2603541051, 369.4545747116), new Vsop87.LnVsop(1.287E-8, 0.99537181009, 14.6690369863), new Vsop87.LnVsop(1.412E-8, 5.18998440411, 113.8778420516), new Vsop87.LnVsop(1.113E-8, 5.5414551977, 403.0223176399), new Vsop87.LnVsop(1.484E-8, 1.03508883775, 1215.1649024473), new Vsop87.LnVsop(1.391E-8, 1.49396068486, 14.2270940016), new Vsop87.LnVsop(1.202E-8, 3.60264192173, 480.7728616238), new Vsop87.LnVsop(1.113E-8, 4.80418427391, 9.449352971), new Vsop87.LnVsop(1.428E-8, 1.57155860246, 419.7452763061), new Vsop87.LnVsop(1.311E-8, 2.99755331991, 458.8415197904), new Vsop87.LnVsop(1.438E-8, 6.10376597618, 64.6991061499), new Vsop87.LnVsop(1.074E-8, 3.16426816293, 54.3347294422), new Vsop87.LnVsop(1.387E-8, 2.78485990518, 26.0235537909), new Vsop87.LnVsop(1.203E-8, 0.20627563214, 0.5694489716), new Vsop87.LnVsop(1.347E-8, 5.57876007696, 95.2284676924), new Vsop87.LnVsop(1.388E-8, 1.66409814967, 240.3864308119), new Vsop87.LnVsop(1.269E-8, 2.37681963075, 37.8724032069), new Vsop87.LnVsop(1.011E-8, 2.76310774823, 80.4106728598), new Vsop87.LnVsop(1.003E-8, 2.79269932952, 218.9281697305), new Vsop87.LnVsop(1.004E-8, 1.15611283525, 384.0599212231), new Vsop87.LnVsop(1.009E-8, 2.43209796832, 154.979823106), new Vsop87.LnVsop(1.326E-8, 0.99157908827, 483.2205421786), new Vsop87.LnVsop(1.339E-8, 0.58791307654, 476.4313180835), new Vsop87.LnVsop(9.89E-9, 3.31666847329, 18.9100067901), new Vsop87.LnVsop(1.07E-8, 2.82291623041, 616.3214130779), new Vsop87.LnVsop(1.257E-8, 1.51721661185, 280.9671470045), new Vsop87.LnVsop(1.219E-8, 3.62982970433, 106.2741679563), new Vsop87.LnVsop(1.276E-8, 4.73464701935, 691.1030116452), new Vsop87.LnVsop(1.146E-8, 4.85249483698, 1044.4040766622), new Vsop87.LnVsop(1.124E-8, 2.46295455688, 326.8681209489), new Vsop87.LnVsop(9.8E-9, 6.04026702553, 5.4690155981), new Vsop87.LnVsop(1.23E-8, 0.61713965835, 237.6781178262), new Vsop87.LnVsop(9.22E-9, 0.36432013348, 10.9338256793), new Vsop87.LnVsop(1.227E-8, 5.83120102521, 63.847772888), new Vsop87.LnVsop(9.18E-9, 3.41111361461, 375.3924655448), new Vsop87.LnVsop(1.262E-8, 5.69321383311, 694.0719570618), new Vsop87.LnVsop(1.037E-8, 5.92126063748, 4.8259251404), new Vsop87.LnVsop(1.148E-8, 5.35062584493, 369.0820676961), new Vsop87.LnVsop(1.02E-8, 2.45414816467, 147.1155165798), new Vsop87.LnVsop(1.217E-8, 3.63858890321, 699.7010313543), new Vsop87.LnVsop(9.6E-9, 4.7838347384, 93.9040536785), new Vsop87.LnVsop(9.93E-9, 3.39918521663, 10.785067833), new Vsop87.LnVsop(8.79E-9, 3.42965236315, 3.0808200012), new Vsop87.LnVsop(1.109E-8, 4.80576232812, 6133.5126528568), new Vsop87.LnVsop(1.004E-8, 3.13174510948, 215.4379594521), new Vsop87.LnVsop(8.68E-9, 2.87444546307, 15.1903018481), new Vsop87.LnVsop(1.167E-8, 6.01716139063, 377.1588225434), new Vsop87.LnVsop(9.67E-9, 2.51117953936, 121.8427223143), new Vsop87.LnVsop(8.57E-9, 5.69539341636, 141.6988906084), new Vsop87.LnVsop(1.18E-8, 2.37522177893, 33.9402499438), new Vsop87.LnVsop(9.61E-9, 0.22181374419, 0.9150237367), new Vsop87.LnVsop(9.01E-9, 4.21763792004, 488.8496164711), new Vsop87.LnVsop(9.99E-9, 2.76968761861, 148.5999892881), new Vsop87.LnVsop(1.007E-8, 3.44301576832, 36.9091953604), new Vsop87.LnVsop(8.38E-9, 1.63355479706, 2.3358059702), new Vsop87.LnVsop(1.055E-8, 5.32670142035, 308.3151148093), new Vsop87.LnVsop(1.043E-8, 1.72678741786, 438.2982824457), new Vsop87.LnVsop(8.09E-9, 0.7748882728, 2043.9822618111), new Vsop87.LnVsop(9.66E-9, 5.97805325335, 606.7601855223), new Vsop87.LnVsop(8.26E-9, 2.97722608735, 62.7726904569), new Vsop87.LnVsop(9.89E-9, 4.44879184782, 406.1031376411), new Vsop87.LnVsop(8.42E-9, 4.09747897628, 140.6563608848), new Vsop87.LnVsop(1.02E-8, 5.1325075604, 157.2674449664), new Vsop87.LnVsop(7.97E-9, 3.10995123049, 93.7921790939), new Vsop87.LnVsop(1.075E-8, 2.4825931792, 405.9912630565), new Vsop87.LnVsop(9.44E-9, 1.16305712399, 82.2039621088), new Vsop87.LnVsop(9.17E-9, 4.89097024007, 12.0089081104), new Vsop87.LnVsop(8.83E-9, 2.3622438514, 3.7720945687), new Vsop87.LnVsop(1.02E-8, 3.90895442648, 194.2885149114), new Vsop87.LnVsop(7.72E-9, 3.14155617772, 248.4631856592), new Vsop87.LnVsop(1.067E-8, 4.11262597752, 141.4864422873), new Vsop87.LnVsop(9.82E-9, 1.66627917034, 40.5807161926), new Vsop87.LnVsop(8.18E-9, 5.48402326753, 252.6559713532), new Vsop87.LnVsop(8.43E-9, 0.97496001006, 73.88782669), new Vsop87.LnVsop(8.46E-9, 3.36344025893, 40.8413486235), new Vsop87.LnVsop(1.017E-8, 2.6513815772, 477.9157907918), new Vsop87.LnVsop(7.27E-9, 2.75669289381, 703.6331846174), new Vsop87.LnVsop(7.72E-9, 4.96057719406, 661.0949149645), new Vsop87.LnVsop(1.013E-8, 4.06561496066, 76.154196691), new Vsop87.LnVsop(7.7E-9, 0.58191520313, 97.6761482472), new Vsop87.LnVsop(7.82E-9, 4.43864011717, 295.1942410061), new Vsop87.LnVsop(9.33E-9, 1.26735157121, 624.919432787), new Vsop87.LnVsop(7.42E-9, 2.20772577601, 1171.875873269), new Vsop87.LnVsop(7.85E-9, 0.09340179162, 440.6822725257), new Vsop87.LnVsop(7.9E-9, 0.78895659697, 11.848849416), new Vsop87.LnVsop(8.01E-9, 5.48034970397, 21.9795259432), new Vsop87.LnVsop(7.17E-9, 4.97342005598, 425.1137181677), new Vsop87.LnVsop(9.48E-9, 3.14533047586, 833.552661779), new Vsop87.LnVsop(9.63E-9, 4.82532331563, 1744.8558675419), new Vsop87.LnVsop(8.11E-9, 6.141747735, 184.9879197867), new Vsop87.LnVsop(6.83E-9, 3.1999081101, 31.6526280834), new Vsop87.LnVsop(8.87E-9, 4.21473602061, 778.4147831847), new Vsop87.LnVsop(6.83E-9, 2.71571995972, 685.4739373527), new Vsop87.LnVsop(8.78E-9, 4.6954102493, 81.682697247), new Vsop87.LnVsop(8.97E-9, 3.94746491465, 75.6753704446), new Vsop87.LnVsop(7.44E-9, 4.00270623421, 902.7051860538), new Vsop87.LnVsop(8.25E-9, 4.24768237924, 1246.6574718363), new Vsop87.LnVsop(6.73E-9, 2.56327330773, 109.3125493421), new Vsop87.LnVsop(6.7E-9, 5.39020598872, 610.6923387854), new Vsop87.LnVsop(8.35E-9, 3.65058253628, 14.8177948326), new Vsop87.LnVsop(7.03E-9, 3.32025655236, 25.0603459444), new Vsop87.LnVsop(6.53E-9, 5.83345039162, 86.6304479833), new Vsop87.LnVsop(6.57E-9, 1.73039905547, 216.4804891757), new Vsop87.LnVsop(7.37E-9, 2.66162027091, 363.5166838784), new Vsop87.LnVsop(6.52E-9, 3.21433113908, 207.8824694666), new Vsop87.LnVsop(6.32E-9, 5.311631538, 180.1619946463), new Vsop87.LnVsop(7.51E-9, 1.05682418871, 916.9322800554), new Vsop87.LnVsop(8.58E-9, 0.07715076892, 156.1554792736), new Vsop87.LnVsop(6.33E-9, 4.98330418733, 958.576777831), new Vsop87.LnVsop(6.51E-9, 6.22872888278, 69.6737891366), new Vsop87.LnVsop(6.17E-9, 1.322047737, 193.655375465), new Vsop87.LnVsop(7.89E-9, 5.67161089073, 280.003939158), new Vsop87.LnVsop(8.15E-9, 3.68454632935, 411.620337349), new Vsop87.LnVsop(6.68E-9, 1.92099734116, 37.611770776), new Vsop87.LnVsop(6.43E-9, 0.26372916234, 217.2312487011), new Vsop87.LnVsop(6.48E-9, 5.91545920656, 302.0953396858), new Vsop87.LnVsop(7.86E-9, 1.22164212539, 490.0734567485), new Vsop87.LnVsop(7.3E-9, 0.75877218619, 44.0921783304), new Vsop87.LnVsop(6.62E-9, 2.70374442339, 469.1364605289), new Vsop87.LnVsop(6.16E-9, 5.68826448465, 25.2727942655), new Vsop87.LnVsop(7.08E-9, 0.65048856186, 14.5571624017), new Vsop87.LnVsop(6.8E-9, 0.50483861507, 1057.8974574809), new Vsop87.LnVsop(7.41E-9, 4.39625712898, 184.0941479094), new Vsop87.LnVsop(6.16E-9, 4.62035066985, 12.2695405413), new Vsop87.LnVsop(5.78E-9, 1.51577770689, 668.2084619653), new Vsop87.LnVsop(5.74E-9, 3.07628710998, 285.1117485887), new Vsop87.LnVsop(6.58E-9, 3.16493349809, 268.4369740323), new Vsop87.LnVsop(5.99E-9, 2.08313007917, 149.3025647037), new Vsop87.LnVsop(7.78E-9, 4.44580465697, 171.6545976624), new Vsop87.LnVsop(7.02E-9, 2.56984201593, 621.7380390493), new Vsop87.LnVsop(5.93E-9, 1.51837555428, 397.3932433474), new Vsop87.LnVsop(6.51E-9, 2.27936792883, 49.1787359017), new Vsop87.LnVsop(5.58E-9, 0.37741292307, 107.4980082337), new Vsop87.LnVsop(5.59E-9, 0.82035344351, 541.5398145106), new Vsop87.LnVsop(5.79E-9, 2.6638461857, 823.9914342234), new Vsop87.LnVsop(7.38E-9, 3.04661280921, 131.9252147317), new Vsop87.LnVsop(6.61E-9, 3.46706982545, 105.380396079), new Vsop87.LnVsop(5.5E-9, 3.5604397096, 497.4476361802), new Vsop87.LnVsop(5.52E-9, 2.93525507111, 34.2008823747), new Vsop87.LnVsop(5.7E-9, 5.61286873129, 118.8737768977), new Vsop87.LnVsop(6.11E-9, 3.52382599505, 149.4031384402), new Vsop87.LnVsop(5.38E-9, 0.46786259161, 133.1008708993), new Vsop87.LnVsop(5.81E-9, 3.06975609659, 137.5542890242), new Vsop87.LnVsop(6.99E-9, 2.57905086244, 602.9880909536), new Vsop87.LnVsop(5.29E-9, 5.41517154207, 450.9772132642), new Vsop87.LnVsop(5.72E-9, 0.49705877254, 331.2096644892), new Vsop87.LnVsop(5.67E-9, 4.82584789901, 842.1506814881), new Vsop87.LnVsop(6.0E-9, 5.83868295988, 181.0557665236), new Vsop87.LnVsop(5.45E-9, 2.85574498347, 61.448276443), new Vsop87.LnVsop(5.91E-9, 5.51829236048, 140.9651774255), new Vsop87.LnVsop(6.24E-9, 0.70843752821, 836.5216071956), new Vsop87.LnVsop(6.38E-9, 3.99812366414, 136.0698163159), new Vsop87.LnVsop(6.23E-9, 5.8434133579, 52.8020726241), new Vsop87.LnVsop(5.76E-9, 0.33426283342, 139.4807047172), new Vsop87.LnVsop(5.88E-9, 0.05694902672, 95.931043108), new Vsop87.LnVsop(5.16E-9, 2.19916574088, 458.090760265), new Vsop87.LnVsop(6.4E-9, 6.23103740957, 10063.7223490764), new Vsop87.LnVsop(5.83E-9, 2.01801609392, 449.2802922348), new Vsop87.LnVsop(5.41E-9, 3.38817907552, 252.0865223816), new Vsop87.LnVsop(6.74E-9, 1.68032765593, 149.0419322728), new Vsop87.LnVsop(5.37E-9, 2.96196069752, 73.1370671646), new Vsop87.LnVsop(5.08E-9, 2.53212989919, 41.7563723602), new Vsop87.LnVsop(5.24E-9, 6.13250235908, 1589.0728952838), new Vsop87.LnVsop(6.3E-9, 0.72006810767, 513.079881013), new Vsop87.LnVsop(5.36E-9, 5.79291762554, 282.6640680339), new Vsop87.LnVsop(5.82E-9, 0.4966183054, 283.6272758804), new Vsop87.LnVsop(5.89E-9, 6.240547917, 29.7956483596), new Vsop87.LnVsop(4.65E-9, 0.25511403173, 57.255490749), new Vsop87.LnVsop(5.81E-9, 4.76285550074, 479.4002635001), new Vsop87.LnVsop(5.34E-9, 2.40031010789, 393.4610900843), new Vsop87.LnVsop(4.99E-9, 1.70080029975, 262.4778313397), new Vsop87.LnVsop(5.74E-9, 2.86244729074, 170.7608257851), new Vsop87.LnVsop(5.64E-9, 1.20364214586, 832.5894539325), new Vsop87.LnVsop(5.56E-9, 4.40198802843, 196.6243208816), new Vsop87.LnVsop(5.66E-9, 0.3431142639, 343.4792050305), new Vsop87.LnVsop(5.3E-9, 3.45607265169, 450.4559484024), new Vsop87.LnVsop(4.43E-9, 3.98624215251, 135.336103133), new Vsop87.LnVsop(5.58E-9, 6.0657095517, 76.3779458602), new Vsop87.LnVsop(5.65E-9, 4.90824100099, 463.5073862364), new Vsop87.LnVsop(5.19E-9, 3.93421845882, 460.5384408198), new Vsop87.LnVsop(4.62E-9, 4.1901057001, 271.4059194489), new Vsop87.LnVsop(4.74E-9, 4.61013000511, 291.262087743), new Vsop87.LnVsop(5.15E-9, 2.2385727469, 228.7982138268), new Vsop87.LnVsop(4.36E-9, 6.22400798387, 149.6113812444), new Vsop87.LnVsop(4.99E-9, 3.72703652941, 853.196381752), new Vsop87.LnVsop(4.36E-9, 5.07972033661, 79.4474650133), new Vsop87.LnVsop(4.26E-9, 2.17011428925, 119.3950417595), new Vsop87.LnVsop(5.4E-9, 1.04610917716, 446.3113468182), new Vsop87.LnVsop(4.23E-9, 1.23352648155, 357.4456666012), new Vsop87.LnVsop(4.84E-9, 2.83311091436, 400.1652468079), new Vsop87.LnVsop(5.47E-9, 0.55236729498, 241.8709035202), new Vsop87.LnVsop(4.36E-9, 3.63014811867, 149.5150130248), new Vsop87.LnVsop(4.35E-9, 1.21235386124, 911.3032057629), new Vsop87.LnVsop(5.06E-9, 1.59810782706, 54.2865453324), new Vsop87.LnVsop(4.68E-9, 0.00162187872, 232.4215505492), new Vsop87.LnVsop(4.5E-9, 6.04091895999, 1894.4190646765), new Vsop87.LnVsop(4.26E-9, 4.89607718517, 116.5379709275), new Vsop87.LnVsop(4.05E-9, 6.24550564728, 149.723255829), new Vsop87.LnVsop(5.52E-9, 0.23040562733, 829.6205085159), new Vsop87.LnVsop(5.17E-9, 2.70015186737, 412.5835451955), new Vsop87.LnVsop(4.06E-9, 2.04699110555, 232.0490435337), new Vsop87.LnVsop(4.09E-9, 4.02096236368, 735.8765135318), new Vsop87.LnVsop(4.64E-9, 3.82915340503, 1094.5460204104), new Vsop87.LnVsop(5.54E-9, 3.92724998283, 416.7763308895), new Vsop87.LnVsop(4.78E-9, 0.23337342897, 1182.9215735329), new Vsop87.LnVsop(4.55E-9, 4.41056074117, 754.8389099486), new Vsop87.LnVsop(4.25E-9, 0.19362570317, 310.1720945331), new Vsop87.LnVsop(4.05E-9, 0.08637530483, 18.9623964168), new Vsop87.LnVsop(5.05E-9, 4.18178166641, 449.4927405559), new Vsop87.LnVsop(3.91E-9, 0.09596077147, 1097.0942747017), new Vsop87.LnVsop(4.86E-9, 4.60822193064, 442.7517005706), new Vsop87.LnVsop(4.47E-9, 0.56825354381, 758.7710632117), new Vsop87.LnVsop(4.06E-9, 3.80066885794, 34.5309507748), new Vsop87.LnVsop(5.43E-9, 2.80897788326, 514.5643537213), new Vsop87.LnVsop(3.94E-9, 0.82400691137, 337.8019466282), new Vsop87.LnVsop(4.98E-9, 1.11991750513, 154.2984995498), new Vsop87.LnVsop(5.26E-9, 5.3572965596, 838.218528225), new Vsop87.LnVsop(3.96E-9, 6.00531185948, 246.9787129509), new Vsop87.LnVsop(4.36E-9, 3.6189681325, 229.0800981171), new Vsop87.LnVsop(4.19E-9, 0.9054672932, 451.7279727896), new Vsop87.LnVsop(3.94E-9, 4.86493280924, 1404.0849754971), new Vsop87.LnVsop(5.05E-9, 4.80928477681, 155.5010879678), new Vsop87.LnVsop(4.37E-9, 1.36909044697, 745.277682393), new Vsop87.LnVsop(4.72E-9, 3.61944685312, 679.2541622292), new Vsop87.LnVsop(4.65E-9, 5.53770634513, 494.2662424425), new Vsop87.LnVsop(4.15E-9, 3.01980670649, 348.8476468921), new Vsop87.LnVsop(4.22E-9, 3.51871257208, 706.8145783551), new Vsop87.LnVsop(3.54E-9, 4.06294331463, 124.2904028691), new Vsop87.LnVsop(3.5E-9, 0.69344344427, 742.9900605326), new Vsop87.LnVsop(4.0E-9, 0.28819545975, 407.5876103494), new Vsop87.LnVsop(4.36E-9, 3.13753022197, 168.5737776612), new Vsop87.LnVsop(4.61E-9, 4.10342065247, 27.7204748203), new Vsop87.LnVsop(3.53E-9, 2.94674365806, 806.725958836), new Vsop87.LnVsop(3.64E-9, 3.0751873248, 442.639825986), new Vsop87.LnVsop(4.82E-9, 1.48698198058, 149.8238295655), new Vsop87.LnVsop(3.97E-9, 2.65695336615, 464.4705940829), new Vsop87.LnVsop(3.48E-9, 5.78081905496, 1265.5674786264), new Vsop87.LnVsop(4.22E-9, 1.93225903819, 474.9468453752), new Vsop87.LnVsop(3.52E-9, 4.0475161448, 180.7951340927), new Vsop87.LnVsop(4.58E-9, 4.95302010209, 619.2903584945), new Vsop87.LnVsop(3.58E-9, 0.16212320594, 1190.7858800591), new Vsop87.LnVsop(3.56E-9, 3.19289330603, 21.1976286505), new Vsop87.LnVsop(4.06E-9, 3.72223708907, 3116.2676309979), new Vsop87.LnVsop(3.41E-9, 3.05116722794, 15.7810026791), new Vsop87.LnVsop(3.52E-9, 2.38001884804, 511.5954083047), new Vsop87.LnVsop(3.76E-9, 3.67717394221, 328.2407190726), new Vsop87.LnVsop(3.7E-9, 0.17259001853, 6531.661656265), new Vsop87.LnVsop(3.78E-9, 4.72535454314, 30.5987975117), new Vsop87.LnVsop(4.56E-9, 0.83406682485, 674.8007441043), new Vsop87.LnVsop(3.76E-9, 5.91068811321, 1617.3840709351), new Vsop87.LnVsop(3.92E-9, 1.90856045571, 25863.55834587229), new Vsop87.LnVsop(3.32E-9, 0.85733579829, 749.2098356561), new Vsop87.LnVsop(3.21E-9, 2.59404134515, 1300.9922012785), new Vsop87.LnVsop(4.44E-9, 0.92962461992, 98.3574718034), new Vsop87.LnVsop(3.38E-9, 4.15717957485, 21.1494445407), new Vsop87.LnVsop(3.17E-9, 3.90481203904, 38.6061163898), new Vsop87.LnVsop(3.46E-9, 1.30799145303, 321.7603115182), new Vsop87.LnVsop(3.87E-9, 3.06870543578, 1012.9115072732), new Vsop87.LnVsop(3.24E-9, 6.11165016338, 696.5196376166), new Vsop87.LnVsop(3.35E-9, 1.33853903231, 172.4577468145), new Vsop87.LnVsop(3.14E-9, 4.56810921721, 1681.1199692385), new Vsop87.LnVsop(3.1E-9, 5.02963877803, 1811.773159583), new Vsop87.LnVsop(3.82E-9, 5.26829613655, 67.0773507355), new Vsop87.LnVsop(3.94E-9, 4.26717713334, 304.2342036999), new Vsop87.LnVsop(4.06E-9, 3.58469900333, 26013.1215430069), new Vsop87.LnVsop(3.09E-9, 2.68348239684, 248.7238180901), new Vsop87.LnVsop(3.72E-9, 1.99921282497, 192.8040422031), new Vsop87.LnVsop(3.7E-9, 4.11260458857, 239.1625905345), new Vsop87.LnVsop(2.99E-9, 3.9646896095, 20277.0078952874), new Vsop87.LnVsop(3.05E-9, 6.24476771738, 501.3797894433), new Vsop87.LnVsop(2.98E-9, 2.7391535245, 143.9341228421), new Vsop87.LnVsop(3.62E-9, 5.98792551264, 920.8644333185), new Vsop87.LnVsop(2.98E-9, 3.52867456736, 21.4582610814), new Vsop87.LnVsop(3.75E-9, 5.43269388058, 625.9945152181), new Vsop87.LnVsop(3.31E-9, 2.33574542436, 229.4526051326), new Vsop87.LnVsop(3.7E-9, 3.51055181581, 91.4563731237), new Vsop87.LnVsop(3.08E-9, 5.60489714954, 445.3481389717), new Vsop87.LnVsop(3.17E-9, 4.34771147014, 217.4436970222), new Vsop87.LnVsop(2.94E-9, 6.15987510624, 19.9737883731), new Vsop87.LnVsop(4.14E-9, 4.81163687199, 589.4947101349), new Vsop87.LnVsop(3.02E-9, 5.2607933805, 27.5604161259), new Vsop87.LnVsop(3.72E-9, 2.20287549079, 44.070926471), new Vsop87.LnVsop(3.9E-9, 1.77880995993, 419.4846438752), new Vsop87.LnVsop(3.71E-9, 0.30454914535, 6283.0758499914), new Vsop87.LnVsop(2.92E-9, 0.17009533973, 455.6601260527), new Vsop87.LnVsop(3.7E-9, 2.48289171331, 376.1956146969), new Vsop87.LnVsop(3.15E-9, 2.97527331738, 236.8749686741), new Vsop87.LnVsop(3.19E-9, 4.13089051068, 81.2620061217), new Vsop87.LnVsop(2.9E-9, 2.63347600042, 454.1586070019), new Vsop87.LnVsop(3.0E-9, 1.28922027378, 799.6124118352), new Vsop87.LnVsop(3.5E-9, 4.25460254325, 227.5261894396), new Vsop87.LnVsop(2.89E-9, 6.1262719817, 132.8884225782), new Vsop87.LnVsop(3.6E-9, 3.48063709609, 44.6134431922), new Vsop87.LnVsop(3.93E-9, 5.1250897637, 3192.5337022735), new Vsop87.LnVsop(3.65E-9, 0.55471648096, 285.6330134505), new Vsop87.LnVsop(3.11E-9, 3.5680168599, 288.7350853111), new Vsop87.LnVsop(3.33E-9, 4.95319798125, 881.5075574033), new Vsop87.LnVsop(3.85E-9, 4.98242164368, 572.2292347475), new Vsop87.LnVsop(3.39E-9, 5.65360136491, 195.7729876197), new Vsop87.LnVsop(3.63E-9, 0.98999016221, 839.7030009333), new Vsop87.LnVsop(3.86E-9, 3.32408807296, 25939.82441714789), new Vsop87.LnVsop(2.89E-9, 3.00353602984, 204.7010757289), new Vsop87.LnVsop(3.74E-9, 0.90849814157, 549.7284439425), new Vsop87.LnVsop(3.21E-9, 1.6541217086, 90.2807169561), new Vsop87.LnVsop(3.83E-9, 3.00200467817, 551.2129166508), new Vsop87.LnVsop(2.79E-9, 4.06882632435, 904.1896587621), new Vsop87.LnVsop(3.66E-9, 6.15032242763, 491.8185618877), new Vsop87.LnVsop(3.41E-9, 3.73123892015, 452.4616859725), new Vsop87.LnVsop(3.6E-9, 3.29825671883, 104.5290628171), new Vsop87.LnVsop(3.19E-9, 5.57991791116, 459.3627846522), new Vsop87.LnVsop(3.86E-9, 4.71096019501, 901.9544265284), new Vsop87.LnVsop(2.96E-9, 2.33233720412, 89.5993933999), new Vsop87.LnVsop(3.48E-9, 0.93025072898, 29.7474642498), new Vsop87.LnVsop(3.08E-9, 1.48912863494, 1530.8060125785), new Vsop87.LnVsop(2.72E-9, 2.84186859971, 2045.4667345194), new Vsop87.LnVsop(3.27E-9, 2.25624475244, 272.5815756165), new Vsop87.LnVsop(3.33E-9, 3.58076165959, 428.0826635843), new Vsop87.LnVsop(3.49E-9, 2.34615857088, 6069.7767545534), new Vsop87.LnVsop(2.78E-9, 5.33956009504, 335.7749571987), new Vsop87.LnVsop(2.7E-9, 5.72961044984, 450.1740641121), new Vsop87.LnVsop(2.82E-9, 2.51807549695, 156.043604689), new Vsop87.LnVsop(3.34E-9, 3.79230663769, 697.8071683688), new Vsop87.LnVsop(2.7E-9, 0.49362216969, 320.3240229197), new Vsop87.LnVsop(3.21E-9, 0.71639963302, 320.2758388099), new Vsop87.LnVsop(2.96E-9, 2.51339170311, 266.1011680621), new Vsop87.LnVsop(2.7E-9, 4.99754135777, 309.2783226558), new Vsop87.LnVsop(2.65E-9, 3.33672155263, 639.897286314), new Vsop87.LnVsop(3.24E-9, 5.54296698387, 1507.1777497157), new Vsop87.LnVsop(2.82E-9, 0.62853626574, 263.962304048), new Vsop87.LnVsop(3.66E-9, 5.89950070572, 268.9582388941), new Vsop87.LnVsop(2.85E-9, 4.23006264357, 177.3049238143), new Vsop87.LnVsop(3.47E-9, 4.708520824, 282.1428031721), new Vsop87.LnVsop(3.32E-9, 0.7653592353, 50.66320861), new Vsop87.LnVsop(2.84E-9, 2.87061321749, 883.7951792637), new Vsop87.LnVsop(3.33E-9, 6.24087751277, 563.6312150384), new Vsop87.LnVsop(3.63E-9, 3.29320353192, 378.9039276826), new Vsop87.LnVsop(3.36E-9, 3.79029047358, 9999.986450773), new Vsop87.LnVsop(2.59E-9, 4.37287015895, 1310.3933701397), new Vsop87.LnVsop(2.55E-9, 4.84760640021, 229.7614216733), new Vsop87.LnVsop(2.86E-9, 3.72531001807, 230.9370778409), new Vsop87.LnVsop(3.32E-9, 2.36777399155, 2274.5468326365), new Vsop87.LnVsop(3.25E-9, 5.91384585098, 9990.4252232174), new Vsop87.LnVsop(2.6E-9, 5.92834225229, 455.0694252217), new Vsop87.LnVsop(2.74E-9, 0.53976988872, 380.2396425446), new Vsop87.LnVsop(3.19E-9, 4.92433309582, 1140.38330388), new Vsop87.LnVsop(2.59E-9, 3.15728798274, 454.7493078329), new Vsop87.LnVsop(2.93E-9, 3.80820074659, 194.1766403268), new Vsop87.LnVsop(2.64E-9, 0.34153729395, 1193.9672737968), new Vsop87.LnVsop(2.96E-9, 2.31655276454, 422.7142217227), new Vsop87.LnVsop(3.03E-9, 0.17738702664, 384.5811860849), new Vsop87.LnVsop(2.85E-9, 1.29732672572, 25.1297819136), new Vsop87.LnVsop(2.51E-9, 1.67282111226, 447.2051186955), new Vsop87.LnVsop(2.51E-9, 3.03412113376, 117.3198682202), new Vsop87.LnVsop(3.26E-9, 1.68159391466, 161.7208630913), new Vsop87.LnVsop(2.48E-9, 5.85392046839, 229.340730548), new Vsop87.LnVsop(2.58E-9, 5.02749399426, 406.954470903), new Vsop87.LnVsop(2.64E-9, 6.15508431133, 1385.174968707), new Vsop87.LnVsop(2.76E-9, 1.5783145232, 336.8387387817), new Vsop87.LnVsop(2.64E-9, 2.90833578247, 75.1541055828), new Vsop87.LnVsop(2.84E-9, 5.70644286377, 92.4195809702), new Vsop87.LnVsop(2.73E-9, 3.78780023228, 380.0158933754), new Vsop87.LnVsop(2.52E-9, 2.00771359511, 85.9391734158), new Vsop87.LnVsop(2.55E-9, 5.06133623645, 102.523325247), new Vsop87.LnVsop(2.57E-9, 1.34131613295, 304.1223291153), new Vsop87.LnVsop(2.44E-9, 2.73811369909, 445.7206459872), new Vsop87.LnVsop(2.65E-9, 3.0254012179, 454.7974919427), new Vsop87.LnVsop(2.74E-9, 1.36882612211, 188.6594406189), new Vsop87.LnVsop(2.39E-9, 5.33018322578, 293.7097682978), new Vsop87.LnVsop(2.35E-9, 5.60412059654, 437.6438911399), new Vsop87.LnVsop(2.76E-9, 5.62363398057, 187.1749679106), new Vsop87.LnVsop(2.78E-9, 3.81695614226, 31.5407534988), new Vsop87.LnVsop(2.92E-9, 4.64128185538, 151.850818995), new Vsop87.LnVsop(3.14E-9, 3.86400459047, 734.4557312983), new Vsop87.LnVsop(2.34E-9, 1.80885124531, 1503.2455964526), new Vsop87.LnVsop(3.22E-9, 2.35445171313, 122.4758617607), new Vsop87.LnVsop(2.58E-9, 6.05880184188, 455.0212411119), new Vsop87.LnVsop(2.38E-9, 2.56020773425, 170.0100662597), new Vsop87.LnVsop(2.32E-9, 4.77316690974, 73.3453099688), new Vsop87.LnVsop(2.32E-9, 5.10057210704, 263.0203480609), new Vsop87.LnVsop(2.4E-9, 2.9977784079, 1147.4968508808), new Vsop87.LnVsop(2.81E-9, 4.15776226983, 279.4826742962), new Vsop87.LnVsop(2.57E-9, 3.04913300739, 436.8138097374), new Vsop87.LnVsop(2.35E-9, 3.02410451628, 361.3778198643), new Vsop87.LnVsop(2.55E-9, 0.88643610795, 418.5214360287), new Vsop87.LnVsop(2.64E-9, 1.89462495453, 74.4090915518), new Vsop87.LnVsop(2.68E-9, 0.38577446389, 444.2361732789), new Vsop87.LnVsop(2.22E-9, 4.53746462038, 230.8252032563), new Vsop87.LnVsop(2.41E-9, 2.49671371454, 548.2439712342), new Vsop87.LnVsop(2.39E-9, 4.41496531562, 213.9534867438), new Vsop87.LnVsop(2.37E-9, 3.26466054351, 535.9107402181), new Vsop87.LnVsop(2.2E-9, 0.41236373275, 448.3170843883), new Vsop87.LnVsop(2.26E-9, 3.93834877953, 754.0357607965), new Vsop87.LnVsop(2.37E-9, 2.40162775612, 827.9235874865), new Vsop87.LnVsop(2.4E-9, 1.77900522919, 380.3884003909), new Vsop87.LnVsop(2.24E-9, 0.05082919493, 76.2178871658), new Vsop87.LnVsop(2.58E-9, 4.48552116447, 551.1010420662), new Vsop87.LnVsop(2.78E-9, 4.63839965274, 341.9947323222), new Vsop87.LnVsop(3.0E-9, 1.76109411385, 371.5297482509), new Vsop87.LnVsop(2.87E-9, 3.90151164865, 531.978586955), new Vsop87.LnVsop(2.74E-9, 1.99452951365, 968.1380053866), new Vsop87.LnVsop(2.62E-9, 6.12295568294, 311.2840602259), new Vsop87.LnVsop(2.64E-9, 5.76806626227, 635.9651330509), new Vsop87.LnVsop(2.14E-9, 1.90097549431, 208.8456773131), new Vsop87.LnVsop(2.21E-9, 5.7356410833, 1136.4511506169), new Vsop87.LnVsop(2.79E-9, 2.40796258509, 1670.0742689746), new Vsop87.LnVsop(2.47E-9, 4.10467533143, 962.5089310941), new Vsop87.LnVsop(2.51E-9, 0.65896974227, 423.6292454594), new Vsop87.LnVsop(2.73E-9, 4.48420386716, 6060.2155269978), new Vsop87.LnVsop(2.84E-9, 1.98517323011, 402.2191684878), new Vsop87.LnVsop(2.13E-9, 0.40391978805, 197.7999770492), new Vsop87.LnVsop(2.71E-9, 3.29944247062, 749.5823426716), new Vsop87.LnVsop(2.14E-9, 1.77108713711, 358.4088744477), new Vsop87.LnVsop(2.12E-9, 1.30757526648, 74.1484591209), new Vsop87.LnVsop(2.85E-9, 3.45237643998, 299.7170951002), new Vsop87.LnVsop(2.15E-9, 0.11685291153, 893.3564068193), new Vsop87.LnVsop(2.26E-9, 4.36569336172, 450.7165808333), new Vsop87.LnVsop(2.85E-9, 0.89336265206, 81.6345131372), new Vsop87.LnVsop(2.76E-9, 2.67678282261, 310.9752436852), new Vsop87.LnVsop(2.37E-9, 4.64910992307, 385.7568422525), new Vsop87.LnVsop(2.33E-9, 5.3964471152, 245.5424243524), new Vsop87.LnVsop(2.66E-9, 0.21523688619, 148.8124376092), new Vsop87.LnVsop(2.22E-9, 1.64662422921, 76.42612997), new Vsop87.LnVsop(2.71E-9, 2.94530770298, 763.4369296577), new Vsop87.LnVsop(2.09E-9, 5.56347456206, 78.9262001515), new Vsop87.LnVsop(2.5E-9, 1.28952902548, 421.1815649046), new Vsop87.LnVsop(2.54E-9, 2.61839399513, 525.2375469697), new Vsop87.LnVsop(2.21E-9, 2.85700154975, 104.5772469269), new Vsop87.LnVsop(2.35E-9, 0.29404113312, 6057.2465815812), new Vsop87.LnVsop(2.13E-9, 1.81939118803, 104.8378793578), new Vsop87.LnVsop(2.19E-9, 4.81031857297, 377.6800874052), new Vsop87.LnVsop(2.39E-9, 4.14502038477, 260.360219185), new Vsop87.LnVsop(2.59E-9, 6.22064928944, 305.6068018236), new Vsop87.LnVsop(2.41E-9, 4.25260400494, 1478.8665740644), new Vsop87.LnVsop(2.6E-9, 6.06592450487, 586.3133163972), new Vsop87.LnVsop(2.15E-9, 2.19677481542, 1321.4390704036), new Vsop87.LnVsop(2.4E-9, 6.18410669894, 689.6185389369), new Vsop87.LnVsop(2.04E-9, 0.09387343234, 945.2434557067), new Vsop87.LnVsop(2.19E-9, 0.49807555465, 507.5995645668), new Vsop87.LnVsop(2.03E-9, 1.80599017081, 1072.7152523135), new Vsop87.LnVsop(2.12E-9, 5.16316390795, 256.4280659219), new Vsop87.LnVsop(2.62E-9, 2.82472906853, 971.1069508032), new Vsop87.LnVsop(2.8E-9, 3.80946061981, 67.9286839974), new Vsop87.LnVsop(2.12E-9, 3.61675003861, 75.4147380137), new Vsop87.LnVsop(2.05E-9, 0.30735417946, 461.1291416508), new Vsop87.LnVsop(2.22E-9, 3.52840777605, 511.5317178299), new Vsop87.LnVsop(1.98E-9, 4.47397050345, 289.5651667136), new Vsop87.LnVsop(2.71E-9, 3.44737698948, 564.8550553158), new Vsop87.LnVsop(2.34E-9, 0.17593976046, 251.1714986449), new Vsop87.LnVsop(1.99E-9, 4.86362206373, 76.7873361374), new Vsop87.LnVsop(2.11E-9, 1.0554409044, 257.3912737684), new Vsop87.LnVsop(2.14E-9, 3.97499500159, 370.5665404044), new Vsop87.LnVsop(2.11E-9, 4.12360308875, 695.5564297701), new Vsop87.LnVsop(1.96E-9, 3.96250134928, 412.3710968744), new Vsop87.LnVsop(2.29E-9, 5.00491031721, 103.9865460959), new Vsop87.LnVsop(2.42E-9, 5.74082244878, 340.5102596139), new Vsop87.LnVsop(2.3E-9, 2.56838559117, 147.5574595645), new Vsop87.LnVsop(2.08E-9, 3.79662225345, 325.3836482406), new Vsop87.LnVsop(2.58E-9, 0.01795959348, 2199.7652340692), new Vsop87.LnVsop(2.13E-9, 5.89130495905, 170.1701249541), new Vsop87.LnVsop(2.67E-9, 0.78536095157, 976.7360250957), new Vsop87.LnVsop(2.18E-9, 1.97075089989, 569.0478410098), new Vsop87.LnVsop(2.57E-9, 1.38354609083, 360.4146120178), new Vsop87.LnVsop(1.95E-9, 3.26824797258, 984.7122062065), new Vsop87.LnVsop(2.51E-9, 4.87361192641, 516.0488264296), new Vsop87.LnVsop(2.02E-9, 4.03331754714, 187.2755416471), new Vsop87.LnVsop(2.23E-9, 0.97997805412, 627.3671133418), new Vsop87.LnVsop(2.05E-9, 5.2807414321, 223.3815878554), new Vsop87.LnVsop(2.24E-9, 5.24077049451, 206.706813299), new Vsop87.LnVsop(2.6E-9, 5.90070113141, 520.129737539), new Vsop87.LnVsop(1.88E-9, 1.49833733081, 26.826702943), new Vsop87.LnVsop(2.05E-9, 5.05597552852, 772.7857088922), new Vsop87.LnVsop(2.28E-9, 3.64861995308, 367.5975949878), new Vsop87.LnVsop(2.37E-9, 2.97607548462, 271.61836777), new Vsop87.LnVsop(2.24E-9, 1.2520150817, 161.4120465506), new Vsop87.LnVsop(1.85E-9, 4.50042780818, 224.8660605637), new Vsop87.LnVsop(2.36E-9, 5.41408651212, 550.1378342197), new Vsop87.LnVsop(1.92E-9, 2.35024531733, 236.1936451179), new Vsop87.LnVsop(2.37E-9, 3.66086044285, 1106.6555022573), new Vsop87.LnVsop(2.25E-9, 1.66222054133, 1366.2125722902), new Vsop87.LnVsop(1.93E-9, 3.0143183166, 164.3809919672), new Vsop87.LnVsop(2.18E-9, 5.46588301502, 1500.0642027149), new Vsop87.LnVsop(2.07E-9, 5.55969556391, 332.6941371975), new Vsop87.LnVsop(2.08E-9, 4.68503146595, 448.9714756941), new Vsop87.LnVsop(2.11E-9, 0.34453145739, 980.6681783588), new Vsop87.LnVsop(2.17E-9, 3.70105940449, 655.938921424), new Vsop87.LnVsop(1.9E-9, 1.69474626512, 1031.87390369), new Vsop87.LnVsop(2.54E-9, 2.52997093206, 58.1705144857), new Vsop87.LnVsop(2.42E-9, 4.63165125809, 167.7224443993), new Vsop87.LnVsop(1.82E-9, 0.38822952347, 249.9476583675), new Vsop87.LnVsop(2.29E-9, 2.97276294509, 676.2852168126), new Vsop87.LnVsop(1.84E-9, 0.87882802865, 947.6911362615), new Vsop87.LnVsop(2.03E-9, 3.17061034955, 846.0828347512), new Vsop87.LnVsop(1.81E-9, 4.5754808316, 343.2185725996), new Vsop87.LnVsop(2.5E-9, 3.61454066264, 452.2010535416), new Vsop87.LnVsop(1.81E-9, 0.8050526257, 168.3131452303), new Vsop87.LnVsop(1.87E-9, 0.91771297573, 556.5176680376), new Vsop87.LnVsop(1.99E-9, 1.94637571303, 253.4591205053), new Vsop87.LnVsop(1.91E-9, 0.61001202802, 394.9455627926), new Vsop87.LnVsop(1.8E-9, 3.74457885445, 1447.4263943021), new Vsop87.LnVsop(1.79E-9, 5.35660015345, 122.0551706354), new Vsop87.LnVsop(2.31E-9, 6.22502194357, 1610.2705239343), new Vsop87.LnVsop(2.4E-9, 6.0370383453, 898.7730327907), new Vsop87.LnVsop(2.18E-9, 2.33495824686, 623.4349600787), new Vsop87.LnVsop(1.81E-9, 1.91828280417, 337.5894983071), new Vsop87.LnVsop(2.21E-9, 2.8913812666, 238.9019581036), new Vsop87.LnVsop(2.09E-9, 1.03618779316, 6212.2264046872), new Vsop87.LnVsop(2.13E-9, 1.02918228734, 657.1627617014), new Vsop87.LnVsop(1.83E-9, 2.72582542773, 332.1728723357), new Vsop87.LnVsop(2.04E-9, 4.6751275615, 377.4194549743), new Vsop87.LnVsop(2.05E-9, 5.62140485721, 388.4651552382), new Vsop87.LnVsop(2.19E-9, 2.76359711762, 561.8861098992), new Vsop87.LnVsop(2.12E-9, 3.46768338211, 181.6464673546), new Vsop87.LnVsop(2.11E-9, 4.59763685784, 1109.6244476739), new Vsop87.LnVsop(2.12E-9, 2.99004198457, 559.6990617753), new Vsop87.LnVsop(1.74E-9, 2.21353674595, 887.7273325268), new Vsop87.LnVsop(1.73E-9, 1.74529912106, 365.149914433), new Vsop87.LnVsop(1.74E-9, 2.45391768476, 1332.4847706675), new Vsop87.LnVsop(2.4E-9, 4.85443977637, 761.7400086283), new Vsop87.LnVsop(1.78E-9, 0.05006039446, 941.3113024436), new Vsop87.LnVsop(1.95E-9, 2.37804209176, 444.8268741099), new Vsop87.LnVsop(2.42E-9, 4.29915867363, 6244.9428143536), new Vsop87.LnVsop(1.72E-9, 3.87569337913, 389.6889955156), new Vsop87.LnVsop(1.88E-9, 2.26967965211, 90.9351082619), new Vsop87.LnVsop(2.17E-9, 1.72840709072, 10213.285546211), new Vsop87.LnVsop(2.21E-9, 3.92472409608, 562.6680071919), new Vsop87.LnVsop(1.73E-9, 4.18722182816, 247.8300462128), new Vsop87.LnVsop(1.74E-9, 2.94442479945, 454.8611824175), new Vsop87.LnVsop(2.39E-9, 3.42577256015, 188.2387494936), new Vsop87.LnVsop(1.74E-9, 6.14174672485, 454.9575506371), new Vsop87.LnVsop(1.91E-9, 0.05959544276, 429.7795846137), new Vsop87.LnVsop(1.99E-9, 4.06645118654, 6204.362098161), new Vsop87.LnVsop(2.32E-9, 0.73635761605, 525.7588118315), new Vsop87.LnVsop(1.9E-9, 3.21864199482, 473.4623726669), new Vsop87.LnVsop(1.84E-9, 2.09184439155, 262.8078997398), new Vsop87.LnVsop(2.04E-9, 2.53426014155, 128.4350044533), new Vsop87.LnVsop(1.99E-9, 5.18040948653, 517.4214245533), new Vsop87.LnVsop(1.69E-9, 3.32081675151, 442.3791935551), new Vsop87.LnVsop(1.94E-9, 1.70394842618, 454.6487340964), new Vsop87.LnVsop(1.74E-9, 0.92072543792, 298.2326223919), new Vsop87.LnVsop(1.97E-9, 2.45889996723, 10142.4361009068), new Vsop87.LnVsop(1.69E-9, 2.85071771667, 182.279606801), new Vsop87.LnVsop(1.76E-9, 3.0680256881, 594.9113361063), new Vsop87.LnVsop(1.7E-9, 1.61438641294, 1512.8068240082), new Vsop87.LnVsop(1.81E-9, 5.5485277762, 388.2045228073), new Vsop87.LnVsop(2.05E-9, 2.42849105018, 179.3106613844), new Vsop87.LnVsop(1.68E-9, 0.36331522083, 597.3590166611), new Vsop87.LnVsop(2.33E-9, 4.13122108092, 544.5087599272), new Vsop87.LnVsop(2.12E-9, 1.16230626511, 268.6976064632), new Vsop87.LnVsop(1.64E-9, 4.16304107762, 433.7117378768), new Vsop87.LnVsop(1.84E-9, 4.13171323402, 78114.14622758799), new Vsop87.LnVsop(2.16E-9, 4.13270907264, 375.6743498351), new Vsop87.LnVsop(1.64E-9, 3.48735100134, 1521.4048437173), new Vsop87.LnVsop(1.66E-9, 3.69271105852, 381.0909758065), new Vsop87.LnVsop(2.15E-9, 3.01465140857, 3191.0492295652), new Vsop87.LnVsop(2.1E-9, 0.51797558404, 987.7817253596), new Vsop87.LnVsop(1.96E-9, 1.96055142388, 255.8373650909), new Vsop87.LnVsop(1.88E-9, 1.75260412819, 9987.4562778008), new Vsop87.LnVsop(1.83E-9, 1.55394479952, 545.2750258176), new Vsop87.LnVsop(1.62E-9, 3.53658533673, 477.0007670551), new Vsop87.LnVsop(1.97E-9, 1.23651696009, 873.1701701251), new Vsop87.LnVsop(2.28E-9, 5.72185284514, 10175.1525105732), new Vsop87.LnVsop(2.21E-9, 1.65277750718, 630.3360587584), new Vsop87.LnVsop(1.66E-9, 4.86610094513, 1440.9941708575), new Vsop87.LnVsop(1.77E-9, 3.02796963506, 5983.9494557222), new Vsop87.LnVsop(1.7E-9, 2.58560048709, 1515.7757694248), new Vsop87.LnVsop(1.77E-9, 2.88506192589, 240.125798381), new Vsop87.LnVsop(2.08E-9, 2.04949512692, 302.3772239761), new Vsop87.LnVsop(1.89E-9, 5.8294637878, 36.1754821775), new Vsop87.LnVsop(2.16E-9, 0.68196473963, 1363.2436268736), new Vsop87.LnVsop(1.75E-9, 2.61001153558, 885.4397106664), new Vsop87.LnVsop(2.1E-9, 2.6555551593, 224.4566702865), new Vsop87.LnVsop(1.6E-9, 3.50517836979, 150.31395666), new Vsop87.LnVsop(1.74E-9, 0.49467967031, 369.9758395734), new Vsop87.LnVsop(1.88E-9, 5.48911204749, 10134.5717943806), new Vsop87.LnVsop(1.91E-9, 5.68393131484, 662.6430781476), new Vsop87.LnVsop(2.05E-9, 0.92509219538, 548.4409131903), new Vsop87.LnVsop(2.06E-9, 6.10268880505, 1054.9285120643), new Vsop87.LnVsop(1.85E-9, 0.91857524328, 440.8947208468), new Vsop87.LnVsop(1.89E-9, 2.67822187732, 2250.1678102483), new Vsop87.LnVsop(1.84E-9, 5.67663245346, 409.9234163196), new Vsop87.LnVsop(2.07E-9, 3.01561723041, 95.2766518022), new Vsop87.LnVsop(1.92E-9, 3.38477678765, 141.1776257466), new Vsop87.LnVsop(1.75E-9, 3.98637627601, 354.9979860464), new Vsop87.LnVsop(1.79E-9, 1.06144138645, 455.1699989582), new Vsop87.LnVsop(1.85E-9, 1.48084539492, 226.7924762567), new Vsop87.LnVsop(1.72E-9, 2.45526838627, 398.2870152247), new Vsop87.LnVsop(2.03E-9, 4.82705125287, 6737.9852165187), new Vsop87.LnVsop(1.59E-9, 3.62343847192, 73.9784494152), new Vsop87.LnVsop(2.15E-9, 3.25584948597, 125.1841747464), new Vsop87.LnVsop(2.05E-9, 0.77710214764, 769.8167634756), new Vsop87.LnVsop(1.64E-9, 4.68848272913, 6607.9277275406), new Vsop87.LnVsop(2.15E-9, 1.66517240781, 118.0706277456), new Vsop87.LnVsop(1.64E-9, 0.87369484245, 774.4826299216), new Vsop87.LnVsop(1.6E-9, 3.32460761773, 138.5656809805), new Vsop87.LnVsop(1.61E-9, 2.52319991589, 409.0720830577), new Vsop87.LnVsop(1.73E-9, 3.15899401917, 70.0462961521), new Vsop87.LnVsop(1.58E-9, 0.06255653314, 138.4693127609), new Vsop87.LnVsop(1.54E-9, 5.92679370788, 224.2329211173), new Vsop87.LnVsop(1.66E-9, 4.16626167677, 72.0732855816), new Vsop87.LnVsop(1.83E-9, 2.68426170572, 838.0060799039), new Vsop87.LnVsop(1.93E-9, 1.38193725138, 154.6710065653), new Vsop87.LnVsop(1.88E-9, 3.61481992714, 517.1607921224), new Vsop87.LnVsop(1.89E-9, 0.667494835, 484.917463208), new Vsop87.LnVsop(2.03E-9, 2.66775880985, 327.4375699205), new Vsop87.LnVsop(1.93E-9, 4.43470193645, 832.0681890707), new Vsop87.LnVsop(1.59E-9, 0.56494121338, 379.1645601135), new Vsop87.LnVsop(1.66E-9, 4.45048519194, 9914.1591519418), new Vsop87.LnVsop(1.68E-9, 3.52621114631, 464.9918589447), new Vsop87.LnVsop(1.96E-9, 6.24770073617, 10668.1949127383), new Vsop87.LnVsop(1.51E-9, 5.72816916526, 59.5912967192), new Vsop87.LnVsop(1.81E-9, 0.32013093352, 421.2297490144), new Vsop87.LnVsop(2.05E-9, 6.02871481422, 772.5887669361), new Vsop87.LnVsop(1.76E-9, 4.99216368664, 123.0183784819), new Vsop87.LnVsop(1.6E-9, 1.37750465628, 308.6876218248), new Vsop87.LnVsop(2.02E-9, 1.13801628591, 508.6264628881), new Vsop87.LnVsop(1.77E-9, 3.63679025498, 1291.4309737229), new Vsop87.LnVsop(1.51E-9, 1.15330259215, 1116.0042814918), new Vsop87.LnVsop(1.78E-9, 4.93531001103, 349.3689117539), new Vsop87.LnVsop(2.05E-9, 2.81769329338, 225.3080035484), new Vsop87.LnVsop(1.82E-9, 0.9147484027, 3189.5647568569), new Vsop87.LnVsop(1.56E-9, 2.37674956845, 151.260118164), new Vsop87.LnVsop(1.54E-9, 2.76526452323, 78263.70942472259), new Vsop87.LnVsop(1.62E-9, 5.62540185969, 1123.1178284926), new Vsop87.LnVsop(1.82E-9, 0.63986108075, 274.5873131866), new Vsop87.LnVsop(1.56E-9, 4.83915698384, 753.1419889192), new Vsop87.LnVsop(1.67E-9, 6.27621577207, 757.8078553652), new Vsop87.LnVsop(1.51E-9, 1.69627858213, 325.9530972122), new Vsop87.LnVsop(1.49E-9, 2.40009261288, 210.8514148832), new Vsop87.LnVsop(1.49E-9, 5.09330665926, 509.0840372751), new Vsop87.LnVsop(1.79E-9, 0.93833237775, 196.8367692027), new Vsop87.LnVsop(1.95E-9, 0.2327276971, 984.4884570373), new Vsop87.LnVsop(1.47E-9, 2.15520667674, 73.2489417492), new Vsop87.LnVsop(1.66E-9, 4.95085074433, 276.9231191568), new Vsop87.LnVsop(1.94E-9, 5.71948163347, 6136.4815982734), new Vsop87.LnVsop(1.48E-9, 1.50337825489, 1525.3369969804), new Vsop87.LnVsop(2.05E-9, 0.81050821834, 6171.6456884946), new Vsop87.LnVsop(1.95E-9, 5.02600286169, 415.2918581812), new Vsop87.LnVsop(1.47E-9, 4.88804405947, 683.0262567979), new Vsop87.LnVsop(1.68E-9, 4.68232587155, 519.6084726772), new Vsop87.LnVsop(1.61E-9, 1.71491481543, 277.146868326), new Vsop87.LnVsop(1.85E-9, 5.8624034365, 1743.3713948336), new Vsop87.LnVsop(1.77E-9, 5.39738308693, 25936.85547173129), new Vsop87.LnVsop(1.59E-9, 3.71583639802, 6604.958782124), new Vsop87.LnVsop(1.52E-9, 3.76465336789, 768.8535556291), new Vsop87.LnVsop(1.91E-9, 4.45675615557, 340.8827666294), new Vsop87.LnVsop(1.47E-9, 6.01587695039, 369.342700127), new Vsop87.LnVsop(1.48E-9, 1.70522713789, 1523.6924655777), new Vsop87.LnVsop(1.44E-9, 1.19516771137, 95.9792272178), new Vsop87.LnVsop(1.81E-9, 4.75684140426, 71.1582618449), new Vsop87.LnVsop(1.45E-9, 3.15169720832, 523.4711899711), new Vsop87.LnVsop(1.46E-9, 4.40646311724, 2014.0265547571), new Vsop87.LnVsop(1.62E-9, 4.76511090288, 245.4942402426), new Vsop87.LnVsop(1.95E-9, 1.45876037172, 281.4884118663), new Vsop87.LnVsop(1.55E-9, 2.45354382334, 557.0389328994), new Vsop87.LnVsop(1.49E-9, 2.09335099835, 273.8536000037), new Vsop87.LnVsop(1.87E-9, 1.77504712447, 995.6460318858), new Vsop87.LnVsop(1.51E-9, 3.12279980744, 746.7621551013), new Vsop87.LnVsop(1.47E-9, 5.09554340545, 466.7582159433), new Vsop87.LnVsop(1.72E-9, 1.4253511108, 276.0717858949), new Vsop87.LnVsop(1.9E-9, 0.86480008, 10066.691294493), new Vsop87.LnVsop(1.54E-9, 2.07677643107, 91.2439248026), new Vsop87.LnVsop(1.42E-9, 2.70241566553, 1367.6970449985), new Vsop87.LnVsop(1.85E-9, 0.07257813358, 548.6533615114), new Vsop87.LnVsop(1.4E-9, 2.61987335792, 76.3142553854), new Vsop87.LnVsop(1.54E-9, 3.03571181321, 714.6788848813), new Vsop87.LnVsop(1.69E-9, 5.57948514798, 163.5778428151), new Vsop87.LnVsop(1.86E-9, 4.76535517241, 197.257460328), new Vsop87.LnVsop(1.53E-9, 3.32414222326, 138.4056222861), new Vsop87.LnVsop(1.67E-9, 5.32278498942, 457.3570470821), new Vsop87.LnVsop(1.42E-9, 4.15791797624, 156.6767441354), new Vsop87.LnVsop(1.51E-9, 4.34031737599, 147.9668498417), new Vsop87.LnVsop(1.83E-9, 6.17032359307, 132.5796060375), new Vsop87.LnVsop(1.38E-9, 2.1381195819, 540.0553418023), new Vsop87.LnVsop(1.38E-9, 5.01289623723, 144.8973306886), new Vsop87.LnVsop(1.67E-9, 2.14405503902, 343.7398374614), new Vsop87.LnVsop(1.52E-9, 3.1101565976, 1381.2428154439), new Vsop87.LnVsop(1.77E-9, 1.05125544318, 586.377006872), new Vsop87.LnVsop(1.49E-9, 4.87184568681, 130.552616608), new Vsop87.LnVsop(1.55E-9, 5.70008442904, 115.6229471908), new Vsop87.LnVsop(1.49E-9, 4.3313015842, 223.8235308401), new Vsop87.LnVsop(1.81E-9, 4.1377051741, 267.5856407704), new Vsop87.LnVsop(1.54E-9, 2.83750308914, 108.982480942), new Vsop87.LnVsop(1.63E-9, 2.53865234151, 743.7932096847), new Vsop87.LnVsop(1.65E-9, 3.41287686341, 247.2393453818), new Vsop87.LnVsop(1.51E-9, 2.20235595263, 476.3194434989), new Vsop87.LnVsop(1.44E-9, 0.01781384847, 164.5410506616), new Vsop87.LnVsop(1.3E-9, 2.21675074014, 1596.9895914367), new Vsop87.LnVsop(1.39E-9, 1.43423426981, 73.5577582899), new Vsop87.LnVsop(1.3E-9, 2.59858785273, 317.8763423649), new Vsop87.LnVsop(1.51E-9, 0.90758816089, 156.4642958143), new Vsop87.LnVsop(1.32E-9, 5.78977405289, 262.0571402144), new Vsop87.LnVsop(1.5E-9, 3.82803929273, 523.7530742614), new Vsop87.LnVsop(1.28E-9, 1.75773422282, 77.7023598741), new Vsop87.LnVsop(1.29E-9, 2.46767229126, 680.0573113813), new Vsop87.LnVsop(1.33E-9, 2.63453025078, 973.554631358), new Vsop87.LnVsop(1.41E-9, 3.2165757437, 710.7467316182), new Vsop87.LnVsop(1.35E-9, 4.39682615321, 153.186533857), new Vsop87.LnVsop(1.64E-9, 0.99473913469, 94.4253185403), new Vsop87.LnVsop(1.45E-9, 5.12015953658, 677.7696895209), new Vsop87.LnVsop(1.26E-9, 1.32965975637, 400.5746370851), new Vsop87.LnVsop(1.41E-9, 1.24113752853, 460.8472573605), new Vsop87.LnVsop(1.33E-9, 4.6173080944, 250.6020496733), new Vsop87.LnVsop(1.29E-9, 5.27547517603, 88.274979386), new Vsop87.LnVsop(1.27E-9, 0.42170103072, 913.7508863177), new Vsop87.LnVsop(1.63E-9, 4.54645286709, 346.4481504471), new Vsop87.LnVsop(1.25E-9, 3.65991404025, 191.3195694948), new Vsop87.LnVsop(1.45E-9, 2.22528076208, 673.316271396), new Vsop87.LnVsop(1.26E-9, 4.73776902368, 1063.3140834523), new Vsop87.LnVsop(1.34E-9, 1.14931407095, 725.0914456988), new Vsop87.LnVsop(1.29E-9, 3.47362853744, 1257.7031721002), new Vsop87.LnVsop(1.24E-9, 5.93939315836, 354.7855377253), new Vsop87.LnVsop(1.36E-9, 2.59497163361, 1119.1856752295), new Vsop87.LnVsop(1.54E-9, 0.69730597728, 365.9006739584), new Vsop87.LnVsop(1.4E-9, 0.6554324722, 73.0364934281), new Vsop87.LnVsop(1.46E-9, 2.80047542494, 188.9200730498), new Vsop87.LnVsop(1.54E-9, 1.87714738928, 164.1203595363), new Vsop87.LnVsop(1.25E-9, 2.18116740243, 764.1876891831), new Vsop87.LnVsop(1.55E-9, 1.28214942977, 148.1905990109), new Vsop87.LnVsop(1.32E-9, 0.29965207574, 255.57673266), new Vsop87.LnVsop(1.25E-9, 1.04485712681, 415.6643651967), new Vsop87.LnVsop(1.37E-9, 2.18373893649, 765.8846102125), new Vsop87.LnVsop(1.27E-9, 2.93669188864, 147.8662761052), new Vsop87.LnVsop(1.4E-9, 0.7686003141, 273.1510245881), new Vsop87.LnVsop(1.42E-9, 4.10293143898, 309.7995875176), new Vsop87.LnVsop(1.18E-9, 5.29215987279, 346.1875180162), new Vsop87.LnVsop(1.18E-9, 5.64065029465, 430.5303441391), new Vsop87.LnVsop(1.17E-9, 4.70740499014, 346.3999663373), new Vsop87.LnVsop(1.59E-9, 3.17545315975, 587.8614795803), new Vsop87.LnVsop(1.3E-9, 4.93752382941, 112.3933693433), new Vsop87.LnVsop(1.23E-9, 2.01301867655, 376.8769382531), new Vsop87.LnVsop(1.31E-9, 5.76525549509, 75.4359898731), new Vsop87.LnVsop(1.52E-9, 4.20648305698, 76.5267037065), new Vsop87.LnVsop(1.33E-9, 0.27916246107, 221.1634019642), new Vsop87.LnVsop(1.15E-9, 6.2695499475, 226.6324175623), new Vsop87.LnVsop(1.59E-9, 6.17088331412, 269.0701134787), new Vsop87.LnVsop(1.14E-9, 3.58569184745, 1048.3362299253), new Vsop87.LnVsop(1.52E-9, 2.72945581345, 639.6366538831), new Vsop87.LnVsop(1.21E-9, 4.6766183437, 1222.2784494481), new Vsop87.LnVsop(1.19E-9, 4.81856456066, 73.4571845534), new Vsop87.LnVsop(1.25E-9, 0.74436796006, 280.2163874791), new Vsop87.LnVsop(1.17E-9, 4.00334187137, 107.918699359), new Vsop87.LnVsop(1.13E-9, 2.15393931454, 303.0585475323), new Vsop87.LnVsop(1.28E-9, 0.04409162068, 76.1060125812), new Vsop87.LnVsop(1.42E-9, 0.57614004948, 246.4361962297), new Vsop87.LnVsop(1.38E-9, 5.48635616668, 392.6579409322), new Vsop87.LnVsop(1.56E-9, 4.96860085576, 552.6973893591), new Vsop87.LnVsop(1.12E-9, 4.3135786833, 74.3240241803), new Vsop87.LnVsop(1.16E-9, 3.19955309317, 71.8608372605), new Vsop87.LnVsop(1.12E-9, 0.38818418554, 75.2391729543), new Vsop87.LnVsop(1.1E-9, 1.3527736469, 376.9463742223), new Vsop87.LnVsop(1.52E-9, 0.76257718923, 956.2891559706), new Vsop87.LnVsop(1.16E-9, 4.73215012461, 1052.2683831884), new Vsop87.LnVsop(1.37E-9, 2.4089304502, 488.5889840402), new Vsop87.LnVsop(1.21E-9, 4.23091725782, 115.3623147599), new Vsop87.LnVsop(1.31E-9, 0.45681197732, 1261.6353253633), new Vsop87.LnVsop(1.42E-9, 1.8732433243, 175.4266922311), new Vsop87.LnVsop(1.28E-9, 2.98656300188, 694.8382229522), new Vsop87.LnVsop(1.07E-9, 5.62518758086, 582.3811631341), new Vsop87.LnVsop(1.34E-9, 4.02062578806, 57.7980074702), new Vsop87.LnVsop(1.12E-9, 1.06960066812, 481.7360694703), new Vsop87.LnVsop(1.06E-9, 1.01847069745, 625.8826406335), new Vsop87.LnVsop(1.25E-9, 1.1476668453, 688.4428827693), new Vsop87.LnVsop(1.1E-9, 1.50687781826, 1083.7609525774), new Vsop87.LnVsop(1.22E-9, 3.47813324957, 763.2244813366), new Vsop87.LnVsop(1.09E-9, 0.4799155699, 143.3434220111), new Vsop87.LnVsop(1.09E-9, 2.37913722341, 313.6835566709), new Vsop87.LnVsop(1.12E-9, 4.82305132773, 323.5054166574), new Vsop87.LnVsop(1.33E-9, 3.91778366061, 9988.9407505091), new Vsop87.LnVsop(1.17E-9, 5.79438398039, 383.3091616977), new Vsop87.LnVsop(1.43E-9, 2.38142377439, 355.7487455718), new Vsop87.LnVsop(1.04E-9, 6.22747103073, 166.237971691), new Vsop87.LnVsop(1.25E-9, 0.93541375535, 532.8723588323), new Vsop87.LnVsop(1.36E-9, 3.34772962822, 624.5100425098), new Vsop87.LnVsop(1.11E-9, 2.80052858233, 185.5786206177), new Vsop87.LnVsop(1.22E-9, 0.66856217536, 499.895316735), new Vsop87.LnVsop(1.29E-9, 5.71746410559, 388.7257876691), new Vsop87.LnVsop(1.24E-9, 0.47197488986, 480.8847362084), new Vsop87.LnVsop(9.9E-10, 2.73963726422, 469.7271613599), new Vsop87.LnVsop(1.35E-9, 0.43811617647, 1286.0143477515), new Vsop87.LnVsop(1.18E-9, 5.62193572572, 386.9806825299), new Vsop87.LnVsop(9.8E-10, 6.12967230866, 1830.6831663731), new Vsop87.LnVsop(1.09E-9, 2.38141278301, 73.9302653054), new Vsop87.LnVsop(1.31E-9, 5.44225511718, 74.1272072615), new Vsop87.LnVsop(1.0E-9, 3.99996377183, 313.9441891018), new Vsop87.LnVsop(9.7E-10, 0.80340713292, 840.6662087798), new Vsop87.LnVsop(1.13E-9, 4.35141023213, 904.4021070832), new Vsop87.LnVsop(1.08E-9, 1.53330326885, 215.7467759928), new Vsop87.LnVsop(1.13E-9, 0.54441962592, 1250.5896250994), new Vsop87.LnVsop(9.8E-10, 1.38351669708, 1218.1338478639), new Vsop87.LnVsop(1.02E-9, 5.79129370115, 65.3804297061), new Vsop87.LnVsop(1.06E-9, 3.94341216754, 678.3603903519), new Vsop87.LnVsop(1.24E-9, 1.28838964889, 664.1275508559), new Vsop87.LnVsop(9.9E-10, 0.02552769353, 117.36805233), new Vsop87.LnVsop(1.31E-9, 2.67824794719, 981.6313862053), new Vsop87.LnVsop(1.19E-9, 3.92954881851, 6134.9971255651), new Vsop87.LnVsop(1.28E-9, 4.11821528752, 632.7837393132), new Vsop87.LnVsop(1.1E-9, 3.43940323812, 78.9743842613), new Vsop87.LnVsop(1.24E-9, 4.84054644412, 1162.4747044078), new Vsop87.LnVsop(9.8E-10, 4.25775813209, 199.8057146193), new Vsop87.LnVsop(1.25E-9, 2.27613295738, 424.1505103212), new Vsop87.LnVsop(1.26E-9, 3.91634098527, 26086.4186688659), new Vsop87.LnVsop(1.01E-9, 5.1361968957, 915.4478073471), new Vsop87.LnVsop(1.13E-9, 4.93378111345, 108.7218485111), new Vsop87.LnVsop(1.05E-9, 3.71144437242, 107.0249274817), new Vsop87.LnVsop(1.25E-9, 5.71482360911, 3339.1279539915), new Vsop87.LnVsop(9.7E-10, 5.84826276361, 739.0579072695), new Vsop87.LnVsop(1.06E-9, 2.53486223474, 76.0054388447), new Vsop87.LnVsop(1.11E-9, 1.67593033062, 1002.7595788866), new Vsop87.LnVsop(1.05E-9, 3.08951960134, 598.5346728287), new Vsop87.LnVsop(1.09E-9, 5.84626924359, 51.8870488874), new Vsop87.LnVsop(1.15E-9, 4.28360700908, 172.1971143836), new Vsop87.LnVsop(9.7E-10, 3.02476841325, 669.0116111174), new Vsop87.LnVsop(1.04E-9, 3.79048221012, 661.1586054393), new Vsop87.LnVsop(1.28E-9, 4.12077041398, 537.3952129264), new Vsop87.LnVsop(1.19E-9, 5.28769603458, 151.1595444275), new Vsop87.LnVsop(1.23E-9, 0.7671758747, 566.600160455), new Vsop87.LnVsop(1.25E-9, 2.4609349466, 686.958410061), new Vsop87.LnVsop(1.1E-9, 0.48706972538, 367.8582274187), new Vsop87.LnVsop(9.1E-10, 1.20582179592, 1134.1635287565), new Vsop87.LnVsop(1.27E-9, 5.92519293974, 322.6116447801), new Vsop87.LnVsop(9.5E-10, 1.48492429003, 70.5888128733), new Vsop87.LnVsop(1.05E-9, 1.25919493117, 524.0618908021), new Vsop87.LnVsop(1.09E-9, 2.16321134153, 506.3757242894), new Vsop87.LnVsop(9.6E-10, 5.79387198359, 335.1418177523), new Vsop87.LnVsop(1.0E-9, 0.1643562606, 1895.9035373848), new Vsop87.LnVsop(1.04E-9, 6.19360690877, 150.3663462867), new Vsop87.LnVsop(1.27E-9, 2.12085008036, 6206.8097787158), new Vsop87.LnVsop(1.16E-9, 1.93143384597, 636.6677084665), new Vsop87.LnVsop(9.4E-10, 3.60705393791, 1226.2106027112), new Vsop87.LnVsop(1.01E-9, 0.24474158501, 170.7126416753), new Vsop87.LnVsop(9.1E-10, 2.18722199515, 294.3004691288), new Vsop87.LnVsop(9.2E-10, 5.62416527287, 798.1279391269), new Vsop87.LnVsop(1.15E-9, 0.61012607379, 583.8656358424), new Vsop87.LnVsop(1.02E-9, 4.71122439335, 924.0458270562), new Vsop87.LnVsop(8.9E-10, 5.21344736627, 207.6700211455), new Vsop87.LnVsop(9.4E-10, 3.70231426761, 63.2146334416), new Vsop87.LnVsop(9.1E-10, 3.75312295357, 923.1520551789), new Vsop87.LnVsop(1.1E-9, 3.96973294508, 154.5591319807), new Vsop87.LnVsop(1.09E-9, 1.01882208456, 748.0978699633), new Vsop87.LnVsop(1.18E-9, 0.99881794452, 134.3728952865), new Vsop87.LnVsop(9.0E-10, 0.41169241547, 318.679491517), new Vsop87.LnVsop(1.07E-9, 3.76840018527, 882.9920301116), new Vsop87.LnVsop(8.8E-10, 5.47502707027, 70.6369969831), new Vsop87.LnVsop(8.8E-10, 0.90750547659, 612.1768114937), new Vsop87.LnVsop(1.18E-9, 3.14225356391, 37.1698277913), new Vsop87.LnVsop(1.06E-9, 5.71907464992, 1101.0264279648), new Vsop87.LnVsop(9.2E-10, 1.60540815321, 213.4109700226), new Vsop87.LnVsop(1.08E-9, 2.73050081078, 73.0846775379), new Vsop87.LnVsop(9.1E-10, 0.73982044423, 320.1639642253), new Vsop87.LnVsop(9.5E-10, 3.37355805725, 190.665178189), new Vsop87.LnVsop(9.0E-10, 2.58787034269, 75.5153117502), new Vsop87.LnVsop(1.02E-9, 2.92980359364, 533.4630596633), new Vsop87.LnVsop(9.2E-10, 4.94283886398, 1055.4497769261), new Vsop87.LnVsop(1.13E-9, 2.3554198498, 176.6505325085), new Vsop87.LnVsop(9.8E-10, 6.04221644753, 1357.6145525811), new Vsop87.LnVsop(8.6E-10, 2.90604124166, 234.4967240885), new Vsop87.LnVsop(8.5E-10, 0.83669286935, 301.4140161296), new Vsop87.LnVsop(9.8E-10, 0.8515463012, 1131.1945833399), new Vsop87.LnVsop(1.12E-9, 0.92696951989, 590.8304249969), new Vsop87.LnVsop(1.12E-9, 5.45918572076, 705.1176573257), new Vsop87.LnVsop(1.01E-9, 4.26515214526, 195.4004806042), new Vsop87.LnVsop(1.02E-9, 5.81318586612, 1396.2206689709), new Vsop87.LnVsop(8.4E-10, 3.86583598631, 913.0001267923), new Vsop87.LnVsop(1.01E-9, 0.14878503401, 702.1487119091), new Vsop87.LnVsop(9.8E-10, 0.30973273548, 12.1576659567), new Vsop87.LnVsop(9.4E-10, 5.53729042047, 178.1350052168), new Vsop87.LnVsop(9.0E-10, 1.42741371964, 592.2030231206), new Vsop87.LnVsop(1.03E-9, 3.56392656212, 487.1045113319), new Vsop87.LnVsop(1.14E-9, 1.71224480179, 216.2680408546), new Vsop87.LnVsop(9.8E-10, 6.12303086368, 575.2676161333), new Vsop87.LnVsop(8.2E-10, 3.07432558693, 315.1680293792), new Vsop87.LnVsop(9.9E-10, 0.95472771381, 176.3899000776), new Vsop87.LnVsop(1.14E-9, 2.59949812888, 75.6329318292), new Vsop87.LnVsop(9.1E-10, 5.72899997508, 196.8849533125), new Vsop87.LnVsop(9.8E-10, 1.78363341484, 259.769518354), new Vsop87.LnVsop(1.13E-9, 1.70438642876, 150.9357952583), new Vsop87.LnVsop(8.1E-10, 6.19017012933, 154.2290635806), new Vsop87.LnVsop(8.7E-10, 2.6792993877, 539.0921339558), new Vsop87.LnVsop(8.0E-10, 2.38043346629, 1053.7528558967), new Vsop87.LnVsop(8.4E-10, 3.41034232685, 1349.7502460549), new Vsop87.LnVsop(8.8E-10, 0.14553753672, 1062.3508756058), new Vsop87.LnVsop(9.2E-10, 0.39976274896, 576.1613880106), new Vsop87.LnVsop(8.0E-10, 6.14901515198, 515.463871093), new Vsop87.LnVsop(8.4E-10, 4.08795854193, 323.2447842265), new Vsop87.LnVsop(7.9E-10, 3.44985050546, 71.7007785661), new Vsop87.LnVsop(1.03E-9, 0.24719113679, 395.105621487), new Vsop87.LnVsop(8.1E-10, 2.61930932018, 623.2225117576), new Vsop87.LnVsop(7.9E-10, 0.90143680512, 718.6110381444), new Vsop87.LnVsop(7.9E-10, 2.22415153671, 74.0478853844), new Vsop87.LnVsop(9.2E-10, 2.57503576494, 302.164775655), new Vsop87.LnVsop(9.4E-10, 4.1347259059, 64.2571631652), new Vsop87.LnVsop(9.0E-10, 3.55225063298, 495.9631634719), new Vsop87.LnVsop(9.7E-10, 5.23472340611, 1112.0721282287), new Vsop87.LnVsop(8.8E-10, 5.01537308962, 1297.8631971675), new Vsop87.LnVsop(9.0E-10, 1.32491876418, 724.8308132679), new Vsop87.LnVsop(1.06E-9, 5.11210367902, 74.1908977363), new Vsop87.LnVsop(8.4E-10, 2.69256231569, 27.7417266797), new Vsop87.LnVsop(8.3E-10, 3.61925786724, 514.7131115676), new Vsop87.LnVsop(8.0E-10, 4.91927269399, 347.3631741838), new Vsop87.LnVsop(7.7E-10, 5.57198158633, 74.9940468884), new Vsop87.LnVsop(8.2E-10, 2.2288257386, 469.8872200543), new Vsop87.LnVsop(8.9E-10, 6.06487552896, 75.3722993983), new Vsop87.LnVsop(7.8E-10, 3.25878759023, 394.3548619616), new Vsop87.LnVsop(1.04E-9, 3.00022428298, 532.6599105112), new Vsop87.LnVsop(7.9E-10, 4.37011833943, 396.5419100855), new Vsop87.LnVsop(1.03E-9, 3.64560367439, 540.7366653585), new Vsop87.LnVsop(8.2E-10, 4.43941220587, 432.8179659995), new Vsop87.LnVsop(1.01E-9, 5.81737971094, 658.1896600227), new Vsop87.LnVsop(9.7E-10, 2.59101775215, 690.1398037987), new Vsop87.LnVsop(8.2E-10, 5.40861394405, 529.57909051), new Vsop87.LnVsop(8.1E-10, 2.52312280794, 384.9536931004), new Vsop87.LnVsop(7.6E-10, 4.43418522057, 818.574808252), new Vsop87.LnVsop(8.1E-10, 0.95220782125, 73.6696328745), new Vsop87.LnVsop(8.7E-10, 5.5722785666, 6284.5603226997), new Vsop87.LnVsop(9.4E-10, 6.23547840274, 305.7186764082), new Vsop87.LnVsop(7.5E-10, 4.35228806434, 112.4939430798), new Vsop87.LnVsop(9.6E-10, 1.1290951463, 123.960334469), new Vsop87.LnVsop(9.5E-10, 2.73244270397, 934.1977554428), new Vsop87.LnVsop(9.7E-10, 4.75415372291, 90.5626012464), new Vsop87.LnVsop(8.8E-10, 5.23693832326, 434.6749457233), new Vsop87.LnVsop(7.6E-10, 4.86126967725, 72.4939767069), new Vsop87.LnVsop(1.04E-9, 5.37590823539, 543.9180590962), new Vsop87.LnVsop(9.1E-10, 1.04794288604, 938.1299087059), new Vsop87.LnVsop(9.9E-10, 2.19698635547, 1129.7101106316), new Vsop87.LnVsop(7.4E-10, 3.27934639338, 89.0086925689), new Vsop87.LnVsop(1.0E-9, 4.59916398079, 461.7622810972), new Vsop87.LnVsop(7.4E-10, 5.6349392604, 233.533516242), new Vsop87.LnVsop(7.4E-10, 3.03606610688, 1531.5567721039), new Vsop87.LnVsop(9.9E-10, 0.64774167845, 554.1818620674), new Vsop87.LnVsop(8.4E-10, 3.14436294064, 370.0452755426), new Vsop87.LnVsop(7.7E-10, 1.33778374453, 1022.3126761344), new Vsop87.LnVsop(8.1E-10, 3.36096602483, 292.0128472684), new Vsop87.LnVsop(8.1E-10, 4.15588604506, 432.2272651685), new Vsop87.LnVsop(7.4E-10, 2.91359929208, 302.7497309916), new Vsop87.LnVsop(9.2E-10, 5.11372489097, 912.7876784712), new Vsop87.LnVsop(7.3E-10, 5.42920211703, 539.2521926502), new Vsop87.LnVsop(8.1E-10, 5.25618688362, 311.6565672414), new Vsop87.LnVsop(8.2E-10, 0.77806577612, 591.9423906897), new Vsop87.LnVsop(7.4E-10, 0.16737907492, 1374.1292684431), new Vsop87.LnVsop(7.7E-10, 3.20203134483, 527.2432845398), new Vsop87.LnVsop(8.1E-10, 3.80903070318, 75.8935642601), new Vsop87.LnVsop(9.7E-10, 4.67281118685, 16.9835910971), new Vsop87.LnVsop(7.7E-10, 2.10541189728, 139.1718881765), new Vsop87.LnVsop(9.1E-10, 4.67274741065, 84.8640909847), new Vsop87.LnVsop(9.8E-10, 2.37249774428, 566.3395280241), new Vsop87.LnVsop(8.2E-10, 2.1607075811, 529.8028396792), new Vsop87.LnVsop(7.2E-10, 3.47566702228, 1086.0485744378), new Vsop87.LnVsop(9.2E-10, 0.21608932947, 1297.0600480154), new Vsop87.LnVsop(9.3E-10, 4.30059085579, 224.9354965329), new Vsop87.LnVsop(8.6E-10, 3.02917299294, 126.5085887603), new Vsop87.LnVsop(7.9E-10, 1.29816054687, 683.9894646444), new Vsop87.LnVsop(9.5E-10, 2.46862196214, 9917.1280973584), new Vsop87.LnVsop(7.6E-10, 2.48420575089, 37.7123445125), new Vsop87.LnVsop(9.7E-10, 0.68274913158, 207.3612046048), new Vsop87.LnVsop(9.6E-10, 4.16112194001, 1042.9196039539), new Vsop87.LnVsop(7.1E-10, 6.0413083451, 223.4510238246), new Vsop87.LnVsop(7.6E-10, 3.37676835926, 502.8642621516), new Vsop87.LnVsop(8.4E-10, 3.24912782551, 628.9634606347), new Vsop87.LnVsop(7.3E-10, 0.7311360743, 390.4921446677), new Vsop87.LnVsop(7.1E-10, 4.64209882547, 72.5463663336), new Vsop87.LnVsop(7.3E-10, 3.31815515601, 356.2700104336), new Vsop87.LnVsop(7.2E-10, 2.60766427215, 602.0248831071), new Vsop87.LnVsop(7.4E-10, 5.76600995478, 1424.5318446222), new Vsop87.LnVsop(7.4E-10, 4.22820017237, 1274.9686474876), new Vsop87.LnVsop(7.4E-10, 2.78217896807, 1522.2079928694), new Vsop87.LnVsop(7.4E-10, 4.38596183925, 1372.6447957348)};
        private static final Vsop87.LnVsop[] uranus_longitude_l1 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(74.7815986091, 0.0, 0.0), new Vsop87.LnVsop(0.00154332863, 5.24158770553, 74.7815985673), new Vsop87.LnVsop(2.4456474E-4, 1.71260334156, 1.4844727083), new Vsop87.LnVsop(9.258442E-5, 0.4282973235, 11.0457002639), new Vsop87.LnVsop(8.265977E-5, 1.50218091379, 63.7358983034), new Vsop87.LnVsop(9.15016E-5, 1.41213765216, 149.5631971346), new Vsop87.LnVsop(3.899108E-5, 0.4648357916, 3.9321532631), new Vsop87.LnVsop(2.277065E-5, 4.17199181523, 76.2660712756), new Vsop87.LnVsop(1.92747E-5, 0.52976188479, 2.9689454166), new Vsop87.LnVsop(1.232725E-5, 1.58632088145, 70.8494453042), new Vsop87.LnVsop(7.91201E-6, 5.43640595978, 3.1813937377), new Vsop87.LnVsop(7.66954E-6, 1.99425624214, 73.297125859), new Vsop87.LnVsop(4.81813E-6, 2.98574070918, 85.8272988312), new Vsop87.LnVsop(4.49635E-6, 4.14242946378, 138.5174968707), new Vsop87.LnVsop(5.65091E-6, 3.87400932383, 224.3447957019), new Vsop87.LnVsop(4.266E-6, 4.73158166033, 71.8126531507), new Vsop87.LnVsop(3.47745E-6, 2.45368882357, 9.5612275556), new Vsop87.LnVsop(3.32699E-6, 2.55525645638, 148.0787244263), new Vsop87.LnVsop(3.17054E-6, 5.57858240166, 52.6901980395), new Vsop87.LnVsop(1.79897E-6, 5.68365861477, 12.5301729722), new Vsop87.LnVsop(1.71119E-6, 3.00040981195, 78.7137518304), new Vsop87.LnVsop(2.05579E-6, 2.36242761009, 2.4476805548), new Vsop87.LnVsop(1.58038E-6, 2.90930836614, 0.9632078465), new Vsop87.LnVsop(1.8909E-6, 4.20258063269, 56.6223513026), new Vsop87.LnVsop(2.02696E-6, 0.34360451816, 151.0476698429), new Vsop87.LnVsop(1.54762E-6, 5.59005854748, 4.4534181249), new Vsop87.LnVsop(1.43472E-6, 2.59047613814, 62.2514255951), new Vsop87.LnVsop(1.51459E-6, 2.93993108236, 77.7505439839), new Vsop87.LnVsop(1.53561E-6, 4.65220425575, 35.1640902212), new Vsop87.LnVsop(1.21462E-6, 4.14937021194, 127.4717966068), new Vsop87.LnVsop(1.15538E-6, 3.73245717203, 65.2203710117), new Vsop87.LnVsop(1.02213E-6, 4.18917777961, 145.6310438715), new Vsop87.LnVsop(1.01894E-6, 6.03382617339, 0.1118745846), new Vsop87.LnVsop(8.8409E-7, 3.99004756152, 18.1592472647), new Vsop87.LnVsop(8.7591E-7, 6.15639888455, 202.2533951741), new Vsop87.LnVsop(8.0591E-7, 2.64095955809, 22.0914005278), new Vsop87.LnVsop(7.2047E-7, 6.04586846354, 70.3281804424), new Vsop87.LnVsop(6.8727E-7, 4.05075598128, 77.962992305), new Vsop87.LnVsop(5.9329E-7, 3.70581611259, 67.6680515665), new Vsop87.LnVsop(4.7388E-7, 3.54091852775, 351.8165923087), new Vsop87.LnVsop(4.2712E-7, 5.72066604839, 5.4166259714), new Vsop87.LnVsop(4.4405E-7, 5.91042456876, 7.1135470008), new Vsop87.LnVsop(3.5784E-7, 3.29585017124, 8.0767548473), new Vsop87.LnVsop(3.5724E-7, 3.32933903151, 71.6002048296), new Vsop87.LnVsop(3.6081E-7, 5.89881403933, 33.6796175129), new Vsop87.LnVsop(4.1676E-7, 4.94718694607, 222.8603229936), new Vsop87.LnVsop(3.1215E-7, 5.48938304422, 160.6088973985), new Vsop87.LnVsop(3.1453E-7, 5.62016551866, 984.6003316219), new Vsop87.LnVsop(3.5171E-7, 5.07842850969, 38.1330356378), new Vsop87.LnVsop(3.5543E-7, 0.0550243966, 299.1263942692), new Vsop87.LnVsop(3.081E-7, 5.49604033608, 59.8037450403), new Vsop87.LnVsop(2.8883E-7, 4.51759500034, 84.3428261229), new Vsop87.LnVsop(2.6705E-7, 5.53637447019, 131.4039498699), new Vsop87.LnVsop(2.9956E-7, 1.66046193211, 447.7958195265), new Vsop87.LnVsop(2.9206E-7, 1.14722620686, 462.0229135281), new Vsop87.LnVsop(2.5811E-7, 4.99049651973, 137.0330241624), new Vsop87.LnVsop(2.5474E-7, 5.73884476629, 380.12776796), new Vsop87.LnVsop(2.1683E-7, 2.80603505468, 69.3649725959), new Vsop87.LnVsop(2.3016E-7, 2.24983506758, 111.4301614968), new Vsop87.LnVsop(1.9228E-7, 3.55594434001, 54.1746707478), new Vsop87.LnVsop(2.1696E-7, 0.9887213968, 213.299095438), new Vsop87.LnVsop(1.9457E-7, 1.86460184285, 108.4612160802), new Vsop87.LnVsop(1.614E-7, 3.10230818045, 14.977853527), new Vsop87.LnVsop(1.3138E-7, 1.95065801902, 87.3117715395), new Vsop87.LnVsop(1.3904E-7, 1.5420709382, 340.7708920448), new Vsop87.LnVsop(1.3543E-7, 4.38430774439, 5.9378908332), new Vsop87.LnVsop(1.6493E-7, 2.80104132725, 225.8292684102), new Vsop87.LnVsop(1.3111E-7, 5.88308816286, 6.2197751235), new Vsop87.LnVsop(1.1811E-7, 0.32606713574, 35.4247226521), new Vsop87.LnVsop(1.2471E-7, 0.32808369953, 51.2057253312), new Vsop87.LnVsop(1.0981E-7, 1.6929966677, 45.5766510387), new Vsop87.LnVsop(1.0888E-7, 5.970420479, 265.9892934775), new Vsop87.LnVsop(1.1433E-7, 3.37877229066, 72.3339180125), new Vsop87.LnVsop(1.2003E-7, 3.60398124894, 269.9214467406), new Vsop87.LnVsop(1.2936E-7, 5.38263455371, 152.5321425512), new Vsop87.LnVsop(1.1674E-7, 1.74413259892, 79.2350166922), new Vsop87.LnVsop(1.0446E-7, 4.16878885118, 24.3790223882), new Vsop87.LnVsop(1.0634E-7, 3.06878261442, 284.1485407422), new Vsop87.LnVsop(9.674E-8, 5.51339189448, 153.4953503977), new Vsop87.LnVsop(9.59E-8, 0.49485192598, 209.3669421749), new Vsop87.LnVsop(9.269E-8, 3.5458995448, 41.6444977756), new Vsop87.LnVsop(9.568E-8, 5.59970406046, 82.8583534146), new Vsop87.LnVsop(9.31E-8, 4.49468477512, 20.6069278195), new Vsop87.LnVsop(9.632E-8, 1.00932793597, 68.8437077341), new Vsop87.LnVsop(8.745E-8, 3.91021963381, 60.7669528868), new Vsop87.LnVsop(1.0176E-7, 3.51758777802, 529.6909650946), new Vsop87.LnVsop(1.0048E-7, 4.64919764888, 77.2292791221), new Vsop87.LnVsop(8.679E-8, 1.96792212254, 195.1398481733), new Vsop87.LnVsop(8.387E-8, 4.41835912213, 134.5853436076), new Vsop87.LnVsop(7.983E-8, 5.35924979986, 75.7448064138), new Vsop87.LnVsop(9.263E-8, 3.95182354442, 39.6175083461), new Vsop87.LnVsop(7.594E-8, 5.77307721631, 73.8183907208), new Vsop87.LnVsop(7.713E-8, 4.44174669087, 14.0146456805), new Vsop87.LnVsop(7.49E-8, 2.17900285342, 145.1097790097), new Vsop87.LnVsop(7.873E-8, 5.74835382023, 184.7272873558), new Vsop87.LnVsop(7.688E-8, 2.41795807218, 146.594251718), new Vsop87.LnVsop(6.438E-8, 0.84540553248, 32.1951448046), new Vsop87.LnVsop(6.256E-8, 2.17063033953, 74.8934731519), new Vsop87.LnVsop(7.937E-8, 0.1717266497, 120.358249606), new Vsop87.LnVsop(7.02E-8, 4.12096862702, 191.2076949102), new Vsop87.LnVsop(6.862E-8, 2.13341287037, 116.4260963429), new Vsop87.LnVsop(5.208E-8, 3.11117214481, 106.9767433719), new Vsop87.LnVsop(4.811E-8, 2.25140758551, 46.2097904851), new Vsop87.LnVsop(4.566E-8, 3.45427623308, 0.7507595254), new Vsop87.LnVsop(4.473E-8, 3.94632863732, 6.592282139), new Vsop87.LnVsop(5.202E-8, 1.15450734319, 112.9146342051), new Vsop87.LnVsop(4.323E-8, 5.15540388592, 144.1465711632), new Vsop87.LnVsop(4.746E-8, 5.18244413774, 81.0013736908), new Vsop87.LnVsop(4.232E-8, 0.2192191002, 92.940845832), new Vsop87.LnVsop(4.323E-8, 2.52442111234, 99.1606209555), new Vsop87.LnVsop(3.879E-8, 2.78711315762, 565.1156877467), new Vsop87.LnVsop(4.332E-8, 5.91118459987, 221.3758502853), new Vsop87.LnVsop(3.801E-8, 0.75135339336, 58.1068240109), new Vsop87.LnVsop(3.812E-8, 3.23225846555, 479.2883889155), new Vsop87.LnVsop(3.656E-8, 5.27986185627, 66.9172920411), new Vsop87.LnVsop(3.811E-8, 4.92593102646, 125.9873238985), new Vsop87.LnVsop(4.172E-8, 2.28697665136, 109.9456887885), new Vsop87.LnVsop(3.472E-8, 2.95403921517, 74.6697239827), new Vsop87.LnVsop(3.501E-8, 4.89811329155, 28.3111756513), new Vsop87.LnVsop(4.495E-8, 4.1545333789, 344.7030453079), new Vsop87.LnVsop(4.258E-8, 2.68419933901, 7.8643065262), new Vsop87.LnVsop(3.456E-8, 0.02638325764, 140.001969579), new Vsop87.LnVsop(4.181E-8, 1.90641663083, 277.0349937414), new Vsop87.LnVsop(3.644E-8, 5.32238666094, 408.4389436113), new Vsop87.LnVsop(3.205E-8, 0.05087987138, 220.4126424388), new Vsop87.LnVsop(3.19E-8, 1.48430670387, 128.9562693151), new Vsop87.LnVsop(3.901E-8, 6.25926496244, 0.8937718773), new Vsop87.LnVsop(3.788E-8, 0.03327505225, 152.7445908723), new Vsop87.LnVsop(3.2E-8, 0.52009458683, 2.2876218604), new Vsop87.LnVsop(3.011E-8, 1.93475294714, 80.1982245387), new Vsop87.LnVsop(4.054E-8, 5.23320423468, 96.8729990951), new Vsop87.LnVsop(3.798E-8, 4.97868021019, 36.6485629295), new Vsop87.LnVsop(3.895E-8, 1.10480659598, 297.6419215609), new Vsop87.LnVsop(3.295E-8, 4.80719384894, 422.6660376129), new Vsop87.LnVsop(3.192E-8, 2.81905779664, 453.424893819), new Vsop87.LnVsop(2.804E-8, 6.19069392998, 135.5485514541), new Vsop87.LnVsop(3.469E-8, 5.88266049174, 16.6747745564), new Vsop87.LnVsop(2.785E-8, 1.35852942533, 404.5067903482), new Vsop87.LnVsop(2.892E-8, 0.53676605577, 159.1244246902), new Vsop87.LnVsop(3.232E-8, 1.54622440929, 23.5758732361), new Vsop87.LnVsop(2.958E-8, 6.25751544465, 456.3938392356), new Vsop87.LnVsop(2.542E-8, 1.85372598824, 490.3340891794), new Vsop87.LnVsop(2.547E-8, 5.19766530615, 173.9422195228), new Vsop87.LnVsop(3.118E-8, 6.10201148242, 142.4496501338), new Vsop87.LnVsop(2.762E-8, 3.51066557656, 288.0806940053), new Vsop87.LnVsop(2.793E-8, 3.90482859776, 358.9301393095), new Vsop87.LnVsop(2.958E-8, 5.31404018803, 55.1378785943), new Vsop87.LnVsop(2.387E-8, 1.31646029756, 211.8146227297), new Vsop87.LnVsop(2.413E-8, 4.38647851761, 60.5545045657), new Vsop87.LnVsop(2.285E-8, 2.31869038469, 31.492569389), new Vsop87.LnVsop(2.366E-8, 2.21968144549, 66.70484372), new Vsop87.LnVsop(2.779E-8, 4.72642945119, 186.2117600641), new Vsop87.LnVsop(2.27E-8, 3.49350071105, 206.1855484372), new Vsop87.LnVsop(2.224E-8, 0.41045917285, 81.3738807063), new Vsop87.LnVsop(2.196E-8, 0.76298510234, 17.5261078183), new Vsop87.LnVsop(2.115E-8, 3.58641580944, 333.657345044), new Vsop87.LnVsop(2.575E-8, 0.73175693995, 200.7689224658), new Vsop87.LnVsop(2.158E-8, 2.61976125405, 13.3333221243), new Vsop87.LnVsop(2.041E-8, 6.27470432139, 98.8999885246), new Vsop87.LnVsop(2.212E-8, 2.36295359318, 347.8844390456), new Vsop87.LnVsop(2.183E-8, 2.4900467683, 76.4785195967), new Vsop87.LnVsop(2.032E-8, 1.6748491158, 235.3904959658), new Vsop87.LnVsop(2.226E-8, 5.9732773815, 1514.2912967165), new Vsop87.LnVsop(1.858E-8, 2.20139550864, 203.7378678824), new Vsop87.LnVsop(2.127E-8, 2.52590780597, 373.9079928365), new Vsop87.LnVsop(1.865E-8, 4.9820720428, 5.1078094307), new Vsop87.LnVsop(1.822E-8, 2.44474441003, 55.6591434561), new Vsop87.LnVsop(2.037E-8, 5.80360322726, 146.3818033969), new Vsop87.LnVsop(1.894E-8, 4.32787921047, 49.5088043018), new Vsop87.LnVsop(1.841E-8, 3.35082910127, 143.6253063014), new Vsop87.LnVsop(1.717E-8, 3.95035994581, 24.1183899573), new Vsop87.LnVsop(1.684E-8, 1.28092098597, 103.0927742186), new Vsop87.LnVsop(2.042E-8, 5.48498644784, 373.0142209592), new Vsop87.LnVsop(1.72E-8, 2.35857527806, 1.6445314027), new Vsop87.LnVsop(1.637E-8, 2.99504798037, 391.1734682239), new Vsop87.LnVsop(1.605E-8, 0.97423033751, 977.4867846211), new Vsop87.LnVsop(1.678E-8, 4.97988460684, 387.2413149608), new Vsop87.LnVsop(1.52E-8, 3.15010457259, 7.4223635415), new Vsop87.LnVsop(1.505E-8, 2.89631333643, 19.643719973), new Vsop87.LnVsop(1.574E-8, 1.61508712335, 991.7138786227), new Vsop87.LnVsop(1.509E-8, 3.32685682695, 909.8187330546), new Vsop87.LnVsop(1.674E-8, 4.30506338212, 305.3461693927), new Vsop87.LnVsop(1.412E-8, 4.53556726512, 81.8951455681), new Vsop87.LnVsop(1.375E-8, 2.49046817916, 426.598190876), new Vsop87.LnVsop(1.373E-8, 5.7533763715, 19.1224551112), new Vsop87.LnVsop(1.34E-8, 3.94224997586, 61.2882177486), new Vsop87.LnVsop(1.367E-8, 4.39913585014, 27.0873353739), new Vsop87.LnVsop(1.385E-8, 2.20171302118, 67.3592350258), new Vsop87.LnVsop(1.351E-8, 4.36029315547, 70.1157321213), new Vsop87.LnVsop(1.304E-8, 2.79975533399, 25.6028626656), new Vsop87.LnVsop(1.313E-8, 3.73575380324, 628.8515860501), new Vsop87.LnVsop(1.338E-8, 4.92441744235, 617.8058857862), new Vsop87.LnVsop(1.361E-8, 0.72643457214, 546.956440482), new Vsop87.LnVsop(1.273E-8, 3.20493914871, 92.0470739547), new Vsop87.LnVsop(1.228E-8, 5.92585113207, 415.5524906121), new Vsop87.LnVsop(1.242E-8, 4.09549754457, 443.8636662634), new Vsop87.LnVsop(1.552E-8, 5.05296247763, 10.2949407385), new Vsop87.LnVsop(1.21E-8, 4.83276785889, 100.3844612329), new Vsop87.LnVsop(1.236E-8, 4.30781434404, 67.8804998876), new Vsop87.LnVsop(1.173E-8, 5.32389543861, 17.2654753874), new Vsop87.LnVsop(1.352E-8, 3.55425818464, 230.5645708254), new Vsop87.LnVsop(1.437E-8, 6.1841765396, 14.2270940016), new Vsop87.LnVsop(1.248E-8, 0.16711396982, 29.2049475286), new Vsop87.LnVsop(1.169E-8, 3.31424750673, 44.7253177768), new Vsop87.LnVsop(1.259E-8, 1.88793196065, 0.6543913058), new Vsop87.LnVsop(1.311E-8, 5.72020892609, 329.7251917809), new Vsop87.LnVsop(1.155E-8, 2.04134400388, 30.7106720963), new Vsop87.LnVsop(1.101E-8, 1.5235036511, 157.6399519819), new Vsop87.LnVsop(1.07E-8, 2.89562175028, 543.0242872189), new Vsop87.LnVsop(1.121E-8, 4.49662162318, 162.0933701068), new Vsop87.LnVsop(1.417E-8, 2.04676765553, 181.7583419392), new Vsop87.LnVsop(1.258E-8, 0.23621358146, 561.1835344836), new Vsop87.LnVsop(1.255E-8, 1.26185998194, 155.7829722581), new Vsop87.LnVsop(1.04E-8, 2.92622745204, 241.6102710893), new Vsop87.LnVsop(1.057E-8, 3.26987298875, 28.5718080822), new Vsop87.LnVsop(1.122E-8, 1.06425470357, 88.1149206916), new Vsop87.LnVsop(1.174E-8, 5.28477501625, 300.6108669775), new Vsop87.LnVsop(1.229E-8, 3.103550368, 454.9093665273), new Vsop87.LnVsop(1.065E-8, 0.29391740657, 58.319272332), new Vsop87.LnVsop(9.6E-9, 5.20482964431, 42.5382696529), new Vsop87.LnVsop(1.015E-8, 4.37032150952, 13.4933808187), new Vsop87.LnVsop(9.82E-9, 4.89018485859, 465.9550667912), new Vsop87.LnVsop(8.89E-9, 3.09788627376, 110.2063212194), new Vsop87.LnVsop(1.102E-8, 1.70896942951, 43.1289704839), new Vsop87.LnVsop(8.67E-9, 4.22078052532, 20.4468691251), new Vsop87.LnVsop(8.97E-9, 0.17179849041, 604.4725636619), new Vsop87.LnVsop(9.37E-9, 0.09295857555, 273.1028404783), new Vsop87.LnVsop(8.29E-9, 5.25281847981, 472.1748419147), new Vsop87.LnVsop(8.64E-9, 4.75896276795, 33.1371007917), new Vsop87.LnVsop(8.77E-9, 4.34963188052, 105.4922706636), new Vsop87.LnVsop(8.82E-9, 0.53648210499, 80.7194894005), new Vsop87.LnVsop(9.66E-9, 2.82647414963, 41.1019810544), new Vsop87.LnVsop(8.05E-9, 3.53324257123, 39.3568759152), new Vsop87.LnVsop(1.087E-8, 2.79964970506, 48.7580447764), new Vsop87.LnVsop(8.61E-9, 4.69150625691, 1059.3819301892), new Vsop87.LnVsop(8.46E-9, 1.65248920316, 554.0699874828), new Vsop87.LnVsop(8.91E-9, 2.85006063739, 32.2433289144), new Vsop87.LnVsop(9.38E-9, 1.90783329336, 259.5088859231), new Vsop87.LnVsop(8.76E-9, 0.83921717739, 4.7353024152), new Vsop87.LnVsop(9.64E-9, 1.56609888164, 227.3137411185), new Vsop87.LnVsop(7.07E-9, 6.16918394997, 3.6233367224), new Vsop87.LnVsop(6.89E-9, 0.64981694232, 88.7962442478), new Vsop87.LnVsop(8.3E-9, 0.39292254125, 378.6432952517), new Vsop87.LnVsop(7.08E-9, 5.49627918383, 558.0021407459), new Vsop87.LnVsop(7.87E-9, 1.95609328363, 16.4623262353), new Vsop87.LnVsop(9.01E-9, 1.83265668559, 258.8757464767), new Vsop87.LnVsop(7.86E-9, 2.26160622294, 16.04163511), new Vsop87.LnVsop(6.4E-9, 4.15920545966, 141.6988906084), new Vsop87.LnVsop(6.72E-9, 1.00050394612, 522.5774180938), new Vsop87.LnVsop(6.25E-9, 5.82930714013, 89.7594520943), new Vsop87.LnVsop(6.19E-9, 4.31040053451, 455.8725743738), new Vsop87.LnVsop(6.19E-9, 4.77556598161, 453.9461586808), new Vsop87.LnVsop(6.66E-9, 2.80724719033, 68.5618234438), new Vsop87.LnVsop(7.54E-9, 4.22436113545, 486.4019359163), new Vsop87.LnVsop(6.65E-9, 0.76096162867, 120.9913890524), new Vsop87.LnVsop(6.36E-9, 5.75172788892, 119.5069163441), new Vsop87.LnVsop(5.95E-9, 3.92147529886, 25.2727942655), new Vsop87.LnVsop(6.29E-9, 1.79018286231, 440.6822725257), new Vsop87.LnVsop(7.19E-9, 4.27356498725, 50.4025761791), new Vsop87.LnVsop(5.98E-9, 0.22963306541, 117.9105690512), new Vsop87.LnVsop(7.06E-9, 0.45734010595, 536.8045120954), new Vsop87.LnVsop(6.91E-9, 6.14152846301, 258.0244132148), new Vsop87.LnVsop(5.88E-9, 5.49070240544, 767.3690829208), new Vsop87.LnVsop(5.8E-9, 0.63199844828, 95.3885263868), new Vsop87.LnVsop(7.39E-9, 1.12968525578, 129.9194771616), new Vsop87.LnVsop(6.25E-9, 0.60601623675, 152.0108776894), new Vsop87.LnVsop(6.84E-9, 3.48227286692, 835.0371344873), new Vsop87.LnVsop(6.57E-9, 0.08702780614, 114.3991069134), new Vsop87.LnVsop(6.11E-9, 4.15939229748, 154.0166152595), new Vsop87.LnVsop(5.92E-9, 1.93836345843, 106.2741679563), new Vsop87.LnVsop(5.28E-9, 5.94363613171, 518.6452648307), new Vsop87.LnVsop(5.08E-9, 1.4393186126, 218.9281697305), new Vsop87.LnVsop(5.05E-9, 4.39807654944, 121.8427223143), new Vsop87.LnVsop(5.26E-9, 0.30539221936, 756.3233826569), new Vsop87.LnVsop(4.92E-9, 0.02248323091, 106.0135355254), new Vsop87.LnVsop(4.83E-9, 0.69881109315, 264.5048207692), new Vsop87.LnVsop(4.83E-9, 3.75988497269, 342.2553647531), new Vsop87.LnVsop(6.31E-9, 2.23161489343, 218.4069048687), new Vsop87.LnVsop(5.87E-9, 0.18557468628, 458.090760265), new Vsop87.LnVsop(5.82E-9, 6.01383333156, 47.061123747), new Vsop87.LnVsop(5.66E-9, 1.9438866407, 699.7010313543), new Vsop87.LnVsop(4.69E-9, 2.00109396664, 275.5505210331), new Vsop87.LnVsop(4.69E-9, 0.07681059856, 216.4804891757), new Vsop87.LnVsop(4.65E-9, 4.97885409598, 458.8415197904), new Vsop87.LnVsop(4.5E-9, 2.93431036585, 692.5874843535), new Vsop87.LnVsop(5.46E-9, 2.42033648569, 339.2864193365), new Vsop87.LnVsop(5.43E-9, 2.61197344648, 451.7279727896), new Vsop87.LnVsop(4.33E-9, 2.83073694779, 32.7164096664), new Vsop87.LnVsop(4.97E-9, 4.22419242251, 166.828672522), new Vsop87.LnVsop(4.36E-9, 2.61151229793, 685.4739373527), new Vsop87.LnVsop(5.01E-9, 0.18281416681, 331.3215390738), new Vsop87.LnVsop(4.47E-9, 4.51662766639, 142.1408335931), new Vsop87.LnVsop(4.19E-9, 1.92148690569, 148.5999892881), new Vsop87.LnVsop(4.66E-9, 0.96357284606, 760.25553592), new Vsop87.LnVsop(5.54E-9, 5.40626840965, 278.5194664497), new Vsop87.LnVsop(4.1E-9, 4.63543184365, 40.1600250673), new Vsop87.LnVsop(4.45E-9, 1.00949029615, 468.2426886516), new Vsop87.LnVsop(4.15E-9, 5.68097308082, 92.3077063856), new Vsop87.LnVsop(3.97E-9, 3.98144952901, 31.2319369581), new Vsop87.LnVsop(4.21E-9, 5.47567810199, 104.0077979553), new Vsop87.LnVsop(4.03E-9, 5.19002062014, 22.633917249), new Vsop87.LnVsop(4.28E-9, 3.48886570846, 180.2738692309), new Vsop87.LnVsop(4.12E-9, 1.02398688739, 469.1364605289), new Vsop87.LnVsop(3.85E-9, 3.7901438429, 450.9772132642), new Vsop87.LnVsop(4.24E-9, 2.40007672624, 39.0962434843), new Vsop87.LnVsop(4.69E-9, 2.07500437056, 296.1574488526), new Vsop87.LnVsop(3.67E-9, 5.39331524988, 874.3940104025), new Vsop87.LnVsop(4.39E-9, 5.75684595296, 183.2428146475), new Vsop87.LnVsop(4.4E-9, 0.36377653224, 367.9701020033), new Vsop87.LnVsop(4.09E-9, 4.21847176009, 181.0557665236), new Vsop87.LnVsop(3.67E-9, 0.97754899263, 113.8778420516), new Vsop87.LnVsop(4.27E-9, 3.32207591906, 114.9416236346), new Vsop87.LnVsop(3.61E-9, 2.87413243525, 384.0599212231), new Vsop87.LnVsop(3.88E-9, 5.441319019, 26.0235537909), new Vsop87.LnVsop(3.61E-9, 0.18436557007, 184.0941479094), new Vsop87.LnVsop(3.97E-9, 4.78908291565, 268.4369740323), new Vsop87.LnVsop(3.75E-9, 5.66345783317, 353.301065017), new Vsop87.LnVsop(4.2E-9, 3.84692082861, 254.9435932136), new Vsop87.LnVsop(3.56E-9, 2.4675080892, 210.3301500214), new Vsop87.LnVsop(3.52E-9, 0.124985429, 142.6620984549), new Vsop87.LnVsop(3.67E-9, 2.92343694465, 291.262087743), new Vsop87.LnVsop(3.95E-9, 4.76556910944, 109.3125493421), new Vsop87.LnVsop(3.49E-9, 0.36426017087, 46.470422916), new Vsop87.LnVsop(3.58E-9, 2.75549207793, 295.1942410061), new Vsop87.LnVsop(4.12E-9, 2.43295972201, 483.2205421786), new Vsop87.LnVsop(3.52E-9, 1.24968669034, 97.4155158163), new Vsop87.LnVsop(4.42E-9, 1.88628680612, 123.5396433437), new Vsop87.LnVsop(3.85E-9, 3.26394747049, 79.4474650133), new Vsop87.LnVsop(4.06E-9, 2.53016887679, 255.0554677982), new Vsop87.LnVsop(3.7E-9, 4.14864372053, 282.6640680339), new Vsop87.LnVsop(3.47E-9, 1.94674357151, 173.6815870919), new Vsop87.LnVsop(3.4E-9, 1.34666529473, 34.2008823747), new Vsop87.LnVsop(3.72E-9, 1.86781055268, 207.8824694666), new Vsop87.LnVsop(3.53E-9, 2.64173549643, 162.8965192589), new Vsop87.LnVsop(3.7E-9, 1.88031244406, 192.6921676185), new Vsop87.LnVsop(3.58E-9, 4.58259834086, 149.6750717192), new Vsop87.LnVsop(3.69E-9, 2.15183429984, 555.5544601911), new Vsop87.LnVsop(3.29E-9, 0.89991825345, 905.8865797915), new Vsop87.LnVsop(3.22E-9, 3.40065562385, 309.2783226558), new Vsop87.LnVsop(3.61E-9, 2.19153615911, 562.6680071919), new Vsop87.LnVsop(3.35E-9, 5.03174519184, 189.7232222019), new Vsop87.LnVsop(3.3E-9, 4.23716253952, 75.3028634291), new Vsop87.LnVsop(3.66E-9, 1.74722181798, 545.4719677737), new Vsop87.LnVsop(3.09E-9, 4.56448107045, 350.3321196004), new Vsop87.LnVsop(3.17E-9, 0.98960192882, 335.1418177523), new Vsop87.LnVsop(3.59E-9, 5.76812959678, 916.9322800554), new Vsop87.LnVsop(2.95E-9, 1.33754315792, 150.5264049811), new Vsop87.LnVsop(3.29E-9, 1.82999432252, 706.8145783551), new Vsop87.LnVsop(3.05E-9, 2.85945986335, 267.4737661858), new Vsop87.LnVsop(3.84E-9, 4.2560215439, 198.321241911), new Vsop87.LnVsop(2.96E-9, 1.71949913712, 394.3548619616), new Vsop87.LnVsop(2.85E-9, 0.69559923528, 312.4597163935), new Vsop87.LnVsop(3.11E-9, 1.47691197071, 375.3924655448), new Vsop87.LnVsop(3.0E-9, 5.09637659621, 376.1956146969), new Vsop87.LnVsop(3.59E-9, 2.54874884785, 9988.9407505091), new Vsop87.LnVsop(2.83E-9, 3.06617758884, 193.655375465), new Vsop87.LnVsop(3.0E-9, 5.92918355218, 124.2904028691), new Vsop87.LnVsop(2.9E-9, 4.90172200702, 681.5417840896), new Vsop87.LnVsop(2.76E-9, 4.65186244616, 332.1728723357), new Vsop87.LnVsop(2.85E-9, 4.83606028553, 68.1893164283), new Vsop87.LnVsop(3.1E-9, 3.75000484412, 253.5709950899), new Vsop87.LnVsop(2.94E-9, 0.92142971378, 610.6923387854), new Vsop87.LnVsop(3.04E-9, 5.60868779754, 271.4059194489), new Vsop87.LnVsop(3.0E-9, 2.69560181941, 548.4409131903), new Vsop87.LnVsop(2.66E-9, 1.57547215891, 369.0820676961), new Vsop87.LnVsop(2.7E-9, 2.12904548682, 778.4147831847), new Vsop87.LnVsop(2.78E-9, 3.38349188253, 346.3999663373), new Vsop87.LnVsop(2.88E-9, 2.78232740152, 1812.5239191084), new Vsop87.LnVsop(2.74E-9, 4.87674891727, 831.1049812242), new Vsop87.LnVsop(3.06E-9, 5.1589262602, 285.6330134505), new Vsop87.LnVsop(2.6E-9, 0.96985733128, 90.8232336773), new Vsop87.LnVsop(2.89E-9, 3.99815838405, 451.9404211107), new Vsop87.LnVsop(3.41E-9, 3.64288743408, 187.6962327724), new Vsop87.LnVsop(2.62E-9, 5.24129067312, 94.4253185403), new Vsop87.LnVsop(2.55E-9, 5.62384661312, 691.1030116452), new Vsop87.LnVsop(2.78E-9, 2.76955704952, 657.1627617014), new Vsop87.LnVsop(3.14E-9, 1.67255558365, 25.8634950965), new Vsop87.LnVsop(2.52E-9, 1.20515376123, 134.0640787458), new Vsop87.LnVsop(2.7E-9, 5.95275530301, 362.8622925726), new Vsop87.LnVsop(2.5E-9, 1.95456834458, 497.4476361802), new Vsop87.LnVsop(3.31E-9, 2.03342131435, 445.3481389717), new Vsop87.LnVsop(2.55E-9, 1.8286784763, 180.1619946463), new Vsop87.LnVsop(2.8E-9, 1.1541422757, 986.0848043302), new Vsop87.LnVsop(2.47E-9, 5.99403279584, 147.1155165798), new Vsop87.LnVsop(2.91E-9, 2.41284857072, 381.6122406683), new Vsop87.LnVsop(2.51E-9, 5.78452299837, 630.3360587584), new Vsop87.LnVsop(2.97E-9, 1.5777424273, 49.7212526229), new Vsop87.LnVsop(2.44E-9, 4.93404985518, 107.4980082337), new Vsop87.LnVsop(2.49E-9, 5.56442927723, 133.1008708993), new Vsop87.LnVsop(2.4E-9, 2.84851616507, 44.0921783304), new Vsop87.LnVsop(2.48E-9, 1.97763922353, 593.426863398), new Vsop87.LnVsop(2.33E-9, 0.16241159105, 124.5028511902), new Vsop87.LnVsop(2.38E-9, 4.32756553343, 823.9914342234), new Vsop87.LnVsop(2.49E-9, 2.86247259468, 226.7924762567), new Vsop87.LnVsop(2.61E-9, 2.27307279052, 73.0846775379), new Vsop87.LnVsop(2.33E-9, 2.20084586652, 894.8408795276), new Vsop87.LnVsop(2.29E-9, 6.25761030439, 122.4758617607), new Vsop87.LnVsop(2.44E-9, 5.76540363539, 135.336103133), new Vsop87.LnVsop(3.06E-9, 1.55862796103, 3191.0492295652), new Vsop87.LnVsop(2.88E-9, 5.81344092057, 902.7051860538), new Vsop87.LnVsop(3.02E-9, 5.76656213355, 219.891377577), new Vsop87.LnVsop(2.47E-9, 4.80414025079, 204.7010757289), new Vsop87.LnVsop(2.64E-9, 0.01674333019, 294.6729761443), new Vsop87.LnVsop(2.45E-9, 5.89659082767, 507.5995645668), new Vsop87.LnVsop(2.53E-9, 0.68155783879, 43.2890291783), new Vsop87.LnVsop(2.59E-9, 0.32203683101, 105.380396079), new Vsop87.LnVsop(2.4E-9, 1.26452469031, 559.6990617753), new Vsop87.LnVsop(2.37E-9, 2.9026340439, 156.1554792736), new Vsop87.LnVsop(2.99E-9, 3.55325980025, 397.3932433474), new Vsop87.LnVsop(2.44E-9, 1.77778279869, 411.620337349), new Vsop87.LnVsop(2.11E-9, 0.44507165688, 597.3590166611), new Vsop87.LnVsop(2.09E-9, 6.2774334636, 470.6903692064), new Vsop87.LnVsop(2.26E-9, 2.98952389106, 25.1297819136), new Vsop87.LnVsop(2.93E-9, 4.38922897212, 334.2904844904), new Vsop87.LnVsop(2.78E-9, 3.98468567421, 477.8039162072), new Vsop87.LnVsop(2.06E-9, 1.00879014806, 175.1660598002), new Vsop87.LnVsop(2.46E-9, 2.70487794377, 227.5261894396), new Vsop87.LnVsop(2.37E-9, 2.74955785783, 446.3113468182), new Vsop87.LnVsop(2.42E-9, 1.94330310979, 228.276948965), new Vsop87.LnVsop(2.2E-9, 2.21089026533, 460.5384408198), new Vsop87.LnVsop(2.47E-9, 3.57103210654, 372.4235201282), new Vsop87.LnVsop(2.79E-9, 1.3658752909, 118.8737768977), new Vsop87.LnVsop(2.18E-9, 3.73553622758, 449.2802922348), new Vsop87.LnVsop(2.16E-9, 4.40353401308, 10063.7223490764), new Vsop87.LnVsop(2.3E-9, 4.66927758266, 535.3200393871), new Vsop87.LnVsop(1.97E-9, 2.20805345461, 473.068613792), new Vsop87.LnVsop(2.29E-9, 3.19497593427, 463.5073862364), new Vsop87.LnVsop(2.01E-9, 5.34615119244, 480.7728616238), new Vsop87.LnVsop(1.93E-9, 6.19624242617, 820.0592809603), new Vsop87.LnVsop(2.42E-9, 1.96036147638, 988.532484885), new Vsop87.LnVsop(1.9E-9, 3.13243705705, 136.0698163159), new Vsop87.LnVsop(1.93E-9, 4.07671504865, 143.9341228421), new Vsop87.LnVsop(2.02E-9, 1.83078684759, 72.4939767069), new Vsop87.LnVsop(2.28E-9, 3.34903021483, 95.9792272178), new Vsop87.LnVsop(2.08E-9, 4.8113324768, 377.1588225434), new Vsop87.LnVsop(2.0E-9, 0.61839132774, 236.8749686741), new Vsop87.LnVsop(2.35E-9, 3.6743683926, 838.218528225), new Vsop87.LnVsop(1.93E-9, 2.15481780749, 74.9416572617), new Vsop87.LnVsop(1.87E-9, 2.81310936004, 572.2292347475), new Vsop87.LnVsop(2.13E-9, 1.61813973088, 42.5864537627), new Vsop87.LnVsop(2.07E-9, 6.03862516281, 524.0618908021), new Vsop87.LnVsop(2.03E-9, 5.04988207039, 457.8783119439), new Vsop87.LnVsop(2.03E-9, 1.0475888918, 409.9234163196), new Vsop87.LnVsop(1.88E-9, 2.07982369812, 976.0023119128), new Vsop87.LnVsop(2.1E-9, 5.85785362661, 196.6243208816), new Vsop87.LnVsop(1.92E-9, 3.61383045656, 993.198351331), new Vsop87.LnVsop(2.09E-9, 3.17349988395, 1587.5884225755), new Vsop87.LnVsop(1.84E-9, 1.85051728434, 908.3342603463), new Vsop87.LnVsop(1.92E-9, 5.22508686633, 450.4559484024), new Vsop87.LnVsop(1.8E-9, 5.28618792228, 21.1976286505), new Vsop87.LnVsop(2.13E-9, 5.58315163677, 538.2889848037), new Vsop87.LnVsop(1.76E-9, 5.03044627538, 170.7608257851), new Vsop87.LnVsop(2.03E-9, 5.80938645616, 624.919432787), new Vsop87.LnVsop(1.8E-9, 2.51990272877, 1044.4040766622), new Vsop87.LnVsop(1.79E-9, 6.05515483358, 525.7588118315), new Vsop87.LnVsop(1.75E-9, 1.96452622716, 520.129737539), new Vsop87.LnVsop(1.99E-9, 0.52713547564, 457.3570470821), new Vsop87.LnVsop(1.85E-9, 2.84806428136, 1293.8786542777), new Vsop87.LnVsop(1.75E-9, 1.54398883192, 15.1903018481), new Vsop87.LnVsop(1.74E-9, 4.6639424451, 9947.0556815321), new Vsop87.LnVsop(1.85E-9, 5.46594207951, 981.6313862053), new Vsop87.LnVsop(1.71E-9, 5.673899584, 114.1384744825), new Vsop87.LnVsop(1.82E-9, 1.04937888593, 532.6599105112), new Vsop87.LnVsop(1.78E-9, 0.51114232798, 172.1971143836), new Vsop87.LnVsop(1.69E-9, 3.11804373794, 978.9712573294), new Vsop87.LnVsop(1.76E-9, 3.74915826552, 920.8644333185), new Vsop87.LnVsop(1.8E-9, 1.07197408549, 586.3133163972), new Vsop87.LnVsop(1.66E-9, 1.9368297112, 449.4927405559), new Vsop87.LnVsop(1.69E-9, 0.5930651065, 983.1158589136), new Vsop87.LnVsop(1.78E-9, 3.92600130864, 621.7380390493), new Vsop87.LnVsop(1.74E-9, 4.32154318588, 280.9671470045), new Vsop87.LnVsop(1.91E-9, 0.54024876337, 424.1505103212), new Vsop87.LnVsop(1.89E-9, 0.10678158871, 406.954470903), new Vsop87.LnVsop(2.05E-9, 0.52365243803, 653.9813679637), new Vsop87.LnVsop(1.68E-9, 3.54301022192, 414.0680179038), new Vsop87.LnVsop(1.64E-9, 1.87404692874, 171.6545976624), new Vsop87.LnVsop(1.85E-9, 5.12729146826, 521.0929453855), new Vsop87.LnVsop(1.72E-9, 0.39423495673, 328.2407190726), new Vsop87.LnVsop(1.72E-9, 0.34793158963, 2349.3284312038), new Vsop87.LnVsop(1.8E-9, 0.37372289781, 661.0949149645), new Vsop87.LnVsop(1.7E-9, 5.79397661496, 421.1815649046), new Vsop87.LnVsop(1.59E-9, 2.25636452893, 539.2521926502), new Vsop87.LnVsop(1.93E-9, 1.65109454411, 91.4563731237), new Vsop87.LnVsop(1.66E-9, 2.23770488518, 80.9319377216), new Vsop87.LnVsop(1.83E-9, 3.00393831502, 286.596221297), new Vsop87.LnVsop(1.66E-9, 0.92209664824, 444.8268741099), new Vsop87.LnVsop(1.7E-9, 0.39414968415, 417.0369633204), new Vsop87.LnVsop(1.62E-9, 3.23150668653, 177.8743727859), new Vsop87.LnVsop(1.81E-9, 4.00504030975, 388.7257876691), new Vsop87.LnVsop(1.53E-9, 2.20468918814, 749.2098356561), new Vsop87.LnVsop(1.63E-9, 3.73110852012, 216.9224321604), new Vsop87.LnVsop(2.12E-9, 4.72231132508, 833.552661779), new Vsop87.LnVsop(1.98E-9, 6.18808818431, 346.1875180162), new Vsop87.LnVsop(1.77E-9, 2.13790488243, 66.1835788582), new Vsop87.LnVsop(1.89E-9, 0.61299968484, 8.5980197091), new Vsop87.LnVsop(2.13E-9, 4.78511947496, 1190.0351205337), new Vsop87.LnVsop(1.64E-9, 4.63818971012, 178.7893965226), new Vsop87.LnVsop(1.8E-9, 1.93178230246, 248.7238180901), new Vsop87.LnVsop(1.58E-9, 6.1394207787, 782.3469364478), new Vsop87.LnVsop(2.06E-9, 0.89126217502, 260.9933586314), new Vsop87.LnVsop(1.76E-9, 3.10085327825, 233.9060232575), new Vsop87.LnVsop(1.49E-9, 3.08021590217, 386.3475430835), new Vsop87.LnVsop(1.5E-9, 5.07107463854, 293.188503436), new Vsop87.LnVsop(1.8E-9, 6.18875446783, 526.722019678), new Vsop87.LnVsop(1.64E-9, 4.49121433201, 374.4986936675), new Vsop87.LnVsop(1.89E-9, 1.11458377928, 6058.7310542895), new Vsop87.LnVsop(1.47E-9, 3.01754055024, 670.4960838257), new Vsop87.LnVsop(1.68E-9, 3.76331368122, 74.2603337055), new Vsop87.LnVsop(1.44E-9, 2.31996539469, 294.3004691288), new Vsop87.LnVsop(1.67E-9, 5.42159494206, 22.8945496799), new Vsop87.LnVsop(1.44E-9, 5.81822380109, 75.5323580927), new Vsop87.LnVsop(1.57E-9, 0.40945769911, 88.274979386), new Vsop87.LnVsop(1.75E-9, 4.5376133901, 184.9879197867), new Vsop87.LnVsop(1.53E-9, 0.48543215446, 144.8973306886), new Vsop87.LnVsop(1.6E-9, 2.60794839561, 1055.4497769261), new Vsop87.LnVsop(1.79E-9, 4.37562818485, 764.1876891831), new Vsop87.LnVsop(1.43E-9, 1.99453048271, 354.9979860464), new Vsop87.LnVsop(1.46E-9, 5.69235209707, 600.5404103988), new Vsop87.LnVsop(1.77E-9, 3.90369220329, 1396.2206689709), new Vsop87.LnVsop(1.93E-9, 2.53328556634, 189.1807054807), new Vsop87.LnVsop(1.55E-9, 4.70126542016, 306.830642101), new Vsop87.LnVsop(1.54E-9, 4.62870568847, 154.979823106), new Vsop87.LnVsop(1.64E-9, 6.02390945956, 383.0967133766), new Vsop87.LnVsop(1.87E-9, 4.84188822839, 432.8179659995), new Vsop87.LnVsop(1.85E-9, 3.23152718658, 683.9894646444), new Vsop87.LnVsop(1.52E-9, 3.68645778017, 1439.5096981492), new Vsop87.LnVsop(1.35E-9, 0.15727475865, 115.3623147599), new Vsop87.LnVsop(1.83E-9, 3.27617419135, 331.2096644892), new Vsop87.LnVsop(1.43E-9, 5.46480801118, 74.0308390419), new Vsop87.LnVsop(1.44E-9, 4.20445488125, 237.6781178262), new Vsop87.LnVsop(1.33E-9, 4.32149882064, 515.463871093), new Vsop87.LnVsop(1.67E-9, 4.08839285774, 74.5209661364), new Vsop87.LnVsop(1.36E-9, 1.71455645866, 93.9040536785), new Vsop87.LnVsop(1.35E-9, 3.91190350483, 232.4215505492), new Vsop87.LnVsop(1.62E-9, 1.97790343838, 221.1634019642), new Vsop87.LnVsop(1.32E-9, 2.82624616573, 385.7568422525), new Vsop87.LnVsop(1.6E-9, 1.35947259957, 514.5643537213), new Vsop87.LnVsop(1.26E-9, 3.80235468146, 491.8185618877), new Vsop87.LnVsop(1.41E-9, 2.57765836949, 217.2312487011), new Vsop87.LnVsop(1.24E-9, 0.99583430014, 541.5398145106), new Vsop87.LnVsop(1.67E-9, 3.31937662997, 6133.5126528568), new Vsop87.LnVsop(1.41E-9, 2.6341144147, 323.5054166574), new Vsop87.LnVsop(1.28E-9, 5.08522615028, 448.6895914038), new Vsop87.LnVsop(1.57E-9, 5.87846003299, 149.45132255), new Vsop87.LnVsop(1.63E-9, 6.15363541244, 3340.6124266998), new Vsop87.LnVsop(1.45E-9, 0.39378158577, 357.4456666012), new Vsop87.LnVsop(1.3E-9, 0.87687909058, 234.4967240885), new Vsop87.LnVsop(1.32E-9, 4.39790926475, 686.958410061), new Vsop87.LnVsop(1.18E-9, 2.97103357711, 163.5778428151), new Vsop87.LnVsop(1.49E-9, 3.44120121334, 371.5297482509), new Vsop87.LnVsop(1.28E-9, 2.90544144809, 537.3952129264), new Vsop87.LnVsop(1.18E-9, 4.93654738085, 771.3012361839), new Vsop87.LnVsop(1.38E-9, 1.60526889301, 229.0800981171), new Vsop87.LnVsop(1.4E-9, 0.19423734509, 103.3534066495), new Vsop87.LnVsop(1.38E-9, 0.41128239547, 175.4266922311), new Vsop87.LnVsop(1.55E-9, 3.98039100074, 302.0953396858), new Vsop87.LnVsop(1.27E-9, 2.98955690598, 328.3525936572), new Vsop87.LnVsop(1.14E-9, 2.38099208126, 10213.285546211), new Vsop87.LnVsop(1.27E-9, 2.38558048946, 842.1506814881), new Vsop87.LnVsop(1.31E-9, 3.01936629873, 635.9651330509), new Vsop87.LnVsop(1.38E-9, 0.44662144244, 838.9692877504), new Vsop87.LnVsop(1.29E-9, 4.25513451348, 310.1720945331), new Vsop87.LnVsop(1.48E-9, 0.41799256546, 594.9113361063), new Vsop87.LnVsop(1.49E-9, 4.10330124264, 98.3574718034), new Vsop87.LnVsop(1.09E-9, 2.88811868696, 42.0651889009), new Vsop87.LnVsop(1.09E-9, 3.78134972711, 40.5807161926), new Vsop87.LnVsop(1.08E-9, 2.55916728156, 199.2844497575), new Vsop87.LnVsop(1.25E-9, 0.48048283452, 404.6186649328), new Vsop87.LnVsop(1.35E-9, 2.87189439592, 167.7224443993), new Vsop87.LnVsop(1.18E-9, 3.07682081692, 327.4375699205), new Vsop87.LnVsop(1.19E-9, 5.78903264789, 260.360219185), new Vsop87.LnVsop(1.11E-9, 3.22737687538, 15.4991183888), new Vsop87.LnVsop(1.09E-9, 6.27549146354, 73.1370671646), new Vsop87.LnVsop(1.09E-9, 4.70945671248, 76.42612997), new Vsop87.LnVsop(1.26E-9, 2.80187501225, 639.897286314), new Vsop87.LnVsop(1.05E-9, 1.48616898015, 405.9912630565), new Vsop87.LnVsop(1.16E-9, 4.85863853667, 1515.7757694248), new Vsop87.LnVsop(1.14E-9, 2.76818793591, 291.7040307277), new Vsop87.LnVsop(1.07E-9, 1.11766952208, 271.61836777), new Vsop87.LnVsop(1.11E-9, 2.87343319463, 410.1358646407), new Vsop87.LnVsop(1.11E-9, 0.27810454195, 255.8373650909), new Vsop87.LnVsop(1.18E-9, 5.07878372226, 679.2541622292), new Vsop87.LnVsop(9.9E-10, 1.51676782588, 194.2885149114), new Vsop87.LnVsop(9.9E-10, 1.03758417112, 703.6331846174), new Vsop87.LnVsop(1.3E-9, 1.66666180289, 403.0223176399), new Vsop87.LnVsop(1.23E-9, 6.11422629384, 365.0011565867), new Vsop87.LnVsop(1.04E-9, 5.23997703346, 141.4864422873), new Vsop87.LnVsop(1.15E-9, 6.23621039514, 214.7835681463), new Vsop87.LnVsop(9.6E-10, 0.43424417561, 35.685355083), new Vsop87.LnVsop(1.03E-9, 1.06002930749, 76.3779458602), new Vsop87.LnVsop(1.04E-9, 2.65595803065, 742.9900605326), new Vsop87.LnVsop(1.15E-9, 5.22994397833, 511.5317178299), new Vsop87.LnVsop(9.4E-10, 2.74704482453, 80.4106728598), new Vsop87.LnVsop(1.28E-9, 0.77030466848, 806.725958836), new Vsop87.LnVsop(1.1E-9, 5.29132647687, 274.5873131866), new Vsop87.LnVsop(1.14E-9, 2.57034943327, 69.1525242748), new Vsop87.LnVsop(9.5E-10, 2.6283493608, 217.4436970222), new Vsop87.LnVsop(1.13E-9, 0.31878741567, 228.7982138268), new Vsop87.LnVsop(9.4E-10, 1.09024515607, 779.899255893), new Vsop87.LnVsop(1.04E-9, 1.63565182098, 1438.0252254409), new Vsop87.LnVsop(1.23E-9, 0.31994708206, 205.2223405907), new Vsop87.LnVsop(8.9E-10, 3.89481868438, 273.8536000037), new Vsop87.LnVsop(1.11E-9, 5.23314925278, 115.8835796217), new Vsop87.LnVsop(9.0E-10, 0.08059052014, 543.9180590962), new Vsop87.LnVsop(1.03E-9, 1.50283068334, 316.3918696566), new Vsop87.LnVsop(1.14E-9, 4.07327336627, 303.8616966844), new Vsop87.LnVsop(1.21E-9, 2.40722327908, 89.0086925689), new Vsop87.LnVsop(8.5E-10, 2.88976414563, 481.7360694703), new Vsop87.LnVsop(1.02E-9, 3.36728076478, 731.9443602687), new Vsop87.LnVsop(9.5E-10, 4.08252009963, 223.4510238246), new Vsop87.LnVsop(1.03E-9, 1.17394061445, 30.5987975117), new Vsop87.LnVsop(8.2E-10, 2.2522100728, 180.7951340927), new Vsop87.LnVsop(8.8E-10, 3.62556128338, 73.1852512744), new Vsop87.LnVsop(1.06E-9, 5.05420123147, 82.6459050935), new Vsop87.LnVsop(8.0E-10, 6.02853833502, 343.2185725996), new Vsop87.LnVsop(8.6E-10, 5.34618023172, 107.0249274817), new Vsop87.LnVsop(9.6E-10, 1.56226891458, 768.8535556291), new Vsop87.LnVsop(9.0E-10, 5.07169537551, 534.4262675098), new Vsop87.LnVsop(9.8E-10, 4.9225249206, 582.3811631341), new Vsop87.LnVsop(1.01E-9, 0.84796065157, 602.9880909536), new Vsop87.LnVsop(8.3E-10, 1.65460715725, 753.1419889192), new Vsop87.LnVsop(7.8E-10, 5.51638181769, 74.7334144575), new Vsop87.LnVsop(9.3E-10, 5.84400145456, 774.4826299216), new Vsop87.LnVsop(8.9E-10, 0.95563866426, 6.9010986797), new Vsop87.LnVsop(8.7E-10, 4.41987284863, 552.5855147745), new Vsop87.LnVsop(1.03E-9, 4.60346642754, 370.9390474199), new Vsop87.LnVsop(7.7E-10, 4.7740441983, 242.5040429666), new Vsop87.LnVsop(7.5E-10, 3.39192079177, 118.0224436358), new Vsop87.LnVsop(7.6E-10, 1.05747326519, 79.889407998), new Vsop87.LnVsop(7.9E-10, 3.54181953824, 758.7710632117), new Vsop87.LnVsop(7.4E-10, 3.98963783883, 301.4140161296), new Vsop87.LnVsop(7.8E-10, 1.82705732908, 74.8297826771), new Vsop87.LnVsop(7.4E-10, 1.08013205637, 107.918699359), new Vsop87.LnVsop(7.4E-10, 5.37621944193, 473.659314623), new Vsop87.LnVsop(7.8E-10, 2.52470639403, 103.9865460959), new Vsop87.LnVsop(7.3E-10, 1.33099035143, 117.3198682202), new Vsop87.LnVsop(7.3E-10, 3.86314726423, 47.6942631934), new Vsop87.LnVsop(7.9E-10, 3.79190807969, 243.9885156749), new Vsop87.LnVsop(7.9E-10, 1.85527149881, 495.9631634719), new Vsop87.LnVsop(8.3E-10, 4.63377403454, 147.8662761052), new Vsop87.LnVsop(7.5E-10, 3.25894652055, 195.7729876197), new Vsop87.LnVsop(8.3E-10, 2.51263535489, 73.88782669), new Vsop87.LnVsop(7.6E-10, 0.65318077927, 6283.0758499914), new Vsop87.LnVsop(7.4E-10, 2.98225723938, 77.0692204277), new Vsop87.LnVsop(9.5E-10, 1.54407527959, 210.8514148832), new Vsop87.LnVsop(7.2E-10, 5.49406740322, 74.6215398729), new Vsop87.LnVsop(8.3E-10, 3.32264980311, 1366.2125722902), new Vsop87.LnVsop(7.4E-10, 3.656968537, 69.6737891366), new Vsop87.LnVsop(7.4E-10, 3.23127044816, 208.8456773131), new Vsop87.LnVsop(8.0E-10, 4.36056904242, 1662.9607219738), new Vsop87.LnVsop(7.3E-10, 5.2653129037, 130.4407420234), new Vsop87.LnVsop(7.1E-10, 4.81609825971, 321.1271720718), new Vsop87.LnVsop(7.6E-10, 2.5184813688, 84.9335269539), new Vsop87.LnVsop(9.7E-10, 2.40670778188, 75.6753704446), new Vsop87.LnVsop(7.8E-10, 5.68434801179, 221.8971151471)};
        private static final Vsop87.LnVsop[] uranus_longitude_l2 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(2.349469E-5, 2.26708640433, 74.7815985673), new Vsop87.LnVsop(8.48806E-6, 3.14159265359, 0.0), new Vsop87.LnVsop(7.68983E-6, 4.52562378749, 11.0457002639), new Vsop87.LnVsop(5.51555E-6, 3.2581932204, 63.7358983034), new Vsop87.LnVsop(5.41559E-6, 2.27572631399, 3.9321532631), new Vsop87.LnVsop(5.29491E-6, 4.92336172394, 1.4844727083), new Vsop87.LnVsop(2.57527E-6, 3.69060540044, 3.1813937377), new Vsop87.LnVsop(1.82036E-6, 6.21866555925, 70.8494453042), new Vsop87.LnVsop(1.84429E-6, 5.05954505833, 149.5631971346), new Vsop87.LnVsop(4.9505E-7, 6.03085160423, 56.6223513026), new Vsop87.LnVsop(5.3456E-7, 1.45801353517, 76.2660712756), new Vsop87.LnVsop(3.8334E-7, 1.78433163102, 52.6901980395), new Vsop87.LnVsop(4.4885E-7, 3.90644983662, 2.4476805548), new Vsop87.LnVsop(4.4623E-7, 0.81232539761, 85.8272988312), new Vsop87.LnVsop(3.7373E-7, 4.46132739805, 2.9689454166), new Vsop87.LnVsop(3.3044E-7, 0.86461989031, 9.5612275556), new Vsop87.LnVsop(2.4305E-7, 2.10670976428, 18.1592472647), new Vsop87.LnVsop(2.925E-7, 5.09724793503, 73.297125859), new Vsop87.LnVsop(2.2309E-7, 4.81978108793, 78.7137518304), new Vsop87.LnVsop(2.2283E-7, 5.99230347559, 138.5174968707), new Vsop87.LnVsop(1.723E-7, 2.53731197138, 145.6310438715), new Vsop87.LnVsop(2.1416E-7, 2.39692592406, 77.962992305), new Vsop87.LnVsop(1.5114E-7, 1.43013979998, 224.3447957019), new Vsop87.LnVsop(1.6756E-7, 3.46508324378, 12.5301729722), new Vsop87.LnVsop(1.2003E-7, 0.01666017885, 22.0914005278), new Vsop87.LnVsop(1.0497E-7, 4.47250656935, 62.2514255951), new Vsop87.LnVsop(1.0943E-7, 0.08477481315, 127.4717966068), new Vsop87.LnVsop(8.683E-8, 4.25475342937, 7.1135470008), new Vsop87.LnVsop(1.0478E-7, 5.16510093405, 71.6002048296), new Vsop87.LnVsop(7.208E-8, 1.25579094145, 5.4166259714), new Vsop87.LnVsop(8.383E-8, 5.49939298653, 67.6680515665), new Vsop87.LnVsop(6.079E-8, 5.44023447414, 65.2203710117), new Vsop87.LnVsop(5.718E-8, 1.83543074459, 202.2533951741), new Vsop87.LnVsop(6.109E-8, 3.36329480272, 447.7958195265), new Vsop87.LnVsop(6.002E-8, 5.72509014963, 462.0229135281), new Vsop87.LnVsop(5.684E-8, 4.14533132422, 151.0476698429), new Vsop87.LnVsop(5.091E-8, 3.52369031374, 59.8037450403), new Vsop87.LnVsop(5.147E-8, 1.05915315998, 131.4039498699), new Vsop87.LnVsop(4.917E-8, 3.38475371297, 4.4534181249), new Vsop87.LnVsop(4.818E-8, 1.20436413021, 71.8126531507), new Vsop87.LnVsop(4.697E-8, 6.13059120042, 148.0787244263), new Vsop87.LnVsop(3.95E-8, 0.69544777458, 77.7505439839), new Vsop87.LnVsop(3.655E-8, 1.75283968054, 351.8165923087), new Vsop87.LnVsop(3.144E-8, 3.30914690507, 160.6088973985), new Vsop87.LnVsop(3.17E-8, 6.13784634729, 77.2292791221), new Vsop87.LnVsop(3.149E-8, 3.83524373649, 45.5766510387), new Vsop87.LnVsop(3.616E-8, 4.56973348262, 454.9093665273), new Vsop87.LnVsop(2.673E-8, 1.05631111199, 69.3649725959), new Vsop87.LnVsop(2.66E-8, 5.35501232753, 269.9214467406), new Vsop87.LnVsop(2.315E-8, 2.61423820966, 84.3428261229), new Vsop87.LnVsop(2.258E-8, 5.07517615514, 14.977853527), new Vsop87.LnVsop(2.249E-8, 1.37812609668, 284.1485407422), new Vsop87.LnVsop(2.072E-8, 4.3496677836, 984.6003316219), new Vsop87.LnVsop(2.101E-8, 2.31175293338, 120.358249606), new Vsop87.LnVsop(1.808E-8, 0.52249831108, 137.0330241624), new Vsop87.LnVsop(1.849E-8, 5.69618054054, 54.1746707478), new Vsop87.LnVsop(1.983E-8, 3.87043200848, 195.1398481733), new Vsop87.LnVsop(1.632E-8, 5.07069503204, 209.3669421749), new Vsop87.LnVsop(1.578E-8, 2.91229378751, 51.2057253312), new Vsop87.LnVsop(1.722E-8, 6.25913624391, 41.6444977756), new Vsop87.LnVsop(1.656E-8, 6.26113629911, 277.0349937414), new Vsop87.LnVsop(1.822E-8, 1.24304611018, 35.1640902212), new Vsop87.LnVsop(1.345E-8, 2.04057300383, 70.3281804424), new Vsop87.LnVsop(1.253E-8, 2.65486278486, 134.5853436076), new Vsop87.LnVsop(1.239E-8, 4.63255501972, 92.940845832), new Vsop87.LnVsop(1.369E-8, 6.08201469405, 87.3117715395), new Vsop87.LnVsop(1.277E-8, 5.87454788183, 60.5545045657), new Vsop87.LnVsop(1.281E-8, 2.51504858314, 72.3339180125), new Vsop87.LnVsop(1.25E-8, 1.09008933023, 213.299095438), new Vsop87.LnVsop(1.055E-8, 4.00338488062, 299.1263942692), new Vsop87.LnVsop(1.133E-8, 4.64929170681, 152.7445908723), new Vsop87.LnVsop(1.082E-8, 1.07336611951, 153.4953503977), new Vsop87.LnVsop(1.037E-8, 4.82158521698, 116.4260963429), new Vsop87.LnVsop(8.63E-9, 3.56774115747, 340.7708920448), new Vsop87.LnVsop(9.57E-9, 2.11521253777, 20.6069278195), new Vsop87.LnVsop(9.52E-9, 2.4717064451, 380.12776796), new Vsop87.LnVsop(8.36E-9, 6.12347738126, 49.5088043018), new Vsop87.LnVsop(8.08E-9, 0.29677438017, 191.2076949102), new Vsop87.LnVsop(8.08E-9, 4.08162792952, 14.2270940016), new Vsop87.LnVsop(7.92E-9, 6.1709106312, 344.7030453079), new Vsop87.LnVsop(7.91E-9, 2.37030711541, 58.1068240109), new Vsop87.LnVsop(9.14E-9, 2.11419968166, 14.0146456805), new Vsop87.LnVsop(7.88E-9, 0.75228496417, 408.4389436113), new Vsop87.LnVsop(7.63E-9, 2.38121244677, 222.8603229936), new Vsop87.LnVsop(8.91E-9, 2.04340711828, 265.9892934775), new Vsop87.LnVsop(7.3E-9, 3.10064098912, 422.6660376129), new Vsop87.LnVsop(7.65E-9, 0.7772382722, 76.4785195967), new Vsop87.LnVsop(6.45E-9, 2.77108845143, 96.8729990951), new Vsop87.LnVsop(7.45E-9, 2.35633194869, 358.9301393095), new Vsop87.LnVsop(6.2E-9, 1.98188971784, 33.6796175129), new Vsop87.LnVsop(6.55E-9, 3.8541585028, 16.6747745564), new Vsop87.LnVsop(6.08E-9, 0.15790159997, 28.3111756513), new Vsop87.LnVsop(5.87E-9, 1.09637968292, 55.1378785943), new Vsop87.LnVsop(6.17E-9, 1.70137701054, 8.0767548473), new Vsop87.LnVsop(6.45E-9, 5.17890892522, 23.5758732361), new Vsop87.LnVsop(5.89E-9, 3.39293635432, 144.1465711632), new Vsop87.LnVsop(5.98E-9, 3.77279530334, 80.1982245387), new Vsop87.LnVsop(5.62E-9, 4.90624120147, 35.4247226521), new Vsop87.LnVsop(5.87E-9, 4.33026772564, 29.2049475286), new Vsop87.LnVsop(4.74E-9, 0.88680405794, 565.1156877467), new Vsop87.LnVsop(4.77E-9, 3.44956358856, 128.9562693151), new Vsop87.LnVsop(4.32E-9, 1.05836005695, 19.643719973), new Vsop87.LnVsop(4.8E-9, 5.27492573341, 206.1855484372), new Vsop87.LnVsop(4.54E-9, 6.05565972578, 70.1157321213), new Vsop87.LnVsop(4.13E-9, 0.42595505653, 225.8292684102), new Vsop87.LnVsop(4.58E-9, 5.47151191138, 333.657345044), new Vsop87.LnVsop(5.28E-9, 2.2702575842, 38.1330356378), new Vsop87.LnVsop(4.47E-9, 0.91893151458, 373.0142209592), new Vsop87.LnVsop(5.11E-9, 1.59897693264, 142.4496501338), new Vsop87.LnVsop(4.2E-9, 5.77293204332, 146.594251718), new Vsop87.LnVsop(3.83E-9, 1.91679738697, 5.6290742925), new Vsop87.LnVsop(3.82E-9, 3.0433966022, 152.5321425512), new Vsop87.LnVsop(4.18E-9, 1.05236603665, 125.9873238985), new Vsop87.LnVsop(3.72E-9, 2.85710020233, 200.7689224658), new Vsop87.LnVsop(4.96E-9, 1.92980650193, 415.5524906121), new Vsop87.LnVsop(3.7E-9, 3.2221242722, 387.2413149608), new Vsop87.LnVsop(3.87E-9, 2.79134085638, 81.8951455681), new Vsop87.LnVsop(3.57E-9, 4.64158965749, 220.4126424388), new Vsop87.LnVsop(3.45E-9, 2.98021540638, 429.7795846137), new Vsop87.LnVsop(3.35E-9, 5.29062985955, 13.3333221243), new Vsop87.LnVsop(3.2E-9, 1.62674909598, 99.1606209555), new Vsop87.LnVsop(3.2E-9, 0.74685145174, 347.8844390456), new Vsop87.LnVsop(2.88E-9, 2.44437048636, 546.956440482), new Vsop87.LnVsop(2.75E-9, 0.62680026669, 31.492569389), new Vsop87.LnVsop(2.81E-9, 6.04447663913, 456.3938392356), new Vsop87.LnVsop(2.7E-9, 2.7937834555, 977.4867846211), new Vsop87.LnVsop(2.68E-9, 4.64955164739, 230.5645708254), new Vsop87.LnVsop(2.71E-9, 0.59225635449, 1894.4190646765), new Vsop87.LnVsop(2.63E-9, 3.49309481771, 440.6822725257), new Vsop87.LnVsop(2.53E-9, 1.90016027905, 129.9194771616), new Vsop87.LnVsop(2.71E-9, 4.82853730065, 561.1835344836), new Vsop87.LnVsop(2.59E-9, 0.27190856999, 373.9079928365), new Vsop87.LnVsop(3.14E-9, 1.47136601206, 24.3790223882), new Vsop87.LnVsop(2.61E-9, 0.09830739366, 991.7138786227), new Vsop87.LnVsop(2.35E-9, 5.13968661425, 479.2883889155), new Vsop87.LnVsop(2.31E-9, 1.3810636328, 391.1734682239), new Vsop87.LnVsop(2.3E-9, 4.81251240097, 159.1244246902), new Vsop87.LnVsop(3.05E-9, 4.4551845892, 112.9146342051), new Vsop87.LnVsop(3.11E-9, 4.82238770299, 108.4612160802), new Vsop87.LnVsop(2.33E-9, 4.25631985431, 365.9006739584), new Vsop87.LnVsop(2.61E-9, 1.59315260466, 17.2654753874), new Vsop87.LnVsop(2.33E-9, 2.83623217386, 376.1956146969), new Vsop87.LnVsop(2.94E-9, 1.66582514618, 124.2904028691), new Vsop87.LnVsop(2.13E-9, 1.07884329091, 288.0806940053), new Vsop87.LnVsop(2.07E-9, 5.03566431809, 297.6419215609), new Vsop87.LnVsop(2.01E-9, 1.68940522081, 135.5485514541), new Vsop87.LnVsop(2.31E-9, 2.24878224928, 152.0108776894), new Vsop87.LnVsop(2.16E-9, 6.19661665314, 490.3340891794), new Vsop87.LnVsop(2.36E-9, 4.93084016804, 458.090760265), new Vsop87.LnVsop(2.25E-9, 0.22664678208, 254.9435932136), new Vsop87.LnVsop(2.13E-9, 0.12942394964, 411.620337349), new Vsop87.LnVsop(1.93E-9, 3.70727194044, 353.301065017), new Vsop87.LnVsop(2.14E-9, 2.37863059014, 184.0941479094), new Vsop87.LnVsop(2.11E-9, 2.16158427984, 162.0933701068), new Vsop87.LnVsop(2.08E-9, 3.81481624262, 258.8757464767), new Vsop87.LnVsop(1.88E-9, 0.23642242835, 74.8934731519), new Vsop87.LnVsop(2.29E-9, 5.33297149225, 827.1728279611), new Vsop87.LnVsop(1.96E-9, 3.41624470471, 173.9422195228), new Vsop87.LnVsop(1.86E-9, 1.25407717254, 74.6697239827), new Vsop87.LnVsop(2.19E-9, 1.22774377372, 305.3461693927), new Vsop87.LnVsop(1.84E-9, 0.07653324668, 969.6224780949), new Vsop87.LnVsop(1.81E-9, 5.5026898635, 983.1158589136), new Vsop87.LnVsop(2.34E-9, 1.43222813448, 146.3818033969), new Vsop87.LnVsop(1.91E-9, 4.02315888568, 774.4826299216), new Vsop87.LnVsop(1.76E-9, 0.36587651982, 100.3844612329), new Vsop87.LnVsop(1.74E-9, 0.35464783229, 354.9979860464), new Vsop87.LnVsop(1.74E-9, 2.8120362685, 140.001969579), new Vsop87.LnVsop(2.01E-9, 1.04955848325, 316.3918696566), new Vsop87.LnVsop(1.72E-9, 0.67782414229, 167.7224443993), new Vsop87.LnVsop(1.75E-9, 5.90738517293, 235.3904959658), new Vsop87.LnVsop(1.71E-9, 1.90443657327, 33.1371007917), new Vsop87.LnVsop(1.74E-9, 5.60867787733, 469.1364605289), new Vsop87.LnVsop(1.79E-9, 2.38892600195, 486.4019359163), new Vsop87.LnVsop(1.71E-9, 1.27067391131, 291.262087743), new Vsop87.LnVsop(1.75E-9, 3.15884013286, 66.9172920411), new Vsop87.LnVsop(2.09E-9, 5.78799629527, 111.4301614968), new Vsop87.LnVsop(1.71E-9, 5.43315629209, 42.5382696529), new Vsop87.LnVsop(2.03E-9, 1.58369655553, 298.2326223919), new Vsop87.LnVsop(1.66E-9, 4.78948867256, 1514.2912967165), new Vsop87.LnVsop(1.74E-9, 0.56063488876, 521.0929453855), new Vsop87.LnVsop(2.05E-9, 3.48282420941, 404.5067903482), new Vsop87.LnVsop(1.71E-9, 2.91325849153, 535.3200393871), new Vsop87.LnVsop(1.77E-9, 0.86306620537, 472.1748419147), new Vsop87.LnVsop(1.84E-9, 2.92293138603, 881.5075574033), new Vsop87.LnVsop(1.66E-9, 4.78927133151, 109.9456887885), new Vsop87.LnVsop(1.88E-9, 0.57920908215, 369.0820676961), new Vsop87.LnVsop(1.55E-9, 1.28199332469, 89.7594520943), new Vsop87.LnVsop(1.56E-9, 2.77376676007, 141.6988906084), new Vsop87.LnVsop(1.63E-9, 6.18149717003, 1357.6145525811), new Vsop87.LnVsop(1.54E-9, 6.1325559281, 218.9281697305), new Vsop87.LnVsop(1.51E-9, 2.6977364819, 132.8884225782), new Vsop87.LnVsop(1.64E-9, 5.23606804941, 1094.8066528413), new Vsop87.LnVsop(1.57E-9, 3.34238375767, 268.4369740323), new Vsop87.LnVsop(1.69E-9, 1.82777920099, 398.2870152247), new Vsop87.LnVsop(1.78E-9, 3.45386061878, 685.4739373527), new Vsop87.LnVsop(1.48E-9, 2.9887327609, 211.8146227297), new Vsop87.LnVsop(1.55E-9, 1.72159478356, 679.2541622292), new Vsop87.LnVsop(1.48E-9, 0.95649146876, 867.2804634017), new Vsop87.LnVsop(1.91E-9, 3.62538073529, 554.0699874828), new Vsop87.LnVsop(1.78E-9, 2.10923963877, 661.0949149645), new Vsop87.LnVsop(1.35E-9, 6.06368720482, 980.6681783588), new Vsop87.LnVsop(1.35E-9, 5.9685748351, 91.4563731237), new Vsop87.LnVsop(1.3E-9, 4.36914393286, 273.1028404783), new Vsop87.LnVsop(1.53E-9, 3.49640803991, 228.276948965), new Vsop87.LnVsop(1.3E-9, 2.72570287614, 522.5774180938), new Vsop87.LnVsop(1.43E-9, 5.02900860888, 536.8045120954), new Vsop87.LnVsop(1.26E-9, 1.93883254906, 909.8187330546), new Vsop87.LnVsop(1.27E-9, 1.78014700856, 205.4347889118), new Vsop87.LnVsop(1.4E-9, 0.83038018169, 535.9107402181), new Vsop87.LnVsop(1.27E-9, 5.06009501625, 275.5505210331), new Vsop87.LnVsop(1.29E-9, 3.77988686343, 483.2205421786), new Vsop87.LnVsop(1.18E-9, 5.83292150811, 703.6331846174), new Vsop87.LnVsop(1.3E-9, 4.52188865601, 216.4804891757), new Vsop87.LnVsop(1.17E-9, 3.97236048113, 135.336103133), new Vsop87.LnVsop(1.1E-9, 4.10507371008, 433.7117378768), new Vsop87.LnVsop(1.13E-9, 1.51901732866, 384.0599212231), new Vsop87.LnVsop(1.07E-9, 0.99334138425, 295.1942410061), new Vsop87.LnVsop(1.31E-9, 3.98415139373, 73.0846775379), new Vsop87.LnVsop(1.08E-9, 4.07981007546, 203.7378678824), new Vsop87.LnVsop(1.09E-9, 3.04776608048, 300.6108669775), new Vsop87.LnVsop(1.09E-9, 1.22958797958, 525.7588118315), new Vsop87.LnVsop(1.31E-9, 2.99178036398, 75.7448064138), new Vsop87.LnVsop(1.03E-9, 4.46390192594, 579.3427817483), new Vsop87.LnVsop(1.09E-9, 1.9918256593, 60.7669528868), new Vsop87.LnVsop(1.21E-9, 0.73822914508, 248.7238180901), new Vsop87.LnVsop(1.06E-9, 2.04571727537, 2043.9822618111), new Vsop87.LnVsop(1.02E-9, 4.88960169615, 831.1049812242), new Vsop87.LnVsop(9.9E-10, 3.81282044986, 73.8183907208), new Vsop87.LnVsop(9.4E-10, 5.78362714209, 350.3321196004), new Vsop87.LnVsop(1.14E-9, 2.09397520178, 278.5194664497), new Vsop87.LnVsop(8.9E-10, 5.90655259674, 79.2350166922), new Vsop87.LnVsop(9.7E-10, 2.67425330058, 221.3758502853), new Vsop87.LnVsop(8.9E-10, 6.25528198072, 234.4967240885), new Vsop87.LnVsop(8.5E-10, 0.13307608646, 639.897286314), new Vsop87.LnVsop(9.0E-10, 5.53000751155, 827.9235874865), new Vsop87.LnVsop(8.0E-10, 5.34711145866, 181.0557665236), new Vsop87.LnVsop(7.9E-10, 0.95205771963, 426.598190876), new Vsop87.LnVsop(8.4E-10, 3.97140652554, 336.8387387817), new Vsop87.LnVsop(8.0E-10, 5.24056087129, 504.561183181), new Vsop87.LnVsop(7.8E-10, 2.26526379571, 450.9772132642), new Vsop87.LnVsop(8.1E-10, 1.32480509617, 89.0086925689), new Vsop87.LnVsop(1.08E-9, 1.50473495412, 25.2727942655), new Vsop87.LnVsop(7.7E-10, 0.31815291828, 447.2051186955), new Vsop87.LnVsop(8.1E-10, 4.64364910706, 1208.0513554465), new Vsop87.LnVsop(7.7E-10, 5.90631938483, 515.463871093), new Vsop87.LnVsop(9.5E-10, 5.82143764459, 453.424893819), new Vsop87.LnVsop(7.7E-10, 3.56359211434, 82.8583534146), new Vsop87.LnVsop(9.3E-10, 0.3830174579, 699.7010313543), new Vsop87.LnVsop(7.6E-10, 4.16820366863, 95.3885263868), new Vsop87.LnVsop(7.6E-10, 1.49535232496, 849.2642284889), new Vsop87.LnVsop(9.9E-10, 2.79074529357, 184.7272873558), new Vsop87.LnVsop(7.6E-10, 6.13770068285, 123.5396433437), new Vsop87.LnVsop(1.04E-9, 6.2565394264, 443.8636662634), new Vsop87.LnVsop(7.3E-10, 3.57936315445, 180.1619946463), new Vsop87.LnVsop(8.3E-10, 1.56888177127, 306.830642101), new Vsop87.LnVsop(8.7E-10, 0.74135830037, 227.5261894396), new Vsop87.LnVsop(7.9E-10, 1.91762400825, 901.9544265284), new Vsop87.LnVsop(8.9E-10, 3.64708770174, 810.6581120991), new Vsop87.LnVsop(8.4E-10, 1.50560186863, 419.4846438752)};
        private static final Vsop87.LnVsop[] uranus_longitude_l3 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.22192E-6, 0.02112102225, 74.7815985673), new Vsop87.LnVsop(6.8195E-7, 4.12138633187, 3.9321532631), new Vsop87.LnVsop(5.2729E-7, 2.38808499397, 11.0457002639), new Vsop87.LnVsop(4.3714E-7, 2.95937380925, 1.4844727083), new Vsop87.LnVsop(4.5405E-7, 2.04405402149, 3.1813937377), new Vsop87.LnVsop(2.4903E-7, 4.886800756, 63.7358983034), new Vsop87.LnVsop(2.1004E-7, 4.54879176205, 70.8494453042), new Vsop87.LnVsop(8.985E-8, 1.58255257968, 56.6223513026), new Vsop87.LnVsop(9.158E-8, 2.57000447334, 149.5631971346), new Vsop87.LnVsop(1.0361E-7, 0.0, 0.0), new Vsop87.LnVsop(4.261E-8, 0.22780215466, 18.1592472647), new Vsop87.LnVsop(3.625E-8, 5.3836730459, 76.2660712756), new Vsop87.LnVsop(3.244E-8, 5.01058611704, 85.8272988312), new Vsop87.LnVsop(3.488E-8, 4.13160885916, 52.6901980395), new Vsop87.LnVsop(3.57E-8, 0.94065081296, 77.962992305), new Vsop87.LnVsop(2.738E-8, 0.4034653554, 78.7137518304), new Vsop87.LnVsop(2.233E-8, 0.87157987676, 145.6310438715), new Vsop87.LnVsop(1.948E-8, 2.67957461817, 7.1135470008), new Vsop87.LnVsop(2.12E-8, 5.64073933192, 9.5612275556), new Vsop87.LnVsop(1.566E-8, 5.46300116637, 73.297125859), new Vsop87.LnVsop(1.308E-8, 1.25835033636, 12.5301729722), new Vsop87.LnVsop(1.616E-8, 0.49324165265, 71.6002048296), new Vsop87.LnVsop(1.23E-8, 3.93093451148, 22.0914005278), new Vsop87.LnVsop(9.06E-9, 2.17573166732, 127.4717966068), new Vsop87.LnVsop(8.11E-9, 5.08300105756, 447.7958195265), new Vsop87.LnVsop(8.0E-9, 4.00214562488, 462.0229135281), new Vsop87.LnVsop(7.18E-9, 0.34600103024, 5.6290742925), new Vsop87.LnVsop(7.18E-9, 1.19635899416, 138.5174968707), new Vsop87.LnVsop(6.8E-9, 2.9444450611, 131.4039498699), new Vsop87.LnVsop(5.81E-9, 5.14726797687, 224.3447957019), new Vsop87.LnVsop(4.06E-9, 4.33376335103, 120.358249606), new Vsop87.LnVsop(3.76E-9, 0.75784834422, 269.9214467406), new Vsop87.LnVsop(3.47E-9, 5.94165731686, 284.1485407422), new Vsop87.LnVsop(3.45E-9, 3.05968942771, 561.1835344836), new Vsop87.LnVsop(3.43E-9, 4.01891371998, 546.956440482), new Vsop87.LnVsop(3.76E-9, 5.9584406066, 45.5766510387), new Vsop87.LnVsop(3.34E-9, 1.61761448243, 151.0476698429), new Vsop87.LnVsop(2.84E-9, 1.1286389648, 134.5853436076), new Vsop87.LnVsop(2.78E-9, 3.4313540142, 202.2533951741), new Vsop87.LnVsop(3.74E-9, 3.31569280991, 152.7445908723), new Vsop87.LnVsop(2.68E-9, 3.24741531524, 536.8045120954), new Vsop87.LnVsop(3.58E-9, 1.10916640253, 333.657345044), new Vsop87.LnVsop(3.55E-9, 2.95198893484, 153.4953503977), new Vsop87.LnVsop(2.36E-9, 4.64852235589, 387.2413149608), new Vsop87.LnVsop(2.23E-9, 5.11416165165, 347.8844390456), new Vsop87.LnVsop(2.45E-9, 5.194366284, 81.8951455681), new Vsop87.LnVsop(2.28E-9, 3.7413893183, 87.3117715395), new Vsop87.LnVsop(2.26E-9, 4.29682981394, 77.7505439839), new Vsop87.LnVsop(2.34E-9, 5.80540756495, 67.6680515665), new Vsop87.LnVsop(2.88E-9, 5.72707827196, 195.1398481733), new Vsop87.LnVsop(2.01E-9, 1.74602592032, 213.299095438), new Vsop87.LnVsop(2.04E-9, 5.81145810966, 373.0142209592), new Vsop87.LnVsop(1.87E-9, 2.35512484122, 124.2904028691), new Vsop87.LnVsop(1.85E-9, 3.12619552579, 148.0787244263), new Vsop87.LnVsop(1.7E-9, 1.91718323832, 59.8037450403), new Vsop87.LnVsop(1.65E-9, 3.46463258943, 209.3669421749), new Vsop87.LnVsop(1.71E-9, 6.12119673115, 351.8165923087), new Vsop87.LnVsop(1.91E-9, 5.50650694321, 73.0846775379), new Vsop87.LnVsop(1.54E-9, 2.74592153459, 92.940845832), new Vsop87.LnVsop(1.87E-9, 2.88710400041, 146.3818033969), new Vsop87.LnVsop(1.42E-9, 3.34786225013, 72.3339180125), new Vsop87.LnVsop(1.3E-9, 1.06884333081, 84.3428261229), new Vsop87.LnVsop(1.56E-9, 1.27379656026, 160.6088973985), new Vsop87.LnVsop(1.12E-9, 2.52374006072, 62.2514255951), new Vsop87.LnVsop(9.6E-10, 2.43808447701, 288.0806940053), new Vsop87.LnVsop(1.04E-9, 4.80942792304, 144.1465711632), new Vsop87.LnVsop(9.0E-10, 4.64083951502, 411.620337349), new Vsop87.LnVsop(8.0E-10, 3.36996054975, 497.4476361802), new Vsop87.LnVsop(8.5E-10, 2.90593266919, 483.2205421786)};
        private static final Vsop87.LnVsop[] uranus_longitude_l4 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(5.536E-8, 4.57721551627, 74.7815985673), new Vsop87.LnVsop(3.183E-8, 0.34467460171, 11.0457002639), new Vsop87.LnVsop(1.207E-8, 3.40871377105, 56.6223513026), new Vsop87.LnVsop(6.34E-9, 4.65445189526, 18.1592472647), new Vsop87.LnVsop(3.59E-9, 0.67024156853, 149.5631971346), new Vsop87.LnVsop(2.47E-9, 2.07784257495, 63.7358983034), new Vsop87.LnVsop(1.09E-9, 2.7551433797, 85.8272988312), new Vsop87.LnVsop(9.2E-10, 5.02598538441, 131.4039498699)};

        Longitude() {
        }
    }
}

