/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt.solarsystem;

import de.kah2.zodiac.nova4jmt.Nutation;
import de.kah2.zodiac.nova4jmt.RiseSet;
import de.kah2.zodiac.nova4jmt.Transform;
import de.kah2.zodiac.nova4jmt.Utility;
import de.kah2.zodiac.nova4jmt.api.LnEquPosn;
import de.kah2.zodiac.nova4jmt.api.LnHelioPosn;
import de.kah2.zodiac.nova4jmt.api.LnLnlatPosn;
import de.kah2.zodiac.nova4jmt.api.LnNutation;
import de.kah2.zodiac.nova4jmt.api.LnRectPosn;
import de.kah2.zodiac.nova4jmt.api.LnRstTime;
import de.kah2.zodiac.nova4jmt.solarsystem.Earth;
import de.kah2.zodiac.nova4jmt.util.IGetEquBodyCoords;

public class Solar {
    public static final double LN_SOLAR_STANDART_HORIZON = -0.8333;

    public static void ln_get_solar_geom_coords(double JD, LnHelioPosn position) {
        Earth.ln_get_earth_helio_coords(JD, position);
        position.L += 180.0;
        position.L = Utility.ln_range_degrees(position.L);
        position.B *= -1.0;
    }

    public static void ln_get_solar_equ_coords(double JD, LnEquPosn position) {
        LnHelioPosn sol = new LnHelioPosn();
        LnLnlatPosn LB = new LnLnlatPosn();
        LnNutation nutation = new LnNutation();
        Solar.ln_get_solar_geom_coords(JD, sol);
        new Nutation().ln_get_nutation(JD, nutation);
        sol.L += nutation.longitude;
        double aberration = 1.581003086419753E-5 / sol.R;
        sol.L -= aberration;
        LB.lat = sol.B;
        LB.lng = sol.L;
        Transform.ln_get_equ_from_ecl(LB, JD, position);
    }

    public static void ln_get_solar_ecl_coords(double JD, LnLnlatPosn position) {
        LnHelioPosn sol = new LnHelioPosn();
        LnNutation nutation = new LnNutation();
        Solar.ln_get_solar_geom_coords(JD, sol);
        new Nutation().ln_get_nutation(JD, nutation);
        sol.L += nutation.longitude;
        double aberration = 1.581003086419753E-5 / sol.R;
        sol.L -= aberration;
        position.lng = sol.L;
        position.lat = sol.B;
    }

    public static void ln_get_solar_geo_coords(double JD, LnRectPosn position) {
        LnHelioPosn sol = new LnHelioPosn();
        Earth.ln_get_earth_helio_coords(JD, sol);
        Transform.ln_get_rect_from_helio(sol, position);
        position.X *= -1.0;
        position.Y *= -1.0;
        position.Z *= -1.0;
    }

    public static int ln_get_solar_rst_horizon(double JD, LnLnlatPosn observer, double horizon, LnRstTime rst) {
        return RiseSet.ln_get_body_rst_horizon(JD, observer, new IGetEquBodyCoords(){

            @Override
            public void get_equ_body_coords(double JD, LnEquPosn position) {
                Solar.ln_get_solar_equ_coords(JD, position);
            }
        }, horizon, rst);
    }

    public static int ln_get_solar_rst(double JD, LnLnlatPosn observer, LnRstTime rst) {
        return Solar.ln_get_solar_rst_horizon(JD, observer, -0.8333, rst);
    }

    public static double ln_get_solar_sdiam(double JD) {
        double So = 959.63;
        double dist = Earth.ln_get_earth_solar_dist(JD);
        return So / dist;
    }
}

