/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt.solarsystem;

import de.kah2.zodiac.nova4jmt.RiseSet;
import de.kah2.zodiac.nova4jmt.Transform;
import de.kah2.zodiac.nova4jmt.Utility;
import de.kah2.zodiac.nova4jmt.Vsop87;
import de.kah2.zodiac.nova4jmt.api.LnEquPosn;
import de.kah2.zodiac.nova4jmt.api.LnHelioPosn;
import de.kah2.zodiac.nova4jmt.api.LnLnlatPosn;
import de.kah2.zodiac.nova4jmt.api.LnRectPosn;
import de.kah2.zodiac.nova4jmt.api.LnRstTime;
import de.kah2.zodiac.nova4jmt.solarsystem.Earth;
import de.kah2.zodiac.nova4jmt.solarsystem.Solar;
import de.kah2.zodiac.nova4jmt.util.IGetEquBodyCoords;

public class Saturn {
    static double cJD = 0.0;
    static double cL = 0.0;
    static double cB = 0.0;
    static double cR = 0.0;

    public static void ln_get_saturn_equ_coords(double JD, LnEquPosn position) {
        double c;
        double b;
        double a;
        double last;
        double delta;
        double diff;
        LnHelioPosn h_sol = new LnHelioPosn();
        LnHelioPosn h_saturn = new LnHelioPosn();
        LnRectPosn g_sol = new LnRectPosn();
        LnRectPosn g_saturn = new LnRectPosn();
        double t = 0.0;
        Solar.ln_get_solar_geom_coords(JD, h_sol);
        Transform.ln_get_rect_from_helio(h_sol, g_sol);
        do {
            last = t;
            Saturn.ln_get_saturn_helio_coords(JD - t, h_saturn);
            Transform.ln_get_rect_from_helio(h_saturn, g_saturn);
            a = g_sol.X + g_saturn.X;
            b = g_sol.Y + g_saturn.Y;
            c = g_sol.Z + g_saturn.Z;
            delta = a * a + b * b + c * c;
        } while ((diff = (t = (delta = Math.sqrt(delta)) * 0.0057755183) - last) > 1.0E-4 || diff < -1.0E-4);
        double ra = Math.atan2(b, a);
        double dec = c / delta;
        dec = Math.asin(dec);
        position.ra = Utility.ln_range_degrees(Utility.ln_rad_to_deg(ra));
        position.dec = Utility.ln_rad_to_deg(dec);
    }

    public static void ln_get_saturn_helio_coords(double JD, LnHelioPosn position) {
        if (JD == cJD) {
            position.L = cL;
            position.B = cB;
            position.R = cR;
            return;
        }
        double t = (JD - 2451545.0) / 365250.0;
        double t2 = t * t;
        double t3 = t2 * t;
        double t4 = t3 * t;
        double t5 = t4 * t;
        double L0 = Vsop87.ln_calc_series(Longitude.saturn_longitude_l0, t);
        double L1 = Vsop87.ln_calc_series(Longitude.saturn_longitude_l1, t);
        double L2 = Vsop87.ln_calc_series(Longitude.saturn_longitude_l2, t);
        double L3 = Vsop87.ln_calc_series(Longitude.saturn_longitude_l3, t);
        double L4 = Vsop87.ln_calc_series(Longitude.saturn_longitude_l4, t);
        double L5 = Vsop87.ln_calc_series(Longitude.saturn_longitude_l5, t);
        position.L = L0 + L1 * t + L2 * t2 + L3 * t3 + L4 * t4 + L5 * t5;
        double B0 = Vsop87.ln_calc_series(Latitude.saturn_latitude_b0, t);
        double B1 = Vsop87.ln_calc_series(Latitude.saturn_latitude_b1, t);
        double B2 = Vsop87.ln_calc_series(Latitude.saturn_latitude_b2, t);
        double B3 = Vsop87.ln_calc_series(Latitude.saturn_latitude_b3, t);
        double B4 = Vsop87.ln_calc_series(Latitude.saturn_latitude_b4, t);
        double B5 = Vsop87.ln_calc_series(Latitude.saturn_latitude_b5, t);
        position.B = B0 + B1 * t + B2 * t2 + B3 * t3 + B4 * t4 + B5 * t5;
        double R0 = Vsop87.ln_calc_series(Radius.saturn_radius_r0, t);
        double R1 = Vsop87.ln_calc_series(Radius.saturn_radius_r1, t);
        double R2 = Vsop87.ln_calc_series(Radius.saturn_radius_r2, t);
        double R3 = Vsop87.ln_calc_series(Radius.saturn_radius_r3, t);
        double R4 = Vsop87.ln_calc_series(Radius.saturn_radius_r4, t);
        double R5 = Vsop87.ln_calc_series(Radius.saturn_radius_r5, t);
        position.R = R0 + R1 * t + R2 * t2 + R3 * t3 + R4 * t4 + R5 * t5;
        position.L = Utility.ln_rad_to_deg(position.L);
        position.B = Utility.ln_rad_to_deg(position.B);
        position.L = Utility.ln_range_degrees(position.L);
        Vsop87.ln_vsop87_to_fk5(position, JD);
        cJD = JD;
        cL = position.L;
        cB = position.B;
        cR = position.R;
    }

    public static double ln_get_saturn_earth_dist(double JD) {
        LnHelioPosn h_saturn = new LnHelioPosn();
        LnHelioPosn h_earth = new LnHelioPosn();
        LnRectPosn g_saturn = new LnRectPosn();
        LnRectPosn g_earth = new LnRectPosn();
        Saturn.ln_get_saturn_helio_coords(JD, h_saturn);
        Earth.ln_get_earth_helio_coords(JD, h_earth);
        Transform.ln_get_rect_from_helio(h_saturn, g_saturn);
        Transform.ln_get_rect_from_helio(h_earth, g_earth);
        double x = g_saturn.X - g_earth.X;
        double y = g_saturn.Y - g_earth.Y;
        double z = g_saturn.Z - g_earth.Z;
        x *= x;
        y *= y;
        z *= z;
        return Math.sqrt(x + y + z);
    }

    public static double ln_get_saturn_solar_dist(double JD) {
        LnHelioPosn h_saturn = new LnHelioPosn();
        Saturn.ln_get_saturn_helio_coords(JD, h_saturn);
        return h_saturn.R;
    }

    public static double ln_get_saturn_magnitude(double JD) {
        double r = Saturn.ln_get_saturn_solar_dist(JD);
        double delta = Saturn.ln_get_saturn_earth_dist(JD);
        return -8.88 + 5.0 * Math.log10(r * delta);
    }

    public static double ln_get_saturn_disk(double JD) {
        double R = Earth.ln_get_earth_solar_dist(JD);
        double r = Saturn.ln_get_saturn_solar_dist(JD);
        double delta = Saturn.ln_get_saturn_earth_dist(JD);
        return ((r + delta) * (r + delta) - R * R) / (4.0 * r * delta);
    }

    public static double ln_get_saturn_phase(double JD) {
        double R = Earth.ln_get_earth_solar_dist(JD);
        double r = Saturn.ln_get_saturn_solar_dist(JD);
        double delta = Saturn.ln_get_saturn_earth_dist(JD);
        double i = (r * r + delta * delta - R * R) / (2.0 * r * delta);
        i = Math.acos(i);
        return Utility.ln_rad_to_deg(i);
    }

    public static int ln_get_saturn_rst(double JD, LnLnlatPosn observer, LnRstTime rst) {
        return RiseSet.ln_get_body_rst_horizon(JD, observer, new IGetEquBodyCoords(){

            @Override
            public void get_equ_body_coords(double JD, LnEquPosn position) {
                Saturn.ln_get_saturn_equ_coords(JD, position);
            }
        }, RiseSet.LN_STAR_STANDART_HORIZON.doubleValue(), rst);
    }

    public static double ln_get_saturn_equ_sdiam(double JD) {
        double So = 82.73;
        double dist = Saturn.ln_get_saturn_earth_dist(JD);
        return So / dist;
    }

    public static double ln_get_saturn_pol_sdiam(double JD) {
        double So = 73.82;
        double dist = Saturn.ln_get_saturn_earth_dist(JD);
        return So / dist;
    }

    public static void ln_get_saturn_rect_helio(double JD, LnRectPosn position) {
        LnHelioPosn saturn = new LnHelioPosn();
        Saturn.ln_get_saturn_helio_coords(JD, saturn);
        Transform.ln_get_rect_from_helio(saturn, position);
    }

    static class Radius {
        private static final Vsop87.LnVsop[] saturn_radius_r0 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(9.55758135486, 0.0, 0.0), new Vsop87.LnVsop(0.52921382865, 2.39226219573, 213.299095438), new Vsop87.LnVsop(0.01873679867, 5.2354960466, 206.1855484372), new Vsop87.LnVsop(0.01464663929, 1.64763042902, 426.598190876), new Vsop87.LnVsop(0.00821891141, 5.93520042303, 316.3918696566), new Vsop87.LnVsop(0.00547506923, 5.0153261898, 103.0927742186), new Vsop87.LnVsop(0.0037168465, 2.27114821115, 220.4126424388), new Vsop87.LnVsop(0.00361778765, 3.13904301847, 7.1135470008), new Vsop87.LnVsop(0.00140617506, 5.70406606781, 632.7837393132), new Vsop87.LnVsop(0.00108974848, 3.29313390175, 110.2063212194), new Vsop87.LnVsop(6.9006962E-4, 5.94099540992, 419.4846438752), new Vsop87.LnVsop(6.1053367E-4, 0.94037691801, 639.897286314), new Vsop87.LnVsop(4.8913294E-4, 1.55733638681, 202.2533951741), new Vsop87.LnVsop(3.4143772E-4, 0.19519102597, 277.0349937414), new Vsop87.LnVsop(3.2401773E-4, 5.47084567016, 949.1756089698), new Vsop87.LnVsop(2.0936596E-4, 0.46349251129, 735.8765135318), new Vsop87.LnVsop(2.08393E-4, 1.52102476129, 433.7117378768), new Vsop87.LnVsop(2.0746751E-4, 5.33255457763, 199.0720014364), new Vsop87.LnVsop(1.5298404E-4, 3.0594381494, 529.6909650946), new Vsop87.LnVsop(1.4296484E-4, 2.60433479142, 323.5054166574), new Vsop87.LnVsop(1.1993338E-4, 5.98050967385, 846.0828347512), new Vsop87.LnVsop(1.1380257E-4, 1.7310542704, 522.5774180938), new Vsop87.LnVsop(1.2884624E-4, 1.64890652873, 138.5174968707), new Vsop87.LnVsop(7.752664E-5, 5.85190720634, 95.9792272178), new Vsop87.LnVsop(9.796004E-5, 5.20477537945, 1265.5674786264), new Vsop87.LnVsop(6.465823E-5, 0.17732249942, 1052.2683831884), new Vsop87.LnVsop(6.770608E-5, 3.00432308205, 14.2270940016), new Vsop87.LnVsop(5.850459E-5, 1.45520063003, 415.5524906121), new Vsop87.LnVsop(5.30742E-5, 0.597422002, 63.7358983034), new Vsop87.LnVsop(4.695487E-5, 2.14913875148, 227.5261894396), new Vsop87.LnVsop(4.044055E-5, 1.64006628713, 209.3669421749), new Vsop87.LnVsop(3.688237E-5, 0.78017261355, 412.3710968744), new Vsop87.LnVsop(3.376576E-5, 3.69526804193, 224.3447957019), new Vsop87.LnVsop(2.885428E-5, 1.38764476428, 838.9692877504), new Vsop87.LnVsop(2.975955E-5, 5.6846913175, 210.1177017003), new Vsop87.LnVsop(3.419618E-5, 4.94550542171, 1581.959348283), new Vsop87.LnVsop(3.460944E-5, 1.8508869805, 175.1660598002), new Vsop87.LnVsop(3.400702E-5, 0.55385265588, 350.3321196004), new Vsop87.LnVsop(2.507656E-5, 3.53854849756, 742.9900605326), new Vsop87.LnVsop(2.448261E-5, 6.18411000897, 1368.660252845), new Vsop87.LnVsop(2.406134E-5, 2.96557066697, 117.3198682202), new Vsop87.LnVsop(2.8811E-5, 0.17962517668, 853.196381752), new Vsop87.LnVsop(2.173933E-5, 0.01504273441, 340.7708920448), new Vsop87.LnVsop(2.024755E-5, 5.05404443168, 11.0457002639), new Vsop87.LnVsop(1.740284E-5, 2.34658553206, 309.2783226558), new Vsop87.LnVsop(1.861491E-5, 5.93369815396, 625.6701923124), new Vsop87.LnVsop(1.888373E-5, 0.02965674854, 3.9321532631), new Vsop87.LnVsop(1.610962E-5, 1.17294612833, 74.7815985673), new Vsop87.LnVsop(1.462651E-5, 1.92592107843, 216.4804891757), new Vsop87.LnVsop(1.474674E-5, 5.67670456599, 203.7378678824), new Vsop87.LnVsop(1.395118E-5, 5.93681366484, 127.4717966068), new Vsop87.LnVsop(1.781073E-5, 0.76321113173, 217.2312487011), new Vsop87.LnVsop(1.817173E-5, 5.77721016746, 490.3340891794), new Vsop87.LnVsop(1.472651E-5, 1.40074361969, 137.0330241624), new Vsop87.LnVsop(1.304238E-5, 0.77242217158, 647.0108333148), new Vsop87.LnVsop(1.149625E-5, 5.74018465658, 1162.4747044078), new Vsop87.LnVsop(1.12666E-5, 4.46695542616, 265.9892934775), new Vsop87.LnVsop(1.277624E-5, 2.98416387533, 1059.3819301892), new Vsop87.LnVsop(1.207069E-5, 0.75304212507, 351.8165923087), new Vsop87.LnVsop(1.071373E-5, 1.13559402672, 1155.361157407), new Vsop87.LnVsop(1.020836E-5, 5.912164079, 1685.0521225016), new Vsop87.LnVsop(1.314853E-5, 5.11211291628, 211.8146227297), new Vsop87.LnVsop(1.295446E-5, 4.69181789263, 1898.3512179396), new Vsop87.LnVsop(1.099067E-5, 1.81772713286, 149.5631971346), new Vsop87.LnVsop(9.987E-6, 2.63153637392, 200.7689224658), new Vsop87.LnVsop(9.85887E-6, 2.25994579127, 956.2891559706), new Vsop87.LnVsop(9.32498E-6, 3.6697651607, 554.0699874828), new Vsop87.LnVsop(6.64378E-6, 0.60293797633, 728.762966531), new Vsop87.LnVsop(6.59773E-6, 4.66626568448, 195.1398481733), new Vsop87.LnVsop(6.1773E-6, 5.62079509269, 942.062061969), new Vsop87.LnVsop(6.26321E-6, 5.9422380524, 1478.8665740644), new Vsop87.LnVsop(4.82324E-6, 1.8404847559, 479.2883889155), new Vsop87.LnVsop(4.88024E-6, 2.79370056377, 3.1813937377), new Vsop87.LnVsop(4.69977E-6, 0.83852490947, 1471.7530270636), new Vsop87.LnVsop(4.51795E-6, 5.64511397088, 2001.4439921582), new Vsop87.LnVsop(5.53115E-6, 3.41113180428, 269.9214467406), new Vsop87.LnVsop(5.34419E-6, 1.26448338991, 275.5505210331), new Vsop87.LnVsop(4.72465E-6, 1.881976479, 515.463871093), new Vsop87.LnVsop(4.05564E-6, 1.63989371862, 536.8045120954), new Vsop87.LnVsop(5.16979E-6, 4.44301732436, 2214.7430875962), new Vsop87.LnVsop(4.53031E-6, 3.00355936608, 302.164775655), new Vsop87.LnVsop(4.94358E-6, 2.28631779029, 278.5194664497), new Vsop87.LnVsop(4.89957E-6, 5.80627763476, 191.2076949102), new Vsop87.LnVsop(4.27438E-6, 0.05728625421, 284.1485407422), new Vsop87.LnVsop(3.39681E-6, 1.40193253039, 440.8252848776), new Vsop87.LnVsop(3.40671E-6, 0.89095123731, 628.8515860501), new Vsop87.LnVsop(3.85941E-6, 1.99711336197, 1272.6810256272), new Vsop87.LnVsop(2.88229E-6, 1.12166658438, 422.6660376129), new Vsop87.LnVsop(2.9413E-6, 0.42566345584, 312.1990839626), new Vsop87.LnVsop(2.6248E-6, 0.31730778329, 1045.1548361876), new Vsop87.LnVsop(2.95348E-6, 0.67123785008, 88.865680217), new Vsop87.LnVsop(3.42778E-6, 5.85587331618, 1795.258443721), new Vsop87.LnVsop(3.41376E-6, 2.37619847718, 525.4981794006), new Vsop87.LnVsop(2.3384E-6, 4.22716164833, 114.1384744825), new Vsop87.LnVsop(2.23693E-6, 2.28109311966, 330.6189636582), new Vsop87.LnVsop(2.75816E-6, 0.47831420035, 38.1330356378), new Vsop87.LnVsop(2.24509E-6, 0.54737895493, 1788.1448967202), new Vsop87.LnVsop(3.03382E-6, 0.87951215556, 6069.7767545534), new Vsop87.LnVsop(2.92033E-6, 6.21435200687, 210.8514148832), new Vsop87.LnVsop(2.26021E-6, 0.37470024598, 142.4496501338), new Vsop87.LnVsop(2.77361E-6, 5.32007209923, 692.5874843535), new Vsop87.LnVsop(2.42981E-6, 5.3719132247, 1258.4539316256), new Vsop87.LnVsop(2.05518E-6, 0.95727934819, 288.0806940053), new Vsop87.LnVsop(2.07418E-6, 5.38074389449, 2317.8358618148), new Vsop87.LnVsop(1.86792E-6, 6.03513906344, 404.5067903482), new Vsop87.LnVsop(2.18728E-6, 5.25467962646, 212.3358875915), new Vsop87.LnVsop(2.21952E-6, 5.94565685178, 39.3568759152), new Vsop87.LnVsop(1.79461E-6, 4.4108886003, 408.4389436113), new Vsop87.LnVsop(2.41484E-6, 1.12472797872, 388.4651552382), new Vsop87.LnVsop(1.97242E-6, 3.90215848857, 52.6901980395), new Vsop87.LnVsop(2.36745E-6, 0.90816434282, 1375.7737998458), new Vsop87.LnVsop(1.72018E-6, 5.56321647759, 213.3472795478), new Vsop87.LnVsop(1.69893E-6, 2.85627663958, 99.1606209555), new Vsop87.LnVsop(2.14211E-6, 4.20220398238, 2531.1349572528), new Vsop87.LnVsop(1.71967E-6, 2.365497404, 213.2509113282), new Vsop87.LnVsop(1.65592E-6, 2.63731901847, 215.7467759928), new Vsop87.LnVsop(2.30764E-6, 5.49430203101, 191.9584544356), new Vsop87.LnVsop(1.77457E-6, 0.3813183367, 430.5303441391), new Vsop87.LnVsop(1.91521E-6, 2.95905308803, 437.6438911399), new Vsop87.LnVsop(1.63278E-6, 3.45811838277, 617.8058857862), new Vsop87.LnVsop(1.62306E-6, 5.73059706733, 203.0041546995), new Vsop87.LnVsop(1.75037E-6, 5.71409014243, 1066.49547719), new Vsop87.LnVsop(1.82912E-6, 5.66913964019, 2111.6503133776), new Vsop87.LnVsop(1.50093E-6, 4.40713052025, 417.0369633204), new Vsop87.LnVsop(1.87955E-6, 6.07914706117, 563.6312150384), new Vsop87.LnVsop(1.44751E-6, 5.081154075, 423.4167971383), new Vsop87.LnVsop(1.37424E-6, 5.43711941387, 222.8603229936), new Vsop87.LnVsop(1.72859E-6, 1.84924132022, 1589.0728952838), new Vsop87.LnVsop(1.65367E-6, 2.89085128458, 214.2623032845), new Vsop87.LnVsop(1.45738E-6, 1.56566786572, 831.8557407496), new Vsop87.LnVsop(1.76715E-6, 2.3025051169, 9999.986450773), new Vsop87.LnVsop(1.29054E-6, 2.5532773604, 414.0680179038), new Vsop87.LnVsop(1.20072E-6, 0.04355666836, 1361.5467058442), new Vsop87.LnVsop(1.43538E-6, 0.99839503339, 76.2660712756), new Vsop87.LnVsop(1.08866E-6, 2.092391991, 207.6700211455), new Vsop87.LnVsop(1.31903E-6, 2.85788215274, 312.4597163935), new Vsop87.LnVsop(1.12006E-6, 0.26268721967, 2104.5367663768), new Vsop87.LnVsop(1.25243E-6, 4.78336081984, 205.2223405907), new Vsop87.LnVsop(1.04426E-6, 3.63700546876, 65.2203710117), new Vsop87.LnVsop(1.07397E-6, 3.66971473274, 212.7778305762), new Vsop87.LnVsop(1.08678E-6, 2.85493119127, 21.3406410024), new Vsop87.LnVsop(9.7432E-7, 5.12133810135, 2634.2277314714), new Vsop87.LnVsop(1.09144E-6, 1.6323570202, 208.633228992), new Vsop87.LnVsop(9.6681E-7, 4.19670884921, 305.3461693927), new Vsop87.LnVsop(9.6356E-7, 2.56061375123, 1692.1656695024), new Vsop87.LnVsop(8.595E-7, 4.54551656203, 210.3783341312), new Vsop87.LnVsop(9.9199E-7, 5.13700784528, 1574.8458012822), new Vsop87.LnVsop(1.12586E-6, 5.03077528575, 703.6331846174), new Vsop87.LnVsop(8.382E-7, 1.18242417124, 429.7795846137), new Vsop87.LnVsop(8.9023E-7, 5.38777022, 107.0249274817), new Vsop87.LnVsop(1.10307E-6, 2.43652629097, 355.7487455718), new Vsop87.LnVsop(9.0436E-7, 4.20939381417, 213.8203602998), new Vsop87.LnVsop(9.5576E-7, 5.44345029853, 2428.0421830342), new Vsop87.LnVsop(9.4196E-7, 2.39809539458, 483.2205421786), new Vsop87.LnVsop(8.5658E-7, 0.03212125891, 860.3099287528), new Vsop87.LnVsop(8.8781E-7, 4.05795823648, 128.9562693151), new Vsop87.LnVsop(8.1952E-7, 1.6641358772, 62.2514255951), new Vsop87.LnVsop(9.0968E-7, 3.96769274342, 2847.5268269094), new Vsop87.LnVsop(8.4136E-7, 4.60800956822, 177.8743727859), new Vsop87.LnVsop(8.8291E-7, 3.86573756854, 140.001969579), new Vsop87.LnVsop(9.3309E-7, 0.73847907603, 831.1049812242), new Vsop87.LnVsop(9.195E-7, 2.94820357852, 35.4247226521), new Vsop87.LnVsop(9.6733E-7, 4.84623402274, 131.4039498699), new Vsop87.LnVsop(8.6987E-7, 1.33651321637, 1905.4647649404), new Vsop87.LnVsop(7.1036E-7, 0.99289997732, 405.2575498736), new Vsop87.LnVsop(9.5225E-7, 2.51496477958, 2.4476805548), new Vsop87.LnVsop(7.25E-7, 4.63319492132, 245.5424243524), new Vsop87.LnVsop(8.2455E-7, 1.52813728425, 145.6310438715), new Vsop87.LnVsop(7.678E-7, 3.15262144591, 767.3690829208), new Vsop87.LnVsop(7.0362E-7, 4.04036200412, 173.9422195228), new Vsop87.LnVsop(8.619E-7, 2.29886507805, 85.8272988312), new Vsop87.LnVsop(6.6726E-7, 4.75093122174, 70.8494453042), new Vsop87.LnVsop(6.5893E-7, 2.4729931125, 280.9671470045), new Vsop87.LnVsop(6.5129E-7, 0.09259103795, 9.5612275556), new Vsop87.LnVsop(7.1669E-7, 0.01187527275, 565.1156877467), new Vsop87.LnVsop(6.6488E-7, 1.08200099735, 339.2864193365), new Vsop87.LnVsop(6.3441E-7, 2.01741294636, 234.6397364404), new Vsop87.LnVsop(6.0956E-7, 5.11950202312, 756.3233826569), new Vsop87.LnVsop(5.7792E-7, 6.05712220674, 1677.9385755008), new Vsop87.LnVsop(6.4168E-7, 1.28718951847, 1148.2476104062), new Vsop87.LnVsop(7.3324E-7, 4.3782396964, 425.1137181677), new Vsop87.LnVsop(5.7179E-7, 6.26635812249, 2420.9286360334), new Vsop87.LnVsop(5.5012E-7, 3.85870982169, 342.2553647531), new Vsop87.LnVsop(5.5347E-7, 1.6036662959, 543.0242872189), new Vsop87.LnVsop(6.4075E-7, 4.09799744422, 327.4375699205), new Vsop87.LnVsop(5.7804E-7, 5.46967524925, 347.8844390456), new Vsop87.LnVsop(7.3568E-7, 3.72317864427, 92.0470739547), new Vsop87.LnVsop(7.365E-7, 3.57067095117, 1.4844727083), new Vsop87.LnVsop(6.5011E-7, 2.44916996344, 267.4737661858), new Vsop87.LnVsop(5.4545E-7, 3.71490034335, 344.7030453079), new Vsop87.LnVsop(4.9834E-7, 3.93491116778, 192.6921676185), new Vsop87.LnVsop(4.9536E-7, 3.22835315683, 333.657345044), new Vsop87.LnVsop(4.7617E-7, 3.92991700611, 199.2844497575), new Vsop87.LnVsop(4.9487E-7, 4.90287053223, 217.491881132), new Vsop87.LnVsop(4.639E-7, 2.63757382235, 10.2949407385), new Vsop87.LnVsop(6.2822E-7, 4.40222532856, 214.7835681463), new Vsop87.LnVsop(4.6317E-7, 2.0959781782, 212.5483359126), new Vsop87.LnVsop(5.4399E-7, 1.06837441326, 362.8622925726), new Vsop87.LnVsop(5.8898E-7, 2.62274564952, 225.8292684102), new Vsop87.LnVsop(4.8458E-7, 3.15145995815, 216.2198567448), new Vsop87.LnVsop(4.6304E-7, 4.86526668367, 2950.619601128), new Vsop87.LnVsop(4.6012E-7, 4.97405657859, 198.321241911), new Vsop87.LnVsop(4.668E-7, 2.44971808455, 207.1487562837), new Vsop87.LnVsop(4.4544E-7, 1.77853306195, 223.5940361765), new Vsop87.LnVsop(4.4526E-7, 5.55789993555, 264.5048207692), new Vsop87.LnVsop(5.5807E-7, 4.29420266501, 329.7251917809), new Vsop87.LnVsop(4.947E-7, 5.2071040339, 2744.4340526908), new Vsop87.LnVsop(5.8832E-7, 4.23073251588, 700.6642392008), new Vsop87.LnVsop(5.2681E-7, 3.79401248595, 343.2185725996), new Vsop87.LnVsop(4.1599E-7, 0.74365516186, 125.9873238985), new Vsop87.LnVsop(5.6184E-7, 2.06967234741, 124.433415221), new Vsop87.LnVsop(4.7914E-7, 2.38951194877, 207.8824694666), new Vsop87.LnVsop(4.3427E-7, 1.83764074596, 106.2741679563), new Vsop87.LnVsop(3.9822E-7, 4.00880264668, 12.5301729722), new Vsop87.LnVsop(5.3915E-7, 4.97995268146, 134.5853436076), new Vsop87.LnVsop(4.9974E-7, 5.75533228241, 320.3240229197), new Vsop87.LnVsop(4.6661E-7, 2.06519866248, 2008.557539159), new Vsop87.LnVsop(4.4845E-7, 5.35638703411, 218.9281697305), new Vsop87.LnVsop(4.0789E-7, 4.92568693313, 1891.2376709388), new Vsop87.LnVsop(4.2917E-7, 0.39624025575, 357.4456666012), new Vsop87.LnVsop(3.7986E-7, 2.06627721117, 247.2393453818), new Vsop87.LnVsop(4.8733E-7, 5.32762223699, 3127.3133312618), new Vsop87.LnVsop(4.108E-7, 2.47538730007, 237.6781178262), new Vsop87.LnVsop(3.4595E-7, 5.62346550573, 99.9113804809), new Vsop87.LnVsop(4.0736E-7, 4.08372789207, 621.7380390493), new Vsop87.LnVsop(3.4217E-7, 0.73134343646, 750.1036075334), new Vsop87.LnVsop(3.397E-7, 5.31274574257, 206.233732547), new Vsop87.LnVsop(3.6432E-7, 1.68823737636, 22.0914005278), new Vsop87.LnVsop(3.9263E-7, 3.4565924439, 241.6102710893), new Vsop87.LnVsop(3.9247E-7, 4.39637044405, 18.1592472647), new Vsop87.LnVsop(3.4703E-7, 2.24942082303, 487.3651437628), new Vsop87.LnVsop(3.3115E-7, 4.86602845858, 209.106309744), new Vsop87.LnVsop(3.2805E-7, 1.06026635194, 252.6559713532), new Vsop87.LnVsop(3.9031E-7, 3.73882100198, 3163.918696566), new Vsop87.LnVsop(3.2427E-7, 2.22874162802, 319.5732633943), new Vsop87.LnVsop(3.4475E-7, 1.82451837226, 380.12776796), new Vsop87.LnVsop(4.1741E-7, 0.08219629974, 210.3301500214), new Vsop87.LnVsop(3.3602E-7, 5.80228769156, 251.4321310758), new Vsop87.LnVsop(3.1221E-7, 1.96490815234, 244.318584075), new Vsop87.LnVsop(3.482E-7, 5.96330410021, 217.964961884), new Vsop87.LnVsop(3.8505E-7, 4.43924639932, 160.6088973985), new Vsop87.LnVsop(3.6106E-7, 3.83276808968, 56.6223513026), new Vsop87.LnVsop(3.0287E-7, 2.25797096745, 1169.5882514086), new Vsop87.LnVsop(3.1085E-7, 4.90133840375, 144.1465711632), new Vsop87.LnVsop(3.2208E-7, 3.57884943983, 231.4583427027), new Vsop87.LnVsop(2.8857E-7, 5.80423567126, 1994.3304451574), new Vsop87.LnVsop(3.2178E-7, 2.13176978399, 206.1373643274), new Vsop87.LnVsop(3.1795E-7, 3.81800770982, 73.297125859), new Vsop87.LnVsop(2.9001E-7, 2.21676176185, 14.977853527), new Vsop87.LnVsop(3.4903E-7, 5.6522370985, 497.4476361802), new Vsop87.LnVsop(3.2246E-7, 1.92866027151, 98.8999885246), new Vsop87.LnVsop(3.2119E-7, 0.99531311844, 1464.6394800628), new Vsop87.LnVsop(2.9114E-7, 5.98247860339, 2737.32050569), new Vsop87.LnVsop(3.6706E-7, 4.75493516593, 348.8476468921), new Vsop87.LnVsop(2.7506E-7, 6.12108141844, 214.0498549634), new Vsop87.LnVsop(2.8512E-7, 1.68678188105, 78.7137518304), new Vsop87.LnVsop(2.7266E-7, 0.2424126514, 313.2104759189), new Vsop87.LnVsop(2.8789E-7, 0.04439781853, 5.6290742925), new Vsop87.LnVsop(3.2512E-7, 3.77917498543, 33.9402499438), new Vsop87.LnVsop(3.5016E-7, 3.43495537908, 273.1028404783), new Vsop87.LnVsop(2.713E-7, 5.20559983787, 148.0787244263), new Vsop87.LnVsop(3.3098E-7, 2.44781346214, 969.6224780949), new Vsop87.LnVsop(2.7876E-7, 1.4445798235, 258.8757464767), new Vsop87.LnVsop(2.7324E-7, 4.2603169255, 179.3588454942), new Vsop87.LnVsop(2.9185E-7, 4.84536228119, 905.8865797915), new Vsop87.LnVsop(2.7869E-7, 0.78770357978, 546.956440482), new Vsop87.LnVsop(2.757E-7, 2.4521432165, 254.9435932136), new Vsop87.LnVsop(2.893E-7, 6.03256439022, 188.9200730498), new Vsop87.LnVsop(3.4313E-7, 6.00978682828, 166.828672522), new Vsop87.LnVsop(2.5943E-7, 0.65129538567, 654.1243803156), new Vsop87.LnVsop(3.3574E-7, 1.23583695762, 2221.856634597), new Vsop87.LnVsop(2.4357E-7, 0.52261322301, 894.8408795276), new Vsop87.LnVsop(2.7769E-7, 5.17801023424, 5.4166259714), new Vsop87.LnVsop(2.5596E-7, 3.35872554982, 0.9632078465), new Vsop87.LnVsop(2.2984E-7, 3.5246592021, 458.8415197904), new Vsop87.LnVsop(2.4471E-7, 0.00612626886, 69.1525242748), new Vsop87.LnVsop(2.8688E-7, 0.76245403349, 488.8496164711), new Vsop87.LnVsop(2.3664E-7, 2.54807644282, 196.6243208816), new Vsop87.LnVsop(2.5432E-7, 5.28932962898, 636.7158925763), new Vsop87.LnVsop(3.1152E-7, 2.04977568414, 282.4516197128), new Vsop87.LnVsop(2.5224E-7, 4.97246368293, 3060.8259223474), new Vsop87.LnVsop(2.9605E-7, 3.92681945757, 206.706813299), new Vsop87.LnVsop(2.2223E-7, 3.25151461044, 681.5417840896), new Vsop87.LnVsop(2.7913E-7, 2.72520521957, 32.2433289144), new Vsop87.LnVsop(2.2107E-7, 4.75818706798, 213.1872208534), new Vsop87.LnVsop(2.1662E-7, 4.61542319262, 3267.0114707846), new Vsop87.LnVsop(2.7048E-7, 2.86264558816, 24.3790223882), new Vsop87.LnVsop(2.2107E-7, 3.16802956645, 213.4109700226), new Vsop87.LnVsop(2.0731E-7, 1.67138184255, 274.0660483248), new Vsop87.LnVsop(2.5352E-7, 5.12122578609, 168.0525127994), new Vsop87.LnVsop(2.8E-7, 4.72415728042, 552.5855147745), new Vsop87.LnVsop(2.6154E-7, 1.59534268938, 491.8185618877), new Vsop87.LnVsop(2.1984E-7, 0.87565381783, 635.9651330509), new Vsop87.LnVsop(2.7121E-7, 5.53473514339, 555.5544601911), new Vsop87.LnVsop(2.5282E-7, 1.78091725384, 182.279606801), new Vsop87.LnVsop(1.9559E-7, 2.14658471778, 54.1746707478), new Vsop87.LnVsop(2.702E-7, 3.57938591854, 561.1835344836), new Vsop87.LnVsop(2.1398E-7, 3.86074898701, 116.4260963429), new Vsop87.LnVsop(1.988E-7, 5.59172876182, 4.192785694), new Vsop87.LnVsop(1.9455E-7, 0.10611239153, 218.7157214094), new Vsop87.LnVsop(1.9933E-7, 2.90526601486, 120.358249606), new Vsop87.LnVsop(2.5474E-7, 1.62678013615, 2324.9494088156), new Vsop87.LnVsop(2.5565E-7, 2.09824642636, 248.7238180901), new Vsop87.LnVsop(1.9858E-7, 2.5207926516, 1485.9801210652), new Vsop87.LnVsop(1.8516E-7, 2.54810951896, 213.5115437591), new Vsop87.LnVsop(1.8516E-7, 5.3775511051, 213.0866471169), new Vsop87.LnVsop(1.977E-7, 0.0753938129, 842.1506814881), new Vsop87.LnVsop(2.366E-7, 1.60734696991, 738.7972748386), new Vsop87.LnVsop(2.0404E-7, 2.95125083804, 59.8037450403), new Vsop87.LnVsop(2.4267E-7, 3.15706315958, 240.3864308119), new Vsop87.LnVsop(1.8338E-7, 3.18779671933, 295.0512286542), new Vsop87.LnVsop(1.7466E-7, 2.90466924741, 477.8039162072), new Vsop87.LnVsop(2.0744E-7, 1.0646867375, 494.2662424425), new Vsop87.LnVsop(2.0425E-7, 1.8415240439, 533.6231183577), new Vsop87.LnVsop(2.1401E-7, 0.64115941242, 189.7232222019), new Vsop87.LnVsop(1.6379E-7, 3.9827987735, 2.9207613068), new Vsop87.LnVsop(1.6058E-7, 0.59325161303, 746.9222137957), new Vsop87.LnVsop(1.7014E-7, 4.74645535598, 2207.6295405954), new Vsop87.LnVsop(2.0479E-7, 6.05098286202, 173.6815870919), new Vsop87.LnVsop(1.5443E-7, 1.49110952141, 543.9180590962), new Vsop87.LnVsop(1.9833E-7, 4.93811673788, 121.2520214833), new Vsop87.LnVsop(1.7073E-7, 0.71316728361, 1781.0313497194), new Vsop87.LnVsop(1.7213E-7, 0.67923942083, 151.0476698429), new Vsop87.LnVsop(1.5031E-7, 5.52780819403, 2310.722314814), new Vsop87.LnVsop(1.5525E-7, 5.71027236377, 3053.7123753466), new Vsop87.LnVsop(1.5852E-7, 4.45624558241, 643.8294395771), new Vsop87.LnVsop(1.6033E-7, 0.63293747499, 358.9301393095), new Vsop87.LnVsop(1.4591E-7, 5.26184260227, 472.1748419147), new Vsop87.LnVsop(1.6544E-7, 3.52801242983, 3480.3105662226), new Vsop87.LnVsop(1.8834E-7, 0.55399472524, 4.665866446), new Vsop87.LnVsop(1.7549E-7, 2.26583782913, 672.1406152284), new Vsop87.LnVsop(1.8022E-7, 2.71080286082, 181.806526049), new Vsop87.LnVsop(1.5918E-7, 5.23473369828, 135.5485514541), new Vsop87.LnVsop(1.3931E-7, 3.19357128657, 213.5597278689), new Vsop87.LnVsop(1.4074E-7, 0.80929029505, 221.3758502853), new Vsop87.LnVsop(1.3931E-7, 4.73208739639, 213.0384630071), new Vsop87.LnVsop(1.4594E-7, 2.65461071698, 292.0128472684), new Vsop87.LnVsop(1.4383E-7, 0.21121098879, 235.3904959658), new Vsop87.LnVsop(1.6173E-7, 0.91043299219, 280.003939158), new Vsop87.LnVsop(1.3328E-7, 3.54955934512, 205.6642835754), new Vsop87.LnVsop(1.6559E-7, 5.3889675375, 424.1505103212), new Vsop87.LnVsop(1.6104E-7, 0.82547975762, 176.6505325085), new Vsop87.LnVsop(1.2726E-7, 0.75928182731, 721.6494195302), new Vsop87.LnVsop(1.2745E-7, 3.55415994159, 153.4953503977), new Vsop87.LnVsop(1.4455E-7, 0.12149539513, 313.6835566709), new Vsop87.LnVsop(1.6497E-7, 3.26380729084, 6283.0758499914), new Vsop87.LnVsop(1.6566E-7, 1.62651930127, 5856.4776591154), new Vsop87.LnVsop(1.5039E-7, 1.25437397471, 2641.3412784722), new Vsop87.LnVsop(1.5688E-7, 1.1894072881, 486.4019359163), new Vsop87.LnVsop(1.1898E-7, 0.91072314364, 416.3032501375), new Vsop87.LnVsop(1.1709E-7, 1.10722547914, 81.7521332162), new Vsop87.LnVsop(1.2984E-7, 4.74370547048, 3377.217792004), new Vsop87.LnVsop(1.3213E-7, 4.95593892766, 1279.794572628), new Vsop87.LnVsop(1.6123E-7, 0.98390715272, 2538.2485042536), new Vsop87.LnVsop(1.4673E-7, 2.63437960547, 618.5566453116), new Vsop87.LnVsop(1.1539E-7, 0.63828316888, 28.3111756513), new Vsop87.LnVsop(1.1339E-7, 4.36553205735, 3583.4033404412), new Vsop87.LnVsop(1.4901E-7, 1.75796184641, 569.0478410098), new Vsop87.LnVsop(1.1246E-7, 5.9919115557, 193.655375465), new Vsop87.LnVsop(1.4753E-7, 2.92291248767, 167.0893049529), new Vsop87.LnVsop(1.2755E-7, 3.61745093436, 67.6680515665), new Vsop87.LnVsop(1.3536E-7, 2.50325109462, 1802.3719907218), new Vsop87.LnVsop(1.2238E-7, 0.27162703042, 1044.4040766622), new Vsop87.LnVsop(1.1034E-7, 6.28008547861, 629.6023455755), new Vsop87.LnVsop(1.4387E-7, 0.38039001729, 601.7642506762), new Vsop87.LnVsop(1.231E-7, 2.18899826214, 650.9429865779), new Vsop87.LnVsop(1.0854E-7, 0.14262616333, 501.3797894433), new Vsop87.LnVsop(1.5105E-7, 2.6715208815, 46.470422916), new Vsop87.LnVsop(1.0735E-7, 2.86920913253, 113.3877149571), new Vsop87.LnVsop(1.4686E-7, 6.05254709898, 468.2426886516), new Vsop87.LnVsop(1.0576E-7, 2.06017585814, 429.0458714308), new Vsop87.LnVsop(1.2292E-7, 1.82443833563, 241.8709035202), new Vsop87.LnVsop(1.1154E-7, 1.20110507523, 172.2452984934), new Vsop87.LnVsop(1.3687E-7, 2.20307346288, 228.276948965), new Vsop87.LnVsop(1.0679E-7, 5.0736954182, 162.8965192589), new Vsop87.LnVsop(1.203E-7, 3.18736701996, 72.0732855816), new Vsop87.LnVsop(1.216E-7, 4.51222901843, 425.6349830295), new Vsop87.LnVsop(9.941E-8, 1.4988720921, 226.6324175623), new Vsop87.LnVsop(1.2101E-7, 4.14977794208, 1108.1399749656), new Vsop87.LnVsop(1.0287E-7, 2.10680007794, 1033.3583763983), new Vsop87.LnVsop(1.0771E-7, 4.68125923293, 129.9194771616), new Vsop87.LnVsop(9.592E-8, 4.80075106366, 426.6463749858), new Vsop87.LnVsop(1.2949E-7, 5.1160175613, 219.4494345923), new Vsop87.LnVsop(9.921E-8, 2.81125800889, 518.6452648307), new Vsop87.LnVsop(1.2272E-7, 5.33779805565, 776.9303104764), new Vsop87.LnVsop(9.486E-8, 4.85709302918, 820.0592809603), new Vsop87.LnVsop(1.1392E-7, 3.86350991469, 405.9912630565), new Vsop87.LnVsop(9.281E-8, 0.70440206655, 403.0223176399), new Vsop87.LnVsop(9.617E-8, 1.60410621884, 426.5500067662), new Vsop87.LnVsop(1.0112E-7, 2.7648687563, 210.5907824523), new Vsop87.LnVsop(1.0872E-7, 1.35809078598, 170.7608257851), new Vsop87.LnVsop(1.2502E-7, 6.06479177955, 875.830299001), new Vsop87.LnVsop(1.0175E-7, 2.36250012243, 685.4739373527), new Vsop87.LnVsop(1.2211E-7, 2.04456082125, 508.3503240922), new Vsop87.LnVsop(9.502E-8, 3.18475934663, 286.596221297), new Vsop87.LnVsop(1.0133E-7, 4.02559667441, 381.3516082374), new Vsop87.LnVsop(8.889E-8, 3.62576694345, 319.3126309634), new Vsop87.LnVsop(8.927E-8, 5.46319224261, 3370.1042450032), new Vsop87.LnVsop(1.0052E-7, 5.16107251039, 216.0074084237), new Vsop87.LnVsop(8.553E-8, 3.87970879218, 630.3360587584), new Vsop87.LnVsop(8.401E-8, 5.65557131026, 213.4591541324), new Vsop87.LnVsop(8.401E-8, 2.27009862215, 213.1390367436), new Vsop87.LnVsop(9.962E-8, 5.97645215717, 6.1503391543), new Vsop87.LnVsop(1.1664E-7, 0.95814408096, 694.0719570618), new Vsop87.LnVsop(8.686E-8, 2.33879748618, 220.364458329), new Vsop87.LnVsop(8.135E-8, 5.54067608923, 220.4608265486), new Vsop87.LnVsop(9.144E-8, 0.45077461958, 2097.423219376), new Vsop87.LnVsop(9.579E-8, 2.76806282069, 556.5176680376), new Vsop87.LnVsop(8.128E-8, 5.54123343077, 181.0557665236), new Vsop87.LnVsop(1.0807E-7, 0.06096432609, 691.1030116452), new Vsop87.LnVsop(9.578E-8, 2.84972091302, 184.0941479094), new Vsop87.LnVsop(9.848E-8, 2.37490871749, 945.2434557067), new Vsop87.LnVsop(8.512E-8, 0.17361504982, 289.5651667136), new Vsop87.LnVsop(8.689E-8, 0.84670554895, 2957.7331481288), new Vsop87.LnVsop(7.633E-8, 0.00567409646, 7.1617311106), new Vsop87.LnVsop(9.022E-8, 3.38436801047, 731.9443602687), new Vsop87.LnVsop(7.888E-8, 5.78452089815, 230.8252032563), new Vsop87.LnVsop(9.472E-8, 2.26694157732, 8.0767548473), new Vsop87.LnVsop(7.461E-8, 5.29596435777, 2627.1141844706), new Vsop87.LnVsop(7.616E-8, 3.1056140631, 7.065362891), new Vsop87.LnVsop(9.879E-8, 4.69447221853, 10213.285546211), new Vsop87.LnVsop(7.264E-8, 0.07122374466, 100.6450936638), new Vsop87.LnVsop(8.001E-8, 1.60939840798, 696.5196376166), new Vsop87.LnVsop(7.601E-8, 4.90123787776, 51.2057253312), new Vsop87.LnVsop(7.716E-8, 4.69702238883, 436.1594184316), new Vsop87.LnVsop(9.866E-8, 5.25569996364, 699.7010313543), new Vsop87.LnVsop(7.375E-8, 4.52777394099, 616.3214130779), new Vsop87.LnVsop(9.388E-8, 2.44919199853, 2118.7638603784), new Vsop87.LnVsop(7.3E-8, 4.0188547501, 212.0270710508), new Vsop87.LnVsop(9.071E-8, 2.75662160229, 130.4407420234), new Vsop87.LnVsop(7.175E-8, 5.62469707711, 31.492569389), new Vsop87.LnVsop(6.915E-8, 0.57642247068, 739.8086667949), new Vsop87.LnVsop(8.909E-8, 2.19570530999, 427.5613987225), new Vsop87.LnVsop(9.167E-8, 2.04679688754, 204.7010757289), new Vsop87.LnVsop(7.766E-8, 3.27192916123, 3796.7024358792), new Vsop87.LnVsop(6.842E-8, 0.55589113901, 135.336103133), new Vsop87.LnVsop(9.154E-8, 3.04674464726, 9786.687355335), new Vsop87.LnVsop(8.677E-8, 4.27082106143, 141.2258098564), new Vsop87.LnVsop(6.709E-8, 5.66109188592, 480.7728616238), new Vsop87.LnVsop(6.946E-8, 4.1235200144, 662.531203563), new Vsop87.LnVsop(7.24E-8, 3.90653111215, 214.5711198252), new Vsop87.LnVsop(6.717E-8, 4.613115875, 2524.021410252), new Vsop87.LnVsop(6.566E-8, 2.67659365854, 194.1766403268), new Vsop87.LnVsop(6.537E-8, 6.25555511414, 31.019488637), new Vsop87.LnVsop(7.484E-8, 5.56871021201, 271.4059194489), new Vsop87.LnVsop(7.956E-8, 5.04685375986, 411.620337349), new Vsop87.LnVsop(8.039E-8, 3.08941959611, 353.301065017), new Vsop87.LnVsop(7.069E-8, 1.10060234302, 282.6640680339), new Vsop87.LnVsop(6.105E-8, 0.81728612933, 593.426863398), new Vsop87.LnVsop(6.14E-8, 3.79672318503, 180.1619946463), new Vsop87.LnVsop(6.761E-8, 3.84307989405, 412.5835451955), new Vsop87.LnVsop(6.034E-8, 5.4341820396, 724.8308132679), new Vsop87.LnVsop(8.102E-8, 4.51051495778, 268.4369740323), new Vsop87.LnVsop(6.029E-8, 1.24355734058, 447.9388318784), new Vsop87.LnVsop(7.613E-8, 0.79977414552, 2854.6403739102), new Vsop87.LnVsop(7.425E-8, 2.293594419, 532.6117264014), new Vsop87.LnVsop(5.896E-8, 2.06866571185, 454.9093665273), new Vsop87.LnVsop(6.005E-8, 2.87167092054, 426.0769260142), new Vsop87.LnVsop(7.278E-8, 0.88193016589, 457.617679513), new Vsop87.LnVsop(5.744E-8, 1.73450672261, 50.4025761791), new Vsop87.LnVsop(6.355E-8, 6.27053564712, 313.9441891018), new Vsop87.LnVsop(6.193E-8, 3.99658934587, 835.0371344873), new Vsop87.LnVsop(7.429E-8, 5.38166639065, 953.1077622329), new Vsop87.LnVsop(5.813E-8, 0.52655128116, 1038.0412891868), new Vsop87.LnVsop(6.145E-8, 4.52475150505, 3693.6096616606), new Vsop87.LnVsop(5.624E-8, 0.46667684775, 610.6923387854), new Vsop87.LnVsop(6.075E-8, 3.4660945259, 278.2588340188), new Vsop87.LnVsop(5.877E-8, 5.51717146635, 1073.6090241908), new Vsop87.LnVsop(5.521E-8, 0.45012859744, 643.0786800517), new Vsop87.LnVsop(6.7E-8, 4.22406253654, 916.9322800554), new Vsop87.LnVsop(6.72E-8, 4.19624148194, 938.1299087059), new Vsop87.LnVsop(5.508E-8, 4.07398606097, 3899.7952100978), new Vsop87.LnVsop(5.441E-8, 2.79849882662, 397.3932433474), new Vsop87.LnVsop(6.134E-8, 4.90393524057, 0.5212648618), new Vsop87.LnVsop(5.695E-8, 4.11782098393, 391.1734682239), new Vsop87.LnVsop(5.754E-8, 4.42718264879, 165.6048322446), new Vsop87.LnVsop(5.4E-8, 3.2629041406, 20.6069278195), new Vsop87.LnVsop(5.879E-8, 6.17871813155, 291.262087743), new Vsop87.LnVsop(6.722E-8, 2.1862234289, 627.3671133418), new Vsop87.LnVsop(5.359E-8, 2.29438108352, 331.2096644892), new Vsop87.LnVsop(5.39E-8, 3.7428193189, 418.5214360287), new Vsop87.LnVsop(6.683E-8, 2.13438701667, 285.6330134505), new Vsop87.LnVsop(6.419E-8, 5.65171900155, 518.3846323998), new Vsop87.LnVsop(6.193E-8, 4.89768396188, 450.9772132642), new Vsop87.LnVsop(5.687E-8, 3.48764525546, 230.5645708254), new Vsop87.LnVsop(5.064E-8, 4.09065475521, 6.592282139), new Vsop87.LnVsop(5.037E-8, 2.5999065474, 66.70484372), new Vsop87.LnVsop(5.191E-8, 4.39610445378, 84.3428261229), new Vsop87.LnVsop(4.977E-8, 2.71603834658, 558.0021407459), new Vsop87.LnVsop(5.308E-8, 0.63718449606, 114.3991069134), new Vsop87.LnVsop(5.221E-8, 4.65473413721, 310.7146112543), new Vsop87.LnVsop(4.896E-8, 3.7700969923, 423.6774295692), new Vsop87.LnVsop(5.931E-8, 2.73953602204, 219.891377577), new Vsop87.LnVsop(6.357E-8, 1.4013701239, 606.7601855223), new Vsop87.LnVsop(6.528E-8, 2.95896329675, 624.919432787), new Vsop87.LnVsop(4.734E-8, 0.23182011937, 1063.3140834523), new Vsop87.LnVsop(6.408E-8, 1.1668741968, 268.9582388941), new Vsop87.LnVsop(5.179E-8, 1.95231681037, 1182.9215735329), new Vsop87.LnVsop(4.785E-8, 1.5907152341, 420.9691165835), new Vsop87.LnVsop(6.093E-8, 0.30791927132, 524.0137066923), new Vsop87.LnVsop(5.161E-8, 0.14373018373, 2413.8150890326), new Vsop87.LnVsop(4.854E-8, 5.21382590347, 3686.4961146598), new Vsop87.LnVsop(4.648E-8, 3.71025478809, 305.0855369618), new Vsop87.LnVsop(5.072E-8, 1.7325757494, 337.732510659), new Vsop87.LnVsop(4.926E-8, 2.12141378228, 104.0559820651), new Vsop87.LnVsop(4.959E-8, 0.46912887724, 3274.1250177854), new Vsop87.LnVsop(4.797E-8, 3.68003355961, 240.125798381), new Vsop87.LnVsop(4.881E-8, 2.56296192969, 980.6681783588), new Vsop87.LnVsop(4.538E-8, 5.06386842515, 103.1409583284), new Vsop87.LnVsop(5.243E-8, 4.56756453601, 238.9019581036), new Vsop87.LnVsop(5.396E-8, 3.52859562249, 107.2855599126), new Vsop87.LnVsop(4.504E-8, 1.68251875362, 196.0336200506), new Vsop87.LnVsop(4.897E-8, 4.89294590398, 102.1295663721), new Vsop87.LnVsop(4.329E-8, 1.45425771576, 409.9234163196), new Vsop87.LnVsop(4.522E-8, 1.86757053063, 103.0445901088), new Vsop87.LnVsop(5.627E-8, 1.48094428399, 105.5404547734), new Vsop87.LnVsop(5.549E-8, 6.23714371031, 112.6540017742), new Vsop87.LnVsop(5.089E-8, 3.40647640515, 427.1194557378), new Vsop87.LnVsop(4.206E-8, 0.15752956829, 958.576777831), new Vsop87.LnVsop(5.782E-8, 3.55197606731, 25874.6040461362), new Vsop87.LnVsop(4.946E-8, 0.49718145204, 511.5317178299), new Vsop87.LnVsop(4.401E-8, 3.75996694142, 1171.875873269), new Vsop87.LnVsop(4.159E-8, 5.94760152108, 316.4400537664), new Vsop87.LnVsop(4.129E-8, 4.67603982685, 106.0135355254), new Vsop87.LnVsop(4.896E-8, 3.54149603851, 960.2213092337), new Vsop87.LnVsop(5.302E-8, 2.03239262703, 2435.155730035), new Vsop87.LnVsop(4.083E-8, 3.22253056977, 775.233389447), new Vsop87.LnVsop(4.044E-8, 3.11555925708, 115.6229471908), new Vsop87.LnVsop(4.31E-8, 4.15198847307, 823.9914342234), new Vsop87.LnVsop(5.212E-8, 0.72733303302, 810.6581120991), new Vsop87.LnVsop(4.007E-8, 2.01729253216, 597.3590166611), new Vsop87.LnVsop(4.562E-8, 5.5955819649, 778.4147831847), new Vsop87.LnVsop(4.147E-8, 2.75091730849, 316.3436855468), new Vsop87.LnVsop(4.254E-8, 3.94241247597, 422.405405182), new Vsop87.LnVsop(4.6E-8, 1.45697260622, 184.9879197867), new Vsop87.LnVsop(3.893E-8, 6.03446446847, 945.9942152321), new Vsop87.LnVsop(4.02E-8, 1.20560354979, 850.0149880143), new Vsop87.LnVsop(3.887E-8, 4.17726970779, 97.6761482472), new Vsop87.LnVsop(4.43E-8, 3.99621211317, 393.4610900843), new Vsop87.LnVsop(3.84E-8, 1.21234108241, 212.0752551606), new Vsop87.LnVsop(4.201E-8, 6.27730992986, 0.7507595254), new Vsop87.LnVsop(4.863E-8, 1.13422250397, 526.9826521089), new Vsop87.LnVsop(4.447E-8, 1.35547164147, 211.6021744086), new Vsop87.LnVsop(3.82E-8, 5.0365898977, 2943.5060541272), new Vsop87.LnVsop(3.84E-8, 0.43014354282, 214.5229357154), new Vsop87.LnVsop(4.73E-8, 3.62040936733, 638.4128136057), new Vsop87.LnVsop(4.868E-8, 5.75868955321, 1246.6574718363), new Vsop87.LnVsop(5.306E-8, 1.97377190922, 526.5095713569), new Vsop87.LnVsop(3.931E-8, 2.36660571051, 909.8187330546), new Vsop87.LnVsop(3.795E-8, 5.98201295154, 325.9530972122), new Vsop87.LnVsop(3.66E-8, 2.77163682449, 123.5396433437), new Vsop87.LnVsop(3.733E-8, 6.2488686605, 159.1244246902), new Vsop87.LnVsop(3.63E-8, 5.31291201362, 406.954470903), new Vsop87.LnVsop(4.125E-8, 2.26202662047, 453.424893819), new Vsop87.LnVsop(3.804E-8, 1.94311852072, 421.1815649046), new Vsop87.LnVsop(3.921E-8, 3.0321285021, 317.3550775031), new Vsop87.LnVsop(4.474E-8, 0.79005911356, 838.218528225), new Vsop87.LnVsop(3.887E-8, 3.66517061, 216.2680408546), new Vsop87.LnVsop(4.124E-8, 2.0769245436, 988.532484885), new Vsop87.LnVsop(3.826E-8, 5.00388072945, 7.6348118626), new Vsop87.LnVsop(3.511E-8, 0.85041677251, 299.1263942692), new Vsop87.LnVsop(4.47E-8, 0.81353118479, 43.2890291783), new Vsop87.LnVsop(4.4E-8, 1.68614665169, 824.7421937488), new Vsop87.LnVsop(3.581E-8, 2.35235960566, 337.8019466282), new Vsop87.LnVsop(4.556E-8, 1.19671843654, 421.93232443), new Vsop87.LnVsop(4.606E-8, 3.48411536111, 913.9633346388), new Vsop87.LnVsop(3.434E-8, 0.71560801606, 20.4468691251), new Vsop87.LnVsop(4.419E-8, 5.41935926211, 963.4027029714), new Vsop87.LnVsop(3.733E-8, 2.84428537908, 739.0579072695), new Vsop87.LnVsop(4.535E-8, 3.73475254758, 37.8724032069), new Vsop87.LnVsop(3.493E-8, 0.95852190622, 436.8931316145), new Vsop87.LnVsop(4.367E-8, 6.08179089265, 760.25553592), new Vsop87.LnVsop(3.597E-8, 2.77342512545, 444.7574381407), new Vsop87.LnVsop(3.724E-8, 0.59005210557, 256.4280659219), new Vsop87.LnVsop(4.626E-8, 1.36732630873, 495.7507151508), new Vsop87.LnVsop(4.325E-8, 4.75343402622, 40.8413486235), new Vsop87.LnVsop(4.192E-8, 1.53217061691, 298.2326223919), new Vsop87.LnVsop(3.397E-8, 3.25386995141, 4113.0943055358), new Vsop87.LnVsop(3.534E-8, 5.01937599581, 386.9806825299), new Vsop87.LnVsop(4.444E-8, 2.22449419566, 318.8395502114), new Vsop87.LnVsop(3.634E-8, 1.51814005753, 41.6444977756), new Vsop87.LnVsop(4.432E-8, 1.80184528105, 829.6205085159), new Vsop87.LnVsop(3.209E-8, 1.74496507797, 952.3570027075), new Vsop87.LnVsop(4.471E-8, 2.64501992639, 832.5894539325), new Vsop87.LnVsop(4.17E-8, 3.10349766466, 60.7669528868), new Vsop87.LnVsop(3.718E-8, 4.79840355539, 238.4288773516), new Vsop87.LnVsop(3.372E-8, 5.52902680091, 143.9341228421), new Vsop87.LnVsop(3.231E-8, 4.07749274895, 426.4863162914), new Vsop87.LnVsop(3.187E-8, 0.26747560612, 1354.4331588434), new Vsop87.LnVsop(3.249E-8, 6.19660166578, 754.8389099486), new Vsop87.LnVsop(3.832E-8, 5.62257892389, 315.4286618101), new Vsop87.LnVsop(3.102E-8, 2.69222024207, 343.7398374614), new Vsop87.LnVsop(4.045E-8, 4.0257062827, 376.1956146969), new Vsop87.LnVsop(3.576E-8, 0.3853278728, 214.9960164674), new Vsop87.LnVsop(3.231E-8, 2.48733524742, 426.7100654606), new Vsop87.LnVsop(3.272E-8, 0.55922563072, 619.2903584945), new Vsop87.LnVsop(3.145E-8, 5.53069704309, 402.2191684878), new Vsop87.LnVsop(3.594E-8, 3.09973315674, 1048.3362299253), new Vsop87.LnVsop(3.913E-8, 5.7636981168, 239.1625905345), new Vsop87.LnVsop(3.13E-8, 0.12587768357, 3590.516887442), new Vsop87.LnVsop(3.223E-8, 2.37297249115, 429.5189521828), new Vsop87.LnVsop(2.959E-8, 1.88185764818, 93.531546663), new Vsop87.LnVsop(3.401E-8, 5.91727053879, 570.7447620392), new Vsop87.LnVsop(2.893E-8, 5.69690703144, 1262.3860848887), new Vsop87.LnVsop(3.194E-8, 4.15518147251, 366.7944458357), new Vsop87.LnVsop(3.267E-8, 2.0854191132, 806.725958836), new Vsop87.LnVsop(2.923E-8, 1.13173771167, 262.0571402144), new Vsop87.LnVsop(3.342E-8, 1.79129601981, 443.8636662634), new Vsop87.LnVsop(3.519E-8, 1.86888683578, 439.1283638482), new Vsop87.LnVsop(3.331E-8, 6.05086663762, 108.7218485111), new Vsop87.LnVsop(3.434E-8, 5.44390765201, 84.9335269539), new Vsop87.LnVsop(2.942E-8, 2.72795635418, 541.5398145106), new Vsop87.LnVsop(2.965E-8, 0.02681640831, 221.1634019642), new Vsop87.LnVsop(2.978E-8, 5.29375140441, 313.4711083498), new Vsop87.LnVsop(3.473E-8, 2.06103634915, 1261.6353253633), new Vsop87.LnVsop(3.689E-8, 1.11165149425, 395.578702239), new Vsop87.LnVsop(2.793E-8, 0.38781777981, 211.8628068395), new Vsop87.LnVsop(3.181E-8, 1.01693719457, 418.0001711669), new Vsop87.LnVsop(3.747E-8, 3.89168631842, 220.9339073006), new Vsop87.LnVsop(3.29E-8, 0.63073796473, 3171.0322435668), new Vsop87.LnVsop(3.086E-8, 2.17469905033, 306.830642101), new Vsop87.LnVsop(3.119E-8, 0.92371206211, 205.4347889118), new Vsop87.LnVsop(2.987E-8, 2.01186468194, 117.9105690512), new Vsop87.LnVsop(2.793E-8, 1.25466684542, 214.7353840365), new Vsop87.LnVsop(2.715E-8, 1.86769320511, 426.8106391971), new Vsop87.LnVsop(2.715E-8, 4.69713479126, 426.3857425549), new Vsop87.LnVsop(2.89E-8, 0.64154774742, 263.0203480609), new Vsop87.LnVsop(3.311E-8, 3.01441319731, 336.8387387817), new Vsop87.LnVsop(2.746E-8, 2.69963506849, 380.3884003909), new Vsop87.LnVsop(3.123E-8, 2.19601758733, 2.9689454166), new Vsop87.LnVsop(3.006E-8, 5.91067479448, 2.7083129857), new Vsop87.LnVsop(2.644E-8, 2.97696438264, 384.0599212231), new Vsop87.LnVsop(3.645E-8, 5.61049552466, 423.6292454594), new Vsop87.LnVsop(3.498E-8, 0.19746089391, 576.1613880106), new Vsop87.LnVsop(2.794E-8, 4.27284753268, 4010.0015313172), new Vsop87.LnVsop(3.389E-8, 1.49948217445, 885.4397106664), new Vsop87.LnVsop(2.663E-8, 4.57051350603, 361.3778198643), new Vsop87.LnVsop(3.034E-8, 2.0812482269, 2751.5475996916), new Vsop87.LnVsop(2.581E-8, 0.17405799614, 1056.2005364515), new Vsop87.LnVsop(3.049E-8, 1.03668168368, 732.6951197941), new Vsop87.LnVsop(2.559E-8, 3.9647117139, 430.79097657), new Vsop87.LnVsop(2.715E-8, 6.16166361673, 572.2292347475), new Vsop87.LnVsop(2.534E-8, 5.31015667874, 427.3489504014), new Vsop87.LnVsop(2.591E-8, 4.91947374252, 464.7312265138), new Vsop87.LnVsop(2.715E-8, 4.628028769, 140.9651774255), new Vsop87.LnVsop(2.58E-8, 3.27421375191, 136.0698163159), new Vsop87.LnVsop(2.605E-8, 0.99538186951, 92.3077063856), new Vsop87.LnVsop(2.498E-8, 0.20316576938, 110.2545053292), new Vsop87.LnVsop(2.592E-8, 4.30914764493, 561.934294009), new Vsop87.LnVsop(3.139E-8, 5.41283857071, 328.2407190726), new Vsop87.LnVsop(2.668E-8, 1.90490897736, 88.1149206916), new Vsop87.LnVsop(2.975E-8, 3.34497161574, 273.8536000037), new Vsop87.LnVsop(2.896E-8, 5.62348887158, 1699.2792165032), new Vsop87.LnVsop(3.016E-8, 1.06868053473, 7.8643065262), new Vsop87.LnVsop(2.711E-8, 2.27577147546, 519.3960243561), new Vsop87.LnVsop(2.646E-8, 1.38294890847, 460.5384408198), new Vsop87.LnVsop(2.67E-8, 2.55002171454, 195.8906076987), new Vsop87.LnVsop(2.465E-8, 3.82257543008, 77.7505439839), new Vsop87.LnVsop(2.86E-8, 2.57578667803, 505.3119427064), new Vsop87.LnVsop(2.909E-8, 0.81750588929, 45.5766510387), new Vsop87.LnVsop(2.434E-8, 4.67002316303, 2840.4132799086), new Vsop87.LnVsop(3.297E-8, 1.33975572602, 305.6068018236), new Vsop87.LnVsop(3.36E-8, 3.38474137719, 162.0933701068), new Vsop87.LnVsop(3.327E-8, 2.32322471286, 285.3723810196), new Vsop87.LnVsop(2.434E-8, 3.71460437051, 4216.1870797544), new Vsop87.LnVsop(2.4E-8, 4.51737346541, 540.7366653585), new Vsop87.LnVsop(2.506E-8, 1.31681285875, 36.6485629295), new Vsop87.LnVsop(2.388E-8, 1.13864271701, 23.5758732361), new Vsop87.LnVsop(2.367E-8, 0.92796234913, 757.2171545342), new Vsop87.LnVsop(3.057E-8, 1.71218695964, 256.5881246163), new Vsop87.LnVsop(2.342E-8, 1.45192564703, 131.5469622218), new Vsop87.LnVsop(2.514E-8, 0.09021648201, 206.9363079626), new Vsop87.LnVsop(3.153E-8, 0.85842354898, 705.1176573257), new Vsop87.LnVsop(2.412E-8, 0.54879873444, 107.7586406646), new Vsop87.LnVsop(2.427E-8, 2.04627850771, 124.5028511902), new Vsop87.LnVsop(2.32E-8, 0.02863836432, 317.142629182), new Vsop87.LnVsop(2.632E-8, 1.41253794767, 211.6545640353), new Vsop87.LnVsop(2.871E-8, 5.74770120564, 322.0209439491), new Vsop87.LnVsop(2.296E-8, 1.38115687263, 425.8474313506), new Vsop87.LnVsop(3.103E-8, 1.03244576602, 100.3844612329), new Vsop87.LnVsop(2.323E-8, 4.89135719082, 3259.8979237838), new Vsop87.LnVsop(2.708E-8, 5.36850947426, 432.0148168474), new Vsop87.LnVsop(3.21E-8, 4.49278521063, 432.2272651685), new Vsop87.LnVsop(2.276E-8, 6.04688191978, 214.1022445901), new Vsop87.LnVsop(2.276E-8, 1.96882478275, 212.4959462859), new Vsop87.LnVsop(2.501E-8, 3.320560631, 110.1581371096), new Vsop87.LnVsop(2.829E-8, 2.66887892162, 141.4864422873), new Vsop87.LnVsop(3.092E-8, 6.00298888734, 465.9550667912), new Vsop87.LnVsop(2.246E-8, 2.10578934642, 441.576044403), new Vsop87.LnVsop(2.314E-8, 5.22234612103, 303.8616966844), new Vsop87.LnVsop(2.588E-8, 0.08042775105, 133.1008708993), new Vsop87.LnVsop(2.292E-8, 5.00278268122, 431.264057322), new Vsop87.LnVsop(2.856E-8, 5.42593711539, 315.1680293792), new Vsop87.LnVsop(2.201E-8, 5.91127594022, 867.4234757536), new Vsop87.LnVsop(2.749E-8, 1.42536872532, 42.5382696529), new Vsop87.LnVsop(3.057E-8, 6.17400625369, 109.2431133729), new Vsop87.LnVsop(2.263E-8, 4.62327588198, 188.0263011725), new Vsop87.LnVsop(2.484E-8, 4.68809498416, 1596.1864422846), new Vsop87.LnVsop(2.774E-8, 0.96127776136, 41.0537969446), new Vsop87.LnVsop(2.274E-8, 4.94055830711, 4002.8879843164), new Vsop87.LnVsop(2.541E-8, 0.837056152, 12352.8526045448), new Vsop87.LnVsop(2.645E-8, 4.96474980727, 710.7467316182), new Vsop87.LnVsop(2.236E-8, 5.4872957114, 200.5564741447), new Vsop87.LnVsop(2.872E-8, 2.64762368923, 39.6175083461), new Vsop87.LnVsop(2.122E-8, 4.04560058177, 118.0706277456), new Vsop87.LnVsop(2.944E-8, 3.7669979763, 428.0826635843), new Vsop87.LnVsop(2.245E-8, 5.67078632283, 6467.9257579616), new Vsop87.LnVsop(2.227E-8, 1.15684015463, 227.3137411185), new Vsop87.LnVsop(2.541E-8, 1.09551842708, 184.7272873558), new Vsop87.LnVsop(2.311E-8, 6.13117019885, 2730.2069586892), new Vsop87.LnVsop(2.523E-8, 1.75026771081, 1578.0271950199), new Vsop87.LnVsop(2.826E-8, 1.01897881938, 87.3117715395), new Vsop87.LnVsop(2.703E-8, 1.25988186933, 28.5718080822), new Vsop87.LnVsop(2.174E-8, 1.2246785241, 209.1544938538), new Vsop87.LnVsop(2.079E-8, 3.44743142758, 111.1695290659), new Vsop87.LnVsop(2.068E-8, 4.72242654672, 765.8846102125), new Vsop87.LnVsop(2.111E-8, 2.19792675105, 449.232108125), new Vsop87.LnVsop(2.456E-8, 4.30511454445, 1382.8873468466), new Vsop87.LnVsop(2.072E-8, 0.60946281465, 335.1418177523), new Vsop87.LnVsop(2.761E-8, 6.07901608056, 2914.0142358238), new Vsop87.LnVsop(2.235E-8, 2.8862513313, 207.0793203145), new Vsop87.LnVsop(2.04E-8, 2.51317012035, 426.8588233069), new Vsop87.LnVsop(2.068E-8, 4.24177127582, 96.8729990951), new Vsop87.LnVsop(2.212E-8, 1.21619926123, 640.8604941605), new Vsop87.LnVsop(2.39E-8, 0.8172671045, 550.1378342197), new Vsop87.LnVsop(2.518E-8, 2.99015150463, 745.277682393), new Vsop87.LnVsop(2.04E-8, 4.05168623017, 426.3375584451), new Vsop87.LnVsop(2.189E-8, 1.65687779035, 219.6618829134), new Vsop87.LnVsop(2.529E-8, 4.34280337125, 221.8971151471), new Vsop87.LnVsop(2.554E-8, 5.56906813525, 214.1928673153), new Vsop87.LnVsop(2.712E-8, 1.60469055821, 1050.9963588012), new Vsop87.LnVsop(2.204E-8, 0.3895960191, 217.4436970222), new Vsop87.LnVsop(2.252E-8, 3.46799691105, 481.7360694703), new Vsop87.LnVsop(2.542E-8, 1.31713271917, 462.0229135281), new Vsop87.LnVsop(2.035E-8, 1.13356999548, 842.9014410135), new Vsop87.LnVsop(2.013E-8, 2.6145733766, 315.6411101312), new Vsop87.LnVsop(1.985E-8, 2.98251882415, 668.2084619653), new Vsop87.LnVsop(1.995E-8, 5.36620538717, 1041.2226829245), new Vsop87.LnVsop(2.357E-8, 1.94161571159, 233.9060232575), new Vsop87.LnVsop(2.072E-8, 2.97593151443, 304.1223291153), new Vsop87.LnVsop(2.04E-8, 2.04492641594, 1097.0942747017), new Vsop87.LnVsop(2.139E-8, 3.12500079869, 1276.6131788903), new Vsop87.LnVsop(2.712E-8, 1.49710379225, 3340.6124266998), new Vsop87.LnVsop(2.138E-8, 4.52114042572, 378.9039276826), new Vsop87.LnVsop(2.708E-8, 0.01014338187, 389.9496279465), new Vsop87.LnVsop(1.989E-8, 2.66756812577, 301.4140161296), new Vsop87.LnVsop(2.281E-8, 3.34201090267, 220.2001941177), new Vsop87.LnVsop(1.944E-8, 0.04553582326, 16.6747745564), new Vsop87.LnVsop(1.941E-8, 5.52054449349, 175.4266922311), new Vsop87.LnVsop(2.377E-8, 3.03550341735, 774.4826299216), new Vsop87.LnVsop(2.049E-8, 0.2785818143, 146.594251718), new Vsop87.LnVsop(1.907E-8, 1.80796641977, 192.8522263129), new Vsop87.LnVsop(2.014E-8, 2.26726355818, 198.1087935899), new Vsop87.LnVsop(1.894E-8, 4.66837052854, 220.3007678542), new Vsop87.LnVsop(1.953E-8, 3.95325956567, 103.6140390804), new Vsop87.LnVsop(1.985E-8, 0.60283431486, 3487.4241132234), new Vsop87.LnVsop(1.907E-8, 0.26838618029, 171.6545976624), new Vsop87.LnVsop(2.397E-8, 4.52014748152, 484.7050148869), new Vsop87.LnVsop(2.215E-8, 2.81175588657, 25.1297819136), new Vsop87.LnVsop(2.065E-8, 1.44937608998, 864.2420820159), new Vsop87.LnVsop(2.626E-8, 5.01886635967, 1269.4996318895), new Vsop87.LnVsop(1.973E-8, 2.7356494941, 14.0146456805), new Vsop87.LnVsop(2.433E-8, 3.72005264961, 25558.2121764796), new Vsop87.LnVsop(1.878E-8, 5.62259036586, 1310.3933701397), new Vsop87.LnVsop(1.908E-8, 0.17685540317, 244.791664827), new Vsop87.LnVsop(2.49E-8, 4.74033063304, 637.4496057592), new Vsop87.LnVsop(1.974E-8, 2.68790170927, 769.8167634756), new Vsop87.LnVsop(1.843E-8, 0.0168396279, 233.7459645631), new Vsop87.LnVsop(2.002E-8, 4.17267014873, 315.8706047948), new Vsop87.LnVsop(2.107E-8, 2.88563182217, 328.9220426288), new Vsop87.LnVsop(2.506E-8, 5.73769491309, 544.5087599272), new Vsop87.LnVsop(1.836E-8, 3.41496980986, 195.7729876197), new Vsop87.LnVsop(2.554E-8, 2.35660179716, 212.4053235607), new Vsop87.LnVsop(2.133E-8, 3.38876216948, 420.005908737), new Vsop87.LnVsop(2.515E-8, 1.52053666175, 170.0100662597), new Vsop87.LnVsop(1.825E-8, 2.10573290416, 326.6868103951), new Vsop87.LnVsop(1.825E-8, 4.04945265223, 190.4045457581), new Vsop87.LnVsop(1.787E-8, 4.44171369035, 4319.279853973), new Vsop87.LnVsop(2.218E-8, 1.85338838467, 635.231419868), new Vsop87.LnVsop(2.065E-8, 4.56320119053, 316.9131345184), new Vsop87.LnVsop(2.069E-8, 0.33119237753, 589.4947101349), new Vsop87.LnVsop(1.848E-8, 4.76669755831, 3576.2897934404), new Vsop87.LnVsop(1.823E-8, 2.76149096005, 28.4541880032), new Vsop87.LnVsop(2.057E-8, 0.1513245332, 354.2642728635), new Vsop87.LnVsop(2.195E-8, 2.39000779621, 420.4478517217), new Vsop87.LnVsop(1.871E-8, 4.24693452218, 1119.1856752295), new Vsop87.LnVsop(1.783E-8, 0.01994273456, 1670.8250285), new Vsop87.LnVsop(2.408E-8, 3.76786817334, 1254.5217783625), new Vsop87.LnVsop(2.055E-8, 2.40761448423, 187.4356003415), new Vsop87.LnVsop(1.86E-8, 3.67887919311, 1321.4390704036), new Vsop87.LnVsop(1.927E-8, 1.44376020353, 230.7075831773), new Vsop87.LnVsop(1.909E-8, 2.66281572243, 525.7588118315), new Vsop87.LnVsop(1.715E-8, 0.76853202855, 295.1942410061), new Vsop87.LnVsop(1.709E-8, 0.87394066872, 92.7978334801), new Vsop87.LnVsop(1.988E-8, 3.51782474137, 226.7924762567), new Vsop87.LnVsop(1.97E-8, 1.30348659196, 1385.174968707), new Vsop87.LnVsop(1.702E-8, 1.87642719428, 241.7532834412), new Vsop87.LnVsop(1.714E-8, 0.24096394211, 314.9073969483), new Vsop87.LnVsop(2.221E-8, 4.8221041383, 1585.8915015461), new Vsop87.LnVsop(1.897E-8, 0.64334758324, 55.6591434561), new Vsop87.LnVsop(1.832E-8, 2.83112577682, 385.5443939314), new Vsop87.LnVsop(1.801E-8, 3.9265937091, 334.5511169213), new Vsop87.LnVsop(1.677E-8, 2.65266412786, 6.3627874754), new Vsop87.LnVsop(1.979E-8, 1.01174165465, 26.826702943), new Vsop87.LnVsop(2.146E-8, 4.95169353871, 186.2117600641), new Vsop87.LnVsop(1.737E-8, 5.9681963343, 837.6972633632), new Vsop87.LnVsop(1.938E-8, 3.43779546456, 102.5715093568), new Vsop87.LnVsop(2.274E-8, 3.50826019622, 1570.9136480191), new Vsop87.LnVsop(2.099E-8, 1.88961540842, 598.8434893694), new Vsop87.LnVsop(1.808E-8, 4.01090709296, 638.9340784675), new Vsop87.LnVsop(1.838E-8, 1.8773129242, 1304.9243545416), new Vsop87.LnVsop(2.167E-8, 5.96734709712, 815.0633461142), new Vsop87.LnVsop(1.884E-8, 4.2444781245, 13.4933808187), new Vsop87.LnVsop(1.88E-8, 0.33845094634, 214.9436268407), new Vsop87.LnVsop(1.722E-8, 3.46884545009, 238.5718897035), new Vsop87.LnVsop(1.817E-8, 3.07678560214, 220.5245170234), new Vsop87.LnVsop(1.683E-8, 5.59063267232, 229.9738699944), new Vsop87.LnVsop(1.643E-8, 4.14582161982, 639.9454704238), new Vsop87.LnVsop(1.656E-8, 4.1843055535, 4326.3934009738), new Vsop87.LnVsop(1.629E-8, 3.24277564727, 281.1795953256), new Vsop87.LnVsop(1.836E-8, 3.87300444123, 310.9752436852), new Vsop87.LnVsop(1.696E-8, 6.03578305716, 152.5321425512), new Vsop87.LnVsop(1.625E-8, 2.29563193313, 3067.9394693482), new Vsop87.LnVsop(1.734E-8, 0.01027974479, 827.9235874865), new Vsop87.LnVsop(2.223E-8, 2.02052647478, 259.769518354), new Vsop87.LnVsop(2.029E-8, 5.247941869, 2015.6710861598), new Vsop87.LnVsop(1.653E-8, 2.12349382663, 491.5579294568), new Vsop87.LnVsop(1.759E-8, 5.55819179511, 170.9732741062), new Vsop87.LnVsop(1.935E-8, 4.82674512778, 101.8689339412), new Vsop87.LnVsop(1.952E-8, 0.80897783353, 1049.0869894507), new Vsop87.LnVsop(1.932E-8, 5.93295011372, 249.9476583675), new Vsop87.LnVsop(1.586E-8, 2.23089970089, 749.2098356561), new Vsop87.LnVsop(1.645E-8, 0.94872114837, 639.8491022042), new Vsop87.LnVsop(1.773E-8, 2.55608046714, 9985.7593567714), new Vsop87.LnVsop(1.773E-8, 1.22355983261, 199.9657733137), new Vsop87.LnVsop(1.795E-8, 3.78543930681, 172.4577468145), new Vsop87.LnVsop(1.847E-8, 4.51726084312, 199.8057146193), new Vsop87.LnVsop(1.571E-8, 5.97174519645, 280.2163874791), new Vsop87.LnVsop(1.744E-8, 1.92870917122, 934.9485149682), new Vsop87.LnVsop(2.133E-8, 4.62326373227, 271.61836777), new Vsop87.LnVsop(2.108E-8, 2.4372480061, 453.6855262499), new Vsop87.LnVsop(1.609E-8, 4.96540433043, 285.1117485887), new Vsop87.LnVsop(1.575E-8, 2.6158729201, 632.7355552034), new Vsop87.LnVsop(1.752E-8, 5.21532265401, 25448.00585526019), new Vsop87.LnVsop(2.157E-8, 3.55259066996, 594.6507036754), new Vsop87.LnVsop(1.536E-8, 1.78514076335, 913.7508863177), new Vsop87.LnVsop(1.87E-8, 6.14683645342, 347.3631741838), new Vsop87.LnVsop(1.536E-8, 4.09095438925, 236.1936451179), new Vsop87.LnVsop(1.553E-8, 0.37345849706, 17.2654753874), new Vsop87.LnVsop(1.608E-8, 0.1467566974, 364.3467652809), new Vsop87.LnVsop(2.122E-8, 5.4772272405, 369.0820676961), new Vsop87.LnVsop(1.691E-8, 3.73922627413, 10.0343083076), new Vsop87.LnVsop(1.787E-8, 3.85525912954, 392.6579409322), new Vsop87.LnVsop(1.562E-8, 0.79805735081, 66.1835788582), new Vsop87.LnVsop(1.495E-8, 2.19380669823, 407.4757357648), new Vsop87.LnVsop(1.515E-8, 4.70072295492, 211.2933578679), new Vsop87.LnVsop(1.767E-8, 3.11910667879, 2921.1277828246), new Vsop87.LnVsop(1.515E-8, 3.31498374761, 215.3048330081), new Vsop87.LnVsop(1.871E-8, 5.21036243597, 248.4631856592), new Vsop87.LnVsop(1.557E-8, 5.64355948418, 200.0352092829), new Vsop87.LnVsop(1.486E-8, 5.75676101208, 632.831923423), new Vsop87.LnVsop(1.718E-8, 2.85718283854, 1364.7280995819), new Vsop87.LnVsop(1.843E-8, 0.48469493939, 1127.0499817557), new Vsop87.LnVsop(1.511E-8, 1.9967597306, 205.9731001161), new Vsop87.LnVsop(1.633E-8, 2.07074945596, 378.6432952517), new Vsop87.LnVsop(1.661E-8, 5.25307910207, 219.5188705615), new Vsop87.LnVsop(1.937E-8, 4.84740152093, 857.1285350151), new Vsop87.LnVsop(1.437E-8, 6.25465521582, 1379.7059531089), new Vsop87.LnVsop(1.542E-8, 1.21935754108, 398.1440028728), new Vsop87.LnVsop(1.62E-8, 2.8431678981, 633.7469471597), new Vsop87.LnVsop(1.489E-8, 4.10155671855, 77837.11123384659), new Vsop87.LnVsop(1.573E-8, 4.23741356107, 203.8979265768), new Vsop87.LnVsop(1.631E-8, 2.40624856411, 419.4364597654), new Vsop87.LnVsop(1.69E-8, 0.65475720351, 2700.7151403858), new Vsop87.LnVsop(1.869E-8, 3.54435221295, 354.5249052944), new Vsop87.LnVsop(1.929E-8, 4.34743346077, 971.1069508032), new Vsop87.LnVsop(1.451E-8, 0.99592525811, 642.3449668688), new Vsop87.LnVsop(1.743E-8, 2.48841204719, 976.7360250957), new Vsop87.LnVsop(1.817E-8, 3.9520388555, 6076.8903015542), new Vsop87.LnVsop(1.758E-8, 3.58375338295, 968.1380053866), new Vsop87.LnVsop(1.399E-8, 4.59770409984, 224.6054281328), new Vsop87.LnVsop(1.484E-8, 5.7619184149, 448.6895914038), new Vsop87.LnVsop(1.523E-8, 0.78390897622, 661.2379273164), new Vsop87.LnVsop(1.655E-8, 1.31748248488, 25668.418497699), new Vsop87.LnVsop(1.438E-8, 5.12958189872, 71.8126531507), new Vsop87.LnVsop(1.423E-8, 6.22837994155, 904.4021070832), new Vsop87.LnVsop(1.929E-8, 4.90721606846, 206.3979967583), new Vsop87.LnVsop(1.51E-8, 3.77771207288, 222.7002642992), new Vsop87.LnVsop(1.636E-8, 1.44790851578, 1894.4190646765), new Vsop87.LnVsop(1.419E-8, 0.21487856183, 434.6749457233), new Vsop87.LnVsop(1.767E-8, 0.25099531027, 125.1841747464), new Vsop87.LnVsop(1.564E-8, 3.94804398924, 9566.2747128962), new Vsop87.LnVsop(1.802E-8, 2.42800455399, 348.635198571), new Vsop87.LnVsop(1.88E-8, 4.95438371109, 201.5196819912), new Vsop87.LnVsop(1.63E-8, 0.09698687303, 155.7829722581), new Vsop87.LnVsop(1.406E-8, 3.65940442223, 316.5037442412), new Vsop87.LnVsop(1.495E-8, 0.7783227917, 5959.570433334), new Vsop87.LnVsop(1.407E-8, 5.37485378705, 317.8763423649), new Vsop87.LnVsop(1.356E-8, 3.09618769665, 254.1404440615), new Vsop87.LnVsop(1.408E-8, 5.2497092498, 316.279995072), new Vsop87.LnVsop(1.544E-8, 5.13922144133, 768.8535556291), new Vsop87.LnVsop(1.881E-8, 4.1258810487, 562.1467423301), new Vsop87.LnVsop(1.37E-8, 4.74495578534, 1357.6145525811), new Vsop87.LnVsop(1.485E-8, 2.18712736768, 9889.7801295536), new Vsop87.LnVsop(1.369E-8, 1.31846306523, 1160.8301730051), new Vsop87.LnVsop(1.394E-8, 5.6692451786, 1736.9915610157), new Vsop87.LnVsop(1.811E-8, 1.57682442573, 1141.1340634054), new Vsop87.LnVsop(1.546E-8, 5.46572516167, 226.0417167313), new Vsop87.LnVsop(1.455E-8, 5.49358339565, 504.561183181), new Vsop87.LnVsop(1.495E-8, 5.96827635581, 1226.2106027112), new Vsop87.LnVsop(1.447E-8, 1.44933809994, 893.3564068193), new Vsop87.LnVsop(1.307E-8, 2.55868405014, 310.7627953641), new Vsop87.LnVsop(1.301E-8, 5.76220041204, 714.6788848813), new Vsop87.LnVsop(1.471E-8, 4.33649196996, 25.2727942655), new Vsop87.LnVsop(1.492E-8, 0.22387011859, 702.1487119091), new Vsop87.LnVsop(1.345E-8, 3.00386561569, 843.6351541964), new Vsop87.LnVsop(1.306E-8, 2.90378602257, 1091.6252591036), new Vsop87.LnVsop(1.434E-8, 3.43728063453, 251.1714986449), new Vsop87.LnVsop(1.651E-8, 4.31521847696, 2228.9701815978), new Vsop87.LnVsop(1.315E-8, 4.99261176008, 17.5261078183), new Vsop87.LnVsop(1.407E-8, 5.79229630947, 188.1693135244), new Vsop87.LnVsop(1.544E-8, 3.66627022939, 373.9079928365), new Vsop87.LnVsop(1.479E-8, 3.22975472634, 395.105621487), new Vsop87.LnVsop(1.323E-8, 0.24630123172, 346.3999663373), new Vsop87.LnVsop(1.544E-8, 5.17153313343, 141.6988906084), new Vsop87.LnVsop(1.302E-8, 3.67881511748, 253.4591205053), new Vsop87.LnVsop(1.274E-8, 5.73640322425, 2303.6087678132), new Vsop87.LnVsop(1.747E-8, 0.2465370093, 263.7016716171), new Vsop87.LnVsop(1.69E-8, 5.50438014857, 419.532827985), new Vsop87.LnVsop(1.242E-8, 5.02512547428, 354.9979860464), new Vsop87.LnVsop(1.744E-8, 3.70453251764, 147.1155165798), new Vsop87.LnVsop(1.498E-8, 4.70203004844, 100.1720129118), new Vsop87.LnVsop(1.331E-8, 1.03420766654, 1159.2933106701), new Vsop87.LnVsop(1.557E-8, 0.57740217353, 3178.1457905676), new Vsop87.LnVsop(1.531E-8, 5.60136729946, 260.360219185), new Vsop87.LnVsop(1.597E-8, 4.46013103327, 432.7485300303), new Vsop87.LnVsop(1.291E-8, 0.77502618084, 48.7580447764), new Vsop87.LnVsop(1.228E-8, 0.10949459285, 1372.5924061081), new Vsop87.LnVsop(1.573E-8, 4.00132484524, 1264.2954542392), new Vsop87.LnVsop(1.464E-8, 4.41842460719, 763.4369296577), new Vsop87.LnVsop(1.269E-8, 6.06534948978, 25.8634950965), new Vsop87.LnVsop(1.572E-8, 1.31215103171, 322.6116447801), new Vsop87.LnVsop(1.287E-8, 4.82368466592, 535.9107402181), new Vsop87.LnVsop(1.205E-8, 0.24105241435, 466.7582159433), new Vsop87.LnVsop(1.188E-8, 1.27112537278, 1184.4060462412), new Vsop87.LnVsop(1.199E-8, 1.78020373551, 102.3420146932), new Vsop87.LnVsop(1.186E-8, 4.72251265892, 795.6802585721), new Vsop87.LnVsop(1.497E-8, 3.44614317326, 3024.2205570432), new Vsop87.LnVsop(1.265E-8, 5.78046227081, 531.978586955), new Vsop87.LnVsop(1.23E-8, 5.18147817992, 752.3912293938), new Vsop87.LnVsop(1.158E-8, 2.23776758082, 318.679491517), new Vsop87.LnVsop(1.175E-8, 4.35535063059, 3892.681663097), new Vsop87.LnVsop(1.571E-8, 1.60745561424, 67.8804998876), new Vsop87.LnVsop(1.15E-8, 3.427111484, 306.0969289181), new Vsop87.LnVsop(1.385E-8, 0.89711064123, 6073.7089078165), new Vsop87.LnVsop(1.136E-8, 5.53065311813, 1578.7779545453), new Vsop87.LnVsop(1.247E-8, 1.94513483418, 623.2225117576), new Vsop87.LnVsop(1.366E-8, 3.99684537321, 6065.8446012903), new Vsop87.LnVsop(1.142E-8, 4.35845106342, 1834.6153196362), new Vsop87.LnVsop(1.14E-8, 3.13401303125, 611.4430983108), new Vsop87.LnVsop(1.127E-8, 0.61883337338, 1166.4068576709), new Vsop87.LnVsop(1.403E-8, 0.92404432675, 799.6124118352), new Vsop87.LnVsop(1.174E-8, 1.77470409548, 3384.3313390048), new Vsop87.LnVsop(1.173E-8, 5.43655584105, 494.4786907636), new Vsop87.LnVsop(1.425E-8, 2.65840274172, 1253.7710188371), new Vsop87.LnVsop(1.314E-8, 0.15326588436, 493.303034596), new Vsop87.LnVsop(1.134E-8, 1.16341619317, 255.8373650909), new Vsop87.LnVsop(1.564E-8, 1.09100285617, 683.0262567979), new Vsop87.LnVsop(1.217E-8, 2.18290106978, 17.4084877393), new Vsop87.LnVsop(1.41E-8, 4.08121265308, 97.4636999261), new Vsop87.LnVsop(1.297E-8, 6.0210481349, 225.0785088848), new Vsop87.LnVsop(1.108E-8, 1.99635939822, 3700.7232086614), new Vsop87.LnVsop(1.142E-8, 5.96306227849, 1144.3154571431), new Vsop87.LnVsop(1.304E-8, 5.24544813643, 5650.2921106782), new Vsop87.LnVsop(1.304E-8, 0.78547708972, 1773.9178027186), new Vsop87.LnVsop(1.138E-8, 4.47018614395, 680.0573113813), new Vsop87.LnVsop(1.384E-8, 3.74284963831, 272.5815756165), new Vsop87.LnVsop(1.411E-8, 1.62072757889, 25771.5112719176), new Vsop87.LnVsop(1.149E-8, 4.21885813289, 332.1728723357), new Vsop87.LnVsop(1.098E-8, 3.75659421786, 318.3976072267), new Vsop87.LnVsop(1.117E-8, 3.50712069727, 847.0460425977), new Vsop87.LnVsop(1.072E-8, 1.41288617325, 1268.7488723641), new Vsop87.LnVsop(1.295E-8, 2.32056477953, 10003.9186040361), new Vsop87.LnVsop(1.094E-8, 5.12244388591, 314.3861320865), new Vsop87.LnVsop(1.128E-8, 4.05700139843, 118.8737768977), new Vsop87.LnVsop(1.277E-8, 5.42029902662, 9996.0542975099), new Vsop87.LnVsop(1.086E-8, 1.8033045196, 1457.525933062), new Vsop87.LnVsop(1.265E-8, 5.85587479874, 82.8583534146), new Vsop87.LnVsop(1.058E-8, 0.73867502165, 670.916774951), new Vsop87.LnVsop(1.188E-8, 2.10062104482, 423.8898778903), new Vsop87.LnVsop(1.051E-8, 1.50055229907, 196.8367692027), new Vsop87.LnVsop(1.296E-8, 2.88467024494, 223.3334037456), new Vsop87.LnVsop(1.049E-8, 3.43787192741, 771.3012361839), new Vsop87.LnVsop(1.36E-8, 4.79139479372, 321.808495628), new Vsop87.LnVsop(1.204E-8, 3.03693665003, 608.404716925), new Vsop87.LnVsop(1.068E-8, 3.48313991728, 754.0357607965), new Vsop87.LnVsop(1.175E-8, 0.91096377814, 740.0692992258), new Vsop87.LnVsop(1.391E-8, 4.58075086255, 1248.1419445446), new Vsop87.LnVsop(1.378E-8, 1.56539991797, 409.1897031367), new Vsop87.LnVsop(1.11E-8, 0.75388880657, 1482.7987273275), new Vsop87.LnVsop(1.152E-8, 4.43705273794, 10220.3990932118), new Vsop87.LnVsop(1.043E-8, 1.17588440529, 398.2870152247), new Vsop87.LnVsop(1.115E-8, 3.882677205, 128.3655684841), new Vsop87.LnVsop(1.293E-8, 0.02397468965, 2723.0934116884), new Vsop87.LnVsop(1.044E-8, 4.55436071665, 89.7594520943), new Vsop87.LnVsop(1.19E-8, 4.49552956816, 429.3065038617), new Vsop87.LnVsop(1.253E-8, 1.16885224716, 455.1699989582), new Vsop87.LnVsop(1.122E-8, 5.7216130664, 78263.70942472259), new Vsop87.LnVsop(1.05E-8, 2.29914438978, 848.530515306), new Vsop87.LnVsop(1.083E-8, 4.6901363904, 1.2720243872), new Vsop87.LnVsop(1.252E-8, 5.28238896229, 6080.8224548173), new Vsop87.LnVsop(1.036E-8, 1.37191316671, 1251.3403846248), new Vsop87.LnVsop(1.047E-8, 6.05833150471, 206.4461808681), new Vsop87.LnVsop(1.106E-8, 4.43961682956, 633.305004175), new Vsop87.LnVsop(1.083E-8, 5.04862249728, 629.8629780064), new Vsop87.LnVsop(1.024E-8, 4.87634491793, 433.7599219866), new Vsop87.LnVsop(1.087E-8, 3.6265386028, 582.3811631341), new Vsop87.LnVsop(1.082E-8, 4.07686503205, 1245.172999128), new Vsop87.LnVsop(1.161E-8, 4.20513144049, 827.1728279611), new Vsop87.LnVsop(1.01E-8, 0.83370133581, 16.4623262353), new Vsop87.LnVsop(1.415E-8, 0.47625687277, 774.0095491696), new Vsop87.LnVsop(1.258E-8, 0.13038090471, 101.6083015103), new Vsop87.LnVsop(1.197E-8, 0.79148395839, 9580.5018068978), new Vsop87.LnVsop(1.402E-8, 4.82957073563, 883.7951792637), new Vsop87.LnVsop(9.99E-9, 2.3249777732, 61.2882177486), new Vsop87.LnVsop(1.11E-8, 5.88801273512, 657.1627617014), new Vsop87.LnVsop(9.96E-9, 4.99081075982, 426.7582495704), new Vsop87.LnVsop(1.117E-8, 6.11410083484, 870.4618571394), new Vsop87.LnVsop(1.07E-8, 0.29336435059, 119.767548775), new Vsop87.LnVsop(9.96E-9, 1.60533807172, 426.4381321816), new Vsop87.LnVsop(1.032E-8, 4.72428387546, 201.9927627432), new Vsop87.LnVsop(1.101E-8, 3.93919206905, 632.2624744514), new Vsop87.LnVsop(1.118E-8, 4.40767803642, 532.1386456494), new Vsop87.LnVsop(1.014E-8, 5.79119811472, 6460.8122109608), new Vsop87.LnVsop(1.064E-8, 0.19404592323, 6386.16862421), new Vsop87.LnVsop(1.336E-8, 4.79375117329, 2332.0629558164), new Vsop87.LnVsop(1.002E-8, 5.95184354004, 3906.9087570986), new Vsop87.LnVsop(1.31E-8, 0.60237129875, 1123.1178284926), new Vsop87.LnVsop(9.84E-9, 0.24370826999, 229.7614216733), new Vsop87.LnVsop(1.192E-8, 0.39183403313, 1178.9894202698), new Vsop87.LnVsop(9.83E-9, 6.19356591342, 962.5089310941), new Vsop87.LnVsop(1.032E-8, 5.86748597956, 108.50940019), new Vsop87.LnVsop(1.105E-8, 3.86281159011, 736.8397213783), new Vsop87.LnVsop(1.056E-8, 4.2398546491, 113.1270825262), new Vsop87.LnVsop(9.76E-9, 1.83523959034, 5.8897067234), new Vsop87.LnVsop(1.043E-8, 3.02320720148, 347.4113582936), new Vsop87.LnVsop(1.063E-8, 3.90644958468, 683.1863154923), new Vsop87.LnVsop(1.041E-8, 2.36429894351, 821.5437536686), new Vsop87.LnVsop(9.72E-9, 4.01268690768, 469.7271613599), new Vsop87.LnVsop(1.106E-8, 5.22834029531, 1459.9565672743), new Vsop87.LnVsop(1.217E-8, 4.61800510389, 990.2294059144), new Vsop87.LnVsop(1.171E-8, 0.42265751679, 10011.0321510369), new Vsop87.LnVsop(1.171E-8, 6.15008203965, 737.3128021303), new Vsop87.LnVsop(9.5E-9, 2.20627976392, 199.1201855462), new Vsop87.LnVsop(1.155E-8, 4.33358864948, 1055.4497769261), new Vsop87.LnVsop(9.76E-9, 1.05304205075, 8.3373872782), new Vsop87.LnVsop(9.86E-9, 4.77927211762, 109.6850563576), new Vsop87.LnVsop(9.65E-9, 4.09286645443, 522.529233984), new Vsop87.LnVsop(1.203E-8, 5.48783494218, 2810.9214616052), new Vsop87.LnVsop(1.139E-8, 1.05860663139, 369.9758395734), new Vsop87.LnVsop(1.083E-8, 3.06419651551, 700.4517908797), new Vsop87.LnVsop(9.62E-9, 5.58253892259, 47.061123747), new Vsop87.LnVsop(1.097E-8, 4.27064998408, 384.2723695442), new Vsop87.LnVsop(1.006E-8, 5.89037944896, 10007.0999977738), new Vsop87.LnVsop(9.67E-9, 1.56852913547, 157.6399519819), new Vsop87.LnVsop(1.213E-8, 0.31515805319, 707.5653378805), new Vsop87.LnVsop(1.114E-8, 5.58206045644, 92.940845832), new Vsop87.LnVsop(9.37E-9, 5.19215522052, 316.1312372257), new Vsop87.LnVsop(9.51E-9, 3.65476455359, 1235.6117715724), new Vsop87.LnVsop(9.81E-9, 2.37620383333, 35.212274331), new Vsop87.LnVsop(9.29E-9, 6.06911430142, 0.0481841098), new Vsop87.LnVsop(9.61E-9, 1.69324063398, 433.663553767), new Vsop87.LnVsop(9.33E-9, 3.13487131274, 387.2413149608), new Vsop87.LnVsop(9.93E-9, 3.58058926281, 735.828329422), new Vsop87.LnVsop(1.287E-8, 6.08212342139, 1329.3033769298), new Vsop87.LnVsop(1.015E-8, 6.19122845232, 401.3253966105), new Vsop87.LnVsop(1.024E-8, 1.90798238649, 1175.8080265321), new Vsop87.LnVsop(1.037E-8, 0.76313958988, 733.428832977), new Vsop87.LnVsop(1.072E-8, 4.95817300234, 631.8205314667), new Vsop87.LnVsop(9.93E-9, 0.31814583417, 1365.4788591073), new Vsop87.LnVsop(1.134E-8, 5.87478488618, 6058.7310542895), new Vsop87.LnVsop(9.99E-9, 3.52478664564, 27.0873353739), new Vsop87.LnVsop(9.59E-9, 5.43627627442, 46.2097904851), new Vsop87.LnVsop(9.15E-9, 4.87266214195, 18.9100067901), new Vsop87.LnVsop(9.99E-9, 1.19719347548, 104.5772469269), new Vsop87.LnVsop(9.63E-9, 2.72059732893, 308.3151148093), new Vsop87.LnVsop(1.166E-8, 0.83821274577, 4.1446015842), new Vsop87.LnVsop(1.039E-8, 2.40020830681, 6475.0393049624), new Vsop87.LnVsop(1.141E-8, 2.9286392494, 1037.2905296614), new Vsop87.LnVsop(1.005E-8, 6.12430441703, 6275.9623029906), new Vsop87.LnVsop(1.224E-8, 1.73535287415, 5120.6011455836), new Vsop87.LnVsop(9.24E-9, 5.70601816488, 614.8369403696), new Vsop87.LnVsop(9.76E-9, 3.65075292234, 3281.2385647862), new Vsop87.LnVsop(1.042E-8, 1.10027795842, 1518.2234499796), new Vsop87.LnVsop(8.9E-9, 4.03192782386, 1314.3255234028), new Vsop87.LnVsop(9.19E-9, 4.36994806815, 1151.4290041439), new Vsop87.LnVsop(9.88E-9, 4.17719296131, 98.4269077726), new Vsop87.LnVsop(1.224E-8, 1.5681327778, 498.9321088885), new Vsop87.LnVsop(9.14E-9, 0.84094751548, 8.8104680302), new Vsop87.LnVsop(1.226E-8, 3.52834223937, 80.4106728598), new Vsop87.LnVsop(8.82E-9, 0.83665470112, 294.3004691288), new Vsop87.LnVsop(1.049E-8, 0.4732413022, 495.9631634719), new Vsop87.LnVsop(9.39E-9, 4.68295941083, 4105.980758535), new Vsop87.LnVsop(8.96E-9, 3.65029741088, 414.8187774292), new Vsop87.LnVsop(1.235E-8, 1.23871819142, 357.2332182801), new Vsop87.LnVsop(1.218E-8, 0.18349810348, 1090.4014188262), new Vsop87.LnVsop(9.09E-9, 5.12780284661, 1173.5204046717), new Vsop87.LnVsop(9.48E-9, 5.30478380123, 199.0238173266), new Vsop87.LnVsop(1.075E-8, 2.39947623423, 311.7260032106), new Vsop87.LnVsop(8.71E-9, 0.34963934486, 338.4832701844), new Vsop87.LnVsop(8.95E-9, 1.41605139181, 877.1023233882), new Vsop87.LnVsop(8.95E-9, 6.05936094663, 1987.2168981566), new Vsop87.LnVsop(1.151E-8, 1.92096829093, 757.8078553652), new Vsop87.LnVsop(8.64E-9, 0.73362618982, 1152.1797636693), new Vsop87.LnVsop(1.161E-8, 5.43333581656, 1089.129394439), new Vsop87.LnVsop(9.57E-9, 3.12919808399, 628.5909536192), new Vsop87.LnVsop(8.6E-9, 5.69748024851, 103.843533744), new Vsop87.LnVsop(9.1E-9, 3.29147304619, 159.7151255212), new Vsop87.LnVsop(8.7E-9, 0.77956473768, 907.3710524998), new Vsop87.LnVsop(1.158E-8, 3.33343863758, 6290.1893969922), new Vsop87.LnVsop(1.036E-8, 3.11936047271, 5429.8794682394), new Vsop87.LnVsop(8.52E-9, 6.23629650974, 938.8806682313), new Vsop87.LnVsop(8.88E-9, 5.86925802792, 156.6767441354), new Vsop87.LnVsop(8.32E-9, 5.19725706044, 475.3562356524), new Vsop87.LnVsop(1.039E-8, 4.56635505777, 1912.5783119412), new Vsop87.LnVsop(8.5E-9, 4.08197558202, 3333.498879699), new Vsop87.LnVsop(8.9E-9, 0.24277485157, 3803.81598288), new Vsop87.LnVsop(8.87E-9, 3.46938383985, 1748.788020805), new Vsop87.LnVsop(8.62E-9, 3.35450376868, 425.3261664888), new Vsop87.LnVsop(8.12E-9, 4.75534187737, 620.253566341), new Vsop87.LnVsop(8.76E-9, 4.0681933583, 413.8555695827), new Vsop87.LnVsop(9.2E-9, 5.33063977936, 110.7275860812), new Vsop87.LnVsop(1.065E-8, 0.20426944617, 439.9315130003), new Vsop87.LnVsop(8.98E-9, 5.42633037147, 236.8749686741), new Vsop87.LnVsop(8.62E-9, 3.24167644464, 427.8702152632), new Vsop87.LnVsop(8.39E-9, 4.55976894141, 77.962992305), new Vsop87.LnVsop(7.93E-9, 5.01131700831, 109.9938728983), new Vsop87.LnVsop(8.83E-9, 5.91547058278, 13.3333221243), new Vsop87.LnVsop(7.91E-9, 2.21809404489, 110.4187695405), new Vsop87.LnVsop(8.42E-9, 5.04957483607, 444.1242986943), new Vsop87.LnVsop(8.44E-9, 3.26239911598, 635.70450062), new Vsop87.LnVsop(8.87E-9, 4.23752031725, 3553.9115221378), new Vsop87.LnVsop(8.13E-9, 1.941824595, 627.1546650207), new Vsop87.LnVsop(9.53E-9, 1.84900597155, 835.7878940127), new Vsop87.LnVsop(9.66E-9, 4.55013458162, 9360.089164459), new Vsop87.LnVsop(1.092E-8, 0.5815374794, 203.2647871304), new Vsop87.LnVsop(8.14E-9, 4.01510494376, 604.4725636619), new Vsop87.LnVsop(8.11E-9, 1.22144185843, 254.3528923826), new Vsop87.LnVsop(7.86E-9, 3.84829878956, 194.3890886479), new Vsop87.LnVsop(7.74E-9, 3.7605063931, 219.1406180516), new Vsop87.LnVsop(7.81E-9, 5.08832725435, 802.7938055729), new Vsop87.LnVsop(8.76E-9, 5.19448877884, 948.2124011233), new Vsop87.LnVsop(1.077E-8, 4.29979657165, 5753.3848848968), new Vsop87.LnVsop(9.01E-9, 1.36051594017, 1201.831580323), new Vsop87.LnVsop(7.74E-9, 4.80415223158, 394.3548619616), new Vsop87.LnVsop(7.8E-9, 4.94962976798, 532.8723588323), new Vsop87.LnVsop(8.27E-9, 5.64337714429, 2620.0006374698), new Vsop87.LnVsop(7.72E-9, 2.30361551098, 949.12742486), new Vsop87.LnVsop(8.18E-9, 2.5260962654, 26301.2022370122), new Vsop87.LnVsop(8.55E-9, 3.28701649613, 95.0160193713), new Vsop87.LnVsop(9.28E-9, 0.72021151346, 740.2817475469), new Vsop87.LnVsop(9.74E-9, 1.55167938413, 186.472392495), new Vsop87.LnVsop(8.95E-9, 5.83218231202, 4539.6924964118), new Vsop87.LnVsop(8.24E-9, 3.48188126089, 845.3320752258), new Vsop87.LnVsop(7.51E-9, 5.0732979129, 476.1069951778), new Vsop87.LnVsop(7.73E-9, 2.77996323939, 688.6553310904), new Vsop87.LnVsop(9.39E-9, 3.68460642343, 817.7716590999), new Vsop87.LnVsop(9.1E-9, 4.40175612169, 2648.454825473), new Vsop87.LnVsop(7.53E-9, 0.04254534997, 1534.7381658416), new Vsop87.LnVsop(7.41E-9, 0.04675642866, 846.131018861), new Vsop87.LnVsop(7.36E-9, 0.63322927327, 58.1068240109), new Vsop87.LnVsop(7.76E-9, 5.42586716249, 5540.0857894588), new Vsop87.LnVsop(8.6E-9, 4.24463603685, 29.2049475286), new Vsop87.LnVsop(7.51E-9, 2.43181413413, 625.8826406335), new Vsop87.LnVsop(8.52E-9, 3.11058720799, 232.4215505492), new Vsop87.LnVsop(7.22E-9, 5.34176028966, 949.2237930796), new Vsop87.LnVsop(7.22E-9, 0.45293446355, 522.6256022036), new Vsop87.LnVsop(8.96E-9, 0.32751625766, 229.340730548), new Vsop87.LnVsop(7.22E-9, 3.96121088528, 1474.9344208013), new Vsop87.LnVsop(7.15E-9, 4.41679796625, 19.1224551112), new Vsop87.LnVsop(7.88E-9, 0.99170388242, 121.8427223143), new Vsop87.LnVsop(7.13E-9, 3.68141955548, 4532.578949411), new Vsop87.LnVsop(7.22E-9, 4.16734185316, 232.2091022281), new Vsop87.LnVsop(9.69E-9, 2.31953080666, 566.600160455), new Vsop87.LnVsop(7.95E-9, 6.1676262412, 1475.6851803267), new Vsop87.LnVsop(7.13E-9, 0.83529892802, 1884.124123938), new Vsop87.LnVsop(7.31E-9, 6.11847213487, 1239.5439248355), new Vsop87.LnVsop(8.71E-9, 5.94461985599, 11.3063326948), new Vsop87.LnVsop(7.5E-9, 5.3104093431, 9683.5945811164), new Vsop87.LnVsop(8.61E-9, 1.84312756285, 984.6003316219), new Vsop87.LnVsop(6.95E-9, 4.78088165969, 10419.4710946482), new Vsop87.LnVsop(7.46E-9, 1.40148355303, 782.3469364478), new Vsop87.LnVsop(8.29E-9, 5.85923720925, 845.1196269047), new Vsop87.LnVsop(7.39E-9, 5.21951835749, 3679.382567659), new Vsop87.LnVsop(6.92E-9, 3.38736418117, 6489.2613984286), new Vsop87.LnVsop(6.94E-9, 3.07863807714, 316.6043179777), new Vsop87.LnVsop(6.9E-9, 5.8668131138, 316.1794213355), new Vsop87.LnVsop(7.14E-9, 5.38707933404, 567.8240007324), new Vsop87.LnVsop(7.74E-9, 3.17401887776, 846.0346506414), new Vsop87.LnVsop(7.5E-9, 3.05400490211, 66.9172920411), new Vsop87.LnVsop(7.67E-9, 0.1208184965, 485.8806710545), new Vsop87.LnVsop(7.05E-9, 0.57839934869, 1053.7528558967), new Vsop87.LnVsop(6.84E-9, 4.8844227063, 2545.3620512544), new Vsop87.LnVsop(6.84E-9, 5.35202323443, 1193.9672737968), new Vsop87.LnVsop(6.92E-9, 3.63694823733, 599.6466385215), new Vsop87.LnVsop(8.83E-9, 1.46307267703, 112.9146342051), new Vsop87.LnVsop(8.27E-9, 2.59300433753, 232.942815411), new Vsop87.LnVsop(6.86E-9, 2.16126205234, 529.7391492044)};
        private static final Vsop87.LnVsop[] saturn_radius_r1 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.0618298134, 0.2584351148, 213.299095438), new Vsop87.LnVsop(0.00506577242, 0.71114625261, 206.1855484372), new Vsop87.LnVsop(0.00341394029, 5.79635741658, 426.598190876), new Vsop87.LnVsop(0.00188491195, 0.47215589652, 220.4126424388), new Vsop87.LnVsop(0.00186261486, 3.14159265359, 0.0), new Vsop87.LnVsop(0.00143891146, 1.40744822888, 7.1135470008), new Vsop87.LnVsop(4.9621208E-4, 6.0174427982, 103.0927742186), new Vsop87.LnVsop(2.0928426E-4, 5.09244947411, 639.897286314), new Vsop87.LnVsop(1.9952564E-4, 1.1756060613, 419.4846438752), new Vsop87.LnVsop(1.8839544E-4, 1.60818334043, 110.2063212194), new Vsop87.LnVsop(1.2892843E-4, 5.9432943302, 433.7117378768), new Vsop87.LnVsop(1.3876849E-4, 0.75884928866, 199.0720014364), new Vsop87.LnVsop(5.396842E-5, 1.28853589711, 14.2270940016), new Vsop87.LnVsop(4.869289E-5, 0.86797227054, 323.5054166574), new Vsop87.LnVsop(4.247221E-5, 0.39294984732, 227.5261894396), new Vsop87.LnVsop(3.252331E-5, 1.2585015433, 95.9792272178), new Vsop87.LnVsop(2.856066E-5, 2.1673128387, 735.8765135318), new Vsop87.LnVsop(2.90954E-5, 4.60680719251, 202.2533951741), new Vsop87.LnVsop(3.08141E-5, 3.43662543526, 522.5774180938), new Vsop87.LnVsop(1.987731E-5, 2.45053765034, 412.3710968744), new Vsop87.LnVsop(1.941443E-5, 6.02392296904, 209.3669421749), new Vsop87.LnVsop(1.581782E-5, 1.29189091556, 210.1177017003), new Vsop87.LnVsop(1.339521E-5, 4.30812522038, 853.196381752), new Vsop87.LnVsop(1.315459E-5, 1.25295611814, 117.3198682202), new Vsop87.LnVsop(1.202869E-5, 1.86661895487, 316.3918696566), new Vsop87.LnVsop(1.090827E-5, 0.07529636493, 216.4804891757), new Vsop87.LnVsop(9.543E-6, 5.15171167674, 647.0108333148), new Vsop87.LnVsop(9.65957E-6, 0.47988871608, 632.7837393132), new Vsop87.LnVsop(8.82063E-6, 1.88467410042, 1052.2683831884), new Vsop87.LnVsop(8.7431E-6, 1.40216274572, 224.3447957019), new Vsop87.LnVsop(8.97508E-6, 0.98347755563, 529.6909650946), new Vsop87.LnVsop(7.84828E-6, 3.06374185689, 838.9692877504), new Vsop87.LnVsop(7.39765E-6, 1.38209924525, 625.6701923124), new Vsop87.LnVsop(6.1293E-6, 3.03309390383, 63.7358983034), new Vsop87.LnVsop(6.58132E-6, 4.1437471502, 309.2783226558), new Vsop87.LnVsop(6.4959E-6, 1.72473111863, 742.9900605326), new Vsop87.LnVsop(5.99227E-6, 2.54946247931, 217.2312487011), new Vsop87.LnVsop(5.02951E-6, 2.12941646895, 3.9321532631), new Vsop87.LnVsop(4.12937E-6, 4.59321186186, 415.5524906121), new Vsop87.LnVsop(3.55987E-6, 2.30328555624, 728.762966531), new Vsop87.LnVsop(3.44652E-6, 5.88820160547, 440.8252848776), new Vsop87.LnVsop(3.94995E-6, 0.5339710376, 956.2891559706), new Vsop87.LnVsop(3.35677E-6, 1.61590789073, 1368.660252845), new Vsop87.LnVsop(3.62976E-6, 4.7059780752, 302.164775655), new Vsop87.LnVsop(3.21577E-6, 0.9793235123, 3.1813937377), new Vsop87.LnVsop(2.77708E-6, 0.25951592662, 195.1398481733), new Vsop87.LnVsop(2.9118E-6, 2.8313701005, 1155.361157407), new Vsop87.LnVsop(2.65342E-6, 2.42688922787, 88.865680217), new Vsop87.LnVsop(2.6462E-6, 5.82810809153, 149.5631971346), new Vsop87.LnVsop(3.16952E-6, 3.58395969651, 515.463871093), new Vsop87.LnVsop(2.94362E-6, 2.81544110682, 11.0457002639), new Vsop87.LnVsop(2.44591E-6, 1.04536406733, 942.062061969), new Vsop87.LnVsop(2.15355E-6, 3.56547915194, 490.3340891794), new Vsop87.LnVsop(2.63891E-6, 1.2857730655, 1059.3819301892), new Vsop87.LnVsop(2.45985E-6, 0.90791252506, 191.9584544356), new Vsop87.LnVsop(2.21909E-6, 5.13181138104, 269.9214467406), new Vsop87.LnVsop(1.95132E-6, 4.56582271431, 846.0828347512), new Vsop87.LnVsop(1.82943E-6, 2.67926427647, 127.4717966068), new Vsop87.LnVsop(1.81431E-6, 4.93450656865, 74.7815985673), new Vsop87.LnVsop(1.74706E-6, 3.44549385972, 137.0330241624), new Vsop87.LnVsop(1.65475E-6, 5.99806063883, 536.8045120954), new Vsop87.LnVsop(1.54921E-6, 1.19719941288, 265.9892934775), new Vsop87.LnVsop(1.69692E-6, 4.63444302692, 284.1485407422), new Vsop87.LnVsop(1.5125E-6, 0.5284507406, 330.6189636582), new Vsop87.LnVsop(1.523E-6, 5.43871996026, 422.6660376129), new Vsop87.LnVsop(1.40611E-6, 2.02083462656, 1045.1548361876), new Vsop87.LnVsop(1.57686E-6, 2.99426635258, 340.7708920448), new Vsop87.LnVsop(1.39555E-6, 1.35322655321, 1685.0521225016), new Vsop87.LnVsop(1.4099E-6, 1.2711804015, 203.0041546995), new Vsop87.LnVsop(1.35874E-6, 5.01655087212, 351.8165923087), new Vsop87.LnVsop(1.53415E-6, 0.26924047897, 1272.6810256272), new Vsop87.LnVsop(1.29293E-6, 1.14375799011, 21.3406410024), new Vsop87.LnVsop(1.2781E-6, 2.53730683511, 1471.7530270636), new Vsop87.LnVsop(1.26354E-6, 3.00342230503, 277.0349937414), new Vsop87.LnVsop(1.00208E-6, 3.61417145482, 1066.49547719), new Vsop87.LnVsop(1.03009E-6, 0.38169227203, 203.7378678824), new Vsop87.LnVsop(1.07261E-6, 4.31791292903, 210.8514148832), new Vsop87.LnVsop(9.6106E-7, 0.79400471601, 1258.4539316256), new Vsop87.LnVsop(8.2432E-7, 0.2813059475, 234.6397364404), new Vsop87.LnVsop(9.8329E-7, 2.56113375171, 191.2076949102), new Vsop87.LnVsop(9.7253E-7, 3.26221061562, 831.8557407496), new Vsop87.LnVsop(7.2231E-7, 4.37989037807, 860.3099287528), new Vsop87.LnVsop(7.0663E-7, 0.73027101376, 437.6438911399), new Vsop87.LnVsop(7.0354E-7, 0.876511385, 423.4167971383), new Vsop87.LnVsop(7.1862E-7, 5.58023540653, 429.7795846137), new Vsop87.LnVsop(7.3026E-7, 0.62391865714, 1375.7737998458), new Vsop87.LnVsop(6.6398E-7, 2.68226810752, 405.2575498736), new Vsop87.LnVsop(6.35E-7, 1.751479302, 1361.5467058442), new Vsop87.LnVsop(6.1591E-7, 1.09281357936, 2001.4439921582), new Vsop87.LnVsop(6.7049E-7, 0.06892389889, 408.4389436113), new Vsop87.LnVsop(6.8948E-7, 2.47236189878, 949.1756089698), new Vsop87.LnVsop(6.0266E-7, 2.25229650271, 1788.1448967202), new Vsop87.LnVsop(6.6978E-7, 5.45314123697, 200.7689224658), new Vsop87.LnVsop(6.5588E-7, 0.05566059213, 1589.0728952838), new Vsop87.LnVsop(4.938E-7, 4.17156251836, 138.5174968707), new Vsop87.LnVsop(5.5431E-7, 4.59287180519, 628.8515860501), new Vsop87.LnVsop(5.0576E-7, 6.26929954106, 223.5940361765), new Vsop87.LnVsop(4.7838E-7, 0.83640381014, 10.2949407385), new Vsop87.LnVsop(4.6677E-7, 2.17434678208, 312.1990839626), new Vsop87.LnVsop(5.4368E-7, 0.2824567414, 124.433415221), new Vsop87.LnVsop(4.9402E-7, 3.79857810717, 215.7467759928), new Vsop87.LnVsop(3.9837E-7, 5.17790796777, 1478.8665740644), new Vsop87.LnVsop(3.9385E-7, 0.56431193299, 1574.8458012822), new Vsop87.LnVsop(3.4944E-7, 4.68657210063, 38.1330356378), new Vsop87.LnVsop(3.6698E-7, 0.62957662315, 52.6901980395), new Vsop87.LnVsop(4.2625E-7, 2.98722916534, 1148.2476104062), new Vsop87.LnVsop(3.9684E-7, 0.28575318525, 131.4039498699), new Vsop87.LnVsop(3.1822E-7, 5.18978322396, 76.2660712756), new Vsop87.LnVsop(3.2894E-7, 1.97423476342, 142.4496501338), new Vsop87.LnVsop(4.1928E-7, 4.82822003035, 288.0806940053), new Vsop87.LnVsop(3.0753E-7, 1.47899080224, 1677.9385755008), new Vsop87.LnVsop(4.2664E-7, 3.38153700265, 208.633228992), new Vsop87.LnVsop(2.924E-7, 4.95613345683, 1795.258443721), new Vsop87.LnVsop(2.9268E-7, 5.09912997273, 654.1243803156), new Vsop87.LnVsop(3.2781E-7, 6.12212232937, 145.6310438715), new Vsop87.LnVsop(2.8968E-7, 2.74363421275, 404.5067903482), new Vsop87.LnVsop(2.8114E-7, 0.83461605023, 2317.8358618148), new Vsop87.LnVsop(2.7672E-7, 2.24392488187, 430.5303441391), new Vsop87.LnVsop(2.9995E-7, 1.96800014066, 2104.5367663768), new Vsop87.LnVsop(3.3001E-7, 3.28430957393, 222.8603229936), new Vsop87.LnVsop(3.185E-7, 6.0254624462, 1905.4647649404), new Vsop87.LnVsop(2.7041E-7, 5.24903909688, 388.4651552382), new Vsop87.LnVsop(2.6641E-7, 0.99264332766, 107.0249274817), new Vsop87.LnVsop(2.551E-7, 2.87428732059, 703.6331846174), new Vsop87.LnVsop(2.5131E-7, 6.23420740285, 106.2741679563), new Vsop87.LnVsop(2.4878E-7, 1.07497317697, 99.9113804809), new Vsop87.LnVsop(2.4759E-7, 0.80405733736, 312.4597163935), new Vsop87.LnVsop(2.4276E-7, 0.55199141887, 214.2623032845), new Vsop87.LnVsop(2.8499E-7, 0.83349243224, 1692.1656695024), new Vsop87.LnVsop(2.3219E-7, 5.08264293708, 479.2883889155), new Vsop87.LnVsop(2.4526E-7, 3.10619175315, 212.3358875915), new Vsop87.LnVsop(2.2349E-7, 3.90137970384, 563.6312150384), new Vsop87.LnVsop(2.2702E-7, 4.87840606475, 295.0512286542), new Vsop87.LnVsop(2.1955E-7, 6.06698971563, 85.8272988312), new Vsop87.LnVsop(2.1324E-7, 5.10526973374, 333.657345044), new Vsop87.LnVsop(2.6085E-7, 2.20779309963, 1265.5674786264), new Vsop87.LnVsop(2.0837E-7, 3.28797767286, 70.8494453042), new Vsop87.LnVsop(2.1581E-7, 3.79617408343, 347.8844390456), new Vsop87.LnVsop(2.1654E-7, 3.08846245324, 554.0699874828), new Vsop87.LnVsop(2.2052E-7, 4.22754164002, 217.964961884), new Vsop87.LnVsop(2.0731E-7, 1.68960056607, 231.4583427027), new Vsop87.LnVsop(2.0494E-7, 2.46182647087, 18.1592472647), new Vsop87.LnVsop(2.0925E-7, 0.39175133338, 319.5732633943), new Vsop87.LnVsop(2.6026E-7, 4.27724058407, 483.2205421786), new Vsop87.LnVsop(2.0643E-7, 5.12362856107, 362.8622925726), new Vsop87.LnVsop(2.2054E-7, 5.50298000967, 343.2185725996), new Vsop87.LnVsop(1.9345E-7, 2.01922865065, 313.2104759189), new Vsop87.LnVsop(2.0192E-7, 5.08643103603, 750.1036075334), new Vsop87.LnVsop(2.0028E-7, 3.42922105654, 213.3472795478), new Vsop87.LnVsop(2.4142E-7, 0.64640167712, 207.8824694666), new Vsop87.LnVsop(2.1796E-7, 0.73044797708, 99.1606209555), new Vsop87.LnVsop(1.727E-7, 4.71665063052, 2111.6503133776), new Vsop87.LnVsop(2.0982E-7, 2.69008992251, 1464.6394800628), new Vsop87.LnVsop(1.8742E-7, 0.05702129406, 245.5424243524), new Vsop87.LnVsop(1.7629E-7, 3.83853708584, 497.4476361802), new Vsop87.LnVsop(1.6065E-7, 4.229802702, 565.1156877467), new Vsop87.LnVsop(2.1656E-7, 4.16347847969, 2.4476805548), new Vsop87.LnVsop(1.7E-7, 1.40795878071, 114.1384744825), new Vsop87.LnVsop(1.5876E-7, 0.27065386568, 225.8292684102), new Vsop87.LnVsop(1.5852E-7, 1.20805133747, 1994.3304451574), new Vsop87.LnVsop(1.547E-7, 2.82288536731, 81.7521332162), new Vsop87.LnVsop(1.6429E-7, 3.03873564611, 134.5853436076), new Vsop87.LnVsop(1.5136E-7, 3.85043836712, 1162.4747044078), new Vsop87.LnVsop(1.6356E-7, 4.94371307069, 357.4456666012), new Vsop87.LnVsop(1.5753E-7, 0.32401034699, 1891.2376709388), new Vsop87.LnVsop(2.0149E-7, 0.23046694374, 213.2509113282), new Vsop87.LnVsop(1.5979E-7, 1.70399938448, 2420.9286360334), new Vsop87.LnVsop(1.82E-7, 5.69547541771, 56.6223513026), new Vsop87.LnVsop(1.3748E-7, 0.57922924289, 2634.2277314714), new Vsop87.LnVsop(1.3932E-7, 5.71088147183, 92.0470739547), new Vsop87.LnVsop(1.7364E-7, 3.55895968238, 218.9281697305), new Vsop87.LnVsop(1.527E-7, 1.31086107175, 216.2198567448), new Vsop87.LnVsop(1.2507E-7, 5.19472995904, 635.9651330509), new Vsop87.LnVsop(1.2805E-7, 1.60063026728, 320.3240229197), new Vsop87.LnVsop(1.303E-7, 0.4651576165, 1169.5882514086), new Vsop87.LnVsop(1.1971E-7, 5.95102208296, 543.9180590962), new Vsop87.LnVsop(1.2216E-7, 2.45946622951, 721.6494195302), new Vsop87.LnVsop(1.181E-7, 2.80512639599, 217.491881132), new Vsop87.LnVsop(1.469E-7, 5.56197626202, 344.7030453079), new Vsop87.LnVsop(1.2762E-7, 1.63557330778, 273.1028404783), new Vsop87.LnVsop(1.3314E-7, 5.76062418273, 2221.856634597), new Vsop87.LnVsop(1.1988E-7, 1.77229641324, 160.6088973985), new Vsop87.LnVsop(1.4265E-7, 0.44725822344, 2008.557539159), new Vsop87.LnVsop(1.2411E-7, 1.01142427141, 329.7251917809), new Vsop87.LnVsop(1.0525E-7, 1.5767134547, 212.7778305762), new Vsop87.LnVsop(1.2743E-7, 1.9146399978, 1581.959348283), new Vsop87.LnVsop(1.1823E-7, 4.4365410311, 32.2433289144), new Vsop87.LnVsop(1.2921E-7, 3.76048627039, 508.3503240922), new Vsop87.LnVsop(1.1939E-7, 4.31098492065, 618.5566453116), new Vsop87.LnVsop(1.1699E-7, 5.10149029775, 4.665866446), new Vsop87.LnVsop(1.0438E-7, 2.42664333945, 546.956440482), new Vsop87.LnVsop(1.078E-7, 0.76340329047, 218.7157214094), new Vsop87.LnVsop(9.965E-8, 0.48733890713, 305.3461693927), new Vsop87.LnVsop(1.1374E-7, 3.00672855291, 198.321241911), new Vsop87.LnVsop(1.0188E-7, 2.65217753299, 416.3032501375), new Vsop87.LnVsop(9.359E-8, 4.45945668775, 2428.0421830342), new Vsop87.LnVsop(9.868E-8, 4.04952727454, 62.2514255951), new Vsop87.LnVsop(9.739E-8, 1.60270650693, 327.4375699205), new Vsop87.LnVsop(1.2641E-7, 3.43384418096, 258.8757464767), new Vsop87.LnVsop(1.121E-7, 2.41205097192, 1781.0313497194), new Vsop87.LnVsop(9.176E-8, 5.46534060702, 414.0680179038), new Vsop87.LnVsop(9.835E-8, 3.30296833339, 275.5505210331), new Vsop87.LnVsop(1.0477E-7, 2.07668803958, 213.8203602998), new Vsop87.LnVsop(9.044E-8, 2.92586386765, 1279.794572628), new Vsop87.LnVsop(9.29E-8, 1.11465540663, 113.3877149571), new Vsop87.LnVsop(1.1089E-7, 1.89011533636, 561.1835344836), new Vsop87.LnVsop(1.2015E-7, 3.70960372833, 350.3321196004), new Vsop87.LnVsop(8.585E-8, 2.17607151845, 425.1137181677), new Vsop87.LnVsop(8.579E-8, 1.94628753992, 35.4247226521), new Vsop87.LnVsop(1.0057E-7, 0.09011158121, 182.279606801), new Vsop87.LnVsop(8.39E-8, 3.76818315225, 251.4321310758), new Vsop87.LnVsop(8.492E-8, 0.36083046533, 617.8058857862), new Vsop87.LnVsop(8.386E-8, 1.809452749, 629.6023455755), new Vsop87.LnVsop(8.172E-8, 5.14289867445, 22.0914005278), new Vsop87.LnVsop(8.147E-8, 5.32044581723, 65.2203710117), new Vsop87.LnVsop(8.151E-8, 1.4090773496, 1.4844727083), new Vsop87.LnVsop(7.981E-8, 0.94228723999, 2310.722314814), new Vsop87.LnVsop(8.963E-8, 6.16236845633, 621.7380390493), new Vsop87.LnVsop(8.224E-8, 0.88795773141, 1485.9801210652), new Vsop87.LnVsop(8.265E-8, 3.45191137955, 424.1505103212), new Vsop87.LnVsop(8.824E-8, 0.54099064621, 168.0525127994), new Vsop87.LnVsop(8.012E-8, 3.37491453205, 144.1465711632), new Vsop87.LnVsop(7.866E-8, 5.14081759801, 358.9301393095), new Vsop87.LnVsop(7.478E-8, 5.75449166453, 447.9388318784), new Vsop87.LnVsop(8.368E-8, 0.33514647428, 278.5194664497), new Vsop87.LnVsop(8.084E-8, 1.42623557144, 2737.32050569), new Vsop87.LnVsop(8.08E-8, 0.95897295917, 767.3690829208), new Vsop87.LnVsop(7.277E-8, 2.18375316605, 264.5048207692), new Vsop87.LnVsop(8.067E-8, 5.44034962793, 254.9435932136), new Vsop87.LnVsop(6.773E-8, 1.1989380823, 5.4166259714), new Vsop87.LnVsop(8.896E-8, 4.89270901021, 120.358249606), new Vsop87.LnVsop(6.488E-8, 0.32888478249, 2950.619601128), new Vsop87.LnVsop(7.86E-8, 4.5700621406, 280.9671470045), new Vsop87.LnVsop(6.488E-8, 3.47445744281, 9.5612275556), new Vsop87.LnVsop(6.985E-8, 3.4022840938, 98.8999885246), new Vsop87.LnVsop(7.599E-8, 4.50333322023, 5.6290742925), new Vsop87.LnVsop(8.097E-8, 0.92606736676, 636.7158925763), new Vsop87.LnVsop(6.142E-8, 0.18131149711, 2207.6295405954), new Vsop87.LnVsop(6.045E-8, 4.66728537547, 543.0242872189), new Vsop87.LnVsop(6.4E-8, 2.12819280953, 274.0660483248), new Vsop87.LnVsop(7.002E-8, 3.84517008953, 214.0498549634), new Vsop87.LnVsop(6.481E-8, 5.31032923608, 6076.8903015542), new Vsop87.LnVsop(5.952E-8, 6.15854896065, 650.9429865779), new Vsop87.LnVsop(5.742E-8, 3.56573285563, 1073.6090241908), new Vsop87.LnVsop(6.438E-8, 0.44934410249, 10007.0999977738), new Vsop87.LnVsop(5.6E-8, 3.61451790802, 125.9873238985), new Vsop87.LnVsop(6.258E-8, 3.20899178273, 219.4494345923), new Vsop87.LnVsop(7.713E-8, 0.11144371545, 2324.9494088156), new Vsop87.LnVsop(5.527E-8, 3.83851162143, 181.0557665236), new Vsop87.LnVsop(5.774E-8, 3.03123084747, 121.2520214833), new Vsop87.LnVsop(6.617E-8, 1.63984257878, 1898.3512179396), new Vsop87.LnVsop(5.881E-8, 1.04006410206, 9992.8729037722), new Vsop87.LnVsop(5.831E-8, 5.91627455087, 6062.6632075526), new Vsop87.LnVsop(5.653E-8, 2.25485721003, 1038.0412891868), new Vsop87.LnVsop(5.908E-8, 6.12631666036, 209.106309744), new Vsop87.LnVsop(5.728E-8, 0.81535963664, 472.1748419147), new Vsop87.LnVsop(6.279E-8, 2.11442272676, 2097.423219376), new Vsop87.LnVsop(5.56E-8, 5.81253256927, 237.6781178262), new Vsop87.LnVsop(6.143E-8, 4.62450813686, 207.6700211455), new Vsop87.LnVsop(5.249E-8, 0.56512879469, 192.6921676185), new Vsop87.LnVsop(5.148E-8, 4.85160826999, 267.4737661858), new Vsop87.LnVsop(5.33E-8, 4.83867853829, 643.0786800517), new Vsop87.LnVsop(6.257E-8, 0.76885025825, 210.3783341312), new Vsop87.LnVsop(5.006E-8, 0.8361738184, 247.2393453818), new Vsop87.LnVsop(5.102E-8, 4.01017179605, 205.2223405907), new Vsop87.LnVsop(6.589E-8, 1.80207391594, 12.5301729722), new Vsop87.LnVsop(4.958E-8, 0.25209781984, 129.9194771616), new Vsop87.LnVsop(4.879E-8, 4.01833561013, 487.3651437628), new Vsop87.LnVsop(4.82E-8, 4.1773567487, 2744.4340526908), new Vsop87.LnVsop(5.028E-8, 4.49963257372, 291.262087743), new Vsop87.LnVsop(5.754E-8, 5.50273050205, 2538.2485042536), new Vsop87.LnVsop(5.717E-8, 0.56525356391, 116.4260963429), new Vsop87.LnVsop(4.721E-8, 5.57698903711, 342.2553647531), new Vsop87.LnVsop(5.961E-8, 5.13028344752, 692.5874843535), new Vsop87.LnVsop(5.005E-8, 2.67919325691, 417.0369633204), new Vsop87.LnVsop(5.371E-8, 3.84343543583, 842.1506814881), new Vsop87.LnVsop(4.699E-8, 3.17263913075, 148.0787244263), new Vsop87.LnVsop(6.196E-8, 3.80255973994, 339.2864193365), new Vsop87.LnVsop(4.531E-8, 5.71955873189, 252.6559713532), new Vsop87.LnVsop(5.557E-8, 0.95921182693, 1802.3719907218), new Vsop87.LnVsop(5.441E-8, 4.39196994952, 196.6243208816), new Vsop87.LnVsop(4.437E-8, 4.92360676724, 184.0941479094), new Vsop87.LnVsop(4.981E-8, 1.60730372548, 166.828672522), new Vsop87.LnVsop(4.867E-8, 0.84582358902, 46.470422916), new Vsop87.LnVsop(4.524E-8, 0.25012053389, 128.9562693151), new Vsop87.LnVsop(5.519E-8, 6.18074896704, 337.732510659), new Vsop87.LnVsop(5.817E-8, 5.953264978, 486.4019359163), new Vsop87.LnVsop(4.49E-8, 4.7275613628, 151.0476698429), new Vsop87.LnVsop(4.229E-8, 4.19753271868, 685.4739373527), new Vsop87.LnVsop(4.822E-8, 1.53957590355, 214.7835681463), new Vsop87.LnVsop(4.259E-8, 4.89602700674, 14.977853527), new Vsop87.LnVsop(3.976E-8, 2.98413489266, 380.12776796), new Vsop87.LnVsop(4.711E-8, 3.65759071858, 189.7232222019), new Vsop87.LnVsop(4.351E-8, 5.42665964067, 436.8931316145), new Vsop87.LnVsop(3.867E-8, 3.04703905658, 409.9234163196), new Vsop87.LnVsop(4.121E-8, 5.81711354467, 491.8185618877), new Vsop87.LnVsop(3.858E-8, 0.73540020809, 2627.1141844706), new Vsop87.LnVsop(4.17E-8, 1.17103665385, 3053.7123753466), new Vsop87.LnVsop(3.964E-8, 3.09877355914, 710.7467316182), new Vsop87.LnVsop(3.7E-8, 1.27418723826, 211.8146227297), new Vsop87.LnVsop(4.811E-8, 0.47066044488, 248.7238180901), new Vsop87.LnVsop(4.996E-8, 3.35730909586, 824.7421937488), new Vsop87.LnVsop(3.907E-8, 3.45934568477, 220.4608265486), new Vsop87.LnVsop(3.565E-8, 4.52827067299, 488.8496164711), new Vsop87.LnVsop(4.85E-8, 3.70375230989, 235.3904959658), new Vsop87.LnVsop(3.549E-8, 2.24093365926, 135.336103133), new Vsop87.LnVsop(3.551E-8, 2.90115048624, 411.620337349), new Vsop87.LnVsop(3.559E-8, 1.11004317365, 6283.0758499914), new Vsop87.LnVsop(3.56E-8, 4.54293796144, 601.7642506762), new Vsop87.LnVsop(3.527E-8, 1.56280584377, 643.8294395771), new Vsop87.LnVsop(3.817E-8, 0.98122521854, 271.4059194489), new Vsop87.LnVsop(3.702E-8, 5.5090303582, 458.8415197904), new Vsop87.LnVsop(3.603E-8, 3.52371843525, 244.318584075), new Vsop87.LnVsop(3.972E-8, 5.20379695714, 114.3991069134), new Vsop87.LnVsop(3.63E-8, 2.21149516722, 2.9207613068), new Vsop87.LnVsop(4.441E-8, 3.75471250684, 699.7010313543), new Vsop87.LnVsop(3.314E-8, 4.27527294246, 867.4234757536), new Vsop87.LnVsop(4.15E-8, 4.21425727533, 501.3797894433), new Vsop87.LnVsop(3.259E-8, 4.47232416065, 289.5651667136), new Vsop87.LnVsop(3.887E-8, 4.78383139539, 175.1660598002), new Vsop87.LnVsop(3.404E-8, 3.49533217629, 963.4027029714), new Vsop87.LnVsop(3.223E-8, 5.89367074982, 131.5469622218), new Vsop87.LnVsop(3.223E-8, 1.95410765469, 212.0270710508), new Vsop87.LnVsop(3.321E-8, 1.95836137959, 1354.4331588434), new Vsop87.LnVsop(3.805E-8, 6.2127100829, 268.4369740323), new Vsop87.LnVsop(3.38E-8, 1.80720303188, 756.3233826569), new Vsop87.LnVsop(3.098E-8, 2.15477201622, 916.9322800554), new Vsop87.LnVsop(3.098E-8, 5.5171211947, 24.3790223882), new Vsop87.LnVsop(3.082E-8, 6.14482751895, 3267.0114707846), new Vsop87.LnVsop(3.113E-8, 4.13740456117, 533.6231183577), new Vsop87.LnVsop(3.625E-8, 3.76005340828, 204.7010757289), new Vsop87.LnVsop(3.657E-8, 5.27032709245, 67.6680515665), new Vsop87.LnVsop(4.003E-8, 6.07055704991, 2641.3412784722), new Vsop87.LnVsop(2.882E-8, 0.84196326695, 444.7574381407), new Vsop87.LnVsop(3.196E-8, 2.69187071972, 426.6463749858), new Vsop87.LnVsop(3.514E-8, 1.39367720888, 2214.7430875962), new Vsop87.LnVsop(3.381E-8, 3.69723542122, 229.9738699944), new Vsop87.LnVsop(2.85E-8, 4.48074469649, 241.6102710893), new Vsop87.LnVsop(2.893E-8, 1.51207793298, 945.9942152321), new Vsop87.LnVsop(3.959E-8, 5.96505772017, 212.5483359126), new Vsop87.LnVsop(3.54E-8, 1.30228911976, 69.1525242748), new Vsop87.LnVsop(3.081E-8, 5.73491728749, 282.6640680339), new Vsop87.LnVsop(3.059E-8, 2.59797438443, 905.8865797915), new Vsop87.LnVsop(2.794E-8, 3.44247926079, 188.9200730498), new Vsop87.LnVsop(2.797E-8, 0.03214799691, 427.5613987225), new Vsop87.LnVsop(2.912E-8, 1.70578054502, 28.3111756513), new Vsop87.LnVsop(2.788E-8, 0.01934629259, 681.5417840896), new Vsop87.LnVsop(2.781E-8, 1.05617356654, 28.4541880032), new Vsop87.LnVsop(3.005E-8, 3.90461328299, 526.5095713569), new Vsop87.LnVsop(3.279E-8, 2.64942711439, 739.8086667949), new Vsop87.LnVsop(2.679E-8, 3.42065965187, 778.4147831847), new Vsop87.LnVsop(2.687E-8, 3.21965090864, 776.9303104764), new Vsop87.LnVsop(3.193E-8, 2.72165081797, 432.2272651685), new Vsop87.LnVsop(3.225E-8, 0.99672485298, 2118.7638603784), new Vsop87.LnVsop(3.232E-8, 1.87653144247, 2413.8150890326), new Vsop87.LnVsop(2.634E-8, 2.55045330366, 10213.285546211), new Vsop87.LnVsop(2.591E-8, 5.44639271736, 305.0855369618), new Vsop87.LnVsop(2.937E-8, 0.8421987444, 2435.155730035), new Vsop87.LnVsop(2.594E-8, 5.42212771611, 207.1487562837), new Vsop87.LnVsop(2.552E-8, 3.86374272953, 3060.8259223474), new Vsop87.LnVsop(2.549E-8, 5.91713564413, 439.1283638482), new Vsop87.LnVsop(2.989E-8, 2.5569061971, 425.6349830295), new Vsop87.LnVsop(3.263E-8, 2.59868619716, 213.0384630071), new Vsop87.LnVsop(3.107E-8, 4.04496319473, 6.1503391543), new Vsop87.LnVsop(2.506E-8, 0.17179793992, 945.2434557067), new Vsop87.LnVsop(2.829E-8, 4.8374091254, 397.3932433474), new Vsop87.LnVsop(3.167E-8, 5.70962048994, 381.3516082374), new Vsop87.LnVsop(3.274E-8, 6.27291197136, 421.1815649046), new Vsop87.LnVsop(2.499E-8, 5.28733779933, 299.1263942692), new Vsop87.LnVsop(2.584E-8, 4.23448348275, 195.8906076987), new Vsop87.LnVsop(3.275E-8, 0.27673788021, 201.5196819912), new Vsop87.LnVsop(2.58E-8, 2.62721090534, 213.1872208534), new Vsop87.LnVsop(2.491E-8, 5.85060777804, 738.7972748386), new Vsop87.LnVsop(2.541E-8, 2.56639705704, 140.001969579), new Vsop87.LnVsop(2.529E-8, 1.99070587972, 319.3126309634), new Vsop87.LnVsop(2.467E-8, 3.42927288151, 4.192785694), new Vsop87.LnVsop(2.42E-8, 2.36333597473, 84.3428261229), new Vsop87.LnVsop(2.372E-8, 2.19097141324, 17.2654753874), new Vsop87.LnVsop(2.346E-8, 3.77641630157, 206.233732547), new Vsop87.LnVsop(2.77E-8, 0.44868346595, 285.6330134505), new Vsop87.LnVsop(2.461E-8, 5.42065334253, 395.578702239), new Vsop87.LnVsop(2.352E-8, 0.63041319237, 210.5907824523), new Vsop87.LnVsop(2.556E-8, 0.31798127807, 326.6868103951), new Vsop87.LnVsop(3.257E-8, 5.02353259776, 313.9441891018), new Vsop87.LnVsop(2.396E-8, 4.05648460784, 519.3960243561), new Vsop87.LnVsop(2.563E-8, 1.24842307195, 724.8308132679), new Vsop87.LnVsop(2.439E-8, 3.49398086505, 431.264057322), new Vsop87.LnVsop(2.299E-8, 0.13437111088, 2524.021410252), new Vsop87.LnVsop(2.299E-8, 4.51974731455, 228.276948965), new Vsop87.LnVsop(2.515E-8, 0.70044371265, 2943.5060541272), new Vsop87.LnVsop(3.111E-8, 2.77650913154, 732.6951197941), new Vsop87.LnVsop(2.453E-8, 3.14780313298, 170.7608257851), new Vsop87.LnVsop(2.673E-8, 3.33934506849, 1141.1340634054), new Vsop87.LnVsop(2.501E-8, 3.85258138055, 696.5196376166), new Vsop87.LnVsop(2.384E-8, 0.80154277885, 3370.1042450032), new Vsop87.LnVsop(2.318E-8, 0.79742541663, 426.0769260142), new Vsop87.LnVsop(2.204E-8, 0.22323394228, 3259.8979237838), new Vsop87.LnVsop(2.647E-8, 2.60111065092, 436.1594184316), new Vsop87.LnVsop(2.126E-8, 0.1483231766, 405.9912630565), new Vsop87.LnVsop(2.301E-8, 1.25086250691, 427.1194557378), new Vsop87.LnVsop(2.752E-8, 3.02333147039, 468.2426886516), new Vsop87.LnVsop(2.128E-8, 3.08760310976, 203.2647871304), new Vsop87.LnVsop(2.105E-8, 0.46661118435, 184.9879197867), new Vsop87.LnVsop(2.354E-8, 2.59778868023, 511.5317178299), new Vsop87.LnVsop(2.333E-8, 3.02634928771, 216.0074084237), new Vsop87.LnVsop(2.162E-8, 4.27244747747, 7.1617311106), new Vsop87.LnVsop(2.581E-8, 4.73385922413, 221.3758502853), new Vsop87.LnVsop(2.074E-8, 0.57960021408, 180.1619946463), new Vsop87.LnVsop(2.478E-8, 4.72786315991, 556.5176680376), new Vsop87.LnVsop(2.58E-8, 1.0370534038, 213.4109700226), new Vsop87.LnVsop(2.025E-8, 2.28785218653, 610.6923387854), new Vsop87.LnVsop(2.244E-8, 0.12206585141, 259.769518354), new Vsop87.LnVsop(2.005E-8, 3.14124583124, 1382.8873468466), new Vsop87.LnVsop(2.052E-8, 0.7429125469, 200.5564741447), new Vsop87.LnVsop(1.985E-8, 3.34537824132, 421.93232443), new Vsop87.LnVsop(2.0E-8, 5.26813039382, 661.2379273164), new Vsop87.LnVsop(2.153E-8, 0.85935268348, 286.596221297), new Vsop87.LnVsop(1.936E-8, 1.0528693453, 1262.3860848887), new Vsop87.LnVsop(2.039E-8, 1.72125271358, 1670.8250285), new Vsop87.LnVsop(1.901E-8, 0.58371277903, 406.954470903), new Vsop87.LnVsop(1.976E-8, 1.31263772907, 135.5485514541), new Vsop87.LnVsop(2.447E-8, 0.52794500154, 429.5189521828), new Vsop87.LnVsop(2.174E-8, 2.29627370615, 1773.9178027186), new Vsop87.LnVsop(1.895E-8, 2.80891695372, 141.6988906084), new Vsop87.LnVsop(1.872E-8, 4.35634331322, 572.2292347475), new Vsop87.LnVsop(1.863E-8, 1.4831442904, 638.4128136057), new Vsop87.LnVsop(2.007E-8, 1.73735242111, 193.655375465), new Vsop87.LnVsop(1.927E-8, 1.56648434889, 391.1734682239), new Vsop87.LnVsop(1.844E-8, 6.11579285251, 1261.6353253633), new Vsop87.LnVsop(2.179E-8, 6.14304471748, 205.4347889118), new Vsop87.LnVsop(2.094E-8, 5.00798053675, 420.9691165835), new Vsop87.LnVsop(2.538E-8, 5.83123621858, 426.5500067662), new Vsop87.LnVsop(2.168E-8, 0.41741136149, 213.5115437591), new Vsop87.LnVsop(2.433E-8, 1.02613363057, 59.8037450403), new Vsop87.LnVsop(1.836E-8, 0.30655659532, 938.1299087059), new Vsop87.LnVsop(1.83E-8, 5.54146705928, 206.1373643274), new Vsop87.LnVsop(1.776E-8, 2.1638241283, 72.0732855816), new Vsop87.LnVsop(2.034E-8, 1.21814866092, 3046.5988283458), new Vsop87.LnVsop(1.879E-8, 4.4335865129, 576.1613880106), new Vsop87.LnVsop(1.753E-8, 0.06020614247, 241.7532834412), new Vsop87.LnVsop(2.168E-8, 3.24685294764, 213.0866471169), new Vsop87.LnVsop(1.74E-8, 0.14507117402, 196.0336200506), new Vsop87.LnVsop(1.84E-8, 2.85531411351, 842.9014410135), new Vsop87.LnVsop(2.254E-8, 5.04269960259, 558.0021407459), new Vsop87.LnVsop(2.357E-8, 5.39214088781, 2854.6403739102), new Vsop87.LnVsop(1.84E-8, 2.81087023611, 179.3588454942), new Vsop87.LnVsop(1.765E-8, 3.65425588942, 403.0223176399), new Vsop87.LnVsop(2.147E-8, 1.24753861866, 624.919432787), new Vsop87.LnVsop(1.749E-8, 5.29018685566, 87.3117715395), new Vsop87.LnVsop(1.903E-8, 2.91827326906, 398.1440028728), new Vsop87.LnVsop(2.073E-8, 2.50732735763, 26.826702943), new Vsop87.LnVsop(1.675E-8, 4.80439517678, 181.806526049), new Vsop87.LnVsop(1.902E-8, 2.74426125465, 4952.0635932862), new Vsop87.LnVsop(1.962E-8, 3.52111949662, 213.4591541324), new Vsop87.LnVsop(2.076E-8, 3.2790596932, 1596.1864422846), new Vsop87.LnVsop(1.892E-8, 6.08128888555, 230.7075831773), new Vsop87.LnVsop(1.75E-8, 1.10237257017, 586.3133163972), new Vsop87.LnVsop(1.71E-8, 2.1459528792, 1056.2005364515), new Vsop87.LnVsop(1.616E-8, 2.12300497232, 430.79097657), new Vsop87.LnVsop(1.681E-8, 6.0994130421, 952.3570027075), new Vsop87.LnVsop(1.655E-8, 2.26128695913, 418.5214360287), new Vsop87.LnVsop(1.871E-8, 5.61838915758, 2957.7331481288), new Vsop87.LnVsop(1.962E-8, 0.13564680851, 213.1390367436), new Vsop87.LnVsop(1.629E-8, 2.83974065181, 92.7978334801), new Vsop87.LnVsop(2.145E-8, 5.44218817748, 627.3671133418), new Vsop87.LnVsop(1.792E-8, 1.07109040443, 355.7487455718), new Vsop87.LnVsop(1.647E-8, 0.82347900016, 214.5711198252), new Vsop87.LnVsop(1.624E-8, 1.17583107487, 739.0579072695), new Vsop87.LnVsop(1.524E-8, 2.71525171937, 73.297125859), new Vsop87.LnVsop(1.788E-8, 1.2490851295, 219.891377577), new Vsop87.LnVsop(1.524E-8, 5.26558677448, 5429.8794682394), new Vsop87.LnVsop(1.615E-8, 2.9899688328, 45.5766510387), new Vsop87.LnVsop(1.692E-8, 1.91984860233, 630.3360587584), new Vsop87.LnVsop(1.742E-8, 0.38573693332, 831.1049812242), new Vsop87.LnVsop(1.92E-8, 5.19783839519, 550.1378342197), new Vsop87.LnVsop(1.936E-8, 2.81335247199, 429.0458714308), new Vsop87.LnVsop(1.504E-8, 1.90331343411, 205.6642835754), new Vsop87.LnVsop(1.596E-8, 0.99004701777, 953.1077622329), new Vsop87.LnVsop(1.782E-8, 3.91453968301, 159.1244246902), new Vsop87.LnVsop(1.47E-8, 5.46587523637, 273.8536000037), new Vsop87.LnVsop(1.46E-8, 1.3167378976, 84.9335269539), new Vsop87.LnVsop(1.479E-8, 5.27664183474, 757.2171545342), new Vsop87.LnVsop(1.455E-8, 2.61054780734, 850.0149880143), new Vsop87.LnVsop(1.808E-8, 3.96315121347, 1699.2792165032), new Vsop87.LnVsop(1.643E-8, 0.57689283331, 532.6117264014), new Vsop87.LnVsop(1.887E-8, 2.78798625347, 418.0001711669), new Vsop87.LnVsop(1.607E-8, 1.08154126629, 518.3846323998), new Vsop87.LnVsop(1.68E-8, 3.17515284087, 105.5404547734), new Vsop87.LnVsop(1.641E-8, 2.91802756388, 172.2452984934), new Vsop87.LnVsop(1.48E-8, 4.08712341396, 206.9363079626), new Vsop87.LnVsop(1.407E-8, 3.2376562218, 453.424893819), new Vsop87.LnVsop(1.631E-8, 1.06286709889, 213.5597278689), new Vsop87.LnVsop(1.466E-8, 1.13594271587, 731.9443602687), new Vsop87.LnVsop(1.389E-8, 0.40584159469, 9360.089164459), new Vsop87.LnVsop(1.496E-8, 1.12030845793, 423.6774295692), new Vsop87.LnVsop(1.668E-8, 4.32873096627, 173.9422195228), new Vsop87.LnVsop(1.467E-8, 0.03783145221, 432.0148168474), new Vsop87.LnVsop(1.824E-8, 0.24130491507, 220.364458329), new Vsop87.LnVsop(1.408E-8, 3.34120468096, 934.9485149682), new Vsop87.LnVsop(1.341E-8, 1.40041251657, 373.9079928365), new Vsop87.LnVsop(1.34E-8, 1.30057612449, 428.0826635843), new Vsop87.LnVsop(1.663E-8, 2.38182712355, 188.0263011725), new Vsop87.LnVsop(1.416E-8, 3.65464640816, 6.8529145699), new Vsop87.LnVsop(1.39E-8, 0.72143566917, 2751.5475996916), new Vsop87.LnVsop(1.562E-8, 5.99871360541, 292.0128472684), new Vsop87.LnVsop(1.388E-8, 1.31100159458, 6275.9623029906), new Vsop87.LnVsop(1.351E-8, 5.85616582168, 5863.5912061162), new Vsop87.LnVsop(1.475E-8, 1.21040113552, 2531.1349572528), new Vsop87.LnVsop(1.481E-8, 4.9347698651, 384.0599212231), new Vsop87.LnVsop(1.271E-8, 3.46636801274, 354.9979860464), new Vsop87.LnVsop(1.437E-8, 4.05228413274, 177.8743727859), new Vsop87.LnVsop(1.619E-8, 2.44942359064, 1049.0869894507), new Vsop87.LnVsop(1.626E-8, 3.16002444915, 835.7878940127), new Vsop87.LnVsop(1.249E-8, 2.97028182853, 51749.20809227239), new Vsop87.LnVsop(1.387E-8, 3.37238340312, 409.1897031367), new Vsop87.LnVsop(1.24E-8, 2.66940683813, 2700.7151403858), new Vsop87.LnVsop(1.457E-8, 1.85616688056, 96.8729990951), new Vsop87.LnVsop(1.23E-8, 4.27283851216, 12139.5535091068), new Vsop87.LnVsop(1.221E-8, 4.36973999431, 3914.0223040994), new Vsop87.LnVsop(1.251E-8, 5.29882815294, 306.0969289181), new Vsop87.LnVsop(1.4E-8, 5.0407108032, 295.1942410061), new Vsop87.LnVsop(1.304E-8, 5.77737491864, 60.5545045657), new Vsop87.LnVsop(1.247E-8, 0.99106661572, 9793.8009023358), new Vsop87.LnVsop(1.174E-8, 6.11392643811, 823.9914342234), new Vsop87.LnVsop(1.231E-8, 1.1089053072, 2303.6087678132), new Vsop87.LnVsop(1.186E-8, 4.55984967028, 9808.5381846614), new Vsop87.LnVsop(1.401E-8, 2.50099443277, 206.706813299), new Vsop87.LnVsop(1.181E-8, 5.81146592434, 569.0478410098), new Vsop87.LnVsop(1.234E-8, 2.72607019445, 10206.1719992102), new Vsop87.LnVsop(1.334E-8, 4.87244369722, 54.1746707478), new Vsop87.LnVsop(1.198E-8, 5.42400970257, 864.2420820159), new Vsop87.LnVsop(1.499E-8, 0.34153793328, 17.4084877393), new Vsop87.LnVsop(1.143E-8, 1.61667366569, 238.5718897035), new Vsop87.LnVsop(1.199E-8, 1.39732488359, 1987.2168981566), new Vsop87.LnVsop(1.266E-8, 5.89383144767, 162.8965192589), new Vsop87.LnVsop(1.268E-8, 4.10670310052, 3377.217792004), new Vsop87.LnVsop(1.297E-8, 4.35617934153, 606.7601855223), new Vsop87.LnVsop(1.27E-8, 2.05134233573, 525.7588118315), new Vsop87.LnVsop(1.203E-8, 1.96781078617, 220.9339073006), new Vsop87.LnVsop(1.196E-8, 5.1348521485, 227.3137411185), new Vsop87.LnVsop(1.537E-8, 3.54197877408, 2015.6710861598), new Vsop87.LnVsop(1.098E-8, 5.0954389741, 107.7586406646), new Vsop87.LnVsop(1.153E-8, 5.33028034679, 233.9060232575), new Vsop87.LnVsop(1.365E-8, 3.08025915574, 427.3489504014), new Vsop87.LnVsop(1.075E-8, 3.06444759157, 464.7312265138), new Vsop87.LnVsop(1.374E-8, 2.92410533076, 1457.525933062), new Vsop87.LnVsop(1.352E-8, 2.28174856694, 525.4981794006), new Vsop87.LnVsop(1.073E-8, 1.11416151647, 221.1634019642), new Vsop87.LnVsop(1.344E-8, 1.64695425702, 857.1285350151), new Vsop87.LnVsop(1.184E-8, 2.99776919968, 199.2844497575), new Vsop87.LnVsop(1.107E-8, 4.1210715373, 188.1693135244), new Vsop87.LnVsop(1.048E-8, 0.92836722889, 162.0933701068), new Vsop87.LnVsop(1.042E-8, 3.19127595332, 394.3548619616), new Vsop87.LnVsop(1.117E-8, 3.74367882111, 214.1928673153), new Vsop87.LnVsop(1.348E-8, 3.91347414537, 318.8395502114), new Vsop87.LnVsop(1.423E-8, 5.5511175076, 3274.1250177854), new Vsop87.LnVsop(1.002E-8, 3.38741565397, 211.6021744086), new Vsop87.LnVsop(1.23E-8, 5.4121782689, 425.8474313506), new Vsop87.LnVsop(9.9E-9, 4.85610832843, 611.4430983108), new Vsop87.LnVsop(1.038E-8, 2.75247985959, 637.4496057592), new Vsop87.LnVsop(1.033E-8, 3.81628585983, 504.561183181), new Vsop87.LnVsop(1.167E-8, 5.17428865567, 838.218528225), new Vsop87.LnVsop(1.014E-8, 5.86348763799, 1268.7488723641), new Vsop87.LnVsop(9.71E-9, 0.71587860892, 353.301065017), new Vsop87.LnVsop(9.79E-9, 3.76338750757, 5856.4776591154), new Vsop87.LnVsop(1.162E-8, 0.39950647, 393.4610900843), new Vsop87.LnVsop(1.132E-8, 6.20586626566, 42.5382696529), new Vsop87.LnVsop(9.93E-9, 2.43898404688, 361.3778198643), new Vsop87.LnVsop(9.68E-9, 4.34102490096, 92.940845832), new Vsop87.LnVsop(9.92E-9, 3.44191274254, 244.791664827), new Vsop87.LnVsop(1.04E-8, 2.09854075205, 6290.1893969922), new Vsop87.LnVsop(1.199E-8, 4.50333414597, 465.9550667912), new Vsop87.LnVsop(1.045E-8, 4.35802840016, 199.9657733137), new Vsop87.LnVsop(9.97E-9, 4.30943991893, 212.4053235607), new Vsop87.LnVsop(1.112E-8, 2.01573268377, 401.3253966105), new Vsop87.LnVsop(1.126E-8, 3.10437252196, 2332.0629558164), new Vsop87.LnVsop(9.47E-9, 1.94989936958, 1159.2933106701), new Vsop87.LnVsop(1.004E-8, 3.82717589308, 238.4288773516), new Vsop87.LnVsop(9.87E-9, 1.93295365583, 184.8449074348), new Vsop87.LnVsop(1.267E-8, 2.15471388627, 78.7137518304), new Vsop87.LnVsop(1.012E-8, 3.24365897308, 153.4953503977), new Vsop87.LnVsop(8.95E-9, 0.68991951614, 731.6837278378), new Vsop87.LnVsop(9.84E-9, 3.6576454894, 226.6324175623), new Vsop87.LnVsop(8.89E-9, 1.76327775185, 223.3334037456), new Vsop87.LnVsop(9.01E-9, 1.1287627907, 51.2057253312), new Vsop87.LnVsop(8.95E-9, 1.86564778046, 622.4887985747), new Vsop87.LnVsop(1.02E-8, 5.53181822898, 0.0481841098), new Vsop87.LnVsop(8.73E-9, 5.78462965667, 480.7728616238), new Vsop87.LnVsop(8.54E-9, 1.63255087291, 328.2407190726), new Vsop87.LnVsop(8.53E-9, 1.59662886472, 477.8039162072), new Vsop87.LnVsop(9.52E-9, 1.99527233195, 969.6224780949), new Vsop87.LnVsop(8.58E-9, 5.33623034689, 450.9772132642), new Vsop87.LnVsop(8.67E-9, 2.93211582569, 532.8723588323), new Vsop87.LnVsop(9.0E-9, 1.32666825337, 700.4517908797), new Vsop87.LnVsop(1.123E-8, 4.07401922216, 3693.6096616606), new Vsop87.LnVsop(8.7E-9, 5.51456846454, 159.7151255212), new Vsop87.LnVsop(8.9E-9, 1.03814593125, 960.2213092337), new Vsop87.LnVsop(1.007E-8, 2.73615455688, 4841.8572720668), new Vsop87.LnVsop(9.4E-9, 4.20216070094, 597.3590166611), new Vsop87.LnVsop(9.41E-9, 5.31417860339, 369.9758395734), new Vsop87.LnVsop(8.11E-9, 0.48369226007, 219.6618829134), new Vsop87.LnVsop(1.031E-8, 5.83082902191, 460.5384408198), new Vsop87.LnVsop(8.18E-9, 0.74630905568, 1048.3362299253), new Vsop87.LnVsop(9.54E-9, 5.1733311808, 263.7016716171), new Vsop87.LnVsop(8.04E-9, 1.29176785836, 2847.5268269094), new Vsop87.LnVsop(8.16E-9, 5.61212780797, 885.4397106664), new Vsop87.LnVsop(8.76E-9, 3.5247854882, 10220.3990932118), new Vsop87.LnVsop(8.14E-9, 0.18673966399, 2840.4132799086), new Vsop87.LnVsop(8.23E-9, 5.54820600927, 3171.0322435668), new Vsop87.LnVsop(8.61E-9, 4.39588667312, 552.5855147745), new Vsop87.LnVsop(7.91E-9, 2.62306937203, 1912.5783119412), new Vsop87.LnVsop(7.54E-9, 3.62688875653, 2648.454825473), new Vsop87.LnVsop(8.52E-9, 1.03470840672, 2620.0006374698), new Vsop87.LnVsop(7.91E-9, 3.97836634968, 171.6545976624), new Vsop87.LnVsop(7.84E-9, 5.95489308729, 561.934294009), new Vsop87.LnVsop(9.72E-9, 4.53754130765, 570.7447620392), new Vsop87.LnVsop(7.39E-9, 3.57172839746, 775.233389447), new Vsop87.LnVsop(8.74E-9, 4.15274163736, 41.6444977756), new Vsop87.LnVsop(8.31E-9, 1.41326596696, 287.9376816534), new Vsop87.LnVsop(7.07E-9, 2.18372065037, 29.2049475286), new Vsop87.LnVsop(7.11E-9, 0.00981284716, 2115.5824666407), new Vsop87.LnVsop(7.24E-9, 1.54245854571, 201.9927627432), new Vsop87.LnVsop(9.39E-9, 0.46037763932, 5488.8681053816), new Vsop87.LnVsop(9.39E-9, 1.85473712038, 5062.2699145056), new Vsop87.LnVsop(7.24E-9, 1.62856264107, 2200.5159935946), new Vsop87.LnVsop(7.06E-9, 0.31965789145, 898.7730327907), new Vsop87.LnVsop(6.81E-9, 6.01812948937, 91.7864415238)};
        private static final Vsop87.LnVsop[] saturn_radius_r2 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.00436902572, 4.78671677509, 213.299095438), new Vsop87.LnVsop(7.1922498E-4, 2.5007006993, 206.1855484372), new Vsop87.LnVsop(4.9766872E-4, 4.97167777235, 220.4126424388), new Vsop87.LnVsop(4.3220783E-4, 3.86941044212, 426.598190876), new Vsop87.LnVsop(2.9645766E-4, 5.96309886479, 7.1135470008), new Vsop87.LnVsop(4.141687E-5, 4.10673009419, 433.7117378768), new Vsop87.LnVsop(4.720822E-5, 2.47524028389, 199.0720014364), new Vsop87.LnVsop(3.789321E-5, 3.0977118974, 639.897286314), new Vsop87.LnVsop(2.963981E-5, 1.37198670946, 103.0927742186), new Vsop87.LnVsop(2.556403E-5, 2.85066948131, 419.4846438752), new Vsop87.LnVsop(2.208473E-5, 6.27590108662, 110.2063212194), new Vsop87.LnVsop(2.187311E-5, 5.8554501714, 14.2270940016), new Vsop87.LnVsop(1.956779E-5, 4.92451269861, 227.5261894396), new Vsop87.LnVsop(2.326777E-5, 0.0, 0.0), new Vsop87.LnVsop(9.23829E-6, 5.4638968891, 323.5054166574), new Vsop87.LnVsop(7.05974E-6, 2.97065900638, 95.9792272178), new Vsop87.LnVsop(5.45943E-6, 4.12843012325, 412.3710968744), new Vsop87.LnVsop(3.73763E-6, 5.8341214698, 117.3198682202), new Vsop87.LnVsop(3.60843E-6, 3.27730304283, 647.0108333148), new Vsop87.LnVsop(3.56448E-6, 3.19046275776, 210.1177017003), new Vsop87.LnVsop(3.90607E-6, 4.48122593284, 216.4804891757), new Vsop87.LnVsop(4.31231E-6, 5.17807636127, 522.5774180938), new Vsop87.LnVsop(3.25474E-6, 2.26775488379, 853.196381752), new Vsop87.LnVsop(4.04424E-6, 4.17313476718, 209.3669421749), new Vsop87.LnVsop(2.04458E-6, 0.08803952503, 202.2533951741), new Vsop87.LnVsop(2.06684E-6, 4.02119282093, 735.8765135318), new Vsop87.LnVsop(1.77973E-6, 4.09718163123, 440.8252848776), new Vsop87.LnVsop(1.79903E-6, 3.59725930296, 632.7837393132), new Vsop87.LnVsop(1.53635E-6, 3.13514267989, 625.6701923124), new Vsop87.LnVsop(1.47816E-6, 0.13561171385, 302.164775655), new Vsop87.LnVsop(1.23132E-6, 4.188082239, 88.865680217), new Vsop87.LnVsop(1.32767E-6, 2.59540724138, 191.9584544356), new Vsop87.LnVsop(1.00365E-6, 5.46047886103, 3.1813937377), new Vsop87.LnVsop(1.31964E-6, 5.9341108212, 309.2783226558), new Vsop87.LnVsop(9.7129E-7, 4.01875371334, 728.762966531), new Vsop87.LnVsop(1.10801E-6, 4.78116393398, 838.9692877504), new Vsop87.LnVsop(1.18896E-6, 5.55283545372, 224.3447957019), new Vsop87.LnVsop(9.3927E-7, 4.38412535132, 217.2312487011), new Vsop87.LnVsop(1.08788E-6, 5.29339369085, 515.463871093), new Vsop87.LnVsop(7.856E-7, 5.72528816327, 21.3406410024), new Vsop87.LnVsop(8.1356E-7, 5.10874041756, 956.2891559706), new Vsop87.LnVsop(9.6525E-7, 6.25894400082, 742.9900605326), new Vsop87.LnVsop(6.9181E-7, 4.0500529712, 3.9321532631), new Vsop87.LnVsop(6.483E-7, 3.78002548365, 1052.2683831884), new Vsop87.LnVsop(6.3978E-7, 5.81225801002, 529.6909650946), new Vsop87.LnVsop(6.2365E-7, 2.18095710071, 195.1398481733), new Vsop87.LnVsop(5.7229E-7, 3.14757658238, 203.0041546995), new Vsop87.LnVsop(5.5804E-7, 4.84263005967, 234.6397364404), new Vsop87.LnVsop(5.3036E-7, 5.07508755229, 330.6189636582), new Vsop87.LnVsop(5.0918E-7, 2.77244266104, 942.062061969), new Vsop87.LnVsop(4.4966E-7, 0.58212370012, 269.9214467406), new Vsop87.LnVsop(4.1393E-7, 4.78657175977, 63.7358983034), new Vsop87.LnVsop(4.1412E-7, 3.73171033163, 316.3918696566), new Vsop87.LnVsop(5.2786E-7, 3.920753603, 949.1756089698), new Vsop87.LnVsop(3.8591E-7, 3.74711996033, 1045.1548361876), new Vsop87.LnVsop(3.7347E-7, 4.19076534429, 536.8045120954), new Vsop87.LnVsop(3.549E-7, 2.91778598255, 284.1485407422), new Vsop87.LnVsop(3.365E-7, 3.80330571653, 149.5631971346), new Vsop87.LnVsop(4.09E-7, 4.58137310079, 1155.361157407), new Vsop87.LnVsop(3.0568E-7, 2.48114941443, 860.3099287528), new Vsop87.LnVsop(3.1258E-7, 4.84287013662, 1272.6810256272), new Vsop87.LnVsop(3.9345E-7, 3.51497594706, 422.6660376129), new Vsop87.LnVsop(3.0267E-7, 4.35601859659, 405.2575498736), new Vsop87.LnVsop(2.9735E-7, 1.58889278109, 1066.49547719), new Vsop87.LnVsop(3.5157E-7, 5.94690982234, 1059.3819301892), new Vsop87.LnVsop(2.5796E-7, 3.5517378854, 1368.660252845), new Vsop87.LnVsop(2.6344E-7, 4.80468984306, 124.433415221), new Vsop87.LnVsop(2.9862E-7, 3.66430349958, 429.7795846137), new Vsop87.LnVsop(3.289E-7, 4.96719279752, 831.8557407496), new Vsop87.LnVsop(2.2072E-7, 2.76570533706, 415.5524906121), new Vsop87.LnVsop(2.6103E-7, 4.4552180721, 223.5940361765), new Vsop87.LnVsop(2.3925E-7, 5.30856839441, 10.2949407385), new Vsop87.LnVsop(2.7199E-7, 1.66568373581, 277.0349937414), new Vsop87.LnVsop(2.16E-7, 1.03111763332, 11.0457002639), new Vsop87.LnVsop(1.9791E-7, 2.53638693425, 1258.4539316256), new Vsop87.LnVsop(1.704E-7, 3.27716162306, 654.1243803156), new Vsop87.LnVsop(1.7345E-7, 3.49852392962, 1361.5467058442), new Vsop87.LnVsop(1.5726E-7, 1.72390137596, 490.3340891794), new Vsop87.LnVsop(2.0965E-7, 3.62456217146, 1265.5674786264), new Vsop87.LnVsop(1.7893E-7, 4.30763518069, 1471.7530270636), new Vsop87.LnVsop(1.3547E-7, 0.32283926763, 295.0512286542), new Vsop87.LnVsop(1.2646E-7, 3.13027912532, 74.7815985673), new Vsop87.LnVsop(1.5208E-7, 3.59590956406, 265.9892934775), new Vsop87.LnVsop(1.1701E-7, 2.33365710225, 210.8514148832), new Vsop87.LnVsop(1.5492E-7, 5.01357631979, 127.4717966068), new Vsop87.LnVsop(1.2792E-7, 4.61580100969, 1589.0728952838), new Vsop87.LnVsop(1.0737E-7, 5.04941789777, 191.2076949102), new Vsop87.LnVsop(1.4117E-7, 3.04728052859, 423.4167971383), new Vsop87.LnVsop(1.1052E-7, 4.51972952811, 81.7521332162), new Vsop87.LnVsop(1.3338E-7, 4.8899993703, 437.6438911399), new Vsop87.LnVsop(1.0549E-7, 5.02936454854, 137.0330241624), new Vsop87.LnVsop(1.4258E-7, 4.6919299495, 1148.2476104062), new Vsop87.LnVsop(1.3432E-7, 1.9111707707, 408.4389436113), new Vsop87.LnVsop(1.0094E-7, 5.20250555714, 340.7708920448), new Vsop87.LnVsop(1.0411E-7, 3.33366465751, 1685.0521225016), new Vsop87.LnVsop(9.52E-8, 3.19193162671, 351.8165923087), new Vsop87.LnVsop(1.1397E-7, 5.48081632887, 1375.7737998458), new Vsop87.LnVsop(8.777E-8, 2.80839077219, 99.9113804809), new Vsop87.LnVsop(8.733E-8, 3.22125033819, 1677.9385755008), new Vsop87.LnVsop(7.85E-8, 2.36712432378, 1574.8458012822), new Vsop87.LnVsop(7.658E-8, 6.08736238432, 231.4583427027), new Vsop87.LnVsop(9.222E-8, 3.40983965001, 1581.959348283), new Vsop87.LnVsop(8.222E-8, 4.04654478628, 1788.1448967202), new Vsop87.LnVsop(7.179E-8, 2.00932392414, 131.4039498699), new Vsop87.LnVsop(7.672E-8, 3.69477797972, 846.0828347512), new Vsop87.LnVsop(6.723E-8, 4.38526201358, 145.6310438715), new Vsop87.LnVsop(6.408E-8, 1.31732334919, 215.7467759928), new Vsop87.LnVsop(6.29E-8, 4.01002594556, 447.9388318784), new Vsop87.LnVsop(7.239E-8, 3.29158763151, 750.1036075334), new Vsop87.LnVsop(6.054E-8, 0.55440901153, 18.1592472647), new Vsop87.LnVsop(5.878E-8, 4.48086148593, 106.2741679563), new Vsop87.LnVsop(6.14E-8, 3.78862477414, 313.2104759189), new Vsop87.LnVsop(6.911E-8, 4.84071390677, 319.5732633943), new Vsop87.LnVsop(6.823E-8, 5.44107387955, 508.3503240922), new Vsop87.LnVsop(6.072E-8, 2.90739860693, 138.5174968707), new Vsop87.LnVsop(7.309E-8, 4.37976118424, 1464.6394800628), new Vsop87.LnVsop(5.615E-8, 4.1761755515, 721.6494195302), new Vsop87.LnVsop(5.14E-8, 2.65252687662, 288.0806940053), new Vsop87.LnVsop(5.311E-8, 3.6252084951, 6076.8903015542), new Vsop87.LnVsop(5.193E-8, 5.04861839155, 10007.0999977738), new Vsop87.LnVsop(5.472E-8, 1.1708333574, 56.6223513026), new Vsop87.LnVsop(5.383E-8, 4.35702878688, 1905.4647649404), new Vsop87.LnVsop(5.195E-8, 4.18394941363, 543.9180590962), new Vsop87.LnVsop(4.765E-8, 3.32372808126, 76.2660712756), new Vsop87.LnVsop(4.694E-8, 6.25649673541, 483.2205421786), new Vsop87.LnVsop(4.519E-8, 1.21202742896, 200.7689224658), new Vsop87.LnVsop(4.922E-8, 3.14333262849, 2001.4439921582), new Vsop87.LnVsop(4.712E-8, 1.26507812515, 6062.6632075526), new Vsop87.LnVsop(4.851E-8, 2.42490640186, 628.8515860501), new Vsop87.LnVsop(5.155E-8, 4.4512863615, 416.3032501375), new Vsop87.LnVsop(4.626E-8, 2.68842971043, 9992.8729037722), new Vsop87.LnVsop(4.261E-8, 2.01635516905, 347.8844390456), new Vsop87.LnVsop(4.843E-8, 5.93693841859, 618.5566453116), new Vsop87.LnVsop(4.556E-8, 0.75092365616, 333.657345044), new Vsop87.LnVsop(4.249E-8, 0.82449917175, 222.8603229936), new Vsop87.LnVsop(4.342E-8, 0.9627351577, 343.2185725996), new Vsop87.LnVsop(4.444E-8, 5.77025648302, 184.8449074348), new Vsop87.LnVsop(4.169E-8, 2.95237909837, 107.0249274817), new Vsop87.LnVsop(3.894E-8, 2.91997373157, 38.1330356378), new Vsop87.LnVsop(3.898E-8, 1.97004731481, 497.4476361802), new Vsop87.LnVsop(3.994E-8, 2.91478526694, 1994.3304451574), new Vsop87.LnVsop(5.097E-8, 3.13189365474, 1898.3512179396), new Vsop87.LnVsop(3.629E-8, 3.25010351543, 362.8622925726), new Vsop87.LnVsop(3.699E-8, 4.17117563916, 430.5303441391), new Vsop87.LnVsop(3.56E-8, 3.4822402108, 388.4651552382), new Vsop87.LnVsop(3.694E-8, 0.89402011536, 703.6331846174), new Vsop87.LnVsop(3.606E-8, 0.0348773782, 32.2433289144), new Vsop87.LnVsop(3.484E-8, 1.83233211242, 70.8494453042), new Vsop87.LnVsop(3.611E-8, 3.27859535883, 635.9651330509), new Vsop87.LnVsop(3.479E-8, 1.96759778624, 203.7378678824), new Vsop87.LnVsop(3.39E-8, 1.2313404579, 134.5853436076), new Vsop87.LnVsop(3.551E-8, 3.29904637657, 357.4456666012), new Vsop87.LnVsop(4.236E-8, 5.47583443571, 1692.1656695024), new Vsop87.LnVsop(3.289E-8, 0.57265070971, 10213.285546211), new Vsop87.LnVsop(3.247E-8, 5.47801108148, 6283.0758499914), new Vsop87.LnVsop(3.125E-8, 2.18412055759, 1891.2376709388), new Vsop87.LnVsop(3.319E-8, 3.543626184, 629.6023455755), new Vsop87.LnVsop(3.03E-8, 3.9110870462, 312.1990839626), new Vsop87.LnVsop(4.163E-8, 5.19007572863, 404.5067903482), new Vsop87.LnVsop(4.076E-8, 4.10841252077, 1781.0313497194), new Vsop87.LnVsop(3.774E-8, 3.80557045886, 2104.5367663768), new Vsop87.LnVsop(3.206E-8, 3.89813077889, 1038.0412891868), new Vsop87.LnVsop(2.872E-8, 2.1977039642, 217.964961884), new Vsop87.LnVsop(3.294E-8, 5.62584228838, 113.3877149571), new Vsop87.LnVsop(3.157E-8, 2.95571558329, 52.6901980395), new Vsop87.LnVsop(2.888E-8, 2.56166067768, 867.4234757536), new Vsop87.LnVsop(2.86E-8, 2.34237875942, 181.0557665236), new Vsop87.LnVsop(3.18E-8, 4.22909289398, 337.732510659), new Vsop87.LnVsop(2.899E-8, 5.12520635604, 312.4597163935), new Vsop87.LnVsop(2.998E-8, 5.44837420714, 258.8757464767), new Vsop87.LnVsop(3.032E-8, 4.1181812554, 1478.8665740644), new Vsop87.LnVsop(3.013E-8, 1.61330987129, 1073.6090241908), new Vsop87.LnVsop(2.716E-8, 3.14448153596, 358.9301393095), new Vsop87.LnVsop(2.765E-8, 6.16872527649, 273.1028404783), new Vsop87.LnVsop(2.766E-8, 1.01040617017, 1279.794572628), new Vsop87.LnVsop(3.082E-8, 5.60019300569, 216.2198567448), new Vsop87.LnVsop(3.254E-8, 3.92690377039, 85.8272988312), new Vsop87.LnVsop(2.661E-8, 2.3170549735, 565.1156877467), new Vsop87.LnVsop(2.771E-8, 5.77771382441, 160.6088973985), new Vsop87.LnVsop(2.452E-8, 5.3199797483, 444.7574381407), new Vsop87.LnVsop(2.41E-8, 0.00880493603, 195.8906076987), new Vsop87.LnVsop(2.81E-8, 1.68907631956, 213.3472795478), new Vsop87.LnVsop(2.811E-8, 4.77447520427, 213.2509113282), new Vsop87.LnVsop(2.434E-8, 4.76729826936, 218.7157214094), new Vsop87.LnVsop(3.133E-8, 2.493198911, 6069.7767545534), new Vsop87.LnVsop(2.884E-8, 0.32368080181, 561.1835344836), new Vsop87.LnVsop(2.784E-8, 4.1994248541, 650.9429865779), new Vsop87.LnVsop(2.554E-8, 5.043725881, 1169.5882514086), new Vsop87.LnVsop(2.981E-8, 3.91292350334, 9999.986450773), new Vsop87.LnVsop(2.631E-8, 1.12699455399, 344.7030453079), new Vsop87.LnVsop(2.678E-8, 5.09176744531, 824.7421937488), new Vsop87.LnVsop(2.679E-8, 1.6897140187, 208.633228992), new Vsop87.LnVsop(2.648E-8, 2.94415462727, 643.0786800517), new Vsop87.LnVsop(2.12E-8, 2.31088616664, 2627.1141844706), new Vsop87.LnVsop(2.118E-8, 3.28098774331, 320.3240229197), new Vsop87.LnVsop(2.226E-8, 4.08089457879, 131.5469622218), new Vsop87.LnVsop(2.553E-8, 3.43332044217, 6275.9623029906), new Vsop87.LnVsop(2.67E-8, 3.55722356494, 2420.9286360334), new Vsop87.LnVsop(2.005E-8, 2.02382593901, 144.1465711632), new Vsop87.LnVsop(2.124E-8, 1.61210282593, 218.9281697305), new Vsop87.LnVsop(2.444E-8, 2.95506585634, 2214.7430875962), new Vsop87.LnVsop(1.995E-8, 3.54870355383, 22.0914005278), new Vsop87.LnVsop(1.938E-8, 4.22895382496, 546.956440482), new Vsop87.LnVsop(2.152E-8, 3.95372746872, 1795.258443721), new Vsop87.LnVsop(1.909E-8, 0.85189037198, 121.2520214833), new Vsop87.LnVsop(1.925E-8, 2.91107035422, 636.7158925763), new Vsop87.LnVsop(2.195E-8, 3.74800214181, 436.8931316145), new Vsop87.LnVsop(1.872E-8, 4.66994466499, 188.0263011725), new Vsop87.LnVsop(2.061E-8, 2.87712309214, 2310.722314814), new Vsop87.LnVsop(2.208E-8, 4.83492066978, 1141.1340634054), new Vsop87.LnVsop(2.135E-8, 3.00526791204, 2317.8358618148), new Vsop87.LnVsop(1.816E-8, 2.8017551192, 291.262087743), new Vsop87.LnVsop(1.897E-8, 1.68036754832, 350.3321196004), new Vsop87.LnVsop(2.279E-8, 5.43456146966, 207.8824694666), new Vsop87.LnVsop(1.769E-8, 3.54746039561, 329.7251917809), new Vsop87.LnVsop(1.759E-8, 1.64172549261, 424.1505103212), new Vsop87.LnVsop(1.848E-8, 2.24194286719, 168.0525127994), new Vsop87.LnVsop(1.779E-8, 1.36026967744, 212.3358875915), new Vsop87.LnVsop(2.106E-8, 4.22304768571, 2221.856634597), new Vsop87.LnVsop(1.711E-8, 1.92063117332, 129.9194771616), new Vsop87.LnVsop(2.223E-8, 5.23762818237, 99.1606209555), new Vsop87.LnVsop(1.781E-8, 3.29852655586, 1670.8250285), new Vsop87.LnVsop(1.766E-8, 3.55341010945, 1354.4331588434), new Vsop87.LnVsop(2.051E-8, 3.73308531316, 2097.423219376), new Vsop87.LnVsop(1.691E-8, 5.10160176441, 214.2623032845), new Vsop87.LnVsop(1.757E-8, 4.60923293699, 182.279606801), new Vsop87.LnVsop(1.733E-8, 5.28757672531, 45.5766510387), new Vsop87.LnVsop(1.977E-8, 4.85653036081, 10206.1719992102), new Vsop87.LnVsop(1.567E-8, 4.47742703992, 210.3783341312), new Vsop87.LnVsop(1.551E-8, 2.15558953807, 207.6700211455), new Vsop87.LnVsop(1.779E-8, 3.4039983467, 2428.0421830342), new Vsop87.LnVsop(1.541E-8, 6.0937477836, 554.0699874828), new Vsop87.LnVsop(1.821E-8, 4.15498729351, 225.8292684102), new Vsop87.LnVsop(1.483E-8, 1.31282416766, 219.4494345923), new Vsop87.LnVsop(1.456E-8, 5.90544857131, 1.4844727083), new Vsop87.LnVsop(1.56E-8, 1.01224093587, 235.3904959658), new Vsop87.LnVsop(1.753E-8, 0.10174553335, 12.5301729722), new Vsop87.LnVsop(1.461E-8, 2.45326772796, 305.3461693927), new Vsop87.LnVsop(1.542E-8, 5.51223038941, 204.7010757289), new Vsop87.LnVsop(1.723E-8, 5.94689036034, 196.6243208816), new Vsop87.LnVsop(1.508E-8, 0.72241135463, 429.0458714308), new Vsop87.LnVsop(1.581E-8, 2.64780225512, 207.1487562837), new Vsop87.LnVsop(1.476E-8, 6.12782257368, 212.7778305762), new Vsop87.LnVsop(1.548E-8, 0.53240818911, 120.358249606), new Vsop87.LnVsop(1.474E-8, 0.33626790634, 213.8203602998), new Vsop87.LnVsop(1.37E-8, 5.51600816906, 92.7978334801), new Vsop87.LnVsop(1.428E-8, 3.25039966249, 945.9942152321), new Vsop87.LnVsop(1.444E-8, 5.69264187185, 1485.9801210652), new Vsop87.LnVsop(1.329E-8, 1.9796728209, 198.321241911), new Vsop87.LnVsop(1.752E-8, 2.70090942746, 12.7426212933), new Vsop87.LnVsop(1.317E-8, 1.73769800248, 1382.8873468466), new Vsop87.LnVsop(1.434E-8, 4.37660077473, 5863.5912061162), new Vsop87.LnVsop(1.408E-8, 0.80461100746, 1585.1407420207), new Vsop87.LnVsop(1.271E-8, 5.70165238307, 2.9207613068), new Vsop87.LnVsop(1.313E-8, 5.57979182873, 128.3655684841), new Vsop87.LnVsop(1.25E-8, 0.35839694485, 334.5511169213), new Vsop87.LnVsop(1.337E-8, 3.27439246509, 193.655375465), new Vsop87.LnVsop(1.298E-8, 6.18760666624, 526.5095713569), new Vsop87.LnVsop(1.319E-8, 5.67233796212, 298.2326223919), new Vsop87.LnVsop(1.346E-8, 5.79997037285, 9793.8009023358), new Vsop87.LnVsop(1.402E-8, 3.16235877831, 175.1660598002), new Vsop87.LnVsop(1.202E-8, 2.88792018909, 2413.8150890326), new Vsop87.LnVsop(1.562E-8, 5.00012041556, 2008.557539159), new Vsop87.LnVsop(1.354E-8, 0.94866727482, 217.491881132), new Vsop87.LnVsop(1.292E-8, 5.13478886171, 1162.4747044078), new Vsop87.LnVsop(1.197E-8, 1.74106457854, 2207.6295405954), new Vsop87.LnVsop(1.281E-8, 0.47848987165, 525.4981794006), new Vsop87.LnVsop(1.244E-8, 5.99520374248, 28.4541880032), new Vsop87.LnVsop(1.148E-8, 2.17212855226, 1055.4497769261), new Vsop87.LnVsop(1.282E-8, 6.12823934151, 1802.3719907218), new Vsop87.LnVsop(1.304E-8, 0.3733792328, 3473.1970192218), new Vsop87.LnVsop(1.215E-8, 3.87917402622, 209.106309744), new Vsop87.LnVsop(1.117E-8, 3.33328660827, 661.2379273164), new Vsop87.LnVsop(1.367E-8, 1.00973749169, 621.7380390493), new Vsop87.LnVsop(1.395E-8, 3.82109633863, 2111.6503133776), new Vsop87.LnVsop(1.279E-8, 2.87401595453, 142.4496501338), new Vsop87.LnVsop(1.081E-8, 4.11745082549, 156.6767441354), new Vsop87.LnVsop(1.094E-8, 0.95082594069, 842.1506814881), new Vsop87.LnVsop(1.295E-8, 4.70261675421, 9786.687355335), new Vsop87.LnVsop(1.238E-8, 0.48462207051, 3906.9087570986), new Vsop87.LnVsop(1.011E-8, 2.158067736, 251.4321310758), new Vsop87.LnVsop(1.276E-8, 4.48356586181, 732.6951197941), new Vsop87.LnVsop(1.316E-8, 4.72331667671, 398.1440028728), new Vsop87.LnVsop(9.8E-9, 1.88269080686, 501.3797894433), new Vsop87.LnVsop(9.62E-9, 5.92160366799, 519.3960243561), new Vsop87.LnVsop(1.182E-8, 3.69482624364, 2854.6403739102), new Vsop87.LnVsop(9.45E-9, 4.87513739959, 241.7532834412), new Vsop87.LnVsop(9.7E-9, 2.89031410383, 1987.2168981566), new Vsop87.LnVsop(1.194E-8, 3.26293060096, 5856.4776591154), new Vsop87.LnVsop(9.36E-9, 5.49997099924, 739.0579072695), new Vsop87.LnVsop(1.129E-8, 5.17087619935, 98.8999885246), new Vsop87.LnVsop(1.024E-8, 5.62644279982, 479.2883889155), new Vsop87.LnVsop(1.129E-8, 5.48559615849, 3995.7744373156), new Vsop87.LnVsop(9.78E-9, 5.31362529668, 114.1384744825), new Vsop87.LnVsop(1.167E-8, 2.19961653985, 1699.2792165032), new Vsop87.LnVsop(8.64E-9, 0.25714937203, 436.1594184316), new Vsop87.LnVsop(1.062E-8, 5.13323858077, 2751.5475996916), new Vsop87.LnVsop(9.47E-9, 4.98276726039, 699.7010313543), new Vsop87.LnVsop(8.86E-9, 3.03398159069, 306.0969289181), new Vsop87.LnVsop(9.16E-9, 4.99280834008, 4209.0735327536), new Vsop87.LnVsop(1.048E-8, 0.86254115639, 525.7588118315), new Vsop87.LnVsop(8.94E-9, 2.41362473223, 289.5651667136), new Vsop87.LnVsop(8.0E-9, 1.26419353964, 710.7467316182), new Vsop87.LnVsop(7.91E-9, 2.14989417962, 2620.0006374698), new Vsop87.LnVsop(7.95E-9, 2.09247626825, 563.6312150384), new Vsop87.LnVsop(7.87E-9, 5.25336286912, 214.7835681463), new Vsop87.LnVsop(7.83E-9, 1.29408648806, 685.4739373527), new Vsop87.LnVsop(1.06E-8, 1.56954240117, 5849.3641121146), new Vsop87.LnVsop(7.84E-9, 5.3041896283, 327.4375699205), new Vsop87.LnVsop(7.64E-9, 4.56705124334, 380.12776796), new Vsop87.LnVsop(8.11E-9, 6.20098147255, 245.5424243524), new Vsop87.LnVsop(8.57E-9, 1.78247179649, 135.336103133), new Vsop87.LnVsop(8.01E-9, 1.863831191, 3039.485281345), new Vsop87.LnVsop(8.01E-9, 0.46947170994, 3466.083472221), new Vsop87.LnVsop(9.68E-9, 3.02618272726, 2634.2277314714), new Vsop87.LnVsop(8.14E-9, 1.96028453251, 417.0369633204), new Vsop87.LnVsop(8.1E-9, 4.1354009543, 831.1049812242), new Vsop87.LnVsop(7.39E-9, 2.27110740297, 2303.6087678132), new Vsop87.LnVsop(7.47E-9, 0.2924506326, 916.9322800554), new Vsop87.LnVsop(8.89E-9, 4.44997608522, 230.7075831773), new Vsop87.LnVsop(7.26E-9, 2.54556193643, 576.1613880106), new Vsop87.LnVsop(9.82E-9, 1.94714680471, 229.9738699944), new Vsop87.LnVsop(7.28E-9, 1.11567846944, 540.7366653585), new Vsop87.LnVsop(7.28E-9, 1.30997967935, 511.5317178299), new Vsop87.LnVsop(7.11E-9, 4.55074874644, 980.6681783588), new Vsop87.LnVsop(7.16E-9, 3.74192651696, 3053.7123753466), new Vsop87.LnVsop(7.69E-9, 3.34498423969, 953.1077622329), new Vsop87.LnVsop(9.2E-9, 3.83992182117, 348.635198571), new Vsop87.LnVsop(7.89E-9, 3.15830383443, 739.8086667949), new Vsop87.LnVsop(8.96E-9, 4.82222996928, 4216.1870797544), new Vsop87.LnVsop(7.12E-9, 0.43380103197, 1493.093668066), new Vsop87.LnVsop(8.4E-9, 4.85251148183, 326.6868103951), new Vsop87.LnVsop(7.24E-9, 0.757901174, 486.4019359163), new Vsop87.LnVsop(7.9E-9, 0.48073040004, 4017.115078318), new Vsop87.LnVsop(8.31E-9, 3.48853527081, 84.9335269539), new Vsop87.LnVsop(7.45E-9, 6.22304530635, 1269.4996318895), new Vsop87.LnVsop(6.79E-9, 0.78943373396, 273.8536000037), new Vsop87.LnVsop(9.32E-9, 5.20456188216, 849.2642284889)};
        private static final Vsop87.LnVsop[] saturn_radius_r3 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(2.0315239E-4, 3.02186068237, 213.299095438), new Vsop87.LnVsop(8.923679E-5, 3.19144467228, 220.4126424388), new Vsop87.LnVsop(6.908768E-5, 4.35175288182, 206.1855484372), new Vsop87.LnVsop(4.087056E-5, 4.22398596149, 7.1135470008), new Vsop87.LnVsop(3.878848E-5, 2.01051759517, 426.598190876), new Vsop87.LnVsop(1.070754E-5, 4.20372656114, 199.0720014364), new Vsop87.LnVsop(9.07379E-6, 2.28356519128, 433.7117378768), new Vsop87.LnVsop(6.05936E-6, 3.17456913264, 227.5261894396), new Vsop87.LnVsop(5.96411E-6, 4.13395467306, 14.2270940016), new Vsop87.LnVsop(4.83108E-6, 1.17313249713, 639.897286314), new Vsop87.LnVsop(3.93213E-6, 0.0, 0.0), new Vsop87.LnVsop(2.29396E-6, 4.69783424016, 419.4846438752), new Vsop87.LnVsop(1.87917E-6, 4.5908926492, 110.2063212194), new Vsop87.LnVsop(1.49326E-6, 3.20334759568, 103.0927742186), new Vsop87.LnVsop(1.21613E-6, 3.76751430846, 323.5054166574), new Vsop87.LnVsop(1.013E-6, 5.81716272185, 412.3710968744), new Vsop87.LnVsop(1.0203E-6, 4.70997918436, 95.9792272178), new Vsop87.LnVsop(9.2737E-7, 1.43601934858, 647.0108333148), new Vsop87.LnVsop(7.2411E-7, 4.15100432048, 117.3198682202), new Vsop87.LnVsop(8.4197E-7, 2.63457296718, 216.4804891757), new Vsop87.LnVsop(6.1913E-7, 2.31131212952, 440.8252848776), new Vsop87.LnVsop(4.522E-7, 4.37634609863, 191.9584544356), new Vsop87.LnVsop(4.9426E-7, 2.38844043734, 209.3669421749), new Vsop87.LnVsop(5.4819E-7, 0.30627159494, 853.196381752), new Vsop87.LnVsop(4.0466E-7, 1.83906916098, 302.164775655), new Vsop87.LnVsop(3.8104E-7, 5.93442433914, 88.865680217), new Vsop87.LnVsop(3.2001E-7, 4.01244131364, 21.3406410024), new Vsop87.LnVsop(4.0737E-7, 0.68516563011, 522.5774180938), new Vsop87.LnVsop(2.8116E-7, 5.7651243739, 210.1177017003), new Vsop87.LnVsop(2.4831E-7, 3.06280485014, 234.6397364404), new Vsop87.LnVsop(2.5254E-7, 0.7396536674, 515.463871093), new Vsop87.LnVsop(2.0713E-7, 4.9263934342, 625.6701923124), new Vsop87.LnVsop(1.7714E-7, 5.72683468372, 728.762966531), new Vsop87.LnVsop(1.8131E-7, 1.43975542803, 309.2783226558), new Vsop87.LnVsop(1.6495E-7, 3.52692613051, 3.1813937377), new Vsop87.LnVsop(1.2918E-7, 3.3668492051, 330.6189636582), new Vsop87.LnVsop(1.1094E-7, 3.37261850494, 224.3447957019), new Vsop87.LnVsop(1.0869E-7, 3.43386860676, 956.2891559706), new Vsop87.LnVsop(1.0016E-7, 1.59530701443, 202.2533951741), new Vsop87.LnVsop(1.1527E-7, 5.96454139918, 735.8765135318), new Vsop87.LnVsop(1.0427E-7, 6.07038986657, 405.2575498736), new Vsop87.LnVsop(9.198E-8, 2.93495179548, 124.433415221), new Vsop87.LnVsop(8.733E-8, 4.65644352017, 632.7837393132), new Vsop87.LnVsop(9.909E-8, 0.58906585168, 860.3099287528), new Vsop87.LnVsop(7.397E-8, 4.53722615699, 942.062061969), new Vsop87.LnVsop(9.877E-8, 0.25973572185, 838.9692877504), new Vsop87.LnVsop(9.223E-8, 2.57680550459, 223.5940361765), new Vsop87.LnVsop(7.483E-8, 1.4654223471, 654.1243803156), new Vsop87.LnVsop(8.102E-8, 1.77706845061, 429.7795846137), new Vsop87.LnVsop(7.173E-8, 5.49665397606, 1045.1548361876), new Vsop87.LnVsop(6.882E-8, 1.47851183871, 422.6660376129), new Vsop87.LnVsop(7.832E-8, 0.44349627838, 831.8557407496), new Vsop87.LnVsop(8.107E-8, 4.50187795175, 742.9900605326), new Vsop87.LnVsop(6.92E-8, 4.81164954413, 316.3918696566), new Vsop87.LnVsop(8.075E-8, 4.21886190434, 195.1398481733), new Vsop87.LnVsop(5.803E-8, 2.3541937285, 269.9214467406), new Vsop87.LnVsop(5.616E-8, 1.20479876549, 284.1485407422), new Vsop87.LnVsop(5.782E-8, 4.19740457842, 529.6909650946), new Vsop87.LnVsop(4.92E-8, 2.16694660987, 295.0512286542), new Vsop87.LnVsop(5.415E-8, 2.4712399192, 536.8045120954), new Vsop87.LnVsop(5.965E-8, 6.060771835, 1066.49547719), new Vsop87.LnVsop(5.49E-8, 0.8459759962, 217.2312487011), new Vsop87.LnVsop(5.849E-8, 3.40892096038, 10.2949407385), new Vsop87.LnVsop(4.178E-8, 3.22951777344, 1272.6810256272), new Vsop87.LnVsop(4.391E-8, 0.88818379722, 203.0041546995), new Vsop87.LnVsop(3.566E-8, 6.23461945528, 81.7521332162), new Vsop87.LnVsop(4.005E-8, 0.12257495486, 1155.361157407), new Vsop87.LnVsop(3.099E-8, 4.35795864442, 1258.4539316256), new Vsop87.LnVsop(3.394E-8, 0.86274027413, 508.3503240922), new Vsop87.LnVsop(3.447E-8, 0.20752334492, 1148.2476104062), new Vsop87.LnVsop(3.642E-8, 5.97995786501, 1052.2683831884), new Vsop87.LnVsop(3.059E-8, 4.96923422399, 1677.9385755008), new Vsop87.LnVsop(2.893E-8, 1.90456088258, 149.5631971346), new Vsop87.LnVsop(2.74E-8, 5.7005388801, 3.9321532631), new Vsop87.LnVsop(3.014E-8, 5.36409568893, 1361.5467058442), new Vsop87.LnVsop(2.608E-8, 2.99591016813, 1589.0728952838), new Vsop87.LnVsop(2.464E-8, 2.25182696243, 447.9388318784), new Vsop87.LnVsop(2.295E-8, 3.77182395165, 408.4389436113), new Vsop87.LnVsop(2.449E-8, 5.87771646576, 721.6494195302), new Vsop87.LnVsop(2.441E-8, 3.18918907436, 319.5732633943), new Vsop87.LnVsop(1.967E-8, 1.29771144286, 184.8449074348), new Vsop87.LnVsop(2.51E-8, 4.26899907719, 1059.3819301892), new Vsop87.LnVsop(2.337E-8, 5.73749856685, 313.2104759189), new Vsop87.LnVsop(2.438E-8, 2.20340625323, 543.9180590962), new Vsop87.LnVsop(1.967E-8, 5.54991356049, 1038.0412891868), new Vsop87.LnVsop(2.159E-8, 6.13002461326, 1464.6394800628), new Vsop87.LnVsop(2.033E-8, 6.2340937498, 1471.7530270636), new Vsop87.LnVsop(1.679E-8, 0.53404387418, 635.9651330509), new Vsop87.LnVsop(1.667E-8, 2.31776149711, 337.732510659), new Vsop87.LnVsop(1.743E-8, 4.57646237847, 1994.3304451574), new Vsop87.LnVsop(1.913E-8, 5.17436386408, 2854.6403739102), new Vsop87.LnVsop(1.612E-8, 0.53564663022, 416.3032501375), new Vsop87.LnVsop(1.66E-8, 5.71352144007, 11.0457002639), new Vsop87.LnVsop(2.034E-8, 1.58251242401, 750.1036075334), new Vsop87.LnVsop(1.577E-8, 0.55789908488, 2324.9494088156), new Vsop87.LnVsop(1.659E-8, 2.57526072926, 2090.3096723752), new Vsop87.LnVsop(1.483E-8, 0.0210563348, 490.3340891794), new Vsop87.LnVsop(1.424E-8, 0.96656932678, 415.5524906121), new Vsop87.LnVsop(1.677E-8, 5.9335568145, 1781.0313497194), new Vsop87.LnVsop(1.632E-8, 2.35226638604, 131.5469622218), new Vsop87.LnVsop(1.402E-8, 0.60008117843, 210.8514148832), new Vsop87.LnVsop(1.677E-8, 6.13301097969, 1073.6090241908), new Vsop87.LnVsop(1.478E-8, 3.89120179199, 1251.3403846248), new Vsop87.LnVsop(1.773E-8, 0.03977695852, 423.4167971383), new Vsop87.LnVsop(1.442E-8, 5.32547705924, 2538.2485042536), new Vsop87.LnVsop(1.49E-8, 5.26389041723, 1354.4331588434), new Vsop87.LnVsop(1.61E-8, 3.02368875538, 437.6438911399), new Vsop87.LnVsop(1.462E-8, 3.28599831588, 1884.124123938), new Vsop87.LnVsop(1.346E-8, 5.09589748079, 25.2727942655), new Vsop87.LnVsop(1.48E-8, 0.47735175322, 824.7421937488), new Vsop87.LnVsop(1.312E-8, 3.79347668996, 1567.7322542814), new Vsop87.LnVsop(1.335E-8, 1.74107324653, 195.8906076987), new Vsop87.LnVsop(1.329E-8, 3.20676992162, 2207.6295405954), new Vsop87.LnVsop(1.252E-8, 4.12592480127, 1574.8458012822), new Vsop87.LnVsop(1.526E-8, 1.83391016543, 436.8931316145), new Vsop87.LnVsop(1.204E-8, 5.83523069063, 215.7467759928), new Vsop87.LnVsop(1.431E-8, 2.26632806642, 2420.9286360334), new Vsop87.LnVsop(1.202E-8, 0.89248153731, 127.4717966068), new Vsop87.LnVsop(1.403E-8, 1.02096357086, 643.0786800517), new Vsop87.LnVsop(1.176E-8, 3.91611015213, 1891.2376709388), new Vsop87.LnVsop(1.137E-8, 0.35727698514, 497.4476361802), new Vsop87.LnVsop(1.117E-8, 6.17430918265, 63.7358983034), new Vsop87.LnVsop(1.138E-8, 0.82455844655, 867.4234757536), new Vsop87.LnVsop(1.145E-8, 3.10797488346, 2200.5159935946), new Vsop87.LnVsop(1.082E-8, 3.7258944551, 131.4039498699), new Vsop87.LnVsop(1.387E-8, 1.42954726378, 2634.2277314714), new Vsop87.LnVsop(1.311E-8, 1.45489259116, 430.5303441391), new Vsop87.LnVsop(1.003E-8, 1.81530935794, 618.5566453116), new Vsop87.LnVsop(1.219E-8, 5.39420447728, 1279.794572628), new Vsop87.LnVsop(1.342E-8, 5.63184874016, 1382.8873468466), new Vsop87.LnVsop(9.43E-9, 2.27529460454, 1478.8665740644), new Vsop87.LnVsop(1.034E-8, 4.7209593611, 1987.2168981566), new Vsop87.LnVsop(9.1E-9, 4.75468748593, 113.3877149571), new Vsop87.LnVsop(9.01E-9, 5.71833080761, 265.9892934775), new Vsop87.LnVsop(1.017E-8, 3.79640287208, 1375.7737998458), new Vsop87.LnVsop(8.87E-9, 2.86363894581, 934.9485149682), new Vsop87.LnVsop(9.14E-9, 3.03946255874, 241.7532834412), new Vsop87.LnVsop(8.79E-9, 2.65659265685, 145.6310438715), new Vsop87.LnVsop(1.082E-8, 4.48298283322, 2214.7430875962), new Vsop87.LnVsop(9.68E-9, 4.18488402192, 231.4583427027), new Vsop87.LnVsop(8.88E-9, 5.98816755324, 2524.021410252), new Vsop87.LnVsop(8.09E-9, 2.89742868175, 2008.557539159), new Vsop87.LnVsop(8.72E-9, 5.9569965423, 1368.660252845), new Vsop87.LnVsop(8.14E-9, 6.26605263515, 2015.6710861598), new Vsop87.LnVsop(9.9E-9, 5.32604038017, 2428.0421830342), new Vsop87.LnVsop(7.95E-9, 2.3817813581, 2228.9701815978), new Vsop87.LnVsop(7.65E-9, 4.7003367494, 1670.8250285), new Vsop87.LnVsop(7.19E-9, 3.14082277075, 56.6223513026), new Vsop87.LnVsop(7.25E-9, 5.87999254075, 1685.0521225016), new Vsop87.LnVsop(7.72E-9, 1.15596098579, 3053.7123753466), new Vsop87.LnVsop(9.44E-9, 4.19194509927, 1802.3719907218), new Vsop87.LnVsop(8.23E-9, 0.15294957676, 1141.1340634054), new Vsop87.LnVsop(7.38E-9, 4.90593328066, 1485.9801210652), new Vsop87.LnVsop(6.85E-9, 1.70083536518, 483.2205421786)};
        private static final Vsop87.LnVsop[] saturn_radius_r4 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.202117E-5, 1.41498340225, 220.4126424388), new Vsop87.LnVsop(7.07794E-6, 1.16151449537, 213.299095438), new Vsop87.LnVsop(5.16224E-6, 6.2404910535, 206.1855484372), new Vsop87.LnVsop(4.26107E-6, 2.46891791825, 7.1135470008), new Vsop87.LnVsop(2.67495E-6, 0.18644716875, 426.598190876), new Vsop87.LnVsop(1.70055E-6, 5.96000580678, 199.0720014364), new Vsop87.LnVsop(1.44813E-6, 1.44265291294, 227.5261894396), new Vsop87.LnVsop(1.50056E-6, 0.47968186381, 433.7117378768), new Vsop87.LnVsop(1.21067E-6, 2.40476128629, 14.2270940016), new Vsop87.LnVsop(4.7503E-7, 5.56874777537, 639.897286314), new Vsop87.LnVsop(1.5651E-7, 2.89076603229, 110.2063212194), new Vsop87.LnVsop(1.6364E-7, 0.53928792415, 440.8252848776), new Vsop87.LnVsop(1.8973E-7, 5.8551475302, 647.0108333148), new Vsop87.LnVsop(1.449E-7, 1.31356947305, 412.3710968744), new Vsop87.LnVsop(1.231E-7, 2.10618416544, 323.5054166574), new Vsop87.LnVsop(1.4688E-7, 0.29685965949, 419.4846438752), new Vsop87.LnVsop(1.0893E-7, 2.45288604864, 117.3198682202), new Vsop87.LnVsop(1.1348E-7, 0.17490312278, 95.9792272178), new Vsop87.LnVsop(9.21E-8, 2.30108004686, 21.3406410024), new Vsop87.LnVsop(9.007E-8, 1.55461797818, 88.865680217), new Vsop87.LnVsop(8.089E-8, 3.62570131736, 302.164775655), new Vsop87.LnVsop(8.668E-8, 0.69662054025, 216.4804891757), new Vsop87.LnVsop(7.794E-8, 4.50477684881, 853.196381752), new Vsop87.LnVsop(8.261E-8, 1.27827363929, 234.6397364404), new Vsop87.LnVsop(9.616E-8, 3.14159265359, 0.0), new Vsop87.LnVsop(4.937E-8, 2.61740899859, 515.463871093), new Vsop87.LnVsop(4.365E-8, 0.05807483283, 191.9584544356), new Vsop87.LnVsop(5.944E-8, 5.17118993601, 103.0927742186), new Vsop87.LnVsop(3.675E-8, 3.26106349552, 210.1177017003), new Vsop87.LnVsop(4.387E-8, 4.98731675488, 860.3099287528), new Vsop87.LnVsop(4.001E-8, 1.58149127982, 330.6189636582), new Vsop87.LnVsop(3.875E-8, 6.01795427919, 654.1243803156), new Vsop87.LnVsop(3.956E-8, 1.58112427915, 405.2575498736), new Vsop87.LnVsop(2.962E-8, 2.67872711614, 522.5774180938), new Vsop87.LnVsop(2.961E-8, 0.73625753769, 209.3669421749), new Vsop87.LnVsop(3.102E-8, 1.28964935689, 728.762966531), new Vsop87.LnVsop(2.266E-8, 3.17206848552, 203.0041546995), new Vsop87.LnVsop(2.16E-8, 1.08089139585, 124.433415221), new Vsop87.LnVsop(2.118E-8, 6.14470291334, 429.7795846137), new Vsop87.LnVsop(2.066E-8, 3.92049451838, 1066.49547719), new Vsop87.LnVsop(2.211E-8, 0.80527848095, 625.6701923124), new Vsop87.LnVsop(2.147E-8, 0.49411458094, 447.9388318784), new Vsop87.LnVsop(1.927E-8, 0.78578237497, 295.0512286542), new Vsop87.LnVsop(1.793E-8, 0.12585846743, 942.062061969), new Vsop87.LnVsop(1.706E-8, 1.43840425376, 224.3447957019), new Vsop87.LnVsop(1.986E-8, 1.95084664432, 831.8557407496), new Vsop87.LnVsop(1.6E-8, 5.41185167676, 824.7421937488), new Vsop87.LnVsop(1.717E-8, 0.83103173636, 223.5940361765), new Vsop87.LnVsop(1.598E-8, 1.93650947414, 529.6909650946), new Vsop87.LnVsop(1.303E-8, 5.54181517607, 316.3918696566), new Vsop87.LnVsop(1.288E-8, 1.91850903205, 956.2891559706), new Vsop87.LnVsop(1.184E-8, 3.02295343322, 184.8449074348), new Vsop87.LnVsop(1.234E-8, 0.93431249316, 721.6494195302), new Vsop87.LnVsop(1.212E-8, 6.13915785712, 422.6660376129), new Vsop87.LnVsop(1.249E-8, 5.97947803636, 195.1398481733), new Vsop87.LnVsop(1.142E-8, 0.96309096169, 536.8045120954), new Vsop87.LnVsop(1.011E-8, 1.14653787675, 838.9692877504), new Vsop87.LnVsop(1.031E-8, 1.15377008428, 1148.2476104062), new Vsop87.LnVsop(1.109E-8, 1.63414938335, 17.4084877393), new Vsop87.LnVsop(1.094E-8, 0.98475168289, 1045.1548361876), new Vsop87.LnVsop(9.85E-9, 3.05768671768, 1574.8458012822), new Vsop87.LnVsop(8.87E-9, 2.52072621499, 508.3503240922), new Vsop87.LnVsop(9.86E-9, 1.63414986297, 735.8765135318), new Vsop87.LnVsop(7.53E-9, 4.90938931967, 56.6223513026), new Vsop87.LnVsop(7.91E-9, 2.74375014558, 423.4167971383)};
        private static final Vsop87.LnVsop[] saturn_radius_r5 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.28668E-6, 5.91279864289, 220.4126424388), new Vsop87.LnVsop(3.2196E-7, 0.69558284384, 7.1135470008), new Vsop87.LnVsop(2.6737E-7, 5.91270395039, 227.5261894396), new Vsop87.LnVsop(1.9837E-7, 0.6739685296, 14.2270940016), new Vsop87.LnVsop(1.9994E-7, 4.95031713518, 433.7117378768), new Vsop87.LnVsop(1.3627E-7, 1.47747814594, 199.0720014364), new Vsop87.LnVsop(1.3706E-7, 4.59824754628, 426.598190876), new Vsop87.LnVsop(1.4068E-7, 2.63892426573, 206.1855484372), new Vsop87.LnVsop(7.324E-8, 4.64667642371, 213.299095438), new Vsop87.LnVsop(4.916E-8, 3.63019930267, 639.897286314), new Vsop87.LnVsop(2.985E-8, 4.64378755577, 191.9584544356), new Vsop87.LnVsop(2.675E-8, 0.51742057647, 323.5054166574), new Vsop87.LnVsop(3.42E-8, 4.91489841099, 440.8252848776), new Vsop87.LnVsop(3.171E-8, 4.10118061147, 647.0108333148), new Vsop87.LnVsop(2.885E-8, 3.24108476164, 419.4846438752), new Vsop87.LnVsop(2.173E-8, 5.39877301813, 302.164775655), new Vsop87.LnVsop(1.873E-8, 3.22101902976, 95.9792272178), new Vsop87.LnVsop(2.055E-8, 3.60842101774, 88.865680217), new Vsop87.LnVsop(1.509E-8, 2.68946095921, 853.196381752), new Vsop87.LnVsop(1.518E-8, 0.89692431439, 515.463871093), new Vsop87.LnVsop(1.737E-8, 0.41793799128, 117.3198682202), new Vsop87.LnVsop(1.64E-8, 0.0, 0.0), new Vsop87.LnVsop(1.285E-8, 5.82563377753, 234.6397364404), new Vsop87.LnVsop(9.83E-9, 5.91256391941, 3.1813937377), new Vsop87.LnVsop(1.054E-8, 0.2077897712, 412.3710968744), new Vsop87.LnVsop(7.19E-9, 5.20973072924, 216.4804891757), new Vsop87.LnVsop(7.06E-9, 2.65805151133, 110.2063212194)};

        Radius() {
        }
    }

    static class Latitude {
        private static final Vsop87.LnVsop[] saturn_latitude_b0 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.04330678039, 3.60284428399, 213.299095438), new Vsop87.LnVsop(0.00240348302, 2.85238489373, 426.598190876), new Vsop87.LnVsop(8.4745939E-4, 0.0, 0.0), new Vsop87.LnVsop(3.0863357E-4, 3.48441504555, 220.4126424388), new Vsop87.LnVsop(3.4116062E-4, 0.57297307557, 206.1855484372), new Vsop87.LnVsop(1.473407E-4, 2.11846596715, 639.897286314), new Vsop87.LnVsop(9.916667E-5, 5.79003188904, 419.4846438752), new Vsop87.LnVsop(6.993564E-5, 4.7360468972, 7.1135470008), new Vsop87.LnVsop(4.807588E-5, 5.43305312061, 316.3918696566), new Vsop87.LnVsop(4.788392E-5, 4.96512926584, 110.2063212194), new Vsop87.LnVsop(3.432125E-5, 2.732557466, 433.7117378768), new Vsop87.LnVsop(1.506129E-5, 6.01304519391, 103.0927742186), new Vsop87.LnVsop(1.060298E-5, 5.6309929646, 529.6909650946), new Vsop87.LnVsop(9.69071E-6, 5.20434966293, 632.7837393132), new Vsop87.LnVsop(9.4205E-6, 1.39646688872, 853.196381752), new Vsop87.LnVsop(7.07645E-6, 3.80302289005, 323.5054166574), new Vsop87.LnVsop(5.52314E-6, 5.13149119536, 202.2533951741), new Vsop87.LnVsop(3.99674E-6, 3.35891409671, 227.5261894396), new Vsop87.LnVsop(3.16063E-6, 1.99716693551, 647.0108333148), new Vsop87.LnVsop(3.1938E-6, 3.62571687438, 209.3669421749), new Vsop87.LnVsop(2.84495E-6, 4.88648507126, 224.3447957019), new Vsop87.LnVsop(3.14224E-6, 0.46510248959, 217.2312487011), new Vsop87.LnVsop(2.36441E-6, 2.13887684631, 11.0457002639), new Vsop87.LnVsop(2.15354E-6, 5.9498256102, 846.0828347512), new Vsop87.LnVsop(2.08523E-6, 2.12003937634, 415.5524906121), new Vsop87.LnVsop(1.78958E-6, 2.95361337281, 63.7358983034), new Vsop87.LnVsop(2.07214E-6, 0.73021353207, 199.0720014364), new Vsop87.LnVsop(1.3914E-6, 1.99821987827, 735.8765135318), new Vsop87.LnVsop(1.34884E-6, 5.24501026174, 742.9900605326), new Vsop87.LnVsop(1.40585E-6, 0.64417933116, 490.3340891794), new Vsop87.LnVsop(1.21669E-6, 3.11537142395, 522.5774180938), new Vsop87.LnVsop(1.3924E-6, 4.59535592976, 14.2270940016), new Vsop87.LnVsop(1.15525E-6, 3.1089202092, 216.4804891757), new Vsop87.LnVsop(1.14218E-6, 0.96262037933, 210.1177017003), new Vsop87.LnVsop(9.6377E-7, 4.48164269503, 117.3198682202), new Vsop87.LnVsop(8.0594E-7, 1.31693242934, 277.0349937414), new Vsop87.LnVsop(7.2953E-7, 3.05987977572, 536.8045120954), new Vsop87.LnVsop(6.9261E-7, 4.92378376874, 309.2783226558), new Vsop87.LnVsop(7.4302E-7, 2.89377583784, 149.5631971346), new Vsop87.LnVsop(6.8041E-7, 2.1800128871, 351.8165923087), new Vsop87.LnVsop(6.1733E-7, 0.67727575242, 1066.49547719), new Vsop87.LnVsop(5.6598E-7, 2.6096247711, 440.8252848776), new Vsop87.LnVsop(4.8864E-7, 5.78725829726, 95.9792272178), new Vsop87.LnVsop(4.8242E-7, 2.18211814462, 74.7815985673), new Vsop87.LnVsop(3.8304E-7, 5.29151507162, 1059.3819301892), new Vsop87.LnVsop(3.6322E-7, 1.63347180455, 628.8515860501), new Vsop87.LnVsop(3.5055E-7, 1.71278162034, 1052.2683831884), new Vsop87.LnVsop(3.427E-7, 2.45739879861, 422.6660376129), new Vsop87.LnVsop(3.4314E-7, 5.97994688275, 412.3710968744), new Vsop87.LnVsop(3.3788E-7, 1.14074435448, 949.1756089698), new Vsop87.LnVsop(3.1633E-7, 4.14722028612, 437.6438911399), new Vsop87.LnVsop(3.6834E-7, 6.27770255515, 1162.4747044078), new Vsop87.LnVsop(2.6984E-7, 1.27148410951, 860.3099287528), new Vsop87.LnVsop(2.3516E-7, 2.74935309134, 838.9692877504), new Vsop87.LnVsop(2.3459E-7, 0.98962524752, 210.8514148832), new Vsop87.LnVsop(2.3599E-7, 4.11386769857, 3.9321532631), new Vsop87.LnVsop(2.3631E-7, 3.0742717866, 215.7467759928), new Vsop87.LnVsop(2.0813E-7, 3.51085178074, 330.6189636582), new Vsop87.LnVsop(1.9509E-7, 2.8186061767, 127.4717966068), new Vsop87.LnVsop(1.7103E-7, 3.89783901305, 214.2623032845), new Vsop87.LnVsop(1.7635E-7, 6.19717997355, 703.6331846174), new Vsop87.LnVsop(1.7824E-7, 2.2852398714, 388.4651552382), new Vsop87.LnVsop(2.0934E-7, 0.14356449654, 430.5303441391), new Vsop87.LnVsop(1.6551E-7, 1.66649361181, 38.1330356378), new Vsop87.LnVsop(1.9099E-7, 2.9770022442, 137.0330241624), new Vsop87.LnVsop(1.5517E-7, 4.547956239, 956.2891559706), new Vsop87.LnVsop(1.7065E-7, 0.16611037368, 212.3358875915), new Vsop87.LnVsop(1.4169E-7, 0.48937272443, 213.3472795478), new Vsop87.LnVsop(1.9027E-7, 6.27326596357, 423.4167971383), new Vsop87.LnVsop(1.3345E-7, 2.37139629634, 429.7795846137), new Vsop87.LnVsop(1.2565E-7, 1.03177371258, 563.6312150384), new Vsop87.LnVsop(1.4173E-7, 3.57477472425, 213.2509113282), new Vsop87.LnVsop(1.1374E-7, 1.45298798816, 1368.660252845), new Vsop87.LnVsop(1.0584E-7, 6.17636945166, 200.7689224658), new Vsop87.LnVsop(1.06E-7, 3.84356693852, 138.5174968707), new Vsop87.LnVsop(1.0263E-7, 2.17427018729, 76.2660712756), new Vsop87.LnVsop(1.0072E-7, 1.33201729128, 565.1156877467), new Vsop87.LnVsop(1.2058E-7, 0.44148218737, 222.8603229936), new Vsop87.LnVsop(1.0368E-7, 1.85281517515, 350.3321196004), new Vsop87.LnVsop(8.706E-8, 2.5814759713, 1155.361157407), new Vsop87.LnVsop(8.47E-8, 1.97888106159, 625.6701923124), new Vsop87.LnVsop(8.518E-8, 4.51648111567, 3.1813937377), new Vsop87.LnVsop(7.439E-8, 4.92600810037, 212.7778305762), new Vsop87.LnVsop(7.409E-8, 2.03508355026, 288.0806940053), new Vsop87.LnVsop(8.137E-8, 3.98505041656, 85.8272988312), new Vsop87.LnVsop(7.985E-8, 2.20797256457, 362.8622925726), new Vsop87.LnVsop(6.611E-8, 6.14943940547, 417.0369633204), new Vsop87.LnVsop(7.753E-8, 6.23664541592, 1478.8665740644), new Vsop87.LnVsop(6.318E-8, 1.87385475668, 654.1243803156), new Vsop87.LnVsop(6.319E-8, 1.17329432448, 1265.5674786264), new Vsop87.LnVsop(5.842E-8, 2.35830893941, 750.1036075334), new Vsop87.LnVsop(5.809E-8, 5.01605720364, 479.2883889155), new Vsop87.LnVsop(8.079E-8, 0.42573508414, 554.0699874828), new Vsop87.LnVsop(6.013E-8, 5.5895670331, 425.1137181677), new Vsop87.LnVsop(7.443E-8, 5.41863022509, 213.8203602998), new Vsop87.LnVsop(7.567E-8, 2.68448652355, 191.2076949102), new Vsop87.LnVsop(7.421E-8, 4.19346867637, 9.5612275556), new Vsop87.LnVsop(5.466E-8, 3.21737975737, 234.6397364404), new Vsop87.LnVsop(5.661E-8, 1.46972995704, 265.9892934775), new Vsop87.LnVsop(5.851E-8, 4.81779259708, 1.4844727083), new Vsop87.LnVsop(5.34E-8, 3.45754460657, 203.7378678824), new Vsop87.LnVsop(4.959E-8, 1.04652918134, 12.5301729722), new Vsop87.LnVsop(4.92E-8, 3.85621572217, 173.9422195228), new Vsop87.LnVsop(4.885E-8, 1.9482292787, 195.1398481733), new Vsop87.LnVsop(5.622E-8, 0.81876912331, 52.6901980395), new Vsop87.LnVsop(5.2E-8, 3.32831141176, 515.463871093), new Vsop87.LnVsop(4.927E-8, 3.81806645978, 225.8292684102), new Vsop87.LnVsop(5.033E-8, 0.10753911773, 252.6559713532), new Vsop87.LnVsop(4.415E-8, 5.45507718301, 408.4389436113), new Vsop87.LnVsop(4.169E-8, 1.21147053668, 1685.0521225016), new Vsop87.LnVsop(4.066E-8, 6.24209791402, 1279.794572628), new Vsop87.LnVsop(3.972E-8, 6.13849757304, 217.491881132), new Vsop87.LnVsop(5.397E-8, 5.67209673575, 1375.7737998458), new Vsop87.LnVsop(3.916E-8, 5.9610396759, 210.3783341312), new Vsop87.LnVsop(4.018E-8, 0.99841407086, 842.1506814881), new Vsop87.LnVsop(3.899E-8, 4.58977109833, 1272.6810256272), new Vsop87.LnVsop(3.764E-8, 3.30656219997, 212.5483359126), new Vsop87.LnVsop(4.345E-8, 3.18572215775, 414.0680179038), new Vsop87.LnVsop(3.565E-8, 4.75263028087, 207.8824694666), new Vsop87.LnVsop(3.542E-8, 2.30824066107, 1471.7530270636), new Vsop87.LnVsop(3.733E-8, 1.6100545316, 635.9651330509), new Vsop87.LnVsop(3.709E-8, 2.9707560403, 223.5940361765), new Vsop87.LnVsop(3.576E-8, 3.83445473719, 483.2205421786), new Vsop87.LnVsop(4.053E-8, 3.72114172268, 942.062061969), new Vsop87.LnVsop(3.756E-8, 0.74980502523, 214.0498549634), new Vsop87.LnVsop(3.162E-8, 3.64544174931, 207.6700211455), new Vsop87.LnVsop(3.149E-8, 2.27652164307, 728.762966531), new Vsop87.LnVsop(3.971E-8, 4.37874031224, 216.2198567448), new Vsop87.LnVsop(3.541E-8, 5.62285095602, 218.7157214094), new Vsop87.LnVsop(2.965E-8, 3.40116954988, 650.9429865779), new Vsop87.LnVsop(3.949E-8, 4.19725654798, 209.106309744), new Vsop87.LnVsop(2.854E-8, 4.81078713241, 231.4583427027), new Vsop87.LnVsop(2.826E-8, 0.86693896405, 217.964961884), new Vsop87.LnVsop(2.97E-8, 5.75170150936, 160.6088973985), new Vsop87.LnVsop(2.725E-8, 0.47979226347, 497.4476361802), new Vsop87.LnVsop(2.787E-8, 4.03141540529, 62.2514255951), new Vsop87.LnVsop(2.605E-8, 5.04158135498, 65.2203710117), new Vsop87.LnVsop(2.652E-8, 0.30600516628, 424.1505103212), new Vsop87.LnVsop(2.544E-8, 2.7649753845, 543.9180590962), new Vsop87.LnVsop(2.486E-8, 5.78393991822, 99.1606209555), new Vsop87.LnVsop(3.209E-8, 0.4285318032, 218.9281697305), new Vsop87.LnVsop(2.509E-8, 2.94706968663, 70.8494453042), new Vsop87.LnVsop(2.308E-8, 0.63864314515, 251.4321310758), new Vsop87.LnVsop(2.87E-8, 4.31953619024, 767.3690829208), new Vsop87.LnVsop(2.232E-8, 0.56925732199, 1073.6090241908), new Vsop87.LnVsop(2.245E-8, 1.69948898267, 488.8496164711), new Vsop87.LnVsop(2.283E-8, 1.55577121099, 601.7642506762), new Vsop87.LnVsop(2.385E-8, 4.44576406679, 21.3406410024), new Vsop87.LnVsop(2.096E-8, 5.77427724778, 88.865680217), new Vsop87.LnVsop(2.363E-8, 3.3578087561, 124.433415221), new Vsop87.LnVsop(2.163E-8, 6.2404341111, 1795.258443721), new Vsop87.LnVsop(2.452E-8, 3.19799065056, 208.633228992), new Vsop87.LnVsop(2.032E-8, 4.87022235349, 327.4375699205), new Vsop87.LnVsop(1.951E-8, 5.56009679471, 18.1592472647), new Vsop87.LnVsop(2.283E-8, 4.22370918126, 22.0914005278), new Vsop87.LnVsop(2.217E-8, 4.614401266, 302.164775655), new Vsop87.LnVsop(1.887E-8, 5.45618090482, 142.4496501338), new Vsop87.LnVsop(2.075E-8, 3.5562080658, 1169.5882514086), new Vsop87.LnVsop(2.069E-8, 2.75791541992, 491.8185618877), new Vsop87.LnVsop(1.811E-8, 5.96559795987, 213.1872208534), new Vsop87.LnVsop(1.813E-8, 1.39785635676, 211.8146227297), new Vsop87.LnVsop(1.842E-8, 1.14981052498, 203.0041546995), new Vsop87.LnVsop(1.854E-8, 1.41375949092, 1581.959348283), new Vsop87.LnVsop(1.697E-8, 3.23600230705, 427.5613987225), new Vsop87.LnVsop(1.737E-8, 5.45931200885, 916.9322800554), new Vsop87.LnVsop(1.714E-8, 6.14712457923, 643.8294395771), new Vsop87.LnVsop(1.948E-8, 5.70782269431, 425.6349830295), new Vsop87.LnVsop(1.771E-8, 3.36168499135, 248.7238180901), new Vsop87.LnVsop(1.612E-8, 0.97888345985, 2001.4439921582), new Vsop87.LnVsop(1.97E-8, 2.59656817371, 429.0458714308), new Vsop87.LnVsop(1.628E-8, 0.73975250664, 177.8743727859), new Vsop87.LnVsop(1.564E-8, 2.04331379709, 1788.1448967202), new Vsop87.LnVsop(1.578E-8, 6.02224841728, 426.6463749858), new Vsop87.LnVsop(1.938E-8, 5.48121921327, 636.7158925763), new Vsop87.LnVsop(1.65E-8, 4.616332701, 621.7380390493), new Vsop87.LnVsop(1.552E-8, 2.55530041483, 692.5874843535), new Vsop87.LnVsop(1.484E-8, 6.17153831218, 56.6223513026), new Vsop87.LnVsop(1.782E-8, 3.26132698511, 175.1660598002), new Vsop87.LnVsop(1.504E-8, 2.59954462117, 228.276948965), new Vsop87.LnVsop(1.559E-8, 0.36279929032, 776.9303104764), new Vsop87.LnVsop(1.799E-8, 3.46401859786, 1258.4539316256), new Vsop87.LnVsop(1.521E-8, 3.75579841603, 213.5115437591), new Vsop87.LnVsop(1.811E-8, 4.37544045833, 213.4109700226), new Vsop87.LnVsop(1.521E-8, 0.30205469499, 213.0866471169), new Vsop87.LnVsop(1.608E-8, 4.6671144475, 269.9214467406), new Vsop87.LnVsop(1.525E-8, 1.4792921045, 198.321241911), new Vsop87.LnVsop(1.408E-8, 1.38479725436, 501.3797894433), new Vsop87.LnVsop(1.328E-8, 0.23744796611, 148.0787244263), new Vsop87.LnVsop(1.306E-8, 2.41189915346, 275.5505210331), new Vsop87.LnVsop(1.578E-8, 2.82446177645, 426.5500067662), new Vsop87.LnVsop(1.203E-8, 1.36914857586, 235.3904959658), new Vsop87.LnVsop(1.295E-8, 5.752025246, 1692.1656695024), new Vsop87.LnVsop(1.296E-8, 3.04111189978, 831.8557407496), new Vsop87.LnVsop(1.283E-8, 1.623856688, 643.0786800517), new Vsop87.LnVsop(1.617E-8, 1.31174745624, 214.7835681463), new Vsop87.LnVsop(1.347E-8, 4.01273175674, 278.5194664497), new Vsop87.LnVsop(1.166E-8, 0.09627606633, 340.7708920448), new Vsop87.LnVsop(1.115E-8, 2.20439351972, 221.3758502853), new Vsop87.LnVsop(1.176E-8, 1.07507979885, 312.1990839626), new Vsop87.LnVsop(1.107E-8, 1.50336763826, 289.5651667136), new Vsop87.LnVsop(1.144E-8, 4.40126055317, 213.5597278689), new Vsop87.LnVsop(1.254E-8, 0.21632674588, 404.5067903482), new Vsop87.LnVsop(1.081E-8, 3.1737226072, 98.8999885246), new Vsop87.LnVsop(1.103E-8, 0.23595226512, 617.8058857862), new Vsop87.LnVsop(1.077E-8, 3.5166419454, 312.4597163935), new Vsop87.LnVsop(1.04E-8, 0.53952129629, 778.4147831847), new Vsop87.LnVsop(1.195E-8, 2.11225017751, 205.2223405907), new Vsop87.LnVsop(1.093E-8, 5.16257298332, 630.3360587584), new Vsop87.LnVsop(1.144E-8, 5.939776663, 213.0384630071), new Vsop87.LnVsop(1.041E-8, 4.79618391843, 106.2741679563), new Vsop87.LnVsop(1.1E-8, 0.02510443195, 219.4494345923), new Vsop87.LnVsop(1.311E-8, 5.93851599975, 436.1594184316), new Vsop87.LnVsop(1.26E-8, 0.72452520369, 355.7487455718), new Vsop87.LnVsop(9.5E-9, 2.00808047619, 1045.1548361876), new Vsop87.LnVsop(1.186E-8, 1.8489557536, 151.0476698429), new Vsop87.LnVsop(9.74E-9, 3.01097260601, 696.5196376166), new Vsop87.LnVsop(9.25E-9, 4.88211292859, 39.3568759152), new Vsop87.LnVsop(9.62E-9, 2.8014993578, 738.7972748386), new Vsop87.LnVsop(1.011E-8, 6.26998804708, 121.2520214833), new Vsop87.LnVsop(9.04E-9, 4.15192741336, 426.0769260142), new Vsop87.LnVsop(9.05E-9, 4.2422929708, 10.2949407385), new Vsop87.LnVsop(8.95E-9, 2.4758759909, 447.9388318784), new Vsop87.LnVsop(1.185E-8, 0.85291199481, 525.4981794006), new Vsop87.LnVsop(8.24E-9, 3.97540449663, 210.5907824523), new Vsop87.LnVsop(8.31E-9, 4.05257243032, 207.1487562837), new Vsop87.LnVsop(9.37E-9, 5.4439499856, 344.7030453079), new Vsop87.LnVsop(8.23E-9, 2.08746321895, 358.9301393095), new Vsop87.LnVsop(9.71E-9, 5.09552461634, 1589.0728952838), new Vsop87.LnVsop(1.037E-8, 1.04137394185, 2.4476805548), new Vsop87.LnVsop(8.16E-9, 0.62164413625, 188.9200730498), new Vsop87.LnVsop(7.99E-9, 3.36371952944, 237.6781178262), new Vsop87.LnVsop(7.55E-9, 5.90949038138, 284.1485407422), new Vsop87.LnVsop(8.7E-9, 1.62752216846, 114.1384744825), new Vsop87.LnVsop(7.34E-9, 6.23533301101, 2111.6503133776), new Vsop87.LnVsop(7.67E-9, 2.73664500903, 627.3671133418), new Vsop87.LnVsop(7.02E-9, 0.72502286437, 10213.285546211), new Vsop87.LnVsop(8.02E-9, 5.84200950846, 905.8865797915), new Vsop87.LnVsop(7.11E-9, 1.78782570541, 2104.5367663768), new Vsop87.LnVsop(6.7E-9, 0.75878091288, 2317.8358618148), new Vsop87.LnVsop(7.21E-9, 4.95644466131, 638.4128136057), new Vsop87.LnVsop(7.96E-9, 4.87618145458, 342.2553647531), new Vsop87.LnVsop(8.35E-9, 3.19493605235, 1574.8458012822), new Vsop87.LnVsop(7.03E-9, 0.35096590748, 220.4608265486), new Vsop87.LnVsop(8.24E-9, 0.08813665925, 216.0074084237), new Vsop87.LnVsop(6.53E-9, 4.1958415589, 247.2393453818), new Vsop87.LnVsop(8.26E-9, 4.66851909771, 427.1194557378), new Vsop87.LnVsop(6.9E-9, 0.41878008133, 5856.4776591154), new Vsop87.LnVsop(6.9E-9, 1.34027763379, 6283.0758499914), new Vsop87.LnVsop(6.9E-9, 0.58291546593, 213.4591541324), new Vsop87.LnVsop(6.39E-9, 1.20313256921, 867.4234757536), new Vsop87.LnVsop(8.3E-9, 1.57245339397, 1898.3512179396), new Vsop87.LnVsop(7.53E-9, 1.5113484038, 576.1613880106), new Vsop87.LnVsop(6.29E-9, 2.8357258742, 420.9691165835), new Vsop87.LnVsop(6.9E-9, 3.48062808501, 213.1390367436), new Vsop87.LnVsop(6.0E-9, 5.22938546212, 212.0270710508), new Vsop87.LnVsop(5.65E-9, 5.28088109001, 423.6774295692), new Vsop87.LnVsop(5.52E-9, 5.83275968368, 84.3428261229), new Vsop87.LnVsop(5.46E-9, 3.56643191798, 1485.9801210652), new Vsop87.LnVsop(6.98E-9, 1.92018887936, 134.5853436076), new Vsop87.LnVsop(6.42E-9, 6.14979274963, 179.3588454942), new Vsop87.LnVsop(6.48E-9, 5.15908137311, 8.0767548473), new Vsop87.LnVsop(5.51E-9, 3.3312672806, 980.6681783588), new Vsop87.LnVsop(5.11E-9, 3.87014193733, 125.9873238985), new Vsop87.LnVsop(5.06E-9, 0.80320571787, 181.0557665236), new Vsop87.LnVsop(5.64E-9, 4.0585523639, 831.1049812242), new Vsop87.LnVsop(6.81E-9, 3.45804381274, 220.364458329), new Vsop87.LnVsop(5.41E-9, 2.39250089139, 421.93232443), new Vsop87.LnVsop(4.99E-9, 3.11511715593, 439.1283638482), new Vsop87.LnVsop(5.17E-9, 2.75421533096, 1148.2476104062), new Vsop87.LnVsop(4.92E-9, 4.47188785467, 558.0021407459), new Vsop87.LnVsop(4.67E-9, 4.18104958104, 444.7574381407), new Vsop87.LnVsop(4.58E-9, 0.60793900778, 206.233732547), new Vsop87.LnVsop(5.42E-9, 3.2877375199, 245.5424243524), new Vsop87.LnVsop(4.76E-9, 5.48498169187, 35.4247226521), new Vsop87.LnVsop(4.73E-9, 2.426247298, 436.8931316145), new Vsop87.LnVsop(4.81E-9, 3.72402124244, 206.1373643274), new Vsop87.LnVsop(4.35E-9, 1.61738373338, 191.9584544356), new Vsop87.LnVsop(4.88E-9, 0.26044630515, 416.3032501375), new Vsop87.LnVsop(4.93E-9, 4.13592086433, 518.6452648307), new Vsop87.LnVsop(5.95E-9, 5.11706007934, 214.5711198252), new Vsop87.LnVsop(4.85E-9, 5.1758293874, 67.6680515665), new Vsop87.LnVsop(4.63E-9, 5.53167637735, 418.5214360287), new Vsop87.LnVsop(4.21E-9, 5.573499651, 430.79097657), new Vsop87.LnVsop(4.46E-9, 6.20659186999, 73.297125859), new Vsop87.LnVsop(4.21E-9, 4.65776470174, 543.0242872189), new Vsop87.LnVsop(4.34E-9, 2.95308692533, 5.4166259714), new Vsop87.LnVsop(4.16E-9, 4.36421141391, 113.3877149571), new Vsop87.LnVsop(4.95E-9, 5.38079175722, 391.1734682239), new Vsop87.LnVsop(5.2E-9, 3.99931649474, 618.5566453116), new Vsop87.LnVsop(4.36E-9, 1.60973242385, 2214.7430875962), new Vsop87.LnVsop(4.29E-9, 3.2691335244, 144.1465711632), new Vsop87.LnVsop(3.98E-9, 2.38271972354, 299.1263942692), new Vsop87.LnVsop(3.99E-9, 0.06286559226, 206.706813299), new Vsop87.LnVsop(3.94E-9, 2.75546648016, 425.8474313506), new Vsop87.LnVsop(5.08E-9, 2.86808537292, 337.732510659), new Vsop87.LnVsop(4.75E-9, 5.68509067131, 320.3240229197), new Vsop87.LnVsop(4.32E-9, 0.68163112404, 116.4260963429), new Vsop87.LnVsop(4.04E-9, 1.84176320262, 9786.687355335), new Vsop87.LnVsop(3.71E-9, 5.83302263848, 2008.557539159), new Vsop87.LnVsop(3.83E-9, 4.24902896165, 387.2413149608), new Vsop87.LnVsop(4.16E-9, 3.81981017953, 429.5189521828), new Vsop87.LnVsop(4.91E-9, 4.18581559869, 219.891377577), new Vsop87.LnVsop(3.52E-9, 1.65614871433, 963.4027029714), new Vsop87.LnVsop(3.53E-9, 5.50247369979, 305.3461693927), new Vsop87.LnVsop(4.31E-9, 4.39270197284, 353.301065017), new Vsop87.LnVsop(3.75E-9, 2.67821771477, 319.5732633943), new Vsop87.LnVsop(3.59E-9, 3.54670795682, 421.1815649046), new Vsop87.LnVsop(3.4E-9, 5.19168674166, 69.1525242748), new Vsop87.LnVsop(3.58E-9, 1.11860953046, 1044.4040766622), new Vsop87.LnVsop(3.35E-9, 1.84390801866, 1361.5467058442), new Vsop87.LnVsop(3.28E-9, 6.07083706546, 710.7467316182), new Vsop87.LnVsop(3.28E-9, 1.48617165814, 2420.9286360334), new Vsop87.LnVsop(3.59E-9, 5.62844033096, 78.7137518304), new Vsop87.LnVsop(4.06E-9, 2.91427166192, 1891.2376709388), new Vsop87.LnVsop(3.98E-9, 2.0890434096, 4.665866446), new Vsop87.LnVsop(3.26E-9, 1.62391387691, 5.6290742925), new Vsop87.LnVsop(4.06E-9, 1.87387964143, 114.3991069134), new Vsop87.LnVsop(3.93E-9, 0.56483175403, 128.9562693151), new Vsop87.LnVsop(3.12E-9, 5.29467337499, 347.8844390456), new Vsop87.LnVsop(3.1E-9, 0.31238727781, 427.3489504014), new Vsop87.LnVsop(3.08E-9, 2.84951154508, 487.3651437628), new Vsop87.LnVsop(2.91E-9, 3.26164407025, 494.2662424425), new Vsop87.LnVsop(3.03E-9, 4.94026133382, 373.9079928365), new Vsop87.LnVsop(2.89E-9, 6.15818236951, 969.6224780949), new Vsop87.LnVsop(2.89E-9, 2.0537143135, 214.5229357154), new Vsop87.LnVsop(2.89E-9, 2.83591185309, 212.0752551606), new Vsop87.LnVsop(3.98E-9, 6.03816982033, 432.2272651685), new Vsop87.LnVsop(2.96E-9, 0.30256895246, 1055.4497769261), new Vsop87.LnVsop(2.81E-9, 5.41563930133, 1493.093668066), new Vsop87.LnVsop(2.79E-9, 1.29758402126, 241.6102710893), new Vsop87.LnVsop(3.16E-9, 6.24175867183, 465.9550667912), new Vsop87.LnVsop(2.74E-9, 5.04030677281, 458.8415197904), new Vsop87.LnVsop(2.96E-9, 3.04457317761, 211.6021744086), new Vsop87.LnVsop(2.74E-9, 2.7269438579, 145.6310438715), new Vsop87.LnVsop(2.93E-9, 1.3251042611, 159.1244246902), new Vsop87.LnVsop(2.62E-9, 6.11909674971, 2428.0421830342), new Vsop87.LnVsop(3.23E-9, 1.17506470507, 815.0633461142), new Vsop87.LnVsop(3.45E-9, 5.37087060064, 428.0826635843), new Vsop87.LnVsop(2.59E-9, 0.43312375237, 2634.2277314714), new Vsop87.LnVsop(2.75E-9, 0.9152312597, 849.2642284889), new Vsop87.LnVsop(3.4E-9, 1.29333224497, 329.7251917809), new Vsop87.LnVsop(2.45E-9, 3.52292725422, 184.9879197867), new Vsop87.LnVsop(2.94E-9, 4.29357944566, 4.192785694), new Vsop87.LnVsop(3.39E-9, 1.03807224042, 32.2433289144), new Vsop87.LnVsop(2.43E-9, 3.12855303383, 525.7588118315), new Vsop87.LnVsop(2.6E-9, 5.99230748755, 20.6069278195), new Vsop87.LnVsop(3.03E-9, 3.96700505482, 934.9485149682), new Vsop87.LnVsop(2.85E-9, 5.69508675378, 220.9339073006), new Vsop87.LnVsop(2.39E-9, 2.09555267955, 292.0128472684), new Vsop87.LnVsop(2.42E-9, 0.987086114, 282.4516197128), new Vsop87.LnVsop(2.78E-9, 2.81623774774, 87.3117715395), new Vsop87.LnVsop(2.36E-9, 5.79564763644, 280.9671470045), new Vsop87.LnVsop(2.85E-9, 4.76191845771, 54.1746707478), new Vsop87.LnVsop(2.46E-9, 1.83689902078, 214.9960164674), new Vsop87.LnVsop(2.38E-9, 3.52746857675, 267.4737661858), new Vsop87.LnVsop(2.21E-9, 0.48491368453, 153.4953503977), new Vsop87.LnVsop(2.93E-9, 5.91443975841, 14.977853527), new Vsop87.LnVsop(2.34E-9, 0.29943001944, 14.0146456805), new Vsop87.LnVsop(2.29E-9, 3.91824487445, 182.279606801), new Vsop87.LnVsop(2.17E-9, 3.96246111595, 894.8408795276), new Vsop87.LnVsop(2.19E-9, 1.46332840761, 2531.1349572528), new Vsop87.LnVsop(2.1E-9, 2.01138855049, 211.8628068395), new Vsop87.LnVsop(2.1E-9, 2.8782376161, 214.7353840365), new Vsop87.LnVsop(2.38E-9, 1.85151589425, 221.1634019642), new Vsop87.LnVsop(2.24E-9, 2.49627363443, 1464.6394800628), new Vsop87.LnVsop(2.09E-9, 2.97668922368, 273.1028404783), new Vsop87.LnVsop(2.17E-9, 4.03157211714, 835.0371344873), new Vsop87.LnVsop(2.1E-9, 2.5687957797, 593.426863398), new Vsop87.LnVsop(2.18E-9, 1.71986486818, 0.9632078465), new Vsop87.LnVsop(1.99E-9, 3.53454927143, 219.6618829134), new Vsop87.LnVsop(1.97E-9, 2.65217451107, 864.2420820159), new Vsop87.LnVsop(2.19E-9, 3.46298090101, 1182.9215735329), new Vsop87.LnVsop(1.99E-9, 2.56032050107, 264.5048207692), new Vsop87.LnVsop(1.98E-9, 2.03496428789, 757.2171545342), new Vsop87.LnVsop(2.37E-9, 5.05389714734, 254.9435932136), new Vsop87.LnVsop(1.91E-9, 2.07085765545, 756.3233826569), new Vsop87.LnVsop(1.93E-9, 1.67672523671, 1677.9385755008), new Vsop87.LnVsop(1.91E-9, 1.0526840235, 702.1487119091), new Vsop87.LnVsop(1.81E-9, 1.89155460161, 6.1503391543), new Vsop87.LnVsop(1.82E-9, 1.25399442586, 2737.32050569), new Vsop87.LnVsop(2.04E-9, 1.9801323872, 199.2844497575), new Vsop87.LnVsop(1.86E-9, 2.8142342857, 569.0478410098), new Vsop87.LnVsop(2.46E-9, 3.55854724228, 1251.3403846248), new Vsop87.LnVsop(2.15E-9, 4.52280780251, 3060.8259223474), new Vsop87.LnVsop(1.91E-9, 4.20339468962, 556.5176680376), new Vsop87.LnVsop(2.16E-9, 2.91269882645, 205.4347889118), new Vsop87.LnVsop(2.17E-9, 2.64444506679, 2207.6295405954), new Vsop87.LnVsop(2.25E-9, 0.1426020607, 131.4039498699), new Vsop87.LnVsop(1.89E-9, 1.26887540631, 192.6921676185), new Vsop87.LnVsop(1.79E-9, 6.15317278899, 2.9207613068), new Vsop87.LnVsop(1.77E-9, 2.01695854061, 705.1176573257), new Vsop87.LnVsop(1.88E-9, 2.9247069068, 227.3137411185), new Vsop87.LnVsop(1.81E-9, 3.6224056206, 233.9060232575), new Vsop87.LnVsop(1.66E-9, 5.85339140145, 637.4496057592), new Vsop87.LnVsop(1.63E-9, 3.50597489635, 1382.8873468466), new Vsop87.LnVsop(1.59E-9, 0.13374057204, 431.264057322), new Vsop87.LnVsop(1.58E-9, 5.92245215131, 96.8729990951), new Vsop87.LnVsop(1.78E-9, 4.55357947656, 46.470422916), new Vsop87.LnVsop(1.57E-9, 1.36083501113, 51.2057253312), new Vsop87.LnVsop(1.55E-9, 6.23981289223, 464.7312265138), new Vsop87.LnVsop(1.55E-9, 6.02665412124, 1286.9081196288), new Vsop87.LnVsop(1.75E-9, 4.95229737861, 1905.4647649404), new Vsop87.LnVsop(1.55E-9, 1.36669731999, 206.9363079626), new Vsop87.LnVsop(1.53E-9, 6.05959444754, 561.1835344836), new Vsop87.LnVsop(2.09E-9, 4.50587176454, 24.3790223882), new Vsop87.LnVsop(1.85E-9, 5.49830792597, 205.6642835754), new Vsop87.LnVsop(1.6E-9, 4.18196878857, 3340.6124266998), new Vsop87.LnVsop(1.6E-9, 2.85370771355, 209.1544938538), new Vsop87.LnVsop(1.61E-9, 4.98116500495, 2648.454825473), new Vsop87.LnVsop(1.52E-9, 0.85402744302, 570.7447620392), new Vsop87.LnVsop(1.56E-9, 2.03601440129, 217.4436970222), new Vsop87.LnVsop(1.99E-9, 3.54516172322, 533.6231183577), new Vsop87.LnVsop(1.92E-9, 3.98017256784, 212.4053235607), new Vsop87.LnVsop(1.92E-9, 0.90945359875, 214.1928673153), new Vsop87.LnVsop(1.6E-9, 2.51655480826, 3127.3133312618), new Vsop87.LnVsop(1.45E-9, 0.93224513634, 1994.3304451574), new Vsop87.LnVsop(1.41E-9, 5.66792977216, 120.358249606), new Vsop87.LnVsop(1.41E-9, 3.89020113314, 454.9093665273), new Vsop87.LnVsop(1.52E-9, 1.01334637716, 2840.4132799086), new Vsop87.LnVsop(1.72E-9, 4.15291117436, 2.9689454166), new Vsop87.LnVsop(1.46E-9, 5.26793940136, 7.065362891), new Vsop87.LnVsop(1.77E-9, 0.43379056817, 140.001969579), new Vsop87.LnVsop(1.44E-9, 3.95680110529, 300.6108669775), new Vsop87.LnVsop(1.52E-9, 4.29519544232, 555.5544601911), new Vsop87.LnVsop(1.43E-9, 4.15384555539, 31.019488637), new Vsop87.LnVsop(1.39E-9, 0.79816062945, 166.828672522), new Vsop87.LnVsop(1.38E-9, 4.20351932278, 731.9443602687), new Vsop87.LnVsop(1.35E-9, 1.27076215169, 92.940845832), new Vsop87.LnVsop(1.65E-9, 1.9523411457, 107.0249274817), new Vsop87.LnVsop(1.53E-9, 3.07459476684, 3480.3105662226), new Vsop87.LnVsop(1.25E-9, 3.41715448905, 1802.3719907218), new Vsop87.LnVsop(1.28E-9, 5.8387191804, 2324.9494088156), new Vsop87.LnVsop(1.29E-9, 2.7600424471, 480.7728616238), new Vsop87.LnVsop(1.22E-9, 4.75255632197, 2854.6403739102), new Vsop87.LnVsop(1.29E-9, 4.677286409, 913.9633346388), new Vsop87.LnVsop(1.46E-9, 3.711202754, 546.956440482), new Vsop87.LnVsop(1.21E-9, 1.1999616383, 572.2292347475), new Vsop87.LnVsop(1.19E-9, 4.58843728974, 339.2864193365), new Vsop87.LnVsop(1.27E-9, 6.19604979468, 59.8037450403), new Vsop87.LnVsop(1.23E-9, 5.98410087513, 477.8039162072), new Vsop87.LnVsop(1.22E-9, 5.83022118428, 990.2294059144), new Vsop87.LnVsop(1.51E-9, 2.39461871323, 2524.021410252), new Vsop87.LnVsop(1.47E-9, 4.98185357367, 850.0149880143), new Vsop87.LnVsop(1.27E-9, 0.47350572564, 6.592282139), new Vsop87.LnVsop(1.16E-9, 4.71520095067, 1130.2313754934), new Vsop87.LnVsop(1.29E-9, 5.42390176195, 2538.2485042536), new Vsop87.LnVsop(1.11E-9, 4.51407828148, 1699.2792165032), new Vsop87.LnVsop(1.12E-9, 4.14868763908, 422.405405182), new Vsop87.LnVsop(1.14E-9, 2.06498377101, 952.0963702766), new Vsop87.LnVsop(1.11E-9, 5.53282324077, 857.1285350151), new Vsop87.LnVsop(1.09E-9, 3.00010064569, 420.4478517217), new Vsop87.LnVsop(1.12E-9, 2.20703498575, 395.578702239), new Vsop87.LnVsop(1.47E-9, 1.52595534648, 552.5855147745), new Vsop87.LnVsop(1.17E-9, 5.47540280598, 2957.7331481288), new Vsop87.LnVsop(1.12E-9, 2.57013750439, 462.0229135281), new Vsop87.LnVsop(1.22E-9, 4.9629746282, 638.9340784675), new Vsop87.LnVsop(1.04E-9, 1.91100566417, 472.1748419147), new Vsop87.LnVsop(1.16E-9, 2.82952794316, 450.9772132642), new Vsop87.LnVsop(1.15E-9, 2.25851835662, 1781.0313497194), new Vsop87.LnVsop(1.1E-9, 4.86686492403, 2914.0142358238), new Vsop87.LnVsop(1.09E-9, 4.43985900785, 405.9912630565), new Vsop87.LnVsop(1.02E-9, 5.90339898565, 99.9113804809), new Vsop87.LnVsop(1.01E-9, 2.53384198507, 640.8604941605), new Vsop87.LnVsop(9.9E-10, 5.92243081537, 411.620337349), new Vsop87.LnVsop(1.12E-9, 5.53973044575, 381.3516082374), new Vsop87.LnVsop(1.0E-9, 5.21941099435, 426.4863162914), new Vsop87.LnVsop(1.37E-9, 2.20274006149, 7.1617311106), new Vsop87.LnVsop(9.8E-10, 1.28529782746, 2847.5268269094), new Vsop87.LnVsop(1.16E-9, 5.23339044745, 1119.1856752295), new Vsop87.LnVsop(9.5E-10, 4.2606427488, 540.7366653585), new Vsop87.LnVsop(9.8E-10, 5.27111748177, 639.9454704238), new Vsop87.LnVsop(1.07E-9, 4.38928414646, 412.5835451955), new Vsop87.LnVsop(9.3E-10, 5.35804852851, 334.5511169213), new Vsop87.LnVsop(9.4E-10, 1.16752767262, 5643.1785636774), new Vsop87.LnVsop(1.06E-9, 4.19024947696, 486.4019359163), new Vsop87.LnVsop(9.6E-10, 0.59550056424, 714.6788848813), new Vsop87.LnVsop(9.4E-10, 0.54288367991, 423.6292454594), new Vsop87.LnVsop(1.1E-9, 2.82868370028, 468.2426886516), new Vsop87.LnVsop(8.3E-10, 6.12463094765, 380.12776796), new Vsop87.LnVsop(8.4E-10, 2.20225020879, 909.8187330546), new Vsop87.LnVsop(1.05E-9, 2.66527620584, 460.5384408198), new Vsop87.LnVsop(8.5E-10, 5.20920130922, 562.1467423301), new Vsop87.LnVsop(8.4E-10, 0.14539857176, 681.5417840896), new Vsop87.LnVsop(8.0E-10, 3.0359315293, 409.9234163196), new Vsop87.LnVsop(9.6E-10, 5.09479638103, 92.0470739547), new Vsop87.LnVsop(1.1E-9, 2.03631813918, 642.3449668688), new Vsop87.LnVsop(8.0E-10, 5.71278977344, 361.3778198643), new Vsop87.LnVsop(8.4E-10, 3.00961145051, 426.8106391971), new Vsop87.LnVsop(8.5E-10, 4.28770375675, 135.5485514541), new Vsop87.LnVsop(9.2E-10, 5.33175140498, 432.0148168474), new Vsop87.LnVsop(8.4E-10, 5.83905303666, 426.3857425549), new Vsop87.LnVsop(8.6E-10, 1.51279442193, 760.25553592), new Vsop87.LnVsop(1.0E-9, 3.62925349282, 426.7100654606), new Vsop87.LnVsop(9.8E-10, 2.07358165085, 639.8491022042), new Vsop87.LnVsop(9.3E-10, 4.3026920082, 3377.217792004), new Vsop87.LnVsop(7.5E-10, 2.89079162661, 806.725958836), new Vsop87.LnVsop(7.2E-10, 4.85280339422, 392.6579409322), new Vsop87.LnVsop(8.0E-10, 4.11844342601, 774.4826299216), new Vsop87.LnVsop(8.0E-10, 0.88340921666, 856.3777754897), new Vsop87.LnVsop(8.3E-10, 0.11455345099, 402.2191684878)};
        private static final Vsop87.LnVsop[] saturn_latitude_b1 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.00198927992, 4.93901017903, 213.299095438), new Vsop87.LnVsop(3.6947916E-4, 3.14159265359, 0.0), new Vsop87.LnVsop(1.7966989E-4, 0.5197943111, 426.598190876), new Vsop87.LnVsop(1.0919721E-4, 1.79463271368, 220.4126424388), new Vsop87.LnVsop(1.3320265E-4, 2.26481519893, 206.1855484372), new Vsop87.LnVsop(3.243428E-5, 1.21094033148, 419.4846438752), new Vsop87.LnVsop(2.900519E-5, 6.17033461979, 639.897286314), new Vsop87.LnVsop(1.584712E-5, 0.9341639713, 433.7117378768), new Vsop87.LnVsop(1.580666E-5, 3.08171717435, 7.1135470008), new Vsop87.LnVsop(7.00659E-6, 0.20545152078, 316.3918696566), new Vsop87.LnVsop(3.10902E-6, 4.38351712708, 110.2063212194), new Vsop87.LnVsop(3.01237E-6, 1.66219956459, 227.5261894396), new Vsop87.LnVsop(3.03761E-6, 5.46322830151, 853.196381752), new Vsop87.LnVsop(2.59878E-6, 3.93026240568, 103.0927742186), new Vsop87.LnVsop(2.52673E-6, 0.9002092521, 632.7837393132), new Vsop87.LnVsop(1.82664E-6, 0.12142438148, 647.0108333148), new Vsop87.LnVsop(1.57532E-6, 2.42607457234, 199.0720014364), new Vsop87.LnVsop(1.08184E-6, 1.39896246207, 529.6909650946), new Vsop87.LnVsop(8.8301E-7, 2.17503185037, 323.5054166574), new Vsop87.LnVsop(8.6875E-7, 2.91365320786, 14.2270940016), new Vsop87.LnVsop(9.3226E-7, 2.4431495804, 217.2312487011), new Vsop87.LnVsop(7.6217E-7, 2.73666477702, 210.1177017003), new Vsop87.LnVsop(6.7406E-7, 1.49053395808, 209.3669421749), new Vsop87.LnVsop(6.9585E-7, 1.31682001912, 216.4804891757), new Vsop87.LnVsop(5.3865E-7, 1.74961587267, 202.2533951741), new Vsop87.LnVsop(4.8657E-7, 0.85586786255, 440.8252848776), new Vsop87.LnVsop(3.8289E-7, 2.90107344056, 117.3198682202), new Vsop87.LnVsop(3.0566E-7, 1.28845522495, 412.3710968744), new Vsop87.LnVsop(2.7841E-7, 4.74764197119, 1066.49547719), new Vsop87.LnVsop(3.2708E-7, 2.2181845052, 224.3447957019), new Vsop87.LnVsop(1.8822E-7, 5.62219514688, 860.3099287528), new Vsop87.LnVsop(1.9503E-7, 0.67017561839, 846.0828347512), new Vsop87.LnVsop(1.6933E-7, 1.19325749663, 536.8045120954), new Vsop87.LnVsop(1.6367E-7, 1.21661206395, 95.9792272178), new Vsop87.LnVsop(1.8612E-7, 1.22520531243, 309.2783226558), new Vsop87.LnVsop(1.3682E-7, 4.73321416332, 522.5774180938), new Vsop87.LnVsop(1.5156E-7, 4.6996705248, 11.0457002639), new Vsop87.LnVsop(1.1499E-7, 4.14138196473, 415.5524906121), new Vsop87.LnVsop(1.2837E-7, 2.81845968681, 742.9900605326), new Vsop87.LnVsop(1.3649E-7, 0.41098020093, 422.6660376129), new Vsop87.LnVsop(1.054E-7, 1.81501295981, 330.6189636582), new Vsop87.LnVsop(1.0912E-7, 1.85613282527, 423.4167971383), new Vsop87.LnVsop(9.472E-8, 1.51137573235, 63.7358983034), new Vsop87.LnVsop(8.741E-8, 3.12101135745, 625.6701923124), new Vsop87.LnVsop(9.441E-8, 0.52002672064, 429.7795846137), new Vsop87.LnVsop(8.971E-8, 3.23483186571, 277.0349937414), new Vsop87.LnVsop(7.026E-8, 2.45348926519, 430.5303441391), new Vsop87.LnVsop(7.163E-8, 4.60387223265, 215.7467759928), new Vsop87.LnVsop(6.468E-8, 2.17426030779, 490.3340891794), new Vsop87.LnVsop(6.287E-8, 1.51913918673, 234.6397364404), new Vsop87.LnVsop(6.166E-8, 0.07222081964, 654.1243803156), new Vsop87.LnVsop(6.137E-8, 0.42127140031, 149.5631971346), new Vsop87.LnVsop(7.021E-8, 1.7565001339, 437.6438911399), new Vsop87.LnVsop(5.019E-8, 5.76559473909, 210.8514148832), new Vsop87.LnVsop(4.119E-8, 2.71283218857, 3.1813937377), new Vsop87.LnVsop(3.872E-8, 2.9984970498, 949.1756089698), new Vsop87.LnVsop(3.675E-8, 5.11600747801, 3.9321532631), new Vsop87.LnVsop(3.776E-8, 2.46233837693, 1059.3819301892), new Vsop87.LnVsop(3.317E-8, 4.69110070363, 628.8515860501), new Vsop87.LnVsop(3.682E-8, 1.19319192495, 223.5940361765), new Vsop87.LnVsop(2.68E-8, 3.45355844691, 351.8165923087), new Vsop87.LnVsop(2.571E-8, 3.96363456369, 1162.4747044078), new Vsop87.LnVsop(2.995E-8, 5.02864811906, 515.463871093), new Vsop87.LnVsop(3.293E-8, 2.33138968543, 956.2891559706), new Vsop87.LnVsop(2.415E-8, 2.75650699799, 21.3406410024), new Vsop87.LnVsop(2.425E-8, 4.06403215903, 1279.794572628), new Vsop87.LnVsop(2.265E-8, 5.12930941938, 735.8765135318), new Vsop87.LnVsop(2.062E-8, 2.91053926178, 203.0041546995), new Vsop87.LnVsop(1.99E-8, 5.59520905528, 203.7378678824), new Vsop87.LnVsop(2.031E-8, 0.36328856534, 750.1036075334), new Vsop87.LnVsop(1.928E-8, 0.86086932932, 408.4389436113), new Vsop87.LnVsop(1.903E-8, 1.60746671833, 124.433415221), new Vsop87.LnVsop(1.744E-8, 1.16412193121, 88.865680217), new Vsop87.LnVsop(1.824E-8, 4.86628565112, 1073.6090241908), new Vsop87.LnVsop(2.258E-8, 1.66916684346, 138.5174968707), new Vsop87.LnVsop(1.563E-8, 6.18545235125, 362.8622925726), new Vsop87.LnVsop(1.572E-8, 1.84255832998, 137.0330241624), new Vsop87.LnVsop(1.433E-8, 5.47301146569, 217.964961884), new Vsop87.LnVsop(1.593E-8, 0.97421002648, 543.9180590962), new Vsop87.LnVsop(1.897E-8, 5.87304157924, 635.9651330509), new Vsop87.LnVsop(1.414E-8, 4.02297218519, 728.762966531), new Vsop87.LnVsop(1.386E-8, 2.89672561287, 231.4583427027), new Vsop87.LnVsop(1.41E-8, 0.01654408493, 1052.2683831884), new Vsop87.LnVsop(1.478E-8, 5.55770825875, 483.2205421786), new Vsop87.LnVsop(1.722E-8, 3.44514721962, 838.9692877504), new Vsop87.LnVsop(1.218E-8, 3.76245757391, 1478.8665740644), new Vsop87.LnVsop(1.219E-8, 2.99492994498, 74.7815985673), new Vsop87.LnVsop(1.395E-8, 2.44044866819, 340.7708920448), new Vsop87.LnVsop(1.502E-8, 0.37510741765, 127.4717966068), new Vsop87.LnVsop(1.391E-8, 3.76629584219, 703.6331846174), new Vsop87.LnVsop(1.39E-8, 3.97218003624, 195.1398481733), new Vsop87.LnVsop(1.438E-8, 4.85759262158, 208.633228992), new Vsop87.LnVsop(1.148E-8, 0.73433808719, 447.9388318784), new Vsop87.LnVsop(1.439E-8, 3.72246499569, 350.3321196004), new Vsop87.LnVsop(1.07E-8, 1.49161749546, 218.7157214094), new Vsop87.LnVsop(9.72E-9, 1.32032644773, 210.3783341312), new Vsop87.LnVsop(9.33E-9, 5.03088016698, 497.4476361802), new Vsop87.LnVsop(1.12E-8, 6.03447039073, 191.2076949102), new Vsop87.LnVsop(1.012E-8, 2.4727274472, 200.7689224658), new Vsop87.LnVsop(9.04E-9, 5.29750627971, 207.6700211455), new Vsop87.LnVsop(9.17E-9, 1.38330137048, 636.7158925763), new Vsop87.LnVsop(8.88E-9, 2.70253210128, 554.0699874828), new Vsop87.LnVsop(8.77E-9, 4.73964021792, 424.1505103212), new Vsop87.LnVsop(8.69E-9, 4.30586222071, 222.8603229936), new Vsop87.LnVsop(9.72E-9, 1.21745387645, 650.9429865779), new Vsop87.LnVsop(7.95E-9, 5.25157958165, 214.2623032845), new Vsop87.LnVsop(1.057E-8, 6.01807983373, 643.0786800517), new Vsop87.LnVsop(8.15E-9, 2.85642232089, 191.9584544356), new Vsop87.LnVsop(1.064E-8, 0.66975646323, 85.8272988312), new Vsop87.LnVsop(7.9E-9, 6.10916408265, 265.9892934775), new Vsop87.LnVsop(7.62E-9, 3.00363704123, 38.1330356378), new Vsop87.LnVsop(7.89E-9, 3.01319859815, 1375.7737998458), new Vsop87.LnVsop(8.25E-9, 6.27068316984, 76.2660712756), new Vsop87.LnVsop(7.44E-9, 3.54889644845, 388.4651552382), new Vsop87.LnVsop(7.47E-9, 2.45543129686, 10.2949407385), new Vsop87.LnVsop(7.94E-9, 1.51719014468, 212.3358875915), new Vsop87.LnVsop(8.18E-9, 2.37164551834, 1272.6810256272), new Vsop87.LnVsop(7.06E-9, 3.57651408795, 18.1592472647), new Vsop87.LnVsop(8.02E-9, 1.43897948799, 1169.5882514086), new Vsop87.LnVsop(8.05E-9, 2.38534169381, 207.8824694666), new Vsop87.LnVsop(6.92E-9, 5.66062877642, 867.4234757536), new Vsop87.LnVsop(7.34E-9, 5.3257629333, 565.1156877467), new Vsop87.LnVsop(6.79E-9, 5.84446735833, 288.0806940053), new Vsop87.LnVsop(6.71E-9, 4.72924743617, 842.1506814881), new Vsop87.LnVsop(6.31E-9, 0.75007555324, 142.4496501338), new Vsop87.LnVsop(6.66E-9, 6.00233055509, 1368.660252845), new Vsop87.LnVsop(6.63E-9, 1.84236582113, 213.3472795478), new Vsop87.LnVsop(6.13E-9, 3.17262568619, 1265.5674786264), new Vsop87.LnVsop(5.73E-9, 0.33317816431, 621.7380390493), new Vsop87.LnVsop(6.64E-9, 4.72617875679, 831.8557407496), new Vsop87.LnVsop(6.11E-9, 2.56279664042, 160.6088973985), new Vsop87.LnVsop(5.66E-9, 0.22986063298, 302.164775655), new Vsop87.LnVsop(6.25E-9, 6.10561287765, 209.106309744), new Vsop87.LnVsop(6.75E-9, 0.88783155497, 417.0369633204), new Vsop87.LnVsop(5.5E-9, 4.21628927155, 1155.361157407), new Vsop87.LnVsop(6.61E-9, 0.03876588911, 269.9214467406), new Vsop87.LnVsop(6.27E-9, 5.21555085323, 942.062061969), new Vsop87.LnVsop(6.06E-9, 4.97367692956, 218.9281697305), new Vsop87.LnVsop(6.62E-9, 4.92733502195, 213.2509113282), new Vsop87.LnVsop(4.89E-9, 3.49259680997, 1795.258443721), new Vsop87.LnVsop(5.22E-9, 1.52842269561, 479.2883889155), new Vsop87.LnVsop(6.0E-9, 4.26053473889, 52.6901980395), new Vsop87.LnVsop(5.89E-9, 1.25789673267, 225.8292684102), new Vsop87.LnVsop(5.35E-9, 0.62683535518, 436.8931316145), new Vsop87.LnVsop(5.34E-9, 1.15876642524, 337.732510659), new Vsop87.LnVsop(6.29E-9, 2.68309212494, 216.2198567448), new Vsop87.LnVsop(4.39E-9, 4.59511724407, 235.3904959658), new Vsop87.LnVsop(4.27E-9, 2.1042803428, 416.3032501375), new Vsop87.LnVsop(5.46E-9, 2.3700924938, 643.8294395771), new Vsop87.LnVsop(4.21E-9, 2.66620995581, 404.5067903482), new Vsop87.LnVsop(4.2E-9, 1.52849987998, 56.6223513026), new Vsop87.LnVsop(3.97E-9, 3.53071543409, 1045.1548361876), new Vsop87.LnVsop(4.7E-9, 1.08983824027, 344.7030453079), new Vsop87.LnVsop(4.65E-9, 4.40789299623, 429.0458714308), new Vsop87.LnVsop(3.59E-9, 4.43392625322, 219.4494345923), new Vsop87.LnVsop(3.88E-9, 0.65988376162, 358.9301393095), new Vsop87.LnVsop(3.72E-9, 0.84093856644, 22.0914005278), new Vsop87.LnVsop(3.5E-9, 6.28201928387, 212.7778305762), new Vsop87.LnVsop(3.55E-9, 2.58258544797, 563.6312150384), new Vsop87.LnVsop(3.35E-9, 0.93473132492, 1485.9801210652), new Vsop87.LnVsop(3.64E-9, 1.16006460025, 70.8494453042), new Vsop87.LnVsop(3.49E-9, 0.48985168153, 213.8203602998), new Vsop87.LnVsop(3.02E-9, 4.21736561965, 284.1485407422), new Vsop87.LnVsop(3.05E-9, 6.119010362, 1.4844727083), new Vsop87.LnVsop(3.05E-9, 2.23436929835, 444.7574381407), new Vsop87.LnVsop(3.2E-9, 4.77954182227, 212.5483359126), new Vsop87.LnVsop(2.92E-9, 0.77360901796, 757.2171545342), new Vsop87.LnVsop(3.03E-9, 2.64780088849, 113.3877149571), new Vsop87.LnVsop(2.9E-9, 3.95615953692, 1471.7530270636), new Vsop87.LnVsop(2.9E-9, 3.7952679485, 12.5301729722), new Vsop87.LnVsop(2.64E-9, 6.03067553053, 934.9485149682), new Vsop87.LnVsop(2.58E-9, 2.98397544655, 106.2741679563), new Vsop87.LnVsop(2.73E-9, 5.0314361647, 251.4321310758), new Vsop87.LnVsop(3.16E-9, 5.06312049223, 1258.4539316256), new Vsop87.LnVsop(2.62E-9, 3.2220207984, 916.9322800554), new Vsop87.LnVsop(2.52E-9, 5.7147221812, 1685.0521225016), new Vsop87.LnVsop(2.31E-9, 3.07386470105, 1361.5467058442), new Vsop87.LnVsop(2.63E-9, 5.94315698498, 618.5566453116), new Vsop87.LnVsop(2.67E-9, 4.48240400758, 1148.2476104062), new Vsop87.LnVsop(2.68E-9, 0.02885423751, 207.1487562837), new Vsop87.LnVsop(3.04E-9, 3.82756071659, 217.491881132), new Vsop87.LnVsop(2.17E-9, 2.97086411233, 1692.1656695024), new Vsop87.LnVsop(2.35E-9, 4.69585016895, 696.5196376166), new Vsop87.LnVsop(2.13E-9, 1.00568423, 114.3991069134), new Vsop87.LnVsop(2.17E-9, 5.15304621208, 220.4608265486), new Vsop87.LnVsop(2.69E-9, 4.96401915824, 1574.8458012822), new Vsop87.LnVsop(2.35E-9, 2.63847496179, 355.7487455718), new Vsop87.LnVsop(2.0E-9, 4.52267084558, 508.3503240922), new Vsop87.LnVsop(2.18E-9, 5.3807565966, 245.5424243524), new Vsop87.LnVsop(1.92E-9, 3.35237783766, 2111.6503133776), new Vsop87.LnVsop(2.29E-9, 1.63754079808, 1589.0728952838), new Vsop87.LnVsop(2.51E-9, 4.10813396939, 9.5612275556), new Vsop87.LnVsop(2.02E-9, 4.69607229482, 107.0249274817), new Vsop87.LnVsop(1.73E-9, 1.59764169255, 6069.7767545534), new Vsop87.LnVsop(1.91E-9, 4.732610526, 121.2520214833), new Vsop87.LnVsop(2.07E-9, 1.92813876017, 2420.9286360334), new Vsop87.LnVsop(1.91E-9, 5.84855063985, 181.0557665236), new Vsop87.LnVsop(1.64E-9, 5.21783359224, 414.0680179038), new Vsop87.LnVsop(2.02E-9, 2.29783143388, 1677.9385755008), new Vsop87.LnVsop(1.62E-9, 5.51123664884, 576.1613880106), new Vsop87.LnVsop(1.61E-9, 3.02107979424, 248.7238180901), new Vsop87.LnVsop(1.91E-9, 2.28684786322, 2435.155730035), new Vsop87.LnVsop(1.57E-9, 3.63748850914, 1788.1448967202), new Vsop87.LnVsop(1.52E-9, 1.86243245336, 177.8743727859), new Vsop87.LnVsop(1.64E-9, 1.00473920687, 4.665866446), new Vsop87.LnVsop(1.69E-9, 3.27701894896, 1493.093668066), new Vsop87.LnVsop(1.51E-9, 5.10275814573, 501.3797894433), new Vsop87.LnVsop(1.73E-9, 4.0104555206, 98.8999885246), new Vsop87.LnVsop(1.58E-9, 3.11393392977, 2008.557539159), new Vsop87.LnVsop(1.47E-9, 4.27669780086, 710.7467316182), new Vsop87.LnVsop(1.47E-9, 0.6788206026, 425.1137181677), new Vsop87.LnVsop(1.54E-9, 5.37147054362, 148.0787244263), new Vsop87.LnVsop(1.7E-9, 0.18576682177, 151.0476698429), new Vsop87.LnVsop(1.53E-9, 6.11985601662, 206.1373643274), new Vsop87.LnVsop(1.69E-9, 2.77293672089, 1781.0313497194), new Vsop87.LnVsop(1.37E-9, 1.44843193937, 131.5469622218), new Vsop87.LnVsop(1.68E-9, 5.92342908737, 173.9422195228), new Vsop87.LnVsop(1.58E-9, 3.55883885624, 1581.959348283), new Vsop87.LnVsop(1.84E-9, 4.62097049709, 1891.2376709388), new Vsop87.LnVsop(1.34E-9, 3.91403282954, 114.1384744825), new Vsop87.LnVsop(1.27E-9, 3.70533738666, 436.1594184316), new Vsop87.LnVsop(1.35E-9, 4.66039870198, 778.4147831847), new Vsop87.LnVsop(1.29E-9, 5.91798218618, 963.4027029714), new Vsop87.LnVsop(1.31E-9, 3.92478528327, 421.93232443), new Vsop87.LnVsop(1.2E-9, 0.55800628755, 1802.3719907218), new Vsop87.LnVsop(1.25E-9, 5.47463165452, 2001.4439921582), new Vsop87.LnVsop(1.2E-9, 0.70246037996, 81.7521332162), new Vsop87.LnVsop(1.14E-9, 4.06514981999, 1286.9081196288), new Vsop87.LnVsop(1.03E-9, 2.85758217373, 2428.0421830342), new Vsop87.LnVsop(1.1E-9, 5.49603517952, 601.7642506762), new Vsop87.LnVsop(9.9E-10, 4.6679856612, 431.264057322), new Vsop87.LnVsop(1.35E-9, 5.19983204299, 849.2642284889), new Vsop87.LnVsop(1.18E-9, 2.58641645913, 525.4981794006), new Vsop87.LnVsop(1.01E-9, 6.08443910077, 558.0021407459), new Vsop87.LnVsop(9.2E-10, 5.92766532505, 175.1660598002), new Vsop87.LnVsop(9.9E-10, 4.4290211469, 2317.8358618148), new Vsop87.LnVsop(9.9E-10, 4.19847910689, 776.9303104764), new Vsop87.LnVsop(9.0E-10, 4.8396984837, 2214.7430875962), new Vsop87.LnVsop(9.0E-10, 6.25429035515, 661.2379273164), new Vsop87.LnVsop(8.8E-10, 0.53030468857, 1382.8873468466), new Vsop87.LnVsop(8.6E-10, 5.60357922616, 289.5651667136), new Vsop87.LnVsop(9.3E-10, 4.23197698724, 767.3690829208), new Vsop87.LnVsop(8.4E-10, 1.27340099422, 2531.1349572528), new Vsop87.LnVsop(9.1E-10, 1.34171959952, 421.1815649046), new Vsop87.LnVsop(7.5E-10, 3.24680455233, 488.8496164711), new Vsop87.LnVsop(7.2E-10, 3.94806470747, 637.4496057592), new Vsop87.LnVsop(7.5E-10, 4.01647621073, 432.2272651685)};
        private static final Vsop87.LnVsop[] saturn_latitude_b2 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.3884264E-4, 0.08994998691, 213.299095438), new Vsop87.LnVsop(3.075713E-5, 3.9161093762, 206.1855484372), new Vsop87.LnVsop(2.081666E-5, 0.09631968077, 220.4126424388), new Vsop87.LnVsop(1.452574E-5, 5.48867576013, 426.598190876), new Vsop87.LnVsop(5.46808E-6, 2.94585826799, 419.4846438752), new Vsop87.LnVsop(3.91398E-6, 5.43939792344, 433.7117378768), new Vsop87.LnVsop(3.1974E-6, 4.34820275048, 639.897286314), new Vsop87.LnVsop(2.03518E-6, 1.37396136744, 7.1135470008), new Vsop87.LnVsop(2.20164E-6, 0.0, 0.0), new Vsop87.LnVsop(1.16719E-6, 6.24505924943, 227.5261894396), new Vsop87.LnVsop(6.7605E-7, 1.75135990376, 316.3918696566), new Vsop87.LnVsop(6.4044E-7, 4.10904350356, 199.0720014364), new Vsop87.LnVsop(5.5518E-7, 4.56815095513, 647.0108333148), new Vsop87.LnVsop(4.9875E-7, 3.48944345784, 853.196381752), new Vsop87.LnVsop(3.8984E-7, 2.7993042852, 632.7837393132), new Vsop87.LnVsop(2.7643E-7, 1.22439852303, 14.2270940016), new Vsop87.LnVsop(2.4804E-7, 4.48123972552, 210.1177017003), new Vsop87.LnVsop(2.1498E-7, 5.38853499774, 440.8252848776), new Vsop87.LnVsop(1.5704E-7, 4.28129850675, 217.2312487011), new Vsop87.LnVsop(1.9538E-7, 5.81992746567, 216.4804891757), new Vsop87.LnVsop(1.4472E-7, 1.71327951628, 110.2063212194), new Vsop87.LnVsop(1.229E-7, 4.06067197339, 103.0927742186), new Vsop87.LnVsop(1.0826E-7, 0.58425778734, 323.5054166574), new Vsop87.LnVsop(1.1875E-7, 2.9567255894, 412.3710968744), new Vsop87.LnVsop(1.0534E-7, 2.51484815706, 529.6909650946), new Vsop87.LnVsop(7.971E-8, 1.29072033406, 117.3198682202), new Vsop87.LnVsop(9.046E-8, 5.92757785737, 209.3669421749), new Vsop87.LnVsop(6.82E-8, 3.73629063516, 860.3099287528), new Vsop87.LnVsop(5.266E-8, 3.17424271177, 202.2533951741), new Vsop87.LnVsop(6.316E-8, 2.70918854345, 1066.49547719), new Vsop87.LnVsop(4.648E-8, 3.40943979533, 309.2783226558), new Vsop87.LnVsop(3.657E-8, 6.10028538147, 234.6397364404), new Vsop87.LnVsop(3.034E-8, 3.00141076688, 95.9792272178), new Vsop87.LnVsop(2.964E-8, 4.7591827384, 625.6701923124), new Vsop87.LnVsop(2.831E-8, 3.72837340664, 423.4167971383), new Vsop87.LnVsop(3.06E-8, 4.54921839566, 654.1243803156), new Vsop87.LnVsop(3.173E-8, 4.93945460684, 429.7795846137), new Vsop87.LnVsop(2.517E-8, 2.84610096404, 846.0828347512), new Vsop87.LnVsop(2.755E-8, 0.11130771173, 330.6189636582), new Vsop87.LnVsop(2.476E-8, 5.8052055678, 536.8045120954), new Vsop87.LnVsop(2.579E-8, 4.80701288066, 422.6660376129), new Vsop87.LnVsop(2.252E-8, 0.09608234743, 522.5774180938), new Vsop87.LnVsop(2.036E-8, 0.29468198549, 224.3447957019), new Vsop87.LnVsop(1.945E-8, 5.61183319602, 735.8765135318), new Vsop87.LnVsop(1.649E-8, 6.17255863554, 415.5524906121), new Vsop87.LnVsop(1.711E-8, 5.68150133024, 223.5940361765), new Vsop87.LnVsop(1.223E-8, 1.07126086594, 21.3406410024), new Vsop87.LnVsop(1.51E-8, 1.50174476287, 742.9900605326), new Vsop87.LnVsop(1.07E-8, 4.69201775284, 203.0041546995), new Vsop87.LnVsop(1.097E-8, 4.44901307448, 430.5303441391), new Vsop87.LnVsop(9.59E-9, 0.29003331127, 3.9321532631), new Vsop87.LnVsop(1.219E-8, 4.89549127087, 277.0349937414), new Vsop87.LnVsop(7.8E-9, 6.11668251851, 124.433415221), new Vsop87.LnVsop(8.1E-9, 5.92587997397, 437.6438911399), new Vsop87.LnVsop(7.11E-9, 0.87489137869, 3.1813937377), new Vsop87.LnVsop(7.03E-9, 2.88322689246, 88.865680217), new Vsop87.LnVsop(7.41E-9, 5.28664451824, 447.9388318784), new Vsop87.LnVsop(7.97E-9, 0.38839628271, 515.463871093), new Vsop87.LnVsop(6.48E-9, 2.16863760555, 1059.3819301892), new Vsop87.LnVsop(7.7E-9, 3.01019419227, 1073.6090241908), new Vsop87.LnVsop(6.46E-9, 4.44476999591, 191.9584544356), new Vsop87.LnVsop(7.63E-9, 4.45009347392, 11.0457002639), new Vsop87.LnVsop(5.2E-9, 5.46724081186, 149.5631971346), new Vsop87.LnVsop(4.95E-9, 5.65080506007, 728.762966531), new Vsop87.LnVsop(5.72E-9, 1.93890743211, 1279.794572628), new Vsop87.LnVsop(4.13E-9, 2.87450257144, 408.4389436113), new Vsop87.LnVsop(4.32E-9, 0.45412432082, 956.2891559706), new Vsop87.LnVsop(3.88E-9, 4.94447690735, 949.1756089698), new Vsop87.LnVsop(3.6E-9, 6.13193432237, 63.7358983034), new Vsop87.LnVsop(3.51E-9, 5.97838746664, 215.7467759928), new Vsop87.LnVsop(4.32E-9, 4.8861749087, 838.9692877504), new Vsop87.LnVsop(3.08E-9, 5.01490854649, 1052.2683831884), new Vsop87.LnVsop(3.03E-9, 1.38736789277, 231.4583427027), new Vsop87.LnVsop(3.48E-9, 5.5625665107, 543.9180590962), new Vsop87.LnVsop(2.83E-9, 3.29371245264, 490.3340891794), new Vsop87.LnVsop(2.93E-9, 3.95078933984, 635.9651330509), new Vsop87.LnVsop(2.73E-9, 0.60520392704, 10.2949407385), new Vsop87.LnVsop(2.5E-9, 4.80069153282, 74.7815985673), new Vsop87.LnVsop(2.81E-9, 4.89543546695, 750.1036075334), new Vsop87.LnVsop(2.42E-9, 2.03148855332, 1471.7530270636), new Vsop87.LnVsop(2.74E-9, 3.74993232264, 867.4234757536), new Vsop87.LnVsop(2.59E-9, 4.13047010772, 643.0786800517), new Vsop87.LnVsop(2.16E-9, 0.80763325373, 210.8514148832), new Vsop87.LnVsop(2.06E-9, 0.17095872111, 195.1398481733), new Vsop87.LnVsop(1.97E-9, 2.31774972985, 18.1592472647), new Vsop87.LnVsop(2.5E-9, 4.46843768407, 302.164775655), new Vsop87.LnVsop(1.71E-9, 5.71503506984, 1169.5882514086), new Vsop87.LnVsop(1.84E-9, 1.22063055823, 203.7378678824), new Vsop87.LnVsop(1.5E-9, 3.38891097774, 636.7158925763), new Vsop87.LnVsop(1.83E-9, 0.96894551644, 483.2205421786), new Vsop87.LnVsop(1.88E-9, 0.97246012795, 1375.7737998458), new Vsop87.LnVsop(1.5E-9, 0.21152728512, 1898.3512179396), new Vsop87.LnVsop(1.41E-9, 5.87565118609, 618.5566453116), new Vsop87.LnVsop(1.35E-9, 4.89760499349, 436.8931316145), new Vsop87.LnVsop(1.19E-9, 3.6906115232, 1581.959348283), new Vsop87.LnVsop(1.28E-9, 4.55726731141, 1162.4747044078), new Vsop87.LnVsop(1.08E-9, 3.68308754111, 416.3032501375), new Vsop87.LnVsop(1.22E-9, 0.02813545121, 831.8557407496), new Vsop87.LnVsop(1.02E-9, 3.40993719364, 497.4476361802), new Vsop87.LnVsop(1.36E-9, 3.20634132887, 1155.361157407), new Vsop87.LnVsop(1.15E-9, 3.85804239112, 1265.5674786264), new Vsop87.LnVsop(1.03E-9, 5.21716051597, 650.9429865779), new Vsop87.LnVsop(1.16E-9, 0.26089900561, 1258.4539316256), new Vsop87.LnVsop(9.9E-10, 4.2261756397, 362.8622925726), new Vsop87.LnVsop(9.7E-10, 2.73570765102, 1368.660252845), new Vsop87.LnVsop(9.3E-10, 0.38836049436, 942.062061969), new Vsop87.LnVsop(8.1E-10, 4.68801853439, 351.8165923087), new Vsop87.LnVsop(9.4E-10, 4.53448741145, 628.8515860501), new Vsop87.LnVsop(7.8E-10, 5.47626971516, 337.732510659), new Vsop87.LnVsop(1.02E-9, 0.47334815662, 1272.6810256272), new Vsop87.LnVsop(7.3E-10, 2.04208824417, 621.7380390493)};
        private static final Vsop87.LnVsop[] saturn_latitude_b3 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(4.63357E-6, 1.69194209337, 213.299095438), new Vsop87.LnVsop(4.87242E-6, 5.57827705588, 206.1855484372), new Vsop87.LnVsop(2.70686E-6, 4.65445792593, 220.4126424388), new Vsop87.LnVsop(2.77451E-6, 0.0, 0.0), new Vsop87.LnVsop(6.6718E-7, 3.66337287998, 433.7117378768), new Vsop87.LnVsop(6.5617E-7, 4.71263096227, 419.4846438752), new Vsop87.LnVsop(6.9846E-7, 3.33236270677, 426.598190876), new Vsop87.LnVsop(3.0551E-7, 4.53651131935, 227.5261894396), new Vsop87.LnVsop(2.9704E-7, 2.49374065388, 639.897286314), new Vsop87.LnVsop(1.8157E-7, 5.89401285772, 7.1135470008), new Vsop87.LnVsop(1.7504E-7, 5.79120992263, 199.0720014364), new Vsop87.LnVsop(1.1684E-7, 2.74773493978, 647.0108333148), new Vsop87.LnVsop(6.048E-8, 5.80237729519, 14.2270940016), new Vsop87.LnVsop(6.248E-8, 1.60565634016, 853.196381752), new Vsop87.LnVsop(6.42E-8, 3.63996599914, 440.8252848776), new Vsop87.LnVsop(4.552E-8, 6.21266119922, 210.1177017003), new Vsop87.LnVsop(4.995E-8, 3.21953122449, 316.3918696566), new Vsop87.LnVsop(4.166E-8, 4.64321479214, 632.7837393132), new Vsop87.LnVsop(2.938E-8, 4.647670282, 412.3710968744), new Vsop87.LnVsop(2.894E-8, 4.02023147538, 216.4804891757), new Vsop87.LnVsop(2.225E-8, 0.67809668672, 103.0927742186), new Vsop87.LnVsop(1.694E-8, 1.86898759241, 860.3099287528), new Vsop87.LnVsop(1.394E-8, 4.39486147395, 234.6397364404), new Vsop87.LnVsop(1.272E-8, 5.87144755894, 217.2312487011), new Vsop87.LnVsop(1.132E-8, 5.91391008745, 117.3198682202), new Vsop87.LnVsop(9.84E-9, 0.89291344192, 1066.49547719), new Vsop87.LnVsop(8.48E-9, 5.10998113739, 323.5054166574), new Vsop87.LnVsop(1.018E-8, 2.76708857895, 654.1243803156), new Vsop87.LnVsop(8.44E-9, 5.65924574483, 309.2783226558), new Vsop87.LnVsop(6.31E-9, 3.09293087763, 429.7795846137), new Vsop87.LnVsop(5.24E-9, 0.12316698689, 625.6701923124), new Vsop87.LnVsop(5.48E-9, 0.64455286234, 110.2063212194), new Vsop87.LnVsop(4.84E-9, 5.32908334165, 202.2533951741), new Vsop87.LnVsop(5.11E-9, 4.72373936399, 330.6189636582), new Vsop87.LnVsop(4.51E-9, 3.89411630776, 223.5940361765), new Vsop87.LnVsop(3.95E-9, 5.6047171669, 21.3406410024), new Vsop87.LnVsop(4.41E-9, 4.83224059479, 95.9792272178), new Vsop87.LnVsop(3.48E-9, 6.09514028242, 191.9584544356), new Vsop87.LnVsop(2.77E-9, 4.37382373255, 529.6909650946), new Vsop87.LnVsop(2.76E-9, 4.66453225056, 209.3669421749), new Vsop87.LnVsop(2.91E-9, 3.74809602199, 447.9388318784), new Vsop87.LnVsop(2.31E-9, 4.32361342543, 124.433415221), new Vsop87.LnVsop(2.4E-9, 4.17865323637, 536.8045120954), new Vsop87.LnVsop(2.16E-9, 0.94023041295, 735.8765135318), new Vsop87.LnVsop(2.15E-9, 4.63069992131, 846.0828347512), new Vsop87.LnVsop(2.53E-9, 5.83932336956, 302.164775655), new Vsop87.LnVsop(1.8E-9, 4.66973939257, 224.3447957019), new Vsop87.LnVsop(2.32E-9, 0.72016647797, 203.0041546995), new Vsop87.LnVsop(1.82E-9, 4.63702652869, 88.865680217), new Vsop87.LnVsop(1.69E-9, 1.51271620453, 522.5774180938), new Vsop87.LnVsop(1.69E-9, 5.79435475585, 423.4167971383), new Vsop87.LnVsop(1.33E-9, 2.98510523287, 422.6660376129), new Vsop87.LnVsop(1.28E-9, 1.05737228351, 1073.6090241908), new Vsop87.LnVsop(7.6E-10, 6.23861369445, 1279.794572628)};
        private static final Vsop87.LnVsop[] saturn_latitude_b4 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(5.8521E-7, 0.96404269672, 206.1855484372), new Vsop87.LnVsop(2.7023E-7, 2.97511812746, 213.299095438), new Vsop87.LnVsop(2.7345E-7, 2.90816987834, 220.4126424388), new Vsop87.LnVsop(8.709E-8, 1.88638219079, 433.7117378768), new Vsop87.LnVsop(6.015E-8, 2.81931276694, 227.5261894396), new Vsop87.LnVsop(6.059E-8, 0.21576562475, 419.4846438752), new Vsop87.LnVsop(3.796E-8, 1.19723799579, 199.0720014364), new Vsop87.LnVsop(3.647E-8, 1.71327650497, 426.598190876), new Vsop87.LnVsop(2.054E-8, 0.66410894553, 639.897286314), new Vsop87.LnVsop(2.559E-8, 3.14159265359, 0.0), new Vsop87.LnVsop(1.867E-8, 0.93578719925, 647.0108333148), new Vsop87.LnVsop(1.256E-8, 4.1317599278, 7.1135470008), new Vsop87.LnVsop(1.399E-8, 1.88853247568, 440.8252848776), new Vsop87.LnVsop(9.36E-9, 4.08790738476, 14.2270940016), new Vsop87.LnVsop(6.18E-9, 6.2387930652, 853.196381752), new Vsop87.LnVsop(3.72E-9, 0.27149825756, 412.3710968744), new Vsop87.LnVsop(3.32E-9, 2.65677859091, 234.6397364404), new Vsop87.LnVsop(2.47E-9, 0.25604474898, 632.7837393132), new Vsop87.LnVsop(2.12E-9, 0.03063135059, 860.3099287528), new Vsop87.LnVsop(1.62E-9, 4.96348549494, 117.3198682202), new Vsop87.LnVsop(1.29E-9, 0.09615721074, 110.2063212194), new Vsop87.LnVsop(1.46E-9, 1.02713520383, 654.1243803156), new Vsop87.LnVsop(8.1E-10, 1.92779115537, 625.6701923124), new Vsop87.LnVsop(7.2E-10, 5.13732084121, 1066.49547719)};
        private static final Vsop87.LnVsop[] saturn_latitude_b5 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(5.442E-8, 2.61186488264, 206.1855484372), new Vsop87.LnVsop(1.966E-8, 1.16969532852, 220.4126424388), new Vsop87.LnVsop(9.07E-9, 0.10771558371, 433.7117378768), new Vsop87.LnVsop(8.29E-9, 1.07640059707, 227.5261894396), new Vsop87.LnVsop(5.84E-9, 2.88210646011, 199.0720014364), new Vsop87.LnVsop(7.64E-9, 3.14159265359, 0.0), new Vsop87.LnVsop(1.77E-9, 2.05357076014, 419.4846438752), new Vsop87.LnVsop(1.51E-9, 5.415822678, 647.0108333148), new Vsop87.LnVsop(9.8E-10, 1.68550159247, 213.299095438), new Vsop87.LnVsop(1.2E-9, 0.10893311879, 440.8252848776), new Vsop87.LnVsop(8.1E-10, 5.1137309661, 639.897286314)};

        Latitude() {
        }
    }

    static class Longitude {
        private static final Vsop87.LnVsop[] saturn_longitude_l0 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.87401354025, 0.0, 0.0), new Vsop87.LnVsop(0.11107659762, 3.96205090159, 213.299095438), new Vsop87.LnVsop(0.01414150957, 4.58581516874, 7.1135470008), new Vsop87.LnVsop(0.00398379389, 0.52112032699, 206.1855484372), new Vsop87.LnVsop(0.00350769243, 3.30329907896, 426.598190876), new Vsop87.LnVsop(0.00206816305, 0.24658372002, 103.0927742186), new Vsop87.LnVsop(7.92713E-4, 3.84007056878, 220.4126424388), new Vsop87.LnVsop(2.3990355E-4, 4.66976924553, 110.2063212194), new Vsop87.LnVsop(1.6573588E-4, 0.43719228296, 419.4846438752), new Vsop87.LnVsop(1.4906995E-4, 5.76903183869, 316.3918696566), new Vsop87.LnVsop(1.582029E-4, 0.93809155235, 632.7837393132), new Vsop87.LnVsop(1.4609559E-4, 1.56518472, 3.9321532631), new Vsop87.LnVsop(1.3160301E-4, 4.44891291899, 14.2270940016), new Vsop87.LnVsop(1.5053543E-4, 2.71669915667, 639.897286314), new Vsop87.LnVsop(1.3005299E-4, 5.98119023644, 11.0457002639), new Vsop87.LnVsop(1.0725067E-4, 3.12939523827, 202.2533951741), new Vsop87.LnVsop(5.863206E-5, 0.23656938524, 529.6909650946), new Vsop87.LnVsop(5.227757E-5, 4.20783365759, 3.1813937377), new Vsop87.LnVsop(6.126317E-5, 1.76328667907, 277.0349937414), new Vsop87.LnVsop(5.019687E-5, 3.17787728405, 433.7117378768), new Vsop87.LnVsop(4.59255E-5, 0.61977744975, 199.0720014364), new Vsop87.LnVsop(4.005867E-5, 2.24479718502, 63.7358983034), new Vsop87.LnVsop(2.953796E-5, 0.98280366998, 95.9792272178), new Vsop87.LnVsop(3.87367E-5, 3.22283226966, 138.5174968707), new Vsop87.LnVsop(2.461186E-5, 2.03163875071, 735.8765135318), new Vsop87.LnVsop(3.269484E-5, 0.77492638211, 949.1756089698), new Vsop87.LnVsop(1.758145E-5, 3.2658010994, 522.5774180938), new Vsop87.LnVsop(1.640172E-5, 5.5050445305, 846.0828347512), new Vsop87.LnVsop(1.391327E-5, 4.02333150505, 323.5054166574), new Vsop87.LnVsop(1.580648E-5, 4.37265307169, 309.2783226558), new Vsop87.LnVsop(1.123498E-5, 2.83726798446, 415.5524906121), new Vsop87.LnVsop(1.017275E-5, 3.71700135395, 227.5261894396), new Vsop87.LnVsop(8.48642E-6, 3.1915017083, 209.3669421749), new Vsop87.LnVsop(1.087229E-5, 4.1834325756, 2.4476805548), new Vsop87.LnVsop(9.56757E-6, 0.50744342622, 1265.5674786264), new Vsop87.LnVsop(7.89205E-6, 5.00745127508, 0.9632078465), new Vsop87.LnVsop(6.86999E-6, 1.74714152638, 1052.2683831884), new Vsop87.LnVsop(6.54484E-6, 1.59889329033, 0.0481841098), new Vsop87.LnVsop(7.48819E-6, 2.14396789786, 853.196381752), new Vsop87.LnVsop(6.33982E-6, 2.29887419204, 412.3710968744), new Vsop87.LnVsop(7.43599E-6, 5.25277685028, 224.3447957019), new Vsop87.LnVsop(8.52677E-6, 3.42141279787, 175.1660598002), new Vsop87.LnVsop(5.79844E-6, 3.09254750266, 74.7815985673), new Vsop87.LnVsop(6.24883E-6, 0.9704808751, 210.1177017003), new Vsop87.LnVsop(5.29874E-6, 4.44938991187, 117.3198682202), new Vsop87.LnVsop(5.42648E-6, 1.51824981131, 9.5612275556), new Vsop87.LnVsop(4.74277E-6, 5.47526482059, 742.9900605326), new Vsop87.LnVsop(4.48547E-6, 1.28991363969, 127.4717966068), new Vsop87.LnVsop(5.46365E-6, 2.12677911914, 350.3321196004), new Vsop87.LnVsop(4.78044E-6, 2.96486700885, 137.0330241624), new Vsop87.LnVsop(3.54988E-6, 3.01280169452, 838.9692877504), new Vsop87.LnVsop(4.51857E-6, 1.04437293342, 490.3340891794), new Vsop87.LnVsop(3.47422E-6, 1.53923267387, 340.7708920448), new Vsop87.LnVsop(3.43481E-6, 0.24603836481, 0.5212648618), new Vsop87.LnVsop(3.09029E-6, 3.49491017725, 216.4804891757), new Vsop87.LnVsop(3.22189E-6, 0.96136528867, 203.7378678824), new Vsop87.LnVsop(3.72318E-6, 2.27822895353, 217.2312487011), new Vsop87.LnVsop(3.21562E-6, 2.57185176731, 647.0108333148), new Vsop87.LnVsop(3.30197E-6, 0.24721738903, 1581.959348283), new Vsop87.LnVsop(2.49142E-6, 1.47004230445, 1368.660252845), new Vsop87.LnVsop(2.86703E-6, 2.37046001635, 351.8165923087), new Vsop87.LnVsop(2.20225E-6, 4.20421716654, 200.7689224658), new Vsop87.LnVsop(2.77774E-6, 0.40024010033, 211.8146227297), new Vsop87.LnVsop(2.0452E-6, 6.01073368945, 265.9892934775), new Vsop87.LnVsop(2.07645E-6, 0.48344140678, 1162.4747044078), new Vsop87.LnVsop(2.0865E-6, 1.34533476508, 625.6701923124), new Vsop87.LnVsop(1.82459E-6, 5.49122412646, 2.9207613068), new Vsop87.LnVsop(2.26601E-6, 4.90997278296, 12.5301729722), new Vsop87.LnVsop(2.07666E-6, 1.28298038875, 39.3568759152), new Vsop87.LnVsop(1.73914E-6, 1.86305647242, 0.7507595254), new Vsop87.LnVsop(1.84698E-6, 3.50349102817, 149.5631971346), new Vsop87.LnVsop(1.83509E-6, 0.97260974474, 4.192785694), new Vsop87.LnVsop(1.46074E-6, 6.23107926975, 195.1398481733), new Vsop87.LnVsop(1.64541E-6, 0.44004693949, 5.4166259714), new Vsop87.LnVsop(1.47544E-6, 1.53530368067, 5.6290742925), new Vsop87.LnVsop(1.3969E-6, 4.29463428594, 21.3406410024), new Vsop87.LnVsop(1.31292E-6, 4.06829024226, 10.2949407385), new Vsop87.LnVsop(1.17326E-6, 2.67913173095, 1155.361157407), new Vsop87.LnVsop(1.49302E-6, 5.73592320434, 52.6901980395), new Vsop87.LnVsop(1.22371E-6, 1.97585460706, 4.665866446), new Vsop87.LnVsop(1.13737E-6, 5.59421876022, 1059.3819301892), new Vsop87.LnVsop(1.02689E-6, 1.19754453191, 1685.0521225016), new Vsop87.LnVsop(1.18169E-6, 5.34072820318, 554.0699874828), new Vsop87.LnVsop(1.09287E-6, 3.43808188855, 536.8045120954), new Vsop87.LnVsop(1.104E-6, 0.16605133194, 1.4844727083), new Vsop87.LnVsop(1.2498E-6, 6.27738701225, 1898.3512179396), new Vsop87.LnVsop(8.9916E-7, 5.80394843417, 114.1384744825), new Vsop87.LnVsop(1.03968E-6, 2.19185625957, 88.865680217), new Vsop87.LnVsop(1.1243E-6, 1.10510750315, 191.2076949102), new Vsop87.LnVsop(1.06578E-6, 4.01153470635, 956.2891559706), new Vsop87.LnVsop(9.1425E-7, 1.87523841598, 38.1330356378), new Vsop87.LnVsop(8.3763E-7, 5.48810655641, 0.1118745846), new Vsop87.LnVsop(8.3489E-7, 2.28927138986, 628.8515860501), new Vsop87.LnVsop(9.6973E-7, 4.53662541679, 302.164775655), new Vsop87.LnVsop(1.00634E-6, 4.96513420321, 269.9214467406), new Vsop87.LnVsop(7.5496E-7, 2.18005762811, 728.762966531), new Vsop87.LnVsop(9.633E-7, 2.83319249226, 275.5505210331), new Vsop87.LnVsop(8.2386E-7, 3.05482650543, 440.8252848776), new Vsop87.LnVsop(7.3896E-7, 5.08917637074, 1375.7737998458), new Vsop87.LnVsop(7.1625E-7, 5.10946423579, 65.2203710117), new Vsop87.LnVsop(7.0386E-7, 4.86846451411, 0.2124483211), new Vsop87.LnVsop(6.976E-7, 3.71027033119, 14.977853527), new Vsop87.LnVsop(8.8771E-7, 3.86334160349, 278.5194664497), new Vsop87.LnVsop(6.8092E-7, 0.7343049945, 1478.8665740644), new Vsop87.LnVsop(6.6481E-7, 0.02658132849, 70.8494453042), new Vsop87.LnVsop(6.5694E-7, 2.02147100289, 142.4496501338), new Vsop87.LnVsop(7.5752E-7, 1.6141342601, 284.1485407422), new Vsop87.LnVsop(6.3138E-7, 3.49495099319, 479.2883889155), new Vsop87.LnVsop(6.2557E-7, 2.58733971413, 422.6660376129), new Vsop87.LnVsop(6.93E-7, 3.44002100885, 515.463871093), new Vsop87.LnVsop(7.901E-7, 4.45159676932, 35.4247226521), new Vsop87.LnVsop(6.3664E-7, 3.3174798019, 62.2514255951), new Vsop87.LnVsop(5.2994E-7, 5.51392725227, 0.2606324309), new Vsop87.LnVsop(5.3017E-7, 3.18475265559, 8.0767548473), new Vsop87.LnVsop(5.4492E-7, 2.45664158976, 22.0914005278), new Vsop87.LnVsop(5.0507E-7, 4.26791628421, 99.1606209555), new Vsop87.LnVsop(5.5159E-7, 0.96792241728, 942.062061969), new Vsop87.LnVsop(4.932E-7, 2.386664758, 1471.7530270636), new Vsop87.LnVsop(4.7203E-7, 2.02525393154, 312.1990839626), new Vsop87.LnVsop(6.109E-7, 1.50302054623, 210.8514148832), new Vsop87.LnVsop(6.0676E-7, 2.68689407241, 388.4651552382), new Vsop87.LnVsop(4.5138E-7, 0.93106348303, 2001.4439921582), new Vsop87.LnVsop(4.345E-7, 2.52603236088, 288.0806940053), new Vsop87.LnVsop(4.2562E-7, 3.81786681717, 330.6189636582), new Vsop87.LnVsop(3.9933E-7, 5.71382574413, 408.4389436113), new Vsop87.LnVsop(5.0125E-7, 6.0315257085, 2214.7430875962), new Vsop87.LnVsop(4.6031E-7, 0.54227917765, 212.3358875915), new Vsop87.LnVsop(5.416E-7, 0.78128719345, 191.9584544356), new Vsop87.LnVsop(4.7042E-7, 4.59902370789, 437.6438911399), new Vsop87.LnVsop(4.2367E-7, 1.9006958138, 430.5303441391), new Vsop87.LnVsop(3.9759E-7, 1.63243208156, 1066.49547719), new Vsop87.LnVsop(3.6469E-7, 0.84688120284, 213.3472795478), new Vsop87.LnVsop(3.5468E-7, 4.18601929802, 215.7467759928), new Vsop87.LnVsop(3.6469E-7, 3.93224996469, 213.2509113282), new Vsop87.LnVsop(3.8003E-7, 0.31314052371, 423.4167971383), new Vsop87.LnVsop(4.4824E-7, 1.12406079738, 6.1503391543), new Vsop87.LnVsop(3.7902E-7, 1.19795851065, 2.7083129857), new Vsop87.LnVsop(4.3405E-7, 1.3736045557, 563.6312150384), new Vsop87.LnVsop(4.3913E-7, 3.93075296633, 525.4981794006), new Vsop87.LnVsop(3.4837E-7, 1.01543342379, 203.0041546995), new Vsop87.LnVsop(3.1755E-7, 1.69273634405, 0.1600586944), new Vsop87.LnVsop(3.0892E-7, 6.13529793424, 417.0369633204), new Vsop87.LnVsop(3.6407E-7, 6.00604303567, 18.1592472647), new Vsop87.LnVsop(2.9157E-7, 1.19375828579, 404.5067903482), new Vsop87.LnVsop(3.2811E-7, 0.53654765923, 107.0249274817), new Vsop87.LnVsop(3.0461E-7, 0.72314414241, 222.8603229936), new Vsop87.LnVsop(3.2668E-7, 0.81193242653, 1795.258443721), new Vsop87.LnVsop(3.7741E-7, 3.69667138462, 1272.6810256272), new Vsop87.LnVsop(2.7679E-7, 1.4566396812, 7.1617311106), new Vsop87.LnVsop(2.7165E-7, 1.89600219634, 1045.1548361876), new Vsop87.LnVsop(3.7836E-7, 4.51945172068, 24.3790223882), new Vsop87.LnVsop(3.5003E-7, 4.46092370686, 214.2623032845), new Vsop87.LnVsop(3.2661E-7, 0.6634774319, 692.5874843535), new Vsop87.LnVsop(3.0436E-7, 5.30241022019, 33.9402499438), new Vsop87.LnVsop(2.7579E-7, 6.22702209204, 1.2720243872), new Vsop87.LnVsop(2.6658E-7, 4.56713174166, 7.065362891), new Vsop87.LnVsop(3.1745E-7, 5.49844823318, 56.6223513026), new Vsop87.LnVsop(2.8153E-7, 5.64388600762, 128.9562693151), new Vsop87.LnVsop(2.4275E-7, 3.93953220869, 414.0680179038), new Vsop87.LnVsop(3.2024E-7, 5.22237631301, 92.0470739547), new Vsop87.LnVsop(2.3059E-7, 3.66034194445, 207.6700211455), new Vsop87.LnVsop(2.6975E-7, 0.06644184255, 205.2223405907), new Vsop87.LnVsop(3.1825E-7, 5.59208218558, 6069.7767545534), new Vsop87.LnVsop(2.3153E-7, 2.10053945, 1788.1448967202), new Vsop87.LnVsop(3.104E-7, 0.37144696566, 703.6331846174), new Vsop87.LnVsop(2.9384E-7, 0.14749408878, 131.4039498699), new Vsop87.LnVsop(2.2551E-7, 5.2399478021, 212.7778305762), new Vsop87.LnVsop(2.6183E-7, 5.41312719168, 140.001969579), new Vsop87.LnVsop(2.5779E-7, 4.36084632109, 32.2433289144), new Vsop87.LnVsop(2.0659E-7, 0.67095777002, 2317.8358618148), new Vsop87.LnVsop(2.0362E-7, 2.82404200673, 429.7795846137), new Vsop87.LnVsop(2.4404E-7, 3.08826377429, 145.6310438715), new Vsop87.LnVsop(2.3748E-7, 2.54374565817, 76.2660712756), new Vsop87.LnVsop(2.0112E-7, 5.05984887501, 617.8058857862), new Vsop87.LnVsop(2.3302E-7, 3.97332549746, 483.2205421786), new Vsop87.LnVsop(2.2878E-7, 6.10447953656, 177.8743727859), new Vsop87.LnVsop(2.2984E-7, 3.20182261633, 208.633228992), new Vsop87.LnVsop(2.0638E-7, 5.22127912054, 6.592282139), new Vsop87.LnVsop(2.1419E-7, 0.71923264007, 1258.4539316256), new Vsop87.LnVsop(1.8151E-7, 6.11584874018, 210.3783341312), new Vsop87.LnVsop(2.2385E-7, 5.92318160986, 173.9422195228), new Vsop87.LnVsop(1.912E-7, 5.77736469009, 213.8203602998), new Vsop87.LnVsop(2.087E-7, 5.79129638608, 2531.1349572528), new Vsop87.LnVsop(1.6904E-7, 3.27550525617, 98.8999885246), new Vsop87.LnVsop(1.933E-7, 1.64166493503, 565.1156877467), new Vsop87.LnVsop(2.0839E-7, 2.01683749266, 860.3099287528), new Vsop87.LnVsop(1.5638E-7, 3.10062358099, 106.2741679563), new Vsop87.LnVsop(1.7802E-7, 3.1449763516, 831.8557407496), new Vsop87.LnVsop(1.8235E-7, 5.22594210687, 73.297125859), new Vsop87.LnVsop(1.9304E-7, 5.93982202636, 425.1137181677), new Vsop87.LnVsop(1.4514E-7, 2.75049388379, 1.2238402774), new Vsop87.LnVsop(1.4577E-7, 5.18679424151, 305.3461693927), new Vsop87.LnVsop(1.4254E-7, 3.88076623214, 54.1746707478), new Vsop87.LnVsop(1.4586E-7, 3.24988127841, 78.7137518304), new Vsop87.LnVsop(1.367E-7, 2.55602680997, 405.2575498736), new Vsop87.LnVsop(1.3912E-7, 1.72287975369, 69.1525242748), new Vsop87.LnVsop(1.3689E-7, 2.37432937754, 125.9873238985), new Vsop87.LnVsop(1.3434E-7, 0.83488320765, 99.9113804809), new Vsop87.LnVsop(1.3835E-7, 6.18875441195, 245.5424243524), new Vsop87.LnVsop(1.8486E-7, 0.73172908046, 9999.986450773), new Vsop87.LnVsop(1.3544E-7, 3.58586392379, 234.6397364404), new Vsop87.LnVsop(1.7441E-7, 0.23802704474, 134.5853436076), new Vsop87.LnVsop(1.6882E-7, 0.72758125023, 2111.6503133776), new Vsop87.LnVsop(1.418E-7, 4.51956561605, 59.8037450403), new Vsop87.LnVsop(1.3598E-7, 2.53775710444, 1.6969210294), new Vsop87.LnVsop(1.2237E-7, 2.11959388836, 28.3111756513), new Vsop87.LnVsop(1.199E-7, 1.62127312922, 1361.5467058442), new Vsop87.LnVsop(1.1982E-7, 4.07445076924, 280.9671470045), new Vsop87.LnVsop(1.2757E-7, 5.31153889246, 344.7030453079), new Vsop87.LnVsop(1.6075E-7, 3.97061471646, 355.7487455718), new Vsop87.LnVsop(1.1427E-7, 5.51112367921, 192.6921676185), new Vsop87.LnVsop(1.3107E-7, 4.69154717483, 767.3690829208), new Vsop87.LnVsop(1.4712E-7, 3.29079681274, 1589.0728952838), new Vsop87.LnVsop(1.1417E-7, 1.81615806473, 2104.5367663768), new Vsop87.LnVsop(1.1631E-7, 2.79398246172, 362.8622925726), new Vsop87.LnVsop(1.3238E-7, 4.16610173164, 225.8292684102), new Vsop87.LnVsop(1.0596E-7, 5.50455161216, 199.2844497575), new Vsop87.LnVsop(1.0558E-7, 3.57501718639, 1.4362885985), new Vsop87.LnVsop(1.0487E-7, 2.84545452542, 85.8272988312), new Vsop87.LnVsop(1.0296E-7, 0.22213213548, 198.321241911), new Vsop87.LnVsop(1.0552E-7, 0.18714408691, 217.491881132), new Vsop87.LnVsop(1.1853E-7, 0.11583647552, 7.6348118626), new Vsop87.LnVsop(1.0248E-7, 0.21860767654, 144.1465711632), new Vsop87.LnVsop(1.0388E-7, 1.68706377306, 31.019488637), new Vsop87.LnVsop(1.0298E-7, 4.72105283737, 216.2198567448), new Vsop87.LnVsop(1.0718E-7, 2.6086621806, 339.2864193365), new Vsop87.LnVsop(9.68E-8, 3.66617781358, 212.5483359126), new Vsop87.LnVsop(9.686E-8, 0.41563892555, 2634.2277314714), new Vsop87.LnVsop(9.606E-8, 3.34180429839, 223.5940361765), new Vsop87.LnVsop(9.88E-8, 4.01876851049, 207.1487562837), new Vsop87.LnVsop(1.3227E-7, 6.00697508523, 214.7835681463), new Vsop87.LnVsop(1.1346E-7, 2.61894580651, 7.8643065262), new Vsop87.LnVsop(9.158E-8, 5.39847150076, 342.2553647531), new Vsop87.LnVsop(1.1882E-7, 4.00177866802, 267.4737661858), new Vsop87.LnVsop(1.2076E-7, 3.59957096236, 124.433415221), new Vsop87.LnVsop(8.905E-8, 4.22810786842, 6.3627874754), new Vsop87.LnVsop(1.0136E-7, 3.60824178626, 14.0146456805), new Vsop87.LnVsop(9.194E-8, 0.71906399877, 347.8844390456), new Vsop87.LnVsop(1.0529E-7, 2.36775276401, 831.1049812242), new Vsop87.LnVsop(8.574E-8, 4.48725894302, 1692.1656695024), new Vsop87.LnVsop(1.0251E-7, 3.93334219207, 207.8824694666), new Vsop87.LnVsop(9.179E-8, 4.28183918668, 312.4597163935), new Vsop87.LnVsop(8.088E-8, 0.8122012839, 264.5048207692), new Vsop87.LnVsop(9.228E-8, 4.2641599781, 20.6069278195), new Vsop87.LnVsop(9.607E-8, 0.64286774221, 218.9281697305), new Vsop87.LnVsop(8.675E-8, 0.48616033737, 1574.8458012822), new Vsop87.LnVsop(7.927E-8, 4.71998972854, 333.657345044), new Vsop87.LnVsop(8.927E-8, 0.90701584499, 497.4476361802), new Vsop87.LnVsop(7.934E-8, 2.7328054354, 4.1446015842), new Vsop87.LnVsop(9.133E-8, 5.08251865324, 241.6102710893), new Vsop87.LnVsop(8.885E-8, 5.55498151216, 2847.5268269094), new Vsop87.LnVsop(9.639E-8, 1.60623316904, 0.8937718773), new Vsop87.LnVsop(8.926E-8, 5.8085514369, 329.7251917809), new Vsop87.LnVsop(7.233E-8, 0.60129637991, 206.233732547), new Vsop87.LnVsop(7.655E-8, 5.53681474398, 116.4260963429), new Vsop87.LnVsop(7.537E-8, 5.43686778771, 621.7380390493), new Vsop87.LnVsop(7.118E-8, 0.18742612368, 209.106309744), new Vsop87.LnVsop(8.834E-8, 5.3609073415, 343.2185725996), new Vsop87.LnVsop(7.056E-8, 0.41899430952, 756.3233826569), new Vsop87.LnVsop(8.128E-8, 4.05572601077, 237.6781178262), new Vsop87.LnVsop(8.949E-8, 1.65024350785, 210.3301500214), new Vsop87.LnVsop(6.962E-8, 3.17856271724, 543.0242872189), new Vsop87.LnVsop(8.917E-8, 0.56506143275, 2428.0421830342), new Vsop87.LnVsop(6.918E-8, 3.66850644263, 247.2393453818), new Vsop87.LnVsop(8.989E-8, 4.25044698859, 46.470422916), new Vsop87.LnVsop(7.094E-8, 5.14244381046, 231.4583427027), new Vsop87.LnVsop(7.372E-8, 1.25037224558, 217.964961884), new Vsop87.LnVsop(6.355E-8, 0.82409971051, 31.492569389), new Vsop87.LnVsop(7.562E-8, 5.62661243268, 518.6452648307), new Vsop87.LnVsop(6.911E-8, 3.70119674288, 206.1373643274), new Vsop87.LnVsop(7.015E-8, 2.84101112991, 1148.2476104062), new Vsop87.LnVsop(6.748E-8, 4.56542342874, 120.358249606), new Vsop87.LnVsop(6.281E-8, 5.79091493667, 179.3588454942), new Vsop87.LnVsop(6.275E-8, 3.53628080965, 244.318584075), new Vsop87.LnVsop(5.815E-8, 1.40677827798, 214.0498549634), new Vsop87.LnVsop(5.87E-8, 4.86690383052, 320.3240229197), new Vsop87.LnVsop(6.217E-8, 1.07999162981, 251.4321310758), new Vsop87.LnVsop(7.735E-8, 3.82203922745, 380.12776796), new Vsop87.LnVsop(5.718E-8, 1.34924759084, 1677.9385755008), new Vsop87.LnVsop(6.455E-8, 1.34715012955, 188.9200730498), new Vsop87.LnVsop(6.105E-8, 3.62445388144, 1169.5882514086), new Vsop87.LnVsop(5.646E-8, 2.28659477016, 20.4468691251), new Vsop87.LnVsop(5.804E-8, 1.54857952361, 2420.9286360334), new Vsop87.LnVsop(5.94E-8, 1.65973782972, 842.1506814881), new Vsop87.LnVsop(5.593E-8, 0.50496981495, 148.0787244263), new Vsop87.LnVsop(5.703E-8, 5.0599706723, 2.9689454166), new Vsop87.LnVsop(6.496E-8, 1.93848779933, 357.4456666012), new Vsop87.LnVsop(6.369E-8, 2.44534144405, 654.1243803156), new Vsop87.LnVsop(7.44E-8, 1.35926163985, 166.828672522), new Vsop87.LnVsop(6.407E-8, 0.4068244104, 168.0525127994), new Vsop87.LnVsop(5.568E-8, 2.6953220399, 750.1036075334), new Vsop87.LnVsop(7.145E-8, 2.23105866128, 488.8496164711), new Vsop87.LnVsop(6.711E-8, 6.03818797147, 160.6088973985), new Vsop87.LnVsop(6.939E-8, 5.78359794712, 700.6642392008), new Vsop87.LnVsop(5.675E-8, 2.59531513404, 1.6445314027), new Vsop87.LnVsop(6.615E-8, 3.14048409935, 491.8185618877), new Vsop87.LnVsop(4.903E-8, 2.03902856851, 0.8031491521), new Vsop87.LnVsop(5.163E-8, 4.10008637563, 196.6243208816), new Vsop87.LnVsop(6.445E-8, 5.49855871291, 206.706813299), new Vsop87.LnVsop(4.984E-8, 2.96757082827, 258.8757464767), new Vsop87.LnVsop(5.935E-8, 1.81402138235, 252.6559713532), new Vsop87.LnVsop(6.195E-8, 5.01900946561, 273.1028404783), new Vsop87.LnVsop(5.957E-8, 3.32859235467, 182.279606801), new Vsop87.LnVsop(4.784E-8, 2.24574932417, 635.9651330509), new Vsop87.LnVsop(5.502E-8, 3.31422964456, 1905.4647649404), new Vsop87.LnVsop(5.102E-8, 3.98187445707, 254.9435932136), new Vsop87.LnVsop(5.213E-8, 0.53623981887, 135.5485514541), new Vsop87.LnVsop(4.624E-8, 0.04437884888, 213.1872208534), new Vsop87.LnVsop(5.95E-8, 0.54568184723, 51.2057253312), new Vsop87.LnVsop(4.546E-8, 0.14439151027, 2950.619601128), new Vsop87.LnVsop(4.775E-8, 3.16022842156, 28.5718080822), new Vsop87.LnVsop(4.624E-8, 4.73740665452, 213.4109700226), new Vsop87.LnVsop(4.755E-8, 1.12135253955, 6.2197751235), new Vsop87.LnVsop(5.73E-8, 0.04398674476, 348.8476468921), new Vsop87.LnVsop(4.334E-8, 2.67820804456, 81.7521332162), new Vsop87.LnVsop(4.538E-8, 3.83676862123, 487.3651437628), new Vsop87.LnVsop(5.589E-8, 3.63336808808, 248.7238180901), new Vsop87.LnVsop(4.1E-8, 3.3934435634, 50.4025761791), new Vsop87.LnVsop(5.656E-8, 3.59967152437, 282.4516197128), new Vsop87.LnVsop(5.145E-8, 1.33338899757, 173.6815870919), new Vsop87.LnVsop(3.886E-8, 4.11776461222, 213.5115437591), new Vsop87.LnVsop(3.886E-8, 0.66402089118, 213.0866471169), new Vsop87.LnVsop(4.462E-8, 0.0862682418, 905.8865797915), new Vsop87.LnVsop(4.935E-8, 2.19065724639, 189.7232222019), new Vsop87.LnVsop(3.96E-8, 1.60336432627, 218.7157214094), new Vsop87.LnVsop(3.739E-8, 3.30739598474, 274.0660483248), new Vsop87.LnVsop(3.807E-8, 0.26514954931, 636.7158925763), new Vsop87.LnVsop(5.254E-8, 3.75977292946, 3127.3133312618), new Vsop87.LnVsop(4.658E-8, 0.37534234779, 2744.4340526908), new Vsop87.LnVsop(3.684E-8, 5.11566742961, 458.8415197904), new Vsop87.LnVsop(3.737E-8, 2.56821327326, 546.956440482), new Vsop87.LnVsop(4.217E-8, 5.18269682223, 27.0873353739), new Vsop87.LnVsop(3.875E-8, 2.21675780973, 358.9301393095), new Vsop87.LnVsop(4.786E-8, 4.60614024001, 72.0732855816), new Vsop87.LnVsop(3.55E-8, 3.22934089351, 543.9180590962), new Vsop87.LnVsop(3.49E-8, 3.68860413802, 41.6444977756), new Vsop87.LnVsop(4.794E-8, 4.73551181492, 240.3864308119), new Vsop87.LnVsop(3.735E-8, 3.86571768678, 2008.557539159), new Vsop87.LnVsop(3.68E-8, 5.3665726111, 10.0343083076), new Vsop87.LnVsop(4.306E-8, 3.15625769753, 738.7972748386), new Vsop87.LnVsop(3.38E-8, 0.73199430789, 11.3063326948), new Vsop87.LnVsop(3.497E-8, 2.62462312872, 13.3333221243), new Vsop87.LnVsop(3.552E-8, 0.28968750645, 1891.2376709388), new Vsop87.LnVsop(3.605E-8, 4.69815639671, 295.0512286542), new Vsop87.LnVsop(3.61E-8, 6.25354930659, 129.9194771616), new Vsop87.LnVsop(3.333E-8, 5.04215642358, 153.4953503977), new Vsop87.LnVsop(3.837E-8, 5.31755531541, 3163.918696566), new Vsop87.LnVsop(3.263E-8, 5.59031570352, 2.0057375701), new Vsop87.LnVsop(4.021E-8, 2.37124549902, 176.6505325085), new Vsop87.LnVsop(4.12E-8, 5.4695653652, 6.9010986797), new Vsop87.LnVsop(3.247E-8, 1.7052376331, 235.3904959658), new Vsop87.LnVsop(3.696E-8, 4.07571730975, 969.6224780949), new Vsop87.LnVsop(3.939E-8, 4.26938238363, 181.806526049), new Vsop87.LnVsop(3.425E-8, 2.54883422278, 1464.6394800628), new Vsop87.LnVsop(3.85E-8, 5.48772352401, 37.8724032069), new Vsop87.LnVsop(3.321E-8, 6.05373085646, 9.4011688612), new Vsop87.LnVsop(3.04E-8, 2.38594161141, 221.3758502853), new Vsop87.LnVsop(3.462E-8, 5.81114445373, 13.4933808187), new Vsop87.LnVsop(2.979E-8, 4.14161019024, 66.70484372), new Vsop87.LnVsop(4.112E-8, 2.01009585863, 601.7642506762), new Vsop87.LnVsop(3.202E-8, 4.26949637598, 593.426863398), new Vsop87.LnVsop(2.921E-8, 4.76322755866, 213.5597278689), new Vsop87.LnVsop(2.934E-8, 1.83716438778, 501.3797894433), new Vsop87.LnVsop(3.602E-8, 0.14095035212, 552.5855147745), new Vsop87.LnVsop(3.258E-8, 4.44716335489, 60.7669528868), new Vsop87.LnVsop(3.747E-8, 5.2612891978, 561.1835344836), new Vsop87.LnVsop(2.921E-8, 0.01855836131, 213.0384630071), new Vsop87.LnVsop(2.981E-8, 5.12623240503, 205.6642835754), new Vsop87.LnVsop(2.969E-8, 0.7737388044, 17.5261078183), new Vsop87.LnVsop(3.987E-8, 0.76730729086, 424.1505103212), new Vsop87.LnVsop(2.804E-8, 1.07514216418, 1994.3304451574), new Vsop87.LnVsop(2.905E-8, 1.27184850848, 2737.32050569), new Vsop87.LnVsop(3.642E-8, 0.23263431318, 121.2520214833), new Vsop87.LnVsop(3.155E-8, 2.74978627621, 494.2662424425), new Vsop87.LnVsop(3.576E-8, 4.4982124348, 167.0893049529), new Vsop87.LnVsop(2.735E-8, 0.66893355408, 7.0016724162), new Vsop87.LnVsop(2.782E-8, 2.09895935688, 894.8408795276), new Vsop87.LnVsop(3.004E-8, 0.25953785005, 40.8413486235), new Vsop87.LnVsop(2.737E-8, 5.33066704009, 327.4375699205), new Vsop87.LnVsop(2.726E-8, 3.7514978311, 429.0458714308), new Vsop87.LnVsop(2.784E-8, 4.1756262967, 292.0128472684), new Vsop87.LnVsop(2.744E-8, 2.4134659999, 151.0476698429), new Vsop87.LnVsop(2.575E-8, 1.26282074105, 193.655375465), new Vsop87.LnVsop(2.616E-8, 4.81916423909, 681.5417840896), new Vsop87.LnVsop(2.538E-8, 3.78251096387, 1485.9801210652), new Vsop87.LnVsop(2.926E-8, 0.62372026398, 643.8294395771), new Vsop87.LnVsop(3.466E-8, 5.76060994071, 141.2258098564), new Vsop87.LnVsop(3.253E-8, 0.75622630094, 555.5544601911), new Vsop87.LnVsop(2.885E-8, 6.15831808835, 425.6349830295), new Vsop87.LnVsop(3.386E-8, 2.48152283756, 43.2890291783), new Vsop87.LnVsop(2.436E-8, 4.57894879527, 477.8039162072), new Vsop87.LnVsop(3.19E-8, 0.66177706026, 776.9303104764), new Vsop87.LnVsop(2.576E-8, 1.41578305216, 100.6450936638), new Vsop87.LnVsop(2.443E-8, 1.04510089705, 1279.794572628), new Vsop87.LnVsop(2.598E-8, 3.7305869515, 17.4084877393), new Vsop87.LnVsop(2.559E-8, 5.35988524657, 7.2254215854), new Vsop87.LnVsop(2.846E-8, 1.52684623695, 17.2654753874), new Vsop87.LnVsop(2.83E-8, 2.47231866942, 280.003939158), new Vsop87.LnVsop(2.455E-8, 2.74279373432, 172.2452984934), new Vsop87.LnVsop(3.203E-8, 4.10000274579, 618.5566453116), new Vsop87.LnVsop(2.96E-8, 3.96746610269, 650.9429865779), new Vsop87.LnVsop(2.286E-8, 0.18374210727, 426.6463749858), new Vsop87.LnVsop(2.719E-8, 2.7656368191, 45.5766510387), new Vsop87.LnVsop(2.653E-8, 0.14212412417, 162.8965192589), new Vsop87.LnVsop(3.118E-8, 2.80942514258, 2221.856634597), new Vsop87.LnVsop(2.288E-8, 3.26959753229, 426.5500067662), new Vsop87.LnVsop(2.349E-8, 4.24056039902, 113.3877149571), new Vsop87.LnVsop(2.54E-8, 5.57935398465, 381.3516082374), new Vsop87.LnVsop(2.77E-8, 4.36266517918, 130.4407420234), new Vsop87.LnVsop(2.164E-8, 5.43669210151, 630.3360587584), new Vsop87.LnVsop(3.003E-8, 3.71917411581, 228.276948965), new Vsop87.LnVsop(2.368E-8, 4.49216312171, 25.1297819136), new Vsop87.LnVsop(2.479E-8, 1.71731092969, 313.6835566709), new Vsop87.LnVsop(2.791E-8, 0.40226730686, 8.5980197091), new Vsop87.LnVsop(2.777E-8, 0.0650750656, 5856.4776591154), new Vsop87.LnVsop(2.071E-8, 2.40453395841, 16.4623262353), new Vsop87.LnVsop(2.051E-8, 6.19717541981, 3267.0114707846), new Vsop87.LnVsop(2.755E-8, 0.40055260057, 219.4494345923), new Vsop87.LnVsop(2.306E-8, 2.61456314387, 26.826702943), new Vsop87.LnVsop(1.974E-8, 2.1603379029, 746.9222137957), new Vsop87.LnVsop(2.056E-8, 0.71975258021, 472.1748419147), new Vsop87.LnVsop(1.949E-8, 3.13157993219, 226.6324175623), new Vsop87.LnVsop(2.373E-8, 3.44821539437, 241.8709035202), new Vsop87.LnVsop(2.172E-8, 1.41663830575, 23.5758732361), new Vsop87.LnVsop(2.314E-8, 2.92801925795, 170.7608257851), new Vsop87.LnVsop(2.408E-8, 1.55295728708, 112.6540017742), new Vsop87.LnVsop(2.239E-8, 4.31274272536, 556.5176680376), new Vsop87.LnVsop(2.082E-8, 4.33452809464, 210.5907824523), new Vsop87.LnVsop(1.879E-8, 2.14326068371, 135.336103133), new Vsop87.LnVsop(1.873E-8, 4.75518673767, 115.6229471908), new Vsop87.LnVsop(2.309E-8, 0.11732366204, 3060.8259223474), new Vsop87.LnVsop(1.938E-8, 5.6382161253, 454.9093665273), new Vsop87.LnVsop(1.832E-8, 0.64631637571, 181.0557665236), new Vsop87.LnVsop(1.868E-8, 5.70976107774, 19.1224551112), new Vsop87.LnVsop(2.117E-8, 0.44726902093, 216.0074084237), new Vsop87.LnVsop(1.807E-8, 6.1542731617, 5.8415226136), new Vsop87.LnVsop(2.249E-8, 3.36716140568, 696.5196376166), new Vsop87.LnVsop(2.212E-8, 3.42279313426, 533.6231183577), new Vsop87.LnVsop(2.419E-8, 3.29356384047, 569.0478410098), new Vsop87.LnVsop(1.87E-8, 0.06477042691, 436.1594184316), new Vsop87.LnVsop(1.853E-8, 3.90470835472, 220.364458329), new Vsop87.LnVsop(1.759E-8, 0.94203956471, 213.4591541324), new Vsop87.LnVsop(1.91E-8, 3.72525967039, 104.0559820651), new Vsop87.LnVsop(1.759E-8, 3.83975218378, 213.1390367436), new Vsop87.LnVsop(1.743E-8, 2.21262997019, 416.3032501375), new Vsop87.LnVsop(1.873E-8, 1.42763846972, 16.6747745564), new Vsop87.LnVsop(2.146E-8, 4.41413968676, 184.0941479094), new Vsop87.LnVsop(1.737E-8, 0.82318971745, 220.4608265486), new Vsop87.LnVsop(1.715E-8, 0.26599994417, 103.1409583284), new Vsop87.LnVsop(2.079E-8, 3.85808396012, 672.1406152284), new Vsop87.LnVsop(1.863E-8, 4.68604777727, 286.596221297), new Vsop87.LnVsop(1.904E-8, 5.30834458331, 405.9912630565), new Vsop87.LnVsop(2.24E-8, 3.02208358469, 105.5404547734), new Vsop87.LnVsop(1.861E-8, 2.26358723734, 1781.0313497194), new Vsop87.LnVsop(1.633E-8, 0.16030477876, 18.9100067901), new Vsop87.LnVsop(2.116E-8, 2.90219103589, 486.4019359163), new Vsop87.LnVsop(1.789E-8, 5.08244147798, 731.9443602687), new Vsop87.LnVsop(2.198E-8, 3.88171991657, 427.5613987225), new Vsop87.LnVsop(1.63E-8, 5.33964027212, 418.5214360287), new Vsop87.LnVsop(1.706E-8, 3.35212116331, 103.0445901088), new Vsop87.LnVsop(1.604E-8, 2.48961496337, 55.6591434561), new Vsop87.LnVsop(1.574E-8, 6.10208401892, 106.0135355254), new Vsop87.LnVsop(1.744E-8, 1.83781933542, 1044.4040766622), new Vsop87.LnVsop(2.078E-8, 6.03488501179, 916.9322800554), new Vsop87.LnVsop(1.697E-8, 3.52606534347, 627.3671133418), new Vsop87.LnVsop(1.998E-8, 4.65407827221, 353.301065017), new Vsop87.LnVsop(1.725E-8, 1.49594317534, 25.8634950965), new Vsop87.LnVsop(1.765E-8, 5.14792752968, 107.2855599126), new Vsop87.LnVsop(1.554E-8, 1.11927446344, 230.8252032563), new Vsop87.LnVsop(1.654E-8, 6.0187100123, 77.962992305), new Vsop87.LnVsop(1.486E-8, 0.80594519287, 2310.722314814), new Vsop87.LnVsop(1.846E-8, 0.02334047107, 102.1295663721), new Vsop87.LnVsop(1.528E-8, 1.00286132704, 3053.7123753466), new Vsop87.LnVsop(1.477E-8, 4.25171290737, 194.1766403268), new Vsop87.LnVsop(1.529E-8, 5.58893570501, 212.0270710508), new Vsop87.LnVsop(1.686E-8, 5.08403152624, 3480.3105662226), new Vsop87.LnVsop(1.884E-8, 3.62471460828, 204.7010757289), new Vsop87.LnVsop(1.885E-8, 3.29608219905, 2324.9494088156), new Vsop87.LnVsop(1.529E-8, 5.47660937647, 214.5711198252), new Vsop87.LnVsop(1.392E-8, 2.27890229097, 403.0223176399), new Vsop87.LnVsop(1.541E-8, 2.06818136546, 36.6485629295), new Vsop87.LnVsop(1.446E-8, 6.04094616943, 165.6048322446), new Vsop87.LnVsop(1.924E-8, 1.37067955741, 468.2426886516), new Vsop87.LnVsop(1.427E-8, 0.13207926609, 2207.6295405954), new Vsop87.LnVsop(1.371E-8, 3.34466996039, 93.531546663), new Vsop87.LnVsop(1.368E-8, 1.63092978466, 629.6023455755), new Vsop87.LnVsop(1.376E-8, 5.36960481264, 180.1619946463), new Vsop87.LnVsop(1.376E-8, 2.32437962529, 721.6494195302), new Vsop87.LnVsop(1.574E-8, 0.85824745087, 271.4059194489), new Vsop87.LnVsop(1.652E-8, 5.34399182698, 835.0371344873), new Vsop87.LnVsop(1.395E-8, 5.68950292442, 25.2727942655), new Vsop87.LnVsop(1.539E-8, 5.48277268478, 391.1734682239), new Vsop87.LnVsop(1.356E-8, 2.22997055118, 643.0786800517), new Vsop87.LnVsop(1.761E-8, 3.58954066417, 508.3503240922), new Vsop87.LnVsop(1.597E-8, 3.04206255741, 42.5382696529), new Vsop87.LnVsop(1.39E-8, 4.55010436102, 426.0769260142), new Vsop87.LnVsop(1.369E-8, 2.91645695847, 447.9388318784), new Vsop87.LnVsop(1.303E-8, 1.82744175272, 1382.8873468466), new Vsop87.LnVsop(1.282E-8, 4.26450378358, 123.5396433437), new Vsop87.LnVsop(1.258E-8, 3.0113538462, 409.9234163196), new Vsop87.LnVsop(1.466E-8, 1.84480396294, 289.5651667136), new Vsop87.LnVsop(1.718E-8, 5.697475944, 22.8945496799), new Vsop87.LnVsop(1.272E-8, 4.39843475366, 558.0021407459), new Vsop87.LnVsop(1.348E-8, 3.87460263816, 1802.3719907218), new Vsop87.LnVsop(1.321E-8, 0.07205905057, 411.620337349), new Vsop87.LnVsop(1.223E-8, 4.07454753623, 28.4541880032), new Vsop87.LnVsop(1.565E-8, 2.32965370903, 41.0537969446), new Vsop87.LnVsop(1.648E-8, 6.06315403714, 268.4369740323), new Vsop87.LnVsop(1.367E-8, 5.8304586755, 1108.1399749656), new Vsop87.LnVsop(1.202E-8, 3.07875838575, 420.9691165835), new Vsop87.LnVsop(1.238E-8, 5.25936845912, 412.5835451955), new Vsop87.LnVsop(1.22E-8, 3.92987038126, 2.6601288759), new Vsop87.LnVsop(1.552E-8, 1.48184058623, 9786.687355335), new Vsop87.LnVsop(1.288E-8, 5.0933444995, 427.1194557378), new Vsop87.LnVsop(1.131E-8, 5.39248376531, 423.6774295692), new Vsop87.LnVsop(1.21E-8, 1.45847814907, 291.262087743), new Vsop87.LnVsop(1.121E-8, 3.86569300942, 1033.3583763983), new Vsop87.LnVsop(1.314E-8, 1.4762363867, 1073.6090241908), new Vsop87.LnVsop(1.165E-8, 4.0997657184, 685.4739373527), new Vsop87.LnVsop(1.34E-8, 2.51007561607, 421.93232443), new Vsop87.LnVsop(1.307E-8, 0.11221972956, 71.8126531507), new Vsop87.LnVsop(1.265E-8, 0.90565355476, 778.4147831847), new Vsop87.LnVsop(1.438E-8, 2.5773503339, 100.3844612329), new Vsop87.LnVsop(1.19E-8, 5.63379509659, 5.1078094307), new Vsop87.LnVsop(1.099E-8, 0.15185327787, 820.0592809603), new Vsop87.LnVsop(1.289E-8, 5.20598956623, 278.2588340188), new Vsop87.LnVsop(1.081E-8, 5.18890270804, 313.2104759189), new Vsop87.LnVsop(1.233E-8, 2.70202819383, 282.6640680339), new Vsop87.LnVsop(1.205E-8, 4.01989274918, 980.6681783588), new Vsop87.LnVsop(1.153E-8, 5.01183625908, 230.5645708254), new Vsop87.LnVsop(1.4E-8, 2.58587010058, 2538.2485042536), new Vsop87.LnVsop(1.022E-8, 1.11289664927, 69.3649725959), new Vsop87.LnVsop(1.255E-8, 2.46286000363, 457.617679513), new Vsop87.LnVsop(1.076E-8, 2.39117465097, 48.7580447764), new Vsop87.LnVsop(1.19E-8, 6.18490188091, 3377.217792004), new Vsop87.LnVsop(1.204E-8, 4.09186978258, 525.7588118315), new Vsop87.LnVsop(9.9E-9, 5.94952240765, 3583.4033404412), new Vsop87.LnVsop(1.005E-8, 5.21278239561, 319.3126309634), new Vsop87.LnVsop(9.71E-9, 4.25395254634, 397.3932433474), new Vsop87.LnVsop(9.91E-9, 0.03591482796, 140.9651774255), new Vsop87.LnVsop(9.68E-9, 5.67985317617, 422.405405182), new Vsop87.LnVsop(1.3E-8, 1.34580694314, 875.830299001), new Vsop87.LnVsop(1.19E-8, 0.67902660568, 699.7010313543), new Vsop87.LnVsop(9.66E-9, 1.7726740163, 67.6680515665), new Vsop87.LnVsop(9.5E-9, 2.66974427113, 92.3077063856), new Vsop87.LnVsop(9.33E-9, 0.62979417948, 406.954470903), new Vsop87.LnVsop(1.027E-8, 1.95953557809, 2097.423219376), new Vsop87.LnVsop(1.184E-8, 3.7009496731, 285.6330134505), new Vsop87.LnVsop(9.48E-9, 0.92585793863, 143.9341228421), new Vsop87.LnVsop(1.048E-8, 3.69648624644, 117.9105690512), new Vsop87.LnVsop(1.201E-8, 4.22453841439, 219.891377577), new Vsop87.LnVsop(1.15E-8, 2.53520366594, 104.5772469269), new Vsop87.LnVsop(1.258E-8, 2.516341869, 694.0719570618), new Vsop87.LnVsop(9.4E-9, 3.94701776697, 35.212274331), new Vsop87.LnVsop(1.181E-8, 5.26563174373, 638.4128136057), new Vsop87.LnVsop(1.047E-8, 6.12360979462, 238.9019581036), new Vsop87.LnVsop(9.59E-9, 5.19545703649, 240.125798381), new Vsop87.LnVsop(8.88E-9, 2.16687798409, 739.8086667949), new Vsop87.LnVsop(9.1E-9, 6.12673330424, 616.3214130779), new Vsop87.LnVsop(1.179E-8, 1.71786905567, 691.1030116452), new Vsop87.LnVsop(8.93E-9, 0.95364488395, 14.8177948326), new Vsop87.LnVsop(9.44E-9, 3.4761530994, 443.8636662634), new Vsop87.LnVsop(8.75E-9, 0.58638080067, 2.2876218604), new Vsop87.LnVsop(9.92E-9, 3.17301353403, 337.732510659), new Vsop87.LnVsop(8.42E-9, 3.90433125703, 331.2096644892), new Vsop87.LnVsop(1.055E-8, 3.94158533336, 945.2434557067), new Vsop87.LnVsop(8.48E-9, 3.18251107437, 196.0336200506), new Vsop87.LnVsop(1.043E-8, 3.87748523839, 532.6117264014), new Vsop87.LnVsop(1.021E-8, 2.93082353478, 184.9879197867), new Vsop87.LnVsop(8.2E-9, 1.01398728276, 480.7728616238), new Vsop87.LnVsop(1.076E-8, 3.28234305253, 5.6772584023), new Vsop87.LnVsop(9.65E-9, 2.88516068358, 211.6021744086), new Vsop87.LnVsop(8.4E-9, 5.37879523628, 97.6761482472), new Vsop87.LnVsop(8.08E-9, 2.78227865695, 212.0752551606), new Vsop87.LnVsop(8.03E-9, 0.77782236251, 724.8308132679), new Vsop87.LnVsop(8.39E-9, 3.54633464957, 421.1815649046), new Vsop87.LnVsop(8.06E-9, 0.91687463872, 108.7218485111), new Vsop87.LnVsop(8.08E-9, 2.21175862312, 610.6923387854), new Vsop87.LnVsop(8.08E-9, 2.00008111736, 214.5229357154), new Vsop87.LnVsop(7.97E-9, 2.64685759248, 436.8931316145), new Vsop87.LnVsop(7.91E-9, 2.35474255596, 1.3725981237), new Vsop87.LnVsop(1.001E-8, 2.34471240227, 16.04163511), new Vsop87.LnVsop(9.93E-9, 0.63704559422, 84.9335269539), new Vsop87.LnVsop(8.18E-9, 5.65861039653, 662.531203563), new Vsop87.LnVsop(9.8E-9, 2.62928231216, 395.578702239), new Vsop87.LnVsop(1.022E-8, 2.72113505557, 268.9582388941), new Vsop87.LnVsop(8.67E-9, 1.60229563173, 19.643719973), new Vsop87.LnVsop(7.68E-9, 5.25077200882, 305.0855369618), new Vsop87.LnVsop(8.94E-9, 1.48955357147, 760.25553592), new Vsop87.LnVsop(8.9E-9, 0.12712803242, 238.4288773516), new Vsop87.LnVsop(9.06E-9, 3.36915692315, 526.5095713569), new Vsop87.LnVsop(9.32E-9, 2.83616864072, 2641.3412784722), new Vsop87.LnVsop(8.08E-9, 5.23759255093, 216.2680408546), new Vsop87.LnVsop(7.33E-9, 0.56621977741, 2627.1141844706), new Vsop87.LnVsop(7.98E-9, 3.72376709468, 124.5028511902), new Vsop87.LnVsop(8.47E-9, 2.03085858041, 511.5317178299), new Vsop87.LnVsop(9.08E-9, 0.27377388936, 710.7467316182), new Vsop87.LnVsop(7.53E-9, 0.72727486508, 3370.1042450032), new Vsop87.LnVsop(7.95E-9, 0.27912881638, 101.8689339412), new Vsop87.LnVsop(7.85E-9, 1.63053749655, 465.9550667912), new Vsop87.LnVsop(7.52E-9, 4.77248612283, 102.5715093568), new Vsop87.LnVsop(7.18E-9, 1.61123765583, 159.1244246902), new Vsop87.LnVsop(8.04E-9, 2.07376802341, 114.3991069134), new Vsop87.LnVsop(7.9E-9, 4.48898079269, 444.7574381407), new Vsop87.LnVsop(8.06E-9, 1.2004032767, 570.7447620392), new Vsop87.LnVsop(8.34E-9, 4.3006674639, 453.424893819), new Vsop87.LnVsop(9.11E-9, 5.04625406846, 913.9633346388), new Vsop87.LnVsop(8.6E-9, 2.78958557006, 495.7507151508), new Vsop87.LnVsop(6.88E-9, 1.10207467005, 1.536862335), new Vsop87.LnVsop(7.44E-9, 3.54097534054, 1182.9215735329), new Vsop87.LnVsop(8.17E-9, 3.77746249152, 2118.7638603784), new Vsop87.LnVsop(7.63E-9, 2.56122272197, 418.0001711669), new Vsop87.LnVsop(8.58E-9, 3.50137925405, 439.1283638482), new Vsop87.LnVsop(6.97E-9, 1.84993135386, 72.3339180125), new Vsop87.LnVsop(6.84E-9, 3.93924645159, 337.8019466282), new Vsop87.LnVsop(7.16E-9, 6.18909857064, 310.7146112543), new Vsop87.LnVsop(9.22E-9, 1.70582310864, 125.1841747464), new Vsop87.LnVsop(8.81E-9, 1.69931467623, 6283.0758499914), new Vsop87.LnVsop(6.58E-9, 0.03671701039, 2524.021410252), new Vsop87.LnVsop(7.42E-9, 1.91529584654, 214.9960164674), new Vsop87.LnVsop(6.56E-9, 1.28143991756, 432.0148168474), new Vsop87.LnVsop(8.47E-9, 4.57879676752, 624.919432787), new Vsop87.LnVsop(8.53E-9, 3.03999967701, 298.2326223919), new Vsop87.LnVsop(7.33E-9, 5.8679490019, 938.1299087059), new Vsop87.LnVsop(6.67E-9, 2.19812773242, 576.1613880106), new Vsop87.LnVsop(8.09E-9, 1.62224980069, 299.1263942692), new Vsop87.LnVsop(6.65E-9, 1.63005583526, 221.1634019642), new Vsop87.LnVsop(6.31E-9, 2.01204905117, 58.1068240109), new Vsop87.LnVsop(8.04E-9, 5.94281804567, 26.0235537909), new Vsop87.LnVsop(6.79E-9, 2.11784460945, 256.4280659219), new Vsop87.LnVsop(7.31E-9, 1.95762888351, 19.0105805266), new Vsop87.LnVsop(7.86E-9, 0.91251218885, 518.3846323998), new Vsop87.LnVsop(6.83E-9, 4.89269007977, 3796.7024358792), new Vsop87.LnVsop(7.18E-9, 4.15300342275, 909.8187330546), new Vsop87.LnVsop(6.11E-9, 2.08393662004, 1038.0412891868), new Vsop87.LnVsop(6.25E-9, 4.05845324358, 429.5189521828), new Vsop87.LnVsop(6.92E-9, 4.7196673251, 1048.3362299253), new Vsop87.LnVsop(8.28E-9, 0.31672617003, 25.6028626656), new Vsop87.LnVsop(5.88E-9, 1.95775535435, 211.8628068395), new Vsop87.LnVsop(8.16E-9, 4.1045943469, 141.4864422873), new Vsop87.LnVsop(5.88E-9, 2.82460441996, 214.7353840365), new Vsop87.LnVsop(6.61E-9, 5.2828848136, 103.6140390804), new Vsop87.LnVsop(7.68E-9, 5.28051245446, 428.0826635843), new Vsop87.LnVsop(6.57E-9, 2.58191098926, 526.9826521089), new Vsop87.LnVsop(6.49E-9, 5.56200025375, 393.4610900843), new Vsop87.LnVsop(6.29E-9, 5.97635563917, 188.0263011725), new Vsop87.LnVsop(7.53E-9, 1.90904368126, 25874.6040461362), new Vsop87.LnVsop(7.48E-9, 5.44697890119, 220.9339073006), new Vsop87.LnVsop(7.33E-9, 2.9576302243, 606.7601855223), new Vsop87.LnVsop(7.44E-9, 1.0748603061, 239.1625905345), new Vsop87.LnVsop(5.91E-9, 2.37128962566, 205.4347889118), new Vsop87.LnVsop(6.11E-9, 2.87854337819, 460.5384408198), new Vsop87.LnVsop(5.35E-9, 5.80500022712, 100.1720129118), new Vsop87.LnVsop(5.53E-9, 5.75044544607, 430.79097657), new Vsop87.LnVsop(5.43E-9, 3.42480625305, 597.3590166611), new Vsop87.LnVsop(6.86E-9, 0.66246572964, 953.1077622329), new Vsop87.LnVsop(6.8E-9, 6.15131458182, 432.2272651685), new Vsop87.LnVsop(5.5E-9, 2.22246008421, 92.7978334801), new Vsop87.LnVsop(6.48E-9, 2.33387623043, 30.7588562061), new Vsop87.LnVsop(6.18E-9, 4.106803313, 505.3119427064), new Vsop87.LnVsop(5.2E-9, 2.67035391622, 262.0571402144), new Vsop87.LnVsop(5.13E-9, 3.04159909875, 425.8474313506), new Vsop87.LnVsop(5.64E-9, 1.70404561569, 2413.8150890326), new Vsop87.LnVsop(5.31E-9, 2.17713708436, 263.0203480609), new Vsop87.LnVsop(5.78E-9, 3.31462999801, 33.7278016227), new Vsop87.LnVsop(5.02E-9, 4.4695116808, 343.7398374614), new Vsop87.LnVsop(5.02E-9, 2.10975368391, 319.5732633943), new Vsop87.LnVsop(5.16E-9, 1.42008175574, 1246.6574718363), new Vsop87.LnVsop(5.24E-9, 5.78873025919, 366.7944458357), new Vsop87.LnVsop(5.51E-9, 5.70618089893, 1119.1856752295), new Vsop87.LnVsop(4.97E-9, 3.85720033517, 850.0149880143), new Vsop87.LnVsop(5.11E-9, 1.98874585808, 958.576777831), new Vsop87.LnVsop(6.19E-9, 2.38199178019, 2854.6403739102), new Vsop87.LnVsop(5.52E-9, 3.64343336935, 256.5881246163), new Vsop87.LnVsop(6.22E-9, 1.86517305535, 524.0137066923), new Vsop87.LnVsop(5.31E-9, 2.81862554182, 227.3137411185), new Vsop87.LnVsop(4.93E-9, 4.6338094582, 384.0599212231), new Vsop87.LnVsop(4.8E-9, 5.3368242512, 29.2049475286), new Vsop87.LnVsop(5.78E-9, 5.89620504304, 3693.6096616606), new Vsop87.LnVsop(5.92E-9, 3.23373539743, 824.7421937488), new Vsop87.LnVsop(5.26E-9, 4.17768461979, 136.0698163159), new Vsop87.LnVsop(5.14E-9, 2.31169637126, 2957.7331481288), new Vsop87.LnVsop(6.11E-9, 4.56245943434, 774.4826299216), new Vsop87.LnVsop(4.82E-9, 2.02179864928, 1063.3140834523), new Vsop87.LnVsop(4.71E-9, 5.57017731512, 1171.875873269), new Vsop87.LnVsop(5.27E-9, 4.00342741707, 2435.155730035), new Vsop87.LnVsop(6.43E-9, 3.24713673017, 67.8804998876), new Vsop87.LnVsop(5.24E-9, 4.72613379833, 336.8387387817), new Vsop87.LnVsop(4.67E-9, 3.48891086991, 219.6618829134), new Vsop87.LnVsop(4.7E-9, 1.4929638171, 849.2642284889), new Vsop87.LnVsop(4.95E-9, 5.95822960452, 765.8846102125), new Vsop87.LnVsop(4.63E-9, 6.097803226, 54.3347294422), new Vsop87.LnVsop(5.14E-9, 5.00485530287, 273.8536000037), new Vsop87.LnVsop(4.57E-9, 5.55952771886, 3899.7952100978), new Vsop87.LnVsop(4.47E-9, 1.87280713595, 62.038977274), new Vsop87.LnVsop(4.7E-9, 2.97782717732, 306.830642101), new Vsop87.LnVsop(5.52E-9, 0.65842795395, 315.1680293792), new Vsop87.LnVsop(4.99E-9, 1.92816937061, 217.4436970222), new Vsop87.LnVsop(5.18E-9, 1.75253765929, 867.4234757536), new Vsop87.LnVsop(5.17E-9, 3.53711999444, 233.9060232575), new Vsop87.LnVsop(5.54E-9, 1.28959719818, 133.1008708993), new Vsop87.LnVsop(5.62E-9, 3.72609171835, 934.9485149682), new Vsop87.LnVsop(5.63E-9, 2.99951491306, 170.0100662597), new Vsop87.LnVsop(4.47E-9, 6.04404377845, 141.6988906084), new Vsop87.LnVsop(4.47E-9, 5.83596703375, 823.9914342234), new Vsop87.LnVsop(4.68E-9, 3.87435857327, 320.5846553506), new Vsop87.LnVsop(5.37E-9, 0.85582040261, 214.1928673153), new Vsop87.LnVsop(4.42E-9, 2.80002649672, 209.1544938538), new Vsop87.LnVsop(5.56E-9, 2.28527743564, 810.6581120991), new Vsop87.LnVsop(4.43E-9, 4.31061989755, 9992.8729037722), new Vsop87.LnVsop(5.73E-9, 5.47590213541, 376.1956146969), new Vsop87.LnVsop(4.88E-9, 0.35817136383, 36.9091953604), new Vsop87.LnVsop(4.98E-9, 0.19856617778, 450.9772132642), new Vsop87.LnVsop(4.57E-9, 0.44937757211, 431.264057322), new Vsop87.LnVsop(4.83E-9, 3.92979214854, 39.6175083461), new Vsop87.LnVsop(4.67E-9, 1.89153069484, 30.0562807905), new Vsop87.LnVsop(4.28E-9, 5.7854978949, 491.5579294568), new Vsop87.LnVsop(4.1E-9, 4.94157240067, 306.0969289181), new Vsop87.LnVsop(4.1E-9, 5.52148731043, 118.0706277456), new Vsop87.LnVsop(4.31E-9, 4.30068740031, 88.1149206916), new Vsop87.LnVsop(4.86E-9, 1.24507986579, 107.7586406646), new Vsop87.LnVsop(4.68E-9, 3.66040999717, 988.532484885), new Vsop87.LnVsop(4.18E-9, 1.40296106325, 313.9441891018), new Vsop87.LnVsop(4.83E-9, 4.50050476783, 46.2097904851), new Vsop87.LnVsop(4.37E-9, 0.86746182155, 170.9732741062), new Vsop87.LnVsop(4.81E-9, 1.80728434905, 43.1289704839), new Vsop87.LnVsop(3.98E-9, 2.91337006854, 131.5469622218), new Vsop87.LnVsop(5.29E-9, 3.74604329884, 699.1797664925), new Vsop87.LnVsop(5.45E-9, 2.97416609047, 305.6068018236), new Vsop87.LnVsop(5.37E-9, 2.53257235538, 952.0963702766), new Vsop87.LnVsop(4.12E-9, 3.81964618636, 84.3428261229), new Vsop87.LnVsop(3.91E-9, 2.42357051081, 295.1942410061), new Vsop87.LnVsop(4.92E-9, 0.69476260355, 328.2407190726), new Vsop87.LnVsop(3.9E-9, 1.37349719402, 945.9942152321), new Vsop87.LnVsop(4.43E-9, 1.09570138382, 963.4027029714), new Vsop87.LnVsop(4.72E-9, 2.413318134, 838.218528225), new Vsop87.LnVsop(5.19E-9, 3.12248135009, 10213.285546211), new Vsop87.LnVsop(4.94E-9, 4.63690152976, 301.4140161296), new Vsop87.LnVsop(5.37E-9, 3.9265393717, 212.4053235607), new Vsop87.LnVsop(4.14E-9, 2.59696973215, 121.8427223143), new Vsop87.LnVsop(3.79E-9, 4.885212942, 775.233389447), new Vsop87.LnVsop(4.77E-9, 1.66086029667, 175.4266922311), new Vsop87.LnVsop(4.58E-9, 5.15052595883, 960.2213092337), new Vsop87.LnVsop(4.61E-9, 3.55548515746, 71.6002048296), new Vsop87.LnVsop(3.72E-9, 0.33222550941, 2943.5060541272), new Vsop87.LnVsop(4.57E-9, 4.45882272299, 33.1371007917), new Vsop87.LnVsop(4.76E-9, 3.63257697985, 20.4950532349), new Vsop87.LnVsop(3.98E-9, 4.38336031417, 739.0579072695), new Vsop87.LnVsop(3.66E-9, 1.53633889734, 369.0820676961), new Vsop87.LnVsop(3.81E-9, 0.82643132982, 229.9738699944), new Vsop87.LnVsop(3.76E-9, 2.94742828993, 6062.6632075526), new Vsop87.LnVsop(3.83E-9, 1.84135490966, 346.3999663373), new Vsop87.LnVsop(3.66E-9, 4.24140062871, 541.5398145106), new Vsop87.LnVsop(3.66E-9, 2.04993663405, 87.3117715395), new Vsop87.LnVsop(3.67E-9, 1.55348491072, 754.8389099486), new Vsop87.LnVsop(4.4E-9, 6.2718629278, 378.9039276826), new Vsop87.LnVsop(4.07E-9, 2.5483596634, 732.6951197941), new Vsop87.LnVsop(4.97E-9, 5.69945820916, 562.1467423301), new Vsop87.LnVsop(3.67E-9, 5.72103354739, 96.8729990951), new Vsop87.LnVsop(3.7E-9, 5.65930804475, 89.7594520943), new Vsop87.LnVsop(4.51E-9, 3.05732548022, 898.7730327907), new Vsop87.LnVsop(4.18E-9, 2.03137205914, 146.594251718), new Vsop87.LnVsop(3.67E-9, 5.87612343294, 561.934294009), new Vsop87.LnVsop(4.08E-9, 5.59691221721, 58.319272332), new Vsop87.LnVsop(3.82E-9, 3.87558216751, 519.3960243561), new Vsop87.LnVsop(4.58E-9, 3.41993870613, 829.6205085159), new Vsop87.LnVsop(4.33E-9, 3.40938468811, 32.4557772355), new Vsop87.LnVsop(3.42E-9, 3.61061377024, 449.232108125), new Vsop87.LnVsop(3.51E-9, 0.42169595316, 3686.4961146598), new Vsop87.LnVsop(3.83E-9, 1.45427056096, 2730.2069586892), new Vsop87.LnVsop(3.89E-9, 2.73429108352, 36.1754821775), new Vsop87.LnVsop(4.34E-9, 0.33633221675, 55.1378785943), new Vsop87.LnVsop(3.47E-9, 5.08987125237, 392.6579409322), new Vsop87.LnVsop(3.36E-9, 1.56848818314, 233.7459645631), new Vsop87.LnVsop(4.68E-9, 4.21059909473, 832.5894539325), new Vsop87.LnVsop(4.0E-9, 1.32437246111, 551.1010420662), new Vsop87.LnVsop(4.08E-9, 0.29350145668, 90.5626012464), new Vsop87.LnVsop(3.31E-9, 3.31396426529, 952.3570027075), new Vsop87.LnVsop(4.33E-9, 3.06705605051, 885.4397106664), new Vsop87.LnVsop(3.63E-9, 5.21662491556, 1321.4390704036), new Vsop87.LnVsop(3.5E-9, 0.27061951411, 386.9806825299), new Vsop87.LnVsop(3.77E-9, 4.02407408251, 195.8906076987), new Vsop87.LnVsop(4.39E-9, 0.2061489528, 768.8535556291), new Vsop87.LnVsop(3.43E-9, 2.18929174651, 80.1982245387), new Vsop87.LnVsop(3.71E-9, 4.82569230753, 103.3534066495), new Vsop87.LnVsop(3.16E-9, 3.77933506984, 749.2098356561), new Vsop87.LnVsop(3.13E-9, 0.3341223301, 354.9979860464), new Vsop87.LnVsop(3.45E-9, 0.65964675903, 303.8616966844), new Vsop87.LnVsop(3.18E-9, 6.18967282289, 540.7366653585), new Vsop87.LnVsop(3.94E-9, 0.49801994278, 248.4631856592), new Vsop87.LnVsop(3.21E-9, 1.38233217556, 572.2292347475), new Vsop87.LnVsop(4.09E-9, 4.50419980169, 2914.0142358238), new Vsop87.LnVsop(3.04E-9, 0.55980988137, 200.5564741447), new Vsop87.LnVsop(4.25E-9, 5.38041771827, 387.2413149608), new Vsop87.LnVsop(3.07E-9, 5.62169035036, 426.4863162914), new Vsop87.LnVsop(3.03E-9, 1.7757701557, 1354.4331588434), new Vsop87.LnVsop(3.26E-9, 0.55650991969, 857.1285350151), new Vsop87.LnVsop(3.2E-9, 0.76110062758, 402.2191684878), new Vsop87.LnVsop(3.06E-9, 5.43075844483, 1151.4290041439), new Vsop87.LnVsop(2.96E-9, 3.15801280056, 192.8522263129), new Vsop87.LnVsop(3.73E-9, 3.70882376658, 420.4478517217), new Vsop87.LnVsop(3.81E-9, 1.98600461815, 109.9456887885), new Vsop87.LnVsop(3.13E-9, 1.98847351323, 3274.1250177854), new Vsop87.LnVsop(3.16E-9, 4.68238982521, 4113.0943055358), new Vsop87.LnVsop(2.96E-9, 4.45699206346, 668.2084619653), new Vsop87.LnVsop(3.07E-9, 4.03153284883, 426.7100654606), new Vsop87.LnVsop(3.86E-9, 3.23974290135, 745.9108218394), new Vsop87.LnVsop(3.92E-9, 0.14336691305, 206.3979967583), new Vsop87.LnVsop(3.17E-9, 1.84490263716, 214.9436268407), new Vsop87.LnVsop(2.86E-9, 1.0405805898, 315.6411101312), new Vsop87.LnVsop(2.86E-9, 2.10284268664, 335.1418177523), new Vsop87.LnVsop(2.89E-9, 4.70265740009, 29.7474642498), new Vsop87.LnVsop(2.84E-9, 4.67220236113, 281.1795953256), new Vsop87.LnVsop(2.83E-9, 5.25961089189, 414.8187774292), new Vsop87.LnVsop(2.8E-9, 0.45877292284, 38.6061163898), new Vsop87.LnVsop(3.77E-9, 0.85962141856, 423.6292454594), new Vsop87.LnVsop(2.83E-9, 1.20963336142, 1699.2792165032), new Vsop87.LnVsop(3.02E-9, 1.14801271444, 1257.7031721002), new Vsop87.LnVsop(2.89E-9, 0.39419904139, 114.9416236346), new Vsop87.LnVsop(3.1E-9, 4.11324737724, 769.8167634756), new Vsop87.LnVsop(2.82E-9, 2.75269537491, 551.031606097), new Vsop87.LnVsop(3.36E-9, 6.23083557086, 731.6837278378), new Vsop87.LnVsop(2.79E-9, 0.26388092959, 464.7312265138), new Vsop87.LnVsop(3.68E-9, 1.33340900488, 1055.4497769261), new Vsop87.LnVsop(2.69E-9, 0.1910211109, 172.4577468145), new Vsop87.LnVsop(3.61E-9, 2.44015253985, 705.1176573257), new Vsop87.LnVsop(2.75E-9, 4.28054408975, 380.3884003909), new Vsop87.LnVsop(3.77E-9, 4.70934833857, 745.277682393), new Vsop87.LnVsop(3.07E-9, 1.98521490131, 495.9631634719), new Vsop87.LnVsop(3.37E-9, 3.68858519623, 259.769518354), new Vsop87.LnVsop(3.39E-9, 3.08818903316, 10220.3990932118), new Vsop87.LnVsop(2.96E-9, 2.00421481341, 589.4947101349), new Vsop87.LnVsop(3.17E-9, 1.58244658244, 707.5653378805), new Vsop87.LnVsop(2.96E-9, 5.75916833234, 4010.0015313172), new Vsop87.LnVsop(2.72E-9, 5.06188002128, 604.4725636619), new Vsop87.LnVsop(3.09E-9, 5.08967978904, 481.7360694703), new Vsop87.LnVsop(2.68E-9, 4.17204337052, 90.8232336773), new Vsop87.LnVsop(2.79E-9, 2.57997066424, 1166.4068576709), new Vsop87.LnVsop(2.63E-9, 5.83143850743, 236.1936451179), new Vsop87.LnVsop(2.62E-9, 4.82319865484, 254.1404440615), new Vsop87.LnVsop(3.3E-9, 5.28727805343, 373.9079928365), new Vsop87.LnVsop(2.72E-9, 5.86503850236, 332.1728723357), new Vsop87.LnVsop(2.7E-9, 2.05575029737, 1056.2005364515), new Vsop87.LnVsop(3.25E-9, 5.61078155189, 95.2284676924), new Vsop87.LnVsop(3.29E-9, 3.65551552377, 1261.6353253633), new Vsop87.LnVsop(2.62E-9, 5.26283687262, 190.4045457581), new Vsop87.LnVsop(2.66E-9, 3.28625963812, 560.7104537316), new Vsop87.LnVsop(2.73E-9, 6.14693613085, 57.5161231799), new Vsop87.LnVsop(2.81E-9, 5.14426219194, 253.4591205053), new Vsop87.LnVsop(2.58E-9, 3.41189080652, 426.8106391971), new Vsop87.LnVsop(2.58E-9, 6.24133239267, 426.3857425549), new Vsop87.LnVsop(2.79E-9, 4.41281278656, 385.5443939314), new Vsop87.LnVsop(2.56E-9, 3.16610713985, 102.3420146932), new Vsop87.LnVsop(2.57E-9, 0.70050938269, 103.843533744), new Vsop87.LnVsop(2.54E-9, 5.72706255967, 680.0573113813), new Vsop87.LnVsop(2.61E-9, 2.03152918911, 782.3469364478), new Vsop87.LnVsop(2.66E-9, 2.54277079029, 132.8884225782), new Vsop87.LnVsop(2.54E-9, 3.62032079258, 419.4364597654), new Vsop87.LnVsop(3.16E-9, 2.935045907, 357.2332182801), new Vsop87.LnVsop(2.67E-9, 5.54665314271, 628.5909536192), new Vsop87.LnVsop(3.25E-9, 6.2553445427, 763.4369296577), new Vsop87.LnVsop(2.78E-9, 3.3427595595, 1193.9672737968), new Vsop87.LnVsop(2.49E-9, 3.99548655043, 441.576044403), new Vsop87.LnVsop(2.46E-9, 4.8151475459, 1534.7381658416), new Vsop87.LnVsop(2.72E-9, 2.4807138576, 550.1378342197), new Vsop87.LnVsop(2.46E-9, 5.71006975326, 476.3194434989), new Vsop87.LnVsop(2.94E-9, 1.22963935768, 249.9476583675), new Vsop87.LnVsop(2.59E-9, 3.88202030192, 639.3760214522), new Vsop87.LnVsop(2.44E-9, 5.10422417434, 310.9752436852), new Vsop87.LnVsop(3.11E-9, 3.52049740257, 2751.5475996916), new Vsop87.LnVsop(2.43E-9, 6.28195773692, 2840.4132799086), new Vsop87.LnVsop(3.13E-9, 3.42509462426, 598.8434893694), new Vsop87.LnVsop(2.39E-9, 0.56411438013, 1041.2226829245), new Vsop87.LnVsop(3.14E-9, 2.09014741078, 2700.7151403858), new Vsop87.LnVsop(2.52E-9, 3.18783181098, 433.663553767), new Vsop87.LnVsop(2.69E-9, 0.46123281645, 419.532827985), new Vsop87.LnVsop(2.87E-9, 3.94676800561, 187.4356003415), new Vsop87.LnVsop(2.39E-9, 4.33768387204, 418.9633790134), new Vsop87.LnVsop(2.77E-9, 3.33020754198, 545.4719677737), new Vsop87.LnVsop(2.35E-9, 1.40745218631, 325.9530972122), new Vsop87.LnVsop(3.03E-9, 3.77099446355, 285.3723810196), new Vsop87.LnVsop(2.46E-9, 0.91025855538, 427.3489504014), new Vsop87.LnVsop(3.04E-9, 3.15302544595, 409.1897031367), new Vsop87.LnVsop(2.6E-9, 3.22650696823, 1251.3403846248), new Vsop87.LnVsop(2.7E-9, 0.26009457956, 1175.8080265321), new Vsop87.LnVsop(2.86E-9, 4.70301654462, 5429.8794682394), new Vsop87.LnVsop(3.02E-9, 3.15201610429, 915.235359026), new Vsop87.LnVsop(2.64E-9, 0.46129841785, 720.8986600048), new Vsop87.LnVsop(2.84E-9, 5.20343995757, 395.105621487), new Vsop87.LnVsop(3.0E-9, 3.02573280616, 498.9321088885), new Vsop87.LnVsop(2.37E-9, 4.86867505639, 1181.4371008246), new Vsop87.LnVsop(2.31E-9, 0.11031027115, 433.7599219866), new Vsop87.LnVsop(2.61E-9, 3.79185925936, 658.0565335787), new Vsop87.LnVsop(2.58E-9, 0.22294298357, 535.9107402181), new Vsop87.LnVsop(2.68E-9, 4.16390951489, 348.635198571), new Vsop87.LnVsop(2.94E-9, 1.09586943179, 544.5087599272), new Vsop87.LnVsop(3.19E-9, 0.20364888646, 201.5196819912), new Vsop87.LnVsop(3.2E-9, 0.2173175797, 25448.00585526019), new Vsop87.LnVsop(2.35E-9, 2.91419127683, 3553.9115221378), new Vsop87.LnVsop(2.28E-9, 3.13658374798, 806.725958836), new Vsop87.LnVsop(2.8E-9, 1.8921991225, 608.877797677), new Vsop87.LnVsop(3.04E-9, 1.81517981104, 49.7212526229), new Vsop87.LnVsop(2.41E-9, 4.41107497608, 97.4636999261), new Vsop87.LnVsop(2.8E-9, 1.91710870481, 619.2903584945), new Vsop87.LnVsop(2.68E-9, 5.54944666204, 12352.8526045448), new Vsop87.LnVsop(3.0E-9, 0.82078435036, 260.360219185), new Vsop87.LnVsop(2.41E-9, 2.73275886611, 2254.0999635114), new Vsop87.LnVsop(2.48E-9, 2.5113029027, 203.2647871304), new Vsop87.LnVsop(2.7E-9, 2.71882107339, 455.1699989582), new Vsop87.LnVsop(3.17E-9, 4.74822142018, 420.005908737), new Vsop87.LnVsop(2.38E-9, 4.57200367401, 347.4113582936), new Vsop87.LnVsop(3.12E-9, 2.00917921228, 3171.0322435668), new Vsop87.LnVsop(2.82E-9, 4.2915913335, 1127.2624300768), new Vsop87.LnVsop(2.85E-9, 6.25041522099, 913.0001267923), new Vsop87.LnVsop(2.9E-9, 3.93862532064, 566.600160455), new Vsop87.LnVsop(2.43E-9, 4.43884635841, 611.4430983108), new Vsop87.LnVsop(2.27E-9, 4.2213669237, 821.703812363), new Vsop87.LnVsop(2.73E-9, 1.92151965288, 418.7338843498), new Vsop87.LnVsop(2.36E-9, 4.10002766188, 6467.9257579616), new Vsop87.LnVsop(2.22E-9, 3.40994011933, 520.129737539), new Vsop87.LnVsop(2.23E-9, 2.86569801117, 359.6808988349), new Vsop87.LnVsop(2.26E-9, 1.60308230653, 316.279995072), new Vsop87.LnVsop(2.86E-9, 6.1054638563, 484.7050148869), new Vsop87.LnVsop(2.24E-9, 5.42477390085, 870.4618571394), new Vsop87.LnVsop(2.69E-9, 2.80616329306, 693.5506922), new Vsop87.LnVsop(2.95E-9, 3.16789723206, 1050.9963588012), new Vsop87.LnVsop(2.25E-9, 2.15616043634, 670.916774951), new Vsop87.LnVsop(2.18E-9, 5.03896380986, 771.3012361839), new Vsop87.LnVsop(2.29E-9, 1.16019729708, 531.978586955), new Vsop87.LnVsop(2.7E-9, 6.11597757902, 9360.089164459), new Vsop87.LnVsop(2.2E-9, 0.94624118346, 316.5037442412), new Vsop87.LnVsop(2.23E-9, 4.56047229133, 4429.4861751924), new Vsop87.LnVsop(2.17E-9, 0.06814070717, 3259.8979237838), new Vsop87.LnVsop(2.91E-9, 3.12121440958, 47.6942631934), new Vsop87.LnVsop(2.31E-9, 0.26541832793, 394.3548619616), new Vsop87.LnVsop(2.15E-9, 6.17765322528, 108.50940019), new Vsop87.LnVsop(2.36E-9, 4.4340200526, 640.4185511758), new Vsop87.LnVsop(2.79E-9, 2.65446123759, 134.1122628556), new Vsop87.LnVsop(2.16E-9, 0.22963287739, 5753.3848848968), new Vsop87.LnVsop(2.47E-9, 4.17284923639, 950.1388168163), new Vsop87.LnVsop(2.87E-9, 3.36813375814, 666.723989257), new Vsop87.LnVsop(2.12E-9, 6.07108339832, 1725.9458607518), new Vsop87.LnVsop(2.12E-9, 2.45582771491, 1164.7623262682), new Vsop87.LnVsop(2.66E-9, 2.3003083666, 314.9073969483), new Vsop87.LnVsop(2.79E-9, 2.87114139089, 322.6116447801), new Vsop87.LnVsop(2.28E-9, 2.30491692416, 614.6244920485), new Vsop87.LnVsop(2.24E-9, 3.01352239231, 1937.7080938548), new Vsop87.LnVsop(2.84E-9, 0.3481311454, 1269.4996318895), new Vsop87.LnVsop(2.1E-9, 2.36229213543, 439.9315130003), new Vsop87.LnVsop(2.86E-9, 4.17396480661, 1364.7280995819), new Vsop87.LnVsop(2.22E-9, 4.51639912202, 304.1223291153), new Vsop87.LnVsop(2.15E-9, 0.74685271202, 1008.9793540101), new Vsop87.LnVsop(2.46E-9, 1.05357358595, 657.1627617014), new Vsop87.LnVsop(2.72E-9, 0.63607231806, 679.2541622292), new Vsop87.LnVsop(2.2E-9, 2.78497656776, 840.6662087798), new Vsop87.LnVsop(2.71E-9, 3.98523199705, 453.6855262499), new Vsop87.LnVsop(2.64E-9, 2.58516335032, 2527.2028039897), new Vsop87.LnVsop(2.06E-9, 5.74019252688, 232.2091022281), new Vsop87.LnVsop(2.03E-9, 1.5048333154, 962.5089310941), new Vsop87.LnVsop(2.58E-9, 1.50724315598, 1759.8337210689), new Vsop87.LnVsop(2.12E-9, 0.21249623632, 1170.3914005607), new Vsop87.LnVsop(2.42E-9, 5.51076641081, 1254.5217783625), new Vsop87.LnVsop(2.02E-9, 2.80107182616, 255.8373650909), new Vsop87.LnVsop(2.01E-9, 1.11940822442, 97.4155158163), new Vsop87.LnVsop(2.34E-9, 3.44765874117, 1190.0351205337), new Vsop87.LnVsop(2.01E-9, 5.42082689064, 194.3890886479), new Vsop87.LnVsop(2.09E-9, 0.33775403299, 81.8951455681), new Vsop87.LnVsop(2.01E-9, 2.67485193508, 1546.5346256309), new Vsop87.LnVsop(2.36E-9, 2.80474989355, 462.0229135281), new Vsop87.LnVsop(2.3E-9, 4.7368812144, 401.3253966105), new Vsop87.LnVsop(2.16E-9, 5.55255486747, 334.5511169213), new Vsop87.LnVsop(2.08E-9, 0.74090848873, 517.1607921224), new Vsop87.LnVsop(2.68E-9, 2.54915323674, 795.6802585721), new Vsop87.LnVsop(2.03E-9, 5.48549678977, 557.0389328994), new Vsop87.LnVsop(1.95E-9, 0.30930524284, 1673.2556627123), new Vsop87.LnVsop(2.39E-9, 3.98478822895, 661.0949149645), new Vsop87.LnVsop(1.94E-9, 3.15655633545, 532.8723588323), new Vsop87.LnVsop(2.02E-9, 3.72909313764, 2225.7887878601), new Vsop87.LnVsop(1.98E-9, 4.62958669511, 6076.8903015542), new Vsop87.LnVsop(1.94E-9, 4.0573475171, 426.8588233069), new Vsop87.LnVsop(2.45E-9, 3.77879563722, 499.895316735), new Vsop87.LnVsop(1.97E-9, 2.59372890647, 639.8491022042), new Vsop87.LnVsop(1.94E-9, 0.96685944577, 1310.3933701397), new Vsop87.LnVsop(2.39E-9, 4.63640373069, 868.7167520002), new Vsop87.LnVsop(2.62E-9, 2.16648038763, 9573.388259897), new Vsop87.LnVsop(1.93E-9, 6.12031277542, 620.253566341), new Vsop87.LnVsop(1.97E-9, 0.56732371899, 156.6767441354), new Vsop87.LnVsop(2.47E-9, 2.9134876624, 689.6185389369), new Vsop87.LnVsop(1.94E-9, 5.59586362692, 426.3375584451), new Vsop87.LnVsop(2.32E-9, 1.76649868274, 354.2642728635), new Vsop87.LnVsop(2.37E-9, 1.24961133027, 882.9438460018), new Vsop87.LnVsop(2.42E-9, 6.18368970388, 559.6990617753), new Vsop87.LnVsop(2.02E-9, 4.49789034288, 1239.5439248355), new Vsop87.LnVsop(1.93E-9, 0.87361458277, 47.061123747), new Vsop87.LnVsop(2.59E-9, 4.16391413557, 934.1977554428), new Vsop87.LnVsop(2.43E-9, 2.86100782215, 64.9597385808), new Vsop87.LnVsop(2.64E-9, 5.7701194131, 25654.19140369739), new Vsop87.LnVsop(2.04E-9, 2.99939346928, 1385.174968707), new Vsop87.LnVsop(1.87E-9, 4.79452148614, 843.6351541964), new Vsop87.LnVsop(1.92E-9, 4.99048344211, 636.9765250072), new Vsop87.LnVsop(1.91E-9, 5.405527946, 1489.9122743283), new Vsop87.LnVsop(1.87E-9, 4.02967932517, 6114.538297694), new Vsop87.LnVsop(1.84E-9, 1.13531068665, 1262.3860848887), new Vsop87.LnVsop(1.84E-9, 3.84493991801, 318.679491517), new Vsop87.LnVsop(2.44E-9, 0.76614174177, 5643.1785636774), new Vsop87.LnVsop(1.95E-9, 1.79897803267, 485.8806710545), new Vsop87.LnVsop(1.99E-9, 2.25323627854, 66.1835788582), new Vsop87.LnVsop(2.15E-9, 0.5301096679, 784.0438574772), new Vsop87.LnVsop(1.84E-9, 5.29993031141, 451.7279727896), new Vsop87.LnVsop(2.22E-9, 3.92654047757, 1226.2106027112), new Vsop87.LnVsop(2.01E-9, 4.70550758042, 1276.6131788903), new Vsop87.LnVsop(2.48E-9, 3.47834021364, 1045.8885493705), new Vsop87.LnVsop(1.89E-9, 1.84142475095, 434.6749457233), new Vsop87.LnVsop(1.93E-9, 4.63015663692, 625.8826406335), new Vsop87.LnVsop(2.1E-9, 5.12097279511, 3494.5376602242), new Vsop87.LnVsop(2.25E-9, 3.47799120533, 728.0122070056), new Vsop87.LnVsop(1.8E-9, 1.67083010191, 244.791664827), new Vsop87.LnVsop(1.85E-9, 1.26599682245, 837.6972633632), new Vsop87.LnVsop(1.99E-9, 1.34931214692, 1012.9115072732), new Vsop87.LnVsop(2.06E-9, 4.20379638812, 548.4409131903), new Vsop87.LnVsop(1.85E-9, 3.63189231877, 1097.0942747017), new Vsop87.LnVsop(2.0E-9, 2.80981188653, 757.2171545342), new Vsop87.LnVsop(1.8E-9, 5.69338271322, 4216.1870797544), new Vsop87.LnVsop(2.1E-9, 4.55350094602, 608.404716925), new Vsop87.LnVsop(1.78E-9, 4.72379761838, 317.142629182), new Vsop87.LnVsop(1.83E-9, 1.59341380048, 469.8872200543), new Vsop87.LnVsop(2.01E-9, 0.5021968074, 36.3879304986), new Vsop87.LnVsop(2.11E-9, 2.58933275158, 89.0086925689), new Vsop87.LnVsop(1.79E-9, 1.30120995289, 3906.9087570986), new Vsop87.LnVsop(1.77E-9, 2.25151102161, 35.1640902212), new Vsop87.LnVsop(2.46E-9, 5.20794390821, 272.5815756165), new Vsop87.LnVsop(1.76E-9, 2.39195564251, 103925.01437542078), new Vsop87.LnVsop(2.26E-9, 2.06446075323, 631.2992666049), new Vsop87.LnVsop(1.74E-9, 5.69939637397, 469.7271613599), new Vsop87.LnVsop(1.74E-9, 5.04863411343, 1523.6924655777), new Vsop87.LnVsop(2.32E-9, 5.1935079829, 594.6507036754), new Vsop87.LnVsop(1.92E-9, 5.50039064912, 707.7777862016), new Vsop87.LnVsop(1.77E-9, 5.82784918044, 413.8555695827), new Vsop87.LnVsop(1.73E-9, 1.58292103982, 1379.7059531089), new Vsop87.LnVsop(1.72E-9, 5.94041958594, 984.6003316219), new Vsop87.LnVsop(1.72E-9, 4.68707195529, 40.1600250673), new Vsop87.LnVsop(1.89E-9, 4.84284140555, 568.2970814844), new Vsop87.LnVsop(1.75E-9, 4.835119754, 1194.7180333222), new Vsop87.LnVsop(2.41E-9, 0.67201443623, 1089.129394439), new Vsop87.LnVsop(2.13E-9, 6.08435697556, 271.61836777), new Vsop87.LnVsop(1.77E-9, 1.64110733509, 3590.516887442), new Vsop87.LnVsop(2.24E-9, 0.38976137724, 991.7138786227), new Vsop87.LnVsop(2.16E-9, 2.99208871258, 1141.1340634054), new Vsop87.LnVsop(1.91E-9, 0.70123392369, 2015.6710861598), new Vsop87.LnVsop(1.74E-9, 3.63541680305, 605.275712814), new Vsop87.LnVsop(1.77E-9, 1.45237852614, 904.4021070832), new Vsop87.LnVsop(1.78E-9, 0.35454887224, 444.1242986943), new Vsop87.LnVsop(1.83E-9, 1.13762118246, 258.5456780766), new Vsop87.LnVsop(1.83E-9, 3.04829576614, 25668.418497699), new Vsop87.LnVsop(1.82E-9, 0.75986655407, 504.561183181), new Vsop87.LnVsop(1.99E-9, 3.47101766075, 842.9014410135), new Vsop87.LnVsop(1.87E-9, 4.12687876136, 9985.7593567714), new Vsop87.LnVsop(1.66E-9, 6.00733259649, 3576.2897934404), new Vsop87.LnVsop(1.87E-9, 0.80594740329, 226.0417167313), new Vsop87.LnVsop(1.91E-9, 1.79131964388, 702.1487119091), new Vsop87.LnVsop(2.32E-9, 3.68163889937, 1123.1178284926), new Vsop87.LnVsop(1.72E-9, 5.41410693088, 2306.7901615509), new Vsop87.LnVsop(1.86E-9, 0.86352341507, 973.554631358), new Vsop87.LnVsop(1.73E-9, 1.54028223744, 827.9235874865), new Vsop87.LnVsop(1.93E-9, 1.24804468649, 109.2431133729), new Vsop87.LnVsop(1.84E-9, 4.60992527921, 223.3334037456), new Vsop87.LnVsop(1.65E-9, 1.51886495431, 1670.8250285), new Vsop87.LnVsop(1.62E-9, 2.30291581618, 874.3940104025), new Vsop87.LnVsop(2.06E-9, 1.66459080869, 6290.1893969922), new Vsop87.LnVsop(1.77E-9, 4.36776214702, 328.9220426288), new Vsop87.LnVsop(1.97E-9, 1.43444932583, 347.3631741838), new Vsop87.LnVsop(2.03E-9, 5.71459758755, 664.2763087022), new Vsop87.LnVsop(1.96E-9, 4.72078032034, 104.789695248), new Vsop87.LnVsop(1.82E-9, 1.78459753906, 1245.172999128), new Vsop87.LnVsop(1.84E-9, 0.48156047778, 948.2124011233), new Vsop87.LnVsop(1.77E-9, 3.47933371966, 1304.9243545416), new Vsop87.LnVsop(1.62E-9, 3.87494735228, 949.12742486), new Vsop87.LnVsop(1.68E-9, 5.94654405439, 883.7951792637), new Vsop87.LnVsop(1.88E-9, 4.0419873093, 688.6553310904), new Vsop87.LnVsop(2.0E-9, 5.54644649494, 308.3151148093), new Vsop87.LnVsop(1.95E-9, 0.2949133005, 1144.3154571431), new Vsop87.LnVsop(2.12E-9, 5.98509016682, 432.7485300303), new Vsop87.LnVsop(2.11E-9, 1.36833704118, 815.0633461142), new Vsop87.LnVsop(1.79E-9, 5.4988489538, 9566.2747128962), new Vsop87.LnVsop(1.58E-9, 5.97577354437, 224.6054281328), new Vsop87.LnVsop(1.66E-9, 0.96670231118, 632.0329797878), new Vsop87.LnVsop(1.81E-9, 2.40654138031, 812.1425848074), new Vsop87.LnVsop(1.62E-9, 4.04123271503, 632.7355552034), new Vsop87.LnVsop(1.85E-9, 3.01715709315, 55.8715917772), new Vsop87.LnVsop(1.54E-9, 4.23895313385, 227.4780053298), new Vsop87.LnVsop(1.65E-9, 4.27833421336, 633.7469471597), new Vsop87.LnVsop(1.55E-9, 3.77147874591, 407.4757357648), new Vsop87.LnVsop(1.95E-9, 2.06339645296, 1127.0499817557), new Vsop87.LnVsop(1.71E-9, 3.79380560971, 433.190473015), new Vsop87.LnVsop(2.03E-9, 0.18481949826, 1596.1864422846), new Vsop87.LnVsop(1.52E-9, 0.87668770181, 632.831923423), new Vsop87.LnVsop(2.05E-9, 1.62784908817, 389.9496279465), new Vsop87.LnVsop(1.56E-9, 2.47045974513, 634.2682120215), new Vsop87.LnVsop(1.65E-9, 3.0546519447, 893.3564068193), new Vsop87.LnVsop(1.6E-9, 1.59024173023, 774.0095491696), new Vsop87.LnVsop(1.53E-9, 0.67184956696, 1026.2448293975), new Vsop87.LnVsop(1.57E-9, 5.37707567291, 262.8078997398), new Vsop87.LnVsop(1.64E-9, 5.93798546311, 199.8057146193), new Vsop87.LnVsop(1.52E-9, 0.62990682378, 949.2237930796), new Vsop87.LnVsop(1.84E-9, 2.81115706121, 913.7508863177), new Vsop87.LnVsop(1.74E-9, 3.92776720931, 313.4711083498), new Vsop87.LnVsop(1.57E-9, 5.67235483479, 77837.11123384659), new Vsop87.LnVsop(1.78E-9, 0.2872229637, 637.4496057592), new Vsop87.LnVsop(1.5E-9, 3.40116011178, 401.5378449316), new Vsop87.LnVsop(1.5E-9, 2.55468547332, 623.2225117576), new Vsop87.LnVsop(1.49E-9, 2.64528846124, 1567.7322542814), new Vsop87.LnVsop(1.77E-9, 4.68158494106, 2921.1277828246), new Vsop87.LnVsop(2.0E-9, 4.5974601193, 851.7119090437), new Vsop87.LnVsop(1.47E-9, 4.28619772534, 1160.8301730051), new Vsop87.LnVsop(1.47E-9, 5.22553334565, 219.1406180516), new Vsop87.LnVsop(1.8E-9, 4.39237324654, 110.1581371096), new Vsop87.LnVsop(1.5E-9, 0.38685537182, 346.1875180162), new Vsop87.LnVsop(1.51E-9, 1.58821996099, 110.2545053292), new Vsop87.LnVsop(1.7E-9, 2.06997658106, 907.3710524998), new Vsop87.LnVsop(1.7E-9, 1.70870898705, 493.303034596), new Vsop87.LnVsop(1.47E-9, 5.66193217302, 866.5297038763), new Vsop87.LnVsop(1.56E-9, 0.37713977057, 285.1117485887), new Vsop87.LnVsop(1.48E-9, 2.14966333692, 1053.7528558967), new Vsop87.LnVsop(1.45E-9, 2.97578064766, 318.8395502114), new Vsop87.LnVsop(1.5E-9, 2.02972985856, 1049.0869894507), new Vsop87.LnVsop(1.55E-9, 5.40486194982, 941.3113024436), new Vsop87.LnVsop(1.57E-9, 2.34913118792, 5959.570433334), new Vsop87.LnVsop(1.76E-9, 0.72569662289, 562.6680071919), new Vsop87.LnVsop(1.74E-9, 2.74727949944, 652.4274592862), new Vsop87.LnVsop(1.44E-9, 0.07286394798, 1357.6145525811), new Vsop87.LnVsop(1.57E-9, 5.60572015205, 83.3796182764), new Vsop87.LnVsop(1.92E-9, 1.32296078608, 2906.900688823), new Vsop87.LnVsop(1.45E-9, 2.89440864386, 757.8078553652), new Vsop87.LnVsop(1.63E-9, 2.96579171875, 398.1440028728), new Vsop87.LnVsop(1.43E-9, 5.77044222961, 638.9340784675), new Vsop87.LnVsop(1.53E-9, 4.3082263249, 1688.2335162393), new Vsop87.LnVsop(1.62E-9, 2.92059412639, 640.8604941605), new Vsop87.LnVsop(1.48E-9, 2.22132937111, 366.0436863103), new Vsop87.LnVsop(1.39E-9, 1.57016688059, 508.4933364441), new Vsop87.LnVsop(1.37E-9, 1.2892566593, 214.1022445901), new Vsop87.LnVsop(1.37E-9, 4.69338435212, 1091.6252591036), new Vsop87.LnVsop(1.37E-9, 3.49438482945, 212.4959462859), new Vsop87.LnVsop(1.61E-9, 2.79324425926, 1884.124123938), new Vsop87.LnVsop(1.41E-9, 6.11606010109, 689.4060906158), new Vsop87.LnVsop(1.58E-9, 2.93809799437, 211.6545640353), new Vsop87.LnVsop(1.33E-9, 1.07901356698, 714.6788848813), new Vsop87.LnVsop(1.32E-9, 3.41532758407, 241.7532834412), new Vsop87.LnVsop(1.4E-9, 0.35543703784, 219.5188705615), new Vsop87.LnVsop(1.32E-9, 1.60294025637, 1372.5924061081), new Vsop87.LnVsop(1.38E-9, 4.87283429639, 635.70450062), new Vsop87.LnVsop(1.74E-9, 3.20392947742, 3067.9394693482), new Vsop87.LnVsop(1.31E-9, 2.72435966674, 398.2870152247), new Vsop87.LnVsop(1.42E-9, 2.33733560884, 424.9012698466), new Vsop87.LnVsop(1.45E-9, 2.46754245743, 740.0692992258), new Vsop87.LnVsop(1.3E-9, 6.04357829917, 361.3778198643), new Vsop87.LnVsop(1.36E-9, 4.16548251681, 1016.8436605363), new Vsop87.LnVsop(1.29E-9, 1.72249381106, 9683.5945811164), new Vsop87.LnVsop(1.66E-9, 0.13141571702, 990.2294059144), new Vsop87.LnVsop(1.76E-9, 1.05208913969, 2520.0892569889), new Vsop87.LnVsop(1.66E-9, 0.94384437158, 476.1069951778), new Vsop87.LnVsop(1.4E-9, 3.62845418039, 423.8898778903), new Vsop87.LnVsop(1.46E-9, 4.06866189224, 5636.0650166766), new Vsop87.LnVsop(1.38E-9, 3.29913390228, 98.4269077726), new Vsop87.LnVsop(1.44E-9, 0.52149675978, 1459.9565672743), new Vsop87.LnVsop(1.71E-9, 2.81138753424, 184.7272873558), new Vsop87.LnVsop(1.58E-9, 1.60504572001, 3487.4241132234), new Vsop87.LnVsop(1.24E-9, 2.8570028072, 635.231419868), new Vsop87.LnVsop(1.59E-9, 1.00544429672, 514.7131115676), new Vsop87.LnVsop(1.62E-9, 5.11097835962, 354.5249052944), new Vsop87.LnVsop(1.4E-9, 4.36785639431, 207.0793203145), new Vsop87.LnVsop(1.23E-9, 2.38472091094, 254.3528923826), new Vsop87.LnVsop(1.31E-9, 4.00719555038, 1736.9915610157), new Vsop87.LnVsop(1.27E-9, 2.14761211605, 1443.4418514123), new Vsop87.LnVsop(1.28E-9, 2.83776405449, 152.7445908723), new Vsop87.LnVsop(1.45E-9, 5.85135135519, 221.8971151471), new Vsop87.LnVsop(1.65E-9, 4.63544466195, 9793.8009023358), new Vsop87.LnVsop(1.38E-9, 3.13686094637, 3384.3313390048), new Vsop87.LnVsop(1.61E-9, 5.37196690469, 373.0142209592), new Vsop87.LnVsop(1.22E-9, 1.92670167775, 466.7582159433), new Vsop87.LnVsop(1.53E-9, 2.81114887778, 1201.831580323), new Vsop87.LnVsop(1.39E-9, 3.58663958553, 864.2420820159), new Vsop87.LnVsop(1.21E-9, 1.00723355716, 1578.7779545453), new Vsop87.LnVsop(1.41E-9, 0.53873068197, 5650.2921106782), new Vsop87.LnVsop(1.39E-9, 6.02467596636, 429.3065038617), new Vsop87.LnVsop(1.18E-9, 0.06202877387, 4002.8879843164), new Vsop87.LnVsop(1.17E-9, 0.23611720848, 426.7582495704), new Vsop87.LnVsop(1.21E-9, 5.61834288138, 683.1863154923), new Vsop87.LnVsop(1.31E-9, 0.190990491, 1034.8428491066), new Vsop87.LnVsop(1.45E-9, 2.01100408928, 9580.5018068978), new Vsop87.LnVsop(1.48E-9, 0.86320227639, 802.7938055729), new Vsop87.LnVsop(1.2E-9, 5.84000868066, 639.9454704238), new Vsop87.LnVsop(1.17E-9, 3.13382982755, 426.4381321816), new Vsop87.LnVsop(1.48E-9, 1.37965451617, 737.3128021303), new Vsop87.LnVsop(1.25E-9, 1.29791571244, 1314.3255234028), new Vsop87.LnVsop(1.2E-9, 4.18622956101, 1827.5017726354), new Vsop87.LnVsop(1.2E-9, 1.11355985676, 2303.6087678132), new Vsop87.LnVsop(1.51E-9, 5.23544423687, 3178.1457905676), new Vsop87.LnVsop(1.13E-9, 5.4904148675, 887.7273325268), new Vsop87.LnVsop(1.2E-9, 0.32334283674, 629.8629780064), new Vsop87.LnVsop(1.26E-9, 2.25106706266, 653.2306084383), new Vsop87.LnVsop(1.26E-9, 0.97215166444, 311.7260032106), new Vsop87.LnVsop(1.35E-9, 1.85375623937, 733.428832977), new Vsop87.LnVsop(1.18E-9, 3.16360333291, 642.3449668688), new Vsop87.LnVsop(1.38E-9, 1.39135824716, 1120.148883076), new Vsop87.LnVsop(1.12E-9, 0.42841632061, 475.3562356524), new Vsop87.LnVsop(1.34E-9, 6.26324135064, 384.2723695442), new Vsop87.LnVsop(1.33E-9, 1.19341413256, 502.8642621516), new Vsop87.LnVsop(1.1E-9, 6.20238397088, 220.3007678542), new Vsop87.LnVsop(1.13E-9, 4.51098937409, 1511.1099029788), new Vsop87.LnVsop(1.34E-9, 4.06540685737, 976.7360250957), new Vsop87.LnVsop(1.17E-9, 4.21929280836, 927.8349679674), new Vsop87.LnVsop(1.11E-9, 1.19685071887, 6393.2821712108), new Vsop87.LnVsop(1.09E-9, 4.44503867691, 1299.3476698758), new Vsop87.LnVsop(1.09E-9, 5.14421802968, 6179.9830757728), new Vsop87.LnVsop(1.16E-9, 2.91900716047, 528.2064923863), new Vsop87.LnVsop(1.07E-9, 5.19867681343, 754.0357607965), new Vsop87.LnVsop(1.13E-9, 0.70071879215, 494.4786907636), new Vsop87.LnVsop(1.24E-9, 5.77019376453, 488.63716815), new Vsop87.LnVsop(1.14E-9, 0.06007563513, 631.8205314667), new Vsop87.LnVsop(1.07E-9, 2.73081851971, 628.1178728672), new Vsop87.LnVsop(1.46E-9, 1.07964353369, 206.2974230218), new Vsop87.LnVsop(1.24E-9, 1.16920221082, 188.1693135244), new Vsop87.LnVsop(1.17E-9, 3.62421096533, 2175.386211681), new Vsop87.LnVsop(1.12E-9, 5.17086478948, 1799.1905969841), new Vsop87.LnVsop(1.1E-9, 4.4492241189, 786.2790897109), new Vsop87.LnVsop(1.48E-9, 5.9782571799, 2946.6874478649), new Vsop87.LnVsop(1.37E-9, 1.43623456292, 225.0785088848), new Vsop87.LnVsop(1.16E-9, 5.52594794167, 632.2624744514), new Vsop87.LnVsop(1.08E-9, 3.38785406479, 642.8180476208), new Vsop87.LnVsop(1.08E-9, 4.43079377264, 1158.5425511447), new Vsop87.LnVsop(1.17E-9, 4.26185039858, 484.917463208), new Vsop87.LnVsop(1.36E-9, 1.97060630403, 206.9363079626), new Vsop87.LnVsop(1.05E-9, 2.43791237776, 1159.2933106701), new Vsop87.LnVsop(1.41E-9, 3.4876631851, 1578.0271950199), new Vsop87.LnVsop(1.08E-9, 4.73450004538, 220.5245170234), new Vsop87.LnVsop(1.03E-9, 3.84307420095, 848.530515306), new Vsop87.LnVsop(1.05E-9, 5.15580410406, 1748.788020805), new Vsop87.LnVsop(1.29E-9, 1.1255793049, 26080.78959457339), new Vsop87.LnVsop(1.1E-9, 5.43388877128, 128.3655684841), new Vsop87.LnVsop(1.35E-9, 6.14947956124, 3340.6124266998), new Vsop87.LnVsop(1.06E-9, 1.43304093123, 646.1170614375), new Vsop87.LnVsop(1.01E-9, 3.80702867071, 461.1291416508), new Vsop87.LnVsop(1.15E-9, 3.45101596098, 5863.5912061162), new Vsop87.LnVsop(1.03E-9, 0.947737707, 1106.6555022573), new Vsop87.LnVsop(1.09E-9, 1.02847174985, 1062.5633239269), new Vsop87.LnVsop(1.05E-9, 1.37783338573, 1987.2168981566), new Vsop87.LnVsop(1.1E-9, 2.98897645954, 1042.9196039539), new Vsop87.LnVsop(9.9E-10, 2.05195836305, 1034.1091359237), new Vsop87.LnVsop(1.04E-9, 3.40324525347, 812.9457339595), new Vsop87.LnVsop(1.16E-9, 2.49303741513, 2200.5159935946), new Vsop87.LnVsop(1.11E-9, 5.0116468663, 220.2001941177), new Vsop87.LnVsop(9.9E-10, 5.80548808441, 42.3258213318), new Vsop87.LnVsop(1.39E-9, 5.01901587647, 968.1380053866), new Vsop87.LnVsop(1.26E-9, 2.60609533649, 661.2379273164), new Vsop87.LnVsop(1.29E-9, 1.7472336504, 263.7016716171), new Vsop87.LnVsop(1.09E-9, 5.93625989258, 525.0250986486), new Vsop87.LnVsop(9.8E-10, 5.80682614639, 764.4001375042), new Vsop87.LnVsop(1.34E-9, 3.20331090065, 521.6142102473), new Vsop87.LnVsop(1.18E-9, 1.3096890775, 1222.2784494481), new Vsop87.LnVsop(1.06E-9, 3.86968434473, 4105.980758535), new Vsop87.LnVsop(1.11E-9, 5.14023256336, 226.7924762567), new Vsop87.LnVsop(1.13E-9, 0.50893852381, 184.8449074348), new Vsop87.LnVsop(1.24E-9, 2.6371676783, 1264.2954542392), new Vsop87.LnVsop(1.01E-9, 4.88259461441, 425.3261664888), new Vsop87.LnVsop(1.14E-9, 1.01995685373, 1340.3490771937), new Vsop87.LnVsop(1.27E-9, 4.89025569067, 162.0933701068), new Vsop87.LnVsop(1.16E-9, 5.20717925949, 845.3320752258), new Vsop87.LnVsop(9.6E-10, 4.61869048279, 316.6043179777), new Vsop87.LnVsop(9.6E-10, 1.11796162186, 316.1794213355), new Vsop87.LnVsop(9.6E-10, 5.84959086837, 845.5615698894), new Vsop87.LnVsop(9.6E-10, 4.59376884505, 6386.16862421), new Vsop87.LnVsop(1.03E-9, 5.68113298509, 1130.2313754934), new Vsop87.LnVsop(1.01E-9, 3.86045823511, 198.1087935899), new Vsop87.LnVsop(1.01E-9, 3.27916836807, 896.4854109303), new Vsop87.LnVsop(9.5E-10, 1.492674977, 674.4282370888), new Vsop87.LnVsop(1.02E-9, 4.03806928315, 665.0270682276), new Vsop87.LnVsop(1.11E-9, 4.66594406212, 700.4517908797), new Vsop87.LnVsop(1.2E-9, 4.40929322898, 695.5564297701), new Vsop87.LnVsop(1.09E-9, 2.68886916566, 1518.2234499796), new Vsop87.LnVsop(1.27E-9, 1.35796937995, 1493.093668066), new Vsop87.LnVsop(1.02E-9, 1.49520081692, 327.6982023514), new Vsop87.LnVsop(1.32E-9, 5.87656214175, 971.1069508032), new Vsop87.LnVsop(1.24E-9, 4.37096631322, 1134.3759770776), new Vsop87.LnVsop(9.4E-10, 3.78070391483, 326.6868103951), new Vsop87.LnVsop(1.0E-9, 5.11374589444, 644.090072008), new Vsop87.LnVsop(9.4E-10, 4.12103973042, 104351.61256629678), new Vsop87.LnVsop(1.19E-9, 2.44464219276, 1773.9178027186), new Vsop87.LnVsop(1.2E-9, 5.51190663062, 322.0209439491), new Vsop87.LnVsop(1.04E-9, 0.94072801823, 45.2465826386), new Vsop87.LnVsop(1.1E-9, 5.83597099432, 633.305004175), new Vsop87.LnVsop(9.2E-10, 3.1716500569, 507.5995645668), new Vsop87.LnVsop(1.01E-9, 4.77041953206, 427.8702152632), new Vsop87.LnVsop(9.8E-10, 4.2004892906, 78263.70942472259), new Vsop87.LnVsop(9.8E-10, 2.90784721259, 199.9657733137), new Vsop87.LnVsop(1.19E-9, 2.04004116097, 1154.6103978816), new Vsop87.LnVsop(9.1E-10, 1.3072431762, 1286.9081196288), new Vsop87.LnVsop(1.04E-9, 1.18434321311, 448.6895914038), new Vsop87.LnVsop(9.1E-10, 2.03003386313, 650.1922270525), new Vsop87.LnVsop(1.17E-9, 2.22762346918, 740.2817475469), new Vsop87.LnVsop(9.7E-10, 0.59571650703, 317.8763423649), new Vsop87.LnVsop(9.3E-10, 5.03178505524, 847.0460425977), new Vsop87.LnVsop(9.5E-10, 0.56124912733, 236.8749686741), new Vsop87.LnVsop(9.1E-10, 5.22516620379, 1031.87390369), new Vsop87.LnVsop(9.9E-10, 1.50209451695, 743.7932096847), new Vsop87.LnVsop(1.15E-9, 5.8822685849, 924.0458270562), new Vsop87.LnVsop(9.1E-10, 6.22628300162, 211.2933578679), new Vsop87.LnVsop(1.12E-9, 0.60952277376, 498.1983957056), new Vsop87.LnVsop(9.0E-10, 0.20903253046, 1390.0008938474), new Vsop87.LnVsop(1.24E-9, 0.14544703761, 2332.0629558164), new Vsop87.LnVsop(9.3E-10, 5.53494077769, 5687.940106818), new Vsop87.LnVsop(9.4E-10, 5.34823546532, 1235.6117715724), new Vsop87.LnVsop(1.05E-9, 2.75074759436, 1152.1797636693), new Vsop87.LnVsop(9.7E-10, 3.87780918853, 2733.3883524269), new Vsop87.LnVsop(9.2E-10, 3.33658628877, 518.9058972616), new Vsop87.LnVsop(9.0E-10, 3.20306478995, 1164.9223849626), new Vsop87.LnVsop(9.1E-10, 4.84054379431, 215.3048330081), new Vsop87.LnVsop(9.1E-10, 1.52963589526, 789.4604834486), new Vsop87.LnVsop(1.09E-9, 2.69742747002, 1457.525933062), new Vsop87.LnVsop(8.8E-10, 2.39325619929, 639.1465267886), new Vsop87.LnVsop(1.04E-9, 2.55393911799, 799.6124118352), new Vsop87.LnVsop(8.7E-10, 0.03653347258, 1389.1071219701), new Vsop87.LnVsop(9.3E-10, 0.72961701339, 608.2446582306), new Vsop87.LnVsop(9.3E-10, 5.30395179663, 222.7002642992), new Vsop87.LnVsop(8.7E-10, 1.64989693105, 338.4832701844), new Vsop87.LnVsop(9.7E-10, 4.65063535253, 1784.2127434571), new Vsop87.LnVsop(8.9E-10, 4.65304680818, 4326.3934009738), new Vsop87.LnVsop(8.6E-10, 2.32612831847, 1176.7017984094), new Vsop87.LnVsop(9.5E-10, 0.84654513116, 785.5283301855), new Vsop87.LnVsop(9.4E-10, 2.02588413534, 512.4254897072), new Vsop87.LnVsop(9.8E-10, 4.72121429417, 232.4215505492), new Vsop87.LnVsop(8.5E-10, 5.89926368802, 3156.8051495652), new Vsop87.LnVsop(9.0E-10, 0.49974649623, 77.7505439839), new Vsop87.LnVsop(8.5E-10, 2.91624163677, 746.7621551013), new Vsop87.LnVsop(8.8E-10, 0.46680815352, 1912.5783119412), new Vsop87.LnVsop(8.4E-10, 4.29098368309, 896.3253522359), new Vsop87.LnVsop(8.4E-10, 3.26093035827, 1101.0264279648), new Vsop87.LnVsop(9.7E-10, 5.87961038568, 2648.454825473), new Vsop87.LnVsop(1.12E-9, 1.42592292237, 3046.5988283458), new Vsop87.LnVsop(9.5E-10, 5.07265268907, 1887.3055176757), new Vsop87.LnVsop(9.6E-10, 1.73235805032, 3803.81598288), new Vsop87.LnVsop(9.5E-10, 5.49343620014, 452.2010535416), new Vsop87.LnVsop(8.4E-10, 6.00447997565, 4333.5069479746), new Vsop87.LnVsop(9.2E-10, 1.30019476195, 25241.820306823), new Vsop87.LnVsop(9.1E-10, 0.3448251777, 912.4788619305), new Vsop87.LnVsop(8.9E-10, 5.25882296348, 528.4671248172), new Vsop87.LnVsop(8.7E-10, 2.55502392314, 10323.4918674304), new Vsop87.LnVsop(9.2E-10, 5.75692439129, 113.1270825262), new Vsop87.LnVsop(8.3E-10, 1.67229948282, 229.7614216733), new Vsop87.LnVsop(1.1E-9, 1.58491727058, 1023.9572075371), new Vsop87.LnVsop(8.4E-10, 2.57764287124, 1448.9108670104), new Vsop87.LnVsop(8.4E-10, 1.61297525962, 1173.3603459773), new Vsop87.LnVsop(9.0E-10, 0.4268779114, 473.659314623), new Vsop87.LnVsop(1.0E-9, 4.61116427326, 582.3811631341), new Vsop87.LnVsop(9.3E-10, 5.7628749993, 203.8979265768), new Vsop87.LnVsop(1.02E-9, 0.7163146356, 26301.2022370122), new Vsop87.LnVsop(8.6E-10, 4.04071522456, 3789.5888888784), new Vsop87.LnVsop(1.08E-9, 1.27513065507, 946.727928415), new Vsop87.LnVsop(8.5E-10, 3.37712901665, 1621.3162241982), new Vsop87.LnVsop(9.9E-10, 1.96529929552, 1452.8430202735), new Vsop87.LnVsop(8.8E-10, 5.20958727187, 9470.2954856784), new Vsop87.LnVsop(8.5E-10, 0.31181175336, 627.1546650207), new Vsop87.LnVsop(8.1E-10, 3.03622757274, 196.8367692027), new Vsop87.LnVsop(8.3E-10, 2.42949595819, 818.574808252), new Vsop87.LnVsop(8.1E-10, 1.89609165087, 364.3467652809), new Vsop87.LnVsop(8.7E-10, 5.45538307617, 1147.4968508808), new Vsop87.LnVsop(8.0E-10, 5.25329934448, 4532.578949411), new Vsop87.LnVsop(8.2E-10, 0.02899852098, 4856.0843660684), new Vsop87.LnVsop(8.3E-10, 3.14142784311, 157.6399519819), new Vsop87.LnVsop(9.7E-10, 1.23841230494, 95.0160193713), new Vsop87.LnVsop(1.0E-9, 5.24393975284, 817.7716590999), new Vsop87.LnVsop(8.4E-10, 0.31157071716, 1599.9585368533), new Vsop87.LnVsop(8.8E-10, 4.27265950076, 1681.1199692385), new Vsop87.LnVsop(8.0E-10, 2.85939270432, 1268.7488723641), new Vsop87.LnVsop(8.6E-10, 0.97630886006, 200.0352092829), new Vsop87.LnVsop(8.3E-10, 2.28713281517, 12.7426212933), new Vsop87.LnVsop(9.7E-10, 0.91815961642, 1030.927742186), new Vsop87.LnVsop(7.9E-10, 3.07698098095, 206.0736738526), new Vsop87.LnVsop(9.1E-10, 5.75729901464, 807.9497991134), new Vsop87.LnVsop(8.7E-10, 0.42720761608, 10007.0999977738), new Vsop87.LnVsop(7.8E-10, 3.71839527643, 146.3818033969), new Vsop87.LnVsop(1.08E-9, 5.20280565998, 1184.4060462412), new Vsop87.LnVsop(9.2E-10, 2.60904862533, 154.0166152595), new Vsop87.LnVsop(8.4E-10, 0.32694738907, 1173.5204046717), new Vsop87.LnVsop(8.1E-10, 3.57713443867, 205.9731001161), new Vsop87.LnVsop(8.5E-10, 3.6736404E-4, 443.2729654324), new Vsop87.LnVsop(8.9E-10, 3.50851506346, 835.7878940127), new Vsop87.LnVsop(8.7E-10, 0.7689951262, 201.9927627432), new Vsop87.LnVsop(8.2E-10, 3.64624188259, 718.6110381444), new Vsop87.LnVsop(1.0E-9, 5.66342418624, 1115.2535219664), new Vsop87.LnVsop(8.0E-10, 2.72322567646, 458.090760265), new Vsop87.LnVsop(7.8E-10, 2.92017576269, 634.4806603426), new Vsop87.LnVsop(9.4E-10, 5.87172951757, 2545.3620512544), new Vsop87.LnVsop(8.2E-10, 5.30395730854, 111.1695290659), new Vsop87.LnVsop(7.6E-10, 5.9523503936, 649.4585138696), new Vsop87.LnVsop(9.2E-10, 4.6730874679, 596.6082571357), new Vsop87.LnVsop(7.6E-10, 5.61246309601, 595.7144852584), new Vsop87.LnVsop(8.8E-10, 1.35973650628, 4223.3006267552), new Vsop87.LnVsop(8.9E-10, 0.1859803037, 1482.0479678021), new Vsop87.LnVsop(7.7E-10, 0.65783702665, 567.8240007324), new Vsop87.LnVsop(7.4E-10, 3.13429668952, 529.1697002328), new Vsop87.LnVsop(7.7E-10, 1.78883058145, 171.6545976624), new Vsop87.LnVsop(1.01E-9, 2.01741399535, 943.7589829984), new Vsop87.LnVsop(8.1E-10, 3.1821723759, 534.3568315406), new Vsop87.LnVsop(7.7E-10, 5.55978103968, 878.3261636656), new Vsop87.LnVsop(8.8E-10, 4.96030794134, 5966.6839803348), new Vsop87.LnVsop(9.3E-10, 5.49611976914, 645.5263606065), new Vsop87.LnVsop(7.4E-10, 5.82012747215, 316.4400537664), new Vsop87.LnVsop(8.6E-10, 5.10320208624, 734.2319821291), new Vsop87.LnVsop(8.5E-10, 4.02471557641, 987.7817253596), new Vsop87.LnVsop(7.4E-10, 1.59328832031, 846.131018861), new Vsop87.LnVsop(7.7E-10, 5.04672541583, 238.5718897035), new Vsop87.LnVsop(9.5E-10, 4.71721046069, 1037.2905296614), new Vsop87.LnVsop(8.2E-10, 2.67123570357, 1877.0105769372), new Vsop87.LnVsop(8.8E-10, 3.4479654698, 1587.4283638811), new Vsop87.LnVsop(8.6E-10, 1.12360345918, 845.1196269047), new Vsop87.LnVsop(7.3E-10, 0.30784168957, 109.9938728983), new Vsop87.LnVsop(9.2E-10, 3.20015163409, 324.9898893657), new Vsop87.LnVsop(7.8E-10, 4.90441489556, 828.1360358076), new Vsop87.LnVsop(8.8E-10, 4.85305395851, 251.1714986449), new Vsop87.LnVsop(9.5E-10, 4.06828252459, 738.3241940866), new Vsop87.LnVsop(7.4E-10, 2.08215303049, 416.5638825684), new Vsop87.LnVsop(7.3E-10, 3.80312093402, 110.4187695405), new Vsop87.LnVsop(8.6E-10, 4.26211128325, 809.0135806964), new Vsop87.LnVsop(9.4E-10, 4.99996575655, 378.6432952517), new Vsop87.LnVsop(9.5E-10, 2.9649773329, 844.5983620429), new Vsop87.LnVsop(1.0E-9, 0.15146872601, 186.2117600641), new Vsop87.LnVsop(8.8E-10, 4.16731870359, 232.942815411), new Vsop87.LnVsop(7.2E-10, 2.01506338325, 94.4253185403), new Vsop87.LnVsop(7.6E-10, 4.72470357864, 195.7729876197), new Vsop87.LnVsop(7.2E-10, 0.63509909932, 645.3139122854), new Vsop87.LnVsop(8.5E-10, 3.70783979194, 1057.8974574809), new Vsop87.LnVsop(7.3E-10, 5.83760271337, 1560.6187072806), new Vsop87.LnVsop(7.2E-10, 0.86081417266, 3892.681663097), new Vsop87.LnVsop(7.2E-10, 0.99750824683, 280.2163874791), new Vsop87.LnVsop(7.7E-10, 1.14405747955, 227.5743735494), new Vsop87.LnVsop(7.1E-10, 0.96814412427, 544.6688186216), new Vsop87.LnVsop(8.8E-10, 1.03829142709, 266.952501324)};
        private static final Vsop87.LnVsop[] saturn_longitude_l1 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(213.2990952169, 0.0, 0.0), new Vsop87.LnVsop(0.01297370862, 1.82834923978, 213.299095438), new Vsop87.LnVsop(0.00564345393, 2.88499717272, 7.1135470008), new Vsop87.LnVsop(9.3734369E-4, 1.06311793502, 426.598190876), new Vsop87.LnVsop(0.00107674962, 2.27769131009, 206.1855484372), new Vsop87.LnVsop(4.0244455E-4, 2.04108104671, 220.4126424388), new Vsop87.LnVsop(1.9941774E-4, 1.2795439047, 103.0927742186), new Vsop87.LnVsop(1.0511678E-4, 2.7488034213, 14.2270940016), new Vsop87.LnVsop(6.416106E-5, 0.38238295041, 639.897286314), new Vsop87.LnVsop(4.848994E-5, 2.43037610229, 419.4846438752), new Vsop87.LnVsop(4.056892E-5, 2.92133209468, 110.2063212194), new Vsop87.LnVsop(3.768635E-5, 3.6496533078, 3.9321532631), new Vsop87.LnVsop(3.384691E-5, 2.41694503459, 3.1813937377), new Vsop87.LnVsop(3.231693E-5, 1.26149969158, 433.7117378768), new Vsop87.LnVsop(3.071405E-5, 2.32739504783, 199.0720014364), new Vsop87.LnVsop(1.953179E-5, 3.56378136497, 11.0457002639), new Vsop87.LnVsop(1.249468E-5, 2.62810757084, 95.9792272178), new Vsop87.LnVsop(9.2135E-6, 1.96069472334, 227.5261894396), new Vsop87.LnVsop(7.01524E-6, 4.43097553887, 529.6909650946), new Vsop87.LnVsop(6.49591E-6, 6.17410622073, 202.2533951741), new Vsop87.LnVsop(6.27498E-6, 6.1110981622, 309.2783226558), new Vsop87.LnVsop(4.68362E-6, 4.61704486774, 63.7358983034), new Vsop87.LnVsop(4.40442E-6, 6.0186116335, 853.196381752), new Vsop87.LnVsop(4.78347E-6, 4.98809792152, 522.5774180938), new Vsop87.LnVsop(4.088E-6, 2.10122200324, 323.5054166574), new Vsop87.LnVsop(4.07654E-6, 1.29967965754, 209.3669421749), new Vsop87.LnVsop(3.4372E-6, 3.95819456535, 412.3710968744), new Vsop87.LnVsop(3.38569E-6, 3.63538109408, 316.3918696566), new Vsop87.LnVsop(3.36129E-6, 3.77170200605, 735.8765135318), new Vsop87.LnVsop(3.31895E-6, 2.86077271205, 210.1177017003), new Vsop87.LnVsop(3.46963E-6, 2.24152661493, 632.7837393132), new Vsop87.LnVsop(2.89484E-6, 2.73211009526, 117.3198682202), new Vsop87.LnVsop(2.541E-6, 0.54280472223, 647.0108333148), new Vsop87.LnVsop(2.30497E-6, 1.64428691304, 216.4804891757), new Vsop87.LnVsop(2.8091E-6, 5.74399466555, 2.4476805548), new Vsop87.LnVsop(1.92275E-6, 2.96534476762, 224.3447957019), new Vsop87.LnVsop(1.71342E-6, 4.09606536666, 846.0828347512), new Vsop87.LnVsop(1.6711E-6, 2.59746814308, 21.3406410024), new Vsop87.LnVsop(1.36321E-6, 2.28588945465, 10.2949407385), new Vsop87.LnVsop(1.29468E-6, 3.4486372972, 742.9900605326), new Vsop87.LnVsop(1.27864E-6, 4.09556557491, 217.2312487011), new Vsop87.LnVsop(1.09809E-6, 6.16222822735, 415.5524906121), new Vsop87.LnVsop(9.3929E-7, 3.48395603528, 1052.2683831884), new Vsop87.LnVsop(9.25E-7, 3.94738565799, 88.865680217), new Vsop87.LnVsop(9.7503E-7, 4.72798517062, 838.9692877504), new Vsop87.LnVsop(8.5414E-7, 1.21992749767, 440.8252848776), new Vsop87.LnVsop(8.3544E-7, 3.11243528672, 625.6701923124), new Vsop87.LnVsop(7.7552E-7, 6.24420223771, 302.164775655), new Vsop87.LnVsop(6.1557E-7, 1.82806831206, 195.1398481733), new Vsop87.LnVsop(6.1894E-7, 4.29399030957, 127.4717966068), new Vsop87.LnVsop(6.71E-7, 0.28960408801, 4.665866446), new Vsop87.LnVsop(5.6935E-7, 5.01850216663, 137.0330241624), new Vsop87.LnVsop(5.4018E-7, 5.12526846805, 490.3340891794), new Vsop87.LnVsop(5.4588E-7, 0.28394184881, 74.7815985673), new Vsop87.LnVsop(6.5843E-7, 5.64781011841, 9.5612275556), new Vsop87.LnVsop(4.936E-7, 1.44414937308, 536.8045120954), new Vsop87.LnVsop(5.779E-7, 2.47591802875, 191.9584544356), new Vsop87.LnVsop(4.4445E-7, 2.70867717923, 5.4166259714), new Vsop87.LnVsop(4.6462E-7, 1.17725360336, 149.5631971346), new Vsop87.LnVsop(4.0352E-7, 3.88835739308, 728.762966531), new Vsop87.LnVsop(3.7766E-7, 2.53385959344, 12.5301729722), new Vsop87.LnVsop(4.6627E-7, 5.14898441386, 515.463871093), new Vsop87.LnVsop(4.5601E-7, 2.22651202659, 956.2891559706), new Vsop87.LnVsop(4.0425E-7, 0.41248570335, 269.9214467406), new Vsop87.LnVsop(3.7318E-7, 3.78007466606, 2.9207613068), new Vsop87.LnVsop(3.3848E-7, 3.21091304755, 1368.660252845), new Vsop87.LnVsop(3.7468E-7, 0.63301847328, 422.6660376129), new Vsop87.LnVsop(3.3013E-7, 0.30379634705, 351.8165923087), new Vsop87.LnVsop(3.0286E-7, 2.84006878726, 203.0041546995), new Vsop87.LnVsop(3.5096E-7, 6.08465483298, 5.6290742925), new Vsop87.LnVsop(3.3273E-7, 4.640252073, 277.0349937414), new Vsop87.LnVsop(3.1908E-7, 4.38588051077, 1155.361157407), new Vsop87.LnVsop(2.9011E-7, 3.38845528142, 1059.3819301892), new Vsop87.LnVsop(2.8659E-7, 2.0211899083, 330.6189636582), new Vsop87.LnVsop(2.9347E-7, 5.41549054397, 1066.49547719), new Vsop87.LnVsop(2.8266E-7, 2.74211823281, 265.9892934775), new Vsop87.LnVsop(3.0064E-7, 6.18691482959, 284.1485407422), new Vsop87.LnVsop(3.1444E-7, 2.43486054228, 52.6901980395), new Vsop87.LnVsop(2.6507E-7, 4.51149190693, 340.7708920448), new Vsop87.LnVsop(2.2023E-7, 5.14128268104, 4.192785694), new Vsop87.LnVsop(2.2201E-7, 1.96451679625, 203.7378678824), new Vsop87.LnVsop(2.1711E-7, 2.67663515039, 942.062061969), new Vsop87.LnVsop(2.2573E-7, 5.88439455151, 210.8514148832), new Vsop87.LnVsop(1.9449E-7, 4.76522617576, 70.8494453042), new Vsop87.LnVsop(1.926E-7, 2.30000060917, 437.6438911399), new Vsop87.LnVsop(1.9467E-7, 6.1635806985, 860.3099287528), new Vsop87.LnVsop(1.9308E-7, 4.10055638793, 18.1592472647), new Vsop87.LnVsop(2.2756E-7, 4.13890496693, 191.2076949102), new Vsop87.LnVsop(1.7772E-7, 2.43993724475, 423.4167971383), new Vsop87.LnVsop(1.7625E-7, 1.84879760332, 234.6397364404), new Vsop87.LnVsop(1.7917E-7, 0.90281001853, 429.7795846137), new Vsop87.LnVsop(1.539E-7, 4.2343555618, 1162.4747044078), new Vsop87.LnVsop(1.4518E-7, 3.60447992897, 1045.1548361876), new Vsop87.LnVsop(1.4098E-7, 2.94108637859, 1685.0521225016), new Vsop87.LnVsop(1.6365E-7, 4.04772986282, 949.1756089698), new Vsop87.LnVsop(1.3351E-7, 6.24525394105, 38.1330356378), new Vsop87.LnVsop(1.5958E-7, 1.06504854837, 56.6223513026), new Vsop87.LnVsop(1.4066E-7, 1.43547760486, 408.4389436113), new Vsop87.LnVsop(1.5765E-7, 5.59418374906, 6.1503391543), new Vsop87.LnVsop(1.3047E-7, 5.75713536656, 138.5174968707), new Vsop87.LnVsop(1.4963E-7, 5.77194144042, 22.0914005278), new Vsop87.LnVsop(1.591E-7, 1.93236196007, 1272.6810256272), new Vsop87.LnVsop(1.2859E-7, 4.24850891703, 405.2575498736), new Vsop87.LnVsop(1.3585E-7, 4.09378444821, 1471.7530270636), new Vsop87.LnVsop(1.5186E-7, 0.74349230082, 200.7689224658), new Vsop87.LnVsop(1.6343E-7, 5.95883716209, 628.8515860501), new Vsop87.LnVsop(1.0876E-7, 1.54843099228, 223.5940361765), new Vsop87.LnVsop(1.2178E-7, 1.86122230918, 131.4039498699), new Vsop87.LnVsop(1.1698E-7, 1.80956732786, 124.433415221), new Vsop87.LnVsop(1.0205E-7, 3.46772102734, 1375.7737998458), new Vsop87.LnVsop(1.0113E-7, 2.38081573177, 107.0249274817), new Vsop87.LnVsop(9.801E-8, 2.55376042251, 99.9113804809), new Vsop87.LnVsop(1.0569E-7, 5.35748271313, 215.7467759928), new Vsop87.LnVsop(1.2078E-7, 4.84566679178, 831.8557407496), new Vsop87.LnVsop(9.282E-8, 3.90397999336, 430.5303441391), new Vsop87.LnVsop(1.0209E-7, 6.07702154705, 32.2433289144), new Vsop87.LnVsop(9.247E-8, 3.65397916243, 142.4496501338), new Vsop87.LnVsop(9.333E-8, 5.8116812666, 7.1617311106), new Vsop87.LnVsop(8.973E-8, 1.23896814586, 106.2741679563), new Vsop87.LnVsop(9.584E-8, 1.38807709012, 145.6310438715), new Vsop87.LnVsop(8.092E-8, 4.41109592718, 703.6331846174), new Vsop87.LnVsop(8.37E-8, 5.64021200149, 62.2514255951), new Vsop87.LnVsop(8.365E-8, 2.42756208502, 1258.4539316256), new Vsop87.LnVsop(7.625E-8, 3.75230513033, 312.1990839626), new Vsop87.LnVsop(7.507E-8, 0.52825397746, 654.1243803156), new Vsop87.LnVsop(7.222E-8, 0.28432332038, 0.7507595254), new Vsop87.LnVsop(8.219E-8, 6.22089296322, 14.977853527), new Vsop87.LnVsop(7.047E-8, 0.53162328102, 388.4651552382), new Vsop87.LnVsop(6.575E-8, 3.48594056852, 35.4247226521), new Vsop87.LnVsop(9.019E-8, 4.94930308863, 208.633228992), new Vsop87.LnVsop(6.422E-8, 3.32913886531, 1361.5467058442), new Vsop87.LnVsop(8.828E-8, 0.08576921133, 288.0806940053), new Vsop87.LnVsop(6.468E-8, 2.89346190385, 114.1384744825), new Vsop87.LnVsop(6.244E-8, 0.54959845938, 65.2203710117), new Vsop87.LnVsop(6.147E-8, 2.67701859857, 2001.4439921582), new Vsop87.LnVsop(6.729E-8, 0.23473166872, 8.0767548473), new Vsop87.LnVsop(7.33E-8, 4.85397668762, 222.8603229936), new Vsop87.LnVsop(6.306E-8, 3.80609816761, 1788.1448967202), new Vsop87.LnVsop(5.794E-8, 4.39110470067, 81.7521332162), new Vsop87.LnVsop(6.114E-8, 0.88426580807, 92.0470739547), new Vsop87.LnVsop(6.916E-8, 2.04730284282, 99.1606209555), new Vsop87.LnVsop(5.224E-8, 5.49152647879, 563.6312150384), new Vsop87.LnVsop(6.227E-8, 1.60545827612, 1589.0728952838), new Vsop87.LnVsop(5.156E-8, 2.11913652877, 214.2623032845), new Vsop87.LnVsop(6.641E-8, 5.82592142759, 483.2205421786), new Vsop87.LnVsop(4.96E-8, 5.75655227165, 565.1156877467), new Vsop87.LnVsop(4.949E-8, 0.41506756602, 76.2660712756), new Vsop87.LnVsop(5.284E-8, 4.5806449086, 134.5853436076), new Vsop87.LnVsop(4.983E-8, 4.20110843598, 404.5067903482), new Vsop87.LnVsop(5.143E-8, 4.67534992519, 212.3358875915), new Vsop87.LnVsop(4.733E-8, 4.59040852304, 554.0699874828), new Vsop87.LnVsop(4.551E-8, 3.24564999051, 231.4583427027), new Vsop87.LnVsop(5.149E-8, 3.3357437859, 1.4844727083), new Vsop87.LnVsop(4.646E-8, 5.79841221351, 217.964961884), new Vsop87.LnVsop(4.468E-8, 0.12007438852, 295.0512286542), new Vsop87.LnVsop(4.609E-8, 0.45274542243, 362.8622925726), new Vsop87.LnVsop(4.476E-8, 5.37754871729, 497.4476361802), new Vsop87.LnVsop(4.962E-8, 3.77054763448, 1265.5674786264), new Vsop87.LnVsop(4.209E-8, 4.88259084305, 98.8999885246), new Vsop87.LnVsop(4.24E-8, 5.00130451925, 213.3472795478), new Vsop87.LnVsop(4.739E-8, 4.53295409208, 1148.2476104062), new Vsop87.LnVsop(5.056E-8, 2.20279742533, 207.8824694666), new Vsop87.LnVsop(3.647E-8, 0.55692708637, 750.1036075334), new Vsop87.LnVsop(3.59E-8, 1.83316476388, 225.8292684102), new Vsop87.LnVsop(3.553E-8, 0.35405996436, 333.657345044), new Vsop87.LnVsop(3.771E-8, 0.98541172336, 24.3790223882), new Vsop87.LnVsop(3.643E-8, 1.6134963491, 245.5424243524), new Vsop87.LnVsop(3.416E-8, 2.19565598832, 1574.8458012822), new Vsop87.LnVsop(3.326E-8, 5.32536836657, 347.8844390456), new Vsop87.LnVsop(3.648E-8, 0.80545608428, 343.2185725996), new Vsop87.LnVsop(3.23E-8, 0.21797740452, 635.9651330509), new Vsop87.LnVsop(4.252E-8, 1.8025133313, 213.2509113282), new Vsop87.LnVsop(3.11E-8, 3.03951432197, 1677.9385755008), new Vsop87.LnVsop(3.692E-8, 0.81899526461, 344.7030453079), new Vsop87.LnVsop(3.007E-8, 3.35935547424, 7.8643065262), new Vsop87.LnVsop(2.905E-8, 1.33932275244, 543.9180590962), new Vsop87.LnVsop(2.952E-8, 4.87373800642, 144.1465711632), new Vsop87.LnVsop(2.765E-8, 2.42541766183, 2317.8358618148), new Vsop87.LnVsop(3.051E-8, 4.3098992779, 6062.6632075526), new Vsop87.LnVsop(3.636E-8, 5.12822987131, 218.9281697305), new Vsop87.LnVsop(2.96E-8, 3.53539509519, 2104.5367663768), new Vsop87.LnVsop(3.22E-8, 2.88065191084, 216.2198567448), new Vsop87.LnVsop(2.89E-8, 5.73415956875, 9992.8729037722), new Vsop87.LnVsop(2.581E-8, 3.79872579706, 17.2654753874), new Vsop87.LnVsop(3.497E-8, 5.29659047575, 350.3321196004), new Vsop87.LnVsop(2.852E-8, 3.72852216251, 6076.8903015542), new Vsop87.LnVsop(2.825E-8, 2.5435487903, 1692.1656695024), new Vsop87.LnVsop(2.775E-8, 0.23409308831, 357.4456666012), new Vsop87.LnVsop(2.964E-8, 2.48786690434, 46.470422916), new Vsop87.LnVsop(2.494E-8, 4.3775623453, 217.491881132), new Vsop87.LnVsop(2.434E-8, 0.74936808231, 414.0680179038), new Vsop87.LnVsop(2.711E-8, 5.15376962514, 10007.0999977738), new Vsop87.LnVsop(3.124E-8, 1.92045529107, 17.4084877393), new Vsop87.LnVsop(3.11E-8, 1.71435795236, 1169.5882514086), new Vsop87.LnVsop(2.683E-8, 3.44460235259, 31.019488637), new Vsop87.LnVsop(3.07E-8, 0.27064671367, 120.358249606), new Vsop87.LnVsop(2.498E-8, 0.89152242639, 479.2883889155), new Vsop87.LnVsop(2.239E-8, 3.76466001926, 425.1137181677), new Vsop87.LnVsop(2.492E-8, 2.10872471949, 168.0525127994), new Vsop87.LnVsop(2.554E-8, 1.63237286968, 182.279606801), new Vsop87.LnVsop(2.212E-8, 3.15570115956, 212.7778305762), new Vsop87.LnVsop(2.345E-8, 2.33187767722, 218.7157214094), new Vsop87.LnVsop(2.512E-8, 4.52214797332, 198.321241911), new Vsop87.LnVsop(2.058E-8, 5.32848893146, 125.9873238985), new Vsop87.LnVsop(2.67E-8, 5.76962486601, 618.5566453116), new Vsop87.LnVsop(2.501E-8, 1.36963027063, 1905.4647649404), new Vsop87.LnVsop(2.258E-8, 3.21639296814, 273.1028404783), new Vsop87.LnVsop(2.143E-8, 4.82825483897, 1279.794572628), new Vsop87.LnVsop(2.052E-8, 1.27587061572, 14.0146456805), new Vsop87.LnVsop(2.615E-8, 0.71070461113, 85.8272988312), new Vsop87.LnVsop(2.093E-8, 3.39000145617, 160.6088973985), new Vsop87.LnVsop(1.983E-8, 0.3957372733, 358.9301393095), new Vsop87.LnVsop(2.197E-8, 5.93385162544, 13.3333221243), new Vsop87.LnVsop(1.947E-8, 1.11697571149, 447.9388318784), new Vsop87.LnVsop(1.963E-8, 2.32757954485, 28.4541880032), new Vsop87.LnVsop(2.225E-8, 3.64731297942, 213.8203602998), new Vsop87.LnVsop(1.993E-8, 1.357548667, 20.6069278195), new Vsop87.LnVsop(1.908E-8, 1.85043929897, 1.2720243872), new Vsop87.LnVsop(1.912E-8, 3.44056631214, 69.1525242748), new Vsop87.LnVsop(1.924E-8, 3.75344898408, 28.3111756513), new Vsop87.LnVsop(2.107E-8, 2.25960904718, 116.4260963429), new Vsop87.LnVsop(1.99E-8, 5.04917972011, 424.1505103212), new Vsop87.LnVsop(2.242E-8, 4.24915057068, 1464.6394800628), new Vsop87.LnVsop(1.837E-8, 5.40613525191, 31.492569389), new Vsop87.LnVsop(1.884E-8, 6.27237464104, 25.1297819136), new Vsop87.LnVsop(1.964E-8, 4.88959404434, 275.5505210331), new Vsop87.LnVsop(1.761E-8, 1.55538934409, 650.9429865779), new Vsop87.LnVsop(2.289E-8, 4.95949808683, 258.8757464767), new Vsop87.LnVsop(1.715E-8, 3.99957963119, 416.3032501375), new Vsop87.LnVsop(2.176E-8, 0.00746756006, 0.8937718773), new Vsop87.LnVsop(1.909E-8, 2.59860489663, 329.7251917809), new Vsop87.LnVsop(1.677E-8, 0.41818851015, 54.1746707478), new Vsop87.LnVsop(2.113E-8, 2.56576165077, 59.8037450403), new Vsop87.LnVsop(1.91E-8, 2.42712655158, 113.3877149571), new Vsop87.LnVsop(1.599E-8, 5.29789805696, 251.4321310758), new Vsop87.LnVsop(1.827E-8, 5.46952748031, 842.1506814881), new Vsop87.LnVsop(1.65E-8, 1.82771651512, 128.9562693151), new Vsop87.LnVsop(1.878E-8, 3.51442725486, 1581.959348283), new Vsop87.LnVsop(1.598E-8, 1.71834334467, 129.9194771616), new Vsop87.LnVsop(1.533E-8, 2.7692405381, 1994.3304451574), new Vsop87.LnVsop(1.688E-8, 1.91034000476, 278.5194664497), new Vsop87.LnVsop(1.99E-8, 5.28713202313, 508.3503240922), new Vsop87.LnVsop(1.961E-8, 1.22898590055, 621.7380390493), new Vsop87.LnVsop(1.507E-8, 0.54655212147, 320.3240229197), new Vsop87.LnVsop(1.683E-8, 2.63417306973, 767.3690829208), new Vsop87.LnVsop(1.459E-8, 2.01614186149, 1891.2376709388), new Vsop87.LnVsop(1.532E-8, 3.27409841371, 2420.9286360334), new Vsop87.LnVsop(1.431E-8, 0.21259204805, 643.0786800517), new Vsop87.LnVsop(1.443E-8, 5.51283885539, 1073.6090241908), new Vsop87.LnVsop(1.331E-8, 4.20981834774, 546.956440482), new Vsop87.LnVsop(1.364E-8, 4.00794878746, 721.6494195302), new Vsop87.LnVsop(1.37E-8, 0.00435400783, 1795.258443721), new Vsop87.LnVsop(1.548E-8, 6.10125434827, 280.9671470045), new Vsop87.LnVsop(1.368E-8, 2.06272463663, 192.6921676185), new Vsop87.LnVsop(1.296E-8, 4.84837761166, 45.5766510387), new Vsop87.LnVsop(1.267E-8, 5.28133965845, 173.9422195228), new Vsop87.LnVsop(1.401E-8, 6.13410133967, 39.3568759152), new Vsop87.LnVsop(1.252E-8, 2.19203979277, 2634.2277314714), new Vsop87.LnVsop(1.466E-8, 4.16355235441, 26.826702943), new Vsop87.LnVsop(1.285E-8, 3.76170874847, 2.2876218604), new Vsop87.LnVsop(1.263E-8, 3.65141438062, 264.5048207692), new Vsop87.LnVsop(1.489E-8, 5.41027945158, 214.0498549634), new Vsop87.LnVsop(1.429E-8, 0.71807502378, 254.9435932136), new Vsop87.LnVsop(1.181E-8, 0.42661254361, 41.6444977756), new Vsop87.LnVsop(1.391E-8, 2.15567541516, 2008.557539159), new Vsop87.LnVsop(1.161E-8, 5.23598298659, 181.0557665236), new Vsop87.LnVsop(1.538E-8, 3.62924135993, 561.1835344836), new Vsop87.LnVsop(1.121E-8, 1.08299011495, 6.592282139), new Vsop87.LnVsop(1.218E-8, 1.40812599648, 209.106309744), new Vsop87.LnVsop(1.083E-8, 0.27140934643, 184.0941479094), new Vsop87.LnVsop(1.345E-8, 6.11690814301, 207.6700211455), new Vsop87.LnVsop(1.09E-8, 4.74012700942, 78.7137518304), new Vsop87.LnVsop(1.113E-8, 0.96578641864, 305.3461693927), new Vsop87.LnVsop(1.189E-8, 4.76346210827, 219.4494345923), new Vsop87.LnVsop(1.202E-8, 3.47297831356, 51.2057253312), new Vsop87.LnVsop(1.094E-8, 1.86667293176, 1485.9801210652), new Vsop87.LnVsop(1.172E-8, 4.19848597258, 417.0369633204), new Vsop87.LnVsop(1.067E-8, 3.41866093436, 629.6023455755), new Vsop87.LnVsop(1.286E-8, 2.34110191143, 210.3783341312), new Vsop87.LnVsop(1.405E-8, 2.38547495352, 636.7158925763), new Vsop87.LnVsop(1.226E-8, 3.94550906032, 1781.0313497194), new Vsop87.LnVsop(1.109E-8, 4.88830425812, 1478.8665740644), new Vsop87.LnVsop(1.084E-8, 3.68973847177, 274.0660483248), new Vsop87.LnVsop(9.91E-9, 6.18957362221, 2111.6503133776), new Vsop87.LnVsop(9.87E-9, 2.1965936382, 617.8058857862), new Vsop87.LnVsop(1.051E-8, 1.05437128119, 237.6781178262), new Vsop87.LnVsop(9.88E-9, 6.04638824298, 291.262087743), new Vsop87.LnVsop(1.204E-8, 1.15120847561, 2221.856634597), new Vsop87.LnVsop(1.095E-8, 0.87682075285, 313.2104759189), new Vsop87.LnVsop(9.32E-9, 6.06709440285, 601.7642506762), new Vsop87.LnVsop(1.127E-8, 5.94936507654, 196.6243208816), new Vsop87.LnVsop(9.2E-9, 3.87350396084, 135.336103133), new Vsop87.LnVsop(1.111E-8, 5.24820138356, 189.7232222019), new Vsop87.LnVsop(9.8E-9, 0.80994813332, 436.8931316145), new Vsop87.LnVsop(9.03E-9, 2.3083085972, 312.4597163935), new Vsop87.LnVsop(8.77E-9, 0.11036923562, 267.4737661858), new Vsop87.LnVsop(8.81E-9, 3.6709469449, 25.2727942655), new Vsop87.LnVsop(9.03E-9, 3.52927348588, 643.8294395771), new Vsop87.LnVsop(8.7E-9, 2.91480922799, 211.8146227297), new Vsop87.LnVsop(1.09E-8, 0.40467871703, 692.5874843535), new Vsop87.LnVsop(1.076E-8, 0.14126679823, 175.1660598002), new Vsop87.LnVsop(9.33E-9, 3.2402118374, 214.7835681463), new Vsop87.LnVsop(9.31E-9, 4.46792395595, 77.962992305), new Vsop87.LnVsop(8.93E-9, 4.70654310595, 148.0787244263), new Vsop87.LnVsop(8.87E-9, 3.36333952309, 166.828672522), new Vsop87.LnVsop(8.55E-9, 5.52989068704, 205.2223405907), new Vsop87.LnVsop(8.53E-9, 1.02568311507, 491.8185618877), new Vsop87.LnVsop(8.16E-9, 4.75099680144, 776.9303104764), new Vsop87.LnVsop(8.12E-9, 6.11564621357, 488.8496164711), new Vsop87.LnVsop(1.128E-8, 1.36995647618, 337.732510659), new Vsop87.LnVsop(8.15E-9, 6.27092737025, 1382.8873468466), new Vsop87.LnVsop(7.9E-9, 0.89169444614, 342.2553647531), new Vsop87.LnVsop(1.076E-8, 5.31614813327, 235.3904959658), new Vsop87.LnVsop(7.61E-9, 2.48192692858, 2310.722314814), new Vsop87.LnVsop(7.89E-9, 0.05788153963, 543.0242872189), new Vsop87.LnVsop(7.52E-9, 3.76519728356, 916.9322800554), new Vsop87.LnVsop(7.54E-9, 5.18365928022, 244.318584075), new Vsop87.LnVsop(9.39E-9, 5.77229186804, 501.3797894433), new Vsop87.LnVsop(9.67E-9, 1.3173883427, 486.4019359163), new Vsop87.LnVsop(7.9E-9, 2.98595083986, 2737.32050569), new Vsop87.LnVsop(7.74E-9, 6.26950492111, 151.0476698429), new Vsop87.LnVsop(9.39E-9, 5.48036983143, 339.2864193365), new Vsop87.LnVsop(7.1E-9, 2.41625453577, 247.2393453818), new Vsop87.LnVsop(7.94E-9, 2.59522645936, 1.6445314027), new Vsop87.LnVsop(7.23E-9, 4.56009184704, 121.2520214833), new Vsop87.LnVsop(8.57E-9, 1.99272123647, 248.7238180901), new Vsop87.LnVsop(6.83E-9, 5.50977618441, 487.3651437628), new Vsop87.LnVsop(6.78E-9, 6.10807510472, 867.4234757536), new Vsop87.LnVsop(6.9E-9, 3.76660351032, 1038.0412891868), new Vsop87.LnVsop(7.61E-9, 4.61027550357, 23.5758732361), new Vsop87.LnVsop(6.73E-9, 5.68235998909, 319.5732633943), new Vsop87.LnVsop(8.08E-9, 3.2131227348, 1898.3512179396), new Vsop87.LnVsop(7.15E-9, 5.00023555936, 220.4608265486), new Vsop87.LnVsop(6.39E-9, 5.92948462252, 2428.0421830342), new Vsop87.LnVsop(6.37E-9, 1.86001190818, 2207.6295405954), new Vsop87.LnVsop(6.15E-9, 2.49867623797, 444.7574381407), new Vsop87.LnVsop(7.64E-9, 1.81804298404, 2324.9494088156), new Vsop87.LnVsop(6.72E-9, 2.54160500837, 271.4059194489), new Vsop87.LnVsop(7.37E-9, 1.50543762956, 268.4369740323), new Vsop87.LnVsop(8.36E-9, 1.26618033038, 212.5483359126), new Vsop87.LnVsop(6.37E-9, 2.20572760431, 1802.3719907218), new Vsop87.LnVsop(6.71E-9, 4.00880206711, 425.6349830295), new Vsop87.LnVsop(6.03E-9, 0.64742621983, 207.1487562837), new Vsop87.LnVsop(5.98E-9, 1.51837804657, 427.5613987225), new Vsop87.LnVsop(5.96E-9, 1.9256845514, 2950.619601128), new Vsop87.LnVsop(6.01E-9, 6.22126671427, 228.276948965), new Vsop87.LnVsop(7.37E-9, 5.27939281526, 204.7010757289), new Vsop87.LnVsop(7.2E-9, 2.58510714719, 472.1748419147), new Vsop87.LnVsop(5.95E-9, 4.72112782623, 380.12776796), new Vsop87.LnVsop(6.83E-9, 3.8322386642, 43.2890291783), new Vsop87.LnVsop(6.84E-9, 3.66033684379, 2097.423219376), new Vsop87.LnVsop(6.77E-9, 4.53513985772, 5863.5912061162), new Vsop87.LnVsop(5.7E-9, 1.18346560079, 131.5469622218), new Vsop87.LnVsop(7.31E-9, 2.69927545658, 16.6747745564), new Vsop87.LnVsop(5.63E-9, 6.07653636333, 241.6102710893), new Vsop87.LnVsop(5.64E-9, 5.70013327331, 696.5196376166), new Vsop87.LnVsop(6.65E-9, 5.96873852837, 9793.8009023358), new Vsop87.LnVsop(5.49E-9, 4.92449367054, 188.9200730498), new Vsop87.LnVsop(5.56E-9, 5.75593773439, 533.6231183577), new Vsop87.LnVsop(5.5E-9, 5.49717741465, 206.233732547), new Vsop87.LnVsop(5.56E-9, 4.59787882758, 411.620337349), new Vsop87.LnVsop(5.72E-9, 5.79171128918, 195.8906076987), new Vsop87.LnVsop(6.9E-9, 1.01867006902, 381.3516082374), new Vsop87.LnVsop(6.5E-9, 6.28308874623, 556.5176680376), new Vsop87.LnVsop(5.84E-9, 5.43287379445, 526.5095713569), new Vsop87.LnVsop(5.2E-9, 2.19322568805, 180.1619946463), new Vsop87.LnVsop(6.73E-9, 4.45121662104, 105.5404547734), new Vsop87.LnVsop(5.43E-9, 4.19353137744, 213.1872208534), new Vsop87.LnVsop(5.92E-9, 4.2825907372, 905.8865797915), new Vsop87.LnVsop(5.75E-9, 3.9859591595, 140.001969579), new Vsop87.LnVsop(5.49E-9, 3.29327549224, 193.655375465), new Vsop87.LnVsop(5.86E-9, 3.03561621613, 6275.9623029906), new Vsop87.LnVsop(5.39E-9, 0.80688137797, 458.8415197904), new Vsop87.LnVsop(5.66E-9, 4.23028541931, 426.6463749858), new Vsop87.LnVsop(5.1E-9, 1.10982373938, 738.7972748386), new Vsop87.LnVsop(5.9E-9, 4.09764962186, 436.1594184316), new Vsop87.LnVsop(5.78E-9, 5.76630812428, 963.4027029714), new Vsop87.LnVsop(5.05E-9, 2.95732719798, 135.5485514541), new Vsop87.LnVsop(4.92E-9, 2.71568281674, 84.9335269539), new Vsop87.LnVsop(4.74E-9, 5.99252453125, 289.5651667136), new Vsop87.LnVsop(4.86E-9, 5.24155754727, 5849.3641121146), new Vsop87.LnVsop(6.44E-9, 4.91580087837, 824.7421937488), new Vsop87.LnVsop(5.67E-9, 4.53417326513, 10206.1719992102), new Vsop87.LnVsop(4.75E-9, 6.19959930188, 397.3932433474), new Vsop87.LnVsop(5.52E-9, 1.46641944663, 42.5382696529), new Vsop87.LnVsop(4.47E-9, 2.59259132013, 7.2254215854), new Vsop87.LnVsop(5.45E-9, 0.04176014331, 221.3758502853), new Vsop87.LnVsop(4.49E-9, 0.4707013341, 306.0969289181), new Vsop87.LnVsop(4.49E-9, 5.79259534172, 685.4739373527), new Vsop87.LnVsop(4.97E-9, 1.91225950427, 831.1049812242), new Vsop87.LnVsop(4.72E-9, 5.76556319499, 570.7447620392), new Vsop87.LnVsop(5.43E-9, 2.60337387591, 213.4109700226), new Vsop87.LnVsop(4.76E-9, 1.86523349842, 980.6681783588), new Vsop87.LnVsop(5.25E-9, 5.41470067852, 699.7010313543), new Vsop87.LnVsop(5.68E-9, 0.92576336154, 2538.2485042536), new Vsop87.LnVsop(4.85E-9, 0.61141693408, 41.0537969446), new Vsop87.LnVsop(4.34E-9, 5.97213044475, 576.1613880106), new Vsop87.LnVsop(4.22E-9, 4.60394612547, 710.7467316182), new Vsop87.LnVsop(4.11E-9, 1.34966980065, 27.0873353739), new Vsop87.LnVsop(4.13E-9, 4.83700122362, 429.0458714308), new Vsop87.LnVsop(4.08E-9, 1.57481461411, 241.7532834412), new Vsop87.LnVsop(5.05E-9, 2.85524554478, 327.4375699205), new Vsop87.LnVsop(4.34E-9, 2.72438932125, 3053.7123753466), new Vsop87.LnVsop(4.24E-9, 4.03073158555, 739.8086667949), new Vsop87.LnVsop(4.0E-9, 5.00202145163, 431.264057322), new Vsop87.LnVsop(3.94E-9, 1.80181930923, 184.9879197867), new Vsop87.LnVsop(4.31E-9, 2.02055510167, 525.7588118315), new Vsop87.LnVsop(4.56E-9, 1.9837318336, 213.5115437591), new Vsop87.LnVsop(3.85E-9, 5.66636299791, 519.3960243561), new Vsop87.LnVsop(4.15E-9, 4.41614347545, 179.3588454942), new Vsop87.LnVsop(3.75E-9, 4.64683561376, 409.9234163196), new Vsop87.LnVsop(3.89E-9, 5.74762722112, 849.2642284889), new Vsop87.LnVsop(3.75E-9, 5.86666869275, 19.643719973), new Vsop87.LnVsop(3.9E-9, 2.10901103499, 731.9443602687), new Vsop87.LnVsop(4.39E-9, 3.38020838546, 2413.8150890326), new Vsop87.LnVsop(3.8E-9, 2.33004090915, 2627.1141844706), new Vsop87.LnVsop(4.05E-9, 3.15000005309, 2214.7430875962), new Vsop87.LnVsop(3.74E-9, 0.4132219842, 9779.5738083342), new Vsop87.LnVsop(3.79E-9, 4.79045619616, 421.93232443), new Vsop87.LnVsop(3.81E-9, 3.49547033281, 1354.4331588434), new Vsop87.LnVsop(3.75E-9, 1.15376522878, 569.0478410098), new Vsop87.LnVsop(3.66E-9, 1.36950986067, 835.0371344873), new Vsop87.LnVsop(4.56E-9, 4.81317341975, 213.0866471169), new Vsop87.LnVsop(3.91E-9, 0.63869657954, 206.1373643274), new Vsop87.LnVsop(3.77E-9, 5.03922180095, 298.2326223919), new Vsop87.LnVsop(3.89E-9, 3.23546953234, 760.25553592), new Vsop87.LnVsop(3.61E-9, 3.97052467541, 92.7978334801), new Vsop87.LnVsop(3.84E-9, 0.99158031411, 282.6640680339), new Vsop87.LnVsop(4.72E-9, 1.54703074354, 421.1815649046), new Vsop87.LnVsop(3.51E-9, 0.67273886199, 305.0855369618), new Vsop87.LnVsop(3.86E-9, 4.64254644028, 170.7608257851), new Vsop87.LnVsop(3.65E-9, 6.20540615033, 181.806526049), new Vsop87.LnVsop(3.93E-9, 2.12942707805, 532.6117264014), new Vsop87.LnVsop(3.83E-9, 0.05185541996, 252.6559713532), new Vsop87.LnVsop(4.67E-9, 2.26337241837, 518.6452648307), new Vsop87.LnVsop(4.06E-9, 2.18134488483, 2118.7638603784), new Vsop87.LnVsop(3.56E-9, 3.19586885413, 945.9942152321), new Vsop87.LnVsop(3.61E-9, 0.50233063987, 50.4025761791), new Vsop87.LnVsop(3.34E-9, 5.63337650974, 2744.4340526908), new Vsop87.LnVsop(4.59E-9, 5.37964866365, 934.9485149682), new Vsop87.LnVsop(3.78E-9, 3.56033503151, 1119.1856752295), new Vsop87.LnVsop(3.44E-9, 3.96892381773, 610.6923387854), new Vsop87.LnVsop(3.85E-9, 0.47930663456, 263.7016716171), new Vsop87.LnVsop(3.24E-9, 3.68349538825, 72.0732855816), new Vsop87.LnVsop(4.26E-9, 3.89784222224, 525.4981794006), new Vsop87.LnVsop(3.58E-9, 4.11241839677, 37.8724032069), new Vsop87.LnVsop(3.78E-9, 2.02895767226, 285.6330134505), new Vsop87.LnVsop(3.19E-9, 0.23235332054, 705.1176573257), new Vsop87.LnVsop(3.37E-9, 4.89868242091, 898.7730327907), new Vsop87.LnVsop(3.1E-9, 2.86499460237, 913.9633346388), new Vsop87.LnVsop(3.16E-9, 5.77993661207, 69.3649725959), new Vsop87.LnVsop(3.57E-9, 4.08921720644, 511.5317178299), new Vsop87.LnVsop(3.04E-9, 4.17744815606, 73.297125859), new Vsop87.LnVsop(3.37E-9, 3.31563536598, 391.1734682239), new Vsop87.LnVsop(3.83E-9, 1.51729490652, 2641.3412784722), new Vsop87.LnVsop(2.97E-9, 5.50908719718, 702.1487119091), new Vsop87.LnVsop(3.43E-9, 2.62919531951, 213.5597278689), new Vsop87.LnVsop(3.39E-9, 2.60492937184, 518.3846323998), new Vsop87.LnVsop(2.91E-9, 4.98832153464, 778.4147831847), new Vsop87.LnVsop(3.1E-9, 1.57685156193, 259.769518354), new Vsop87.LnVsop(3.27E-9, 2.86020999144, 724.8308132679), new Vsop87.LnVsop(2.93E-9, 5.71827875268, 60.7669528868), new Vsop87.LnVsop(3.23E-9, 4.94511156125, 409.1897031367), new Vsop87.LnVsop(3.26E-9, 1.93871115533, 480.7728616238), new Vsop87.LnVsop(2.88E-9, 0.87763268205, 887.7273325268), new Vsop87.LnVsop(3.01E-9, 4.30795192233, 206.706813299), new Vsop87.LnVsop(3.8E-9, 2.84673036576, 774.4826299216), new Vsop87.LnVsop(2.8E-9, 1.6649123383, 405.9912630565), new Vsop87.LnVsop(2.81E-9, 0.91462178099, 273.8536000037), new Vsop87.LnVsop(2.79E-9, 1.76942204576, 945.2434557067), new Vsop87.LnVsop(3.31E-9, 2.74250642576, 22.8945496799), new Vsop87.LnVsop(2.81E-9, 5.2841204641, 403.0223176399), new Vsop87.LnVsop(3.62E-9, 2.99550257971, 624.919432787), new Vsop87.LnVsop(2.83E-9, 0.67877937506, 395.578702239), new Vsop87.LnVsop(3.29E-9, 5.90836544487, 100.6450936638), new Vsop87.LnVsop(2.74E-9, 1.62260137014, 681.5417840896), new Vsop87.LnVsop(3.07E-9, 2.71913510791, 406.954470903), new Vsop87.LnVsop(2.84E-9, 3.66870476412, 188.0263011725), new Vsop87.LnVsop(3.19E-9, 5.24796235885, 229.9738699944), new Vsop87.LnVsop(2.72E-9, 2.70582939183, 953.1077622329), new Vsop87.LnVsop(3.35E-9, 4.61515142526, 468.2426886516), new Vsop87.LnVsop(2.65E-9, 1.55747103351, 952.3570027075), new Vsop87.LnVsop(2.65E-9, 2.61338076723, 739.0579072695), new Vsop87.LnVsop(2.61E-9, 4.08135671345, 25.8634950965), new Vsop87.LnVsop(2.61E-9, 4.0594864347, 990.2294059144), new Vsop87.LnVsop(2.96E-9, 4.49128669347, 693.5506922), new Vsop87.LnVsop(2.59E-9, 3.70714931093, 756.3233826569), new Vsop87.LnVsop(2.76E-9, 3.54024051938, 319.3126309634), new Vsop87.LnVsop(2.92E-9, 0.65370180027, 25867.49049913539), new Vsop87.LnVsop(2.92E-9, 0.12510953311, 25881.717593137), new Vsop87.LnVsop(2.88E-9, 3.98602872988, 707.7777862016), new Vsop87.LnVsop(2.85E-9, 1.92324537515, 3134.4268782626), new Vsop87.LnVsop(2.84E-9, 2.45405555508, 3120.199784261), new Vsop87.LnVsop(2.51E-9, 5.49392546588, 552.5855147745), new Vsop87.LnVsop(2.49E-9, 4.9947667069, 211.6021744086), new Vsop87.LnVsop(2.7E-9, 2.96399363494, 2730.2069586892), new Vsop87.LnVsop(2.54E-9, 0.93636425304, 462.0229135281), new Vsop87.LnVsop(2.58E-9, 1.97005667122, 3267.0114707846), new Vsop87.LnVsop(3.33E-9, 4.37215832017, 732.6951197941), new Vsop87.LnVsop(2.49E-9, 4.40993480586, 419.532827985), new Vsop87.LnVsop(2.4E-9, 1.43024411751, 823.9914342234), new Vsop87.LnVsop(2.66E-9, 2.8414091874, 2531.1349572528), new Vsop87.LnVsop(2.71E-9, 3.45824123786, 630.3360587584), new Vsop87.LnVsop(3.06E-9, 4.4845794921, 913.0001267923), new Vsop87.LnVsop(2.41E-9, 1.53210253391, 662.531203563), new Vsop87.LnVsop(2.46E-9, 6.09302475217, 611.4430983108), new Vsop87.LnVsop(3.21E-9, 1.11838394926, 426.5500067662), new Vsop87.LnVsop(2.87E-9, 5.68497603085, 33.9402499438), new Vsop87.LnVsop(2.32E-9, 5.38365779456, 815.0633461142), new Vsop87.LnVsop(2.33E-9, 3.21618054553, 230.5645708254), new Vsop87.LnVsop(2.29E-9, 3.80431337124, 58.1068240109), new Vsop87.LnVsop(2.3E-9, 2.1114755789, 2943.5060541272), new Vsop87.LnVsop(2.39E-9, 3.25558823312, 638.9340784675), new Vsop87.LnVsop(2.2E-9, 0.95686592581, 1894.4190646765), new Vsop87.LnVsop(2.88E-9, 5.03408953047, 714.6788848813), new Vsop87.LnVsop(2.19E-9, 4.97799409159, 354.9979860464), new Vsop87.LnVsop(2.17E-9, 1.68511614749, 2524.021410252), new Vsop87.LnVsop(2.22E-9, 3.48856424574, 212.0270710508), new Vsop87.LnVsop(2.17E-9, 0.721668094, 757.2171545342), new Vsop87.LnVsop(2.23E-9, 1.92215883184, 938.1299087059), new Vsop87.LnVsop(2.17E-9, 3.05680736768, 1130.2313754934), new Vsop87.LnVsop(2.75E-9, 1.36259423, 292.0128472684), new Vsop87.LnVsop(2.75E-9, 1.22972617627, 2957.7331481288), new Vsop87.LnVsop(2.43E-9, 1.7388899115, 432.0148168474), new Vsop87.LnVsop(2.13E-9, 2.96147626163, 67.6680515665), new Vsop87.LnVsop(2.53E-9, 3.09431326008, 29.2049475286), new Vsop87.LnVsop(2.44E-9, 3.15828383212, 7.0016724162), new Vsop87.LnVsop(2.58E-9, 3.94711896782, 1049.0869894507), new Vsop87.LnVsop(2.1E-9, 0.92691531069, 864.2420820159), new Vsop87.LnVsop(2.16E-9, 0.12205673729, 28.5718080822), new Vsop87.LnVsop(2.17E-9, 4.30267078355, 637.4496057592), new Vsop87.LnVsop(2.15E-9, 4.11358919807, 540.7366653585), new Vsop87.LnVsop(2.26E-9, 3.91981304355, 361.3778198643), new Vsop87.LnVsop(2.06E-9, 3.06573974753, 638.4128136057), new Vsop87.LnVsop(2.12E-9, 2.07343849515, 1357.6145525811), new Vsop87.LnVsop(2.06E-9, 4.76320283392, 244.791664827), new Vsop87.LnVsop(2.15E-9, 1.25169484126, 477.8039162072), new Vsop87.LnVsop(2.02E-9, 0.83522072662, 1901.5326116773), new Vsop87.LnVsop(1.99E-9, 4.85324797953, 453.424893819), new Vsop87.LnVsop(2.07E-9, 3.81971465476, 287.9376816534), new Vsop87.LnVsop(2.03E-9, 2.1402503956, 5856.4776591154), new Vsop87.LnVsop(2.5E-9, 5.24129479641, 2015.6710861598), new Vsop87.LnVsop(2.36E-9, 4.28324419129, 432.2272651685), new Vsop87.LnVsop(2.11E-9, 1.68715027741, 535.9107402181), new Vsop87.LnVsop(1.97E-9, 4.71448115756, 394.3548619616), new Vsop87.LnVsop(1.95E-9, 5.87802401359, 572.2292347475), new Vsop87.LnVsop(2.0E-9, 4.89097544068, 5650.2921106782), new Vsop87.LnVsop(1.93E-9, 4.2077843635, 141.6988906084), new Vsop87.LnVsop(2.35E-9, 6.03805082386, 1044.4040766622), new Vsop87.LnVsop(1.95E-9, 3.38080072732, 334.5511169213), new Vsop87.LnVsop(2.15E-9, 4.89303865565, 226.0417167313), new Vsop87.LnVsop(1.95E-9, 2.79052383726, 25448.00585526019), new Vsop87.LnVsop(2.13E-9, 1.01587660832, 420.4478517217), new Vsop87.LnVsop(2.48E-9, 0.66849102314, 627.3671133418), new Vsop87.LnVsop(1.95E-9, 0.58357607695, 661.2379273164), new Vsop87.LnVsop(2.39E-9, 1.61549656794, 484.7050148869), new Vsop87.LnVsop(1.9E-9, 4.5954229051, 464.7312265138), new Vsop87.LnVsop(2.36E-9, 4.74825845225, 448.6895914038), new Vsop87.LnVsop(1.97E-9, 0.70877760895, 5268.4554629428), new Vsop87.LnVsop(1.98E-9, 5.24830954641, 835.7878940127), new Vsop87.LnVsop(2.14E-9, 0.49644344151, 114.3991069134), new Vsop87.LnVsop(2.0E-9, 3.90819588718, 418.5214360287), new Vsop87.LnVsop(1.92E-9, 3.08447389331, 219.891377577), new Vsop87.LnVsop(2.52E-9, 0.59577510798, 481.7360694703), new Vsop87.LnVsop(2.1E-9, 1.47873307456, 205.4347889118), new Vsop87.LnVsop(1.97E-9, 2.47312566093, 1041.2226829245), new Vsop87.LnVsop(1.97E-9, 5.78596362795, 1699.2792165032), new Vsop87.LnVsop(2.29E-9, 2.1529456319, 55.1378785943), new Vsop87.LnVsop(2.11E-9, 5.72331015659, 465.9550667912), new Vsop87.LnVsop(2.19E-9, 5.09141093915, 71.6002048296), new Vsop87.LnVsop(2.01E-9, 2.71361439451, 586.3133163972), new Vsop87.LnVsop(2.07E-9, 4.09887010479, 432.7485300303), new Vsop87.LnVsop(2.1E-9, 0.93478002718, 551.031606097), new Vsop87.LnVsop(1.8E-9, 0.75887949038, 640.8604941605), new Vsop87.LnVsop(1.85E-9, 0.06297798536, 9580.5018068978), new Vsop87.LnVsop(1.83E-9, 0.75734481539, 4649.8988176312), new Vsop87.LnVsop(1.78E-9, 2.54931047505, 426.0769260142), new Vsop87.LnVsop(1.83E-9, 5.40214111593, 449.232108125), new Vsop87.LnVsop(1.92E-9, 5.83214375216, 212.4053235607), new Vsop87.LnVsop(1.91E-9, 5.76589986514, 188.1693135244), new Vsop87.LnVsop(2.0E-9, 1.17340443616, 4952.0635932862), new Vsop87.LnVsop(1.75E-9, 3.62894671655, 62.038977274), new Vsop87.LnVsop(1.79E-9, 5.33862243149, 504.561183181), new Vsop87.LnVsop(1.78E-9, 5.46255862891, 1080.7225711916), new Vsop87.LnVsop(2.23E-9, 3.4833453562, 827.9235874865), new Vsop87.LnVsop(2.06E-9, 1.31950519903, 230.7075831773), new Vsop87.LnVsop(1.73E-9, 0.34682515407, 775.233389447), new Vsop87.LnVsop(2.03E-9, 4.55782575605, 398.1440028728), new Vsop87.LnVsop(1.71E-9, 5.02502465606, 93.531546663), new Vsop87.LnVsop(1.97E-9, 2.52828823882, 286.596221297), new Vsop87.LnVsop(2.03E-9, 4.4627273183, 1141.1340634054), new Vsop87.LnVsop(1.71E-9, 1.17621965762, 439.1283638482), new Vsop87.LnVsop(2.35E-9, 0.71854455488, 2854.6403739102), new Vsop87.LnVsop(1.7E-9, 2.52247386072, 4230.414173756), new Vsop87.LnVsop(1.7E-9, 5.35148826943, 3060.8259223474), new Vsop87.LnVsop(1.71E-9, 0.83639716225, 1165.6560981455), new Vsop87.LnVsop(2.02E-9, 4.78048042035, 1596.1864422846), new Vsop87.LnVsop(1.68E-9, 4.46665083242, 1251.3403846248), new Vsop87.LnVsop(2.16E-9, 2.76419314772, 336.8387387817), new Vsop87.LnVsop(2.01E-9, 4.40543178813, 119.767548775), new Vsop87.LnVsop(1.77E-9, 3.71459442547, 1056.2005364515), new Vsop87.LnVsop(1.95E-9, 4.50146605932, 172.2452984934), new Vsop87.LnVsop(1.78E-9, 3.30601144188, 1670.8250285), new Vsop87.LnVsop(1.87E-9, 0.29230663399, 420.9691165835), new Vsop87.LnVsop(1.65E-9, 1.42862210897, 393.4610900843), new Vsop87.LnVsop(1.64E-9, 2.21783343046, 19999.97290154599), new Vsop87.LnVsop(1.83E-9, 3.54662980988, 639.9454704238), new Vsop87.LnVsop(1.97E-9, 6.09329045432, 450.9772132642), new Vsop87.LnVsop(1.62E-9, 2.04232180441, 232.942815411), new Vsop87.LnVsop(1.62E-9, 5.4174184102, 597.3590166611), new Vsop87.LnVsop(1.61E-9, 5.23936155671, 98.4269077726), new Vsop87.LnVsop(1.6E-9, 0.55319954265, 5429.8794682394), new Vsop87.LnVsop(1.78E-9, 0.75722309082, 3171.0322435668), new Vsop87.LnVsop(1.89E-9, 5.30587912038, 1257.7031721002), new Vsop87.LnVsop(1.83E-9, 1.3948837705, 561.934294009), new Vsop87.LnVsop(1.61E-9, 2.58835334097, 1026.2448293975), new Vsop87.LnVsop(1.69E-9, 2.3922469688, 214.5711198252), new Vsop87.LnVsop(1.6E-9, 0.0233205339, 952.0963702766), new Vsop87.LnVsop(1.65E-9, 5.52028556416, 238.4288773516), new Vsop87.LnVsop(1.67E-9, 4.22204525301, 121.8427223143), new Vsop87.LnVsop(1.56E-9, 2.23201534856, 353.301065017), new Vsop87.LnVsop(1.55E-9, 2.37254283146, 3067.9394693482), new Vsop87.LnVsop(1.73E-9, 1.47028209831, 33.1371007917), new Vsop87.LnVsop(1.63E-9, 4.38548740081, 81.8951455681), new Vsop87.LnVsop(1.65E-9, 2.66510591872, 423.6774295692), new Vsop87.LnVsop(1.58E-9, 0.00790966605, 107.7586406646), new Vsop87.LnVsop(1.54E-9, 2.82175953097, 428.0826635843), new Vsop87.LnVsop(1.74E-9, 1.28271482494, 460.5384408198), new Vsop87.LnVsop(1.54E-9, 1.66553955952, 115.6229471908), new Vsop87.LnVsop(1.72E-9, 5.68697470237, 364.3467652809), new Vsop87.LnVsop(1.57E-9, 1.52766501087, 426.7100654606), new Vsop87.LnVsop(1.5E-9, 3.14467817848, 820.0592809603), new Vsop87.LnVsop(1.52E-9, 1.25095906759, 1261.6353253633), new Vsop87.LnVsop(2.01E-9, 4.38127083242, 418.0001711669), new Vsop87.LnVsop(1.55E-9, 2.82889364566, 184.8449074348), new Vsop87.LnVsop(1.7E-9, 0.52637509428, 558.0021407459), new Vsop87.LnVsop(1.8E-9, 4.57118365613, 1457.525933062), new Vsop87.LnVsop(1.47E-9, 1.04705196368, 100.1720129118), new Vsop87.LnVsop(1.46E-9, 1.97663966745, 9360.089164459), new Vsop87.LnVsop(1.79E-9, 3.1662184984, 857.1285350151), new Vsop87.LnVsop(1.44E-9, 3.54638621538, 614.6244920485), new Vsop87.LnVsop(1.48E-9, 5.79801573208, 856.3777754897), new Vsop87.LnVsop(1.91E-9, 6.11542019555, 606.7601855223), new Vsop87.LnVsop(1.58E-9, 0.11592836628, 384.0599212231), new Vsop87.LnVsop(1.49E-9, 3.60725261749, 205.6642835754), new Vsop87.LnVsop(1.87E-9, 6.26535099398, 1037.2905296614), new Vsop87.LnVsop(1.83E-9, 3.32728254607, 1262.3860848887), new Vsop87.LnVsop(1.64E-9, 4.78384880793, 74.6385862154), new Vsop87.LnVsop(1.59E-9, 1.79960566477, 326.6868103951), new Vsop87.LnVsop(1.49E-9, 2.79221326468, 427.1194557378), new Vsop87.LnVsop(1.69E-9, 3.44710717206, 649.4585138696), new Vsop87.LnVsop(1.59E-9, 0.85238137539, 419.4364597654), new Vsop87.LnVsop(1.38E-9, 1.19046476833, 422.405405182), new Vsop87.LnVsop(1.42E-9, 2.77065540297, 2847.5268269094), new Vsop87.LnVsop(1.63E-9, 4.06958340535, 1372.5924061081), new Vsop87.LnVsop(1.45E-9, 5.52904758486, 909.8187330546), new Vsop87.LnVsop(1.36E-9, 2.18168456444, 3370.1042450032), new Vsop87.LnVsop(1.82E-9, 2.04294180021, 429.5189521828), new Vsop87.LnVsop(1.71E-9, 4.16864035753, 213.0384630071), new Vsop87.LnVsop(1.33E-9, 1.27630544358, 1578.0271950199), new Vsop87.LnVsop(1.52E-9, 0.66132933864, 494.2662424425), new Vsop87.LnVsop(1.31E-9, 5.61666236101, 842.9014410135), new Vsop87.LnVsop(1.69E-9, 0.34789506026, 639.8491022042), new Vsop87.LnVsop(1.73E-9, 2.17720588116, 2435.155730035), new Vsop87.LnVsop(1.28E-9, 1.78174364933, 658.0565335787), new Vsop87.LnVsop(1.37E-9, 5.11560090352, 1912.5783119412), new Vsop87.LnVsop(1.42E-9, 0.75190926039, 594.6507036754), new Vsop87.LnVsop(1.53E-9, 2.78684650106, 476.1069951778), new Vsop87.LnVsop(1.54E-9, 4.94704832787, 10220.3990932118), new Vsop87.LnVsop(1.28E-9, 5.66820405576, 225.0785088848), new Vsop87.LnVsop(1.38E-9, 2.82615622179, 2303.6087678132), new Vsop87.LnVsop(1.32E-9, 1.49741990377, 196.0336200506), new Vsop87.LnVsop(1.29E-9, 4.41175966459, 433.7599219866), new Vsop87.LnVsop(1.71E-9, 6.24909192531, 1051.517623663), new Vsop87.LnVsop(1.6E-9, 1.8589009813, 201.5196819912), new Vsop87.LnVsop(1.21E-9, 5.40484928163, 502.8642621516), new Vsop87.LnVsop(1.53E-9, 4.6394715346, 427.3489504014), new Vsop87.LnVsop(1.21E-9, 3.74544495912, 430.79097657), new Vsop87.LnVsop(1.2E-9, 4.62909460174, 203.2647871304), new Vsop87.LnVsop(1.29E-9, 3.53374989244, 1578.7779545453), new Vsop87.LnVsop(1.35E-9, 1.43937419165, 850.0149880143), new Vsop87.LnVsop(1.37E-9, 4.80520057291, 1570.9136480191), new Vsop87.LnVsop(1.21E-9, 4.87948813075, 224.6054281328), new Vsop87.LnVsop(1.3E-9, 3.34197255602, 0.5212648618), new Vsop87.LnVsop(1.19E-9, 2.8329948906, 373.9079928365), new Vsop87.LnVsop(1.25E-9, 4.91969530984, 1152.1797636693), new Vsop87.LnVsop(1.15E-9, 5.04850642628, 3377.217792004), new Vsop87.LnVsop(1.38E-9, 4.38122571755, 1159.2933106701), new Vsop87.LnVsop(1.34E-9, 0.37323424806, 550.1378342197), new Vsop87.LnVsop(1.13E-9, 2.73735702901, 1276.6131788903), new Vsop87.LnVsop(1.27E-9, 2.13685901715, 2751.5475996916), new Vsop87.LnVsop(1.53E-9, 3.56452485886, 1688.9842757647), new Vsop87.LnVsop(1.41E-9, 2.842693325, 223.3334037456), new Vsop87.LnVsop(1.35E-9, 2.18590537692, 3259.8979237838), new Vsop87.LnVsop(1.39E-9, 0.66224045852, 425.8474313506), new Vsop87.LnVsop(1.23E-9, 4.98137061996, 1286.9081196288), new Vsop87.LnVsop(1.1E-9, 1.95470890132, 3686.4961146598), new Vsop87.LnVsop(1.41E-9, 4.08645824679, 765.8846102125), new Vsop87.LnVsop(1.07E-9, 2.27167812704, 1474.9344208013), new Vsop87.LnVsop(1.07E-9, 0.67574920664, 214.5229357154), new Vsop87.LnVsop(1.08E-9, 4.14668671928, 402.2191684878), new Vsop87.LnVsop(1.09E-9, 0.60965715164, 227.3137411185), new Vsop87.LnVsop(1.23E-9, 4.7556306382, 1055.4497769261), new Vsop87.LnVsop(1.16E-9, 4.48344664917, 1773.9178027186), new Vsop87.LnVsop(1.07E-9, 2.40194959139, 162.0933701068), new Vsop87.LnVsop(1.14E-9, 0.31513063843, 1089.129394439), new Vsop87.LnVsop(1.07E-9, 2.78085038171, 1144.3154571431), new Vsop87.LnVsop(1.07E-9, 1.45794674623, 212.0752551606), new Vsop87.LnVsop(1.17E-9, 3.32755679932, 568.2970814844), new Vsop87.LnVsop(1.05E-9, 0.77526801011, 4546.8060434126), new Vsop87.LnVsop(1.04E-9, 5.58638472767, 258.5456780766), new Vsop87.LnVsop(1.03E-9, 1.1902774E-4, 1250.5896250994), new Vsop87.LnVsop(1.24E-9, 0.75407666346, 1403.3342159717), new Vsop87.LnVsop(1.16E-9, 5.58340550636, 4120.2078525366), new Vsop87.LnVsop(1.05E-9, 5.65016987846, 299.1263942692), new Vsop87.LnVsop(1.07E-9, 5.21539682701, 214.1928673153), new Vsop87.LnVsop(1.04E-9, 4.49107029871, 1379.7059531089), new Vsop87.LnVsop(1.22E-9, 4.67678900588, 199.2844497575), new Vsop87.LnVsop(1.05E-9, 2.31569581172, 200.5564741447), new Vsop87.LnVsop(1.05E-9, 4.46551837753, 216.0074084237), new Vsop87.LnVsop(9.9E-10, 2.99447140993, 96.8729990951), new Vsop87.LnVsop(1.18E-9, 4.76736796759, 1884.124123938), new Vsop87.LnVsop(9.7E-10, 4.51150496941, 0.0481841098), new Vsop87.LnVsop(1.02E-9, 1.14650803737, 1268.7488723641), new Vsop87.LnVsop(1.24E-9, 5.36175829995, 2004.6253858959), new Vsop87.LnVsop(1.13E-9, 2.10434715032, 976.7360250957), new Vsop87.LnVsop(9.9E-10, 2.06115127438, 210.5907824523), new Vsop87.LnVsop(1.02E-9, 0.14631144439, 650.1922270525), new Vsop87.LnVsop(9.6E-10, 4.50945686426, 991.7138786227), new Vsop87.LnVsop(1.21E-9, 0.53237694918, 838.218528225), new Vsop87.LnVsop(1.11E-9, 3.17587281166, 1987.2168981566), new Vsop87.LnVsop(1.13E-9, 0.65690102007, 369.9758395734), new Vsop87.LnVsop(9.7E-10, 5.08571198619, 153.4953503977), new Vsop87.LnVsop(9.5E-10, 4.10494845439, 10213.285546211), new Vsop87.LnVsop(1.09E-9, 4.59330410482, 1471.0022675382), new Vsop87.LnVsop(9.8E-10, 1.97227067133, 555.5544601911), new Vsop87.LnVsop(9.9E-10, 3.74114595447, 619.2903584945), new Vsop87.LnVsop(9.3E-10, 1.8195057305, 1523.6924655777), new Vsop87.LnVsop(1.05E-9, 5.4908392538, 501.2367770914), new Vsop87.LnVsop(9.2E-10, 1.24014873712, 1123.1178284926), new Vsop87.LnVsop(1.13E-9, 1.72036934079, 220.364458329), new Vsop87.LnVsop(9.1E-10, 0.17221579825, 1097.0942747017), new Vsop87.LnVsop(9.8E-10, 1.79805037973, 1254.5217783625), new Vsop87.LnVsop(1.12E-9, 4.45867298294, 763.4369296577), new Vsop87.LnVsop(9.1E-10, 3.20001937333, 962.5089310941), new Vsop87.LnVsop(9.4E-10, 2.86714047622, 548.4409131903), new Vsop87.LnVsop(1.01E-9, 3.07892909093, 725.5815727933), new Vsop87.LnVsop(1.15E-9, 3.37491688156, 313.9441891018), new Vsop87.LnVsop(8.9E-10, 4.83279938124, 657.1627617014), new Vsop87.LnVsop(1.06E-9, 3.73569157743, 220.9339073006), new Vsop87.LnVsop(8.8E-10, 4.81404995864, 670.4960838257), new Vsop87.LnVsop(9.3E-10, 2.11909409613, 731.6837278378), new Vsop87.LnVsop(9.1E-10, 2.84990081277, 1158.5425511447), new Vsop87.LnVsop(8.8E-10, 5.43215955591, 894.8408795276), new Vsop87.LnVsop(1.09E-9, 0.99369307649, 49.5088043018), new Vsop87.LnVsop(8.8E-10, 4.57978939179, 3590.516887442), new Vsop87.LnVsop(9.0E-10, 6.22046531228, 206.9363079626), new Vsop87.LnVsop(8.9E-10, 1.38380314332, 2431.9743362973), new Vsop87.LnVsop(8.9E-10, 0.85422789927, 885.4397106664), new Vsop87.LnVsop(9.2E-10, 1.70846492069, 4525.4654024102), new Vsop87.LnVsop(8.8E-10, 4.19065380742, 20426.571092422), new Vsop87.LnVsop(1.03E-9, 5.09211864667, 213.4591541324), new Vsop87.LnVsop(1.14E-9, 4.77634498556, 2332.0629558164), new Vsop87.LnVsop(9.0E-10, 5.94905546946, 434.6749457233), new Vsop87.LnVsop(8.5E-10, 6.0047379134, 1997.5118388951), new Vsop87.LnVsop(9.3E-10, 4.74694917061, 25874.6040461362), new Vsop87.LnVsop(8.8E-10, 3.9357240647, 924.0458270562), new Vsop87.LnVsop(8.5E-10, 2.23193157611, 4223.3006267552), new Vsop87.LnVsop(9.7E-10, 5.28832295436, 226.6324175623), new Vsop87.LnVsop(9.0E-10, 2.77655931107, 355.7487455718), new Vsop87.LnVsop(8.7E-10, 2.867611963, 2005.3761454213), new Vsop87.LnVsop(1.01E-9, 5.96125293373, 140.9651774255), new Vsop87.LnVsop(1.03E-9, 1.70664595857, 213.1390367436), new Vsop87.LnVsop(8.6E-10, 5.87484967593, 5636.0650166766), new Vsop87.LnVsop(8.1E-10, 3.2716351558, 392.6579409322), new Vsop87.LnVsop(1.1E-9, 2.15873993795, 0.9632078465), new Vsop87.LnVsop(9.1E-10, 4.18922453316, 714.5358725294), new Vsop87.LnVsop(8.4E-10, 0.82519318544, 875.830299001), new Vsop87.LnVsop(9.0E-10, 1.61216801859, 219.6618829134), new Vsop87.LnVsop(8.3E-10, 0.51126636938, 366.0436863103), new Vsop87.LnVsop(9.5E-10, 3.18236269647, 401.3253966105), new Vsop87.LnVsop(8.0E-10, 0.86894269984, 233.9060232575), new Vsop87.LnVsop(7.9E-10, 1.86255607416, 1371.8416465827), new Vsop87.LnVsop(8.8E-10, 3.9059902494, 1030.927742186), new Vsop87.LnVsop(9.9E-10, 3.26868558102, 988.532484885), new Vsop87.LnVsop(8.4E-10, 6.03336793666, 199.9657733137), new Vsop87.LnVsop(9.0E-10, 2.82003299044, 4841.8572720668), new Vsop87.LnVsop(8.4E-10, 2.92855920153, 700.4517908797), new Vsop87.LnVsop(1.03E-9, 5.93497932729, 3384.3313390048), new Vsop87.LnVsop(7.8E-10, 5.48349540273, 1166.4068576709), new Vsop87.LnVsop(9.4E-10, 2.30477326334, 4443.713269194), new Vsop87.LnVsop(8.1E-10, 4.94647597211, 746.9222137957), new Vsop87.LnVsop(8.4E-10, 2.56214102684, 960.2213092337), new Vsop87.LnVsop(8.2E-10, 0.04782722111, 608.877797677), new Vsop87.LnVsop(8.2E-10, 5.83227223542, 769.8167634756), new Vsop87.LnVsop(8.2E-10, 0.8504903601, 2228.9701815978), new Vsop87.LnVsop(9.6E-10, 4.26079753884, 562.1467423301), new Vsop87.LnVsop(8.5E-10, 5.60454891423, 177.8743727859), new Vsop87.LnVsop(8.0E-10, 2.70295280428, 1706.392763504), new Vsop87.LnVsop(8.0E-10, 2.38017647755, 3156.8051495652), new Vsop87.LnVsop(7.7E-10, 0.860726193, 599.6466385215), new Vsop87.LnVsop(8.7E-10, 3.23866124089, 9786.687355335), new Vsop87.LnVsop(7.7E-10, 4.92131979643, 628.5909536192), new Vsop87.LnVsop(8.6E-10, 1.60736733611, 1048.3362299253), new Vsop87.LnVsop(7.8E-10, 5.37725237047, 155.1922714271), new Vsop87.LnVsop(9.9E-10, 4.60217992901, 1493.093668066), new Vsop87.LnVsop(7.5E-10, 1.58021212251, 2115.5824666407), new Vsop87.LnVsop(7.7E-10, 5.3197368096, 700.6642392008), new Vsop87.LnVsop(7.4E-10, 0.97806259478, 455.0523788792), new Vsop87.LnVsop(9.9E-10, 0.79638071608, 4017.115078318), new Vsop87.LnVsop(7.8E-10, 3.39406953094, 106.0135355254), new Vsop87.LnVsop(7.3E-10, 4.04232842619, 907.3710524998), new Vsop87.LnVsop(7.8E-10, 3.5170445414, 969.6224780949), new Vsop87.LnVsop(7.4E-10, 3.12025543151, 201.9927627432), new Vsop87.LnVsop(8.8E-10, 1.09928677784, 1246.6574718363), new Vsop87.LnVsop(7.8E-10, 5.49208074374, 477.0007670551), new Vsop87.LnVsop(7.9E-10, 2.75804430794, 847.0460425977)};
        private static final Vsop87.LnVsop[] saturn_longitude_l2 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.0011644133, 1.17988132879, 7.1135470008), new Vsop87.LnVsop(9.1841837E-4, 0.0732519584, 213.299095438), new Vsop87.LnVsop(3.6661728E-4, 0.0, 0.0), new Vsop87.LnVsop(1.5274496E-4, 4.06493179167, 206.1855484372), new Vsop87.LnVsop(1.0987259E-4, 5.4447918831, 426.598190876), new Vsop87.LnVsop(1.062983E-4, 0.25764306189, 220.4126424388), new Vsop87.LnVsop(4.265404E-5, 1.04596041482, 14.2270940016), new Vsop87.LnVsop(1.215447E-5, 2.91866579609, 103.0927742186), new Vsop87.LnVsop(1.142595E-5, 4.63711665368, 639.897286314), new Vsop87.LnVsop(1.061494E-5, 5.68896768215, 433.7117378768), new Vsop87.LnVsop(1.020102E-5, 0.6336845725, 3.1813937377), new Vsop87.LnVsop(1.044759E-5, 4.04202827818, 199.0720014364), new Vsop87.LnVsop(6.48857E-6, 4.33990455509, 419.4846438752), new Vsop87.LnVsop(5.4932E-6, 5.57301151406, 3.9321532631), new Vsop87.LnVsop(4.56767E-6, 1.2689684848, 110.2063212194), new Vsop87.LnVsop(4.24918E-6, 0.20908786519, 227.5261894396), new Vsop87.LnVsop(2.73782E-6, 4.2885706119, 95.9792272178), new Vsop87.LnVsop(1.61533E-6, 1.38145587317, 11.0457002639), new Vsop87.LnVsop(1.29502E-6, 1.56592444783, 309.2783226558), new Vsop87.LnVsop(1.08829E-6, 3.89769392463, 853.196381752), new Vsop87.LnVsop(1.00917E-6, 0.89243113369, 21.3406410024), new Vsop87.LnVsop(1.0071E-6, 4.89713543344, 647.0108333148), new Vsop87.LnVsop(9.5154E-7, 5.62447011514, 412.3710968744), new Vsop87.LnVsop(8.1962E-7, 1.02414352999, 117.3198682202), new Vsop87.LnVsop(7.486E-7, 4.76187112999, 210.1177017003), new Vsop87.LnVsop(8.2667E-7, 6.05014465562, 216.4804891757), new Vsop87.LnVsop(9.55E-7, 2.91469950689, 316.3918696566), new Vsop87.LnVsop(6.4191E-7, 0.35066202401, 323.5054166574), new Vsop87.LnVsop(8.4889E-7, 5.73495539065, 209.3669421749), new Vsop87.LnVsop(6.6442E-7, 0.48307559227, 10.2949407385), new Vsop87.LnVsop(6.7164E-7, 0.45592762644, 522.5774180938), new Vsop87.LnVsop(5.3849E-7, 2.71027004601, 529.6909650946), new Vsop87.LnVsop(5.2073E-7, 4.77422682479, 632.7837393132), new Vsop87.LnVsop(4.4991E-7, 5.69247085773, 440.8252848776), new Vsop87.LnVsop(4.5297E-7, 1.66820818508, 202.2533951741), new Vsop87.LnVsop(4.2349E-7, 5.70774454577, 88.865680217), new Vsop87.LnVsop(3.205E-7, 0.06977561095, 63.7358983034), new Vsop87.LnVsop(3.1531E-7, 1.67269081492, 302.164775655), new Vsop87.LnVsop(3.116E-7, 4.16289690897, 191.9584544356), new Vsop87.LnVsop(2.4709E-7, 5.65552005153, 735.8765135318), new Vsop87.LnVsop(2.654E-7, 0.82957323703, 224.3447957019), new Vsop87.LnVsop(2.0111E-7, 5.94400958785, 217.2312487011), new Vsop87.LnVsop(1.7562E-7, 4.90127107888, 625.6701923124), new Vsop87.LnVsop(1.7423E-7, 1.62944882745, 742.9900605326), new Vsop87.LnVsop(1.3745E-7, 3.76551606198, 195.1398481733), new Vsop87.LnVsop(1.2239E-7, 4.71655885093, 203.0041546995), new Vsop87.LnVsop(1.1865E-7, 0.12658169661, 234.6397364404), new Vsop87.LnVsop(1.5992E-7, 0.58010406176, 515.463871093), new Vsop87.LnVsop(1.2178E-7, 3.02991813349, 846.0828347512), new Vsop87.LnVsop(1.1013E-7, 5.91647084481, 536.8045120954), new Vsop87.LnVsop(1.3971E-7, 0.20726957441, 838.9692877504), new Vsop87.LnVsop(1.0983E-7, 5.61246766042, 728.762966531), new Vsop87.LnVsop(9.95E-8, 0.24994105562, 330.6189636582), new Vsop87.LnVsop(9.192E-8, 4.15737094186, 860.3099287528), new Vsop87.LnVsop(9.424E-8, 3.21424196104, 1066.49547719), new Vsop87.LnVsop(9.432E-8, 0.46528491211, 956.2891559706), new Vsop87.LnVsop(1.0125E-7, 4.98323117202, 422.6660376129), new Vsop87.LnVsop(8.282E-8, 2.1423724836, 269.9214467406), new Vsop87.LnVsop(7.182E-8, 5.40492160991, 1052.2683831884), new Vsop87.LnVsop(7.53E-8, 5.24653553801, 429.7795846137), new Vsop87.LnVsop(6.339E-8, 4.46236888166, 284.1485407422), new Vsop87.LnVsop(5.962E-8, 5.41494016179, 149.5631971346), new Vsop87.LnVsop(7.482E-8, 4.02606821044, 9.5612275556), new Vsop87.LnVsop(5.72E-8, 4.26530477198, 415.5524906121), new Vsop87.LnVsop(6.049E-8, 5.93261878105, 405.2575498736), new Vsop87.LnVsop(5.707E-8, 0.0108846996, 124.433415221), new Vsop87.LnVsop(4.736E-8, 2.27408430395, 18.1592472647), new Vsop87.LnVsop(5.605E-8, 6.0218667366, 223.5940361765), new Vsop87.LnVsop(4.492E-8, 4.93190106788, 654.1243803156), new Vsop87.LnVsop(4.572E-8, 4.41905037462, 942.062061969), new Vsop87.LnVsop(5.619E-8, 0.29640581964, 127.4717966068), new Vsop87.LnVsop(5.427E-8, 5.54628097641, 949.1756089698), new Vsop87.LnVsop(4.05E-8, 4.70655233568, 74.7815985673), new Vsop87.LnVsop(4.983E-8, 3.20538998582, 277.0349937414), new Vsop87.LnVsop(4.231E-8, 2.89079464814, 56.6223513026), new Vsop87.LnVsop(4.064E-8, 5.30594179929, 1045.1548361876), new Vsop87.LnVsop(3.949E-8, 3.3080407983, 490.3340891794), new Vsop87.LnVsop(3.966E-8, 6.12786433144, 81.7521332162), new Vsop87.LnVsop(3.74E-8, 4.93207109771, 52.6901980395), new Vsop87.LnVsop(4.556E-8, 6.13297205287, 1155.361157407), new Vsop87.LnVsop(3.71E-8, 0.40358664974, 137.0330241624), new Vsop87.LnVsop(3.405E-8, 4.28369409738, 99.9113804809), new Vsop87.LnVsop(3.385E-8, 1.58207215076, 1059.3819301892), new Vsop87.LnVsop(3.946E-8, 0.36427920856, 12.5301729722), new Vsop87.LnVsop(4.075E-8, 0.29371909541, 831.8557407496), new Vsop87.LnVsop(3.337E-8, 0.22680009908, 1272.6810256272), new Vsop87.LnVsop(3.645E-8, 0.15608090085, 437.6438911399), new Vsop87.LnVsop(2.882E-8, 3.16980253835, 70.8494453042), new Vsop87.LnVsop(2.82E-8, 0.32685718956, 191.2076949102), new Vsop87.LnVsop(2.675E-8, 1.8752517315, 295.0512286542), new Vsop87.LnVsop(3.593E-8, 4.72358358604, 423.4167971383), new Vsop87.LnVsop(2.692E-8, 3.59467219768, 131.4039498699), new Vsop87.LnVsop(2.611E-8, 5.15121377007, 1368.660252845), new Vsop87.LnVsop(2.439E-8, 3.90853469376, 210.8514148832), new Vsop87.LnVsop(2.46E-8, 1.5850302701, 32.2433289144), new Vsop87.LnVsop(2.37E-8, 4.74096554852, 351.8165923087), new Vsop87.LnVsop(2.444E-8, 5.81456271395, 106.2741679563), new Vsop87.LnVsop(2.213E-8, 2.05928438838, 6076.8903015542), new Vsop87.LnVsop(2.206E-8, 5.98426401448, 6062.6632075526), new Vsop87.LnVsop(2.163E-8, 5.95837514288, 145.6310438715), new Vsop87.LnVsop(2.748E-8, 3.38304528348, 408.4389436113), new Vsop87.LnVsop(2.284E-8, 3.14006785569, 22.0914005278), new Vsop87.LnVsop(2.089E-8, 3.48276343851, 10007.0999977738), new Vsop87.LnVsop(2.078E-8, 1.12426049665, 9992.8729037722), new Vsop87.LnVsop(2.575E-8, 5.11506203019, 265.9892934775), new Vsop87.LnVsop(1.81E-8, 5.03261959505, 1361.5467058442), new Vsop87.LnVsop(1.751E-8, 4.12209032177, 107.0249274817), new Vsop87.LnVsop(1.757E-8, 4.17277201762, 1258.4539316256), new Vsop87.LnVsop(1.917E-8, 4.52092673239, 138.5174968707), new Vsop87.LnVsop(1.66E-8, 1.3675970543, 231.4583427027), new Vsop87.LnVsop(1.629E-8, 3.76846556637, 628.8515860501), new Vsop87.LnVsop(2.073E-8, 5.24889328333, 1265.5674786264), new Vsop87.LnVsop(1.908E-8, 5.87241184631, 1471.7530270636), new Vsop87.LnVsop(1.491E-8, 0.47137450159, 340.7708920448), new Vsop87.LnVsop(1.469E-8, 5.63066479682, 447.9388318784), new Vsop87.LnVsop(1.368E-8, 2.9019117936, 215.7467759928), new Vsop87.LnVsop(1.387E-8, 5.85935596482, 430.5303441391), new Vsop87.LnVsop(1.722E-8, 6.23117770604, 1148.2476104062), new Vsop87.LnVsop(1.303E-8, 0.59972315177, 28.4541880032), new Vsop87.LnVsop(1.19E-8, 2.83055605436, 200.7689224658), new Vsop87.LnVsop(1.266E-8, 5.78318939698, 543.9180590962), new Vsop87.LnVsop(1.159E-8, 3.52473802224, 497.4476361802), new Vsop87.LnVsop(1.433E-8, 0.85149270762, 6069.7767545534), new Vsop87.LnVsop(1.244E-8, 0.03107328684, 1589.0728952838), new Vsop87.LnVsop(1.091E-8, 4.9691226184, 1685.0521225016), new Vsop87.LnVsop(9.93E-9, 1.599506621, 1375.7737998458), new Vsop87.LnVsop(1.342E-8, 2.27535909191, 9999.986450773), new Vsop87.LnVsop(1.164E-8, 0.71458004021, 508.3503240922), new Vsop87.LnVsop(1.054E-8, 1.40406602585, 483.2205421786), new Vsop87.LnVsop(1.108E-8, 1.19549464972, 618.5566453116), new Vsop87.LnVsop(9.59E-9, 4.2288083422, 288.0806940053), new Vsop87.LnVsop(1.031E-8, 1.0892563558, 184.8449074348), new Vsop87.LnVsop(9.26E-9, 2.59820818098, 134.5853436076), new Vsop87.LnVsop(9.34E-9, 2.43391814989, 222.8603229936), new Vsop87.LnVsop(9.35E-9, 2.650043211, 1279.794572628), new Vsop87.LnVsop(9.32E-9, 2.47823744049, 703.6331846174), new Vsop87.LnVsop(8.94E-9, 4.52571251065, 38.1330356378), new Vsop87.LnVsop(8.89E-9, 2.26537788507, 1162.4747044078), new Vsop87.LnVsop(1.026E-8, 4.88481004083, 750.1036075334), new Vsop87.LnVsop(8.61E-9, 4.72556919318, 362.8622925726), new Vsop87.LnVsop(9.87E-9, 4.5550804487, 635.9651330509), new Vsop87.LnVsop(8.17E-9, 4.78613243939, 1677.9385755008), new Vsop87.LnVsop(8.38E-9, 2.22382688806, 333.657345044), new Vsop87.LnVsop(8.18E-9, 5.77611891155, 416.3032501375), new Vsop87.LnVsop(7.7E-9, 3.431287848, 1073.6090241908), new Vsop87.LnVsop(7.75E-9, 2.51136824078, 343.2185725996), new Vsop87.LnVsop(7.34E-9, 2.35308297796, 120.358249606), new Vsop87.LnVsop(8.82E-9, 5.59382134246, 1788.1448967202), new Vsop87.LnVsop(7.18E-9, 3.92701610563, 1574.8458012822), new Vsop87.LnVsop(7.28E-9, 4.85632864351, 76.2660712756), new Vsop87.LnVsop(6.96E-9, 3.68169796191, 347.8844390456), new Vsop87.LnVsop(6.83E-9, 3.73251938537, 203.7378678824), new Vsop87.LnVsop(6.68E-9, 2.85405845694, 92.0470739547), new Vsop87.LnVsop(8.46E-9, 5.0061997125, 1581.959348283), new Vsop87.LnVsop(7.14E-9, 5.73513429762, 721.6494195302), new Vsop87.LnVsop(6.97E-9, 0.20687083504, 99.1606209555), new Vsop87.LnVsop(6.75E-9, 5.62875135263, 17.2654753874), new Vsop87.LnVsop(8.38E-9, 5.97145881711, 1464.6394800628), new Vsop87.LnVsop(6.41E-9, 0.67589597459, 46.470422916), new Vsop87.LnVsop(6.34E-9, 4.84360016292, 357.4456666012), new Vsop87.LnVsop(8.13E-9, 0.65010530865, 113.3877149571), new Vsop87.LnVsop(7.79E-9, 0.04397099012, 1169.5882514086), new Vsop87.LnVsop(6.54E-9, 5.89612648687, 337.732510659), new Vsop87.LnVsop(5.43E-9, 5.07477971244, 388.4651552382), new Vsop87.LnVsop(5.34E-9, 1.21443390921, 62.2514255951), new Vsop87.LnVsop(5.3E-9, 5.4507420669, 312.1990839626), new Vsop87.LnVsop(5.24E-9, 4.84778928724, 358.9301393095), new Vsop87.LnVsop(5.24E-9, 1.53836680827, 195.8906076987), new Vsop87.LnVsop(5.98E-9, 0.90807361549, 1692.1656695024), new Vsop87.LnVsop(5.21E-9, 3.69000991897, 217.964961884), new Vsop87.LnVsop(6.61E-9, 4.49401694007, 643.0786800517), new Vsop87.LnVsop(5.37E-9, 6.17024172829, 182.279606801), new Vsop87.LnVsop(5.39E-9, 0.29923807305, 98.8999885246), new Vsop87.LnVsop(5.04E-9, 3.80940628684, 168.0525127994), new Vsop87.LnVsop(4.89E-9, 1.08047606868, 5856.4776591154), new Vsop87.LnVsop(5.7E-9, 3.22538390359, 208.633228992), new Vsop87.LnVsop(5.42E-9, 6.00891355828, 1905.4647649404), new Vsop87.LnVsop(4.68E-9, 2.50179341284, 9786.687355335), new Vsop87.LnVsop(4.78E-9, 4.69534368607, 2001.4439921582), new Vsop87.LnVsop(4.68E-9, 0.6971820243, 258.8757464767), new Vsop87.LnVsop(4.56E-9, 3.18302424015, 218.9281697305), new Vsop87.LnVsop(5.42E-9, 0.56755755204, 404.5067903482), new Vsop87.LnVsop(4.18E-9, 4.81455000162, 636.7158925763), new Vsop87.LnVsop(4.05E-9, 3.79642493875, 24.3790223882), new Vsop87.LnVsop(4.28E-9, 0.98881943857, 160.6088973985), new Vsop87.LnVsop(3.95E-9, 3.50540272263, 129.9194771616), new Vsop87.LnVsop(4.91E-9, 5.25616442245, 436.8931316145), new Vsop87.LnVsop(3.95E-9, 0.63866561227, 5849.3641121146), new Vsop87.LnVsop(4.01E-9, 3.91645377349, 565.1156877467), new Vsop87.LnVsop(3.85E-9, 3.66039075343, 563.6312150384), new Vsop87.LnVsop(3.85E-9, 4.21962510029, 867.4234757536), new Vsop87.LnVsop(3.95E-9, 0.79256328399, 767.3690829208), new Vsop87.LnVsop(3.97E-9, 1.47228787593, 273.1028404783), new Vsop87.LnVsop(4.07E-9, 5.47101735998, 1038.0412891868), new Vsop87.LnVsop(4.5E-9, 2.16827084832, 561.1835344836), new Vsop87.LnVsop(3.71E-9, 2.92289280832, 212.3358875915), new Vsop87.LnVsop(4.71E-9, 0.67355945445, 207.8824694666), new Vsop87.LnVsop(4.94E-9, 3.69576582281, 350.3321196004), new Vsop87.LnVsop(4.45E-9, 2.54960078264, 313.2104759189), new Vsop87.LnVsop(4.3E-9, 5.32368128659, 2104.5367663768), new Vsop87.LnVsop(3.6E-9, 0.37557163523, 214.2623032845), new Vsop87.LnVsop(3.46E-9, 1.06976563801, 114.1384744825), new Vsop87.LnVsop(3.74E-9, 3.12722101473, 621.7380390493), new Vsop87.LnVsop(3.49E-9, 1.34436318123, 554.0699874828), new Vsop87.LnVsop(4.23E-9, 5.71328898571, 225.8292684102), new Vsop87.LnVsop(4.3E-9, 2.66387237515, 77.962992305), new Vsop87.LnVsop(3.8E-9, 5.56440978604, 131.5469622218), new Vsop87.LnVsop(3.7E-9, 4.71794670577, 1994.3304451574), new Vsop87.LnVsop(3.36E-9, 5.22381691731, 142.4496501338), new Vsop87.LnVsop(4.51E-9, 5.70353371091, 1781.0313497194), new Vsop87.LnVsop(3.41E-9, 5.92928351979, 26.826702943), new Vsop87.LnVsop(4.13E-9, 5.254421676, 85.8272988312), new Vsop87.LnVsop(3.08E-9, 3.68245311562, 1891.2376709388), new Vsop87.LnVsop(3.07E-9, 0.83912741778, 6283.0758499914), new Vsop87.LnVsop(3.1E-9, 1.98294407285, 9779.5738083342), new Vsop87.LnVsop(3.07E-9, 2.20383229267, 10213.285546211), new Vsop87.LnVsop(3.25E-9, 0.64360996757, 45.5766510387), new Vsop87.LnVsop(3.94E-9, 5.76677470794, 39.3568759152), new Vsop87.LnVsop(3.3E-9, 5.27653526017, 629.6023455755), new Vsop87.LnVsop(2.99E-9, 1.88775208899, 1493.093668066), new Vsop87.LnVsop(3.52E-9, 4.48509640628, 1898.3512179396), new Vsop87.LnVsop(2.81E-9, 3.16317079558, 424.1505103212), new Vsop87.LnVsop(3.16E-9, 4.97188239617, 757.2171545342), new Vsop87.LnVsop(2.87E-9, 0.97698684717, 685.4739373527), new Vsop87.LnVsop(2.76E-9, 6.2594456111, 241.7532834412), new Vsop87.LnVsop(2.75E-9, 0.90501179953, 245.5424243524), new Vsop87.LnVsop(3.0E-9, 0.6897992003, 2008.557539159), new Vsop87.LnVsop(2.95E-9, 3.39770460737, 699.7010313543), new Vsop87.LnVsop(2.79E-9, 4.56569473908, 291.262087743), new Vsop87.LnVsop(2.7E-9, 4.56602256237, 1382.8873468466), new Vsop87.LnVsop(2.81E-9, 4.02513980273, 472.1748419147), new Vsop87.LnVsop(3.51E-9, 2.51708328514, 344.7030453079), new Vsop87.LnVsop(2.49E-9, 5.83224046008, 546.956440482), new Vsop87.LnVsop(2.98E-9, 0.4024562254, 824.7421937488), new Vsop87.LnVsop(2.53E-9, 1.80130756456, 5643.1785636774), new Vsop87.LnVsop(2.55E-9, 1.70309731649, 916.9322800554), new Vsop87.LnVsop(2.4E-9, 1.92537411069, 432.2272651685), new Vsop87.LnVsop(2.31E-9, 1.13100606986, 519.3960243561), new Vsop87.LnVsop(2.57E-9, 3.06004165978, 778.4147831847), new Vsop87.LnVsop(2.35E-9, 5.36973988104, 426.5500067662), new Vsop87.LnVsop(2.37E-9, 3.3768722505, 1055.4497769261), new Vsop87.LnVsop(2.35E-9, 3.22448277667, 9573.388259897), new Vsop87.LnVsop(2.26E-9, 3.88426552477, 576.1613880106), new Vsop87.LnVsop(2.22E-9, 3.9365904206, 319.5732633943), new Vsop87.LnVsop(2.98E-9, 6.14531746207, 421.1815649046), new Vsop87.LnVsop(2.19E-9, 5.77768418505, 92.7978334801), new Vsop87.LnVsop(3.01E-9, 5.93880232828, 486.4019359163), new Vsop87.LnVsop(2.5E-9, 3.1214060442, 144.1465711632), new Vsop87.LnVsop(2.59E-9, 5.84103167814, 650.9429865779), new Vsop87.LnVsop(2.68E-9, 5.02934715041, 6275.9623029906), new Vsop87.LnVsop(2.5E-9, 3.40150002263, 842.1506814881), new Vsop87.LnVsop(2.47E-9, 1.67833021022, 696.5196376166), new Vsop87.LnVsop(2.24E-9, 4.81984414234, 945.9942152321), new Vsop87.LnVsop(2.69E-9, 5.94851586836, 230.7075831773), new Vsop87.LnVsop(2.56E-9, 3.78687318805, 963.4027029714), new Vsop87.LnVsop(2.38E-9, 2.37468752028, 306.0969289181), new Vsop87.LnVsop(2.11E-9, 0.95998214239, 526.5095713569), new Vsop87.LnVsop(2.11E-9, 2.91633331348, 1596.1864422846), new Vsop87.LnVsop(2.02E-9, 0.40419643612, 479.2883889155), new Vsop87.LnVsop(2.01E-9, 4.15907677541, 572.2292347475), new Vsop87.LnVsop(2.18E-9, 2.66042692356, 776.9303104764), new Vsop87.LnVsop(1.98E-9, 1.98905153495, 425.6349830295), new Vsop87.LnVsop(2.04E-9, 0.88373842674, 31.492569389), new Vsop87.LnVsop(1.97E-9, 2.81822588165, 1286.9081196288), new Vsop87.LnVsop(1.96E-9, 2.21181034487, 65.2203710117), new Vsop87.LnVsop(2.6E-9, 0.63239909077, 934.9485149682), new Vsop87.LnVsop(2.22E-9, 3.92299544057, 289.5651667136), new Vsop87.LnVsop(1.92E-9, 5.13699333789, 329.7251917809), new Vsop87.LnVsop(2.06E-9, 2.28201140383, 421.93232443), new Vsop87.LnVsop(2.25E-9, 4.85845144987, 116.4260963429), new Vsop87.LnVsop(2.36E-9, 5.80481391592, 2221.856634597), new Vsop87.LnVsop(1.97E-9, 4.07875793212, 252.6559713532), new Vsop87.LnVsop(2.15E-9, 6.03854865322, 3700.7232086614), new Vsop87.LnVsop(2.5E-9, 3.75929924932, 4002.8879843164), new Vsop87.LnVsop(1.9E-9, 2.06061340112, 425.1137181677), new Vsop87.LnVsop(2.3E-9, 4.58718822052, 2310.722314814), new Vsop87.LnVsop(2.08E-9, 3.08549771485, 41.6444977756), new Vsop87.LnVsop(2.02E-9, 3.49000077242, 417.0369633204), new Vsop87.LnVsop(2.04E-9, 1.76041711688, 556.5176680376), new Vsop87.LnVsop(2.37E-9, 5.80077673064, 1049.0869894507), new Vsop87.LnVsop(1.91E-9, 4.75409244295, 953.1077622329), new Vsop87.LnVsop(1.85E-9, 0.13733419547, 188.0263011725), new Vsop87.LnVsop(1.97E-9, 4.3475683846, 518.3846323998), new Vsop87.LnVsop(1.83E-9, 2.73162234448, 710.7467316182), new Vsop87.LnVsop(1.95E-9, 5.58380753596, 610.6923387854), new Vsop87.LnVsop(1.82E-9, 2.35670801192, 273.8536000037), new Vsop87.LnVsop(2.27E-9, 0.10075592589, 1141.1340634054), new Vsop87.LnVsop(1.86E-9, 5.88991186489, 842.9014410135), new Vsop87.LnVsop(1.81E-9, 1.8400545991, 3281.2385647862), new Vsop87.LnVsop(2.04E-9, 4.6376108665, 2730.2069586892), new Vsop87.LnVsop(2.19E-9, 0.20858177566, 398.1440028728), new Vsop87.LnVsop(1.78E-9, 4.36336156447, 1262.3860848887), new Vsop87.LnVsop(2.34E-9, 5.41547130725, 2840.4132799086), new Vsop87.LnVsop(1.79E-9, 2.71915583308, 823.9914342234), new Vsop87.LnVsop(1.79E-9, 6.16908116316, 429.5189521828), new Vsop87.LnVsop(2.21E-9, 4.67090997536, 2317.8358618148), new Vsop87.LnVsop(2.18E-9, 4.48655129162, 2214.7430875962), new Vsop87.LnVsop(1.78E-9, 4.7398589892, 84.9335269539), new Vsop87.LnVsop(2.19E-9, 5.88231558225, 739.8086667949), new Vsop87.LnVsop(2.12E-9, 3.55778109357, 3899.7952100978), new Vsop87.LnVsop(1.75E-9, 3.98733824496, 181.0557665236), new Vsop87.LnVsop(1.7E-9, 3.48655578504, 501.3797894433), new Vsop87.LnVsop(1.9E-9, 5.08820154691, 838.218528225), new Vsop87.LnVsop(1.68E-9, 4.17824892556, 601.7642506762), new Vsop87.LnVsop(1.86E-9, 6.27969083232, 3384.3313390048), new Vsop87.LnVsop(1.7E-9, 4.04307080504, 2627.1141844706), new Vsop87.LnVsop(2.1E-9, 6.24922487858, 312.4597163935), new Vsop87.LnVsop(1.61E-9, 0.65418381232, 427.1194557378), new Vsop87.LnVsop(1.75E-9, 5.76796435765, 427.5613987225), new Vsop87.LnVsop(1.7E-9, 4.19634927387, 570.7447620392), new Vsop87.LnVsop(1.83E-9, 5.30941051861, 1354.4331588434), new Vsop87.LnVsop(1.94E-9, 4.72715532688, 2723.0934116884), new Vsop87.LnVsop(1.59E-9, 2.54013792041, 156.6767441354), new Vsop87.LnVsop(1.83E-9, 5.05394949061, 1670.8250285), new Vsop87.LnVsop(1.92E-9, 5.30444951399, 2097.423219376), new Vsop87.LnVsop(1.54E-9, 1.43624792504, 238.5718897035), new Vsop87.LnVsop(1.66E-9, 4.87871165187, 207.1487562837), new Vsop87.LnVsop(1.61E-9, 2.29074640137, 429.0458714308), new Vsop87.LnVsop(1.61E-9, 3.10589263843, 381.3516082374), new Vsop87.LnVsop(1.93E-9, 6.19289037233, 1485.9801210652), new Vsop87.LnVsop(1.48E-9, 3.78227154874, 220.4608265486), new Vsop87.LnVsop(1.55E-9, 2.71042195871, 5863.5912061162), new Vsop87.LnVsop(1.48E-9, 5.81240331182, 432.0148168474), new Vsop87.LnVsop(1.68E-9, 0.85973603244, 216.2198567448), new Vsop87.LnVsop(1.47E-9, 2.9883169658, 431.264057322), new Vsop87.LnVsop(1.53E-9, 1.97960511891, 41.0537969446), new Vsop87.LnVsop(1.56E-9, 1.78885164774, 905.8865797915), new Vsop87.LnVsop(1.44E-9, 0.23243678012, 59.8037450403), new Vsop87.LnVsop(1.76E-9, 5.8507625698, 2538.2485042536), new Vsop87.LnVsop(1.53E-9, 4.17220193633, 9793.8009023358), new Vsop87.LnVsop(1.39E-9, 1.88602485832, 334.5511169213), new Vsop87.LnVsop(1.38E-9, 3.86227960029, 305.3461693927), new Vsop87.LnVsop(1.46E-9, 6.22852846698, 1795.258443721), new Vsop87.LnVsop(1.43E-9, 3.54423986926, 251.4321310758), new Vsop87.LnVsop(1.83E-9, 3.75243223047, 856.3777754897), new Vsop87.LnVsop(1.93E-9, 5.9635004698, 732.6951197941), new Vsop87.LnVsop(1.44E-9, 0.80418666244, 128.3655684841), new Vsop87.LnVsop(1.4E-9, 0.9656678088, 298.2326223919), new Vsop87.LnVsop(1.57E-9, 5.60834759134, 551.031606097), new Vsop87.LnVsop(1.31E-9, 1.93665169948, 436.1594184316), new Vsop87.LnVsop(1.4E-9, 0.93212776526, 624.919432787), new Vsop87.LnVsop(1.66E-9, 5.7052157874, 643.8294395771), new Vsop87.LnVsop(1.42E-9, 4.28104505116, 3046.5988283458), new Vsop87.LnVsop(1.33E-9, 0.0653950369, 218.7157214094), new Vsop87.LnVsop(1.36E-9, 2.81474654925, 3473.1970192218), new Vsop87.LnVsop(1.5E-9, 0.04573957934, 213.2509113282), new Vsop87.LnVsop(1.5E-9, 3.24352648336, 213.3472795478), new Vsop87.LnVsop(1.24E-9, 0.09580718084, 945.2434557067), new Vsop87.LnVsop(1.33E-9, 0.94022058895, 1478.8665740644), new Vsop87.LnVsop(1.25E-9, 4.94887245998, 661.2379273164), new Vsop87.LnVsop(1.24E-9, 2.97015258114, 692.5874843535), new Vsop87.LnVsop(1.26E-9, 1.51394399969, 611.4430983108), new Vsop87.LnVsop(1.58E-9, 4.72257677135, 295.1942410061), new Vsop87.LnVsop(1.5E-9, 0.60398672305, 2413.8150890326), new Vsop87.LnVsop(1.56E-9, 5.12996334469, 2420.9286360334), new Vsop87.LnVsop(1.17E-9, 3.64929207405, 3362.9906980024), new Vsop87.LnVsop(1.17E-9, 0.79489355403, 444.7574381407), new Vsop87.LnVsop(1.15E-9, 1.69119601859, 2118.7638603784), new Vsop87.LnVsop(1.14E-9, 1.98550407909, 774.4826299216), new Vsop87.LnVsop(1.18E-9, 0.91668991972, 397.3932433474), new Vsop87.LnVsop(1.44E-9, 4.33884007719, 2620.0006374698), new Vsop87.LnVsop(1.14E-9, 2.79166033655, 235.3904959658), new Vsop87.LnVsop(1.15E-9, 4.38822748118, 206.1373643274), new Vsop87.LnVsop(1.3E-9, 4.69716812098, 2737.32050569), new Vsop87.LnVsop(1.11E-9, 6.17613645667, 380.12776796), new Vsop87.LnVsop(1.21E-9, 2.03089873253, 525.4981794006), new Vsop87.LnVsop(1.14E-9, 1.25282479588, 6290.1893969922), new Vsop87.LnVsop(1.16E-9, 4.50304390109, 2531.1349572528), new Vsop87.LnVsop(1.16E-9, 3.10820904194, 219.4494345923), new Vsop87.LnVsop(1.3E-9, 2.39191628139, 217.491881132), new Vsop87.LnVsop(1.06E-9, 4.99816879211, 2936.3925071264), new Vsop87.LnVsop(1.17E-9, 5.47700869225, 209.106309744), new Vsop87.LnVsop(1.08E-9, 2.67653144313, 10220.3990932118), new Vsop87.LnVsop(1.06E-9, 0.72832676913, 3480.3105662226), new Vsop87.LnVsop(1.09E-9, 3.11293456456, 1688.9842757647), new Vsop87.LnVsop(1.32E-9, 4.86619194495, 175.1660598002), new Vsop87.LnVsop(1.09E-9, 3.41245137157, 1159.2933106701), new Vsop87.LnVsop(1.02E-9, 1.34825182101, 927.8349679674), new Vsop87.LnVsop(1.01E-9, 4.38136430289, 3163.918696566), new Vsop87.LnVsop(1.06E-9, 2.63803685685, 1051.517623663), new Vsop87.LnVsop(1.02E-9, 2.04491853976, 4105.980758535), new Vsop87.LnVsop(1.0E-9, 0.94970095252, 835.7878940127), new Vsop87.LnVsop(1.17E-9, 4.62934163072, 2332.0629558164), new Vsop87.LnVsop(1.01E-9, 3.06953613114, 411.620337349), new Vsop87.LnVsop(9.9E-10, 5.73465398566, 1251.3403846248), new Vsop87.LnVsop(9.7E-10, 0.787859364, 739.0579072695), new Vsop87.LnVsop(9.8E-10, 5.27870818864, 395.578702239), new Vsop87.LnVsop(9.7E-10, 1.09461119824, 2324.9494088156), new Vsop87.LnVsop(9.5E-10, 1.24118747732, 211.8146227297), new Vsop87.LnVsop(1.04E-9, 1.47021057742, 2957.7331481288), new Vsop87.LnVsop(9.4E-10, 1.68922220636, 518.6452648307), new Vsop87.LnVsop(1.18E-9, 4.22282854428, 2207.6295405954), new Vsop87.LnVsop(9.2E-10, 3.413173381, 3679.382567659), new Vsop87.LnVsop(1.11E-9, 4.66199924249, 2634.2277314714), new Vsop87.LnVsop(9.3E-10, 3.01841149764, 3156.8051495652), new Vsop87.LnVsop(1.06E-9, 0.35440155109, 543.0242872189), new Vsop87.LnVsop(9.0E-10, 0.21699672631, 327.4375699205), new Vsop87.LnVsop(9.5E-10, 4.94137031528, 45.2465826386), new Vsop87.LnVsop(8.7E-10, 0.64235473812, 214.7835681463), new Vsop87.LnVsop(1.11E-9, 0.08892066313, 10206.1719992102), new Vsop87.LnVsop(1.15E-9, 4.07375401085, 3686.4961146598), new Vsop87.LnVsop(8.4E-10, 2.49438627744, 121.2520214833), new Vsop87.LnVsop(1.08E-9, 4.78689047662, 850.0149880143), new Vsop87.LnVsop(9.8E-10, 4.83439655178, 3810.9295298808), new Vsop87.LnVsop(8.4E-10, 5.63810867849, 3149.6916025644), new Vsop87.LnVsop(1.12E-9, 1.14266452718, 1802.3719907218), new Vsop87.LnVsop(8.2E-10, 4.77545412312, 3252.784376783), new Vsop87.LnVsop(8.3E-10, 3.73663902299, 207.6700211455), new Vsop87.LnVsop(8.2E-10, 2.76806023078, 540.7366653585), new Vsop87.LnVsop(8.2E-10, 6.15333814412, 210.3783341312), new Vsop87.LnVsop(1.13E-9, 2.14356843768, 2435.155730035), new Vsop87.LnVsop(8.9E-10, 5.86249569421, 2111.6503133776), new Vsop87.LnVsop(1.0E-9, 5.06864917409, 864.2420820159), new Vsop87.LnVsop(8.0E-10, 6.20664537299, 3590.516887442), new Vsop87.LnVsop(8.9E-10, 5.75815115764, 898.7730327907), new Vsop87.LnVsop(8.2E-10, 5.76315175207, 2303.6087678132), new Vsop87.LnVsop(8.2E-10, 0.1185053924, 4.665866446), new Vsop87.LnVsop(9.9E-10, 1.45848606541, 4539.6924964118), new Vsop87.LnVsop(1.07E-9, 2.75969942717, 4113.0943055358), new Vsop87.LnVsop(9.3E-10, 3.444501284, 849.2642284889), new Vsop87.LnVsop(8.0E-10, 5.87232764632, 980.6681783588), new Vsop87.LnVsop(9.8E-10, 2.92531705189, 135.336103133), new Vsop87.LnVsop(8.0E-10, 1.95003898969, 4436.5997221932), new Vsop87.LnVsop(8.0E-10, 3.17860516663, 320.3240229197), new Vsop87.LnVsop(7.8E-10, 5.57840933926, 455.0523788792), new Vsop87.LnVsop(8.4E-10, 5.7660923583, 2854.6403739102), new Vsop87.LnVsop(7.5E-10, 5.72196904186, 1987.2168981566), new Vsop87.LnVsop(7.6E-10, 3.15970573068, 4010.0015313172), new Vsop87.LnVsop(7.6E-10, 2.88023671694, 511.5317178299), new Vsop87.LnVsop(8.0E-10, 5.74706692909, 831.1049812242), new Vsop87.LnVsop(7.9E-10, 1.9001413779, 213.8203602998), new Vsop87.LnVsop(8.0E-10, 0.7900201431, 204.7010757289), new Vsop87.LnVsop(8.6E-10, 1.59595700348, 173.9422195228), new Vsop87.LnVsop(7.4E-10, 4.35316212019, 3583.4033404412), new Vsop87.LnVsop(7.8E-10, 1.4083290274, 212.7778305762), new Vsop87.LnVsop(7.2E-10, 3.92553125825, 1176.7017984094), new Vsop87.LnVsop(7.8E-10, 1.5110564962, 1269.4996318895), new Vsop87.LnVsop(7.1E-10, 3.64609589554, 198.321241911)};
        private static final Vsop87.LnVsop[] saturn_longitude_l3 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.6038732E-4, 5.73945573267, 7.1135470008), new Vsop87.LnVsop(4.254737E-5, 4.58877599687, 213.299095438), new Vsop87.LnVsop(1.906379E-5, 4.7607084357, 220.4126424388), new Vsop87.LnVsop(1.464959E-5, 5.91328884284, 206.1855484372), new Vsop87.LnVsop(1.162062E-5, 5.61974313217, 14.2270940016), new Vsop87.LnVsop(1.044765E-5, 3.57813061587, 426.598190876), new Vsop87.LnVsop(2.36068E-6, 3.85849798708, 433.7117378768), new Vsop87.LnVsop(2.37009E-6, 5.76820709729, 199.0720014364), new Vsop87.LnVsop(1.65645E-6, 5.11642167451, 3.1813937377), new Vsop87.LnVsop(1.31328E-6, 4.74306126145, 227.5261894396), new Vsop87.LnVsop(1.50882E-6, 2.72695802283, 639.897286314), new Vsop87.LnVsop(6.1607E-7, 4.74260728276, 103.0927742186), new Vsop87.LnVsop(6.3899E-7, 0.08672623762, 419.4846438752), new Vsop87.LnVsop(4.0405E-7, 5.47280316518, 21.3406410024), new Vsop87.LnVsop(4.0222E-7, 5.96343977224, 95.9792272178), new Vsop87.LnVsop(3.8807E-7, 5.83309187434, 110.2063212194), new Vsop87.LnVsop(2.6949E-7, 3.00877360899, 647.0108333148), new Vsop87.LnVsop(2.5017E-7, 0.98675576491, 3.9321532631), new Vsop87.LnVsop(3.2692E-7, 3.14159265359, 0.0), new Vsop87.LnVsop(1.8051E-7, 1.021817946, 412.3710968744), new Vsop87.LnVsop(1.7831E-7, 3.32039911376, 309.2783226558), new Vsop87.LnVsop(1.5894E-7, 3.89729495217, 440.8252848776), new Vsop87.LnVsop(1.5768E-7, 5.61263410328, 117.3198682202), new Vsop87.LnVsop(1.8212E-7, 4.96397771331, 10.2949407385), new Vsop87.LnVsop(1.8497E-7, 1.9253436571, 853.196381752), new Vsop87.LnVsop(1.2927E-7, 1.17950837478, 88.865680217), new Vsop87.LnVsop(1.7889E-7, 4.20422746039, 216.4804891757), new Vsop87.LnVsop(1.144E-7, 5.57587131751, 11.0457002639), new Vsop87.LnVsop(1.0554E-7, 5.92710883673, 191.9584544356), new Vsop87.LnVsop(1.0432E-7, 3.95667199114, 209.3669421749), new Vsop87.LnVsop(8.655E-8, 3.39231823414, 302.164775655), new Vsop87.LnVsop(7.523E-8, 4.87915941795, 323.5054166574), new Vsop87.LnVsop(5.871E-8, 1.0570339306, 210.1177017003), new Vsop87.LnVsop(5.349E-8, 4.63664712061, 234.6397364404), new Vsop87.LnVsop(4.986E-8, 0.17277280741, 632.7837393132), new Vsop87.LnVsop(6.3E-8, 2.25329355289, 522.5774180938), new Vsop87.LnVsop(3.608E-8, 2.30889061812, 515.463871093), new Vsop87.LnVsop(2.933E-8, 2.21148312356, 860.3099287528), new Vsop87.LnVsop(2.572E-8, 0.41973213333, 625.6701923124), new Vsop87.LnVsop(2.479E-8, 4.94903388247, 224.3447957019), new Vsop87.LnVsop(2.175E-8, 3.16635787015, 202.2533951741), new Vsop87.LnVsop(2.368E-8, 4.75945968289, 330.6189636582), new Vsop87.LnVsop(2.705E-8, 0.65007424536, 529.6909650946), new Vsop87.LnVsop(1.981E-8, 4.38259974938, 124.433415221), new Vsop87.LnVsop(2.151E-8, 1.35777052319, 405.2575498736), new Vsop87.LnVsop(2.05E-8, 1.03766221834, 728.762966531), new Vsop87.LnVsop(2.129E-8, 3.34889649076, 429.7795846137), new Vsop87.LnVsop(1.804E-8, 3.08896387579, 654.1243803156), new Vsop87.LnVsop(1.794E-8, 3.09524789608, 422.6660376129), new Vsop87.LnVsop(1.767E-8, 4.12428069333, 536.8045120954), new Vsop87.LnVsop(2.036E-8, 4.14778460181, 223.5940361765), new Vsop87.LnVsop(1.522E-8, 0.30568508593, 316.3918696566), new Vsop87.LnVsop(2.003E-8, 1.19811189628, 1066.49547719), new Vsop87.LnVsop(1.824E-8, 5.82606735563, 195.1398481733), new Vsop87.LnVsop(1.672E-8, 6.05450203591, 742.9900605326), new Vsop87.LnVsop(1.374E-8, 5.00478301043, 956.2891559706), new Vsop87.LnVsop(1.33E-8, 3.91860861475, 269.9214467406), new Vsop87.LnVsop(1.448E-8, 1.57683663501, 81.7521332162), new Vsop87.LnVsop(1.282E-8, 1.641726276, 63.7358983034), new Vsop87.LnVsop(1.53E-8, 2.07185037631, 838.9692877504), new Vsop87.LnVsop(1.023E-8, 3.72829174293, 295.0512286542), new Vsop87.LnVsop(1.252E-8, 2.40431685132, 217.2312487011), new Vsop87.LnVsop(1.325E-8, 1.4316872847, 735.8765135318), new Vsop87.LnVsop(9.41E-9, 2.77748068918, 284.1485407422), new Vsop87.LnVsop(8.03E-9, 4.71988196699, 56.6223513026), new Vsop87.LnVsop(9.48E-9, 2.0311671158, 831.8557407496), new Vsop87.LnVsop(8.31E-9, 0.74562303148, 846.0828347512), new Vsop87.LnVsop(8.42E-9, 3.3317537692, 18.1592472647), new Vsop87.LnVsop(8.24E-9, 0.80001123001, 1045.1548361876), new Vsop87.LnVsop(8.57E-9, 2.39067793598, 203.0041546995), new Vsop87.LnVsop(7.38E-9, 3.80960374631, 447.9388318784), new Vsop87.LnVsop(5.84E-9, 6.25069777652, 942.062061969), new Vsop87.LnVsop(5.38E-9, 2.86495331128, 184.8449074348), new Vsop87.LnVsop(5.05E-9, 6.25643434939, 1059.3819301892), new Vsop87.LnVsop(6.26E-9, 1.55608850413, 423.4167971383), new Vsop87.LnVsop(4.85E-9, 3.46793365763, 149.5631971346), new Vsop87.LnVsop(4.84E-9, 4.87301938477, 1272.6810256272), new Vsop87.LnVsop(4.33E-9, 2.70775591374, 508.3503240922), new Vsop87.LnVsop(4.38E-9, 4.22151675617, 437.6438911399), new Vsop87.LnVsop(4.35E-9, 5.39766982546, 408.4389436113), new Vsop87.LnVsop(3.52E-9, 0.59786545468, 22.0914005278), new Vsop87.LnVsop(3.67E-9, 1.22439337201, 2324.9494088156), new Vsop87.LnVsop(4.38E-9, 1.71625572063, 1155.361157407), new Vsop87.LnVsop(3.74E-9, 1.18586297651, 721.6494195302), new Vsop87.LnVsop(3.1E-9, 2.42135657973, 127.4717966068), new Vsop87.LnVsop(3.09E-9, 0.33610530663, 6076.8903015542), new Vsop87.LnVsop(3.09E-9, 1.42279282226, 6062.6632075526), new Vsop87.LnVsop(3.05E-9, 5.34819286072, 131.4039498699), new Vsop87.LnVsop(3.33E-9, 1.84641267165, 1141.1340634054), new Vsop87.LnVsop(3.58E-9, 0.68499202426, 1361.5467058442), new Vsop87.LnVsop(2.93E-9, 2.1908688296, 416.3032501375), new Vsop87.LnVsop(3.37E-9, 3.2900154507, 750.1036075334), new Vsop87.LnVsop(2.93E-9, 2.28323305517, 635.9651330509), new Vsop87.LnVsop(3.73E-9, 1.10446940352, 1052.2683831884), new Vsop87.LnVsop(3.13E-9, 1.86587122616, 1148.2476104062), new Vsop87.LnVsop(2.58E-9, 3.31118509824, 618.5566453116), new Vsop87.LnVsop(2.58E-9, 2.56646226279, 415.5524906121), new Vsop87.LnVsop(2.52E-9, 1.83229588399, 628.8515860501), new Vsop87.LnVsop(2.96E-9, 1.29860021998, 490.3340891794), new Vsop87.LnVsop(3.04E-9, 2.58172658788, 362.8622925726), new Vsop87.LnVsop(2.93E-9, 4.0259531986, 543.9180590962), new Vsop87.LnVsop(2.95E-9, 0.35280179538, 2730.2069586892), new Vsop87.LnVsop(2.43E-9, 3.12295878727, 1382.8873468466), new Vsop87.LnVsop(2.37E-9, 1.50349467228, 70.8494453042), new Vsop87.LnVsop(2.61E-9, 1.55058302472, 1457.525933062), new Vsop87.LnVsop(2.91E-9, 0.8806934034, 2104.5367663768), new Vsop87.LnVsop(3.04E-9, 1.86172088151, 824.7421937488), new Vsop87.LnVsop(2.89E-9, 1.10556085722, 1788.1448967202), new Vsop87.LnVsop(2.57E-9, 1.47442762699, 1073.6090241908), new Vsop87.LnVsop(2.36E-9, 2.78922688109, 430.5303441391), new Vsop87.LnVsop(2.17E-9, 3.57312838427, 483.2205421786), new Vsop87.LnVsop(2.53E-9, 1.52081140336, 1471.7530270636), new Vsop87.LnVsop(2.23E-9, 0.29158786156, 2854.6403739102), new Vsop87.LnVsop(2.82E-9, 0.18719544473, 99.9113804809), new Vsop87.LnVsop(2.06E-9, 1.81343391023, 497.4476361802), new Vsop87.LnVsop(2.41E-9, 0.70959972165, 2420.9286360334), new Vsop87.LnVsop(2.51E-9, 0.61933213502, 2413.8150890326), new Vsop87.LnVsop(2.22E-9, 2.30065576536, 867.4234757536), new Vsop87.LnVsop(1.98E-9, 6.11152305398, 1258.4539316256), new Vsop87.LnVsop(2.37E-9, 0.41532391633, 1677.9385755008), new Vsop87.LnVsop(2.4E-9, 5.33742562346, 231.4583427027), new Vsop87.LnVsop(2.44E-9, 0.92932541351, 52.6901980395), new Vsop87.LnVsop(2.31E-9, 3.3590553049, 436.8931316145), new Vsop87.LnVsop(2.27E-9, 0.43324651601, 2737.32050569), new Vsop87.LnVsop(2.03E-9, 4.11821570036, 337.732510659), new Vsop87.LnVsop(2.07E-9, 0.26876250106, 3046.5988283458), new Vsop87.LnVsop(2.15E-9, 3.58355205754, 934.9485149682), new Vsop87.LnVsop(2.12E-9, 1.25688162158, 1773.9178027186), new Vsop87.LnVsop(2.01E-9, 4.03418221542, 131.5469622218), new Vsop87.LnVsop(2.22E-9, 0.38124598378, 1279.794572628), new Vsop87.LnVsop(2.2E-9, 0.9518454595, 1038.0412891868), new Vsop87.LnVsop(2.41E-9, 4.63368951189, 1905.4647649404), new Vsop87.LnVsop(2.1E-9, 4.19139167658, 2221.856634597), new Vsop87.LnVsop(1.76E-9, 2.94962159722, 74.7815985673), new Vsop87.LnVsop(2.11E-9, 5.60391253075, 2943.5060541272), new Vsop87.LnVsop(1.81E-9, 0.68460528413, 2001.4439921582), new Vsop87.LnVsop(1.85E-9, 0.34812960604, 2317.8358618148), new Vsop87.LnVsop(1.6E-9, 1.23508694599, 1596.1864422846), new Vsop87.LnVsop(1.75E-9, 4.14605894816, 2090.3096723752), new Vsop87.LnVsop(1.52E-9, 0.05796022559, 32.2433289144), new Vsop87.LnVsop(1.62E-9, 0.97905647862, 2627.1141844706), new Vsop87.LnVsop(1.46E-9, 4.58001707019, 106.2741679563), new Vsop87.LnVsop(1.85E-9, 4.74630303607, 319.5732633943), new Vsop87.LnVsop(1.52E-9, 3.58854245185, 650.9429865779), new Vsop87.LnVsop(1.54E-9, 1.27898590074, 636.7158925763), new Vsop87.LnVsop(1.94E-9, 1.21816145647, 2207.6295405954), new Vsop87.LnVsop(1.79E-9, 3.37155577752, 2332.0629558164), new Vsop87.LnVsop(1.5E-9, 2.52427390338, 643.0786800517), new Vsop87.LnVsop(1.47E-9, 6.2712226073, 1994.3304451574), new Vsop87.LnVsop(1.66E-9, 0.52445262931, 113.3877149571), new Vsop87.LnVsop(1.4E-9, 3.04260087324, 661.2379273164), new Vsop87.LnVsop(1.18E-9, 1.12530803349, 215.7467759928), new Vsop87.LnVsop(1.17E-9, 0.86867361262, 1574.8458012822), new Vsop87.LnVsop(1.08E-9, 4.2507708808, 145.6310438715), new Vsop87.LnVsop(1.48E-9, 0.89634027181, 1368.660252845), new Vsop87.LnVsop(1.06E-9, 1.12784071177, 1162.4747044078), new Vsop87.LnVsop(1.29E-9, 1.02682913037, 313.2104759189), new Vsop87.LnVsop(1.2E-9, 1.01405091659, 2516.9078632512), new Vsop87.LnVsop(1.14E-9, 3.30194660143, 757.2171545342), new Vsop87.LnVsop(1.24E-9, 4.83905966929, 444.7574381407), new Vsop87.LnVsop(1.01E-9, 5.22590586676, 1567.7322542814), new Vsop87.LnVsop(9.8E-10, 2.30576007013, 2751.5475996916), new Vsop87.LnVsop(9.0E-10, 0.09448012766, 2524.021410252), new Vsop87.LnVsop(1.03E-9, 0.58319919546, 1354.4331588434), new Vsop87.LnVsop(9.5E-10, 4.8452210822, 2620.0006374698), new Vsop87.LnVsop(9.6E-10, 1.39789423575, 277.0349937414), new Vsop87.LnVsop(1.2E-9, 5.05053768078, 2008.557539159), new Vsop87.LnVsop(1.06E-9, 3.69808924883, 2861.753920911), new Vsop87.LnVsop(1.1E-9, 0.16506001444, 1987.2168981566), new Vsop87.LnVsop(8.4E-10, 3.94251629849, 156.6767441354), new Vsop87.LnVsop(8.5E-10, 0.45004931501, 320.3240229197), new Vsop87.LnVsop(8.6E-10, 1.91244115163, 2634.2277314714), new Vsop87.LnVsop(8.6E-10, 1.7687776586, 2097.423219376), new Vsop87.LnVsop(8.2E-10, 1.27140666625, 1685.0521225016), new Vsop87.LnVsop(8.8E-10, 1.67886685969, 1464.6394800628), new Vsop87.LnVsop(8.1E-10, 2.13887651399, 210.8514148832), new Vsop87.LnVsop(8.6E-10, 4.55455922748, 241.7532834412), new Vsop87.LnVsop(8.7E-10, 1.37882811046, 1781.0313497194), new Vsop87.LnVsop(9.4E-10, 4.36001187626, 2641.3412784722), new Vsop87.LnVsop(8.0E-10, 0.03222646119, 1670.8250285), new Vsop87.LnVsop(8.0E-10, 5.40919461005, 2744.4340526908), new Vsop87.LnVsop(9.0E-10, 2.46737000048, 1802.3719907218), new Vsop87.LnVsop(8.6E-10, 2.21461093242, 3156.8051495652), new Vsop87.LnVsop(8.8E-10, 0.60411748611, 703.6331846174), new Vsop87.LnVsop(7.4E-10, 3.72977862703, 1485.9801210652), new Vsop87.LnVsop(8.4E-10, 0.14427542567, 1884.124123938), new Vsop87.LnVsop(9.0E-10, 5.82096787757, 2531.1349572528), new Vsop87.LnVsop(8.5E-10, 2.00389715339, 1699.2792165032), new Vsop87.LnVsop(9.1E-10, 0.69169111465, 1286.9081196288), new Vsop87.LnVsop(7.5E-10, 3.89924996086, 3370.1042450032), new Vsop87.LnVsop(8.4E-10, 1.84802318288, 398.1440028728), new Vsop87.LnVsop(7.6E-10, 3.33883739305, 195.8906076987)};
        private static final Vsop87.LnVsop[] saturn_longitude_l4 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.661877E-5, 3.99824447634, 7.1135470008), new Vsop87.LnVsop(2.57094E-6, 2.98422287887, 220.4126424388), new Vsop87.LnVsop(2.36328E-6, 3.9024884432, 14.2270940016), new Vsop87.LnVsop(1.4952E-6, 2.73191135434, 213.299095438), new Vsop87.LnVsop(1.09412E-6, 1.51564560686, 206.1855484372), new Vsop87.LnVsop(6.9119E-7, 1.74804093636, 426.598190876), new Vsop87.LnVsop(3.768E-7, 1.23800346661, 199.0720014364), new Vsop87.LnVsop(3.9678E-7, 2.04527339062, 433.7117378768), new Vsop87.LnVsop(3.1172E-7, 3.01055217526, 227.5261894396), new Vsop87.LnVsop(1.5026E-7, 0.83249780616, 639.897286314), new Vsop87.LnVsop(9.424E-8, 3.71267465225, 21.3406410024), new Vsop87.LnVsop(5.131E-8, 2.14278851183, 419.4846438752), new Vsop87.LnVsop(4.379E-8, 1.44314873951, 95.9792272178), new Vsop87.LnVsop(5.391E-8, 1.15849076251, 647.0108333148), new Vsop87.LnVsop(4.315E-8, 2.11844568875, 440.8252848776), new Vsop87.LnVsop(3.215E-8, 4.10085180982, 110.2063212194), new Vsop87.LnVsop(2.866E-8, 3.036049512, 88.865680217), new Vsop87.LnVsop(2.825E-8, 2.76965112625, 412.3710968744), new Vsop87.LnVsop(2.584E-8, 6.2804703528, 853.196381752), new Vsop87.LnVsop(2.616E-8, 0.38576038218, 103.0927742186), new Vsop87.LnVsop(1.872E-8, 5.13517095425, 309.2783226558), new Vsop87.LnVsop(2.21E-8, 3.77003162591, 117.3198682202), new Vsop87.LnVsop(1.772E-8, 5.18511152518, 302.164775655), new Vsop87.LnVsop(1.832E-8, 2.8429204789, 234.6397364404), new Vsop87.LnVsop(1.759E-8, 2.26487572601, 216.4804891757), new Vsop87.LnVsop(1.193E-8, 1.54874757981, 191.9584544356), new Vsop87.LnVsop(7.65E-9, 4.76897987642, 210.1177017003), new Vsop87.LnVsop(6.44E-9, 4.21681516017, 515.463871093), new Vsop87.LnVsop(6.19E-9, 4.0485658098, 522.5774180938), new Vsop87.LnVsop(6.19E-9, 2.37595244026, 209.3669421749), new Vsop87.LnVsop(6.11E-9, 3.14631600944, 323.5054166574), new Vsop87.LnVsop(5.6E-9, 2.17190605203, 124.433415221), new Vsop87.LnVsop(5.19E-9, 3.2053999088, 405.2575498736), new Vsop87.LnVsop(4.43E-9, 0.25912890713, 860.3099287528), new Vsop87.LnVsop(4.12E-9, 3.12214166924, 330.6189636582), new Vsop87.LnVsop(4.31E-9, 3.39648180302, 81.7521332162), new Vsop87.LnVsop(3.29E-9, 4.10003432838, 838.9692877504), new Vsop87.LnVsop(3.74E-9, 1.28466223056, 654.1243803156), new Vsop87.LnVsop(3.14E-9, 3.24026230608, 529.6909650946), new Vsop87.LnVsop(2.91E-9, 2.3378377816, 447.9388318784), new Vsop87.LnVsop(2.92E-9, 5.48631134223, 1066.49547719), new Vsop87.LnVsop(2.91E-9, 3.18885372262, 1464.6394800628), new Vsop87.LnVsop(3.04E-9, 1.25087313988, 742.9900605326), new Vsop87.LnVsop(2.7E-9, 2.18054322187, 632.7837393132), new Vsop87.LnVsop(2.98E-9, 2.38540238363, 625.6701923124), new Vsop87.LnVsop(2.57E-9, 4.47876331608, 1574.8458012822), new Vsop87.LnVsop(2.97E-9, 2.58634568787, 1045.1548361876), new Vsop87.LnVsop(3.14E-9, 2.94878103629, 728.762966531), new Vsop87.LnVsop(2.35E-9, 3.67049647573, 1148.2476104062), new Vsop87.LnVsop(2.83E-9, 4.56828102737, 423.4167971383), new Vsop87.LnVsop(2.21E-9, 3.04602691755, 1781.0313497194), new Vsop87.LnVsop(2.36E-9, 3.61825037624, 231.4583427027), new Vsop87.LnVsop(2.61E-9, 2.04564143517, 1677.9385755008), new Vsop87.LnVsop(2.14E-9, 3.55618873096, 1155.361157407), new Vsop87.LnVsop(2.07E-9, 2.0972665148, 1361.5467058442), new Vsop87.LnVsop(2.52E-9, 0.0, 0.0), new Vsop87.LnVsop(1.75E-9, 1.27230112159, 422.6660376129), new Vsop87.LnVsop(1.9E-9, 2.32718555488, 223.5940361765), new Vsop87.LnVsop(1.87E-9, 3.64109764967, 956.2891559706), new Vsop87.LnVsop(1.68E-9, 0.69946458053, 824.7421937488), new Vsop87.LnVsop(1.77E-9, 5.02653087687, 203.0041546995), new Vsop87.LnVsop(1.64E-9, 1.44690006365, 429.7795846137), new Vsop87.LnVsop(1.59E-9, 2.8092529349, 1589.0728952838), new Vsop87.LnVsop(1.52E-9, 3.88114824142, 831.8557407496), new Vsop87.LnVsop(1.29E-9, 4.99346550473, 618.5566453116), new Vsop87.LnVsop(1.43E-9, 1.03749104574, 316.3918696566), new Vsop87.LnVsop(1.29E-9, 2.77308987628, 1169.5882514086), new Vsop87.LnVsop(1.14E-9, 2.00739159822, 295.0512286542), new Vsop87.LnVsop(1.09E-9, 1.39540359862, 1354.4331588434), new Vsop87.LnVsop(1.09E-9, 6.07865735607, 2001.4439921582), new Vsop87.LnVsop(1.23E-9, 2.06227563721, 942.062061969), new Vsop87.LnVsop(1.04E-9, 4.41203428092, 1279.794572628), new Vsop87.LnVsop(1.25E-9, 5.80362410627, 1073.6090241908), new Vsop87.LnVsop(1.07E-9, 3.3439146343, 735.8765135318), new Vsop87.LnVsop(1.02E-9, 0.61258147793, 1788.1448967202), new Vsop87.LnVsop(1.3E-9, 2.23864282613, 536.8045120954), new Vsop87.LnVsop(9.5E-10, 2.58259079168, 846.0828347512), new Vsop87.LnVsop(9.6E-10, 2.93096385623, 224.3447957019), new Vsop87.LnVsop(1.03E-9, 4.92943720757, 508.3503240922), new Vsop87.LnVsop(9.0E-10, 6.21432772004, 1265.5674786264), new Vsop87.LnVsop(8.3E-10, 1.57021339944, 1038.0412891868), new Vsop87.LnVsop(9.4E-10, 2.75644931636, 721.6494195302), new Vsop87.LnVsop(1.05E-9, 0.46132848902, 867.4234757536), new Vsop87.LnVsop(7.8E-10, 4.50314394179, 2015.6710861598), new Vsop87.LnVsop(8.8E-10, 4.99305633625, 444.0066786153)};
        private static final Vsop87.LnVsop[] saturn_longitude_l5 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.23607E-6, 2.25923420203, 7.1135470008), new Vsop87.LnVsop(3.4176E-7, 2.16278773143, 14.2270940016), new Vsop87.LnVsop(2.7539E-7, 1.19822164604, 220.4126424388), new Vsop87.LnVsop(5.763E-8, 1.21171444884, 227.5261894396), new Vsop87.LnVsop(5.284E-8, 0.23520891295, 433.7117378768), new Vsop87.LnVsop(3.65E-8, 6.20014021207, 426.598190876), new Vsop87.LnVsop(3.061E-8, 2.96839870592, 199.0720014364), new Vsop87.LnVsop(2.865E-8, 4.29470838129, 206.1855484372), new Vsop87.LnVsop(1.499E-8, 6.21044685389, 213.299095438), new Vsop87.LnVsop(1.262E-8, 5.25209851911, 639.897286314), new Vsop87.LnVsop(7.56E-9, 6.17670364645, 191.9584544356), new Vsop87.LnVsop(7.59E-9, 0.69127092329, 302.164775655), new Vsop87.LnVsop(8.2E-9, 5.59433772118, 647.0108333148), new Vsop87.LnVsop(9.42E-9, 0.24584020543, 440.8252848776), new Vsop87.LnVsop(5.47E-9, 4.87451203466, 88.865680217), new Vsop87.LnVsop(5.03E-9, 4.63319665449, 419.4846438752), new Vsop87.LnVsop(3.57E-9, 4.73247835262, 860.3099287528), new Vsop87.LnVsop(3.43E-9, 5.70825898673, 654.1243803156), new Vsop87.LnVsop(2.43E-9, 2.03429529667, 323.5054166574), new Vsop87.LnVsop(3.05E-9, 1.06249794404, 234.6397364404), new Vsop87.LnVsop(2.31E-9, 4.36065387404, 853.196381752), new Vsop87.LnVsop(2.32E-9, 0.84968053738, 309.2783226558), new Vsop87.LnVsop(2.39E-9, 0.65475141729, 117.3198682202), new Vsop87.LnVsop(1.67E-9, 5.240620732, 405.2575498736), new Vsop87.LnVsop(1.65E-9, 2.4145655156, 515.463871093), new Vsop87.LnVsop(1.55E-9, 1.75303344154, 412.3710968744), new Vsop87.LnVsop(1.18E-9, 4.41706591175, 632.7837393132), new Vsop87.LnVsop(9.3E-10, 5.50595405458, 95.9792272178), new Vsop87.LnVsop(1.09E-9, 0.34156541412, 447.9388318784), new Vsop87.LnVsop(7.6E-10, 1.01712437818, 522.5774180938)};

        Longitude() {
        }
    }
}

