/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt.solarsystem;

import de.kah2.zodiac.nova4jmt.RiseSet;
import de.kah2.zodiac.nova4jmt.Transform;
import de.kah2.zodiac.nova4jmt.Utility;
import de.kah2.zodiac.nova4jmt.Vsop87;
import de.kah2.zodiac.nova4jmt.api.LnEquPosn;
import de.kah2.zodiac.nova4jmt.api.LnHelioPosn;
import de.kah2.zodiac.nova4jmt.api.LnLnlatPosn;
import de.kah2.zodiac.nova4jmt.api.LnRectPosn;
import de.kah2.zodiac.nova4jmt.api.LnRstTime;
import de.kah2.zodiac.nova4jmt.solarsystem.Earth;
import de.kah2.zodiac.nova4jmt.solarsystem.Solar;
import de.kah2.zodiac.nova4jmt.util.IGetEquBodyCoords;

public class Jupiter {
    static double cJD = 0.0;
    static double cL = 0.0;
    static double cB = 0.0;
    static double cR = 0.0;

    public static void ln_get_jupiter_equ_coords(double JD, LnEquPosn position) {
        double c;
        double b;
        double a;
        double last;
        double delta;
        double diff;
        LnHelioPosn h_sol = new LnHelioPosn();
        LnHelioPosn h_jupiter = new LnHelioPosn();
        LnRectPosn g_sol = new LnRectPosn();
        LnRectPosn g_jupiter = new LnRectPosn();
        double t = 0.0;
        Solar.ln_get_solar_geom_coords(JD, h_sol);
        Transform.ln_get_rect_from_helio(h_sol, g_sol);
        do {
            last = t;
            Jupiter.ln_get_jupiter_helio_coords(JD - t, h_jupiter);
            Transform.ln_get_rect_from_helio(h_jupiter, g_jupiter);
            a = g_sol.X + g_jupiter.X;
            b = g_sol.Y + g_jupiter.Y;
            c = g_sol.Z + g_jupiter.Z;
            delta = a * a + b * b + c * c;
        } while ((diff = (t = (delta = Math.sqrt(delta)) * 0.0057755183) - last) > 1.0E-4 || diff < -1.0E-4);
        double ra = Math.atan2(b, a);
        double dec = c / delta;
        dec = Math.asin(dec);
        position.ra = Utility.ln_range_degrees(Utility.ln_rad_to_deg(ra));
        position.dec = Utility.ln_rad_to_deg(dec);
    }

    public static void ln_get_jupiter_helio_coords(double JD, LnHelioPosn position) {
        if (JD == cJD) {
            position.L = cL;
            position.B = cB;
            position.R = cR;
            return;
        }
        double t = (JD - 2451545.0) / 365250.0;
        double t2 = t * t;
        double t3 = t2 * t;
        double t4 = t3 * t;
        double t5 = t4 * t;
        double L0 = Vsop87.ln_calc_series(Lontitude.jupiter_longitude_l0, t);
        double L1 = Vsop87.ln_calc_series(Lontitude.jupiter_longitude_l1, t);
        double L2 = Vsop87.ln_calc_series(Lontitude.jupiter_longitude_l2, t);
        double L3 = Vsop87.ln_calc_series(Lontitude.jupiter_longitude_l3, t);
        double L4 = Vsop87.ln_calc_series(Lontitude.jupiter_longitude_l4, t);
        double L5 = Vsop87.ln_calc_series(Lontitude.jupiter_longitude_l5, t);
        position.L = L0 + L1 * t + L2 * t2 + L3 * t3 + L4 * t4 + L5 * t5;
        double B0 = Vsop87.ln_calc_series(Latitude.jupiter_latitude_b0, t);
        double B1 = Vsop87.ln_calc_series(Latitude.jupiter_latitude_b1, t);
        double B2 = Vsop87.ln_calc_series(Latitude.jupiter_latitude_b2, t);
        double B3 = Vsop87.ln_calc_series(Latitude.jupiter_latitude_b3, t);
        double B4 = Vsop87.ln_calc_series(Latitude.jupiter_latitude_b4, t);
        double B5 = Vsop87.ln_calc_series(Latitude.jupiter_latitude_b5, t);
        position.B = B0 + B1 * t + B2 * t2 + B3 * t3 + B4 * t4 + B5 * t5;
        double R0 = Vsop87.ln_calc_series(Radius.jupiter_radius_r0, t);
        double R1 = Vsop87.ln_calc_series(Radius.jupiter_radius_r1, t);
        double R2 = Vsop87.ln_calc_series(Radius.jupiter_radius_r2, t);
        double R3 = Vsop87.ln_calc_series(Radius.jupiter_radius_r3, t);
        double R4 = Vsop87.ln_calc_series(Radius.jupiter_radius_r4, t);
        double R5 = Vsop87.ln_calc_series(Radius.jupiter_radius_r5, t);
        position.R = R0 + R1 * t + R2 * t2 + R3 * t3 + R4 * t4 + R5 * t5;
        position.L = Utility.ln_rad_to_deg(position.L);
        position.B = Utility.ln_rad_to_deg(position.B);
        position.L = Utility.ln_range_degrees(position.L);
        Vsop87.ln_vsop87_to_fk5(position, JD);
        cJD = JD;
        cL = position.L;
        cB = position.B;
        cR = position.R;
    }

    public static double ln_get_jupiter_earth_dist(double JD) {
        LnHelioPosn h_jupiter = new LnHelioPosn();
        LnHelioPosn h_earth = new LnHelioPosn();
        LnRectPosn g_jupiter = new LnRectPosn();
        LnRectPosn g_earth = new LnRectPosn();
        Jupiter.ln_get_jupiter_helio_coords(JD, h_jupiter);
        Earth.ln_get_earth_helio_coords(JD, h_earth);
        Transform.ln_get_rect_from_helio(h_jupiter, g_jupiter);
        Transform.ln_get_rect_from_helio(h_earth, g_earth);
        double x = g_jupiter.X - g_earth.X;
        double y = g_jupiter.Y - g_earth.Y;
        double z = g_jupiter.Z - g_earth.Z;
        x *= x;
        y *= y;
        z *= z;
        return Math.sqrt(x + y + z);
    }

    public static double ln_get_jupiter_solar_dist(double JD) {
        LnHelioPosn h_jupiter = new LnHelioPosn();
        Jupiter.ln_get_jupiter_helio_coords(JD, h_jupiter);
        return h_jupiter.R;
    }

    public static double ln_get_jupiter_magnitude(double JD) {
        double r = Jupiter.ln_get_jupiter_solar_dist(JD);
        double delta = Jupiter.ln_get_jupiter_earth_dist(JD);
        double i = Jupiter.ln_get_jupiter_phase(JD);
        return -9.4 + 5.0 * Math.log10(r * delta) + 0.005 * i;
    }

    public static double ln_get_jupiter_disk(double JD) {
        double R = Earth.ln_get_earth_solar_dist(JD);
        double r = Jupiter.ln_get_jupiter_solar_dist(JD);
        double delta = Jupiter.ln_get_jupiter_earth_dist(JD);
        return ((r + delta) * (r + delta) - R * R) / (4.0 * r * delta);
    }

    public static double ln_get_jupiter_phase(double JD) {
        double R = Earth.ln_get_earth_solar_dist(JD);
        double r = Jupiter.ln_get_jupiter_solar_dist(JD);
        double delta = Jupiter.ln_get_jupiter_earth_dist(JD);
        double i = (r * r + delta * delta - R * R) / (2.0 * r * delta);
        i = Math.acos(i);
        return Utility.ln_rad_to_deg(i);
    }

    public static int ln_get_jupiter_rst(double JD, LnLnlatPosn observer, LnRstTime rst) {
        return RiseSet.ln_get_body_rst_horizon(JD, observer, new IGetEquBodyCoords(){

            @Override
            public void get_equ_body_coords(double JD, LnEquPosn position) {
                Jupiter.ln_get_jupiter_equ_coords(JD, position);
            }
        }, RiseSet.LN_STAR_STANDART_HORIZON.doubleValue(), rst);
    }

    public static double ln_get_jupiter_equ_sdiam(double JD) {
        double So = 98.44;
        double dist = Jupiter.ln_get_jupiter_earth_dist(JD);
        return So / dist;
    }

    public static double ln_get_jupiter_pol_sdiam(double JD) {
        double So = 92.06;
        double dist = Jupiter.ln_get_jupiter_earth_dist(JD);
        return So / dist;
    }

    public static void ln_get_jupiter_rect_helio(double JD, LnRectPosn position) {
        LnHelioPosn jupiter = new LnHelioPosn();
        Jupiter.ln_get_jupiter_helio_coords(JD, jupiter);
        Transform.ln_get_rect_from_helio(jupiter, position);
    }

    static class Radius {
        private static final Vsop87.LnVsop[] jupiter_radius_r0 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(5.20887429326, 0.0, 0.0), new Vsop87.LnVsop(0.25209327119, 3.49108639871, 529.6909650946), new Vsop87.LnVsop(0.00610599976, 3.84115365948, 1059.3819301892), new Vsop87.LnVsop(0.00282029458, 2.57419881293, 632.7837393132), new Vsop87.LnVsop(0.00187647346, 2.07590383214, 522.5774180938), new Vsop87.LnVsop(8.6792905E-4, 0.71001145545, 419.4846438752), new Vsop87.LnVsop(7.2062974E-4, 0.21465724607, 536.8045120954), new Vsop87.LnVsop(6.5517248E-4, 5.9799588479, 316.3918696566), new Vsop87.LnVsop(2.9134542E-4, 1.67759379655, 103.0927742186), new Vsop87.LnVsop(3.0135335E-4, 2.16132003734, 949.1756089698), new Vsop87.LnVsop(2.3453271E-4, 3.54023522184, 735.8765135318), new Vsop87.LnVsop(2.2283743E-4, 4.19362594399, 1589.0728952838), new Vsop87.LnVsop(2.3947298E-4, 0.2745803748, 7.1135470008), new Vsop87.LnVsop(1.3032614E-4, 2.96042965363, 1162.4747044078), new Vsop87.LnVsop(9.70336E-5, 1.90669633585, 206.1855484372), new Vsop87.LnVsop(1.2749023E-4, 2.71550286592, 1052.2683831884), new Vsop87.LnVsop(9.161393E-5, 4.41352953117, 213.299095438), new Vsop87.LnVsop(7.894511E-5, 2.47907592482, 426.598190876), new Vsop87.LnVsop(7.057931E-5, 2.18184839926, 1265.5674786264), new Vsop87.LnVsop(6.137703E-5, 6.26418240033, 846.0828347512), new Vsop87.LnVsop(5.477001E-5, 5.65729989857, 639.897286314), new Vsop87.LnVsop(3.502493E-5, 0.56532365822, 1066.49547719), new Vsop87.LnVsop(4.136822E-5, 2.722208724, 625.6701923124), new Vsop87.LnVsop(4.169954E-5, 2.01603822251, 515.463871093), new Vsop87.LnVsop(2.499967E-5, 4.55181655381, 838.9692877504), new Vsop87.LnVsop(2.616976E-5, 2.00994012876, 1581.959348283), new Vsop87.LnVsop(1.912009E-5, 0.85621128851, 412.3710968744), new Vsop87.LnVsop(2.127681E-5, 6.12755221002, 742.9900605326), new Vsop87.LnVsop(1.610567E-5, 3.08871452594, 1368.660252845), new Vsop87.LnVsop(1.479513E-5, 2.68021307468, 1478.8665740644), new Vsop87.LnVsop(1.23063E-5, 1.89052048109, 323.5054166574), new Vsop87.LnVsop(1.216895E-5, 1.80176263029, 110.2063212194), new Vsop87.LnVsop(9.61113E-6, 4.54876995367, 2118.7638603784), new Vsop87.LnVsop(8.85764E-6, 4.14783869943, 533.6231183577), new Vsop87.LnVsop(7.76583E-6, 3.67710828843, 728.762966531), new Vsop87.LnVsop(9.98591E-6, 2.87205397992, 309.2783226558), new Vsop87.LnVsop(1.014733E-5, 1.38675822271, 454.9093665273), new Vsop87.LnVsop(7.27156E-6, 3.98827252563, 1155.361157407), new Vsop87.LnVsop(6.55334E-6, 2.7907259691, 1685.0521225016), new Vsop87.LnVsop(8.21383E-6, 1.59351544602, 1898.3512179396), new Vsop87.LnVsop(6.20818E-6, 4.82275194351, 956.2891559706), new Vsop87.LnVsop(6.54071E-6, 3.38140746852, 1692.1656695024), new Vsop87.LnVsop(8.11993E-6, 5.94093410097, 909.8187330546), new Vsop87.LnVsop(5.62092E-6, 0.08114877791, 543.9180590962), new Vsop87.LnVsop(5.42222E-6, 0.28357235311, 525.7588118315), new Vsop87.LnVsop(4.57841E-6, 0.12720499202, 1375.7737998458), new Vsop87.LnVsop(6.1474E-6, 2.27633681284, 942.062061969), new Vsop87.LnVsop(4.35816E-6, 2.60279250213, 95.9792272178), new Vsop87.LnVsop(4.96009E-6, 5.53020241869, 380.12776796), new Vsop87.LnVsop(4.69974E-6, 2.81883756859, 1795.258443721), new Vsop87.LnVsop(4.45057E-6, 0.14648640292, 14.2270940016), new Vsop87.LnVsop(2.90917E-6, 3.89373030829, 1471.7530270636), new Vsop87.LnVsop(2.76581E-6, 2.52188912681, 2001.4439921582), new Vsop87.LnVsop(2.7501E-6, 2.98827073289, 526.5095713569), new Vsop87.LnVsop(2.93746E-6, 2.04945754349, 199.0720014364), new Vsop87.LnVsop(2.9101E-6, 6.03128127682, 1169.5882514086), new Vsop87.LnVsop(3.38146E-6, 2.79887096517, 1045.1548361876), new Vsop87.LnVsop(2.57472E-6, 6.13406653083, 532.8723588323), new Vsop87.LnVsop(3.19036E-6, 1.34818583641, 2214.7430875962), new Vsop87.LnVsop(3.09305E-6, 5.36839401116, 1272.6810256272), new Vsop87.LnVsop(3.45803E-6, 1.56404960644, 491.5579294568), new Vsop87.LnVsop(3.03364E-6, 1.15407454389, 5753.3848848968), new Vsop87.LnVsop(1.92308E-6, 0.91996013364, 1596.1864422846), new Vsop87.LnVsop(2.15435E-6, 2.63589770012, 2111.6503133776), new Vsop87.LnVsop(2.00591E-6, 2.37332227687, 1258.4539316256), new Vsop87.LnVsop(2.39039E-6, 3.57396895042, 835.0371344873), new Vsop87.LnVsop(1.97072E-6, 5.92862098187, 453.424893819), new Vsop87.LnVsop(1.39406E-6, 3.63978241621, 1788.1448967202), new Vsop87.LnVsop(1.91351E-6, 8.947898E-5, 983.1158589136), new Vsop87.LnVsop(1.76442E-6, 2.57642803889, 9683.5945811164), new Vsop87.LnVsop(1.23523E-6, 2.26101680855, 2317.8358618148), new Vsop87.LnVsop(1.28191E-6, 4.66615733627, 831.8557407496), new Vsop87.LnVsop(1.12538E-6, 0.85603677104, 433.7117378768), new Vsop87.LnVsop(1.28822E-6, 1.10499202918, 2531.1349572528), new Vsop87.LnVsop(9.9327E-7, 4.50365769161, 518.6452648307), new Vsop87.LnVsop(9.3945E-7, 2.72470156299, 853.196381752), new Vsop87.LnVsop(1.06425E-6, 5.81491645745, 220.4126424388), new Vsop87.LnVsop(1.20294E-6, 2.9520444051, 3.9321532631), new Vsop87.LnVsop(8.1685E-7, 3.23399956574, 1361.5467058442), new Vsop87.LnVsop(1.03994E-6, 2.22277966661, 74.7815985673), new Vsop87.LnVsop(1.12513E-6, 4.86217051434, 528.2064923863), new Vsop87.LnVsop(7.9631E-7, 0.88529543139, 430.5303441391), new Vsop87.LnVsop(8.5789E-7, 2.11469709334, 1574.8458012822), new Vsop87.LnVsop(8.5635E-7, 2.33825806277, 2428.0421830342), new Vsop87.LnVsop(6.8348E-7, 3.35769613854, 2104.5367663768), new Vsop87.LnVsop(6.9535E-7, 3.04092499583, 302.164775655), new Vsop87.LnVsop(6.9854E-7, 3.22383407236, 305.3461693927), new Vsop87.LnVsop(6.9498E-7, 0.20470467419, 532.1386456494), new Vsop87.LnVsop(5.7002E-7, 2.0027840307, 2634.2277314714), new Vsop87.LnVsop(7.7019E-7, 2.09814823113, 508.3503240922), new Vsop87.LnVsop(5.6672E-7, 3.9163533075, 2221.856634597), new Vsop87.LnVsop(5.8366E-7, 5.72512642459, 628.8515860501), new Vsop87.LnVsop(5.2433E-7, 4.0250857458, 527.2432845398), new Vsop87.LnVsop(6.3628E-7, 1.10008717069, 1364.7280995819), new Vsop87.LnVsop(5.3607E-7, 0.87404483378, 2847.5268269094), new Vsop87.LnVsop(5.9639E-7, 0.95858565273, 494.2662424425), new Vsop87.LnVsop(5.8002E-7, 3.45633892143, 2008.557539159), new Vsop87.LnVsop(4.153E-7, 3.51955496522, 529.7391492044), new Vsop87.LnVsop(4.4717E-7, 1.62318067555, 984.6003316219), new Vsop87.LnVsop(4.4943E-7, 4.90105773635, 2648.454825473), new Vsop87.LnVsop(5.3154E-7, 1.19752849531, 760.25553592), new Vsop87.LnVsop(4.4532E-7, 4.42376920441, 1063.3140834523), new Vsop87.LnVsop(3.7511E-7, 2.93024338067, 1677.9385755008), new Vsop87.LnVsop(4.1535E-7, 0.3217437907, 529.6427809848), new Vsop87.LnVsop(4.2886E-7, 0.03097825861, 1439.5096981492), new Vsop87.LnVsop(4.601E-7, 2.54409504187, 636.7158925763), new Vsop87.LnVsop(4.0307E-7, 4.39482471634, 1148.2476104062), new Vsop87.LnVsop(3.8818E-7, 4.31684853535, 149.5631971346), new Vsop87.LnVsop(4.0357E-7, 2.10207822074, 2744.4340526908), new Vsop87.LnVsop(4.8851E-7, 5.60297823445, 2810.9214616052), new Vsop87.LnVsop(3.703E-7, 5.07904223157, 1905.4647649404), new Vsop87.LnVsop(4.3876E-7, 1.24634677337, 621.7380390493), new Vsop87.LnVsop(3.4015E-7, 3.09481058565, 2420.9286360334), new Vsop87.LnVsop(3.6829E-7, 0.84237174099, 530.6541729411), new Vsop87.LnVsop(3.1256E-7, 5.35795807657, 1485.9801210652), new Vsop87.LnVsop(3.9276E-7, 4.70909591065, 569.0478410098), new Vsop87.LnVsop(3.979E-7, 2.46062195592, 355.7487455718), new Vsop87.LnVsop(3.153E-7, 6.19283211825, 3.1813937377), new Vsop87.LnVsop(2.8366E-7, 2.48520234303, 519.3960243561), new Vsop87.LnVsop(3.2409E-7, 2.73383239343, 604.4725636619), new Vsop87.LnVsop(2.7094E-7, 3.92463420595, 2324.9494088156), new Vsop87.LnVsop(2.9014E-7, 1.83523374921, 1891.2376709388), new Vsop87.LnVsop(2.6731E-7, 1.74874273361, 2950.619601128), new Vsop87.LnVsop(2.6453E-7, 0.60429095482, 1055.4497769261), new Vsop87.LnVsop(3.3475E-7, 0.7646317035, 643.8294395771), new Vsop87.LnVsop(2.6499E-7, 1.03248824966, 405.2575498736), new Vsop87.LnVsop(2.5634E-7, 3.46480952342, 458.8415197904), new Vsop87.LnVsop(2.445E-7, 0.88074669554, 423.4167971383), new Vsop87.LnVsop(3.2957E-7, 3.18606309728, 528.7277572481), new Vsop87.LnVsop(2.2463E-7, 0.43478364259, 1073.6090241908), new Vsop87.LnVsop(2.1623E-7, 1.42192729492, 540.7366653585), new Vsop87.LnVsop(2.564E-7, 0.52452881258, 511.5317178299), new Vsop87.LnVsop(2.1016E-7, 3.08217890882, 629.6023455755), new Vsop87.LnVsop(2.2666E-7, 0.65441785872, 3163.918696566), new Vsop87.LnVsop(1.9316E-7, 5.17023800333, 635.9651330509), new Vsop87.LnVsop(2.6139E-7, 1.33354028131, 330.6189636582), new Vsop87.LnVsop(1.8303E-7, 3.5997376613, 746.9222137957), new Vsop87.LnVsop(1.8225E-7, 2.66424699243, 1994.3304451574), new Vsop87.LnVsop(1.9775E-7, 4.13615184912, 1464.6394800628), new Vsop87.LnVsop(1.9466E-7, 1.85632162779, 3060.8259223474), new Vsop87.LnVsop(2.393E-7, 4.99825426891, 1289.9465010146), new Vsop87.LnVsop(2.1865E-7, 5.91688197848, 1802.3719907218), new Vsop87.LnVsop(1.7423E-7, 2.81999126875, 2737.32050569), new Vsop87.LnVsop(1.6669E-7, 5.67299018075, 408.4389436113), new Vsop87.LnVsop(2.294E-7, 5.2676048026, 672.1406152284), new Vsop87.LnVsop(1.8349E-7, 1.89870628722, 1021.2488945514), new Vsop87.LnVsop(1.9065E-7, 3.66520144826, 415.5524906121), new Vsop87.LnVsop(1.5733E-7, 3.34757176872, 1056.2005364515), new Vsop87.LnVsop(1.6361E-7, 0.18155522601, 1699.2792165032), new Vsop87.LnVsop(1.8718E-7, 1.97821694809, 38.1330356378), new Vsop87.LnVsop(1.8769E-7, 3.69167351769, 88.865680217), new Vsop87.LnVsop(1.553E-7, 3.82369172511, 721.6494195302), new Vsop87.LnVsop(1.5401E-7, 1.06319902793, 114.1384744825), new Vsop87.LnVsop(1.6809E-7, 1.91000618622, 217.2312487011), new Vsop87.LnVsop(1.5253E-7, 1.31927244263, 117.3198682202), new Vsop87.LnVsop(1.5115E-7, 3.74899964992, 2641.3412784722), new Vsop87.LnVsop(1.9654E-7, 2.7339106561, 39.3568759152), new Vsop87.LnVsop(1.4669E-7, 1.67269531093, 529.1697002328), new Vsop87.LnVsop(1.4116E-7, 3.55112673348, 142.4496501338), new Vsop87.LnVsop(1.3001E-7, 1.48488755301, 3267.0114707846), new Vsop87.LnVsop(1.4924E-7, 1.32583007552, 490.3340891794), new Vsop87.LnVsop(1.4753E-7, 4.64530618099, 6283.0758499914), new Vsop87.LnVsop(1.4666E-7, 0.80451966905, 5223.6939198022), new Vsop87.LnVsop(1.2149E-7, 3.667552208, 750.1036075334), new Vsop87.LnVsop(1.1954E-7, 2.97127390765, 505.3119427064), new Vsop87.LnVsop(1.4697E-7, 2.16792533244, 530.2122299564), new Vsop87.LnVsop(1.2272E-7, 0.20695687447, 1062.5633239269), new Vsop87.LnVsop(1.1491E-7, 1.11749661877, 561.934294009), new Vsop87.LnVsop(1.1727E-7, 1.6592279015, 2207.6295405954), new Vsop87.LnVsop(1.1081E-7, 3.22060243425, 535.107591066), new Vsop87.LnVsop(1.1566E-7, 5.23036903534, 524.0618908021), new Vsop87.LnVsop(1.1187E-7, 3.8384242505, 76.2660712756), new Vsop87.LnVsop(1.2702E-7, 3.96823187752, 2538.2485042536), new Vsop87.LnVsop(1.0918E-7, 1.27796360308, 2125.8774073792), new Vsop87.LnVsop(1.1242E-7, 3.23197763125, 422.6660376129), new Vsop87.LnVsop(1.264E-7, 0.73683423677, 908.3342603463), new Vsop87.LnVsop(1.131E-7, 5.55879589444, 531.1754378029), new Vsop87.LnVsop(9.584E-8, 5.01019903321, 597.3590166611), new Vsop87.LnVsop(1.031E-7, 3.83872758066, 1781.0313497194), new Vsop87.LnVsop(1.0762E-7, 4.91380719453, 525.0250986486), new Vsop87.LnVsop(1.1756E-7, 5.11238523418, 685.4739373527), new Vsop87.LnVsop(1.1958E-7, 1.72875918561, 911.3032057629), new Vsop87.LnVsop(9.511E-8, 2.95053004168, 1382.8873468466), new Vsop87.LnVsop(8.902E-8, 2.40357723787, 2310.722314814), new Vsop87.LnVsop(9.215E-8, 2.57853098079, 3053.7123753466), new Vsop87.LnVsop(9.92E-8, 0.43817210648, 3480.3105662226), new Vsop87.LnVsop(8.714E-8, 3.67018202505, 739.8086667949), new Vsop87.LnVsop(8.664E-8, 2.70398612383, 526.7702037878), new Vsop87.LnVsop(9.435E-8, 1.61939988249, 3377.217792004), new Vsop87.LnVsop(1.1544E-7, 1.59031375667, 1474.6737883704), new Vsop87.LnVsop(9.532E-8, 0.35524234217, 1512.8068240082), new Vsop87.LnVsop(9.993E-8, 4.80140922781, 558.0021407459), new Vsop87.LnVsop(7.969E-8, 0.08480602718, 528.9402055692), new Vsop87.LnVsop(7.929E-8, 1.46877435816, 963.4027029714), new Vsop87.LnVsop(8.877E-8, 1.21758319481, 416.3032501375), new Vsop87.LnVsop(8.738E-8, 5.29236760592, 945.2434557067), new Vsop87.LnVsop(8.611E-8, 1.13232641062, 532.6117264014), new Vsop87.LnVsop(7.852E-8, 6.26908468547, 647.0108333148), new Vsop87.LnVsop(7.581E-8, 2.90608705953, 533.8837507886), new Vsop87.LnVsop(8.585E-8, 6.06648047796, 10213.285546211), new Vsop87.LnVsop(1.015E-7, 2.49061363606, 1819.6374661092), new Vsop87.LnVsop(8.534E-8, 2.22687140541, 9153.9036160218), new Vsop87.LnVsop(7.968E-8, 3.75535355212, 530.44172462), new Vsop87.LnVsop(9.742E-8, 6.15792553288, 593.426863398), new Vsop87.LnVsop(7.137E-8, 3.59005542659, 2957.7331481288), new Vsop87.LnVsop(7.176E-8, 0.12508174554, 224.3447957019), new Vsop87.LnVsop(8.727E-8, 0.75644622066, 960.2213092337), new Vsop87.LnVsop(7.073E-8, 2.17418036839, 724.8308132679), new Vsop87.LnVsop(7.193E-8, 2.30068915654, 520.129737539), new Vsop87.LnVsop(6.555E-8, 4.75218205387, 202.2533951741), new Vsop87.LnVsop(6.417E-8, 1.25043809621, 3583.4033404412), new Vsop87.LnVsop(8.27E-8, 1.24822326308, 495.7507151508), new Vsop87.LnVsop(7.123E-8, 3.84780072799, 618.5566453116), new Vsop87.LnVsop(8.145E-8, 0.73137862078, 230.5645708254), new Vsop87.LnVsop(6.151E-8, 5.50130756047, 11.0457002639), new Vsop87.LnVsop(7.972E-8, 2.08176164007, 953.1077622329), new Vsop87.LnVsop(7.652E-8, 0.92748230521, 525.4981794006), new Vsop87.LnVsop(7.432E-8, 0.31435666835, 378.6432952517), new Vsop87.LnVsop(6.222E-8, 1.46220596893, 483.2205421786), new Vsop87.LnVsop(7.153E-8, 0.18772230606, 731.9443602687), new Vsop87.LnVsop(6.706E-8, 2.92078077444, 1038.0412891868), new Vsop87.LnVsop(7.309E-8, 6.27084750121, 21.3406410024), new Vsop87.LnVsop(6.129E-8, 2.68322633435, 312.4597163935), new Vsop87.LnVsop(7.541E-8, 0.73440261131, 457.617679513), new Vsop87.LnVsop(5.558E-8, 3.83419160288, 534.3568315406), new Vsop87.LnVsop(5.343E-8, 5.25360544458, 1048.3362299253), new Vsop87.LnVsop(5.341E-8, 6.22288713664, 551.031606097), new Vsop87.LnVsop(5.613E-8, 1.51210605952, 524.2743391232), new Vsop87.LnVsop(5.478E-8, 5.95887338334, 539.9859058331), new Vsop87.LnVsop(5.216E-8, 2.20381924871, 280.9671470045), new Vsop87.LnVsop(5.056E-8, 0.37387972537, 529.5309064002), new Vsop87.LnVsop(6.202E-8, 5.53800819472, 2.4476805548), new Vsop87.LnVsop(6.261E-8, 0.75330485783, 938.1299087059), new Vsop87.LnVsop(5.419E-8, 5.96993331731, 227.5261894396), new Vsop87.LnVsop(5.71E-8, 2.12868548085, 191.9584544356), new Vsop87.LnVsop(5.218E-8, 4.69335266854, 560.7104537316), new Vsop87.LnVsop(4.84E-8, 1.51601288645, 2524.021410252), new Vsop87.LnVsop(5.738E-8, 0.34249718209, 535.9107402181), new Vsop87.LnVsop(5.056E-8, 3.46671669992, 529.851023789), new Vsop87.LnVsop(5.409E-8, 5.21471277042, 1057.8974574809), new Vsop87.LnVsop(4.734E-8, 2.2773307717, 3370.1042450032), new Vsop87.LnVsop(5.22E-8, 3.61280797725, 2097.423219376), new Vsop87.LnVsop(4.861E-8, 1.38856203056, 3693.6096616606), new Vsop87.LnVsop(5.738E-8, 4.79777823324, 598.8434893694), new Vsop87.LnVsop(5.69E-8, 3.93800591227, 2854.6403739102), new Vsop87.LnVsop(4.988E-8, 4.87228166876, 1.4844727083), new Vsop87.LnVsop(5.424E-8, 3.53268613904, 456.3938392356), new Vsop87.LnVsop(4.289E-8, 4.84380640711, 70.8494453042), new Vsop87.LnVsop(5.944E-8, 3.79180483544, 25558.2121764796), new Vsop87.LnVsop(4.189E-8, 2.08145249041, 2627.1141844706), new Vsop87.LnVsop(4.549E-8, 5.64074512699, 2435.155730035), new Vsop87.LnVsop(4.268E-8, 6.20250525407, 775.233389447), new Vsop87.LnVsop(5.405E-8, 4.66492781581, 833.552661779), new Vsop87.LnVsop(5.607E-8, 3.30270139804, 535.3200393871), new Vsop87.LnVsop(4.171E-8, 3.14858229862, 944.9828232758), new Vsop87.LnVsop(4.128E-8, 5.84804741359, 440.8252848776), new Vsop87.LnVsop(4.387E-8, 4.69677892021, 327.4375699205), new Vsop87.LnVsop(4.468E-8, 0.2134804442, 92.0470739547), new Vsop87.LnVsop(4.052E-8, 3.3136700605, 3274.1250177854), new Vsop87.LnVsop(4.375E-8, 0.20464725158, 3796.7024358792), new Vsop87.LnVsop(4.301E-8, 0.99845168304, 387.2413149608), new Vsop87.LnVsop(4.703E-8, 1.96435195092, 107.0249274817), new Vsop87.LnVsop(4.213E-8, 3.21377867882, 696.5196376166), new Vsop87.LnVsop(4.014E-8, 4.62540459805, 2751.5475996916), new Vsop87.LnVsop(3.824E-8, 3.60290168808, 437.6438911399), new Vsop87.LnVsop(4.183E-8, 4.74495457566, 988.532484885), new Vsop87.LnVsop(3.687E-8, 1.57511269436, 381.6122406683), new Vsop87.LnVsop(3.808E-8, 3.97513732318, 732.6951197941), new Vsop87.LnVsop(4.134E-8, 2.59512563472, 916.9322800554), new Vsop87.LnVsop(4.905E-8, 2.67946228179, 1215.1649024473), new Vsop87.LnVsop(4.34E-8, 1.514325863, 1894.4190646765), new Vsop87.LnVsop(3.49E-8, 0.63097592112, 529.9034134157), new Vsop87.LnVsop(4.179E-8, 4.79066440364, 824.7421937488), new Vsop87.LnVsop(4.126E-8, 3.63856052239, 810.6581120991), new Vsop87.LnVsop(3.701E-8, 6.1767641288, 537.7677199419), new Vsop87.LnVsop(4.355E-8, 3.13180489048, 630.3360587584), new Vsop87.LnVsop(3.315E-8, 1.52493374102, 547.8502123593), new Vsop87.LnVsop(3.49E-8, 3.20962050417, 529.4785167735), new Vsop87.LnVsop(3.555E-8, 6.03691345521, 739.0579072695), new Vsop87.LnVsop(4.099E-8, 6.00401453177, 902.7051860538), new Vsop87.LnVsop(4.004E-8, 2.13540836634, 210.1177017003), new Vsop87.LnVsop(3.295E-8, 2.58083202302, 945.9942152321), new Vsop87.LnVsop(3.27E-8, 3.49304887352, 1166.4068576709), new Vsop87.LnVsop(3.994E-8, 4.78250942681, 850.0149880143), new Vsop87.LnVsop(4.24E-8, 0.11161358607, 1744.8558675419), new Vsop87.LnVsop(4.002E-8, 5.20683965697, 635.231419868), new Vsop87.LnVsop(3.115E-8, 4.61995541904, 952.3570027075), new Vsop87.LnVsop(3.003E-8, 0.92689294845, 3899.7952100978), new Vsop87.LnVsop(3.241E-8, 6.13636496944, 10.2949407385), new Vsop87.LnVsop(3.219E-8, 1.83595567094, 18.1592472647), new Vsop87.LnVsop(2.983E-8, 2.60087913786, 632.831923423), new Vsop87.LnVsop(2.967E-8, 5.69894599757, 632.7355552034), new Vsop87.LnVsop(3.168E-8, 6.13783090971, 1158.5425511447), new Vsop87.LnVsop(3.226E-8, 5.5995770736, 608.404716925), new Vsop87.LnVsop(3.122E-8, 5.6507150217, 99.1606209555), new Vsop87.LnVsop(3.761E-8, 2.09239982789, 282.4516197128), new Vsop87.LnVsop(3.356E-8, 1.79147113193, 521.6142102473), new Vsop87.LnVsop(2.838E-8, 4.60179563689, 245.5424243524), new Vsop87.LnVsop(2.715E-8, 2.03270124891, 1514.2912967165), new Vsop87.LnVsop(2.643E-8, 3.69017270026, 885.4397106664), new Vsop87.LnVsop(3.057E-8, 6.02461785861, 633.7469471597), new Vsop87.LnVsop(3.048E-8, 2.29027670842, 631.8205314667), new Vsop87.LnVsop(2.782E-8, 3.18187038682, 295.0512286542), new Vsop87.LnVsop(3.015E-8, 1.28347490089, 1023.9572075371), new Vsop87.LnVsop(2.632E-8, 0.54069640678, 195.1398481733), new Vsop87.LnVsop(2.559E-8, 0.17635133075, 35.4247226521), new Vsop87.LnVsop(2.714E-8, 3.28872509961, 2413.8150890326), new Vsop87.LnVsop(3.249E-8, 2.40881833627, 836.5216071956), new Vsop87.LnVsop(2.451E-8, 5.5855948111, 544.6688186216), new Vsop87.LnVsop(2.535E-8, 1.44414086617, 460.5384408198), new Vsop87.LnVsop(2.441E-8, 0.23204756934, 465.9550667912), new Vsop87.LnVsop(2.41E-8, 4.36768640011, 1056.9342496344), new Vsop87.LnVsop(2.452E-8, 4.53818807914, 514.7131115676), new Vsop87.LnVsop(3.237E-8, 1.17006919872, 177.8743727859), new Vsop87.LnVsop(2.333E-8, 2.13962165652, 319.5732633943), new Vsop87.LnVsop(3.217E-8, 0.60541914081, 1061.829610744), new Vsop87.LnVsop(2.398E-8, 0.6411023316, 523.5406259403), new Vsop87.LnVsop(2.638E-8, 3.81178618526, 3171.0322435668), new Vsop87.LnVsop(2.791E-8, 2.71505085086, 610.6923387854), new Vsop87.LnVsop(2.729E-8, 1.77752023407, 252.6559713532), new Vsop87.LnVsop(2.681E-8, 0.09370791758, 565.1156877467), new Vsop87.LnVsop(2.209E-8, 0.54839208938, 2228.9701815978), new Vsop87.LnVsop(2.312E-8, 2.07210502831, 3686.4961146598), new Vsop87.LnVsop(2.683E-8, 4.94305916877, 1593.0050485469), new Vsop87.LnVsop(2.526E-8, 1.07528597373, 12036.4607348882), new Vsop87.LnVsop(2.268E-8, 0.36783878457, 1969.2006632438), new Vsop87.LnVsop(2.688E-8, 1.51547910962, 447.7958195265), new Vsop87.LnVsop(2.235E-8, 5.95475282699, 6151.533888305), new Vsop87.LnVsop(2.71E-8, 4.64908513849, 462.0229135281), new Vsop87.LnVsop(2.334E-8, 4.47618012518, 209.3669421749), new Vsop87.LnVsop(2.175E-8, 4.5358857024, 501.3797894433), new Vsop87.LnVsop(2.335E-8, 5.92743690508, 611.4430983108), new Vsop87.LnVsop(2.384E-8, 2.81746623044, 3340.6124266998), new Vsop87.LnVsop(2.075E-8, 3.13164231864, 1049.0869894507), new Vsop87.LnVsop(2.789E-8, 1.27687797437, 1041.2226829245), new Vsop87.LnVsop(2.024E-8, 1.80008813939, 2943.5060541272), new Vsop87.LnVsop(2.039E-8, 4.67544543631, 679.2541622292), new Vsop87.LnVsop(2.748E-8, 1.97292590154, 415.2918581812), new Vsop87.LnVsop(1.993E-8, 2.0250359903, 1058.8606653274), new Vsop87.LnVsop(2.293E-8, 2.99171378261, 69.1525242748), new Vsop87.LnVsop(2.083E-8, 1.11198641001, 4010.0015313172), new Vsop87.LnVsop(2.018E-8, 0.04630518303, 4113.0943055358), new Vsop87.LnVsop(1.93E-8, 3.3450719341, 421.93232443), new Vsop87.LnVsop(2.153E-8, 2.1705951229, 1269.4996318895), new Vsop87.LnVsop(1.928E-8, 1.15367163096, 1060.3451380357), new Vsop87.LnVsop(2.336E-8, 1.9633236097, 1279.794572628), new Vsop87.LnVsop(2.201E-8, 2.94451315794, 429.0458714308), new Vsop87.LnVsop(1.939E-8, 3.22015613937, 3590.516887442), new Vsop87.LnVsop(1.843E-8, 5.23293157757, 14.977853527), new Vsop87.LnVsop(1.93E-8, 5.46749050005, 2281.2304965106), new Vsop87.LnVsop(2.171E-8, 2.83736293048, 292.0128472684), new Vsop87.LnVsop(2.125E-8, 0.06224847813, 24.3790223882), new Vsop87.LnVsop(1.938E-8, 3.79909584528, 1059.430114299), new Vsop87.LnVsop(2.157E-8, 3.89303145878, 451.9404211107), new Vsop87.LnVsop(2.029E-8, 3.95461045826, 771.3012361839), new Vsop87.LnVsop(1.784E-8, 1.49468287576, 529.9515975255), new Vsop87.LnVsop(1.815E-8, 4.780779698, 78.7137518304), new Vsop87.LnVsop(1.748E-8, 3.48730020953, 522.6256022036), new Vsop87.LnVsop(1.759E-8, 0.4134408454, 754.0357607965), new Vsop87.LnVsop(1.816E-8, 1.2433471121, 417.0369633204), new Vsop87.LnVsop(1.942E-8, 1.95782403724, 934.9485149682), new Vsop87.LnVsop(1.809E-8, 3.51500010497, 1354.4331588434), new Vsop87.LnVsop(1.766E-8, 5.76140570543, 623.2225117576), new Vsop87.LnVsop(2.346E-8, 5.3815402845, 1261.6353253633), new Vsop87.LnVsop(2.158E-8, 3.4567274859, 827.9235874865), new Vsop87.LnVsop(1.69E-8, 2.68085848682, 642.3449668688), new Vsop87.LnVsop(1.973E-8, 1.04545877724, 33.9402499438), new Vsop87.LnVsop(1.751E-8, 3.13572498964, 384.0599212231), new Vsop87.LnVsop(1.8E-8, 5.45980392229, 1201.831580323), new Vsop87.LnVsop(1.682E-8, 6.10616525578, 432.0148168474), new Vsop87.LnVsop(1.936E-8, 3.00893936737, 567.8240007324), new Vsop87.LnVsop(2.058E-8, 3.08341203251, 535.8413042489), new Vsop87.LnVsop(1.782E-8, 5.03100165106, 1098.7388061044), new Vsop87.LnVsop(1.826E-8, 2.13081844602, 99.9113804809), new Vsop87.LnVsop(2.075E-8, 3.18662095186, 1366.2125722902), new Vsop87.LnVsop(2.274E-8, 5.1794757806, 3178.1457905676), new Vsop87.LnVsop(1.706E-8, 3.09150223641, 1251.3403846248), new Vsop87.LnVsop(2.242E-8, 1.74102512909, 1151.4290041439), new Vsop87.LnVsop(1.613E-8, 3.16800255751, 67.6680515665), new Vsop87.LnVsop(1.715E-8, 5.04087524117, 586.3133163972), new Vsop87.LnVsop(1.609E-8, 5.65561775211, 1165.6560981455), new Vsop87.LnVsop(1.68E-8, 3.07291090659, 1134.1635287565), new Vsop87.LnVsop(1.994E-8, 2.52023134686, 1059.903195051), new Vsop87.LnVsop(2.154E-8, 6.16996906006, 563.6312150384), new Vsop87.LnVsop(1.703E-8, 0.99422663808, 1254.5217783625), new Vsop87.LnVsop(1.748E-8, 3.47238840628, 1058.4187223427), new Vsop87.LnVsop(1.865E-8, 1.62280773417, 5.4166259714), new Vsop87.LnVsop(1.886E-8, 5.5846984033, 32.2433289144), new Vsop87.LnVsop(1.559E-8, 0.38338275068, 313.2104759189), new Vsop87.LnVsop(1.673E-8, 4.16553276624, 106.2741679563), new Vsop87.LnVsop(1.624E-8, 3.47283697724, 1159.2933106701), new Vsop87.LnVsop(1.552E-8, 3.04262360186, 385.5443939314), new Vsop87.LnVsop(1.728E-8, 2.12791034661, 306.830642101), new Vsop87.LnVsop(1.495E-8, 1.43630114874, 2840.4132799086), new Vsop87.LnVsop(1.511E-8, 4.44377608685, 395.105621487), new Vsop87.LnVsop(1.958E-8, 0.05215107058, 761.7400086283), new Vsop87.LnVsop(1.755E-8, 1.27198192898, 1173.5204046717), new Vsop87.LnVsop(1.548E-8, 0.44749208924, 4216.1870797544), new Vsop87.LnVsop(1.493E-8, 2.79720044893, 277.0349937414), new Vsop87.LnVsop(1.636E-8, 0.2619935149, 522.529233984), new Vsop87.LnVsop(1.569E-8, 2.55719070621, 4.192785694), new Vsop87.LnVsop(1.466E-8, 2.24427810064, 1550.939859646), new Vsop87.LnVsop(1.858E-8, 3.7979722959, 420.9691165835), new Vsop87.LnVsop(1.915E-8, 4.75826139824, 3067.9394693482), new Vsop87.LnVsop(1.684E-8, 2.42057577614, 203.0041546995), new Vsop87.LnVsop(1.784E-8, 2.34591354953, 529.4303326637), new Vsop87.LnVsop(1.938E-8, 0.60127744372, 1059.3337460794), new Vsop87.LnVsop(1.804E-8, 5.16348161105, 1578.0271950199), new Vsop87.LnVsop(1.371E-8, 3.54043412257, 5.6290742925), new Vsop87.LnVsop(1.362E-8, 6.04117291776, 0.9632078465), new Vsop87.LnVsop(1.361E-8, 0.45533257707, 418.5214360287), new Vsop87.LnVsop(1.494E-8, 5.65499635123, 373.0142209592), new Vsop87.LnVsop(1.84E-8, 4.24679354047, 981.6313862053), new Vsop87.LnVsop(1.567E-8, 3.32429870195, 532.3992780803), new Vsop87.LnVsop(1.405E-8, 1.78978994642, 4002.8879843164), new Vsop87.LnVsop(1.34E-8, 1.9466828227, 528.4189407074), new Vsop87.LnVsop(1.745E-8, 5.76913240451, 490.0734567485), new Vsop87.LnVsop(1.472E-8, 2.98912826857, 2730.2069586892), new Vsop87.LnVsop(1.437E-8, 4.19470227783, 420.4478517217), new Vsop87.LnVsop(1.303E-8, 0.66473988441, 173.9422195228), new Vsop87.LnVsop(1.578E-8, 3.90273683089, 602.9880909536), new Vsop87.LnVsop(1.335E-8, 5.58590962636, 1276.6131788903), new Vsop87.LnVsop(1.385E-8, 3.88479835656, 419.4364597654), new Vsop87.LnVsop(1.663E-8, 3.94564005698, 2274.5468326365), new Vsop87.LnVsop(1.351E-8, 0.81710478493, 1585.1407420207), new Vsop87.LnVsop(1.491E-8, 1.66541765776, 2655.5683724738), new Vsop87.LnVsop(1.353E-8, 0.74889817664, 632.2624744514), new Vsop87.LnVsop(1.331E-8, 2.44677888034, 561.1835344836), new Vsop87.LnVsop(1.291E-8, 0.78974363945, 1603.2999892854), new Vsop87.LnVsop(1.659E-8, 5.59776019266, 362.8622925726), new Vsop87.LnVsop(1.513E-8, 4.29754579983, 303.8616966844), new Vsop87.LnVsop(1.227E-8, 4.41715278426, 531.387886124), new Vsop87.LnVsop(1.213E-8, 4.55260634893, 366.7944458357), new Vsop87.LnVsop(1.521E-8, 0.55776043586, 1592.2542890215), new Vsop87.LnVsop(1.22E-8, 3.6302978804, 497.4476361802), new Vsop87.LnVsop(1.333E-8, 1.24847548771, 633.305004175), new Vsop87.LnVsop(1.54E-8, 5.74134360983, 320.3240229197), new Vsop87.LnVsop(1.212E-8, 3.38335836048, 536.8526962052), new Vsop87.LnVsop(1.245E-8, 4.21639502753, 4.665866446), new Vsop87.LnVsop(1.358E-8, 3.42385026423, 539.2521926502), new Vsop87.LnVsop(1.482E-8, 3.06076740133, 1585.8915015461), new Vsop87.LnVsop(1.552E-8, 0.48480014971, 493.0424021651), new Vsop87.LnVsop(1.462E-8, 2.30628702663, 1363.2436268736), new Vsop87.LnVsop(1.18E-8, 3.52707625131, 1064.7985561606), new Vsop87.LnVsop(1.406E-8, 1.53810768058, 1020.025054274), new Vsop87.LnVsop(1.415E-8, 2.27798301933, 758.7710632117), new Vsop87.LnVsop(1.336E-8, 1.8938727238, 530.9629894818), new Vsop87.LnVsop(1.485E-8, 3.55629043627, 774.0095491696), new Vsop87.LnVsop(1.247E-8, 5.64344659992, 479.2883889155), new Vsop87.LnVsop(1.106E-8, 0.89453807282, 2.9207613068), new Vsop87.LnVsop(1.227E-8, 2.76228281324, 299.1263942692), new Vsop87.LnVsop(1.086E-8, 5.66285953861, 1053.7528558967), new Vsop87.LnVsop(1.091E-8, 2.82244505598, 1262.3860848887), new Vsop87.LnVsop(1.168E-8, 3.65910636679, 3487.4241132234), new Vsop87.LnVsop(1.329E-8, 0.1666409453, 536.7563279856), new Vsop87.LnVsop(1.124E-8, 5.88442602775, 1060.8664028975), new Vsop87.LnVsop(1.082E-8, 4.5140735935, 528.2546764961), new Vsop87.LnVsop(1.105E-8, 1.93890691771, 244.318584075), new Vsop87.LnVsop(1.059E-8, 1.55367109732, 536.2832472336), new Vsop87.LnVsop(1.317E-8, 4.06940092395, 799.6124118352), new Vsop87.LnVsop(1.26E-8, 5.75630215326, 527.9940440652), new Vsop87.LnVsop(1.447E-8, 0.65113178433, 1091.6252591036), new Vsop87.LnVsop(1.413E-8, 4.71923061422, 1141.1340634054), new Vsop87.LnVsop(1.082E-8, 5.60975006771, 531.1272536931), new Vsop87.LnVsop(1.148E-8, 3.27410230494, 1035.002907801), new Vsop87.LnVsop(1.048E-8, 4.64334530342, 124.433415221), new Vsop87.LnVsop(1.072E-8, 0.48068438534, 1058.6311706638), new Vsop87.LnVsop(1.045E-8, 4.66144812532, 521.8266585684), new Vsop87.LnVsop(1.036E-8, 1.68979485122, 1070.4276304531), new Vsop87.LnVsop(1.052E-8, 4.72763208314, 913.7508863177), new Vsop87.LnVsop(1.166E-8, 4.97934379883, 450.9772132642), new Vsop87.LnVsop(1.099E-8, 3.13173940863, 1482.7987273275), new Vsop87.LnVsop(1.372E-8, 4.87583487947, 842.9014410135), new Vsop87.LnVsop(1.037E-8, 2.95852835709, 3906.9087570986), new Vsop87.LnVsop(1.154E-8, 3.71720602716, 81.7521332162), new Vsop87.LnVsop(1.013E-8, 0.92736137443, 429.7795846137), new Vsop87.LnVsop(1.085E-8, 3.19275725911, 151.0476698429), new Vsop87.LnVsop(1.03E-8, 0.01725208757, 391.1734682239), new Vsop87.LnVsop(1.282E-8, 4.75859233981, 600.5404103988), new Vsop87.LnVsop(9.72E-9, 0.96985712709, 2332.0629558164), new Vsop87.LnVsop(1.047E-8, 0.99077301795, 337.732510659), new Vsop87.LnVsop(9.8E-9, 3.28594540964, 1379.7059531089), new Vsop87.LnVsop(9.66E-9, 1.6239632216, 3259.8979237838), new Vsop87.LnVsop(1.125E-8, 2.23732263924, 523.0986829556), new Vsop87.LnVsop(9.37E-9, 0.90005698525, 576.1613880106), new Vsop87.LnVsop(1.044E-8, 3.52819283674, 530.5847369719), new Vsop87.LnVsop(1.129E-8, 4.87187369639, 874.3940104025), new Vsop87.LnVsop(1.244E-8, 0.80634178279, 419.532827985), new Vsop87.LnVsop(9.24E-9, 2.3562939198, 1912.5783119412), new Vsop87.LnVsop(1.087E-8, 3.2106582976, 6681.2248533996), new Vsop87.LnVsop(9.2E-9, 3.01896006307, 1372.5924061081), new Vsop87.LnVsop(9.14E-9, 4.34560268499, 1127.0499817557), new Vsop87.LnVsop(9.31E-9, 5.56146061492, 537.5552716208), new Vsop87.LnVsop(9.12E-9, 2.25878214021, 1467.8208738005), new Vsop87.LnVsop(1.202E-8, 1.77363593153, 5120.6011455836), new Vsop87.LnVsop(1.025E-8, 6.08315999637, 469.8872200543), new Vsop87.LnVsop(8.87E-9, 5.53922649066, 498.6714764576), new Vsop87.LnVsop(8.88E-9, 3.38270405256, 812.1425848074), new Vsop87.LnVsop(1.027E-8, 1.64373259126, 1493.093668066), new Vsop87.LnVsop(1.153E-8, 5.20213407672, 554.0699874828), new Vsop87.LnVsop(1.044E-8, 0.31244551729, 528.7971932173), new Vsop87.LnVsop(1.197E-8, 3.12884590029, 1966.2317178272), new Vsop87.LnVsop(9.7E-9, 2.29596237496, 100.6450936638), new Vsop87.LnVsop(9.3E-9, 2.88178471502, 1056.4611688824), new Vsop87.LnVsop(1.052E-8, 1.69484089706, 484.444382456), new Vsop87.LnVsop(8.47E-9, 3.25831322794, 1063.5747158832), new Vsop87.LnVsop(1.137E-8, 4.02029739425, 1670.0742689746), new Vsop87.LnVsop(8.64E-9, 2.69234571372, 31.019488637), new Vsop87.LnVsop(9.06E-9, 6.05494155026, 446.3113468182), new Vsop87.LnVsop(8.6E-9, 4.78175008217, 530.914805372), new Vsop87.LnVsop(9.39E-9, 3.51238251326, 523.4711899711), new Vsop87.LnVsop(8.6E-9, 5.34207357904, 528.4671248172), new Vsop87.LnVsop(8.76E-9, 0.87683423308, 4326.3934009738), new Vsop87.LnVsop(8.19E-9, 3.57201959303, 451.7279727896), new Vsop87.LnVsop(8.24E-9, 0.66291575747, 20426.571092422), new Vsop87.LnVsop(8.49E-9, 3.23256854293, 1670.8250285), new Vsop87.LnVsop(8.2E-9, 5.73661004927, 594.6507036754), new Vsop87.LnVsop(1.116E-8, 1.22881167024, 1489.9122743283), new Vsop87.LnVsop(8.68E-9, 0.80016386644, 2042.4977891028), new Vsop87.LnVsop(8.8E-9, 4.22241993782, 1884.124123938), new Vsop87.LnVsop(8.35E-9, 5.37311812708, 5621.8429232104), new Vsop87.LnVsop(9.74E-9, 3.67667471757, 25565.3257234804), new Vsop87.LnVsop(7.88E-9, 0.51622458293, 526.9826521089), new Vsop87.LnVsop(8.95E-9, 2.77465005384, 3046.5988283458), new Vsop87.LnVsop(8.49E-9, 4.31414424046, 806.725958836), new Vsop87.LnVsop(9.25E-9, 0.5547818495, 627.3671133418), new Vsop87.LnVsop(9.2E-9, 6.26573335293, 700.4517908797), new Vsop87.LnVsop(8.92E-9, 2.67011158629, 946.727928415), new Vsop87.LnVsop(8.46E-9, 5.90640854756, 1087.6931058405), new Vsop87.LnVsop(9.48E-9, 0.77931728039, 25551.09862947879), new Vsop87.LnVsop(8.44E-9, 0.00976249584, 628.5909536192), new Vsop87.LnVsop(7.6E-9, 1.12121829396, 683.1863154923), new Vsop87.LnVsop(8.2E-9, 1.58880252302, 1025.4416802454), new Vsop87.LnVsop(7.81E-9, 1.86416466337, 629.8629780064), new Vsop87.LnVsop(9.67E-9, 3.20618313117, 9050.8108418032), new Vsop87.LnVsop(8.05E-9, 0.08389717815, 4532.578949411), new Vsop87.LnVsop(9.19E-9, 5.60009343497, 498.1983957056), new Vsop87.LnVsop(7.38E-9, 2.6497637213, 1012.9115072732), new Vsop87.LnVsop(7.38E-9, 5.90389531154, 701.936263588), new Vsop87.LnVsop(7.41E-9, 3.06795481071, 5481.7545583808), new Vsop87.LnVsop(7.25E-9, 2.81220410314, 3597.6304344428), new Vsop87.LnVsop(8.78E-9, 1.02427130092, 5760.4984318976), new Vsop87.LnVsop(7.21E-9, 5.29574036514, 1304.9243545416), new Vsop87.LnVsop(9.94E-9, 5.163913701, 10316.3783204296), new Vsop87.LnVsop(8.9E-9, 4.10819809661, 1060.1326897146), new Vsop87.LnVsop(8.3E-9, 0.30961042231, 1123.1178284926), new Vsop87.LnVsop(9.62E-9, 1.48376004518, 1062.302691496), new Vsop87.LnVsop(8.23E-9, 3.22228477513, 121.2520214833), new Vsop87.LnVsop(9.16E-9, 6.02908368648, 7.8643065262), new Vsop87.LnVsop(7.25E-9, 2.1880906586, 1176.7017984094), new Vsop87.LnVsop(8.61E-9, 4.41932623043, 5746.271337896), new Vsop87.LnVsop(8.54E-9, 5.47701506544, 2818.035008606), new Vsop87.LnVsop(7.09E-9, 1.09852456494, 248.7238180901), new Vsop87.LnVsop(8.56E-9, 2.58042139486, 2803.8079146044), new Vsop87.LnVsop(7.34E-9, 0.11633686168, 635.70450062), new Vsop87.LnVsop(7.27E-9, 1.56150632966, 4319.279853973), new Vsop87.LnVsop(6.87E-9, 2.65370734689, 1567.7322542814), new Vsop87.LnVsop(9.38E-9, 0.34938672944, 1140.38330388), new Vsop87.LnVsop(8.32E-9, 5.14362006475, 1054.7160637432), new Vsop87.LnVsop(6.65E-9, 1.87621123047, 103.1409583284), new Vsop87.LnVsop(8.05E-9, 2.65683001547, 63.7358983034), new Vsop87.LnVsop(8.46E-9, 1.47557828604, 898.7730327907), new Vsop87.LnVsop(8.63E-9, 3.98700238575, 686.958410061), new Vsop87.LnVsop(8.06E-9, 4.64475158248, 533.8355666788), new Vsop87.LnVsop(8.6E-9, 1.45053114983, 2199.7652340692), new Vsop87.LnVsop(6.88E-9, 5.6933402695, 525.5463635104), new Vsop87.LnVsop(8.59E-9, 5.32386044216, 1542.6024723678), new Vsop87.LnVsop(6.68E-9, 4.93815253692, 5172.476235725), new Vsop87.LnVsop(8.18E-9, 1.41973280302, 580.0935412737), new Vsop87.LnVsop(6.9E-9, 0.80287056032, 977.4867846211), new Vsop87.LnVsop(6.38E-9, 4.2176024679, 1064.0477966352), new Vsop87.LnVsop(8.78E-9, 2.58779583091, 782.3469364478), new Vsop87.LnVsop(8.11E-9, 1.3040662247, 1055.1891444952), new Vsop87.LnVsop(6.37E-9, 6.13121700151, 4752.9915918498), new Vsop87.LnVsop(8.21E-9, 3.8998191828, 986.0848043302), new Vsop87.LnVsop(6.42E-9, 1.86734510583, 1053.9653042178), new Vsop87.LnVsop(7.81E-9, 1.18377747884, 987.3086446076), new Vsop87.LnVsop(8.04E-9, 1.909391607, 707.5653378805), new Vsop87.LnVsop(6.86E-9, 0.27079898498, 11.7794134468), new Vsop87.LnVsop(6.34E-9, 3.43769853475, 650.9429865779), new Vsop87.LnVsop(6.39E-9, 1.86699974431, 6172.869528772), new Vsop87.LnVsop(6.2E-9, 2.5556159845, 1049.8207026336), new Vsop87.LnVsop(6.97E-9, 4.18082589322, 1.6969210294), new Vsop87.LnVsop(6.86E-9, 2.51807576494, 638.4128136057), new Vsop87.LnVsop(8.49E-9, 5.56317630404, 4429.4861751924), new Vsop87.LnVsop(6.14E-9, 6.19071579609, 738.3241940866), new Vsop87.LnVsop(6.42E-9, 1.70942182986, 5230.807466803), new Vsop87.LnVsop(7.48E-9, 3.63387486593, 73.297125859), new Vsop87.LnVsop(6.15E-9, 5.38518078437, 835.7878940127), new Vsop87.LnVsop(6.01E-9, 0.90129977643, 711.4974911436), new Vsop87.LnVsop(6.04E-9, 5.44066125511, 632.0329797878), new Vsop87.LnVsop(5.97E-9, 3.03921014345, 6.9534883064), new Vsop87.LnVsop(7.67E-9, 4.49491439876, 1457.525933062), new Vsop87.LnVsop(7.78E-9, 3.08728745329, 441.576044403), new Vsop87.LnVsop(5.94E-9, 2.87175682597, 633.5344988386), new Vsop87.LnVsop(5.88E-9, 0.08236113246, 4164.311989613), new Vsop87.LnVsop(5.99E-9, 4.13850666612, 733.428832977), new Vsop87.LnVsop(6.92E-9, 6.10931942233, 12.7426212933), new Vsop87.LnVsop(5.97E-9, 6.13204711801, 7.2736056952), new Vsop87.LnVsop(7.87E-9, 1.98195319336, 860.3099287528), new Vsop87.LnVsop(7.74E-9, 4.8208932866, 951.6232895246), new Vsop87.LnVsop(5.89E-9, 0.30558911648, 153.4953503977), new Vsop87.LnVsop(5.77E-9, 3.84676656235, 767.3690829208), new Vsop87.LnVsop(5.75E-9, 4.50676079721, 1230.1427559743), new Vsop87.LnVsop(7.25E-9, 2.73069387932, 6.1503391543), new Vsop87.LnVsop(5.61E-9, 3.8756591436, 135.336103133), new Vsop87.LnVsop(5.58E-9, 3.36094471852, 24498.8302462904), new Vsop87.LnVsop(6.41E-9, 4.90173124861, 991.7138786227), new Vsop87.LnVsop(5.57E-9, 3.45629457197, 19896.8801273274), new Vsop87.LnVsop(5.58E-9, 1.17103892689, 3576.2897934404), new Vsop87.LnVsop(6.37E-9, 6.08896653583, 46.470422916), new Vsop87.LnVsop(6.31E-9, 5.65855415701, 661.0949149645), new Vsop87.LnVsop(6.28E-9, 2.32902331778, 501.2367770914), new Vsop87.LnVsop(5.6E-9, 3.57141429379, 5333.9002410216), new Vsop87.LnVsop(5.48E-9, 3.03388113862, 7.1617311106), new Vsop87.LnVsop(6.98E-9, 2.0542123076, 3156.8051495652), new Vsop87.LnVsop(7.48E-9, 0.29223355288, 313.9441891018), new Vsop87.LnVsop(7.44E-9, 2.33083237537, 620.253566341), new Vsop87.LnVsop(5.86E-9, 5.68889329019, 1587.5884225755), new Vsop87.LnVsop(5.84E-9, 6.10336975118, 7.065362891), new Vsop87.LnVsop(6.15E-9, 4.72920786161, 3384.3313390048), new Vsop87.LnVsop(5.37E-9, 1.52803865425, 8094.5216858326), new Vsop87.LnVsop(5.95E-9, 1.89655724176, 113.3877149571), new Vsop87.LnVsop(5.42E-9, 3.28894870834, 10103.0792249916), new Vsop87.LnVsop(5.44E-9, 0.69476773349, 4642.7852706304), new Vsop87.LnVsop(5.64E-9, 0.72677136462, 1059.2218714948), new Vsop87.LnVsop(5.46E-9, 0.45425690852, 4694.0029547076), new Vsop87.LnVsop(5.85E-9, 2.82650088707, 344.7030453079), new Vsop87.LnVsop(5.28E-9, 2.32101188937, 949.2237930796), new Vsop87.LnVsop(5.3E-9, 4.99510636441, 9264.1099372412), new Vsop87.LnVsop(5.67E-9, 5.13926871155, 288.0806940053), new Vsop87.LnVsop(5.27E-9, 5.40641191628, 949.12742486), new Vsop87.LnVsop(5.31E-9, 0.16792029802, 1080.7225711916), new Vsop87.LnVsop(5.35E-9, 1.42855602314, 9.5612275556), new Vsop87.LnVsop(6.88E-9, 0.4635318063, 842.1506814881), new Vsop87.LnVsop(6.97E-9, 4.99042365686, 12.5301729722), new Vsop87.LnVsop(5.53E-9, 5.23792586314, 528.0464336919), new Vsop87.LnVsop(5.04E-9, 2.58550284, 5378.6617841622), new Vsop87.LnVsop(5.19E-9, 3.1015709777, 9161.0171630226), new Vsop87.LnVsop(6.19E-9, 3.71554817226, 2090.3096723752), new Vsop87.LnVsop(6.21E-9, 3.98893673383, 409.9234163196), new Vsop87.LnVsop(5.44E-9, 1.05857942311, 1438.0252254409), new Vsop87.LnVsop(5.41E-9, 3.07978704943, 1446.62324515), new Vsop87.LnVsop(4.88E-9, 5.26894402637, 1751.539531416), new Vsop87.LnVsop(6.39E-9, 2.98874052475, 2349.3284312038), new Vsop87.LnVsop(6.84E-9, 2.97458993261, 298.2326223919), new Vsop87.LnVsop(5.55E-9, 3.57205235856, 1144.3154571431), new Vsop87.LnVsop(4.82E-9, 1.84410406707, 1077.5411774539), new Vsop87.LnVsop(4.93E-9, 2.66756696257, 849.2642284889), new Vsop87.LnVsop(5.53E-9, 5.31312350142, 531.3354964973), new Vsop87.LnVsop(6.12E-9, 1.26746376254, 878.3261636656), new Vsop87.LnVsop(5.81E-9, 5.77185453327, 745.4377410874), new Vsop87.LnVsop(5.37E-9, 3.67807254097, 605.9570363702), new Vsop87.LnVsop(4.76E-9, 3.28733354824, 734.9133056853), new Vsop87.LnVsop(4.93E-9, 3.73487080434, 131.4039498699), new Vsop87.LnVsop(4.93E-9, 1.24342391046, 11506.7697697936), new Vsop87.LnVsop(6.13E-9, 3.84144928692, 1065.0110044817), new Vsop87.LnVsop(5.79E-9, 0.02333971761, 1069.6768709277), new Vsop87.LnVsop(6.53E-9, 2.40326963363, 657.1627617014), new Vsop87.LnVsop(5.09E-9, 0.70662672351, 1570.9136480191), new Vsop87.LnVsop(5.64E-9, 3.81960833918, 1059.5419888836), new Vsop87.LnVsop(4.68E-9, 3.50348554992, 4841.8572720668), new Vsop87.LnVsop(6.21E-9, 4.58816416137, 105.5404547734), new Vsop87.LnVsop(5.92E-9, 0.99424149467, 920.8644333185), new Vsop87.LnVsop(4.57E-9, 2.38193571955, 990.2294059144), new Vsop87.LnVsop(4.58E-9, 5.94092303682, 513.2286388593), new Vsop87.LnVsop(4.62E-9, 1.09795189347, 100.1720129118), new Vsop87.LnVsop(4.91E-9, 1.28733237388, 247.2393453818), new Vsop87.LnVsop(4.73E-9, 5.02679239007, 103.0445901088), new Vsop87.LnVsop(5.4E-9, 0.54791737146, 51646.11531805379), new Vsop87.LnVsop(5.31E-9, 0.30026207053, 912.7876784712), new Vsop87.LnVsop(4.88E-9, 5.32348416682, 1432.3961511484), new Vsop87.LnVsop(4.49E-9, 3.02583472996, 5901.239202256), new Vsop87.LnVsop(5.43E-9, 2.98751942458, 4223.3006267552), new Vsop87.LnVsop(6.29E-9, 2.75622390887, 334.5511169213), new Vsop87.LnVsop(4.81E-9, 3.63292807076, 5584.8473325994), new Vsop87.LnVsop(4.44E-9, 4.61008831817, 546.1532913299), new Vsop87.LnVsop(6.22E-9, 2.29597570837, 9999.986450773), new Vsop87.LnVsop(5.88E-9, 5.46780291871, 668.2084619653), new Vsop87.LnVsop(4.85E-9, 0.74674429026, 736.8397213783), new Vsop87.LnVsop(5.95E-9, 3.78181802412, 6386.16862421), new Vsop87.LnVsop(5.67E-9, 0.38348819779, 737.3609862401), new Vsop87.LnVsop(4.74E-9, 3.37296965859, 3803.81598288), new Vsop87.LnVsop(4.34E-9, 2.64411689486, 748.406686504), new Vsop87.LnVsop(6.04E-9, 0.87482329646, 6069.7767545534), new Vsop87.LnVsop(5.2E-9, 2.12596982279, 906.849787638), new Vsop87.LnVsop(5.13E-9, 5.10763567804, 1090.4014188262), new Vsop87.LnVsop(4.59E-9, 4.06923787133, 5216.5803728014), new Vsop87.LnVsop(4.66E-9, 2.29198238542, 2225.7887878601), new Vsop87.LnVsop(5.89E-9, 0.74050145875, 1291.4309737229), new Vsop87.LnVsop(4.66E-9, 2.43707405011, 3362.9906980024), new Vsop87.LnVsop(5.66E-9, 0.59740900184, 350.3321196004), new Vsop87.LnVsop(4.29E-9, 2.46364296538, 3914.0223040994), new Vsop87.LnVsop(4.74E-9, 5.19232279677, 857.1285350151), new Vsop87.LnVsop(4.29E-9, 0.59245436963, 1065.6017053127), new Vsop87.LnVsop(5.11E-9, 2.44662587368, 9690.7081281172), new Vsop87.LnVsop(4.24E-9, 1.67088834417, 148.0787244263), new Vsop87.LnVsop(4.12E-9, 3.29630633921, 7.3259953219), new Vsop87.LnVsop(4.36E-9, 1.40801830895, 995.6460318858), new Vsop87.LnVsop(4.29E-9, 2.13901349243, 3473.1970192218), new Vsop87.LnVsop(5.1E-9, 4.29090556636, 2545.3620512544), new Vsop87.LnVsop(5.01E-9, 5.8416783383, 9676.4810341156), new Vsop87.LnVsop(5.48E-9, 6.03429743373, 9367.2027114598), new Vsop87.LnVsop(4.33E-9, 0.43309624811, 735.828329422), new Vsop87.LnVsop(4.33E-9, 5.9339792666, 1688.2335162393), new Vsop87.LnVsop(4.29E-9, 2.18700390627, 1357.6145525811), new Vsop87.LnVsop(4.39E-9, 0.44871247921, 512.4254897072), new Vsop87.LnVsop(5.55E-9, 1.00328633116, 141.2258098564), new Vsop87.LnVsop(4.41E-9, 3.06678924251, 1475.6851803267), new Vsop87.LnVsop(5.44E-9, 2.22925308079, 1440.9941708575), new Vsop87.LnVsop(4.04E-9, 3.51410520211, 1329.3033769298), new Vsop87.LnVsop(4.12E-9, 5.87495245826, 6.9010986797), new Vsop87.LnVsop(4.42E-9, 5.37772982571, 104.0559820651), new Vsop87.LnVsop(4.65E-9, 1.93436756934, 6275.9623029906), new Vsop87.LnVsop(4.01E-9, 2.90426785776, 1987.2168981566), new Vsop87.LnVsop(4.81E-9, 6.21043578332, 683.9894646444), new Vsop87.LnVsop(3.85E-9, 0.13151986614, 970.5162499722), new Vsop87.LnVsop(3.83E-9, 6.02073818555, 1268.7488723641), new Vsop87.LnVsop(3.91E-9, 2.81753436573, 5798.1464280374), new Vsop87.LnVsop(3.95E-9, 0.22367886581, 51116.4243529592), new Vsop87.LnVsop(4.8E-9, 3.89516556182, 967.3348562345), new Vsop87.LnVsop(4.26E-9, 3.81910977181, 546.956440482), new Vsop87.LnVsop(4.71E-9, 6.24506463249, 946.4672959841), new Vsop87.LnVsop(3.79E-9, 1.14527123185, 1059.5943785103), new Vsop87.LnVsop(3.71E-9, 6.15750793727, 509.2440959695), new Vsop87.LnVsop(4.76E-9, 4.40755251309, 2200.5159935946), new Vsop87.LnVsop(5.11E-9, 5.53118344106, 1128.534454464)};
        private static final Vsop87.LnVsop[] jupiter_radius_r1 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.0127180152, 2.64937512894, 529.6909650946), new Vsop87.LnVsop(6.1661816E-4, 3.00076460387, 1059.3819301892), new Vsop87.LnVsop(5.3443713E-4, 3.89717383175, 522.5774180938), new Vsop87.LnVsop(3.1185171E-4, 4.88276958012, 536.8045120954), new Vsop87.LnVsop(4.1390269E-4, 0.0, 0.0), new Vsop87.LnVsop(1.1847263E-4, 2.41328764459, 419.4846438752), new Vsop87.LnVsop(9.166454E-5, 4.75978553741, 7.1135470008), new Vsop87.LnVsop(3.175595E-5, 2.79298354393, 103.0927742186), new Vsop87.LnVsop(3.203481E-5, 5.21084121495, 735.8765135318), new Vsop87.LnVsop(3.403577E-5, 3.34689633223, 1589.0728952838), new Vsop87.LnVsop(2.599925E-5, 3.63439058628, 206.1855484372), new Vsop87.LnVsop(2.412127E-5, 1.46948314626, 426.598190876), new Vsop87.LnVsop(2.80607E-5, 3.74227009702, 515.463871093), new Vsop87.LnVsop(2.676611E-5, 4.33051702874, 1052.2683831884), new Vsop87.LnVsop(2.100392E-5, 3.92772817188, 639.897286314), new Vsop87.LnVsop(1.64616E-5, 5.30947626153, 1066.49547719), new Vsop87.LnVsop(1.641093E-5, 4.41628521235, 625.6701923124), new Vsop87.LnVsop(1.049766E-5, 3.16115576687, 213.299095438), new Vsop87.LnVsop(1.024703E-5, 2.55437897122, 412.3710968744), new Vsop87.LnVsop(7.40834E-6, 2.17089042827, 1162.4747044078), new Vsop87.LnVsop(8.0643E-6, 2.67747285932, 632.7837393132), new Vsop87.LnVsop(6.76729E-6, 6.2497969066, 838.9692877504), new Vsop87.LnVsop(4.68918E-6, 4.70985711091, 543.9180590962), new Vsop87.LnVsop(4.44628E-6, 0.40306241278, 323.5054166574), new Vsop87.LnVsop(5.67074E-6, 4.57671527249, 742.9900605326), new Vsop87.LnVsop(4.1584E-6, 5.36847472493, 728.762966531), new Vsop87.LnVsop(4.8481E-6, 2.46907968946, 949.1756089698), new Vsop87.LnVsop(3.37576E-6, 3.16751996354, 956.2891559706), new Vsop87.LnVsop(4.01711E-6, 4.60509281258, 309.2783226558), new Vsop87.LnVsop(3.4733E-6, 4.68154619204, 14.2270940016), new Vsop87.LnVsop(2.60727E-6, 5.34286862943, 846.0828347512), new Vsop87.LnVsop(2.2002E-6, 4.84195212656, 1368.660252845), new Vsop87.LnVsop(2.03233E-6, 5.60019394971, 1155.361157407), new Vsop87.LnVsop(2.46438E-6, 3.92373109496, 942.062061969), new Vsop87.LnVsop(1.83575E-6, 4.26454732757, 95.9792272178), new Vsop87.LnVsop(1.97119E-6, 3.70582665656, 2118.7638603784), new Vsop87.LnVsop(1.79982E-6, 4.4021361484, 532.8723588323), new Vsop87.LnVsop(1.95844E-6, 3.75886519686, 199.0720014364), new Vsop87.LnVsop(2.0014E-6, 4.43930806722, 1045.1548361876), new Vsop87.LnVsop(1.70248E-6, 4.84663902529, 526.5095713569), new Vsop87.LnVsop(1.46328E-6, 6.12953407685, 533.6231183577), new Vsop87.LnVsop(1.33441E-6, 1.32112984738, 110.2063212194), new Vsop87.LnVsop(1.3203E-6, 4.5111176854, 525.7588118315), new Vsop87.LnVsop(1.23776E-6, 2.0423359166, 1478.8665740644), new Vsop87.LnVsop(1.21876E-6, 4.40555373903, 1169.5882514086), new Vsop87.LnVsop(1.15354E-6, 4.4675233641, 1581.959348283), new Vsop87.LnVsop(9.8559E-7, 5.72824115387, 1596.1864422846), new Vsop87.LnVsop(9.1744E-7, 4.53147949989, 1685.0521225016), new Vsop87.LnVsop(1.10685E-6, 3.62539004538, 1272.6810256272), new Vsop87.LnVsop(8.0515E-7, 4.11374100758, 1258.4539316256), new Vsop87.LnVsop(7.9518E-7, 2.71923662078, 1692.1656695024), new Vsop87.LnVsop(1.00157E-6, 5.24639992412, 1265.5674786264), new Vsop87.LnVsop(7.7866E-7, 5.56575552496, 1471.7530270636), new Vsop87.LnVsop(8.584E-7, 0.07984103333, 831.8557407496), new Vsop87.LnVsop(8.2132E-7, 3.8076306513, 508.3503240922), new Vsop87.LnVsop(5.5296E-7, 0.35136399335, 316.3918696566), new Vsop87.LnVsop(5.2289E-7, 5.53069765044, 433.7117378768), new Vsop87.LnVsop(5.5809E-7, 4.75224156118, 302.164775655), new Vsop87.LnVsop(5.0625E-7, 4.85603624371, 1375.7737998458), new Vsop87.LnVsop(4.3539E-7, 4.94471526157, 1361.5467058442), new Vsop87.LnVsop(4.2146E-7, 1.22819828957, 853.196381752), new Vsop87.LnVsop(3.7653E-7, 4.26849585975, 2001.4439921582), new Vsop87.LnVsop(4.9301E-7, 4.01704532497, 220.4126424388), new Vsop87.LnVsop(3.8248E-7, 5.33256180883, 1788.1448967202), new Vsop87.LnVsop(3.5653E-7, 1.7630023504, 1795.258443721), new Vsop87.LnVsop(3.6185E-7, 3.85316960087, 1574.8458012822), new Vsop87.LnVsop(2.9178E-7, 5.1681765418, 3.9321532631), new Vsop87.LnVsop(2.5113E-7, 4.3388976689, 519.3960243561), new Vsop87.LnVsop(2.4766E-7, 2.72782261862, 405.2575498736), new Vsop87.LnVsop(2.7102E-7, 6.09843304423, 1148.2476104062), new Vsop87.LnVsop(2.2665E-7, 0.19350039559, 380.12776796), new Vsop87.LnVsop(2.0538E-7, 4.32862762591, 3.1813937377), new Vsop87.LnVsop(1.9941E-7, 4.6343584991, 1677.9385755008), new Vsop87.LnVsop(1.9522E-7, 5.1072829713, 1073.6090241908), new Vsop87.LnVsop(1.85E-7, 3.76514376541, 1485.9801210652), new Vsop87.LnVsop(1.8845E-7, 5.0570337283, 2104.5367663768), new Vsop87.LnVsop(1.6987E-7, 4.02069213446, 2317.8358618148), new Vsop87.LnVsop(1.668E-7, 5.4330287961, 88.865680217), new Vsop87.LnVsop(1.5372E-7, 2.91841323048, 2008.557539159), new Vsop87.LnVsop(1.4419E-7, 3.63960739927, 628.8515860501), new Vsop87.LnVsop(1.463E-7, 5.51305730294, 721.6494195302), new Vsop87.LnVsop(1.854E-7, 6.02594081104, 330.6189636582), new Vsop87.LnVsop(1.3638E-7, 4.88575627207, 629.6023455755), new Vsop87.LnVsop(1.3472E-7, 1.38742780013, 518.6452648307), new Vsop87.LnVsop(1.5538E-7, 2.93208280366, 1905.4647649404), new Vsop87.LnVsop(1.2405E-7, 1.58727793866, 2111.6503133776), new Vsop87.LnVsop(1.2168E-7, 3.37798229468, 635.9651330509), new Vsop87.LnVsop(1.1835E-7, 4.08484570984, 2648.454825473), new Vsop87.LnVsop(1.1259E-7, 4.62303293007, 636.7158925763), new Vsop87.LnVsop(1.4286E-7, 2.74041502983, 2221.856634597), new Vsop87.LnVsop(1.1157E-7, 3.54867395941, 1891.2376709388), new Vsop87.LnVsop(1.3131E-7, 5.83476507713, 1464.6394800628), new Vsop87.LnVsop(1.1346E-7, 2.57830184286, 511.5317178299), new Vsop87.LnVsop(1.0484E-7, 0.49631744855, 453.424893819), new Vsop87.LnVsop(9.712E-8, 4.39039807014, 1994.3304451574), new Vsop87.LnVsop(1.0072E-7, 2.75854126409, 423.4167971383), new Vsop87.LnVsop(8.973E-8, 4.79620568259, 2420.9286360334), new Vsop87.LnVsop(8.487E-8, 5.15862241737, 1056.2005364515), new Vsop87.LnVsop(8.037E-8, 3.72684449392, 2634.2277314714), new Vsop87.LnVsop(8.036E-8, 1.28481352995, 2428.0421830342), new Vsop87.LnVsop(8.823E-8, 1.84296748834, 750.1036075334), new Vsop87.LnVsop(8.976E-8, 4.81284969227, 1062.5633239269), new Vsop87.LnVsop(8.608E-8, 4.53451403086, 21.3406410024), new Vsop87.LnVsop(9.412E-8, 4.34166457358, 1802.3719907218), new Vsop87.LnVsop(6.904E-8, 5.96626034536, 540.7366653585), new Vsop87.LnVsop(7.268E-8, 4.98087083693, 1699.2792165032), new Vsop87.LnVsop(7.068E-8, 4.99227057771, 1055.4497769261), new Vsop87.LnVsop(7.244E-8, 4.97266787687, 1898.3512179396), new Vsop87.LnVsop(6.479E-8, 1.40223433818, 422.6660376129), new Vsop87.LnVsop(6.28E-8, 3.64802738608, 621.7380390493), new Vsop87.LnVsop(6.231E-8, 4.45749513375, 551.031606097), new Vsop87.LnVsop(6.271E-8, 6.13813110445, 2125.8774073792), new Vsop87.LnVsop(6.801E-8, 2.92013819097, 2324.9494088156), new Vsop87.LnVsop(5.898E-8, 2.58873003212, 569.0478410098), new Vsop87.LnVsop(6.481E-8, 4.58107849781, 1038.0412891868), new Vsop87.LnVsop(6.653E-8, 5.54500062883, 1781.0313497194), new Vsop87.LnVsop(7.187E-8, 3.02482572051, 416.3032501375), new Vsop87.LnVsop(5.141E-8, 6.21519498122, 963.4027029714), new Vsop87.LnVsop(5.878E-8, 4.23185657623, 539.9859058331), new Vsop87.LnVsop(5.119E-8, 0.06958852255, 1063.3140834523), new Vsop87.LnVsop(5.247E-8, 0.16792912472, 117.3198682202), new Vsop87.LnVsop(5.423E-8, 4.93524030417, 835.0371344873), new Vsop87.LnVsop(6.217E-8, 3.87980766892, 191.9584544356), new Vsop87.LnVsop(4.967E-8, 1.34452103048, 1382.8873468466), new Vsop87.LnVsop(4.635E-8, 4.63642027299, 643.8294395771), new Vsop87.LnVsop(4.561E-8, 3.37093181163, 2207.6295405954), new Vsop87.LnVsop(4.474E-8, 4.07436890901, 2310.722314814), new Vsop87.LnVsop(4.703E-8, 4.55179426438, 2737.32050569), new Vsop87.LnVsop(4.487E-8, 1.48312334127, 408.4389436113), new Vsop87.LnVsop(4.087E-8, 1.12906821675, 415.5524906121), new Vsop87.LnVsop(5.489E-8, 5.62261637529, 618.5566453116), new Vsop87.LnVsop(4.323E-8, 4.60454457547, 647.0108333148), new Vsop87.LnVsop(3.882E-8, 4.09352825462, 430.5303441391), new Vsop87.LnVsop(3.747E-8, 3.41170997719, 2950.619601128), new Vsop87.LnVsop(3.803E-8, 2.19632996017, 534.3568315406), new Vsop87.LnVsop(3.634E-8, 1.03495466077, 2744.4340526908), new Vsop87.LnVsop(4.549E-8, 4.21325324482, 227.5261894396), new Vsop87.LnVsop(3.565E-8, 4.1124002973, 440.8252848776), new Vsop87.LnVsop(3.852E-8, 1.1493781578, 74.7815985673), new Vsop87.LnVsop(3.525E-8, 4.27662025409, 10.2949407385), new Vsop87.LnVsop(3.488E-8, 5.33792561596, 458.8415197904), new Vsop87.LnVsop(4.208E-8, 2.38049728614, 2538.2485042536), new Vsop87.LnVsop(4.465E-8, 0.18617267547, 824.7421937488), new Vsop87.LnVsop(3.327E-8, 5.51323389248, 739.8086667949), new Vsop87.LnVsop(3.252E-8, 2.68329422796, 561.934294009), new Vsop87.LnVsop(3.247E-8, 4.88392621669, 295.0512286542), new Vsop87.LnVsop(3.571E-8, 4.64017933384, 2214.7430875962), new Vsop87.LnVsop(3.469E-8, 4.3426692436, 305.3461693927), new Vsop87.LnVsop(3.43E-8, 3.34792668508, 149.5631971346), new Vsop87.LnVsop(3.474E-8, 2.75054677372, 2641.3412784722), new Vsop87.LnVsop(3.618E-8, 5.30205670433, 2097.423219376), new Vsop87.LnVsop(2.963E-8, 1.32779700914, 611.4430983108), new Vsop87.LnVsop(2.826E-8, 0.91971516521, 984.6003316219), new Vsop87.LnVsop(3.445E-8, 1.63289286159, 525.0250986486), new Vsop87.LnVsop(2.635E-8, 5.25522783247, 532.1386456494), new Vsop87.LnVsop(2.682E-8, 4.24680441193, 3053.7123753466), new Vsop87.LnVsop(2.655E-8, 3.18365951037, 527.2432845398), new Vsop87.LnVsop(2.418E-8, 4.23791881124, 217.2312487011), new Vsop87.LnVsop(2.231E-8, 4.23923472684, 739.0579072695), new Vsop87.LnVsop(2.268E-8, 5.5224811056, 524.2743391232), new Vsop87.LnVsop(2.095E-8, 4.85943251945, 1049.0869894507), new Vsop87.LnVsop(2.054E-8, 5.38759557118, 142.4496501338), new Vsop87.LnVsop(2.058E-8, 3.79500539044, 2627.1141844706), new Vsop87.LnVsop(2.536E-8, 3.95352520357, 210.1177017003), new Vsop87.LnVsop(2.095E-8, 5.76269812349, 529.6427809848), new Vsop87.LnVsop(2.533E-8, 5.82849252925, 732.6951197941), new Vsop87.LnVsop(2.025E-8, 4.20638434497, 945.9942152321), new Vsop87.LnVsop(2.248E-8, 1.61218306133, 604.4725636619), new Vsop87.LnVsop(1.923E-8, 4.75088270631, 535.107591066), new Vsop87.LnVsop(1.969E-8, 5.49257949498, 1439.5096981492), new Vsop87.LnVsop(1.876E-8, 3.26958300763, 3267.0114707846), new Vsop87.LnVsop(2.286E-8, 2.938608985, 76.2660712756), new Vsop87.LnVsop(2.298E-8, 2.67602302579, 760.25553592), new Vsop87.LnVsop(2.074E-8, 5.85386852879, 532.6117264014), new Vsop87.LnVsop(2.16E-8, 3.89934769002, 2435.155730035), new Vsop87.LnVsop(1.763E-8, 3.1882352481, 2524.021410252), new Vsop87.LnVsop(1.681E-8, 0.78838681637, 3060.8259223474), new Vsop87.LnVsop(2.121E-8, 0.41035912497, 1279.794572628), new Vsop87.LnVsop(1.66E-8, 2.34370903423, 528.7277572481), new Vsop87.LnVsop(1.642E-8, 4.0757994414, 731.9443602687), new Vsop87.LnVsop(2.095E-8, 2.67732367556, 529.7391492044), new Vsop87.LnVsop(1.712E-8, 4.29334392085, 724.8308132679), new Vsop87.LnVsop(1.856E-8, 2.76989081814, 952.3570027075), new Vsop87.LnVsop(1.904E-8, 2.48369702447, 2957.7331481288), new Vsop87.LnVsop(2.003E-8, 5.04729621715, 2413.8150890326), new Vsop87.LnVsop(1.672E-8, 0.28599461931, 454.9093665273), new Vsop87.LnVsop(1.582E-8, 5.84371262844, 547.8502123593), new Vsop87.LnVsop(1.595E-8, 1.18530166527, 38.1330356378), new Vsop87.LnVsop(1.563E-8, 3.02970693113, 945.2434557067), new Vsop87.LnVsop(1.542E-8, 1.12520322838, 1021.2488945514), new Vsop87.LnVsop(1.546E-8, 0.38348247678, 319.5732633943), new Vsop87.LnVsop(1.463E-8, 0.61055082613, 312.4597163935), new Vsop87.LnVsop(1.604E-8, 3.50041190037, 934.9485149682), new Vsop87.LnVsop(1.439E-8, 4.26513521887, 526.7702037878), new Vsop87.LnVsop(1.611E-8, 5.24344469844, 1354.4331588434), new Vsop87.LnVsop(1.511E-8, 5.4959187617, 81.7521332162), new Vsop87.LnVsop(1.906E-8, 3.78137493812, 953.1077622329), new Vsop87.LnVsop(1.656E-8, 6.0966708974, 530.6541729411), new Vsop87.LnVsop(1.799E-8, 5.83566265631, 909.8187330546), new Vsop87.LnVsop(1.405E-8, 4.32629307157, 3178.1457905676), new Vsop87.LnVsop(1.406E-8, 4.05527527402, 1158.5425511447), new Vsop87.LnVsop(1.493E-8, 3.29690433844, 1041.2226829245), new Vsop87.LnVsop(1.558E-8, 1.51646768353, 902.7051860538), new Vsop87.LnVsop(1.387E-8, 2.52840497309, 530.44172462), new Vsop87.LnVsop(1.41E-8, 0.07169032313, 490.3340891794), new Vsop87.LnVsop(1.562E-8, 1.86268966974, 437.6438911399), new Vsop87.LnVsop(1.606E-8, 4.27835003095, 2531.1349572528), new Vsop87.LnVsop(1.794E-8, 6.21722587878, 18.1592472647), new Vsop87.LnVsop(1.422E-8, 3.98206620893, 3370.1042450032), new Vsop87.LnVsop(1.515E-8, 0.17967750365, 1141.1340634054), new Vsop87.LnVsop(1.329E-8, 5.84479773498, 387.2413149608), new Vsop87.LnVsop(1.3E-8, 0.29821177492, 597.3590166611), new Vsop87.LnVsop(1.71E-8, 2.23503932366, 2854.6403739102), new Vsop87.LnVsop(1.558E-8, 6.17783174275, 983.1158589136), new Vsop87.LnVsop(1.311E-8, 3.75085875476, 1165.6560981455), new Vsop87.LnVsop(1.482E-8, 0.83066678204, 529.1697002328), new Vsop87.LnVsop(1.435E-8, 0.23355762296, 860.3099287528), new Vsop87.LnVsop(1.141E-8, 3.46612877999, 483.2205421786), new Vsop87.LnVsop(1.133E-8, 2.81368303631, 124.433415221), new Vsop87.LnVsop(1.319E-8, 4.88148483038, 1251.3403846248), new Vsop87.LnVsop(1.508E-8, 3.48139955389, 2751.5475996916), new Vsop87.LnVsop(1.237E-8, 0.90332265294, 916.9322800554), new Vsop87.LnVsop(1.142E-8, 5.61457234897, 337.732510659), new Vsop87.LnVsop(1.076E-8, 5.4994776987, 1585.8915015461), new Vsop87.LnVsop(1.123E-8, 1.45270581179, 533.8837507886), new Vsop87.LnVsop(1.067E-8, 5.2971093645, 1159.2933106701), new Vsop87.LnVsop(1.063E-8, 3.52724300315, 2943.5060541272), new Vsop87.LnVsop(1.416E-8, 5.18377634152, 1592.2542890215), new Vsop87.LnVsop(1.054E-8, 1.67751055664, 497.4476361802), new Vsop87.LnVsop(1.338E-8, 3.48243389264, 107.0249274817), new Vsop87.LnVsop(1.037E-8, 3.12801094422, 70.8494453042), new Vsop87.LnVsop(1.102E-8, 4.18000348718, 203.0041546995), new Vsop87.LnVsop(1.021E-8, 5.62851625196, 1603.2999892854), new Vsop87.LnVsop(9.67E-9, 2.80222742968, 3583.4033404412), new Vsop87.LnVsop(1.106E-8, 4.86492659899, 1166.4068576709), new Vsop87.LnVsop(1.093E-8, 3.23230823003, 447.7958195265), new Vsop87.LnVsop(1.073E-8, 0.3566864311, 1593.0050485469), new Vsop87.LnVsop(1.108E-8, 2.42061915107, 106.2741679563), new Vsop87.LnVsop(1.003E-8, 3.80070721725, 99.9113804809), new Vsop87.LnVsop(9.87E-9, 2.441849331, 1048.3362299253), new Vsop87.LnVsop(9.21E-9, 0.12955317257, 1070.4276304531), new Vsop87.LnVsop(1.136E-8, 2.2656859095, 525.4981794006), new Vsop87.LnVsop(8.85E-9, 4.25304247204, 114.1384744825), new Vsop87.LnVsop(1.168E-8, 2.68377982079, 209.3669421749), new Vsop87.LnVsop(9.67E-9, 4.47667348232, 9676.4810341156), new Vsop87.LnVsop(8.75E-9, 0.22303452734, 460.5384408198), new Vsop87.LnVsop(1.067E-8, 4.72721946609, 2730.2069586892), new Vsop87.LnVsop(1.165E-8, 1.56030440737, 630.3360587584), new Vsop87.LnVsop(9.51E-9, 0.49347419163, 842.9014410135), new Vsop87.LnVsop(8.84E-9, 4.75139536245, 960.2213092337), new Vsop87.LnVsop(1.158E-8, 5.50047449313, 224.3447957019), new Vsop87.LnVsop(8.92E-9, 2.26616982044, 327.4375699205), new Vsop87.LnVsop(9.4E-9, 0.06481852204, 746.9222137957), new Vsop87.LnVsop(8.99E-9, 1.78944295718, 4.665866446), new Vsop87.LnVsop(8.94E-9, 3.06608347131, 5746.271337896), new Vsop87.LnVsop(9.36E-9, 5.35932787694, 1585.1407420207), new Vsop87.LnVsop(8.66E-9, 1.40863222239, 202.2533951741), new Vsop87.LnVsop(8.65E-9, 2.85348523795, 938.1299087059), new Vsop87.LnVsop(7.82E-9, 0.49776082272, 3377.217792004), new Vsop87.LnVsop(8.22E-9, 4.08331963114, 501.2367770914), new Vsop87.LnVsop(9.33E-9, 0.30976125598, 685.4739373527), new Vsop87.LnVsop(1.033E-8, 2.47031686819, 3274.1250177854), new Vsop87.LnVsop(7.99E-9, 2.08457026425, 77734.01845962799), new Vsop87.LnVsop(1.017E-8, 5.24406833089, 842.1506814881), new Vsop87.LnVsop(7.41E-9, 1.32379374647, 530.2122299564), new Vsop87.LnVsop(8.42E-9, 3.39449778904, 484.444382456), new Vsop87.LnVsop(8.21E-9, 0.48415264993, 850.0149880143), new Vsop87.LnVsop(8.25E-9, 3.48499388498, 498.6714764576), new Vsop87.LnVsop(7.81E-9, 1.03963400654, 373.0142209592), new Vsop87.LnVsop(7.59E-9, 3.82014111206, 6283.0758499914), new Vsop87.LnVsop(9.15E-9, 2.89101498678, 462.0229135281), new Vsop87.LnVsop(7.7E-9, 0.27005681805, 2655.5683724738), new Vsop87.LnVsop(7.07E-9, 5.77702928333, 429.7795846137), new Vsop87.LnVsop(8.62E-9, 5.01184578153, 1567.7322542814), new Vsop87.LnVsop(7.11E-9, 4.82250918143, 11.7794134468), new Vsop87.LnVsop(6.92E-9, 2.63705354662, 6.592282139), new Vsop87.LnVsop(7.71E-9, 3.87410612014, 9690.7081281172), new Vsop87.LnVsop(6.68E-9, 1.79396450309, 775.233389447), new Vsop87.LnVsop(7.4E-9, 3.39423131656, 99.1606209555), new Vsop87.LnVsop(6.63E-9, 5.27704405712, 4532.578949411), new Vsop87.LnVsop(7.59E-9, 5.4535868657, 9683.5945811164), new Vsop87.LnVsop(7.09E-9, 3.71117647887, 3686.4961146598), new Vsop87.LnVsop(6.77E-9, 4.27891183416, 25028.521211385), new Vsop87.LnVsop(7.84E-9, 5.33244311918, 827.9235874865), new Vsop87.LnVsop(6.64E-9, 6.08614002142, 2281.2304965106), new Vsop87.LnVsop(6.43E-9, 1.40239510103, 9161.0171630226), new Vsop87.LnVsop(6.56E-9, 0.60909845504, 835.7878940127), new Vsop87.LnVsop(7.02E-9, 6.10412979847, 4635.6717236296), new Vsop87.LnVsop(8.09E-9, 4.19626489638, 5753.3848848968), new Vsop87.LnVsop(7.0E-9, 4.95131303046, 1670.8250285), new Vsop87.LnVsop(8.38E-9, 4.51443146541, 1069.6768709277), new Vsop87.LnVsop(6.26E-9, 4.38443691624, 5.4166259714), new Vsop87.LnVsop(7.0E-9, 3.78143557545, 2818.035008606), new Vsop87.LnVsop(7.01E-9, 4.28283847329, 2803.8079146044), new Vsop87.LnVsop(7.29E-9, 4.62695452187, 2228.9701815978), new Vsop87.LnVsop(6.04E-9, 3.05855704532, 2840.4132799086), new Vsop87.LnVsop(6.78E-9, 2.45013730979, 5760.4984318976), new Vsop87.LnVsop(6.24E-9, 0.61517599566, 1176.7017984094), new Vsop87.LnVsop(7.17E-9, 1.82600293291, 3171.0322435668), new Vsop87.LnVsop(6.17E-9, 5.74358811142, 1061.829610744), new Vsop87.LnVsop(6.67E-9, 4.22974611158, 4539.6924964118), new Vsop87.LnVsop(7.93E-9, 5.96535561367, 1457.525933062), new Vsop87.LnVsop(5.65E-9, 0.99421817994, 1894.4190646765), new Vsop87.LnVsop(5.78E-9, 2.13199559472, 313.2104759189), new Vsop87.LnVsop(7.52E-9, 0.4606370015, 635.231419868), new Vsop87.LnVsop(6.14E-9, 0.15814341318, 1493.093668066), new Vsop87.LnVsop(6.22E-9, 1.98136818407, 25565.3257234804), new Vsop87.LnVsop(6.14E-9, 2.48275371627, 25551.09862947879), new Vsop87.LnVsop(5.86E-9, 4.17489084697, 2847.5268269094), new Vsop87.LnVsop(5.98E-9, 5.29419256363, 565.1156877467), new Vsop87.LnVsop(6.16E-9, 2.08837621877, 10.0343083076), new Vsop87.LnVsop(6.58E-9, 2.41428707991, 195.1398481733), new Vsop87.LnVsop(6.92E-9, 3.1322902553, 7.6348118626), new Vsop87.LnVsop(5.69E-9, 3.52605667631, 3067.9394693482), new Vsop87.LnVsop(5.25E-9, 3.21922961346, 1098.7388061044), new Vsop87.LnVsop(6.85E-9, 4.18539472904, 46.470422916), new Vsop87.LnVsop(6.24E-9, 2.07173693354, 121.2520214833), new Vsop87.LnVsop(5.25E-9, 1.47517891985, 446.3113468182), new Vsop87.LnVsop(5.08E-9, 2.1358430071, 1.6969210294), new Vsop87.LnVsop(5.04E-9, 5.65511769313, 2332.0629558164), new Vsop87.LnVsop(6.74E-9, 1.47570122611, 4694.0029547076), new Vsop87.LnVsop(5.47E-9, 0.28995741521, 113.3877149571), new Vsop87.LnVsop(6.89E-9, 2.98160755722, 11.0457002639), new Vsop87.LnVsop(5.46E-9, 4.51208004692, 6275.9623029906), new Vsop87.LnVsop(5.61E-9, 1.84479899238, 92.0470739547), new Vsop87.LnVsop(4.92E-9, 4.83275232, 9492.1463150048), new Vsop87.LnVsop(5.49E-9, 4.34579166146, 3046.5988283458), new Vsop87.LnVsop(4.79E-9, 1.70769710474, 3281.2385647862), new Vsop87.LnVsop(5.93E-9, 5.86079640612, 524.0618908021), new Vsop87.LnVsop(5.1E-9, 2.6255703127, 529.851023789), new Vsop87.LnVsop(4.8E-9, 0.30754294369, 528.9402055692), new Vsop87.LnVsop(4.75E-9, 4.16520247375, 1151.4290041439), new Vsop87.LnVsop(5.2E-9, 4.53246652413, 531.1754378029), new Vsop87.LnVsop(5.75E-9, 3.53909947579, 1056.9342496344), new Vsop87.LnVsop(4.76E-9, 5.35229226962, 560.7104537316), new Vsop87.LnVsop(4.7E-9, 4.95335116275, 7.8643065262), new Vsop87.LnVsop(4.7E-9, 6.26977555004, 3693.6096616606), new Vsop87.LnVsop(6.1E-9, 6.20128372098, 1884.124123938), new Vsop87.LnVsop(5.13E-9, 4.1985031637, 1057.8974574809), new Vsop87.LnVsop(5.45E-9, 1.19385752069, 1514.2912967165), new Vsop87.LnVsop(4.61E-9, 0.16951411708, 26087.9031415742), new Vsop87.LnVsop(6.14E-9, 5.42289673768, 2090.3096723752), new Vsop87.LnVsop(4.87E-9, 3.71760211139, 447.9388318784), new Vsop87.LnVsop(5.92E-9, 2.91424148255, 8624.2126509272), new Vsop87.LnVsop(4.49E-9, 5.24967420622, 10213.285546211), new Vsop87.LnVsop(4.25E-9, 2.71416734228, 1064.0477966352), new Vsop87.LnVsop(5.1E-9, 5.81591864532, 529.5309064002), new Vsop87.LnVsop(5.2E-9, 3.25538472195, 600.5404103988), new Vsop87.LnVsop(4.61E-9, 3.87803707104, 2015.6710861598), new Vsop87.LnVsop(4.3E-9, 1.28652623263, 505.3119427064), new Vsop87.LnVsop(4.33E-9, 3.43823137684, 1152.1797636693), new Vsop87.LnVsop(4.22E-9, 5.12631540623, 944.9828232758), new Vsop87.LnVsop(4.1E-9, 1.24248975309, 5069.3834615064), new Vsop87.LnVsop(4.11E-9, 2.95117124177, 4326.3934009738), new Vsop87.LnVsop(4.19E-9, 5.16120679625, 1173.5204046717), new Vsop87.LnVsop(4.12E-9, 2.9812544633, 554.0699874828), new Vsop87.LnVsop(4.72E-9, 0.12243647414, 245.5424243524), new Vsop87.LnVsop(4.02E-9, 5.88796637322, 1570.9136480191), new Vsop87.LnVsop(5.05E-9, 1.49028912471, 3782.4753418776), new Vsop87.LnVsop(4.39E-9, 3.06170334768, 1475.6851803267), new Vsop87.LnVsop(4.26E-9, 3.12237794195, 12566.1516999828), new Vsop87.LnVsop(5.01E-9, 0.09797922397, 1912.5783119412), new Vsop87.LnVsop(4.34E-9, 3.59362426939, 3259.8979237838), new Vsop87.LnVsop(3.98E-9, 4.91510709622, 4120.2078525366), new Vsop87.LnVsop(4.25E-9, 4.74522508051, 1080.7225711916), new Vsop87.LnVsop(4.12E-9, 6.26668629942, 512.2824773553), new Vsop87.LnVsop(3.77E-9, 5.63771534471, 988.532484885), new Vsop87.LnVsop(3.76E-9, 1.04960792457, 6.3627874754), new Vsop87.LnVsop(3.87E-9, 0.82173742289, 2758.6611466924), new Vsop87.LnVsop(3.98E-9, 3.16033099794, 1.4844727083), new Vsop87.LnVsop(3.92E-9, 1.86519119748, 885.4397106664)};
        private static final Vsop87.LnVsop[] jupiter_radius_r2 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(7.9644957E-4, 1.35865949884, 529.6909650946), new Vsop87.LnVsop(8.251645E-5, 5.777744604, 522.5774180938), new Vsop87.LnVsop(7.02994E-5, 3.27477392111, 536.8045120954), new Vsop87.LnVsop(5.314031E-5, 1.83835031247, 1059.3819301892), new Vsop87.LnVsop(1.861184E-5, 2.97686957956, 7.1135470008), new Vsop87.LnVsop(8.36256E-6, 4.19892740368, 419.4846438752), new Vsop87.LnVsop(9.6442E-6, 5.48029587251, 515.463871093), new Vsop87.LnVsop(4.06408E-6, 3.78248932836, 1066.49547719), new Vsop87.LnVsop(4.26544E-6, 2.22743958182, 639.897286314), new Vsop87.LnVsop(3.77334E-6, 2.24232535935, 1589.0728952838), new Vsop87.LnVsop(4.97914E-6, 3.14159265359, 0.0), new Vsop87.LnVsop(3.39124E-6, 6.12690872435, 625.6701923124), new Vsop87.LnVsop(3.62961E-6, 5.36776401268, 206.1855484372), new Vsop87.LnVsop(3.42139E-6, 6.09909325177, 1052.2683831884), new Vsop87.LnVsop(2.7994E-6, 4.26158071104, 412.3710968744), new Vsop87.LnVsop(3.32558E-6, 0.00332561805, 426.598190876), new Vsop87.LnVsop(2.29775E-6, 0.70510840437, 735.8765135318), new Vsop87.LnVsop(2.00884E-6, 3.06805028347, 543.9180590962), new Vsop87.LnVsop(1.9966E-6, 4.42869041267, 103.0927742186), new Vsop87.LnVsop(2.57306E-6, 0.962674825, 632.7837393132), new Vsop87.LnVsop(1.38577E-6, 2.93153004432, 14.2270940016), new Vsop87.LnVsop(1.1338E-6, 0.78831018317, 728.762966531), new Vsop87.LnVsop(8.5848E-7, 5.14257631438, 323.5054166574), new Vsop87.LnVsop(9.4695E-7, 1.70378030966, 838.9692877504), new Vsop87.LnVsop(8.3674E-7, 0.05892269245, 309.2783226558), new Vsop87.LnVsop(7.5194E-7, 1.60633621497, 956.2891559706), new Vsop87.LnVsop(7.0197E-7, 1.50916343132, 213.299095438), new Vsop87.LnVsop(8.0209E-7, 2.98293613006, 742.9900605326), new Vsop87.LnVsop(5.6365E-7, 0.95014515126, 1162.4747044078), new Vsop87.LnVsop(6.1758E-7, 6.10246926546, 1045.1548361876), new Vsop87.LnVsop(6.6425E-7, 5.47411271821, 199.0720014364), new Vsop87.LnVsop(5.0128E-7, 2.72034786035, 532.8723588323), new Vsop87.LnVsop(5.1793E-7, 5.58477632168, 942.062061969), new Vsop87.LnVsop(3.9925E-7, 5.94843040319, 95.9792272178), new Vsop87.LnVsop(4.4584E-7, 5.52437023269, 508.3503240922), new Vsop87.LnVsop(4.4215E-7, 0.26965913924, 526.5095713569), new Vsop87.LnVsop(3.013E-7, 0.93896301926, 1155.361157407), new Vsop87.LnVsop(2.8433E-7, 2.87743261296, 525.7588118315), new Vsop87.LnVsop(2.6377E-7, 4.26907277677, 1596.1864422846), new Vsop87.LnVsop(2.7064E-7, 2.80927398799, 1169.5882514086), new Vsop87.LnVsop(2.7531E-7, 2.64852579481, 2118.7638603784), new Vsop87.LnVsop(2.2695E-7, 0.18097965354, 302.164775655), new Vsop87.LnVsop(2.9439E-7, 1.78672212056, 831.8557407496), new Vsop87.LnVsop(2.0007E-7, 0.03856532918, 949.1756089698), new Vsop87.LnVsop(1.9915E-7, 1.1579233154, 533.6231183577), new Vsop87.LnVsop(2.1698E-7, 1.8898695033, 1272.6810256272), new Vsop87.LnVsop(1.7678E-7, 4.14815218724, 846.0828347512), new Vsop87.LnVsop(1.7064E-7, 5.88794387217, 1258.4539316256), new Vsop87.LnVsop(2.1474E-7, 4.34579246643, 316.3918696566), new Vsop87.LnVsop(2.1174E-7, 0.54776446005, 1265.5674786264), new Vsop87.LnVsop(1.9878E-7, 0.06616288602, 1581.959348283), new Vsop87.LnVsop(1.7028E-7, 0.53404092917, 1368.660252845), new Vsop87.LnVsop(1.2874E-7, 3.89924775426, 433.7117378768), new Vsop87.LnVsop(1.2887E-7, 0.81112211137, 110.2063212194), new Vsop87.LnVsop(1.1716E-7, 0.40420153376, 1361.5467058442), new Vsop87.LnVsop(1.1655E-7, 4.43864372476, 405.2575498736), new Vsop87.LnVsop(1.2042E-7, 2.22601252935, 220.4126424388), new Vsop87.LnVsop(9.62E-8, 6.01003863537, 853.196381752), new Vsop87.LnVsop(1.0252E-7, 0.99356542172, 1471.7530270636), new Vsop87.LnVsop(9.102E-8, 1.61635845262, 1692.1656695024), new Vsop87.LnVsop(8.722E-8, 3.51382233353, 1073.6090241908), new Vsop87.LnVsop(8.283E-8, 5.61696036887, 1574.8458012822), new Vsop87.LnVsop(8.917E-8, 6.26263765188, 519.3960243561), new Vsop87.LnVsop(7.962E-8, 0.6424558275, 1478.8665740644), new Vsop87.LnVsop(7.722E-8, 0.17138136003, 1685.0521225016), new Vsop87.LnVsop(7.445E-8, 0.9053742871, 88.865680217), new Vsop87.LnVsop(7.337E-8, 0.8899628257, 721.6494195302), new Vsop87.LnVsop(9.118E-8, 1.51639567636, 1148.2476104062), new Vsop87.LnVsop(6.139E-8, 2.49651421842, 3.1813937377), new Vsop87.LnVsop(7.001E-8, 4.44209624915, 330.6189636582), new Vsop87.LnVsop(5.235E-8, 2.79243270986, 21.3406410024), new Vsop87.LnVsop(5.041E-8, 2.97840393432, 1375.7737998458), new Vsop87.LnVsop(4.937E-8, 0.04442899397, 1677.9385755008), new Vsop87.LnVsop(4.633E-8, 2.26661974645, 1485.9801210652), new Vsop87.LnVsop(4.667E-8, 0.84935842035, 3.9321532631), new Vsop87.LnVsop(5.341E-8, 0.86294969395, 1788.1448967202), new Vsop87.LnVsop(4.248E-8, 0.41663016954, 629.6023455755), new Vsop87.LnVsop(4.187E-8, 1.6219871556, 635.9651330509), new Vsop87.LnVsop(3.629E-8, 2.71174024514, 551.031606097), new Vsop87.LnVsop(4.453E-8, 1.27731121245, 1464.6394800628), new Vsop87.LnVsop(3.266E-8, 0.54602174256, 1795.258443721), new Vsop87.LnVsop(3.409E-8, 1.20638860556, 1905.4647649404), new Vsop87.LnVsop(3.164E-8, 6.20189662302, 1038.0412891868), new Vsop87.LnVsop(3.096E-8, 6.21099164255, 2001.4439921582), new Vsop87.LnVsop(3.404E-8, 2.44670518809, 539.9859058331), new Vsop87.LnVsop(3.168E-8, 5.58075929197, 191.9584544356), new Vsop87.LnVsop(2.201E-8, 5.33344494715, 1891.2376709388), new Vsop87.LnVsop(2.553E-8, 3.20949626593, 1062.5633239269), new Vsop87.LnVsop(2.386E-8, 4.29199230828, 963.4027029714), new Vsop87.LnVsop(2.597E-8, 0.57986674442, 2104.5367663768), new Vsop87.LnVsop(2.547E-8, 0.14627545776, 750.1036075334), new Vsop87.LnVsop(2.609E-8, 4.82665360488, 416.3032501375), new Vsop87.LnVsop(2.187E-8, 1.71707514653, 628.8515860501), new Vsop87.LnVsop(2.258E-8, 6.17429279705, 1994.3304451574), new Vsop87.LnVsop(2.624E-8, 2.36922205485, 227.5261894396), new Vsop87.LnVsop(2.097E-8, 3.31460321409, 1699.2792165032), new Vsop87.LnVsop(2.027E-8, 3.15533834136, 611.4430983108), new Vsop87.LnVsop(2.081E-8, 0.31057710726, 2111.6503133776), new Vsop87.LnVsop(2.484E-8, 0.04731413707, 1898.3512179396), new Vsop87.LnVsop(1.963E-8, 0.29583638556, 636.7158925763), new Vsop87.LnVsop(2.279E-8, 1.96058124545, 824.7421937488), new Vsop87.LnVsop(1.829E-8, 4.69907372627, 2125.8774073792), new Vsop87.LnVsop(1.829E-8, 0.33004933298, 295.0512286542), new Vsop87.LnVsop(2.553E-8, 1.24739305569, 2221.856634597), new Vsop87.LnVsop(1.785E-8, 3.5100927402, 647.0108333148), new Vsop87.LnVsop(1.786E-8, 3.46994340828, 1055.4497769261), new Vsop87.LnVsop(1.742E-8, 2.43853510157, 10.2949407385), new Vsop87.LnVsop(1.85E-8, 1.60578508516, 2008.557539159), new Vsop87.LnVsop(1.971E-8, 1.15435477931, 618.5566453116), new Vsop87.LnVsop(1.611E-8, 5.83466560322, 422.6660376129), new Vsop87.LnVsop(1.639E-8, 0.45469643466, 1056.2005364515), new Vsop87.LnVsop(1.628E-8, 5.86754764931, 2317.8358618148), new Vsop87.LnVsop(2.099E-8, 1.05944599014, 1781.0313497194), new Vsop87.LnVsop(1.57E-8, 2.39516560987, 440.8252848776), new Vsop87.LnVsop(1.999E-8, 4.62828691526, 423.4167971383), new Vsop87.LnVsop(1.48E-8, 0.02394813605, 1382.8873468466), new Vsop87.LnVsop(1.502E-8, 5.74598263477, 117.3198682202), new Vsop87.LnVsop(1.881E-8, 2.76425929784, 1802.3719907218), new Vsop87.LnVsop(1.983E-8, 2.99080832362, 2648.454825473), new Vsop87.LnVsop(1.402E-8, 0.15904673895, 2420.9286360334), new Vsop87.LnVsop(1.174E-8, 1.55354182426, 380.12776796), new Vsop87.LnVsop(1.321E-8, 1.26221998203, 1063.3140834523), new Vsop87.LnVsop(1.15E-8, 4.12219328847, 547.8502123593), new Vsop87.LnVsop(1.08E-8, 4.41192013439, 934.9485149682), new Vsop87.LnVsop(1.138E-8, 5.93242605811, 2310.722314814), new Vsop87.LnVsop(1.033E-8, 5.63854408052, 99.9113804809), new Vsop87.LnVsop(9.49E-9, 6.07298626146, 511.5317178299), new Vsop87.LnVsop(1.012E-8, 3.80744305824, 1603.2999892854), new Vsop87.LnVsop(9.22E-9, 6.16494528393, 945.9942152321), new Vsop87.LnVsop(9.15E-9, 5.22425774632, 2207.6295405954), new Vsop87.LnVsop(8.6E-9, 2.48740591818, 6283.0758499914), new Vsop87.LnVsop(8.36E-9, 1.08651799806, 81.7521332162), new Vsop87.LnVsop(1.165E-8, 0.72510519647, 2097.423219376), new Vsop87.LnVsop(8.51E-9, 4.69371733745, 5746.271337896), new Vsop87.LnVsop(7.89E-9, 3.91035208173, 10213.285546211), new Vsop87.LnVsop(8.46E-9, 0.77030801324, 5760.4984318976), new Vsop87.LnVsop(9.24E-9, 1.4342324986, 732.6951197941), new Vsop87.LnVsop(8.05E-9, 6.11630827296, 9676.4810341156), new Vsop87.LnVsop(8.0E-9, 2.1928953416, 9690.7081281172), new Vsop87.LnVsop(8.12E-9, 5.00490295474, 319.5732633943), new Vsop87.LnVsop(8.41E-9, 1.22483116811, 952.3570027075), new Vsop87.LnVsop(7.2E-9, 3.95975713584, 337.732510659), new Vsop87.LnVsop(7.11E-9, 1.23970970528, 106.2741679563), new Vsop87.LnVsop(8.89E-9, 0.10251260092, 2737.32050569), new Vsop87.LnVsop(8.58E-9, 1.51763095265, 2324.9494088156), new Vsop87.LnVsop(8.68E-9, 2.67598866406, 3370.1042450032), new Vsop87.LnVsop(7.1E-9, 0.65180853077, 2538.2485042536), new Vsop87.LnVsop(7.43E-9, 0.60536479474, 1354.4331588434), new Vsop87.LnVsop(6.33E-9, 1.37719198152, 124.433415221), new Vsop87.LnVsop(8.66E-9, 3.02831268213, 3046.5988283458), new Vsop87.LnVsop(7.33E-9, 5.84583969196, 2634.2277314714), new Vsop87.LnVsop(6.91E-9, 1.14062641255, 2641.3412784722), new Vsop87.LnVsop(5.93E-9, 1.80277592426, 453.424893819), new Vsop87.LnVsop(6.6E-9, 6.01207640959, 1049.0869894507), new Vsop87.LnVsop(7.71E-9, 6.01059588645, 2214.7430875962), new Vsop87.LnVsop(5.86E-9, 5.6814901946, 107.0249274817), new Vsop87.LnVsop(6.39E-9, 4.77149952374, 860.3099287528), new Vsop87.LnVsop(7.82E-9, 2.52401202862, 3679.382567659), new Vsop87.LnVsop(6.31E-9, 2.27765412816, 2015.6710861598), new Vsop87.LnVsop(7.79E-9, 2.38608991574, 3267.0114707846), new Vsop87.LnVsop(5.84E-9, 3.00542907219, 1262.3860848887), new Vsop87.LnVsop(5.43E-9, 3.09924086245, 3281.2385647862), new Vsop87.LnVsop(5.35E-9, 2.42171003067, 739.0579072695), new Vsop87.LnVsop(6.81E-9, 1.18831331541, 739.8086667949), new Vsop87.LnVsop(6.21E-9, 1.2446288744, 3803.81598288), new Vsop87.LnVsop(7.17E-9, 4.14222389339, 9683.5945811164), new Vsop87.LnVsop(5.46E-9, 3.43095520503, 18.1592472647), new Vsop87.LnVsop(5.45E-9, 5.65426574985, 2627.1141844706), new Vsop87.LnVsop(5.38E-9, 4.92334194042, 447.7958195265), new Vsop87.LnVsop(5.34E-9, 0.99911551571, 462.0229135281), new Vsop87.LnVsop(5.41E-9, 6.19275150397, 1987.2168981566), new Vsop87.LnVsop(5.11E-9, 3.2855327837, 4.665866446), new Vsop87.LnVsop(5.37E-9, 5.33205206604, 2751.5475996916), new Vsop87.LnVsop(6.51E-9, 5.12199308959, 3156.8051495652), new Vsop87.LnVsop(5.1E-9, 5.35664230912, 9.5612275556), new Vsop87.LnVsop(5.44E-9, 1.81488805078, 1251.3403846248), new Vsop87.LnVsop(4.26E-9, 2.10841334313, 149.5631971346), new Vsop87.LnVsop(5.16E-9, 3.89424540015, 2516.9078632512), new Vsop87.LnVsop(5.43E-9, 5.56620814561, 2524.021410252), new Vsop87.LnVsop(5.19E-9, 2.43126348834, 3686.4961146598), new Vsop87.LnVsop(4.04E-9, 2.77840802846, 7.1617311106), new Vsop87.LnVsop(5.33E-9, 4.77083438961, 3473.1970192218), new Vsop87.LnVsop(3.86E-9, 6.06244501785, 203.0041546995), new Vsop87.LnVsop(4.82E-9, 0.38718011166, 2428.0421830342), new Vsop87.LnVsop(4.34E-9, 5.36713537673, 2531.1349572528), new Vsop87.LnVsop(3.7E-9, 6.04174787347, 1670.8250285)};
        private static final Vsop87.LnVsop[] jupiter_radius_r3 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(3.519277E-5, 6.05800355513, 529.6909650946), new Vsop87.LnVsop(1.073281E-5, 1.67319166156, 536.8045120954), new Vsop87.LnVsop(9.1563E-6, 1.41326157617, 522.5774180938), new Vsop87.LnVsop(3.41654E-6, 0.52294532787, 1059.3819301892), new Vsop87.LnVsop(2.54881E-6, 1.19631092831, 7.1135470008), new Vsop87.LnVsop(2.21477E-6, 0.95234304351, 515.463871093), new Vsop87.LnVsop(6.902E-7, 2.26889455907, 1066.49547719), new Vsop87.LnVsop(8.9777E-7, 3.14159265359, 0.0), new Vsop87.LnVsop(5.7885E-7, 1.41227055539, 543.9180590962), new Vsop87.LnVsop(5.77E-7, 0.52564805704, 639.897286314), new Vsop87.LnVsop(5.1213E-7, 5.97994255422, 412.3710968744), new Vsop87.LnVsop(4.6968E-7, 1.57861666908, 625.6701923124), new Vsop87.LnVsop(4.2744E-7, 6.11814173992, 419.4846438752), new Vsop87.LnVsop(3.7444E-7, 1.18048940249, 14.2270940016), new Vsop87.LnVsop(3.3816E-7, 1.66573652907, 1052.2683831884), new Vsop87.LnVsop(3.1166E-7, 1.0446807262, 1589.0728952838), new Vsop87.LnVsop(2.9943E-7, 4.63498871771, 426.598190876), new Vsop87.LnVsop(3.3558E-7, 0.8485387917, 206.1855484372), new Vsop87.LnVsop(2.0709E-7, 2.50340319894, 728.762966531), new Vsop87.LnVsop(1.447E-7, 0.96111460506, 508.3503240922), new Vsop87.LnVsop(1.2974E-7, 1.50391478213, 1045.1548361876), new Vsop87.LnVsop(1.1596E-7, 3.55299164531, 323.5054166574), new Vsop87.LnVsop(1.2357E-7, 2.6079739865, 735.8765135318), new Vsop87.LnVsop(1.5065E-7, 0.8796121409, 199.0720014364), new Vsop87.LnVsop(1.1062E-7, 1.78854133467, 309.2783226558), new Vsop87.LnVsop(1.0576E-7, 0.00265970762, 956.2891559706), new Vsop87.LnVsop(9.798E-8, 6.24533081819, 103.0927742186), new Vsop87.LnVsop(6.725E-8, 1.86312777034, 302.164775655), new Vsop87.LnVsop(9.133E-8, 3.46071465629, 838.9692877504), new Vsop87.LnVsop(7.338E-8, 1.28438797074, 742.9900605326), new Vsop87.LnVsop(7.182E-8, 0.91717952341, 942.062061969), new Vsop87.LnVsop(5.482E-8, 1.35541254124, 95.9792272178), new Vsop87.LnVsop(6.754E-8, 3.45186268696, 831.8557407496), new Vsop87.LnVsop(4.626E-8, 2.83572146596, 1596.1864422846), new Vsop87.LnVsop(4.106E-8, 6.01730779864, 213.299095438), new Vsop87.LnVsop(3.942E-8, 1.19384143223, 1169.5882514086), new Vsop87.LnVsop(3.469E-8, 6.10664206989, 405.2575498736), new Vsop87.LnVsop(2.861E-8, 2.32367020387, 1155.361157407), new Vsop87.LnVsop(2.519E-8, 0.42500820125, 220.4126424388), new Vsop87.LnVsop(2.468E-8, 1.84219414782, 532.8723588323), new Vsop87.LnVsop(2.322E-8, 1.57653167974, 2118.7638603784), new Vsop87.LnVsop(2.283E-8, 0.13415259559, 632.7837393132), new Vsop87.LnVsop(2.243E-8, 1.9175122913, 1073.6090241908), new Vsop87.LnVsop(2.285E-8, 5.94194291108, 1162.4747044078), new Vsop87.LnVsop(2.137E-8, 1.06953434212, 21.3406410024), new Vsop87.LnVsop(2.515E-8, 0.33520672477, 1272.6810256272), new Vsop87.LnVsop(2.042E-8, 5.9277991653, 110.2063212194), new Vsop87.LnVsop(1.927E-8, 2.58542297225, 88.865680217), new Vsop87.LnVsop(2.021E-8, 2.2176111383, 433.7117378768), new Vsop87.LnVsop(1.943E-8, 1.46376661665, 1258.4539316256), new Vsop87.LnVsop(1.7E-8, 1.88459425041, 525.7588118315), new Vsop87.LnVsop(1.815E-8, 2.6762655865, 330.6189636582), new Vsop87.LnVsop(1.821E-8, 2.75572507789, 721.6494195302), new Vsop87.LnVsop(2.068E-8, 3.17049523925, 1148.2476104062), new Vsop87.LnVsop(1.866E-8, 2.28678298902, 1361.5467058442), new Vsop87.LnVsop(1.526E-8, 4.47646904898, 853.196381752), new Vsop87.LnVsop(1.508E-8, 0.11633951449, 949.1756089698), new Vsop87.LnVsop(1.655E-8, 0.44340210808, 533.6231183577), new Vsop87.LnVsop(1.572E-8, 0.45863923926, 526.5095713569), new Vsop87.LnVsop(1.161E-8, 3.10471097791, 963.4027029714), new Vsop87.LnVsop(1.162E-8, 1.19270352887, 1574.8458012822), new Vsop87.LnVsop(1.14E-8, 2.4632410666, 846.0828347512), new Vsop87.LnVsop(1.259E-8, 1.24988357144, 1038.0412891868), new Vsop87.LnVsop(1.396E-8, 0.69581007586, 551.031606097), new Vsop87.LnVsop(1.182E-8, 1.93125671013, 1581.959348283), new Vsop87.LnVsop(8.94E-9, 2.85762385272, 519.3960243561), new Vsop87.LnVsop(9.83E-9, 4.17198081351, 2627.1141844706), new Vsop87.LnVsop(1.061E-8, 0.66716890315, 539.9859058331), new Vsop87.LnVsop(8.59E-9, 4.91931457958, 611.4430983108), new Vsop87.LnVsop(9.18E-9, 4.89690742057, 1670.8250285), new Vsop87.LnVsop(8.66E-9, 3.00153408458, 1368.660252845), new Vsop87.LnVsop(1.115E-8, 0.97017156126, 227.5261894396), new Vsop87.LnVsop(8.87E-9, 3.68665606145, 824.7421937488), new Vsop87.LnVsop(7.37E-9, 3.20041743453, 2125.8774073792), new Vsop87.LnVsop(7.3E-9, 2.32845485663, 2317.8358618148), new Vsop87.LnVsop(8.28E-9, 1.01037712742, 191.9584544356), new Vsop87.LnVsop(7.78E-9, 0.25303611679, 1141.1340634054), new Vsop87.LnVsop(7.57E-9, 2.24232615954, 2538.2485042536), new Vsop87.LnVsop(7.2E-9, 0.55787809007, 440.8252848776), new Vsop87.LnVsop(6.72E-9, 4.17028096565, 1692.1656695024), new Vsop87.LnVsop(6.91E-9, 5.78026436421, 1485.9801210652), new Vsop87.LnVsop(6.11E-9, 2.66934999696, 1265.5674786264), new Vsop87.LnVsop(5.92E-9, 2.26781665598, 1471.7530270636), new Vsop87.LnVsop(5.61E-9, 6.11300561068, 1279.794572628), new Vsop87.LnVsop(5.66E-9, 1.93294355027, 2634.2277314714), new Vsop87.LnVsop(5.45E-9, 2.21244108948, 1062.5633239269), new Vsop87.LnVsop(6.4E-9, 2.47352731748, 1699.2792165032), new Vsop87.LnVsop(6.94E-9, 4.71564977334, 750.1036075334), new Vsop87.LnVsop(6.04E-9, 1.97421641416, 1677.9385755008), new Vsop87.LnVsop(5.01E-9, 2.45269887786, 81.7521332162), new Vsop87.LnVsop(5.52E-9, 4.37775459043, 1382.8873468466), new Vsop87.LnVsop(5.56E-9, 5.31872445991, 2413.8150890326), new Vsop87.LnVsop(5.89E-9, 0.19759573714, 10.2949407385), new Vsop87.LnVsop(4.97E-9, 2.52744546318, 2207.6295405954), new Vsop87.LnVsop(4.16E-9, 6.19072120624, 934.9485149682), new Vsop87.LnVsop(4.33E-9, 5.80559659477, 1478.8665740644), new Vsop87.LnVsop(3.95E-9, 2.34556406839, 295.0512286542)};
        private static final Vsop87.LnVsop[] jupiter_radius_r4 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.28623E-6, 0.08347608895, 536.8045120954), new Vsop87.LnVsop(1.13458E-6, 4.2481893818, 529.6909650946), new Vsop87.LnVsop(8.2704E-7, 3.29801136583, 522.5774180938), new Vsop87.LnVsop(3.7897E-7, 2.7340266556, 515.463871093), new Vsop87.LnVsop(2.6713E-7, 5.68996992467, 7.1135470008), new Vsop87.LnVsop(1.7808E-7, 5.40366594364, 1059.3819301892), new Vsop87.LnVsop(1.2564E-7, 6.00543529469, 543.9180590962), new Vsop87.LnVsop(9.272E-8, 0.75619260404, 1066.49547719), new Vsop87.LnVsop(8.141E-8, 5.68230705037, 14.2270940016), new Vsop87.LnVsop(6.174E-8, 5.10190413726, 639.897286314), new Vsop87.LnVsop(6.92E-8, 1.42214334807, 412.3710968744), new Vsop87.LnVsop(5.327E-8, 3.33829390777, 625.6701923124), new Vsop87.LnVsop(2.895E-8, 3.38407751603, 1052.2683831884), new Vsop87.LnVsop(2.696E-8, 4.18310762577, 728.762966531), new Vsop87.LnVsop(2.435E-8, 2.96139551556, 426.598190876), new Vsop87.LnVsop(2.176E-8, 6.21232313303, 1589.0728952838), new Vsop87.LnVsop(2.008E-8, 3.13891134942, 1045.1548361876), new Vsop87.LnVsop(1.817E-8, 2.74670205576, 206.1855484372), new Vsop87.LnVsop(1.883E-8, 1.87835568033, 419.4846438752), new Vsop87.LnVsop(1.501E-8, 1.26929907808, 1596.1864422846), new Vsop87.LnVsop(1.701E-8, 2.5890147944, 199.0720014364), new Vsop87.LnVsop(1.689E-8, 0.0, 0.0), new Vsop87.LnVsop(1.148E-8, 5.18914327333, 831.8557407496), new Vsop87.LnVsop(1.033E-8, 5.3570223871, 220.4126424388), new Vsop87.LnVsop(8.74E-9, 5.79483644819, 1169.5882514086), new Vsop87.LnVsop(8.54E-9, 4.55476058022, 956.2891559706), new Vsop87.LnVsop(9.13E-9, 1.89622509837, 1148.2476104062), new Vsop87.LnVsop(9.49E-9, 0.68597092334, 1361.5467058442), new Vsop87.LnVsop(7.88E-9, 1.44319075028, 1272.6810256272), new Vsop87.LnVsop(7.74E-9, 3.21426219962, 508.3503240922), new Vsop87.LnVsop(9.21E-9, 5.33422516215, 551.031606097), new Vsop87.LnVsop(6.81E-9, 0.44800059149, 1073.6090241908), new Vsop87.LnVsop(6.81E-9, 5.21435913114, 21.3406410024), new Vsop87.LnVsop(5.87E-9, 4.57539103016, 110.2063212194), new Vsop87.LnVsop(5.78E-9, 1.97098995055, 647.0108333148), new Vsop87.LnVsop(5.96E-9, 2.85043907413, 191.9584544356), new Vsop87.LnVsop(5.99E-9, 2.43146933611, 117.3198682202), new Vsop87.LnVsop(5.44E-9, 0.53039419311, 330.6189636582), new Vsop87.LnVsop(5.45E-9, 3.50461220615, 302.164775655), new Vsop87.LnVsop(5.38E-9, 4.22160404735, 88.865680217), new Vsop87.LnVsop(7.57E-9, 2.28818475655, 942.062061969), new Vsop87.LnVsop(5.62E-9, 1.485943786, 3.1813937377), new Vsop87.LnVsop(6.31E-9, 1.83863158533, 10.2949407385), new Vsop87.LnVsop(5.04E-9, 2.08322743695, 103.0927742186), new Vsop87.LnVsop(4.62E-9, 0.40130574859, 433.7117378768)};
        private static final Vsop87.LnVsop[] jupiter_radius_r5 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.1193E-7, 4.74280611863, 536.8045120954), new Vsop87.LnVsop(4.288E-8, 5.90497787277, 522.5774180938), new Vsop87.LnVsop(2.004E-8, 3.65178377123, 7.1135470008), new Vsop87.LnVsop(2.118E-8, 5.57290745004, 515.463871093), new Vsop87.LnVsop(1.908E-8, 4.29659647286, 543.9180590962), new Vsop87.LnVsop(1.534E-8, 5.4637372964, 1066.49547719), new Vsop87.LnVsop(1.596E-8, 4.11045079899, 1059.3819301892), new Vsop87.LnVsop(1.301E-8, 3.72955393027, 14.2270940016), new Vsop87.LnVsop(1.033E-8, 4.50671820436, 529.6909650946)};

        Radius() {
        }
    }

    static class Latitude {
        private static final Vsop87.LnVsop[] jupiter_latitude_b0 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.02268615702, 3.55852606721, 529.6909650946), new Vsop87.LnVsop(0.00109971634, 3.90809347197, 1059.3819301892), new Vsop87.LnVsop(0.00110090358, 0.0, 0.0), new Vsop87.LnVsop(8.101428E-5, 3.60509572885, 522.5774180938), new Vsop87.LnVsop(6.043996E-5, 4.25883108339, 1589.0728952838), new Vsop87.LnVsop(6.437782E-5, 0.30627119215, 536.8045120954), new Vsop87.LnVsop(1.10688E-5, 2.9853440952, 1162.4747044078), new Vsop87.LnVsop(9.41651E-6, 2.93619073963, 1052.2683831884), new Vsop87.LnVsop(8.94088E-6, 1.75447402715, 7.1135470008), new Vsop87.LnVsop(7.6728E-6, 2.15473604461, 632.7837393132), new Vsop87.LnVsop(9.44328E-6, 1.67522315024, 426.598190876), new Vsop87.LnVsop(6.84219E-6, 3.67808774854, 213.299095438), new Vsop87.LnVsop(6.29223E-6, 0.6434329002, 1066.49547719), new Vsop87.LnVsop(8.35861E-6, 5.1788197781, 103.0927742186), new Vsop87.LnVsop(5.31671E-6, 2.70305944444, 110.2063212194), new Vsop87.LnVsop(5.58524E-6, 0.01354838161, 846.0828347512), new Vsop87.LnVsop(4.64449E-6, 1.17337267936, 949.1756089698), new Vsop87.LnVsop(4.31072E-6, 2.6082502278, 419.4846438752), new Vsop87.LnVsop(3.51433E-6, 4.61062966359, 2118.7638603784), new Vsop87.LnVsop(1.23148E-6, 3.34968047337, 1692.1656695024), new Vsop87.LnVsop(1.15038E-6, 5.04892367391, 316.3918696566), new Vsop87.LnVsop(1.32159E-6, 4.7781694038, 742.9900605326), new Vsop87.LnVsop(1.03402E-6, 2.31878940535, 1478.8665740644), new Vsop87.LnVsop(1.16379E-6, 1.38688268881, 323.5054166574), new Vsop87.LnVsop(1.0242E-6, 3.15294025567, 1581.959348283), new Vsop87.LnVsop(1.03762E-6, 3.70104530617, 515.463871093), new Vsop87.LnVsop(7.865E-7, 3.98318863271, 1265.5674786264), new Vsop87.LnVsop(6.9935E-7, 2.56006243114, 956.2891559706), new Vsop87.LnVsop(5.5597E-7, 0.37501076637, 1375.7737998458), new Vsop87.LnVsop(5.1986E-7, 0.99006936413, 1596.1864422846), new Vsop87.LnVsop(5.5194E-7, 0.4017664106, 525.7588118315), new Vsop87.LnVsop(6.3456E-7, 4.50073545366, 735.8765135318), new Vsop87.LnVsop(4.9691E-7, 0.18650769854, 543.9180590962), new Vsop87.LnVsop(4.8831E-7, 3.57260516733, 533.6231183577), new Vsop87.LnVsop(2.8353E-7, 1.53532751494, 625.6701923124), new Vsop87.LnVsop(2.9209E-7, 5.43144706118, 206.1855484372), new Vsop87.LnVsop(2.3255E-7, 5.95197656622, 838.9692877504), new Vsop87.LnVsop(2.2841E-7, 6.19262795963, 532.8723588323), new Vsop87.LnVsop(2.3202E-7, 4.06473393382, 526.5095713569), new Vsop87.LnVsop(2.4435E-7, 6.1094808932, 1169.5882514086), new Vsop87.LnVsop(2.1116E-7, 4.96322450112, 2648.454825473), new Vsop87.LnVsop(1.7878E-7, 3.08705078418, 1795.258443721), new Vsop87.LnVsop(1.6234E-7, 4.83514182468, 1368.660252845), new Vsop87.LnVsop(2.1314E-7, 2.69476772406, 1045.1548361876), new Vsop87.LnVsop(1.574E-7, 1.15129718235, 942.062061969), new Vsop87.LnVsop(1.7325E-7, 1.61549112201, 14.2270940016), new Vsop87.LnVsop(1.3396E-7, 2.30541502374, 853.196381752), new Vsop87.LnVsop(1.1904E-7, 3.09812644271, 2111.6503133776), new Vsop87.LnVsop(1.1734E-7, 2.83005459062, 2008.557539159), new Vsop87.LnVsop(1.1291E-7, 0.98958488237, 433.7117378768), new Vsop87.LnVsop(1.183E-7, 4.76527289406, 309.2783226558), new Vsop87.LnVsop(1.0702E-7, 3.7018297714, 2221.856634597), new Vsop87.LnVsop(1.0815E-7, 5.8196067182, 1272.6810256272), new Vsop87.LnVsop(1.3505E-7, 3.28127499147, 1155.361157407), new Vsop87.LnVsop(1.0179E-7, 2.58690544075, 117.3198682202), new Vsop87.LnVsop(1.0632E-7, 5.23488821353, 95.9792272178), new Vsop87.LnVsop(8.77E-8, 0.40456977116, 220.4126424388), new Vsop87.LnVsop(7.439E-8, 2.94640424217, 412.3710968744), new Vsop87.LnVsop(6.151E-8, 2.69098997815, 380.12776796), new Vsop87.LnVsop(5.028E-8, 0.7274968344, 1055.4497769261), new Vsop87.LnVsop(4.939E-8, 0.73757027802, 1905.4647649404), new Vsop87.LnVsop(5.421E-8, 4.08611312731, 1685.0521225016), new Vsop87.LnVsop(5.936E-8, 4.32059794159, 1063.3140834523), new Vsop87.LnVsop(4.737E-8, 4.09302873263, 527.2432845398), new Vsop87.LnVsop(4.01E-8, 0.51536205068, 1073.6090241908), new Vsop87.LnVsop(4.709E-8, 1.84069593466, 984.6003316219), new Vsop87.LnVsop(3.974E-8, 1.33608144666, 2125.8774073792), new Vsop87.LnVsop(3.762E-8, 3.58647029066, 529.7391492044), new Vsop87.LnVsop(4.731E-8, 6.16377395837, 532.1386456494), new Vsop87.LnVsop(4.666E-8, 5.88761580267, 639.897286314), new Vsop87.LnVsop(3.763E-8, 0.38865915086, 529.6427809848), new Vsop87.LnVsop(3.409E-8, 4.05403520743, 1898.3512179396), new Vsop87.LnVsop(3.458E-8, 3.43863446426, 1485.9801210652), new Vsop87.LnVsop(4.23E-8, 2.23769605857, 74.7815985673), new Vsop87.LnVsop(3.091E-8, 0.16468497073, 1699.2792165032), new Vsop87.LnVsop(2.976E-8, 0.72268932553, 530.6541729411), new Vsop87.LnVsop(3.162E-8, 1.25051775753, 330.6189636582), new Vsop87.LnVsop(2.727E-8, 4.37684648696, 149.5631971346), new Vsop87.LnVsop(2.837E-8, 0.05988888469, 1439.5096981492), new Vsop87.LnVsop(2.983E-8, 3.25251234697, 528.7277572481), new Vsop87.LnVsop(2.232E-8, 0.26152702827, 1062.5633239269), new Vsop87.LnVsop(2.464E-8, 1.1691499032, 453.424893819), new Vsop87.LnVsop(2.596E-8, 3.30503237792, 2324.9494088156), new Vsop87.LnVsop(1.988E-8, 2.85269753342, 1574.8458012822), new Vsop87.LnVsop(2.527E-8, 5.94464299442, 909.8187330546), new Vsop87.LnVsop(2.269E-8, 1.30385144361, 3.9321532631), new Vsop87.LnVsop(1.742E-8, 4.4993438743, 1258.4539316256), new Vsop87.LnVsop(1.714E-8, 4.12970162252, 2001.4439921582), new Vsop87.LnVsop(2.028E-8, 3.97933364572, 1056.2005364515), new Vsop87.LnVsop(1.667E-8, 0.36035632569, 10213.285546211), new Vsop87.LnVsop(1.579E-8, 6.11636481584, 1802.3719907218), new Vsop87.LnVsop(1.393E-8, 3.69324297104, 2214.7430875962), new Vsop87.LnVsop(1.604E-8, 1.98841976369, 38.1330356378), new Vsop87.LnVsop(1.325E-8, 1.74025919863, 529.1697002328), new Vsop87.LnVsop(1.451E-8, 2.39820472604, 2428.0421830342), new Vsop87.LnVsop(1.594E-8, 2.07557781162, 1021.2488945514), new Vsop87.LnVsop(1.319E-8, 1.33764254668, 618.5566453116), new Vsop87.LnVsop(1.346E-8, 3.27611250994, 2641.3412784722), new Vsop87.LnVsop(1.23E-8, 0.19547016795, 305.3461693927), new Vsop87.LnVsop(1.223E-8, 2.86673324041, 1382.8873468466), new Vsop87.LnVsop(1.324E-8, 2.23549334986, 530.2122299564), new Vsop87.LnVsop(1.056E-8, 3.8058420628, 76.2660712756), new Vsop87.LnVsop(1.05E-8, 4.68049393704, 1788.1448967202), new Vsop87.LnVsop(1.226E-8, 5.34004079561, 3178.1457905676), new Vsop87.LnVsop(1.009E-8, 3.19598679941, 2538.2485042536), new Vsop87.LnVsop(1.266E-8, 3.04716587183, 604.4725636619), new Vsop87.LnVsop(9.54E-9, 3.86982853835, 728.762966531), new Vsop87.LnVsop(1.124E-8, 1.59536330231, 3.1813937377), new Vsop87.LnVsop(9.78E-9, 0.25225276132, 983.1158589136), new Vsop87.LnVsop(9.48E-9, 0.21562638606, 750.1036075334), new Vsop87.LnVsop(9.46E-9, 3.93927018641, 508.3503240922), new Vsop87.LnVsop(9.2E-9, 1.14676177277, 963.4027029714), new Vsop87.LnVsop(8.17E-9, 5.93843083013, 831.8557407496), new Vsop87.LnVsop(7.7E-9, 2.96062737592, 526.7702037878), new Vsop87.LnVsop(1.018E-8, 5.55723104876, 199.0720014364), new Vsop87.LnVsop(7.61E-9, 1.38163787157, 532.6117264014), new Vsop87.LnVsop(7.26E-9, 3.98350624153, 2317.8358618148), new Vsop87.LnVsop(8.63E-9, 0.87983185587, 490.3340891794), new Vsop87.LnVsop(8.68E-9, 3.44355447829, 569.0478410098), new Vsop87.LnVsop(7.11E-9, 4.11083927584, 2751.5475996916), new Vsop87.LnVsop(7.08E-9, 0.33555577415, 528.9402055692), new Vsop87.LnVsop(7.08E-9, 4.00539820601, 530.44172462), new Vsop87.LnVsop(6.56E-9, 4.39587636715, 519.3960243561), new Vsop87.LnVsop(8.01E-9, 4.03968735657, 1364.7280995819), new Vsop87.LnVsop(6.79E-9, 1.18645749024, 525.4981794006), new Vsop87.LnVsop(6.45E-9, 5.10528821006, 1361.5467058442), new Vsop87.LnVsop(6.68E-9, 3.15607509055, 533.8837507886), new Vsop87.LnVsop(6.63E-9, 0.73722024842, 5223.6939198022), new Vsop87.LnVsop(6.63E-9, 1.5709278681, 6283.0758499914), new Vsop87.LnVsop(5.43E-9, 0.26361339096, 227.5261894396), new Vsop87.LnVsop(5.25E-9, 6.22337510612, 539.9859058331), new Vsop87.LnVsop(5.13E-9, 4.98311290285, 302.164775655), new Vsop87.LnVsop(5.44E-9, 2.2225302277, 2744.4340526908), new Vsop87.LnVsop(5.31E-9, 2.62394469648, 99.1606209555), new Vsop87.LnVsop(6.02E-9, 1.56087341101, 454.9093665273), new Vsop87.LnVsop(5.18E-9, 0.26343809435, 551.031606097), new Vsop87.LnVsop(5.16E-9, 1.09334875112, 934.9485149682), new Vsop87.LnVsop(6.59E-9, 0.62609803674, 1512.8068240082), new Vsop87.LnVsop(5.24E-9, 0.64710955846, 524.0618908021), new Vsop87.LnVsop(5.16E-9, 3.69478866795, 535.3200393871), new Vsop87.LnVsop(4.91E-9, 3.63015352701, 2531.1349572528), new Vsop87.LnVsop(5.7E-9, 0.61976758778, 540.7366653585), new Vsop87.LnVsop(4.96E-9, 2.19397054688, 1514.2912967165), new Vsop87.LnVsop(5.32E-9, 0.20040217534, 525.0250986486), new Vsop87.LnVsop(4.49E-9, 0.62392433691, 529.5309064002), new Vsop87.LnVsop(4.49E-9, 3.71676131146, 529.851023789), new Vsop87.LnVsop(4.93E-9, 0.39157407639, 224.3447957019), new Vsop87.LnVsop(4.5E-9, 5.02496027796, 1048.3362299253), new Vsop87.LnVsop(4.28E-9, 5.44829085911, 11.0457002639), new Vsop87.LnVsop(4.99E-9, 4.13924061941, 534.3568315406), new Vsop87.LnVsop(5.28E-9, 1.76471074936, 524.2743391232), new Vsop87.LnVsop(4.54E-9, 4.53329910309, 1056.9342496344), new Vsop87.LnVsop(5.2E-9, 2.57406093768, 535.107591066), new Vsop87.LnVsop(3.98E-9, 1.40335768867, 960.2213092337), new Vsop87.LnVsop(4.57E-9, 4.1769850057, 2104.5367663768), new Vsop87.LnVsop(5.05E-9, 5.36536006721, 1057.8974574809), new Vsop87.LnVsop(5.36E-9, 4.80412344518, 1593.0050485469), new Vsop87.LnVsop(4.15E-9, 0.96574631343, 2435.155730035), new Vsop87.LnVsop(5.18E-9, 0.54534019245, 1061.829610744), new Vsop87.LnVsop(3.59E-9, 4.0270344203, 1059.430114299), new Vsop87.LnVsop(3.57E-9, 2.66856274985, 835.0371344873), new Vsop87.LnVsop(4.43E-9, 5.27506751917, 1.4844727083), new Vsop87.LnVsop(3.58E-9, 5.94447745169, 440.8252848776), new Vsop87.LnVsop(4.71E-9, 6.05795526096, 1471.7530270636), new Vsop87.LnVsop(3.86E-9, 2.1595764934, 9153.9036160218), new Vsop87.LnVsop(4.24E-9, 2.70933415956, 1038.0412891868), new Vsop87.LnVsop(3.59E-9, 0.82921825054, 1059.3337460794), new Vsop87.LnVsop(3.1E-9, 0.88102053266, 529.9034134157), new Vsop87.LnVsop(3.1E-9, 3.45966511571, 529.4785167735), new Vsop87.LnVsop(3.0E-9, 3.70314980875, 2634.2277314714), new Vsop87.LnVsop(2.92E-9, 2.6369029408, 415.5524906121), new Vsop87.LnVsop(2.79E-9, 1.60721363324, 643.8294395771), new Vsop87.LnVsop(2.91E-9, 5.83172186169, 1148.2476104062), new Vsop87.LnVsop(3.7E-9, 5.71572992264, 531.1754378029), new Vsop87.LnVsop(2.67E-9, 5.39229778002, 1891.2376709388), new Vsop87.LnVsop(2.75E-9, 3.34111459961, 518.6452648307), new Vsop87.LnVsop(2.69E-9, 1.06062338999, 1585.1407420207), new Vsop87.LnVsop(3.05E-9, 2.50290530704, 511.5317178299), new Vsop87.LnVsop(2.95E-9, 1.84394223501, 547.8502123593), new Vsop87.LnVsop(2.54E-9, 2.98339664362, 1134.1635287565), new Vsop87.LnVsop(2.89E-9, 1.86077249808, 21.3406410024), new Vsop87.LnVsop(2.65E-9, 4.93074056536, 679.2541622292), new Vsop87.LnVsop(2.5E-9, 0.4286403204, 1969.2006632438), new Vsop87.LnVsop(3.08E-9, 2.67241191564, 2957.7331481288), new Vsop87.LnVsop(2.22E-9, 4.78828764413, 514.7131115676), new Vsop87.LnVsop(3.13E-9, 4.88100504465, 528.2064923863), new Vsop87.LnVsop(2.21E-9, 4.3294566753, 1677.9385755008), new Vsop87.LnVsop(2.17E-9, 3.46325099644, 2950.619601128), new Vsop87.LnVsop(2.16E-9, 0.52215246917, 2228.9701815978), new Vsop87.LnVsop(2.14E-9, 5.83569926578, 544.6688186216), new Vsop87.LnVsop(2.83E-9, 2.88733008413, 35.4247226521), new Vsop87.LnVsop(2.72E-9, 1.65636249662, 3060.8259223474), new Vsop87.LnVsop(2.34E-9, 1.68821601235, 2655.5683724738), new Vsop87.LnVsop(2.05E-9, 3.36180409781, 2847.5268269094), new Vsop87.LnVsop(2.64E-9, 3.62728688214, 2420.9286360334), new Vsop87.LnVsop(1.91E-9, 4.26801797983, 430.5303441391), new Vsop87.LnVsop(1.79E-9, 3.91470663032, 3340.6124266998), new Vsop87.LnVsop(1.8E-9, 0.04748930181, 387.2413149608), new Vsop87.LnVsop(2.41E-9, 4.03850570457, 494.2662424425), new Vsop87.LnVsop(1.77E-9, 4.26408822698, 672.1406152284), new Vsop87.LnVsop(1.87E-9, 2.72585227782, 299.1263942692), new Vsop87.LnVsop(2.34E-9, 1.34461198439, 173.9422195228), new Vsop87.LnVsop(1.71E-9, 0.85583570724, 1603.2999892854), new Vsop87.LnVsop(2.24E-9, 0.33038256827, 565.1156877467), new Vsop87.LnVsop(2.0E-9, 1.27568775106, 39.3568759152), new Vsop87.LnVsop(1.7E-9, 4.96553772568, 1464.6394800628), new Vsop87.LnVsop(2.11E-9, 1.00937080256, 523.5406259403), new Vsop87.LnVsop(2.1E-9, 3.75802767164, 2854.6403739102), new Vsop87.LnVsop(1.62E-9, 5.87799218214, 3480.3105662226), new Vsop87.LnVsop(1.63E-9, 4.62924224205, 2015.6710861598), new Vsop87.LnVsop(1.91E-9, 3.3315928375, 535.8413042489), new Vsop87.LnVsop(1.51E-9, 1.17104489977, 1060.3451380357), new Vsop87.LnVsop(1.6E-9, 1.81868596669, 312.4597163935), new Vsop87.LnVsop(1.58E-9, 2.59595816107, 529.4303326637), new Vsop87.LnVsop(1.58E-9, 1.7447274873, 529.9515975255), new Vsop87.LnVsop(1.73E-9, 3.62448533343, 230.5645708254), new Vsop87.LnVsop(1.42E-9, 0.70435921398, 522.529233984), new Vsop87.LnVsop(1.44E-9, 5.35713735269, 107.0249274817), new Vsop87.LnVsop(1.44E-9, 6.14090754307, 1158.5425511447), new Vsop87.LnVsop(1.78E-9, 0.27468100074, 3906.9087570986), new Vsop87.LnVsop(1.26E-9, 5.15022690251, 2207.6295405954), new Vsop87.LnVsop(1.26E-9, 3.42007113405, 2.4476805548), new Vsop87.LnVsop(1.27E-9, 0.39943436855, 70.8494453042), new Vsop87.LnVsop(1.23E-9, 4.77863018783, 2524.021410252), new Vsop87.LnVsop(1.23E-9, 0.46252835423, 647.0108333148), new Vsop87.LnVsop(1.44E-9, 3.60266428249, 1058.4187223427), new Vsop87.LnVsop(1.58E-9, 3.76145245959, 92.0470739547), new Vsop87.LnVsop(1.19E-9, 4.08254103435, 1585.8915015461), new Vsop87.LnVsop(1.25E-9, 2.35595591495, 3163.918696566), new Vsop87.LnVsop(1.22E-9, 3.21032018083, 3377.217792004), new Vsop87.LnVsop(1.21E-9, 3.3976715496, 18.1592472647), new Vsop87.LnVsop(1.31E-9, 1.67909216935, 1289.9465010146), new Vsop87.LnVsop(1.15E-9, 2.35736056408, 1550.939859646), new Vsop87.LnVsop(1.26E-9, 2.40837527327, 106.2741679563), new Vsop87.LnVsop(1.31E-9, 1.3764322801, 1023.9572075371), new Vsop87.LnVsop(1.21E-9, 1.60251352962, 10.2949407385), new Vsop87.LnVsop(1.21E-9, 0.6142582568, 1592.2542890215), new Vsop87.LnVsop(1.35E-9, 3.60014547346, 124.433415221), new Vsop87.LnVsop(1.37E-9, 2.41776488975, 3274.1250177854), new Vsop87.LnVsop(1.29E-9, 0.09688303813, 2332.0629558164), new Vsop87.LnVsop(9.2E-10, 4.89058170259, 1098.7388061044), new Vsop87.LnVsop(1.06E-9, 5.18592950792, 2281.2304965106), new Vsop87.LnVsop(1.14E-9, 2.96580552116, 1166.4068576709), new Vsop87.LnVsop(9.2E-10, 1.6502742275, 860.3099287528), new Vsop87.LnVsop(1.02E-9, 3.6426515808, 3171.0322435668), new Vsop87.LnVsop(1.03E-9, 1.63123525514, 1894.4190646765), new Vsop87.LnVsop(8.0E-10, 0.38766601962, 4694.0029547076), new Vsop87.LnVsop(7.4E-10, 3.869459078, 3067.9394693482), new Vsop87.LnVsop(9.5E-10, 1.66457947, 1151.4290041439)};
        private static final Vsop87.LnVsop[] jupiter_latitude_b1 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(7.8203446E-4, 1.52377859742, 529.6909650946), new Vsop87.LnVsop(7.789905E-5, 2.59734071843, 1059.3819301892), new Vsop87.LnVsop(2.788602E-5, 4.85622679819, 536.8045120954), new Vsop87.LnVsop(2.429728E-5, 5.45947255041, 522.5774180938), new Vsop87.LnVsop(1.985777E-5, 0.0, 0.0), new Vsop87.LnVsop(7.11633E-6, 3.13688338277, 1589.0728952838), new Vsop87.LnVsop(2.92916E-6, 5.27960297214, 1066.49547719), new Vsop87.LnVsop(2.57804E-6, 4.76667796123, 1052.2683831884), new Vsop87.LnVsop(2.71233E-6, 0.10154920958, 7.1135470008), new Vsop87.LnVsop(8.6261E-7, 1.08347893125, 103.0927742186), new Vsop87.LnVsop(7.9683E-7, 1.04738628033, 110.2063212194), new Vsop87.LnVsop(8.1369E-7, 0.63901209639, 419.4846438752), new Vsop87.LnVsop(8.1666E-7, 0.49217368092, 426.598190876), new Vsop87.LnVsop(7.0613E-7, 2.82219329635, 632.7837393132), new Vsop87.LnVsop(6.6992E-7, 5.48215719084, 515.463871093), new Vsop87.LnVsop(5.8497E-7, 3.56648086507, 2118.7638603784), new Vsop87.LnVsop(5.1976E-7, 2.85910965609, 949.1756089698), new Vsop87.LnVsop(4.1188E-7, 4.75217333048, 543.9180590962), new Vsop87.LnVsop(3.9924E-7, 3.9243378711, 735.8765135318), new Vsop87.LnVsop(4.0237E-7, 1.1356429014, 1162.4747044078), new Vsop87.LnVsop(2.6065E-7, 5.69856804584, 1596.1864422846), new Vsop87.LnVsop(3.1305E-7, 6.03167547323, 323.5054166574), new Vsop87.LnVsop(3.0485E-7, 5.98342688371, 316.3918696566), new Vsop87.LnVsop(2.1243E-7, 4.88358142951, 213.299095438), new Vsop87.LnVsop(1.7336E-7, 1.63355193402, 956.2891559706), new Vsop87.LnVsop(1.6318E-7, 1.68217979523, 206.1855484372), new Vsop87.LnVsop(2.1612E-7, 4.90561988011, 1581.959348283), new Vsop87.LnVsop(1.505E-7, 4.621848587, 525.7588118315), new Vsop87.LnVsop(1.5354E-7, 4.38535188227, 532.8723588323), new Vsop87.LnVsop(1.4194E-7, 5.89751177643, 526.5095713569), new Vsop87.LnVsop(1.2259E-7, 5.76584367807, 533.6231183577), new Vsop87.LnVsop(1.3752E-7, 4.43118193299, 1045.1548361876), new Vsop87.LnVsop(1.0998E-7, 3.66464772481, 742.9900605326), new Vsop87.LnVsop(1.0324E-7, 4.35223675725, 1169.5882514086), new Vsop87.LnVsop(1.202E-7, 6.22841485051, 14.2270940016), new Vsop87.LnVsop(8.201E-8, 5.61044388483, 1265.5674786264), new Vsop87.LnVsop(9.125E-8, 2.07963809004, 1692.1656695024), new Vsop87.LnVsop(6.995E-8, 3.68757029433, 625.6701923124), new Vsop87.LnVsop(6.623E-8, 2.95794554141, 942.062061969), new Vsop87.LnVsop(6.854E-8, 4.8689970084, 1155.361157407), new Vsop87.LnVsop(5.392E-8, 0.92120894811, 117.3198682202), new Vsop87.LnVsop(4.948E-8, 5.58428784853, 433.7117378768), new Vsop87.LnVsop(5.907E-8, 4.00891325053, 639.897286314), new Vsop87.LnVsop(4.904E-8, 0.79623393478, 95.9792272178), new Vsop87.LnVsop(4.849E-8, 0.77150458453, 853.196381752), new Vsop87.LnVsop(4.554E-8, 3.96028178465, 2648.454825473), new Vsop87.LnVsop(3.572E-8, 5.0359177237, 220.4126424388), new Vsop87.LnVsop(3.471E-8, 5.1316691305, 1073.6090241908), new Vsop87.LnVsop(3.611E-8, 1.57140411443, 1478.8665740644), new Vsop87.LnVsop(2.856E-8, 4.6708893116, 1272.6810256272), new Vsop87.LnVsop(3.393E-8, 5.57286071973, 1375.7737998458), new Vsop87.LnVsop(2.753E-8, 0.68101124197, 846.0828347512), new Vsop87.LnVsop(2.097E-8, 6.16024347671, 2125.8774073792), new Vsop87.LnVsop(2.114E-8, 5.87434713206, 330.6189636582), new Vsop87.LnVsop(1.945E-8, 0.99530094399, 309.2783226558), new Vsop87.LnVsop(1.637E-8, 0.11662674189, 1795.258443721), new Vsop87.LnVsop(1.899E-8, 5.04072957525, 412.3710968744), new Vsop87.LnVsop(1.791E-8, 2.71494717262, 1485.9801210652), new Vsop87.LnVsop(1.543E-8, 4.89349278048, 1062.5633239269), new Vsop87.LnVsop(1.379E-8, 4.78442752303, 1699.2792165032), new Vsop87.LnVsop(1.614E-8, 5.3169501295, 2111.6503133776), new Vsop87.LnVsop(1.356E-8, 5.09369131122, 1055.4497769261), new Vsop87.LnVsop(1.472E-8, 4.5564613273, 1574.8458012822), new Vsop87.LnVsop(1.216E-8, 5.83778167217, 1258.4539316256), new Vsop87.LnVsop(1.061E-8, 0.21929903524, 1063.3140834523), new Vsop87.LnVsop(1.281E-8, 2.63291136301, 2221.856634597), new Vsop87.LnVsop(1.282E-8, 4.40670408797, 728.762966531), new Vsop87.LnVsop(1.081E-8, 5.6595815302, 508.3503240922), new Vsop87.LnVsop(1.236E-8, 5.79698189268, 1056.2005364515), new Vsop87.LnVsop(8.34E-9, 5.66034576977, 838.9692877504), new Vsop87.LnVsop(8.43E-9, 1.39726903288, 199.0720014364), new Vsop87.LnVsop(1.114E-8, 0.93457172591, 1368.660252845), new Vsop87.LnVsop(1.004E-8, 1.88230290234, 2008.557539159), new Vsop87.LnVsop(7.84E-9, 3.98772675676, 1471.7530270636), new Vsop87.LnVsop(6.82E-9, 6.16172441549, 519.3960243561), new Vsop87.LnVsop(6.49E-9, 3.11256832821, 618.5566453116), new Vsop87.LnVsop(5.97E-9, 4.81489778721, 551.031606097), new Vsop87.LnVsop(5.46E-9, 4.76855837933, 1685.0521225016), new Vsop87.LnVsop(5.46E-9, 4.45547174659, 539.9859058331), new Vsop87.LnVsop(6.28E-9, 0.06358024238, 3.1813937377), new Vsop87.LnVsop(5.14E-9, 1.39819252269, 1382.8873468466), new Vsop87.LnVsop(5.46E-9, 5.95490984957, 1905.4647649404), new Vsop87.LnVsop(4.32E-9, 4.90782507942, 227.5261894396), new Vsop87.LnVsop(3.75E-9, 6.13692411934, 2428.0421830342), new Vsop87.LnVsop(4.41E-9, 4.43503611535, 1038.0412891868), new Vsop87.LnVsop(3.36E-9, 4.15259691191, 440.8252848776), new Vsop87.LnVsop(3.92E-9, 4.41318281175, 1802.3719907218), new Vsop87.LnVsop(3.36E-9, 1.95113506965, 525.0250986486), new Vsop87.LnVsop(3.22E-9, 2.38708525663, 534.3568315406), new Vsop87.LnVsop(4.11E-9, 4.66598314047, 750.1036075334), new Vsop87.LnVsop(2.7E-9, 4.34851907328, 3178.1457905676), new Vsop87.LnVsop(3.44E-9, 2.88739614093, 3.9321532631), new Vsop87.LnVsop(3.06E-9, 0.14928179595, 21.3406410024), new Vsop87.LnVsop(2.29E-9, 4.71494574126, 1788.1448967202), new Vsop87.LnVsop(2.53E-9, 5.97477420709, 1898.3512179396), new Vsop87.LnVsop(2.2E-9, 1.65244409667, 302.164775655), new Vsop87.LnVsop(2.0E-9, 5.63991949724, 524.2743391232), new Vsop87.LnVsop(1.97E-9, 4.98395147244, 535.107591066), new Vsop87.LnVsop(1.89E-9, 1.27085486089, 831.8557407496), new Vsop87.LnVsop(2.17E-9, 5.72813758318, 963.4027029714), new Vsop87.LnVsop(1.63E-9, 4.41162044978, 511.5317178299), new Vsop87.LnVsop(1.57E-9, 6.22659623699, 547.8502123593), new Vsop87.LnVsop(1.56E-9, 4.4788995575, 2104.5367663768), new Vsop87.LnVsop(1.58E-9, 4.68155089578, 526.7702037878), new Vsop87.LnVsop(1.57E-9, 5.94254789616, 532.6117264014), new Vsop87.LnVsop(1.77E-9, 1.54590155579, 2324.9494088156), new Vsop87.LnVsop(1.59E-9, 0.57726792367, 1361.5467058442), new Vsop87.LnVsop(1.43E-9, 5.47600559579, 1603.2999892854), new Vsop87.LnVsop(1.44E-9, 1.09752516756, 74.7815985673), new Vsop87.LnVsop(1.25E-9, 4.04792462029, 2001.4439921582), new Vsop87.LnVsop(1.16E-9, 0.2066142658, 2655.5683724738), new Vsop87.LnVsop(1.0E-9, 5.2954686401, 1891.2376709388), new Vsop87.LnVsop(1.04E-9, 6.06015582682, 10.2949407385), new Vsop87.LnVsop(1.22E-9, 3.06889841223, 2317.8358618148), new Vsop87.LnVsop(1.06E-9, 3.07515212924, 2751.5475996916), new Vsop87.LnVsop(1.23E-9, 3.57772593687, 2015.6710861598), new Vsop87.LnVsop(8.0E-10, 5.2238696329, 2228.9701815978), new Vsop87.LnVsop(1.03E-9, 2.60543230206, 2538.2485042536), new Vsop87.LnVsop(7.6E-10, 6.05570454898, 984.6003316219), new Vsop87.LnVsop(8.7E-10, 4.53831014475, 1148.2476104062)};
        private static final Vsop87.LnVsop[] jupiter_latitude_b2 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(5.49832E-5, 3.01596270062, 529.6909650946), new Vsop87.LnVsop(6.02076E-6, 3.13358939436, 536.8045120954), new Vsop87.LnVsop(5.02174E-6, 2.05202111599, 1059.3819301892), new Vsop87.LnVsop(4.53862E-6, 0.95912416388, 522.5774180938), new Vsop87.LnVsop(1.15043E-6, 0.0, 0.0), new Vsop87.LnVsop(6.8911E-7, 3.65515676096, 1066.49547719), new Vsop87.LnVsop(6.7052E-7, 2.23363751256, 1589.0728952838), new Vsop87.LnVsop(4.2555E-7, 0.52143365809, 1052.2683831884), new Vsop87.LnVsop(3.9396E-7, 4.65314230657, 7.1135470008), new Vsop87.LnVsop(2.3438E-7, 0.96725852073, 515.463871093), new Vsop87.LnVsop(1.7383E-7, 3.0311625189, 543.9180590962), new Vsop87.LnVsop(6.651E-8, 4.14899100562, 1596.1864422846), new Vsop87.LnVsop(7.013E-8, 2.58268666095, 2118.7638603784), new Vsop87.LnVsop(5.389E-8, 5.43989474079, 110.2063212194), new Vsop87.LnVsop(4.578E-8, 6.21390672967, 1045.1548361876), new Vsop87.LnVsop(4.226E-8, 2.60174767485, 532.8723588323), new Vsop87.LnVsop(3.653E-8, 5.49147329377, 426.598190876), new Vsop87.LnVsop(4.208E-8, 4.53565061928, 14.2270940016), new Vsop87.LnVsop(3.62E-8, 2.16725398015, 1162.4747044078), new Vsop87.LnVsop(4.347E-8, 4.3461097602, 323.5054166574), new Vsop87.LnVsop(3.449E-8, 1.44287034922, 526.5095713569), new Vsop87.LnVsop(3.25E-8, 4.99793920041, 632.7837393132), new Vsop87.LnVsop(3.549E-8, 5.47945408971, 103.0927742186), new Vsop87.LnVsop(3.031E-8, 0.65632340107, 1581.959348283), new Vsop87.LnVsop(3.252E-8, 5.38360789595, 949.1756089698), new Vsop87.LnVsop(2.464E-8, 0.29383438152, 956.2891559706), new Vsop87.LnVsop(2.59E-8, 2.61624183669, 525.7588118315), new Vsop87.LnVsop(2.414E-8, 6.08828067002, 419.4846438752), new Vsop87.LnVsop(2.206E-8, 2.62381175358, 1169.5882514086), new Vsop87.LnVsop(1.991E-8, 1.5660645161, 533.6231183577), new Vsop87.LnVsop(1.868E-8, 2.0356422949, 316.3918696566), new Vsop87.LnVsop(2.225E-8, 6.11348450922, 735.8765135318), new Vsop87.LnVsop(1.512E-8, 4.74989508185, 942.062061969), new Vsop87.LnVsop(1.458E-8, 3.53705002363, 1073.6090241908), new Vsop87.LnVsop(1.473E-8, 3.61629070367, 206.1855484372), new Vsop87.LnVsop(1.467E-8, 5.52885404945, 117.3198682202), new Vsop87.LnVsop(1.373E-8, 0.3687588483, 1155.361157407), new Vsop87.LnVsop(1.237E-8, 2.65571662403, 95.9792272178), new Vsop87.LnVsop(1.124E-8, 3.90568585311, 433.7117378768), new Vsop87.LnVsop(1.348E-8, 5.54306182308, 625.6701923124), new Vsop87.LnVsop(9.64E-9, 5.49710119494, 853.196381752), new Vsop87.LnVsop(9.47E-9, 2.34829918409, 639.897286314), new Vsop87.LnVsop(7.98E-9, 3.3790937024, 220.4126424388), new Vsop87.LnVsop(7.07E-9, 1.57787722219, 1692.1656695024), new Vsop87.LnVsop(5.91E-9, 0.29761569203, 213.299095438), new Vsop87.LnVsop(5.72E-9, 1.28691054813, 508.3503240922), new Vsop87.LnVsop(5.12E-9, 2.56537612741, 1265.5674786264), new Vsop87.LnVsop(6.65E-9, 6.11880936688, 728.762966531), new Vsop87.LnVsop(4.47E-9, 4.60869261113, 2125.8774073792), new Vsop87.LnVsop(5.86E-9, 4.43282799664, 330.6189636582), new Vsop87.LnVsop(4.14E-9, 1.25349133607, 1258.4539316256), new Vsop87.LnVsop(5.24E-9, 2.96141918447, 2648.454825473), new Vsop87.LnVsop(4.44E-9, 3.19923402818, 1062.5633239269), new Vsop87.LnVsop(4.04E-9, 1.79288519616, 1485.9801210652), new Vsop87.LnVsop(3.75E-9, 0.79587902858, 838.9692877504), new Vsop87.LnVsop(3.53E-9, 3.34547139217, 199.0720014364), new Vsop87.LnVsop(4.52E-9, 5.08983741758, 846.0828347512), new Vsop87.LnVsop(3.34E-9, 3.04324482994, 551.031606097), new Vsop87.LnVsop(3.66E-9, 1.6889571387, 519.3960243561), new Vsop87.LnVsop(3.94E-9, 1.57570736696, 412.3710968744), new Vsop87.LnVsop(3.01E-9, 3.37032774636, 309.2783226558), new Vsop87.LnVsop(2.91E-9, 2.62531230776, 539.9859058331), new Vsop87.LnVsop(3.25E-9, 0.15647873172, 1574.8458012822), new Vsop87.LnVsop(2.45E-9, 3.25292367144, 1272.6810256272), new Vsop87.LnVsop(2.17E-9, 3.11492452322, 1699.2792165032), new Vsop87.LnVsop(1.84E-9, 1.08716393617, 1478.8665740644), new Vsop87.LnVsop(1.48E-9, 2.68589605205, 440.8252848776), new Vsop87.LnVsop(1.51E-9, 3.55666552483, 227.5261894396), new Vsop87.LnVsop(1.59E-9, 4.5928744136, 3.1813937377), new Vsop87.LnVsop(1.36E-9, 4.84859091336, 1375.7737998458), new Vsop87.LnVsop(1.63E-9, 2.32840480908, 1368.660252845), new Vsop87.LnVsop(1.43E-9, 3.221770954, 1055.4497769261), new Vsop87.LnVsop(1.42E-9, 5.72788361902, 1471.7530270636), new Vsop87.LnVsop(1.58E-9, 4.73812763868, 21.3406410024), new Vsop87.LnVsop(1.28E-9, 2.70021949677, 742.9900605326), new Vsop87.LnVsop(1.39E-9, 1.17163391807, 1056.2005364515), new Vsop87.LnVsop(1.45E-9, 0.86475461158, 2111.6503133776), new Vsop87.LnVsop(1.13E-9, 0.9347585654, 1685.0521225016), new Vsop87.LnVsop(9.2E-10, 6.08486890659, 1038.0412891868), new Vsop87.LnVsop(7.7E-10, 1.76503406298, 1795.258443721), new Vsop87.LnVsop(7.6E-10, 1.81177242528, 2221.856634597), new Vsop87.LnVsop(7.7E-10, 3.87925580596, 1603.2999892854)};
        private static final Vsop87.LnVsop[] jupiter_latitude_b3 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(1.85332E-6, 4.7927676149, 529.6909650946), new Vsop87.LnVsop(8.5668E-7, 1.40023038638, 536.8045120954), new Vsop87.LnVsop(5.6359E-7, 2.81574766965, 522.5774180938), new Vsop87.LnVsop(1.9435E-7, 6.25741008684, 1059.3819301892), new Vsop87.LnVsop(1.0858E-7, 2.04333735353, 1066.49547719), new Vsop87.LnVsop(1.4477E-7, 0.0, 0.0), new Vsop87.LnVsop(5.535E-8, 2.75732372347, 515.463871093), new Vsop87.LnVsop(4.939E-8, 1.29727834284, 543.9180590962), new Vsop87.LnVsop(4.97E-8, 2.56009290021, 1052.2683831884), new Vsop87.LnVsop(4.112E-8, 0.86840480428, 1589.0728952838), new Vsop87.LnVsop(3.798E-8, 2.86619114773, 7.1135470008), new Vsop87.LnVsop(1.107E-8, 2.66033381472, 1596.1864422846), new Vsop87.LnVsop(1.093E-8, 1.82485496219, 1045.1548361876), new Vsop87.LnVsop(1.031E-8, 2.82866669066, 14.2270940016), new Vsop87.LnVsop(4.33E-9, 4.07064796547, 419.4846438752), new Vsop87.LnVsop(4.41E-9, 1.3884926851, 2118.7638603784), new Vsop87.LnVsop(4.27E-9, 1.88306006605, 1073.6090241908), new Vsop87.LnVsop(3.85E-9, 3.4306315526, 110.2063212194), new Vsop87.LnVsop(2.7E-9, 0.28254340737, 942.062061969), new Vsop87.LnVsop(2.82E-9, 2.56588914137, 323.5054166574), new Vsop87.LnVsop(2.81E-9, 1.78450485408, 735.8765135318), new Vsop87.LnVsop(2.5E-9, 3.0124653574, 508.3503240922), new Vsop87.LnVsop(2.18E-9, 2.72492160401, 1581.959348283), new Vsop87.LnVsop(2.1E-9, 0.07248270409, 632.7837393132), new Vsop87.LnVsop(2.25E-9, 3.97044557, 117.3198682202), new Vsop87.LnVsop(2.03E-9, 0.07858321388, 639.897286314), new Vsop87.LnVsop(1.7E-9, 0.89620998933, 1169.5882514086), new Vsop87.LnVsop(1.65E-9, 1.56025270981, 625.6701923124), new Vsop87.LnVsop(1.56E-9, 5.58460103668, 103.0927742186), new Vsop87.LnVsop(1.37E-9, 4.26368918979, 95.9792272178), new Vsop87.LnVsop(1.0E-9, 1.72309553591, 949.1756089698), new Vsop87.LnVsop(9.4E-10, 2.26854098455, 1155.361157407), new Vsop87.LnVsop(8.2E-10, 5.02874146441, 956.2891559706)};
        private static final Vsop87.LnVsop[] jupiter_latitude_b4 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(8.963E-8, 5.9388723238, 536.8045120954), new Vsop87.LnVsop(5.28E-8, 4.80778878768, 522.5774180938), new Vsop87.LnVsop(1.161E-8, 0.46295890438, 1066.49547719), new Vsop87.LnVsop(1.104E-8, 4.53240452495, 515.463871093), new Vsop87.LnVsop(1.087E-8, 5.81789252627, 543.9180590962), new Vsop87.LnVsop(8.18E-9, 1.49293156118, 529.6909650946), new Vsop87.LnVsop(5.95E-9, 4.58881648484, 1059.3819301892), new Vsop87.LnVsop(5.13E-9, 4.57214361679, 1052.2683831884), new Vsop87.LnVsop(1.79E-9, 0.7582126428, 7.1135470008), new Vsop87.LnVsop(1.43E-9, 5.78292264064, 1589.0728952838), new Vsop87.LnVsop(1.35E-9, 1.57382028639, 14.2270940016), new Vsop87.LnVsop(9.6E-10, 1.04662476547, 1596.1864422846), new Vsop87.LnVsop(7.7E-10, 3.5878064157, 1045.1548361876)};
        private static final Vsop87.LnVsop[] jupiter_latitude_b5 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(6.62E-9, 4.10413626462, 536.8045120954), new Vsop87.LnVsop(4.31E-9, 0.82614663721, 522.5774180938), new Vsop87.LnVsop(2.08E-9, 0.05498457769, 515.463871093)};

        Latitude() {
        }
    }

    static class Lontitude {
        private static Vsop87.LnVsop[] jupiter_longitude_l0 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(0.59954691494, 0.0, 0.0), new Vsop87.LnVsop(0.09695898719, 5.06191793158, 529.6909650946), new Vsop87.LnVsop(0.00573610142, 1.44406205629, 7.1135470008), new Vsop87.LnVsop(0.00306389205, 5.41734730184, 1059.3819301892), new Vsop87.LnVsop(9.7178296E-4, 4.14264726552, 632.7837393132), new Vsop87.LnVsop(7.2903078E-4, 3.64042916389, 522.5774180938), new Vsop87.LnVsop(6.4263975E-4, 3.41145165351, 103.0927742186), new Vsop87.LnVsop(3.9806064E-4, 2.29376740788, 419.4846438752), new Vsop87.LnVsop(3.8857767E-4, 1.27231755835, 316.3918696566), new Vsop87.LnVsop(2.7964629E-4, 1.7845459182, 536.8045120954), new Vsop87.LnVsop(1.358973E-4, 5.7748104079, 1589.0728952838), new Vsop87.LnVsop(8.246349E-5, 3.5822792584, 206.1855484372), new Vsop87.LnVsop(8.768704E-5, 3.63000308199, 949.1756089698), new Vsop87.LnVsop(7.368042E-5, 5.0810119427, 735.8765135318), new Vsop87.LnVsop(6.26315E-5, 0.02497628807, 213.299095438), new Vsop87.LnVsop(6.114062E-5, 4.51319998626, 1162.4747044078), new Vsop87.LnVsop(4.905396E-5, 1.32084470588, 110.2063212194), new Vsop87.LnVsop(5.305285E-5, 1.30671216791, 14.2270940016), new Vsop87.LnVsop(5.305441E-5, 4.18625634012, 1052.2683831884), new Vsop87.LnVsop(4.647248E-5, 4.69958103684, 3.9321532631), new Vsop87.LnVsop(3.045023E-5, 4.31676431084, 426.598190876), new Vsop87.LnVsop(2.609999E-5, 1.56667394063, 846.0828347512), new Vsop87.LnVsop(2.028191E-5, 1.06376530715, 3.1813937377), new Vsop87.LnVsop(1.764763E-5, 2.14148655117, 1066.49547719), new Vsop87.LnVsop(1.722972E-5, 3.88036268267, 1265.5674786264), new Vsop87.LnVsop(1.920945E-5, 0.97168196472, 639.897286314), new Vsop87.LnVsop(1.633223E-5, 3.58201833555, 515.463871093), new Vsop87.LnVsop(1.431999E-5, 4.29685556046, 625.6701923124), new Vsop87.LnVsop(9.73272E-6, 4.09764549134, 95.9792272178), new Vsop87.LnVsop(8.84457E-6, 2.43700227469, 412.3710968744), new Vsop87.LnVsop(7.32853E-6, 6.08535124451, 838.9692877504), new Vsop87.LnVsop(7.31094E-6, 3.80592308125, 1581.959348283), new Vsop87.LnVsop(6.91971E-6, 6.13365277914, 2118.7638603784), new Vsop87.LnVsop(7.09166E-6, 1.2927476033, 742.9900605326), new Vsop87.LnVsop(6.14482E-6, 4.10850580886, 1478.8665740644), new Vsop87.LnVsop(4.95219E-6, 3.75564106217, 323.5054166574), new Vsop87.LnVsop(5.81903E-6, 4.53969579398, 309.2783226558), new Vsop87.LnVsop(3.75664E-6, 4.70304250208, 1368.660252845), new Vsop87.LnVsop(3.89876E-6, 4.89706786539, 1692.1656695024), new Vsop87.LnVsop(3.41016E-6, 5.7145237931, 533.6231183577), new Vsop87.LnVsop(3.30458E-6, 4.74049819491, 0.0481841098), new Vsop87.LnVsop(4.40853E-6, 2.95818598959, 454.9093665273), new Vsop87.LnVsop(4.17267E-6, 1.03554397138, 2.4476805548), new Vsop87.LnVsop(2.44174E-6, 5.22024286247, 728.762966531), new Vsop87.LnVsop(2.61541E-6, 1.87652515753, 0.9632078465), new Vsop87.LnVsop(2.56589E-6, 3.72410394286, 199.0720014364), new Vsop87.LnVsop(2.61005E-6, 0.82048379203, 380.12776796), new Vsop87.LnVsop(2.20381E-6, 1.65114584814, 543.9180590962), new Vsop87.LnVsop(2.01991E-6, 1.80692992449, 1375.7737998458), new Vsop87.LnVsop(2.07336E-6, 1.85463683689, 525.7588118315), new Vsop87.LnVsop(1.97061E-6, 5.29255821015, 1155.361157407), new Vsop87.LnVsop(2.35139E-6, 1.22694468346, 909.8187330546), new Vsop87.LnVsop(1.74827E-6, 5.90974976879, 956.2891559706), new Vsop87.LnVsop(1.49385E-6, 4.37744775359, 1685.0521225016), new Vsop87.LnVsop(1.75197E-6, 3.22647697998, 1898.3512179396), new Vsop87.LnVsop(1.75172E-6, 3.7297744122, 942.062061969), new Vsop87.LnVsop(1.57917E-6, 4.36478445901, 1795.258443721), new Vsop87.LnVsop(1.37898E-6, 1.31800455202, 1169.5882514086), new Vsop87.LnVsop(1.17498E-6, 2.50021486074, 1596.1864422846), new Vsop87.LnVsop(1.50504E-6, 3.90624455135, 74.7815985673), new Vsop87.LnVsop(1.16786E-6, 3.3892092106, 0.5212648618), new Vsop87.LnVsop(1.05894E-6, 4.55439354032, 526.5095713569), new Vsop87.LnVsop(1.3054E-6, 4.16876671917, 1045.1548361876), new Vsop87.LnVsop(1.41388E-6, 3.13579930728, 491.5579294568), new Vsop87.LnVsop(9.9524E-7, 1.4211262227, 532.8723588323), new Vsop87.LnVsop(9.6143E-7, 1.18143253105, 117.3198682202), new Vsop87.LnVsop(9.1732E-7, 0.85722451006, 1272.6810256272), new Vsop87.LnVsop(8.7704E-7, 1.2173050435, 453.424893819), new Vsop87.LnVsop(6.8531E-7, 2.3520190589, 2.9207613068), new Vsop87.LnVsop(6.6111E-7, 5.3438096704, 1471.7530270636), new Vsop87.LnVsop(7.7401E-7, 4.42676354183, 39.3568759152), new Vsop87.LnVsop(7.2028E-7, 4.23856425835, 2111.6503133776), new Vsop87.LnVsop(6.3345E-7, 4.97658360088, 0.7507595254), new Vsop87.LnVsop(5.9423E-7, 4.11122034593, 2001.4439921582), new Vsop87.LnVsop(6.2471E-7, 0.51213142347, 220.4126424388), new Vsop87.LnVsop(6.654E-7, 2.98844410276, 2214.7430875962), new Vsop87.LnVsop(6.0295E-7, 4.1263361942, 4.192785694), new Vsop87.LnVsop(5.6014E-7, 1.15477785231, 21.3406410024), new Vsop87.LnVsop(5.2954E-7, 0.91283039851, 10.2949407385), new Vsop87.LnVsop(7.0461E-7, 5.14178006023, 835.0371344873), new Vsop87.LnVsop(5.1903E-7, 4.10065404719, 1258.4539316256), new Vsop87.LnVsop(4.6583E-7, 4.66599487054, 5.6290742925), new Vsop87.LnVsop(5.8261E-7, 5.86719898935, 5753.3848848968), new Vsop87.LnVsop(4.0103E-7, 4.68801114087, 0.1600586944), new Vsop87.LnVsop(4.6785E-7, 4.79414027278, 305.3461693927), new Vsop87.LnVsop(3.9306E-7, 4.2549933801, 853.196381752), new Vsop87.LnVsop(4.6153E-7, 5.10982849847, 4.665866446), new Vsop87.LnVsop(5.4583E-7, 1.5707166354, 983.1158589136), new Vsop87.LnVsop(3.8921E-7, 6.07598407822, 518.6452648307), new Vsop87.LnVsop(3.846E-7, 2.43832240008, 433.7117378768), new Vsop87.LnVsop(4.691E-7, 3.54638837922, 5.4166259714), new Vsop87.LnVsop(4.1834E-7, 4.67980756775, 302.164775655), new Vsop87.LnVsop(3.5921E-7, 2.45088327353, 430.5303441391), new Vsop87.LnVsop(3.9307E-7, 1.71678059616, 11.0457002639), new Vsop87.LnVsop(3.7895E-7, 0.21140086073, 2648.454825473), new Vsop87.LnVsop(3.7566E-7, 6.19479786035, 831.8557407496), new Vsop87.LnVsop(3.5845E-7, 4.61505536309, 2008.557539159), new Vsop87.LnVsop(4.3402E-7, 0.14992219581, 528.2064923863), new Vsop87.LnVsop(3.1581E-7, 5.14178165108, 1788.1448967202), new Vsop87.LnVsop(2.986E-7, 5.34424466576, 2221.856634597), new Vsop87.LnVsop(3.2959E-7, 5.2895264038, 88.865680217), new Vsop87.LnVsop(2.7686E-7, 1.85227036207, 0.2124483211), new Vsop87.LnVsop(2.5821E-7, 3.85920335036, 2317.8358618148), new Vsop87.LnVsop(2.4705E-7, 2.63498818, 114.1384744825), new Vsop87.LnVsop(3.3844E-7, 1.00563073311, 9683.5945811164), new Vsop87.LnVsop(2.4248E-7, 3.82564321484, 1574.8458012822), new Vsop87.LnVsop(2.7111E-7, 2.80845416546, 18.1592472647), new Vsop87.LnVsop(2.6837E-7, 1.77586073782, 532.1386456494), new Vsop87.LnVsop(2.6212E-7, 2.74456887801, 2531.1349572528), new Vsop87.LnVsop(3.0765E-7, 0.42330199069, 1.4844727083), new Vsop87.LnVsop(3.0469E-7, 3.66675723074, 508.3503240922), new Vsop87.LnVsop(2.3191E-7, 3.24511984498, 984.6003316219), new Vsop87.LnVsop(1.9445E-7, 0.52370214464, 14.977853527), new Vsop87.LnVsop(1.9331E-7, 4.85656303715, 1361.5467058442), new Vsop87.LnVsop(2.2889E-7, 3.85009333532, 2428.0421830342), new Vsop87.LnVsop(2.1613E-7, 6.01647014213, 1063.3140834523), new Vsop87.LnVsop(2.0167E-7, 5.59590496803, 527.2432845398), new Vsop87.LnVsop(2.3732E-7, 2.52764898478, 494.2662424425), new Vsop87.LnVsop(2.019E-7, 1.01559114881, 628.8515860501), new Vsop87.LnVsop(1.5994E-7, 5.09003506053, 529.7391492044), new Vsop87.LnVsop(1.6134E-7, 5.27096450385, 142.4496501338), new Vsop87.LnVsop(2.0697E-7, 4.03443555572, 355.7487455718), new Vsop87.LnVsop(2.148E-7, 1.28666873894, 35.4247226521), new Vsop87.LnVsop(1.4981E-7, 4.8611981817, 2104.5367663768), new Vsop87.LnVsop(1.7242E-7, 1.59187221366, 1439.5096981492), new Vsop87.LnVsop(1.5994E-7, 1.89222393849, 529.6427809848), new Vsop87.LnVsop(1.7957E-7, 4.30177741048, 6.1503391543), new Vsop87.LnVsop(1.3287E-7, 2.1896068877, 1055.4497769261), new Vsop87.LnVsop(1.4809E-7, 0.87727524457, 99.1606209555), new Vsop87.LnVsop(1.4148E-7, 2.71597731671, 0.2606324309), new Vsop87.LnVsop(1.4202E-7, 2.41335744746, 530.6541729411), new Vsop87.LnVsop(1.5331E-7, 6.07685758999, 149.5631971346), new Vsop87.LnVsop(1.5832E-7, 4.11682340572, 636.7158925763), new Vsop87.LnVsop(1.6199E-7, 2.77035135003, 760.25553592), new Vsop87.LnVsop(1.2258E-7, 2.61067822838, 405.2575498736), new Vsop87.LnVsop(1.3665E-7, 3.56042954023, 217.2312487011), new Vsop87.LnVsop(1.5261E-7, 2.81823022031, 621.7380390493), new Vsop87.LnVsop(1.468E-7, 6.26419083616, 569.0478410098), new Vsop87.LnVsop(1.2529E-7, 1.39076773846, 7.065362891), new Vsop87.LnVsop(1.1603E-7, 4.60461324892, 7.1617311106), new Vsop87.LnVsop(1.1676E-7, 3.60450719576, 2634.2277314714), new Vsop87.LnVsop(1.2182E-7, 0.24373178668, 1485.9801210652), new Vsop87.LnVsop(1.1352E-7, 2.0081439837, 1073.6090241908), new Vsop87.LnVsop(1.1241E-7, 2.48010676188, 423.4167971383), new Vsop87.LnVsop(1.0942E-7, 5.03605236981, 458.8415197904), new Vsop87.LnVsop(1.1121E-7, 4.04930841517, 519.3960243561), new Vsop87.LnVsop(1.2266E-7, 4.30151937187, 604.4725636619), new Vsop87.LnVsop(1.315E-7, 2.72184449861, 1364.7280995819), new Vsop87.LnVsop(1.0604E-7, 3.11518747071, 1.2720243872), new Vsop87.LnVsop(9.873E-8, 1.70233190646, 1699.2792165032), new Vsop87.LnVsop(1.0828E-7, 5.08717082517, 2324.9494088156), new Vsop87.LnVsop(1.0692E-7, 2.51399278354, 2847.5268269094), new Vsop87.LnVsop(1.2646E-7, 4.755908152, 528.7277572481), new Vsop87.LnVsop(1.0084E-7, 4.05599680401, 38.1330356378), new Vsop87.LnVsop(1.1536E-7, 2.35035142816, 643.8294395771), new Vsop87.LnVsop(1.0218E-7, 3.6581819344, 107.0249274817), new Vsop87.LnVsop(1.0234E-7, 3.63741793836, 2744.4340526908), new Vsop87.LnVsop(1.0105E-7, 1.31344662885, 1905.4647649404), new Vsop87.LnVsop(9.338E-8, 5.92214604272, 1148.2476104062), new Vsop87.LnVsop(8.796E-8, 2.77421597882, 6.592282139), new Vsop87.LnVsop(8.421E-8, 4.52526352162, 1677.9385755008), new Vsop87.LnVsop(1.0128E-7, 2.09031029378, 511.5317178299), new Vsop87.LnVsop(8.28E-8, 2.98793394775, 540.7366653585), new Vsop87.LnVsop(9.753E-8, 1.22443091754, 32.2433289144), new Vsop87.LnVsop(1.0629E-7, 2.07778578633, 92.0470739547), new Vsop87.LnVsop(7.886E-8, 0.99641706679, 408.4389436113), new Vsop87.LnVsop(8.813E-8, 3.4691226487, 1021.2488945514), new Vsop87.LnVsop(7.941E-8, 2.86765260965, 2125.8774073792), new Vsop87.LnVsop(8.575E-8, 5.29585347114, 415.5524906121), new Vsop87.LnVsop(7.841E-8, 6.08025868276, 70.8494453042), new Vsop87.LnVsop(7.706E-8, 1.69807427167, 8.0767548473), new Vsop87.LnVsop(7.265E-8, 4.65479123794, 629.6023455755), new Vsop87.LnVsop(7.163E-8, 4.93237560809, 1056.2005364515), new Vsop87.LnVsop(7.248E-8, 4.61590472787, 2420.9286360334), new Vsop87.LnVsop(7.712E-8, 2.1381857288, 33.9402499438), new Vsop87.LnVsop(6.645E-8, 0.45640663795, 635.9651330509), new Vsop87.LnVsop(9.377E-8, 4.03158387581, 2810.9214616052), new Vsop87.LnVsop(8.221E-8, 1.23649767817, 1802.3719907218), new Vsop87.LnVsop(6.34E-8, 0.07280718454, 202.2533951741), new Vsop87.LnVsop(6.383E-8, 3.54298789012, 1891.2376709388), new Vsop87.LnVsop(7.901E-8, 2.32514375888, 230.5645708254), new Vsop87.LnVsop(6.214E-8, 4.54560345236, 2.7083129857), new Vsop87.LnVsop(7.347E-8, 1.24457591968, 24.3790223882), new Vsop87.LnVsop(7.472E-8, 3.02787419533, 330.6189636582), new Vsop87.LnVsop(6.246E-8, 1.77826735859, 1062.5633239269), new Vsop87.LnVsop(5.674E-8, 5.14130380414, 746.9222137957), new Vsop87.LnVsop(5.855E-8, 5.4212716933, 28.3111756513), new Vsop87.LnVsop(5.629E-8, 3.24347319369, 529.1697002328), new Vsop87.LnVsop(7.653E-8, 0.52812977555, 672.1406152284), new Vsop87.LnVsop(5.456E-8, 3.34715399006, 2950.619601128), new Vsop87.LnVsop(7.127E-8, 1.43485695449, 6.2197751235), new Vsop87.LnVsop(5.388E-8, 4.90171438369, 69.1525242748), new Vsop87.LnVsop(5.608E-8, 4.98112575538, 2641.3412784722), new Vsop87.LnVsop(5.843E-8, 2.95362326688, 490.3340891794), new Vsop87.LnVsop(4.943E-8, 5.37603229206, 721.6494195302), new Vsop87.LnVsop(5.12E-8, 4.85758375369, 31.019488637), new Vsop87.LnVsop(5.163E-8, 5.07430434384, 67.6680515665), new Vsop87.LnVsop(4.738E-8, 6.10247687172, 106.2741679563), new Vsop87.LnVsop(4.879E-8, 0.07093292758, 78.7137518304), new Vsop87.LnVsop(4.854E-8, 5.6387571047, 1.6969210294), new Vsop87.LnVsop(5.629E-8, 3.73870719507, 530.2122299564), new Vsop87.LnVsop(4.471E-8, 4.49152590899, 505.3119427064), new Vsop87.LnVsop(4.313E-8, 4.79367774897, 535.107591066), new Vsop87.LnVsop(4.28E-8, 0.5478382371, 1.4362885985), new Vsop87.LnVsop(4.453E-8, 0.50550043817, 524.0618908021), new Vsop87.LnVsop(4.936E-8, 4.82992128024, 422.6660376129), new Vsop87.LnVsop(4.701E-8, 3.4163231632, 3060.8259223474), new Vsop87.LnVsop(4.261E-8, 2.67050830494, 561.934294009), new Vsop87.LnVsop(4.156E-8, 4.00674305729, 99.9113804809), new Vsop87.LnVsop(4.561E-8, 2.29662333497, 3163.918696566), new Vsop87.LnVsop(4.414E-8, 5.67223937661, 1464.6394800628), new Vsop87.LnVsop(5.27E-8, 3.89098773035, 191.9584544356), new Vsop87.LnVsop(5.344E-8, 0.3150553796, 1289.9465010146), new Vsop87.LnVsop(3.856E-8, 4.28927088609, 1994.3304451574), new Vsop87.LnVsop(4.227E-8, 5.32680781419, 2538.2485042536), new Vsop87.LnVsop(3.968E-8, 4.56799284427, 1382.8873468466), new Vsop87.LnVsop(3.874E-8, 1.56573094048, 647.0108333148), new Vsop87.LnVsop(4.227E-8, 5.51697565211, 5223.6939198022), new Vsop87.LnVsop(4.13E-8, 2.81118299519, 416.3032501375), new Vsop87.LnVsop(3.662E-8, 4.35201972236, 2737.32050569), new Vsop87.LnVsop(3.584E-8, 5.48543989133, 750.1036075334), new Vsop87.LnVsop(4.329E-8, 0.84948546685, 531.1754378029), new Vsop87.LnVsop(4.093E-8, 0.19987691246, 525.0250986486), new Vsop87.LnVsop(3.4E-8, 6.00302355875, 1.2238402774), new Vsop87.LnVsop(3.496E-8, 0.31250621097, 597.3590166611), new Vsop87.LnVsop(3.957E-8, 1.92811865595, 1512.8068240082), new Vsop87.LnVsop(3.299E-8, 4.27641782638, 526.7702037878), new Vsop87.LnVsop(3.218E-8, 2.90660065796, 963.4027029714), new Vsop87.LnVsop(3.15E-8, 3.81062282472, 280.9671470045), new Vsop87.LnVsop(4.129E-8, 4.74946631331, 0.8937718773), new Vsop87.LnVsop(3.84E-8, 1.91064921809, 378.6432952517), new Vsop87.LnVsop(3.057E-8, 1.65588839054, 528.9402055692), new Vsop87.LnVsop(3.011E-8, 1.59274545702, 224.3447957019), new Vsop87.LnVsop(3.197E-8, 5.86630896662, 4.1446015842), new Vsop87.LnVsop(3.628E-8, 0.07910101827, 558.0021407459), new Vsop87.LnVsop(2.932E-8, 0.41424504523, 7.8643065262), new Vsop87.LnVsop(3.316E-8, 2.70210829186, 532.6117264014), new Vsop87.LnVsop(2.925E-8, 4.47579366684, 533.8837507886), new Vsop87.LnVsop(3.688E-8, 0.39899953746, 685.4739373527), new Vsop87.LnVsop(3.224E-8, 2.45813595822, 960.2213092337), new Vsop87.LnVsop(3.059E-8, 5.32615258179, 530.44172462), new Vsop87.LnVsop(3.383E-8, 4.4216688979, 312.4597163935), new Vsop87.LnVsop(3.321E-8, 2.71397444568, 495.7507151508), new Vsop87.LnVsop(2.698E-8, 5.23121581439, 739.8086667949), new Vsop87.LnVsop(3.591E-8, 2.3099570752, 908.3342603463), new Vsop87.LnVsop(2.619E-8, 3.09144103989, 3267.0114707846), new Vsop87.LnVsop(3.567E-8, 5.07207593227, 73.297125859), new Vsop87.LnVsop(2.797E-8, 2.98948711408, 483.2205421786), new Vsop87.LnVsop(3.397E-8, 3.29611266379, 911.3032057629), new Vsop87.LnVsop(3.352E-8, 1.44371985824, 593.426863398), new Vsop87.LnVsop(2.563E-8, 3.35095990562, 2207.6295405954), new Vsop87.LnVsop(2.553E-8, 0.36858603419, 1048.3362299253), new Vsop87.LnVsop(2.621E-8, 3.82783663712, 520.129737539), new Vsop87.LnVsop(3.356E-8, 1.08298579333, 46.470422916), new Vsop87.LnVsop(3.397E-8, 3.83080921477, 210.1177017003), new Vsop87.LnVsop(3.023E-8, 5.52874613382, 618.5566453116), new Vsop87.LnVsop(2.498E-8, 0.47888741754, 945.2434557067), new Vsop87.LnVsop(2.665E-8, 0.49714213041, 1057.8974574809), new Vsop87.LnVsop(2.322E-8, 5.87923753103, 2751.5475996916), new Vsop87.LnVsop(2.587E-8, 0.03759881914, 1.6445314027), new Vsop87.LnVsop(2.901E-8, 2.50012990691, 525.4981794006), new Vsop87.LnVsop(3.153E-8, 2.30879679988, 457.617679513), new Vsop87.LnVsop(2.199E-8, 3.94421228731, 31.492569389), new Vsop87.LnVsop(2.381E-8, 6.19254995974, 327.4375699205), new Vsop87.LnVsop(2.458E-8, 0.65614526486, 9153.9036160218), new Vsop87.LnVsop(2.111E-8, 5.61905648764, 16.4623262353), new Vsop87.LnVsop(2.135E-8, 3.75723920792, 724.8308132679), new Vsop87.LnVsop(2.406E-8, 2.29315638318, 195.1398481733), new Vsop87.LnVsop(2.166E-8, 5.43273753334, 534.3568315406), new Vsop87.LnVsop(2.073E-8, 1.50113866877, 551.031606097), new Vsop87.LnVsop(2.678E-8, 5.06400504512, 456.3938392356), new Vsop87.LnVsop(2.078E-8, 5.28920605515, 76.2660712756), new Vsop87.LnVsop(2.26E-8, 5.38117794868, 1781.0313497194), new Vsop87.LnVsop(2.356E-8, 0.6739707478, 227.5261894396), new Vsop87.LnVsop(2.245E-8, 3.18183437676, 3377.217792004), new Vsop87.LnVsop(2.184E-8, 3.08383961547, 524.2743391232), new Vsop87.LnVsop(2.12E-8, 2.70078368869, 387.2413149608), new Vsop87.LnVsop(2.116E-8, 6.20284849642, 209.3669421749), new Vsop87.LnVsop(2.712E-8, 3.18157742001, 1474.6737883704), new Vsop87.LnVsop(2.127E-8, 1.24322560799, 539.9859058331), new Vsop87.LnVsop(2.034E-8, 4.81691423751, 2957.7331481288), new Vsop87.LnVsop(2.424E-8, 3.57564169482, 953.1077622329), new Vsop87.LnVsop(1.947E-8, 1.94468082531, 529.5309064002), new Vsop87.LnVsop(1.896E-8, 4.01429491115, 2310.722314814), new Vsop87.LnVsop(1.934E-8, 4.10019561108, 3053.7123753466), new Vsop87.LnVsop(2.056E-8, 6.27074172997, 245.5424243524), new Vsop87.LnVsop(2.108E-8, 3.22886421713, 252.6559713532), new Vsop87.LnVsop(2.596E-8, 2.77467288033, 177.8743727859), new Vsop87.LnVsop(1.919E-8, 3.14810072956, 381.6122406683), new Vsop87.LnVsop(2.217E-8, 1.92368906923, 535.9107402181), new Vsop87.LnVsop(1.947E-8, 5.03751779986, 529.851023789), new Vsop87.LnVsop(2.025E-8, 4.82814272957, 17.2654753874), new Vsop87.LnVsop(1.945E-8, 2.10604975291, 3480.3105662226), new Vsop87.LnVsop(1.899E-8, 0.05094358013, 560.7104537316), new Vsop87.LnVsop(2.204E-8, 0.59883534036, 3178.1457905676), new Vsop87.LnVsop(2.271E-8, 1.67327013848, 731.9443602687), new Vsop87.LnVsop(1.706E-8, 5.40277333462, 20.4468691251), new Vsop87.LnVsop(2.292E-8, 4.20486152808, 1038.0412891868), new Vsop87.LnVsop(2.218E-8, 3.65953926062, 282.4516197128), new Vsop87.LnVsop(2.182E-8, 4.87392902929, 535.3200393871), new Vsop87.LnVsop(1.745E-8, 1.34021867874, 25.1297819136), new Vsop87.LnVsop(1.601E-8, 3.9273001584, 17.5261078183), new Vsop87.LnVsop(1.832E-8, 0.31684585935, 124.433415221), new Vsop87.LnVsop(1.651E-8, 0.63598292839, 17.4084877393), new Vsop87.LnVsop(2.041E-8, 0.1561657197, 598.8434893694), new Vsop87.LnVsop(1.494E-8, 3.81397557923, 319.5732633943), new Vsop87.LnVsop(1.55E-8, 5.25207305606, 437.6438911399), new Vsop87.LnVsop(1.852E-8, 2.36130812462, 37.8724032069), new Vsop87.LnVsop(1.466E-8, 1.72925259575, 59.8037450403), new Vsop87.LnVsop(1.443E-8, 1.18211898345, 440.8252848776), new Vsop87.LnVsop(1.417E-8, 5.82294202166, 81.7521332162), new Vsop87.LnVsop(1.404E-8, 0.26052756597, 50.4025761791), new Vsop87.LnVsop(1.906E-8, 4.06896916057, 1819.6374661092), new Vsop87.LnVsop(1.756E-8, 2.32963193021, 938.1299087059), new Vsop87.LnVsop(1.487E-8, 2.2486674654, 10.0343083076), new Vsop87.LnVsop(1.364E-8, 3.5672222202, 1514.2912967165), new Vsop87.LnVsop(1.4E-8, 4.844907356, 295.0512286542), new Vsop87.LnVsop(1.344E-8, 2.20177702106, 529.9034134157), new Vsop87.LnVsop(1.339E-8, 1.16084562282, 2435.155730035), new Vsop87.LnVsop(1.767E-8, 5.45221132569, 2854.6403739102), new Vsop87.LnVsop(1.678E-8, 6.22853454017, 833.552661779), new Vsop87.LnVsop(1.471E-8, 4.80574673735, 696.5196376166), new Vsop87.LnVsop(1.436E-8, 1.45810543491, 537.7677199419), new Vsop87.LnVsop(1.657E-8, 0.02916161564, 138.5174968707), new Vsop87.LnVsop(1.3E-8, 3.14077552949, 547.8502123593), new Vsop87.LnVsop(1.343E-8, 6.14827104783, 988.532484885), new Vsop87.LnVsop(1.244E-8, 2.81685406295, 3583.4033404412), new Vsop87.LnVsop(1.344E-8, 4.78042160411, 529.4785167735), new Vsop87.LnVsop(1.649E-8, 2.12096966866, 1061.829610744), new Vsop87.LnVsop(1.343E-8, 1.43417621076, 1158.5425511447), new Vsop87.LnVsop(1.476E-8, 0.24757783675, 1593.0050485469), new Vsop87.LnVsop(1.413E-8, 3.07444531604, 6283.0758499914), new Vsop87.LnVsop(1.245E-8, 5.94918194719, 1056.9342496344), new Vsop87.LnVsop(1.389E-8, 2.87752350116, 1023.9572075371), new Vsop87.LnVsop(1.263E-8, 3.46181945031, 40.8413486235), new Vsop87.LnVsop(1.325E-8, 4.15426187385, 916.9322800554), new Vsop87.LnVsop(1.193E-8, 1.96467811927, 1969.2006632438), new Vsop87.LnVsop(1.166E-8, 4.65530520965, 944.9828232758), new Vsop87.LnVsop(1.477E-8, 5.26757779384, 810.6581120991), new Vsop87.LnVsop(1.137E-8, 2.48561382158, 2.0057375701), new Vsop87.LnVsop(1.118E-8, 3.80747957482, 7.0016724162), new Vsop87.LnVsop(1.138E-8, 5.11611531676, 885.4397106664), new Vsop87.LnVsop(1.131E-8, 1.54587053613, 775.233389447), new Vsop87.LnVsop(1.477E-8, 4.69745636225, 630.3360587584), new Vsop87.LnVsop(1.252E-8, 1.34285306257, 739.0579072695), new Vsop87.LnVsop(1.446E-8, 5.54999644374, 43.2890291783), new Vsop87.LnVsop(1.273E-8, 5.19038966009, 2097.423219376), new Vsop87.LnVsop(1.101E-8, 4.56980597491, 3274.1250177854), new Vsop87.LnVsop(1.376E-8, 3.61001303649, 415.2918581812), new Vsop87.LnVsop(1.437E-8, 6.22449718728, 155.7829722581), new Vsop87.LnVsop(1.167E-8, 4.09455518613, 203.0041546995), new Vsop87.LnVsop(1.237E-8, 4.41132627005, 292.0128472684), new Vsop87.LnVsop(1.26E-8, 3.0594071141, 1894.4190646765), new Vsop87.LnVsop(1.077E-8, 2.57045229823, 25.2727942655), new Vsop87.LnVsop(1.23E-8, 4.78806138085, 1166.4068576709), new Vsop87.LnVsop(1.02E-8, 3.23608012616, 2524.021410252), new Vsop87.LnVsop(1.341E-8, 0.4926229459, 635.231419868), new Vsop87.LnVsop(1.209E-8, 3.36291805492, 521.6142102473), new Vsop87.LnVsop(1.03E-8, 1.81822316076, 465.9550667912), new Vsop87.LnVsop(1.338E-8, 1.26080837186, 902.7051860538), new Vsop87.LnVsop(1.037E-8, 3.87887112181, 3370.1042450032), new Vsop87.LnVsop(1.224E-8, 0.0927081522, 824.7421937488), new Vsop87.LnVsop(9.91E-9, 4.16587901561, 632.831923423), new Vsop87.LnVsop(1.256E-8, 3.04496727213, 447.7958195265), new Vsop87.LnVsop(9.76E-9, 3.80163486221, 2627.1141844706), new Vsop87.LnVsop(1.049E-8, 2.94996331904, 3693.6096616606), new Vsop87.LnVsop(9.84E-9, 0.98260252064, 632.7355552034), new Vsop87.LnVsop(1.05E-8, 2.20935815967, 7.2254215854), new Vsop87.LnVsop(9.92E-9, 5.41914618009, 1059.430114299), new Vsop87.LnVsop(9.61E-9, 0.87315283345, 544.6688186216), new Vsop87.LnVsop(1.044E-8, 5.63190253364, 732.6951197941), new Vsop87.LnVsop(1.049E-8, 5.81616384906, 26.826702943), new Vsop87.LnVsop(1.162E-8, 0.01265418336, 850.0149880143), new Vsop87.LnVsop(1.11E-8, 3.63236419104, 306.830642101), new Vsop87.LnVsop(1.077E-8, 0.95773741232, 608.404716925), new Vsop87.LnVsop(1.285E-8, 4.22955322265, 1215.1649024473), new Vsop87.LnVsop(1.06E-8, 3.85856786258, 631.8205314667), new Vsop87.LnVsop(1.165E-8, 3.50653563773, 8.5980197091), new Vsop87.LnVsop(9.32E-9, 4.62514414355, 1049.0869894507), new Vsop87.LnVsop(1.243E-8, 6.16316972773, 462.0229135281), new Vsop87.LnVsop(1.035E-8, 1.30805281638, 633.7469471597), new Vsop87.LnVsop(1.238E-8, 2.21195391602, 25558.2121764796), new Vsop87.LnVsop(1.24E-8, 2.27960685992, 6.9010986797), new Vsop87.LnVsop(9.41E-9, 4.14573950731, 945.9942152321), new Vsop87.LnVsop(9.27E-9, 6.10893117621, 514.7131115676), new Vsop87.LnVsop(9.14E-9, 6.17641484462, 952.3570027075), new Vsop87.LnVsop(8.93E-9, 4.27448748055, 0.6331394464), new Vsop87.LnVsop(9.03E-9, 1.94322862741, 3796.7024358792), new Vsop87.LnVsop(1.162E-8, 5.51229668479, 2.9689454166), new Vsop87.LnVsop(1.042E-8, 1.65853884324, 565.1156877467), new Vsop87.LnVsop(9.01E-9, 3.035669957, 460.5384408198), new Vsop87.LnVsop(9.03E-9, 2.24012900198, 523.5406259403), new Vsop87.LnVsop(1.063E-8, 0.99370930422, 320.3240229197), new Vsop87.LnVsop(9.7E-9, 4.56604202702, 429.0458714308), new Vsop87.LnVsop(1.07E-8, 4.33159520959, 610.6923387854), new Vsop87.LnVsop(8.61E-9, 2.82160166871, 1060.3451380357), new Vsop87.LnVsop(8.82E-9, 4.8000859872, 384.0599212231), new Vsop87.LnVsop(9.59E-9, 5.45446729951, 451.9404211107), new Vsop87.LnVsop(1.042E-8, 5.79270367192, 303.8616966844), new Vsop87.LnVsop(8.54E-9, 0.32316261535, 1098.7388061044), new Vsop87.LnVsop(7.84E-9, 1.85121094914, 313.2104759189), new Vsop87.LnVsop(7.82E-9, 3.03559242565, 5.8415226136), new Vsop87.LnVsop(1.051E-8, 1.41051789534, 72.0732855816), new Vsop87.LnVsop(8.54E-9, 1.22328398267, 611.4430983108), new Vsop87.LnVsop(8.99E-9, 5.32174286122, 3171.0322435668), new Vsop87.LnVsop(9.91E-9, 2.22133552179, 1059.3337460794), new Vsop87.LnVsop(7.19E-9, 4.9255025132, 421.93232443), new Vsop87.LnVsop(9.54E-9, 3.98272904231, 836.5216071956), new Vsop87.LnVsop(8.22E-9, 4.4968055764, 10213.285546211), new Vsop87.LnVsop(7.15E-9, 4.62515255534, 385.5443939314), new Vsop87.LnVsop(7.3E-9, 1.87143496079, 153.4953503977), new Vsop87.LnVsop(7.08E-9, 2.93048853593, 417.0369633204), new Vsop87.LnVsop(8.64E-9, 3.03246422011, 1041.2226829245), new Vsop87.LnVsop(7.08E-9, 6.01601101389, 395.105621487), new Vsop87.LnVsop(9.35E-9, 6.01864688839, 173.9422195228), new Vsop87.LnVsop(6.95E-9, 1.39408383356, 432.0148168474), new Vsop87.LnVsop(6.87E-9, 3.06548397571, 529.9515975255), new Vsop87.LnVsop(6.79E-9, 2.18654815982, 2228.9701815978), new Vsop87.LnVsop(8.02E-9, 0.83949166659, 1261.6353253633), new Vsop87.LnVsop(6.77E-9, 3.58329228033, 244.318584075), new Vsop87.LnVsop(8.5E-9, 5.46114025921, 41.0537969446), new Vsop87.LnVsop(8.17E-9, 4.65313917851, 535.8413042489), new Vsop87.LnVsop(6.52E-9, 0.44220736244, 1201.831580323), new Vsop87.LnVsop(7.11E-9, 0.96230448675, 373.0142209592), new Vsop87.LnVsop(6.65E-9, 1.03244633471, 623.2225117576), new Vsop87.LnVsop(7.43E-9, 2.79188326958, 1173.5204046717), new Vsop87.LnVsop(6.43E-9, 5.05336021072, 522.6256022036), new Vsop87.LnVsop(6.39E-9, 4.22718483639, 25.8634950965), new Vsop87.LnVsop(8.46E-9, 3.26302783028, 1151.4290041439), new Vsop87.LnVsop(7.15E-9, 5.07610655676, 1058.4187223427), new Vsop87.LnVsop(8.33E-9, 1.49468358374, 563.6312150384), new Vsop87.LnVsop(7.6E-9, 4.34851471971, 100.6450936638), new Vsop87.LnVsop(7.81E-9, 3.58209400202, 2281.2304965106), new Vsop87.LnVsop(6.33E-9, 6.23841236159, 679.2541622292), new Vsop87.LnVsop(8.79E-9, 1.69353525086, 1744.8558675419), new Vsop87.LnVsop(6.33E-9, 4.31803237654, 3590.516887442), new Vsop87.LnVsop(6.51E-9, 2.45318135806, 1585.1407420207), new Vsop87.LnVsop(6.18E-9, 2.6817879476, 3899.7952100978), new Vsop87.LnVsop(6.46E-9, 2.88581188015, 13.4933808187), new Vsop87.LnVsop(7.31E-9, 5.86652105139, 501.3797894433), new Vsop87.LnVsop(6.44E-9, 4.64527687663, 1134.1635287565), new Vsop87.LnVsop(6.51E-9, 0.83706409863, 2015.6710861598), new Vsop87.LnVsop(7.96E-9, 5.36663489938, 420.9691165835), new Vsop87.LnVsop(6.41E-9, 4.7653372527, 567.8240007324), new Vsop87.LnVsop(8.02E-9, 5.79880803733, 981.6313862053), new Vsop87.LnVsop(7.64E-9, 5.05232912435, 827.9235874865), new Vsop87.LnVsop(6.04E-9, 5.11227651497, 1159.2933106701), new Vsop87.LnVsop(7.45E-9, 1.80925868883, 2332.0629558164), new Vsop87.LnVsop(6.66E-9, 2.06624389616, 27.0873353739), new Vsop87.LnVsop(5.59E-9, 0.1754022493, 63.7358983034), new Vsop87.LnVsop(6.54E-9, 4.94087804792, 2413.8150890326), new Vsop87.LnVsop(7.27E-9, 1.05835550856, 490.0734567485), new Vsop87.LnVsop(7.32E-9, 5.93179840659, 42.5382696529), new Vsop87.LnVsop(5.73E-9, 3.61521168878, 3686.4961146598), new Vsop87.LnVsop(6.33E-9, 4.21755652519, 166.828672522), new Vsop87.LnVsop(6.87E-9, 3.91671464947, 529.4303326637), new Vsop87.LnVsop(5.7E-9, 2.73603650313, 4010.0015313172), new Vsop87.LnVsop(6.0E-9, 1.82660431776, 522.529233984), new Vsop87.LnVsop(5.51E-9, 5.08473283991, 1354.4331588434), new Vsop87.LnVsop(5.19E-9, 6.11952999304, 366.7944458357), new Vsop87.LnVsop(7.19E-9, 0.85722557203, 362.8622925726), new Vsop87.LnVsop(5.18E-9, 2.03954063338, 418.5214360287), new Vsop87.LnVsop(5.15E-9, 3.51750445096, 528.4189407074), new Vsop87.LnVsop(5.15E-9, 3.47893153369, 103.1409583284), new Vsop87.LnVsop(5.5E-9, 5.77676837013, 420.4478517217), new Vsop87.LnVsop(5.5E-9, 0.61414019478, 104.0559820651), new Vsop87.LnVsop(4.95E-9, 2.41738200479, 179.3588454942), new Vsop87.LnVsop(5.13E-9, 0.29786764002, 103.0445901088), new Vsop87.LnVsop(5.37E-9, 5.47946247228, 771.3012361839), new Vsop87.LnVsop(5.08E-9, 3.08930305232, 1357.6145525811), new Vsop87.LnVsop(4.95E-9, 4.95361665264, 536.8526962052), new Vsop87.LnVsop(6.81E-9, 4.56250434221, 112.6540017742), new Vsop87.LnVsop(4.84E-9, 0.79038835602, 28.4541880032), new Vsop87.LnVsop(5.29E-9, 5.469785, 419.4364597654), new Vsop87.LnVsop(5.96E-9, 4.98134265245, 1251.3403846248), new Vsop87.LnVsop(4.82E-9, 3.60230884794, 2943.5060541272), new Vsop87.LnVsop(4.92E-9, 3.95966654574, 1269.4996318895), new Vsop87.LnVsop(6.3E-9, 6.16456074704, 105.5404547734), new Vsop87.LnVsop(4.8E-9, 0.86786400621, 35.212274331), new Vsop87.LnVsop(4.63E-9, 3.15421544338, 934.9485149682), new Vsop87.LnVsop(5.86E-9, 5.48425579444, 56.6223513026), new Vsop87.LnVsop(4.75E-9, 2.28309287464, 2042.4977891028), new Vsop87.LnVsop(5.02E-9, 1.43671788962, 469.8872200543), new Vsop87.LnVsop(5.65E-9, 1.90952569252, 107.2855599126), new Vsop87.LnVsop(4.67E-9, 2.35119921534, 1603.2999892854), new Vsop87.LnVsop(4.64E-9, 3.82801546235, 1550.939859646), new Vsop87.LnVsop(6.05E-9, 1.65413715574, 761.7400086283), new Vsop87.LnVsop(4.43E-9, 5.46290368791, 135.336103133), new Vsop87.LnVsop(5.8E-9, 2.06327501551, 493.0424021651), new Vsop87.LnVsop(5.4E-9, 1.73777056143, 536.7563279856), new Vsop87.LnVsop(4.33E-9, 0.27166977225, 93.531546663), new Vsop87.LnVsop(5.15E-9, 3.46469417422, 530.9629894818), new Vsop87.LnVsop(4.41E-9, 5.28940184186, 497.4476361802), new Vsop87.LnVsop(4.87E-9, 5.78767525063, 12036.4607348882), new Vsop87.LnVsop(5.71E-9, 3.71223026143, 1279.794572628), new Vsop87.LnVsop(4.19E-9, 3.43816729207, 1070.4276304531), new Vsop87.LnVsop(4.52E-9, 2.5785523231, 1254.5217783625), new Vsop87.LnVsop(4.26E-9, 3.21103415941, 2840.4132799086), new Vsop87.LnVsop(4.14E-9, 1.54298025443, 115.6229471908), new Vsop87.LnVsop(4.24E-9, 0.12594305292, 1268.7488723641), new Vsop87.LnVsop(4.11E-9, 3.12423996609, 536.2832472336), new Vsop87.LnVsop(4.52E-9, 1.00220432453, 113.3877149571), new Vsop87.LnVsop(4.2E-9, 0.81806831366, 1165.6560981455), new Vsop87.LnVsop(4.34E-9, 0.36146452053, 1304.9243545416), new Vsop87.LnVsop(4.01E-9, 5.70119897835, 1127.0499817557), new Vsop87.LnVsop(4.61E-9, 3.26463688117, 102.1295663721), new Vsop87.LnVsop(5.33E-9, 2.54951538277, 141.2258098564), new Vsop87.LnVsop(4.13E-9, 4.38709867977, 6151.533888305), new Vsop87.LnVsop(4.25E-9, 3.93823979711, 561.1835344836), new Vsop87.LnVsop(3.9E-9, 2.68799663827, 576.1613880106), new Vsop87.LnVsop(4.73E-9, 4.76746213122, 277.0349937414), new Vsop87.LnVsop(4.15E-9, 1.68861617904, 391.1734682239), new Vsop87.LnVsop(3.92E-9, 3.96583998204, 3906.9087570986), new Vsop87.LnVsop(3.85E-9, 1.69122429631, 4113.0943055358), new Vsop87.LnVsop(4.51E-9, 5.49097711996, 602.9880909536), new Vsop87.LnVsop(4.99E-9, 3.80738289142, 81.0013736908), new Vsop87.LnVsop(4.54E-9, 0.1097588141, 600.5404103988), new Vsop87.LnVsop(3.77E-9, 6.25455256536, 913.7508863177), new Vsop87.LnVsop(4.53E-9, 3.86104865566, 758.7710632117), new Vsop87.LnVsop(4.07E-9, 5.13475793028, 3487.4241132234), new Vsop87.LnVsop(4.0E-9, 4.44473187959, 990.2294059144), new Vsop87.LnVsop(4.35E-9, 3.76103015832, 523.0986829556), new Vsop87.LnVsop(3.65E-9, 5.16456643007, 4694.0029547076), new Vsop87.LnVsop(4.54E-9, 1.63326913717, 976.0023119128), new Vsop87.LnVsop(4.06E-9, 2.72098337513, 1438.0252254409), new Vsop87.LnVsop(3.49E-9, 3.59598547445, 1058.8606653274), new Vsop87.LnVsop(3.54E-9, 0.6208384152, 498.6714764576), new Vsop87.LnVsop(3.83E-9, 5.09228018194, 539.2521926502), new Vsop87.LnVsop(4.3E-9, 6.1434104713, 3067.9394693482), new Vsop87.LnVsop(3.91E-9, 3.2518505126, 2655.5683724738), new Vsop87.LnVsop(4.59E-9, 3.43896606345, 121.2520214833), new Vsop87.LnVsop(4.35E-9, 3.59822556033, 860.3099287528), new Vsop87.LnVsop(4.24E-9, 4.72908722432, 1366.2125722902), new Vsop87.LnVsop(3.27E-9, 4.55290845875, 1696.0978227655), new Vsop87.LnVsop(3.24E-9, 4.23685005208, 642.3449668688), new Vsop87.LnVsop(3.95E-9, 3.26281926074, 484.444382456), new Vsop87.LnVsop(3.3E-9, 6.05223507989, 215.7467759928), new Vsop87.LnVsop(4.17E-9, 0.2026293662, 842.9014410135), new Vsop87.LnVsop(4.08E-9, 0.45802341103, 1578.0271950199), new Vsop87.LnVsop(3.42E-9, 6.1534617983, 1371.8416465827), new Vsop87.LnVsop(3.4E-9, 2.77813018312, 3.523118349), new Vsop87.LnVsop(3.63E-9, 4.68453721321, 2730.2069586892), new Vsop87.LnVsop(3.09E-9, 1.97341771897, 754.0357607965), new Vsop87.LnVsop(3.24E-9, 0.32544817254, 586.3133163972), new Vsop87.LnVsop(3.02E-9, 2.08708848834, 526.9826521089), new Vsop87.LnVsop(3.52E-9, 5.13897382364, 523.4711899711), new Vsop87.LnVsop(3.52E-9, 5.75014912811, 806.725958836), new Vsop87.LnVsop(3.09E-9, 2.49798852626, 4326.3934009738), new Vsop87.LnVsop(2.95E-9, 2.35354744096, 4216.1870797544), new Vsop87.LnVsop(3.0E-9, 1.17310114418, 700.4517908797), new Vsop87.LnVsop(3.35E-9, 4.47490824488, 1585.8915015461), new Vsop87.LnVsop(3.0E-9, 4.94243905681, 1379.7059531089), new Vsop87.LnVsop(3.24E-9, 4.32475054774, 299.1263942692), new Vsop87.LnVsop(4.02E-9, 2.0461963046, 842.1506814881), new Vsop87.LnVsop(3.12E-9, 4.59043534747, 188.9200730498), new Vsop87.LnVsop(2.88E-9, 2.25534557761, 878.3261636656), new Vsop87.LnVsop(3.95E-9, 5.99139284997, 3384.3313390048), new Vsop87.LnVsop(3.8E-9, 1.67961592499, 36.6485629295), new Vsop87.LnVsop(3.38E-9, 1.32019124492, 148.0787244263), new Vsop87.LnVsop(3.91E-9, 4.8218876638, 1012.9115072732), new Vsop87.LnVsop(3.32E-9, 2.02575723995, 1091.6252591036), new Vsop87.LnVsop(2.82E-9, 0.39153852422, 207.6700211455), new Vsop87.LnVsop(2.8E-9, 3.80317669283, 298.2326223919), new Vsop87.LnVsop(3.86E-9, 6.2677115054, 1141.1340634054), new Vsop87.LnVsop(2.93E-9, 4.53809139767, 1446.62324515), new Vsop87.LnVsop(3.49E-9, 4.09122089564, 1059.903195051), new Vsop87.LnVsop(3.01E-9, 4.46304798246, 1567.7322542814), new Vsop87.LnVsop(3.18E-9, 5.50558184307, 5216.5803728014), new Vsop87.LnVsop(3.27E-9, 4.76582526444, 134.5853436076), new Vsop87.LnVsop(2.8E-9, 2.1653066999, 2964.8466951296), new Vsop87.LnVsop(2.83E-9, 3.90409016441, 127.4717966068), new Vsop87.LnVsop(2.75E-9, 0.88658304766, 1474.9344208013), new Vsop87.LnVsop(3.22E-9, 2.48245791694, 1065.6017053127), new Vsop87.LnVsop(3.6E-9, 0.62008772137, 1542.6024723678), new Vsop87.LnVsop(2.86E-9, 5.85849625329, 172.2452984934), new Vsop87.LnVsop(2.7E-9, 4.08297977357, 1578.7779545453), new Vsop87.LnVsop(3.62E-9, 1.06148806683, 181.806526049), new Vsop87.LnVsop(3.35E-9, 4.50997684981, 2349.3284312038), new Vsop87.LnVsop(2.75E-9, 3.38473535401, 4002.8879843164), new Vsop87.LnVsop(3.15E-9, 3.68770155844, 1440.9941708575), new Vsop87.LnVsop(2.52E-9, 2.4066300408, 97.6761482472), new Vsop87.LnVsop(2.79E-9, 5.2241034068, 4649.8988176312), new Vsop87.LnVsop(2.9E-9, 0.61661476278, 9146.790069021), new Vsop87.LnVsop(2.48E-9, 4.45243005934, 1688.9842757647), new Vsop87.LnVsop(3.0E-9, 3.07432010319, 1902.2833712027), new Vsop87.LnVsop(2.92E-9, 2.7017003915, 987.3086446076), new Vsop87.LnVsop(2.58E-9, 4.79343588315, 1670.8250285), new Vsop87.LnVsop(3.19E-9, 1.34244131618, 1288.4620283063), new Vsop87.LnVsop(2.56E-9, 3.45257813604, 3259.8979237838), new Vsop87.LnVsop(3.25E-9, 5.57785413832, 1670.0742689746), new Vsop87.LnVsop(2.48E-9, 4.23500945233, 849.2642284889), new Vsop87.LnVsop(2.78E-9, 0.25405518415, 874.3940104025), new Vsop87.LnVsop(2.99E-9, 4.67059404038, 1329.3033769298), new Vsop87.LnVsop(2.95E-9, 5.86995680986, 2804.2377977311), new Vsop87.LnVsop(3.28E-9, 6.06415193771, 1821.1219388175), new Vsop87.LnVsop(2.45E-9, 4.68144067248, 77204.32749453338), new Vsop87.LnVsop(2.37E-9, 4.97805954611, 351.8165923087), new Vsop87.LnVsop(3.02E-9, 1.20236584617, 232.0490435337), new Vsop87.LnVsop(3.03E-9, 5.533643832, 2274.5468326365), new Vsop87.LnVsop(2.86E-9, 2.41146391401, 2545.3620512544), new Vsop87.LnVsop(2.33E-9, 1.50676309691, 1688.2335162393), new Vsop87.LnVsop(2.5E-9, 2.31712160522, 632.2624744514), new Vsop87.LnVsop(2.38E-9, 5.06850996242, 3803.81598288), new Vsop87.LnVsop(2.27E-9, 6.27454357025, 1586.625214729), new Vsop87.LnVsop(2.26E-9, 0.05894638117, 1518.2234499796), new Vsop87.LnVsop(2.59E-9, 3.86479264667, 782.3469364478), new Vsop87.LnVsop(2.35E-9, 0.16574304942, 137.0330241624), new Vsop87.LnVsop(2.25E-9, 2.32024197535, 2498.8916283384), new Vsop87.LnVsop(2.24E-9, 6.18923621853, 546.1532913299), new Vsop87.LnVsop(2.24E-9, 3.37553489276, 1077.5411774539), new Vsop87.LnVsop(2.22E-9, 1.23639175728, 513.2286388593), new Vsop87.LnVsop(2.46E-9, 2.81685819136, 633.305004175), new Vsop87.LnVsop(2.86E-9, 5.08443662064, 774.0095491696), new Vsop87.LnVsop(2.69E-9, 4.93013868827, 151.0476698429), new Vsop87.LnVsop(2.76E-9, 5.42875443749, 986.0848043302), new Vsop87.LnVsop(2.39E-9, 0.71912390253, 1276.6131788903), new Vsop87.LnVsop(2.81E-9, 0.54377467623, 2122.6960136415), new Vsop87.LnVsop(2.18E-9, 2.90308501961, 85.8272988312), new Vsop87.LnVsop(2.21E-9, 0.99955195094, 1053.7528558967), new Vsop87.LnVsop(2.83E-9, 6.28058228271, 71.8126531507), new Vsop87.LnVsop(2.71E-9, 6.01605176699, 170.7608257851), new Vsop87.LnVsop(2.15E-9, 5.76717651257, 208.633228992), new Vsop87.LnVsop(2.28E-9, 1.19429336725, 1060.8664028975), new Vsop87.LnVsop(2.64E-9, 3.93467981347, 1363.2436268736), new Vsop87.LnVsop(2.28E-9, 5.04184148954, 1064.7985561606), new Vsop87.LnVsop(2.95E-9, 2.15253083015, 6386.16862421), new Vsop87.LnVsop(2.17E-9, 3.24577492609, 2424.1100297711), new Vsop87.LnVsop(2.36E-9, 4.50018016828, 24498.8302462904), new Vsop87.LnVsop(2.11E-9, 4.25651045434, 5069.3834615064), new Vsop87.LnVsop(2.64E-9, 5.8167635951, 77.962992305), new Vsop87.LnVsop(2.56E-9, 5.65979495257, 799.6124118352), new Vsop87.LnVsop(2.1E-9, 5.29881111973, 1457.525933062), new Vsop87.LnVsop(2.08E-9, 5.72006005477, 1064.0477966352), new Vsop87.LnVsop(2.41E-9, 6.25063055391, 1621.3162241982), new Vsop87.LnVsop(2.35E-9, 2.2069104929, 1570.9136480191), new Vsop87.LnVsop(2.12E-9, 2.88214546012, 1674.0064222377), new Vsop87.LnVsop(2.06E-9, 1.59586698276, 4429.4861751924), new Vsop87.LnVsop(2.06E-9, 3.37322544845, 1053.9653042178), new Vsop87.LnVsop(2.5E-9, 4.49171024387, 1482.7987273275), new Vsop87.LnVsop(2.13E-9, 0.30373351265, 8624.2126509272), new Vsop87.LnVsop(2.23E-9, 4.8841887481, 1035.002907801), new Vsop87.LnVsop(2.12E-9, 4.20492282875, 1912.5783119412), new Vsop87.LnVsop(2.71E-9, 5.11992121116, 1818.1529934009), new Vsop87.LnVsop(2.1E-9, 4.08825553401, 203.7378678824), new Vsop87.LnVsop(2.83E-9, 1.89231830584, 313.9441891018), new Vsop87.LnVsop(2.58E-9, 1.73501688448, 1887.3055176757), new Vsop87.LnVsop(2.48E-9, 2.14407705659, 1592.2542890215), new Vsop87.LnVsop(2.1E-9, 4.52024390322, 1262.3860848887), new Vsop87.LnVsop(2.52E-9, 5.69246926803, 104.5772469269), new Vsop87.LnVsop(2.19E-9, 2.91834170224, 2114.8317071153), new Vsop87.LnVsop(1.99E-9, 3.93816217381, 2043.9822618111), new Vsop87.LnVsop(2.04E-9, 4.76593693079, 812.1425848074), new Vsop87.LnVsop(2.07E-9, 0.25148913797, 533.8355666788), new Vsop87.LnVsop(2.15E-9, 2.01665842348, 512.4254897072), new Vsop87.LnVsop(2.04E-9, 0.90117975859, 1408.0171287602), new Vsop87.LnVsop(2.25E-9, 1.23997208583, 3340.6124266998), new Vsop87.LnVsop(2.11E-9, 5.13548160002, 1065.0110044817), new Vsop87.LnVsop(2.58E-9, 2.36055913266, 2861.753920911), new Vsop87.LnVsop(1.98E-9, 4.32566984621, 269.9214467406), new Vsop87.LnVsop(2.02E-9, 3.19887703276, 1553.6481726317), new Vsop87.LnVsop(1.94E-9, 2.6201325208, 683.1863154923), new Vsop87.LnVsop(2.17E-9, 5.40943412253, 546.956440482), new Vsop87.LnVsop(2.08E-9, 0.06358383719, 991.7138786227), new Vsop87.LnVsop(2.67E-9, 3.27705006018, 5120.6011455836), new Vsop87.LnVsop(1.91E-9, 0.70424277574, 4230.414173756), new Vsop87.LnVsop(2.0E-9, 2.35014426129, 1591.5205758386), new Vsop87.LnVsop(2.14E-9, 6.15608452028, 951.6232895246), new Vsop87.LnVsop(1.94E-9, 1.60798799495, 102.5715093568), new Vsop87.LnVsop(2.34E-9, 4.9389588495, 1443.4418514123), new Vsop87.LnVsop(1.98E-9, 0.93365862986, 1909.3969182035), new Vsop87.LnVsop(1.85E-9, 4.0326470482, 1049.8207026336), new Vsop87.LnVsop(2.15E-9, 0.97603524748, 479.2883889155), new Vsop87.LnVsop(2.45E-9, 2.99717870481, 1467.8208738005), new Vsop87.LnVsop(2.57E-9, 4.70227238723, 9050.8108418032), new Vsop87.LnVsop(1.83E-9, 2.03870101784, 635.70450062), new Vsop87.LnVsop(2.28E-9, 6.23410947014, 64.9597385808), new Vsop87.LnVsop(1.8E-9, 4.21309134581, 143.9341228421), new Vsop87.LnVsop(1.8E-9, 4.82872225059, 1063.5747158832), new Vsop87.LnVsop(1.8E-9, 5.06126965624, 52.6901980395), new Vsop87.LnVsop(2.26E-9, 0.55335289468, 554.0699874828), new Vsop87.LnVsop(2.09E-9, 5.67975843693, 48.7580447764), new Vsop87.LnVsop(1.86E-9, 3.66359750257, 108.7218485111), new Vsop87.LnVsop(1.9E-9, 2.00836664877, 1058.6311706638), new Vsop87.LnVsop(1.8E-9, 1.44709940248, 970.5162499722), new Vsop87.LnVsop(1.83E-9, 3.1735846422, 140.9651774255), new Vsop87.LnVsop(1.75E-9, 3.79284463842, 4223.3006267552), new Vsop87.LnVsop(2.2E-9, 2.43555893039, 419.532827985), new Vsop87.LnVsop(1.72E-9, 3.04802064781, 54.3347294422), new Vsop87.LnVsop(1.76E-9, 3.77033437497, 3473.1970192218), new Vsop87.LnVsop(1.7E-9, 4.66517108448, 1372.5924061081), new Vsop87.LnVsop(1.78E-9, 3.08366669427, 4319.279853973), new Vsop87.LnVsop(1.98E-9, 0.42731863655, 857.1285350151), new Vsop87.LnVsop(2.15E-9, 0.68265759605, 1054.7160637432), new Vsop87.LnVsop(1.74E-9, 0.85388069641, 1587.5884225755), new Vsop87.LnVsop(2.12E-9, 5.41318500564, 9580.5018068978), new Vsop87.LnVsop(2.0E-9, 1.60275119026, 6681.2248533996), new Vsop87.LnVsop(1.93E-9, 2.13003457583, 103.6140390804), new Vsop87.LnVsop(1.8E-9, 4.48952373198, 1144.3154571431), new Vsop87.LnVsop(1.65E-9, 4.54343649149, 1365.4788591073), new Vsop87.LnVsop(2.11E-9, 1.53402733679, 1069.6768709277), new Vsop87.LnVsop(2.23E-9, 0.11650319998, 67.8804998876), new Vsop87.LnVsop(2.02E-9, 0.3552732997, 1090.4014188262), new Vsop87.LnVsop(2.18E-9, 3.57295707203, 906.849787638), new Vsop87.LnVsop(1.64E-9, 1.06674687948, 594.6507036754), new Vsop87.LnVsop(1.75E-9, 2.36532854682, 977.4867846211), new Vsop87.LnVsop(2.08E-9, 0.69348288097, 1128.534454464), new Vsop87.LnVsop(1.71E-9, 5.7445839182, 1884.124123938), new Vsop87.LnVsop(1.61E-9, 0.85437052339, 537.5552716208), new Vsop87.LnVsop(2.07E-9, 0.49276008455, 71.6002048296), new Vsop87.LnVsop(1.56E-9, 5.14834108268, 451.7279727896), new Vsop87.LnVsop(1.59E-9, 5.37530499642, 20426.571092422), new Vsop87.LnVsop(1.7E-9, 1.78813796184, 5230.807466803), new Vsop87.LnVsop(2.18E-9, 0.2787548627, 175.1660598002), new Vsop87.LnVsop(2.15E-9, 1.88254208749, 1140.38330388), new Vsop87.LnVsop(2.09E-9, 3.5491731719, 3156.8051495652), new Vsop87.LnVsop(1.71E-9, 1.79628112458, 1123.1178284926), new Vsop87.LnVsop(1.88E-9, 5.24747110812, 25565.3257234804), new Vsop87.LnVsop(2.14E-9, 3.66925552525, 84.9335269539), new Vsop87.LnVsop(2.03E-9, 2.83619345048, 1489.9122743283), new Vsop87.LnVsop(1.73E-9, 4.34546063838, 3046.5988283458), new Vsop87.LnVsop(1.51E-9, 1.16342049906, 3914.0223040994), new Vsop87.LnVsop(1.9E-9, 5.67865609408, 1060.1326897146), new Vsop87.LnVsop(1.67E-9, 0.53874364357, 528.0464336919), new Vsop87.LnVsop(2.03E-9, 0.70565787834, 498.1983957056), new Vsop87.LnVsop(1.71E-9, 4.21009295927, 946.727928415), new Vsop87.LnVsop(2.05E-9, 3.05470007095, 1062.302691496), new Vsop87.LnVsop(2.03E-9, 3.28866933881, 1020.025054274), new Vsop87.LnVsop(1.79E-9, 2.14335011927, 627.3671133418), new Vsop87.LnVsop(1.83E-9, 2.35011338194, 25551.09862947879), new Vsop87.LnVsop(1.62E-9, 1.58054653744, 628.5909536192), new Vsop87.LnVsop(1.45E-9, 1.33045199323, 821.703812363), new Vsop87.LnVsop(1.81E-9, 2.85483720271, 1055.1891444952), new Vsop87.LnVsop(1.51E-9, 3.43200492547, 629.8629780064), new Vsop87.LnVsop(1.78E-9, 3.58994989047, 2004.364753465), new Vsop87.LnVsop(1.57E-9, 3.15195765206, 1025.4416802454), new Vsop87.LnVsop(1.42E-9, 4.7945854735, 1799.1905969841), new Vsop87.LnVsop(1.62E-9, 4.86173373432, 441.576044403), new Vsop87.LnVsop(1.85E-9, 3.21794429243, 1595.2926704073), new Vsop87.LnVsop(1.39E-9, 0.89228489209, 1432.3961511484), new Vsop87.LnVsop(1.67E-9, 2.85163037043, 5746.271337896), new Vsop87.LnVsop(1.67E-9, 5.73970232471, 5760.4984318976), new Vsop87.LnVsop(1.8E-9, 3.5654717039, 3185.2593375684), new Vsop87.LnVsop(1.51E-9, 2.13306499259, 1094.8066528413), new Vsop87.LnVsop(1.81E-9, 3.32294686175, 229.0800981171), new Vsop87.LnVsop(1.6E-9, 1.05753894323, 1087.6931058405), new Vsop87.LnVsop(1.65E-9, 3.51478084503, 707.5653378805), new Vsop87.LnVsop(1.34E-9, 1.82354002117, 5591.9608796002), new Vsop87.LnVsop(1.53E-9, 0.36221123982, 835.7878940127), new Vsop87.LnVsop(1.49E-9, 5.48394113995, 4333.5069479746), new Vsop87.LnVsop(1.69E-9, 5.98967815113, 2210.8109343331), new Vsop87.LnVsop(1.3E-9, 4.05971369649, 2005.3761454213), new Vsop87.LnVsop(1.76E-9, 4.67735877741, 1966.2317178272), new Vsop87.LnVsop(1.51E-9, 4.89507270868, 532.3992780803), new Vsop87.LnVsop(1.32E-9, 4.4682079818, 1987.2168981566), new Vsop87.LnVsop(1.52E-9, 2.54945350135, 1589.024711174), new Vsop87.LnVsop(1.35E-9, 2.67785802201, 78263.70942472259), new Vsop87.LnVsop(1.33E-9, 2.22367803003, 4642.7852706304), new Vsop87.LnVsop(1.52E-9, 5.74726585589, 1589.1210793936), new Vsop87.LnVsop(1.31E-9, 5.4436652812, 1588.1096874373), new Vsop87.LnVsop(1.3E-9, 5.08622554741, 650.9429865779), new Vsop87.LnVsop(1.27E-9, 3.01271886345, 1590.0361031303), new Vsop87.LnVsop(1.65E-9, 0.63157456503, 2729.4561991638), new Vsop87.LnVsop(1.6E-9, 3.09136733422, 1493.093668066), new Vsop87.LnVsop(1.26E-9, 4.02785244573, 2012.4896924221), new Vsop87.LnVsop(1.49E-9, 4.88056376194, 10206.1719992102), new Vsop87.LnVsop(1.2E-9, 3.6680799047, 1268.0151591812), new Vsop87.LnVsop(1.2E-9, 1.28575150669, 3597.6304344428), new Vsop87.LnVsop(1.18E-9, 5.98810576269, 531.387886124), new Vsop87.LnVsop(1.18E-9, 1.62024281593, 927.8349679674), new Vsop87.LnVsop(1.6E-9, 4.48451486494, 2654.6746005965), new Vsop87.LnVsop(1.28E-9, 4.08631741503, 638.4128136057), new Vsop87.LnVsop(1.14E-9, 6.19276216389, 1834.6153196362), new Vsop87.LnVsop(1.13E-9, 0.28741277087, 1208.9451273238), new Vsop87.LnVsop(1.22E-9, 1.34377557036, 446.3113468182), new Vsop87.LnVsop(1.13E-9, 2.64305802892, 3494.5376602242), new Vsop87.LnVsop(1.2E-9, 2.29717715125, 1059.2218714948), new Vsop87.LnVsop(1.11E-9, 5.97803783981, 550.1378342197), new Vsop87.LnVsop(1.2E-9, 5.96435211741, 3281.2385647862), new Vsop87.LnVsop(1.1E-9, 1.45784255142, 509.2440959695), new Vsop87.LnVsop(1.23E-9, 1.58528243666, 1080.7225711916), new Vsop87.LnVsop(1.08E-9, 2.15949816307, 4532.578949411), new Vsop87.LnVsop(1.31E-9, 2.49342323482, 920.8644333185), new Vsop87.LnVsop(1.07E-9, 0.03308245525, 521.8266585684), new Vsop87.LnVsop(1.12E-9, 2.26353490193, 2534.3163509905), new Vsop87.LnVsop(1.24E-9, 5.97253582505, 3700.7232086614), new Vsop87.LnVsop(1.43E-9, 0.97252781618, 4443.713269194), new Vsop87.LnVsop(1.04E-9, 3.10363960804, 8094.5216858326), new Vsop87.LnVsop(1.19E-9, 4.36305496553, 1056.4611688824), new Vsop87.LnVsop(1.04E-9, 5.38869056901, 767.3690829208), new Vsop87.LnVsop(1.03E-9, 4.7576634948, 1226.2106027112), new Vsop87.LnVsop(1.16E-9, 0.51605524063, 5621.8429232104), new Vsop87.LnVsop(1.04E-9, 6.08481630108, 528.2546764961), new Vsop87.LnVsop(1.19E-9, 1.0647552502, 527.9940440652), new Vsop87.LnVsop(1.21E-9, 5.6664507403, 2200.5159935946), new Vsop87.LnVsop(1.35E-9, 3.04469989833, 2199.7652340692), new Vsop87.LnVsop(1.01E-9, 3.61205787591, 3789.5888888784), new Vsop87.LnVsop(1.0E-9, 4.82071617356, 2100.6046131137), new Vsop87.LnVsop(1.36E-9, 2.25652419983, 1291.4309737229), new Vsop87.LnVsop(1.04E-9, 0.8973074681, 531.1272536931), new Vsop87.LnVsop(1.08E-9, 0.43456673876, 288.0806940053), new Vsop87.LnVsop(1.2E-9, 5.3900141258, 1059.5419888836), new Vsop87.LnVsop(1.25E-9, 0.62099682567, 1997.5118388951), new Vsop87.LnVsop(1.34E-9, 5.25320383252, 1895.9035373848), new Vsop87.LnVsop(1.03E-9, 3.61799646841, 1792.0770499833), new Vsop87.LnVsop(1.18E-9, 1.00645954017, 745.4377410874), new Vsop87.LnVsop(1.11E-9, 5.68172209277, 4017.115078318), new Vsop87.LnVsop(9.3E-10, 1.71996718617, 4164.311989613), new Vsop87.LnVsop(9.1E-10, 4.54586794299, 5901.239202256), new Vsop87.LnVsop(1.03E-9, 1.44157781039, 1731.5225454176), new Vsop87.LnVsop(9.4E-10, 2.9402588712, 995.6460318858), new Vsop87.LnVsop(1.01E-9, 5.09893554431, 530.5847369719), new Vsop87.LnVsop(1.02E-9, 0.27489333673, 450.9772132642), new Vsop87.LnVsop(1.21E-9, 3.07830472533, 580.0935412737), new Vsop87.LnVsop(9.8E-10, 0.35522834563, 5371.5482371614), new Vsop87.LnVsop(8.9E-10, 2.36605964279, 1176.7017984094), new Vsop87.LnVsop(1.15E-9, 3.54968128884, 5488.8681053816), new Vsop87.LnVsop(8.6E-10, 2.70671848058, 2424.8607892965), new Vsop87.LnVsop(1.09E-9, 0.93924032031, 3707.8367556622), new Vsop87.LnVsop(8.9E-10, 2.47000942358, 4312.1663069722), new Vsop87.LnVsop(9.2E-10, 0.49026147824, 5392.8888781638), new Vsop87.LnVsop(8.5E-10, 0.57009625976, 1628.429771199), new Vsop87.LnVsop(8.4E-10, 2.52951052433, 4657.012364632), new Vsop87.LnVsop(9.5E-10, 0.492989167, 1230.1427559743), new Vsop87.LnVsop(1.01E-9, 1.88318822487, 528.7971932173), new Vsop87.LnVsop(8.3E-10, 6.0583887951, 2858.5725271733), new Vsop87.LnVsop(8.3E-10, 3.97031381838, 247.2393453818), new Vsop87.LnVsop(8.2E-10, 4.61989860058, 3252.784376783), new Vsop87.LnVsop(8.1E-10, 2.0943814486, 2203.6973873323), new Vsop87.LnVsop(8.1E-10, 3.48070291292, 1231.6272286826), new Vsop87.LnVsop(1.08E-9, 2.69586646495, 10110.1927719924), new Vsop87.LnVsop(8.3E-10, 0.06930748257, 530.914805372), new Vsop87.LnVsop(8.0E-10, 0.22833904656, 2218.6752408593), new Vsop87.LnVsop(8.3E-10, 0.62963097943, 528.4671248172), new Vsop87.LnVsop(8.4E-10, 3.31531263655, 1895.1698242019), new Vsop87.LnVsop(8.2E-10, 4.56743340637, 6231.8581659142), new Vsop87.LnVsop(8.2E-10, 3.36834041159, 5172.476235725), new Vsop87.LnVsop(9.7E-10, 0.87887326085, 9690.7081281172), new Vsop87.LnVsop(9.7E-10, 4.27398661375, 9676.4810341156), new Vsop87.LnVsop(8.3E-10, 2.554273347, 1059.5943785103), new Vsop87.LnVsop(9.9E-10, 4.2226374011, 8521.1198767086), new Vsop87.LnVsop(7.8E-10, 5.75868229769, 5812.373522039), new Vsop87.LnVsop(7.8E-10, 4.55958930291, 4752.9915918498), new Vsop87.LnVsop(8.0E-10, 1.07708178317, 5378.6617841622), new Vsop87.LnVsop(7.8E-10, 0.76677000831, 525.5463635104), new Vsop87.LnVsop(8.1E-10, 3.10720885599, 2527.2028039897), new Vsop87.LnVsop(8.1E-10, 0.45113135705, 2516.9078632512), new Vsop87.LnVsop(9.8E-10, 1.42656513937, 757.2171545342), new Vsop87.LnVsop(8.7E-10, 4.62233814403, 184.9879197867), new Vsop87.LnVsop(1.03E-9, 2.56729943579, 1124.34166877), new Vsop87.LnVsop(1.02E-9, 1.33070990614, 3782.4753418776), new Vsop87.LnVsop(8.4E-10, 5.05086451175, 1160.027023853), new Vsop87.LnVsop(7.9E-10, 2.29616426691, 2758.6611466924), new Vsop87.LnVsop(8.0E-10, 0.8513600239, 1791.3262904579), new Vsop87.LnVsop(7.5E-10, 5.42366672204, 2755.4797529547), new Vsop87.LnVsop(8.5E-10, 1.86831566677, 25028.521211385), new Vsop87.LnVsop(7.9E-10, 4.70716888788, 4120.2078525366), new Vsop87.LnVsop(7.3E-10, 4.69119414591, 2115.5824666407), new Vsop87.LnVsop(9.8E-10, 3.9322263696, 2124.9836355019), new Vsop87.LnVsop(7.2E-10, 3.82048491843, 4539.6924964118), new Vsop87.LnVsop(8.1E-10, 5.76205552882, 617.8058857862)};
        private static final Vsop87.LnVsop[] jupiter_longitude_l1 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(529.69096508814, 0.0, 0.0), new Vsop87.LnVsop(0.00489503243, 4.2208293947, 529.6909650946), new Vsop87.LnVsop(0.00228917222, 6.02646855621, 7.1135470008), new Vsop87.LnVsop(3.0099479E-4, 4.54540782858, 1059.3819301892), new Vsop87.LnVsop(2.072092E-4, 5.45943156902, 522.5774180938), new Vsop87.LnVsop(1.2103653E-4, 0.16994816098, 536.8045120954), new Vsop87.LnVsop(6.067987E-5, 4.42422292017, 103.0927742186), new Vsop87.LnVsop(5.433968E-5, 3.98480737746, 419.4846438752), new Vsop87.LnVsop(4.237744E-5, 5.89008707199, 14.2270940016), new Vsop87.LnVsop(2.211974E-5, 5.26766687382, 206.1855484372), new Vsop87.LnVsop(1.983502E-5, 4.88600705699, 1589.0728952838), new Vsop87.LnVsop(1.295769E-5, 5.55132752171, 3.1813937377), new Vsop87.LnVsop(1.163416E-5, 0.51450634873, 3.9321532631), new Vsop87.LnVsop(1.007167E-5, 0.46474690033, 735.8765135318), new Vsop87.LnVsop(1.174094E-5, 5.84238857133, 1052.2683831884), new Vsop87.LnVsop(8.47762E-6, 5.75765726863, 110.2063212194), new Vsop87.LnVsop(8.2725E-6, 4.80311857692, 213.299095438), new Vsop87.LnVsop(8.29822E-6, 0.59345481695, 1066.49547719), new Vsop87.LnVsop(1.003864E-5, 3.14841622246, 426.598190876), new Vsop87.LnVsop(1.09873E-5, 5.30705242117, 515.463871093), new Vsop87.LnVsop(7.24923E-6, 5.51690038433, 639.897286314), new Vsop87.LnVsop(5.67826E-6, 5.98865760444, 625.6701923124), new Vsop87.LnVsop(4.74197E-6, 4.1324371636, 412.3710968744), new Vsop87.LnVsop(4.12936E-6, 5.73653788228, 95.9792272178), new Vsop87.LnVsop(3.3682E-6, 3.72892266066, 1162.4747044078), new Vsop87.LnVsop(3.45412E-6, 4.24128387922, 632.7837393132), new Vsop87.LnVsop(2.34071E-6, 6.24295755869, 309.2783226558), new Vsop87.LnVsop(1.94827E-6, 2.21824346028, 323.5054166574), new Vsop87.LnVsop(2.34805E-6, 4.03315571261, 949.1756089698), new Vsop87.LnVsop(1.83904E-6, 6.2797391951, 543.9180590962), new Vsop87.LnVsop(1.98512E-6, 1.50446971008, 838.9692877504), new Vsop87.LnVsop(1.86807E-6, 6.07956275814, 742.9900605326), new Vsop87.LnVsop(1.71405E-6, 5.41658811525, 199.0720014364), new Vsop87.LnVsop(1.30777E-6, 0.62641588161, 728.762966531), new Vsop87.LnVsop(1.34095E-6, 5.23702273624, 2118.7638603784), new Vsop87.LnVsop(1.15444E-6, 0.6778374723, 846.0828347512), new Vsop87.LnVsop(1.06501E-6, 4.4767172424, 956.2891559706), new Vsop87.LnVsop(6.6832E-7, 5.73362353275, 21.3406410024), new Vsop87.LnVsop(6.9619E-7, 5.9725637809, 532.8723588323), new Vsop87.LnVsop(5.995E-7, 1.0065747379, 1596.1864422846), new Vsop87.LnVsop(6.3366E-7, 6.05635396519, 1581.959348283), new Vsop87.LnVsop(7.9718E-7, 5.821567337, 1045.1548361876), new Vsop87.LnVsop(6.5635E-7, 0.12938321631, 526.5095713569), new Vsop87.LnVsop(5.8519E-7, 0.58687309667, 1155.361157407), new Vsop87.LnVsop(5.661E-7, 1.41183572003, 533.6231183577), new Vsop87.LnVsop(7.1631E-7, 5.34149334443, 942.062061969), new Vsop87.LnVsop(5.7343E-7, 5.9687033662, 1169.5882514086), new Vsop87.LnVsop(5.5048E-7, 5.42871116938, 10.2949407385), new Vsop87.LnVsop(5.2026E-7, 0.22999191591, 1368.660252845), new Vsop87.LnVsop(5.2295E-7, 5.72636754267, 117.3198682202), new Vsop87.LnVsop(5.0427E-7, 6.08258832558, 525.7588118315), new Vsop87.LnVsop(4.7278E-7, 3.60428393787, 1478.8665740644), new Vsop87.LnVsop(4.2199E-7, 4.13113112919, 1692.1656695024), new Vsop87.LnVsop(4.6566E-7, 0.51168261375, 1265.5674786264), new Vsop87.LnVsop(3.2801E-7, 5.03520269183, 220.4126424388), new Vsop87.LnVsop(3.3556E-7, 0.09960615979, 302.164775655), new Vsop87.LnVsop(2.9379E-7, 3.35927110207, 4.665866446), new Vsop87.LnVsop(2.9311E-7, 0.75894050642, 88.865680217), new Vsop87.LnVsop(3.2449E-7, 5.37487176787, 508.3503240922), new Vsop87.LnVsop(2.9741E-7, 5.42345191096, 1272.6810256272), new Vsop87.LnVsop(2.1789E-7, 6.14949766217, 1685.0521225016), new Vsop87.LnVsop(2.5194E-7, 1.60716361937, 831.8557407496), new Vsop87.LnVsop(2.1133E-7, 5.86310776376, 1258.4539316256), new Vsop87.LnVsop(1.9668E-7, 2.18904500387, 316.3918696566), new Vsop87.LnVsop(1.7878E-7, 0.82813691085, 433.7117378768), new Vsop87.LnVsop(1.7409E-7, 2.75647882058, 853.196381752), new Vsop87.LnVsop(1.7703E-7, 5.95527033658, 5.4166259714), new Vsop87.LnVsop(1.8586E-7, 0.51459954175, 1375.7737998458), new Vsop87.LnVsop(1.7469E-7, 0.7085516406, 1471.7530270636), new Vsop87.LnVsop(1.4369E-7, 0.91459684737, 18.1592472647), new Vsop87.LnVsop(1.4107E-7, 0.63031131929, 2.9207613068), new Vsop87.LnVsop(1.1728E-7, 1.76421689491, 380.12776796), new Vsop87.LnVsop(1.1042E-7, 5.56386292919, 1574.8458012822), new Vsop87.LnVsop(1.1422E-7, 4.30273286555, 405.2575498736), new Vsop87.LnVsop(1.0407E-7, 0.30595619562, 1361.5467058442), new Vsop87.LnVsop(9.894E-8, 0.38972478935, 1073.6090241908), new Vsop87.LnVsop(9.808E-8, 5.90342059427, 519.3960243561), new Vsop87.LnVsop(9.287E-8, 3.23717178839, 1795.258443721), new Vsop87.LnVsop(9.079E-8, 5.59391515894, 2648.454825473), new Vsop87.LnVsop(8.83E-8, 0.53669085248, 1788.1448967202), new Vsop87.LnVsop(8.238E-8, 5.88621877345, 2001.4439921582), new Vsop87.LnVsop(8.058E-8, 5.07394631539, 1485.9801210652), new Vsop87.LnVsop(6.69E-8, 2.41093500491, 4.192785694), new Vsop87.LnVsop(5.917E-8, 4.17942020818, 2008.557539159), new Vsop87.LnVsop(7.256E-8, 6.19390446816, 11.0457002639), new Vsop87.LnVsop(6.272E-8, 1.36131578474, 1148.2476104062), new Vsop87.LnVsop(5.142E-8, 5.23124680535, 628.8515860501), new Vsop87.LnVsop(5.141E-8, 2.92956226336, 518.6452648307), new Vsop87.LnVsop(4.764E-8, 0.16833299921, 629.6023455755), new Vsop87.LnVsop(4.603E-8, 0.78535347104, 721.6494195302), new Vsop87.LnVsop(4.573E-8, 6.24771751154, 1677.9385755008), new Vsop87.LnVsop(4.536E-8, 4.9510938869, 635.9651330509), new Vsop87.LnVsop(4.434E-8, 1.45220762308, 2125.8774073792), new Vsop87.LnVsop(4.518E-8, 2.06522259381, 453.424893819), new Vsop87.LnVsop(4.428E-8, 0.15677546362, 1699.2792165032), new Vsop87.LnVsop(5.594E-8, 5.5747124137, 191.9584544356), new Vsop87.LnVsop(5.405E-8, 1.46221153779, 330.6189636582), new Vsop87.LnVsop(5.776E-8, 4.37575545399, 2221.856634597), new Vsop87.LnVsop(4.265E-8, 0.24198200812, 2104.5367663768), new Vsop87.LnVsop(4.1E-8, 6.19338226411, 636.7158925763), new Vsop87.LnVsop(4.432E-8, 4.35787390405, 423.4167971383), new Vsop87.LnVsop(4.102E-8, 0.4919546148, 1056.2005364515), new Vsop87.LnVsop(4.527E-8, 0.09244775677, 1062.5633239269), new Vsop87.LnVsop(4.397E-8, 4.14273244974, 511.5317178299), new Vsop87.LnVsop(3.567E-8, 5.66550104255, 2317.8358618148), new Vsop87.LnVsop(3.585E-8, 0.28040162482, 1055.4497769261), new Vsop87.LnVsop(4.009E-8, 2.54842404074, 74.7815985673), new Vsop87.LnVsop(3.686E-8, 2.9336784999, 32.2433289144), new Vsop87.LnVsop(2.969E-8, 5.50022776972, 107.0249274817), new Vsop87.LnVsop(2.856E-8, 5.73809418496, 99.9113804809), new Vsop87.LnVsop(2.718E-8, 1.25246874516, 540.7366653585), new Vsop87.LnVsop(2.808E-8, 3.30714906571, 0.7507595254), new Vsop87.LnVsop(2.669E-8, 1.6339853139, 1063.3140834523), new Vsop87.LnVsop(2.667E-8, 4.28683044077, 106.2741679563), new Vsop87.LnVsop(2.705E-8, 3.03568370231, 422.6660376129), new Vsop87.LnVsop(3.271E-8, 5.89438924876, 1802.3719907218), new Vsop87.LnVsop(2.654E-8, 0.35475530647, 1898.3512179396), new Vsop87.LnVsop(2.574E-8, 3.59809745049, 750.1036075334), new Vsop87.LnVsop(2.486E-8, 5.28928577587, 1891.2376709388), new Vsop87.LnVsop(3.221E-8, 4.58424996327, 416.3032501375), new Vsop87.LnVsop(2.936E-8, 1.09054035208, 1464.6394800628), new Vsop87.LnVsop(2.398E-8, 6.02106328658, 551.031606097), new Vsop87.LnVsop(2.214E-8, 5.24451644028, 621.7380390493), new Vsop87.LnVsop(2.193E-8, 0.00364881833, 2420.9286360334), new Vsop87.LnVsop(2.32E-8, 5.82908812407, 305.3461693927), new Vsop87.LnVsop(2.088E-8, 5.99245749935, 1994.3304451574), new Vsop87.LnVsop(2.042E-8, 0.7501127547, 142.4496501338), new Vsop87.LnVsop(2.021E-8, 4.17581114855, 569.0478410098), new Vsop87.LnVsop(2.11E-8, 6.25440423633, 647.0108333148), new Vsop87.LnVsop(2.11E-8, 5.18650189729, 227.5261894396), new Vsop87.LnVsop(2.279E-8, 5.79998105466, 539.9859058331), new Vsop87.LnVsop(2.004E-8, 4.20934218728, 2324.9494088156), new Vsop87.LnVsop(1.977E-8, 3.99196981525, 24.3790223882), new Vsop87.LnVsop(1.953E-8, 1.35695450633, 963.4027029714), new Vsop87.LnVsop(1.896E-8, 2.78687918909, 2428.0421830342), new Vsop87.LnVsop(1.97E-8, 5.88674791355, 217.2312487011), new Vsop87.LnVsop(1.931E-8, 3.03273886284, 1382.8873468466), new Vsop87.LnVsop(2.034E-8, 3.0851308676, 408.4389436113), new Vsop87.LnVsop(1.833E-8, 5.61442879983, 430.5303441391), new Vsop87.LnVsop(1.838E-8, 1.25469566267, 81.7521332162), new Vsop87.LnVsop(1.82E-8, 5.9750652083, 114.1384744825), new Vsop87.LnVsop(2.043E-8, 4.34071262566, 70.8494453042), new Vsop87.LnVsop(1.957E-8, 4.03064578017, 92.0470739547), new Vsop87.LnVsop(1.768E-8, 0.33096757704, 35.4247226521), new Vsop87.LnVsop(2.328E-8, 5.86166964748, 1038.0412891868), new Vsop87.LnVsop(1.831E-8, 4.81134529978, 124.433415221), new Vsop87.LnVsop(2.268E-8, 1.0265290122, 618.5566453116), new Vsop87.LnVsop(1.919E-8, 5.01339713289, 99.1606209555), new Vsop87.LnVsop(1.923E-8, 0.28688541174, 31.019488637), new Vsop87.LnVsop(2.359E-8, 4.65803416282, 1905.4647649404), new Vsop87.LnVsop(1.879E-8, 5.69252482087, 210.1177017003), new Vsop87.LnVsop(1.678E-8, 0.25561675979, 295.0512286542), new Vsop87.LnVsop(1.656E-8, 5.46017983557, 2634.2277314714), new Vsop87.LnVsop(1.675E-8, 6.15616456038, 643.8294395771), new Vsop87.LnVsop(1.953E-8, 5.09846435548, 17.4084877393), new Vsop87.LnVsop(1.539E-8, 2.75248075364, 415.5524906121), new Vsop87.LnVsop(1.482E-8, 3.76735041917, 534.3568315406), new Vsop87.LnVsop(1.446E-8, 3.15802770791, 25.1297819136), new Vsop87.LnVsop(1.421E-8, 0.61909506285, 458.8415197904), new Vsop87.LnVsop(1.666E-8, 0.26032169128, 835.0371344873), new Vsop87.LnVsop(1.472E-8, 0.83054329617, 28.3111756513), new Vsop87.LnVsop(1.654E-8, 0.88874938135, 1781.0313497194), new Vsop87.LnVsop(1.302E-8, 5.75537548503, 440.8252848776), new Vsop87.LnVsop(1.349E-8, 2.49744006758, 984.6003316219), new Vsop87.LnVsop(1.355E-8, 5.10790739045, 149.5631971346), new Vsop87.LnVsop(1.188E-8, 2.24279457878, 31.492569389), new Vsop87.LnVsop(1.231E-8, 0.77900547379, 739.8086667949), new Vsop87.LnVsop(1.161E-8, 3.10767970553, 2111.6503133776), new Vsop87.LnVsop(1.178E-8, 4.30970344337, 561.934294009), new Vsop87.LnVsop(1.233E-8, 6.22576640438, 2214.7430875962), new Vsop87.LnVsop(1.095E-8, 6.03022173687, 2737.32050569), new Vsop87.LnVsop(1.324E-8, 4.22919631556, 2538.2485042536), new Vsop87.LnVsop(1.346E-8, 3.20576632074, 525.0250986486), new Vsop87.LnVsop(1.057E-8, 5.76574985561, 2310.722314814), new Vsop87.LnVsop(1.158E-8, 0.46300827788, 67.6680515665), new Vsop87.LnVsop(1.027E-8, 0.20709586018, 7.8643065262), new Vsop87.LnVsop(1.143E-8, 5.5663227939, 46.470422916), new Vsop87.LnVsop(1.012E-8, 0.54307369204, 532.1386456494), new Vsop87.LnVsop(9.79E-9, 5.1408895345, 2207.6295405954), new Vsop87.LnVsop(9.93E-9, 2.03698162387, 319.5732633943), new Vsop87.LnVsop(1.035E-8, 2.9032569187, 611.4430983108), new Vsop87.LnVsop(1.021E-8, 4.7566856088, 527.2432845398), new Vsop87.LnVsop(1.31E-8, 1.78907016216, 824.7421937488), new Vsop87.LnVsop(8.95E-9, 2.54589419261, 2744.4340526908), new Vsop87.LnVsop(8.9E-9, 5.41093971819, 28.4541880032), new Vsop87.LnVsop(9.85E-9, 0.88687783832, 5760.4984318976), new Vsop87.LnVsop(9.83E-9, 1.42102189882, 5746.271337896), new Vsop87.LnVsop(8.93E-9, 5.87175153771, 203.0041546995), new Vsop87.LnVsop(9.22E-9, 4.17425091286, 2641.3412784722), new Vsop87.LnVsop(8.76E-9, 0.75315488921, 1439.5096981492), new Vsop87.LnVsop(9.45E-9, 2.31584676883, 9690.7081281172), new Vsop87.LnVsop(9.41E-9, 2.84331047707, 9676.4810341156), new Vsop87.LnVsop(8.67E-9, 0.81016495601, 524.2743391232), new Vsop87.LnVsop(8.28E-9, 2.35268476661, 312.4597163935), new Vsop87.LnVsop(9.12E-9, 2.80494184378, 6.2197751235), new Vsop87.LnVsop(8.08E-9, 1.05165559697, 529.6427809848), new Vsop87.LnVsop(7.79E-9, 4.79938843208, 945.2434557067), new Vsop87.LnVsop(8.78E-9, 5.76532521399, 1.6445314027), new Vsop87.LnVsop(9.54E-9, 4.308801741, 209.3669421749), new Vsop87.LnVsop(7.72E-9, 5.25564170894, 2950.619601128), new Vsop87.LnVsop(7.45E-9, 0.03807300102, 535.107591066), new Vsop87.LnVsop(7.44E-9, 0.58381523987, 25.2727942655), new Vsop87.LnVsop(7.35E-9, 0.19889697619, 1049.0869894507), new Vsop87.LnVsop(7.47E-9, 2.71776604422, 38.1330356378), new Vsop87.LnVsop(7.28E-9, 5.97254317194, 945.9942152321), new Vsop87.LnVsop(7.69E-9, 4.51524159414, 952.3570027075), new Vsop87.LnVsop(7.11E-9, 0.38043574201, 69.1525242748), new Vsop87.LnVsop(7.61E-9, 3.07043913906, 39.3568759152), new Vsop87.LnVsop(8.02E-9, 1.14189803237, 532.6117264014), new Vsop87.LnVsop(7.04E-9, 1.25543872788, 547.8502123593), new Vsop87.LnVsop(8.0E-9, 3.20276130202, 604.4725636619), new Vsop87.LnVsop(8.21E-9, 1.05238771575, 909.8187330546), new Vsop87.LnVsop(7.25E-9, 5.6829355415, 953.1077622329), new Vsop87.LnVsop(6.82E-9, 1.20168457647, 387.2413149608), new Vsop87.LnVsop(6.4E-9, 3.91564016975, 528.7277572481), new Vsop87.LnVsop(6.63E-9, 0.81538903178, 2228.9701815978), new Vsop87.LnVsop(8.08E-9, 4.2494667246, 529.7391492044), new Vsop87.LnVsop(7.68E-9, 0.58100515131, 2097.423219376), new Vsop87.LnVsop(6.93E-9, 2.51156186683, 916.9322800554), new Vsop87.LnVsop(7.84E-9, 4.23618116997, 195.1398481733), new Vsop87.LnVsop(7.63E-9, 1.12270397266, 732.6951197941), new Vsop87.LnVsop(6.17E-9, 5.80980286923, 739.0579072695), new Vsop87.LnVsop(7.34E-9, 4.24709115085, 760.25553592), new Vsop87.LnVsop(5.92E-9, 3.26062064584, 202.2533951741), new Vsop87.LnVsop(5.52E-9, 5.83536244089, 526.7702037878), new Vsop87.LnVsop(7.14E-9, 4.90042609368, 2751.5475996916), new Vsop87.LnVsop(6.4E-9, 1.38548213559, 530.6541729411), new Vsop87.LnVsop(6.2E-9, 3.01948741376, 902.7051860538), new Vsop87.LnVsop(7.22E-9, 5.18172356552, 1.4844727083), new Vsop87.LnVsop(5.3E-9, 5.96271879869, 2015.6710861598), new Vsop87.LnVsop(5.41E-9, 3.78415919087, 2957.7331481288), new Vsop87.LnVsop(5.3E-9, 6.10433734445, 2531.1349572528), new Vsop87.LnVsop(5.69E-9, 4.12853081905, 2854.6403739102), new Vsop87.LnVsop(4.98E-9, 4.62946077069, 934.9485149682), new Vsop87.LnVsop(5.23E-9, 3.63882931609, 437.6438911399), new Vsop87.LnVsop(5.27E-9, 5.80963579852, 3053.7123753466), new Vsop87.LnVsop(4.89E-9, 5.93594675987, 3178.1457905676), new Vsop87.LnVsop(4.88E-9, 4.99103190309, 483.2205421786), new Vsop87.LnVsop(4.87E-9, 5.55239102762, 2627.1141844706), new Vsop87.LnVsop(4.78E-9, 0.83306238983, 1603.2999892854), new Vsop87.LnVsop(4.87E-9, 5.86510858429, 724.8308132679), new Vsop87.LnVsop(4.53E-9, 0.61324874134, 1159.2933106701), new Vsop87.LnVsop(4.51E-9, 2.28214016934, 3060.8259223474), new Vsop87.LnVsop(5.15E-9, 4.78127185341, 447.7958195265), new Vsop87.LnVsop(5.37E-9, 0.63663065397, 1354.4331588434), new Vsop87.LnVsop(4.61E-9, 2.67886294351, 1021.2488945514), new Vsop87.LnVsop(4.5E-9, 1.91049628603, 597.3590166611), new Vsop87.LnVsop(4.88E-9, 5.56151436365, 2435.155730035), new Vsop87.LnVsop(4.32E-9, 3.64946046991, 313.2104759189), new Vsop87.LnVsop(4.35E-9, 3.02448452708, 533.8837507886), new Vsop87.LnVsop(4.26E-9, 5.07997231709, 2524.021410252), new Vsop87.LnVsop(4.91E-9, 3.59200148259, 230.5645708254), new Vsop87.LnVsop(5.03E-9, 1.5759500924, 454.9093665273), new Vsop87.LnVsop(5.26E-9, 2.0289966749, 1279.794572628), new Vsop87.LnVsop(3.88E-9, 5.58072092256, 731.9443602687), new Vsop87.LnVsop(4.49E-9, 1.11025492739, 56.6223513026), new Vsop87.LnVsop(4.6E-9, 4.42534443381, 462.0229135281), new Vsop87.LnVsop(4.95E-9, 0.36191781331, 1251.3403846248), new Vsop87.LnVsop(3.98E-9, 5.2011937611, 3267.0114707846), new Vsop87.LnVsop(4.16E-9, 1.70821947228, 245.5424243524), new Vsop87.LnVsop(3.55E-9, 1.65214516751, 78.7137518304), new Vsop87.LnVsop(3.66E-9, 5.75203350764, 2847.5268269094), new Vsop87.LnVsop(4.03E-9, 1.72240208145, 1141.1340634054), new Vsop87.LnVsop(3.34E-9, 6.0103374635, 960.2213092337), new Vsop87.LnVsop(3.31E-9, 1.74101810453, 490.3340891794), new Vsop87.LnVsop(3.14E-9, 5.73955945935, 1158.5425511447), new Vsop87.LnVsop(3.89E-9, 0.31258924956, 2413.8150890326), new Vsop87.LnVsop(3.28E-9, 3.50753080884, 3274.1250177854), new Vsop87.LnVsop(3.49E-9, 0.38232238589, 2332.0629558164), new Vsop87.LnVsop(3.0E-9, 4.75999716377, 938.1299087059), new Vsop87.LnVsop(3.25E-9, 0.54991590409, 43.2890291783), new Vsop87.LnVsop(2.88E-9, 4.9049770238, 1357.6145525811), new Vsop87.LnVsop(3.04E-9, 6.12658548685, 1262.3860848887), new Vsop87.LnVsop(2.85E-9, 2.89817774175, 530.2122299564), new Vsop87.LnVsop(2.85E-9, 4.56582790812, 1268.7488723641), new Vsop87.LnVsop(3.1E-9, 4.69121773135, 76.2660712756), new Vsop87.LnVsop(2.78E-9, 5.49867187248, 280.9671470045), new Vsop87.LnVsop(2.79E-9, 4.66775152978, 1261.6353253633), new Vsop87.LnVsop(3.57E-9, 5.45944338384, 113.3877149571), new Vsop87.LnVsop(3.0E-9, 4.11291800981, 1048.3362299253), new Vsop87.LnVsop(2.83E-9, 1.09440291187, 1512.8068240082), new Vsop87.LnVsop(3.26E-9, 0.60265644873, 827.9235874865), new Vsop87.LnVsop(2.8E-9, 2.64073976181, 373.0142209592), new Vsop87.LnVsop(2.67E-9, 1.94524254858, 3377.217792004), new Vsop87.LnVsop(2.83E-9, 5.36501811239, 1165.6560981455), new Vsop87.LnVsop(2.81E-9, 5.54752717581, 3370.1042450032), new Vsop87.LnVsop(2.69E-9, 3.92616563946, 42.5382696529), new Vsop87.LnVsop(2.7E-9, 4.93414229832, 1041.2226829245), new Vsop87.LnVsop(2.74E-9, 1.86909714777, 2655.5683724738), new Vsop87.LnVsop(2.59E-9, 2.56026215512, 9146.790069021), new Vsop87.LnVsop(2.58E-9, 5.96872448521, 1269.4996318895), new Vsop87.LnVsop(2.54E-9, 1.3544998482, 1061.829610744), new Vsop87.LnVsop(2.82E-9, 3.01539201149, 320.3240229197), new Vsop87.LnVsop(2.72E-9, 4.18505693688, 8624.2126509272), new Vsop87.LnVsop(2.45E-9, 1.24462798353, 252.6559713532), new Vsop87.LnVsop(2.6E-9, 4.32490177755, 4017.115078318), new Vsop87.LnVsop(2.47E-9, 3.83116540525, 327.4375699205), new Vsop87.LnVsop(2.64E-9, 1.1329859586, 1969.2006632438), new Vsop87.LnVsop(2.91E-9, 2.99706400538, 4694.0029547076), new Vsop87.LnVsop(2.23E-9, 5.86659978015, 3914.0223040994), new Vsop87.LnVsop(2.41E-9, 3.94118046972, 3171.0322435668), new Vsop87.LnVsop(2.28E-9, 5.97829032334, 224.3447957019), new Vsop87.LnVsop(2.23E-9, 6.19814052214, 3281.2385647862), new Vsop87.LnVsop(2.46E-9, 2.91332083588, 1514.2912967165), new Vsop87.LnVsop(2.3E-9, 2.2070151315, 850.0149880143), new Vsop87.LnVsop(2.7E-9, 0.5823399263, 1592.2542890215), new Vsop87.LnVsop(2.36E-9, 4.85450939183, 3583.4033404412), new Vsop87.LnVsop(2.37E-9, 2.74342922621, 1912.5783119412), new Vsop87.LnVsop(2.76E-9, 6.04560989855, 1069.6768709277), new Vsop87.LnVsop(2.54E-9, 1.83831918853, 1593.0050485469), new Vsop87.LnVsop(2.14E-9, 3.63754231115, 3803.81598288), new Vsop87.LnVsop(2.1E-9, 3.08485590783, 3590.516887442), new Vsop87.LnVsop(2.6E-9, 5.06089460492, 1059.430114299), new Vsop87.LnVsop(2.27E-9, 0.23394232373, 1670.8250285), new Vsop87.LnVsop(2.46E-9, 5.53873348349, 2840.4132799086), new Vsop87.LnVsop(2.06E-9, 4.553308556, 554.0699874828), new Vsop87.LnVsop(2.02E-9, 1.32439444045, 4326.3934009738), new Vsop87.LnVsop(2.27E-9, 0.78540105705, 59.8037450403), new Vsop87.LnVsop(2.58E-9, 1.3085433563, 1493.093668066), new Vsop87.LnVsop(1.99E-9, 0.45118573624, 529.5309064002), new Vsop87.LnVsop(2.03E-9, 4.1687211015, 4333.5069479746), new Vsop87.LnVsop(2.07E-9, 0.07882551152, 5223.6939198022), new Vsop87.LnVsop(2.03E-9, 2.87164861799, 505.3119427064), new Vsop87.LnVsop(1.97E-9, 4.05755296915, 1064.0477966352), new Vsop87.LnVsop(1.96E-9, 5.99844851675, 3597.6304344428), new Vsop87.LnVsop(1.99E-9, 3.30501818656, 4120.2078525366), new Vsop87.LnVsop(1.94E-9, 5.95526916809, 84.9335269539), new Vsop87.LnVsop(1.95E-9, 4.77984803416, 1098.7388061044), new Vsop87.LnVsop(2.45E-9, 0.01831767727, 1567.7322542814), new Vsop87.LnVsop(2.04E-9, 3.8125265239, 530.44172462), new Vsop87.LnVsop(2.1E-9, 1.56035035567, 512.2824773553), new Vsop87.LnVsop(1.98E-9, 3.54440293022, 529.851023789), new Vsop87.LnVsop(2.66E-9, 1.58071929624, 983.1158589136), new Vsop87.LnVsop(1.98E-9, 0.30047978925, 1166.4068576709), new Vsop87.LnVsop(1.88E-9, 0.90738705875, 135.336103133), new Vsop87.LnVsop(2.56E-9, 1.87162378257, 1289.9465010146), new Vsop87.LnVsop(1.9E-9, 1.05137411074, 1884.124123938), new Vsop87.LnVsop(1.78E-9, 1.0110854555, 10206.1719992102), new Vsop87.LnVsop(1.89E-9, 0.35186987278, 1372.5924061081), new Vsop87.LnVsop(2.18E-9, 5.40858666125, 679.2541622292), new Vsop87.LnVsop(1.72E-9, 4.35360474429, 1578.0271950199), new Vsop87.LnVsop(1.72E-9, 0.28434115891, 494.2662424425), new Vsop87.LnVsop(2.06E-9, 0.01485146863, 2730.2069586892), new Vsop87.LnVsop(1.76E-9, 5.20619161648, 3686.4961146598), new Vsop87.LnVsop(1.73E-9, 1.83493659695, 746.9222137957), new Vsop87.LnVsop(1.77E-9, 0.49024580662, 1585.8915015461), new Vsop87.LnVsop(2.06E-9, 5.22730929781, 3995.7744373156), new Vsop87.LnVsop(1.9E-9, 4.99077882242, 3067.9394693482), new Vsop87.LnVsop(1.69E-9, 2.57956666704, 9161.0171630226), new Vsop87.LnVsop(1.68E-9, 6.15800395467, 970.5162499722), new Vsop87.LnVsop(1.65E-9, 1.51795928301, 4010.0015313172), new Vsop87.LnVsop(1.89E-9, 0.74735111652, 2545.3620512544), new Vsop87.LnVsop(1.73E-9, 3.38232793511, 885.4397106664), new Vsop87.LnVsop(1.66E-9, 1.54981367866, 1070.4276304531), new Vsop87.LnVsop(1.63E-9, 2.27700702598, 1060.3451380357), new Vsop87.LnVsop(1.57E-9, 1.23713010823, 5216.5803728014), new Vsop87.LnVsop(1.78E-9, 5.39417024046, 3163.918696566), new Vsop87.LnVsop(1.58E-9, 3.90063523153, 3487.4241132234), new Vsop87.LnVsop(1.69E-9, 5.91153502769, 1578.7779545453), new Vsop87.LnVsop(1.78E-9, 5.51894552093, 2943.5060541272), new Vsop87.LnVsop(1.54E-9, 4.52070366231, 1058.4187223427), new Vsop87.LnVsop(1.63E-9, 0.80456433006, 1585.1407420207), new Vsop87.LnVsop(1.51E-9, 4.87442909516, 81.8951455681), new Vsop87.LnVsop(1.8E-9, 1.88055488803, 685.4739373527), new Vsop87.LnVsop(1.54E-9, 3.65536637158, 77734.01845962799), new Vsop87.LnVsop(1.63E-9, 5.06311074065, 498.6714764576), new Vsop87.LnVsop(1.62E-9, 0.84216605238, 2200.5159935946), new Vsop87.LnVsop(1.89E-9, 0.56636371283, 842.1506814881), new Vsop87.LnVsop(1.51E-9, 4.66530832982, 977.4867846211), new Vsop87.LnVsop(1.87E-9, 3.11784576157, 630.3360587584), new Vsop87.LnVsop(1.44E-9, 0.70005415255, 92.7978334801), new Vsop87.LnVsop(1.38E-9, 2.92367081829, 927.8349679674), new Vsop87.LnVsop(1.64E-9, 3.73913227289, 1134.1635287565), new Vsop87.LnVsop(1.82E-9, 5.86715864086, 5753.3848848968), new Vsop87.LnVsop(1.44E-9, 4.89589455408, 991.7138786227), new Vsop87.LnVsop(1.37E-9, 2.07768743239, 842.9014410135), new Vsop87.LnVsop(1.51E-9, 2.10726170967, 860.3099287528), new Vsop87.LnVsop(1.4E-9, 0.77231183403, 9683.5945811164), new Vsop87.LnVsop(1.31E-9, 2.96777933087, 497.4476361802), new Vsop87.LnVsop(1.19E-9, 1.2600741094, 2005.3761454213), new Vsop87.LnVsop(1.2E-9, 6.13286906499, 1987.2168981566), new Vsop87.LnVsop(1.43E-9, 2.40231943231, 529.1697002328), new Vsop87.LnVsop(1.13E-9, 4.7309485584, 4863.1979130692), new Vsop87.LnVsop(1.22E-9, 4.54364035076, 1371.8416465827), new Vsop87.LnVsop(1.35E-9, 3.56089271537, 1054.7160637432), new Vsop87.LnVsop(1.15E-9, 1.5581015669, 9153.9036160218), new Vsop87.LnVsop(1.5E-9, 4.28443290371, 429.0458714308), new Vsop87.LnVsop(1.32E-9, 5.07409771627, 1056.9342496344), new Vsop87.LnVsop(1.12E-9, 4.59192248879, 3700.7232086614), new Vsop87.LnVsop(1.03E-9, 2.60811213731, 1894.4190646765), new Vsop87.LnVsop(1.05E-9, 5.94340093827, 1057.8974574809), new Vsop87.LnVsop(1.01E-9, 1.58846813422, 3693.6096616606), new Vsop87.LnVsop(1.18E-9, 4.88733637311, 600.5404103988), new Vsop87.LnVsop(9.8E-10, 1.3879327163, 1059.3337460794), new Vsop87.LnVsop(1.0E-9, 5.7497544402, 501.2367770914), new Vsop87.LnVsop(1.01E-9, 0.02209271767, 2964.8466951296), new Vsop87.LnVsop(9.5E-10, 0.49108484683, 560.7104537316), new Vsop87.LnVsop(9.4E-10, 5.18380306247, 4546.8060434126), new Vsop87.LnVsop(1.04E-9, 3.47229999154, 4223.3006267552), new Vsop87.LnVsop(9.9E-10, 5.46359299375, 3156.8051495652), new Vsop87.LnVsop(9.9E-10, 5.95584423449, 547.0994528339), new Vsop87.LnVsop(9.1E-10, 1.87848199981, 528.9402055692), new Vsop87.LnVsop(1.08E-9, 5.98018728055, 1364.7280995819), new Vsop87.LnVsop(1.16E-9, 3.44357640421, 1432.3961511484), new Vsop87.LnVsop(8.8E-10, 4.22154936325, 4649.8988176312), new Vsop87.LnVsop(1.09E-9, 3.83768244476, 525.4981794006), new Vsop87.LnVsop(8.7E-10, 0.58669584397, 1173.5204046717), new Vsop87.LnVsop(9.1E-10, 5.33968822169, 216.4804891757), new Vsop87.LnVsop(1.02E-9, 1.41480903153, 3075.053016349), new Vsop87.LnVsop(1.02E-9, 1.74475388738, 2758.6611466924), new Vsop87.LnVsop(8.9E-10, 5.89316363283, 757.2171545342), new Vsop87.LnVsop(8.6E-10, 6.0434065174, 6275.9623029906), new Vsop87.LnVsop(1.01E-9, 4.70225529886, 3473.1970192218), new Vsop87.LnVsop(7.9E-10, 5.72096488951, 5385.775331163), new Vsop87.LnVsop(7.8E-10, 1.11944499728, 429.7795846137), new Vsop87.LnVsop(7.8E-10, 5.12580794008, 1475.6851803267), new Vsop87.LnVsop(7.8E-10, 3.87444671518, 2321.7680150779), new Vsop87.LnVsop(8.6E-10, 2.89392726975, 10213.285546211), new Vsop87.LnVsop(7.7E-10, 1.40171543677, 5179.5897827258), new Vsop87.LnVsop(7.6E-10, 0.09895432561, 3707.8367556622), new Vsop87.LnVsop(7.3E-10, 5.65154413109, 1151.4290041439), new Vsop87.LnVsop(8.4E-10, 5.15227885953, 1091.6252591036), new Vsop87.LnVsop(7.9E-10, 4.811543412, 3384.3313390048), new Vsop87.LnVsop(8.0E-10, 0.05190580386, 1080.7225711916), new Vsop87.LnVsop(8.0E-10, 5.35119272632, 2.4476805548), new Vsop87.LnVsop(8.5E-10, 5.88100684593, 234.6397364404)};
        private static final Vsop87.LnVsop[] jupiter_longitude_l2 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(4.7233601E-4, 4.32148536482, 7.1135470008), new Vsop87.LnVsop(3.0649436E-4, 2.929777887, 529.6909650946), new Vsop87.LnVsop(1.4837605E-4, 3.14159265359, 0.0), new Vsop87.LnVsop(3.189359E-5, 1.05515491122, 522.5774180938), new Vsop87.LnVsop(2.728901E-5, 4.84555421873, 536.8045120954), new Vsop87.LnVsop(2.54744E-5, 3.42720888976, 1059.3819301892), new Vsop87.LnVsop(1.721046E-5, 4.18734600902, 14.2270940016), new Vsop87.LnVsop(3.83277E-6, 5.76794364868, 419.4846438752), new Vsop87.LnVsop(3.67514E-6, 6.05520169517, 103.0927742186), new Vsop87.LnVsop(3.77503E-6, 0.7605083906, 515.463871093), new Vsop87.LnVsop(3.37386E-6, 3.78644856157, 3.1813937377), new Vsop87.LnVsop(3.08194E-6, 0.6936828379, 206.1855484372), new Vsop87.LnVsop(2.14121E-6, 3.8295818143, 1589.0728952838), new Vsop87.LnVsop(2.03945E-6, 5.34259263233, 1066.49547719), new Vsop87.LnVsop(1.97456E-6, 2.4835107179, 3.9321532631), new Vsop87.LnVsop(1.46156E-6, 3.81335105293, 639.897286314), new Vsop87.LnVsop(1.56209E-6, 1.36162315686, 1052.2683831884), new Vsop87.LnVsop(1.29577E-6, 5.83745710707, 412.3710968744), new Vsop87.LnVsop(1.41825E-6, 1.63491733107, 426.598190876), new Vsop87.LnVsop(1.17324E-6, 1.41441723025, 625.6701923124), new Vsop87.LnVsop(9.6673E-7, 4.03472268105, 110.2063212194), new Vsop87.LnVsop(9.0824E-7, 1.10616181082, 95.9792272178), new Vsop87.LnVsop(7.8757E-7, 4.63773672633, 543.9180590962), new Vsop87.LnVsop(7.2393E-7, 2.21660922294, 735.8765135318), new Vsop87.LnVsop(8.732E-7, 2.52152838765, 632.7837393132), new Vsop87.LnVsop(5.6885E-7, 3.12193937495, 213.299095438), new Vsop87.LnVsop(4.8615E-7, 1.67250930065, 309.2783226558), new Vsop87.LnVsop(5.8472E-7, 0.83261136328, 199.0720014364), new Vsop87.LnVsop(4.0161E-7, 4.02477739294, 21.3406410024), new Vsop87.LnVsop(3.9773E-7, 0.62346681537, 323.5054166574), new Vsop87.LnVsop(3.5738E-7, 2.32587552001, 728.762966531), new Vsop87.LnVsop(2.561E-7, 2.52090555309, 1162.4747044078), new Vsop87.LnVsop(2.9257E-7, 3.60827234952, 10.2949407385), new Vsop87.LnVsop(2.3621E-7, 3.00418693282, 956.2891559706), new Vsop87.LnVsop(2.779E-7, 3.24029772587, 838.9692877504), new Vsop87.LnVsop(2.5988E-7, 4.50541789846, 742.9900605326), new Vsop87.LnVsop(2.5259E-7, 1.21368179972, 1045.1548361876), new Vsop87.LnVsop(1.9456E-7, 4.29184444888, 532.8723588323), new Vsop87.LnVsop(1.616E-7, 5.81618778562, 1596.1864422846), new Vsop87.LnVsop(1.7655E-7, 0.8091545878, 508.3503240922), new Vsop87.LnVsop(1.7714E-7, 4.21087482222, 2118.7638603784), new Vsop87.LnVsop(1.695E-7, 1.83162996779, 526.5095713569), new Vsop87.LnVsop(1.4656E-7, 3.99869563261, 117.3198682202), new Vsop87.LnVsop(1.3717E-7, 1.80293013315, 302.164775655), new Vsop87.LnVsop(1.3232E-7, 2.51839383442, 88.865680217), new Vsop87.LnVsop(1.2771E-7, 4.3696527712, 1169.5882514086), new Vsop87.LnVsop(1.5311E-7, 0.68283508612, 942.062061969), new Vsop87.LnVsop(1.0924E-7, 4.44465911708, 525.7588118315), new Vsop87.LnVsop(1.3902E-7, 5.9586109821, 316.3918696566), new Vsop87.LnVsop(9.462E-8, 2.17903550202, 1155.361157407), new Vsop87.LnVsop(8.792E-8, 3.29010679292, 220.4126424388), new Vsop87.LnVsop(7.851E-8, 5.76115179798, 846.0828347512), new Vsop87.LnVsop(7.64E-8, 2.7204502155, 533.6231183577), new Vsop87.LnVsop(9.055E-8, 1.63552089571, 1581.959348283), new Vsop87.LnVsop(8.687E-8, 3.31770180816, 831.8557407496), new Vsop87.LnVsop(6.355E-8, 0.49733352086, 949.1756089698), new Vsop87.LnVsop(6.615E-8, 2.18391508427, 1265.5674786264), new Vsop87.LnVsop(5.38E-8, 6.00496610446, 405.2575498736), new Vsop87.LnVsop(4.562E-8, 1.38462817429, 1258.4539316256), new Vsop87.LnVsop(4.367E-8, 5.07489817646, 1073.6090241908), new Vsop87.LnVsop(4.28E-8, 3.04118697325, 1692.1656695024), new Vsop87.LnVsop(4.371E-8, 5.474919646, 433.7117378768), new Vsop87.LnVsop(4.201E-8, 5.28578420235, 18.1592472647), new Vsop87.LnVsop(3.95E-8, 1.25151054185, 853.196381752), new Vsop87.LnVsop(5.302E-8, 3.65714557917, 1272.6810256272), new Vsop87.LnVsop(4.368E-8, 2.27494144993, 1368.660252845), new Vsop87.LnVsop(3.462E-8, 1.50340907962, 519.3960243561), new Vsop87.LnVsop(2.757E-8, 2.16577371531, 1478.8665740644), new Vsop87.LnVsop(2.704E-8, 1.04777971186, 1574.8458012822), new Vsop87.LnVsop(2.891E-8, 2.04866759038, 1361.5467058442), new Vsop87.LnVsop(3.075E-8, 0.9910538683, 191.9584544356), new Vsop87.LnVsop(2.437E-8, 2.36815291342, 1471.7530270636), new Vsop87.LnVsop(2.201E-8, 2.47797001828, 721.6494195302), new Vsop87.LnVsop(2.093E-8, 3.72335003599, 1485.9801210652), new Vsop87.LnVsop(2.273E-8, 3.03212449012, 1148.2476104062), new Vsop87.LnVsop(1.947E-8, 1.8876418002, 1685.0521225016), new Vsop87.LnVsop(2.057E-8, 6.18001258073, 330.6189636582), new Vsop87.LnVsop(1.451E-8, 4.72055072637, 32.2433289144), new Vsop87.LnVsop(1.449E-8, 3.1879914905, 635.9651330509), new Vsop87.LnVsop(1.377E-8, 5.12507193192, 1375.7737998458), new Vsop87.LnVsop(1.421E-8, 1.9924918846, 629.6023455755), new Vsop87.LnVsop(1.401E-8, 4.26834108454, 551.031606097), new Vsop87.LnVsop(1.265E-8, 0.00691519565, 2125.8774073792), new Vsop87.LnVsop(1.272E-8, 2.25106018556, 1788.1448967202), new Vsop87.LnVsop(1.238E-8, 1.75660677516, 1677.9385755008), new Vsop87.LnVsop(1.206E-8, 2.18559244687, 1795.258443721), new Vsop87.LnVsop(1.493E-8, 4.02813570061, 539.9859058331), new Vsop87.LnVsop(1.314E-8, 4.76481710487, 1062.5633239269), new Vsop87.LnVsop(1.11E-8, 2.97713206981, 81.7521332162), new Vsop87.LnVsop(1.027E-8, 1.99159218429, 295.0512286542), new Vsop87.LnVsop(1.368E-8, 4.63088532557, 2648.454825473), new Vsop87.LnVsop(1.025E-8, 3.75336759986, 28.4541880032), new Vsop87.LnVsop(9.78E-9, 3.01394148632, 124.433415221), new Vsop87.LnVsop(1.227E-8, 1.22879053363, 1038.0412891868), new Vsop87.LnVsop(9.65E-9, 1.17674106025, 99.9113804809), new Vsop87.LnVsop(1.015E-8, 1.8592221639, 750.1036075334), new Vsop87.LnVsop(9.24E-9, 3.53294521831, 227.5261894396), new Vsop87.LnVsop(9.88E-9, 5.05622576252, 1699.2792165032), new Vsop87.LnVsop(1.059E-8, 0.13477400877, 416.3032501375), new Vsop87.LnVsop(8.19E-9, 2.0194816163, 1056.2005364515), new Vsop87.LnVsop(8.88E-9, 1.75920995401, 1898.3512179396), new Vsop87.LnVsop(1.013E-8, 2.80784883642, 1464.6394800628), new Vsop87.LnVsop(7.91E-9, 4.92419444433, 1055.4497769261), new Vsop87.LnVsop(7.74E-9, 1.91132974373, 2111.6503133776), new Vsop87.LnVsop(7.29E-9, 3.2901665697, 628.8515860501), new Vsop87.LnVsop(7.43E-9, 2.65216075794, 106.2741679563), new Vsop87.LnVsop(7.19E-9, 2.95858266157, 2008.557539159), new Vsop87.LnVsop(6.93E-9, 0.10835603179, 963.4027029714), new Vsop87.LnVsop(8.28E-9, 2.72900314719, 618.5566453116), new Vsop87.LnVsop(7.77E-9, 1.63387777696, 2001.4439921582), new Vsop87.LnVsop(6.51E-9, 1.1926797813, 422.6660376129), new Vsop87.LnVsop(6.81E-9, 5.47481858348, 5760.4984318976), new Vsop87.LnVsop(6.81E-9, 3.11621018972, 5746.271337896), new Vsop87.LnVsop(6.44E-9, 4.68534695662, 611.4430983108), new Vsop87.LnVsop(6.65E-9, 1.86713865983, 2104.5367663768), new Vsop87.LnVsop(6.29E-9, 3.05748834184, 380.12776796), new Vsop87.LnVsop(6.37E-9, 1.8573150656, 636.7158925763), new Vsop87.LnVsop(7.15E-9, 3.04974505007, 2221.856634597), new Vsop87.LnVsop(6.35E-9, 4.53916560604, 9676.4810341156), new Vsop87.LnVsop(6.35E-9, 0.61458920732, 9690.7081281172), new Vsop87.LnVsop(8.21E-9, 6.24663887828, 423.4167971383), new Vsop87.LnVsop(7.64E-9, 4.32616763486, 1802.3719907218), new Vsop87.LnVsop(5.81E-9, 0.83633087877, 1891.2376709388), new Vsop87.LnVsop(6.38E-9, 2.83653046158, 1905.4647649404), new Vsop87.LnVsop(5.58E-9, 3.96114629751, 440.8252848776), new Vsop87.LnVsop(6.23E-9, 1.2271148801, 1382.8873468466), new Vsop87.LnVsop(7.11E-9, 3.43507379865, 824.7421937488), new Vsop87.LnVsop(5.16E-9, 1.10671630111, 107.0249274817), new Vsop87.LnVsop(5.35E-9, 1.5591428253, 1994.3304451574), new Vsop87.LnVsop(5.48E-9, 4.39997113815, 647.0108333148), new Vsop87.LnVsop(4.12E-9, 1.25354625957, 203.0041546995), new Vsop87.LnVsop(4.14E-9, 2.66777275564, 2324.9494088156), new Vsop87.LnVsop(5.33E-9, 2.55533346856, 1781.0313497194), new Vsop87.LnVsop(3.93E-9, 1.26401319046, 210.1177017003), new Vsop87.LnVsop(4.28E-9, 1.47563898333, 2214.7430875962), new Vsop87.LnVsop(4.17E-9, 2.8828219421, 1063.3140834523), new Vsop87.LnVsop(4.31E-9, 5.0033713277, 3178.1457905676), new Vsop87.LnVsop(4.04E-9, 3.51234818882, 2751.5475996916), new Vsop87.LnVsop(4.33E-9, 4.29604508638, 5753.3848848968), new Vsop87.LnVsop(3.11E-9, 0.32531359824, 2655.5683724738), new Vsop87.LnVsop(3.15E-9, 0.16909542121, 1279.794572628), new Vsop87.LnVsop(3.27E-9, 3.36314839669, 1141.1340634054), new Vsop87.LnVsop(3.4E-9, 1.47994765617, 2317.8358618148), new Vsop87.LnVsop(2.8E-9, 5.45018668393, 2228.9701815978), new Vsop87.LnVsop(2.86E-9, 1.69087245649, 2420.9286360334), new Vsop87.LnVsop(2.72E-9, 0.27466300281, 319.5732633943), new Vsop87.LnVsop(2.85E-9, 2.92648819935, 2957.7331481288), new Vsop87.LnVsop(2.42E-9, 6.23321763999, 934.9485149682), new Vsop87.LnVsop(2.65E-9, 0.35799742793, 2840.4132799086), new Vsop87.LnVsop(2.47E-9, 2.41874119352, 1251.3403846248), new Vsop87.LnVsop(3.03E-9, 2.43034117616, 70.8494453042), new Vsop87.LnVsop(2.51E-9, 0.43544711316, 3259.8979237838), new Vsop87.LnVsop(2.26E-9, 4.49396746521, 5223.6939198022), new Vsop87.LnVsop(2.33E-9, 5.48382095726, 1603.2999892854), new Vsop87.LnVsop(2.72E-9, 2.98590404673, 1457.525933062), new Vsop87.LnVsop(2.85E-9, 2.60754102796, 2538.2485042536), new Vsop87.LnVsop(2.07E-9, 5.94297320087, 9153.9036160218), new Vsop87.LnVsop(2.83E-9, 2.0285798662, 3171.0322435668), new Vsop87.LnVsop(2.91E-9, 5.14022289511, 1592.2542890215), new Vsop87.LnVsop(2.33E-9, 2.70967928648, 1354.4331588434), new Vsop87.LnVsop(2.68E-9, 5.02822905034, 2015.6710861598), new Vsop87.LnVsop(2.39E-9, 1.57690386034, 2744.4340526908), new Vsop87.LnVsop(2.84E-9, 2.27103340038, 2854.6403739102), new Vsop87.LnVsop(2.54E-9, 1.36546010277, 3370.1042450032), new Vsop87.LnVsop(2.21E-9, 1.17223735868, 3053.7123753466), new Vsop87.LnVsop(2.24E-9, 1.28623905132, 3060.8259223474), new Vsop87.LnVsop(2.05E-9, 3.3051071358, 3384.3313390048), new Vsop87.LnVsop(2.22E-9, 0.63302066932, 3163.918696566), new Vsop87.LnVsop(1.88E-9, 6.00513627145, 92.0470739547), new Vsop87.LnVsop(1.93E-9, 1.57356589213, 2428.0421830342), new Vsop87.LnVsop(2.47E-9, 2.25464204265, 2097.423219376), new Vsop87.LnVsop(1.98E-9, 2.56172919362, 2641.3412784722), new Vsop87.LnVsop(2.03E-9, 3.40598495601, 99.1606209555), new Vsop87.LnVsop(1.79E-9, 0.54218881357, 2207.6295405954), new Vsop87.LnVsop(1.78E-9, 5.56443381281, 2332.0629558164), new Vsop87.LnVsop(1.76E-9, 1.4307064011, 945.9942152321), new Vsop87.LnVsop(2.22E-9, 3.6678313844, 113.3877149571), new Vsop87.LnVsop(1.78E-9, 0.64947535071, 1176.7017984094), new Vsop87.LnVsop(1.99E-9, 1.14834144531, 2531.1349572528), new Vsop87.LnVsop(1.66E-9, 4.09266431951, 6283.0758499914), new Vsop87.LnVsop(1.83E-9, 1.27422647789, 2310.722314814), new Vsop87.LnVsop(2.27E-9, 1.68715930646, 1567.7322542814), new Vsop87.LnVsop(1.88E-9, 4.32227206118, 1069.6768709277), new Vsop87.LnVsop(2.25E-9, 3.69300117786, 2435.155730035), new Vsop87.LnVsop(1.62E-9, 3.60183151152, 3067.9394693482), new Vsop87.LnVsop(2.03E-9, 2.24205059922, 67.6680515665), new Vsop87.LnVsop(1.52E-9, 5.48122906518, 10213.285546211), new Vsop87.LnVsop(1.91E-9, 2.68685722531, 1773.9178027186), new Vsop87.LnVsop(1.89E-9, 2.95184731936, 732.6951197941), new Vsop87.LnVsop(1.78E-9, 2.63197229299, 3274.1250177854), new Vsop87.LnVsop(1.68E-9, 5.38131391591, 1585.1407420207), new Vsop87.LnVsop(1.52E-9, 1.52826598178, 2950.619601128), new Vsop87.LnVsop(1.72E-9, 1.85377970325, 2413.8150890326), new Vsop87.LnVsop(1.65E-9, 2.69610230323, 952.3570027075), new Vsop87.LnVsop(1.61E-9, 4.77428302161, 1262.3860848887), new Vsop87.LnVsop(1.43E-9, 6.22998196624, 860.3099287528), new Vsop87.LnVsop(1.87E-9, 1.19805936589, 3362.9906980024), new Vsop87.LnVsop(1.34E-9, 2.74105572, 1670.8250285), new Vsop87.LnVsop(1.22E-9, 5.52449599842, 337.732510659), new Vsop87.LnVsop(1.43E-9, 1.20984019641, 2634.2277314714), new Vsop87.LnVsop(1.14E-9, 2.52833228247, 1585.8915015461), new Vsop87.LnVsop(1.36E-9, 2.694238355, 739.8086667949), new Vsop87.LnVsop(1.12E-9, 5.77394476974, 547.8502123593), new Vsop87.LnVsop(1.5E-9, 4.91666030632, 3494.5376602242), new Vsop87.LnVsop(1.19E-9, 5.50342415511, 4113.0943055358), new Vsop87.LnVsop(1.49E-9, 0.81247034524, 3267.0114707846), new Vsop87.LnVsop(1.03E-9, 0.80198707373, 2737.32050569), new Vsop87.LnVsop(1.2E-9, 2.81532905166, 3803.81598288), new Vsop87.LnVsop(1.11E-9, 2.4497372115, 3590.516887442), new Vsop87.LnVsop(1.08E-9, 1.3330108582, 1049.0869894507), new Vsop87.LnVsop(1.33E-9, 0.33542188145, 3156.8051495652), new Vsop87.LnVsop(1.08E-9, 2.55716124258, 4010.0015313172), new Vsop87.LnVsop(1.19E-9, 1.02217622746, 2524.021410252), new Vsop87.LnVsop(1.05E-9, 5.89338290292, 3789.5888888784), new Vsop87.LnVsop(9.4E-10, 0.88652607343, 3377.217792004), new Vsop87.LnVsop(8.6E-10, 1.26934319585, 511.5317178299), new Vsop87.LnVsop(8.2E-10, 4.65514231193, 3281.2385647862), new Vsop87.LnVsop(8.1E-10, 4.55655881694, 4319.279853973), new Vsop87.LnVsop(8.4E-10, 5.52322777064, 4120.2078525366), new Vsop87.LnVsop(7.5E-10, 0.40562636382, 2627.1141844706), new Vsop87.LnVsop(9.9E-10, 3.94867595848, 4017.115078318), new Vsop87.LnVsop(8.0E-10, 0.2815752297, 2847.5268269094), new Vsop87.LnVsop(7.3E-10, 3.52191166845, 2964.8466951296), new Vsop87.LnVsop(9.2E-10, 0.43014320279, 3914.0223040994), new Vsop87.LnVsop(8.3E-10, 0.25202430423, 2644.5226722099)};
        private static final Vsop87.LnVsop[] jupiter_longitude_l3 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(6.501673E-5, 2.5986292365, 7.1135470008), new Vsop87.LnVsop(1.355012E-5, 1.34692775915, 529.6909650946), new Vsop87.LnVsop(4.70691E-6, 2.47502798748, 14.2270940016), new Vsop87.LnVsop(4.16933E-6, 3.24456258569, 536.8045120954), new Vsop87.LnVsop(3.5287E-6, 2.97380410245, 522.5774180938), new Vsop87.LnVsop(1.65699E-6, 2.09182221854, 1059.3819301892), new Vsop87.LnVsop(8.6769E-7, 2.51454300081, 515.463871093), new Vsop87.LnVsop(3.4458E-7, 3.82181443085, 1066.49547719), new Vsop87.LnVsop(2.2671E-7, 2.98178645046, 543.9180590962), new Vsop87.LnVsop(2.376E-7, 1.27416115958, 412.3710968744), new Vsop87.LnVsop(2.8501E-7, 2.44538595164, 206.1855484372), new Vsop87.LnVsop(1.9722E-7, 2.10936654685, 639.897286314), new Vsop87.LnVsop(1.7778E-7, 2.59019838502, 1589.0728952838), new Vsop87.LnVsop(1.9709E-7, 1.40149363982, 419.4846438752), new Vsop87.LnVsop(1.8767E-7, 1.58683219668, 103.0927742186), new Vsop87.LnVsop(1.7015E-7, 2.29975384867, 21.3406410024), new Vsop87.LnVsop(1.6179E-7, 3.1543828742, 625.6701923124), new Vsop87.LnVsop(1.5902E-7, 3.25713655347, 1052.2683831884), new Vsop87.LnVsop(1.3421E-7, 2.76078519881, 95.9792272178), new Vsop87.LnVsop(1.3233E-7, 2.53761666317, 199.0720014364), new Vsop87.LnVsop(1.2676E-7, 6.26512955217, 426.598190876), new Vsop87.LnVsop(8.633E-8, 2.26532712763, 110.2063212194), new Vsop87.LnVsop(6.718E-8, 3.42006598208, 309.2783226558), new Vsop87.LnVsop(8.703E-8, 1.76298942412, 10.2949407385), new Vsop87.LnVsop(6.529E-8, 4.03744539112, 728.762966531), new Vsop87.LnVsop(5.397E-8, 5.2643257077, 323.5054166574), new Vsop87.LnVsop(5.685E-8, 2.51772778746, 508.3503240922), new Vsop87.LnVsop(7.504E-8, 0.0, 0.0), new Vsop87.LnVsop(5.431E-8, 2.90223114269, 1045.1548361876), new Vsop87.LnVsop(3.997E-8, 4.30231913648, 88.865680217), new Vsop87.LnVsop(3.855E-8, 3.52241347275, 302.164775655), new Vsop87.LnVsop(3.811E-8, 4.08897954122, 735.8765135318), new Vsop87.LnVsop(3.232E-8, 1.4797215105, 956.2891559706), new Vsop87.LnVsop(2.931E-8, 4.35694383564, 1596.1864422846), new Vsop87.LnVsop(2.657E-8, 1.27257961451, 213.299095438), new Vsop87.LnVsop(2.556E-8, 2.23303484585, 117.3198682202), new Vsop87.LnVsop(2.414E-8, 2.9182867642, 742.9900605326), new Vsop87.LnVsop(2.657E-8, 5.0155101339, 838.9692877504), new Vsop87.LnVsop(1.935E-8, 2.79590256973, 1169.5882514086), new Vsop87.LnVsop(2.222E-8, 2.39310688825, 942.062061969), new Vsop87.LnVsop(1.605E-8, 3.09964511466, 2118.7638603784), new Vsop87.LnVsop(1.491E-8, 1.55001725357, 220.4126424388), new Vsop87.LnVsop(1.934E-8, 5.0082360231, 831.8557407496), new Vsop87.LnVsop(1.584E-8, 1.40103448632, 405.2575498736), new Vsop87.LnVsop(1.286E-8, 3.46966168288, 1073.6090241908), new Vsop87.LnVsop(1.21E-8, 4.05719633951, 1155.361157407), new Vsop87.LnVsop(9.95E-9, 3.40755481322, 532.8723588323), new Vsop87.LnVsop(8.95E-9, 1.6408692176, 632.7837393132), new Vsop87.LnVsop(9.42E-9, 2.70150730852, 191.9584544356), new Vsop87.LnVsop(8.17E-9, 3.29435640763, 1258.4539316256), new Vsop87.LnVsop(7.21E-9, 1.62926029676, 949.1756089698), new Vsop87.LnVsop(7.45E-9, 1.14787945018, 1162.4747044078), new Vsop87.LnVsop(7.19E-9, 3.7399276487, 433.7117378768), new Vsop87.LnVsop(6.58E-9, 2.90980216736, 1574.8458012822), new Vsop87.LnVsop(6.11E-9, 5.95148659718, 853.196381752), new Vsop87.LnVsop(6.65E-9, 3.54820168197, 525.7588118315), new Vsop87.LnVsop(6.09E-9, 4.14925115671, 721.6494195302), new Vsop87.LnVsop(5.98E-9, 4.69470159905, 81.7521332162), new Vsop87.LnVsop(6.69E-9, 1.94668551888, 1272.6810256272), new Vsop87.LnVsop(6.43E-9, 2.02118053595, 526.5095713569), new Vsop87.LnVsop(5.08E-9, 4.3523913142, 1368.660252845), new Vsop87.LnVsop(5.09E-9, 4.95261621008, 1148.2476104062), new Vsop87.LnVsop(5.64E-9, 3.418796288, 1581.959348283), new Vsop87.LnVsop(5.12E-9, 4.39016117028, 330.6189636582), new Vsop87.LnVsop(5.48E-9, 2.25796919785, 551.031606097), new Vsop87.LnVsop(4.78E-9, 3.8601569376, 1361.5467058442), new Vsop87.LnVsop(3.83E-9, 0.24286568335, 611.4430983108), new Vsop87.LnVsop(4.34E-9, 2.94972316227, 1038.0412891868), new Vsop87.LnVsop(3.76E-9, 1.42987791517, 124.433415221), new Vsop87.LnVsop(3.9E-9, 4.06059870551, 1471.7530270636), new Vsop87.LnVsop(3.85E-9, 4.70313900114, 519.3960243561), new Vsop87.LnVsop(4.28E-9, 2.22447290956, 539.9859058331), new Vsop87.LnVsop(3.94E-9, 4.52891996323, 1464.6394800628), new Vsop87.LnVsop(3.06E-9, 2.0201596447, 1485.9801210652), new Vsop87.LnVsop(2.83E-9, 0.96808839854, 1905.4647649404), new Vsop87.LnVsop(2.78E-9, 4.35223393872, 963.4027029714), new Vsop87.LnVsop(3.09E-9, 3.65940227544, 846.0828347512), new Vsop87.LnVsop(3.42E-9, 4.17369218547, 1788.1448967202), new Vsop87.LnVsop(2.59E-9, 4.0081221811, 1265.5674786264), new Vsop87.LnVsop(2.93E-9, 3.91258428829, 1685.0521225016), new Vsop87.LnVsop(2.59E-9, 1.01628149559, 1478.8665740644), new Vsop87.LnVsop(2.53E-9, 3.12703531515, 1994.3304451574), new Vsop87.LnVsop(2.38E-9, 6.13097565419, 1382.8873468466), new Vsop87.LnVsop(2.2E-9, 4.81059910221, 2125.8774073792), new Vsop87.LnVsop(2.25E-9, 2.51478069462, 1891.2376709388), new Vsop87.LnVsop(2.78E-9, 3.63969386282, 1677.9385755008), new Vsop87.LnVsop(2.42E-9, 2.90163762388, 2310.722314814), new Vsop87.LnVsop(2.42E-9, 3.56541237319, 1699.2792165032), new Vsop87.LnVsop(2.48E-9, 6.02173100984, 750.1036075334), new Vsop87.LnVsop(1.97E-9, 5.17715231546, 618.5566453116), new Vsop87.LnVsop(2.56E-9, 4.19052619061, 1781.0313497194), new Vsop87.LnVsop(1.96E-9, 0.77278217513, 2221.856634597), new Vsop87.LnVsop(1.85E-9, 3.87563539893, 295.0512286542), new Vsop87.LnVsop(2.34E-9, 2.54350140197, 1375.7737998458), new Vsop87.LnVsop(1.84E-9, 3.72826587808, 2538.2485042536), new Vsop87.LnVsop(1.89E-9, 5.74277274755, 2627.1141844706), new Vsop87.LnVsop(1.63E-9, 1.29242716775, 1692.1656695024), new Vsop87.LnVsop(2.18E-9, 3.86704847246, 2104.5367663768), new Vsop87.LnVsop(1.71E-9, 5.25744961028, 824.7421937488), new Vsop87.LnVsop(1.71E-9, 4.17086334577, 2097.423219376), new Vsop87.LnVsop(1.49E-9, 4.30563038349, 2001.4439921582), new Vsop87.LnVsop(1.48E-9, 1.85615806078, 1056.2005364515), new Vsop87.LnVsop(1.55E-9, 4.31124093129, 2317.8358618148), new Vsop87.LnVsop(1.52E-9, 3.97372662088, 1055.4497769261), new Vsop87.LnVsop(1.47E-9, 1.55828353595, 227.5261894396), new Vsop87.LnVsop(1.96E-9, 2.21259819908, 934.9485149682), new Vsop87.LnVsop(1.6E-9, 1.77096189842, 1141.1340634054), new Vsop87.LnVsop(1.32E-9, 3.78618524413, 1062.5633239269), new Vsop87.LnVsop(1.79E-9, 5.57450109164, 1354.4331588434), new Vsop87.LnVsop(1.21E-9, 3.84004974551, 2634.2277314714), new Vsop87.LnVsop(1.18E-9, 1.43347687364, 1279.794572628), new Vsop87.LnVsop(1.24E-9, 3.41965347556, 2648.454825473), new Vsop87.LnVsop(1.62E-9, 2.01594918927, 533.6231183577), new Vsop87.LnVsop(1.06E-9, 3.26215180863, 2207.6295405954), new Vsop87.LnVsop(1.07E-9, 0.88798638307, 1670.8250285), new Vsop87.LnVsop(1.07E-9, 0.60623932999, 2413.8150890326), new Vsop87.LnVsop(8.2E-10, 0.40279200309, 2950.619601128), new Vsop87.LnVsop(8.0E-10, 2.0682207944, 3060.8259223474), new Vsop87.LnVsop(8.3E-10, 2.43109843716, 2428.0421830342), new Vsop87.LnVsop(7.9E-10, 3.80336766578, 1603.2999892854)};
        private static final Vsop87.LnVsop[] jupiter_longitude_l4 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(6.69505E-6, 0.85280378158, 7.1135470008), new Vsop87.LnVsop(9.9965E-7, 0.74243651986, 14.2270940016), new Vsop87.LnVsop(5.003E-7, 1.65383477095, 536.8045120954), new Vsop87.LnVsop(4.369E-7, 5.81923759985, 529.6909650946), new Vsop87.LnVsop(3.1794E-7, 4.85865051639, 522.5774180938), new Vsop87.LnVsop(1.4735E-7, 4.29065528652, 515.463871093), new Vsop87.LnVsop(8.408E-8, 0.68386181768, 1059.3819301892), new Vsop87.LnVsop(4.926E-8, 1.29899425511, 543.9180590962), new Vsop87.LnVsop(4.563E-8, 2.31453670801, 1066.49547719), new Vsop87.LnVsop(4.254E-8, 0.48193363691, 21.3406410024), new Vsop87.LnVsop(3.1E-8, 3.00251285081, 412.3710968744), new Vsop87.LnVsop(2.053E-8, 0.39854167561, 639.897286314), new Vsop87.LnVsop(1.764E-8, 4.90551864257, 625.6701923124), new Vsop87.LnVsop(1.901E-8, 4.2566097793, 199.0720014364), new Vsop87.LnVsop(1.69E-8, 4.25228443627, 206.1855484372), new Vsop87.LnVsop(1.345E-8, 5.06309624095, 1052.2683831884), new Vsop87.LnVsop(1.211E-8, 4.7143259874, 95.9792272178), new Vsop87.LnVsop(1.091E-8, 1.32037613765, 1589.0728952838), new Vsop87.LnVsop(9.71E-9, 5.67505418481, 728.762966531), new Vsop87.LnVsop(9.35E-9, 6.05626917469, 88.865680217), new Vsop87.LnVsop(9.41E-9, 4.66216576341, 1045.1548361876), new Vsop87.LnVsop(9.07E-9, 4.56755235537, 426.598190876), new Vsop87.LnVsop(7.83E-9, 3.39826306476, 419.4846438752), new Vsop87.LnVsop(7.63E-9, 3.509082399, 103.0927742186), new Vsop87.LnVsop(7.37E-9, 0.53486231851, 110.2063212194), new Vsop87.LnVsop(4.13E-9, 5.21759457392, 302.164775655), new Vsop87.LnVsop(3.97E-9, 6.22333486636, 956.2891559706), new Vsop87.LnVsop(3.75E-9, 5.22028842158, 309.2783226558), new Vsop87.LnVsop(3.57E-9, 4.7713238136, 508.3503240922), new Vsop87.LnVsop(4.22E-9, 0.58114211624, 117.3198682202), new Vsop87.LnVsop(3.18E-9, 3.51963719294, 323.5054166574), new Vsop87.LnVsop(3.53E-9, 4.07385033829, 942.062061969), new Vsop87.LnVsop(3.18E-9, 0.47985672138, 831.8557407496), new Vsop87.LnVsop(2.51E-9, 1.79670889239, 1073.6090241908), new Vsop87.LnVsop(2.55E-9, 2.93957928902, 1596.1864422846), new Vsop87.LnVsop(2.1E-9, 0.42245785278, 220.4126424388), new Vsop87.LnVsop(1.88E-9, 1.11282762167, 1169.5882514086), new Vsop87.LnVsop(1.87E-9, 2.15988498485, 1361.5467058442), new Vsop87.LnVsop(1.8E-9, 3.44457638757, 1148.2476104062), new Vsop87.LnVsop(1.57E-9, 3.04524492827, 1272.6810256272), new Vsop87.LnVsop(1.73E-9, 5.21493846901, 1581.959348283), new Vsop87.LnVsop(1.6E-9, 1.91340275752, 2118.7638603784), new Vsop87.LnVsop(1.94E-9, 4.74134167991, 1155.361157407), new Vsop87.LnVsop(1.19E-9, 2.25819104081, 330.6189636582), new Vsop87.LnVsop(1.27E-9, 1.67407621995, 1891.2376709388), new Vsop87.LnVsop(1.31E-9, 0.52395207361, 551.031606097), new Vsop87.LnVsop(9.9E-10, 3.45749497992, 647.0108333148), new Vsop87.LnVsop(7.7E-10, 3.29690316802, 1368.660252845)};
        private static final Vsop87.LnVsop[] jupiter_longitude_l5 = new Vsop87.LnVsop[]{new Vsop87.LnVsop(4.9639E-7, 5.2576992477, 7.1135470008), new Vsop87.LnVsop(1.5775E-7, 5.24859620238, 14.2270940016), new Vsop87.LnVsop(4.326E-8, 0.02660738929, 536.8045120954), new Vsop87.LnVsop(1.573E-8, 1.18411087933, 522.5774180938), new Vsop87.LnVsop(8.19E-9, 5.86582284529, 543.9180590962), new Vsop87.LnVsop(7.24E-9, 0.88277941285, 515.463871093), new Vsop87.LnVsop(3.6E-9, 0.78335749573, 1066.49547719), new Vsop87.LnVsop(3.19E-9, 5.73095137303, 1059.3819301892), new Vsop87.LnVsop(1.98E-9, 0.04372566049, 1589.0728952838), new Vsop87.LnVsop(1.07E-9, 0.09298499958, 1073.6090241908), new Vsop87.LnVsop(7.9E-10, 6.16619004945, 529.6909650946)};

        Lontitude() {
        }
    }
}

