/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt;

import de.kah2.zodiac.nova4jmt.api.LnDms;
import de.kah2.zodiac.nova4jmt.api.LnEquPosn;
import de.kah2.zodiac.nova4jmt.api.LnHms;
import de.kah2.zodiac.nova4jmt.api.LnHrzPosn;
import de.kah2.zodiac.nova4jmt.api.LnLnlatPosn;
import de.kah2.zodiac.nova4jmt.api.LnRectPosn;
import de.kah2.zodiac.nova4jmt.api.LnhEquPosn;
import de.kah2.zodiac.nova4jmt.api.LnhHrzPosn;
import de.kah2.zodiac.nova4jmt.api.LnhLnlatPosn;
import de.kah2.zodiac.nova4jmt.util.Tokens;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Properties;

public class Utility {
    private static final BigDecimal D2R = new BigDecimal("0.017453292519943295769");
    private static final double R2D = 57.29577951308232;

    public static String ln_get_version() {
        Properties pomProps = new Properties();
        try {
            InputStream in = Utility.class.getClassLoader().getResourceAsStream("META-INF/maven/net.sourceforge.novaforjava/novaforjava/pom.properties");
            if (in == null) {
                in = new FileInputStream(new File("target/maven-archiver/pom.properties"));
            }
            pomProps.load(in);
            in.close();
        }
        catch (IOException e) {
            new IllegalArgumentException("Could not load version info ", e);
        }
        return pomProps.getProperty("version");
    }

    public static double ln_rad_to_deg(double radians) {
        return radians * 57.29577951308232;
    }

    public static double ln_deg_to_rad(double degrees) {
        return degrees * D2R.doubleValue();
    }

    public static BigDecimal ln_deg_to_rad(BigDecimal degrees) {
        return degrees.multiply(D2R);
    }

    public static double ln_hms_to_deg(LnHms hms) {
        double degrees = (double)hms.hours / 24.0 * 360.0;
        degrees += (double)hms.minutes / 60.0 * 15.0;
        return degrees += hms.seconds / 60.0 * 0.25;
    }

    public static double ln_hms_to_rad(LnHms hms) {
        double radians = (double)hms.hours / 24.0 * 2.0 * Math.PI;
        radians += (double)hms.minutes / 60.0 * 2.0 * Math.PI / 24.0;
        return radians += hms.seconds / 60.0 * 2.0 * Math.PI / 1440.0;
    }

    public static void ln_deg_to_hms(double degrees, LnHms hms) {
        degrees = Utility.ln_range_degrees(degrees);
        double dtemp = degrees / 15.0;
        hms.hours = (int)dtemp;
        dtemp = 60.0 * (dtemp - (double)hms.hours);
        hms.minutes = (int)dtemp;
        hms.seconds = 60.0 * (dtemp - (double)hms.minutes);
        if (hms.seconds > 59.0) {
            hms.seconds = 0.0;
            ++hms.minutes;
        }
        if (hms.minutes > 59) {
            hms.minutes = 0;
            ++hms.hours;
        }
    }

    public static void ln_rad_to_hms(double radians, LnHms hms) {
        radians = Utility.ln_range_radians(radians);
        double degrees = Utility.ln_rad_to_deg(radians);
        Utility.ln_deg_to_hms(degrees, hms);
    }

    public static double ln_dms_to_deg(LnDms dms) {
        double degrees = Math.abs((double)dms.degrees);
        degrees += Math.abs((double)dms.minutes / 60.0);
        degrees += Math.abs(dms.seconds / 3600.0);
        if (dms.neg != 0) {
            degrees *= -1.0;
        }
        return degrees;
    }

    public static double ln_dms_to_rad(LnDms dms) {
        double radians = Math.abs((double)dms.degrees / 360.0 * 2.0 * Math.PI);
        radians += Math.abs((double)dms.minutes / 21600.0 * 2.0 * Math.PI);
        radians += Math.abs(dms.seconds / 1296000.0 * 2.0 * Math.PI);
        if (dms.neg != 0) {
            radians *= -1.0;
        }
        return radians;
    }

    public static void ln_deg_to_dms(double degrees, LnDms dms) {
        dms.neg = degrees >= 0.0 ? 0 : 1;
        degrees = Math.abs(degrees);
        dms.degrees = (int)degrees;
        double dtemp = 60.0 * (degrees - (double)dms.degrees);
        dms.minutes = (int)dtemp;
        dms.seconds = 60.0 * (dtemp - (double)dms.minutes);
        if (dms.seconds > 59.0) {
            dms.seconds = 0.0;
            ++dms.minutes;
        }
        if (dms.minutes > 59) {
            dms.minutes = 0;
            ++dms.degrees;
        }
    }

    public static void ln_rad_to_dms(double radians, LnDms dms) {
        double degrees = Utility.ln_rad_to_deg(radians);
        Utility.ln_deg_to_dms(degrees, dms);
    }

    public static double ln_range_degrees(double angle) {
        if (angle >= 0.0 && angle < 360.0) {
            return angle;
        }
        double temp = (int)(angle / 360.0);
        if (angle < 0.0) {
            temp -= 1.0;
        }
        return angle - (temp *= 360.0);
    }

    public static double ln_range_radians(double angle) {
        if (angle >= 0.0 && angle < Math.PI * 2) {
            return angle;
        }
        double temp = (int)(angle / (Math.PI * 2));
        if (angle < 0.0) {
            temp -= 1.0;
        }
        return angle - (temp *= Math.PI * 2);
    }

    public static double ln_range_radians2(double angle) {
        if (angle > Math.PI * -2 && angle < Math.PI * 2) {
            return angle;
        }
        double temp = (int)(angle / (Math.PI * 2));
        return angle - (temp *= Math.PI * 2);
    }

    public static void ln_add_secs_hms(LnHms hms, double seconds) {
        LnHms source_hms = new LnHms();
        source_hms.hours = (int)(seconds / 3600.0);
        source_hms.minutes = (int)((seconds -= (double)(source_hms.hours * 3600)) / 60.0);
        source_hms.seconds = seconds -= (double)(source_hms.minutes * 60);
        Utility.ln_add_hms(source_hms, hms);
    }

    public static void ln_add_hms(LnHms source, LnHms dest) {
        dest.seconds += source.seconds;
        if (dest.seconds >= 60.0) {
            ++source.minutes;
            dest.seconds -= 60.0;
        } else if (dest.seconds < 0.0) {
            --source.minutes;
            dest.seconds += 60.0;
        }
        dest.minutes += source.minutes;
        if (dest.minutes >= 60) {
            ++source.hours;
            dest.minutes -= 60;
        } else if (dest.seconds < 0.0) {
            --source.hours;
            dest.minutes += 60;
        }
        dest.hours += source.hours;
    }

    public static void ln_hequ_to_equ(LnhEquPosn hpos, LnEquPosn pos) {
        pos.ra = Utility.ln_hms_to_deg(hpos.ra);
        pos.dec = Utility.ln_dms_to_deg(hpos.dec);
    }

    public static void ln_equ_to_hequ(LnEquPosn pos, LnhEquPosn hpos) {
        Utility.ln_deg_to_hms(pos.ra, hpos.ra);
        Utility.ln_deg_to_dms(pos.dec, hpos.dec);
    }

    public static void ln_hhrz_to_hrz(LnhHrzPosn hpos, LnHrzPosn pos) {
        pos.alt = Utility.ln_dms_to_deg(hpos.alt);
        pos.az = Utility.ln_dms_to_deg(hpos.az);
    }

    public static void ln_hrz_to_hhrz(LnHrzPosn pos, LnhHrzPosn hpos) {
        Utility.ln_deg_to_dms(pos.alt, hpos.alt);
        Utility.ln_deg_to_dms(pos.az, hpos.az);
    }

    public static String ln_hrz_to_nswe(LnHrzPosn pos) {
        String[] directions = new String[]{"S", "SSW", "SW", "SWW", "W", "NWW", "NW", "NNW", "N", "NNE", "NE", "NEE", "E", "SEE", "SE", "SSE"};
        return directions[(int)(pos.az / 22.5)];
    }

    public static void ln_hlnlat_to_lnlat(LnhLnlatPosn hpos, LnLnlatPosn pos) {
        pos.lng = Utility.ln_dms_to_deg(hpos.lng);
        pos.lat = Utility.ln_dms_to_deg(hpos.lat);
    }

    public static void ln_lnlat_to_hlnlat(LnLnlatPosn pos, LnhLnlatPosn hpos) {
        Utility.ln_deg_to_dms(pos.lng, hpos.lng);
        Utility.ln_deg_to_dms(pos.lat, hpos.lat);
    }

    public static double ln_get_rect_distance(LnRectPosn a, LnRectPosn b) {
        double x = a.X - b.X;
        double y = a.Y - b.Y;
        double z = a.Z - b.Z;
        x *= x;
        y *= y;
        z *= z;
        return Math.sqrt(x + y + z);
    }

    public static double ln_get_light_time(double dist) {
        return dist * 0.005775183;
    }

    public static String trim(String x) {
        int index = x.length() - 1;
        while (Character.isWhitespace(x.charAt(index))) {
            --index;
        }
        return x.substring(0, index + 1);
    }

    public static double ln_get_dec_location(String s) {
        Tokens tokens;
        Type type;
        int hh;
        boolean negative = false;
        char[] delim1 = " :.,;DdHhMm'\n\t".toCharArray();
        char[] delim2 = " NSEWnsew\"\n\t".toCharArray();
        int dghh = 0;
        int minutes = 0;
        double seconds = 0.0;
        if (s == null || s.isEmpty()) {
            return -0.0;
        }
        int ptrIndex = 0;
        String ptr = s.trim();
        if (ptr.charAt(ptrIndex) == '+' || ptr.charAt(ptrIndex) == '-') {
            boolean bl = negative = ptr.charAt(ptrIndex++) == '-' ? true : negative;
        }
        if (Utility.indexOneOf(ptr, 'S', 's', 'W', 'w') >= 0) {
            negative = true;
        }
        if ((hh = Utility.indexOneOf(ptr = ptr.substring(ptrIndex).trim(), 'H', 'h')) >= 0 && hh < 3) {
            type = Type.HOURS;
            if (negative) {
                negative = false;
            }
        } else {
            int ame = Utility.indexOneOf(ptr, 'S', 's', 'N', 'n');
            if (ame >= 0) {
                type = Type.LAT;
                if (ame == 0) {
                    ptr = ptr.substring(1);
                }
            } else {
                type = Type.DEGREES;
            }
        }
        if ((ptr = (tokens = new Tokens(ptr, delim1)).nextToken()) == null) {
            return -0.0;
        }
        dghh = Integer.parseInt(ptr);
        ptr = tokens.nextToken();
        if (ptr != null) {
            minutes = Integer.parseInt(ptr);
            if (minutes > 59) {
                return -0.0;
            }
        } else {
            return -0.0;
        }
        ptr = tokens.nextToken(delim2);
        if (ptr != null) {
            ptr.replaceFirst("\\.", ",");
            seconds = Double.parseDouble(ptr);
            if (seconds >= 60.0) {
                return -0.0;
            }
        }
        if ((ptr = tokens.nextToken(" \n\t".toCharArray())) != null) {
            while (Character.isWhitespace(ptr.charAt(0))) {
                ptr = ptr.substring(1);
            }
            if (ptr.charAt(0) == 'S' || ptr.charAt(0) == 'W' || ptr.charAt(0) == 's' || ptr.charAt(0) == 'w') {
                negative = true;
            }
        }
        double pos = (double)dghh + (double)minutes / 60.0 + seconds / 3600.0;
        if (type == Type.HOURS && pos > 24.0) {
            return -0.0;
        }
        if (type == Type.LAT && pos > 90.0) {
            return -0.0;
        }
        if (negative) {
            pos = 0.0 - pos;
        }
        return pos;
    }

    public static String ln_get_humanr_location(double location) {
        double deg = 0.0;
        double min = 0.0;
        double sec = 0.0;
        BigDecimal[] split = new BigDecimal(location).divideAndRemainder(BigDecimal.ONE);
        deg = split[0].doubleValue();
        sec = 60.0 * split[1].doubleValue();
        if (sec < 0.0) {
            sec *= -1.0;
        }
        split = new BigDecimal(sec).divideAndRemainder(BigDecimal.ONE);
        min = split[0].doubleValue();
        sec = 60.0 * split[1].doubleValue();
        return String.format("%+d\u00ba%d'%.2f\"", (int)deg, (int)min, sec);
    }

    public static double ln_interpolate3(double n, double y1, double y2, double y3) {
        double a = y2 - y1;
        double b = y3 - y2;
        double c = b - a;
        double y = y2 + n / 2.0 * (a + b + n * c);
        return y;
    }

    public static double ln_interpolate5(double n, double y1, double y2, double y3, double y4, double y5) {
        double A = y2 - y1;
        double B = y3 - y2;
        double C = y4 - y3;
        double D = y5 - y4;
        double E = B - A;
        double F = C - B;
        double G = D - C;
        double H = F - E;
        double J = G - F;
        double K = J - H;
        double y = 0.0;
        double n2 = n * n;
        double n3 = n2 * n;
        double n4 = n3 * n;
        y += y3;
        y += n * ((B + C) / 2.0 - (H + J) / 12.0);
        y += n2 * (F / 2.0 - K / 24.0);
        y += n3 * ((H + J) / 12.0);
        return y += n4 * (K / 24.0);
    }

    public static double cbrt(double x) {
        return Math.pow(x, 0.3333333333333333);
    }

    public static double nan(String code) {
        return Double.NaN;
    }

    private static int indexOneOf(String string, char ... chars) {
        int index = Integer.MAX_VALUE;
        for (int charIndex = 0; charIndex < chars.length; ++charIndex) {
            int currentIndex = string.indexOf(chars[index]);
            if (currentIndex < 0) continue;
            index = Math.min(currentIndex, index);
        }
        if (index == Integer.MAX_VALUE) {
            return -1;
        }
        return index;
    }

    private static enum Type {
        HOURS,
        DEGREES,
        LAT,
        LONG;

    }
}

