/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt;

import de.kah2.zodiac.nova4jmt.DynamicalTime;
import de.kah2.zodiac.nova4jmt.SiderealTime;
import de.kah2.zodiac.nova4jmt.Utility;
import de.kah2.zodiac.nova4jmt.api.LnEquPosn;
import de.kah2.zodiac.nova4jmt.api.LnLnlatPosn;
import de.kah2.zodiac.nova4jmt.api.LnRstTime;
import de.kah2.zodiac.nova4jmt.util.IGetEquBodyCoords;
import de.kah2.zodiac.nova4jmt.util.IGetMotionBodyCoords;
import java.math.BigDecimal;

public class RiseSet {
    public static final BigDecimal LN_STAR_STANDART_HORIZON = new BigDecimal(-0.5667);

    public static int check_coords(LnLnlatPosn observer, double H1, BigDecimal horizon, LnEquPosn object) {
        return RiseSet.check_coords(observer, H1, horizon.doubleValue(), object);
    }

    public static int check_coords(LnLnlatPosn observer, double H1, double horizon, LnEquPosn object) {
        if (Math.abs(H1) > 1.0) {
            double h = 90.0 + object.dec - observer.lat;
            if (h > 90.0) {
                h = 180.0 - h;
            }
            if (h < -90.0) {
                h = -180.0 - h;
            }
            if (h < horizon) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public static int ln_get_object_rst(double JD, LnLnlatPosn observer, LnEquPosn object, LnRstTime rst) {
        return RiseSet.ln_get_object_rst_horizon(JD, observer, object, LN_STAR_STANDART_HORIZON, rst);
    }

    public static int ln_get_object_rst_horizon(double JD, LnLnlatPosn observer, LnEquPosn object, BigDecimal horizon, LnRstTime rst) {
        return RiseSet.ln_get_object_rst_horizon_offset(JD, observer, object, horizon, rst, 0.5);
    }

    public static int ln_get_object_rst_horizon_offset(double JD, LnLnlatPosn observer, LnEquPosn object, BigDecimal horizon, LnRstTime rst, double ut_offset) {
        double JD_UT;
        if (Double.isNaN(ut_offset)) {
            JD_UT = JD;
        } else {
            int jd = (int)JD;
            JD_UT = (double)jd + ut_offset;
        }
        double O = SiderealTime.ln_get_apparent_sidereal_time(JD_UT);
        O *= 15.0;
        double H0 = Math.sin(Utility.ln_deg_to_rad(horizon.doubleValue())) - Math.sin(Utility.ln_deg_to_rad(observer.lat)) * Math.sin(Utility.ln_deg_to_rad(object.dec));
        double H1 = Math.cos(Utility.ln_deg_to_rad(observer.lat)) * Math.cos(Utility.ln_deg_to_rad(object.dec));
        H1 = H0 / H1;
        int ret = RiseSet.check_coords(observer, H1, horizon, object);
        if (ret != 0) {
            return ret;
        }
        H0 = Math.acos(H1);
        H0 = Utility.ln_rad_to_deg(H0);
        double mt = (object.ra - observer.lng - O) / 360.0;
        double mr = mt - H0 / 360.0;
        double ms = mt + H0 / 360.0;
        for (int i = 0; i < 3; ++i) {
            if (mt > 1.0) {
                mt -= 1.0;
            } else if (mt < 0.0) {
                mt += 1.0;
            }
            if (mr > 1.0) {
                mr -= 1.0;
            } else if (mr < 0.0) {
                mr += 1.0;
            }
            if (ms > 1.0) {
                ms -= 1.0;
            } else if (ms < 0.0) {
                ms += 1.0;
            }
            double mst = O + 360.985647 * mt;
            double msr = O + 360.985647 * mr;
            double mss = O + 360.985647 * ms;
            double Hat = mst + observer.lng - object.ra;
            double Har = msr + observer.lng - object.ra;
            double Has = mss + observer.lng - object.ra;
            double altr = Math.sin(Utility.ln_deg_to_rad(observer.lat)) * Math.sin(Utility.ln_deg_to_rad(object.dec)) + Math.cos(Utility.ln_deg_to_rad(observer.lat)) * Math.cos(Utility.ln_deg_to_rad(object.dec)) * Math.cos(Utility.ln_deg_to_rad(Har));
            double alts = Math.sin(Utility.ln_deg_to_rad(observer.lat)) * Math.sin(Utility.ln_deg_to_rad(object.dec)) + Math.cos(Utility.ln_deg_to_rad(observer.lat)) * Math.cos(Utility.ln_deg_to_rad(object.dec)) * Math.cos(Utility.ln_deg_to_rad(Has));
            altr = Utility.ln_rad_to_deg(altr);
            alts = Utility.ln_rad_to_deg(alts);
            Utility.ln_range_degrees(Hat);
            if (Hat > 180.0) {
                Hat -= 360.0;
            }
            double dmt = -(Hat / 360.0);
            double dmr = (altr - horizon.doubleValue()) / (360.0 * Math.cos(Utility.ln_deg_to_rad(object.dec)) * Math.cos(Utility.ln_deg_to_rad(observer.lat)) * Math.sin(Utility.ln_deg_to_rad(Har)));
            double dms = (alts - horizon.doubleValue()) / (360.0 * Math.cos(Utility.ln_deg_to_rad(object.dec)) * Math.cos(Utility.ln_deg_to_rad(observer.lat)) * Math.sin(Utility.ln_deg_to_rad(Has)));
            if ((mt += dmt) <= 1.0 && mt >= 0.0 && (mr += dmr) <= 1.0 && mr >= 0.0 && (ms += dms) <= 1.0 && ms >= 0.0) break;
        }
        rst.rise = JD_UT + mr;
        rst.transit = JD_UT + mt;
        rst.set = JD_UT + ms;
        return 0;
    }

    public static int ln_get_object_next_rst(double JD, LnLnlatPosn observer, LnEquPosn object, LnRstTime rst) {
        return RiseSet.ln_get_object_next_rst_horizon(JD, observer, object, LN_STAR_STANDART_HORIZON, rst);
    }

    public static void set_next_rst(LnRstTime rst, double diff, LnRstTime out) {
        out.rise = rst.rise + diff;
        out.transit = rst.transit + diff;
        out.set = rst.set + diff;
    }

    public static double find_next(double JD, double jd1, double jd2, double jd3) {
        if (Double.isNaN(jd1) && Double.isNaN(jd2)) {
            return jd3;
        }
        if (JD < jd1) {
            return jd1;
        }
        if (JD < jd2) {
            return jd2;
        }
        return jd3;
    }

    public static int ln_get_object_next_rst_horizon(double JD, LnLnlatPosn observer, LnEquPosn object, BigDecimal horizon, LnRstTime rst) {
        LnRstTime rst_1 = new LnRstTime();
        LnRstTime rst_2 = new LnRstTime();
        int ret = RiseSet.ln_get_object_rst_horizon_offset(JD, observer, object, horizon, rst, Utility.nan("0"));
        if (ret != 0) {
            return ret;
        }
        if (rst.rise > JD + 0.5 || rst.transit > JD + 0.5 || rst.set > JD + 0.5) {
            RiseSet.ln_get_object_rst_horizon_offset(JD - 1.0, observer, object, horizon, rst_1, Utility.nan("0"));
        } else {
            RiseSet.set_next_rst(rst, -1.0, rst_1);
        }
        if (rst.rise < JD || rst.transit < JD || rst.set < JD) {
            RiseSet.ln_get_object_rst_horizon_offset(JD + 1.0, observer, object, horizon, rst_2, Utility.nan("0"));
        } else {
            RiseSet.set_next_rst(rst, 1.0, rst_2);
        }
        rst.rise = RiseSet.find_next(JD, rst_1.rise, rst.rise, rst_2.rise);
        rst.transit = RiseSet.find_next(JD, rst_1.transit, rst.transit, rst_2.transit);
        rst.set = RiseSet.find_next(JD, rst_1.set, rst.set, rst_2.set);
        if (Double.isNaN(rst.rise)) {
            return ret;
        }
        return 0;
    }

    public static int ln_get_body_rst_horizon(double JD, LnLnlatPosn observer, IGetEquBodyCoords get_equ_body_coords, double horizon, LnRstTime rst) {
        return RiseSet.ln_get_body_rst_horizon_offset(JD, observer, get_equ_body_coords, horizon, rst, 0.5);
    }

    public static int ln_get_body_rst_horizon_offset(double JD, LnLnlatPosn observer, IGetEquBodyCoords get_equ_body_coords, double horizon, LnRstTime rst, double ut_offset) {
        double JD_UT;
        LnEquPosn sol1 = new LnEquPosn();
        LnEquPosn sol2 = new LnEquPosn();
        LnEquPosn sol3 = new LnEquPosn();
        LnEquPosn post = new LnEquPosn();
        LnEquPosn posr = new LnEquPosn();
        LnEquPosn poss = new LnEquPosn();
        double T = DynamicalTime.ln_get_dynamical_time_diff(JD);
        if (Double.isNaN(ut_offset)) {
            JD_UT = JD;
        } else {
            int jd = (int)JD;
            JD_UT = (double)jd + ut_offset;
        }
        JD_UT = JD;
        double O = SiderealTime.ln_get_apparent_sidereal_time(JD_UT);
        O *= 15.0;
        get_equ_body_coords.get_equ_body_coords(JD_UT - 1.0, sol1);
        get_equ_body_coords.get_equ_body_coords(JD_UT, sol2);
        get_equ_body_coords.get_equ_body_coords(JD_UT + 1.0, sol3);
        double H0 = Math.sin(Utility.ln_deg_to_rad(horizon)) - Math.sin(Utility.ln_deg_to_rad(observer.lat)) * Math.sin(Utility.ln_deg_to_rad(sol2.dec));
        double H1 = Math.cos(Utility.ln_deg_to_rad(observer.lat)) * Math.cos(Utility.ln_deg_to_rad(sol2.dec));
        H1 = H0 / H1;
        int ret = RiseSet.check_coords(observer, H1, horizon, sol2);
        if (ret != 0) {
            return ret;
        }
        H0 = Math.acos(H1);
        H0 = Utility.ln_rad_to_deg(H0);
        if (sol1.ra - sol2.ra > 180.0) {
            sol2.ra += 360.0;
        }
        if (sol2.ra - sol3.ra > 180.0) {
            sol3.ra += 360.0;
        }
        if (sol3.ra - sol2.ra > 180.0) {
            sol3.ra -= 360.0;
        }
        if (sol2.ra - sol1.ra > 180.0) {
            sol3.ra -= 360.0;
        }
        double mt = (sol2.ra - observer.lng - O) / 360.0;
        double mr = mt - H0 / 360.0;
        double ms = mt + H0 / 360.0;
        for (int i = 0; i < 3; ++i) {
            if (mt > 1.0) {
                mt -= 1.0;
            } else if (mt < 0.0) {
                mt += 1.0;
            }
            if (mr > 1.0) {
                mr -= 1.0;
            } else if (mr < 0.0) {
                mr += 1.0;
            }
            if (ms > 1.0) {
                ms -= 1.0;
            } else if (ms < 0.0) {
                ms += 1.0;
            }
            double mst = O + 360.985647 * mt;
            double msr = O + 360.985647 * mr;
            double mss = O + 360.985647 * ms;
            double nt = mt + T / 86400.0;
            double nr = mr + T / 86400.0;
            double ns = ms + T / 86400.0;
            posr.ra = Utility.ln_interpolate3(nr, sol1.ra, sol2.ra, sol3.ra);
            posr.dec = Utility.ln_interpolate3(nr, sol1.dec, sol2.dec, sol3.dec);
            post.ra = Utility.ln_interpolate3(nt, sol1.ra, sol2.ra, sol3.ra);
            poss.ra = Utility.ln_interpolate3(ns, sol1.ra, sol2.ra, sol3.ra);
            poss.dec = Utility.ln_interpolate3(ns, sol1.dec, sol2.dec, sol3.dec);
            double Hat = mst + observer.lng - post.ra;
            double Har = msr + observer.lng - posr.ra;
            double Has = mss + observer.lng - poss.ra;
            double altr = Math.sin(Utility.ln_deg_to_rad(observer.lat)) * Math.sin(Utility.ln_deg_to_rad(posr.dec)) + Math.cos(Utility.ln_deg_to_rad(observer.lat)) * Math.cos(Utility.ln_deg_to_rad(posr.dec)) * Math.cos(Utility.ln_deg_to_rad(Har));
            double alts = Math.sin(Utility.ln_deg_to_rad(observer.lat)) * Math.sin(Utility.ln_deg_to_rad(poss.dec)) + Math.cos(Utility.ln_deg_to_rad(observer.lat)) * Math.cos(Utility.ln_deg_to_rad(poss.dec)) * Math.cos(Utility.ln_deg_to_rad(Has));
            altr = Utility.ln_rad_to_deg(altr);
            alts = Utility.ln_rad_to_deg(alts);
            Utility.ln_range_degrees(Hat);
            if (Hat > 180.0) {
                Hat -= 360.0;
            }
            double dmt = -(Hat / 360.0);
            double dmr = (altr - horizon) / (360.0 * Math.cos(Utility.ln_deg_to_rad(posr.dec)) * Math.cos(Utility.ln_deg_to_rad(observer.lat)) * Math.sin(Utility.ln_deg_to_rad(Har)));
            double dms = (alts - horizon) / (360.0 * Math.cos(Utility.ln_deg_to_rad(poss.dec)) * Math.cos(Utility.ln_deg_to_rad(observer.lat)) * Math.sin(Utility.ln_deg_to_rad(Has)));
            if ((mt += dmt) <= 1.0 && mt >= 0.0 && (mr += dmr) <= 1.0 && mr >= 0.0 && (ms += dms) <= 1.0 && ms >= 0.0) break;
        }
        rst.rise = JD_UT + mr;
        rst.transit = JD_UT + mt;
        rst.set = JD_UT + ms;
        return 0;
    }

    public static int ln_get_body_next_rst_horizon(double JD, LnLnlatPosn observer, IGetEquBodyCoords get_equ_body_coords, double horizon, LnRstTime rst) {
        return RiseSet.ln_get_body_next_rst_horizon_future(JD, observer, get_equ_body_coords, horizon, 1, rst);
    }

    public static int ln_get_body_next_rst_horizon_future(double JD, LnLnlatPosn observer, IGetEquBodyCoords get_equ_body_coords, double horizon, int day_limit, LnRstTime rst) {
        LnRstTime rst_1 = new LnRstTime();
        LnRstTime rst_2 = new LnRstTime();
        int ret = RiseSet.ln_get_body_rst_horizon_offset(JD, observer, get_equ_body_coords, horizon, rst, Utility.nan("0"));
        if (ret != 0 && day_limit == 1) {
            return ret;
        }
        if (ret == 0 && (rst.rise > JD + 0.5 || rst.transit > JD + 0.5 || rst.set > JD + 0.5)) {
            ret = RiseSet.ln_get_body_rst_horizon_offset(JD - 1.0, observer, get_equ_body_coords, horizon, rst_1, Utility.nan("0"));
            if (ret != 0) {
                RiseSet.set_next_rst(rst, -1.0, rst_1);
            }
        } else {
            rst.rise = Utility.nan("0");
            rst.transit = Utility.nan("0");
            rst.set = Utility.nan("0");
            RiseSet.set_next_rst(rst, -1.0, rst_1);
        }
        if (ret != 0 || rst.rise < JD || rst.transit < JD || rst.set < JD) {
            int day;
            for (day = 1; day <= day_limit; ++day) {
                ret = RiseSet.ln_get_body_rst_horizon_offset(JD + (double)day, observer, get_equ_body_coords, horizon, rst_2, Utility.nan("0"));
                if (ret != 0) continue;
                day = day_limit + 2;
                break;
            }
            if (day == day_limit + 1) {
                return ret;
            }
        } else {
            RiseSet.set_next_rst(rst, 1.0, rst_2);
        }
        rst.rise = RiseSet.find_next(JD, rst_1.rise, rst.rise, rst_2.rise);
        rst.transit = RiseSet.find_next(JD, rst_1.transit, rst.transit, rst_2.transit);
        rst.set = RiseSet.find_next(JD, rst_1.set, rst.set, rst_2.set);
        if (Double.isNaN(rst.rise)) {
            return ret;
        }
        return 0;
    }

    public static <T> int ln_get_motion_body_rst_horizon(double JD, LnLnlatPosn observer, IGetMotionBodyCoords<T> get_motion_body_coords, T orbit, double horizon, LnRstTime rst) {
        return RiseSet.ln_get_motion_body_rst_horizon_offset(JD, observer, get_motion_body_coords, orbit, horizon, rst, 0.5);
    }

    public static <T> int ln_get_motion_body_rst_horizon_offset(double JD, LnLnlatPosn observer, IGetMotionBodyCoords<T> get_motion_body_coords, T orbit, double horizon, LnRstTime rst, double ut_offset) {
        double JD_UT;
        double mt = 0.0;
        double mr = 0.0;
        double ms = 0.0;
        LnEquPosn sol1 = new LnEquPosn();
        LnEquPosn sol2 = new LnEquPosn();
        LnEquPosn sol3 = new LnEquPosn();
        LnEquPosn post = new LnEquPosn();
        LnEquPosn posr = new LnEquPosn();
        LnEquPosn poss = new LnEquPosn();
        double T = DynamicalTime.ln_get_dynamical_time_diff(JD);
        if (Double.isNaN(ut_offset)) {
            JD_UT = JD;
        } else {
            int jd = (int)JD;
            JD_UT = (double)jd + ut_offset;
        }
        double O = SiderealTime.ln_get_apparent_sidereal_time(JD_UT);
        O *= 15.0;
        get_motion_body_coords.get_motion_body_coords(JD_UT - 1.0, orbit, sol1);
        get_motion_body_coords.get_motion_body_coords(JD_UT, orbit, sol2);
        get_motion_body_coords.get_motion_body_coords(JD_UT + 1.0, orbit, sol3);
        double H0 = Math.sin(Utility.ln_deg_to_rad(horizon)) - Math.sin(Utility.ln_deg_to_rad(observer.lat)) * Math.sin(Utility.ln_deg_to_rad(sol2.dec));
        double H1 = Math.cos(Utility.ln_deg_to_rad(observer.lat)) * Math.cos(Utility.ln_deg_to_rad(sol2.dec));
        H1 = H0 / H1;
        int ret = RiseSet.check_coords(observer, H1, horizon, sol2);
        if (ret != 0) {
            return ret;
        }
        H0 = Math.acos(H1);
        H0 = Utility.ln_rad_to_deg(H0);
        if (sol1.ra - sol2.ra > 180.0) {
            sol2.ra += 360.0;
        }
        if (sol2.ra - sol3.ra > 180.0) {
            sol3.ra += 360.0;
        }
        if (sol3.ra - sol2.ra > 180.0) {
            sol3.ra -= 360.0;
        }
        if (sol2.ra - sol1.ra > 180.0) {
            sol3.ra -= 360.0;
        }
        for (int i = 0; i < 3; ++i) {
            mt = (sol2.ra - observer.lng - O) / 360.0;
            mr = mt - H0 / 360.0;
            ms = mt + H0 / 360.0;
            if (mt > 1.0) {
                mt -= 1.0;
            } else if (mt < 0.0) {
                mt += 1.0;
            }
            if (mr > 1.0) {
                mr -= 1.0;
            } else if (mr < 0.0) {
                mr += 1.0;
            }
            if (ms > 1.0) {
                ms -= 1.0;
            } else if (ms < 0.0) {
                ms += 1.0;
            }
            double mst = O + 360.985647 * mt;
            double msr = O + 360.985647 * mr;
            double mss = O + 360.985647 * ms;
            double nt = mt + T / 86400.0;
            double nr = mr + T / 86400.0;
            double ns = ms + T / 86400.0;
            posr.ra = Utility.ln_interpolate3(nr, sol1.ra, sol2.ra, sol3.ra);
            posr.dec = Utility.ln_interpolate3(nr, sol1.dec, sol2.dec, sol3.dec);
            post.ra = Utility.ln_interpolate3(nt, sol1.ra, sol2.ra, sol3.ra);
            poss.ra = Utility.ln_interpolate3(ns, sol1.ra, sol2.ra, sol3.ra);
            poss.dec = Utility.ln_interpolate3(ns, sol1.dec, sol2.dec, sol3.dec);
            double Hat = mst + observer.lng - post.ra;
            double Har = msr + observer.lng - posr.ra;
            double Has = mss + observer.lng - poss.ra;
            double altr = Math.sin(Utility.ln_deg_to_rad(observer.lat)) * Math.sin(Utility.ln_deg_to_rad(posr.dec)) + Math.cos(Utility.ln_deg_to_rad(observer.lat)) * Math.cos(Utility.ln_deg_to_rad(posr.dec)) * Math.cos(Utility.ln_deg_to_rad(Har));
            double alts = Math.sin(Utility.ln_deg_to_rad(observer.lat)) * Math.sin(Utility.ln_deg_to_rad(poss.dec)) + Math.cos(Utility.ln_deg_to_rad(observer.lat)) * Math.cos(Utility.ln_deg_to_rad(poss.dec)) * Math.cos(Utility.ln_deg_to_rad(Has));
            double dmt = -(Hat / 360.0);
            double dmr = (altr - horizon) / (360.0 * Math.cos(Utility.ln_deg_to_rad(posr.dec)) * Math.cos(Utility.ln_deg_to_rad(observer.lat)) * Math.sin(Utility.ln_deg_to_rad(Har)));
            double dms = (alts - horizon) / (360.0 * Math.cos(Utility.ln_deg_to_rad(poss.dec)) * Math.cos(Utility.ln_deg_to_rad(observer.lat)) * Math.sin(Utility.ln_deg_to_rad(Has)));
            if ((mt += dmt) <= 1.0 && mt >= 0.0 && (mr += dmr) <= 1.0 && mr >= 0.0 && (ms += dms) <= 1.0 && ms >= 0.0) break;
        }
        rst.rise = JD_UT + mr;
        rst.transit = JD_UT + mt;
        rst.set = JD_UT + ms;
        return 0;
    }

    public static <T> int ln_get_motion_body_next_rst_horizon(double JD, LnLnlatPosn observer, IGetMotionBodyCoords<T> get_motion_body_coords, T orbit, double horizon, LnRstTime rst) {
        return RiseSet.ln_get_motion_body_next_rst_horizon_future(JD, observer, get_motion_body_coords, orbit, horizon, 1, rst);
    }

    public static <T> int ln_get_motion_body_next_rst_horizon_future(double JD, LnLnlatPosn observer, IGetMotionBodyCoords<T> get_motion_body_coords, T orbit, double horizon, int day_limit, LnRstTime rst) {
        LnRstTime rst_1 = new LnRstTime();
        LnRstTime rst_2 = new LnRstTime();
        int ret = RiseSet.ln_get_motion_body_rst_horizon_offset(JD, observer, get_motion_body_coords, orbit, horizon, rst, Utility.nan("0"));
        if (ret != 0 && day_limit == 1) {
            return ret;
        }
        if (ret == 0 && (rst.rise > JD + 0.5 || rst.transit > JD + 0.5 || rst.set > JD + 0.5)) {
            ret = RiseSet.ln_get_motion_body_rst_horizon_offset(JD - 1.0, observer, get_motion_body_coords, orbit, horizon, rst_1, Utility.nan("0"));
            if (ret != 0) {
                RiseSet.set_next_rst(rst, -1.0, rst_1);
            }
        } else {
            rst.rise = Utility.nan("0");
            rst.transit = Utility.nan("0");
            rst.set = Utility.nan("0");
            RiseSet.set_next_rst(rst, -1.0, rst_1);
        }
        if (ret != 0 || rst.rise < JD || rst.transit < JD || rst.set < JD) {
            int day;
            for (day = 1; day <= day_limit; ++day) {
                ret = RiseSet.ln_get_motion_body_rst_horizon_offset(JD + (double)day, observer, get_motion_body_coords, orbit, horizon, rst_2, Utility.nan("0"));
                if (ret != 0) continue;
                day = day_limit + 2;
                break;
            }
            if (day == day_limit + 1) {
                return ret;
            }
        } else {
            RiseSet.set_next_rst(rst, 1.0, rst_2);
        }
        rst.rise = RiseSet.find_next(JD, rst_1.rise, rst.rise, rst_2.rise);
        rst.transit = RiseSet.find_next(JD, rst_1.transit, rst.transit, rst_2.transit);
        rst.set = RiseSet.find_next(JD, rst_1.set, rst.set, rst_2.set);
        if (Double.isNaN(rst.rise)) {
            return ret;
        }
        return 0;
    }
}

