/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt;

import de.kah2.zodiac.nova4jmt.SiderealTime;
import de.kah2.zodiac.nova4jmt.Utility;
import de.kah2.zodiac.nova4jmt.api.DoubleRef;
import de.kah2.zodiac.nova4jmt.api.LnEquPosn;
import de.kah2.zodiac.nova4jmt.api.LnLnlatPosn;

public class Parallax {
    public static void get_topocentric(LnLnlatPosn observer, double height, DoubleRef ro_sin, DoubleRef ro_cos) {
        double lat_rad = Utility.ln_deg_to_rad(observer.lat);
        double u = Math.atan(0.99664719 * Math.tan(lat_rad));
        ro_sin.value = 0.99664719 * Math.sin(u) + height / 6378140.0 * Math.sin(lat_rad);
        ro_cos.value = Math.cos(u) + height / 6378140.0 * Math.cos(lat_rad);
        ro_sin.value = observer.lat > 0.0 ? Math.abs(ro_sin.value) : Math.abs(ro_sin.value) * -1.0;
        ro_cos.value = Math.abs(ro_cos.value);
    }

    public static void ln_get_parallax(LnEquPosn object, double au_distance, LnLnlatPosn observer, double height, double JD, LnEquPosn parallax) {
        double H = SiderealTime.ln_get_apparent_sidereal_time(JD) + (observer.lng - object.ra) / 15.0;
        Parallax.ln_get_parallax_ha(object, au_distance, observer, height, H, parallax);
    }

    public static void ln_get_parallax_ha(LnEquPosn object, double au_distance, LnLnlatPosn observer, double height, double H, LnEquPosn parallax) {
        DoubleRef ro_sin = new DoubleRef();
        DoubleRef ro_cos = new DoubleRef();
        Parallax.get_topocentric(observer, height, ro_sin, ro_cos);
        double sin_pi = Math.sin(Utility.ln_deg_to_rad(8.794 / au_distance / 3600.0));
        double sin_H = Math.sin(H *= 0.2617993877991494);
        double cos_H = Math.cos(H);
        double dec_rad = Utility.ln_deg_to_rad(object.dec);
        double cos_dec = Math.cos(dec_rad);
        parallax.ra = Math.atan2(-ro_cos.value * sin_pi * sin_H, cos_dec - ro_cos.value * sin_pi * cos_H);
        parallax.dec = Math.atan2((Math.sin(dec_rad) - ro_sin.value * sin_pi) * Math.cos(parallax.ra), cos_dec - ro_cos.value * sin_pi * cos_H);
        parallax.ra = Utility.ln_rad_to_deg(parallax.ra);
        parallax.dec = Utility.ln_rad_to_deg(parallax.dec) - object.dec;
    }
}

