/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt;

import de.kah2.zodiac.nova4jmt.RiseSet;
import de.kah2.zodiac.nova4jmt.Transform;
import de.kah2.zodiac.nova4jmt.Utility;
import de.kah2.zodiac.nova4jmt.api.LnEquPosn;
import de.kah2.zodiac.nova4jmt.api.LnHelioPosn;
import de.kah2.zodiac.nova4jmt.api.LnLnlatPosn;
import de.kah2.zodiac.nova4jmt.api.LnParOrbit;
import de.kah2.zodiac.nova4jmt.api.LnRectPosn;
import de.kah2.zodiac.nova4jmt.api.LnRstTime;
import de.kah2.zodiac.nova4jmt.solarsystem.Earth;
import de.kah2.zodiac.nova4jmt.solarsystem.Solar;
import de.kah2.zodiac.nova4jmt.util.IGetMotionBodyCoords;

public class ParabolicMotion {
    public static double ln_solve_barker(double q, double t) {
        double W = 0.03649116245 / (q * Math.sqrt(q)) * t;
        double G = W / 2.0;
        double Y = Math.cbrt(G + Math.sqrt(G * G + 1.0));
        return Y - 1.0 / Y;
    }

    public static double ln_get_par_true_anomaly(double q, double t) {
        double s = ParabolicMotion.ln_solve_barker(q, t);
        double v = 2.0 * Math.atan(s);
        return Utility.ln_range_degrees(Utility.ln_rad_to_deg(v));
    }

    public static double ln_get_par_radius_vector(double q, double t) {
        double s = ParabolicMotion.ln_solve_barker(q, t);
        return q * (1.0 + s * s);
    }

    public static void ln_get_par_helio_rect_posn(LnParOrbit orbit, double JD, LnRectPosn posn) {
        double t = JD - orbit.JD;
        double sin_e = 0.397777156;
        double cos_e = 0.917482062;
        double sin_omega = Math.sin(Utility.ln_deg_to_rad(orbit.omega));
        double cos_omega = Math.cos(Utility.ln_deg_to_rad(orbit.omega));
        double sin_i = Math.sin(Utility.ln_deg_to_rad(orbit.i));
        double cos_i = Math.cos(Utility.ln_deg_to_rad(orbit.i));
        double F = cos_omega;
        double G = sin_omega * cos_e;
        double H = sin_omega * sin_e;
        double P = -sin_omega * cos_i;
        double Q = cos_omega * cos_i * cos_e - sin_i * sin_e;
        double R = cos_omega * cos_i * sin_e + sin_i * cos_e;
        double A = Math.atan2(F, P);
        double B = Math.atan2(G, Q);
        double C = Math.atan2(H, R);
        double a = Math.sqrt(F * F + P * P);
        double b = Math.sqrt(G * G + Q * Q);
        double c = Math.sqrt(H * H + R * R);
        double v = ParabolicMotion.ln_get_par_true_anomaly(orbit.q, t);
        double r = ParabolicMotion.ln_get_par_radius_vector(orbit.q, t);
        posn.X = r * a * Math.sin(A + Utility.ln_deg_to_rad(orbit.w + v));
        posn.Y = r * b * Math.sin(B + Utility.ln_deg_to_rad(orbit.w + v));
        posn.Z = r * c * Math.sin(C + Utility.ln_deg_to_rad(orbit.w + v));
    }

    public static void ln_get_par_geo_rect_posn(LnParOrbit orbit, double JD, LnRectPosn posn) {
        LnRectPosn p_posn = new LnRectPosn();
        LnRectPosn e_posn = new LnRectPosn();
        LnHelioPosn earth = new LnHelioPosn();
        ParabolicMotion.ln_get_par_helio_rect_posn(orbit, JD, p_posn);
        Earth.ln_get_earth_helio_coords(JD, earth);
        Transform.ln_get_rect_from_helio(earth, e_posn);
        posn.X = p_posn.X - e_posn.X;
        posn.Y = p_posn.Y - e_posn.Y;
        posn.Z = p_posn.Z - e_posn.Z;
    }

    public static void ln_get_par_body_equ_coords(double JD, LnParOrbit orbit, LnEquPosn posn) {
        LnRectPosn body_rect_posn = new LnRectPosn();
        LnRectPosn sol_rect_posn = new LnRectPosn();
        ParabolicMotion.ln_get_par_helio_rect_posn(orbit, JD, body_rect_posn);
        Solar.ln_get_solar_geo_coords(JD, sol_rect_posn);
        double dist = Utility.ln_get_rect_distance(body_rect_posn, sol_rect_posn);
        double t = Utility.ln_get_light_time(dist);
        ParabolicMotion.ln_get_par_helio_rect_posn(orbit, JD - t, body_rect_posn);
        double x = sol_rect_posn.X + body_rect_posn.X;
        double y = sol_rect_posn.Y + body_rect_posn.Y;
        double z = sol_rect_posn.Z + body_rect_posn.Z;
        posn.ra = Utility.ln_range_degrees(Utility.ln_rad_to_deg(Math.atan2(y, x)));
        posn.dec = Utility.ln_rad_to_deg(Math.atan2(z, Math.sqrt(x * x + y * y)));
    }

    public static double ln_get_par_body_earth_dist(double JD, LnParOrbit orbit) {
        LnRectPosn body_rect_posn = new LnRectPosn();
        LnRectPosn earth_rect_posn = new LnRectPosn();
        ParabolicMotion.ln_get_par_geo_rect_posn(orbit, JD, body_rect_posn);
        earth_rect_posn.X = 0.0;
        earth_rect_posn.Y = 0.0;
        earth_rect_posn.Z = 0.0;
        return Utility.ln_get_rect_distance(body_rect_posn, earth_rect_posn);
    }

    public static double ln_get_par_body_solar_dist(double JD, LnParOrbit orbit) {
        LnRectPosn body_rect_posn = new LnRectPosn();
        LnRectPosn sol_rect_posn = new LnRectPosn();
        ParabolicMotion.ln_get_par_helio_rect_posn(orbit, JD, body_rect_posn);
        sol_rect_posn.X = 0.0;
        sol_rect_posn.Y = 0.0;
        sol_rect_posn.Z = 0.0;
        return Utility.ln_get_rect_distance(body_rect_posn, sol_rect_posn);
    }

    public static double ln_get_par_body_phase_angle(double JD, LnParOrbit orbit) {
        double t = JD - orbit.JD;
        double r = ParabolicMotion.ln_get_par_radius_vector(orbit.q, t);
        double R = Earth.ln_get_earth_solar_dist(JD);
        double d = ParabolicMotion.ln_get_par_body_solar_dist(JD, orbit);
        double phase = (r * r + d * d - R * R) / (2.0 * r * d);
        return Utility.ln_range_degrees(Utility.ln_rad_to_deg(Math.acos(phase)));
    }

    public static double ln_get_par_body_elong(double JD, LnParOrbit orbit) {
        double t = JD - orbit.JD;
        double r = ParabolicMotion.ln_get_par_radius_vector(orbit.q, t);
        double R = Earth.ln_get_earth_solar_dist(JD);
        double d = ParabolicMotion.ln_get_par_body_solar_dist(JD, orbit);
        double elong = (R * R + d * d - r * r) / (2.0 * R * d);
        return Utility.ln_range_degrees(Utility.ln_rad_to_deg(Math.acos(elong)));
    }

    public static int ln_get_par_body_rst(double JD, LnLnlatPosn observer, LnParOrbit orbit, LnRstTime rst) {
        return ParabolicMotion.ln_get_par_body_rst_horizon(JD, observer, orbit, RiseSet.LN_STAR_STANDART_HORIZON.doubleValue(), rst);
    }

    public static int ln_get_par_body_rst_horizon(double JD, LnLnlatPosn observer, LnParOrbit orbit, double horizon, LnRstTime rst) {
        return RiseSet.ln_get_motion_body_rst_horizon(JD, observer, new IGetMotionBodyCoords<LnParOrbit>(){

            @Override
            public void get_motion_body_coords(double JD, LnParOrbit orbit, LnEquPosn posn) {
                ParabolicMotion.ln_get_par_body_equ_coords(JD, orbit, posn);
            }
        }, orbit, horizon, rst);
    }

    public static int ln_get_par_body_next_rst(double JD, LnLnlatPosn observer, LnParOrbit orbit, LnRstTime rst) {
        return ParabolicMotion.ln_get_par_body_next_rst_horizon(JD, observer, orbit, RiseSet.LN_STAR_STANDART_HORIZON.doubleValue(), rst);
    }

    public static int ln_get_par_body_next_rst_horizon(double JD, LnLnlatPosn observer, LnParOrbit orbit, double horizon, LnRstTime rst) {
        return RiseSet.ln_get_motion_body_next_rst_horizon(JD, observer, new IGetMotionBodyCoords<LnParOrbit>(){

            @Override
            public void get_motion_body_coords(double JD, LnParOrbit orbit, LnEquPosn posn) {
                ParabolicMotion.ln_get_par_body_equ_coords(JD, orbit, posn);
            }
        }, orbit, horizon, rst);
    }

    public static int ln_get_par_body_next_rst_horizon_future(double JD, LnLnlatPosn observer, LnParOrbit orbit, double horizon, int day_limit, LnRstTime rst) {
        return RiseSet.ln_get_motion_body_next_rst_horizon_future(JD, observer, new IGetMotionBodyCoords<LnParOrbit>(){

            @Override
            public void get_motion_body_coords(double JD, LnParOrbit orbit, LnEquPosn posn) {
                ParabolicMotion.ln_get_par_body_equ_coords(JD, orbit, posn);
            }
        }, orbit, horizon, day_limit, rst);
    }
}

