/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt;

import de.kah2.zodiac.nova4jmt.DynamicalTime;
import de.kah2.zodiac.nova4jmt.Utility;
import de.kah2.zodiac.nova4jmt.api.LnNutation;
import java.math.BigDecimal;
import java.math.MathContext;

public class Nutation {
    private static final NutationArguments[] arguments = new NutationArguments[]{new NutationArguments(0.0, 0.0, 0.0, 0.0, 1.0), new NutationArguments(-2.0, 0.0, 0.0, 2.0, 2.0), new NutationArguments(0.0, 0.0, 0.0, 2.0, 2.0), new NutationArguments(0.0, 0.0, 0.0, 0.0, 2.0), new NutationArguments(0.0, 1.0, 0.0, 0.0, 0.0), new NutationArguments(0.0, 0.0, 1.0, 0.0, 0.0), new NutationArguments(-2.0, 1.0, 0.0, 2.0, 2.0), new NutationArguments(0.0, 0.0, 0.0, 2.0, 1.0), new NutationArguments(0.0, 0.0, 1.0, 2.0, 2.0), new NutationArguments(-2.0, -1.0, 0.0, 2.0, 2.0), new NutationArguments(-2.0, 0.0, 1.0, 0.0, 0.0), new NutationArguments(-2.0, 0.0, 0.0, 2.0, 1.0), new NutationArguments(0.0, 0.0, -1.0, 2.0, 2.0), new NutationArguments(2.0, 0.0, 0.0, 0.0, 0.0), new NutationArguments(0.0, 0.0, 1.0, 0.0, 1.0), new NutationArguments(2.0, 0.0, -1.0, 2.0, 2.0), new NutationArguments(0.0, 0.0, -1.0, 0.0, 1.0), new NutationArguments(0.0, 0.0, 1.0, 2.0, 1.0), new NutationArguments(-2.0, 0.0, 2.0, 0.0, 0.0), new NutationArguments(0.0, 0.0, -2.0, 2.0, 1.0), new NutationArguments(2.0, 0.0, 0.0, 2.0, 2.0), new NutationArguments(0.0, 0.0, 2.0, 2.0, 2.0), new NutationArguments(0.0, 0.0, 2.0, 0.0, 0.0), new NutationArguments(-2.0, 0.0, 1.0, 2.0, 2.0), new NutationArguments(0.0, 0.0, 0.0, 2.0, 0.0), new NutationArguments(-2.0, 0.0, 0.0, 2.0, 0.0), new NutationArguments(0.0, 0.0, -1.0, 2.0, 1.0), new NutationArguments(0.0, 2.0, 0.0, 0.0, 0.0), new NutationArguments(2.0, 0.0, -1.0, 0.0, 1.0), new NutationArguments(-2.0, 2.0, 0.0, 2.0, 2.0), new NutationArguments(0.0, 1.0, 0.0, 0.0, 1.0), new NutationArguments(-2.0, 0.0, 1.0, 0.0, 1.0), new NutationArguments(0.0, -1.0, 0.0, 0.0, 1.0), new NutationArguments(0.0, 0.0, 2.0, -2.0, 0.0), new NutationArguments(2.0, 0.0, -1.0, 2.0, 1.0), new NutationArguments(2.0, 0.0, 1.0, 2.0, 2.0), new NutationArguments(0.0, 1.0, 0.0, 2.0, 2.0), new NutationArguments(-2.0, 1.0, 1.0, 0.0, 0.0), new NutationArguments(0.0, -1.0, 0.0, 2.0, 2.0), new NutationArguments(2.0, 0.0, 0.0, 2.0, 1.0), new NutationArguments(2.0, 0.0, 1.0, 0.0, 0.0), new NutationArguments(-2.0, 0.0, 2.0, 2.0, 2.0), new NutationArguments(-2.0, 0.0, 1.0, 2.0, 1.0), new NutationArguments(2.0, 0.0, -2.0, 0.0, 1.0), new NutationArguments(2.0, 0.0, 0.0, 0.0, 1.0), new NutationArguments(0.0, -1.0, 1.0, 0.0, 0.0), new NutationArguments(-2.0, -1.0, 0.0, 2.0, 1.0), new NutationArguments(-2.0, 0.0, 0.0, 0.0, 1.0), new NutationArguments(0.0, 0.0, 2.0, 2.0, 1.0), new NutationArguments(-2.0, 0.0, 2.0, 0.0, 1.0), new NutationArguments(-2.0, 1.0, 0.0, 2.0, 1.0), new NutationArguments(0.0, 0.0, 1.0, -2.0, 0.0), new NutationArguments(-1.0, 0.0, 1.0, 0.0, 0.0), new NutationArguments(-2.0, 1.0, 0.0, 0.0, 0.0), new NutationArguments(1.0, 0.0, 0.0, 0.0, 0.0), new NutationArguments(0.0, 0.0, 1.0, 2.0, 0.0), new NutationArguments(0.0, 0.0, -2.0, 2.0, 2.0), new NutationArguments(-1.0, -1.0, 1.0, 0.0, 0.0), new NutationArguments(0.0, 1.0, 1.0, 0.0, 0.0), new NutationArguments(0.0, -1.0, 1.0, 2.0, 2.0), new NutationArguments(2.0, -1.0, -1.0, 2.0, 2.0), new NutationArguments(0.0, 0.0, 3.0, 2.0, 2.0), new NutationArguments(2.0, -1.0, 0.0, 2.0, 2.0)};
    private static final NutationCoefficients[] coefficients = new NutationCoefficients[]{new NutationCoefficients(-171996.0, -174.2, 92025.0, 8.9), new NutationCoefficients(-13187.0, -1.6, 5736.0, -3.1), new NutationCoefficients(-2274.0, -0.2, 977.0, -0.5), new NutationCoefficients(2062.0, 0.2, -895.0, 0.5), new NutationCoefficients(1426.0, -3.4, 54.0, -0.1), new NutationCoefficients(712.0, 0.1, -7.0, 0.0), new NutationCoefficients(-517.0, 1.2, 224.0, -0.6), new NutationCoefficients(-386.0, -0.4, 200.0, 0.0), new NutationCoefficients(-301.0, 0.0, 129.0, -0.1), new NutationCoefficients(217.0, -0.5, -95.0, 0.3), new NutationCoefficients(-158.0, 0.0, 0.0, 0.0), new NutationCoefficients(129.0, 0.1, -70.0, 0.0), new NutationCoefficients(123.0, 0.0, -53.0, 0.0), new NutationCoefficients(63.0, 0.0, 0.0, 0.0), new NutationCoefficients(63.0, 0.1, -33.0, 0.0), new NutationCoefficients(-59.0, 0.0, 26.0, 0.0), new NutationCoefficients(-58.0, -0.1, 32.0, 0.0), new NutationCoefficients(-51.0, 0.0, 27.0, 0.0), new NutationCoefficients(48.0, 0.0, 0.0, 0.0), new NutationCoefficients(46.0, 0.0, -24.0, 0.0), new NutationCoefficients(-38.0, 0.0, 16.0, 0.0), new NutationCoefficients(-31.0, 0.0, 13.0, 0.0), new NutationCoefficients(29.0, 0.0, 0.0, 0.0), new NutationCoefficients(29.0, 0.0, -12.0, 0.0), new NutationCoefficients(26.0, 0.0, 0.0, 0.0), new NutationCoefficients(-22.0, 0.0, 0.0, 0.0), new NutationCoefficients(21.0, 0.0, -10.0, 0.0), new NutationCoefficients(17.0, -0.1, 0.0, 0.0), new NutationCoefficients(16.0, 0.0, -8.0, 0.0), new NutationCoefficients(-16.0, 0.1, 7.0, 0.0), new NutationCoefficients(-15.0, 0.0, 9.0, 0.0), new NutationCoefficients(-13.0, 0.0, 7.0, 0.0), new NutationCoefficients(-12.0, 0.0, 6.0, 0.0), new NutationCoefficients(11.0, 0.0, 0.0, 0.0), new NutationCoefficients(-10.0, 0.0, 5.0, 0.0), new NutationCoefficients(-8.0, 0.0, 3.0, 0.0), new NutationCoefficients(7.0, 0.0, -3.0, 0.0), new NutationCoefficients(-7.0, 0.0, 0.0, 0.0), new NutationCoefficients(-7.0, 0.0, 3.0, 0.0), new NutationCoefficients(-7.0, 0.0, 3.0, 0.0), new NutationCoefficients(6.0, 0.0, 0.0, 0.0), new NutationCoefficients(6.0, 0.0, -3.0, 0.0), new NutationCoefficients(6.0, 0.0, -3.0, 0.0), new NutationCoefficients(-6.0, 0.0, 3.0, 0.0), new NutationCoefficients(-6.0, 0.0, 3.0, 0.0), new NutationCoefficients(5.0, 0.0, 0.0, 0.0), new NutationCoefficients(-5.0, 0.0, 3.0, 0.0), new NutationCoefficients(-5.0, 0.0, 3.0, 0.0), new NutationCoefficients(-5.0, 0.0, 3.0, 0.0), new NutationCoefficients(4.0, 0.0, 0.0, 0.0), new NutationCoefficients(4.0, 0.0, 0.0, 0.0), new NutationCoefficients(4.0, 0.0, 0.0, 0.0), new NutationCoefficients(-4.0, 0.0, 0.0, 0.0), new NutationCoefficients(-4.0, 0.0, 0.0, 0.0), new NutationCoefficients(-4.0, 0.0, 0.0, 0.0), new NutationCoefficients(3.0, 0.0, 0.0, 0.0), new NutationCoefficients(-3.0, 0.0, 0.0, 0.0), new NutationCoefficients(-3.0, 0.0, 0.0, 0.0), new NutationCoefficients(-3.0, 0.0, 0.0, 0.0), new NutationCoefficients(-3.0, 0.0, 0.0, 0.0), new NutationCoefficients(-3.0, 0.0, 0.0, 0.0), new NutationCoefficients(-3.0, 0.0, 0.0, 0.0), new NutationCoefficients(-3.0, 0.0, 0.0, 0.0)};
    private static final BigDecimal LN_NUTATION_EPOCH_THRESHOLD = new BigDecimal(0.1);
    private BigDecimal c_JD = BigDecimal.ZERO;
    private BigDecimal c_longitude = BigDecimal.ZERO;
    private BigDecimal c_obliquity = BigDecimal.ZERO;
    private BigDecimal c_ecliptic = BigDecimal.ZERO;

    public void ln_get_nutation(double JDdoule, LnNutation nutation) {
        BigDecimal JD = Nutation.d(JDdoule);
        if (JD.subtract(this.c_JD).abs().compareTo(LN_NUTATION_EPOCH_THRESHOLD) > 0) {
            this.c_JD = JD;
            BigDecimal JDE = Nutation.d(DynamicalTime.ln_get_jde(JD.doubleValue()));
            BigDecimal T = JDE.subtract(Nutation.d(2451545.0)).divide(Nutation.d(36525.0), MathContext.DECIMAL128);
            BigDecimal T2 = T.multiply(T);
            BigDecimal T3 = T2.multiply(T);
            BigDecimal D = Nutation.d(297.85036).add(Nutation.d(445267.11148).multiply(T)).subtract(Nutation.d(0.0019142).multiply(T2)).add(T3.divide(Nutation.d(189474.0), MathContext.DECIMAL128));
            BigDecimal M = Nutation.d(357.52772).add(Nutation.d(35999.05034).multiply(T)).subtract(Nutation.d(1.603E-4).multiply(T2)).subtract(T3.divide(Nutation.d(300000.0), MathContext.DECIMAL128));
            BigDecimal MM = Nutation.d(134.96298).add(Nutation.d(477198.867398).multiply(T)).add(Nutation.d(0.0086972).multiply(T2)).add(T3.divide(Nutation.d(56250.0), MathContext.DECIMAL128));
            BigDecimal F = Nutation.d(93.27191).add(Nutation.d(483202.017538).multiply(T)).subtract(Nutation.d(0.0036825).multiply(T2)).add(T3.divide(Nutation.d(327270.0), MathContext.DECIMAL128));
            BigDecimal O = Nutation.d(125.04452).subtract(Nutation.d(1934.136261).multiply(T)).add(Nutation.d(0.0020708).multiply(T2)).add(T3.divide(Nutation.d(450000.0), MathContext.DECIMAL128));
            D = Utility.ln_deg_to_rad(D);
            M = Utility.ln_deg_to_rad(M);
            MM = Utility.ln_deg_to_rad(MM);
            F = Utility.ln_deg_to_rad(F);
            O = Utility.ln_deg_to_rad(O);
            for (int i = 0; i < arguments.length; ++i) {
                BigDecimal coeff_sine = Nutation.coefficients[i].longitude1.add(Nutation.coefficients[i].longitude2.multiply(T));
                BigDecimal coeff_cos = Nutation.coefficients[i].obliquity1.add(Nutation.coefficients[i].obliquity2.multiply(T));
                BigDecimal argument = Nutation.arguments[i].D.multiply(D).add(Nutation.arguments[i].M.multiply(M)).add(Nutation.arguments[i].MM.multiply(MM)).add(Nutation.arguments[i].F.multiply(F)).add(Nutation.arguments[i].O.multiply(O));
                this.c_longitude = this.c_longitude.add(coeff_sine.multiply(Nutation.d(Math.sin(argument.doubleValue()))));
                this.c_obliquity = this.c_obliquity.add(coeff_cos.multiply(Nutation.d(Math.cos(argument.doubleValue()))));
            }
            this.c_longitude = this.c_longitude.divide(Nutation.d(10000.0), MathContext.DECIMAL128);
            this.c_obliquity = this.c_obliquity.divide(Nutation.d(10000.0), MathContext.DECIMAL128);
            this.c_longitude = this.c_longitude.divide(Nutation.d(3600.0), MathContext.DECIMAL128);
            this.c_obliquity = this.c_obliquity.divide(Nutation.d(3600.0), MathContext.DECIMAL128);
            this.c_ecliptic = Nutation.d(23.0).add(Nutation.d(26.0).divide(Nutation.d(60.0), MathContext.DECIMAL128)).add(Nutation.d(21.448).divide(Nutation.d(3600.0), MathContext.DECIMAL128)).subtract(Nutation.d(46.815).divide(Nutation.d(3600.0), MathContext.DECIMAL128).multiply(T)).subtract(Nutation.d(5.9E-4).divide(Nutation.d(3600.0), MathContext.DECIMAL128).multiply(T2)).add(Nutation.d(0.001813).divide(Nutation.d(3600.0), MathContext.DECIMAL128).multiply(T3));
        }
        nutation.longitude = this.c_longitude.doubleValue();
        nutation.obliquity = this.c_obliquity.doubleValue();
        nutation.ecliptic = this.c_ecliptic.doubleValue();
    }

    private static BigDecimal d(double value) {
        return BigDecimal.valueOf(value);
    }

    static class NutationCoefficients {
        BigDecimal longitude1;
        BigDecimal longitude2;
        BigDecimal obliquity1;
        BigDecimal obliquity2;

        public NutationCoefficients(double longitude1, double longitude2, double obliquity1, double obliquity2) {
            this.longitude1 = Nutation.d(longitude1);
            this.longitude2 = Nutation.d(longitude2);
            this.obliquity1 = Nutation.d(obliquity1);
            this.obliquity2 = Nutation.d(obliquity2);
        }
    }

    static class NutationArguments {
        BigDecimal D;
        BigDecimal M;
        BigDecimal MM;
        BigDecimal F;
        BigDecimal O;

        public NutationArguments(double d, double m, double mM, double f, double o) {
            this.D = Nutation.d(d);
            this.M = Nutation.d(m);
            this.MM = Nutation.d(mM);
            this.F = Nutation.d(f);
            this.O = Nutation.d(o);
        }
    }
}

