/*
 * Decompiled with CFR 0.152.
 */
package de.kah2.zodiac.nova4jmt;

import de.kah2.zodiac.nova4jmt.Utility;
import de.kah2.zodiac.nova4jmt.api.LnEquPosn;
import de.kah2.zodiac.nova4jmt.api.LnHelioPosn;
import de.kah2.zodiac.nova4jmt.api.LnLnlatPosn;
import de.kah2.zodiac.nova4jmt.solarsystem.Solar;

public class Aberration {
    static final Arg[] arguments = new Arg[]{new Arg(0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0), new Arg(0.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0), new Arg(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0), new Arg(0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 2.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 3.0, -8.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 5.0, -8.0, 3.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(2.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 1.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(2.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 3.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(1.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(2.0, -3.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 0.0, 0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(2.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 3.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 2.0, -1.0, 0.0), new Arg(8.0, 12.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(8.0, 14.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 0.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(3.0, 4.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 2.0, 0.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(3.0, -3.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 2.0, -2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0), new Arg(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, -2.0, 0.0, 0.0)};
    static final XYZ[] x_coefficients = new XYZ[]{new XYZ(-1719914.0, -2.0, -25.0, 0.0), new XYZ(6434.0, 141.0, 28007.0, -107.0), new XYZ(715.0, 0.0, 0.0, 0.0), new XYZ(715.0, 0.0, 0.0, 0.0), new XYZ(486.0, -5.0, -236.0, -4.0), new XYZ(159.0, 0.0, 0.0, 0.0), new XYZ(0.0, 0.0, 0.0, 0.0), new XYZ(39.0, 0.0, 0.0, 0.0), new XYZ(33.0, 0.0, -10.0, 0.0), new XYZ(31.0, 0.0, 1.0, 0.0), new XYZ(8.0, 0.0, -28.0, 0.0), new XYZ(8.0, 0.0, -28.0, 0.0), new XYZ(21.0, 0.0, 0.0, 0.0), new XYZ(-19.0, 0.0, 0.0, 0.0), new XYZ(17.0, 0.0, 0.0, 0.0), new XYZ(16.0, 0.0, 0.0, 0.0), new XYZ(16.0, 0.0, 0.0, 0.0), new XYZ(11.0, 0.0, -1.0, 0.0), new XYZ(0.0, 0.0, -11.0, 0.0), new XYZ(-11.0, 0.0, -2.0, 0.0), new XYZ(-7.0, 0.0, -8.0, 0.0), new XYZ(-10.0, 0.0, 0.0, 0.0), new XYZ(-9.0, 0.0, 0.0, 0.0), new XYZ(-9.0, 0.0, 0.0, 0.0), new XYZ(0.0, 0.0, -9.0, 0.0), new XYZ(0.0, 0.0, -9.0, 0.0), new XYZ(8.0, 0.0, 0.0, 0.0), new XYZ(8.0, 0.0, 0.0, 0.0), new XYZ(-4.0, 0.0, -7.0, 0.0), new XYZ(-4.0, 0.0, -7.0, 0.0), new XYZ(-6.0, 0.0, -5.0, 0.0), new XYZ(-1.0, 0.0, -1.0, 0.0), new XYZ(4.0, 0.0, -6.0, 0.0), new XYZ(0.0, 0.0, -7.0, 0.0), new XYZ(5.0, 0.0, -5.0, 0.0), new XYZ(5.0, 0.0, 0.0, 0.0)};
    static final XYZ[] y_coefficients = new XYZ[]{new XYZ(25.0, -13.0, 1578089.0, 156.0), new XYZ(25697.0, -95.0, -5904.0, -130.0), new XYZ(6.0, 0.0, -657.0, 0.0), new XYZ(0.0, 0.0, -656.0, 0.0), new XYZ(-216.0, -4.0, -446.0, 5.0), new XYZ(2.0, 0.0, -147.0, 0.0), new XYZ(0.0, 0.0, 26.0, 0.0), new XYZ(0.0, 0.0, -36.0, 0.0), new XYZ(-9.0, 0.0, -30.0, 0.0), new XYZ(1.0, 0.0, -28.0, 0.0), new XYZ(25.0, 0.0, 8.0, 0.0), new XYZ(-25.0, 0.0, -8.0, 0.0), new XYZ(0.0, 0.0, -19.0, 0.0), new XYZ(0.0, 0.0, 17.0, 0.0), new XYZ(0.0, 0.0, -16.0, 0.0), new XYZ(0.0, 0.0, 15.0, 0.0), new XYZ(1.0, 0.0, -15.0, 0.0), new XYZ(-1.0, 0.0, -10.0, 0.0), new XYZ(-10.0, 0.0, 0.0, 0.0), new XYZ(-2.0, 0.0, 9.0, 0.0), new XYZ(-8.0, 0.0, 6.0, 0.0), new XYZ(0.0, 0.0, 9.0, 0.0), new XYZ(0.0, 0.0, -9.0, 0.0), new XYZ(0.0, 0.0, -8.0, 0.0), new XYZ(-8.0, 0.0, 0.0, 0.0), new XYZ(8.0, 0.0, 0.0, 0.0), new XYZ(0.0, 0.0, -8.0, 0.0), new XYZ(0.0, 0.0, -7.0, 0.0), new XYZ(-6.0, 0.0, -4.0, 0.0), new XYZ(6.0, 0.0, -4.0, 0.0), new XYZ(-4.0, 0.0, 5.0, 0.0), new XYZ(-2.0, 0.0, -7.0, 0.0), new XYZ(-5.0, 0.0, -4.0, 0.0), new XYZ(-6.0, 0.0, 0.0, 0.0), new XYZ(-4.0, 0.0, -5.0, 0.0), new XYZ(0.0, 0.0, -5.0, 0.0)};
    static final XYZ[] z_coefficients = new XYZ[]{new XYZ(10.0, 32.0, 684185.0, -358.0), new XYZ(11141.0, -48.0, -2559.0, -55.0), new XYZ(-15.0, 0.0, -282.0, 0.0), new XYZ(0.0, 0.0, -285.0, 0.0), new XYZ(-94.0, 0.0, -193.0, 0.0), new XYZ(-6.0, 0.0, -61.0, 0.0), new XYZ(0.0, 0.0, 59.0, 0.0), new XYZ(0.0, 0.0, 16.0, 0.0), new XYZ(-5.0, 0.0, -13.0, 0.0), new XYZ(0.0, 0.0, -12.0, 0.0), new XYZ(11.0, 0.0, 3.0, 0.0), new XYZ(-11.0, 0.0, -3.0, 0.0), new XYZ(0.0, 0.0, -8.0, 0.0), new XYZ(0.0, 0.0, 8.0, 0.0), new XYZ(0.0, 0.0, -7.0, 0.0), new XYZ(1.0, 0.0, 7.0, 0.0), new XYZ(-3.0, 0.0, -6.0, 0.0), new XYZ(-1.0, 0.0, 5.0, 0.0), new XYZ(-4.0, 0.0, 0.0, 0.0), new XYZ(-1.0, 0.0, 4.0, 0.0), new XYZ(-3.0, 0.0, 3.0, 0.0), new XYZ(0.0, 0.0, 4.0, 0.0), new XYZ(0.0, 0.0, -4.0, 0.0), new XYZ(0.0, 0.0, -4.0, 0.0), new XYZ(-3.0, 0.0, 0.0, 0.0), new XYZ(3.0, 0.0, 0.0, 0.0), new XYZ(0.0, 0.0, -3.0, 0.0), new XYZ(0.0, 0.0, -3.0, 0.0), new XYZ(-3.0, 0.0, 2.0, 0.0), new XYZ(3.0, 0.0, -2.0, 0.0), new XYZ(-2.0, 0.0, 2.0, 0.0), new XYZ(1.0, 0.0, -4.0, 0.0), new XYZ(-2.0, 0.0, -2.0, 0.0), new XYZ(-3.0, 0.0, 0.0, 0.0), new XYZ(-2.0, 0.0, -2.0, 0.0), new XYZ(0.0, 0.0, -2.0, 0.0)};

    public static void ln_get_equ_aber(LnEquPosn mean_position, double JD, LnEquPosn position) {
        double c = 1.731446335E10;
        double T = (JD - 2451545.0) / 36525.0;
        double L2 = 3.1761467 + 1021.3285546 * T;
        double L3 = 1.7534703 + 628.3075849 * T;
        double L4 = 6.2034809 + 334.0612431 * T;
        double L5 = 0.5995464 + 52.9690965 * T;
        double L6 = 0.8740168 + 21.329909095 * T;
        double L7 = 5.4812939 + 7.4781599 * T;
        double L8 = 5.3118863 + 3.8133036 * T;
        double LL = 3.8103444 + 8399.6847337 * T;
        double D = 5.1984667 + 7771.3771486 * T;
        double MM = 2.3555559 + 8328.6914289 * T;
        double F = 1.6279052 + 8433.4661601 * T;
        double X = 0.0;
        double Y = 0.0;
        double Z = 0.0;
        for (int i = 0; i < arguments.length; ++i) {
            double A = Aberration.arguments[i].a_L2 * L2 + Aberration.arguments[i].a_L3 * L3 + Aberration.arguments[i].a_L4 * L4 + Aberration.arguments[i].a_L5 * L5 + Aberration.arguments[i].a_L6 * L6 + Aberration.arguments[i].a_L7 * L7 + Aberration.arguments[i].a_L8 * L8 + Aberration.arguments[i].a_LL * LL + Aberration.arguments[i].a_D * D + Aberration.arguments[i].a_MM * MM + Aberration.arguments[i].a_F * F;
            X += (Aberration.x_coefficients[i].sin1 + Aberration.x_coefficients[i].sin2 * T) * Math.sin(A) + (Aberration.x_coefficients[i].cos1 + Aberration.x_coefficients[i].cos2 * T) * Math.cos(A);
            Y += (Aberration.y_coefficients[i].sin1 + Aberration.y_coefficients[i].sin2 * T) * Math.sin(A) + (Aberration.y_coefficients[i].cos1 + Aberration.y_coefficients[i].cos2 * T) * Math.cos(A);
            Z += (Aberration.z_coefficients[i].sin1 + Aberration.z_coefficients[i].sin2 * T) * Math.sin(A) + (Aberration.z_coefficients[i].cos1 + Aberration.z_coefficients[i].cos2 * T) * Math.cos(A);
        }
        double mean_ra = Utility.ln_deg_to_rad(mean_position.ra);
        double mean_dec = Utility.ln_deg_to_rad(mean_position.dec);
        double delta_ra = (Y * Math.cos(mean_ra) - X * Math.sin(mean_ra)) / (c * Math.cos(mean_dec));
        double delta_dec = (X * Math.cos(mean_ra) + Y * Math.sin(mean_ra)) * Math.sin(mean_dec) - Z * Math.cos(mean_dec);
        position.ra = Utility.ln_rad_to_deg(mean_ra + delta_ra);
        position.dec = Utility.ln_rad_to_deg(mean_dec + (delta_dec /= -c));
    }

    public static void ln_get_ecl_aber(LnLnlatPosn mean_position, double JD, LnLnlatPosn position) {
        LnHelioPosn sol_position = new LnHelioPosn();
        double k = Utility.ln_deg_to_rad(0.0056932);
        double T = (JD - 2451545.0) / 36525.0;
        double T2 = T * T;
        Solar.ln_get_solar_geom_coords(JD, sol_position);
        double true_longitude = Utility.ln_deg_to_rad(sol_position.B);
        double e = 0.016708617 - 4.2037E-5 * T - 1.236E-7 * T2;
        e = Utility.ln_deg_to_rad(e);
        double t = 102.93735 + 1.71953 * T + 4.6E-5 * T2;
        t = Utility.ln_deg_to_rad(t);
        double mean_lng = Utility.ln_deg_to_rad(mean_position.lng);
        double mean_lat = Utility.ln_deg_to_rad(mean_position.lat);
        double delta_lng = (-k * Math.cos(true_longitude - mean_lng) + e * k * Math.cos(t - mean_lng)) / Math.cos(mean_lat);
        double delta_lat = -k * Math.sin(mean_lat) * (Math.sin(true_longitude - mean_lng) - e * Math.sin(t - mean_lng));
        position.lng = Utility.ln_rad_to_deg(mean_lng += delta_lng);
        position.lat = Utility.ln_rad_to_deg(mean_lat += delta_lat);
    }

    private static class XYZ {
        double sin1;
        double sin2;
        double cos1;
        double cos2;

        public XYZ(double sin1, double sin2, double cos1, double cos2) {
            this.sin1 = sin1;
            this.sin2 = sin2;
            this.cos1 = cos1;
            this.cos2 = cos2;
        }
    }

    private static class Arg {
        double a_L2;
        double a_L3;
        double a_L4;
        double a_L5;
        double a_L6;
        double a_L7;
        double a_L8;
        double a_LL;
        double a_D;
        double a_MM;
        double a_F;

        public Arg(double a_L2, double a_L3, double a_L4, double a_L5, double a_L6, double a_L7, double a_L8, double a_LL, double a_D, double a_MM, double a_F) {
            this.a_L2 = a_L2;
            this.a_L3 = a_L3;
            this.a_L4 = a_L4;
            this.a_L5 = a_L5;
            this.a_L6 = a_L6;
            this.a_L7 = a_L7;
            this.a_L8 = a_L8;
            this.a_LL = a_LL;
            this.a_D = a_D;
            this.a_MM = a_MM;
            this.a_F = a_F;
        }
    }
}

