package de.kah2.zodiac.nova4jmt.solarsystem;

/*
 * #%L
 * libnova for Java
 * %%
 * Copyright (C) 2014 novaforjava
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import static java.lang.Math.acos;
import static java.lang.Math.asin;
import static java.lang.Math.atan2;
import static java.lang.Math.log10;
import static java.lang.Math.sqrt;
import static de.kah2.zodiac.nova4jmt.RiseSet.LN_STAR_STANDART_HORIZON;
import static de.kah2.zodiac.nova4jmt.RiseSet.ln_get_body_rst_horizon;
import static de.kah2.zodiac.nova4jmt.Transform.ln_get_rect_from_helio;
import static de.kah2.zodiac.nova4jmt.Utility.ln_rad_to_deg;
import static de.kah2.zodiac.nova4jmt.Utility.ln_range_degrees;
import static de.kah2.zodiac.nova4jmt.Vsop87.ln_calc_series;
import static de.kah2.zodiac.nova4jmt.Vsop87.ln_vsop87_to_fk5;
import static de.kah2.zodiac.nova4jmt.solarsystem.Earth.ln_get_earth_helio_coords;
import static de.kah2.zodiac.nova4jmt.solarsystem.Earth.ln_get_earth_solar_dist;
import static de.kah2.zodiac.nova4jmt.solarsystem.Solar.ln_get_solar_geom_coords;
import de.kah2.zodiac.nova4jmt.Vsop87;
import de.kah2.zodiac.nova4jmt.api.LnEquPosn;
import de.kah2.zodiac.nova4jmt.api.LnHelioPosn;
import de.kah2.zodiac.nova4jmt.api.LnLnlatPosn;
import de.kah2.zodiac.nova4jmt.api.LnRectPosn;
import de.kah2.zodiac.nova4jmt.api.LnRstTime;
import de.kah2.zodiac.nova4jmt.util.IGetEquBodyCoords;

public class Jupiter {

	/** cache variables */
	static double cJD = 0.0, cL = 0.0, cB = 0.0, cR = 0.0;

	static class Lontitude {
		private static Vsop87.LnVsop[] jupiter_longitude_l0 = {
				new Vsop87.LnVsop(0.59954691494, 0.00000000000, 0.00000000000),
				new Vsop87.LnVsop(0.09695898719, 5.06191793158, 529.69096509460),
				new Vsop87.LnVsop(0.00573610142, 1.44406205629, 7.11354700080),
				new Vsop87.LnVsop(0.00306389205, 5.41734730184,
						1059.38193018920),
				new Vsop87.LnVsop(0.00097178296, 4.14264726552, 632.78373931320),
				new Vsop87.LnVsop(0.00072903078, 3.64042916389, 522.57741809380),
				new Vsop87.LnVsop(0.00064263975, 3.41145165351, 103.09277421860),
				new Vsop87.LnVsop(0.00039806064, 2.29376740788, 419.48464387520),
				new Vsop87.LnVsop(0.00038857767, 1.27231755835, 316.39186965660),
				new Vsop87.LnVsop(0.00027964629, 1.78454591820, 536.80451209540),
				new Vsop87.LnVsop(0.00013589730, 5.77481040790,
						1589.07289528380),
				new Vsop87.LnVsop(0.00008246349, 3.58227925840, 206.18554843720),
				new Vsop87.LnVsop(0.00008768704, 3.63000308199, 949.17560896980),
				new Vsop87.LnVsop(0.00007368042, 5.08101194270, 735.87651353180),
				new Vsop87.LnVsop(0.00006263150, 0.02497628807, 213.29909543800),
				new Vsop87.LnVsop(0.00006114062, 4.51319998626,
						1162.47470440780),
				new Vsop87.LnVsop(0.00004905396, 1.32084470588, 110.20632121940),
				new Vsop87.LnVsop(0.00005305285, 1.30671216791, 14.22709400160),
				new Vsop87.LnVsop(0.00005305441, 4.18625634012,
						1052.26838318840),
				new Vsop87.LnVsop(0.00004647248, 4.69958103684, 3.93215326310),
				new Vsop87.LnVsop(0.00003045023, 4.31676431084, 426.59819087600),
				new Vsop87.LnVsop(0.00002609999, 1.56667394063, 846.08283475120),
				new Vsop87.LnVsop(0.00002028191, 1.06376530715, 3.18139373770),
				new Vsop87.LnVsop(0.00001764763, 2.14148655117,
						1066.49547719000),
				new Vsop87.LnVsop(0.00001722972, 3.88036268267,
						1265.56747862640),
				new Vsop87.LnVsop(0.00001920945, 0.97168196472, 639.89728631400),
				new Vsop87.LnVsop(0.00001633223, 3.58201833555, 515.46387109300),
				new Vsop87.LnVsop(0.00001431999, 4.29685556046, 625.67019231240),
				new Vsop87.LnVsop(0.00000973272, 4.09764549134, 95.97922721780),
				new Vsop87.LnVsop(0.00000884457, 2.43700227469, 412.37109687440),
				new Vsop87.LnVsop(0.00000732853, 6.08535124451, 838.96928775040),
				new Vsop87.LnVsop(0.00000731094, 3.80592308125,
						1581.95934828300),
				new Vsop87.LnVsop(0.00000691971, 6.13365277914,
						2118.76386037840),
				new Vsop87.LnVsop(0.00000709166, 1.29274760330, 742.99006053260),
				new Vsop87.LnVsop(0.00000614482, 4.10850580886,
						1478.86657406440),
				new Vsop87.LnVsop(0.00000495219, 3.75564106217, 323.50541665740),
				new Vsop87.LnVsop(0.00000581903, 4.53969579398, 309.27832265580),
				new Vsop87.LnVsop(0.00000375664, 4.70304250208,
						1368.66025284500),
				new Vsop87.LnVsop(0.00000389876, 4.89706786539,
						1692.16566950240),
				new Vsop87.LnVsop(0.00000341016, 5.71452379310, 533.62311835770),
				new Vsop87.LnVsop(0.00000330458, 4.74049819491, 0.04818410980),
				new Vsop87.LnVsop(0.00000440853, 2.95818598959, 454.90936652730),
				new Vsop87.LnVsop(0.00000417267, 1.03554397138, 2.44768055480),
				new Vsop87.LnVsop(0.00000244174, 5.22024286247, 728.76296653100),
				new Vsop87.LnVsop(0.00000261541, 1.87652515753, 0.96320784650),
				new Vsop87.LnVsop(0.00000256589, 3.72410394286, 199.07200143640),
				new Vsop87.LnVsop(0.00000261005, 0.82048379203, 380.12776796000),
				new Vsop87.LnVsop(0.00000220381, 1.65114584814, 543.91805909620),
				new Vsop87.LnVsop(0.00000201991, 1.80692992449,
						1375.77379984580),
				new Vsop87.LnVsop(0.00000207336, 1.85463683689, 525.75881183150),
				new Vsop87.LnVsop(0.00000197061, 5.29255821015,
						1155.36115740700),
				new Vsop87.LnVsop(0.00000235139, 1.22694468346, 909.81873305460),
				new Vsop87.LnVsop(0.00000174827, 5.90974976879, 956.28915597060),
				new Vsop87.LnVsop(0.00000149385, 4.37744775359,
						1685.05212250160),
				new Vsop87.LnVsop(0.00000175197, 3.22647697998,
						1898.35121793960),
				new Vsop87.LnVsop(0.00000175172, 3.72977441220, 942.06206196900),
				new Vsop87.LnVsop(0.00000157917, 4.36478445901,
						1795.25844372100),
				new Vsop87.LnVsop(0.00000137898, 1.31800455202,
						1169.58825140860),
				new Vsop87.LnVsop(0.00000117498, 2.50021486074,
						1596.18644228460),
				new Vsop87.LnVsop(0.00000150504, 3.90624455135, 74.78159856730),
				new Vsop87.LnVsop(0.00000116786, 3.38920921060, 0.52126486180),
				new Vsop87.LnVsop(0.00000105894, 4.55439354032, 526.50957135690),
				new Vsop87.LnVsop(0.00000130540, 4.16876671917,
						1045.15483618760),
				new Vsop87.LnVsop(0.00000141388, 3.13579930728, 491.55792945680),
				new Vsop87.LnVsop(0.00000099524, 1.42112622270, 532.87235883230),
				new Vsop87.LnVsop(0.00000096143, 1.18143253105, 117.31986822020),
				new Vsop87.LnVsop(0.00000091732, 0.85722451006,
						1272.68102562720),
				new Vsop87.LnVsop(0.00000087704, 1.21730504350, 453.42489381900),
				new Vsop87.LnVsop(0.00000068531, 2.35201905890, 2.92076130680),
				new Vsop87.LnVsop(0.00000066111, 5.34380967040,
						1471.75302706360),
				new Vsop87.LnVsop(0.00000077401, 4.42676354183, 39.35687591520),
				new Vsop87.LnVsop(0.00000072028, 4.23856425835,
						2111.65031337760),
				new Vsop87.LnVsop(0.00000063345, 4.97658360088, 0.75075952540),
				new Vsop87.LnVsop(0.00000059423, 4.11122034593,
						2001.44399215820),
				new Vsop87.LnVsop(0.00000062471, 0.51213142347, 220.41264243880),
				new Vsop87.LnVsop(0.00000066540, 2.98844410276,
						2214.74308759620),
				new Vsop87.LnVsop(0.00000060295, 4.12633619420, 4.19278569400),
				new Vsop87.LnVsop(0.00000056014, 1.15477785231, 21.34064100240),
				new Vsop87.LnVsop(0.00000052954, 0.91283039851, 10.29494073850),
				new Vsop87.LnVsop(0.00000070461, 5.14178006023, 835.03713448730),
				new Vsop87.LnVsop(0.00000051903, 4.10065404719,
						1258.45393162560),
				new Vsop87.LnVsop(0.00000046583, 4.66599487054, 5.62907429250),
				new Vsop87.LnVsop(0.00000058261, 5.86719898935,
						5753.38488489680),
				new Vsop87.LnVsop(0.00000040103, 4.68801114087, 0.16005869440),
				new Vsop87.LnVsop(0.00000046785, 4.79414027278, 305.34616939270),
				new Vsop87.LnVsop(0.00000039306, 4.25499338010, 853.19638175200),
				new Vsop87.LnVsop(0.00000046153, 5.10982849847, 4.66586644600),
				new Vsop87.LnVsop(0.00000054583, 1.57071663540, 983.11585891360),
				new Vsop87.LnVsop(0.00000038921, 6.07598407822, 518.64526483070),
				new Vsop87.LnVsop(0.00000038460, 2.43832240008, 433.71173787680),
				new Vsop87.LnVsop(0.00000046910, 3.54638837922, 5.41662597140),
				new Vsop87.LnVsop(0.00000041834, 4.67980756775, 302.16477565500),
				new Vsop87.LnVsop(0.00000035921, 2.45088327353, 430.53034413910),
				new Vsop87.LnVsop(0.00000039307, 1.71678059616, 11.04570026390),
				new Vsop87.LnVsop(0.00000037895, 0.21140086073,
						2648.45482547300),
				new Vsop87.LnVsop(0.00000037566, 6.19479786035, 831.85574074960),
				new Vsop87.LnVsop(0.00000035845, 4.61505536309,
						2008.55753915900),
				new Vsop87.LnVsop(0.00000043402, 0.14992219581, 528.20649238630),
				new Vsop87.LnVsop(0.00000031581, 5.14178165108,
						1788.14489672020),
				new Vsop87.LnVsop(0.00000029860, 5.34424466576,
						2221.85663459700),
				new Vsop87.LnVsop(0.00000032959, 5.28952640380, 88.86568021700),
				new Vsop87.LnVsop(0.00000027686, 1.85227036207, 0.21244832110),
				new Vsop87.LnVsop(0.00000025821, 3.85920335036,
						2317.83586181480),
				new Vsop87.LnVsop(0.00000024705, 2.63498818000, 114.13847448250),
				new Vsop87.LnVsop(0.00000033844, 1.00563073311,
						9683.59458111640),
				new Vsop87.LnVsop(0.00000024248, 3.82564321484,
						1574.84580128220),
				new Vsop87.LnVsop(0.00000027111, 2.80845416546, 18.15924726470),
				new Vsop87.LnVsop(0.00000026837, 1.77586073782, 532.13864564940),
				new Vsop87.LnVsop(0.00000026212, 2.74456887801,
						2531.13495725280),
				new Vsop87.LnVsop(0.00000030765, 0.42330199069, 1.48447270830),
				new Vsop87.LnVsop(0.00000030469, 3.66675723074, 508.35032409220),
				new Vsop87.LnVsop(0.00000023191, 3.24511984498, 984.60033162190),
				new Vsop87.LnVsop(0.00000019445, 0.52370214464, 14.97785352700),
				new Vsop87.LnVsop(0.00000019331, 4.85656303715,
						1361.54670584420),
				new Vsop87.LnVsop(0.00000022889, 3.85009333532,
						2428.04218303420),
				new Vsop87.LnVsop(0.00000021613, 6.01647014213,
						1063.31408345230),
				new Vsop87.LnVsop(0.00000020167, 5.59590496803, 527.24328453980),
				new Vsop87.LnVsop(0.00000023732, 2.52764898478, 494.26624244250),
				new Vsop87.LnVsop(0.00000020190, 1.01559114881, 628.85158605010),
				new Vsop87.LnVsop(0.00000015994, 5.09003506053, 529.73914920440),
				new Vsop87.LnVsop(0.00000016134, 5.27096450385, 142.44965013380),
				new Vsop87.LnVsop(0.00000020697, 4.03443555572, 355.74874557180),
				new Vsop87.LnVsop(0.00000021480, 1.28666873894, 35.42472265210),
				new Vsop87.LnVsop(0.00000014981, 4.86119818170,
						2104.53676637680),
				new Vsop87.LnVsop(0.00000017242, 1.59187221366,
						1439.50969814920),
				new Vsop87.LnVsop(0.00000015994, 1.89222393849, 529.64278098480),
				new Vsop87.LnVsop(0.00000017957, 4.30177741048, 6.15033915430),
				new Vsop87.LnVsop(0.00000013287, 2.18960688770,
						1055.44977692610),
				new Vsop87.LnVsop(0.00000014809, 0.87727524457, 99.16062095550),
				new Vsop87.LnVsop(0.00000014148, 2.71597731671, 0.26063243090),
				new Vsop87.LnVsop(0.00000014202, 2.41335744746, 530.65417294110),
				new Vsop87.LnVsop(0.00000015331, 6.07685758999, 149.56319713460),
				new Vsop87.LnVsop(0.00000015832, 4.11682340572, 636.71589257630),
				new Vsop87.LnVsop(0.00000016199, 2.77035135003, 760.25553592000),
				new Vsop87.LnVsop(0.00000012258, 2.61067822838, 405.25754987360),
				new Vsop87.LnVsop(0.00000013665, 3.56042954023, 217.23124870110),
				new Vsop87.LnVsop(0.00000015261, 2.81823022031, 621.73803904930),
				new Vsop87.LnVsop(0.00000014680, 6.26419083616, 569.04784100980),
				new Vsop87.LnVsop(0.00000012529, 1.39076773846, 7.06536289100),
				new Vsop87.LnVsop(0.00000011603, 4.60461324892, 7.16173111060),
				new Vsop87.LnVsop(0.00000011676, 3.60450719576,
						2634.22773147140),
				new Vsop87.LnVsop(0.00000012182, 0.24373178668,
						1485.98012106520),
				new Vsop87.LnVsop(0.00000011352, 2.00814398370,
						1073.60902419080),
				new Vsop87.LnVsop(0.00000011241, 2.48010676188, 423.41679713830),
				new Vsop87.LnVsop(0.00000010942, 5.03605236981, 458.84151979040),
				new Vsop87.LnVsop(0.00000011121, 4.04930841517, 519.39602435610),
				new Vsop87.LnVsop(0.00000012266, 4.30151937187, 604.47256366190),
				new Vsop87.LnVsop(0.00000013150, 2.72184449861,
						1364.72809958190),
				new Vsop87.LnVsop(0.00000010604, 3.11518747071, 1.27202438720),
				new Vsop87.LnVsop(0.00000009873, 1.70233190646,
						1699.27921650320),
				new Vsop87.LnVsop(0.00000010828, 5.08717082517,
						2324.94940881560),
				new Vsop87.LnVsop(0.00000010692, 2.51399278354,
						2847.52682690940),
				new Vsop87.LnVsop(0.00000012646, 4.75590815200, 528.72775724810),
				new Vsop87.LnVsop(0.00000010084, 4.05599680401, 38.13303563780),
				new Vsop87.LnVsop(0.00000011536, 2.35035142816, 643.82943957710),
				new Vsop87.LnVsop(0.00000010218, 3.65818193440, 107.02492748170),
				new Vsop87.LnVsop(0.00000010234, 3.63741793836,
						2744.43405269080),
				new Vsop87.LnVsop(0.00000010105, 1.31344662885,
						1905.46476494040),
				new Vsop87.LnVsop(0.00000009338, 5.92214604272,
						1148.24761040620),
				new Vsop87.LnVsop(0.00000008796, 2.77421597882, 6.59228213900),
				new Vsop87.LnVsop(0.00000008421, 4.52526352162,
						1677.93857550080),
				new Vsop87.LnVsop(0.00000010128, 2.09031029378, 511.53171782990),
				new Vsop87.LnVsop(0.00000008280, 2.98793394775, 540.73666535850),
				new Vsop87.LnVsop(0.00000009753, 1.22443091754, 32.24332891440),
				new Vsop87.LnVsop(0.00000010629, 2.07778578633, 92.04707395470),
				new Vsop87.LnVsop(0.00000007886, 0.99641706679, 408.43894361130),
				new Vsop87.LnVsop(0.00000008813, 3.46912264870,
						1021.24889455140),
				new Vsop87.LnVsop(0.00000007941, 2.86765260965,
						2125.87740737920),
				new Vsop87.LnVsop(0.00000008575, 5.29585347114, 415.55249061210),
				new Vsop87.LnVsop(0.00000007841, 6.08025868276, 70.84944530420),
				new Vsop87.LnVsop(0.00000007706, 1.69807427167, 8.07675484730),
				new Vsop87.LnVsop(0.00000007265, 4.65479123794, 629.60234557550),
				new Vsop87.LnVsop(0.00000007163, 4.93237560809,
						1056.20053645150),
				new Vsop87.LnVsop(0.00000007248, 4.61590472787,
						2420.92863603340),
				new Vsop87.LnVsop(0.00000007712, 2.13818572880, 33.94024994380),
				new Vsop87.LnVsop(0.00000006645, 0.45640663795, 635.96513305090),
				new Vsop87.LnVsop(0.00000009377, 4.03158387581,
						2810.92146160520),
				new Vsop87.LnVsop(0.00000008221, 1.23649767817,
						1802.37199072180),
				new Vsop87.LnVsop(0.00000006340, 0.07280718454, 202.25339517410),
				new Vsop87.LnVsop(0.00000006383, 3.54298789012,
						1891.23767093880),
				new Vsop87.LnVsop(0.00000007901, 2.32514375888, 230.56457082540),
				new Vsop87.LnVsop(0.00000006214, 4.54560345236, 2.70831298570),
				new Vsop87.LnVsop(0.00000007347, 1.24457591968, 24.37902238820),
				new Vsop87.LnVsop(0.00000007472, 3.02787419533, 330.61896365820),
				new Vsop87.LnVsop(0.00000006246, 1.77826735859,
						1062.56332392690),
				new Vsop87.LnVsop(0.00000005674, 5.14130380414, 746.92221379570),
				new Vsop87.LnVsop(0.00000005855, 5.42127169330, 28.31117565130),
				new Vsop87.LnVsop(0.00000005629, 3.24347319369, 529.16970023280),
				new Vsop87.LnVsop(0.00000007653, 0.52812977555, 672.14061522840),
				new Vsop87.LnVsop(0.00000005456, 3.34715399006,
						2950.61960112800),
				new Vsop87.LnVsop(0.00000007127, 1.43485695449, 6.21977512350),
				new Vsop87.LnVsop(0.00000005388, 4.90171438369, 69.15252427480),
				new Vsop87.LnVsop(0.00000005608, 4.98112575538,
						2641.34127847220),
				new Vsop87.LnVsop(0.00000005843, 2.95362326688, 490.33408917940),
				new Vsop87.LnVsop(0.00000004943, 5.37603229206, 721.64941953020),
				new Vsop87.LnVsop(0.00000005120, 4.85758375369, 31.01948863700),
				new Vsop87.LnVsop(0.00000005163, 5.07430434384, 67.66805156650),
				new Vsop87.LnVsop(0.00000004738, 6.10247687172, 106.27416795630),
				new Vsop87.LnVsop(0.00000004879, 0.07093292758, 78.71375183040),
				new Vsop87.LnVsop(0.00000004854, 5.63875710470, 1.69692102940),
				new Vsop87.LnVsop(0.00000005629, 3.73870719507, 530.21222995640),
				new Vsop87.LnVsop(0.00000004471, 4.49152590899, 505.31194270640),
				new Vsop87.LnVsop(0.00000004313, 4.79367774897, 535.10759106600),
				new Vsop87.LnVsop(0.00000004280, 0.54783823710, 1.43628859850),
				new Vsop87.LnVsop(0.00000004453, 0.50550043817, 524.06189080210),
				new Vsop87.LnVsop(0.00000004936, 4.82992128024, 422.66603761290),
				new Vsop87.LnVsop(0.00000004701, 3.41632316320,
						3060.82592234740),
				new Vsop87.LnVsop(0.00000004261, 2.67050830494, 561.93429400900),
				new Vsop87.LnVsop(0.00000004156, 4.00674305729, 99.91138048090),
				new Vsop87.LnVsop(0.00000004561, 2.29662333497,
						3163.91869656600),
				new Vsop87.LnVsop(0.00000004414, 5.67223937661,
						1464.63948006280),
				new Vsop87.LnVsop(0.00000005270, 3.89098773035, 191.95845443560),
				new Vsop87.LnVsop(0.00000005344, 0.31505537960,
						1289.94650101460),
				new Vsop87.LnVsop(0.00000003856, 4.28927088609,
						1994.33044515740),
				new Vsop87.LnVsop(0.00000004227, 5.32680781419,
						2538.24850425360),
				new Vsop87.LnVsop(0.00000003968, 4.56799284427,
						1382.88734684660),
				new Vsop87.LnVsop(0.00000003874, 1.56573094048, 647.01083331480),
				new Vsop87.LnVsop(0.00000004227, 5.51697565211,
						5223.69391980220),
				new Vsop87.LnVsop(0.00000004130, 2.81118299519, 416.30325013750),
				new Vsop87.LnVsop(0.00000003662, 4.35201972236,
						2737.32050569000),
				new Vsop87.LnVsop(0.00000003584, 5.48543989133, 750.10360753340),
				new Vsop87.LnVsop(0.00000004329, 0.84948546685, 531.17543780290),
				new Vsop87.LnVsop(0.00000004093, 0.19987691246, 525.02509864860),
				new Vsop87.LnVsop(0.00000003400, 6.00302355875, 1.22384027740),
				new Vsop87.LnVsop(0.00000003496, 0.31250621097, 597.35901666110),
				new Vsop87.LnVsop(0.00000003957, 1.92811865595,
						1512.80682400820),
				new Vsop87.LnVsop(0.00000003299, 4.27641782638, 526.77020378780),
				new Vsop87.LnVsop(0.00000003218, 2.90660065796, 963.40270297140),
				new Vsop87.LnVsop(0.00000003150, 3.81062282472, 280.96714700450),
				new Vsop87.LnVsop(0.00000004129, 4.74946631331, 0.89377187730),
				new Vsop87.LnVsop(0.00000003840, 1.91064921809, 378.64329525170),
				new Vsop87.LnVsop(0.00000003057, 1.65588839054, 528.94020556920),
				new Vsop87.LnVsop(0.00000003011, 1.59274545702, 224.34479570190),
				new Vsop87.LnVsop(0.00000003197, 5.86630896662, 4.14460158420),
				new Vsop87.LnVsop(0.00000003628, 0.07910101827, 558.00214074590),
				new Vsop87.LnVsop(0.00000002932, 0.41424504523, 7.86430652620),
				new Vsop87.LnVsop(0.00000003316, 2.70210829186, 532.61172640140),
				new Vsop87.LnVsop(0.00000002925, 4.47579366684, 533.88375078860),
				new Vsop87.LnVsop(0.00000003688, 0.39899953746, 685.47393735270),
				new Vsop87.LnVsop(0.00000003224, 2.45813595822, 960.22130923370),
				new Vsop87.LnVsop(0.00000003059, 5.32615258179, 530.44172462000),
				new Vsop87.LnVsop(0.00000003383, 4.42166889790, 312.45971639350),
				new Vsop87.LnVsop(0.00000003321, 2.71397444568, 495.75071515080),
				new Vsop87.LnVsop(0.00000002698, 5.23121581439, 739.80866679490),
				new Vsop87.LnVsop(0.00000003591, 2.30995707520, 908.33426034630),
				new Vsop87.LnVsop(0.00000002619, 3.09144103989,
						3267.01147078460),
				new Vsop87.LnVsop(0.00000003567, 5.07207593227, 73.29712585900),
				new Vsop87.LnVsop(0.00000002797, 2.98948711408, 483.22054217860),
				new Vsop87.LnVsop(0.00000003397, 3.29611266379, 911.30320576290),
				new Vsop87.LnVsop(0.00000003352, 1.44371985824, 593.42686339800),
				new Vsop87.LnVsop(0.00000002563, 3.35095990562,
						2207.62954059540),
				new Vsop87.LnVsop(0.00000002553, 0.36858603419,
						1048.33622992530),
				new Vsop87.LnVsop(0.00000002621, 3.82783663712, 520.12973753900),
				new Vsop87.LnVsop(0.00000003356, 1.08298579333, 46.47042291600),
				new Vsop87.LnVsop(0.00000003397, 3.83080921477, 210.11770170030),
				new Vsop87.LnVsop(0.00000003023, 5.52874613382, 618.55664531160),
				new Vsop87.LnVsop(0.00000002498, 0.47888741754, 945.24345570670),
				new Vsop87.LnVsop(0.00000002665, 0.49714213041,
						1057.89745748090),
				new Vsop87.LnVsop(0.00000002322, 5.87923753103,
						2751.54759969160),
				new Vsop87.LnVsop(0.00000002587, 0.03759881914, 1.64453140270),
				new Vsop87.LnVsop(0.00000002901, 2.50012990691, 525.49817940060),
				new Vsop87.LnVsop(0.00000003153, 2.30879679988, 457.61767951300),
				new Vsop87.LnVsop(0.00000002199, 3.94421228731, 31.49256938900),
				new Vsop87.LnVsop(0.00000002381, 6.19254995974, 327.43756992050),
				new Vsop87.LnVsop(0.00000002458, 0.65614526486,
						9153.90361602180),
				new Vsop87.LnVsop(0.00000002111, 5.61905648764, 16.46232623530),
				new Vsop87.LnVsop(0.00000002135, 3.75723920792, 724.83081326790),
				new Vsop87.LnVsop(0.00000002406, 2.29315638318, 195.13984817330),
				new Vsop87.LnVsop(0.00000002166, 5.43273753334, 534.35683154060),
				new Vsop87.LnVsop(0.00000002073, 1.50113866877, 551.03160609700),
				new Vsop87.LnVsop(0.00000002678, 5.06400504512, 456.39383923560),
				new Vsop87.LnVsop(0.00000002078, 5.28920605515, 76.26607127560),
				new Vsop87.LnVsop(0.00000002260, 5.38117794868,
						1781.03134971940),
				new Vsop87.LnVsop(0.00000002356, 0.67397074780, 227.52618943960),
				new Vsop87.LnVsop(0.00000002245, 3.18183437676,
						3377.21779200400),
				new Vsop87.LnVsop(0.00000002184, 3.08383961547, 524.27433912320),
				new Vsop87.LnVsop(0.00000002120, 2.70078368869, 387.24131496080),
				new Vsop87.LnVsop(0.00000002116, 6.20284849642, 209.36694217490),
				new Vsop87.LnVsop(0.00000002712, 3.18157742001,
						1474.67378837040),
				new Vsop87.LnVsop(0.00000002127, 1.24322560799, 539.98590583310),
				new Vsop87.LnVsop(0.00000002034, 4.81691423751,
						2957.73314812880),
				new Vsop87.LnVsop(0.00000002424, 3.57564169482, 953.10776223290),
				new Vsop87.LnVsop(0.00000001947, 1.94468082531, 529.53090640020),
				new Vsop87.LnVsop(0.00000001896, 4.01429491115,
						2310.72231481400),
				new Vsop87.LnVsop(0.00000001934, 4.10019561108,
						3053.71237534660),
				new Vsop87.LnVsop(0.00000002056, 6.27074172997, 245.54242435240),
				new Vsop87.LnVsop(0.00000002108, 3.22886421713, 252.65597135320),
				new Vsop87.LnVsop(0.00000002596, 2.77467288033, 177.87437278590),
				new Vsop87.LnVsop(0.00000001919, 3.14810072956, 381.61224066830),
				new Vsop87.LnVsop(0.00000002217, 1.92368906923, 535.91074021810),
				new Vsop87.LnVsop(0.00000001947, 5.03751779986, 529.85102378900),
				new Vsop87.LnVsop(0.00000002025, 4.82814272957, 17.26547538740),
				new Vsop87.LnVsop(0.00000001945, 2.10604975291,
						3480.31056622260),
				new Vsop87.LnVsop(0.00000001899, 0.05094358013, 560.71045373160),
				new Vsop87.LnVsop(0.00000002204, 0.59883534036,
						3178.14579056760),
				new Vsop87.LnVsop(0.00000002271, 1.67327013848, 731.94436026870),
				new Vsop87.LnVsop(0.00000001706, 5.40277333462, 20.44686912510),
				new Vsop87.LnVsop(0.00000002292, 4.20486152808,
						1038.04128918680),
				new Vsop87.LnVsop(0.00000002218, 3.65953926062, 282.45161971280),
				new Vsop87.LnVsop(0.00000002182, 4.87392902929, 535.32003938710),
				new Vsop87.LnVsop(0.00000001745, 1.34021867874, 25.12978191360),
				new Vsop87.LnVsop(0.00000001601, 3.92730015840, 17.52610781830),
				new Vsop87.LnVsop(0.00000001832, 0.31684585935, 124.43341522100),
				new Vsop87.LnVsop(0.00000001651, 0.63598292839, 17.40848773930),
				new Vsop87.LnVsop(0.00000002041, 0.15616571970, 598.84348936940),
				new Vsop87.LnVsop(0.00000001494, 3.81397557923, 319.57326339430),
				new Vsop87.LnVsop(0.00000001550, 5.25207305606, 437.64389113990),
				new Vsop87.LnVsop(0.00000001852, 2.36130812462, 37.87240320690),
				new Vsop87.LnVsop(0.00000001466, 1.72925259575, 59.80374504030),
				new Vsop87.LnVsop(0.00000001443, 1.18211898345, 440.82528487760),
				new Vsop87.LnVsop(0.00000001417, 5.82294202166, 81.75213321620),
				new Vsop87.LnVsop(0.00000001404, 0.26052756597, 50.40257617910),
				new Vsop87.LnVsop(0.00000001906, 4.06896916057,
						1819.63746610920),
				new Vsop87.LnVsop(0.00000001756, 2.32963193021, 938.12990870590),
				new Vsop87.LnVsop(0.00000001487, 2.24866746540, 10.03430830760),
				new Vsop87.LnVsop(0.00000001364, 3.56722222020,
						1514.29129671650),
				new Vsop87.LnVsop(0.00000001400, 4.84490735600, 295.05122865420),
				new Vsop87.LnVsop(0.00000001344, 2.20177702106, 529.90341341570),
				new Vsop87.LnVsop(0.00000001339, 1.16084562282,
						2435.15573003500),
				new Vsop87.LnVsop(0.00000001767, 5.45221132569,
						2854.64037391020),
				new Vsop87.LnVsop(0.00000001678, 6.22853454017, 833.55266177900),
				new Vsop87.LnVsop(0.00000001471, 4.80574673735, 696.51963761660),
				new Vsop87.LnVsop(0.00000001436, 1.45810543491, 537.76771994190),
				new Vsop87.LnVsop(0.00000001657, 0.02916161564, 138.51749687070),
				new Vsop87.LnVsop(0.00000001300, 3.14077552949, 547.85021235930),
				new Vsop87.LnVsop(0.00000001343, 6.14827104783, 988.53248488500),
				new Vsop87.LnVsop(0.00000001244, 2.81685406295,
						3583.40334044120),
				new Vsop87.LnVsop(0.00000001344, 4.78042160411, 529.47851677350),
				new Vsop87.LnVsop(0.00000001649, 2.12096966866,
						1061.82961074400),
				new Vsop87.LnVsop(0.00000001343, 1.43417621076,
						1158.54255114470),
				new Vsop87.LnVsop(0.00000001476, 0.24757783675,
						1593.00504854690),
				new Vsop87.LnVsop(0.00000001413, 3.07444531604,
						6283.07584999140),
				new Vsop87.LnVsop(0.00000001245, 5.94918194719,
						1056.93424963440),
				new Vsop87.LnVsop(0.00000001389, 2.87752350116,
						1023.95720753710),
				new Vsop87.LnVsop(0.00000001263, 3.46181945031, 40.84134862350),
				new Vsop87.LnVsop(0.00000001325, 4.15426187385, 916.93228005540),
				new Vsop87.LnVsop(0.00000001193, 1.96467811927,
						1969.20066324380),
				new Vsop87.LnVsop(0.00000001166, 4.65530520965, 944.98282327580),
				new Vsop87.LnVsop(0.00000001477, 5.26757779384, 810.65811209910),
				new Vsop87.LnVsop(0.00000001137, 2.48561382158, 2.00573757010),
				new Vsop87.LnVsop(0.00000001118, 3.80747957482, 7.00167241620),
				new Vsop87.LnVsop(0.00000001138, 5.11611531676, 885.43971066640),
				new Vsop87.LnVsop(0.00000001131, 1.54587053613, 775.23338944700),
				new Vsop87.LnVsop(0.00000001477, 4.69745636225, 630.33605875840),
				new Vsop87.LnVsop(0.00000001252, 1.34285306257, 739.05790726950),
				new Vsop87.LnVsop(0.00000001446, 5.54999644374, 43.28902917830),
				new Vsop87.LnVsop(0.00000001273, 5.19038966009,
						2097.42321937600),
				new Vsop87.LnVsop(0.00000001101, 4.56980597491,
						3274.12501778540),
				new Vsop87.LnVsop(0.00000001376, 3.61001303649, 415.29185818120),
				new Vsop87.LnVsop(0.00000001437, 6.22449718728, 155.78297225810),
				new Vsop87.LnVsop(0.00000001167, 4.09455518613, 203.00415469950),
				new Vsop87.LnVsop(0.00000001237, 4.41132627005, 292.01284726840),
				new Vsop87.LnVsop(0.00000001260, 3.05940711410,
						1894.41906467650),
				new Vsop87.LnVsop(0.00000001077, 2.57045229823, 25.27279426550),
				new Vsop87.LnVsop(0.00000001230, 4.78806138085,
						1166.40685767090),
				new Vsop87.LnVsop(0.00000001020, 3.23608012616,
						2524.02141025200),
				new Vsop87.LnVsop(0.00000001341, 0.49262294590, 635.23141986800),
				new Vsop87.LnVsop(0.00000001209, 3.36291805492, 521.61421024730),
				new Vsop87.LnVsop(0.00000001030, 1.81822316076, 465.95506679120),
				new Vsop87.LnVsop(0.00000001338, 1.26080837186, 902.70518605380),
				new Vsop87.LnVsop(0.00000001037, 3.87887112181,
						3370.10424500320),
				new Vsop87.LnVsop(0.00000001224, 0.09270815220, 824.74219374880),
				new Vsop87.LnVsop(0.00000000991, 4.16587901561, 632.83192342300),
				new Vsop87.LnVsop(0.00000001256, 3.04496727213, 447.79581952650),
				new Vsop87.LnVsop(0.00000000976, 3.80163486221,
						2627.11418447060),
				new Vsop87.LnVsop(0.00000001049, 2.94996331904,
						3693.60966166060),
				new Vsop87.LnVsop(0.00000000984, 0.98260252064, 632.73555520340),
				new Vsop87.LnVsop(0.00000001050, 2.20935815967, 7.22542158540),
				new Vsop87.LnVsop(0.00000000992, 5.41914618009,
						1059.43011429900),
				new Vsop87.LnVsop(0.00000000961, 0.87315283345, 544.66881862160),
				new Vsop87.LnVsop(0.00000001044, 5.63190253364, 732.69511979410),
				new Vsop87.LnVsop(0.00000001049, 5.81616384906, 26.82670294300),
				new Vsop87.LnVsop(0.00000001162, 0.01265418336, 850.01498801430),
				new Vsop87.LnVsop(0.00000001110, 3.63236419104, 306.83064210100),
				new Vsop87.LnVsop(0.00000001077, 0.95773741232, 608.40471692500),
				new Vsop87.LnVsop(0.00000001285, 4.22955322265,
						1215.16490244730),
				new Vsop87.LnVsop(0.00000001060, 3.85856786258, 631.82053146670),
				new Vsop87.LnVsop(0.00000001165, 3.50653563773, 8.59801970910),
				new Vsop87.LnVsop(0.00000000932, 4.62514414355,
						1049.08698945070),
				new Vsop87.LnVsop(0.00000001243, 6.16316972773, 462.02291352810),
				new Vsop87.LnVsop(0.00000001035, 1.30805281638, 633.74694715970),
				new Vsop87.LnVsop(0.00000001238, 2.21195391602,
						25558.21217647960),
				new Vsop87.LnVsop(0.00000001240, 2.27960685992, 6.90109867970),
				new Vsop87.LnVsop(0.00000000941, 4.14573950731, 945.99421523210),
				new Vsop87.LnVsop(0.00000000927, 6.10893117621, 514.71311156760),
				new Vsop87.LnVsop(0.00000000914, 6.17641484462, 952.35700270750),
				new Vsop87.LnVsop(0.00000000893, 4.27448748055, 0.63313944640),
				new Vsop87.LnVsop(0.00000000903, 1.94322862741,
						3796.70243587920),
				new Vsop87.LnVsop(0.00000001162, 5.51229668479, 2.96894541660),
				new Vsop87.LnVsop(0.00000001042, 1.65853884324, 565.11568774670),
				new Vsop87.LnVsop(0.00000000901, 3.03566995700, 460.53844081980),
				new Vsop87.LnVsop(0.00000000903, 2.24012900198, 523.54062594030),
				new Vsop87.LnVsop(0.00000001063, 0.99370930422, 320.32402291970),
				new Vsop87.LnVsop(0.00000000970, 4.56604202702, 429.04587143080),
				new Vsop87.LnVsop(0.00000001070, 4.33159520959, 610.69233878540),
				new Vsop87.LnVsop(0.00000000861, 2.82160166871,
						1060.34513803570),
				new Vsop87.LnVsop(0.00000000882, 4.80008598720, 384.05992122310),
				new Vsop87.LnVsop(0.00000000959, 5.45446729951, 451.94042111070),
				new Vsop87.LnVsop(0.00000001042, 5.79270367192, 303.86169668440),
				new Vsop87.LnVsop(0.00000000854, 0.32316261535,
						1098.73880610440),
				new Vsop87.LnVsop(0.00000000784, 1.85121094914, 313.21047591890),
				new Vsop87.LnVsop(0.00000000782, 3.03559242565, 5.84152261360),
				new Vsop87.LnVsop(0.00000001051, 1.41051789534, 72.07328558160),
				new Vsop87.LnVsop(0.00000000854, 1.22328398267, 611.44309831080),
				new Vsop87.LnVsop(0.00000000899, 5.32174286122,
						3171.03224356680),
				new Vsop87.LnVsop(0.00000000991, 2.22133552179,
						1059.33374607940),
				new Vsop87.LnVsop(0.00000000719, 4.92550251320, 421.93232443000),
				new Vsop87.LnVsop(0.00000000954, 3.98272904231, 836.52160719560),
				new Vsop87.LnVsop(0.00000000822, 4.49680557640,
						10213.28554621100),
				new Vsop87.LnVsop(0.00000000715, 4.62515255534, 385.54439393140),
				new Vsop87.LnVsop(0.00000000730, 1.87143496079, 153.49535039770),
				new Vsop87.LnVsop(0.00000000708, 2.93048853593, 417.03696332040),
				new Vsop87.LnVsop(0.00000000864, 3.03246422011,
						1041.22268292450),
				new Vsop87.LnVsop(0.00000000708, 6.01601101389, 395.10562148700),
				new Vsop87.LnVsop(0.00000000935, 6.01864688839, 173.94221952280),
				new Vsop87.LnVsop(0.00000000695, 1.39408383356, 432.01481684740),
				new Vsop87.LnVsop(0.00000000687, 3.06548397571, 529.95159752550),
				new Vsop87.LnVsop(0.00000000679, 2.18654815982,
						2228.97018159780),
				new Vsop87.LnVsop(0.00000000802, 0.83949166659,
						1261.63532536330),
				new Vsop87.LnVsop(0.00000000677, 3.58329228033, 244.31858407500),
				new Vsop87.LnVsop(0.00000000850, 5.46114025921, 41.05379694460),
				new Vsop87.LnVsop(0.00000000817, 4.65313917851, 535.84130424890),
				new Vsop87.LnVsop(0.00000000652, 0.44220736244,
						1201.83158032300),
				new Vsop87.LnVsop(0.00000000711, 0.96230448675, 373.01422095920),
				new Vsop87.LnVsop(0.00000000665, 1.03244633471, 623.22251175760),
				new Vsop87.LnVsop(0.00000000743, 2.79188326958,
						1173.52040467170),
				new Vsop87.LnVsop(0.00000000643, 5.05336021072, 522.62560220360),
				new Vsop87.LnVsop(0.00000000639, 4.22718483639, 25.86349509650),
				new Vsop87.LnVsop(0.00000000846, 3.26302783028,
						1151.42900414390),
				new Vsop87.LnVsop(0.00000000715, 5.07610655676,
						1058.41872234270),
				new Vsop87.LnVsop(0.00000000833, 1.49468358374, 563.63121503840),
				new Vsop87.LnVsop(0.00000000760, 4.34851471971, 100.64509366380),
				new Vsop87.LnVsop(0.00000000781, 3.58209400202,
						2281.23049651060),
				new Vsop87.LnVsop(0.00000000633, 6.23841236159, 679.25416222920),
				new Vsop87.LnVsop(0.00000000879, 1.69353525086,
						1744.85586754190),
				new Vsop87.LnVsop(0.00000000633, 4.31803237654,
						3590.51688744200),
				new Vsop87.LnVsop(0.00000000651, 2.45318135806,
						1585.14074202070),
				new Vsop87.LnVsop(0.00000000618, 2.68178794760,
						3899.79521009780),
				new Vsop87.LnVsop(0.00000000646, 2.88581188015, 13.49338081870),
				new Vsop87.LnVsop(0.00000000731, 5.86652105139, 501.37978944330),
				new Vsop87.LnVsop(0.00000000644, 4.64527687663,
						1134.16352875650),
				new Vsop87.LnVsop(0.00000000651, 0.83706409863,
						2015.67108615980),
				new Vsop87.LnVsop(0.00000000796, 5.36663489938, 420.96911658350),
				new Vsop87.LnVsop(0.00000000641, 4.76533725270, 567.82400073240),
				new Vsop87.LnVsop(0.00000000802, 5.79880803733, 981.63138620530),
				new Vsop87.LnVsop(0.00000000764, 5.05232912435, 827.92358748650),
				new Vsop87.LnVsop(0.00000000604, 5.11227651497,
						1159.29331067010),
				new Vsop87.LnVsop(0.00000000745, 1.80925868883,
						2332.06295581640),
				new Vsop87.LnVsop(0.00000000666, 2.06624389616, 27.08733537390),
				new Vsop87.LnVsop(0.00000000559, 0.17540224930, 63.73589830340),
				new Vsop87.LnVsop(0.00000000654, 4.94087804792,
						2413.81508903260),
				new Vsop87.LnVsop(0.00000000727, 1.05835550856, 490.07345674850),
				new Vsop87.LnVsop(0.00000000732, 5.93179840659, 42.53826965290),
				new Vsop87.LnVsop(0.00000000573, 3.61521168878,
						3686.49611465980),
				new Vsop87.LnVsop(0.00000000633, 4.21755652519, 166.82867252200),
				new Vsop87.LnVsop(0.00000000687, 3.91671464947, 529.43033266370),
				new Vsop87.LnVsop(0.00000000570, 2.73603650313,
						4010.00153131720),
				new Vsop87.LnVsop(0.00000000600, 1.82660431776, 522.52923398400),
				new Vsop87.LnVsop(0.00000000551, 5.08473283991,
						1354.43315884340),
				new Vsop87.LnVsop(0.00000000519, 6.11952999304, 366.79444583570),
				new Vsop87.LnVsop(0.00000000719, 0.85722557203, 362.86229257260),
				new Vsop87.LnVsop(0.00000000518, 2.03954063338, 418.52143602870),
				new Vsop87.LnVsop(0.00000000515, 3.51750445096, 528.41894070740),
				new Vsop87.LnVsop(0.00000000515, 3.47893153369, 103.14095832840),
				new Vsop87.LnVsop(0.00000000550, 5.77676837013, 420.44785172170),
				new Vsop87.LnVsop(0.00000000550, 0.61414019478, 104.05598206510),
				new Vsop87.LnVsop(0.00000000495, 2.41738200479, 179.35884549420),
				new Vsop87.LnVsop(0.00000000513, 0.29786764002, 103.04459010880),
				new Vsop87.LnVsop(0.00000000537, 5.47946247228, 771.30123618390),
				new Vsop87.LnVsop(0.00000000508, 3.08930305232,
						1357.61455258110),
				new Vsop87.LnVsop(0.00000000495, 4.95361665264, 536.85269620520),
				new Vsop87.LnVsop(0.00000000681, 4.56250434221, 112.65400177420),
				new Vsop87.LnVsop(0.00000000484, 0.79038835602, 28.45418800320),
				new Vsop87.LnVsop(0.00000000529, 5.46978500000, 419.43645976540),
				new Vsop87.LnVsop(0.00000000596, 4.98134265245,
						1251.34038462480),
				new Vsop87.LnVsop(0.00000000482, 3.60230884794,
						2943.50605412720),
				new Vsop87.LnVsop(0.00000000492, 3.95966654574,
						1269.49963188950),
				new Vsop87.LnVsop(0.00000000630, 6.16456074704, 105.54045477340),
				new Vsop87.LnVsop(0.00000000480, 0.86786400621, 35.21227433100),
				new Vsop87.LnVsop(0.00000000463, 3.15421544338, 934.94851496820),
				new Vsop87.LnVsop(0.00000000586, 5.48425579444, 56.62235130260),
				new Vsop87.LnVsop(0.00000000475, 2.28309287464,
						2042.49778910280),
				new Vsop87.LnVsop(0.00000000502, 1.43671788962, 469.88722005430),
				new Vsop87.LnVsop(0.00000000565, 1.90952569252, 107.28555991260),
				new Vsop87.LnVsop(0.00000000467, 2.35119921534,
						1603.29998928540),
				new Vsop87.LnVsop(0.00000000464, 3.82801546235,
						1550.93985964600),
				new Vsop87.LnVsop(0.00000000605, 1.65413715574, 761.74000862830),
				new Vsop87.LnVsop(0.00000000443, 5.46290368791, 135.33610313300),
				new Vsop87.LnVsop(0.00000000580, 2.06327501551, 493.04240216510),
				new Vsop87.LnVsop(0.00000000540, 1.73777056143, 536.75632798560),
				new Vsop87.LnVsop(0.00000000433, 0.27166977225, 93.53154666300),
				new Vsop87.LnVsop(0.00000000515, 3.46469417422, 530.96298948180),
				new Vsop87.LnVsop(0.00000000441, 5.28940184186, 497.44763618020),
				new Vsop87.LnVsop(0.00000000487, 5.78767525063,
						12036.46073488820),
				new Vsop87.LnVsop(0.00000000571, 3.71223026143,
						1279.79457262800),
				new Vsop87.LnVsop(0.00000000419, 3.43816729207,
						1070.42763045310),
				new Vsop87.LnVsop(0.00000000452, 2.57855232310,
						1254.52177836250),
				new Vsop87.LnVsop(0.00000000426, 3.21103415941,
						2840.41327990860),
				new Vsop87.LnVsop(0.00000000414, 1.54298025443, 115.62294719080),
				new Vsop87.LnVsop(0.00000000424, 0.12594305292,
						1268.74887236410),
				new Vsop87.LnVsop(0.00000000411, 3.12423996609, 536.28324723360),
				new Vsop87.LnVsop(0.00000000452, 1.00220432453, 113.38771495710),
				new Vsop87.LnVsop(0.00000000420, 0.81806831366,
						1165.65609814550),
				new Vsop87.LnVsop(0.00000000434, 0.36146452053,
						1304.92435454160),
				new Vsop87.LnVsop(0.00000000401, 5.70119897835,
						1127.04998175570),
				new Vsop87.LnVsop(0.00000000461, 3.26463688117, 102.12956637210),
				new Vsop87.LnVsop(0.00000000533, 2.54951538277, 141.22580985640),
				new Vsop87.LnVsop(0.00000000413, 4.38709867977,
						6151.53388830500),
				new Vsop87.LnVsop(0.00000000425, 3.93823979711, 561.18353448360),
				new Vsop87.LnVsop(0.00000000390, 2.68799663827, 576.16138801060),
				new Vsop87.LnVsop(0.00000000473, 4.76746213122, 277.03499374140),
				new Vsop87.LnVsop(0.00000000415, 1.68861617904, 391.17346822390),
				new Vsop87.LnVsop(0.00000000392, 3.96583998204,
						3906.90875709860),
				new Vsop87.LnVsop(0.00000000385, 1.69122429631,
						4113.09430553580),
				new Vsop87.LnVsop(0.00000000451, 5.49097711996, 602.98809095360),
				new Vsop87.LnVsop(0.00000000499, 3.80738289142, 81.00137369080),
				new Vsop87.LnVsop(0.00000000454, 0.10975881410, 600.54041039880),
				new Vsop87.LnVsop(0.00000000377, 6.25455256536, 913.75088631770),
				new Vsop87.LnVsop(0.00000000453, 3.86104865566, 758.77106321170),
				new Vsop87.LnVsop(0.00000000407, 5.13475793028,
						3487.42411322340),
				new Vsop87.LnVsop(0.00000000400, 4.44473187959, 990.22940591440),
				new Vsop87.LnVsop(0.00000000435, 3.76103015832, 523.09868295560),
				new Vsop87.LnVsop(0.00000000365, 5.16456643007,
						4694.00295470760),
				new Vsop87.LnVsop(0.00000000454, 1.63326913717, 976.00231191280),
				new Vsop87.LnVsop(0.00000000406, 2.72098337513,
						1438.02522544090),
				new Vsop87.LnVsop(0.00000000349, 3.59598547445,
						1058.86066532740),
				new Vsop87.LnVsop(0.00000000354, 0.62083841520, 498.67147645760),
				new Vsop87.LnVsop(0.00000000383, 5.09228018194, 539.25219265020),
				new Vsop87.LnVsop(0.00000000430, 6.14341047130,
						3067.93946934820),
				new Vsop87.LnVsop(0.00000000391, 3.25185051260,
						2655.56837247380),
				new Vsop87.LnVsop(0.00000000459, 3.43896606345, 121.25202148330),
				new Vsop87.LnVsop(0.00000000435, 3.59822556033, 860.30992875280),
				new Vsop87.LnVsop(0.00000000424, 4.72908722432,
						1366.21257229020),
				new Vsop87.LnVsop(0.00000000327, 4.55290845875,
						1696.09782276550),
				new Vsop87.LnVsop(0.00000000324, 4.23685005208, 642.34496686880),
				new Vsop87.LnVsop(0.00000000395, 3.26281926074, 484.44438245600),
				new Vsop87.LnVsop(0.00000000330, 6.05223507989, 215.74677599280),
				new Vsop87.LnVsop(0.00000000417, 0.20262936620, 842.90144101350),
				new Vsop87.LnVsop(0.00000000408, 0.45802341103,
						1578.02719501990),
				new Vsop87.LnVsop(0.00000000342, 6.15346179830,
						1371.84164658270),
				new Vsop87.LnVsop(0.00000000340, 2.77813018312, 3.52311834900),
				new Vsop87.LnVsop(0.00000000363, 4.68453721321,
						2730.20695868920),
				new Vsop87.LnVsop(0.00000000309, 1.97341771897, 754.03576079650),
				new Vsop87.LnVsop(0.00000000324, 0.32544817254, 586.31331639720),
				new Vsop87.LnVsop(0.00000000302, 2.08708848834, 526.98265210890),
				new Vsop87.LnVsop(0.00000000352, 5.13897382364, 523.47118997110),
				new Vsop87.LnVsop(0.00000000352, 5.75014912811, 806.72595883600),
				new Vsop87.LnVsop(0.00000000309, 2.49798852626,
						4326.39340097380),
				new Vsop87.LnVsop(0.00000000295, 2.35354744096,
						4216.18707975440),
				new Vsop87.LnVsop(0.00000000300, 1.17310114418, 700.45179087970),
				new Vsop87.LnVsop(0.00000000335, 4.47490824488,
						1585.89150154610),
				new Vsop87.LnVsop(0.00000000300, 4.94243905681,
						1379.70595310890),
				new Vsop87.LnVsop(0.00000000324, 4.32475054774, 299.12639426920),
				new Vsop87.LnVsop(0.00000000402, 2.04619630460, 842.15068148810),
				new Vsop87.LnVsop(0.00000000312, 4.59043534747, 188.92007304980),
				new Vsop87.LnVsop(0.00000000288, 2.25534557761, 878.32616366560),
				new Vsop87.LnVsop(0.00000000395, 5.99139284997,
						3384.33133900480),
				new Vsop87.LnVsop(0.00000000380, 1.67961592499, 36.64856292950),
				new Vsop87.LnVsop(0.00000000338, 1.32019124492, 148.07872442630),
				new Vsop87.LnVsop(0.00000000391, 4.82188766380,
						1012.91150727320),
				new Vsop87.LnVsop(0.00000000332, 2.02575723995,
						1091.62525910360),
				new Vsop87.LnVsop(0.00000000282, 0.39153852422, 207.67002114550),
				new Vsop87.LnVsop(0.00000000280, 3.80317669283, 298.23262239190),
				new Vsop87.LnVsop(0.00000000386, 6.26771150540,
						1141.13406340540),
				new Vsop87.LnVsop(0.00000000293, 4.53809139767,
						1446.62324515000),
				new Vsop87.LnVsop(0.00000000349, 4.09122089564,
						1059.90319505100),
				new Vsop87.LnVsop(0.00000000301, 4.46304798246,
						1567.73225428140),
				new Vsop87.LnVsop(0.00000000318, 5.50558184307,
						5216.58037280140),
				new Vsop87.LnVsop(0.00000000327, 4.76582526444, 134.58534360760),
				new Vsop87.LnVsop(0.00000000280, 2.16530669990,
						2964.84669512960),
				new Vsop87.LnVsop(0.00000000283, 3.90409016441, 127.47179660680),
				new Vsop87.LnVsop(0.00000000275, 0.88658304766,
						1474.93442080130),
				new Vsop87.LnVsop(0.00000000322, 2.48245791694,
						1065.60170531270),
				new Vsop87.LnVsop(0.00000000360, 0.62008772137,
						1542.60247236780),
				new Vsop87.LnVsop(0.00000000286, 5.85849625329, 172.24529849340),
				new Vsop87.LnVsop(0.00000000270, 4.08297977357,
						1578.77795454530),
				new Vsop87.LnVsop(0.00000000362, 1.06148806683, 181.80652604900),
				new Vsop87.LnVsop(0.00000000335, 4.50997684981,
						2349.32843120380),
				new Vsop87.LnVsop(0.00000000275, 3.38473535401,
						4002.88798431640),
				new Vsop87.LnVsop(0.00000000315, 3.68770155844,
						1440.99417085750),
				new Vsop87.LnVsop(0.00000000252, 2.40663004080, 97.67614824720),
				new Vsop87.LnVsop(0.00000000279, 5.22410340680,
						4649.89881763120),
				new Vsop87.LnVsop(0.00000000290, 0.61661476278,
						9146.79006902100),
				new Vsop87.LnVsop(0.00000000248, 4.45243005934,
						1688.98427576470),
				new Vsop87.LnVsop(0.00000000300, 3.07432010319,
						1902.28337120270),
				new Vsop87.LnVsop(0.00000000292, 2.70170039150, 987.30864460760),
				new Vsop87.LnVsop(0.00000000258, 4.79343588315,
						1670.82502850000),
				new Vsop87.LnVsop(0.00000000319, 1.34244131618,
						1288.46202830630),
				new Vsop87.LnVsop(0.00000000256, 3.45257813604,
						3259.89792378380),
				new Vsop87.LnVsop(0.00000000325, 5.57785413832,
						1670.07426897460),
				new Vsop87.LnVsop(0.00000000248, 4.23500945233, 849.26422848890),
				new Vsop87.LnVsop(0.00000000278, 0.25405518415, 874.39401040250),
				new Vsop87.LnVsop(0.00000000299, 4.67059404038,
						1329.30337692980),
				new Vsop87.LnVsop(0.00000000295, 5.86995680986,
						2804.23779773110),
				new Vsop87.LnVsop(0.00000000328, 6.06415193771,
						1821.12193881750),
				new Vsop87.LnVsop(0.00000000245, 4.68144067248,
						77204.32749453338),
				new Vsop87.LnVsop(0.00000000237, 4.97805954611, 351.81659230870),
				new Vsop87.LnVsop(0.00000000302, 1.20236584617, 232.04904353370),
				new Vsop87.LnVsop(0.00000000303, 5.53364383200,
						2274.54683263650),
				new Vsop87.LnVsop(0.00000000286, 2.41146391401,
						2545.36205125440),
				new Vsop87.LnVsop(0.00000000233, 1.50676309691,
						1688.23351623930),
				new Vsop87.LnVsop(0.00000000250, 2.31712160522, 632.26247445140),
				new Vsop87.LnVsop(0.00000000238, 5.06850996242,
						3803.81598288000),
				new Vsop87.LnVsop(0.00000000227, 6.27454357025,
						1586.62521472900),
				new Vsop87.LnVsop(0.00000000226, 0.05894638117,
						1518.22344997960),
				new Vsop87.LnVsop(0.00000000259, 3.86479264667, 782.34693644780),
				new Vsop87.LnVsop(0.00000000235, 0.16574304942, 137.03302416240),
				new Vsop87.LnVsop(0.00000000225, 2.32024197535,
						2498.89162833840),
				new Vsop87.LnVsop(0.00000000224, 6.18923621853, 546.15329132990),
				new Vsop87.LnVsop(0.00000000224, 3.37553489276,
						1077.54117745390),
				new Vsop87.LnVsop(0.00000000222, 1.23639175728, 513.22863885930),
				new Vsop87.LnVsop(0.00000000246, 2.81685819136, 633.30500417500),
				new Vsop87.LnVsop(0.00000000286, 5.08443662064, 774.00954916960),
				new Vsop87.LnVsop(0.00000000269, 4.93013868827, 151.04766984290),
				new Vsop87.LnVsop(0.00000000276, 5.42875443749, 986.08480433020),
				new Vsop87.LnVsop(0.00000000239, 0.71912390253,
						1276.61317889030),
				new Vsop87.LnVsop(0.00000000281, 0.54377467623,
						2122.69601364150),
				new Vsop87.LnVsop(0.00000000218, 2.90308501961, 85.82729883120),
				new Vsop87.LnVsop(0.00000000221, 0.99955195094,
						1053.75285589670),
				new Vsop87.LnVsop(0.00000000283, 6.28058228271, 71.81265315070),
				new Vsop87.LnVsop(0.00000000271, 6.01605176699, 170.76082578510),
				new Vsop87.LnVsop(0.00000000215, 5.76717651257, 208.63322899200),
				new Vsop87.LnVsop(0.00000000228, 1.19429336725,
						1060.86640289750),
				new Vsop87.LnVsop(0.00000000264, 3.93467981347,
						1363.24362687360),
				new Vsop87.LnVsop(0.00000000228, 5.04184148954,
						1064.79855616060),
				new Vsop87.LnVsop(0.00000000295, 2.15253083015,
						6386.16862421000),
				new Vsop87.LnVsop(0.00000000217, 3.24577492609,
						2424.11002977110),
				new Vsop87.LnVsop(0.00000000236, 4.50018016828,
						24498.83024629040),
				new Vsop87.LnVsop(0.00000000211, 4.25651045434,
						5069.38346150640),
				new Vsop87.LnVsop(0.00000000264, 5.81676359510, 77.96299230500),
				new Vsop87.LnVsop(0.00000000256, 5.65979495257, 799.61241183520),
				new Vsop87.LnVsop(0.00000000210, 5.29881111973,
						1457.52593306200),
				new Vsop87.LnVsop(0.00000000208, 5.72006005477,
						1064.04779663520),
				new Vsop87.LnVsop(0.00000000241, 6.25063055391,
						1621.31622419820),
				new Vsop87.LnVsop(0.00000000235, 2.20691049290,
						1570.91364801910),
				new Vsop87.LnVsop(0.00000000212, 2.88214546012,
						1674.00642223770),
				new Vsop87.LnVsop(0.00000000206, 1.59586698276,
						4429.48617519240),
				new Vsop87.LnVsop(0.00000000206, 3.37322544845,
						1053.96530421780),
				new Vsop87.LnVsop(0.00000000250, 4.49171024387,
						1482.79872732750),
				new Vsop87.LnVsop(0.00000000213, 0.30373351265,
						8624.21265092720),
				new Vsop87.LnVsop(0.00000000223, 4.88418874810,
						1035.00290780100),
				new Vsop87.LnVsop(0.00000000212, 4.20492282875,
						1912.57831194120),
				new Vsop87.LnVsop(0.00000000271, 5.11992121116,
						1818.15299340090),
				new Vsop87.LnVsop(0.00000000210, 4.08825553401, 203.73786788240),
				new Vsop87.LnVsop(0.00000000283, 1.89231830584, 313.94418910180),
				new Vsop87.LnVsop(0.00000000258, 1.73501688448,
						1887.30551767570),
				new Vsop87.LnVsop(0.00000000248, 2.14407705659,
						1592.25428902150),
				new Vsop87.LnVsop(0.00000000210, 4.52024390322,
						1262.38608488870),
				new Vsop87.LnVsop(0.00000000252, 5.69246926803, 104.57724692690),
				new Vsop87.LnVsop(0.00000000219, 2.91834170224,
						2114.83170711530),
				new Vsop87.LnVsop(0.00000000199, 3.93816217381,
						2043.98226181110),
				new Vsop87.LnVsop(0.00000000204, 4.76593693079, 812.14258480740),
				new Vsop87.LnVsop(0.00000000207, 0.25148913797, 533.83556667880),
				new Vsop87.LnVsop(0.00000000215, 2.01665842348, 512.42548970720),
				new Vsop87.LnVsop(0.00000000204, 0.90117975859,
						1408.01712876020),
				new Vsop87.LnVsop(0.00000000225, 1.23997208583,
						3340.61242669980),
				new Vsop87.LnVsop(0.00000000211, 5.13548160002,
						1065.01100448170),
				new Vsop87.LnVsop(0.00000000258, 2.36055913266,
						2861.75392091100),
				new Vsop87.LnVsop(0.00000000198, 4.32566984621, 269.92144674060),
				new Vsop87.LnVsop(0.00000000202, 3.19887703276,
						1553.64817263170),
				new Vsop87.LnVsop(0.00000000194, 2.62013252080, 683.18631549230),
				new Vsop87.LnVsop(0.00000000217, 5.40943412253, 546.95644048200),
				new Vsop87.LnVsop(0.00000000208, 0.06358383719, 991.71387862270),
				new Vsop87.LnVsop(0.00000000267, 3.27705006018,
						5120.60114558360),
				new Vsop87.LnVsop(0.00000000191, 0.70424277574,
						4230.41417375600),
				new Vsop87.LnVsop(0.00000000200, 2.35014426129,
						1591.52057583860),
				new Vsop87.LnVsop(0.00000000214, 6.15608452028, 951.62328952460),
				new Vsop87.LnVsop(0.00000000194, 1.60798799495, 102.57150935680),
				new Vsop87.LnVsop(0.00000000234, 4.93895884950,
						1443.44185141230),
				new Vsop87.LnVsop(0.00000000198, 0.93365862986,
						1909.39691820350),
				new Vsop87.LnVsop(0.00000000185, 4.03264704820,
						1049.82070263360),
				new Vsop87.LnVsop(0.00000000215, 0.97603524748, 479.28838891550),
				new Vsop87.LnVsop(0.00000000245, 2.99717870481,
						1467.82087380050),
				new Vsop87.LnVsop(0.00000000257, 4.70227238723,
						9050.81084180320),
				new Vsop87.LnVsop(0.00000000183, 2.03870101784, 635.70450062000),
				new Vsop87.LnVsop(0.00000000228, 6.23410947014, 64.95973858080),
				new Vsop87.LnVsop(0.00000000180, 4.21309134581, 143.93412284210),
				new Vsop87.LnVsop(0.00000000180, 4.82872225059,
						1063.57471588320),
				new Vsop87.LnVsop(0.00000000180, 5.06126965624, 52.69019803950),
				new Vsop87.LnVsop(0.00000000226, 0.55335289468, 554.06998748280),
				new Vsop87.LnVsop(0.00000000209, 5.67975843693, 48.75804477640),
				new Vsop87.LnVsop(0.00000000186, 3.66359750257, 108.72184851110),
				new Vsop87.LnVsop(0.00000000190, 2.00836664877,
						1058.63117066380),
				new Vsop87.LnVsop(0.00000000180, 1.44709940248, 970.51624997220),
				new Vsop87.LnVsop(0.00000000183, 3.17358464220, 140.96517742550),
				new Vsop87.LnVsop(0.00000000175, 3.79284463842,
						4223.30062675520),
				new Vsop87.LnVsop(0.00000000220, 2.43555893039, 419.53282798500),
				new Vsop87.LnVsop(0.00000000172, 3.04802064781, 54.33472944220),
				new Vsop87.LnVsop(0.00000000176, 3.77033437497,
						3473.19701922180),
				new Vsop87.LnVsop(0.00000000170, 4.66517108448,
						1372.59240610810),
				new Vsop87.LnVsop(0.00000000178, 3.08366669427,
						4319.27985397300),
				new Vsop87.LnVsop(0.00000000198, 0.42731863655, 857.12853501510),
				new Vsop87.LnVsop(0.00000000215, 0.68265759605,
						1054.71606374320),
				new Vsop87.LnVsop(0.00000000174, 0.85388069641,
						1587.58842257550),
				new Vsop87.LnVsop(0.00000000212, 5.41318500564,
						9580.50180689780),
				new Vsop87.LnVsop(0.00000000200, 1.60275119026,
						6681.22485339960),
				new Vsop87.LnVsop(0.00000000193, 2.13003457583, 103.61403908040),
				new Vsop87.LnVsop(0.00000000180, 4.48952373198,
						1144.31545714310),
				new Vsop87.LnVsop(0.00000000165, 4.54343649149,
						1365.47885910730),
				new Vsop87.LnVsop(0.00000000211, 1.53402733679,
						1069.67687092770),
				new Vsop87.LnVsop(0.00000000223, 0.11650319998, 67.88049988760),
				new Vsop87.LnVsop(0.00000000202, 0.35527329970,
						1090.40141882620),
				new Vsop87.LnVsop(0.00000000218, 3.57295707203, 906.84978763800),
				new Vsop87.LnVsop(0.00000000164, 1.06674687948, 594.65070367540),
				new Vsop87.LnVsop(0.00000000175, 2.36532854682, 977.48678462110),
				new Vsop87.LnVsop(0.00000000208, 0.69348288097,
						1128.53445446400),
				new Vsop87.LnVsop(0.00000000171, 5.74458391820,
						1884.12412393800),
				new Vsop87.LnVsop(0.00000000161, 0.85437052339, 537.55527162080),
				new Vsop87.LnVsop(0.00000000207, 0.49276008455, 71.60020482960),
				new Vsop87.LnVsop(0.00000000156, 5.14834108268, 451.72797278960),
				new Vsop87.LnVsop(0.00000000159, 5.37530499642,
						20426.57109242200),
				new Vsop87.LnVsop(0.00000000170, 1.78813796184,
						5230.80746680300),
				new Vsop87.LnVsop(0.00000000218, 0.27875486270, 175.16605980020),
				new Vsop87.LnVsop(0.00000000215, 1.88254208749,
						1140.38330388000),
				new Vsop87.LnVsop(0.00000000209, 3.54917317190,
						3156.80514956520),
				new Vsop87.LnVsop(0.00000000171, 1.79628112458,
						1123.11782849260),
				new Vsop87.LnVsop(0.00000000188, 5.24747110812,
						25565.32572348040),
				new Vsop87.LnVsop(0.00000000214, 3.66925552525, 84.93352695390),
				new Vsop87.LnVsop(0.00000000203, 2.83619345048,
						1489.91227432830),
				new Vsop87.LnVsop(0.00000000173, 4.34546063838,
						3046.59882834580),
				new Vsop87.LnVsop(0.00000000151, 1.16342049906,
						3914.02230409940),
				new Vsop87.LnVsop(0.00000000190, 5.67865609408,
						1060.13268971460),
				new Vsop87.LnVsop(0.00000000167, 0.53874364357, 528.04643369190),
				new Vsop87.LnVsop(0.00000000203, 0.70565787834, 498.19839570560),
				new Vsop87.LnVsop(0.00000000171, 4.21009295927, 946.72792841500),
				new Vsop87.LnVsop(0.00000000205, 3.05470007095,
						1062.30269149600),
				new Vsop87.LnVsop(0.00000000203, 3.28866933881,
						1020.02505427400),
				new Vsop87.LnVsop(0.00000000179, 2.14335011927, 627.36711334180),
				new Vsop87.LnVsop(0.00000000183, 2.35011338194,
						25551.09862947879),
				new Vsop87.LnVsop(0.00000000162, 1.58054653744, 628.59095361920),
				new Vsop87.LnVsop(0.00000000145, 1.33045199323, 821.70381236300),
				new Vsop87.LnVsop(0.00000000181, 2.85483720271,
						1055.18914449520),
				new Vsop87.LnVsop(0.00000000151, 3.43200492547, 629.86297800640),
				new Vsop87.LnVsop(0.00000000178, 3.58994989047,
						2004.36475346500),
				new Vsop87.LnVsop(0.00000000157, 3.15195765206,
						1025.44168024540),
				new Vsop87.LnVsop(0.00000000142, 4.79458547350,
						1799.19059698410),
				new Vsop87.LnVsop(0.00000000162, 4.86173373432, 441.57604440300),
				new Vsop87.LnVsop(0.00000000185, 3.21794429243,
						1595.29267040730),
				new Vsop87.LnVsop(0.00000000139, 0.89228489209,
						1432.39615114840),
				new Vsop87.LnVsop(0.00000000167, 2.85163037043,
						5746.27133789600),
				new Vsop87.LnVsop(0.00000000167, 5.73970232471,
						5760.49843189760),
				new Vsop87.LnVsop(0.00000000180, 3.56547170390,
						3185.25933756840),
				new Vsop87.LnVsop(0.00000000151, 2.13306499259,
						1094.80665284130),
				new Vsop87.LnVsop(0.00000000181, 3.32294686175, 229.08009811710),
				new Vsop87.LnVsop(0.00000000160, 1.05753894323,
						1087.69310584050),
				new Vsop87.LnVsop(0.00000000165, 3.51478084503, 707.56533788050),
				new Vsop87.LnVsop(0.00000000134, 1.82354002117,
						5591.96087960020),
				new Vsop87.LnVsop(0.00000000153, 0.36221123982, 835.78789401270),
				new Vsop87.LnVsop(0.00000000149, 5.48394113995,
						4333.50694797460),
				new Vsop87.LnVsop(0.00000000169, 5.98967815113,
						2210.81093433310),
				new Vsop87.LnVsop(0.00000000130, 4.05971369649,
						2005.37614542130),
				new Vsop87.LnVsop(0.00000000176, 4.67735877741,
						1966.23171782720),
				new Vsop87.LnVsop(0.00000000151, 4.89507270868, 532.39927808030),
				new Vsop87.LnVsop(0.00000000132, 4.46820798180,
						1987.21689815660),
				new Vsop87.LnVsop(0.00000000152, 2.54945350135,
						1589.02471117400),
				new Vsop87.LnVsop(0.00000000135, 2.67785802201,
						78263.70942472259),
				new Vsop87.LnVsop(0.00000000133, 2.22367803003,
						4642.78527063040),
				new Vsop87.LnVsop(0.00000000152, 5.74726585589,
						1589.12107939360),
				new Vsop87.LnVsop(0.00000000131, 5.44366528120,
						1588.10968743730),
				new Vsop87.LnVsop(0.00000000130, 5.08622554741, 650.94298657790),
				new Vsop87.LnVsop(0.00000000127, 3.01271886345,
						1590.03610313030),
				new Vsop87.LnVsop(0.00000000165, 0.63157456503,
						2729.45619916380),
				new Vsop87.LnVsop(0.00000000160, 3.09136733422,
						1493.09366806600),
				new Vsop87.LnVsop(0.00000000126, 4.02785244573,
						2012.48969242210),
				new Vsop87.LnVsop(0.00000000149, 4.88056376194,
						10206.17199921020),
				new Vsop87.LnVsop(0.00000000120, 3.66807990470,
						1268.01515918120),
				new Vsop87.LnVsop(0.00000000120, 1.28575150669,
						3597.63043444280),
				new Vsop87.LnVsop(0.00000000118, 5.98810576269, 531.38788612400),
				new Vsop87.LnVsop(0.00000000118, 1.62024281593, 927.83496796740),
				new Vsop87.LnVsop(0.00000000160, 4.48451486494,
						2654.67460059650),
				new Vsop87.LnVsop(0.00000000128, 4.08631741503, 638.41281360570),
				new Vsop87.LnVsop(0.00000000114, 6.19276216389,
						1834.61531963620),
				new Vsop87.LnVsop(0.00000000113, 0.28741277087,
						1208.94512732380),
				new Vsop87.LnVsop(0.00000000122, 1.34377557036, 446.31134681820),
				new Vsop87.LnVsop(0.00000000113, 2.64305802892,
						3494.53766022420),
				new Vsop87.LnVsop(0.00000000120, 2.29717715125,
						1059.22187149480),
				new Vsop87.LnVsop(0.00000000111, 5.97803783981, 550.13783421970),
				new Vsop87.LnVsop(0.00000000120, 5.96435211741,
						3281.23856478620),
				new Vsop87.LnVsop(0.00000000110, 1.45784255142, 509.24409596950),
				new Vsop87.LnVsop(0.00000000123, 1.58528243666,
						1080.72257119160),
				new Vsop87.LnVsop(0.00000000108, 2.15949816307,
						4532.57894941100),
				new Vsop87.LnVsop(0.00000000131, 2.49342323482, 920.86443331850),
				new Vsop87.LnVsop(0.00000000107, 0.03308245525, 521.82665856840),
				new Vsop87.LnVsop(0.00000000112, 2.26353490193,
						2534.31635099050),
				new Vsop87.LnVsop(0.00000000124, 5.97253582505,
						3700.72320866140),
				new Vsop87.LnVsop(0.00000000143, 0.97252781618,
						4443.71326919400),
				new Vsop87.LnVsop(0.00000000104, 3.10363960804,
						8094.52168583260),
				new Vsop87.LnVsop(0.00000000119, 4.36305496553,
						1056.46116888240),
				new Vsop87.LnVsop(0.00000000104, 5.38869056901, 767.36908292080),
				new Vsop87.LnVsop(0.00000000103, 4.75766349480,
						1226.21060271120),
				new Vsop87.LnVsop(0.00000000116, 0.51605524063,
						5621.84292321040),
				new Vsop87.LnVsop(0.00000000104, 6.08481630108, 528.25467649610),
				new Vsop87.LnVsop(0.00000000119, 1.06475525020, 527.99404406520),
				new Vsop87.LnVsop(0.00000000121, 5.66645074030,
						2200.51599359460),
				new Vsop87.LnVsop(0.00000000135, 3.04469989833,
						2199.76523406920),
				new Vsop87.LnVsop(0.00000000101, 3.61205787591,
						3789.58888887840),
				new Vsop87.LnVsop(0.00000000100, 4.82071617356,
						2100.60461311370),
				new Vsop87.LnVsop(0.00000000136, 2.25652419983,
						1291.43097372290),
				new Vsop87.LnVsop(0.00000000104, 0.89730746810, 531.12725369310),
				new Vsop87.LnVsop(0.00000000108, 0.43456673876, 288.08069400530),
				new Vsop87.LnVsop(0.00000000120, 5.39001412580,
						1059.54198888360),
				new Vsop87.LnVsop(0.00000000125, 0.62099682567,
						1997.51183889510),
				new Vsop87.LnVsop(0.00000000134, 5.25320383252,
						1895.90353738480),
				new Vsop87.LnVsop(0.00000000103, 3.61799646841,
						1792.07704998330),
				new Vsop87.LnVsop(0.00000000118, 1.00645954017, 745.43774108740),
				new Vsop87.LnVsop(0.00000000111, 5.68172209277,
						4017.11507831800),
				new Vsop87.LnVsop(0.00000000093, 1.71996718617,
						4164.31198961300),
				new Vsop87.LnVsop(0.00000000091, 4.54586794299,
						5901.23920225600),
				new Vsop87.LnVsop(0.00000000103, 1.44157781039,
						1731.52254541760),
				new Vsop87.LnVsop(0.00000000094, 2.94025887120, 995.64603188580),
				new Vsop87.LnVsop(0.00000000101, 5.09893554431, 530.58473697190),
				new Vsop87.LnVsop(0.00000000102, 0.27489333673, 450.97721326420),
				new Vsop87.LnVsop(0.00000000121, 3.07830472533, 580.09354127370),
				new Vsop87.LnVsop(0.00000000098, 0.35522834563,
						5371.54823716140),
				new Vsop87.LnVsop(0.00000000089, 2.36605964279,
						1176.70179840940),
				new Vsop87.LnVsop(0.00000000115, 3.54968128884,
						5488.86810538160),
				new Vsop87.LnVsop(0.00000000086, 2.70671848058,
						2424.86078929650),
				new Vsop87.LnVsop(0.00000000109, 0.93924032031,
						3707.83675566220),
				new Vsop87.LnVsop(0.00000000089, 2.47000942358,
						4312.16630697220),
				new Vsop87.LnVsop(0.00000000092, 0.49026147824,
						5392.88887816380),
				new Vsop87.LnVsop(0.00000000085, 0.57009625976,
						1628.42977119900),
				new Vsop87.LnVsop(0.00000000084, 2.52951052433,
						4657.01236463200),
				new Vsop87.LnVsop(0.00000000095, 0.49298916700,
						1230.14275597430),
				new Vsop87.LnVsop(0.00000000101, 1.88318822487, 528.79719321730),
				new Vsop87.LnVsop(0.00000000083, 6.05838879510,
						2858.57252717330),
				new Vsop87.LnVsop(0.00000000083, 3.97031381838, 247.23934538180),
				new Vsop87.LnVsop(0.00000000082, 4.61989860058,
						3252.78437678300),
				new Vsop87.LnVsop(0.00000000081, 2.09438144860,
						2203.69738733230),
				new Vsop87.LnVsop(0.00000000081, 3.48070291292,
						1231.62722868260),
				new Vsop87.LnVsop(0.00000000108, 2.69586646495,
						10110.19277199240),
				new Vsop87.LnVsop(0.00000000083, 0.06930748257, 530.91480537200),
				new Vsop87.LnVsop(0.00000000080, 0.22833904656,
						2218.67524085930),
				new Vsop87.LnVsop(0.00000000083, 0.62963097943, 528.46712481720),
				new Vsop87.LnVsop(0.00000000084, 3.31531263655,
						1895.16982420190),
				new Vsop87.LnVsop(0.00000000082, 4.56743340637,
						6231.85816591420),
				new Vsop87.LnVsop(0.00000000082, 3.36834041159,
						5172.47623572500),
				new Vsop87.LnVsop(0.00000000097, 0.87887326085,
						9690.70812811720),
				new Vsop87.LnVsop(0.00000000097, 4.27398661375,
						9676.48103411560),
				new Vsop87.LnVsop(0.00000000083, 2.55427334700,
						1059.59437851030),
				new Vsop87.LnVsop(0.00000000099, 4.22263740110,
						8521.11987670860),
				new Vsop87.LnVsop(0.00000000078, 5.75868229769,
						5812.37352203900),
				new Vsop87.LnVsop(0.00000000078, 4.55958930291,
						4752.99159184980),
				new Vsop87.LnVsop(0.00000000080, 1.07708178317,
						5378.66178416220),
				new Vsop87.LnVsop(0.00000000078, 0.76677000831, 525.54636351040),
				new Vsop87.LnVsop(0.00000000081, 3.10720885599,
						2527.20280398970),
				new Vsop87.LnVsop(0.00000000081, 0.45113135705,
						2516.90786325120),
				new Vsop87.LnVsop(0.00000000098, 1.42656513937, 757.21715453420),
				new Vsop87.LnVsop(0.00000000087, 4.62233814403, 184.98791978670),
				new Vsop87.LnVsop(0.00000000103, 2.56729943579,
						1124.34166877000),
				new Vsop87.LnVsop(0.00000000102, 1.33070990614,
						3782.47534187760),
				new Vsop87.LnVsop(0.00000000084, 5.05086451175,
						1160.02702385300),
				new Vsop87.LnVsop(0.00000000079, 2.29616426691,
						2758.66114669240),
				new Vsop87.LnVsop(0.00000000080, 0.85136002390,
						1791.32629045790),
				new Vsop87.LnVsop(0.00000000075, 5.42366672204,
						2755.47975295470),
				new Vsop87.LnVsop(0.00000000085, 1.86831566677,
						25028.52121138500),
				new Vsop87.LnVsop(0.00000000079, 4.70716888788,
						4120.20785253660),
				new Vsop87.LnVsop(0.00000000073, 4.69119414591,
						2115.58246664070),
				new Vsop87.LnVsop(0.00000000098, 3.93222636960,
						2124.98363550190),
				new Vsop87.LnVsop(0.00000000072, 3.82048491843,
						4539.69249641180),
				new Vsop87.LnVsop(0.00000000081, 5.76205552882, 617.80588578620), };

		private static final Vsop87.LnVsop[] jupiter_longitude_l1 = {
				new Vsop87.LnVsop(529.69096508814, 0.00000000000, 0.00000000000),
				new Vsop87.LnVsop(0.00489503243, 4.22082939470, 529.69096509460),
				new Vsop87.LnVsop(0.00228917222, 6.02646855621, 7.11354700080),
				new Vsop87.LnVsop(0.00030099479, 4.54540782858,
						1059.38193018920),
				new Vsop87.LnVsop(0.00020720920, 5.45943156902, 522.57741809380),
				new Vsop87.LnVsop(0.00012103653, 0.16994816098, 536.80451209540),
				new Vsop87.LnVsop(0.00006067987, 4.42422292017, 103.09277421860),
				new Vsop87.LnVsop(0.00005433968, 3.98480737746, 419.48464387520),
				new Vsop87.LnVsop(0.00004237744, 5.89008707199, 14.22709400160),
				new Vsop87.LnVsop(0.00002211974, 5.26766687382, 206.18554843720),
				new Vsop87.LnVsop(0.00001983502, 4.88600705699,
						1589.07289528380),
				new Vsop87.LnVsop(0.00001295769, 5.55132752171, 3.18139373770),
				new Vsop87.LnVsop(0.00001163416, 0.51450634873, 3.93215326310),
				new Vsop87.LnVsop(0.00001007167, 0.46474690033, 735.87651353180),
				new Vsop87.LnVsop(0.00001174094, 5.84238857133,
						1052.26838318840),
				new Vsop87.LnVsop(0.00000847762, 5.75765726863, 110.20632121940),
				new Vsop87.LnVsop(0.00000827250, 4.80311857692, 213.29909543800),
				new Vsop87.LnVsop(0.00000829822, 0.59345481695,
						1066.49547719000),
				new Vsop87.LnVsop(0.00001003864, 3.14841622246, 426.59819087600),
				new Vsop87.LnVsop(0.00001098730, 5.30705242117, 515.46387109300),
				new Vsop87.LnVsop(0.00000724923, 5.51690038433, 639.89728631400),
				new Vsop87.LnVsop(0.00000567826, 5.98865760444, 625.67019231240),
				new Vsop87.LnVsop(0.00000474197, 4.13243716360, 412.37109687440),
				new Vsop87.LnVsop(0.00000412936, 5.73653788228, 95.97922721780),
				new Vsop87.LnVsop(0.00000336820, 3.72892266066,
						1162.47470440780),
				new Vsop87.LnVsop(0.00000345412, 4.24128387922, 632.78373931320),
				new Vsop87.LnVsop(0.00000234071, 6.24295755869, 309.27832265580),
				new Vsop87.LnVsop(0.00000194827, 2.21824346028, 323.50541665740),
				new Vsop87.LnVsop(0.00000234805, 4.03315571261, 949.17560896980),
				new Vsop87.LnVsop(0.00000183904, 6.27973919510, 543.91805909620),
				new Vsop87.LnVsop(0.00000198512, 1.50446971008, 838.96928775040),
				new Vsop87.LnVsop(0.00000186807, 6.07956275814, 742.99006053260),
				new Vsop87.LnVsop(0.00000171405, 5.41658811525, 199.07200143640),
				new Vsop87.LnVsop(0.00000130777, 0.62641588161, 728.76296653100),
				new Vsop87.LnVsop(0.00000134095, 5.23702273624,
						2118.76386037840),
				new Vsop87.LnVsop(0.00000115444, 0.67783747230, 846.08283475120),
				new Vsop87.LnVsop(0.00000106501, 4.47671724240, 956.28915597060),
				new Vsop87.LnVsop(0.00000066832, 5.73362353275, 21.34064100240),
				new Vsop87.LnVsop(0.00000069619, 5.97256378090, 532.87235883230),
				new Vsop87.LnVsop(0.00000059950, 1.00657473790,
						1596.18644228460),
				new Vsop87.LnVsop(0.00000063366, 6.05635396519,
						1581.95934828300),
				new Vsop87.LnVsop(0.00000079718, 5.82156733700,
						1045.15483618760),
				new Vsop87.LnVsop(0.00000065635, 0.12938321631, 526.50957135690),
				new Vsop87.LnVsop(0.00000058519, 0.58687309667,
						1155.36115740700),
				new Vsop87.LnVsop(0.00000056610, 1.41183572003, 533.62311835770),
				new Vsop87.LnVsop(0.00000071631, 5.34149334443, 942.06206196900),
				new Vsop87.LnVsop(0.00000057343, 5.96870336620,
						1169.58825140860),
				new Vsop87.LnVsop(0.00000055048, 5.42871116938, 10.29494073850),
				new Vsop87.LnVsop(0.00000052026, 0.22999191591,
						1368.66025284500),
				new Vsop87.LnVsop(0.00000052295, 5.72636754267, 117.31986822020),
				new Vsop87.LnVsop(0.00000050427, 6.08258832558, 525.75881183150),
				new Vsop87.LnVsop(0.00000047278, 3.60428393787,
						1478.86657406440),
				new Vsop87.LnVsop(0.00000042199, 4.13113112919,
						1692.16566950240),
				new Vsop87.LnVsop(0.00000046566, 0.51168261375,
						1265.56747862640),
				new Vsop87.LnVsop(0.00000032801, 5.03520269183, 220.41264243880),
				new Vsop87.LnVsop(0.00000033556, 0.09960615979, 302.16477565500),
				new Vsop87.LnVsop(0.00000029379, 3.35927110207, 4.66586644600),
				new Vsop87.LnVsop(0.00000029311, 0.75894050642, 88.86568021700),
				new Vsop87.LnVsop(0.00000032449, 5.37487176787, 508.35032409220),
				new Vsop87.LnVsop(0.00000029741, 5.42345191096,
						1272.68102562720),
				new Vsop87.LnVsop(0.00000021789, 6.14949766217,
						1685.05212250160),
				new Vsop87.LnVsop(0.00000025194, 1.60716361937, 831.85574074960),
				new Vsop87.LnVsop(0.00000021133, 5.86310776376,
						1258.45393162560),
				new Vsop87.LnVsop(0.00000019668, 2.18904500387, 316.39186965660),
				new Vsop87.LnVsop(0.00000017878, 0.82813691085, 433.71173787680),
				new Vsop87.LnVsop(0.00000017409, 2.75647882058, 853.19638175200),
				new Vsop87.LnVsop(0.00000017703, 5.95527033658, 5.41662597140),
				new Vsop87.LnVsop(0.00000018586, 0.51459954175,
						1375.77379984580),
				new Vsop87.LnVsop(0.00000017469, 0.70855164060,
						1471.75302706360),
				new Vsop87.LnVsop(0.00000014369, 0.91459684737, 18.15924726470),
				new Vsop87.LnVsop(0.00000014107, 0.63031131929, 2.92076130680),
				new Vsop87.LnVsop(0.00000011728, 1.76421689491, 380.12776796000),
				new Vsop87.LnVsop(0.00000011042, 5.56386292919,
						1574.84580128220),
				new Vsop87.LnVsop(0.00000011422, 4.30273286555, 405.25754987360),
				new Vsop87.LnVsop(0.00000010407, 0.30595619562,
						1361.54670584420),
				new Vsop87.LnVsop(0.00000009894, 0.38972478935,
						1073.60902419080),
				new Vsop87.LnVsop(0.00000009808, 5.90342059427, 519.39602435610),
				new Vsop87.LnVsop(0.00000009287, 3.23717178839,
						1795.25844372100),
				new Vsop87.LnVsop(0.00000009079, 5.59391515894,
						2648.45482547300),
				new Vsop87.LnVsop(0.00000008830, 0.53669085248,
						1788.14489672020),
				new Vsop87.LnVsop(0.00000008238, 5.88621877345,
						2001.44399215820),
				new Vsop87.LnVsop(0.00000008058, 5.07394631539,
						1485.98012106520),
				new Vsop87.LnVsop(0.00000006690, 2.41093500491, 4.19278569400),
				new Vsop87.LnVsop(0.00000005917, 4.17942020818,
						2008.55753915900),
				new Vsop87.LnVsop(0.00000007256, 6.19390446816, 11.04570026390),
				new Vsop87.LnVsop(0.00000006272, 1.36131578474,
						1148.24761040620),
				new Vsop87.LnVsop(0.00000005142, 5.23124680535, 628.85158605010),
				new Vsop87.LnVsop(0.00000005141, 2.92956226336, 518.64526483070),
				new Vsop87.LnVsop(0.00000004764, 0.16833299921, 629.60234557550),
				new Vsop87.LnVsop(0.00000004603, 0.78535347104, 721.64941953020),
				new Vsop87.LnVsop(0.00000004573, 6.24771751154,
						1677.93857550080),
				new Vsop87.LnVsop(0.00000004536, 4.95109388690, 635.96513305090),
				new Vsop87.LnVsop(0.00000004434, 1.45220762308,
						2125.87740737920),
				new Vsop87.LnVsop(0.00000004518, 2.06522259381, 453.42489381900),
				new Vsop87.LnVsop(0.00000004428, 0.15677546362,
						1699.27921650320),
				new Vsop87.LnVsop(0.00000005594, 5.57471241370, 191.95845443560),
				new Vsop87.LnVsop(0.00000005405, 1.46221153779, 330.61896365820),
				new Vsop87.LnVsop(0.00000005776, 4.37575545399,
						2221.85663459700),
				new Vsop87.LnVsop(0.00000004265, 0.24198200812,
						2104.53676637680),
				new Vsop87.LnVsop(0.00000004100, 6.19338226411, 636.71589257630),
				new Vsop87.LnVsop(0.00000004432, 4.35787390405, 423.41679713830),
				new Vsop87.LnVsop(0.00000004102, 0.49195461480,
						1056.20053645150),
				new Vsop87.LnVsop(0.00000004527, 0.09244775677,
						1062.56332392690),
				new Vsop87.LnVsop(0.00000004397, 4.14273244974, 511.53171782990),
				new Vsop87.LnVsop(0.00000003567, 5.66550104255,
						2317.83586181480),
				new Vsop87.LnVsop(0.00000003585, 0.28040162482,
						1055.44977692610),
				new Vsop87.LnVsop(0.00000004009, 2.54842404074, 74.78159856730),
				new Vsop87.LnVsop(0.00000003686, 2.93367849990, 32.24332891440),
				new Vsop87.LnVsop(0.00000002969, 5.50022776972, 107.02492748170),
				new Vsop87.LnVsop(0.00000002856, 5.73809418496, 99.91138048090),
				new Vsop87.LnVsop(0.00000002718, 1.25246874516, 540.73666535850),
				new Vsop87.LnVsop(0.00000002808, 3.30714906571, 0.75075952540),
				new Vsop87.LnVsop(0.00000002669, 1.63398531390,
						1063.31408345230),
				new Vsop87.LnVsop(0.00000002667, 4.28683044077, 106.27416795630),
				new Vsop87.LnVsop(0.00000002705, 3.03568370231, 422.66603761290),
				new Vsop87.LnVsop(0.00000003271, 5.89438924876,
						1802.37199072180),
				new Vsop87.LnVsop(0.00000002654, 0.35475530647,
						1898.35121793960),
				new Vsop87.LnVsop(0.00000002574, 3.59809745049, 750.10360753340),
				new Vsop87.LnVsop(0.00000002486, 5.28928577587,
						1891.23767093880),
				new Vsop87.LnVsop(0.00000003221, 4.58424996327, 416.30325013750),
				new Vsop87.LnVsop(0.00000002936, 1.09054035208,
						1464.63948006280),
				new Vsop87.LnVsop(0.00000002398, 6.02106328658, 551.03160609700),
				new Vsop87.LnVsop(0.00000002214, 5.24451644028, 621.73803904930),
				new Vsop87.LnVsop(0.00000002193, 0.00364881833,
						2420.92863603340),
				new Vsop87.LnVsop(0.00000002320, 5.82908812407, 305.34616939270),
				new Vsop87.LnVsop(0.00000002088, 5.99245749935,
						1994.33044515740),
				new Vsop87.LnVsop(0.00000002042, 0.75011275470, 142.44965013380),
				new Vsop87.LnVsop(0.00000002021, 4.17581114855, 569.04784100980),
				new Vsop87.LnVsop(0.00000002110, 6.25440423633, 647.01083331480),
				new Vsop87.LnVsop(0.00000002110, 5.18650189729, 227.52618943960),
				new Vsop87.LnVsop(0.00000002279, 5.79998105466, 539.98590583310),
				new Vsop87.LnVsop(0.00000002004, 4.20934218728,
						2324.94940881560),
				new Vsop87.LnVsop(0.00000001977, 3.99196981525, 24.37902238820),
				new Vsop87.LnVsop(0.00000001953, 1.35695450633, 963.40270297140),
				new Vsop87.LnVsop(0.00000001896, 2.78687918909,
						2428.04218303420),
				new Vsop87.LnVsop(0.00000001970, 5.88674791355, 217.23124870110),
				new Vsop87.LnVsop(0.00000001931, 3.03273886284,
						1382.88734684660),
				new Vsop87.LnVsop(0.00000002034, 3.08513086760, 408.43894361130),
				new Vsop87.LnVsop(0.00000001833, 5.61442879983, 430.53034413910),
				new Vsop87.LnVsop(0.00000001838, 1.25469566267, 81.75213321620),
				new Vsop87.LnVsop(0.00000001820, 5.97506520830, 114.13847448250),
				new Vsop87.LnVsop(0.00000002043, 4.34071262566, 70.84944530420),
				new Vsop87.LnVsop(0.00000001957, 4.03064578017, 92.04707395470),
				new Vsop87.LnVsop(0.00000001768, 0.33096757704, 35.42472265210),
				new Vsop87.LnVsop(0.00000002328, 5.86166964748,
						1038.04128918680),
				new Vsop87.LnVsop(0.00000001831, 4.81134529978, 124.43341522100),
				new Vsop87.LnVsop(0.00000002268, 1.02652901220, 618.55664531160),
				new Vsop87.LnVsop(0.00000001919, 5.01339713289, 99.16062095550),
				new Vsop87.LnVsop(0.00000001923, 0.28688541174, 31.01948863700),
				new Vsop87.LnVsop(0.00000002359, 4.65803416282,
						1905.46476494040),
				new Vsop87.LnVsop(0.00000001879, 5.69252482087, 210.11770170030),
				new Vsop87.LnVsop(0.00000001678, 0.25561675979, 295.05122865420),
				new Vsop87.LnVsop(0.00000001656, 5.46017983557,
						2634.22773147140),
				new Vsop87.LnVsop(0.00000001675, 6.15616456038, 643.82943957710),
				new Vsop87.LnVsop(0.00000001953, 5.09846435548, 17.40848773930),
				new Vsop87.LnVsop(0.00000001539, 2.75248075364, 415.55249061210),
				new Vsop87.LnVsop(0.00000001482, 3.76735041917, 534.35683154060),
				new Vsop87.LnVsop(0.00000001446, 3.15802770791, 25.12978191360),
				new Vsop87.LnVsop(0.00000001421, 0.61909506285, 458.84151979040),
				new Vsop87.LnVsop(0.00000001666, 0.26032169128, 835.03713448730),
				new Vsop87.LnVsop(0.00000001472, 0.83054329617, 28.31117565130),
				new Vsop87.LnVsop(0.00000001654, 0.88874938135,
						1781.03134971940),
				new Vsop87.LnVsop(0.00000001302, 5.75537548503, 440.82528487760),
				new Vsop87.LnVsop(0.00000001349, 2.49744006758, 984.60033162190),
				new Vsop87.LnVsop(0.00000001355, 5.10790739045, 149.56319713460),
				new Vsop87.LnVsop(0.00000001188, 2.24279457878, 31.49256938900),
				new Vsop87.LnVsop(0.00000001231, 0.77900547379, 739.80866679490),
				new Vsop87.LnVsop(0.00000001161, 3.10767970553,
						2111.65031337760),
				new Vsop87.LnVsop(0.00000001178, 4.30970344337, 561.93429400900),
				new Vsop87.LnVsop(0.00000001233, 6.22576640438,
						2214.74308759620),
				new Vsop87.LnVsop(0.00000001095, 6.03022173687,
						2737.32050569000),
				new Vsop87.LnVsop(0.00000001324, 4.22919631556,
						2538.24850425360),
				new Vsop87.LnVsop(0.00000001346, 3.20576632074, 525.02509864860),
				new Vsop87.LnVsop(0.00000001057, 5.76574985561,
						2310.72231481400),
				new Vsop87.LnVsop(0.00000001158, 0.46300827788, 67.66805156650),
				new Vsop87.LnVsop(0.00000001027, 0.20709586018, 7.86430652620),
				new Vsop87.LnVsop(0.00000001143, 5.56632279390, 46.47042291600),
				new Vsop87.LnVsop(0.00000001012, 0.54307369204, 532.13864564940),
				new Vsop87.LnVsop(0.00000000979, 5.14088953450,
						2207.62954059540),
				new Vsop87.LnVsop(0.00000000993, 2.03698162387, 319.57326339430),
				new Vsop87.LnVsop(0.00000001035, 2.90325691870, 611.44309831080),
				new Vsop87.LnVsop(0.00000001021, 4.75668560880, 527.24328453980),
				new Vsop87.LnVsop(0.00000001310, 1.78907016216, 824.74219374880),
				new Vsop87.LnVsop(0.00000000895, 2.54589419261,
						2744.43405269080),
				new Vsop87.LnVsop(0.00000000890, 5.41093971819, 28.45418800320),
				new Vsop87.LnVsop(0.00000000985, 0.88687783832,
						5760.49843189760),
				new Vsop87.LnVsop(0.00000000983, 1.42102189882,
						5746.27133789600),
				new Vsop87.LnVsop(0.00000000893, 5.87175153771, 203.00415469950),
				new Vsop87.LnVsop(0.00000000922, 4.17425091286,
						2641.34127847220),
				new Vsop87.LnVsop(0.00000000876, 0.75315488921,
						1439.50969814920),
				new Vsop87.LnVsop(0.00000000945, 2.31584676883,
						9690.70812811720),
				new Vsop87.LnVsop(0.00000000941, 2.84331047707,
						9676.48103411560),
				new Vsop87.LnVsop(0.00000000867, 0.81016495601, 524.27433912320),
				new Vsop87.LnVsop(0.00000000828, 2.35268476661, 312.45971639350),
				new Vsop87.LnVsop(0.00000000912, 2.80494184378, 6.21977512350),
				new Vsop87.LnVsop(0.00000000808, 1.05165559697, 529.64278098480),
				new Vsop87.LnVsop(0.00000000779, 4.79938843208, 945.24345570670),
				new Vsop87.LnVsop(0.00000000878, 5.76532521399, 1.64453140270),
				new Vsop87.LnVsop(0.00000000954, 4.30880174100, 209.36694217490),
				new Vsop87.LnVsop(0.00000000772, 5.25564170894,
						2950.61960112800),
				new Vsop87.LnVsop(0.00000000745, 0.03807300102, 535.10759106600),
				new Vsop87.LnVsop(0.00000000744, 0.58381523987, 25.27279426550),
				new Vsop87.LnVsop(0.00000000735, 0.19889697619,
						1049.08698945070),
				new Vsop87.LnVsop(0.00000000747, 2.71776604422, 38.13303563780),
				new Vsop87.LnVsop(0.00000000728, 5.97254317194, 945.99421523210),
				new Vsop87.LnVsop(0.00000000769, 4.51524159414, 952.35700270750),
				new Vsop87.LnVsop(0.00000000711, 0.38043574201, 69.15252427480),
				new Vsop87.LnVsop(0.00000000761, 3.07043913906, 39.35687591520),
				new Vsop87.LnVsop(0.00000000802, 1.14189803237, 532.61172640140),
				new Vsop87.LnVsop(0.00000000704, 1.25543872788, 547.85021235930),
				new Vsop87.LnVsop(0.00000000800, 3.20276130202, 604.47256366190),
				new Vsop87.LnVsop(0.00000000821, 1.05238771575, 909.81873305460),
				new Vsop87.LnVsop(0.00000000725, 5.68293554150, 953.10776223290),
				new Vsop87.LnVsop(0.00000000682, 1.20168457647, 387.24131496080),
				new Vsop87.LnVsop(0.00000000640, 3.91564016975, 528.72775724810),
				new Vsop87.LnVsop(0.00000000663, 0.81538903178,
						2228.97018159780),
				new Vsop87.LnVsop(0.00000000808, 4.24946672460, 529.73914920440),
				new Vsop87.LnVsop(0.00000000768, 0.58100515131,
						2097.42321937600),
				new Vsop87.LnVsop(0.00000000693, 2.51156186683, 916.93228005540),
				new Vsop87.LnVsop(0.00000000784, 4.23618116997, 195.13984817330),
				new Vsop87.LnVsop(0.00000000763, 1.12270397266, 732.69511979410),
				new Vsop87.LnVsop(0.00000000617, 5.80980286923, 739.05790726950),
				new Vsop87.LnVsop(0.00000000734, 4.24709115085, 760.25553592000),
				new Vsop87.LnVsop(0.00000000592, 3.26062064584, 202.25339517410),
				new Vsop87.LnVsop(0.00000000552, 5.83536244089, 526.77020378780),
				new Vsop87.LnVsop(0.00000000714, 4.90042609368,
						2751.54759969160),
				new Vsop87.LnVsop(0.00000000640, 1.38548213559, 530.65417294110),
				new Vsop87.LnVsop(0.00000000620, 3.01948741376, 902.70518605380),
				new Vsop87.LnVsop(0.00000000722, 5.18172356552, 1.48447270830),
				new Vsop87.LnVsop(0.00000000530, 5.96271879869,
						2015.67108615980),
				new Vsop87.LnVsop(0.00000000541, 3.78415919087,
						2957.73314812880),
				new Vsop87.LnVsop(0.00000000530, 6.10433734445,
						2531.13495725280),
				new Vsop87.LnVsop(0.00000000569, 4.12853081905,
						2854.64037391020),
				new Vsop87.LnVsop(0.00000000498, 4.62946077069, 934.94851496820),
				new Vsop87.LnVsop(0.00000000523, 3.63882931609, 437.64389113990),
				new Vsop87.LnVsop(0.00000000527, 5.80963579852,
						3053.71237534660),
				new Vsop87.LnVsop(0.00000000489, 5.93594675987,
						3178.14579056760),
				new Vsop87.LnVsop(0.00000000488, 4.99103190309, 483.22054217860),
				new Vsop87.LnVsop(0.00000000487, 5.55239102762,
						2627.11418447060),
				new Vsop87.LnVsop(0.00000000478, 0.83306238983,
						1603.29998928540),
				new Vsop87.LnVsop(0.00000000487, 5.86510858429, 724.83081326790),
				new Vsop87.LnVsop(0.00000000453, 0.61324874134,
						1159.29331067010),
				new Vsop87.LnVsop(0.00000000451, 2.28214016934,
						3060.82592234740),
				new Vsop87.LnVsop(0.00000000515, 4.78127185341, 447.79581952650),
				new Vsop87.LnVsop(0.00000000537, 0.63663065397,
						1354.43315884340),
				new Vsop87.LnVsop(0.00000000461, 2.67886294351,
						1021.24889455140),
				new Vsop87.LnVsop(0.00000000450, 1.91049628603, 597.35901666110),
				new Vsop87.LnVsop(0.00000000488, 5.56151436365,
						2435.15573003500),
				new Vsop87.LnVsop(0.00000000432, 3.64946046991, 313.21047591890),
				new Vsop87.LnVsop(0.00000000435, 3.02448452708, 533.88375078860),
				new Vsop87.LnVsop(0.00000000426, 5.07997231709,
						2524.02141025200),
				new Vsop87.LnVsop(0.00000000491, 3.59200148259, 230.56457082540),
				new Vsop87.LnVsop(0.00000000503, 1.57595009240, 454.90936652730),
				new Vsop87.LnVsop(0.00000000526, 2.02899667490,
						1279.79457262800),
				new Vsop87.LnVsop(0.00000000388, 5.58072092256, 731.94436026870),
				new Vsop87.LnVsop(0.00000000449, 1.11025492739, 56.62235130260),
				new Vsop87.LnVsop(0.00000000460, 4.42534443381, 462.02291352810),
				new Vsop87.LnVsop(0.00000000495, 0.36191781331,
						1251.34038462480),
				new Vsop87.LnVsop(0.00000000398, 5.20119376110,
						3267.01147078460),
				new Vsop87.LnVsop(0.00000000416, 1.70821947228, 245.54242435240),
				new Vsop87.LnVsop(0.00000000355, 1.65214516751, 78.71375183040),
				new Vsop87.LnVsop(0.00000000366, 5.75203350764,
						2847.52682690940),
				new Vsop87.LnVsop(0.00000000403, 1.72240208145,
						1141.13406340540),
				new Vsop87.LnVsop(0.00000000334, 6.01033746350, 960.22130923370),
				new Vsop87.LnVsop(0.00000000331, 1.74101810453, 490.33408917940),
				new Vsop87.LnVsop(0.00000000314, 5.73955945935,
						1158.54255114470),
				new Vsop87.LnVsop(0.00000000389, 0.31258924956,
						2413.81508903260),
				new Vsop87.LnVsop(0.00000000328, 3.50753080884,
						3274.12501778540),
				new Vsop87.LnVsop(0.00000000349, 0.38232238589,
						2332.06295581640),
				new Vsop87.LnVsop(0.00000000300, 4.75999716377, 938.12990870590),
				new Vsop87.LnVsop(0.00000000325, 0.54991590409, 43.28902917830),
				new Vsop87.LnVsop(0.00000000288, 4.90497702380,
						1357.61455258110),
				new Vsop87.LnVsop(0.00000000304, 6.12658548685,
						1262.38608488870),
				new Vsop87.LnVsop(0.00000000285, 2.89817774175, 530.21222995640),
				new Vsop87.LnVsop(0.00000000285, 4.56582790812,
						1268.74887236410),
				new Vsop87.LnVsop(0.00000000310, 4.69121773135, 76.26607127560),
				new Vsop87.LnVsop(0.00000000278, 5.49867187248, 280.96714700450),
				new Vsop87.LnVsop(0.00000000279, 4.66775152978,
						1261.63532536330),
				new Vsop87.LnVsop(0.00000000357, 5.45944338384, 113.38771495710),
				new Vsop87.LnVsop(0.00000000300, 4.11291800981,
						1048.33622992530),
				new Vsop87.LnVsop(0.00000000283, 1.09440291187,
						1512.80682400820),
				new Vsop87.LnVsop(0.00000000326, 0.60265644873, 827.92358748650),
				new Vsop87.LnVsop(0.00000000280, 2.64073976181, 373.01422095920),
				new Vsop87.LnVsop(0.00000000267, 1.94524254858,
						3377.21779200400),
				new Vsop87.LnVsop(0.00000000283, 5.36501811239,
						1165.65609814550),
				new Vsop87.LnVsop(0.00000000281, 5.54752717581,
						3370.10424500320),
				new Vsop87.LnVsop(0.00000000269, 3.92616563946, 42.53826965290),
				new Vsop87.LnVsop(0.00000000270, 4.93414229832,
						1041.22268292450),
				new Vsop87.LnVsop(0.00000000274, 1.86909714777,
						2655.56837247380),
				new Vsop87.LnVsop(0.00000000259, 2.56026215512,
						9146.79006902100),
				new Vsop87.LnVsop(0.00000000258, 5.96872448521,
						1269.49963188950),
				new Vsop87.LnVsop(0.00000000254, 1.35449984820,
						1061.82961074400),
				new Vsop87.LnVsop(0.00000000282, 3.01539201149, 320.32402291970),
				new Vsop87.LnVsop(0.00000000272, 4.18505693688,
						8624.21265092720),
				new Vsop87.LnVsop(0.00000000245, 1.24462798353, 252.65597135320),
				new Vsop87.LnVsop(0.00000000260, 4.32490177755,
						4017.11507831800),
				new Vsop87.LnVsop(0.00000000247, 3.83116540525, 327.43756992050),
				new Vsop87.LnVsop(0.00000000264, 1.13298595860,
						1969.20066324380),
				new Vsop87.LnVsop(0.00000000291, 2.99706400538,
						4694.00295470760),
				new Vsop87.LnVsop(0.00000000223, 5.86659978015,
						3914.02230409940),
				new Vsop87.LnVsop(0.00000000241, 3.94118046972,
						3171.03224356680),
				new Vsop87.LnVsop(0.00000000228, 5.97829032334, 224.34479570190),
				new Vsop87.LnVsop(0.00000000223, 6.19814052214,
						3281.23856478620),
				new Vsop87.LnVsop(0.00000000246, 2.91332083588,
						1514.29129671650),
				new Vsop87.LnVsop(0.00000000230, 2.20701513150, 850.01498801430),
				new Vsop87.LnVsop(0.00000000270, 0.58233992630,
						1592.25428902150),
				new Vsop87.LnVsop(0.00000000236, 4.85450939183,
						3583.40334044120),
				new Vsop87.LnVsop(0.00000000237, 2.74342922621,
						1912.57831194120),
				new Vsop87.LnVsop(0.00000000276, 6.04560989855,
						1069.67687092770),
				new Vsop87.LnVsop(0.00000000254, 1.83831918853,
						1593.00504854690),
				new Vsop87.LnVsop(0.00000000214, 3.63754231115,
						3803.81598288000),
				new Vsop87.LnVsop(0.00000000210, 3.08485590783,
						3590.51688744200),
				new Vsop87.LnVsop(0.00000000260, 5.06089460492,
						1059.43011429900),
				new Vsop87.LnVsop(0.00000000227, 0.23394232373,
						1670.82502850000),
				new Vsop87.LnVsop(0.00000000246, 5.53873348349,
						2840.41327990860),
				new Vsop87.LnVsop(0.00000000206, 4.55330855600, 554.06998748280),
				new Vsop87.LnVsop(0.00000000202, 1.32439444045,
						4326.39340097380),
				new Vsop87.LnVsop(0.00000000227, 0.78540105705, 59.80374504030),
				new Vsop87.LnVsop(0.00000000258, 1.30854335630,
						1493.09366806600),
				new Vsop87.LnVsop(0.00000000199, 0.45118573624, 529.53090640020),
				new Vsop87.LnVsop(0.00000000203, 4.16872110150,
						4333.50694797460),
				new Vsop87.LnVsop(0.00000000207, 0.07882551152,
						5223.69391980220),
				new Vsop87.LnVsop(0.00000000203, 2.87164861799, 505.31194270640),
				new Vsop87.LnVsop(0.00000000197, 4.05755296915,
						1064.04779663520),
				new Vsop87.LnVsop(0.00000000196, 5.99844851675,
						3597.63043444280),
				new Vsop87.LnVsop(0.00000000199, 3.30501818656,
						4120.20785253660),
				new Vsop87.LnVsop(0.00000000194, 5.95526916809, 84.93352695390),
				new Vsop87.LnVsop(0.00000000195, 4.77984803416,
						1098.73880610440),
				new Vsop87.LnVsop(0.00000000245, 0.01831767727,
						1567.73225428140),
				new Vsop87.LnVsop(0.00000000204, 3.81252652390, 530.44172462000),
				new Vsop87.LnVsop(0.00000000210, 1.56035035567, 512.28247735530),
				new Vsop87.LnVsop(0.00000000198, 3.54440293022, 529.85102378900),
				new Vsop87.LnVsop(0.00000000266, 1.58071929624, 983.11585891360),
				new Vsop87.LnVsop(0.00000000198, 0.30047978925,
						1166.40685767090),
				new Vsop87.LnVsop(0.00000000188, 0.90738705875, 135.33610313300),
				new Vsop87.LnVsop(0.00000000256, 1.87162378257,
						1289.94650101460),
				new Vsop87.LnVsop(0.00000000190, 1.05137411074,
						1884.12412393800),
				new Vsop87.LnVsop(0.00000000178, 1.01108545550,
						10206.17199921020),
				new Vsop87.LnVsop(0.00000000189, 0.35186987278,
						1372.59240610810),
				new Vsop87.LnVsop(0.00000000218, 5.40858666125, 679.25416222920),
				new Vsop87.LnVsop(0.00000000172, 4.35360474429,
						1578.02719501990),
				new Vsop87.LnVsop(0.00000000172, 0.28434115891, 494.26624244250),
				new Vsop87.LnVsop(0.00000000206, 0.01485146863,
						2730.20695868920),
				new Vsop87.LnVsop(0.00000000176, 5.20619161648,
						3686.49611465980),
				new Vsop87.LnVsop(0.00000000173, 1.83493659695, 746.92221379570),
				new Vsop87.LnVsop(0.00000000177, 0.49024580662,
						1585.89150154610),
				new Vsop87.LnVsop(0.00000000206, 5.22730929781,
						3995.77443731560),
				new Vsop87.LnVsop(0.00000000190, 4.99077882242,
						3067.93946934820),
				new Vsop87.LnVsop(0.00000000169, 2.57956666704,
						9161.01716302260),
				new Vsop87.LnVsop(0.00000000168, 6.15800395467, 970.51624997220),
				new Vsop87.LnVsop(0.00000000165, 1.51795928301,
						4010.00153131720),
				new Vsop87.LnVsop(0.00000000189, 0.74735111652,
						2545.36205125440),
				new Vsop87.LnVsop(0.00000000173, 3.38232793511, 885.43971066640),
				new Vsop87.LnVsop(0.00000000166, 1.54981367866,
						1070.42763045310),
				new Vsop87.LnVsop(0.00000000163, 2.27700702598,
						1060.34513803570),
				new Vsop87.LnVsop(0.00000000157, 1.23713010823,
						5216.58037280140),
				new Vsop87.LnVsop(0.00000000178, 5.39417024046,
						3163.91869656600),
				new Vsop87.LnVsop(0.00000000158, 3.90063523153,
						3487.42411322340),
				new Vsop87.LnVsop(0.00000000169, 5.91153502769,
						1578.77795454530),
				new Vsop87.LnVsop(0.00000000178, 5.51894552093,
						2943.50605412720),
				new Vsop87.LnVsop(0.00000000154, 4.52070366231,
						1058.41872234270),
				new Vsop87.LnVsop(0.00000000163, 0.80456433006,
						1585.14074202070),
				new Vsop87.LnVsop(0.00000000151, 4.87442909516, 81.89514556810),
				new Vsop87.LnVsop(0.00000000180, 1.88055488803, 685.47393735270),
				new Vsop87.LnVsop(0.00000000154, 3.65536637158,
						77734.01845962799),
				new Vsop87.LnVsop(0.00000000163, 5.06311074065, 498.67147645760),
				new Vsop87.LnVsop(0.00000000162, 0.84216605238,
						2200.51599359460),
				new Vsop87.LnVsop(0.00000000189, 0.56636371283, 842.15068148810),
				new Vsop87.LnVsop(0.00000000151, 4.66530832982, 977.48678462110),
				new Vsop87.LnVsop(0.00000000187, 3.11784576157, 630.33605875840),
				new Vsop87.LnVsop(0.00000000144, 0.70005415255, 92.79783348010),
				new Vsop87.LnVsop(0.00000000138, 2.92367081829, 927.83496796740),
				new Vsop87.LnVsop(0.00000000164, 3.73913227289,
						1134.16352875650),
				new Vsop87.LnVsop(0.00000000182, 5.86715864086,
						5753.38488489680),
				new Vsop87.LnVsop(0.00000000144, 4.89589455408, 991.71387862270),
				new Vsop87.LnVsop(0.00000000137, 2.07768743239, 842.90144101350),
				new Vsop87.LnVsop(0.00000000151, 2.10726170967, 860.30992875280),
				new Vsop87.LnVsop(0.00000000140, 0.77231183403,
						9683.59458111640),
				new Vsop87.LnVsop(0.00000000131, 2.96777933087, 497.44763618020),
				new Vsop87.LnVsop(0.00000000119, 1.26007410940,
						2005.37614542130),
				new Vsop87.LnVsop(0.00000000120, 6.13286906499,
						1987.21689815660),
				new Vsop87.LnVsop(0.00000000143, 2.40231943231, 529.16970023280),
				new Vsop87.LnVsop(0.00000000113, 4.73094855840,
						4863.19791306920),
				new Vsop87.LnVsop(0.00000000122, 4.54364035076,
						1371.84164658270),
				new Vsop87.LnVsop(0.00000000135, 3.56089271537,
						1054.71606374320),
				new Vsop87.LnVsop(0.00000000115, 1.55810156690,
						9153.90361602180),
				new Vsop87.LnVsop(0.00000000150, 4.28443290371, 429.04587143080),
				new Vsop87.LnVsop(0.00000000132, 5.07409771627,
						1056.93424963440),
				new Vsop87.LnVsop(0.00000000112, 4.59192248879,
						3700.72320866140),
				new Vsop87.LnVsop(0.00000000103, 2.60811213731,
						1894.41906467650),
				new Vsop87.LnVsop(0.00000000105, 5.94340093827,
						1057.89745748090),
				new Vsop87.LnVsop(0.00000000101, 1.58846813422,
						3693.60966166060),
				new Vsop87.LnVsop(0.00000000118, 4.88733637311, 600.54041039880),
				new Vsop87.LnVsop(0.00000000098, 1.38793271630,
						1059.33374607940),
				new Vsop87.LnVsop(0.00000000100, 5.74975444020, 501.23677709140),
				new Vsop87.LnVsop(0.00000000101, 0.02209271767,
						2964.84669512960),
				new Vsop87.LnVsop(0.00000000095, 0.49108484683, 560.71045373160),
				new Vsop87.LnVsop(0.00000000094, 5.18380306247,
						4546.80604341260),
				new Vsop87.LnVsop(0.00000000104, 3.47229999154,
						4223.30062675520),
				new Vsop87.LnVsop(0.00000000099, 5.46359299375,
						3156.80514956520),
				new Vsop87.LnVsop(0.00000000099, 5.95584423449, 547.09945283390),
				new Vsop87.LnVsop(0.00000000091, 1.87848199981, 528.94020556920),
				new Vsop87.LnVsop(0.00000000108, 5.98018728055,
						1364.72809958190),
				new Vsop87.LnVsop(0.00000000116, 3.44357640421,
						1432.39615114840),
				new Vsop87.LnVsop(0.00000000088, 4.22154936325,
						4649.89881763120),
				new Vsop87.LnVsop(0.00000000109, 3.83768244476, 525.49817940060),
				new Vsop87.LnVsop(0.00000000087, 0.58669584397,
						1173.52040467170),
				new Vsop87.LnVsop(0.00000000091, 5.33968822169, 216.48048917570),
				new Vsop87.LnVsop(0.00000000102, 1.41480903153,
						3075.05301634900),
				new Vsop87.LnVsop(0.00000000102, 1.74475388738,
						2758.66114669240),
				new Vsop87.LnVsop(0.00000000089, 5.89316363283, 757.21715453420),
				new Vsop87.LnVsop(0.00000000086, 6.04340651740,
						6275.96230299060),
				new Vsop87.LnVsop(0.00000000101, 4.70225529886,
						3473.19701922180),
				new Vsop87.LnVsop(0.00000000079, 5.72096488951,
						5385.77533116300),
				new Vsop87.LnVsop(0.00000000078, 1.11944499728, 429.77958461370),
				new Vsop87.LnVsop(0.00000000078, 5.12580794008,
						1475.68518032670),
				new Vsop87.LnVsop(0.00000000078, 3.87444671518,
						2321.76801507790),
				new Vsop87.LnVsop(0.00000000086, 2.89392726975,
						10213.28554621100),
				new Vsop87.LnVsop(0.00000000077, 1.40171543677,
						5179.58978272580),
				new Vsop87.LnVsop(0.00000000076, 0.09895432561,
						3707.83675566220),
				new Vsop87.LnVsop(0.00000000073, 5.65154413109,
						1151.42900414390),
				new Vsop87.LnVsop(0.00000000084, 5.15227885953,
						1091.62525910360),
				new Vsop87.LnVsop(0.00000000079, 4.81154341200,
						3384.33133900480),
				new Vsop87.LnVsop(0.00000000080, 0.05190580386,
						1080.72257119160),
				new Vsop87.LnVsop(0.00000000080, 5.35119272632, 2.44768055480),
				new Vsop87.LnVsop(0.00000000085, 5.88100684593, 234.63973644040), };

		private static final Vsop87.LnVsop[] jupiter_longitude_l2 = {
				new Vsop87.LnVsop(0.00047233601, 4.32148536482, 7.11354700080),
				new Vsop87.LnVsop(0.00030649436, 2.92977788700, 529.69096509460),
				new Vsop87.LnVsop(0.00014837605, 3.14159265359, 0.00000000000),
				new Vsop87.LnVsop(0.00003189359, 1.05515491122, 522.57741809380),
				new Vsop87.LnVsop(0.00002728901, 4.84555421873, 536.80451209540),
				new Vsop87.LnVsop(0.00002547440, 3.42720888976,
						1059.38193018920),
				new Vsop87.LnVsop(0.00001721046, 4.18734600902, 14.22709400160),
				new Vsop87.LnVsop(0.00000383277, 5.76794364868, 419.48464387520),
				new Vsop87.LnVsop(0.00000367514, 6.05520169517, 103.09277421860),
				new Vsop87.LnVsop(0.00000377503, 0.76050839060, 515.46387109300),
				new Vsop87.LnVsop(0.00000337386, 3.78644856157, 3.18139373770),
				new Vsop87.LnVsop(0.00000308194, 0.69368283790, 206.18554843720),
				new Vsop87.LnVsop(0.00000214121, 3.82958181430,
						1589.07289528380),
				new Vsop87.LnVsop(0.00000203945, 5.34259263233,
						1066.49547719000),
				new Vsop87.LnVsop(0.00000197456, 2.48351071790, 3.93215326310),
				new Vsop87.LnVsop(0.00000146156, 3.81335105293, 639.89728631400),
				new Vsop87.LnVsop(0.00000156209, 1.36162315686,
						1052.26838318840),
				new Vsop87.LnVsop(0.00000129577, 5.83745710707, 412.37109687440),
				new Vsop87.LnVsop(0.00000141825, 1.63491733107, 426.59819087600),
				new Vsop87.LnVsop(0.00000117324, 1.41441723025, 625.67019231240),
				new Vsop87.LnVsop(0.00000096673, 4.03472268105, 110.20632121940),
				new Vsop87.LnVsop(0.00000090824, 1.10616181082, 95.97922721780),
				new Vsop87.LnVsop(0.00000078757, 4.63773672633, 543.91805909620),
				new Vsop87.LnVsop(0.00000072393, 2.21660922294, 735.87651353180),
				new Vsop87.LnVsop(0.00000087320, 2.52152838765, 632.78373931320),
				new Vsop87.LnVsop(0.00000056885, 3.12193937495, 213.29909543800),
				new Vsop87.LnVsop(0.00000048615, 1.67250930065, 309.27832265580),
				new Vsop87.LnVsop(0.00000058472, 0.83261136328, 199.07200143640),
				new Vsop87.LnVsop(0.00000040161, 4.02477739294, 21.34064100240),
				new Vsop87.LnVsop(0.00000039773, 0.62346681537, 323.50541665740),
				new Vsop87.LnVsop(0.00000035738, 2.32587552001, 728.76296653100),
				new Vsop87.LnVsop(0.00000025610, 2.52090555309,
						1162.47470440780),
				new Vsop87.LnVsop(0.00000029257, 3.60827234952, 10.29494073850),
				new Vsop87.LnVsop(0.00000023621, 3.00418693282, 956.28915597060),
				new Vsop87.LnVsop(0.00000027790, 3.24029772587, 838.96928775040),
				new Vsop87.LnVsop(0.00000025988, 4.50541789846, 742.99006053260),
				new Vsop87.LnVsop(0.00000025259, 1.21368179972,
						1045.15483618760),
				new Vsop87.LnVsop(0.00000019456, 4.29184444888, 532.87235883230),
				new Vsop87.LnVsop(0.00000016160, 5.81618778562,
						1596.18644228460),
				new Vsop87.LnVsop(0.00000017655, 0.80915458780, 508.35032409220),
				new Vsop87.LnVsop(0.00000017714, 4.21087482222,
						2118.76386037840),
				new Vsop87.LnVsop(0.00000016950, 1.83162996779, 526.50957135690),
				new Vsop87.LnVsop(0.00000014656, 3.99869563261, 117.31986822020),
				new Vsop87.LnVsop(0.00000013717, 1.80293013315, 302.16477565500),
				new Vsop87.LnVsop(0.00000013232, 2.51839383442, 88.86568021700),
				new Vsop87.LnVsop(0.00000012771, 4.36965277120,
						1169.58825140860),
				new Vsop87.LnVsop(0.00000015311, 0.68283508612, 942.06206196900),
				new Vsop87.LnVsop(0.00000010924, 4.44465911708, 525.75881183150),
				new Vsop87.LnVsop(0.00000013902, 5.95861098210, 316.39186965660),
				new Vsop87.LnVsop(0.00000009462, 2.17903550202,
						1155.36115740700),
				new Vsop87.LnVsop(0.00000008792, 3.29010679292, 220.41264243880),
				new Vsop87.LnVsop(0.00000007851, 5.76115179798, 846.08283475120),
				new Vsop87.LnVsop(0.00000007640, 2.72045021550, 533.62311835770),
				new Vsop87.LnVsop(0.00000009055, 1.63552089571,
						1581.95934828300),
				new Vsop87.LnVsop(0.00000008687, 3.31770180816, 831.85574074960),
				new Vsop87.LnVsop(0.00000006355, 0.49733352086, 949.17560896980),
				new Vsop87.LnVsop(0.00000006615, 2.18391508427,
						1265.56747862640),
				new Vsop87.LnVsop(0.00000005380, 6.00496610446, 405.25754987360),
				new Vsop87.LnVsop(0.00000004562, 1.38462817429,
						1258.45393162560),
				new Vsop87.LnVsop(0.00000004367, 5.07489817646,
						1073.60902419080),
				new Vsop87.LnVsop(0.00000004280, 3.04118697325,
						1692.16566950240),
				new Vsop87.LnVsop(0.00000004371, 5.47491964600, 433.71173787680),
				new Vsop87.LnVsop(0.00000004201, 5.28578420235, 18.15924726470),
				new Vsop87.LnVsop(0.00000003950, 1.25151054185, 853.19638175200),
				new Vsop87.LnVsop(0.00000005302, 3.65714557917,
						1272.68102562720),
				new Vsop87.LnVsop(0.00000004368, 2.27494144993,
						1368.66025284500),
				new Vsop87.LnVsop(0.00000003462, 1.50340907962, 519.39602435610),
				new Vsop87.LnVsop(0.00000002757, 2.16577371531,
						1478.86657406440),
				new Vsop87.LnVsop(0.00000002704, 1.04777971186,
						1574.84580128220),
				new Vsop87.LnVsop(0.00000002891, 2.04866759038,
						1361.54670584420),
				new Vsop87.LnVsop(0.00000003075, 0.99105386830, 191.95845443560),
				new Vsop87.LnVsop(0.00000002437, 2.36815291342,
						1471.75302706360),
				new Vsop87.LnVsop(0.00000002201, 2.47797001828, 721.64941953020),
				new Vsop87.LnVsop(0.00000002093, 3.72335003599,
						1485.98012106520),
				new Vsop87.LnVsop(0.00000002273, 3.03212449012,
						1148.24761040620),
				new Vsop87.LnVsop(0.00000001947, 1.88764180020,
						1685.05212250160),
				new Vsop87.LnVsop(0.00000002057, 6.18001258073, 330.61896365820),
				new Vsop87.LnVsop(0.00000001451, 4.72055072637, 32.24332891440),
				new Vsop87.LnVsop(0.00000001449, 3.18799149050, 635.96513305090),
				new Vsop87.LnVsop(0.00000001377, 5.12507193192,
						1375.77379984580),
				new Vsop87.LnVsop(0.00000001421, 1.99249188460, 629.60234557550),
				new Vsop87.LnVsop(0.00000001401, 4.26834108454, 551.03160609700),
				new Vsop87.LnVsop(0.00000001265, 0.00691519565,
						2125.87740737920),
				new Vsop87.LnVsop(0.00000001272, 2.25106018556,
						1788.14489672020),
				new Vsop87.LnVsop(0.00000001238, 1.75660677516,
						1677.93857550080),
				new Vsop87.LnVsop(0.00000001206, 2.18559244687,
						1795.25844372100),
				new Vsop87.LnVsop(0.00000001493, 4.02813570061, 539.98590583310),
				new Vsop87.LnVsop(0.00000001314, 4.76481710487,
						1062.56332392690),
				new Vsop87.LnVsop(0.00000001110, 2.97713206981, 81.75213321620),
				new Vsop87.LnVsop(0.00000001027, 1.99159218429, 295.05122865420),
				new Vsop87.LnVsop(0.00000001368, 4.63088532557,
						2648.45482547300),
				new Vsop87.LnVsop(0.00000001025, 3.75336759986, 28.45418800320),
				new Vsop87.LnVsop(0.00000000978, 3.01394148632, 124.43341522100),
				new Vsop87.LnVsop(0.00000001227, 1.22879053363,
						1038.04128918680),
				new Vsop87.LnVsop(0.00000000965, 1.17674106025, 99.91138048090),
				new Vsop87.LnVsop(0.00000001015, 1.85922216390, 750.10360753340),
				new Vsop87.LnVsop(0.00000000924, 3.53294521831, 227.52618943960),
				new Vsop87.LnVsop(0.00000000988, 5.05622576252,
						1699.27921650320),
				new Vsop87.LnVsop(0.00000001059, 0.13477400877, 416.30325013750),
				new Vsop87.LnVsop(0.00000000819, 2.01948161630,
						1056.20053645150),
				new Vsop87.LnVsop(0.00000000888, 1.75920995401,
						1898.35121793960),
				new Vsop87.LnVsop(0.00000001013, 2.80784883642,
						1464.63948006280),
				new Vsop87.LnVsop(0.00000000791, 4.92419444433,
						1055.44977692610),
				new Vsop87.LnVsop(0.00000000774, 1.91132974373,
						2111.65031337760),
				new Vsop87.LnVsop(0.00000000729, 3.29016656970, 628.85158605010),
				new Vsop87.LnVsop(0.00000000743, 2.65216075794, 106.27416795630),
				new Vsop87.LnVsop(0.00000000719, 2.95858266157,
						2008.55753915900),
				new Vsop87.LnVsop(0.00000000693, 0.10835603179, 963.40270297140),
				new Vsop87.LnVsop(0.00000000828, 2.72900314719, 618.55664531160),
				new Vsop87.LnVsop(0.00000000777, 1.63387777696,
						2001.44399215820),
				new Vsop87.LnVsop(0.00000000651, 1.19267978130, 422.66603761290),
				new Vsop87.LnVsop(0.00000000681, 5.47481858348,
						5760.49843189760),
				new Vsop87.LnVsop(0.00000000681, 3.11621018972,
						5746.27133789600),
				new Vsop87.LnVsop(0.00000000644, 4.68534695662, 611.44309831080),
				new Vsop87.LnVsop(0.00000000665, 1.86713865983,
						2104.53676637680),
				new Vsop87.LnVsop(0.00000000629, 3.05748834184, 380.12776796000),
				new Vsop87.LnVsop(0.00000000637, 1.85731506560, 636.71589257630),
				new Vsop87.LnVsop(0.00000000715, 3.04974505007,
						2221.85663459700),
				new Vsop87.LnVsop(0.00000000635, 4.53916560604,
						9676.48103411560),
				new Vsop87.LnVsop(0.00000000635, 0.61458920732,
						9690.70812811720),
				new Vsop87.LnVsop(0.00000000821, 6.24663887828, 423.41679713830),
				new Vsop87.LnVsop(0.00000000764, 4.32616763486,
						1802.37199072180),
				new Vsop87.LnVsop(0.00000000581, 0.83633087877,
						1891.23767093880),
				new Vsop87.LnVsop(0.00000000638, 2.83653046158,
						1905.46476494040),
				new Vsop87.LnVsop(0.00000000558, 3.96114629751, 440.82528487760),
				new Vsop87.LnVsop(0.00000000623, 1.22711488010,
						1382.88734684660),
				new Vsop87.LnVsop(0.00000000711, 3.43507379865, 824.74219374880),
				new Vsop87.LnVsop(0.00000000516, 1.10671630111, 107.02492748170),
				new Vsop87.LnVsop(0.00000000535, 1.55914282530,
						1994.33044515740),
				new Vsop87.LnVsop(0.00000000548, 4.39997113815, 647.01083331480),
				new Vsop87.LnVsop(0.00000000412, 1.25354625957, 203.00415469950),
				new Vsop87.LnVsop(0.00000000414, 2.66777275564,
						2324.94940881560),
				new Vsop87.LnVsop(0.00000000533, 2.55533346856,
						1781.03134971940),
				new Vsop87.LnVsop(0.00000000393, 1.26401319046, 210.11770170030),
				new Vsop87.LnVsop(0.00000000428, 1.47563898333,
						2214.74308759620),
				new Vsop87.LnVsop(0.00000000417, 2.88282194210,
						1063.31408345230),
				new Vsop87.LnVsop(0.00000000431, 5.00337132770,
						3178.14579056760),
				new Vsop87.LnVsop(0.00000000404, 3.51234818882,
						2751.54759969160),
				new Vsop87.LnVsop(0.00000000433, 4.29604508638,
						5753.38488489680),
				new Vsop87.LnVsop(0.00000000311, 0.32531359824,
						2655.56837247380),
				new Vsop87.LnVsop(0.00000000315, 0.16909542121,
						1279.79457262800),
				new Vsop87.LnVsop(0.00000000327, 3.36314839669,
						1141.13406340540),
				new Vsop87.LnVsop(0.00000000340, 1.47994765617,
						2317.83586181480),
				new Vsop87.LnVsop(0.00000000280, 5.45018668393,
						2228.97018159780),
				new Vsop87.LnVsop(0.00000000286, 1.69087245649,
						2420.92863603340),
				new Vsop87.LnVsop(0.00000000272, 0.27466300281, 319.57326339430),
				new Vsop87.LnVsop(0.00000000285, 2.92648819935,
						2957.73314812880),
				new Vsop87.LnVsop(0.00000000242, 6.23321763999, 934.94851496820),
				new Vsop87.LnVsop(0.00000000265, 0.35799742793,
						2840.41327990860),
				new Vsop87.LnVsop(0.00000000247, 2.41874119352,
						1251.34038462480),
				new Vsop87.LnVsop(0.00000000303, 2.43034117616, 70.84944530420),
				new Vsop87.LnVsop(0.00000000251, 0.43544711316,
						3259.89792378380),
				new Vsop87.LnVsop(0.00000000226, 4.49396746521,
						5223.69391980220),
				new Vsop87.LnVsop(0.00000000233, 5.48382095726,
						1603.29998928540),
				new Vsop87.LnVsop(0.00000000272, 2.98590404673,
						1457.52593306200),
				new Vsop87.LnVsop(0.00000000285, 2.60754102796,
						2538.24850425360),
				new Vsop87.LnVsop(0.00000000207, 5.94297320087,
						9153.90361602180),
				new Vsop87.LnVsop(0.00000000283, 2.02857986620,
						3171.03224356680),
				new Vsop87.LnVsop(0.00000000291, 5.14022289511,
						1592.25428902150),
				new Vsop87.LnVsop(0.00000000233, 2.70967928648,
						1354.43315884340),
				new Vsop87.LnVsop(0.00000000268, 5.02822905034,
						2015.67108615980),
				new Vsop87.LnVsop(0.00000000239, 1.57690386034,
						2744.43405269080),
				new Vsop87.LnVsop(0.00000000284, 2.27103340038,
						2854.64037391020),
				new Vsop87.LnVsop(0.00000000254, 1.36546010277,
						3370.10424500320),
				new Vsop87.LnVsop(0.00000000221, 1.17223735868,
						3053.71237534660),
				new Vsop87.LnVsop(0.00000000224, 1.28623905132,
						3060.82592234740),
				new Vsop87.LnVsop(0.00000000205, 3.30510713580,
						3384.33133900480),
				new Vsop87.LnVsop(0.00000000222, 0.63302066932,
						3163.91869656600),
				new Vsop87.LnVsop(0.00000000188, 6.00513627145, 92.04707395470),
				new Vsop87.LnVsop(0.00000000193, 1.57356589213,
						2428.04218303420),
				new Vsop87.LnVsop(0.00000000247, 2.25464204265,
						2097.42321937600),
				new Vsop87.LnVsop(0.00000000198, 2.56172919362,
						2641.34127847220),
				new Vsop87.LnVsop(0.00000000203, 3.40598495601, 99.16062095550),
				new Vsop87.LnVsop(0.00000000179, 0.54218881357,
						2207.62954059540),
				new Vsop87.LnVsop(0.00000000178, 5.56443381281,
						2332.06295581640),
				new Vsop87.LnVsop(0.00000000176, 1.43070640110, 945.99421523210),
				new Vsop87.LnVsop(0.00000000222, 3.66783138440, 113.38771495710),
				new Vsop87.LnVsop(0.00000000178, 0.64947535071,
						1176.70179840940),
				new Vsop87.LnVsop(0.00000000199, 1.14834144531,
						2531.13495725280),
				new Vsop87.LnVsop(0.00000000166, 4.09266431951,
						6283.07584999140),
				new Vsop87.LnVsop(0.00000000183, 1.27422647789,
						2310.72231481400),
				new Vsop87.LnVsop(0.00000000227, 1.68715930646,
						1567.73225428140),
				new Vsop87.LnVsop(0.00000000188, 4.32227206118,
						1069.67687092770),
				new Vsop87.LnVsop(0.00000000225, 3.69300117786,
						2435.15573003500),
				new Vsop87.LnVsop(0.00000000162, 3.60183151152,
						3067.93946934820),
				new Vsop87.LnVsop(0.00000000203, 2.24205059922, 67.66805156650),
				new Vsop87.LnVsop(0.00000000152, 5.48122906518,
						10213.28554621100),
				new Vsop87.LnVsop(0.00000000191, 2.68685722531,
						1773.91780271860),
				new Vsop87.LnVsop(0.00000000189, 2.95184731936, 732.69511979410),
				new Vsop87.LnVsop(0.00000000178, 2.63197229299,
						3274.12501778540),
				new Vsop87.LnVsop(0.00000000168, 5.38131391591,
						1585.14074202070),
				new Vsop87.LnVsop(0.00000000152, 1.52826598178,
						2950.61960112800),
				new Vsop87.LnVsop(0.00000000172, 1.85377970325,
						2413.81508903260),
				new Vsop87.LnVsop(0.00000000165, 2.69610230323, 952.35700270750),
				new Vsop87.LnVsop(0.00000000161, 4.77428302161,
						1262.38608488870),
				new Vsop87.LnVsop(0.00000000143, 6.22998196624, 860.30992875280),
				new Vsop87.LnVsop(0.00000000187, 1.19805936589,
						3362.99069800240),
				new Vsop87.LnVsop(0.00000000134, 2.74105572000,
						1670.82502850000),
				new Vsop87.LnVsop(0.00000000122, 5.52449599842, 337.73251065900),
				new Vsop87.LnVsop(0.00000000143, 1.20984019641,
						2634.22773147140),
				new Vsop87.LnVsop(0.00000000114, 2.52833228247,
						1585.89150154610),
				new Vsop87.LnVsop(0.00000000136, 2.69423835500, 739.80866679490),
				new Vsop87.LnVsop(0.00000000112, 5.77394476974, 547.85021235930),
				new Vsop87.LnVsop(0.00000000150, 4.91666030632,
						3494.53766022420),
				new Vsop87.LnVsop(0.00000000119, 5.50342415511,
						4113.09430553580),
				new Vsop87.LnVsop(0.00000000149, 0.81247034524,
						3267.01147078460),
				new Vsop87.LnVsop(0.00000000103, 0.80198707373,
						2737.32050569000),
				new Vsop87.LnVsop(0.00000000120, 2.81532905166,
						3803.81598288000),
				new Vsop87.LnVsop(0.00000000111, 2.44973721150,
						3590.51688744200),
				new Vsop87.LnVsop(0.00000000108, 1.33301085820,
						1049.08698945070),
				new Vsop87.LnVsop(0.00000000133, 0.33542188145,
						3156.80514956520),
				new Vsop87.LnVsop(0.00000000108, 2.55716124258,
						4010.00153131720),
				new Vsop87.LnVsop(0.00000000119, 1.02217622746,
						2524.02141025200),
				new Vsop87.LnVsop(0.00000000105, 5.89338290292,
						3789.58888887840),
				new Vsop87.LnVsop(0.00000000094, 0.88652607343,
						3377.21779200400),
				new Vsop87.LnVsop(0.00000000086, 1.26934319585, 511.53171782990),
				new Vsop87.LnVsop(0.00000000082, 4.65514231193,
						3281.23856478620),
				new Vsop87.LnVsop(0.00000000081, 4.55655881694,
						4319.27985397300),
				new Vsop87.LnVsop(0.00000000084, 5.52322777064,
						4120.20785253660),
				new Vsop87.LnVsop(0.00000000075, 0.40562636382,
						2627.11418447060),
				new Vsop87.LnVsop(0.00000000099, 3.94867595848,
						4017.11507831800),
				new Vsop87.LnVsop(0.00000000080, 0.28157522970,
						2847.52682690940),
				new Vsop87.LnVsop(0.00000000073, 3.52191166845,
						2964.84669512960),
				new Vsop87.LnVsop(0.00000000092, 0.43014320279,
						3914.02230409940),
				new Vsop87.LnVsop(0.00000000083, 0.25202430423,
						2644.52267220990), };

		private static final Vsop87.LnVsop[] jupiter_longitude_l3 = {
				new Vsop87.LnVsop(0.00006501673, 2.59862923650, 7.11354700080),
				new Vsop87.LnVsop(0.00001355012, 1.34692775915, 529.69096509460),
				new Vsop87.LnVsop(0.00000470691, 2.47502798748, 14.22709400160),
				new Vsop87.LnVsop(0.00000416933, 3.24456258569, 536.80451209540),
				new Vsop87.LnVsop(0.00000352870, 2.97380410245, 522.57741809380),
				new Vsop87.LnVsop(0.00000165699, 2.09182221854,
						1059.38193018920),
				new Vsop87.LnVsop(0.00000086769, 2.51454300081, 515.46387109300),
				new Vsop87.LnVsop(0.00000034458, 3.82181443085,
						1066.49547719000),
				new Vsop87.LnVsop(0.00000022671, 2.98178645046, 543.91805909620),
				new Vsop87.LnVsop(0.00000023760, 1.27416115958, 412.37109687440),
				new Vsop87.LnVsop(0.00000028501, 2.44538595164, 206.18554843720),
				new Vsop87.LnVsop(0.00000019722, 2.10936654685, 639.89728631400),
				new Vsop87.LnVsop(0.00000017778, 2.59019838502,
						1589.07289528380),
				new Vsop87.LnVsop(0.00000019709, 1.40149363982, 419.48464387520),
				new Vsop87.LnVsop(0.00000018767, 1.58683219668, 103.09277421860),
				new Vsop87.LnVsop(0.00000017015, 2.29975384867, 21.34064100240),
				new Vsop87.LnVsop(0.00000016179, 3.15438287420, 625.67019231240),
				new Vsop87.LnVsop(0.00000015902, 3.25713655347,
						1052.26838318840),
				new Vsop87.LnVsop(0.00000013421, 2.76078519881, 95.97922721780),
				new Vsop87.LnVsop(0.00000013233, 2.53761666317, 199.07200143640),
				new Vsop87.LnVsop(0.00000012676, 6.26512955217, 426.59819087600),
				new Vsop87.LnVsop(0.00000008633, 2.26532712763, 110.20632121940),
				new Vsop87.LnVsop(0.00000006718, 3.42006598208, 309.27832265580),
				new Vsop87.LnVsop(0.00000008703, 1.76298942412, 10.29494073850),
				new Vsop87.LnVsop(0.00000006529, 4.03744539112, 728.76296653100),
				new Vsop87.LnVsop(0.00000005397, 5.26432570770, 323.50541665740),
				new Vsop87.LnVsop(0.00000005685, 2.51772778746, 508.35032409220),
				new Vsop87.LnVsop(0.00000007504, 0.00000000000, 0.00000000000),
				new Vsop87.LnVsop(0.00000005431, 2.90223114269,
						1045.15483618760),
				new Vsop87.LnVsop(0.00000003997, 4.30231913648, 88.86568021700),
				new Vsop87.LnVsop(0.00000003855, 3.52241347275, 302.16477565500),
				new Vsop87.LnVsop(0.00000003811, 4.08897954122, 735.87651353180),
				new Vsop87.LnVsop(0.00000003232, 1.47972151050, 956.28915597060),
				new Vsop87.LnVsop(0.00000002931, 4.35694383564,
						1596.18644228460),
				new Vsop87.LnVsop(0.00000002657, 1.27257961451, 213.29909543800),
				new Vsop87.LnVsop(0.00000002556, 2.23303484585, 117.31986822020),
				new Vsop87.LnVsop(0.00000002414, 2.91828676420, 742.99006053260),
				new Vsop87.LnVsop(0.00000002657, 5.01551013390, 838.96928775040),
				new Vsop87.LnVsop(0.00000001935, 2.79590256973,
						1169.58825140860),
				new Vsop87.LnVsop(0.00000002222, 2.39310688825, 942.06206196900),
				new Vsop87.LnVsop(0.00000001605, 3.09964511466,
						2118.76386037840),
				new Vsop87.LnVsop(0.00000001491, 1.55001725357, 220.41264243880),
				new Vsop87.LnVsop(0.00000001934, 5.00823602310, 831.85574074960),
				new Vsop87.LnVsop(0.00000001584, 1.40103448632, 405.25754987360),
				new Vsop87.LnVsop(0.00000001286, 3.46966168288,
						1073.60902419080),
				new Vsop87.LnVsop(0.00000001210, 4.05719633951,
						1155.36115740700),
				new Vsop87.LnVsop(0.00000000995, 3.40755481322, 532.87235883230),
				new Vsop87.LnVsop(0.00000000895, 1.64086921760, 632.78373931320),
				new Vsop87.LnVsop(0.00000000942, 2.70150730852, 191.95845443560),
				new Vsop87.LnVsop(0.00000000817, 3.29435640763,
						1258.45393162560),
				new Vsop87.LnVsop(0.00000000721, 1.62926029676, 949.17560896980),
				new Vsop87.LnVsop(0.00000000745, 1.14787945018,
						1162.47470440780),
				new Vsop87.LnVsop(0.00000000719, 3.73992764870, 433.71173787680),
				new Vsop87.LnVsop(0.00000000658, 2.90980216736,
						1574.84580128220),
				new Vsop87.LnVsop(0.00000000611, 5.95148659718, 853.19638175200),
				new Vsop87.LnVsop(0.00000000665, 3.54820168197, 525.75881183150),
				new Vsop87.LnVsop(0.00000000609, 4.14925115671, 721.64941953020),
				new Vsop87.LnVsop(0.00000000598, 4.69470159905, 81.75213321620),
				new Vsop87.LnVsop(0.00000000669, 1.94668551888,
						1272.68102562720),
				new Vsop87.LnVsop(0.00000000643, 2.02118053595, 526.50957135690),
				new Vsop87.LnVsop(0.00000000508, 4.35239131420,
						1368.66025284500),
				new Vsop87.LnVsop(0.00000000509, 4.95261621008,
						1148.24761040620),
				new Vsop87.LnVsop(0.00000000564, 3.41879628800,
						1581.95934828300),
				new Vsop87.LnVsop(0.00000000512, 4.39016117028, 330.61896365820),
				new Vsop87.LnVsop(0.00000000548, 2.25796919785, 551.03160609700),
				new Vsop87.LnVsop(0.00000000478, 3.86015693760,
						1361.54670584420),
				new Vsop87.LnVsop(0.00000000383, 0.24286568335, 611.44309831080),
				new Vsop87.LnVsop(0.00000000434, 2.94972316227,
						1038.04128918680),
				new Vsop87.LnVsop(0.00000000376, 1.42987791517, 124.43341522100),
				new Vsop87.LnVsop(0.00000000390, 4.06059870551,
						1471.75302706360),
				new Vsop87.LnVsop(0.00000000385, 4.70313900114, 519.39602435610),
				new Vsop87.LnVsop(0.00000000428, 2.22447290956, 539.98590583310),
				new Vsop87.LnVsop(0.00000000394, 4.52891996323,
						1464.63948006280),
				new Vsop87.LnVsop(0.00000000306, 2.02015964470,
						1485.98012106520),
				new Vsop87.LnVsop(0.00000000283, 0.96808839854,
						1905.46476494040),
				new Vsop87.LnVsop(0.00000000278, 4.35223393872, 963.40270297140),
				new Vsop87.LnVsop(0.00000000309, 3.65940227544, 846.08283475120),
				new Vsop87.LnVsop(0.00000000342, 4.17369218547,
						1788.14489672020),
				new Vsop87.LnVsop(0.00000000259, 4.00812218110,
						1265.56747862640),
				new Vsop87.LnVsop(0.00000000293, 3.91258428829,
						1685.05212250160),
				new Vsop87.LnVsop(0.00000000259, 1.01628149559,
						1478.86657406440),
				new Vsop87.LnVsop(0.00000000253, 3.12703531515,
						1994.33044515740),
				new Vsop87.LnVsop(0.00000000238, 6.13097565419,
						1382.88734684660),
				new Vsop87.LnVsop(0.00000000220, 4.81059910221,
						2125.87740737920),
				new Vsop87.LnVsop(0.00000000225, 2.51478069462,
						1891.23767093880),
				new Vsop87.LnVsop(0.00000000278, 3.63969386282,
						1677.93857550080),
				new Vsop87.LnVsop(0.00000000242, 2.90163762388,
						2310.72231481400),
				new Vsop87.LnVsop(0.00000000242, 3.56541237319,
						1699.27921650320),
				new Vsop87.LnVsop(0.00000000248, 6.02173100984, 750.10360753340),
				new Vsop87.LnVsop(0.00000000197, 5.17715231546, 618.55664531160),
				new Vsop87.LnVsop(0.00000000256, 4.19052619061,
						1781.03134971940),
				new Vsop87.LnVsop(0.00000000196, 0.77278217513,
						2221.85663459700),
				new Vsop87.LnVsop(0.00000000185, 3.87563539893, 295.05122865420),
				new Vsop87.LnVsop(0.00000000234, 2.54350140197,
						1375.77379984580),
				new Vsop87.LnVsop(0.00000000184, 3.72826587808,
						2538.24850425360),
				new Vsop87.LnVsop(0.00000000189, 5.74277274755,
						2627.11418447060),
				new Vsop87.LnVsop(0.00000000163, 1.29242716775,
						1692.16566950240),
				new Vsop87.LnVsop(0.00000000218, 3.86704847246,
						2104.53676637680),
				new Vsop87.LnVsop(0.00000000171, 5.25744961028, 824.74219374880),
				new Vsop87.LnVsop(0.00000000171, 4.17086334577,
						2097.42321937600),
				new Vsop87.LnVsop(0.00000000149, 4.30563038349,
						2001.44399215820),
				new Vsop87.LnVsop(0.00000000148, 1.85615806078,
						1056.20053645150),
				new Vsop87.LnVsop(0.00000000155, 4.31124093129,
						2317.83586181480),
				new Vsop87.LnVsop(0.00000000152, 3.97372662088,
						1055.44977692610),
				new Vsop87.LnVsop(0.00000000147, 1.55828353595, 227.52618943960),
				new Vsop87.LnVsop(0.00000000196, 2.21259819908, 934.94851496820),
				new Vsop87.LnVsop(0.00000000160, 1.77096189842,
						1141.13406340540),
				new Vsop87.LnVsop(0.00000000132, 3.78618524413,
						1062.56332392690),
				new Vsop87.LnVsop(0.00000000179, 5.57450109164,
						1354.43315884340),
				new Vsop87.LnVsop(0.00000000121, 3.84004974551,
						2634.22773147140),
				new Vsop87.LnVsop(0.00000000118, 1.43347687364,
						1279.79457262800),
				new Vsop87.LnVsop(0.00000000124, 3.41965347556,
						2648.45482547300),
				new Vsop87.LnVsop(0.00000000162, 2.01594918927, 533.62311835770),
				new Vsop87.LnVsop(0.00000000106, 3.26215180863,
						2207.62954059540),
				new Vsop87.LnVsop(0.00000000107, 0.88798638307,
						1670.82502850000),
				new Vsop87.LnVsop(0.00000000107, 0.60623932999,
						2413.81508903260),
				new Vsop87.LnVsop(0.00000000082, 0.40279200309,
						2950.61960112800),
				new Vsop87.LnVsop(0.00000000080, 2.06822079440,
						3060.82592234740),
				new Vsop87.LnVsop(0.00000000083, 2.43109843716,
						2428.04218303420),
				new Vsop87.LnVsop(0.00000000079, 3.80336766578,
						1603.29998928540), };

		private static final Vsop87.LnVsop[] jupiter_longitude_l4 = {
				new Vsop87.LnVsop(0.00000669505, 0.85280378158, 7.11354700080),
				new Vsop87.LnVsop(0.00000099965, 0.74243651986, 14.22709400160),
				new Vsop87.LnVsop(0.00000050030, 1.65383477095, 536.80451209540),
				new Vsop87.LnVsop(0.00000043690, 5.81923759985, 529.69096509460),
				new Vsop87.LnVsop(0.00000031794, 4.85865051639, 522.57741809380),
				new Vsop87.LnVsop(0.00000014735, 4.29065528652, 515.46387109300),
				new Vsop87.LnVsop(0.00000008408, 0.68386181768,
						1059.38193018920),
				new Vsop87.LnVsop(0.00000004926, 1.29899425511, 543.91805909620),
				new Vsop87.LnVsop(0.00000004563, 2.31453670801,
						1066.49547719000),
				new Vsop87.LnVsop(0.00000004254, 0.48193363691, 21.34064100240),
				new Vsop87.LnVsop(0.00000003100, 3.00251285081, 412.37109687440),
				new Vsop87.LnVsop(0.00000002053, 0.39854167561, 639.89728631400),
				new Vsop87.LnVsop(0.00000001764, 4.90551864257, 625.67019231240),
				new Vsop87.LnVsop(0.00000001901, 4.25660977930, 199.07200143640),
				new Vsop87.LnVsop(0.00000001690, 4.25228443627, 206.18554843720),
				new Vsop87.LnVsop(0.00000001345, 5.06309624095,
						1052.26838318840),
				new Vsop87.LnVsop(0.00000001211, 4.71432598740, 95.97922721780),
				new Vsop87.LnVsop(0.00000001091, 1.32037613765,
						1589.07289528380),
				new Vsop87.LnVsop(0.00000000971, 5.67505418481, 728.76296653100),
				new Vsop87.LnVsop(0.00000000935, 6.05626917469, 88.86568021700),
				new Vsop87.LnVsop(0.00000000941, 4.66216576341,
						1045.15483618760),
				new Vsop87.LnVsop(0.00000000907, 4.56755235537, 426.59819087600),
				new Vsop87.LnVsop(0.00000000783, 3.39826306476, 419.48464387520),
				new Vsop87.LnVsop(0.00000000763, 3.50908239900, 103.09277421860),
				new Vsop87.LnVsop(0.00000000737, 0.53486231851, 110.20632121940),
				new Vsop87.LnVsop(0.00000000413, 5.21759457392, 302.16477565500),
				new Vsop87.LnVsop(0.00000000397, 6.22333486636, 956.28915597060),
				new Vsop87.LnVsop(0.00000000375, 5.22028842158, 309.27832265580),
				new Vsop87.LnVsop(0.00000000357, 4.77132381360, 508.35032409220),
				new Vsop87.LnVsop(0.00000000422, 0.58114211624, 117.31986822020),
				new Vsop87.LnVsop(0.00000000318, 3.51963719294, 323.50541665740),
				new Vsop87.LnVsop(0.00000000353, 4.07385033829, 942.06206196900),
				new Vsop87.LnVsop(0.00000000318, 0.47985672138, 831.85574074960),
				new Vsop87.LnVsop(0.00000000251, 1.79670889239,
						1073.60902419080),
				new Vsop87.LnVsop(0.00000000255, 2.93957928902,
						1596.18644228460),
				new Vsop87.LnVsop(0.00000000210, 0.42245785278, 220.41264243880),
				new Vsop87.LnVsop(0.00000000188, 1.11282762167,
						1169.58825140860),
				new Vsop87.LnVsop(0.00000000187, 2.15988498485,
						1361.54670584420),
				new Vsop87.LnVsop(0.00000000180, 3.44457638757,
						1148.24761040620),
				new Vsop87.LnVsop(0.00000000157, 3.04524492827,
						1272.68102562720),
				new Vsop87.LnVsop(0.00000000173, 5.21493846901,
						1581.95934828300),
				new Vsop87.LnVsop(0.00000000160, 1.91340275752,
						2118.76386037840),
				new Vsop87.LnVsop(0.00000000194, 4.74134167991,
						1155.36115740700),
				new Vsop87.LnVsop(0.00000000119, 2.25819104081, 330.61896365820),
				new Vsop87.LnVsop(0.00000000127, 1.67407621995,
						1891.23767093880),
				new Vsop87.LnVsop(0.00000000131, 0.52395207361, 551.03160609700),
				new Vsop87.LnVsop(0.00000000099, 3.45749497992, 647.01083331480),
				new Vsop87.LnVsop(0.00000000077, 3.29690316802,
						1368.66025284500), };

		private static final Vsop87.LnVsop[] jupiter_longitude_l5 = {
				new Vsop87.LnVsop(0.00000049639, 5.25769924770, 7.11354700080),
				new Vsop87.LnVsop(0.00000015775, 5.24859620238, 14.22709400160),
				new Vsop87.LnVsop(0.00000004326, 0.02660738929, 536.80451209540),
				new Vsop87.LnVsop(0.00000001573, 1.18411087933, 522.57741809380),
				new Vsop87.LnVsop(0.00000000819, 5.86582284529, 543.91805909620),
				new Vsop87.LnVsop(0.00000000724, 0.88277941285, 515.46387109300),
				new Vsop87.LnVsop(0.00000000360, 0.78335749573,
						1066.49547719000),
				new Vsop87.LnVsop(0.00000000319, 5.73095137303,
						1059.38193018920),
				new Vsop87.LnVsop(0.00000000198, 0.04372566049,
						1589.07289528380),
				new Vsop87.LnVsop(0.00000000107, 0.09298499958,
						1073.60902419080),
				new Vsop87.LnVsop(0.00000000079, 6.16619004945, 529.69096509460), };
	}

	static class Latitude {
		private static final Vsop87.LnVsop[] jupiter_latitude_b0 = {
				new Vsop87.LnVsop(0.02268615702, 3.55852606721, 529.69096509460),
				new Vsop87.LnVsop(0.00109971634, 3.90809347197,
						1059.38193018920),
				new Vsop87.LnVsop(0.00110090358, 0.00000000000, 0.00000000000),
				new Vsop87.LnVsop(0.00008101428, 3.60509572885, 522.57741809380),
				new Vsop87.LnVsop(0.00006043996, 4.25883108339,
						1589.07289528380),
				new Vsop87.LnVsop(0.00006437782, 0.30627119215, 536.80451209540),
				new Vsop87.LnVsop(0.00001106880, 2.98534409520,
						1162.47470440780),
				new Vsop87.LnVsop(0.00000941651, 2.93619073963,
						1052.26838318840),
				new Vsop87.LnVsop(0.00000894088, 1.75447402715, 7.11354700080),
				new Vsop87.LnVsop(0.00000767280, 2.15473604461, 632.78373931320),
				new Vsop87.LnVsop(0.00000944328, 1.67522315024, 426.59819087600),
				new Vsop87.LnVsop(0.00000684219, 3.67808774854, 213.29909543800),
				new Vsop87.LnVsop(0.00000629223, 0.64343290020,
						1066.49547719000),
				new Vsop87.LnVsop(0.00000835861, 5.17881977810, 103.09277421860),
				new Vsop87.LnVsop(0.00000531671, 2.70305944444, 110.20632121940),
				new Vsop87.LnVsop(0.00000558524, 0.01354838161, 846.08283475120),
				new Vsop87.LnVsop(0.00000464449, 1.17337267936, 949.17560896980),
				new Vsop87.LnVsop(0.00000431072, 2.60825022780, 419.48464387520),
				new Vsop87.LnVsop(0.00000351433, 4.61062966359,
						2118.76386037840),
				new Vsop87.LnVsop(0.00000123148, 3.34968047337,
						1692.16566950240),
				new Vsop87.LnVsop(0.00000115038, 5.04892367391, 316.39186965660),
				new Vsop87.LnVsop(0.00000132159, 4.77816940380, 742.99006053260),
				new Vsop87.LnVsop(0.00000103402, 2.31878940535,
						1478.86657406440),
				new Vsop87.LnVsop(0.00000116379, 1.38688268881, 323.50541665740),
				new Vsop87.LnVsop(0.00000102420, 3.15294025567,
						1581.95934828300),
				new Vsop87.LnVsop(0.00000103762, 3.70104530617, 515.46387109300),
				new Vsop87.LnVsop(0.00000078650, 3.98318863271,
						1265.56747862640),
				new Vsop87.LnVsop(0.00000069935, 2.56006243114, 956.28915597060),
				new Vsop87.LnVsop(0.00000055597, 0.37501076637,
						1375.77379984580),
				new Vsop87.LnVsop(0.00000051986, 0.99006936413,
						1596.18644228460),
				new Vsop87.LnVsop(0.00000055194, 0.40176641060, 525.75881183150),
				new Vsop87.LnVsop(0.00000063456, 4.50073545366, 735.87651353180),
				new Vsop87.LnVsop(0.00000049691, 0.18650769854, 543.91805909620),
				new Vsop87.LnVsop(0.00000048831, 3.57260516733, 533.62311835770),
				new Vsop87.LnVsop(0.00000028353, 1.53532751494, 625.67019231240),
				new Vsop87.LnVsop(0.00000029209, 5.43144706118, 206.18554843720),
				new Vsop87.LnVsop(0.00000023255, 5.95197656622, 838.96928775040),
				new Vsop87.LnVsop(0.00000022841, 6.19262795963, 532.87235883230),
				new Vsop87.LnVsop(0.00000023202, 4.06473393382, 526.50957135690),
				new Vsop87.LnVsop(0.00000024435, 6.10948089320,
						1169.58825140860),
				new Vsop87.LnVsop(0.00000021116, 4.96322450112,
						2648.45482547300),
				new Vsop87.LnVsop(0.00000017878, 3.08705078418,
						1795.25844372100),
				new Vsop87.LnVsop(0.00000016234, 4.83514182468,
						1368.66025284500),
				new Vsop87.LnVsop(0.00000021314, 2.69476772406,
						1045.15483618760),
				new Vsop87.LnVsop(0.00000015740, 1.15129718235, 942.06206196900),
				new Vsop87.LnVsop(0.00000017325, 1.61549112201, 14.22709400160),
				new Vsop87.LnVsop(0.00000013396, 2.30541502374, 853.19638175200),
				new Vsop87.LnVsop(0.00000011904, 3.09812644271,
						2111.65031337760),
				new Vsop87.LnVsop(0.00000011734, 2.83005459062,
						2008.55753915900),
				new Vsop87.LnVsop(0.00000011291, 0.98958488237, 433.71173787680),
				new Vsop87.LnVsop(0.00000011830, 4.76527289406, 309.27832265580),
				new Vsop87.LnVsop(0.00000010702, 3.70182977140,
						2221.85663459700),
				new Vsop87.LnVsop(0.00000010815, 5.81960671820,
						1272.68102562720),
				new Vsop87.LnVsop(0.00000013505, 3.28127499147,
						1155.36115740700),
				new Vsop87.LnVsop(0.00000010179, 2.58690544075, 117.31986822020),
				new Vsop87.LnVsop(0.00000010632, 5.23488821353, 95.97922721780),
				new Vsop87.LnVsop(0.00000008770, 0.40456977116, 220.41264243880),
				new Vsop87.LnVsop(0.00000007439, 2.94640424217, 412.37109687440),
				new Vsop87.LnVsop(0.00000006151, 2.69098997815, 380.12776796000),
				new Vsop87.LnVsop(0.00000005028, 0.72749683440,
						1055.44977692610),
				new Vsop87.LnVsop(0.00000004939, 0.73757027802,
						1905.46476494040),
				new Vsop87.LnVsop(0.00000005421, 4.08611312731,
						1685.05212250160),
				new Vsop87.LnVsop(0.00000005936, 4.32059794159,
						1063.31408345230),
				new Vsop87.LnVsop(0.00000004737, 4.09302873263, 527.24328453980),
				new Vsop87.LnVsop(0.00000004010, 0.51536205068,
						1073.60902419080),
				new Vsop87.LnVsop(0.00000004709, 1.84069593466, 984.60033162190),
				new Vsop87.LnVsop(0.00000003974, 1.33608144666,
						2125.87740737920),
				new Vsop87.LnVsop(0.00000003762, 3.58647029066, 529.73914920440),
				new Vsop87.LnVsop(0.00000004731, 6.16377395837, 532.13864564940),
				new Vsop87.LnVsop(0.00000004666, 5.88761580267, 639.89728631400),
				new Vsop87.LnVsop(0.00000003763, 0.38865915086, 529.64278098480),
				new Vsop87.LnVsop(0.00000003409, 4.05403520743,
						1898.35121793960),
				new Vsop87.LnVsop(0.00000003458, 3.43863446426,
						1485.98012106520),
				new Vsop87.LnVsop(0.00000004230, 2.23769605857, 74.78159856730),
				new Vsop87.LnVsop(0.00000003091, 0.16468497073,
						1699.27921650320),
				new Vsop87.LnVsop(0.00000002976, 0.72268932553, 530.65417294110),
				new Vsop87.LnVsop(0.00000003162, 1.25051775753, 330.61896365820),
				new Vsop87.LnVsop(0.00000002727, 4.37684648696, 149.56319713460),
				new Vsop87.LnVsop(0.00000002837, 0.05988888469,
						1439.50969814920),
				new Vsop87.LnVsop(0.00000002983, 3.25251234697, 528.72775724810),
				new Vsop87.LnVsop(0.00000002232, 0.26152702827,
						1062.56332392690),
				new Vsop87.LnVsop(0.00000002464, 1.16914990320, 453.42489381900),
				new Vsop87.LnVsop(0.00000002596, 3.30503237792,
						2324.94940881560),
				new Vsop87.LnVsop(0.00000001988, 2.85269753342,
						1574.84580128220),
				new Vsop87.LnVsop(0.00000002527, 5.94464299442, 909.81873305460),
				new Vsop87.LnVsop(0.00000002269, 1.30385144361, 3.93215326310),
				new Vsop87.LnVsop(0.00000001742, 4.49934387430,
						1258.45393162560),
				new Vsop87.LnVsop(0.00000001714, 4.12970162252,
						2001.44399215820),
				new Vsop87.LnVsop(0.00000002028, 3.97933364572,
						1056.20053645150),
				new Vsop87.LnVsop(0.00000001667, 0.36035632569,
						10213.28554621100),
				new Vsop87.LnVsop(0.00000001579, 6.11636481584,
						1802.37199072180),
				new Vsop87.LnVsop(0.00000001393, 3.69324297104,
						2214.74308759620),
				new Vsop87.LnVsop(0.00000001604, 1.98841976369, 38.13303563780),
				new Vsop87.LnVsop(0.00000001325, 1.74025919863, 529.16970023280),
				new Vsop87.LnVsop(0.00000001451, 2.39820472604,
						2428.04218303420),
				new Vsop87.LnVsop(0.00000001594, 2.07557781162,
						1021.24889455140),
				new Vsop87.LnVsop(0.00000001319, 1.33764254668, 618.55664531160),
				new Vsop87.LnVsop(0.00000001346, 3.27611250994,
						2641.34127847220),
				new Vsop87.LnVsop(0.00000001230, 0.19547016795, 305.34616939270),
				new Vsop87.LnVsop(0.00000001223, 2.86673324041,
						1382.88734684660),
				new Vsop87.LnVsop(0.00000001324, 2.23549334986, 530.21222995640),
				new Vsop87.LnVsop(0.00000001056, 3.80584206280, 76.26607127560),
				new Vsop87.LnVsop(0.00000001050, 4.68049393704,
						1788.14489672020),
				new Vsop87.LnVsop(0.00000001226, 5.34004079561,
						3178.14579056760),
				new Vsop87.LnVsop(0.00000001009, 3.19598679941,
						2538.24850425360),
				new Vsop87.LnVsop(0.00000001266, 3.04716587183, 604.47256366190),
				new Vsop87.LnVsop(0.00000000954, 3.86982853835, 728.76296653100),
				new Vsop87.LnVsop(0.00000001124, 1.59536330231, 3.18139373770),
				new Vsop87.LnVsop(0.00000000978, 0.25225276132, 983.11585891360),
				new Vsop87.LnVsop(0.00000000948, 0.21562638606, 750.10360753340),
				new Vsop87.LnVsop(0.00000000946, 3.93927018641, 508.35032409220),
				new Vsop87.LnVsop(0.00000000920, 1.14676177277, 963.40270297140),
				new Vsop87.LnVsop(0.00000000817, 5.93843083013, 831.85574074960),
				new Vsop87.LnVsop(0.00000000770, 2.96062737592, 526.77020378780),
				new Vsop87.LnVsop(0.00000001018, 5.55723104876, 199.07200143640),
				new Vsop87.LnVsop(0.00000000761, 1.38163787157, 532.61172640140),
				new Vsop87.LnVsop(0.00000000726, 3.98350624153,
						2317.83586181480),
				new Vsop87.LnVsop(0.00000000863, 0.87983185587, 490.33408917940),
				new Vsop87.LnVsop(0.00000000868, 3.44355447829, 569.04784100980),
				new Vsop87.LnVsop(0.00000000711, 4.11083927584,
						2751.54759969160),
				new Vsop87.LnVsop(0.00000000708, 0.33555577415, 528.94020556920),
				new Vsop87.LnVsop(0.00000000708, 4.00539820601, 530.44172462000),
				new Vsop87.LnVsop(0.00000000656, 4.39587636715, 519.39602435610),
				new Vsop87.LnVsop(0.00000000801, 4.03968735657,
						1364.72809958190),
				new Vsop87.LnVsop(0.00000000679, 1.18645749024, 525.49817940060),
				new Vsop87.LnVsop(0.00000000645, 5.10528821006,
						1361.54670584420),
				new Vsop87.LnVsop(0.00000000668, 3.15607509055, 533.88375078860),
				new Vsop87.LnVsop(0.00000000663, 0.73722024842,
						5223.69391980220),
				new Vsop87.LnVsop(0.00000000663, 1.57092786810,
						6283.07584999140),
				new Vsop87.LnVsop(0.00000000543, 0.26361339096, 227.52618943960),
				new Vsop87.LnVsop(0.00000000525, 6.22337510612, 539.98590583310),
				new Vsop87.LnVsop(0.00000000513, 4.98311290285, 302.16477565500),
				new Vsop87.LnVsop(0.00000000544, 2.22253022770,
						2744.43405269080),
				new Vsop87.LnVsop(0.00000000531, 2.62394469648, 99.16062095550),
				new Vsop87.LnVsop(0.00000000602, 1.56087341101, 454.90936652730),
				new Vsop87.LnVsop(0.00000000518, 0.26343809435, 551.03160609700),
				new Vsop87.LnVsop(0.00000000516, 1.09334875112, 934.94851496820),
				new Vsop87.LnVsop(0.00000000659, 0.62609803674,
						1512.80682400820),
				new Vsop87.LnVsop(0.00000000524, 0.64710955846, 524.06189080210),
				new Vsop87.LnVsop(0.00000000516, 3.69478866795, 535.32003938710),
				new Vsop87.LnVsop(0.00000000491, 3.63015352701,
						2531.13495725280),
				new Vsop87.LnVsop(0.00000000570, 0.61976758778, 540.73666535850),
				new Vsop87.LnVsop(0.00000000496, 2.19397054688,
						1514.29129671650),
				new Vsop87.LnVsop(0.00000000532, 0.20040217534, 525.02509864860),
				new Vsop87.LnVsop(0.00000000449, 0.62392433691, 529.53090640020),
				new Vsop87.LnVsop(0.00000000449, 3.71676131146, 529.85102378900),
				new Vsop87.LnVsop(0.00000000493, 0.39157407639, 224.34479570190),
				new Vsop87.LnVsop(0.00000000450, 5.02496027796,
						1048.33622992530),
				new Vsop87.LnVsop(0.00000000428, 5.44829085911, 11.04570026390),
				new Vsop87.LnVsop(0.00000000499, 4.13924061941, 534.35683154060),
				new Vsop87.LnVsop(0.00000000528, 1.76471074936, 524.27433912320),
				new Vsop87.LnVsop(0.00000000454, 4.53329910309,
						1056.93424963440),
				new Vsop87.LnVsop(0.00000000520, 2.57406093768, 535.10759106600),
				new Vsop87.LnVsop(0.00000000398, 1.40335768867, 960.22130923370),
				new Vsop87.LnVsop(0.00000000457, 4.17698500570,
						2104.53676637680),
				new Vsop87.LnVsop(0.00000000505, 5.36536006721,
						1057.89745748090),
				new Vsop87.LnVsop(0.00000000536, 4.80412344518,
						1593.00504854690),
				new Vsop87.LnVsop(0.00000000415, 0.96574631343,
						2435.15573003500),
				new Vsop87.LnVsop(0.00000000518, 0.54534019245,
						1061.82961074400),
				new Vsop87.LnVsop(0.00000000359, 4.02703442030,
						1059.43011429900),
				new Vsop87.LnVsop(0.00000000357, 2.66856274985, 835.03713448730),
				new Vsop87.LnVsop(0.00000000443, 5.27506751917, 1.48447270830),
				new Vsop87.LnVsop(0.00000000358, 5.94447745169, 440.82528487760),
				new Vsop87.LnVsop(0.00000000471, 6.05795526096,
						1471.75302706360),
				new Vsop87.LnVsop(0.00000000386, 2.15957649340,
						9153.90361602180),
				new Vsop87.LnVsop(0.00000000424, 2.70933415956,
						1038.04128918680),
				new Vsop87.LnVsop(0.00000000359, 0.82921825054,
						1059.33374607940),
				new Vsop87.LnVsop(0.00000000310, 0.88102053266, 529.90341341570),
				new Vsop87.LnVsop(0.00000000310, 3.45966511571, 529.47851677350),
				new Vsop87.LnVsop(0.00000000300, 3.70314980875,
						2634.22773147140),
				new Vsop87.LnVsop(0.00000000292, 2.63690294080, 415.55249061210),
				new Vsop87.LnVsop(0.00000000279, 1.60721363324, 643.82943957710),
				new Vsop87.LnVsop(0.00000000291, 5.83172186169,
						1148.24761040620),
				new Vsop87.LnVsop(0.00000000370, 5.71572992264, 531.17543780290),
				new Vsop87.LnVsop(0.00000000267, 5.39229778002,
						1891.23767093880),
				new Vsop87.LnVsop(0.00000000275, 3.34111459961, 518.64526483070),
				new Vsop87.LnVsop(0.00000000269, 1.06062338999,
						1585.14074202070),
				new Vsop87.LnVsop(0.00000000305, 2.50290530704, 511.53171782990),
				new Vsop87.LnVsop(0.00000000295, 1.84394223501, 547.85021235930),
				new Vsop87.LnVsop(0.00000000254, 2.98339664362,
						1134.16352875650),
				new Vsop87.LnVsop(0.00000000289, 1.86077249808, 21.34064100240),
				new Vsop87.LnVsop(0.00000000265, 4.93074056536, 679.25416222920),
				new Vsop87.LnVsop(0.00000000250, 0.42864032040,
						1969.20066324380),
				new Vsop87.LnVsop(0.00000000308, 2.67241191564,
						2957.73314812880),
				new Vsop87.LnVsop(0.00000000222, 4.78828764413, 514.71311156760),
				new Vsop87.LnVsop(0.00000000313, 4.88100504465, 528.20649238630),
				new Vsop87.LnVsop(0.00000000221, 4.32945667530,
						1677.93857550080),
				new Vsop87.LnVsop(0.00000000217, 3.46325099644,
						2950.61960112800),
				new Vsop87.LnVsop(0.00000000216, 0.52215246917,
						2228.97018159780),
				new Vsop87.LnVsop(0.00000000214, 5.83569926578, 544.66881862160),
				new Vsop87.LnVsop(0.00000000283, 2.88733008413, 35.42472265210),
				new Vsop87.LnVsop(0.00000000272, 1.65636249662,
						3060.82592234740),
				new Vsop87.LnVsop(0.00000000234, 1.68821601235,
						2655.56837247380),
				new Vsop87.LnVsop(0.00000000205, 3.36180409781,
						2847.52682690940),
				new Vsop87.LnVsop(0.00000000264, 3.62728688214,
						2420.92863603340),
				new Vsop87.LnVsop(0.00000000191, 4.26801797983, 430.53034413910),
				new Vsop87.LnVsop(0.00000000179, 3.91470663032,
						3340.61242669980),
				new Vsop87.LnVsop(0.00000000180, 0.04748930181, 387.24131496080),
				new Vsop87.LnVsop(0.00000000241, 4.03850570457, 494.26624244250),
				new Vsop87.LnVsop(0.00000000177, 4.26408822698, 672.14061522840),
				new Vsop87.LnVsop(0.00000000187, 2.72585227782, 299.12639426920),
				new Vsop87.LnVsop(0.00000000234, 1.34461198439, 173.94221952280),
				new Vsop87.LnVsop(0.00000000171, 0.85583570724,
						1603.29998928540),
				new Vsop87.LnVsop(0.00000000224, 0.33038256827, 565.11568774670),
				new Vsop87.LnVsop(0.00000000200, 1.27568775106, 39.35687591520),
				new Vsop87.LnVsop(0.00000000170, 4.96553772568,
						1464.63948006280),
				new Vsop87.LnVsop(0.00000000211, 1.00937080256, 523.54062594030),
				new Vsop87.LnVsop(0.00000000210, 3.75802767164,
						2854.64037391020),
				new Vsop87.LnVsop(0.00000000162, 5.87799218214,
						3480.31056622260),
				new Vsop87.LnVsop(0.00000000163, 4.62924224205,
						2015.67108615980),
				new Vsop87.LnVsop(0.00000000191, 3.33159283750, 535.84130424890),
				new Vsop87.LnVsop(0.00000000151, 1.17104489977,
						1060.34513803570),
				new Vsop87.LnVsop(0.00000000160, 1.81868596669, 312.45971639350),
				new Vsop87.LnVsop(0.00000000158, 2.59595816107, 529.43033266370),
				new Vsop87.LnVsop(0.00000000158, 1.74472748730, 529.95159752550),
				new Vsop87.LnVsop(0.00000000173, 3.62448533343, 230.56457082540),
				new Vsop87.LnVsop(0.00000000142, 0.70435921398, 522.52923398400),
				new Vsop87.LnVsop(0.00000000144, 5.35713735269, 107.02492748170),
				new Vsop87.LnVsop(0.00000000144, 6.14090754307,
						1158.54255114470),
				new Vsop87.LnVsop(0.00000000178, 0.27468100074,
						3906.90875709860),
				new Vsop87.LnVsop(0.00000000126, 5.15022690251,
						2207.62954059540),
				new Vsop87.LnVsop(0.00000000126, 3.42007113405, 2.44768055480),
				new Vsop87.LnVsop(0.00000000127, 0.39943436855, 70.84944530420),
				new Vsop87.LnVsop(0.00000000123, 4.77863018783,
						2524.02141025200),
				new Vsop87.LnVsop(0.00000000123, 0.46252835423, 647.01083331480),
				new Vsop87.LnVsop(0.00000000144, 3.60266428249,
						1058.41872234270),
				new Vsop87.LnVsop(0.00000000158, 3.76145245959, 92.04707395470),
				new Vsop87.LnVsop(0.00000000119, 4.08254103435,
						1585.89150154610),
				new Vsop87.LnVsop(0.00000000125, 2.35595591495,
						3163.91869656600),
				new Vsop87.LnVsop(0.00000000122, 3.21032018083,
						3377.21779200400),
				new Vsop87.LnVsop(0.00000000121, 3.39767154960, 18.15924726470),
				new Vsop87.LnVsop(0.00000000131, 1.67909216935,
						1289.94650101460),
				new Vsop87.LnVsop(0.00000000115, 2.35736056408,
						1550.93985964600),
				new Vsop87.LnVsop(0.00000000126, 2.40837527327, 106.27416795630),
				new Vsop87.LnVsop(0.00000000131, 1.37643228010,
						1023.95720753710),
				new Vsop87.LnVsop(0.00000000121, 1.60251352962, 10.29494073850),
				new Vsop87.LnVsop(0.00000000121, 0.61425825680,
						1592.25428902150),
				new Vsop87.LnVsop(0.00000000135, 3.60014547346, 124.43341522100),
				new Vsop87.LnVsop(0.00000000137, 2.41776488975,
						3274.12501778540),
				new Vsop87.LnVsop(0.00000000129, 0.09688303813,
						2332.06295581640),
				new Vsop87.LnVsop(0.00000000092, 4.89058170259,
						1098.73880610440),
				new Vsop87.LnVsop(0.00000000106, 5.18592950792,
						2281.23049651060),
				new Vsop87.LnVsop(0.00000000114, 2.96580552116,
						1166.40685767090),
				new Vsop87.LnVsop(0.00000000092, 1.65027422750, 860.30992875280),
				new Vsop87.LnVsop(0.00000000102, 3.64265158080,
						3171.03224356680),
				new Vsop87.LnVsop(0.00000000103, 1.63123525514,
						1894.41906467650),
				new Vsop87.LnVsop(0.00000000080, 0.38766601962,
						4694.00295470760),
				new Vsop87.LnVsop(0.00000000074, 3.86945907800,
						3067.93946934820),
				new Vsop87.LnVsop(0.00000000095, 1.66457947000,
						1151.42900414390), };

		private static final Vsop87.LnVsop[] jupiter_latitude_b1 = {
				new Vsop87.LnVsop(0.00078203446, 1.52377859742, 529.69096509460),
				new Vsop87.LnVsop(0.00007789905, 2.59734071843,
						1059.38193018920),
				new Vsop87.LnVsop(0.00002788602, 4.85622679819, 536.80451209540),
				new Vsop87.LnVsop(0.00002429728, 5.45947255041, 522.57741809380),
				new Vsop87.LnVsop(0.00001985777, 0.00000000000, 0.00000000000),
				new Vsop87.LnVsop(0.00000711633, 3.13688338277,
						1589.07289528380),
				new Vsop87.LnVsop(0.00000292916, 5.27960297214,
						1066.49547719000),
				new Vsop87.LnVsop(0.00000257804, 4.76667796123,
						1052.26838318840),
				new Vsop87.LnVsop(0.00000271233, 0.10154920958, 7.11354700080),
				new Vsop87.LnVsop(0.00000086261, 1.08347893125, 103.09277421860),
				new Vsop87.LnVsop(0.00000079683, 1.04738628033, 110.20632121940),
				new Vsop87.LnVsop(0.00000081369, 0.63901209639, 419.48464387520),
				new Vsop87.LnVsop(0.00000081666, 0.49217368092, 426.59819087600),
				new Vsop87.LnVsop(0.00000070613, 2.82219329635, 632.78373931320),
				new Vsop87.LnVsop(0.00000066992, 5.48215719084, 515.46387109300),
				new Vsop87.LnVsop(0.00000058497, 3.56648086507,
						2118.76386037840),
				new Vsop87.LnVsop(0.00000051976, 2.85910965609, 949.17560896980),
				new Vsop87.LnVsop(0.00000041188, 4.75217333048, 543.91805909620),
				new Vsop87.LnVsop(0.00000039924, 3.92433787110, 735.87651353180),
				new Vsop87.LnVsop(0.00000040237, 1.13564290140,
						1162.47470440780),
				new Vsop87.LnVsop(0.00000026065, 5.69856804584,
						1596.18644228460),
				new Vsop87.LnVsop(0.00000031305, 6.03167547323, 323.50541665740),
				new Vsop87.LnVsop(0.00000030485, 5.98342688371, 316.39186965660),
				new Vsop87.LnVsop(0.00000021243, 4.88358142951, 213.29909543800),
				new Vsop87.LnVsop(0.00000017336, 1.63355193402, 956.28915597060),
				new Vsop87.LnVsop(0.00000016318, 1.68217979523, 206.18554843720),
				new Vsop87.LnVsop(0.00000021612, 4.90561988011,
						1581.95934828300),
				new Vsop87.LnVsop(0.00000015050, 4.62184858700, 525.75881183150),
				new Vsop87.LnVsop(0.00000015354, 4.38535188227, 532.87235883230),
				new Vsop87.LnVsop(0.00000014194, 5.89751177643, 526.50957135690),
				new Vsop87.LnVsop(0.00000012259, 5.76584367807, 533.62311835770),
				new Vsop87.LnVsop(0.00000013752, 4.43118193299,
						1045.15483618760),
				new Vsop87.LnVsop(0.00000010998, 3.66464772481, 742.99006053260),
				new Vsop87.LnVsop(0.00000010324, 4.35223675725,
						1169.58825140860),
				new Vsop87.LnVsop(0.00000012020, 6.22841485051, 14.22709400160),
				new Vsop87.LnVsop(0.00000008201, 5.61044388483,
						1265.56747862640),
				new Vsop87.LnVsop(0.00000009125, 2.07963809004,
						1692.16566950240),
				new Vsop87.LnVsop(0.00000006995, 3.68757029433, 625.67019231240),
				new Vsop87.LnVsop(0.00000006623, 2.95794554141, 942.06206196900),
				new Vsop87.LnVsop(0.00000006854, 4.86899700840,
						1155.36115740700),
				new Vsop87.LnVsop(0.00000005392, 0.92120894811, 117.31986822020),
				new Vsop87.LnVsop(0.00000004948, 5.58428784853, 433.71173787680),
				new Vsop87.LnVsop(0.00000005907, 4.00891325053, 639.89728631400),
				new Vsop87.LnVsop(0.00000004904, 0.79623393478, 95.97922721780),
				new Vsop87.LnVsop(0.00000004849, 0.77150458453, 853.19638175200),
				new Vsop87.LnVsop(0.00000004554, 3.96028178465,
						2648.45482547300),
				new Vsop87.LnVsop(0.00000003572, 5.03591772370, 220.41264243880),
				new Vsop87.LnVsop(0.00000003471, 5.13166913050,
						1073.60902419080),
				new Vsop87.LnVsop(0.00000003611, 1.57140411443,
						1478.86657406440),
				new Vsop87.LnVsop(0.00000002856, 4.67088931160,
						1272.68102562720),
				new Vsop87.LnVsop(0.00000003393, 5.57286071973,
						1375.77379984580),
				new Vsop87.LnVsop(0.00000002753, 0.68101124197, 846.08283475120),
				new Vsop87.LnVsop(0.00000002097, 6.16024347671,
						2125.87740737920),
				new Vsop87.LnVsop(0.00000002114, 5.87434713206, 330.61896365820),
				new Vsop87.LnVsop(0.00000001945, 0.99530094399, 309.27832265580),
				new Vsop87.LnVsop(0.00000001637, 0.11662674189,
						1795.25844372100),
				new Vsop87.LnVsop(0.00000001899, 5.04072957525, 412.37109687440),
				new Vsop87.LnVsop(0.00000001791, 2.71494717262,
						1485.98012106520),
				new Vsop87.LnVsop(0.00000001543, 4.89349278048,
						1062.56332392690),
				new Vsop87.LnVsop(0.00000001379, 4.78442752303,
						1699.27921650320),
				new Vsop87.LnVsop(0.00000001614, 5.31695012950,
						2111.65031337760),
				new Vsop87.LnVsop(0.00000001356, 5.09369131122,
						1055.44977692610),
				new Vsop87.LnVsop(0.00000001472, 4.55646132730,
						1574.84580128220),
				new Vsop87.LnVsop(0.00000001216, 5.83778167217,
						1258.45393162560),
				new Vsop87.LnVsop(0.00000001061, 0.21929903524,
						1063.31408345230),
				new Vsop87.LnVsop(0.00000001281, 2.63291136301,
						2221.85663459700),
				new Vsop87.LnVsop(0.00000001282, 4.40670408797, 728.76296653100),
				new Vsop87.LnVsop(0.00000001081, 5.65958153020, 508.35032409220),
				new Vsop87.LnVsop(0.00000001236, 5.79698189268,
						1056.20053645150),
				new Vsop87.LnVsop(0.00000000834, 5.66034576977, 838.96928775040),
				new Vsop87.LnVsop(0.00000000843, 1.39726903288, 199.07200143640),
				new Vsop87.LnVsop(0.00000001114, 0.93457172591,
						1368.66025284500),
				new Vsop87.LnVsop(0.00000001004, 1.88230290234,
						2008.55753915900),
				new Vsop87.LnVsop(0.00000000784, 3.98772675676,
						1471.75302706360),
				new Vsop87.LnVsop(0.00000000682, 6.16172441549, 519.39602435610),
				new Vsop87.LnVsop(0.00000000649, 3.11256832821, 618.55664531160),
				new Vsop87.LnVsop(0.00000000597, 4.81489778721, 551.03160609700),
				new Vsop87.LnVsop(0.00000000546, 4.76855837933,
						1685.05212250160),
				new Vsop87.LnVsop(0.00000000546, 4.45547174659, 539.98590583310),
				new Vsop87.LnVsop(0.00000000628, 0.06358024238, 3.18139373770),
				new Vsop87.LnVsop(0.00000000514, 1.39819252269,
						1382.88734684660),
				new Vsop87.LnVsop(0.00000000546, 5.95490984957,
						1905.46476494040),
				new Vsop87.LnVsop(0.00000000432, 4.90782507942, 227.52618943960),
				new Vsop87.LnVsop(0.00000000375, 6.13692411934,
						2428.04218303420),
				new Vsop87.LnVsop(0.00000000441, 4.43503611535,
						1038.04128918680),
				new Vsop87.LnVsop(0.00000000336, 4.15259691191, 440.82528487760),
				new Vsop87.LnVsop(0.00000000392, 4.41318281175,
						1802.37199072180),
				new Vsop87.LnVsop(0.00000000336, 1.95113506965, 525.02509864860),
				new Vsop87.LnVsop(0.00000000322, 2.38708525663, 534.35683154060),
				new Vsop87.LnVsop(0.00000000411, 4.66598314047, 750.10360753340),
				new Vsop87.LnVsop(0.00000000270, 4.34851907328,
						3178.14579056760),
				new Vsop87.LnVsop(0.00000000344, 2.88739614093, 3.93215326310),
				new Vsop87.LnVsop(0.00000000306, 0.14928179595, 21.34064100240),
				new Vsop87.LnVsop(0.00000000229, 4.71494574126,
						1788.14489672020),
				new Vsop87.LnVsop(0.00000000253, 5.97477420709,
						1898.35121793960),
				new Vsop87.LnVsop(0.00000000220, 1.65244409667, 302.16477565500),
				new Vsop87.LnVsop(0.00000000200, 5.63991949724, 524.27433912320),
				new Vsop87.LnVsop(0.00000000197, 4.98395147244, 535.10759106600),
				new Vsop87.LnVsop(0.00000000189, 1.27085486089, 831.85574074960),
				new Vsop87.LnVsop(0.00000000217, 5.72813758318, 963.40270297140),
				new Vsop87.LnVsop(0.00000000163, 4.41162044978, 511.53171782990),
				new Vsop87.LnVsop(0.00000000157, 6.22659623699, 547.85021235930),
				new Vsop87.LnVsop(0.00000000156, 4.47889955750,
						2104.53676637680),
				new Vsop87.LnVsop(0.00000000158, 4.68155089578, 526.77020378780),
				new Vsop87.LnVsop(0.00000000157, 5.94254789616, 532.61172640140),
				new Vsop87.LnVsop(0.00000000177, 1.54590155579,
						2324.94940881560),
				new Vsop87.LnVsop(0.00000000159, 0.57726792367,
						1361.54670584420),
				new Vsop87.LnVsop(0.00000000143, 5.47600559579,
						1603.29998928540),
				new Vsop87.LnVsop(0.00000000144, 1.09752516756, 74.78159856730),
				new Vsop87.LnVsop(0.00000000125, 4.04792462029,
						2001.44399215820),
				new Vsop87.LnVsop(0.00000000116, 0.20661426580,
						2655.56837247380),
				new Vsop87.LnVsop(0.00000000100, 5.29546864010,
						1891.23767093880),
				new Vsop87.LnVsop(0.00000000104, 6.06015582682, 10.29494073850),
				new Vsop87.LnVsop(0.00000000122, 3.06889841223,
						2317.83586181480),
				new Vsop87.LnVsop(0.00000000106, 3.07515212924,
						2751.54759969160),
				new Vsop87.LnVsop(0.00000000123, 3.57772593687,
						2015.67108615980),
				new Vsop87.LnVsop(0.00000000080, 5.22386963290,
						2228.97018159780),
				new Vsop87.LnVsop(0.00000000103, 2.60543230206,
						2538.24850425360),
				new Vsop87.LnVsop(0.00000000076, 6.05570454898, 984.60033162190),
				new Vsop87.LnVsop(0.00000000087, 4.53831014475,
						1148.24761040620), };

		private static final Vsop87.LnVsop[] jupiter_latitude_b2 = {
				new Vsop87.LnVsop(0.00005498320, 3.01596270062, 529.69096509460),
				new Vsop87.LnVsop(0.00000602076, 3.13358939436, 536.80451209540),
				new Vsop87.LnVsop(0.00000502174, 2.05202111599,
						1059.38193018920),
				new Vsop87.LnVsop(0.00000453862, 0.95912416388, 522.57741809380),
				new Vsop87.LnVsop(0.00000115043, 0.00000000000, 0.00000000000),
				new Vsop87.LnVsop(0.00000068911, 3.65515676096,
						1066.49547719000),
				new Vsop87.LnVsop(0.00000067052, 2.23363751256,
						1589.07289528380),
				new Vsop87.LnVsop(0.00000042555, 0.52143365809,
						1052.26838318840),
				new Vsop87.LnVsop(0.00000039396, 4.65314230657, 7.11354700080),
				new Vsop87.LnVsop(0.00000023438, 0.96725852073, 515.46387109300),
				new Vsop87.LnVsop(0.00000017383, 3.03116251890, 543.91805909620),
				new Vsop87.LnVsop(0.00000006651, 4.14899100562,
						1596.18644228460),
				new Vsop87.LnVsop(0.00000007013, 2.58268666095,
						2118.76386037840),
				new Vsop87.LnVsop(0.00000005389, 5.43989474079, 110.20632121940),
				new Vsop87.LnVsop(0.00000004578, 6.21390672967,
						1045.15483618760),
				new Vsop87.LnVsop(0.00000004226, 2.60174767485, 532.87235883230),
				new Vsop87.LnVsop(0.00000003653, 5.49147329377, 426.59819087600),
				new Vsop87.LnVsop(0.00000004208, 4.53565061928, 14.22709400160),
				new Vsop87.LnVsop(0.00000003620, 2.16725398015,
						1162.47470440780),
				new Vsop87.LnVsop(0.00000004347, 4.34610976020, 323.50541665740),
				new Vsop87.LnVsop(0.00000003449, 1.44287034922, 526.50957135690),
				new Vsop87.LnVsop(0.00000003250, 4.99793920041, 632.78373931320),
				new Vsop87.LnVsop(0.00000003549, 5.47945408971, 103.09277421860),
				new Vsop87.LnVsop(0.00000003031, 0.65632340107,
						1581.95934828300),
				new Vsop87.LnVsop(0.00000003252, 5.38360789595, 949.17560896980),
				new Vsop87.LnVsop(0.00000002464, 0.29383438152, 956.28915597060),
				new Vsop87.LnVsop(0.00000002590, 2.61624183669, 525.75881183150),
				new Vsop87.LnVsop(0.00000002414, 6.08828067002, 419.48464387520),
				new Vsop87.LnVsop(0.00000002206, 2.62381175358,
						1169.58825140860),
				new Vsop87.LnVsop(0.00000001991, 1.56606451610, 533.62311835770),
				new Vsop87.LnVsop(0.00000001868, 2.03564229490, 316.39186965660),
				new Vsop87.LnVsop(0.00000002225, 6.11348450922, 735.87651353180),
				new Vsop87.LnVsop(0.00000001512, 4.74989508185, 942.06206196900),
				new Vsop87.LnVsop(0.00000001458, 3.53705002363,
						1073.60902419080),
				new Vsop87.LnVsop(0.00000001473, 3.61629070367, 206.18554843720),
				new Vsop87.LnVsop(0.00000001467, 5.52885404945, 117.31986822020),
				new Vsop87.LnVsop(0.00000001373, 0.36875884830,
						1155.36115740700),
				new Vsop87.LnVsop(0.00000001237, 2.65571662403, 95.97922721780),
				new Vsop87.LnVsop(0.00000001124, 3.90568585311, 433.71173787680),
				new Vsop87.LnVsop(0.00000001348, 5.54306182308, 625.67019231240),
				new Vsop87.LnVsop(0.00000000964, 5.49710119494, 853.19638175200),
				new Vsop87.LnVsop(0.00000000947, 2.34829918409, 639.89728631400),
				new Vsop87.LnVsop(0.00000000798, 3.37909370240, 220.41264243880),
				new Vsop87.LnVsop(0.00000000707, 1.57787722219,
						1692.16566950240),
				new Vsop87.LnVsop(0.00000000591, 0.29761569203, 213.29909543800),
				new Vsop87.LnVsop(0.00000000572, 1.28691054813, 508.35032409220),
				new Vsop87.LnVsop(0.00000000512, 2.56537612741,
						1265.56747862640),
				new Vsop87.LnVsop(0.00000000665, 6.11880936688, 728.76296653100),
				new Vsop87.LnVsop(0.00000000447, 4.60869261113,
						2125.87740737920),
				new Vsop87.LnVsop(0.00000000586, 4.43282799664, 330.61896365820),
				new Vsop87.LnVsop(0.00000000414, 1.25349133607,
						1258.45393162560),
				new Vsop87.LnVsop(0.00000000524, 2.96141918447,
						2648.45482547300),
				new Vsop87.LnVsop(0.00000000444, 3.19923402818,
						1062.56332392690),
				new Vsop87.LnVsop(0.00000000404, 1.79288519616,
						1485.98012106520),
				new Vsop87.LnVsop(0.00000000375, 0.79587902858, 838.96928775040),
				new Vsop87.LnVsop(0.00000000353, 3.34547139217, 199.07200143640),
				new Vsop87.LnVsop(0.00000000452, 5.08983741758, 846.08283475120),
				new Vsop87.LnVsop(0.00000000334, 3.04324482994, 551.03160609700),
				new Vsop87.LnVsop(0.00000000366, 1.68895713870, 519.39602435610),
				new Vsop87.LnVsop(0.00000000394, 1.57570736696, 412.37109687440),
				new Vsop87.LnVsop(0.00000000301, 3.37032774636, 309.27832265580),
				new Vsop87.LnVsop(0.00000000291, 2.62531230776, 539.98590583310),
				new Vsop87.LnVsop(0.00000000325, 0.15647873172,
						1574.84580128220),
				new Vsop87.LnVsop(0.00000000245, 3.25292367144,
						1272.68102562720),
				new Vsop87.LnVsop(0.00000000217, 3.11492452322,
						1699.27921650320),
				new Vsop87.LnVsop(0.00000000184, 1.08716393617,
						1478.86657406440),
				new Vsop87.LnVsop(0.00000000148, 2.68589605205, 440.82528487760),
				new Vsop87.LnVsop(0.00000000151, 3.55666552483, 227.52618943960),
				new Vsop87.LnVsop(0.00000000159, 4.59287441360, 3.18139373770),
				new Vsop87.LnVsop(0.00000000136, 4.84859091336,
						1375.77379984580),
				new Vsop87.LnVsop(0.00000000163, 2.32840480908,
						1368.66025284500),
				new Vsop87.LnVsop(0.00000000143, 3.22177095400,
						1055.44977692610),
				new Vsop87.LnVsop(0.00000000142, 5.72788361902,
						1471.75302706360),
				new Vsop87.LnVsop(0.00000000158, 4.73812763868, 21.34064100240),
				new Vsop87.LnVsop(0.00000000128, 2.70021949677, 742.99006053260),
				new Vsop87.LnVsop(0.00000000139, 1.17163391807,
						1056.20053645150),
				new Vsop87.LnVsop(0.00000000145, 0.86475461158,
						2111.65031337760),
				new Vsop87.LnVsop(0.00000000113, 0.93475856540,
						1685.05212250160),
				new Vsop87.LnVsop(0.00000000092, 6.08486890659,
						1038.04128918680),
				new Vsop87.LnVsop(0.00000000077, 1.76503406298,
						1795.25844372100),
				new Vsop87.LnVsop(0.00000000076, 1.81177242528,
						2221.85663459700),
				new Vsop87.LnVsop(0.00000000077, 3.87925580596,
						1603.29998928540), };

		private static final Vsop87.LnVsop[] jupiter_latitude_b3 = {
				new Vsop87.LnVsop(0.00000185332, 4.79276761490, 529.69096509460),
				new Vsop87.LnVsop(0.00000085668, 1.40023038638, 536.80451209540),
				new Vsop87.LnVsop(0.00000056359, 2.81574766965, 522.57741809380),
				new Vsop87.LnVsop(0.00000019435, 6.25741008684,
						1059.38193018920),
				new Vsop87.LnVsop(0.00000010858, 2.04333735353,
						1066.49547719000),
				new Vsop87.LnVsop(0.00000014477, 0.00000000000, 0.00000000000),
				new Vsop87.LnVsop(0.00000005535, 2.75732372347, 515.46387109300),
				new Vsop87.LnVsop(0.00000004939, 1.29727834284, 543.91805909620),
				new Vsop87.LnVsop(0.00000004970, 2.56009290021,
						1052.26838318840),
				new Vsop87.LnVsop(0.00000004112, 0.86840480428,
						1589.07289528380),
				new Vsop87.LnVsop(0.00000003798, 2.86619114773, 7.11354700080),
				new Vsop87.LnVsop(0.00000001107, 2.66033381472,
						1596.18644228460),
				new Vsop87.LnVsop(0.00000001093, 1.82485496219,
						1045.15483618760),
				new Vsop87.LnVsop(0.00000001031, 2.82866669066, 14.22709400160),
				new Vsop87.LnVsop(0.00000000433, 4.07064796547, 419.48464387520),
				new Vsop87.LnVsop(0.00000000441, 1.38849268510,
						2118.76386037840),
				new Vsop87.LnVsop(0.00000000427, 1.88306006605,
						1073.60902419080),
				new Vsop87.LnVsop(0.00000000385, 3.43063155260, 110.20632121940),
				new Vsop87.LnVsop(0.00000000270, 0.28254340737, 942.06206196900),
				new Vsop87.LnVsop(0.00000000282, 2.56588914137, 323.50541665740),
				new Vsop87.LnVsop(0.00000000281, 1.78450485408, 735.87651353180),
				new Vsop87.LnVsop(0.00000000250, 3.01246535740, 508.35032409220),
				new Vsop87.LnVsop(0.00000000218, 2.72492160401,
						1581.95934828300),
				new Vsop87.LnVsop(0.00000000210, 0.07248270409, 632.78373931320),
				new Vsop87.LnVsop(0.00000000225, 3.97044557000, 117.31986822020),
				new Vsop87.LnVsop(0.00000000203, 0.07858321388, 639.89728631400),
				new Vsop87.LnVsop(0.00000000170, 0.89620998933,
						1169.58825140860),
				new Vsop87.LnVsop(0.00000000165, 1.56025270981, 625.67019231240),
				new Vsop87.LnVsop(0.00000000156, 5.58460103668, 103.09277421860),
				new Vsop87.LnVsop(0.00000000137, 4.26368918979, 95.97922721780),
				new Vsop87.LnVsop(0.00000000100, 1.72309553591, 949.17560896980),
				new Vsop87.LnVsop(0.00000000094, 2.26854098455,
						1155.36115740700),
				new Vsop87.LnVsop(0.00000000082, 5.02874146441, 956.28915597060), };

		private static final Vsop87.LnVsop[] jupiter_latitude_b4 = {
				new Vsop87.LnVsop(0.00000008963, 5.93887232380, 536.80451209540),
				new Vsop87.LnVsop(0.00000005280, 4.80778878768, 522.57741809380),
				new Vsop87.LnVsop(0.00000001161, 0.46295890438,
						1066.49547719000),
				new Vsop87.LnVsop(0.00000001104, 4.53240452495, 515.46387109300),
				new Vsop87.LnVsop(0.00000001087, 5.81789252627, 543.91805909620),
				new Vsop87.LnVsop(0.00000000818, 1.49293156118, 529.69096509460),
				new Vsop87.LnVsop(0.00000000595, 4.58881648484,
						1059.38193018920),
				new Vsop87.LnVsop(0.00000000513, 4.57214361679,
						1052.26838318840),
				new Vsop87.LnVsop(0.00000000179, 0.75821264280, 7.11354700080),
				new Vsop87.LnVsop(0.00000000143, 5.78292264064,
						1589.07289528380),
				new Vsop87.LnVsop(0.00000000135, 1.57382028639, 14.22709400160),
				new Vsop87.LnVsop(0.00000000096, 1.04662476547,
						1596.18644228460),
				new Vsop87.LnVsop(0.00000000077, 3.58780641570,
						1045.15483618760), };

		private static final Vsop87.LnVsop[] jupiter_latitude_b5 = {
				new Vsop87.LnVsop(0.00000000662, 4.10413626462, 536.80451209540),
				new Vsop87.LnVsop(0.00000000431, 0.82614663721, 522.57741809380),
				new Vsop87.LnVsop(0.00000000208, 0.05498457769, 515.46387109300), };
	}

	static class Radius {
		private static final Vsop87.LnVsop[] jupiter_radius_r0 = {
				new Vsop87.LnVsop(5.20887429326, 0.00000000000, 0.00000000000),
				new Vsop87.LnVsop(0.25209327119, 3.49108639871, 529.69096509460),
				new Vsop87.LnVsop(0.00610599976, 3.84115365948,
						1059.38193018920),
				new Vsop87.LnVsop(0.00282029458, 2.57419881293, 632.78373931320),
				new Vsop87.LnVsop(0.00187647346, 2.07590383214, 522.57741809380),
				new Vsop87.LnVsop(0.00086792905, 0.71001145545, 419.48464387520),
				new Vsop87.LnVsop(0.00072062974, 0.21465724607, 536.80451209540),
				new Vsop87.LnVsop(0.00065517248, 5.97995884790, 316.39186965660),
				new Vsop87.LnVsop(0.00029134542, 1.67759379655, 103.09277421860),
				new Vsop87.LnVsop(0.00030135335, 2.16132003734, 949.17560896980),
				new Vsop87.LnVsop(0.00023453271, 3.54023522184, 735.87651353180),
				new Vsop87.LnVsop(0.00022283743, 4.19362594399,
						1589.07289528380),
				new Vsop87.LnVsop(0.00023947298, 0.27458037480, 7.11354700080),
				new Vsop87.LnVsop(0.00013032614, 2.96042965363,
						1162.47470440780),
				new Vsop87.LnVsop(0.00009703360, 1.90669633585, 206.18554843720),
				new Vsop87.LnVsop(0.00012749023, 2.71550286592,
						1052.26838318840),
				new Vsop87.LnVsop(0.00009161393, 4.41352953117, 213.29909543800),
				new Vsop87.LnVsop(0.00007894511, 2.47907592482, 426.59819087600),
				new Vsop87.LnVsop(0.00007057931, 2.18184839926,
						1265.56747862640),
				new Vsop87.LnVsop(0.00006137703, 6.26418240033, 846.08283475120),
				new Vsop87.LnVsop(0.00005477001, 5.65729989857, 639.89728631400),
				new Vsop87.LnVsop(0.00003502493, 0.56532365822,
						1066.49547719000),
				new Vsop87.LnVsop(0.00004136822, 2.72220872400, 625.67019231240),
				new Vsop87.LnVsop(0.00004169954, 2.01603822251, 515.46387109300),
				new Vsop87.LnVsop(0.00002499967, 4.55181655381, 838.96928775040),
				new Vsop87.LnVsop(0.00002616976, 2.00994012876,
						1581.95934828300),
				new Vsop87.LnVsop(0.00001912009, 0.85621128851, 412.37109687440),
				new Vsop87.LnVsop(0.00002127681, 6.12755221002, 742.99006053260),
				new Vsop87.LnVsop(0.00001610567, 3.08871452594,
						1368.66025284500),
				new Vsop87.LnVsop(0.00001479513, 2.68021307468,
						1478.86657406440),
				new Vsop87.LnVsop(0.00001230630, 1.89052048109, 323.50541665740),
				new Vsop87.LnVsop(0.00001216895, 1.80176263029, 110.20632121940),
				new Vsop87.LnVsop(0.00000961113, 4.54876995367,
						2118.76386037840),
				new Vsop87.LnVsop(0.00000885764, 4.14783869943, 533.62311835770),
				new Vsop87.LnVsop(0.00000776583, 3.67710828843, 728.76296653100),
				new Vsop87.LnVsop(0.00000998591, 2.87205397992, 309.27832265580),
				new Vsop87.LnVsop(0.00001014733, 1.38675822271, 454.90936652730),
				new Vsop87.LnVsop(0.00000727156, 3.98827252563,
						1155.36115740700),
				new Vsop87.LnVsop(0.00000655334, 2.79072596910,
						1685.05212250160),
				new Vsop87.LnVsop(0.00000821383, 1.59351544602,
						1898.35121793960),
				new Vsop87.LnVsop(0.00000620818, 4.82275194351, 956.28915597060),
				new Vsop87.LnVsop(0.00000654071, 3.38140746852,
						1692.16566950240),
				new Vsop87.LnVsop(0.00000811993, 5.94093410097, 909.81873305460),
				new Vsop87.LnVsop(0.00000562092, 0.08114877791, 543.91805909620),
				new Vsop87.LnVsop(0.00000542222, 0.28357235311, 525.75881183150),
				new Vsop87.LnVsop(0.00000457841, 0.12720499202,
						1375.77379984580),
				new Vsop87.LnVsop(0.00000614740, 2.27633681284, 942.06206196900),
				new Vsop87.LnVsop(0.00000435816, 2.60279250213, 95.97922721780),
				new Vsop87.LnVsop(0.00000496009, 5.53020241869, 380.12776796000),
				new Vsop87.LnVsop(0.00000469974, 2.81883756859,
						1795.25844372100),
				new Vsop87.LnVsop(0.00000445057, 0.14648640292, 14.22709400160),
				new Vsop87.LnVsop(0.00000290917, 3.89373030829,
						1471.75302706360),
				new Vsop87.LnVsop(0.00000276581, 2.52188912681,
						2001.44399215820),
				new Vsop87.LnVsop(0.00000275010, 2.98827073289, 526.50957135690),
				new Vsop87.LnVsop(0.00000293746, 2.04945754349, 199.07200143640),
				new Vsop87.LnVsop(0.00000291010, 6.03128127682,
						1169.58825140860),
				new Vsop87.LnVsop(0.00000338146, 2.79887096517,
						1045.15483618760),
				new Vsop87.LnVsop(0.00000257472, 6.13406653083, 532.87235883230),
				new Vsop87.LnVsop(0.00000319036, 1.34818583641,
						2214.74308759620),
				new Vsop87.LnVsop(0.00000309305, 5.36839401116,
						1272.68102562720),
				new Vsop87.LnVsop(0.00000345803, 1.56404960644, 491.55792945680),
				new Vsop87.LnVsop(0.00000303364, 1.15407454389,
						5753.38488489680),
				new Vsop87.LnVsop(0.00000192308, 0.91996013364,
						1596.18644228460),
				new Vsop87.LnVsop(0.00000215435, 2.63589770012,
						2111.65031337760),
				new Vsop87.LnVsop(0.00000200591, 2.37332227687,
						1258.45393162560),
				new Vsop87.LnVsop(0.00000239039, 3.57396895042, 835.03713448730),
				new Vsop87.LnVsop(0.00000197072, 5.92862098187, 453.42489381900),
				new Vsop87.LnVsop(0.00000139406, 3.63978241621,
						1788.14489672020),
				new Vsop87.LnVsop(0.00000191351, 0.00008947898, 983.11585891360),
				new Vsop87.LnVsop(0.00000176442, 2.57642803889,
						9683.59458111640),
				new Vsop87.LnVsop(0.00000123523, 2.26101680855,
						2317.83586181480),
				new Vsop87.LnVsop(0.00000128191, 4.66615733627, 831.85574074960),
				new Vsop87.LnVsop(0.00000112538, 0.85603677104, 433.71173787680),
				new Vsop87.LnVsop(0.00000128822, 1.10499202918,
						2531.13495725280),
				new Vsop87.LnVsop(0.00000099327, 4.50365769161, 518.64526483070),
				new Vsop87.LnVsop(0.00000093945, 2.72470156299, 853.19638175200),
				new Vsop87.LnVsop(0.00000106425, 5.81491645745, 220.41264243880),
				new Vsop87.LnVsop(0.00000120294, 2.95204440510, 3.93215326310),
				new Vsop87.LnVsop(0.00000081685, 3.23399956574,
						1361.54670584420),
				new Vsop87.LnVsop(0.00000103994, 2.22277966661, 74.78159856730),
				new Vsop87.LnVsop(0.00000112513, 4.86217051434, 528.20649238630),
				new Vsop87.LnVsop(0.00000079631, 0.88529543139, 430.53034413910),
				new Vsop87.LnVsop(0.00000085789, 2.11469709334,
						1574.84580128220),
				new Vsop87.LnVsop(0.00000085635, 2.33825806277,
						2428.04218303420),
				new Vsop87.LnVsop(0.00000068348, 3.35769613854,
						2104.53676637680),
				new Vsop87.LnVsop(0.00000069535, 3.04092499583, 302.16477565500),
				new Vsop87.LnVsop(0.00000069854, 3.22383407236, 305.34616939270),
				new Vsop87.LnVsop(0.00000069498, 0.20470467419, 532.13864564940),
				new Vsop87.LnVsop(0.00000057002, 2.00278403070,
						2634.22773147140),
				new Vsop87.LnVsop(0.00000077019, 2.09814823113, 508.35032409220),
				new Vsop87.LnVsop(0.00000056672, 3.91635330750,
						2221.85663459700),
				new Vsop87.LnVsop(0.00000058366, 5.72512642459, 628.85158605010),
				new Vsop87.LnVsop(0.00000052433, 4.02508574580, 527.24328453980),
				new Vsop87.LnVsop(0.00000063628, 1.10008717069,
						1364.72809958190),
				new Vsop87.LnVsop(0.00000053607, 0.87404483378,
						2847.52682690940),
				new Vsop87.LnVsop(0.00000059639, 0.95858565273, 494.26624244250),
				new Vsop87.LnVsop(0.00000058002, 3.45633892143,
						2008.55753915900),
				new Vsop87.LnVsop(0.00000041530, 3.51955496522, 529.73914920440),
				new Vsop87.LnVsop(0.00000044717, 1.62318067555, 984.60033162190),
				new Vsop87.LnVsop(0.00000044943, 4.90105773635,
						2648.45482547300),
				new Vsop87.LnVsop(0.00000053154, 1.19752849531, 760.25553592000),
				new Vsop87.LnVsop(0.00000044532, 4.42376920441,
						1063.31408345230),
				new Vsop87.LnVsop(0.00000037511, 2.93024338067,
						1677.93857550080),
				new Vsop87.LnVsop(0.00000041535, 0.32174379070, 529.64278098480),
				new Vsop87.LnVsop(0.00000042886, 0.03097825861,
						1439.50969814920),
				new Vsop87.LnVsop(0.00000046010, 2.54409504187, 636.71589257630),
				new Vsop87.LnVsop(0.00000040307, 4.39482471634,
						1148.24761040620),
				new Vsop87.LnVsop(0.00000038818, 4.31684853535, 149.56319713460),
				new Vsop87.LnVsop(0.00000040357, 2.10207822074,
						2744.43405269080),
				new Vsop87.LnVsop(0.00000048851, 5.60297823445,
						2810.92146160520),
				new Vsop87.LnVsop(0.00000037030, 5.07904223157,
						1905.46476494040),
				new Vsop87.LnVsop(0.00000043876, 1.24634677337, 621.73803904930),
				new Vsop87.LnVsop(0.00000034015, 3.09481058565,
						2420.92863603340),
				new Vsop87.LnVsop(0.00000036829, 0.84237174099, 530.65417294110),
				new Vsop87.LnVsop(0.00000031256, 5.35795807657,
						1485.98012106520),
				new Vsop87.LnVsop(0.00000039276, 4.70909591065, 569.04784100980),
				new Vsop87.LnVsop(0.00000039790, 2.46062195592, 355.74874557180),
				new Vsop87.LnVsop(0.00000031530, 6.19283211825, 3.18139373770),
				new Vsop87.LnVsop(0.00000028366, 2.48520234303, 519.39602435610),
				new Vsop87.LnVsop(0.00000032409, 2.73383239343, 604.47256366190),
				new Vsop87.LnVsop(0.00000027094, 3.92463420595,
						2324.94940881560),
				new Vsop87.LnVsop(0.00000029014, 1.83523374921,
						1891.23767093880),
				new Vsop87.LnVsop(0.00000026731, 1.74874273361,
						2950.61960112800),
				new Vsop87.LnVsop(0.00000026453, 0.60429095482,
						1055.44977692610),
				new Vsop87.LnVsop(0.00000033475, 0.76463170350, 643.82943957710),
				new Vsop87.LnVsop(0.00000026499, 1.03248824966, 405.25754987360),
				new Vsop87.LnVsop(0.00000025634, 3.46480952342, 458.84151979040),
				new Vsop87.LnVsop(0.00000024450, 0.88074669554, 423.41679713830),
				new Vsop87.LnVsop(0.00000032957, 3.18606309728, 528.72775724810),
				new Vsop87.LnVsop(0.00000022463, 0.43478364259,
						1073.60902419080),
				new Vsop87.LnVsop(0.00000021623, 1.42192729492, 540.73666535850),
				new Vsop87.LnVsop(0.00000025640, 0.52452881258, 511.53171782990),
				new Vsop87.LnVsop(0.00000021016, 3.08217890882, 629.60234557550),
				new Vsop87.LnVsop(0.00000022666, 0.65441785872,
						3163.91869656600),
				new Vsop87.LnVsop(0.00000019316, 5.17023800333, 635.96513305090),
				new Vsop87.LnVsop(0.00000026139, 1.33354028131, 330.61896365820),
				new Vsop87.LnVsop(0.00000018303, 3.59973766130, 746.92221379570),
				new Vsop87.LnVsop(0.00000018225, 2.66424699243,
						1994.33044515740),
				new Vsop87.LnVsop(0.00000019775, 4.13615184912,
						1464.63948006280),
				new Vsop87.LnVsop(0.00000019466, 1.85632162779,
						3060.82592234740),
				new Vsop87.LnVsop(0.00000023930, 4.99825426891,
						1289.94650101460),
				new Vsop87.LnVsop(0.00000021865, 5.91688197848,
						1802.37199072180),
				new Vsop87.LnVsop(0.00000017423, 2.81999126875,
						2737.32050569000),
				new Vsop87.LnVsop(0.00000016669, 5.67299018075, 408.43894361130),
				new Vsop87.LnVsop(0.00000022940, 5.26760480260, 672.14061522840),
				new Vsop87.LnVsop(0.00000018349, 1.89870628722,
						1021.24889455140),
				new Vsop87.LnVsop(0.00000019065, 3.66520144826, 415.55249061210),
				new Vsop87.LnVsop(0.00000015733, 3.34757176872,
						1056.20053645150),
				new Vsop87.LnVsop(0.00000016361, 0.18155522601,
						1699.27921650320),
				new Vsop87.LnVsop(0.00000018718, 1.97821694809, 38.13303563780),
				new Vsop87.LnVsop(0.00000018769, 3.69167351769, 88.86568021700),
				new Vsop87.LnVsop(0.00000015530, 3.82369172511, 721.64941953020),
				new Vsop87.LnVsop(0.00000015401, 1.06319902793, 114.13847448250),
				new Vsop87.LnVsop(0.00000016809, 1.91000618622, 217.23124870110),
				new Vsop87.LnVsop(0.00000015253, 1.31927244263, 117.31986822020),
				new Vsop87.LnVsop(0.00000015115, 3.74899964992,
						2641.34127847220),
				new Vsop87.LnVsop(0.00000019654, 2.73391065610, 39.35687591520),
				new Vsop87.LnVsop(0.00000014669, 1.67269531093, 529.16970023280),
				new Vsop87.LnVsop(0.00000014116, 3.55112673348, 142.44965013380),
				new Vsop87.LnVsop(0.00000013001, 1.48488755301,
						3267.01147078460),
				new Vsop87.LnVsop(0.00000014924, 1.32583007552, 490.33408917940),
				new Vsop87.LnVsop(0.00000014753, 4.64530618099,
						6283.07584999140),
				new Vsop87.LnVsop(0.00000014666, 0.80451966905,
						5223.69391980220),
				new Vsop87.LnVsop(0.00000012149, 3.66755220800, 750.10360753340),
				new Vsop87.LnVsop(0.00000011954, 2.97127390765, 505.31194270640),
				new Vsop87.LnVsop(0.00000014697, 2.16792533244, 530.21222995640),
				new Vsop87.LnVsop(0.00000012272, 0.20695687447,
						1062.56332392690),
				new Vsop87.LnVsop(0.00000011491, 1.11749661877, 561.93429400900),
				new Vsop87.LnVsop(0.00000011727, 1.65922790150,
						2207.62954059540),
				new Vsop87.LnVsop(0.00000011081, 3.22060243425, 535.10759106600),
				new Vsop87.LnVsop(0.00000011566, 5.23036903534, 524.06189080210),
				new Vsop87.LnVsop(0.00000011187, 3.83842425050, 76.26607127560),
				new Vsop87.LnVsop(0.00000012702, 3.96823187752,
						2538.24850425360),
				new Vsop87.LnVsop(0.00000010918, 1.27796360308,
						2125.87740737920),
				new Vsop87.LnVsop(0.00000011242, 3.23197763125, 422.66603761290),
				new Vsop87.LnVsop(0.00000012640, 0.73683423677, 908.33426034630),
				new Vsop87.LnVsop(0.00000011310, 5.55879589444, 531.17543780290),
				new Vsop87.LnVsop(0.00000009584, 5.01019903321, 597.35901666110),
				new Vsop87.LnVsop(0.00000010310, 3.83872758066,
						1781.03134971940),
				new Vsop87.LnVsop(0.00000010762, 4.91380719453, 525.02509864860),
				new Vsop87.LnVsop(0.00000011756, 5.11238523418, 685.47393735270),
				new Vsop87.LnVsop(0.00000011958, 1.72875918561, 911.30320576290),
				new Vsop87.LnVsop(0.00000009511, 2.95053004168,
						1382.88734684660),
				new Vsop87.LnVsop(0.00000008902, 2.40357723787,
						2310.72231481400),
				new Vsop87.LnVsop(0.00000009215, 2.57853098079,
						3053.71237534660),
				new Vsop87.LnVsop(0.00000009920, 0.43817210648,
						3480.31056622260),
				new Vsop87.LnVsop(0.00000008714, 3.67018202505, 739.80866679490),
				new Vsop87.LnVsop(0.00000008664, 2.70398612383, 526.77020378780),
				new Vsop87.LnVsop(0.00000009435, 1.61939988249,
						3377.21779200400),
				new Vsop87.LnVsop(0.00000011544, 1.59031375667,
						1474.67378837040),
				new Vsop87.LnVsop(0.00000009532, 0.35524234217,
						1512.80682400820),
				new Vsop87.LnVsop(0.00000009993, 4.80140922781, 558.00214074590),
				new Vsop87.LnVsop(0.00000007969, 0.08480602718, 528.94020556920),
				new Vsop87.LnVsop(0.00000007929, 1.46877435816, 963.40270297140),
				new Vsop87.LnVsop(0.00000008877, 1.21758319481, 416.30325013750),
				new Vsop87.LnVsop(0.00000008738, 5.29236760592, 945.24345570670),
				new Vsop87.LnVsop(0.00000008611, 1.13232641062, 532.61172640140),
				new Vsop87.LnVsop(0.00000007852, 6.26908468547, 647.01083331480),
				new Vsop87.LnVsop(0.00000007581, 2.90608705953, 533.88375078860),
				new Vsop87.LnVsop(0.00000008585, 6.06648047796,
						10213.28554621100),
				new Vsop87.LnVsop(0.00000010150, 2.49061363606,
						1819.63746610920),
				new Vsop87.LnVsop(0.00000008534, 2.22687140541,
						9153.90361602180),
				new Vsop87.LnVsop(0.00000007968, 3.75535355212, 530.44172462000),
				new Vsop87.LnVsop(0.00000009742, 6.15792553288, 593.42686339800),
				new Vsop87.LnVsop(0.00000007137, 3.59005542659,
						2957.73314812880),
				new Vsop87.LnVsop(0.00000007176, 0.12508174554, 224.34479570190),
				new Vsop87.LnVsop(0.00000008727, 0.75644622066, 960.22130923370),
				new Vsop87.LnVsop(0.00000007073, 2.17418036839, 724.83081326790),
				new Vsop87.LnVsop(0.00000007193, 2.30068915654, 520.12973753900),
				new Vsop87.LnVsop(0.00000006555, 4.75218205387, 202.25339517410),
				new Vsop87.LnVsop(0.00000006417, 1.25043809621,
						3583.40334044120),
				new Vsop87.LnVsop(0.00000008270, 1.24822326308, 495.75071515080),
				new Vsop87.LnVsop(0.00000007123, 3.84780072799, 618.55664531160),
				new Vsop87.LnVsop(0.00000008145, 0.73137862078, 230.56457082540),
				new Vsop87.LnVsop(0.00000006151, 5.50130756047, 11.04570026390),
				new Vsop87.LnVsop(0.00000007972, 2.08176164007, 953.10776223290),
				new Vsop87.LnVsop(0.00000007652, 0.92748230521, 525.49817940060),
				new Vsop87.LnVsop(0.00000007432, 0.31435666835, 378.64329525170),
				new Vsop87.LnVsop(0.00000006222, 1.46220596893, 483.22054217860),
				new Vsop87.LnVsop(0.00000007153, 0.18772230606, 731.94436026870),
				new Vsop87.LnVsop(0.00000006706, 2.92078077444,
						1038.04128918680),
				new Vsop87.LnVsop(0.00000007309, 6.27084750121, 21.34064100240),
				new Vsop87.LnVsop(0.00000006129, 2.68322633435, 312.45971639350),
				new Vsop87.LnVsop(0.00000007541, 0.73440261131, 457.61767951300),
				new Vsop87.LnVsop(0.00000005558, 3.83419160288, 534.35683154060),
				new Vsop87.LnVsop(0.00000005343, 5.25360544458,
						1048.33622992530),
				new Vsop87.LnVsop(0.00000005341, 6.22288713664, 551.03160609700),
				new Vsop87.LnVsop(0.00000005613, 1.51210605952, 524.27433912320),
				new Vsop87.LnVsop(0.00000005478, 5.95887338334, 539.98590583310),
				new Vsop87.LnVsop(0.00000005216, 2.20381924871, 280.96714700450),
				new Vsop87.LnVsop(0.00000005056, 0.37387972537, 529.53090640020),
				new Vsop87.LnVsop(0.00000006202, 5.53800819472, 2.44768055480),
				new Vsop87.LnVsop(0.00000006261, 0.75330485783, 938.12990870590),
				new Vsop87.LnVsop(0.00000005419, 5.96993331731, 227.52618943960),
				new Vsop87.LnVsop(0.00000005710, 2.12868548085, 191.95845443560),
				new Vsop87.LnVsop(0.00000005218, 4.69335266854, 560.71045373160),
				new Vsop87.LnVsop(0.00000004840, 1.51601288645,
						2524.02141025200),
				new Vsop87.LnVsop(0.00000005738, 0.34249718209, 535.91074021810),
				new Vsop87.LnVsop(0.00000005056, 3.46671669992, 529.85102378900),
				new Vsop87.LnVsop(0.00000005409, 5.21471277042,
						1057.89745748090),
				new Vsop87.LnVsop(0.00000004734, 2.27733077170,
						3370.10424500320),
				new Vsop87.LnVsop(0.00000005220, 3.61280797725,
						2097.42321937600),
				new Vsop87.LnVsop(0.00000004861, 1.38856203056,
						3693.60966166060),
				new Vsop87.LnVsop(0.00000005738, 4.79777823324, 598.84348936940),
				new Vsop87.LnVsop(0.00000005690, 3.93800591227,
						2854.64037391020),
				new Vsop87.LnVsop(0.00000004988, 4.87228166876, 1.48447270830),
				new Vsop87.LnVsop(0.00000005424, 3.53268613904, 456.39383923560),
				new Vsop87.LnVsop(0.00000004289, 4.84380640711, 70.84944530420),
				new Vsop87.LnVsop(0.00000005944, 3.79180483544,
						25558.21217647960),
				new Vsop87.LnVsop(0.00000004189, 2.08145249041,
						2627.11418447060),
				new Vsop87.LnVsop(0.00000004549, 5.64074512699,
						2435.15573003500),
				new Vsop87.LnVsop(0.00000004268, 6.20250525407, 775.23338944700),
				new Vsop87.LnVsop(0.00000005405, 4.66492781581, 833.55266177900),
				new Vsop87.LnVsop(0.00000005607, 3.30270139804, 535.32003938710),
				new Vsop87.LnVsop(0.00000004171, 3.14858229862, 944.98282327580),
				new Vsop87.LnVsop(0.00000004128, 5.84804741359, 440.82528487760),
				new Vsop87.LnVsop(0.00000004387, 4.69677892021, 327.43756992050),
				new Vsop87.LnVsop(0.00000004468, 0.21348044420, 92.04707395470),
				new Vsop87.LnVsop(0.00000004052, 3.31367006050,
						3274.12501778540),
				new Vsop87.LnVsop(0.00000004375, 0.20464725158,
						3796.70243587920),
				new Vsop87.LnVsop(0.00000004301, 0.99845168304, 387.24131496080),
				new Vsop87.LnVsop(0.00000004703, 1.96435195092, 107.02492748170),
				new Vsop87.LnVsop(0.00000004213, 3.21377867882, 696.51963761660),
				new Vsop87.LnVsop(0.00000004014, 4.62540459805,
						2751.54759969160),
				new Vsop87.LnVsop(0.00000003824, 3.60290168808, 437.64389113990),
				new Vsop87.LnVsop(0.00000004183, 4.74495457566, 988.53248488500),
				new Vsop87.LnVsop(0.00000003687, 1.57511269436, 381.61224066830),
				new Vsop87.LnVsop(0.00000003808, 3.97513732318, 732.69511979410),
				new Vsop87.LnVsop(0.00000004134, 2.59512563472, 916.93228005540),
				new Vsop87.LnVsop(0.00000004905, 2.67946228179,
						1215.16490244730),
				new Vsop87.LnVsop(0.00000004340, 1.51432586300,
						1894.41906467650),
				new Vsop87.LnVsop(0.00000003490, 0.63097592112, 529.90341341570),
				new Vsop87.LnVsop(0.00000004179, 4.79066440364, 824.74219374880),
				new Vsop87.LnVsop(0.00000004126, 3.63856052239, 810.65811209910),
				new Vsop87.LnVsop(0.00000003701, 6.17676412880, 537.76771994190),
				new Vsop87.LnVsop(0.00000004355, 3.13180489048, 630.33605875840),
				new Vsop87.LnVsop(0.00000003315, 1.52493374102, 547.85021235930),
				new Vsop87.LnVsop(0.00000003490, 3.20962050417, 529.47851677350),
				new Vsop87.LnVsop(0.00000003555, 6.03691345521, 739.05790726950),
				new Vsop87.LnVsop(0.00000004099, 6.00401453177, 902.70518605380),
				new Vsop87.LnVsop(0.00000004004, 2.13540836634, 210.11770170030),
				new Vsop87.LnVsop(0.00000003295, 2.58083202302, 945.99421523210),
				new Vsop87.LnVsop(0.00000003270, 3.49304887352,
						1166.40685767090),
				new Vsop87.LnVsop(0.00000003994, 4.78250942681, 850.01498801430),
				new Vsop87.LnVsop(0.00000004240, 0.11161358607,
						1744.85586754190),
				new Vsop87.LnVsop(0.00000004002, 5.20683965697, 635.23141986800),
				new Vsop87.LnVsop(0.00000003115, 4.61995541904, 952.35700270750),
				new Vsop87.LnVsop(0.00000003003, 0.92689294845,
						3899.79521009780),
				new Vsop87.LnVsop(0.00000003241, 6.13636496944, 10.29494073850),
				new Vsop87.LnVsop(0.00000003219, 1.83595567094, 18.15924726470),
				new Vsop87.LnVsop(0.00000002983, 2.60087913786, 632.83192342300),
				new Vsop87.LnVsop(0.00000002967, 5.69894599757, 632.73555520340),
				new Vsop87.LnVsop(0.00000003168, 6.13783090971,
						1158.54255114470),
				new Vsop87.LnVsop(0.00000003226, 5.59957707360, 608.40471692500),
				new Vsop87.LnVsop(0.00000003122, 5.65071502170, 99.16062095550),
				new Vsop87.LnVsop(0.00000003761, 2.09239982789, 282.45161971280),
				new Vsop87.LnVsop(0.00000003356, 1.79147113193, 521.61421024730),
				new Vsop87.LnVsop(0.00000002838, 4.60179563689, 245.54242435240),
				new Vsop87.LnVsop(0.00000002715, 2.03270124891,
						1514.29129671650),
				new Vsop87.LnVsop(0.00000002643, 3.69017270026, 885.43971066640),
				new Vsop87.LnVsop(0.00000003057, 6.02461785861, 633.74694715970),
				new Vsop87.LnVsop(0.00000003048, 2.29027670842, 631.82053146670),
				new Vsop87.LnVsop(0.00000002782, 3.18187038682, 295.05122865420),
				new Vsop87.LnVsop(0.00000003015, 1.28347490089,
						1023.95720753710),
				new Vsop87.LnVsop(0.00000002632, 0.54069640678, 195.13984817330),
				new Vsop87.LnVsop(0.00000002559, 0.17635133075, 35.42472265210),
				new Vsop87.LnVsop(0.00000002714, 3.28872509961,
						2413.81508903260),
				new Vsop87.LnVsop(0.00000003249, 2.40881833627, 836.52160719560),
				new Vsop87.LnVsop(0.00000002451, 5.58559481110, 544.66881862160),
				new Vsop87.LnVsop(0.00000002535, 1.44414086617, 460.53844081980),
				new Vsop87.LnVsop(0.00000002441, 0.23204756934, 465.95506679120),
				new Vsop87.LnVsop(0.00000002410, 4.36768640011,
						1056.93424963440),
				new Vsop87.LnVsop(0.00000002452, 4.53818807914, 514.71311156760),
				new Vsop87.LnVsop(0.00000003237, 1.17006919872, 177.87437278590),
				new Vsop87.LnVsop(0.00000002333, 2.13962165652, 319.57326339430),
				new Vsop87.LnVsop(0.00000003217, 0.60541914081,
						1061.82961074400),
				new Vsop87.LnVsop(0.00000002398, 0.64110233160, 523.54062594030),
				new Vsop87.LnVsop(0.00000002638, 3.81178618526,
						3171.03224356680),
				new Vsop87.LnVsop(0.00000002791, 2.71505085086, 610.69233878540),
				new Vsop87.LnVsop(0.00000002729, 1.77752023407, 252.65597135320),
				new Vsop87.LnVsop(0.00000002681, 0.09370791758, 565.11568774670),
				new Vsop87.LnVsop(0.00000002209, 0.54839208938,
						2228.97018159780),
				new Vsop87.LnVsop(0.00000002312, 2.07210502831,
						3686.49611465980),
				new Vsop87.LnVsop(0.00000002683, 4.94305916877,
						1593.00504854690),
				new Vsop87.LnVsop(0.00000002526, 1.07528597373,
						12036.46073488820),
				new Vsop87.LnVsop(0.00000002268, 0.36783878457,
						1969.20066324380),
				new Vsop87.LnVsop(0.00000002688, 1.51547910962, 447.79581952650),
				new Vsop87.LnVsop(0.00000002235, 5.95475282699,
						6151.53388830500),
				new Vsop87.LnVsop(0.00000002710, 4.64908513849, 462.02291352810),
				new Vsop87.LnVsop(0.00000002334, 4.47618012518, 209.36694217490),
				new Vsop87.LnVsop(0.00000002175, 4.53588570240, 501.37978944330),
				new Vsop87.LnVsop(0.00000002335, 5.92743690508, 611.44309831080),
				new Vsop87.LnVsop(0.00000002384, 2.81746623044,
						3340.61242669980),
				new Vsop87.LnVsop(0.00000002075, 3.13164231864,
						1049.08698945070),
				new Vsop87.LnVsop(0.00000002789, 1.27687797437,
						1041.22268292450),
				new Vsop87.LnVsop(0.00000002024, 1.80008813939,
						2943.50605412720),
				new Vsop87.LnVsop(0.00000002039, 4.67544543631, 679.25416222920),
				new Vsop87.LnVsop(0.00000002748, 1.97292590154, 415.29185818120),
				new Vsop87.LnVsop(0.00000001993, 2.02503599030,
						1058.86066532740),
				new Vsop87.LnVsop(0.00000002293, 2.99171378261, 69.15252427480),
				new Vsop87.LnVsop(0.00000002083, 1.11198641001,
						4010.00153131720),
				new Vsop87.LnVsop(0.00000002018, 0.04630518303,
						4113.09430553580),
				new Vsop87.LnVsop(0.00000001930, 3.34507193410, 421.93232443000),
				new Vsop87.LnVsop(0.00000002153, 2.17059512290,
						1269.49963188950),
				new Vsop87.LnVsop(0.00000001928, 1.15367163096,
						1060.34513803570),
				new Vsop87.LnVsop(0.00000002336, 1.96332360970,
						1279.79457262800),
				new Vsop87.LnVsop(0.00000002201, 2.94451315794, 429.04587143080),
				new Vsop87.LnVsop(0.00000001939, 3.22015613937,
						3590.51688744200),
				new Vsop87.LnVsop(0.00000001843, 5.23293157757, 14.97785352700),
				new Vsop87.LnVsop(0.00000001930, 5.46749050005,
						2281.23049651060),
				new Vsop87.LnVsop(0.00000002171, 2.83736293048, 292.01284726840),
				new Vsop87.LnVsop(0.00000002125, 0.06224847813, 24.37902238820),
				new Vsop87.LnVsop(0.00000001938, 3.79909584528,
						1059.43011429900),
				new Vsop87.LnVsop(0.00000002157, 3.89303145878, 451.94042111070),
				new Vsop87.LnVsop(0.00000002029, 3.95461045826, 771.30123618390),
				new Vsop87.LnVsop(0.00000001784, 1.49468287576, 529.95159752550),
				new Vsop87.LnVsop(0.00000001815, 4.78077969800, 78.71375183040),
				new Vsop87.LnVsop(0.00000001748, 3.48730020953, 522.62560220360),
				new Vsop87.LnVsop(0.00000001759, 0.41344084540, 754.03576079650),
				new Vsop87.LnVsop(0.00000001816, 1.24334711210, 417.03696332040),
				new Vsop87.LnVsop(0.00000001942, 1.95782403724, 934.94851496820),
				new Vsop87.LnVsop(0.00000001809, 3.51500010497,
						1354.43315884340),
				new Vsop87.LnVsop(0.00000001766, 5.76140570543, 623.22251175760),
				new Vsop87.LnVsop(0.00000002346, 5.38154028450,
						1261.63532536330),
				new Vsop87.LnVsop(0.00000002158, 3.45672748590, 827.92358748650),
				new Vsop87.LnVsop(0.00000001690, 2.68085848682, 642.34496686880),
				new Vsop87.LnVsop(0.00000001973, 1.04545877724, 33.94024994380),
				new Vsop87.LnVsop(0.00000001751, 3.13572498964, 384.05992122310),
				new Vsop87.LnVsop(0.00000001800, 5.45980392229,
						1201.83158032300),
				new Vsop87.LnVsop(0.00000001682, 6.10616525578, 432.01481684740),
				new Vsop87.LnVsop(0.00000001936, 3.00893936737, 567.82400073240),
				new Vsop87.LnVsop(0.00000002058, 3.08341203251, 535.84130424890),
				new Vsop87.LnVsop(0.00000001782, 5.03100165106,
						1098.73880610440),
				new Vsop87.LnVsop(0.00000001826, 2.13081844602, 99.91138048090),
				new Vsop87.LnVsop(0.00000002075, 3.18662095186,
						1366.21257229020),
				new Vsop87.LnVsop(0.00000002274, 5.17947578060,
						3178.14579056760),
				new Vsop87.LnVsop(0.00000001706, 3.09150223641,
						1251.34038462480),
				new Vsop87.LnVsop(0.00000002242, 1.74102512909,
						1151.42900414390),
				new Vsop87.LnVsop(0.00000001613, 3.16800255751, 67.66805156650),
				new Vsop87.LnVsop(0.00000001715, 5.04087524117, 586.31331639720),
				new Vsop87.LnVsop(0.00000001609, 5.65561775211,
						1165.65609814550),
				new Vsop87.LnVsop(0.00000001680, 3.07291090659,
						1134.16352875650),
				new Vsop87.LnVsop(0.00000001994, 2.52023134686,
						1059.90319505100),
				new Vsop87.LnVsop(0.00000002154, 6.16996906006, 563.63121503840),
				new Vsop87.LnVsop(0.00000001703, 0.99422663808,
						1254.52177836250),
				new Vsop87.LnVsop(0.00000001748, 3.47238840628,
						1058.41872234270),
				new Vsop87.LnVsop(0.00000001865, 1.62280773417, 5.41662597140),
				new Vsop87.LnVsop(0.00000001886, 5.58469840330, 32.24332891440),
				new Vsop87.LnVsop(0.00000001559, 0.38338275068, 313.21047591890),
				new Vsop87.LnVsop(0.00000001673, 4.16553276624, 106.27416795630),
				new Vsop87.LnVsop(0.00000001624, 3.47283697724,
						1159.29331067010),
				new Vsop87.LnVsop(0.00000001552, 3.04262360186, 385.54439393140),
				new Vsop87.LnVsop(0.00000001728, 2.12791034661, 306.83064210100),
				new Vsop87.LnVsop(0.00000001495, 1.43630114874,
						2840.41327990860),
				new Vsop87.LnVsop(0.00000001511, 4.44377608685, 395.10562148700),
				new Vsop87.LnVsop(0.00000001958, 0.05215107058, 761.74000862830),
				new Vsop87.LnVsop(0.00000001755, 1.27198192898,
						1173.52040467170),
				new Vsop87.LnVsop(0.00000001548, 0.44749208924,
						4216.18707975440),
				new Vsop87.LnVsop(0.00000001493, 2.79720044893, 277.03499374140),
				new Vsop87.LnVsop(0.00000001636, 0.26199351490, 522.52923398400),
				new Vsop87.LnVsop(0.00000001569, 2.55719070621, 4.19278569400),
				new Vsop87.LnVsop(0.00000001466, 2.24427810064,
						1550.93985964600),
				new Vsop87.LnVsop(0.00000001858, 3.79797229590, 420.96911658350),
				new Vsop87.LnVsop(0.00000001915, 4.75826139824,
						3067.93946934820),
				new Vsop87.LnVsop(0.00000001684, 2.42057577614, 203.00415469950),
				new Vsop87.LnVsop(0.00000001784, 2.34591354953, 529.43033266370),
				new Vsop87.LnVsop(0.00000001938, 0.60127744372,
						1059.33374607940),
				new Vsop87.LnVsop(0.00000001804, 5.16348161105,
						1578.02719501990),
				new Vsop87.LnVsop(0.00000001371, 3.54043412257, 5.62907429250),
				new Vsop87.LnVsop(0.00000001362, 6.04117291776, 0.96320784650),
				new Vsop87.LnVsop(0.00000001361, 0.45533257707, 418.52143602870),
				new Vsop87.LnVsop(0.00000001494, 5.65499635123, 373.01422095920),
				new Vsop87.LnVsop(0.00000001840, 4.24679354047, 981.63138620530),
				new Vsop87.LnVsop(0.00000001567, 3.32429870195, 532.39927808030),
				new Vsop87.LnVsop(0.00000001405, 1.78978994642,
						4002.88798431640),
				new Vsop87.LnVsop(0.00000001340, 1.94668282270, 528.41894070740),
				new Vsop87.LnVsop(0.00000001745, 5.76913240451, 490.07345674850),
				new Vsop87.LnVsop(0.00000001472, 2.98912826857,
						2730.20695868920),
				new Vsop87.LnVsop(0.00000001437, 4.19470227783, 420.44785172170),
				new Vsop87.LnVsop(0.00000001303, 0.66473988441, 173.94221952280),
				new Vsop87.LnVsop(0.00000001578, 3.90273683089, 602.98809095360),
				new Vsop87.LnVsop(0.00000001335, 5.58590962636,
						1276.61317889030),
				new Vsop87.LnVsop(0.00000001385, 3.88479835656, 419.43645976540),
				new Vsop87.LnVsop(0.00000001663, 3.94564005698,
						2274.54683263650),
				new Vsop87.LnVsop(0.00000001351, 0.81710478493,
						1585.14074202070),
				new Vsop87.LnVsop(0.00000001491, 1.66541765776,
						2655.56837247380),
				new Vsop87.LnVsop(0.00000001353, 0.74889817664, 632.26247445140),
				new Vsop87.LnVsop(0.00000001331, 2.44677888034, 561.18353448360),
				new Vsop87.LnVsop(0.00000001291, 0.78974363945,
						1603.29998928540),
				new Vsop87.LnVsop(0.00000001659, 5.59776019266, 362.86229257260),
				new Vsop87.LnVsop(0.00000001513, 4.29754579983, 303.86169668440),
				new Vsop87.LnVsop(0.00000001227, 4.41715278426, 531.38788612400),
				new Vsop87.LnVsop(0.00000001213, 4.55260634893, 366.79444583570),
				new Vsop87.LnVsop(0.00000001521, 0.55776043586,
						1592.25428902150),
				new Vsop87.LnVsop(0.00000001220, 3.63029788040, 497.44763618020),
				new Vsop87.LnVsop(0.00000001333, 1.24847548771, 633.30500417500),
				new Vsop87.LnVsop(0.00000001540, 5.74134360983, 320.32402291970),
				new Vsop87.LnVsop(0.00000001212, 3.38335836048, 536.85269620520),
				new Vsop87.LnVsop(0.00000001245, 4.21639502753, 4.66586644600),
				new Vsop87.LnVsop(0.00000001358, 3.42385026423, 539.25219265020),
				new Vsop87.LnVsop(0.00000001482, 3.06076740133,
						1585.89150154610),
				new Vsop87.LnVsop(0.00000001552, 0.48480014971, 493.04240216510),
				new Vsop87.LnVsop(0.00000001462, 2.30628702663,
						1363.24362687360),
				new Vsop87.LnVsop(0.00000001180, 3.52707625131,
						1064.79855616060),
				new Vsop87.LnVsop(0.00000001406, 1.53810768058,
						1020.02505427400),
				new Vsop87.LnVsop(0.00000001415, 2.27798301933, 758.77106321170),
				new Vsop87.LnVsop(0.00000001336, 1.89387272380, 530.96298948180),
				new Vsop87.LnVsop(0.00000001485, 3.55629043627, 774.00954916960),
				new Vsop87.LnVsop(0.00000001247, 5.64344659992, 479.28838891550),
				new Vsop87.LnVsop(0.00000001106, 0.89453807282, 2.92076130680),
				new Vsop87.LnVsop(0.00000001227, 2.76228281324, 299.12639426920),
				new Vsop87.LnVsop(0.00000001086, 5.66285953861,
						1053.75285589670),
				new Vsop87.LnVsop(0.00000001091, 2.82244505598,
						1262.38608488870),
				new Vsop87.LnVsop(0.00000001168, 3.65910636679,
						3487.42411322340),
				new Vsop87.LnVsop(0.00000001329, 0.16664094530, 536.75632798560),
				new Vsop87.LnVsop(0.00000001124, 5.88442602775,
						1060.86640289750),
				new Vsop87.LnVsop(0.00000001082, 4.51407359350, 528.25467649610),
				new Vsop87.LnVsop(0.00000001105, 1.93890691771, 244.31858407500),
				new Vsop87.LnVsop(0.00000001059, 1.55367109732, 536.28324723360),
				new Vsop87.LnVsop(0.00000001317, 4.06940092395, 799.61241183520),
				new Vsop87.LnVsop(0.00000001260, 5.75630215326, 527.99404406520),
				new Vsop87.LnVsop(0.00000001447, 0.65113178433,
						1091.62525910360),
				new Vsop87.LnVsop(0.00000001413, 4.71923061422,
						1141.13406340540),
				new Vsop87.LnVsop(0.00000001082, 5.60975006771, 531.12725369310),
				new Vsop87.LnVsop(0.00000001148, 3.27410230494,
						1035.00290780100),
				new Vsop87.LnVsop(0.00000001048, 4.64334530342, 124.43341522100),
				new Vsop87.LnVsop(0.00000001072, 0.48068438534,
						1058.63117066380),
				new Vsop87.LnVsop(0.00000001045, 4.66144812532, 521.82665856840),
				new Vsop87.LnVsop(0.00000001036, 1.68979485122,
						1070.42763045310),
				new Vsop87.LnVsop(0.00000001052, 4.72763208314, 913.75088631770),
				new Vsop87.LnVsop(0.00000001166, 4.97934379883, 450.97721326420),
				new Vsop87.LnVsop(0.00000001099, 3.13173940863,
						1482.79872732750),
				new Vsop87.LnVsop(0.00000001372, 4.87583487947, 842.90144101350),
				new Vsop87.LnVsop(0.00000001037, 2.95852835709,
						3906.90875709860),
				new Vsop87.LnVsop(0.00000001154, 3.71720602716, 81.75213321620),
				new Vsop87.LnVsop(0.00000001013, 0.92736137443, 429.77958461370),
				new Vsop87.LnVsop(0.00000001085, 3.19275725911, 151.04766984290),
				new Vsop87.LnVsop(0.00000001030, 0.01725208757, 391.17346822390),
				new Vsop87.LnVsop(0.00000001282, 4.75859233981, 600.54041039880),
				new Vsop87.LnVsop(0.00000000972, 0.96985712709,
						2332.06295581640),
				new Vsop87.LnVsop(0.00000001047, 0.99077301795, 337.73251065900),
				new Vsop87.LnVsop(0.00000000980, 3.28594540964,
						1379.70595310890),
				new Vsop87.LnVsop(0.00000000966, 1.62396322160,
						3259.89792378380),
				new Vsop87.LnVsop(0.00000001125, 2.23732263924, 523.09868295560),
				new Vsop87.LnVsop(0.00000000937, 0.90005698525, 576.16138801060),
				new Vsop87.LnVsop(0.00000001044, 3.52819283674, 530.58473697190),
				new Vsop87.LnVsop(0.00000001129, 4.87187369639, 874.39401040250),
				new Vsop87.LnVsop(0.00000001244, 0.80634178279, 419.53282798500),
				new Vsop87.LnVsop(0.00000000924, 2.35629391980,
						1912.57831194120),
				new Vsop87.LnVsop(0.00000001087, 3.21065829760,
						6681.22485339960),
				new Vsop87.LnVsop(0.00000000920, 3.01896006307,
						1372.59240610810),
				new Vsop87.LnVsop(0.00000000914, 4.34560268499,
						1127.04998175570),
				new Vsop87.LnVsop(0.00000000931, 5.56146061492, 537.55527162080),
				new Vsop87.LnVsop(0.00000000912, 2.25878214021,
						1467.82087380050),
				new Vsop87.LnVsop(0.00000001202, 1.77363593153,
						5120.60114558360),
				new Vsop87.LnVsop(0.00000001025, 6.08315999637, 469.88722005430),
				new Vsop87.LnVsop(0.00000000887, 5.53922649066, 498.67147645760),
				new Vsop87.LnVsop(0.00000000888, 3.38270405256, 812.14258480740),
				new Vsop87.LnVsop(0.00000001027, 1.64373259126,
						1493.09366806600),
				new Vsop87.LnVsop(0.00000001153, 5.20213407672, 554.06998748280),
				new Vsop87.LnVsop(0.00000001044, 0.31244551729, 528.79719321730),
				new Vsop87.LnVsop(0.00000001197, 3.12884590029,
						1966.23171782720),
				new Vsop87.LnVsop(0.00000000970, 2.29596237496, 100.64509366380),
				new Vsop87.LnVsop(0.00000000930, 2.88178471502,
						1056.46116888240),
				new Vsop87.LnVsop(0.00000001052, 1.69484089706, 484.44438245600),
				new Vsop87.LnVsop(0.00000000847, 3.25831322794,
						1063.57471588320),
				new Vsop87.LnVsop(0.00000001137, 4.02029739425,
						1670.07426897460),
				new Vsop87.LnVsop(0.00000000864, 2.69234571372, 31.01948863700),
				new Vsop87.LnVsop(0.00000000906, 6.05494155026, 446.31134681820),
				new Vsop87.LnVsop(0.00000000860, 4.78175008217, 530.91480537200),
				new Vsop87.LnVsop(0.00000000939, 3.51238251326, 523.47118997110),
				new Vsop87.LnVsop(0.00000000860, 5.34207357904, 528.46712481720),
				new Vsop87.LnVsop(0.00000000876, 0.87683423308,
						4326.39340097380),
				new Vsop87.LnVsop(0.00000000819, 3.57201959303, 451.72797278960),
				new Vsop87.LnVsop(0.00000000824, 0.66291575747,
						20426.57109242200),
				new Vsop87.LnVsop(0.00000000849, 3.23256854293,
						1670.82502850000),
				new Vsop87.LnVsop(0.00000000820, 5.73661004927, 594.65070367540),
				new Vsop87.LnVsop(0.00000001116, 1.22881167024,
						1489.91227432830),
				new Vsop87.LnVsop(0.00000000868, 0.80016386644,
						2042.49778910280),
				new Vsop87.LnVsop(0.00000000880, 4.22241993782,
						1884.12412393800),
				new Vsop87.LnVsop(0.00000000835, 5.37311812708,
						5621.84292321040),
				new Vsop87.LnVsop(0.00000000974, 3.67667471757,
						25565.32572348040),
				new Vsop87.LnVsop(0.00000000788, 0.51622458293, 526.98265210890),
				new Vsop87.LnVsop(0.00000000895, 2.77465005384,
						3046.59882834580),
				new Vsop87.LnVsop(0.00000000849, 4.31414424046, 806.72595883600),
				new Vsop87.LnVsop(0.00000000925, 0.55478184950, 627.36711334180),
				new Vsop87.LnVsop(0.00000000920, 6.26573335293, 700.45179087970),
				new Vsop87.LnVsop(0.00000000892, 2.67011158629, 946.72792841500),
				new Vsop87.LnVsop(0.00000000846, 5.90640854756,
						1087.69310584050),
				new Vsop87.LnVsop(0.00000000948, 0.77931728039,
						25551.09862947879),
				new Vsop87.LnVsop(0.00000000844, 0.00976249584, 628.59095361920),
				new Vsop87.LnVsop(0.00000000760, 1.12121829396, 683.18631549230),
				new Vsop87.LnVsop(0.00000000820, 1.58880252302,
						1025.44168024540),
				new Vsop87.LnVsop(0.00000000781, 1.86416466337, 629.86297800640),
				new Vsop87.LnVsop(0.00000000967, 3.20618313117,
						9050.81084180320),
				new Vsop87.LnVsop(0.00000000805, 0.08389717815,
						4532.57894941100),
				new Vsop87.LnVsop(0.00000000919, 5.60009343497, 498.19839570560),
				new Vsop87.LnVsop(0.00000000738, 2.64976372130,
						1012.91150727320),
				new Vsop87.LnVsop(0.00000000738, 5.90389531154, 701.93626358800),
				new Vsop87.LnVsop(0.00000000741, 3.06795481071,
						5481.75455838080),
				new Vsop87.LnVsop(0.00000000725, 2.81220410314,
						3597.63043444280),
				new Vsop87.LnVsop(0.00000000878, 1.02427130092,
						5760.49843189760),
				new Vsop87.LnVsop(0.00000000721, 5.29574036514,
						1304.92435454160),
				new Vsop87.LnVsop(0.00000000994, 5.16391370100,
						10316.37832042960),
				new Vsop87.LnVsop(0.00000000890, 4.10819809661,
						1060.13268971460),
				new Vsop87.LnVsop(0.00000000830, 0.30961042231,
						1123.11782849260),
				new Vsop87.LnVsop(0.00000000962, 1.48376004518,
						1062.30269149600),
				new Vsop87.LnVsop(0.00000000823, 3.22228477513, 121.25202148330),
				new Vsop87.LnVsop(0.00000000916, 6.02908368648, 7.86430652620),
				new Vsop87.LnVsop(0.00000000725, 2.18809065860,
						1176.70179840940),
				new Vsop87.LnVsop(0.00000000861, 4.41932623043,
						5746.27133789600),
				new Vsop87.LnVsop(0.00000000854, 5.47701506544,
						2818.03500860600),
				new Vsop87.LnVsop(0.00000000709, 1.09852456494, 248.72381809010),
				new Vsop87.LnVsop(0.00000000856, 2.58042139486,
						2803.80791460440),
				new Vsop87.LnVsop(0.00000000734, 0.11633686168, 635.70450062000),
				new Vsop87.LnVsop(0.00000000727, 1.56150632966,
						4319.27985397300),
				new Vsop87.LnVsop(0.00000000687, 2.65370734689,
						1567.73225428140),
				new Vsop87.LnVsop(0.00000000938, 0.34938672944,
						1140.38330388000),
				new Vsop87.LnVsop(0.00000000832, 5.14362006475,
						1054.71606374320),
				new Vsop87.LnVsop(0.00000000665, 1.87621123047, 103.14095832840),
				new Vsop87.LnVsop(0.00000000805, 2.65683001547, 63.73589830340),
				new Vsop87.LnVsop(0.00000000846, 1.47557828604, 898.77303279070),
				new Vsop87.LnVsop(0.00000000863, 3.98700238575, 686.95841006100),
				new Vsop87.LnVsop(0.00000000806, 4.64475158248, 533.83556667880),
				new Vsop87.LnVsop(0.00000000860, 1.45053114983,
						2199.76523406920),
				new Vsop87.LnVsop(0.00000000688, 5.69334026950, 525.54636351040),
				new Vsop87.LnVsop(0.00000000859, 5.32386044216,
						1542.60247236780),
				new Vsop87.LnVsop(0.00000000668, 4.93815253692,
						5172.47623572500),
				new Vsop87.LnVsop(0.00000000818, 1.41973280302, 580.09354127370),
				new Vsop87.LnVsop(0.00000000690, 0.80287056032, 977.48678462110),
				new Vsop87.LnVsop(0.00000000638, 4.21760246790,
						1064.04779663520),
				new Vsop87.LnVsop(0.00000000878, 2.58779583091, 782.34693644780),
				new Vsop87.LnVsop(0.00000000811, 1.30406622470,
						1055.18914449520),
				new Vsop87.LnVsop(0.00000000637, 6.13121700151,
						4752.99159184980),
				new Vsop87.LnVsop(0.00000000821, 3.89981918280, 986.08480433020),
				new Vsop87.LnVsop(0.00000000642, 1.86734510583,
						1053.96530421780),
				new Vsop87.LnVsop(0.00000000781, 1.18377747884, 987.30864460760),
				new Vsop87.LnVsop(0.00000000804, 1.90939160700, 707.56533788050),
				new Vsop87.LnVsop(0.00000000686, 0.27079898498, 11.77941344680),
				new Vsop87.LnVsop(0.00000000634, 3.43769853475, 650.94298657790),
				new Vsop87.LnVsop(0.00000000639, 1.86699974431,
						6172.86952877200),
				new Vsop87.LnVsop(0.00000000620, 2.55561598450,
						1049.82070263360),
				new Vsop87.LnVsop(0.00000000697, 4.18082589322, 1.69692102940),
				new Vsop87.LnVsop(0.00000000686, 2.51807576494, 638.41281360570),
				new Vsop87.LnVsop(0.00000000849, 5.56317630404,
						4429.48617519240),
				new Vsop87.LnVsop(0.00000000614, 6.19071579609, 738.32419408660),
				new Vsop87.LnVsop(0.00000000642, 1.70942182986,
						5230.80746680300),
				new Vsop87.LnVsop(0.00000000748, 3.63387486593, 73.29712585900),
				new Vsop87.LnVsop(0.00000000615, 5.38518078437, 835.78789401270),
				new Vsop87.LnVsop(0.00000000601, 0.90129977643, 711.49749114360),
				new Vsop87.LnVsop(0.00000000604, 5.44066125511, 632.03297978780),
				new Vsop87.LnVsop(0.00000000597, 3.03921014345, 6.95348830640),
				new Vsop87.LnVsop(0.00000000767, 4.49491439876,
						1457.52593306200),
				new Vsop87.LnVsop(0.00000000778, 3.08728745329, 441.57604440300),
				new Vsop87.LnVsop(0.00000000594, 2.87175682597, 633.53449883860),
				new Vsop87.LnVsop(0.00000000588, 0.08236113246,
						4164.31198961300),
				new Vsop87.LnVsop(0.00000000599, 4.13850666612, 733.42883297700),
				new Vsop87.LnVsop(0.00000000692, 6.10931942233, 12.74262129330),
				new Vsop87.LnVsop(0.00000000597, 6.13204711801, 7.27360569520),
				new Vsop87.LnVsop(0.00000000787, 1.98195319336, 860.30992875280),
				new Vsop87.LnVsop(0.00000000774, 4.82089328660, 951.62328952460),
				new Vsop87.LnVsop(0.00000000589, 0.30558911648, 153.49535039770),
				new Vsop87.LnVsop(0.00000000577, 3.84676656235, 767.36908292080),
				new Vsop87.LnVsop(0.00000000575, 4.50676079721,
						1230.14275597430),
				new Vsop87.LnVsop(0.00000000725, 2.73069387932, 6.15033915430),
				new Vsop87.LnVsop(0.00000000561, 3.87565914360, 135.33610313300),
				new Vsop87.LnVsop(0.00000000558, 3.36094471852,
						24498.83024629040),
				new Vsop87.LnVsop(0.00000000641, 4.90173124861, 991.71387862270),
				new Vsop87.LnVsop(0.00000000557, 3.45629457197,
						19896.88012732740),
				new Vsop87.LnVsop(0.00000000558, 1.17103892689,
						3576.28979344040),
				new Vsop87.LnVsop(0.00000000637, 6.08896653583, 46.47042291600),
				new Vsop87.LnVsop(0.00000000631, 5.65855415701, 661.09491496450),
				new Vsop87.LnVsop(0.00000000628, 2.32902331778, 501.23677709140),
				new Vsop87.LnVsop(0.00000000560, 3.57141429379,
						5333.90024102160),
				new Vsop87.LnVsop(0.00000000548, 3.03388113862, 7.16173111060),
				new Vsop87.LnVsop(0.00000000698, 2.05421230760,
						3156.80514956520),
				new Vsop87.LnVsop(0.00000000748, 0.29223355288, 313.94418910180),
				new Vsop87.LnVsop(0.00000000744, 2.33083237537, 620.25356634100),
				new Vsop87.LnVsop(0.00000000586, 5.68889329019,
						1587.58842257550),
				new Vsop87.LnVsop(0.00000000584, 6.10336975118, 7.06536289100),
				new Vsop87.LnVsop(0.00000000615, 4.72920786161,
						3384.33133900480),
				new Vsop87.LnVsop(0.00000000537, 1.52803865425,
						8094.52168583260),
				new Vsop87.LnVsop(0.00000000595, 1.89655724176, 113.38771495710),
				new Vsop87.LnVsop(0.00000000542, 3.28894870834,
						10103.07922499160),
				new Vsop87.LnVsop(0.00000000544, 0.69476773349,
						4642.78527063040),
				new Vsop87.LnVsop(0.00000000564, 0.72677136462,
						1059.22187149480),
				new Vsop87.LnVsop(0.00000000546, 0.45425690852,
						4694.00295470760),
				new Vsop87.LnVsop(0.00000000585, 2.82650088707, 344.70304530790),
				new Vsop87.LnVsop(0.00000000528, 2.32101188937, 949.22379307960),
				new Vsop87.LnVsop(0.00000000530, 4.99510636441,
						9264.10993724120),
				new Vsop87.LnVsop(0.00000000567, 5.13926871155, 288.08069400530),
				new Vsop87.LnVsop(0.00000000527, 5.40641191628, 949.12742486000),
				new Vsop87.LnVsop(0.00000000531, 0.16792029802,
						1080.72257119160),
				new Vsop87.LnVsop(0.00000000535, 1.42855602314, 9.56122755560),
				new Vsop87.LnVsop(0.00000000688, 0.46353180630, 842.15068148810),
				new Vsop87.LnVsop(0.00000000697, 4.99042365686, 12.53017297220),
				new Vsop87.LnVsop(0.00000000553, 5.23792586314, 528.04643369190),
				new Vsop87.LnVsop(0.00000000504, 2.58550284000,
						5378.66178416220),
				new Vsop87.LnVsop(0.00000000519, 3.10157097770,
						9161.01716302260),
				new Vsop87.LnVsop(0.00000000619, 3.71554817226,
						2090.30967237520),
				new Vsop87.LnVsop(0.00000000621, 3.98893673383, 409.92341631960),
				new Vsop87.LnVsop(0.00000000544, 1.05857942311,
						1438.02522544090),
				new Vsop87.LnVsop(0.00000000541, 3.07978704943,
						1446.62324515000),
				new Vsop87.LnVsop(0.00000000488, 5.26894402637,
						1751.53953141600),
				new Vsop87.LnVsop(0.00000000639, 2.98874052475,
						2349.32843120380),
				new Vsop87.LnVsop(0.00000000684, 2.97458993261, 298.23262239190),
				new Vsop87.LnVsop(0.00000000555, 3.57205235856,
						1144.31545714310),
				new Vsop87.LnVsop(0.00000000482, 1.84410406707,
						1077.54117745390),
				new Vsop87.LnVsop(0.00000000493, 2.66756696257, 849.26422848890),
				new Vsop87.LnVsop(0.00000000553, 5.31312350142, 531.33549649730),
				new Vsop87.LnVsop(0.00000000612, 1.26746376254, 878.32616366560),
				new Vsop87.LnVsop(0.00000000581, 5.77185453327, 745.43774108740),
				new Vsop87.LnVsop(0.00000000537, 3.67807254097, 605.95703637020),
				new Vsop87.LnVsop(0.00000000476, 3.28733354824, 734.91330568530),
				new Vsop87.LnVsop(0.00000000493, 3.73487080434, 131.40394986990),
				new Vsop87.LnVsop(0.00000000493, 1.24342391046,
						11506.76976979360),
				new Vsop87.LnVsop(0.00000000613, 3.84144928692,
						1065.01100448170),
				new Vsop87.LnVsop(0.00000000579, 0.02333971761,
						1069.67687092770),
				new Vsop87.LnVsop(0.00000000653, 2.40326963363, 657.16276170140),
				new Vsop87.LnVsop(0.00000000509, 0.70662672351,
						1570.91364801910),
				new Vsop87.LnVsop(0.00000000564, 3.81960833918,
						1059.54198888360),
				new Vsop87.LnVsop(0.00000000468, 3.50348554992,
						4841.85727206680),
				new Vsop87.LnVsop(0.00000000621, 4.58816416137, 105.54045477340),
				new Vsop87.LnVsop(0.00000000592, 0.99424149467, 920.86443331850),
				new Vsop87.LnVsop(0.00000000457, 2.38193571955, 990.22940591440),
				new Vsop87.LnVsop(0.00000000458, 5.94092303682, 513.22863885930),
				new Vsop87.LnVsop(0.00000000462, 1.09795189347, 100.17201291180),
				new Vsop87.LnVsop(0.00000000491, 1.28733237388, 247.23934538180),
				new Vsop87.LnVsop(0.00000000473, 5.02679239007, 103.04459010880),
				new Vsop87.LnVsop(0.00000000540, 0.54791737146,
						51646.11531805379),
				new Vsop87.LnVsop(0.00000000531, 0.30026207053, 912.78767847120),
				new Vsop87.LnVsop(0.00000000488, 5.32348416682,
						1432.39615114840),
				new Vsop87.LnVsop(0.00000000449, 3.02583472996,
						5901.23920225600),
				new Vsop87.LnVsop(0.00000000543, 2.98751942458,
						4223.30062675520),
				new Vsop87.LnVsop(0.00000000629, 2.75622390887, 334.55111692130),
				new Vsop87.LnVsop(0.00000000481, 3.63292807076,
						5584.84733259940),
				new Vsop87.LnVsop(0.00000000444, 4.61008831817, 546.15329132990),
				new Vsop87.LnVsop(0.00000000622, 2.29597570837,
						9999.98645077300),
				new Vsop87.LnVsop(0.00000000588, 5.46780291871, 668.20846196530),
				new Vsop87.LnVsop(0.00000000485, 0.74674429026, 736.83972137830),
				new Vsop87.LnVsop(0.00000000595, 3.78181802412,
						6386.16862421000),
				new Vsop87.LnVsop(0.00000000567, 0.38348819779, 737.36098624010),
				new Vsop87.LnVsop(0.00000000474, 3.37296965859,
						3803.81598288000),
				new Vsop87.LnVsop(0.00000000434, 2.64411689486, 748.40668650400),
				new Vsop87.LnVsop(0.00000000604, 0.87482329646,
						6069.77675455340),
				new Vsop87.LnVsop(0.00000000520, 2.12596982279, 906.84978763800),
				new Vsop87.LnVsop(0.00000000513, 5.10763567804,
						1090.40141882620),
				new Vsop87.LnVsop(0.00000000459, 4.06923787133,
						5216.58037280140),
				new Vsop87.LnVsop(0.00000000466, 2.29198238542,
						2225.78878786010),
				new Vsop87.LnVsop(0.00000000589, 0.74050145875,
						1291.43097372290),
				new Vsop87.LnVsop(0.00000000466, 2.43707405011,
						3362.99069800240),
				new Vsop87.LnVsop(0.00000000566, 0.59740900184, 350.33211960040),
				new Vsop87.LnVsop(0.00000000429, 2.46364296538,
						3914.02230409940),
				new Vsop87.LnVsop(0.00000000474, 5.19232279677, 857.12853501510),
				new Vsop87.LnVsop(0.00000000429, 0.59245436963,
						1065.60170531270),
				new Vsop87.LnVsop(0.00000000511, 2.44662587368,
						9690.70812811720),
				new Vsop87.LnVsop(0.00000000424, 1.67088834417, 148.07872442630),
				new Vsop87.LnVsop(0.00000000412, 3.29630633921, 7.32599532190),
				new Vsop87.LnVsop(0.00000000436, 1.40801830895, 995.64603188580),
				new Vsop87.LnVsop(0.00000000429, 2.13901349243,
						3473.19701922180),
				new Vsop87.LnVsop(0.00000000510, 4.29090556636,
						2545.36205125440),
				new Vsop87.LnVsop(0.00000000501, 5.84167833830,
						9676.48103411560),
				new Vsop87.LnVsop(0.00000000548, 6.03429743373,
						9367.20271145980),
				new Vsop87.LnVsop(0.00000000433, 0.43309624811, 735.82832942200),
				new Vsop87.LnVsop(0.00000000433, 5.93397926660,
						1688.23351623930),
				new Vsop87.LnVsop(0.00000000429, 2.18700390627,
						1357.61455258110),
				new Vsop87.LnVsop(0.00000000439, 0.44871247921, 512.42548970720),
				new Vsop87.LnVsop(0.00000000555, 1.00328633116, 141.22580985640),
				new Vsop87.LnVsop(0.00000000441, 3.06678924251,
						1475.68518032670),
				new Vsop87.LnVsop(0.00000000544, 2.22925308079,
						1440.99417085750),
				new Vsop87.LnVsop(0.00000000404, 3.51410520211,
						1329.30337692980),
				new Vsop87.LnVsop(0.00000000412, 5.87495245826, 6.90109867970),
				new Vsop87.LnVsop(0.00000000442, 5.37772982571, 104.05598206510),
				new Vsop87.LnVsop(0.00000000465, 1.93436756934,
						6275.96230299060),
				new Vsop87.LnVsop(0.00000000401, 2.90426785776,
						1987.21689815660),
				new Vsop87.LnVsop(0.00000000481, 6.21043578332, 683.98946464440),
				new Vsop87.LnVsop(0.00000000385, 0.13151986614, 970.51624997220),
				new Vsop87.LnVsop(0.00000000383, 6.02073818555,
						1268.74887236410),
				new Vsop87.LnVsop(0.00000000391, 2.81753436573,
						5798.14642803740),
				new Vsop87.LnVsop(0.00000000395, 0.22367886581,
						51116.42435295920),
				new Vsop87.LnVsop(0.00000000480, 3.89516556182, 967.33485623450),
				new Vsop87.LnVsop(0.00000000426, 3.81910977181, 546.95644048200),
				new Vsop87.LnVsop(0.00000000471, 6.24506463249, 946.46729598410),
				new Vsop87.LnVsop(0.00000000379, 1.14527123185,
						1059.59437851030),
				new Vsop87.LnVsop(0.00000000371, 6.15750793727, 509.24409596950),
				new Vsop87.LnVsop(0.00000000476, 4.40755251309,
						2200.51599359460),
				new Vsop87.LnVsop(0.00000000511, 5.53118344106,
						1128.53445446400), };

		private static final Vsop87.LnVsop[] jupiter_radius_r1 = {
				new Vsop87.LnVsop(0.01271801520, 2.64937512894, 529.69096509460),
				new Vsop87.LnVsop(0.00061661816, 3.00076460387,
						1059.38193018920),
				new Vsop87.LnVsop(0.00053443713, 3.89717383175, 522.57741809380),
				new Vsop87.LnVsop(0.00031185171, 4.88276958012, 536.80451209540),
				new Vsop87.LnVsop(0.00041390269, 0.00000000000, 0.00000000000),
				new Vsop87.LnVsop(0.00011847263, 2.41328764459, 419.48464387520),
				new Vsop87.LnVsop(0.00009166454, 4.75978553741, 7.11354700080),
				new Vsop87.LnVsop(0.00003175595, 2.79298354393, 103.09277421860),
				new Vsop87.LnVsop(0.00003203481, 5.21084121495, 735.87651353180),
				new Vsop87.LnVsop(0.00003403577, 3.34689633223,
						1589.07289528380),
				new Vsop87.LnVsop(0.00002599925, 3.63439058628, 206.18554843720),
				new Vsop87.LnVsop(0.00002412127, 1.46948314626, 426.59819087600),
				new Vsop87.LnVsop(0.00002806070, 3.74227009702, 515.46387109300),
				new Vsop87.LnVsop(0.00002676611, 4.33051702874,
						1052.26838318840),
				new Vsop87.LnVsop(0.00002100392, 3.92772817188, 639.89728631400),
				new Vsop87.LnVsop(0.00001646160, 5.30947626153,
						1066.49547719000),
				new Vsop87.LnVsop(0.00001641093, 4.41628521235, 625.67019231240),
				new Vsop87.LnVsop(0.00001049766, 3.16115576687, 213.29909543800),
				new Vsop87.LnVsop(0.00001024703, 2.55437897122, 412.37109687440),
				new Vsop87.LnVsop(0.00000740834, 2.17089042827,
						1162.47470440780),
				new Vsop87.LnVsop(0.00000806430, 2.67747285932, 632.78373931320),
				new Vsop87.LnVsop(0.00000676729, 6.24979690660, 838.96928775040),
				new Vsop87.LnVsop(0.00000468918, 4.70985711091, 543.91805909620),
				new Vsop87.LnVsop(0.00000444628, 0.40306241278, 323.50541665740),
				new Vsop87.LnVsop(0.00000567074, 4.57671527249, 742.99006053260),
				new Vsop87.LnVsop(0.00000415840, 5.36847472493, 728.76296653100),
				new Vsop87.LnVsop(0.00000484810, 2.46907968946, 949.17560896980),
				new Vsop87.LnVsop(0.00000337576, 3.16751996354, 956.28915597060),
				new Vsop87.LnVsop(0.00000401711, 4.60509281258, 309.27832265580),
				new Vsop87.LnVsop(0.00000347330, 4.68154619204, 14.22709400160),
				new Vsop87.LnVsop(0.00000260727, 5.34286862943, 846.08283475120),
				new Vsop87.LnVsop(0.00000220020, 4.84195212656,
						1368.66025284500),
				new Vsop87.LnVsop(0.00000203233, 5.60019394971,
						1155.36115740700),
				new Vsop87.LnVsop(0.00000246438, 3.92373109496, 942.06206196900),
				new Vsop87.LnVsop(0.00000183575, 4.26454732757, 95.97922721780),
				new Vsop87.LnVsop(0.00000197119, 3.70582665656,
						2118.76386037840),
				new Vsop87.LnVsop(0.00000179982, 4.40213614840, 532.87235883230),
				new Vsop87.LnVsop(0.00000195844, 3.75886519686, 199.07200143640),
				new Vsop87.LnVsop(0.00000200140, 4.43930806722,
						1045.15483618760),
				new Vsop87.LnVsop(0.00000170248, 4.84663902529, 526.50957135690),
				new Vsop87.LnVsop(0.00000146328, 6.12953407685, 533.62311835770),
				new Vsop87.LnVsop(0.00000133441, 1.32112984738, 110.20632121940),
				new Vsop87.LnVsop(0.00000132030, 4.51111768540, 525.75881183150),
				new Vsop87.LnVsop(0.00000123776, 2.04233591660,
						1478.86657406440),
				new Vsop87.LnVsop(0.00000121876, 4.40555373903,
						1169.58825140860),
				new Vsop87.LnVsop(0.00000115354, 4.46752336410,
						1581.95934828300),
				new Vsop87.LnVsop(0.00000098559, 5.72824115387,
						1596.18644228460),
				new Vsop87.LnVsop(0.00000091744, 4.53147949989,
						1685.05212250160),
				new Vsop87.LnVsop(0.00000110685, 3.62539004538,
						1272.68102562720),
				new Vsop87.LnVsop(0.00000080515, 4.11374100758,
						1258.45393162560),
				new Vsop87.LnVsop(0.00000079518, 2.71923662078,
						1692.16566950240),
				new Vsop87.LnVsop(0.00000100157, 5.24639992412,
						1265.56747862640),
				new Vsop87.LnVsop(0.00000077866, 5.56575552496,
						1471.75302706360),
				new Vsop87.LnVsop(0.00000085840, 0.07984103333, 831.85574074960),
				new Vsop87.LnVsop(0.00000082132, 3.80763065130, 508.35032409220),
				new Vsop87.LnVsop(0.00000055296, 0.35136399335, 316.39186965660),
				new Vsop87.LnVsop(0.00000052289, 5.53069765044, 433.71173787680),
				new Vsop87.LnVsop(0.00000055809, 4.75224156118, 302.16477565500),
				new Vsop87.LnVsop(0.00000050625, 4.85603624371,
						1375.77379984580),
				new Vsop87.LnVsop(0.00000043539, 4.94471526157,
						1361.54670584420),
				new Vsop87.LnVsop(0.00000042146, 1.22819828957, 853.19638175200),
				new Vsop87.LnVsop(0.00000037653, 4.26849585975,
						2001.44399215820),
				new Vsop87.LnVsop(0.00000049301, 4.01704532497, 220.41264243880),
				new Vsop87.LnVsop(0.00000038248, 5.33256180883,
						1788.14489672020),
				new Vsop87.LnVsop(0.00000035653, 1.76300235040,
						1795.25844372100),
				new Vsop87.LnVsop(0.00000036185, 3.85316960087,
						1574.84580128220),
				new Vsop87.LnVsop(0.00000029178, 5.16817654180, 3.93215326310),
				new Vsop87.LnVsop(0.00000025113, 4.33889766890, 519.39602435610),
				new Vsop87.LnVsop(0.00000024766, 2.72782261862, 405.25754987360),
				new Vsop87.LnVsop(0.00000027102, 6.09843304423,
						1148.24761040620),
				new Vsop87.LnVsop(0.00000022665, 0.19350039559, 380.12776796000),
				new Vsop87.LnVsop(0.00000020538, 4.32862762591, 3.18139373770),
				new Vsop87.LnVsop(0.00000019941, 4.63435849910,
						1677.93857550080),
				new Vsop87.LnVsop(0.00000019522, 5.10728297130,
						1073.60902419080),
				new Vsop87.LnVsop(0.00000018500, 3.76514376541,
						1485.98012106520),
				new Vsop87.LnVsop(0.00000018845, 5.05703372830,
						2104.53676637680),
				new Vsop87.LnVsop(0.00000016987, 4.02069213446,
						2317.83586181480),
				new Vsop87.LnVsop(0.00000016680, 5.43302879610, 88.86568021700),
				new Vsop87.LnVsop(0.00000015372, 2.91841323048,
						2008.55753915900),
				new Vsop87.LnVsop(0.00000014419, 3.63960739927, 628.85158605010),
				new Vsop87.LnVsop(0.00000014630, 5.51305730294, 721.64941953020),
				new Vsop87.LnVsop(0.00000018540, 6.02594081104, 330.61896365820),
				new Vsop87.LnVsop(0.00000013638, 4.88575627207, 629.60234557550),
				new Vsop87.LnVsop(0.00000013472, 1.38742780013, 518.64526483070),
				new Vsop87.LnVsop(0.00000015538, 2.93208280366,
						1905.46476494040),
				new Vsop87.LnVsop(0.00000012405, 1.58727793866,
						2111.65031337760),
				new Vsop87.LnVsop(0.00000012168, 3.37798229468, 635.96513305090),
				new Vsop87.LnVsop(0.00000011835, 4.08484570984,
						2648.45482547300),
				new Vsop87.LnVsop(0.00000011259, 4.62303293007, 636.71589257630),
				new Vsop87.LnVsop(0.00000014286, 2.74041502983,
						2221.85663459700),
				new Vsop87.LnVsop(0.00000011157, 3.54867395941,
						1891.23767093880),
				new Vsop87.LnVsop(0.00000013131, 5.83476507713,
						1464.63948006280),
				new Vsop87.LnVsop(0.00000011346, 2.57830184286, 511.53171782990),
				new Vsop87.LnVsop(0.00000010484, 0.49631744855, 453.42489381900),
				new Vsop87.LnVsop(0.00000009712, 4.39039807014,
						1994.33044515740),
				new Vsop87.LnVsop(0.00000010072, 2.75854126409, 423.41679713830),
				new Vsop87.LnVsop(0.00000008973, 4.79620568259,
						2420.92863603340),
				new Vsop87.LnVsop(0.00000008487, 5.15862241737,
						1056.20053645150),
				new Vsop87.LnVsop(0.00000008037, 3.72684449392,
						2634.22773147140),
				new Vsop87.LnVsop(0.00000008036, 1.28481352995,
						2428.04218303420),
				new Vsop87.LnVsop(0.00000008823, 1.84296748834, 750.10360753340),
				new Vsop87.LnVsop(0.00000008976, 4.81284969227,
						1062.56332392690),
				new Vsop87.LnVsop(0.00000008608, 4.53451403086, 21.34064100240),
				new Vsop87.LnVsop(0.00000009412, 4.34166457358,
						1802.37199072180),
				new Vsop87.LnVsop(0.00000006904, 5.96626034536, 540.73666535850),
				new Vsop87.LnVsop(0.00000007268, 4.98087083693,
						1699.27921650320),
				new Vsop87.LnVsop(0.00000007068, 4.99227057771,
						1055.44977692610),
				new Vsop87.LnVsop(0.00000007244, 4.97266787687,
						1898.35121793960),
				new Vsop87.LnVsop(0.00000006479, 1.40223433818, 422.66603761290),
				new Vsop87.LnVsop(0.00000006280, 3.64802738608, 621.73803904930),
				new Vsop87.LnVsop(0.00000006231, 4.45749513375, 551.03160609700),
				new Vsop87.LnVsop(0.00000006271, 6.13813110445,
						2125.87740737920),
				new Vsop87.LnVsop(0.00000006801, 2.92013819097,
						2324.94940881560),
				new Vsop87.LnVsop(0.00000005898, 2.58873003212, 569.04784100980),
				new Vsop87.LnVsop(0.00000006481, 4.58107849781,
						1038.04128918680),
				new Vsop87.LnVsop(0.00000006653, 5.54500062883,
						1781.03134971940),
				new Vsop87.LnVsop(0.00000007187, 3.02482572051, 416.30325013750),
				new Vsop87.LnVsop(0.00000005141, 6.21519498122, 963.40270297140),
				new Vsop87.LnVsop(0.00000005878, 4.23185657623, 539.98590583310),
				new Vsop87.LnVsop(0.00000005119, 0.06958852255,
						1063.31408345230),
				new Vsop87.LnVsop(0.00000005247, 0.16792912472, 117.31986822020),
				new Vsop87.LnVsop(0.00000005423, 4.93524030417, 835.03713448730),
				new Vsop87.LnVsop(0.00000006217, 3.87980766892, 191.95845443560),
				new Vsop87.LnVsop(0.00000004967, 1.34452103048,
						1382.88734684660),
				new Vsop87.LnVsop(0.00000004635, 4.63642027299, 643.82943957710),
				new Vsop87.LnVsop(0.00000004561, 3.37093181163,
						2207.62954059540),
				new Vsop87.LnVsop(0.00000004474, 4.07436890901,
						2310.72231481400),
				new Vsop87.LnVsop(0.00000004703, 4.55179426438,
						2737.32050569000),
				new Vsop87.LnVsop(0.00000004487, 1.48312334127, 408.43894361130),
				new Vsop87.LnVsop(0.00000004087, 1.12906821675, 415.55249061210),
				new Vsop87.LnVsop(0.00000005489, 5.62261637529, 618.55664531160),
				new Vsop87.LnVsop(0.00000004323, 4.60454457547, 647.01083331480),
				new Vsop87.LnVsop(0.00000003882, 4.09352825462, 430.53034413910),
				new Vsop87.LnVsop(0.00000003747, 3.41170997719,
						2950.61960112800),
				new Vsop87.LnVsop(0.00000003803, 2.19632996017, 534.35683154060),
				new Vsop87.LnVsop(0.00000003634, 1.03495466077,
						2744.43405269080),
				new Vsop87.LnVsop(0.00000004549, 4.21325324482, 227.52618943960),
				new Vsop87.LnVsop(0.00000003565, 4.11240029730, 440.82528487760),
				new Vsop87.LnVsop(0.00000003852, 1.14937815780, 74.78159856730),
				new Vsop87.LnVsop(0.00000003525, 4.27662025409, 10.29494073850),
				new Vsop87.LnVsop(0.00000003488, 5.33792561596, 458.84151979040),
				new Vsop87.LnVsop(0.00000004208, 2.38049728614,
						2538.24850425360),
				new Vsop87.LnVsop(0.00000004465, 0.18617267547, 824.74219374880),
				new Vsop87.LnVsop(0.00000003327, 5.51323389248, 739.80866679490),
				new Vsop87.LnVsop(0.00000003252, 2.68329422796, 561.93429400900),
				new Vsop87.LnVsop(0.00000003247, 4.88392621669, 295.05122865420),
				new Vsop87.LnVsop(0.00000003571, 4.64017933384,
						2214.74308759620),
				new Vsop87.LnVsop(0.00000003469, 4.34266924360, 305.34616939270),
				new Vsop87.LnVsop(0.00000003430, 3.34792668508, 149.56319713460),
				new Vsop87.LnVsop(0.00000003474, 2.75054677372,
						2641.34127847220),
				new Vsop87.LnVsop(0.00000003618, 5.30205670433,
						2097.42321937600),
				new Vsop87.LnVsop(0.00000002963, 1.32779700914, 611.44309831080),
				new Vsop87.LnVsop(0.00000002826, 0.91971516521, 984.60033162190),
				new Vsop87.LnVsop(0.00000003445, 1.63289286159, 525.02509864860),
				new Vsop87.LnVsop(0.00000002635, 5.25522783247, 532.13864564940),
				new Vsop87.LnVsop(0.00000002682, 4.24680441193,
						3053.71237534660),
				new Vsop87.LnVsop(0.00000002655, 3.18365951037, 527.24328453980),
				new Vsop87.LnVsop(0.00000002418, 4.23791881124, 217.23124870110),
				new Vsop87.LnVsop(0.00000002231, 4.23923472684, 739.05790726950),
				new Vsop87.LnVsop(0.00000002268, 5.52248110560, 524.27433912320),
				new Vsop87.LnVsop(0.00000002095, 4.85943251945,
						1049.08698945070),
				new Vsop87.LnVsop(0.00000002054, 5.38759557118, 142.44965013380),
				new Vsop87.LnVsop(0.00000002058, 3.79500539044,
						2627.11418447060),
				new Vsop87.LnVsop(0.00000002536, 3.95352520357, 210.11770170030),
				new Vsop87.LnVsop(0.00000002095, 5.76269812349, 529.64278098480),
				new Vsop87.LnVsop(0.00000002533, 5.82849252925, 732.69511979410),
				new Vsop87.LnVsop(0.00000002025, 4.20638434497, 945.99421523210),
				new Vsop87.LnVsop(0.00000002248, 1.61218306133, 604.47256366190),
				new Vsop87.LnVsop(0.00000001923, 4.75088270631, 535.10759106600),
				new Vsop87.LnVsop(0.00000001969, 5.49257949498,
						1439.50969814920),
				new Vsop87.LnVsop(0.00000001876, 3.26958300763,
						3267.01147078460),
				new Vsop87.LnVsop(0.00000002286, 2.93860898500, 76.26607127560),
				new Vsop87.LnVsop(0.00000002298, 2.67602302579, 760.25553592000),
				new Vsop87.LnVsop(0.00000002074, 5.85386852879, 532.61172640140),
				new Vsop87.LnVsop(0.00000002160, 3.89934769002,
						2435.15573003500),
				new Vsop87.LnVsop(0.00000001763, 3.18823524810,
						2524.02141025200),
				new Vsop87.LnVsop(0.00000001681, 0.78838681637,
						3060.82592234740),
				new Vsop87.LnVsop(0.00000002121, 0.41035912497,
						1279.79457262800),
				new Vsop87.LnVsop(0.00000001660, 2.34370903423, 528.72775724810),
				new Vsop87.LnVsop(0.00000001642, 4.07579944140, 731.94436026870),
				new Vsop87.LnVsop(0.00000002095, 2.67732367556, 529.73914920440),
				new Vsop87.LnVsop(0.00000001712, 4.29334392085, 724.83081326790),
				new Vsop87.LnVsop(0.00000001856, 2.76989081814, 952.35700270750),
				new Vsop87.LnVsop(0.00000001904, 2.48369702447,
						2957.73314812880),
				new Vsop87.LnVsop(0.00000002003, 5.04729621715,
						2413.81508903260),
				new Vsop87.LnVsop(0.00000001672, 0.28599461931, 454.90936652730),
				new Vsop87.LnVsop(0.00000001582, 5.84371262844, 547.85021235930),
				new Vsop87.LnVsop(0.00000001595, 1.18530166527, 38.13303563780),
				new Vsop87.LnVsop(0.00000001563, 3.02970693113, 945.24345570670),
				new Vsop87.LnVsop(0.00000001542, 1.12520322838,
						1021.24889455140),
				new Vsop87.LnVsop(0.00000001546, 0.38348247678, 319.57326339430),
				new Vsop87.LnVsop(0.00000001463, 0.61055082613, 312.45971639350),
				new Vsop87.LnVsop(0.00000001604, 3.50041190037, 934.94851496820),
				new Vsop87.LnVsop(0.00000001439, 4.26513521887, 526.77020378780),
				new Vsop87.LnVsop(0.00000001611, 5.24344469844,
						1354.43315884340),
				new Vsop87.LnVsop(0.00000001511, 5.49591876170, 81.75213321620),
				new Vsop87.LnVsop(0.00000001906, 3.78137493812, 953.10776223290),
				new Vsop87.LnVsop(0.00000001656, 6.09667089740, 530.65417294110),
				new Vsop87.LnVsop(0.00000001799, 5.83566265631, 909.81873305460),
				new Vsop87.LnVsop(0.00000001405, 4.32629307157,
						3178.14579056760),
				new Vsop87.LnVsop(0.00000001406, 4.05527527402,
						1158.54255114470),
				new Vsop87.LnVsop(0.00000001493, 3.29690433844,
						1041.22268292450),
				new Vsop87.LnVsop(0.00000001558, 1.51646768353, 902.70518605380),
				new Vsop87.LnVsop(0.00000001387, 2.52840497309, 530.44172462000),
				new Vsop87.LnVsop(0.00000001410, 0.07169032313, 490.33408917940),
				new Vsop87.LnVsop(0.00000001562, 1.86268966974, 437.64389113990),
				new Vsop87.LnVsop(0.00000001606, 4.27835003095,
						2531.13495725280),
				new Vsop87.LnVsop(0.00000001794, 6.21722587878, 18.15924726470),
				new Vsop87.LnVsop(0.00000001422, 3.98206620893,
						3370.10424500320),
				new Vsop87.LnVsop(0.00000001515, 0.17967750365,
						1141.13406340540),
				new Vsop87.LnVsop(0.00000001329, 5.84479773498, 387.24131496080),
				new Vsop87.LnVsop(0.00000001300, 0.29821177492, 597.35901666110),
				new Vsop87.LnVsop(0.00000001710, 2.23503932366,
						2854.64037391020),
				new Vsop87.LnVsop(0.00000001558, 6.17783174275, 983.11585891360),
				new Vsop87.LnVsop(0.00000001311, 3.75085875476,
						1165.65609814550),
				new Vsop87.LnVsop(0.00000001482, 0.83066678204, 529.16970023280),
				new Vsop87.LnVsop(0.00000001435, 0.23355762296, 860.30992875280),
				new Vsop87.LnVsop(0.00000001141, 3.46612877999, 483.22054217860),
				new Vsop87.LnVsop(0.00000001133, 2.81368303631, 124.43341522100),
				new Vsop87.LnVsop(0.00000001319, 4.88148483038,
						1251.34038462480),
				new Vsop87.LnVsop(0.00000001508, 3.48139955389,
						2751.54759969160),
				new Vsop87.LnVsop(0.00000001237, 0.90332265294, 916.93228005540),
				new Vsop87.LnVsop(0.00000001142, 5.61457234897, 337.73251065900),
				new Vsop87.LnVsop(0.00000001076, 5.49947769870,
						1585.89150154610),
				new Vsop87.LnVsop(0.00000001123, 1.45270581179, 533.88375078860),
				new Vsop87.LnVsop(0.00000001067, 5.29710936450,
						1159.29331067010),
				new Vsop87.LnVsop(0.00000001063, 3.52724300315,
						2943.50605412720),
				new Vsop87.LnVsop(0.00000001416, 5.18377634152,
						1592.25428902150),
				new Vsop87.LnVsop(0.00000001054, 1.67751055664, 497.44763618020),
				new Vsop87.LnVsop(0.00000001338, 3.48243389264, 107.02492748170),
				new Vsop87.LnVsop(0.00000001037, 3.12801094422, 70.84944530420),
				new Vsop87.LnVsop(0.00000001102, 4.18000348718, 203.00415469950),
				new Vsop87.LnVsop(0.00000001021, 5.62851625196,
						1603.29998928540),
				new Vsop87.LnVsop(0.00000000967, 2.80222742968,
						3583.40334044120),
				new Vsop87.LnVsop(0.00000001106, 4.86492659899,
						1166.40685767090),
				new Vsop87.LnVsop(0.00000001093, 3.23230823003, 447.79581952650),
				new Vsop87.LnVsop(0.00000001073, 0.35668643110,
						1593.00504854690),
				new Vsop87.LnVsop(0.00000001108, 2.42061915107, 106.27416795630),
				new Vsop87.LnVsop(0.00000001003, 3.80070721725, 99.91138048090),
				new Vsop87.LnVsop(0.00000000987, 2.44184933100,
						1048.33622992530),
				new Vsop87.LnVsop(0.00000000921, 0.12955317257,
						1070.42763045310),
				new Vsop87.LnVsop(0.00000001136, 2.26568590950, 525.49817940060),
				new Vsop87.LnVsop(0.00000000885, 4.25304247204, 114.13847448250),
				new Vsop87.LnVsop(0.00000001168, 2.68377982079, 209.36694217490),
				new Vsop87.LnVsop(0.00000000967, 4.47667348232,
						9676.48103411560),
				new Vsop87.LnVsop(0.00000000875, 0.22303452734, 460.53844081980),
				new Vsop87.LnVsop(0.00000001067, 4.72721946609,
						2730.20695868920),
				new Vsop87.LnVsop(0.00000001165, 1.56030440737, 630.33605875840),
				new Vsop87.LnVsop(0.00000000951, 0.49347419163, 842.90144101350),
				new Vsop87.LnVsop(0.00000000884, 4.75139536245, 960.22130923370),
				new Vsop87.LnVsop(0.00000001158, 5.50047449313, 224.34479570190),
				new Vsop87.LnVsop(0.00000000892, 2.26616982044, 327.43756992050),
				new Vsop87.LnVsop(0.00000000940, 0.06481852204, 746.92221379570),
				new Vsop87.LnVsop(0.00000000899, 1.78944295718, 4.66586644600),
				new Vsop87.LnVsop(0.00000000894, 3.06608347131,
						5746.27133789600),
				new Vsop87.LnVsop(0.00000000936, 5.35932787694,
						1585.14074202070),
				new Vsop87.LnVsop(0.00000000866, 1.40863222239, 202.25339517410),
				new Vsop87.LnVsop(0.00000000865, 2.85348523795, 938.12990870590),
				new Vsop87.LnVsop(0.00000000782, 0.49776082272,
						3377.21779200400),
				new Vsop87.LnVsop(0.00000000822, 4.08331963114, 501.23677709140),
				new Vsop87.LnVsop(0.00000000933, 0.30976125598, 685.47393735270),
				new Vsop87.LnVsop(0.00000001033, 2.47031686819,
						3274.12501778540),
				new Vsop87.LnVsop(0.00000000799, 2.08457026425,
						77734.01845962799),
				new Vsop87.LnVsop(0.00000001017, 5.24406833089, 842.15068148810),
				new Vsop87.LnVsop(0.00000000741, 1.32379374647, 530.21222995640),
				new Vsop87.LnVsop(0.00000000842, 3.39449778904, 484.44438245600),
				new Vsop87.LnVsop(0.00000000821, 0.48415264993, 850.01498801430),
				new Vsop87.LnVsop(0.00000000825, 3.48499388498, 498.67147645760),
				new Vsop87.LnVsop(0.00000000781, 1.03963400654, 373.01422095920),
				new Vsop87.LnVsop(0.00000000759, 3.82014111206,
						6283.07584999140),
				new Vsop87.LnVsop(0.00000000915, 2.89101498678, 462.02291352810),
				new Vsop87.LnVsop(0.00000000770, 0.27005681805,
						2655.56837247380),
				new Vsop87.LnVsop(0.00000000707, 5.77702928333, 429.77958461370),
				new Vsop87.LnVsop(0.00000000862, 5.01184578153,
						1567.73225428140),
				new Vsop87.LnVsop(0.00000000711, 4.82250918143, 11.77941344680),
				new Vsop87.LnVsop(0.00000000692, 2.63705354662, 6.59228213900),
				new Vsop87.LnVsop(0.00000000771, 3.87410612014,
						9690.70812811720),
				new Vsop87.LnVsop(0.00000000668, 1.79396450309, 775.23338944700),
				new Vsop87.LnVsop(0.00000000740, 3.39423131656, 99.16062095550),
				new Vsop87.LnVsop(0.00000000663, 5.27704405712,
						4532.57894941100),
				new Vsop87.LnVsop(0.00000000759, 5.45358686570,
						9683.59458111640),
				new Vsop87.LnVsop(0.00000000709, 3.71117647887,
						3686.49611465980),
				new Vsop87.LnVsop(0.00000000677, 4.27891183416,
						25028.52121138500),
				new Vsop87.LnVsop(0.00000000784, 5.33244311918, 827.92358748650),
				new Vsop87.LnVsop(0.00000000664, 6.08614002142,
						2281.23049651060),
				new Vsop87.LnVsop(0.00000000643, 1.40239510103,
						9161.01716302260),
				new Vsop87.LnVsop(0.00000000656, 0.60909845504, 835.78789401270),
				new Vsop87.LnVsop(0.00000000702, 6.10412979847,
						4635.67172362960),
				new Vsop87.LnVsop(0.00000000809, 4.19626489638,
						5753.38488489680),
				new Vsop87.LnVsop(0.00000000700, 4.95131303046,
						1670.82502850000),
				new Vsop87.LnVsop(0.00000000838, 4.51443146541,
						1069.67687092770),
				new Vsop87.LnVsop(0.00000000626, 4.38443691624, 5.41662597140),
				new Vsop87.LnVsop(0.00000000700, 3.78143557545,
						2818.03500860600),
				new Vsop87.LnVsop(0.00000000701, 4.28283847329,
						2803.80791460440),
				new Vsop87.LnVsop(0.00000000729, 4.62695452187,
						2228.97018159780),
				new Vsop87.LnVsop(0.00000000604, 3.05855704532,
						2840.41327990860),
				new Vsop87.LnVsop(0.00000000678, 2.45013730979,
						5760.49843189760),
				new Vsop87.LnVsop(0.00000000624, 0.61517599566,
						1176.70179840940),
				new Vsop87.LnVsop(0.00000000717, 1.82600293291,
						3171.03224356680),
				new Vsop87.LnVsop(0.00000000617, 5.74358811142,
						1061.82961074400),
				new Vsop87.LnVsop(0.00000000667, 4.22974611158,
						4539.69249641180),
				new Vsop87.LnVsop(0.00000000793, 5.96535561367,
						1457.52593306200),
				new Vsop87.LnVsop(0.00000000565, 0.99421817994,
						1894.41906467650),
				new Vsop87.LnVsop(0.00000000578, 2.13199559472, 313.21047591890),
				new Vsop87.LnVsop(0.00000000752, 0.46063700150, 635.23141986800),
				new Vsop87.LnVsop(0.00000000614, 0.15814341318,
						1493.09366806600),
				new Vsop87.LnVsop(0.00000000622, 1.98136818407,
						25565.32572348040),
				new Vsop87.LnVsop(0.00000000614, 2.48275371627,
						25551.09862947879),
				new Vsop87.LnVsop(0.00000000586, 4.17489084697,
						2847.52682690940),
				new Vsop87.LnVsop(0.00000000598, 5.29419256363, 565.11568774670),
				new Vsop87.LnVsop(0.00000000616, 2.08837621877, 10.03430830760),
				new Vsop87.LnVsop(0.00000000658, 2.41428707991, 195.13984817330),
				new Vsop87.LnVsop(0.00000000692, 3.13229025530, 7.63481186260),
				new Vsop87.LnVsop(0.00000000569, 3.52605667631,
						3067.93946934820),
				new Vsop87.LnVsop(0.00000000525, 3.21922961346,
						1098.73880610440),
				new Vsop87.LnVsop(0.00000000685, 4.18539472904, 46.47042291600),
				new Vsop87.LnVsop(0.00000000624, 2.07173693354, 121.25202148330),
				new Vsop87.LnVsop(0.00000000525, 1.47517891985, 446.31134681820),
				new Vsop87.LnVsop(0.00000000508, 2.13584300710, 1.69692102940),
				new Vsop87.LnVsop(0.00000000504, 5.65511769313,
						2332.06295581640),
				new Vsop87.LnVsop(0.00000000674, 1.47570122611,
						4694.00295470760),
				new Vsop87.LnVsop(0.00000000547, 0.28995741521, 113.38771495710),
				new Vsop87.LnVsop(0.00000000689, 2.98160755722, 11.04570026390),
				new Vsop87.LnVsop(0.00000000546, 4.51208004692,
						6275.96230299060),
				new Vsop87.LnVsop(0.00000000561, 1.84479899238, 92.04707395470),
				new Vsop87.LnVsop(0.00000000492, 4.83275232000,
						9492.14631500480),
				new Vsop87.LnVsop(0.00000000549, 4.34579166146,
						3046.59882834580),
				new Vsop87.LnVsop(0.00000000479, 1.70769710474,
						3281.23856478620),
				new Vsop87.LnVsop(0.00000000593, 5.86079640612, 524.06189080210),
				new Vsop87.LnVsop(0.00000000510, 2.62557031270, 529.85102378900),
				new Vsop87.LnVsop(0.00000000480, 0.30754294369, 528.94020556920),
				new Vsop87.LnVsop(0.00000000475, 4.16520247375,
						1151.42900414390),
				new Vsop87.LnVsop(0.00000000520, 4.53246652413, 531.17543780290),
				new Vsop87.LnVsop(0.00000000575, 3.53909947579,
						1056.93424963440),
				new Vsop87.LnVsop(0.00000000476, 5.35229226962, 560.71045373160),
				new Vsop87.LnVsop(0.00000000470, 4.95335116275, 7.86430652620),
				new Vsop87.LnVsop(0.00000000470, 6.26977555004,
						3693.60966166060),
				new Vsop87.LnVsop(0.00000000610, 6.20128372098,
						1884.12412393800),
				new Vsop87.LnVsop(0.00000000513, 4.19850316370,
						1057.89745748090),
				new Vsop87.LnVsop(0.00000000545, 1.19385752069,
						1514.29129671650),
				new Vsop87.LnVsop(0.00000000461, 0.16951411708,
						26087.90314157420),
				new Vsop87.LnVsop(0.00000000614, 5.42289673768,
						2090.30967237520),
				new Vsop87.LnVsop(0.00000000487, 3.71760211139, 447.93883187840),
				new Vsop87.LnVsop(0.00000000592, 2.91424148255,
						8624.21265092720),
				new Vsop87.LnVsop(0.00000000449, 5.24967420622,
						10213.28554621100),
				new Vsop87.LnVsop(0.00000000425, 2.71416734228,
						1064.04779663520),
				new Vsop87.LnVsop(0.00000000510, 5.81591864532, 529.53090640020),
				new Vsop87.LnVsop(0.00000000520, 3.25538472195, 600.54041039880),
				new Vsop87.LnVsop(0.00000000461, 3.87803707104,
						2015.67108615980),
				new Vsop87.LnVsop(0.00000000430, 1.28652623263, 505.31194270640),
				new Vsop87.LnVsop(0.00000000433, 3.43823137684,
						1152.17976366930),
				new Vsop87.LnVsop(0.00000000422, 5.12631540623, 944.98282327580),
				new Vsop87.LnVsop(0.00000000410, 1.24248975309,
						5069.38346150640),
				new Vsop87.LnVsop(0.00000000411, 2.95117124177,
						4326.39340097380),
				new Vsop87.LnVsop(0.00000000419, 5.16120679625,
						1173.52040467170),
				new Vsop87.LnVsop(0.00000000412, 2.98125446330, 554.06998748280),
				new Vsop87.LnVsop(0.00000000472, 0.12243647414, 245.54242435240),
				new Vsop87.LnVsop(0.00000000402, 5.88796637322,
						1570.91364801910),
				new Vsop87.LnVsop(0.00000000505, 1.49028912471,
						3782.47534187760),
				new Vsop87.LnVsop(0.00000000439, 3.06170334768,
						1475.68518032670),
				new Vsop87.LnVsop(0.00000000426, 3.12237794195,
						12566.15169998280),
				new Vsop87.LnVsop(0.00000000501, 0.09797922397,
						1912.57831194120),
				new Vsop87.LnVsop(0.00000000434, 3.59362426939,
						3259.89792378380),
				new Vsop87.LnVsop(0.00000000398, 4.91510709622,
						4120.20785253660),
				new Vsop87.LnVsop(0.00000000425, 4.74522508051,
						1080.72257119160),
				new Vsop87.LnVsop(0.00000000412, 6.26668629942, 512.28247735530),
				new Vsop87.LnVsop(0.00000000377, 5.63771534471, 988.53248488500),
				new Vsop87.LnVsop(0.00000000376, 1.04960792457, 6.36278747540),
				new Vsop87.LnVsop(0.00000000387, 0.82173742289,
						2758.66114669240),
				new Vsop87.LnVsop(0.00000000398, 3.16033099794, 1.48447270830),
				new Vsop87.LnVsop(0.00000000392, 1.86519119748, 885.43971066640), };

		private static final Vsop87.LnVsop[] jupiter_radius_r2 = {
				new Vsop87.LnVsop(0.00079644957, 1.35865949884, 529.69096509460),
				new Vsop87.LnVsop(0.00008251645, 5.77774460400, 522.57741809380),
				new Vsop87.LnVsop(0.00007029940, 3.27477392111, 536.80451209540),
				new Vsop87.LnVsop(0.00005314031, 1.83835031247,
						1059.38193018920),
				new Vsop87.LnVsop(0.00001861184, 2.97686957956, 7.11354700080),
				new Vsop87.LnVsop(0.00000836256, 4.19892740368, 419.48464387520),
				new Vsop87.LnVsop(0.00000964420, 5.48029587251, 515.46387109300),
				new Vsop87.LnVsop(0.00000406408, 3.78248932836,
						1066.49547719000),
				new Vsop87.LnVsop(0.00000426544, 2.22743958182, 639.89728631400),
				new Vsop87.LnVsop(0.00000377334, 2.24232535935,
						1589.07289528380),
				new Vsop87.LnVsop(0.00000497914, 3.14159265359, 0.00000000000),
				new Vsop87.LnVsop(0.00000339124, 6.12690872435, 625.67019231240),
				new Vsop87.LnVsop(0.00000362961, 5.36776401268, 206.18554843720),
				new Vsop87.LnVsop(0.00000342139, 6.09909325177,
						1052.26838318840),
				new Vsop87.LnVsop(0.00000279940, 4.26158071104, 412.37109687440),
				new Vsop87.LnVsop(0.00000332558, 0.00332561805, 426.59819087600),
				new Vsop87.LnVsop(0.00000229775, 0.70510840437, 735.87651353180),
				new Vsop87.LnVsop(0.00000200884, 3.06805028347, 543.91805909620),
				new Vsop87.LnVsop(0.00000199660, 4.42869041267, 103.09277421860),
				new Vsop87.LnVsop(0.00000257306, 0.96267482500, 632.78373931320),
				new Vsop87.LnVsop(0.00000138577, 2.93153004432, 14.22709400160),
				new Vsop87.LnVsop(0.00000113380, 0.78831018317, 728.76296653100),
				new Vsop87.LnVsop(0.00000085848, 5.14257631438, 323.50541665740),
				new Vsop87.LnVsop(0.00000094695, 1.70378030966, 838.96928775040),
				new Vsop87.LnVsop(0.00000083674, 0.05892269245, 309.27832265580),
				new Vsop87.LnVsop(0.00000075194, 1.60633621497, 956.28915597060),
				new Vsop87.LnVsop(0.00000070197, 1.50916343132, 213.29909543800),
				new Vsop87.LnVsop(0.00000080209, 2.98293613006, 742.99006053260),
				new Vsop87.LnVsop(0.00000056365, 0.95014515126,
						1162.47470440780),
				new Vsop87.LnVsop(0.00000061758, 6.10246926546,
						1045.15483618760),
				new Vsop87.LnVsop(0.00000066425, 5.47411271821, 199.07200143640),
				new Vsop87.LnVsop(0.00000050128, 2.72034786035, 532.87235883230),
				new Vsop87.LnVsop(0.00000051793, 5.58477632168, 942.06206196900),
				new Vsop87.LnVsop(0.00000039925, 5.94843040319, 95.97922721780),
				new Vsop87.LnVsop(0.00000044584, 5.52437023269, 508.35032409220),
				new Vsop87.LnVsop(0.00000044215, 0.26965913924, 526.50957135690),
				new Vsop87.LnVsop(0.00000030130, 0.93896301926,
						1155.36115740700),
				new Vsop87.LnVsop(0.00000028433, 2.87743261296, 525.75881183150),
				new Vsop87.LnVsop(0.00000026377, 4.26907277677,
						1596.18644228460),
				new Vsop87.LnVsop(0.00000027064, 2.80927398799,
						1169.58825140860),
				new Vsop87.LnVsop(0.00000027531, 2.64852579481,
						2118.76386037840),
				new Vsop87.LnVsop(0.00000022695, 0.18097965354, 302.16477565500),
				new Vsop87.LnVsop(0.00000029439, 1.78672212056, 831.85574074960),
				new Vsop87.LnVsop(0.00000020007, 0.03856532918, 949.17560896980),
				new Vsop87.LnVsop(0.00000019915, 1.15792331540, 533.62311835770),
				new Vsop87.LnVsop(0.00000021698, 1.88986950330,
						1272.68102562720),
				new Vsop87.LnVsop(0.00000017678, 4.14815218724, 846.08283475120),
				new Vsop87.LnVsop(0.00000017064, 5.88794387217,
						1258.45393162560),
				new Vsop87.LnVsop(0.00000021474, 4.34579246643, 316.39186965660),
				new Vsop87.LnVsop(0.00000021174, 0.54776446005,
						1265.56747862640),
				new Vsop87.LnVsop(0.00000019878, 0.06616288602,
						1581.95934828300),
				new Vsop87.LnVsop(0.00000017028, 0.53404092917,
						1368.66025284500),
				new Vsop87.LnVsop(0.00000012874, 3.89924775426, 433.71173787680),
				new Vsop87.LnVsop(0.00000012887, 0.81112211137, 110.20632121940),
				new Vsop87.LnVsop(0.00000011716, 0.40420153376,
						1361.54670584420),
				new Vsop87.LnVsop(0.00000011655, 4.43864372476, 405.25754987360),
				new Vsop87.LnVsop(0.00000012042, 2.22601252935, 220.41264243880),
				new Vsop87.LnVsop(0.00000009620, 6.01003863537, 853.19638175200),
				new Vsop87.LnVsop(0.00000010252, 0.99356542172,
						1471.75302706360),
				new Vsop87.LnVsop(0.00000009102, 1.61635845262,
						1692.16566950240),
				new Vsop87.LnVsop(0.00000008722, 3.51382233353,
						1073.60902419080),
				new Vsop87.LnVsop(0.00000008283, 5.61696036887,
						1574.84580128220),
				new Vsop87.LnVsop(0.00000008917, 6.26263765188, 519.39602435610),
				new Vsop87.LnVsop(0.00000007962, 0.64245582750,
						1478.86657406440),
				new Vsop87.LnVsop(0.00000007722, 0.17138136003,
						1685.05212250160),
				new Vsop87.LnVsop(0.00000007445, 0.90537428710, 88.86568021700),
				new Vsop87.LnVsop(0.00000007337, 0.88996282570, 721.64941953020),
				new Vsop87.LnVsop(0.00000009118, 1.51639567636,
						1148.24761040620),
				new Vsop87.LnVsop(0.00000006139, 2.49651421842, 3.18139373770),
				new Vsop87.LnVsop(0.00000007001, 4.44209624915, 330.61896365820),
				new Vsop87.LnVsop(0.00000005235, 2.79243270986, 21.34064100240),
				new Vsop87.LnVsop(0.00000005041, 2.97840393432,
						1375.77379984580),
				new Vsop87.LnVsop(0.00000004937, 0.04442899397,
						1677.93857550080),
				new Vsop87.LnVsop(0.00000004633, 2.26661974645,
						1485.98012106520),
				new Vsop87.LnVsop(0.00000004667, 0.84935842035, 3.93215326310),
				new Vsop87.LnVsop(0.00000005341, 0.86294969395,
						1788.14489672020),
				new Vsop87.LnVsop(0.00000004248, 0.41663016954, 629.60234557550),
				new Vsop87.LnVsop(0.00000004187, 1.62198715560, 635.96513305090),
				new Vsop87.LnVsop(0.00000003629, 2.71174024514, 551.03160609700),
				new Vsop87.LnVsop(0.00000004453, 1.27731121245,
						1464.63948006280),
				new Vsop87.LnVsop(0.00000003266, 0.54602174256,
						1795.25844372100),
				new Vsop87.LnVsop(0.00000003409, 1.20638860556,
						1905.46476494040),
				new Vsop87.LnVsop(0.00000003164, 6.20189662302,
						1038.04128918680),
				new Vsop87.LnVsop(0.00000003096, 6.21099164255,
						2001.44399215820),
				new Vsop87.LnVsop(0.00000003404, 2.44670518809, 539.98590583310),
				new Vsop87.LnVsop(0.00000003168, 5.58075929197, 191.95845443560),
				new Vsop87.LnVsop(0.00000002201, 5.33344494715,
						1891.23767093880),
				new Vsop87.LnVsop(0.00000002553, 3.20949626593,
						1062.56332392690),
				new Vsop87.LnVsop(0.00000002386, 4.29199230828, 963.40270297140),
				new Vsop87.LnVsop(0.00000002597, 0.57986674442,
						2104.53676637680),
				new Vsop87.LnVsop(0.00000002547, 0.14627545776, 750.10360753340),
				new Vsop87.LnVsop(0.00000002609, 4.82665360488, 416.30325013750),
				new Vsop87.LnVsop(0.00000002187, 1.71707514653, 628.85158605010),
				new Vsop87.LnVsop(0.00000002258, 6.17429279705,
						1994.33044515740),
				new Vsop87.LnVsop(0.00000002624, 2.36922205485, 227.52618943960),
				new Vsop87.LnVsop(0.00000002097, 3.31460321409,
						1699.27921650320),
				new Vsop87.LnVsop(0.00000002027, 3.15533834136, 611.44309831080),
				new Vsop87.LnVsop(0.00000002081, 0.31057710726,
						2111.65031337760),
				new Vsop87.LnVsop(0.00000002484, 0.04731413707,
						1898.35121793960),
				new Vsop87.LnVsop(0.00000001963, 0.29583638556, 636.71589257630),
				new Vsop87.LnVsop(0.00000002279, 1.96058124545, 824.74219374880),
				new Vsop87.LnVsop(0.00000001829, 4.69907372627,
						2125.87740737920),
				new Vsop87.LnVsop(0.00000001829, 0.33004933298, 295.05122865420),
				new Vsop87.LnVsop(0.00000002553, 1.24739305569,
						2221.85663459700),
				new Vsop87.LnVsop(0.00000001785, 3.51009274020, 647.01083331480),
				new Vsop87.LnVsop(0.00000001786, 3.46994340828,
						1055.44977692610),
				new Vsop87.LnVsop(0.00000001742, 2.43853510157, 10.29494073850),
				new Vsop87.LnVsop(0.00000001850, 1.60578508516,
						2008.55753915900),
				new Vsop87.LnVsop(0.00000001971, 1.15435477931, 618.55664531160),
				new Vsop87.LnVsop(0.00000001611, 5.83466560322, 422.66603761290),
				new Vsop87.LnVsop(0.00000001639, 0.45469643466,
						1056.20053645150),
				new Vsop87.LnVsop(0.00000001628, 5.86754764931,
						2317.83586181480),
				new Vsop87.LnVsop(0.00000002099, 1.05944599014,
						1781.03134971940),
				new Vsop87.LnVsop(0.00000001570, 2.39516560987, 440.82528487760),
				new Vsop87.LnVsop(0.00000001999, 4.62828691526, 423.41679713830),
				new Vsop87.LnVsop(0.00000001480, 0.02394813605,
						1382.88734684660),
				new Vsop87.LnVsop(0.00000001502, 5.74598263477, 117.31986822020),
				new Vsop87.LnVsop(0.00000001881, 2.76425929784,
						1802.37199072180),
				new Vsop87.LnVsop(0.00000001983, 2.99080832362,
						2648.45482547300),
				new Vsop87.LnVsop(0.00000001402, 0.15904673895,
						2420.92863603340),
				new Vsop87.LnVsop(0.00000001174, 1.55354182426, 380.12776796000),
				new Vsop87.LnVsop(0.00000001321, 1.26221998203,
						1063.31408345230),
				new Vsop87.LnVsop(0.00000001150, 4.12219328847, 547.85021235930),
				new Vsop87.LnVsop(0.00000001080, 4.41192013439, 934.94851496820),
				new Vsop87.LnVsop(0.00000001138, 5.93242605811,
						2310.72231481400),
				new Vsop87.LnVsop(0.00000001033, 5.63854408052, 99.91138048090),
				new Vsop87.LnVsop(0.00000000949, 6.07298626146, 511.53171782990),
				new Vsop87.LnVsop(0.00000001012, 3.80744305824,
						1603.29998928540),
				new Vsop87.LnVsop(0.00000000922, 6.16494528393, 945.99421523210),
				new Vsop87.LnVsop(0.00000000915, 5.22425774632,
						2207.62954059540),
				new Vsop87.LnVsop(0.00000000860, 2.48740591818,
						6283.07584999140),
				new Vsop87.LnVsop(0.00000000836, 1.08651799806, 81.75213321620),
				new Vsop87.LnVsop(0.00000001165, 0.72510519647,
						2097.42321937600),
				new Vsop87.LnVsop(0.00000000851, 4.69371733745,
						5746.27133789600),
				new Vsop87.LnVsop(0.00000000789, 3.91035208173,
						10213.28554621100),
				new Vsop87.LnVsop(0.00000000846, 0.77030801324,
						5760.49843189760),
				new Vsop87.LnVsop(0.00000000924, 1.43423249860, 732.69511979410),
				new Vsop87.LnVsop(0.00000000805, 6.11630827296,
						9676.48103411560),
				new Vsop87.LnVsop(0.00000000800, 2.19289534160,
						9690.70812811720),
				new Vsop87.LnVsop(0.00000000812, 5.00490295474, 319.57326339430),
				new Vsop87.LnVsop(0.00000000841, 1.22483116811, 952.35700270750),
				new Vsop87.LnVsop(0.00000000720, 3.95975713584, 337.73251065900),
				new Vsop87.LnVsop(0.00000000711, 1.23970970528, 106.27416795630),
				new Vsop87.LnVsop(0.00000000889, 0.10251260092,
						2737.32050569000),
				new Vsop87.LnVsop(0.00000000858, 1.51763095265,
						2324.94940881560),
				new Vsop87.LnVsop(0.00000000868, 2.67598866406,
						3370.10424500320),
				new Vsop87.LnVsop(0.00000000710, 0.65180853077,
						2538.24850425360),
				new Vsop87.LnVsop(0.00000000743, 0.60536479474,
						1354.43315884340),
				new Vsop87.LnVsop(0.00000000633, 1.37719198152, 124.43341522100),
				new Vsop87.LnVsop(0.00000000866, 3.02831268213,
						3046.59882834580),
				new Vsop87.LnVsop(0.00000000733, 5.84583969196,
						2634.22773147140),
				new Vsop87.LnVsop(0.00000000691, 1.14062641255,
						2641.34127847220),
				new Vsop87.LnVsop(0.00000000593, 1.80277592426, 453.42489381900),
				new Vsop87.LnVsop(0.00000000660, 6.01207640959,
						1049.08698945070),
				new Vsop87.LnVsop(0.00000000771, 6.01059588645,
						2214.74308759620),
				new Vsop87.LnVsop(0.00000000586, 5.68149019460, 107.02492748170),
				new Vsop87.LnVsop(0.00000000639, 4.77149952374, 860.30992875280),
				new Vsop87.LnVsop(0.00000000782, 2.52401202862,
						3679.38256765900),
				new Vsop87.LnVsop(0.00000000631, 2.27765412816,
						2015.67108615980),
				new Vsop87.LnVsop(0.00000000779, 2.38608991574,
						3267.01147078460),
				new Vsop87.LnVsop(0.00000000584, 3.00542907219,
						1262.38608488870),
				new Vsop87.LnVsop(0.00000000543, 3.09924086245,
						3281.23856478620),
				new Vsop87.LnVsop(0.00000000535, 2.42171003067, 739.05790726950),
				new Vsop87.LnVsop(0.00000000681, 1.18831331541, 739.80866679490),
				new Vsop87.LnVsop(0.00000000621, 1.24462887440,
						3803.81598288000),
				new Vsop87.LnVsop(0.00000000717, 4.14222389339,
						9683.59458111640),
				new Vsop87.LnVsop(0.00000000546, 3.43095520503, 18.15924726470),
				new Vsop87.LnVsop(0.00000000545, 5.65426574985,
						2627.11418447060),
				new Vsop87.LnVsop(0.00000000538, 4.92334194042, 447.79581952650),
				new Vsop87.LnVsop(0.00000000534, 0.99911551571, 462.02291352810),
				new Vsop87.LnVsop(0.00000000541, 6.19275150397,
						1987.21689815660),
				new Vsop87.LnVsop(0.00000000511, 3.28553278370, 4.66586644600),
				new Vsop87.LnVsop(0.00000000537, 5.33205206604,
						2751.54759969160),
				new Vsop87.LnVsop(0.00000000651, 5.12199308959,
						3156.80514956520),
				new Vsop87.LnVsop(0.00000000510, 5.35664230912, 9.56122755560),
				new Vsop87.LnVsop(0.00000000544, 1.81488805078,
						1251.34038462480),
				new Vsop87.LnVsop(0.00000000426, 2.10841334313, 149.56319713460),
				new Vsop87.LnVsop(0.00000000516, 3.89424540015,
						2516.90786325120),
				new Vsop87.LnVsop(0.00000000543, 5.56620814561,
						2524.02141025200),
				new Vsop87.LnVsop(0.00000000519, 2.43126348834,
						3686.49611465980),
				new Vsop87.LnVsop(0.00000000404, 2.77840802846, 7.16173111060),
				new Vsop87.LnVsop(0.00000000533, 4.77083438961,
						3473.19701922180),
				new Vsop87.LnVsop(0.00000000386, 6.06244501785, 203.00415469950),
				new Vsop87.LnVsop(0.00000000482, 0.38718011166,
						2428.04218303420),
				new Vsop87.LnVsop(0.00000000434, 5.36713537673,
						2531.13495725280),
				new Vsop87.LnVsop(0.00000000370, 6.04174787347,
						1670.82502850000), };

		private static final Vsop87.LnVsop[] jupiter_radius_r3 = {
				new Vsop87.LnVsop(0.00003519277, 6.05800355513, 529.69096509460),
				new Vsop87.LnVsop(0.00001073281, 1.67319166156, 536.80451209540),
				new Vsop87.LnVsop(0.00000915630, 1.41326157617, 522.57741809380),
				new Vsop87.LnVsop(0.00000341654, 0.52294532787,
						1059.38193018920),
				new Vsop87.LnVsop(0.00000254881, 1.19631092831, 7.11354700080),
				new Vsop87.LnVsop(0.00000221477, 0.95234304351, 515.46387109300),
				new Vsop87.LnVsop(0.00000069020, 2.26889455907,
						1066.49547719000),
				new Vsop87.LnVsop(0.00000089777, 3.14159265359, 0.00000000000),
				new Vsop87.LnVsop(0.00000057885, 1.41227055539, 543.91805909620),
				new Vsop87.LnVsop(0.00000057700, 0.52564805704, 639.89728631400),
				new Vsop87.LnVsop(0.00000051213, 5.97994255422, 412.37109687440),
				new Vsop87.LnVsop(0.00000046968, 1.57861666908, 625.67019231240),
				new Vsop87.LnVsop(0.00000042744, 6.11814173992, 419.48464387520),
				new Vsop87.LnVsop(0.00000037444, 1.18048940249, 14.22709400160),
				new Vsop87.LnVsop(0.00000033816, 1.66573652907,
						1052.26838318840),
				new Vsop87.LnVsop(0.00000031166, 1.04468072620,
						1589.07289528380),
				new Vsop87.LnVsop(0.00000029943, 4.63498871771, 426.59819087600),
				new Vsop87.LnVsop(0.00000033558, 0.84853879170, 206.18554843720),
				new Vsop87.LnVsop(0.00000020709, 2.50340319894, 728.76296653100),
				new Vsop87.LnVsop(0.00000014470, 0.96111460506, 508.35032409220),
				new Vsop87.LnVsop(0.00000012974, 1.50391478213,
						1045.15483618760),
				new Vsop87.LnVsop(0.00000011596, 3.55299164531, 323.50541665740),
				new Vsop87.LnVsop(0.00000012357, 2.60797398650, 735.87651353180),
				new Vsop87.LnVsop(0.00000015065, 0.87961214090, 199.07200143640),
				new Vsop87.LnVsop(0.00000011062, 1.78854133467, 309.27832265580),
				new Vsop87.LnVsop(0.00000010576, 0.00265970762, 956.28915597060),
				new Vsop87.LnVsop(0.00000009798, 6.24533081819, 103.09277421860),
				new Vsop87.LnVsop(0.00000006725, 1.86312777034, 302.16477565500),
				new Vsop87.LnVsop(0.00000009133, 3.46071465629, 838.96928775040),
				new Vsop87.LnVsop(0.00000007338, 1.28438797074, 742.99006053260),
				new Vsop87.LnVsop(0.00000007182, 0.91717952341, 942.06206196900),
				new Vsop87.LnVsop(0.00000005482, 1.35541254124, 95.97922721780),
				new Vsop87.LnVsop(0.00000006754, 3.45186268696, 831.85574074960),
				new Vsop87.LnVsop(0.00000004626, 2.83572146596,
						1596.18644228460),
				new Vsop87.LnVsop(0.00000004106, 6.01730779864, 213.29909543800),
				new Vsop87.LnVsop(0.00000003942, 1.19384143223,
						1169.58825140860),
				new Vsop87.LnVsop(0.00000003469, 6.10664206989, 405.25754987360),
				new Vsop87.LnVsop(0.00000002861, 2.32367020387,
						1155.36115740700),
				new Vsop87.LnVsop(0.00000002519, 0.42500820125, 220.41264243880),
				new Vsop87.LnVsop(0.00000002468, 1.84219414782, 532.87235883230),
				new Vsop87.LnVsop(0.00000002322, 1.57653167974,
						2118.76386037840),
				new Vsop87.LnVsop(0.00000002283, 0.13415259559, 632.78373931320),
				new Vsop87.LnVsop(0.00000002243, 1.91751229130,
						1073.60902419080),
				new Vsop87.LnVsop(0.00000002285, 5.94194291108,
						1162.47470440780),
				new Vsop87.LnVsop(0.00000002137, 1.06953434212, 21.34064100240),
				new Vsop87.LnVsop(0.00000002515, 0.33520672477,
						1272.68102562720),
				new Vsop87.LnVsop(0.00000002042, 5.92779916530, 110.20632121940),
				new Vsop87.LnVsop(0.00000001927, 2.58542297225, 88.86568021700),
				new Vsop87.LnVsop(0.00000002021, 2.21761113830, 433.71173787680),
				new Vsop87.LnVsop(0.00000001943, 1.46376661665,
						1258.45393162560),
				new Vsop87.LnVsop(0.00000001700, 1.88459425041, 525.75881183150),
				new Vsop87.LnVsop(0.00000001815, 2.67626558650, 330.61896365820),
				new Vsop87.LnVsop(0.00000001821, 2.75572507789, 721.64941953020),
				new Vsop87.LnVsop(0.00000002068, 3.17049523925,
						1148.24761040620),
				new Vsop87.LnVsop(0.00000001866, 2.28678298902,
						1361.54670584420),
				new Vsop87.LnVsop(0.00000001526, 4.47646904898, 853.19638175200),
				new Vsop87.LnVsop(0.00000001508, 0.11633951449, 949.17560896980),
				new Vsop87.LnVsop(0.00000001655, 0.44340210808, 533.62311835770),
				new Vsop87.LnVsop(0.00000001572, 0.45863923926, 526.50957135690),
				new Vsop87.LnVsop(0.00000001161, 3.10471097791, 963.40270297140),
				new Vsop87.LnVsop(0.00000001162, 1.19270352887,
						1574.84580128220),
				new Vsop87.LnVsop(0.00000001140, 2.46324106660, 846.08283475120),
				new Vsop87.LnVsop(0.00000001259, 1.24988357144,
						1038.04128918680),
				new Vsop87.LnVsop(0.00000001396, 0.69581007586, 551.03160609700),
				new Vsop87.LnVsop(0.00000001182, 1.93125671013,
						1581.95934828300),
				new Vsop87.LnVsop(0.00000000894, 2.85762385272, 519.39602435610),
				new Vsop87.LnVsop(0.00000000983, 4.17198081351,
						2627.11418447060),
				new Vsop87.LnVsop(0.00000001061, 0.66716890315, 539.98590583310),
				new Vsop87.LnVsop(0.00000000859, 4.91931457958, 611.44309831080),
				new Vsop87.LnVsop(0.00000000918, 4.89690742057,
						1670.82502850000),
				new Vsop87.LnVsop(0.00000000866, 3.00153408458,
						1368.66025284500),
				new Vsop87.LnVsop(0.00000001115, 0.97017156126, 227.52618943960),
				new Vsop87.LnVsop(0.00000000887, 3.68665606145, 824.74219374880),
				new Vsop87.LnVsop(0.00000000737, 3.20041743453,
						2125.87740737920),
				new Vsop87.LnVsop(0.00000000730, 2.32845485663,
						2317.83586181480),
				new Vsop87.LnVsop(0.00000000828, 1.01037712742, 191.95845443560),
				new Vsop87.LnVsop(0.00000000778, 0.25303611679,
						1141.13406340540),
				new Vsop87.LnVsop(0.00000000757, 2.24232615954,
						2538.24850425360),
				new Vsop87.LnVsop(0.00000000720, 0.55787809007, 440.82528487760),
				new Vsop87.LnVsop(0.00000000672, 4.17028096565,
						1692.16566950240),
				new Vsop87.LnVsop(0.00000000691, 5.78026436421,
						1485.98012106520),
				new Vsop87.LnVsop(0.00000000611, 2.66934999696,
						1265.56747862640),
				new Vsop87.LnVsop(0.00000000592, 2.26781665598,
						1471.75302706360),
				new Vsop87.LnVsop(0.00000000561, 6.11300561068,
						1279.79457262800),
				new Vsop87.LnVsop(0.00000000566, 1.93294355027,
						2634.22773147140),
				new Vsop87.LnVsop(0.00000000545, 2.21244108948,
						1062.56332392690),
				new Vsop87.LnVsop(0.00000000640, 2.47352731748,
						1699.27921650320),
				new Vsop87.LnVsop(0.00000000694, 4.71564977334, 750.10360753340),
				new Vsop87.LnVsop(0.00000000604, 1.97421641416,
						1677.93857550080),
				new Vsop87.LnVsop(0.00000000501, 2.45269887786, 81.75213321620),
				new Vsop87.LnVsop(0.00000000552, 4.37775459043,
						1382.88734684660),
				new Vsop87.LnVsop(0.00000000556, 5.31872445991,
						2413.81508903260),
				new Vsop87.LnVsop(0.00000000589, 0.19759573714, 10.29494073850),
				new Vsop87.LnVsop(0.00000000497, 2.52744546318,
						2207.62954059540),
				new Vsop87.LnVsop(0.00000000416, 6.19072120624, 934.94851496820),
				new Vsop87.LnVsop(0.00000000433, 5.80559659477,
						1478.86657406440),
				new Vsop87.LnVsop(0.00000000395, 2.34556406839, 295.05122865420), };

		private static final Vsop87.LnVsop[] jupiter_radius_r4 = {
				new Vsop87.LnVsop(0.00000128623, 0.08347608895, 536.80451209540),
				new Vsop87.LnVsop(0.00000113458, 4.24818938180, 529.69096509460),
				new Vsop87.LnVsop(0.00000082704, 3.29801136583, 522.57741809380),
				new Vsop87.LnVsop(0.00000037897, 2.73402665560, 515.46387109300),
				new Vsop87.LnVsop(0.00000026713, 5.68996992467, 7.11354700080),
				new Vsop87.LnVsop(0.00000017808, 5.40366594364,
						1059.38193018920),
				new Vsop87.LnVsop(0.00000012564, 6.00543529469, 543.91805909620),
				new Vsop87.LnVsop(0.00000009272, 0.75619260404,
						1066.49547719000),
				new Vsop87.LnVsop(0.00000008141, 5.68230705037, 14.22709400160),
				new Vsop87.LnVsop(0.00000006174, 5.10190413726, 639.89728631400),
				new Vsop87.LnVsop(0.00000006920, 1.42214334807, 412.37109687440),
				new Vsop87.LnVsop(0.00000005327, 3.33829390777, 625.67019231240),
				new Vsop87.LnVsop(0.00000002895, 3.38407751603,
						1052.26838318840),
				new Vsop87.LnVsop(0.00000002696, 4.18310762577, 728.76296653100),
				new Vsop87.LnVsop(0.00000002435, 2.96139551556, 426.59819087600),
				new Vsop87.LnVsop(0.00000002176, 6.21232313303,
						1589.07289528380),
				new Vsop87.LnVsop(0.00000002008, 3.13891134942,
						1045.15483618760),
				new Vsop87.LnVsop(0.00000001817, 2.74670205576, 206.18554843720),
				new Vsop87.LnVsop(0.00000001883, 1.87835568033, 419.48464387520),
				new Vsop87.LnVsop(0.00000001501, 1.26929907808,
						1596.18644228460),
				new Vsop87.LnVsop(0.00000001701, 2.58901479440, 199.07200143640),
				new Vsop87.LnVsop(0.00000001689, 0.00000000000, 0.00000000000),
				new Vsop87.LnVsop(0.00000001148, 5.18914327333, 831.85574074960),
				new Vsop87.LnVsop(0.00000001033, 5.35702238710, 220.41264243880),
				new Vsop87.LnVsop(0.00000000874, 5.79483644819,
						1169.58825140860),
				new Vsop87.LnVsop(0.00000000854, 4.55476058022, 956.28915597060),
				new Vsop87.LnVsop(0.00000000913, 1.89622509837,
						1148.24761040620),
				new Vsop87.LnVsop(0.00000000949, 0.68597092334,
						1361.54670584420),
				new Vsop87.LnVsop(0.00000000788, 1.44319075028,
						1272.68102562720),
				new Vsop87.LnVsop(0.00000000774, 3.21426219962, 508.35032409220),
				new Vsop87.LnVsop(0.00000000921, 5.33422516215, 551.03160609700),
				new Vsop87.LnVsop(0.00000000681, 0.44800059149,
						1073.60902419080),
				new Vsop87.LnVsop(0.00000000681, 5.21435913114, 21.34064100240),
				new Vsop87.LnVsop(0.00000000587, 4.57539103016, 110.20632121940),
				new Vsop87.LnVsop(0.00000000578, 1.97098995055, 647.01083331480),
				new Vsop87.LnVsop(0.00000000596, 2.85043907413, 191.95845443560),
				new Vsop87.LnVsop(0.00000000599, 2.43146933611, 117.31986822020),
				new Vsop87.LnVsop(0.00000000544, 0.53039419311, 330.61896365820),
				new Vsop87.LnVsop(0.00000000545, 3.50461220615, 302.16477565500),
				new Vsop87.LnVsop(0.00000000538, 4.22160404735, 88.86568021700),
				new Vsop87.LnVsop(0.00000000757, 2.28818475655, 942.06206196900),
				new Vsop87.LnVsop(0.00000000562, 1.48594378600, 3.18139373770),
				new Vsop87.LnVsop(0.00000000631, 1.83863158533, 10.29494073850),
				new Vsop87.LnVsop(0.00000000504, 2.08322743695, 103.09277421860),
				new Vsop87.LnVsop(0.00000000462, 0.40130574859, 433.71173787680), };

		private static final Vsop87.LnVsop[] jupiter_radius_r5 = {
				new Vsop87.LnVsop(0.00000011193, 4.74280611863, 536.80451209540),
				new Vsop87.LnVsop(0.00000004288, 5.90497787277, 522.57741809380),
				new Vsop87.LnVsop(0.00000002004, 3.65178377123, 7.11354700080),
				new Vsop87.LnVsop(0.00000002118, 5.57290745004, 515.46387109300),
				new Vsop87.LnVsop(0.00000001908, 4.29659647286, 543.91805909620),
				new Vsop87.LnVsop(0.00000001534, 5.46373729640,
						1066.49547719000),
				new Vsop87.LnVsop(0.00000001596, 4.11045079899,
						1059.38193018920),
				new Vsop87.LnVsop(0.00000001301, 3.72955393027, 14.22709400160),
				new Vsop87.LnVsop(0.00000001033, 4.50671820436, 529.69096509460), };
	}

	/**
	 * void ln_get_jupiter_equ_coords(double JD, LnEquPosn position); \param JD
	 * julian Day \param position Pointer to store position
	 * 
	 * Calculates Jupiter's equatorial position for given julian day. This
	 * function includes calculations for planetary aberration and refers to the
	 * FK5 reference frame.
	 * 
	 * To get the complete equatorial coordinates, corrections for nutation have
	 * to be applied.
	 * 
	 * The position returned is accurate to within 0.1 arcsecs.
	 */
	public static void ln_get_jupiter_equ_coords(double JD, LnEquPosn position) {
		LnHelioPosn h_sol = new LnHelioPosn(), h_jupiter = new LnHelioPosn();
		LnRectPosn g_sol = new LnRectPosn(), g_jupiter = new LnRectPosn();
		double a, b, c;
		double ra, dec, delta, diff, last, t = 0;

		/** need typdef for solar heliocentric coords */
		ln_get_solar_geom_coords(JD, h_sol);
		ln_get_rect_from_helio(h_sol, g_sol);

		do {
			last = t;
			ln_get_jupiter_helio_coords(JD - t, h_jupiter);
			ln_get_rect_from_helio(h_jupiter, g_jupiter);

			/** equ 33.10 pg 229 */
			a = g_sol.X + g_jupiter.X;
			b = g_sol.Y + g_jupiter.Y;
			c = g_sol.Z + g_jupiter.Z;

			delta = a * a + b * b + c * c;
			delta = sqrt(delta);
			t = delta * 0.0057755183;
			diff = t - last;
		} while (diff > 0.0001 || diff < -0.0001);

		ra = atan2(b, a);
		dec = c / delta;
		dec = asin(dec);

		/** back to hours, degrees */
		position.ra = ln_range_degrees(ln_rad_to_deg(ra));
		position.dec = ln_rad_to_deg(dec);
	}

	/**
	 * void ln_get_jupiter_helio_coords(double JD, LnHelioPosn position) \param
	 * JD Julian Day \param position Pointer to store heliocentric position
	 * 
	 * Calculate Jupiters heliocentric (refered to the centre of the Sun)
	 * coordinates in the FK5 reference frame for the given julian day.
	 * Longitude and Latitude are in degrees, whilst radius vector is in AU.
	 */
	/**
	 * Chapter 31 Pg 206-207 Equ 31.1 31.2 , 31.3 using VSOP 87
	 */
	public static void ln_get_jupiter_helio_coords(double JD,
			LnHelioPosn position) {
		double t, t2, t3, t4, t5;
		double L0, L1, L2, L3, L4, L5;
		double B0, B1, B2, B3, B4, B5;
		double R0, R1, R2, R3, R4, R5;

		/** check cache first */
		if (JD == cJD) {
			/** cache hit */
			position.L = cL;
			position.B = cB;
			position.R = cR;
			return;
		}

		/** get julian ephemeris day */
		t = (JD - 2451545.0) / 365250;
		t2 = t * t;
		t3 = t2 * t;
		t4 = t3 * t;
		t5 = t4 * t;

		/** calc L series */
		L0 = ln_calc_series(Lontitude.jupiter_longitude_l0, t);
		L1 = ln_calc_series(Lontitude.jupiter_longitude_l1, t);
		L2 = ln_calc_series(Lontitude.jupiter_longitude_l2, t);
		L3 = ln_calc_series(Lontitude.jupiter_longitude_l3, t);
		L4 = ln_calc_series(Lontitude.jupiter_longitude_l4, t);
		L5 = ln_calc_series(Lontitude.jupiter_longitude_l5, t);
		position.L = (L0 + L1 * t + L2 * t2 + L3 * t3 + L4 * t4 + L5 * t5);

		/** calc B series */
		B0 = ln_calc_series(Latitude.jupiter_latitude_b0, t);
		B1 = ln_calc_series(Latitude.jupiter_latitude_b1, t);
		B2 = ln_calc_series(Latitude.jupiter_latitude_b2, t);
		B3 = ln_calc_series(Latitude.jupiter_latitude_b3, t);
		B4 = ln_calc_series(Latitude.jupiter_latitude_b4, t);
		B5 = ln_calc_series(Latitude.jupiter_latitude_b5, t);
		position.B = (B0 + B1 * t + B2 * t2 + B3 * t3 + B4 * t4 + B5 * t5);

		/** calc R series */
		R0 = ln_calc_series(Radius.jupiter_radius_r0, t);
		R1 = ln_calc_series(Radius.jupiter_radius_r1, t);
		R2 = ln_calc_series(Radius.jupiter_radius_r2, t);
		R3 = ln_calc_series(Radius.jupiter_radius_r3, t);
		R4 = ln_calc_series(Radius.jupiter_radius_r4, t);
		R5 = ln_calc_series(Radius.jupiter_radius_r5, t);
		position.R = (R0 + R1 * t + R2 * t2 + R3 * t3 + R4 * t4 + R5 * t5);

		/** change to degrees in correct quadrant */
		position.L = ln_rad_to_deg(position.L);
		position.B = ln_rad_to_deg(position.B);
		position.L = ln_range_degrees(position.L);

		/** change to fk5 reference frame */
		ln_vsop87_to_fk5(position, JD);

		/** save cache */
		cJD = JD;
		cL = position.L;
		cB = position.B;
		cR = position.R;
	}

	/**
	 * double ln_get_jupiter_earth_dist(double JD); \param JD Julian day. \brief
	 * Calculate the distance between Jupiter and the Earth in AU \return
	 * Distance in AU.
	 * 
	 * Calculates the distance in AU between the Earth and Jupiter for the given
	 * julian day.
	 */
	public static double ln_get_jupiter_earth_dist(double JD) {
		LnHelioPosn h_jupiter = new LnHelioPosn(), h_earth = new LnHelioPosn();
		LnRectPosn g_jupiter = new LnRectPosn(), g_earth = new LnRectPosn();
		double x, y, z;

		/** get heliocentric positions */
		ln_get_jupiter_helio_coords(JD, h_jupiter);
		ln_get_earth_helio_coords(JD, h_earth);

		/** get geocentric coords */
		ln_get_rect_from_helio(h_jupiter, g_jupiter);
		ln_get_rect_from_helio(h_earth, g_earth);

		/** use pythag */
		x = g_jupiter.X - g_earth.X;
		y = g_jupiter.Y - g_earth.Y;
		z = g_jupiter.Z - g_earth.Z;
		;
		x = x * x;
		y = y * y;
		z = z * z;

		return sqrt(x + y + z);
	}

	/**
	 * double ln_get_jupiter_solar_dist(double JD); \param JD Julian day. \brief
	 * Calculate the distance between Jupiter and the Sun in AU \return Distance
	 * in AU.
	 * 
	 * Calculates the distance in AU between the Sun and Jupiter for the given
	 * julian day.
	 */
	public static double ln_get_jupiter_solar_dist(double JD) {
		LnHelioPosn h_jupiter = new LnHelioPosn();

		/** get heliocentric position */
		ln_get_jupiter_helio_coords(JD, h_jupiter);
		return h_jupiter.R;
	}

	/**
	 * double ln_get_jupiter_magnitude(double JD); \param JD Julian day \brief
	 * Calculate the visible magnitude of Jupiter \return Visible magnitude of
	 * Jupiter
	 * 
	 * Calculate the visible magnitude of jupiter for the given julian day.
	 */
	public static double ln_get_jupiter_magnitude(double JD) {
		double delta, r, i;

		/** get distances */
		r = ln_get_jupiter_solar_dist(JD);
		delta = ln_get_jupiter_earth_dist(JD);

		/** get phase */
		i = ln_get_jupiter_phase(JD);

		return -9.40 + 5.0 * log10(r * delta) + 0.005 * i;
	}

	/**
	 * double ln_get_jupiter_disk(double JD); \param JD Julian day. \brief
	 * Calculate the illuminated fraction of Jupiter's disk \return Illuminated
	 * fraction of Jupiters disk (Value between 0 and 1)
	 * 
	 * Calculate the illuminated fraction of Jupiter's disk for the given Julian
	 * day.
	 */
	/** Chapter 41 */
	public static double ln_get_jupiter_disk(double JD) {
		double r, delta, R;

		/** get distances */
		R = ln_get_earth_solar_dist(JD);
		r = ln_get_jupiter_solar_dist(JD);
		delta = ln_get_jupiter_earth_dist(JD);

		/** calc fraction angle */
		return (((r + delta) * (r + delta)) - R * R) / (4 * r * delta);
	}

	/**
	 * double ln_get_jupiter_phase(double JD); \param JD Julian Day \return
	 * Phase angle of Jupiter (degrees)
	 * 
	 * Calculates the phase angle of Jupiter, that is, the angle Sun - Jupiter -
	 * Earth for the given Julian day.
	 */
	/** Chapter 41 */
	public static double ln_get_jupiter_phase(double JD) {
		double i, r, delta, R;

		/** get distances */
		R = ln_get_earth_solar_dist(JD);
		r = ln_get_jupiter_solar_dist(JD);
		delta = ln_get_jupiter_earth_dist(JD);

		/** calc phase */
		i = (r * r + delta * delta - R * R) / (2.0 * r * delta);
		i = acos(i);
		return ln_rad_to_deg(i);
	}

	/**
	 * double ln_get_jupiter_rst(double JD, LnLnlatPosn observer, LnRstTime
	 * rst); \param JD Julian day \param observer Observers position \param rst
	 * Pointer to store Rise, Set and Transit time in JD \return 0 for success,
	 * else 1 for circumpolar.
	 * 
	 * Calculate the time the rise, set and transit (crosses the local meridian
	 * at upper culmination) time of Jupiter for the given Julian day.
	 * 
	 * Note: this functions returns 1 if Jupiter is circumpolar, that is it
	 * remains the whole day either above or below the horizon.
	 */
	public static int ln_get_jupiter_rst(double JD, LnLnlatPosn observer,
			LnRstTime rst) {
		return ln_get_body_rst_horizon(JD, observer, new IGetEquBodyCoords() {

			@Override
			public void get_equ_body_coords(double JD, LnEquPosn position) {
				ln_get_jupiter_equ_coords(JD, position);

			}
		}, LN_STAR_STANDART_HORIZON.doubleValue(), rst);
	}

	/**
	 * double ln_get_jupiter_equ_sdiam(double JD) \param JD Julian day \return
	 * Semidiameter in arc seconds
	 * 
	 * Calculate the equatorial semidiameter of Jupiter in arc seconds for the
	 * given julian day.
	 */
	public static double ln_get_jupiter_equ_sdiam(double JD) {
		double So = 98.44;
		/** at 1 AU */
		double dist;

		dist = ln_get_jupiter_earth_dist(JD);
		return So / dist;
	}

	/**
	 * double ln_get_jupiter_pol_sdiam(double JD) \param JD Julian day \return
	 * Semidiameter in arc seconds \todo Use Jupitercentric latitude of Earth Pg
	 * 390
	 * 
	 * Calculate the polar semidiameter of Jupiter in arc seconds for the given
	 * julian day.
	 */
	public static double ln_get_jupiter_pol_sdiam(double JD) {
		double So = 92.06;
		/** at 1 AU */
		double dist;

		dist = ln_get_jupiter_earth_dist(JD);
		return So / dist;
	}

	/**
	 * void ln_get_jupiter_rect_helio(double JD, LnRectPosn position) \param JD
	 * Julian day. \param position pointer to return position
	 * 
	 * Calculate Jupiters rectangular heliocentric coordinates for the given
	 * Julian day. Coordinates are in AU.
	 */
	public static void ln_get_jupiter_rect_helio(double JD, LnRectPosn position) {
		LnHelioPosn jupiter = new LnHelioPosn();

		ln_get_jupiter_helio_coords(JD, jupiter);
		ln_get_rect_from_helio(jupiter, position);
	}

}
