/*
 * Decompiled with CFR 0.152.
 */
package de.kaffeekrone.jsteuernummer;

import de.kaffeekrone.jsteuernummer.Region;
import de.kaffeekrone.jsteuernummer.SteuernummerException;

public class Steuernummer {
    private final String steuernummer;
    private final Region region;

    private Steuernummer(String steuernummer) throws SteuernummerException {
        this.steuernummer = steuernummer;
        Region tempRegion = null;
        for (Region region : Region.values()) {
            if (!region.matchesRegion(steuernummer) && !region.matchesCountry(steuernummer)) continue;
            tempRegion = region;
            break;
        }
        if (tempRegion == null) {
            throw new SteuernummerException("No region could be determined for steuernummer " + steuernummer);
        }
        this.region = tempRegion;
    }

    private Steuernummer(String steuernummer, Region region) throws SteuernummerException {
        this.steuernummer = steuernummer;
        if (!region.matchesRegion(steuernummer) && !region.matchesCountry(steuernummer)) {
            throw new SteuernummerException("Region (" + (Object)((Object)region) + ") does not match with given steuernummer (" + steuernummer + ")");
        }
        this.region = region;
    }

    public String getSteuernummer() {
        return this.steuernummer;
    }

    public Region getRegion() {
        return this.region;
    }

    public static Steuernummer of(String steuernummer) throws SteuernummerException {
        return new Steuernummer(steuernummer);
    }

    public static Steuernummer of(String steuernummer, Region region) throws SteuernummerException {
        return new Steuernummer(steuernummer, region);
    }
}

