/*
 * This file is part of vyreka, a dynamic mapping tool designed to navigate grid-based locations and find optimal paths.
 *
 * MIT License
 *
 * Copyright (c) 2024 JvstvsHD
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package de.jvstvshd.vyreka.core

import kotlin.math.pow

/**
 * Calculates the power of this integer to the given exponent. This is a shorthand for `this.toDouble().pow(exponent.toDouble()).toInt()`.
 * @param exponent the exponent to raise this integer to.
 */
fun Int.pow(exponent: Int): Int {
    return this.toDouble().pow(exponent.toDouble()).toInt()
}

/**
 * Clears all elements in this array by setting them to `null`.
 */
fun Array<Any?>.clear() {
    for (i in indices) {
        this[i] = null
    }
}

/**
 * Clears all elements in this 2-dimensional array by setting them to `null`.
 */
fun Array<Array<Any?>>.clear() {
    for (i in indices) {
        this[i].clear()
    }
}