/*
 * Decompiled with CFR 0.152.
 */
package net.hitmc.lobbycountdown.team;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.ranges.RangesKt;
import net.hitmc.lobbycountdown.team.Team;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\rH\u0016J\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\u0012H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lnet/hitmc/lobbycountdown/team/TwoTeams;", "Lnet/hitmc/lobbycountdown/team/Team;", "color", "Lnet/kyori/adventure/text/format/NamedTextColor;", "(Lnet/kyori/adventure/text/format/NamedTextColor;)V", "getColor", "()Lnet/kyori/adventure/text/format/NamedTextColor;", "name", "", "getName", "()Ljava/lang/String;", "players", "", "Lorg/bukkit/entity/Player;", "join", "", "player", "opposite", "", "Companion", "lobby-countdown"})
public final class TwoTeams
implements Team {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NamedTextColor color;
    @NotNull
    private final Set<Player> players;
    @NotNull
    private static final TwoTeams RED;
    @NotNull
    private static final TwoTeams BLUE;

    public TwoTeams(@NotNull NamedTextColor color) {
        Intrinsics.checkNotNullParameter(color, "color");
        this.color = color;
        this.players = new LinkedHashSet();
    }

    @NotNull
    public NamedTextColor getColor() {
        return this.color;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.getColor().toString();
        Intrinsics.checkNotNullExpressionValue(string, "color.toString()");
        return string;
    }

    @Override
    @NotNull
    public Set<Player> players() {
        return CollectionsKt.toSet((Iterable)this.players);
    }

    @Override
    public void join(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
    }

    @NotNull
    public final TwoTeams opposite() {
        TwoTeams twoTeams;
        if (Intrinsics.areEqual(this, RED)) {
            twoTeams = BLUE;
        } else if (Intrinsics.areEqual(this, BLUE)) {
            twoTeams = RED;
        } else {
            throw new IllegalStateException("Unknown team".toString());
        }
        return twoTeams;
    }

    static {
        NamedTextColor namedTextColor = NamedTextColor.RED;
        Intrinsics.checkNotNullExpressionValue(namedTextColor, "RED");
        RED = new TwoTeams(namedTextColor);
        NamedTextColor namedTextColor2 = NamedTextColor.BLUE;
        Intrinsics.checkNotNullExpressionValue(namedTextColor2, "BLUE");
        BLUE = new TwoTeams(namedTextColor2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\t\u001a\u00020\nJ\b\u0010\u000b\u001a\u00020\u0004H\u0002J&\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00040\r*\b\u0012\u0004\u0012\u00020\u000e0\u000f2\u0006\u0010\u0010\u001a\u00020\u0004H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lnet/hitmc/lobbycountdown/team/TwoTeams$Companion;", "", "()V", "BLUE", "Lnet/hitmc/lobbycountdown/team/TwoTeams;", "getBLUE", "()Lnet/hitmc/lobbycountdown/team/TwoTeams;", "RED", "getRED", "assignTeams", "", "randomTeam", "halfPlayers", "", "Lorg/bukkit/entity/Player;", "", "majorityTeam", "lobby-countdown"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TwoTeams getRED() {
            return RED;
        }

        @NotNull
        public final TwoTeams getBLUE() {
            return BLUE;
        }

        public final void assignTeams() {
            Map<Object, TwoTeams> map2;
            List assignedPlayers = CollectionsKt.toMutableList(SetsKt.plus(this.getRED().players, this.getBLUE().players));
            Collection collection = Bukkit.getOnlinePlayers();
            Intrinsics.checkNotNullExpressionValue(collection, "getOnlinePlayers()");
            List unassignedPlayers = CollectionsKt.toMutableList(CollectionsKt.minus((Iterable)collection, CollectionsKt.toSet(assignedPlayers)));
            switch (unassignedPlayers.size()) {
                case 0: {
                    return;
                }
                case 1: {
                    int n = this.getRED().players.size();
                    map2 = MapsKt.mapOf(new Pair(CollectionsKt.first(unassignedPlayers), n == this.getBLUE().players.size() ? this.randomTeam() : ((0 <= n ? n < this.getBLUE().players.size() : false) ? this.getRED() : this.getBLUE())));
                    break;
                }
                default: {
                    int blueCount = this.getBLUE().players.size();
                    int n = this.getRED().players.size();
                    if (n == blueCount) {
                        map2 = this.halfPlayers(unassignedPlayers, this.randomTeam());
                        break;
                    }
                    map2 = (0 <= n ? n < blueCount : false) ? this.halfPlayers(unassignedPlayers, this.getRED()) : this.halfPlayers(unassignedPlayers, this.getBLUE());
                }
            }
            Map<Object, TwoTeams> teamAssignment = map2;
            for (Map.Entry<Object, TwoTeams> entry : teamAssignment.entrySet()) {
                Player player = (Player)entry.getKey();
                TwoTeams team = entry.getValue();
                team.players.add(player);
            }
        }

        private final Map<Player, TwoTeams> halfPlayers(List<? extends Player> $this$halfPlayers, TwoTeams majorityTeam) {
            TwoTeams twoTeams;
            Map map2;
            Object object;
            List list = CollectionsKt.chunked((Iterable)$this$halfPlayers, MathKt.roundToInt((double)$this$halfPlayers.size() / 2.0));
            List red = list.get(0);
            List blue = list.get(1);
            Iterable $this$associateWith$iv = red;
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                Player player = (Player)element$iv$iv;
                object = element$iv$iv;
                map2 = result$iv;
                boolean bl = false;
                twoTeams = majorityTeam;
                map2.put(object, twoTeams);
            }
            $this$associateWith$iv = blue;
            map2 = result$iv;
            $i$f$associateWith = false;
            result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
            $this$associateWithTo$iv$iv = $this$associateWith$iv;
            $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                Player it = (Player)element$iv$iv;
                twoTeams = element$iv$iv;
                object = result$iv;
                boolean bl = false;
                TwoTeams twoTeams2 = majorityTeam.opposite();
                object.put((TwoTeams)twoTeams, (TwoTeams)twoTeams2);
            }
            return MapsKt.plus(map2, result$iv);
        }

        private final TwoTeams randomTeam() {
            return Random.Default.nextBoolean() ? this.getRED() : this.getBLUE();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

