/*
 * Decompiled with CFR 0.152.
 */
package net.hitmc.lobbycountdown;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.hitmc.lobbycountdown.CountdownHandler;
import net.hitmc.lobbycountdown.HotbarItem;
import net.hitmc.lobbycountdown.Listeners;
import net.hitmc.lobbycountdown.events.LCCancelCountdownEvent;
import net.hitmc.lobbycountdown.events.LCCountdownStartEvent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.ServicesManager;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BV\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u001d\u0010\r\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010#\u001a\u00020$2\b\b\u0002\u0010%\u001a\u00020&J\u000e\u0010'\u001a\u00020$2\u0006\u0010\u0013\u001a\u00020\nJ\u0006\u0010(\u001a\u00020$R\u001e\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR(\u0010\r\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\b\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0015R\u000e\u0010!\u001a\u00020\"X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lnet/hitmc/lobbycountdown/LobbyCountdown;", "", "plugin", "Lorg/bukkit/plugin/Plugin;", "items", "", "Lnet/hitmc/lobbycountdown/HotbarItem;", "countdownHandler", "Lnet/hitmc/lobbycountdown/CountdownHandler;", "startValue", "", "spawnLocation", "Lorg/bukkit/Location;", "startCountdown", "Lkotlin/Function2;", "", "Lkotlin/ExtensionFunctionType;", "(Lorg/bukkit/plugin/Plugin;Ljava/util/List;Lnet/hitmc/lobbycountdown/CountdownHandler;ILorg/bukkit/Location;Lkotlin/jvm/functions/Function2;)V", "<set-?>", "countdown", "getCountdown", "()I", "getCountdownHandler", "()Lnet/hitmc/lobbycountdown/CountdownHandler;", "getItems", "()Ljava/util/List;", "getPlugin", "()Lorg/bukkit/plugin/Plugin;", "getSpawnLocation", "()Lorg/bukkit/Location;", "getStartCountdown", "()Lkotlin/jvm/functions/Function2;", "getStartValue", "task", "Lorg/bukkit/scheduler/BukkitTask;", "cancel", "", "reason", "Lnet/hitmc/lobbycountdown/events/LCCancelCountdownEvent$Reason;", "setCountdown", "start", "lobby-countdown"})
public final class LobbyCountdown {
    @NotNull
    private final Plugin plugin;
    @NotNull
    private final List<HotbarItem> items;
    @Nullable
    private final CountdownHandler countdownHandler;
    private final int startValue;
    @NotNull
    private final Location spawnLocation;
    @NotNull
    private final Function2<LobbyCountdown, Integer, Boolean> startCountdown;
    private int countdown;
    private BukkitTask task;

    public LobbyCountdown(@NotNull Plugin plugin, @NotNull List<HotbarItem> items, @Nullable CountdownHandler countdownHandler, int startValue, @NotNull Location spawnLocation, @NotNull Function2<? super LobbyCountdown, ? super Integer, Boolean> startCountdown) {
        Intrinsics.checkNotNullParameter(plugin, "plugin");
        Intrinsics.checkNotNullParameter(items, "items");
        Intrinsics.checkNotNullParameter(spawnLocation, "spawnLocation");
        Intrinsics.checkNotNullParameter(startCountdown, "startCountdown");
        this.plugin = plugin;
        this.items = items;
        this.countdownHandler = countdownHandler;
        this.startValue = startValue;
        this.spawnLocation = spawnLocation;
        this.startCountdown = startCountdown;
        this.countdown = this.startValue;
        ServicesManager servicesManager = Bukkit.getServicesManager();
        Intrinsics.checkNotNullExpressionValue(servicesManager, "getServicesManager()");
        ServicesManager servicesManager2 = servicesManager;
        RegisteredServiceProvider registeredServiceProvider = servicesManager2.getRegistration(LobbyCountdown.class);
        if ((registeredServiceProvider != null ? (LobbyCountdown)registeredServiceProvider.getProvider() : null) != null) {
            throw new IllegalStateException("There was already registered an instance of LobbyCount".toString());
        }
        servicesManager2.register(LobbyCountdown.class, (Object)this, this.plugin, ServicePriority.High);
        Bukkit.getPluginManager().registerEvents((Listener)new Listeners(this), this.plugin);
    }

    public /* synthetic */ LobbyCountdown(Plugin plugin, List list, CountdownHandler countdownHandler, int n, Location location, Function2 function2, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            countdownHandler = null;
        }
        this(plugin, list, countdownHandler, n, location, function2);
    }

    @NotNull
    public final Plugin getPlugin() {
        return this.plugin;
    }

    @NotNull
    public final List<HotbarItem> getItems() {
        return this.items;
    }

    @Nullable
    public final CountdownHandler getCountdownHandler() {
        return this.countdownHandler;
    }

    public final int getStartValue() {
        return this.startValue;
    }

    @NotNull
    public final Location getSpawnLocation() {
        return this.spawnLocation;
    }

    @NotNull
    public final Function2<LobbyCountdown, Integer, Boolean> getStartCountdown() {
        return this.startCountdown;
    }

    public final int getCountdown() {
        return this.countdown;
    }

    public final void start() {
        if (this.task != null) {
            return;
        }
        LCCountdownStartEvent event = new LCCountdownStartEvent();
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        BukkitTask bukkitTask = Bukkit.getScheduler().runTaskTimer(this.plugin, () -> LobbyCountdown.start$lambda-0(this), 0L, 20L);
        Intrinsics.checkNotNullExpressionValue(bukkitTask, "getScheduler().runTaskTi\u2026own--\n        }, 0L, 20L)");
        this.task = bukkitTask;
    }

    public final void cancel(@NotNull LCCancelCountdownEvent.Reason reason) {
        Intrinsics.checkNotNullParameter((Object)reason, "reason");
        LCCancelCountdownEvent event = new LCCancelCountdownEvent(reason);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        BukkitTask bukkitTask = this.task;
        if (bukkitTask == null) {
            Intrinsics.throwUninitializedPropertyAccessException("task");
            bukkitTask = null;
        }
        bukkitTask.cancel();
    }

    public static /* synthetic */ void cancel$default(LobbyCountdown lobbyCountdown, LCCancelCountdownEvent.Reason reason, int n, Object object) {
        if ((n & 1) != 0) {
            reason = LCCancelCountdownEvent.Reason.CUSTOM;
        }
        lobbyCountdown.cancel(reason);
    }

    public final void setCountdown(int countdown) {
        if (this.task != null) {
            BukkitTask bukkitTask = this.task;
            if (bukkitTask == null) {
                Intrinsics.throwUninitializedPropertyAccessException("task");
                bukkitTask = null;
            }
            bukkitTask.cancel();
        }
        this.countdown = countdown;
        this.start();
    }

    private static final void start$lambda-0(LobbyCountdown this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        CountdownHandler countdownHandler = this$0.countdownHandler;
        if (countdownHandler != null) {
            countdownHandler.tick(this$0.countdown);
        }
        if (this$0.countdownHandler != null) {
            if (this$0.countdownHandler.getMessageValues().contains(this$0.countdown)) {
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    CountdownHandler countdownHandler2 = this$0.countdownHandler;
                    int n = this$0.countdown;
                    Intrinsics.checkNotNullExpressionValue(onlinePlayer, "onlinePlayer");
                    countdownHandler2.message(n, onlinePlayer);
                }
            }
            if (this$0.countdownHandler.getTitleValues().contains(this$0.countdown)) {
                for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
                    CountdownHandler countdownHandler3 = this$0.countdownHandler;
                    int n = this$0.countdown;
                    Intrinsics.checkNotNullExpressionValue(onlinePlayer, "onlinePlayer");
                    countdownHandler3.title(n, onlinePlayer);
                }
            }
        }
        if (this$0.countdown <= 0) {
            this$0.cancel(LCCancelCountdownEvent.Reason.COUNTDOWN_ZERO);
            CountdownHandler countdownHandler4 = this$0.countdownHandler;
            if (countdownHandler4 != null) {
                countdownHandler4.finished();
            }
            return;
        }
        int n = this$0.countdown;
        this$0.countdown = n + -1;
    }
}

