/*
 * Decompiled with CFR 0.152.
 */
package net.axay.kspigot.structures;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.axay.kspigot.annotations.NMS_General;
import net.axay.kspigot.data.NBTDataLoaderKt;
import net.axay.kspigot.extensions.bukkit.EntityExtensionsKt;
import net.axay.kspigot.structures.StructureData;
import net.minecraft.nbt.CompoundTag;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_19_R1.entity.CraftEntity;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@NMS_General
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\tH\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lnet/axay/kspigot/structures/StructureDataEntity;", "Lnet/axay/kspigot/structures/StructureData;", "entity", "Lorg/bukkit/entity/Entity;", "(Lorg/bukkit/entity/Entity;)V", "entityType", "Lorg/bukkit/entity/EntityType;", "(Lorg/bukkit/entity/EntityType;)V", "nbtData", "Lnet/minecraft/nbt/CompoundTag;", "(Lorg/bukkit/entity/EntityType;Lnet/minecraft/nbt/CompoundTag;)V", "getEntityType", "()Lorg/bukkit/entity/EntityType;", "getNbtData", "()Lnet/minecraft/nbt/CompoundTag;", "component1", "component2", "copy", "createAt", "", "loc", "Lorg/bukkit/Location;", "equals", "", "other", "", "hashCode", "", "toString", "", "KSpigot"})
public final class StructureDataEntity
implements StructureData {
    @NotNull
    private final EntityType entityType;
    @NotNull
    private final CompoundTag nbtData;

    public StructureDataEntity(@NotNull EntityType entityType, @NotNull CompoundTag nbtData) {
        Intrinsics.checkNotNullParameter(entityType, "entityType");
        Intrinsics.checkNotNullParameter(nbtData, "nbtData");
        this.entityType = entityType;
        this.nbtData = nbtData;
    }

    @NotNull
    public final EntityType getEntityType() {
        return this.entityType;
    }

    @NotNull
    public final CompoundTag getNbtData() {
        return this.nbtData;
    }

    public StructureDataEntity(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter(entity, "entity");
        EntityType entityType = entity.getType();
        Intrinsics.checkNotNullExpressionValue(entityType, "entity.type");
        this(entityType, NBTDataLoaderKt.getNbtData(entity));
    }

    public StructureDataEntity(@NotNull EntityType entityType) {
        Intrinsics.checkNotNullParameter(entityType, "entityType");
        this(entityType, new CompoundTag());
    }

    @Override
    public void createAt(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter(loc, "loc");
        Entity entity = EntityExtensionsKt.spawnCleanEntity(loc, this.entityType);
        Intrinsics.checkNotNull(entity, "null cannot be cast to non-null type org.bukkit.craftbukkit.v1_19_R1.entity.CraftEntity");
        ((CraftEntity)entity).getHandle().load(this.nbtData);
    }

    @NotNull
    public final EntityType component1() {
        return this.entityType;
    }

    @NotNull
    public final CompoundTag component2() {
        return this.nbtData;
    }

    @NotNull
    public final StructureDataEntity copy(@NotNull EntityType entityType, @NotNull CompoundTag nbtData) {
        Intrinsics.checkNotNullParameter(entityType, "entityType");
        Intrinsics.checkNotNullParameter(nbtData, "nbtData");
        return new StructureDataEntity(entityType, nbtData);
    }

    public static /* synthetic */ StructureDataEntity copy$default(StructureDataEntity structureDataEntity, EntityType entityType, CompoundTag compoundTag, int n, Object object) {
        if ((n & 1) != 0) {
            entityType = structureDataEntity.entityType;
        }
        if ((n & 2) != 0) {
            compoundTag = structureDataEntity.nbtData;
        }
        return structureDataEntity.copy(entityType, compoundTag);
    }

    @NotNull
    public String toString() {
        return "StructureDataEntity(entityType=" + this.entityType + ", nbtData=" + this.nbtData + ")";
    }

    public int hashCode() {
        int result2 = this.entityType.hashCode();
        result2 = result2 * 31 + this.nbtData.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StructureDataEntity)) {
            return false;
        }
        StructureDataEntity structureDataEntity = (StructureDataEntity)other;
        if (this.entityType != structureDataEntity.entityType) {
            return false;
        }
        return Intrinsics.areEqual(this.nbtData, structureDataEntity.nbtData);
    }
}

