/*
 * Decompiled with CFR 0.152.
 */
package net.axay.kspigot.structures;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.axay.kspigot.structures.StructureData;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u000e\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\bH\u00c6\u0003J\u001d\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lnet/axay/kspigot/structures/StructureDataBlock;", "Lnet/axay/kspigot/structures/StructureData;", "block", "Lorg/bukkit/block/Block;", "(Lorg/bukkit/block/Block;)V", "material", "Lorg/bukkit/Material;", "blockData", "Lorg/bukkit/block/data/BlockData;", "(Lorg/bukkit/Material;Lorg/bukkit/block/data/BlockData;)V", "getBlockData", "()Lorg/bukkit/block/data/BlockData;", "getMaterial", "()Lorg/bukkit/Material;", "component1", "component2", "copy", "createAt", "", "loc", "Lorg/bukkit/Location;", "equals", "", "other", "", "hashCode", "", "toString", "", "KSpigot"})
public final class StructureDataBlock
implements StructureData {
    @NotNull
    private final Material material;
    @NotNull
    private final BlockData blockData;

    public StructureDataBlock(@NotNull Material material, @NotNull BlockData blockData) {
        Intrinsics.checkNotNullParameter(material, "material");
        Intrinsics.checkNotNullParameter(blockData, "blockData");
        this.material = material;
        this.blockData = blockData;
    }

    @NotNull
    public final Material getMaterial() {
        return this.material;
    }

    @NotNull
    public final BlockData getBlockData() {
        return this.blockData;
    }

    public StructureDataBlock(@NotNull Block block) {
        Intrinsics.checkNotNullParameter(block, "block");
        Material material = block.getType();
        Intrinsics.checkNotNullExpressionValue(material, "block.type");
        BlockData blockData = block.getBlockData();
        Intrinsics.checkNotNullExpressionValue(blockData, "block.blockData");
        this(material, blockData);
    }

    @Override
    public void createAt(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter(loc, "loc");
        Block it = loc.getBlock();
        boolean bl = false;
        it.setType(this.material);
        it.setBlockData(this.blockData);
    }

    @NotNull
    public final Material component1() {
        return this.material;
    }

    @NotNull
    public final BlockData component2() {
        return this.blockData;
    }

    @NotNull
    public final StructureDataBlock copy(@NotNull Material material, @NotNull BlockData blockData) {
        Intrinsics.checkNotNullParameter(material, "material");
        Intrinsics.checkNotNullParameter(blockData, "blockData");
        return new StructureDataBlock(material, blockData);
    }

    public static /* synthetic */ StructureDataBlock copy$default(StructureDataBlock structureDataBlock, Material material, BlockData blockData, int n, Object object) {
        if ((n & 1) != 0) {
            material = structureDataBlock.material;
        }
        if ((n & 2) != 0) {
            blockData = structureDataBlock.blockData;
        }
        return structureDataBlock.copy(material, blockData);
    }

    @NotNull
    public String toString() {
        return "StructureDataBlock(material=" + this.material + ", blockData=" + this.blockData + ")";
    }

    public int hashCode() {
        int result2 = this.material.hashCode();
        result2 = result2 * 31 + this.blockData.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StructureDataBlock)) {
            return false;
        }
        StructureDataBlock structureDataBlock = (StructureDataBlock)other;
        if (this.material != structureDataBlock.material) {
            return false;
        }
        return Intrinsics.areEqual(this.blockData, structureDataBlock.blockData);
    }
}

