/*
 * Decompiled with CFR 0.152.
 */
package net.axay.kspigot.sound;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.axay.kspigot.extensions.bukkit.GeoExtensionsKt;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\bH\u00c6\u0003J3\u0010\u001a\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020&J\t\u0010'\u001a\u00020(H\u00d6\u0001R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000f\"\u0004\b\u0015\u0010\u0011\u00a8\u0006)"}, d2={"Lnet/axay/kspigot/sound/KSpigotSound;", "", "sound", "Lorg/bukkit/Sound;", "volume", "", "pitch", "category", "Lorg/bukkit/SoundCategory;", "(Lorg/bukkit/Sound;FFLorg/bukkit/SoundCategory;)V", "getCategory", "()Lorg/bukkit/SoundCategory;", "setCategory", "(Lorg/bukkit/SoundCategory;)V", "getPitch", "()F", "setPitch", "(F)V", "getSound", "()Lorg/bukkit/Sound;", "getVolume", "setVolume", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "playAt", "", "loc", "Lorg/bukkit/Location;", "playFor", "player", "Lorg/bukkit/entity/Player;", "toString", "", "KSpigot"})
public final class KSpigotSound {
    @NotNull
    private final Sound sound;
    private float volume;
    private float pitch;
    @Nullable
    private SoundCategory category;

    public KSpigotSound(@NotNull Sound sound, float volume, float pitch, @Nullable SoundCategory category) {
        Intrinsics.checkNotNullParameter(sound, "sound");
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
        this.category = category;
    }

    public /* synthetic */ KSpigotSound(Sound sound, float f, float f2, SoundCategory soundCategory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            f = 1.0f;
        }
        if ((n & 4) != 0) {
            f2 = 1.0f;
        }
        if ((n & 8) != 0) {
            soundCategory = null;
        }
        this(sound, f, f2, soundCategory);
    }

    @NotNull
    public final Sound getSound() {
        return this.sound;
    }

    public final float getVolume() {
        return this.volume;
    }

    public final void setVolume(float f) {
        this.volume = f;
    }

    public final float getPitch() {
        return this.pitch;
    }

    public final void setPitch(float f) {
        this.pitch = f;
    }

    @Nullable
    public final SoundCategory getCategory() {
        return this.category;
    }

    public final void setCategory(@Nullable SoundCategory soundCategory) {
        this.category = soundCategory;
    }

    public final void playAt(@NotNull Location loc) {
        Intrinsics.checkNotNullParameter(loc, "loc");
        SoundCategory curCategory = this.category;
        if (curCategory != null) {
            GeoExtensionsKt.getWorldOrException(loc).playSound(loc, this.sound, curCategory, this.volume, this.pitch);
        } else {
            GeoExtensionsKt.getWorldOrException(loc).playSound(loc, this.sound, this.volume, this.pitch);
        }
    }

    public final void playFor(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        SoundCategory curCategory = this.category;
        if (curCategory != null) {
            player.playSound(player.getLocation(), this.sound, curCategory, this.volume, this.pitch);
        } else {
            player.playSound(player.getLocation(), this.sound, this.volume, this.pitch);
        }
    }

    @NotNull
    public final Sound component1() {
        return this.sound;
    }

    public final float component2() {
        return this.volume;
    }

    public final float component3() {
        return this.pitch;
    }

    @Nullable
    public final SoundCategory component4() {
        return this.category;
    }

    @NotNull
    public final KSpigotSound copy(@NotNull Sound sound, float volume, float pitch, @Nullable SoundCategory category) {
        Intrinsics.checkNotNullParameter(sound, "sound");
        return new KSpigotSound(sound, volume, pitch, category);
    }

    public static /* synthetic */ KSpigotSound copy$default(KSpigotSound kSpigotSound, Sound sound, float f, float f2, SoundCategory soundCategory, int n, Object object) {
        if ((n & 1) != 0) {
            sound = kSpigotSound.sound;
        }
        if ((n & 2) != 0) {
            f = kSpigotSound.volume;
        }
        if ((n & 4) != 0) {
            f2 = kSpigotSound.pitch;
        }
        if ((n & 8) != 0) {
            soundCategory = kSpigotSound.category;
        }
        return kSpigotSound.copy(sound, f, f2, soundCategory);
    }

    @NotNull
    public String toString() {
        return "KSpigotSound(sound=" + this.sound + ", volume=" + this.volume + ", pitch=" + this.pitch + ", category=" + this.category + ")";
    }

    public int hashCode() {
        int result2 = this.sound.hashCode();
        result2 = result2 * 31 + Float.hashCode(this.volume);
        result2 = result2 * 31 + Float.hashCode(this.pitch);
        result2 = result2 * 31 + (this.category == null ? 0 : this.category.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KSpigotSound)) {
            return false;
        }
        KSpigotSound kSpigotSound = (KSpigotSound)other;
        if (this.sound != kSpigotSound.sound) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.volume), (Object)Float.valueOf(kSpigotSound.volume))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)Float.valueOf(this.pitch), (Object)Float.valueOf(kSpigotSound.pitch))) {
            return false;
        }
        return this.category == kSpigotSound.category;
    }
}

