/*
 * Decompiled with CFR 0.152.
 */
package net.axay.kspigot.ipaddress.badipdetectionservices;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import net.axay.kspigot.ipaddress.BadIPDetectionResult;
import net.axay.kspigot.ipaddress.BadIPDetectionService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0014J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lnet/axay/kspigot/ipaddress/badipdetectionservices/VPNBlocker;", "Lnet/axay/kspigot/ipaddress/BadIPDetectionService;", "()V", "interpreteResult", "Lnet/axay/kspigot/ipaddress/BadIPDetectionResult;", "result", "Lkotlinx/serialization/json/JsonObject;", "requestString", "", "ip", "KSpigot"})
public final class VPNBlocker
extends BadIPDetectionService {
    public VPNBlocker() {
        super("vpnblocker.net");
    }

    @Override
    @NotNull
    protected String requestString(@NotNull String ip2) {
        Intrinsics.checkNotNullParameter(ip2, "ip");
        return "https://api.vpnblocker.net/v2/json/" + ip2;
    }

    @Override
    @NotNull
    protected BadIPDetectionResult interpreteResult(@NotNull JsonObject result2) {
        BadIPDetectionResult badIPDetectionResult;
        Intrinsics.checkNotNullParameter(result2, "result");
        JsonElement jsonElement = (JsonElement)result2.get((Object)"host-ip");
        JsonPrimitive isBad = jsonElement != null ? JsonElementKt.getJsonPrimitive(jsonElement) : null;
        JsonPrimitive jsonPrimitive = isBad;
        if (jsonPrimitive != null) {
            badIPDetectionResult = JsonElementKt.getBoolean(jsonPrimitive) ? BadIPDetectionResult.GENERAL_BAD : BadIPDetectionResult.GOOD;
        } else {
            Object object = (JsonElement)result2.get((Object)"remaining_requests");
            if (object == null || (object = JsonElementKt.getJsonPrimitive((JsonElement)object)) == null || (object = JsonElementKt.getIntOrNull((JsonPrimitive)object)) == null) {
                return BadIPDetectionResult.ERROR;
            }
            int remaining = (Integer)object;
            badIPDetectionResult = remaining <= 0 ? BadIPDetectionResult.LIMIT : BadIPDetectionResult.ERROR;
        }
        return badIPDetectionResult;
    }
}

