/*
 * Decompiled with CFR 0.152.
 */
package net.axay.kspigot.ipaddress;

import java.io.Closeable;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.modules.SerializersModule;
import net.axay.kspigot.ipaddress.BadIPDetectionResult;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH$J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0003J\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000eH\u0014J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lnet/axay/kspigot/ipaddress/BadIPDetectionService;", "", "name", "", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "interpreteResult", "Lnet/axay/kspigot/ipaddress/BadIPDetectionResult;", "result", "Lkotlinx/serialization/json/JsonObject;", "isBad", "ip", "requestHeaders", "", "requestString", "KSpigot"})
public abstract class BadIPDetectionService {
    @NotNull
    private final String name;

    public BadIPDetectionService(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        this.name = name;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    protected abstract String requestString(@NotNull String var1);

    @NotNull
    protected Map<String, String> requestHeaders() {
        return MapsKt.emptyMap();
    }

    @NotNull
    protected abstract BadIPDetectionResult interpreteResult(@NotNull JsonObject var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final BadIPDetectionResult isBad(@NotNull String ip2) {
        BadIPDetectionResult badIPDetectionResult;
        Object field;
        Object object;
        Object element$iv;
        Intrinsics.checkNotNullParameter(ip2, "ip");
        URLConnection uRLConnection = new URL(this.requestString(ip2)).openConnection();
        Intrinsics.checkNotNull(uRLConnection, "null cannot be cast to non-null type java.net.HttpURLConnection");
        HttpURLConnection con = (HttpURLConnection)uRLConnection;
        con.setRequestMethod("GET");
        Map<String, String> $this$forEach$iv = this.requestHeaders();
        boolean $i$f$forEach = false;
        Object object2 = $this$forEach$iv.entrySet().iterator();
        while (object2.hasNext()) {
            object = element$iv = object2.next();
            boolean bl = false;
            field = object.getKey();
            String value = object.getValue();
            con.setRequestProperty((String)field, value);
        }
        con.connect();
        if (con.getResponseCode() == 429) {
            return BadIPDetectionResult.LIMIT;
        }
        try {
            object2 = con.getInputStream();
            element$iv = null;
            try {
                void $this$decodeFromString$iv;
                InputStream it = (InputStream)object2;
                boolean bl = false;
                field = Json.Default;
                byte[] byArray = it.readAllBytes();
                Intrinsics.checkNotNullExpressionValue(byArray, "it.readAllBytes()");
                String string$iv = StringsKt.decodeToString(byArray);
                boolean $i$f$decodeFromString = false;
                SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
                boolean $i$f$serializer = false;
                KSerializer<Object> $this$cast$iv$iv$iv = SerializersKt.serializer($this$serializer$iv$iv, Reflection.typeOf(JsonObject.class));
                boolean $i$f$cast = false;
                object = (JsonObject)$this$decodeFromString$iv.decodeFromString($this$cast$iv$iv$iv, string$iv);
            }
            catch (Throwable throwable) {
                try {
                    element$iv = throwable;
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    CloseableKt.closeFinally((Closeable)object2, element$iv);
                    throw throwable2;
                }
            }
            CloseableKt.closeFinally((Closeable)object2, (Throwable)element$iv);
            object2 = object;
        }
        catch (SerializationException exc) {
            object2 = null;
        }
        Object object3 = object2;
        if (object3 == null) {
            return BadIPDetectionResult.ERROR;
        }
        Object result2 = object3;
        try {
            badIPDetectionResult = this.interpreteResult((JsonObject)result2);
        }
        catch (Exception exc) {
            return BadIPDetectionResult.ERROR;
        }
        return badIPDetectionResult;
    }
}

