/*
 * Decompiled with CFR 0.152.
 */
package de.jutzig.github.release.plugin;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.FileSet;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecrypter;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.FileUtils;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHRelease;
import org.kohsuke.github.GHReleaseBuilder;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubBuilder;
import org.kohsuke.github.PagedIterable;

@Mojo(name="release", defaultPhase=LifecyclePhase.DEPLOY)
public class UploadMojo
extends AbstractMojo
implements Contextualizable {
    private static final String PUBLIC_GITUHB_API_ENDPOINT = "https://api.github.com";
    @Parameter(defaultValue="github")
    private String serverId;
    @Parameter(defaultValue="${project.version}")
    private String tag;
    @Parameter(property="relase.name")
    private String releaseName;
    @Parameter(property="project.description")
    private String description;
    @Parameter(property="github.commitish")
    private String commitish;
    @Parameter(property="github.draft")
    private Boolean draft;
    @Parameter(property="release.repositoryId", defaultValue="${project.scm.connection}", required=true)
    private String repositoryId;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    @Parameter(property="release.artifact", defaultValue="${project.build.directory}/${project.artifactId}-${project.version}.${project.packaging}")
    private String artifact;
    @Parameter
    private FileSet fileSet;
    @Parameter
    private List<FileSet> fileSets;
    @Parameter(defaultValue="false")
    private Boolean overwriteArtifact;
    @Parameter(defaultValue="false")
    private Boolean deleteRelease;
    @Requirement
    private PlexusContainer container;
    @Parameter
    private Boolean prerelease;
    @Parameter(defaultValue="false")
    private Boolean failOnExistingRelease;
    @Component
    private MavenProject project;
    private static final Pattern REPOSITORY_PATTERN = Pattern.compile("^(scm:git[:|])?(https?://[\\w\\d.-]+/|git@[\\w\\d.-]+:)([^/]+/[^/\\.]+)(\\.git)?(/.*)?$", 2);

    public void execute() throws MojoExecutionException {
        if (this.releaseName == null) {
            this.releaseName = this.tag;
        }
        if (this.prerelease == null) {
            this.prerelease = UploadMojo.guessPreRelease(this.tag);
        }
        this.repositoryId = UploadMojo.computeRepositoryId(this.repositoryId);
        GHRelease release = null;
        try {
            GitHub gitHub = this.createGithub(this.serverId);
            GHRepository repository = gitHub.getRepository(this.repositoryId);
            release = this.findRelease(repository, this.releaseName);
            if (release != null) {
                String message = "Release " + this.releaseName + " already exists. Not creating";
                if (this.failOnExistingRelease.booleanValue()) {
                    throw new MojoExecutionException(message);
                }
                if (this.deleteRelease.booleanValue()) {
                    this.getLog().info((CharSequence)("Removing existing release " + release.getName() + "..."));
                    release.delete();
                    this.getLog().info((CharSequence)("Release " + release.getName() + " removed successfully."));
                    release = null;
                } else {
                    this.getLog().info((CharSequence)message);
                }
            }
            if (release == null) {
                this.getLog().info((CharSequence)("Creating release " + this.releaseName));
                GHReleaseBuilder builder = repository.createRelease(this.tag);
                if (this.description != null) {
                    builder.body(this.description);
                }
                if (this.commitish != null) {
                    builder.commitish(this.commitish);
                }
                if (this.draft != null) {
                    builder.draft(this.draft.booleanValue());
                }
                builder.prerelease(this.prerelease.booleanValue());
                builder.name(this.releaseName);
                release = builder.create();
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Failed to create release", (Exception)e);
        }
        try {
            Object asset;
            if (this.artifact != null && !this.artifact.trim().isEmpty() && ((File)(asset = new File(this.artifact))).exists()) {
                this.uploadAsset(release, (File)asset);
            }
            if (this.fileSet != null) {
                this.uploadAssets(release, this.fileSet);
            }
            if (this.fileSets != null) {
                for (FileSet set : this.fileSets) {
                    this.uploadAssets(release, set);
                }
            }
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Failed to upload assets", (Exception)e);
        }
    }

    private void uploadAsset(GHRelease release, File asset) throws IOException {
        this.getLog().info((CharSequence)("Processing asset " + asset.getPath()));
        List existingAssets = release.getAssets();
        for (GHAsset a : existingAssets) {
            if (!a.getName().equals(asset.getName())) continue;
            if (this.overwriteArtifact.booleanValue()) {
                this.getLog().info((CharSequence)"  Deleting existing asset");
                a.delete();
                continue;
            }
            this.getLog().warn((CharSequence)("Asset " + asset.getName() + " already exists. Skipping"));
            return;
        }
        this.getLog().info((CharSequence)"  Upload asset");
        release.uploadAsset(asset, "application/zip");
    }

    private void uploadAssets(GHRelease release, FileSet fileset) throws IOException {
        List assets = FileUtils.getFiles((File)new File(fileset.getDirectory()), (String)StringUtils.join((Iterable)fileset.getIncludes(), (char)','), (String)StringUtils.join((Iterable)fileset.getExcludes(), (char)','));
        for (File asset : assets) {
            this.uploadAsset(release, asset);
        }
    }

    private GHRelease findRelease(GHRepository repository, String releaseNameToFind) throws IOException {
        PagedIterable releases = repository.listReleases();
        for (GHRelease ghRelease : releases) {
            if (!releaseNameToFind.equals(ghRelease.getName())) continue;
            return ghRelease;
        }
        return null;
    }

    public static String computeRepositoryId(String id) {
        Matcher matcher = REPOSITORY_PATTERN.matcher(id);
        if (matcher.matches()) {
            return matcher.group(3);
        }
        return id;
    }

    static String computeGithubApiEndpoint(Scm scm) {
        if (scm == null || StringUtils.isEmpty((CharSequence)scm.getConnection())) {
            return PUBLIC_GITUHB_API_ENDPOINT;
        }
        Matcher matcher = REPOSITORY_PATTERN.matcher(scm.getConnection());
        if (!matcher.matches()) {
            return PUBLIC_GITUHB_API_ENDPOINT;
        }
        String githubApiEndpoint = matcher.group(2);
        if (githubApiEndpoint.contains("github.com")) {
            return PUBLIC_GITUHB_API_ENDPOINT;
        }
        if (githubApiEndpoint.startsWith("git@")) {
            githubApiEndpoint = githubApiEndpoint.substring(4, githubApiEndpoint.length() - 1);
        }
        if (!(githubApiEndpoint = StringUtils.removeEnd((String)githubApiEndpoint, (String)"/")).startsWith("http")) {
            githubApiEndpoint = "https://" + githubApiEndpoint;
        }
        return githubApiEndpoint + "/api/v3";
    }

    public GitHub createGithub(String serverId) throws MojoExecutionException, IOException {
        String usernameProperty = System.getProperty("username");
        String passwordProperty = System.getProperty("password");
        String githubApiEndpoint = UploadMojo.computeGithubApiEndpoint(this.project.getScm());
        GitHubBuilder gitHubBuilder = new GitHubBuilder().withEndpoint(githubApiEndpoint);
        if (usernameProperty != null && passwordProperty != null) {
            this.getLog().debug((CharSequence)"Using server credentials from system properties 'username' and 'password'");
            return gitHubBuilder.withPassword(usernameProperty, passwordProperty).build();
        }
        Server server = this.getServer(this.settings, serverId);
        if (server == null) {
            throw new MojoExecutionException(MessageFormat.format("Server ''{0}'' not found in settings", serverId));
        }
        this.getLog().debug((CharSequence)MessageFormat.format("Using ''{0}'' server credentials", serverId));
        try {
            SettingsDecrypter settingsDecrypter = (SettingsDecrypter)this.container.lookup(SettingsDecrypter.class);
            SettingsDecryptionResult result = settingsDecrypter.decrypt((SettingsDecryptionRequest)new DefaultSettingsDecryptionRequest(server));
            server = result.getServer();
        }
        catch (ComponentLookupException cle) {
            throw new MojoExecutionException("Unable to lookup SettingsDecrypter: " + cle.getMessage(), (Exception)((Object)cle));
        }
        String serverUsername = System.getProperty("github.username", server.getUsername());
        String serverPassword = System.getProperty("github.password", server.getPassword());
        String serverAccessToken = System.getProperty("github.apitoken", server.getPrivateKey());
        if (StringUtils.isNotEmpty((CharSequence)serverUsername) && StringUtils.isNotEmpty((CharSequence)serverPassword)) {
            return gitHubBuilder.withPassword(serverUsername, serverPassword).build();
        }
        if (StringUtils.isNotEmpty((CharSequence)serverAccessToken)) {
            return gitHubBuilder.withOAuthToken(serverAccessToken).build();
        }
        throw new MojoExecutionException("Configuration for server " + serverId + " has no login credentials");
    }

    protected Server getServer(Settings settings, String serverId) {
        if (settings == null) {
            return null;
        }
        List servers = settings.getServers();
        if (servers == null || servers.isEmpty()) {
            return null;
        }
        for (Server server : servers) {
            if (!serverId.equals(server.getId())) continue;
            return server;
        }
        return null;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    static boolean guessPreRelease(String version) {
        boolean preRelease = version.endsWith("-SNAPSHOT") || StringUtils.containsIgnoreCase((CharSequence)version, (CharSequence)"-alpha") || StringUtils.containsIgnoreCase((CharSequence)version, (CharSequence)"-beta") || StringUtils.containsIgnoreCase((CharSequence)version, (CharSequence)"-RC") || StringUtils.containsIgnoreCase((CharSequence)version, (CharSequence)".RC") || StringUtils.containsIgnoreCase((CharSequence)version, (CharSequence)".M") || StringUtils.containsIgnoreCase((CharSequence)version, (CharSequence)".BUILD_SNAPSHOT");
        return preRelease;
    }
}

