/*
 * Decompiled with CFR 0.152.
 */
package de.juplo.reactorm;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;

public class SerialExecutor
implements Executor {
    private final Queue<Runnable> tasks = new ArrayDeque<Runnable>();
    private final Executor executor;
    private Runnable active;

    SerialExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public synchronized void execute(Runnable r) {
        this.tasks.offer(() -> {
            try {
                r.run();
            }
            finally {
                this.scheduleNext();
            }
        });
        if (this.active == null) {
            this.scheduleNext();
        }
    }

    private synchronized void scheduleNext() {
        this.active = this.tasks.poll();
        if (this.active != null) {
            this.executor.execute(this.active);
        }
    }
}

