/*
 * Decompiled with CFR 0.152.
 */
package de.juplo.reactorm;

import de.juplo.reactorm.PaginatedSourcePublisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaginatedSourceSubscription
implements Subscription {
    public static final Logger LOG = LoggerFactory.getLogger(PaginatedSourceSubscription.class);
    private final PaginatedSourcePublisher publisher;
    private final Subscriber subscriber;

    PaginatedSourceSubscription(PaginatedSourcePublisher publisher, Subscriber subscriber) {
        this.publisher = publisher;
        this.subscriber = subscriber;
    }

    public void request(long request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: request for {} items from subscriber {}", new Object[]{this.publisher, request, Integer.toHexString(this.subscriber.hashCode())});
        }
        if (!this.publisher.isSubscribed(this.subscriber)) {
            return;
        }
        if (this.publisher.isCompleted() || this.publisher.hasError()) {
            this.publisher.publish();
            return;
        }
        if (request <= 0L) {
            this.publisher.signalError(new IllegalArgumentException("non-positive request signals are illegal"));
            return;
        }
        this.publisher.addRequest(this.subscriber, request);
        this.publisher.publish();
    }

    public void cancel() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: subscriber {} canceled its sbscription!", (Object)this.publisher, (Object)Integer.toHexString(this.subscriber.hashCode()));
        }
        this.publisher.unsubscribe(this.subscriber);
    }
}

