package de.juplo.reactorm;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;


/**
 * Simple implementation of an executor, that executes all scheduled tasks in
 * a strict serial order.
 * <em>
 * The implementation is mainly borrowed from the example in the java API
 * documentation.
 * </em>
 * @author Kai Moritz
 */
public class SerialExecutor implements Executor
{
  private final Queue<Runnable> tasks = new ArrayDeque<>();
  private final Executor executor;

  private Runnable active;


  SerialExecutor(Executor executor)
  {
    this.executor = executor;
  }


  @Override
  public synchronized void execute(final Runnable r)
  {
    tasks.offer((Runnable)() ->
    {
      try
      {
        r.run();
      }
      finally
      {
        scheduleNext();
      }
    });

    if (active == null)
      scheduleNext();
  }

  private synchronized void scheduleNext()
  {
    if ((active = tasks.poll()) != null)
      executor.execute(active);
  }
}
