package de.juplo.reactorm;


/**
 * Helper class to keep track of the request of a subscriber.
 * <em>Intended for internal usage only.</em>
 * @author Kai Moritz
 */
class Request
{
  private long requested = 0;


  protected long get()
  {
    return requested;
  }

  protected void add(long request)
  {
    requested += request;
    // Handle overflow!
    if (requested <= 0)
      requested = Long.MAX_VALUE;
  }

  protected boolean consume()
  {
    if (requested > 0)
    {
      if (requested != Long.MAX_VALUE)
        requested--;
      return true;
    }
    else
      return false;
  }


  @Override
  public String toString()
  {
    return Long.toString(requested);
  }
}
