/*
 * Decompiled with CFR 0.152.
 */
package de.juplo.plugins.hibernate4;

import com.pyx4j.log4j.MavenLogAppender;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.hibernate.cfg.Configuration;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.Target;
import org.scannotation.AnnotationDB;

public class Hbm2DdlMojo
extends AbstractMojo {
    public static final String DRIVER_CLASS = "hibernate.connection.driver_class";
    public static final String URL = "hibernate.connection.url";
    public static final String USERNAME = "hibernate.connection.username";
    public static final String PASSWORD = "hibernate.connection.password";
    public static final String DIALECT = "hibernate.dialect";
    private MavenProject project;
    private String outputDirectory;
    private boolean skip;
    private String driverClassName;
    private String url;
    private String username;
    private String password;
    private String hibernateDialect;
    private String hibernateProperties;
    private String target;
    private String type;
    private String outputFile;
    private String delimiter;
    private boolean format;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoFailureException, MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Exectuion of hibernate4-maven-plugin:export was skipped!");
            return;
        }
        File dir = new File(this.outputDirectory);
        if (!dir.exists()) {
            throw new MojoExecutionException("Cannot scan for annotated classes in " + this.outputDirectory + ": directory does not exist!");
        }
        HashSet classes = new HashSet();
        try {
            AnnotationDB db = new AnnotationDB();
            this.getLog().info((CharSequence)("Scanning directory " + this.outputDirectory + " for annotated classes..."));
            URL dirUrl = dir.toURI().toURL();
            db.scanArchives(new URL[]{dirUrl});
            if (db.getAnnotationIndex().containsKey(Entity.class.getName())) {
                classes.addAll((Collection)db.getAnnotationIndex().get(Entity.class.getName()));
            }
            if (db.getAnnotationIndex().containsKey(MappedSuperclass.class.getName())) {
                classes.addAll((Collection)db.getAnnotationIndex().get(MappedSuperclass.class.getName()));
            }
            if (db.getAnnotationIndex().containsKey(Embeddable.class.getName())) {
                classes.addAll((Collection)db.getAnnotationIndex().get(Embeddable.class.getName()));
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error while scanning!", (Throwable)e);
            throw new MojoFailureException(e.getMessage());
        }
        if (classes.isEmpty()) {
            throw new MojoFailureException("No annotated classes found in directory " + this.outputDirectory);
        }
        Properties properties = new Properties();
        try {
            File file = new File(this.hibernateProperties);
            if (file.exists()) {
                this.getLog().info((CharSequence)("Reading properties from file " + this.hibernateProperties + "..."));
                properties.load(new FileInputStream(file));
            } else {
                this.getLog().info((CharSequence)("No hibernate-properties-file found! Checked path: " + this.hibernateProperties));
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Error while reading properties!", (Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
        if (this.driverClassName != null) {
            if (properties.containsKey(DRIVER_CLASS)) {
                this.getLog().debug((CharSequence)("Overwriting property hibernate.connection.driver_class=" + properties.getProperty(DRIVER_CLASS) + " with the value " + this.driverClassName + " from the plugin-configuration-parameter driverClassName!"));
            } else {
                this.getLog().debug((CharSequence)("Using the value " + this.driverClassName + " from the plugin-configuration-parameter driverClassName!"));
            }
            properties.setProperty(DRIVER_CLASS, this.driverClassName);
        }
        if (this.url != null) {
            if (properties.containsKey(URL)) {
                this.getLog().debug((CharSequence)("Overwriting property hibernate.connection.url=" + properties.getProperty(URL) + " with the value " + this.url + " from the plugin-configuration-parameter url!"));
            } else {
                this.getLog().debug((CharSequence)("Using the value " + this.url + " from the plugin-configuration-parameter url!"));
            }
            properties.setProperty(URL, this.url);
        }
        if (this.username != null) {
            if (properties.containsKey(USERNAME)) {
                this.getLog().debug((CharSequence)("Overwriting property hibernate.connection.username=" + properties.getProperty(USERNAME) + " with the value " + this.username + " from the plugin-configuration-parameter username!"));
            } else {
                this.getLog().debug((CharSequence)("Using the value " + this.username + " from the plugin-configuration-parameter username!"));
            }
            properties.setProperty(USERNAME, this.username);
        }
        if (this.password != null) {
            if (properties.containsKey(PASSWORD)) {
                this.getLog().debug((CharSequence)("Overwriting property hibernate.connection.password=" + properties.getProperty(PASSWORD) + " with the value " + this.password + " from the plugin-configuration-parameter password!"));
            } else {
                this.getLog().debug((CharSequence)("Using the value " + this.password + " from the plugin-configuration-parameter password!"));
            }
            properties.setProperty(PASSWORD, this.password);
        }
        if (this.hibernateDialect != null) {
            if (properties.containsKey(DIALECT)) {
                this.getLog().debug((CharSequence)("Overwriting property hibernate.dialect=" + properties.getProperty(DIALECT) + " with the value " + this.hibernateDialect + " from the plugin-configuration-parameter hibernateDialect!"));
            } else {
                this.getLog().debug((CharSequence)("Using the value " + this.hibernateDialect + " from the plugin-configuration-parameter hibernateDialect!"));
            }
            properties.setProperty(DIALECT, this.hibernateDialect);
        }
        this.getLog().info((CharSequence)"Gathered hibernate-configuration (turn on debugging for details):");
        if (properties.isEmpty()) {
            this.getLog().error((CharSequence)"No properties set!");
            throw new MojoFailureException("Hibernate-Configuration is missing!");
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.getLog().info((CharSequence)("  " + entry.getKey() + " = " + entry.getValue()));
        }
        URLClassLoader classLoader = null;
        try {
            this.getLog().debug((CharSequence)"Creating ClassLoader for project-dependencies...");
            List classpathFiles = this.project.getCompileClasspathElements();
            URL[] urls = new URL[classpathFiles.size()];
            for (int i = 0; i < classpathFiles.size(); ++i) {
                this.getLog().debug((CharSequence)("Dependency: " + (String)classpathFiles.get(i)));
                urls[i] = new File((String)classpathFiles.get(i)).toURI().toURL();
            }
            classLoader = new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Error while creating ClassLoader!", (Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
        Configuration config = new Configuration();
        config.setProperties(properties);
        try {
            this.getLog().debug((CharSequence)"Adding annotated classes to hibernate-mapping-configuration...");
            for (String annotatedClass : classes) {
                this.getLog().debug((CharSequence)("Class " + annotatedClass));
                config.addAnnotatedClass(classLoader.loadClass(annotatedClass));
            }
        }
        catch (ClassNotFoundException e) {
            this.getLog().error((CharSequence)"Error while adding annotated classes!", (Throwable)e);
            throw new MojoExecutionException(e.getMessage());
        }
        Target target = null;
        try {
            target = Target.valueOf((String)this.target);
        }
        catch (IllegalArgumentException e) {
            this.getLog().error((CharSequence)("Invalid value for configuration-option \"target\": " + this.target));
            this.getLog().error((CharSequence)"Valid values are: NONE, SCRIPT, EXPORT, BOTH");
            throw new MojoExecutionException("Invalid value for configuration-option \"target\"");
        }
        SchemaExport.Type type = null;
        try {
            type = SchemaExport.Type.valueOf((String)this.type);
        }
        catch (IllegalArgumentException e) {
            this.getLog().error((CharSequence)("Invalid value for configuration-option \"type\": " + this.type));
            this.getLog().error((CharSequence)"Valid values are: NONE, CREATE, DROP, BOTH");
            throw new MojoExecutionException("Invalid value for configuration-option \"type\"");
        }
        Connection connection = null;
        try {
            switch (target) {
                case EXPORT: 
                case BOTH: {
                    switch (type) {
                        case CREATE: 
                        case DROP: 
                        case BOTH: {
                            Class<?> driverClass = classLoader.loadClass(this.driverClassName);
                            this.getLog().debug((CharSequence)("Registering JDBC-driver " + driverClass.getName()));
                            DriverManager.registerDriver(new DriverProxy((Driver)driverClass.newInstance()));
                            this.getLog().debug((CharSequence)("Opening JDBC-connection to " + this.url + " as " + this.username + " with password " + this.password));
                            connection = DriverManager.getConnection(this.url, this.username, this.password);
                        }
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            this.getLog().error((CharSequence)("Dependency for driver-class " + this.driverClassName + " is missing!"));
            throw new MojoExecutionException(e.getMessage());
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)"Cannot establish connection to database!");
            Enumeration<Driver> drivers = DriverManager.getDrivers();
            if (!drivers.hasMoreElements()) {
                this.getLog().error((CharSequence)"No drivers registered!");
            }
            while (drivers.hasMoreElements()) {
                this.getLog().debug((CharSequence)("Driver: " + drivers.nextElement()));
            }
            throw new MojoExecutionException(e.getMessage());
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        MavenLogAppender.startPluginLog((AbstractMojo)this);
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            SchemaExport export = new SchemaExport(config, connection);
            export.setOutputFile(this.outputFile);
            export.setDelimiter(this.delimiter);
            export.setFormat(this.format);
            export.execute(target, type);
            for (Object exception : export.getExceptions()) {
                this.getLog().debug((CharSequence)exception.toString());
            }
        }
        finally {
            MavenLogAppender.endPluginLog((AbstractMojo)this);
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            try {
                connection.close();
            }
            catch (SQLException e) {
                this.getLog().error((CharSequence)("Error while closing connection: " + e.getMessage()));
            }
        }
    }

    static final class DriverProxy
    implements Driver {
        private final Driver target;

        DriverProxy(Driver target) {
            if (target == null) {
                throw new NullPointerException();
            }
            this.target = target;
        }

        public Driver getTarget() {
            return this.target;
        }

        @Override
        public boolean acceptsURL(String url) throws SQLException {
            return this.target.acceptsURL(url);
        }

        @Override
        public Connection connect(String url, Properties info) throws SQLException {
            return this.target.connect(url, info);
        }

        @Override
        public int getMajorVersion() {
            return this.target.getMajorVersion();
        }

        @Override
        public int getMinorVersion() {
            return this.target.getMinorVersion();
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
            return this.target.getPropertyInfo(url, info);
        }

        @Override
        public boolean jdbcCompliant() {
            return this.target.jdbcCompliant();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new SQLFeatureNotSupportedException("Not supported, for backward-compatibility with Java 1.6");
        }

        public String toString() {
            return "Proxy: " + this.target;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DriverProxy)) {
                return false;
            }
            DriverProxy other = (DriverProxy)obj;
            return this.target.equals(other.target);
        }
    }
}

