/*
 * Decompiled with CFR 0.152.
 */
package de.juplo.plugins.hibernate;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import org.apache.maven.plugin.logging.Log;

public class MutableClassLoader
extends ClassLoader {
    private URLClassLoader loader;
    private Log log;

    public MutableClassLoader(LinkedHashSet<URL> urls, Log log) {
        if (log.isDebugEnabled()) {
            for (URL url : urls) {
                log.debug((CharSequence)url.toString());
            }
        }
        this.loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), this.getClass().getClassLoader());
        this.log = log;
    }

    public MutableClassLoader add(LinkedHashSet<URL> urls) {
        LinkedHashSet<URL> old = new LinkedHashSet<URL>(Arrays.asList(this.loader.getURLs()));
        old.addAll(urls);
        if (this.log.isDebugEnabled()) {
            for (URL url : urls) {
                this.log.debug((CharSequence)url.toString());
            }
        }
        this.loader = new URLClassLoader(old.toArray(new URL[urls.size()]), this.getClass().getClassLoader());
        return this;
    }

    @Override
    public void clearAssertionStatus() {
        this.loader.clearAssertionStatus();
    }

    @Override
    public void setClassAssertionStatus(String className, boolean enabled) {
        this.loader.setClassAssertionStatus(className, enabled);
    }

    @Override
    public void setPackageAssertionStatus(String packageName, boolean enabled) {
        this.loader.setPackageAssertionStatus(packageName, enabled);
    }

    @Override
    public void setDefaultAssertionStatus(boolean enabled) {
        this.loader.setDefaultAssertionStatus(enabled);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.loader.getResourceAsStream(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.loader.getResources(name);
    }

    @Override
    public URL getResource(String name) {
        return this.loader.getResource(name);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loader.loadClass(name);
    }
}

