/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.writable;

import de.jungblut.math.DoubleVector;
import de.jungblut.math.dense.DenseDoubleVector;
import de.jungblut.math.dense.SingleEntryDoubleVector;
import de.jungblut.math.named.NamedDoubleVector;
import de.jungblut.math.sparse.SparseDoubleVector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.io.WritableComparable;

public final class VectorWritable
implements WritableComparable<VectorWritable> {
    private static final byte DENSE = 0;
    private static final byte SPARSE = 1;
    private static final byte SINGLE = 2;
    private DoubleVector vector;

    public VectorWritable() {
    }

    public VectorWritable(VectorWritable v) {
        this.vector = v.getVector();
    }

    public VectorWritable(DoubleVector v) {
        this.vector = v;
    }

    public final void write(DataOutput out) throws IOException {
        VectorWritable.writeVector(this.vector, out);
    }

    public final void readFields(DataInput in) throws IOException {
        this.vector = VectorWritable.readVector(in);
    }

    public final int compareTo(VectorWritable o) {
        return VectorWritable.compareVector(this, o);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.vector == null ? 0 : this.vector.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VectorWritable other = (VectorWritable)obj;
        return !(this.vector == null ? other.vector != null : !this.vector.equals(other.vector));
    }

    public DoubleVector getVector() {
        return this.vector;
    }

    public String toString() {
        return this.vector.toString();
    }

    public static void writeVector(DoubleVector vector, DataOutput out) throws IOException {
        if (vector.isSparse()) {
            out.writeByte(1);
            out.writeInt(vector.getLength());
            out.writeInt(vector.getDimension());
            Iterator iterateNonZero = vector.iterateNonZero();
            while (iterateNonZero.hasNext()) {
                DoubleVector.DoubleVectorElement next = (DoubleVector.DoubleVectorElement)iterateNonZero.next();
                out.writeInt(next.getIndex());
                out.writeDouble(next.getValue());
            }
        } else if (vector.isSingle()) {
            out.writeByte(2);
            out.writeDouble(vector.get(0));
        } else if (!vector.isSparse()) {
            out.writeByte(0);
            out.writeInt(vector.getLength());
            for (int i = 0; i < vector.getDimension(); ++i) {
                out.writeDouble(vector.get(i));
            }
        } else {
            throw new IllegalArgumentException("Can't serialize vector of type: " + vector.getClass());
        }
        if (vector.isNamed() && vector.getName() != null) {
            out.writeBoolean(true);
            out.writeUTF(vector.getName());
        } else {
            out.writeBoolean(false);
        }
    }

    public static DoubleVector readVector(DataInput in) throws IOException {
        byte typeByte = in.readByte();
        SingleEntryDoubleVector vector = null;
        switch (typeByte) {
            case 1: {
                int length = in.readInt();
                int dim = in.readInt();
                vector = new SparseDoubleVector(dim);
                for (int i = 0; i < length; ++i) {
                    int index = in.readInt();
                    double value = in.readDouble();
                    vector.set(index, value);
                }
                break;
            }
            case 0: {
                int length = in.readInt();
                vector = new DenseDoubleVector(length);
                for (int i = 0; i < length; ++i) {
                    vector.set(i, in.readDouble());
                }
                break;
            }
            case 2: {
                vector = new SingleEntryDoubleVector(in.readDouble());
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't deserialize vector of type byte: " + typeByte);
            }
        }
        if (in.readBoolean()) {
            vector = new NamedDoubleVector(in.readUTF(), (DoubleVector)vector);
        }
        return vector;
    }

    public static int compareVector(VectorWritable a, VectorWritable o) {
        return VectorWritable.compareVector(a.getVector(), o.getVector());
    }

    public static int compareVector(DoubleVector a, DoubleVector o) {
        DoubleVector subtract = a.subtract(o);
        return (int)subtract.sum();
    }

    public static VectorWritable wrap(DoubleVector a) {
        return new VectorWritable(a);
    }
}

