/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.writable;

import com.google.common.base.Preconditions;
import de.jungblut.math.DoubleMatrix;
import de.jungblut.math.DoubleVector;
import de.jungblut.math.dense.DenseDoubleMatrix;
import de.jungblut.math.sparse.SparseDoubleRowMatrix;
import de.jungblut.math.sparse.SparseDoubleVector;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import org.apache.hadoop.io.Writable;

public final class MatrixWritable
implements Writable {
    public static final byte DENSE_DOUBLE_MATRIX = 1;
    public static final byte SPARSE_DOUBLE_ROW_MATRIX = 2;
    private DoubleMatrix mat;

    public MatrixWritable() {
    }

    public MatrixWritable(DoubleMatrix mat) {
        Preconditions.checkNotNull((Object)mat);
        this.mat = mat;
    }

    public void readFields(DataInput in) throws IOException {
        byte flag = in.readByte();
        switch (flag) {
            case 1: {
                this.mat = MatrixWritable.readDenseMatrix(in);
                break;
            }
            case 2: {
                this.mat = MatrixWritable.readSparseMatrix(in);
            }
        }
    }

    public void write(DataOutput out) throws IOException {
        if (this.mat.isSparse()) {
            out.writeByte(2);
            MatrixWritable.writeSparseMatrix((SparseDoubleRowMatrix)this.mat, out);
        } else {
            out.writeByte(1);
            MatrixWritable.writeDenseMatrix((DenseDoubleMatrix)this.mat, out);
        }
    }

    public DoubleMatrix getMatrix() {
        return this.mat;
    }

    public static void writeSparseMatrix(SparseDoubleRowMatrix mat, DataOutput out) throws IOException {
        out.writeInt(mat.getRowCount());
        out.writeInt(mat.getColumnCount());
        int[] rowIndices = mat.rowIndices();
        out.writeInt(rowIndices.length);
        for (int row : rowIndices) {
            out.writeInt(row);
            DoubleVector rowVector = mat.getRowVector(row);
            out.writeInt(rowVector.getLength());
            Iterator iterateNonZero = rowVector.iterateNonZero();
            while (iterateNonZero.hasNext()) {
                DoubleVector.DoubleVectorElement next = (DoubleVector.DoubleVectorElement)iterateNonZero.next();
                out.writeInt(next.getIndex());
                out.writeDouble(next.getValue());
            }
        }
    }

    public static SparseDoubleRowMatrix readSparseMatrix(DataInput in) throws IOException {
        SparseDoubleRowMatrix mat = new SparseDoubleRowMatrix(in.readInt(), in.readInt());
        int numRowIndices = in.readInt();
        for (int i = 0; i < numRowIndices; ++i) {
            int rowIndex = in.readInt();
            int numColumns = in.readInt();
            SparseDoubleVector row = new SparseDoubleVector(mat.getColumnCount());
            for (int j = 0; j < numColumns; ++j) {
                row.set(in.readInt(), in.readDouble());
            }
            mat.setRowVector(rowIndex, (DoubleVector)row);
        }
        return mat;
    }

    public static void writeDenseMatrix(DenseDoubleMatrix mat, DataOutput out) throws IOException {
        out.writeInt(mat.getRowCount());
        out.writeInt(mat.getColumnCount());
        for (int row = 0; row < mat.getRowCount(); ++row) {
            for (int col = 0; col < mat.getColumnCount(); ++col) {
                out.writeDouble(mat.get(row, col));
            }
        }
    }

    public static DenseDoubleMatrix readDenseMatrix(DataInput in) throws IOException {
        DenseDoubleMatrix mat = new DenseDoubleMatrix(in.readInt(), in.readInt());
        for (int row = 0; row < mat.getRowCount(); ++row) {
            for (int col = 0; col < mat.getColumnCount(); ++col) {
                mat.set(row, col, in.readDouble());
            }
        }
        return mat;
    }
}

