/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.utils;

import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import de.jungblut.math.DoubleVector;
import java.util.Iterator;

public final class VectorFunnel
implements Funnel<DoubleVector> {
    private static final long serialVersionUID = -7994812949854877907L;

    public void funnel(DoubleVector from, PrimitiveSink into) {
        if (from.isSparse()) {
            Iterator iterator = from.iterateNonZero();
            while (iterator.hasNext()) {
                DoubleVector.DoubleVectorElement next = (DoubleVector.DoubleVectorElement)iterator.next();
                into.putInt(next.getIndex());
                into.putDouble(next.getValue());
            }
        } else {
            int dimension = from.getDimension();
            for (int i = dimension - 1; i >= 0; --i) {
                into.putInt(i);
                into.putDouble(from.get(i));
            }
        }
    }
}

