/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.utils;

import com.google.common.base.Preconditions;
import gnu.trove.list.array.TDoubleArrayList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.io.Writable;

public final class Statistics
implements Writable {
    private boolean finalized = false;
    private TDoubleArrayList data = new TDoubleArrayList();
    private double min = Double.MAX_VALUE;
    private double max = -1.7976931348623157E308;
    private double median;
    private double mean;
    private double standardDeviation;
    private double sum;
    private int count;
    private double signalToNoise;
    private double coefficientOfVariation;
    private double dispersionIndex;
    private double variance;

    public void add(double item) {
        Preconditions.checkState((!this.finalized ? 1 : 0) != 0);
        this.sum += item;
        ++this.count;
        this.min = Math.min(this.min, item);
        this.max = Math.max(this.max, item);
        this.data.add(item);
    }

    public void finalizeComputation() {
        if (this.count > 0) {
            this.mean = this.sum / (double)this.count;
            for (int i = 0; i < this.data.size(); ++i) {
                double f = this.data.get(i);
                double diff = f - this.mean;
                this.standardDeviation += diff * diff;
            }
            this.variance = this.standardDeviation / (double)this.count;
            this.standardDeviation = Math.sqrt(this.variance);
            this.signalToNoise = this.mean / this.standardDeviation;
            this.coefficientOfVariation = this.standardDeviation / this.mean;
            this.dispersionIndex = this.variance / this.mean;
            double[] array = this.data.toArray();
            Arrays.sort(array);
            if (this.count % 2 != 0) {
                this.median = array[this.count / 2];
            } else {
                int mid = this.count / 2;
                this.median = (array[mid - 1] + array[mid]) / 2.0;
            }
        }
        this.data = null;
        this.finalized = true;
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.finalized);
        out.writeInt(this.count);
        out.writeDouble(this.sum);
        out.writeDouble(this.min);
        out.writeDouble(this.max);
        out.writeDouble(this.median);
        out.writeDouble(this.mean);
        out.writeDouble(this.standardDeviation);
        out.writeDouble(this.variance);
        out.writeDouble(this.signalToNoise);
        out.writeDouble(this.coefficientOfVariation);
        out.writeDouble(this.dispersionIndex);
    }

    public void readFields(DataInput in) throws IOException {
        this.finalized = in.readBoolean();
        this.count = in.readInt();
        this.sum = in.readDouble();
        this.min = in.readDouble();
        this.max = in.readDouble();
        this.median = in.readDouble();
        this.mean = in.readDouble();
        this.standardDeviation = in.readDouble();
        this.variance = in.readDouble();
        this.signalToNoise = in.readDouble();
        this.coefficientOfVariation = in.readDouble();
        this.dispersionIndex = in.readDouble();
    }

    public double getMin() {
        Preconditions.checkState((boolean)this.finalized);
        return this.min;
    }

    public double getMax() {
        Preconditions.checkState((boolean)this.finalized);
        return this.max;
    }

    public double getMedian() {
        Preconditions.checkState((boolean)this.finalized);
        return this.median;
    }

    public double getMean() {
        Preconditions.checkState((boolean)this.finalized);
        return this.mean;
    }

    public double getStandardDeviation() {
        Preconditions.checkState((boolean)this.finalized);
        return this.standardDeviation;
    }

    public double getVariance() {
        Preconditions.checkState((boolean)this.finalized);
        return this.variance;
    }

    public double getSignalToNoise() {
        Preconditions.checkState((boolean)this.finalized);
        return this.signalToNoise;
    }

    public double getDispersionIndex() {
        Preconditions.checkState((boolean)this.finalized);
        return this.dispersionIndex;
    }

    public double getCoefficientOfVariation() {
        Preconditions.checkState((boolean)this.finalized);
        return this.coefficientOfVariation;
    }

    public double getSum() {
        Preconditions.checkState((boolean)this.finalized);
        return this.sum;
    }

    public int getCount() {
        Preconditions.checkState((boolean)this.finalized);
        return this.count;
    }

    public String toString() {
        return "Statistics [Min=" + this.getMin() + ", Max=" + this.getMax() + ", Median=" + this.getMedian() + ", Mean=" + this.getMean() + ", StandardDeviation=" + this.getStandardDeviation() + ", Variance=" + this.getVariance() + ", SignalToNoise=" + this.getSignalToNoise() + ", DispersionIndex=" + this.getDispersionIndex() + ", CoefficientOfVariation=" + this.getCoefficientOfVariation() + ", Sum=" + this.getSum() + ", Count=" + this.getCount() + "]";
    }
}

