/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.sketching;

import com.google.common.base.Preconditions;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;

public class CountMinSketch<T> {
    private final int[][] countTable;
    private final HashFunction[] hashers;
    private Funnel<T> funnel;

    public CountMinSketch(int tableWidth, int tableHeight, Funnel<T> funnel) {
        this.funnel = (Funnel)Preconditions.checkNotNull(funnel, (Object)"funnel");
        Preconditions.checkArgument((tableWidth > 0 ? 1 : 0) != 0, (Object)"tableWidth must at least be 1!");
        Preconditions.checkArgument((tableHeight > 0 ? 1 : 0) != 0, (Object)"tableHeight must be greater than 0!");
        this.countTable = new int[tableHeight][tableWidth];
        this.hashers = new HashFunction[tableHeight];
        for (int i = 0; i < tableHeight; ++i) {
            this.hashers[i] = Hashing.murmur3_128((int)((int)((long)i * System.currentTimeMillis())));
        }
    }

    public void add(T obj) {
        Preconditions.checkNotNull(obj);
        for (int i = 0; i < this.countTable.length; ++i) {
            int hash = this.hashers[i].newHasher().putObject(obj, this.funnel).hash().asInt();
            int[] nArray = this.countTable[i];
            int n = Math.abs(hash) % this.countTable[i].length;
            nArray[n] = nArray[n] + 1;
        }
    }

    public int approximateCount(T obj) {
        Preconditions.checkNotNull(obj);
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < this.countTable.length; ++i) {
            int hash = this.hashers[i].newHasher().putObject(obj, this.funnel).hash().asInt();
            int valueAt = this.countTable[i][Math.abs(hash) % this.countTable[i].length];
            if (valueAt == 0) continue;
            min = Math.min(min, valueAt);
        }
        return min == Integer.MAX_VALUE ? 0 : min;
    }
}

