/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.reader;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import de.jungblut.math.DoubleVector;
import de.jungblut.math.dense.DenseDoubleVector;
import de.jungblut.math.dense.SingleEntryDoubleVector;
import de.jungblut.reader.Dataset;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public final class MushroomReader {
    private MushroomReader() {
        throw new IllegalAccessError();
    }

    public static Dataset readMushroomDataset(String path) {
        Iterator line;
        ArrayList<DenseDoubleVector> list = new ArrayList<DenseDoubleVector>();
        ArrayList<String[]> buffer = new ArrayList<String[]>();
        HashMultimap multiMap = HashMultimap.create();
        try (BufferedReader br = new BufferedReader(new FileReader(path));){
            int numLines = 0;
            line = null;
            while ((line = br.readLine()) != null) {
                if (numLines == 0) {
                    ++numLines;
                    continue;
                }
                String[] split = ((String)((Object)line)).split(",");
                Preconditions.checkArgument((split.length == 23 ? 1 : 0) != 0, (Object)("CSV length was not 23! Given " + split.length));
                for (int i = 0; i < split.length; ++i) {
                    multiMap.put((Object)i, (Object)split[i]);
                }
                buffer.add(split);
                ++numLines;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        HashMap indexMapping = new HashMap();
        Set keySet = multiMap.keySet();
        line = keySet.iterator();
        while (line.hasNext()) {
            int index = (Integer)line.next();
            HashMap<String, Integer> featureMap = new HashMap<String, Integer>();
            Set set = multiMap.get((Object)index);
            int nameIndex = 0;
            for (String name : set) {
                featureMap.put(name, nameIndex++);
            }
            indexMapping.put(index, featureMap);
        }
        for (String[] line2 : buffer) {
            DenseDoubleVector vec = new DenseDoubleVector(line2.length);
            for (int i = 0; i < line2.length; ++i) {
                HashMap hashMap = (HashMap)indexMapping.get(i);
                Integer value = (Integer)hashMap.get(line2[i]);
                vec.set(i, (double)value.intValue());
            }
            list.add(vec);
        }
        DoubleVector[] features = new DoubleVector[list.size()];
        DoubleVector[] outcome = new DoubleVector[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            DoubleVector doubleVector = (DoubleVector)list.get(i);
            features[i] = doubleVector.slice(doubleVector.getLength() - 1);
            outcome[i] = new SingleEntryDoubleVector(doubleVector.get(doubleVector.getLength() - 1));
        }
        return new Dataset(features, outcome);
    }
}

