/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.reader;

import java.awt.color.ColorSpace;

public final class LUVColorSpace
extends ColorSpace {
    private static final long serialVersionUID = 1L;
    private final int L = 0;
    private final int U = 1;
    private final int V = 2;
    private final int X = 0;
    private final int Y = 1;
    private final int Z = 2;
    private final int R = 0;
    private final int G = 1;
    private final int B = 2;
    private float EPSILON = 0.008856f;
    private float ref_X = 95.047f;
    private float ref_Y = 100.0f;
    private float ref_Z = 108.883f;
    private static ColorSpace RGB = ColorSpace.getInstance(1004);

    public LUVColorSpace() {
        super(2, 3);
    }

    @Override
    public float[] fromCIEXYZ(float[] colorvalue) {
        float[] result = new float[3];
        float var_U = 4.0f * colorvalue[0] / (colorvalue[0] + 15.0f * colorvalue[1] + 3.0f * colorvalue[2]);
        float var_V = 9.0f * colorvalue[1] / (colorvalue[0] + 15.0f * colorvalue[1] + 3.0f * colorvalue[2]);
        float var_Y = colorvalue[1] / 100.0f;
        var_Y = var_Y > this.EPSILON ? (float)Math.pow(var_Y, 0.3333333432674408) : 7.787f * var_Y + 0.13793103f;
        float ref_U = 4.0f * this.ref_X / (this.ref_X + 15.0f * this.ref_Y + 3.0f * this.ref_Z);
        float ref_V = 9.0f * this.ref_Y / (this.ref_X + 15.0f * this.ref_Y + 3.0f * this.ref_Z);
        result[0] = 116.0f * var_Y - 16.0f;
        result[1] = 13.0f * result[0] * (var_U - ref_U);
        result[2] = 13.0f * result[0] * (var_V - ref_V);
        return result;
    }

    @Override
    public float[] fromRGB(float[] rgbvalue) {
        return this.fromCIEXYZ(this.toCIEXYZ(rgbvalue));
    }

    @Override
    public float[] toCIEXYZ(float[] colorvalue) {
        float[] result = new float[3];
        float var_R = colorvalue[0] / 255.0f;
        float var_G = colorvalue[1] / 255.0f;
        float var_B = colorvalue[2] / 255.0f;
        var_R = var_R > 0.04045f ? (float)Math.pow((var_R + 0.055f) / 1.055f, 2.4) : (var_R /= 12.92f);
        var_G = var_G > 0.04045f ? (float)Math.pow((var_G + 0.055f) / 1.055f, 2.4) : (var_G /= 12.92f);
        var_B = var_B > 0.04045f ? (float)Math.pow((var_B + 0.055f) / 1.055f, 2.4) : (var_B /= 12.92f);
        result[0] = (var_R *= 100.0f) * 0.4124f + (var_G *= 100.0f) * 0.3576f + (var_B *= 100.0f) * 0.1805f;
        result[1] = var_R * 0.2126f + var_G * 0.7152f + var_B * 0.0722f;
        result[2] = var_R * 0.0193f + var_G * 0.1192f + var_B * 0.9505f;
        return result;
    }

    @Override
    public float[] toRGB(float[] colorvalue) {
        return RGB.fromCIEXYZ(this.toCIEXYZ(colorvalue));
    }
}

