/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.reader;

import com.google.common.base.Preconditions;
import de.jungblut.classification.eval.EvaluationSplit;
import de.jungblut.math.DoubleVector;
import de.jungblut.math.dense.DenseDoubleVector;
import de.jungblut.reader.Dataset;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public final class IrisReader {
    private IrisReader() {
        throw new IllegalAccessError();
    }

    public static Dataset readIrisDataset(String path) {
        DoubleVector[] features = new DoubleVector[150];
        DenseDoubleVector[] outcome = new DenseDoubleVector[150];
        try (BufferedReader br = new BufferedReader(new FileReader(path));){
            String line = null;
            int index = 0;
            while ((line = br.readLine()) != null) {
                String[] split = line.split(",");
                Preconditions.checkArgument((split.length == 5 ? 1 : 0) != 0, (Object)("CSV length was not 5! Given " + split.length));
                features[index] = new DenseDoubleVector(4);
                for (int i = 0; i < split.length - 1; ++i) {
                    features[index].set(i, Double.parseDouble(split[i]));
                }
                outcome[index] = split[split.length - 1].equals("Iris-setosa") ? new DenseDoubleVector(new double[]{1.0, 0.0, 0.0}) : (split[split.length - 1].equals("Iris-versicolor") ? new DenseDoubleVector(new double[]{0.0, 1.0, 0.0}) : new DenseDoubleVector(new double[]{0.0, 0.0, 1.0}));
                ++index;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Dataset(features, (DoubleVector[])outcome);
    }

    public static EvaluationSplit getEvaluationSplit(Dataset irisData) {
        DenseDoubleVector[] trainFeatures = new DenseDoubleVector[120];
        DenseDoubleVector[] trainOutcomes = new DenseDoubleVector[120];
        DenseDoubleVector[] testFeatures = new DenseDoubleVector[30];
        DenseDoubleVector[] testOutcomes = new DenseDoubleVector[30];
        DoubleVector[] features = irisData.getFeatures();
        DoubleVector[] outcomes = irisData.getOutcomes();
        int[] trainSplitPoints = new int[]{40, 90, 140};
        int[] trainDestStartPoints = new int[]{0, 40, 80};
        int[] testDestStartPoints = new int[]{0, 10, 20};
        for (int i = 0; i < 3; ++i) {
            int splitPoint = trainSplitPoints[i];
            System.arraycopy(features, splitPoint - 40, trainFeatures, trainDestStartPoints[i], 40);
            System.arraycopy(outcomes, splitPoint - 40, trainOutcomes, trainDestStartPoints[i], 40);
            System.arraycopy(features, splitPoint, testFeatures, testDestStartPoints[i], 10);
            System.arraycopy(outcomes, splitPoint, testOutcomes, testDestStartPoints[i], 10);
        }
        return new EvaluationSplit((DoubleVector[])trainFeatures, (DoubleVector[])trainOutcomes, (DoubleVector[])testFeatures, (DoubleVector[])testOutcomes);
    }
}

