/*
 * Decompiled with CFR 0.152.
 */
package de.jungblut.reader;

import de.jungblut.math.DoubleVector;
import de.jungblut.math.dense.DenseDoubleVector;
import de.jungblut.reader.LUVColorSpace;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public final class ImageReader {
    private ImageReader() {
        throw new IllegalAccessError();
    }

    public static List<BufferedImage> getSlidingWindowPatches(BufferedImage source, int windowWidth, int windowHeight, int verticalStride, int horizontalStride) {
        ArrayList<BufferedImage> list = new ArrayList<BufferedImage>();
        for (int height = 0; height < source.getHeight() - windowHeight; height += verticalStride) {
            for (int width = 0; width < source.getWidth() - windowWidth; width += horizontalStride) {
                BufferedImage subimage = source.getSubimage(width, height, windowWidth, windowHeight);
                list.add(subimage);
            }
        }
        return list;
    }

    public static DoubleVector readImageAsGreyScale(BufferedImage img) {
        int h = img.getHeight();
        int w = img.getWidth();
        DenseDoubleVector vector = new DenseDoubleVector(h * w);
        int[] rgb = img.getRGB(0, 0, w, h, null, 0, w);
        for (int i = 0; i < rgb.length; ++i) {
            int red = rgb[i] >> 16 & 0xFF;
            int green = rgb[i] >> 8 & 0xFF;
            int blue = rgb[i] >> 0 & 0xFF;
            vector.set(i, (double)(red + green + blue) / 3.0);
        }
        return vector;
    }

    public static DoubleVector[] readImageAsRGB(BufferedImage img) {
        int h = img.getHeight();
        int w = img.getWidth();
        DoubleVector[] vectors = new DoubleVector[h * w];
        int currentIndex = 0;
        int[] rgb = img.getRGB(0, 0, w, h, null, 0, w);
        for (int i = 0; i < rgb.length; ++i) {
            double[] rgbValue = new double[]{rgb[i] >> 16 & 0xFF, rgb[i] >> 8 & 0xFF, rgb[i] >> 0 & 0xFF};
            vectors[currentIndex++] = new DenseDoubleVector(rgbValue);
        }
        return vectors;
    }

    public static DoubleVector[] readImageAsLUV(BufferedImage img) {
        LUVColorSpace space = new LUVColorSpace();
        int h = img.getHeight();
        int w = img.getWidth();
        DoubleVector[] vectors = new DoubleVector[h * w];
        int currentIndex = 0;
        int[] rgb = img.getRGB(0, 0, w, h, null, 0, w);
        float[] rgbValue = new float[3];
        for (int i = 0; i < rgb.length; ++i) {
            rgbValue[0] = rgb[i] >> 16 & 0xFF;
            rgbValue[1] = rgb[i] >> 8 & 0xFF;
            rgbValue[2] = rgb[i] >> 0 & 0xFF;
            float[] luv = ((ColorSpace)space).fromRGB(rgbValue);
            double[] arr = new double[luv.length];
            for (int x = 0; x < luv.length; ++x) {
                arr[x] = luv[x];
            }
            vectors[currentIndex++] = new DenseDoubleVector(arr);
        }
        return vectors;
    }
}

